 #define module_name	TAR2VMS   #define module_version  "V2.0-1" /*D  *	TAR2VMS.C - Handles the extract and list functionality of VMSTAR.  */   
 #ifdef __DECC ) #pragma module module_name module_version  #else " #module module_name module_version #endif   #ifdef USE_OWN_MKDIR #define mkdir oldmkdir #endif   #include <stdio.h> #include <stdlib.h>  #include <string.h>  #include <errno.h> #include <ctype.h> #include <time.h>    #include <unixio.h>  #include <unixlib.h> #include <descrip.h> #include <ssdef.h> #include <strdef.h>  #include <str$routines.h>    #include "vmstar_cmdline.h"  #include "vmsmunch.h"  #include "vmstarP.h"   #ifdef USE_OWN_MKDIR #undef mkdir int mkdir(); #endif   /* Globals in this module */   static int mode, uid, gid; static int bytecount; 1 static FILE *tarfp;		/* The input file pointer */    /* File characteristics */   static int linktype;   /* Misc. */    #define ABSASCTIM_MAX	23" char vmscreation[ABSASCTIM_MAX+1];   /* Forward declarations */   int hdr_read();  int decode_header(); int scan_title();  int cleanup_dire();  int make_new();  int copyfile();  int tarskip(); int vms_cleanup();  1 /* tar2vms -- handles extract and list options */    tar2vms(argc,argv)	 int argc;  char **argv; { , int status,file_type,j, flag, argi, process;$ char *make_directory(), *argp, *ptr;) struct dsc$descriptor pattern, candidate;  FILE *opentar();   /* open the file for reading */   #     if((tarfp = opentar()) == NULL) 	         { 0         printf("tar: error opening tarfile.\n");         exit(SS$_NORMAL); 	         }   I /* Now keep reading headers from this file, and decode the names, etc. */   H     while((status=hdr_read(&header))==RECSIZE)    /* 0 on end of file */     {          process = 0;:         if(strlen(header.title)!=0)     /* Valid header */	         {              decode_header();             process = 1;  F /* Now if file names were specified on the command line, check if they    match the current one */                if (argc > 0) 
             {                  process = 0;                 argi = 0; #                 while (argi < argc)                  { >                     pattern.dsc$w_length = strlen(argv[argi]);7                     pattern.dsc$a_pointer = argv[argi]; 8                     pattern.dsc$b_dtype = DSC$K_DTYPE_T;8                     pattern.dsc$b_class = DSC$K_CLASS_S;>                     candidate.dsc$w_length = strlen(pathname);7                     candidate.dsc$a_pointer = pathname; :                     candidate.dsc$b_dtype = DSC$K_DTYPE_T;:                     candidate.dsc$b_class = DSC$K_CLASS_S;                       ++argi;   K                     if (str$match_wild(&candidate, &pattern) == STR$_MATCH)                      { $                         process = 1;                         break;                     }                  } 
             } 	         }          else	         {               status = 1;              break;          }             if (process && the_wait)	         {              *temp = '\0'; P             while (*temp != 'y' && *temp != 'n' && *temp != 'q' && *temp != 'a')
             { 6                 printf("%s   (y/n/q/a) ? ", pathname);?                 if (scanf("%s", temp) == EOF) exit(SS$_NORMAL); '                 *temp = tolower(*temp); 
             } ( 	    if (*temp == 'q') exit(SS$_NORMAL);5             process = (*temp == 'y' || *temp == 'a');  	    if (*temp == 'a') 		the_wait = 0; 	         }          if (process && extract)          {               E                 file_type=scan_title(pathname,new_directory,newfile); ,                 cleanup_dire(new_directory);/                 if( make_new(new_directory)!=0) E                     printf("tar: error creating %s\n",new_directory); '                 if(file_type == ISDIRE)                      {}'                 if(file_type == ISFILE)   - /*  Now move the data into the output file */   $                     if(bytecount>=0)                     { 6                         strcpy(outfile,new_directory);0                         strcat(outfile,newfile);4                         copyfile(outfile,bytecount);                     } 	         }          else	         { A             if (process && list)               /* listing only */ 
             { )                 printf("%6o %8d %s %s\n", 8                     mode,bytecount,creation+4,pathname);3                 if (linktype == 1 || linktype == 2) O                  printf("                                --->  %s\n",linkname); 
             }              if(linktype == 0) #                 tarskip(bytecount); 	         }      }       /* end while  */:     if(status == 1)                     /* Empty header */     {   C /*        printf("Do you wish to move past the EOF mark (y/n) ? ");  **        fflush(stdout);  **        gets(temp); # **        if(tolower(*temp) == 'y') 3 **            while((status=hdr_read(&header)) >0);  **        else */ 	    fclose(tarfp);              exit(SS$_NORMAL);      } >     if(status==0)                       /* End of tar file  */     { -         printf("tar: EOF hit on tarfile.\n");  	fclose(tarfp);          exit(SS$_NORMAL);      } 7     if(status<0)                        /* An error  */      { 0         printf("tar: error reading tarfile.\n"); 	fclose(tarfp);          exit(SS$_NORMAL);      }  }     G /* This function simply copies the file to the output, no conversion */    int copyfile(outfile,nbytes), char outfile[]; /* name of output version */ int nbytes;  { 8 int inbytes, fil, s, i, ctlchars, eightbitchars, nchars; register unsigned char c;  struct VMStimbuf vtb; 3 int binfile;		       /* "extract as binary" flag */   - /* Read the first block of the tarred file */        binfile = binmode;     inbytes = 0;'     if (linktype == 0 && nbytes != 0) { 7         if((inbytes=fread(buffer,1,RECSIZE,tarfp)) < 0) 	         { - 	   printf("tar: error reading tar file.\n");  	   fclose(tarfp); 	   exit(SS$_NORMAL); 	         }   J /* If automatic mode is set, then try to figure out what kind of file this    is */  '         if (automode && inbytes != 0) {              ctlchars = 0;  	    eightbitchars = 0;   A /* Scan the buffer, counting chars with msb set and control chars     not CR, LF or FF */  2 	    nchars = nbytes < inbytes ? nbytes : inbytes;# 	    for (i = 0; i < nchars; ++i) {  		c = buffer[i]; 	        if (c < ' ' && -                     c != 0x0a && c != 0x0c && +                     c != 0x0d && c != 0x09)  		     ctlchars++; 	        if (c > 127)  		    eightbitchars++; 	    }  C /* Now apply some heuristics to determine file is text or binary */   ( 	    ctlchars = ctlchars * 100 / nchars;2 	    eightbitchars = eightbitchars * 100 / nchars;/ 	    if (ctlchars > 10 || eightbitchars > 30 || 5                 (ctlchars > 5 && eightbitchars > 20))                  binfile = 1;	         }      }    /*  Open the output file */        if (binfile)     {  #if 0 ;         fil = creat(outfile,0,"rfm=fix","mrs=512","alq=5");  #else          char alq[10]; ( 	sprintf(alq,"alq=%d",(nbytes+511)/512);7         fil = creat(outfile,0,"rfm=fix","mrs=512",alq);  #endif     }      else     {  #if 0 =         fil = creat(outfile,0,"rfm=stmlf","rat=cr","mbc=16");  #else          char alq[10]; ( 	sprintf(alq,"alq=%d",(nbytes+511)/512);A         fil = creat(outfile,0,"rfm=stmlf","rat=cr","mbc=16",alq);  #endif     }        if(fil == ERROR1)      { 4         printf("tar: error creating %s \n",outfile); 	tarskip(nbytes - inbytes);  	s = -1;     }      else 	s = 0;      if(linktype !=0)     { C         sprintf(buffer,"*** This file is a link to %s\n",linkname); -         s = write(fil,buffer,strlen(buffer));  	close(fil);     }      else     { 2         while(nbytes > 0 && s >= 0 && inbytes > 0)	         { ? 	    /* Some tar files have lots of junk at the end of the last ? 	     * record (unless the file to extractt has a size which is > 	     * a multiple of 512 bytes, of course).  This is not very; 	     * clean, so we simply fill the end of the last record  	     * with NULs */# 	    if (binfile && nbytes<RECSIZE)V1 	      memset(buffer+nbytes,'\0',RECSIZE-nbytes);l  S             s = write(fil,buffer,(binfile || (nbytes>RECSIZE)) ? RECSIZE : nbytes);_             nbytes -= inbytes;             if (nbytes > 0) * 		inbytes = fread(buffer,1,RECSIZE,tarfp);	         }   - /* Close the extracted file, check results */u  
 	close (fil);i*         if (inbytes == 0 && nbytes != 0) {=                 printf("tar: unexpected EOF on tar file.\n");c 	        fclose(tarfp);e!                 exit(SS$_NORMAL);i 	} 	if (inbytes < 0) { + 		printf("tar: error reading tar file.\n");m 	        fclose(tarfp);r!                 exit(SS$_NORMAL);f	         }      };     if (s < 0)     {i7         printf("tar: error writing file %s\n",outfile);t 	fclose(tarfp);t         exit(SS$_NORMAL);u     }p       if(verbose)l     {c         printf("%s %8d%c%s\n",$                creation+4,bytecount,% 	       binfile ? '*' : ' ',outfile);M         if(linktype!=0)aA             printf("                         --> %s\n",linkname);e     }n     vtb.actime = 0;n     vtb.modtime = 0;&     if (date_policy & dp_modification) 	vtb.actime = vmscreation;"     if (date_policy & dp_creation) 	vtb.modtime = vmscreation; '     VMSmunch(outfile, SET_TIMES, &vtb);j     return(0); }s  G /* scan_title -- decode a Un*x file name into the directory and name */n  J /* Return a value to indicate if this is a directory name, or another file= * We return the extracted directory string in "dire", and therA * filename (if it exists) in "fname". The full title is in "line"* * at input.d */   int scan_title(line,dire,fname)t char line[],dire[],fname[];l {s char *end1;d int len,len2,i,ind; ? /* The format will be UNIX at input, so we have to scan for thef * UNIX directory separator '/'A * If the name ends with '/' then it is actually a directory name. F * If the directory consists only of '.', then don't add a subdirectoryI * The output directory will be a complete file spec, based on the default0 * directory. */      H     strcpy(dire,curdir);                /* Start with the current dir */  I     /* We need to make sure the directory delimiters are square brackets,hA        otherwise we'll get some problems... -- Richard Levitte */ *     while ((end1 = strchr(dire,'<')) != 0)
 	*end1 = '[';$*     while ((end1 = strchr(dire,'>')) != 0)
 	*end1 = ']';_          if(strncmp(line,"./",2)==0).9         strcpy(line,line+2);            /* ignore "./" */dC     strcpy(temp,line);                  /* Start in local buffer */tK     ind=vms_cleanup(temp);              /* Remove illegal vms characters */_D     if((end1=strrchr(temp,'/'))==0)     /* No directory at all  ? */>         strcpy(fname,temp);             /* Only a file name */     elseJ     {                                   /* End of directory name is '/' */F         *end1 = 0;                      /* Terminate directory name */I         strcpy(fname,end1+1);           /* File name without directory */ L         for (i=1;temp[i];i++)           /* Change '/' to '.' in directory */2             if(temp[i]=='/')		/* and '.' to '_' */                 temp[i]='.';% 	    else if (!dot && temp[i] == '.')s 	        temp[i] = '_';e=         if (*temp == '/')               /* absolute path ? */A	         { <             *temp = '[';		/* yes, build absolute VMS path */             strcpy(dire,temp);	         }          else	         {|7             dire[strlen(dire)-1] = (*temp=='.')?0:'.' ; L                  /* "." to indicate a subdirectory (unless already there )*/C             strcat(dire,temp);      /* Add on the new directory  */ 	         } @         strcat(dire,"]") ;              /* And close with ']' */     }yA     if(strlen(fname)==0)        /* Could this cause problems ? */i     {)         return(ISDIRE);l     }=     elseA         for(i=0,end1=fname;*end1;end1++) /* Replace multiple . */              if(*end1 == '.')9                 if(i++)*end1 = '_'; /* After the first */      return(ISFILE);  }   ( /* make_new -- create a new directory */   int make_new(want) char want[]; {t int status, created; char *dotp;    #ifdef debug)     fprintf(stderr, "want = %s (", want); ,     for (dotp = want; *dotp != '\0'; dotp++)  	fprintf(stderr, "\\%o", *dotp);D     fprintf(stderr, ")\nbefore: errno = %d -- ", errno); perror(""); #endif     created = 1;F     status = mkdir(want, 0);   /* mkdir in VAX C and DEC C creates all 				  missing levels */=     if (status != 0)     {( #ifdef debug9         fprintf(stderr, "1: status = %d, errno = %d -- ",  		status, errno); perror("");  #endif         if (errno == EEXIST)             return (0);*         if (errno != EINVAL)D             return (-1);          /* unknown error, simply return */L         else                      /* maybe too many levels of directories */O         {                         /* change "[...FOO.BAR]" to "[...FOO$BAR]" */ H         for (dotp = &want[strlen(want) - 1];dotp > want && status != 0;)              if (*--dotp == '.') 
             {                  *dotp = '$';(                 status = mkdir(want, 0);3                 if (status != 0 && errno == EEXIST)(                 {x)                     status = created = 0;                      break;                 }  #ifdef debug3 		fprintf(stderr, "2: status = %d, errno = %d -- ",  			status, errno); perror(""); #endif
             }c	         }      }t #ifdef debug5     fprintf(stderr, "3: status = %d, errno = %d -- ",e  	    status, errno); perror(""); #endif     if (status != 0)         return (-1);     if(verbose && created):         printf("                              %s\n",want);     return(0); }   @  /* Function to open and get data from the blocked input file */ FILE *opentar()  { 	 FILE *fp;      fp = fopen(tarfile, "rb");     return(fp);  }&  F /* Get the next file header from the input file buffer. We will always% * move to the next 512 byte boundary.a */ int hdr_read(buffer)
 char *buffer;  { 	 int stat;RB     stat = fread(buffer,1,RECSIZE,tarfp);    /* read the header */D     return(stat);                       /* catch them next read ? */ }     G /* This is supposed to skip over data to get to the desired position */ G /* Position is the number of bytes to skip. We should never have to useF6 * this during data transfers; just during listings. */ int tarskip(bytes)
 int bytes; {i int i=0;     while(bytes > 0)	         {'2         if((i=fread(buffer,1,RECSIZE,tarfp)) == 0)
             { 5             printf("tar: EOF hit while skipping.\n");              return(-1); 
             };         bytes -= i;p	         }r     return(0); }   % /* Decode the fields of the header */r   int decode_header()h {;, unsigned long idate, *bintim, chksum, value; char ll, *ptr; bintim = &idate;$     linktype=0; strcpy(linkname,"");"     strcpy(pathname,header.title);$     sscanf(header.time,"%o",bintim);;     strcpy(creation,ctime(bintim));     /* Work on this! */i     creation[24]=0;   7     sprintf(vmscreation, "%2.2s-%3.3s-%4.4s %8.8s.00", )C 	&(creation[8]), &(creation[4]), &(creation[20]), &(creation[11]));).     vmscreation[4] = _toupper(vmscreation[4]);.     vmscreation[5] = _toupper(vmscreation[5]);  )     sscanf(header.count,"%o",&bytecount);m)     sscanf(header.protection,"%o",&mode); !     sscanf(header.uid,"%o",&uid);=!     sscanf(header.gid,"%o",&gid); '     sscanf(header.chksum,"%o",&chksum);b   /* Verify checksum */   N     for(value = 0, ptr = (char *)&header; ptr < (char *)&header.chksum; ptr++)B              value += *ptr;                /* make the checksum */B     for(ptr = &header.linkcount; ptr <= &header.dummy[255]; ptr++)              value += *ptr;lN     value += (8 * ' ');	               /* checksum considered as all spaces */       if (chksum != value)D     {                                       /* abort if incorrect */B         printf("tar: directory checksum error for %s\n",pathname);         exit(SS$_NORMAL);      }i    > /* We may have the link written as binary or as character:  */  )     linktype = isdigit(header.linkcount)?e6             (header.linkcount - '0'):header.linkcount;     if(linktype != 0)I.         sscanf(header.linkname,"%s",linkname);     return(0); }     J /* vms_cleanup -- removes illegal characters from directory and file namesO  * Replaces hyphens and commas with underscores. Returns number of translationsf  * that were made.  */    vms_cleanup(string)e char string[]; {k     int i,flag=0;o     char c;      char *p;&     static char badchars[] = BADCHARS;(     static char translate[] = TRANSLATE;       for(i=0; c=string[i]; ++i)     { .         if ((p = strchr(badchars, c)) != NULL)L         {                    /* Replace illegal characters by underscores */.             string[i] = translate[p-badchars];B             flag++;          /* Record if any changes were made */	         },         else:             string[i] = toupper(c); /* Map to uppercase */     }e     return(flag);  }n   #ifdef USE_OWN_MKDIRE /* Let's try to do our own, non-buggy mkdir ().  At least, it returnsM<    better error codes, especially for non-unix statuses.  */   #include <libdef.h>n   int mkdir(dir, mode)
 char *dir;	 int mode;. {tK   struct dsc$descriptor_s dsc_dir = { 0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0 };    unsigned long status;c  %   dsc_dir.dsc$w_length = strlen(dir);    dsc_dir.dsc$a_pointer = dir;  3   status = lib$create_dir(&dsc_dir, 0, 0, 0, 0, 0);    switch (status)      {e+     case SS$_CREATED : errno = 0; return 0;d0     case SS$_NORMAL : errno = EEXIST; return -1;1     case LIB$_INVARG : errno = EINVAL; return -1;r4     case LIB$_INVFILSPE : errno = EINVAL; return -1;=     default: errno = EVMSERR; vaxc$errno = status; return -1;l     }e   return -1; }n #endif /* USE_OWN_MKDIR */