/* polyhex.h -- polyhexes for hextris */

/* Maximum number of hexagons was chosen to be 5 because if 6, it leaves a */
/*  hole:  @ @   */
/*        @   @  */
/*         @ @   */
/*  likewise, 4 was chosen for corner mode because if 5, it leaves a hole: */
/*   @ @   */
/*  @   @  */
/*   @     */

/* '+' Prelude part */
/*   1st number = number of hexagons in a polyhex */
/*   2nd number = number of distinct polyhexes & rotations & reflections */
/*   3rd number = number of distinct polyhexes & reflections */
/*   4th number = number of distinct polyhexes */
/*   5th number = 0 do not allow rotation and reflection */
/*                1 allow rotation but not reflection */
/*                2 allow rotation and reflection */
/*   6th number = corner mode to consider? 0 or 1 (if 0, no 7) */
/*   7th number = 0 do not allow rotation and reflection for corner mode */
/*                1 allow rotation but not reflection for corner mode */
/*                2 allow rotation and reflection for corner mode */

/* '*' Main parts */
/*   1st number = n-> consider an 3n(n-1)+1 hexagon */
/* '#' polyhex group (follows a '*') */
/*   1st number = number of hexagons in a polyhex */
/*   2nd number = number of polyhexes (incl rot & refl) in a 3n(n-1)+1 */
/*       hexagon */
/* The polyhex (follows a '#') */
/*   1st number = numbered polyhex (there for your benefit) */
/*   2nd number = rotation pointer (usually the next polyhex) */
/*   3rd number = reflection pointer */
/*   4th number = number of rows down to start */
/*   5th number = start number (0, 1, 2) */
/*       0=> starter for no turns permitted (no reflections or rotations) */
/*       1=> starter for allow rotations and no turns permitted */
/*       2=> starter for reflections, rotations, and no turns permitted */
/*   Next number (if corner mode) = start number for corner mode */
/*   The proceeding 2 or 3 numbers are repeated for gradual appearance */
/*       Pieces either JUMPIN or appear GRADUALly */
/*   The last group of 3n(n-1)+1 numbers is the polyhex */
/*       0=>     empty hexagon */
/*       1..64=> used hexagon */
/* '~' debug (preceeds a '#') */
/*   1st number = number of polyhexes to skip */

static /* const */ char * polyhex_data[] = {

/* PRELUDE */
/* + Polyhex States(None Rot Refl) Style Corners [Style] */
/* + 1 1 1 1 0 1      0 */
"+ 2 3 1 1 0 1      0",
"+ 3 11 3 3 0 1      1",
"+ 4 44 10 7 1 1      2",
"+ 5 186 33 22 2 0",

/* MAIN */
/* * X    (polyhex fills 3X(X-1)+1 hexagon) */
/* # Polyhex Number_of_Polyhex_Normal [Number_of_Polyhex_Corner] */
/* Ref_Num Ptr_Rot Ptr_Refl (Start_Location Start)J&G Shape_Array */
/* * 1 */
/* # 1 1 */
/* 0 0 0  0 2 0 2   64 */
"* 2",
"# 2 3",
"0 1 0  1 2 1 0   0 0  8 1 0  0 0",
"1 2 2  1 0 2 0   0 0  0 2 0  16 0",
"2 0 1  1 0 2 2   0 0  4 0 0  32 0",
"# 3 11",
"0 1 0   1 2 1 0   0 0  8 9 1    0 0",
"1 2 2   0 0 2 2   0 2  0 18 0   16 0",
"2 0 1   0 0 2 0   4 0  0 36 0   0 32",
"3 4 3   0 2 1 0   6 0  24 33 0  0 0",
"4 3 4   1 0 2 2   0 0  12 3 0   48 0",
"5 6 10  1 2 2 0   0 0  0 10 1   16 0",
"6 7 9   0 0 2 2   2 0  20 0 0   32 0",
"7 8 8   1 0 2 0   0 0  4 0 0    40 1",
"8 9 7   1 0 2 0   0 0  0 0 2    8 17",
"9 10 6  0 0 2 0   4 0  0 34 0   16 0",
"10 5 5  1 0 2 0   0 0  8 5 0    0 32",
"# 4 23",
"0 1 6     1 2 2 0   0 0   12 11 1  48 0",
"1 2 11    0 0 2 2   0 2   0 22 0   24 33",
"2 3 10    0 0 2 0   4 0   0 44 3   0 48",
"3 4 9     0 0 1 0   0 6   8 25 33  0 0",
"4 5 8     0 0 2 0   12 3  0 50 0   16 0",
"5 0 7     0 0 2 0   6 0   24 37 0  0 32",
"6 7 0     1 1 2 0   0 0   8 13 3   0 48",
"7 8 5     0 0 2 0   0 6   0 26 33  16 0",
"8 9 4     0 0 2 0   12 3  0 52 0   0 32",
"9 10 3    0 0 1 0   6 0   24 41 1  0 0",
"10 11 2   0 0 2 0   0 2   12 19 0  48 0",
"11 6 1    0 0 2 1   4 0   0 38 0   24 33",
"12 13 12  0 2 2 2   6 0   28 35 0  48 0",
"13 14 14  1 0 2 0   0 0   12 7 0   56 33",
"14 12 13  1 0 2 0   0 0   0 14 3   24 49",
"15 16 16  0 2 2 2   4 0   0 42 1   16 0",
"16 15 15  0 0 2 0   0 2   8 21 0   0 32",
"17 18 17  0 2 1 0   10 5  16 0 32  0 0",
"18 19 22  0 0 2 2   10 1  20 0 0   32 0",
"19 20 21  0 0 2 0   2 0   20 0 0   40 1",
"20 21 20  1 0 2 0   0 0   4 0 2    40 17",
"21 22 19  0 0 2 0   0 4   0 0 34   8 17",
"22 17 18  0 0 2 0   8 5   0 0 34   0 16",
"# 5 21",
"0 1 0     1 2 2 0   0 0   12 15 3   56 49",
"1 2 5     0 0 2 0   0 6   0 30 35   24 49",
"2 3 4     0 0 2 0   12 7  0 60 35   0 48",
"3 4 3     0 0 1 0   14 7  24 57 33  0 0",
"4 5 2     0 0 2 2   14 3  28 51 0   48 0",
"5 0 1     0 0 2 0   6 0   28 39 0   56 33",
"6 7 9     0 2 2 0   6 0   28 43 1   48 0",
"7 8 8     0 0 2 0   0 2   12 23 0   56 33",
"8 9 7     0 0 2 0   4 0   0 46 3    24 49",
"9 10 6    0 0 2 0   0 6   8 29 35   0 48",
"10 11 11  0 0 2 0   12 7  0 58 33   16 0",
"11 6 10   0 0 2 2   14 3  24 53 0   0 32",
"12 13 12  0 2 2 2   12 3  0 54 0    24 33",
"13 14 14  0 0 2 0   6 0   24 45 3   0 48",
"14 12 13  0 0 2 0   0 6   12 27 33  48 0",
"15 16 20  0 2 2 0   10 5  20 0 32   32 0",
"16 17 19  0 0 2 2   10 1  20 0 0    40 1",
"17 18 18  0 0 2 0   2 0   20 0 2    40 17",
"18 19 17  0 0 2 0   0 4   4 0 34    40 17",
"19 20 16  0 0 2 0   8 5   0 0 34    8 17",
"20 15 15  0 0 2 0   10 5  16 0 34   0 16",
"* 3",
"# 4 21",
"0 1 0     2 2 2 0   0 0 0  0 0 0 0   8 9 9 1 0    0 0 0 0   0 0 0",
"1 2 2     1 0 4 2   0 0 0  0 0 2 0   0 0 18 0 0   0 18 0 0  16 0 0",
"2 0 1     1 0 4 0   0 0 0  4 0 0 0   0 36 0 0 0   0 36 0 0  0 32 0",
"3 4 9     2 2 3 0   0 0 0  0 0 0 0   0 10 9 1 0   16 0 0 0  0 0 0",
"4 5 14    1 0 4 2   0 0 0  0 2 0 0   0 18 0 0 0   20 0 0 0  32 0 0",
"5 6 13    1 0 3 0   0 0 0  4 0 0 0   0 36 0 0 0   0 40 1 0  0 0 0",
"6 7 12    2 0 3 0   0 0 0  0 0 0 0   0 0 0 2 0    8 9 17 0  0 0 0",
"7 8 11    1 0 4 0   0 0 0  0 4 0 0   0 0 34 0 0   0 18 0 0  16 0 0",
"8 3 10    1 0 3 0   0 0 0  8 5 0 0   0 0 36 0 0   0 0 32 0  0 0 0",
"9 10 3    2 1 3 0   0 0 0  0 0 0 0   8 9 5 0 0    0 0 32 0  0 0 0",
"10 11 8   1 0 3 0   0 0 0  0 10 1 0  0 18 0 0 0   16 0 0 0  0 0 0",
"11 12 7   1 0 4 0   0 0 0  2 0 0 0   20 0 0 0 0   36 0 0 0  32 0 0",
"12 13 6   2 0 3 0   0 0 0  0 0 0 0   4 0 0 0 0    40 9 1 0  0 0 0",
"13 14 5   1 0 3 0   0 0 0  0 0 2 0   0 0 18 0 0   8 17 0 0  0 0 0",
"14 9 4    1 0 4 1   0 0 0  4 0 0 0   0 36 0 0 0   0 34 0 0  16 0 0",
"15 16 18  2 2 3 0   0 0 0  0 0 0 0   8 5 0 0 0    0 40 1 0  0 0 0",
"16 17 20  1 0 3 0   0 0 0  0 0 2 0   0 10 17 0 0  16 0 0 0  0 0 0",
"17 15 19  1 0 4 2   0 0 0  4 0 0 0   0 34 0 0 0   20 0 0 0  32 0 0",
"18 19 15  2 1 3 0   0 0 0  0 0 0 0   0 0 10 1 0   8 17 0 0  0 0 0",
"19 20 17  1 0 4 1   0 0 0  0 2 0 0   0 20 0 0 0   0 34 0 0  16 0 0",
"20 18 16  1 0 3 0   0 0 0  4 0 0 0   0 40 5 0 0   0 0 32 0  0 0 0",
"# 5 165",
"0 1 0        2 2 2 0   0 0 0  0 0 0 0    8 9 9 9 1     0 0 0 0     0 0 0",
"1 2 2        0 0 4 2   0 0 2  0 0 18 0   0 0 18 0 0    0 18 0 0    16 0 0",
"2 0 1        0 0 4 0   4 0 0  0 36 0 0   0 0 36 0 0    0 0 36 0    0 0 32",
"3 4 9        2 2 3 0   0 0 0  0 0 0 0    0 10 9 9 1    16 0 0 0    0 0 0",
"4 5 14       0 0 4 2   0 2 0  0 18 0 0   0 18 0 0 0    20 0 0 0    32 0 0",
"5 6 13       1 0 4 0   0 0 0  4 0 0 0    0 36 0 0 0    0 36 0 0    0 40 1",
"6 7 12       2 0 3 0   0 0 0  0 0 0 0    0 0 0 0 2     8 9 9 17    0 0 0",
"7 8 11       0 0 4 0   0 4 0  0 0 34 0   0 0 18 0 0    0 18 0 0    16 0 0",
"8 3 10       1 0 4 0   0 0 0  8 5 0 0    0 0 36 0 0    0 0 36 0    0 0 32",
"9 10 3       2 1 3 0   0 0 0  0 0 0 0    8 9 9 5 0     0 0 0 32    0 0 0",
"10 11 8      1 0 4 0   0 0 0  0 0 10 1   0 0 18 0 0    0 18 0 0    16 0 0",
"11 12 7      0 0 4 0   2 0 0  20 0 0 0   0 36 0 0 0    0 36 0 0    0 32 0",
"12 13 6      2 0 3 0   0 0 0  0 0 0 0    4 0 0 0 0     40 9 9 1    0 0 0",
"13 14 5      1 0 4 0   0 0 0  0 0 0 2    0 0 0 18 0    0 0 18 0    8 17 0",
"14 9 4       0 0 4 1   4 0 0  0 36 0 0   0 0 36 0 0    0 0 34 0    0 16 0",
"15 16 21     2 2 3 0   0 0 0  0 0 0 0    12 11 9 1 0   48 0 0 0    0 0 0",
"16 17 26     1 0 4 0   0 0 0  0 0 2 0    0 0 18 0 0    0 22 0 0    24 33 0",
"17 18 25     1 0 4 0   0 0 0  4 0 0 0    0 36 0 0 0    0 44 3 0    0 48 0",
"18 19 24     2 0 3 0   0 0 0  0 0 0 0    0 0 0 6 0     8 9 25 33   0 0 0",
"19 20 23     1 0 4 2   0 0 0  0 12 3 0   0 0 50 0 0    0 18 0 0    16 0 0",
"20 15 22     1 0 4 0   0 0 0  6 0 0 0    24 37 0 0 0   0 36 0 0    0 32 0",
"21 22 15     2 1 3 0   0 0 0  0 0 0 0    8 9 13 3 0    0 0 48 0    0 0 0",
"22 23 20     1 0 4 0   0 0 0  0 0 6 0    0 0 26 33 0   0 18 0 0    16 0 0",
"23 24 19     1 0 4 1   0 0 0  12 3 0 0   0 52 0 0 0    0 36 0 0    0 32 0",
"24 25 18     2 0 3 0   0 0 0  0 0 0 0    0 6 0 0 0     24 41 9 1   0 0 0",
"25 26 17     1 0 4 0   0 0 0  0 0 2 0    0 0 18 0 0    12 19 0 0   48 0 0",
"26 21 16     1 0 4 0   0 0 0  4 0 0 0    0 36 0 0 0    0 38 0 0    24 33 0",
"27 28 27     2 2 3 0   0 0 0  0 0 0 0    8 13 11 1 0   0 48 0 0    0 0 0",
"28 29 32     1 0 4 0   0 0 0  0 0 2 0    0 0 22 0 0    0 26 33 0   16 0 0",
"29 30 31     1 0 4 0   0 0 0  4 0 0 0    0 44 3 0 0    0 52 0 0    0 32 0",
"30 31 30     2 0 3 0   0 0 0  0 0 0 0    0 0 6 0 0     8 25 41 1   0 0 0",
"31 32 29     1 0 4 2   0 0 0  0 0 2 0    0 12 19 0 0   0 50 0 0    16 0 0",
"32 27 28     1 0 4 0   0 0 0  4 0 0 0    0 38 0 0 0    24 37 0 0   0 32 0",
"33 34 33     2 2 3 0   0 0 0  0 0 0 0    0 10 9 5 0    16 0 0 32   0 0 0",
"34 35 38     1 0 4 0   0 0 0  0 10 1 0   0 18 0 0 0    20 0 0 0    32 0 0",
"35 36 37     1 0 4 0   0 0 0  2 0 0 0    20 0 0 0 0    36 0 0 0    40 1 0",
"36 37 36     2 0 3 0   0 0 0  0 0 0 0    4 0 0 2 0     40 9 17 0   0 0 0",
"37 38 35     1 0 4 2   0 0 0  0 0 4 0    0 0 0 34 0    0 0 18 0    8 17 0",
"38 33 34     1 0 4 0   0 0 0  8 5 0 0    0 0 36 0 0    0 0 34 0    0 16 0",
"39 40 45     2 2 3 0   0 0 0  0 0 0 0    0 10 13 3 0   16 0 48 0   0 0 0",
"40 41 50     1 0 4 0   0 0 0  0 6 0 0    0 26 33 0 0   20 0 0 0    32 0 0",
"41 42 49     1 0 3 0   0 0 0  12 3 0 0   0 52 0 0 0    0 40 1 0    0 0 0",
"42 43 48     2 0 3 0   0 0 0  0 0 0 0    0 6 0 2 0     24 41 17 0  0 0 0",
"43 44 47     1 0 4 2   0 0 0  0 4 0 0    0 0 34 0 0    12 19 0 0   48 0 0",
"44 39 46     1 0 3 0   0 0 0  8 5 0 0    0 0 38 0 0    0 24 33 0   0 0 0",
"45 46 39     2 1 3 0   0 0 0  0 0 0 0    12 11 5 0 0   48 0 32 0   0 0 0",
"46 47 44     1 0 3 0   0 0 0  0 10 1 0   0 22 0 0 0    24 33 0 0   0 0 0",
"47 48 43     1 0 4 1   0 0 0  2 0 0 0    20 0 0 0 0    44 3 0 0    48 0 0",
"48 49 42     2 0 3 0   0 0 0  0 0 0 0    4 0 6 0 0     40 25 33 0  0 0 0",
"49 50 41     1 0 3 0   0 0 0  0 12 3 0   0 0 50 0 0    8 17 0 0    0 0 0",
"50 45 40     1 0 4 0   0 0 0  6 0 0 0    24 37 0 0 0   0 34 0 0    16 0 0",
"51 52 57     2 2 3 0   0 0 0  0 0 0 0    0 14 11 1 0   24 49 0 0   0 0 0",
"52 53 62     1 0 4 0   0 0 0  0 2 0 0    0 22 0 0 0    28 35 0 0   48 0 0",
"53 54 61     1 0 3 0   0 0 0  4 0 0 0    0 44 7 0 0    0 56 33 0   0 0 0",
"54 55 60     2 0 3 0   0 0 0  0 0 0 0    0 0 14 3 0    8 25 49 0   0 0 0",
"55 56 59     1 0 4 2   0 0 0  0 6 0 0    0 28 35 0 0   0 50 0 0    16 0 0",
"56 51 58     1 0 3 0   0 0 0  12 7 0 0   0 56 37 0 0   0 0 32 0    0 0 0",
"57 58 51     2 1 3 0   0 0 0  0 0 0 0    8 13 7 0 0    0 56 33 0   0 0 0",
"58 59 56     1 0 3 0   0 0 0  0 14 3 0   0 26 49 0 0   16 0 0 0    0 0 0",
"59 60 55     1 0 4 1   0 0 0  0 6 0 0    0 28 35 0 0   0 52 0 0    0 32 0",
"60 61 54     2 0 3 0   0 0 0  0 0 0 0    12 7 0 0 0    56 41 1 0   0 0 0",
"61 62 53     1 0 3 0   0 0 0  0 0 2 0    0 14 19 0 0   24 49 0 0   0 0 0",
"62 57 52     1 0 4 0   0 0 0  4 0 0 0    0 38 0 0 0    28 35 0 0   48 0 0",
"63 64 69     1 2 3 0   0 0 0  10 9 1 0   20 0 0 0 0    32 0 0 0    0 0 0",
"64 65 74     1 0 4 0   0 0 0  0 2 0 0    0 18 0 0 0    20 0 0 0    40 1 0",
"65 66 73     1 0 3 0   0 0 0  4 0 0 0    0 36 0 2 0    0 40 17 0   0 0 0",
"66 67 72     1 0 3 0   0 0 0  0 0 4 0    0 0 0 34 0    8 9 17 0    0 0 0",
"67 68 71     1 0 4 2   0 0 0  8 5 0 0    0 0 34 0 0    0 18 0 0    16 0 0",
"68 63 70     1 0 3 0   0 0 0  10 5 0 0   16 0 36 0 0   0 0 32 0    0 0 0",
"69 70 63     1 1 3 0   0 0 0  8 9 5 0    0 0 0 34 0    0 0 16 0    0 0 0",
"70 71 68     1 0 3 0   0 0 0  0 10 5 0   0 18 0 32 0   16 0 0 0    0 0 0",
"71 72 67     1 0 4 1   0 0 0  10 1 0 0   20 0 0 0 0    36 0 0 0    32 0 0",
"72 73 66     1 0 3 0   0 0 0  2 0 0 0    20 0 0 0 0    40 9 1 0    0 0 0",
"73 74 65     1 0 3 0   0 0 0  0 0 2 0    4 0 18 0 0    40 17 0 0   0 0 0",
"74 69 64     1 0 4 0   0 0 0  0 4 0 0    0 0 36 0 0    0 0 34 0    8 17 0",
"75 76 80     1 2 3 0   0 0 0  0 10 9 1   0 18 0 0 0    16 0 0 0    0 0 0",
"76 77 79     0 0 4 0   0 2 0  0 18 0 0   0 20 0 0 0    0 36 0 0    0 32 0",
"77 78 78     1 0 3 0   0 0 0  4 0 0 0    0 36 0 0 0    0 40 9 1    0 0 0",
"78 79 77     1 0 3 0   0 0 0  0 0 0 2    0 0 0 18 0    8 9 17 0    0 0 0",
"79 80 76     0 0 4 2   0 4 0  0 0 36 0   0 0 0 34 0    0 0 18 0    0 16 0",
"80 75 75     1 0 3 0   0 0 0  8 9 5 0    0 0 0 36 0    0 0 0 32    0 0 0",
"81 82 87     2 2 3 0   0 0 0  0 0 0 0    0 0 10 9 1    8 17 0 0    0 0 0",
"82 83 92     0 0 4 0   0 2 0  0 18 0 0   0 20 0 0 0    0 34 0 0    16 0 0",
"83 84 91     1 0 4 0   0 0 0  4 0 0 0    0 36 0 0 0    0 40 5 0    0 0 32",
"84 85 90     2 0 3 0   0 0 0  0 0 0 0    0 0 0 10 1    8 9 17 0    0 0 0",
"85 86 89     0 0 4 2   0 2 0  0 20 0 0   0 0 34 0 0    0 18 0 0    16 0 0",
"86 81 88     1 0 4 0   0 0 0  4 0 0 0    0 40 5 0 0    0 0 36 0    0 0 32",
"87 88 81     2 1 3 0   0 0 0  0 0 0 0    8 9 5 0 0     0 0 40 1    0 0 0",
"88 89 86     1 0 4 0   0 0 0  0 0 0 2    0 0 10 17 0   0 18 0 0    16 0 0",
"89 90 85     0 0 4 1   4 0 0  0 34 0 0   0 20 0 0 0    0 36 0 0    0 32 0",
"90 91 84     2 0 3 0   0 0 0  0 0 0 0    8 5 0 0 0     0 40 9 1    0 0 0",
"91 92 83     1 0 4 0   0 0 0  0 0 0 2    0 0 0 18 0    0 10 17 0   16 0 0",
"92 87 82     0 0 4 0   4 0 0  0 36 0 0   0 0 34 0 0    0 20 0 0    0 32 0",
"93 94 96     1 2 3 0   0 0 0  4 0 0 0    0 42 9 1 0    16 0 0 0    0 0 0",
"94 95 95     1 0 4 0   0 0 0  0 0 2 0    0 0 18 0 0    8 21 0 0    0 32 0",
"95 96 94     1 0 4 0   0 0 0  4 0 0 0    0 36 0 0 0    0 42 1 0    16 0 0",
"96 97 93     1 0 3 0   0 0 0  0 0 2 0    8 9 21 0 0    0 0 32 0    0 0 0",
"97 98 98     1 0 4 2   0 0 0  0 4 0 0    0 0 42 1 0    0 18 0 0    16 0 0",
"98 93 97     1 0 4 0   0 0 0  0 2 0 0    8 21 0 0 0    0 36 0 0    0 32 0",
"99 100 105   1 2 3 0   0 0 0  0 6 0 0    0 26 41 1 0   16 0 0 0    0 0 0",
"100 101 110  1 0 4 1   0 0 0  0 2 0 0    12 19 0 0 0   52 0 0 0    32 0 0",
"101 102 109  1 0 3 0   0 0 0  4 0 0 0    0 38 0 0 0    24 41 1 0   0 0 0",
"102 103 108  1 0 3 0   0 0 0  0 0 2 0    8 13 19 0 0   0 48 0 0    0 0 0",
"103 104 107  1 0 4 0   0 0 0  0 4 0 0    0 0 38 0 0    0 26 33 0   16 0 0",
"104 99 106   1 0 3 0   0 0 0  8 13 3 0   0 0 52 0 0    0 0 32 0    0 0 0",
"105 106 99   1 1 3 0   0 0 0  0 6 0 0    8 25 37 0 0   0 0 32 0    0 0 0",
"106 107 104  1 0 3 0   0 0 0  12 11 1 0  0 50 0 0 0    16 0 0 0    0 0 0",
"107 108 103  1 0 4 0   0 0 0  0 2 0 0    0 22 0 0 0    24 37 0 0   0 32 0",
"108 109 102  1 0 3 0   0 0 0  4 0 0 0    0 44 11 1 0   0 48 0 0    0 0 0",
"109 110 101  1 0 3 0   0 0 0  0 0 2 0    0 0 22 0 0    8 25 33 0   0 0 0",
"110 105 100  1 0 4 2   0 0 0  4 0 0 0    0 44 3 0 0    0 50 0 0    16 0 0",
"111 112 117  1 2 3 0   0 0 0  0 0 6 0    0 10 25 33 0  16 0 0 0    0 0 0",
"112 113 122  1 0 4 1   0 0 0  12 3 0 0   0 50 0 0 0    20 0 0 0    32 0 0",
"113 114 121  1 0 3 0   0 0 0  6 0 0 0    24 37 0 0 0   0 40 1 0    0 0 0",
"114 115 120  1 0 3 0   0 0 0  0 0 2 0    12 11 17 0 0  48 0 0 0    0 0 0",
"115 116 119  1 0 4 0   0 0 0  0 4 0 0    0 0 34 0 0    0 22 0 0    24 33 0",
"116 111 118  1 0 3 0   0 0 0  8 5 0 0    0 0 44 3 0    0 0 48 0    0 0 0",
"117 118 111  1 1 3 0   0 0 0  6 0 0 0    24 41 5 0 0   0 0 32 0    0 0 0",
"118 119 116  1 0 3 0   0 0 0  0 10 1 0   12 19 0 0 0   48 0 0 0    0 0 0",
"119 120 115  1 0 4 0   0 0 0  0 2 0 0    0 20 0 0 0    0 38 0 0    24 33 0",
"120 121 114  1 0 3 0   0 0 0  4 0 0 0    0 40 13 3 0   0 0 48 0    0 0 0",
"121 122 113  1 0 3 0   0 0 0  0 0 6 0    0 0 26 33 0   8 17 0 0    0 0 0",
"122 117 112  1 0 4 2   0 0 0  12 3 0 0   0 52 0 0 0    0 34 0 0    16 0 0",
"123 124 126  1 2 3 0   0 0 0  0 0 0 2    0 10 9 17 0   16 0 0 0    0 0 0",
"124 125 128  1 0 4 1   0 4 0  0 0 34 0   0 0 18 0 0    0 20 0 0    0 32 0",
"125 123 127  1 0 3 0   0 0 0  8 5 0 0    0 0 36 0 0    0 0 40 1    0 0 0",
"126 127 123  1 1 3 0   0 0 0  4 0 0 0    0 40 9 5 0    0 0 0 32    0 0 0",
"127 128 125  1 0 3 0   0 0 0  0 0 10 1   0 0 18 0 0    8 17 0 0    0 0 0",
"128 126 124  1 0 4 2   0 2 0  0 20 0 0   0 0 36 0 0    0 0 34 0    0 16 0",
"129 130 129  1 2 3 0   0 0 0  0 6 0 0    0 26 37 0 0   16 0 32 0   0 0 0",
"130 131 134  1 0 3 0   0 0 0  12 11 1 0  0 52 0 0 0    0 32 0 0    0 0 0",
"131 132 133  1 0 3 0   0 0 0  0 2 0 0    0 22 0 0 0    24 41 1 0   0 0 0",
"132 133 132  1 0 3 0   0 0 0  4 0 2 0    0 44 19 0 0   0 48 0 0    0 0 0",
"133 134 131  1 0 3 0   0 0 0  0 4 0 0    0 0 38 0 0    8 25 33 0   0 0 0",
"134 129 130  1 0 3 2   0 0 0  8 13 3 0   0 0 50 0 0    0 16 0 0    0 0 0",
"135 136 141  2 2 3 0   0 0 0  0 0 0 0    0 10 5 0 0    16 0 40 1   0 0 0",
"136 137 146  1 0 4 2   0 0 0  0 0 2 0    0 10 17 0 0   20 0 0 0    32 0 0",
"137 138 145  1 0 4 0   0 0 0  4 0 0 0    0 34 0 0 0    20 0 0 0    40 1 0",
"138 139 144  2 0 3 0   0 0 0  0 0 0 0    8 5 0 2 0     0 40 17 0   0 0 0",
"139 140 143  1 0 4 0   0 0 0  0 0 4 0    0 0 0 34 0    0 10 17 0   16 0 0",
"140 135 142  1 0 4 0   0 0 0  8 5 0 0    0 0 34 0 0    0 20 0 0    0 32 0",
"141 142 135  2 1 3 0   0 0 0  0 0 0 0    0 0 10 5 0    8 17 0 32   0 0 0",
"142 143 140  1 0 4 0   0 0 0  0 10 1 0   0 20 0 0 0    0 34 0 0    16 0 0",
"143 144 139  1 0 4 0   0 0 0  2 0 0 0    20 0 0 0 0    40 5 0 0    0 32 0",
"144 145 138  2 0 3 0   0 0 0  0 0 0 0    4 0 10 1 0    40 17 0 0   0 0 0",
"145 146 137  1 0 4 0   0 0 0  0 0 2 0    0 0 20 0 0    0 0 34 0    8 17 0",
"146 141 136  1 0 4 0   0 0 0  4 0 0 0    0 40 5 0 0    0 0 34 0    0 16 0",
"147 148 153  1 2 3 0   0 0 0  4 0 0 0    0 42 5 0 0    16 0 32 0   0 0 0",
"148 149 158  1 0 3 0   0 0 0  0 10 1 0   8 21 0 0 0    0 32 0 0    0 0 0",
"149 150 157  1 0 4 0   0 0 0  0 2 0 0    0 20 0 0 0    0 42 1 0    16 0 0",
"150 151 156  1 0 3 0   0 0 0  4 0 2 0    0 40 21 0 0   0 0 32 0    0 0 0",
"151 152 155  1 0 3 0   0 0 0  0 4 0 0    0 0 42 1 0    8 17 0 0    0 0 0",
"152 147 154  1 0 4 2   0 0 0  0 2 0 0    8 21 0 0 0    0 34 0 0    16 0 0",
"153 154 147  1 1 3 0   0 0 0  0 0 2 0    0 10 21 0 0   16 0 32 0   0 0 0",
"154 155 152  1 0 4 1   0 0 0  4 0 0 0    0 42 1 0 0    20 0 0 0    32 0 0",
"155 156 151  1 0 3 0   0 0 0  0 2 0 0    8 21 0 0 0    0 40 1 0    0 0 0",
"156 157 150  1 0 3 0   0 0 0  4 0 2 0    0 42 17 0 0   16 0 0 0    0 0 0",
"157 158 149  1 0 4 0   0 0 0  0 4 0 0    0 0 34 0 0    8 21 0 0    0 32 0",
"158 153 148  1 0 3 0   0 0 0  8 5 0 0    0 0 42 1 0    0 16 0 0    0 0 0",
"159 160 164  1 2 3 0   0 0 0  0 0 10 1   0 10 17 0 0   16 0 0 0    0 0 0",
"160 161 163  0 0 4 0   0 2 0  0 20 0 0   0 0 34 0 0    0 20 0 0    0 32 0",
"161 162 162  1 0 3 0   0 0 0  4 0 0 0    0 40 5 0 0    0 0 40 1    0 0 0",
"162 163 161  1 0 3 0   0 0 0  0 0 0 2    0 0 10 17 0   8 17 0 0    0 0 0",
"163 164 160  0 0 4 2   0 4 0  0 0 34 0   0 0 20 0 0    0 0 34 0    0 16 0",
"164 159 159  1 0 3 0   0 0 0  8 5 0 0    0 0 40 5 0    0 0 0 32    0 0 0"};
