/* polyomino.h -- polyominoes for tetris & welltris */

/* Maximum number of squares was chosen to be 6 because if 7, it leaves a */
/*  hole: @@@ */
/*        @ @ */
/*        @@  */
/*  likewise, 3 was chosen for diagonal mode because if 4, it leaves a hole: */
/*   @  */
/*  @ @ */
/*   @  */

/* '+' Prelude part */
/*   1st number = number of squares in a polyomino */
/*   2nd number = number of distinct polyominoes & rotations & reflections */
/*   3rd number = number of distinct polyominoes & reflections */
/*   4th number = number of distinct polyominoes */
/*   5th number = 0 do not allow rotation and reflection */
/*                1 allow rotation but not reflection */
/*                2 allow rotation and reflection */
/*   6th number = diagonal mode to consider? 0 or 1 (if 0, no 7-10) */
/*   7th number = diagonal number of distinct polyominoes & rots & refls */
/*   8th number = diagonal number of distinct polyominoes & reflections */
/*   9th number = diagonal number of distinct polyominoes */
/*  10th number = 0 do not allow rotation and reflection for diagonal mode */
/*                1 allow rotation but not reflection for diagonal mode */
/*                2 allow rotation and reflection for diagonal mode */

/* '*' Main parts */
/*   1st number = n-> consider an n^2 square */
/* '#' polyomino group (follows a '*') */
/*   1st number = number of squares in a polyomino */
/*   2nd number = number of polyominoes (incl rot & refl) in a n^2 square */
/*   3rd number = if it is there, number of polyominoes (incl rot & refl) */
/*       in a n^2 square with diagonal mode */
/* The polyomino (follows a '#') */
/*   1st number = numbered polyomino (there for your benefit) */
/*   2nd number = rotation pointer (usually the next polyomino) */
/*   3rd number = reflection pointer */
/*   4th number = number of rows down to start */
/*   5th number = start number (0, 1, or 2) */
/*       0=> starter for no turns permitted (no reflections or rotations) */
/*       1=> starter for allow rotations and no turns permitted */
/*       2=> starter for reflections, rotations, and no turns permitted */
/*   Next number (if diagonal mode) = start number for diagonal mode */
/*   The proceeding 2 or 3 numbers are repeated for gradual appearance */
/*       Pieces either JUMPIN or appear GRADUALly */
/*   The last group of n^2 numbers is the actual polyomino */
/*       0=>     empty square */
/*       1..16=> used square */
/* '~' debug (preceeds a '#') */
/*   1st number = number of polyominoes to skip */

static /* const */ char * polyomino_data[] = {

/* PRELUDE */
/* + Polyomino States(None Rot Refl) Style Diagonal [States(N R R) Style] */
/* + 1 1 1 1 0 1     1 1 1 0 */

"+ 2 2 1 1 0 1     4 2 2 0",
"+ 3 6 2 2 0 1     20 6 5 1",
"+ 4 19 7 5 1 0",
"+ 5 63 18 12 2 0",
"+ 6 216 60 35 2 0",

/* MAIN */
/* * X    (polyomino fills X^2 square) */
/* # Polyomino Number_of_Polyominoes_Normal [Number_of_Polyominoes_Diagonal] */
/* Ref_Num Ptr_Rot Ptr_Refl (Start_Location Start_N [Start_D])J&G Shape_Array */
/* * 1 */
/* # 1 1 */
/* 0 0 0  0 2 2 1 2 2   16 */
"* 2",
"# 2 2 4",
"0 1 0  1 2 2 1 0 0   0 0  4 1",
"1 0 1  0 0 0 1 2 2   0 2  0 8",

"2 3 3  0 0 2 1 0 2   0 16  16 0",
"3 2 2  0 0 0 1 0 0   16 0  0 16",
"# 3 4 4",
"0 1 3  0 2 2 1 2 2   6 1  8 0",
"1 2 2  0 0 0 1 0 0   2 0  12 1",
"2 3 1  0 0 0 1 0 0   0 2  4 9",
"3 0 0  0 0 0 1 0 0   4 3  0 8",
"# 4 1",
"0 0 0  0 2 1 2   6 3  12 9",
"* 3",
"# 3 2 16",
"0 1 0   1 2 2 1 0 0   0 0 0  4 5 1   0 0 0",
"1 0 1   0 0 0 2 2 2   0 2 0  0 10 0  0 8 0",

"2 3 3     0 0 2 2 0 2   16 0 0  0 16 0   0 0 16",
"3 2 2     0 0 0 2 0 0   0 0 16  0 16 0   16 0 0",
"4 5 8     1 0 2 2 0 0   0 0 0   0 4 1    16 0 0",
"5 6 11    0 0 0 2 0 2   0 2 0   0 8 0    0 0 16",
"6 7 10    1 0 0 2 0 0   0 0 0   0 0 16   4 1 0",
"7 4 9     0 0 0 2 0 0   0 16 0  0 0 2    0 0 8",
"8 9 4     1 0 1 2 0 0   0 0 0   4 1 0    0 0 16",
"9 10 7    0 0 0 2 0 0   0 0 16  0 2 0    0 8 0",
"10 11 6   1 0 0 2 0 0   0 0 0   16 0 0   0 4 1",
"11 8 5    0 0 0 2 0 1   0 0 2   0 0 8    0 16 0",
"12 13 12  1 0 2 2 0 0   0 0 0   16 0 16  0 16 0",
"13 14 15  0 0 0 2 0 2   0 16 0  0 0 16   0 16 0",
"14 15 14  1 0 0 2 0 0   0 0 0   0 16 0   16 0 16",
"15 12 13  0 0 0 2 0 0   0 0 16  0 16 0   0 0 16",
"# 4 16",
"0 1 4     1 2 2 0   0 0 0  6 5 1   8 0 0",
"1 2 7     0 0 2 0   0 2 0  0 10 0  0 12 1",
"2 3 6     1 0 2 0   0 0 0  0 0 2   4 5 9",
"3 0 5     0 0 2 2   0 4 3  0 0 10  0 0 8",
"4 5 0     1 1 2 0   0 0 0  4 5 3   0 0 8",
"5 6 3     0 0 2 1   0 6 1  0 10 0  0 8 0",
"6 7 2     1 0 2 0   0 0 0  2 0 0   12 5 1",
"7 4 1     0 0 2 0   0 0 2  0 0 10  0 4 9",
"8 9 8     1 2 2 0   0 0 0  4 7 1   0 8 0",
"9 10 11   0 0 2 2   0 2 0  0 14 1  0 8 0",
"10 11 10  1 0 2 0   0 0 0  0 2 0   4 13 1",
"11 8 9    0 0 2 0   0 0 2  0 4 11  0 0 8",
"12 13 14  1 2 2 0   0 0 0  4 3 0   0 12 1",
"13 12 15  0 0 2 2   0 0 2  0 6 9   0 8 0",
"14 15 12  1 1 2 0   0 0 0  0 6 1   4 9 0",
"15 14 13  0 0 2 1   0 2 0  0 12 3  0 0 8",
"# 5 37",
"0 1 0     1 2 2 0   0 0 0  6 5 3    8 0 8",
"1 2 3     0 0 2 2   0 6 1  0 10 0   0 12 1",
"2 3 2     1 0 2 0   0 0 0  2 0 2    12 5 9",
"3 0 1     0 0 2 0   0 4 3  0 0 10   0 4 9",
"4 5 8     1 2 2 0   0 0 0  6 7 1    12 9 0",
"5 6 11    0 0 2 0   0 2 0  0 14 3   0 12 9",
"6 7 10    1 0 2 0   0 0 0  0 6 3    4 13 9",
"7 4 9     0 0 2 2   0 6 3  0 12 11  0 0 8",
"8 9 4     1 1 2 0   0 0 0  4 7 3    0 12 9",
"9 10 7    0 0 2 1   0 6 3  0 14 9   0 8 0",
"10 11 6   1 0 2 0   0 0 0  6 3 0    12 13 1",
"11 8 5    0 0 2 0   0 0 2  0 6 11   0 12 9",
"12 13 12  0 2 2 2   4 7 1  0 10 0   0 8 0",
"13 14 15  0 0 2 0   2 0 0  14 5 1   8 0 0",
"14 15 14  0 0 2 0   0 2 0  0 10 0   4 13 1",
"15 12 13  0 0 2 0   0 0 2  4 5 11   0 0 8",
"16 17 19  0 2 2 2   6 5 1  10 0 0   8 0 0",
"17 18 18  0 0 2 0   2 0 0  10 0 0   12 5 1",
"18 19 17  0 0 2 0   0 0 2  0 0 10   4 5 9",
"19 16 16  0 0 2 0   4 5 3  0 0 10   0 0 8",
"20 21 22  0 2 2 0   2 0 0  12 5 3   0 0 8",
"21 20 23  0 0 2 2   0 6 1  0 10 0   4 9 0",
"22 23 20  0 1 2 0   0 0 2  6 5 9    8 0 0",
"23 22 21  0 0 2 1   4 3 0  0 10 0   0 12 1",
"24 25 25  0 2 2 2   4 3 0  0 12 3   0 0 8",
"25 26 24  0 0 2 0   0 6 1  6 9 0    8 0 0",
"26 27 27  0 0 2 0   2 0 0  12 3 0   0 12 1",
"27 24 26  0 0 2 0   0 0 2  0 6 9    4 9 0",
"28 29 32  0 2 2 0   0 2 0  6 13 1   8 0 0",
"29 30 35  0 0 2 0   0 2 0  4 11 0   0 12 1",
"30 31 34  0 0 2 0   0 0 2  4 7 9    0 8 0",
"31 28 33  0 0 2 2   4 3 0  0 14 1   0 8 0",
"32 33 28  0 1 2 0   0 2 0  4 13 3   0 0 8",
"33 34 31  0 0 2 1   0 6 1  4 11 0   0 8 0",
"34 35 30  0 0 2 0   2 0 0  12 7 1   0 8 0",
"35 32 29  0 0 2 0   0 2 0  0 14 1   4 9 0",
"36 36 36  0 2 2 2   0 2 0  4 15 1   0 8 0",
"# 6 46",
"0 1 4     0 2 2 0   6 5 3  10 0 8   8 0 0",
"1 2 7     0 0 2 0   6 1 0  10 0 0   12 5 1",
"2 3 6     0 0 2 0   0 0 2  2 0 10   12 5 9",
"3 0 5     0 0 2 2   4 5 3  0 0 10   0 4 9",
"4 5 0     0 1 2 0   6 5 3  8 0 10   0 0 8",
"5 6 3     0 0 2 1   6 5 1  10 0 0   12 1 0",
"6 7 2     0 0 2 0   2 0 0  10 0 2   12 5 9",
"7 4 1     0 0 2 0   0 4 3  0 0 10   4 5 9",
"8 9 12    0 2 2 2   6 7 1  12 11 0  0 8 0",
"9 10 15   0 0 2 0   2 0 0  14 7 1   12 9 0",
"10 11 14  0 0 2 0   0 2 0  0 14 3   4 13 9",
"11 8 13   0 0 2 0   0 6 3  4 13 11  0 0 8",
"12 13 8   0 1 2 1   4 7 3  0 14 9   0 8 0",
"13 14 11  0 0 2 0   6 3 0  14 13 1  8 0 0",
"14 15 10  0 0 2 0   0 2 0  6 11 0   12 13 1",
"15 12 9   0 0 2 0   0 0 2  4 7 11   0 12 9",
"16 17 20  0 2 2 0   6 3 0  12 13 3  0 0 8",
"17 18 23  0 0 2 0   0 6 1  6 11 0   12 9 0",
"18 19 22  0 0 2 0   2 0 0  12 7 3   0 12 9",
"19 16 21  0 0 2 2   0 6 3  0 14 9   4 9 0",
"20 21 16  0 1 2 0   0 6 3  6 13 9   8 0 0",
"21 22 19  0 0 2 1   6 3 0  12 11 0  0 12 1",
"22 23 18  0 0 2 0   0 0 2  6 7 9    12 9 0",
"23 20 17  0 0 2 0   4 3 0  0 14 3   0 12 9",
"24 25 28  0 2 2 2   4 7 1  0 10 0   4 9 0",
"25 26 31  0 0 2 0   2 0 0  14 5 3   8 0 8",
"26 27 30  0 0 2 0   0 6 1  0 10 0   4 13 1",
"27 24 29  0 0 2 0   2 0 2  12 5 11  0 0 8",
"28 29 24  0 1 2 1   4 7 1  0 10 0   0 12 1",
"29 30 27  0 0 2 0   2 0 2  14 5 9   8 0 0",
"30 31 26  0 0 2 0   4 3 0  0 10 0   4 13 1",
"31 28 25  0 0 2 0   0 0 2  6 5 11   8 0 8",
"32 33 32  0 2 2 0   2 0 2  12 7 9   0 8 0",
"33 34 35  0 0 2 2   4 3 0  0 14 1   4 9 0",
"34 35 34  0 0 2 0   0 2 0  6 13 3   8 0 8",
"35 32 33  0 0 2 0   0 6 1  4 11 0   0 12 1",
"36 37 39  0 2 2 2   6 7 1  14 9 0   8 0 0",
"37 38 38  0 0 2 0   2 0 0  14 3 0   12 13 1",
"38 39 37  0 0 2 0   0 0 2  0 6 11   4 13 9",
"39 36 36  0 0 2 0   4 7 3  0 12 11  0 0 8",
"40 41 43  0 2 2 2   6 3 0  12 15 1  0 8 0",
"41 42 42  0 0 2 0   0 2 0  6 15 1   12 9 0",
"42 43 41  0 0 2 0   0 2 0  4 15 3   0 12 9",
"43 40 40  0 0 2 0   0 6 3  4 15 9   0 8 0",
"44 45 44  1 2 2 0   0 0 0  6 7 3    12 13 9",
"45 44 45  0 0 2 2   0 6 3  0 14 11  0 12 9",
"* 4",
"# 4 2",
"0 1 0  2 2 2 0   0 0 0 0  0 0 0 0   4 5 5 1   0 0 0 0",
"1 0 1  0 0 3 2   0 0 2 0  0 0 10 0  0 0 10 0  0 0 8 0",
"# 5 24",
"0 1 4     1 2 2 0   0 0 0 0  6 5 5 1   8 0 0 0   0 0 0 0",
"1 2 7     0 0 3 0   0 2 0 0  0 10 0 0  0 10 0 0  0 12 1 0",
"2 3 6     1 0 2 0   0 0 0 0  0 0 0 2   4 5 5 9   0 0 0 0",
"3 0 5     0 0 3 2   0 4 3 0  0 0 10 0  0 0 10 0  0 0 8 0",
"4 5 0     1 1 2 0   0 0 0 0  4 5 5 3   0 0 0 8   0 0 0 0",
"5 6 3     0 0 3 1   0 6 1 0  0 10 0 0  0 10 0 0  0 8 0 0",
"6 7 2     1 0 2 0   0 0 0 0  2 0 0 0   12 5 5 1  0 0 0 0",
"7 4 1     0 0 3 0   0 0 2 0  0 0 10 0  0 0 10 0  0 4 9 0",
"8 9 12    1 2 2 0   0 0 0 0  4 7 5 1   0 8 0 0   0 0 0 0",
"9 10 15   0 0 3 0   0 2 0 0  0 10 0 0  0 14 1 0  0 8 0 0",
"10 11 14  1 0 2 0   0 0 0 0  0 0 2 0   4 5 13 1  0 0 0 0",
"11 8 13   0 0 3 2   0 0 2 0  0 4 11 0  0 0 10 0  0 0 8 0",
"12 13 8   1 1 2 0   0 0 0 0  4 5 7 1   0 0 8 0   0 0 0 0",
"13 14 11  0 0 3 1   0 2 0 0  0 14 1 0  0 10 0 0  0 8 0 0",
"14 15 10  1 0 2 0   0 0 0 0  0 2 0 0   4 13 5 1  0 0 0 0",
"15 12 9   0 0 3 0   0 0 2 0  0 0 10 0  0 4 11 0  0 0 8 0",
"16 17 20  1 2 2 0   0 0 0 0  4 5 3 0   0 0 12 1  0 0 0 0",
"17 18 23  0 0 3 2   0 0 2 0  0 6 9 0   0 10 0 0  0 8 0 0",
"18 19 22  1 0 2 0   0 0 0 0  4 3 0 0   0 12 5 1  0 0 0 0",
"19 16 21  0 0 3 0   0 0 2 0  0 0 10 0  0 6 9 0   0 8 0 0",
"20 21 16  1 1 2 0   0 0 0 0  0 6 5 1   4 9 0 0   0 0 0 0",
"21 22 19  0 0 3 0   0 2 0 0  0 10 0 0  0 12 3 0  0 0 8 0",
"22 23 18  1 0 2 0   0 0 0 0  0 0 6 1   4 5 9 0   0 0 0 0",
"23 20 17  0 0 3 1   0 2 0 0  0 12 3 0  0 0 10 0  0 0 8 0",
"# 6 136",
"0 1 4        1 2 3 0   0 0 0 0  6 5 5 1    10 0 0 0   8 0 0 0",
"1 2 7        0 0 3 0   0 2 0 0  0 10 0 0   0 10 0 0   0 12 5 1",
"2 3 6        1 0 3 0   0 0 0 0  0 0 0 2    0 0 0 10   4 5 5 9",
"3 0 5        0 0 3 2   0 4 5 3  0 0 0 10   0 0 0 10   0 0 0 8",
"4 5 0        1 1 3 0   0 0 0 0  4 5 5 3    0 0 0 10   0 0 0 8",
"5 6 3        0 0 3 1   0 6 5 1  0 10 0 0   0 10 0 0   0 8 0 0",
"6 7 2        1 0 3 0   0 0 0 0  2 0 0 0    10 0 0 0   12 5 5 1",
"7 4 1        0 0 3 0   0 0 0 2  0 0 0 10   0 0 0 10   0 4 5 9",
"8 9 12       1 2 2 0   0 0 0 0  6 7 5 1    12 9 0 0   0 0 0 0",
"9 10 15      0 0 3 0   0 2 0 0  0 10 0 0   0 14 3 0   0 12 9 0",
"10 11 14     1 0 2 0   0 0 0 0  0 0 6 3    4 5 13 9   0 0 0 0",
"11 8 13      0 0 3 2   0 6 3 0  0 12 11 0  0 0 10 0   0 0 8 0",
"12 13 8      1 1 2 0   0 0 0 0  4 5 7 3    0 0 12 9   0 0 0 0",
"13 14 11     0 0 3 1   0 6 3 0  0 14 9 0   0 10 0 0   0 8 0 0",
"14 15 10     1 0 2 0   0 0 0 0  6 3 0 0    12 13 5 1  0 0 0 0",
"15 12 9      0 0 3 0   0 0 2 0  0 0 10 0   0 6 11 0   0 12 9 0",
"16 17 20     1 2 2 0   0 0 0 0  6 5 7 1    8 0 8 0    0 0 0 0",
"17 18 23     0 0 3 0   0 2 0 0  0 14 1 0   0 10 0 0   0 12 1 0",
"18 19 22     1 0 2 0   0 0 0 0  0 2 0 2    4 13 5 9   0 0 0 0",
"19 16 21     0 0 3 2   0 4 3 0  0 0 10 0   0 4 11 0   0 0 8 0",
"20 21 16     1 1 2 0   0 0 0 0  4 7 5 3    0 8 0 8    0 0 0 0",
"21 22 19     0 0 3 1   0 6 1 0  0 10 0 0   0 14 1 0   0 8 0 0",
"22 23 18     1 0 2 0   0 0 0 0  2 0 2 0    12 5 13 1  0 0 0 0",
"23 20 17     0 0 3 0   0 0 2 0  0 4 11 0   0 0 10 0   0 4 9 0",
"24 25 28     1 2 3 0   0 0 0 0  4 7 5 1    0 10 0 0   0 8 0 0",
"25 26 31     0 0 3 0   0 2 0 0  0 10 0 0   0 14 5 1   0 8 0 0",
"26 27 30     1 0 3 0   0 0 0 0  0 0 2 0    0 0 10 0   4 5 13 1",
"27 24 29     0 0 3 2   0 0 0 2  0 4 5 11   0 0 0 10   0 0 0 8",
"28 29 24     1 1 3 0   0 0 0 0  4 5 7 1    0 0 10 0   0 0 8 0",
"29 30 27     0 0 3 1   0 2 0 0  0 14 5 1   0 10 0 0   0 8 0 0",
"30 31 26     1 0 3 0   0 0 0 0  0 2 0 0    0 10 0 0   4 13 5 1",
"31 28 25     0 0 3 0   0 0 0 2  0 0 0 10   0 4 5 11   0 0 0 8",
"32 33 36     1 2 3 0   0 0 0 0  0 2 0 0    6 13 5 1   8 0 0 0",
"33 34 39     0 0 3 0   0 0 2 0  0 0 10 0   0 4 11 0   0 0 12 1",
"34 35 38     1 0 3 0   0 0 0 0  0 0 0 2    4 5 7 9    0 0 8 0",
"35 32 37     0 0 3 2   0 4 3 0  0 0 14 1   0 0 10 0   0 0 8 0",
"36 37 32     1 1 3 0   0 0 0 0  0 0 2 0    4 5 13 3   0 0 0 8",
"37 38 35     0 0 3 1   0 0 6 1  0 4 11 0   0 0 10 0   0 0 8 0",
"38 39 34     1 0 3 0   0 0 0 0  2 0 0 0    12 7 5 1   0 8 0 0",
"39 36 33     0 0 3 0   0 0 2 0  0 0 10 0   0 0 14 1   0 4 9 0",
"40 41 44     1 2 3 0   0 0 0 0  0 0 2 0    6 5 13 1   8 0 0 0",
"41 42 47     0 0 3 0   0 0 2 0  0 4 11 0   0 0 10 0   0 0 12 1",
"42 43 46     1 0 3 0   0 0 0 0  0 0 0 2    4 7 5 9    0 8 0 0",
"43 40 45     0 0 3 2   0 4 3 0  0 0 10 0   0 0 14 1   0 0 8 0",
"44 45 40     1 1 3 0   0 0 0 0  0 2 0 0    4 13 5 3   0 0 0 8",
"45 46 43     0 0 3 1   0 0 6 1  0 0 10 0   0 4 11 0   0 0 8 0",
"46 47 42     1 0 3 0   0 0 0 0  2 0 0 0    12 5 7 1   0 0 8 0",
"47 44 41     0 0 3 0   0 0 2 0  0 0 14 1   0 0 10 0   0 4 9 0",
"48 49 52     1 2 2 0   0 0 0 0  6 5 3 0    8 0 12 1   0 0 0 0",
"49 50 55     0 0 3 0   0 0 2 0  0 6 9 0    0 10 0 0   0 12 1 0",
"50 51 54     1 0 2 0   0 0 0 0  4 3 0 2    0 12 5 9   0 0 0 0",
"51 48 53     0 0 3 2   0 4 3 0  0 0 10 0   0 6 9 0    0 8 0 0",
"52 53 48     1 1 2 0   0 0 0 0  0 6 5 3    4 9 0 8    0 0 0 0",
"53 54 51     0 0 3 1   0 6 1 0  0 10 0 0   0 12 3 0   0 0 8 0",
"54 55 50     1 0 2 0   0 0 0 0  2 0 6 1    12 5 9 0   0 0 0 0",
"55 52 49     0 0 3 0   0 2 0 0  0 12 3 0   0 0 10 0   0 4 9 0",
"56 57 60     1 2 3 0   0 0 0 0  4 5 3 0    0 0 10 0   0 0 12 1",
"57 58 63     0 0 3 2   0 0 0 2  0 6 5 9    0 10 0 0   0 8 0 0",
"58 59 62     1 0 3 0   0 0 0 0  4 3 0 0    0 10 0 0   0 12 5 1",
"59 56 61     0 0 3 0   0 0 0 2  0 0 0 10   0 6 5 9    0 8 0 0",
"60 61 56     1 1 3 0   0 0 0 0  0 6 5 1    0 10 0 0   4 9 0 0",
"61 62 59     0 0 3 0   0 2 0 0  0 10 0 0   0 12 5 3   0 0 0 8",
"62 63 58     1 0 3 0   0 0 0 0  0 0 6 1    0 0 10 0   4 5 9 0",
"63 60 57     0 0 3 1   0 2 0 0  0 12 5 3   0 0 0 10   0 0 0 8",
"64 65 68     1 2 3 0   0 0 0 0  4 5 3 0    0 0 14 1   0 0 8 0",
"65 66 71     0 0 3 2   0 0 2 0  0 6 13 1   0 10 0 0   0 8 0 0",
"66 67 70     1 0 3 0   0 0 0 0  0 2 0 0    4 11 0 0   0 12 5 1",
"67 64 69     0 0 3 0   0 0 0 2  0 0 0 10   0 4 7 9    0 0 8 0",
"68 69 64     1 1 3 0   0 0 0 0  0 6 5 1    4 11 0 0   0 8 0 0",
"69 70 67     0 0 3 0   0 2 0 0  0 10 0 0   0 12 7 1   0 0 8 0",
"70 71 66     1 0 3 0   0 0 0 0  0 0 2 0    0 0 14 1   4 5 9 0",
"71 68 65     0 0 3 1   0 0 2 0  0 4 13 3   0 0 0 10   0 0 0 8",
"72 73 76     1 2 3 0   0 0 0 0  4 5 3 0    0 0 12 3   0 0 0 8",
"73 74 79     0 0 3 2   0 0 6 1  0 6 9 0    0 10 0 0   0 8 0 0",
"74 75 78     1 0 3 0   0 0 0 0  2 0 0 0    12 3 0 0   0 12 5 1",
"75 72 77     0 0 3 0   0 0 0 2  0 0 0 10   0 0 6 9    0 4 9 0",
"76 77 72     1 1 3 0   0 0 0 0  0 6 5 1    6 9 0 0    8 0 0 0",
"77 78 75     0 0 3 0   0 2 0 0  0 10 0 0   0 12 3 0   0 0 12 1",
"78 79 74     1 0 3 0   0 0 0 0  0 0 0 2    0 0 6 9    4 5 9 0",
"79 76 73     0 0 3 1   0 4 3 0  0 0 12 3   0 0 0 10   0 0 0 8",
"80 81 84     1 2 3 0   0 0 0 0  4 3 0 0    0 14 5 1   0 8 0 0",
"81 82 87     0 0 3 0   0 0 2 0  0 0 10 0   0 6 13 1   0 8 0 0",
"82 83 86     1 0 3 0   0 0 0 0  0 0 2 0    4 5 11 0   0 0 12 1",
"83 80 85     0 0 3 2   0 0 0 2  0 4 7 9    0 0 10 0   0 0 8 0",
"84 85 80     1 1 3 0   0 0 0 0  0 0 6 1    4 5 11 0   0 0 8 0",
"85 86 83     0 0 3 1   0 2 0 0  0 12 7 1   0 0 10 0   0 0 8 0",
"86 87 82     1 0 3 0   0 0 0 0  0 2 0 0    0 14 5 1   4 9 0 0",
"87 84 81     0 0 3 0   0 0 2 0  0 0 10 0   0 4 13 3   0 0 0 8",
"88 89 92     1 2 3 0   0 0 0 0  4 3 0 0    0 12 7 1   0 0 8 0",
"89 90 95     0 0 3 0   0 0 2 0  0 0 14 1   0 6 9 0    0 8 0 0",
"90 91 94     1 0 3 0   0 0 0 0  0 2 0 0    4 13 3 0   0 0 12 1",
"91 88 93     0 0 3 2   0 0 0 2  0 0 6 9    0 4 11 0   0 0 8 0",
"92 93 88     1 1 3 0   0 0 0 0  0 0 6 1    4 7 9 0    0 8 0 0",
"93 94 91     0 0 3 1   0 2 0 0  0 12 3 0   0 0 14 1   0 0 8 0",
"94 95 90     1 0 3 0   0 0 0 0  0 0 2 0    0 6 13 1   4 9 0 0",
"95 92 89     0 0 3 0   0 0 2 0  0 4 11 0   0 0 12 3   0 0 0 8",
"96 97 100    1 2 3 0   0 0 0 0  4 3 0 0    0 12 5 3   0 0 0 8",
"97 98 103    0 0 3 2   0 0 6 1  0 0 10 0   0 6 9 0    0 8 0 0",
"98 99 102    1 0 3 0   0 0 0 0  2 0 0 0    12 5 3 0   0 0 12 1",
"99 96 101    0 0 3 0   0 0 0 2  0 0 6 9    0 0 10 0   0 4 9 0",
"100 101 96   1 1 3 0   0 0 0 0  0 0 6 1    6 5 9 0    8 0 0 0",
"101 102 99   0 0 3 0   0 2 0 0  0 12 3 0   0 0 10 0   0 0 12 1",
"102 103 98   1 0 3 0   0 0 0 0  0 0 0 2    0 6 5 9    4 9 0 0",
"103 100 97   0 0 3 1   0 4 3 0  0 0 10 0   0 0 12 3   0 0 0 8",
"104 105 104  1 2 2 0   0 0 0 0  4 7 7 1    0 12 9 0   0 0 0 0",
"105 106 107  0 0 3 2   0 2 0 0  0 14 3 0   0 14 9 0   0 8 0 0",
"106 107 106  1 0 2 0   0 0 0 0  0 6 3 0    4 13 13 1  0 0 0 0",
"107 104 105  0 0 3 0   0 0 2 0  0 6 11 0   0 12 11 0  0 0 8 0",
"108 109 108  1 2 2 0   0 0 0 0  6 5 5 3    8 0 0 8    0 0 0 0",
"109 110 111  0 0 3 2   0 6 1 0  0 10 0 0   0 10 0 0   0 12 1 0",
"110 111 110  1 0 2 0   0 0 0 0  2 0 0 2    12 5 5 9   0 0 0 0",
"111 108 109  0 0 3 0   0 4 3 0  0 0 10 0   0 0 10 0   0 4 9 0",
"112 113 114  1 2 2 0   0 0 0 0  4 7 3 0    0 12 13 1  0 0 0 0",
"113 112 115  0 0 3 2   0 0 2 0  0 6 11 0   0 14 9 0   0 8 0 0",
"114 115 112  1 1 2 0   0 0 0 0  0 6 7 1    4 13 9 0   0 0 0 0",
"115 114 113  0 0 3 1   0 2 0 0  0 14 3 0   0 12 11 0  0 0 8 0",
"116 117 118  1 2 3 0   0 0 0 0  4 3 0 0    0 12 3 0   0 0 12 1",
"117 116 119  0 0 3 2   0 0 0 2  0 0 6 9    0 6 9 0    0 8 0 0",
"118 119 116  1 1 3 0   0 0 0 0  0 0 6 1    0 6 9 0    4 9 0 0",
"119 118 117  0 0 3 1   0 2 0 0  0 12 3 0   0 0 12 3   0 0 0 8",
"120 121 122  1 2 3 0   0 0 0 0  2 0 0 0    14 5 5 1   8 0 0 0",
"121 122 121  0 0 3 0   0 0 2 0  0 0 10 0   0 0 10 0   0 4 13 1",
"122 123 120  1 0 3 0   0 0 0 0  0 0 0 2    4 5 5 11   0 0 0 8",
"123 120 123  0 0 3 2   0 4 7 1  0 0 10 0   0 0 10 0   0 0 8 0",
"124 125 126  1 2 3 0   0 0 0 0  0 2 0 0    4 15 5 1   0 8 0 0",
"125 126 125  0 0 3 0   0 0 2 0  0 0 10 0   0 4 15 1   0 0 8 0",
"126 127 124  1 0 3 0   0 0 0 0  0 0 2 0    4 5 15 1   0 0 8 0",
"127 124 127  0 0 3 2   0 0 2 0  0 4 15 1   0 0 10 0   0 0 8 0",
"128 129 130  1 2 3 0   0 0 0 0  0 2 0 0    4 13 7 1   0 0 8 0",
"129 128 131  0 0 3 2   0 0 2 0  0 0 14 1   0 4 11 0   0 0 8 0",
"130 131 128  1 1 3 0   0 0 0 0  0 0 2 0    4 7 13 1   0 8 0 0",
"131 128 129  0 0 3 1   0 0 2 0  0 4 11 0   0 0 14 1   0 0 8 0",
"132 133 134  1 2 3 0   0 0 0 0  2 0 0 0    12 5 5 3   0 0 0 8",
"133 132 135  0 0 3 2   0 0 6 1  0 0 10 0   0 0 10 0   0 4 9 0",
"134 135 132  1 1 3 0   0 0 0 0  0 0 0 2    6 5 5 9    8 0 0 0",
"135 134 133  0 0 3 1   0 4 3 0  0 0 10 0   0 0 10 0   0 0 12 1",
"* 5",
"# 5 2",
"0 1 0  2 2 2 0   0 0 0 0 0  0 0 0 0 0   4 5 5 5 1   0 0 0 0 0   0 0 0 0 0",
"1 0 1  0 0 4 2   0 0 2 0 0  0 0 10 0 0  0 0 10 0 0  0 0 10 0 0  0 0 8 0 0",
"# 6 32",
"0 1 4     2 2 3 0   0 0 0 0 0  0 0 0 0 0   6 5 5 5 1   8 0 0 0 0   0 0 0 0 0",
"1 2 7     0 0 4 0   0 0 2 0 0  0 0 10 0 0  0 0 10 0 0  0 0 10 0 0  0 0 12 1 0",
"2 3 6     2 0 3 0   0 0 0 0 0  0 0 0 0 0   0 0 0 0 2   4 5 5 5 9   0 0 0 0 0",
"3 0 5     0 0 4 2   0 0 4 3 0  0 0 0 10 0  0 0 0 10 0  0 0 0 10 0  0 0 0 8 0",
"4 5 0     2 1 3 0   0 0 0 0 0  0 0 0 0 0   4 5 5 5 3   0 0 0 0 8   0 0 0 0 0",
"5 6 3     0 0 4 1   0 0 6 1 0  0 0 10 0 0  0 0 10 0 0  0 0 10 0 0  0 0 8 0 0",
"6 7 2     2 0 3 0   0 0 0 0 0  0 0 0 0 0   2 0 0 0 0   12 5 5 5 1  0 0 0 0 0",
"7 4 1     0 0 4 0   0 0 0 2 0  0 0 0 10 0  0 0 0 10 0  0 0 0 10 0  0 0 4 9 0",
"8 9 12    2 2 3 0   0 0 0 0 0  0 0 0 0 0   4 7 5 5 1   0 8 0 0 0   0 0 0 0 0",
"9 10 15   0 0 4 0   0 0 2 0 0  0 0 10 0 0  0 0 10 0 0  0 0 14 1 0  0 0 8 0 0",
"10 11 14  2 0 3 0   0 0 0 0 0  0 0 0 0 0   0 0 0 2 0   4 5 5 13 1  0 0 0 0 0",
"11 8 13   0 0 4 2   0 0 0 2 0  0 0 4 11 0  0 0 0 10 0  0 0 0 10 0  0 0 0 8 0",
"12 13 8   2 1 3 0   0 0 0 0 0  0 0 0 0 0   4 5 5 7 1   0 0 0 8 0   0 0 0 0 0",
"13 14 11  0 0 4 1   0 0 2 0 0  0 0 14 1 0  0 0 10 0 0  0 0 10 0 0  0 0 8 0 0",
"14 15 10  2 0 3 0   0 0 0 0 0  0 0 0 0 0   0 2 0 0 0   4 13 5 5 1  0 0 0 0 0",
"15 12 9   0 0 4 0   0 0 0 2 0  0 0 0 10 0  0 0 0 10 0  0 0 4 11 0  0 0 0 8 0",
"16 17 20  2 2 3 0   0 0 0 0 0  0 0 0 0 0   4 5 5 3 0   0 0 0 12 1  0 0 0 0 0",
"17 18 23  0 0 4 2   0 0 0 2 0  0 0 6 9 0   0 0 10 0 0  0 0 10 0 0  0 0 8 0 0",
"18 19 22  2 0 3 0   0 0 0 0 0  0 0 0 0 0   4 3 0 0 0   0 12 5 5 1  0 0 0 0 0",
"19 16 21  0 0 4 0   0 0 0 2 0  0 0 0 10 0  0 0 0 10 0  0 0 6 9 0   0 0 8 0 0",
"20 21 16  2 1 3 0   0 0 0 0 0  0 0 0 0 0   0 6 5 5 1   4 9 0 0 0   0 0 0 0 0",
"21 22 19  0 0 4 0   0 0 2 0 0  0 0 10 0 0  0 0 10 0 0  0 0 12 3 0  0 0 0 8 0",
"22 23 18  2 0 3 0   0 0 0 0 0  0 0 0 0 0   0 0 0 6 1   4 5 5 9 0   0 0 0 0 0",
"23 20 17  0 0 4 1   0 0 2 0 0  0 0 12 3 0  0 0 0 10 0  0 0 0 10 0  0 0 0 8 0",
"24 25 24  2 2 3 0   0 0 0 0 0  0 0 0 0 0   4 5 7 5 1   0 0 8 0 0   0 0 0 0 0",
"25 26 27  0 0 4 2   0 0 2 0 0  0 0 10 0 0  0 0 14 1 0  0 0 10 0 0  0 0 8 0 0",
"26 27 26  2 0 3 0   0 0 0 0 0  0 0 0 0 0   0 0 2 0 0   4 5 13 5 1  0 0 0 0 0",
"27 24 25  0 0 4 0   0 0 0 2 0  0 0 0 10 0  0 0 4 11 0  0 0 0 10 0  0 0 0 8 0",
"28 29 30  2 2 3 0   0 0 0 0 0  0 0 0 0 0   4 5 3 0 0   0 0 12 5 1  0 0 0 0 0",
"29 28 31  0 0 4 2   0 0 0 2 0  0 0 0 10 0  0 0 6 9 0   0 0 10 0 0  0 0 8 0 0",
"30 31 28  2 1 3 0   0 0 0 0 0  0 0 0 0 0   0 0 6 5 1   4 5 9 0 0   0 0 0 0 0",
"31 30 29  0 0 4 1   0 0 2 0 0  0 0 10 0 0  0 0 12 3 0  0 0 0 10 0  0 0 0 8 0",
"* 6",
"# 6 2",
"0 1 0  3 2 3 0   0 0 0 0 0 0   0 0 0 0 0 0   0 0 0 0 0 0",
"                 4 5 5 5 5 1   0 0 0 0 0 0   0 0 0 0 0 0",
"1 0 1  0 0 5 2   0 0 0 2 0 0   0 0 0 10 0 0  0 0 0 10 0 0",
"                 0 0 0 10 0 0  0 0 0 10 0 0  0 0 0 8 0 0"};
