/* Copyright G.Dauphin Sep 97 */

#include "../config.h"
#include "HTMLP.h"
#include "HTMLPutil.h"
#include "HTMLframe.h"
#include <stdlib.h>

extern MarkInfo *NULL_ANCHOR_PTR;

/* Basically we show the urls that appear within the frameset tag
 * as urls and add some text explaining that these are the urls they
 * were supposed to see as frames.  We also show the NOFRAMES stuff. */

void FramePlace(HTMLWidget hw, MarkInfo *mptr, PhotoComposeContext *pcc)
{
    char *sptr;
    char *nptr;

    switch (mptr->type) {
	case M_FRAME:
		pcc->anchor_tag_ptr = mptr;
		sptr = mptr->anc_href =
			ParseMarkTag(mptr->start, MT_FRAME, "SRC");
		if (sptr) {
			pcc->fg = hw->html.anchor_fg;
			pcc->underline_number = hw->html.num_anchor_underlines;
			pcc->dashed_underlines = hw->html.dashed_anchor_lines;
			if (hw->html.previously_visited_test != NULL) {
				if ((*(visitTestProc)
				   (hw->html.previously_visited_test))
				   ((Widget)hw, sptr)) {   
					pcc->fg = hw->html.visitedAnchor_fg;
					pcc->underline_number = hw->html.num_visitedAnchor_underlines;            
					pcc->dashed_underlines = hw->html.dashed_visitedAnchor_lines;                             
				} else {
					pcc->fg = hw->html.anchor_fg;
					pcc->underline_number = hw->html.num_anchor_underlines; 
					pcc->dashed_underlines = hw->html.dashed_anchor_lines;
				}
			} else {       
				pcc->fg = hw->html.anchor_fg;
				pcc->underline_number = hw->html.num_anchor_underlines;
				pcc->dashed_underlines = hw->html.dashed_anchor_lines;
			} 
		}
		if (pcc->in_underlined) {
			pcc->dashed_underlines = False;
			if (!pcc->underline_number)
				pcc->underline_number = 1;
		}                      

		ConditionalLineFeed(hw, 1, pcc);
		if (sptr) {
			mptr->text = sptr;
			PartOfTextPlace(hw, mptr, pcc);
		}

		pcc->fg = hw->manager.foreground;
		pcc->underline_number = pcc->in_underlined;
		pcc->dashed_underlines = False;
		pcc->anchor_tag_ptr = NULL_ANCHOR_PTR;

		nptr = ParseMarkTag(mptr->start, MT_FRAME, "NAME");
		if (nptr && sptr) {
			pcc->x += 10;
			mptr->text = nptr;
			PartOfTextPlace(hw, mptr, pcc);
			free(nptr);
		}
		mptr->text = NULL;
		break;

	case M_FRAMESET:
		if (mptr->is_end) {
			if (pcc->frameset) {
				pcc->frameset--;
				ConditionalLineFeed(hw, 1, pcc);
				mptr->text = "-----------------------";
				PartOfTextPlace(hw, mptr, pcc);
			}
		} else {
			pcc->frameset++;
			ConditionalLineFeed(hw, 1, pcc);
			mptr->text = "------- Frame Set -------";
			PartOfTextPlace(hw, mptr, pcc);
		}
		mptr->text = NULL;
		break;

	case M_NOFRAMES:
		if (mptr->is_end) {
			if (pcc->noframes) {
				pcc->noframes--;
				ConditionalLineFeed(hw, 1, pcc);
				mptr->text = "*************************";
				PartOfTextPlace(hw, mptr, pcc);
				ConditionalLineFeed(hw, 1, pcc);
			}
		} else {
			pcc->noframes++;
			ConditionalLineFeed(hw, 1, pcc);
			mptr->text = "***** No Frames View *****";
			PartOfTextPlace(hw, mptr, pcc);
			ConditionalLineFeed(hw, 1, pcc);
		}
		mptr->text = NULL;
		break;

	default:
		break;
    }
}
