= /*	HyperText Tranfer Protocol	- Client implementation		HTTP.c  **	==========================  */ #include "../config.h" #include "HTTP.h"    #define HTTP_VERSION	"HTTP/1.0"    #define HTTP_PORT    80  #define HTTPS_PORT  443   B #define INIT_LINE_SIZE		1024	/* Start with line buffer this big */6 #define LINE_EXTEND_THRESH	256	/* Minimum read size */? #define VERSION_LENGTH 		20	/* For returned protocol version */    #ifdef HAVE_SSL  #include <openssl/ssl.h> #include <openssl/crypto.h>  #endif   #include "HTParse.h" #include "HTTCP.h" #include "HTFormat.h"  #include "HTFile.h"  #include <ctype.h> #include "HTAlert.h" #include "HTMIME.h"  #include "HTML.h"  #include "HTInit.h"  #include "HTAABrow.h"  #include "HTCookie.h"    int useKeepAlive = 1;  extern int securityType; int sendAgent = 1; int sendReferer = 1; extern int selectedAgent;  extern char **agent;9 extern int retried_with_new_nonce;  /* For digest auth */  extern char *redirecting_url; # int broken_Microsoft_crap_hack = 0;  extern int HTSetCookies;   #ifndef DISABLE_TRACE  int httpTrace = 0; int www2Trace = 0; #endif   char **extra_headers = NULL;  ? /* I know...I know...a lib should not depend on a program... */  #define _LIBWWW2   struct _HTStream   {    HTStreamClass * isa; };   /* For browser to call */ ' void HT_SetExtraHeaders(char **headers)  {  	extra_headers = headers;  }    /* Defined in src/mo-www.c */ / extern char *HTAppName;		/* Application name */  /* Defined in src/gui.c */4 extern char *HTAppVersion;	/* Application version */1 extern char *HTReferer;		/* HTTP referer field */   8 /* Variables that control whether we do a POST or a GET,4    and if a POST, what and how we POST.  And HEAD */ int do_head = 0; int do_post = 0; int do_put = 0;  int put_file_size = 0; int bad_location = 0; 
 FILE *put_fp;  char *post_content_type = NULL;  char *post_data = NULL; A extern BOOL using_gateway;    /* Are we using an HTTP gateway? */ 8 extern char *proxy_host_fix;  /* For the Host: header */G extern BOOL using_proxy;      /* Are we using an HTTP proxy gateway? */ B PUBLIC BOOL reloading = NO;   /* Did someone say, "RELOAD!?!?!" */  # PUBLIC char *encrypt_cipher = NULL;  PUBLIC int encrypt_bits = 0;   #ifdef HAVE_SSL % PRIVATE SSL *keepalive_handle = NULL; - PUBLIC SSL_CTX *ssl_ctx = NULL;	/* SSL ctx */     PRIVATE void free_ssl_ctx NOARGS {      if (ssl_ctx)         SSL_CTX_free(ssl_ctx); }   " PRIVATE SSL *HTGetSSLHandle NOARGS {      if (ssl_ctx == NULL) {
         /* 	 *  First time only.  	 */ 	SSLeay_add_ssl_algorithms(); / 	ssl_ctx = SSL_CTX_new(SSLv23_client_method()); * 	SSL_CTX_set_options(ssl_ctx, SSL_OP_ALL);+ 	SSL_CTX_set_default_verify_paths(ssl_ctx);  	atexit(free_ssl_ctx);     }      return(SSL_new(ssl_ctx));  }   0 #define HTTP_NETREAD(sock, buff, size, handle) \D 	(handle ? SSL_read(handle, buff, size) : NETREAD(sock, buff, size))1 #define HTTP_NETWRITE(sock, buff, size, handle) \ F 	(handle ? SSL_write(handle, buff, size) : NETWRITE(sock, buff, size))& #define HTTP_NETCLOSE(sock, handle)  \A 	{ NETCLOSE(sock); if (handle) SSL_free(handle); handle = NULL; }  #else   3 #define HTTP_NETREAD(a, b, c, d)   NETREAD(a, b, c) 4 #define HTTP_NETWRITE(a, b, c, d)  NETWRITE(a, b, c)* #define HTTP_NETCLOSE(a, b)	   NETCLOSE(a) #endif /* HAVE_SSL */   2 PRIVATE void TrimDoubleQuotes ARGS1(char *, value) { 
     int i;     char *cp = value;   $     if (!(cp && *cp) || *cp != '\"')         return;        i = strlen(cp);      if (cp[(i - 1)] != '\"')         return;      else         cp[(i - 1)] = '\0';        for (i = 0; value[i]; i++)         value[i] = cp[(i + 1)];  }   1 /*		Load Document from HTTP Server			HTLoadHTTP() " **		============================== **< **	Given a hypertext address, this routine loads a document. ** ** ** On entry,> **	arg	is the hypertext reference of the article to be loaded. ** ** On exit, 0 **	returns	>=0	If no error, a good socket number
 **		<0	Error.  **F **	The socket must be closed by the caller after the document has been **	read. ** */  ' /* Where was our last connection to? */  static int lsocket = -1; static char *addr = NULL;    PUBLIC int HTLoadHTTP ARGS4 (  	char *, 		arg,  	HTParentAnchor *,	anAnchor, 	HTFormat,		format_out,  	HTStream *,		sink)  { 0   int s;			/* Socket number for returned data */   WWW_CONST char *url = arg;0   char *command = NULL;		/* The whole command */)   char *eol;			/* End of line if found */ 4   char *start_of_data;		/* Start of body of reply */    int status;			/* tcp return */   int bytes_already_read; 1   char crlf[3];			/* A CR LF equivalent string */ +   HTStream *target;		/* Unconverted data */ ;   HTFormat format_in;		/* Format arriving in the message */    :   BOOL had_header;		/* Have we had at least one header? */   char *line_buffer;   char *line_kept_clean;1   BOOL extensions;		/* Assume good HTTP server */    int compressed; >   char line[2048];		/* Bumped up to cover Kerb huge headers */)   int length, rawlength, done_length, rv;    int already_retrying = 0;    int return_nothing;    int i;   int keepingalive = 0; 
   char *p;   int statusError = 0;   char tmpbuf[4096];   char *begin_ptr, *tmp_ptr;   int env_length; E   BOOL auth_proxy = NO;         /* Generate a proxy authorization. */  #ifdef HAVE_SSL E   BOOL do_connect = FALSE;	/* Are we going to use a proxy tunnel ? */ H   BOOL did_connect = FALSE;	/* Are we actually using a proxy tunnel ? */A   WWW_CONST char *connect_url = NULL; /* The URL being proxied */ 9   char *connect_host = NULL;	/* The host being proxied */ +   SSL *handle = NULL;		/* The SSL handle */    BOOL try_tls = TRUE; #else    void *handle = NULL; #endif     if (!arg || !*arg) {       if (!arg)            status = -3;
       else           status = -2;!       HTProgress("Bad request.");        goto done;   }    #ifdef HAVE_SSL 3   if (using_proxy && !strncmp(arg, "http://", 7)) { 8       if (connect_url = strstr((arg + 7), "https://")) { 	  do_connect = TRUE; < 	  connect_host = HTParse(connect_url, "https", PARSE_HOST);$ 	  if (!strchr(connect_host, ':')) {( 	      sprintf(line, ":%d", HTTPS_PORT);' 	      StrAllocCat(connect_host, line);  	  } #ifndef DISABLE_TRACE  	  if (httpTrace) { = 		fprintf(stderr, "HTTP: connect_url = '%s'\n", connect_url); ? 		fprintf(stderr, "HTTP: connect_host = '%s'\n", connect_host);  	  } #endif       }    }  #endif      sprintf(crlf, "%c%c", CR, LF);  .   /* At this point, we're talking HTTP/1.0. */   extensions = YES;     try_again: ;   /* All initializations are moved down here from up above, $      so we can start over here... */
   eol = 0;   bytes_already_read = 0;    had_header = NO;
   length = 0;    compressed = 0;    target = NULL;   line_buffer = NULL;    line_kept_clean = NULL;    return_nothing = 0;   G 	/* Okay... addr looks like http://hagbard.ncsa.uiuc.edu/blah/etc.html  " 	 * lets crop it at the 3rd '/' */' 	for (p = url, i=0; *p && i != 3; p++)   		if (*p == '/') i++;    	if (i == 3)3 		i = p-url; /* i = length not counting last '/' */  	else  		i = 0;  > 	if ((lsocket != -1) && i && addr && !strncmp(addr, url, i)) {B 		/* Keepalive active and addresses match -- try the old socket */ 		s = lsocket; #ifdef HAVE_SSL  		handle = keepalive_handle; 		if (handle) {    			StrAllocCopy(encrypt_cipher,$ 				(char *)SSL_get_cipher(handle));4 			encrypt_bits = SSL_get_cipher_bits(handle, NULL);
 		} else { 			encrypt_cipher = NULL;  		}  #endif< 		/* Flag in case of network error due to server timeout */  		keepingalive = 1; 0 		lsocket = -1; /* Prevent looping on failure */ #ifndef DISABLE_TRACE  		if (httpTrace) 			fprintf(stderr,- 				"HTTP: Keep-Alive reusing '%s'\n", addr);  #endif	 	} else {  		if (addr)  			free(addr);- 		/* Save the address for next time around */  		addr = malloc(i+1);  		strncpy(addr, url, i); 		*(addr + i) = 0;  ; 		keepingalive = 0; /* Just normal opening of the socket */  		if (lsocket != -1) { 			/* No socket leaks here */ , 			HTTP_NETCLOSE(lsocket, keepalive_handle);. 			lsocket = -1; /* Wait tiserver says okay */ 		}  #ifndef DISABLE_TRACE  		if (httpTrace); 			fprintf(stderr, "HTTP: Keep-Alive saving '%s'\n", addr);  #endif 	}     if (!keepingalive) {&       if (!strncmp(url, "https", 5)) { #ifdef HAVE_SSL  #ifndef DISABLE_TRACE            if (httpTrace)8 	      fprintf(stderr, "HTTP: Doing secure connect.\n"); #endif6 	  status = HTDoConnect(url, "HTTPS", HTTPS_PORT, &s);       } else {;           status = HTDoConnect(url, "HTTP", HTTP_PORT, &s);        }  #else $           application_user_feedback(: 		"This client does not contain support for HTTPS URLs.");!           status = HT_NOT_LOADED;            goto done;       } 7       status = HTDoConnect(url, "HTTP", HTTP_PORT, &s);  #endif%       if (status == HT_INTERRUPTED) {  	  /* Interrupt cleanly. */  #ifndef DISABLE_TRACE  	  if (httpTrace)  	      fprintf(stderr,? 		      "HTTP: Interrupted on connect; recovering cleanly.\n");  #endif) 	  HTProgress("Connection interrupted."); ) 	  /* status already == HT_INTERRUPTED */ 
 	  goto done;        }        if (status < 0) {  #ifndef DISABLE_TRACE  	  if (httpTrace)  	      fprintf(stderr,  < 		  "HTTP: Cannot connect to host for `%s' (errno = %d).\n", 		  url, errno); #endif3 	  HTProgress("Unable to connect to remote host.");  	  status = HT_NO_DATA; 
 	  goto done; 
       }      }  #ifdef HAVE_SSL  use_tunnel:    /*!   ** If this is an https document    ** then do the SSL stuff here    */D   if (did_connect || (!strncmp(url, "https", 5) && !keepingalive)) {        handle = HTGetSSLHandle();       if (!did_connect)  	  keepalive_handle = handle;        SSL_set_fd(handle, s);       if (!try_tls) +           handle->options|=SSL_OP_NO_TLSv1; #       status = SSL_connect(handle);          if (status <= 0) { 	  if (try_tls) {  #ifndef DISABLE_TRACE  	      if (httpTrace) F 	          fprintf(stderr, "HTTP: Retrying connection without TLS\n"); #endif* 	      HTProgress("Retrying connection."); 	      try_tls = FALSE;  	      if (did_connect) $ 	          HTTP_NETCLOSE(s, handle);       	      goto try_again; 	  } else {  #ifndef DISABLE_TRACE  	      if (httpTrace) !                   fprintf(stderr, P                      "HTTP: Failed SSL handshake for host '%s' (SSLerr = %d)\n", 		     url, status); #endifL       	      HTProgress("Unable to make secure connection to remote host."); 	      if (did_connect) $ 	          HTTP_NETCLOSE(s, handle);$       	      status = HT_NOT_LOADED;       	      goto done;  	  }       } C       StrAllocCopy(encrypt_cipher, (char *)SSL_get_cipher(handle)); 7       encrypt_bits = SSL_get_cipher_bits(handle, NULL);    #ifdef NOTDEFINED .       if (strcmp(HTParse(url, "", PARSE_HOST),"       		 strstr(X509_NAME_oneline( 		 	X509_get_subject_name() 				handle->session->peer)),"/CN=")+4)) { 5 	  HTAlert("Certificate is for different host name"); $ 	  HTAlert(strstr(X509_NAME_oneline( 	  		 X509_get_subject_name(( 			 	handle->session->peer)),"/CN=")+4);       }  #endif   }  #endif  $   /*	Ask that node for the document,$    *	omitting the host name & anchor
    */            { >     char *p1 = HTParse(url, "", PARSE_PATH|PARSE_PUNCTUATION);   #ifdef HAVE_SSL      if (do_connect) (       StrAllocCopy(command, "CONNECT ");     else #endif     if (do_post && !do_put) %       StrAllocCopy(command, "POST ");      else if (do_post && do_put) $       StrAllocCopy(command, "PUT ");     else if (do_head) %       StrAllocCopy(command, "HEAD ");      else$       StrAllocCopy(command, "GET ");       /*;      * For a gateway, the beginning '/' on the request must ;      * be stripped before appending to the gateway address.       */  #ifdef HAVE_SSL 9     if ((using_gateway || using_proxy) && !did_connect) {  	if (do_connect)( 	    StrAllocCat(command, connect_host); 	else   	    StrAllocCat(command, p1+1);     }  #else %     if (using_gateway || using_proxy) #         StrAllocCat(command, p1+1);  #endif     else!         StrAllocCat(command, p1); 
     free(p1);    }    if (extensions) {         StrAllocCat(command, " ");)       StrAllocCat(command, HTTP_VERSION);    }    8   StrAllocCat(command, crlf);	/* CR LF, as in rfc 977 */     if (extensions)      {        int n, i, len;              if (!HTPresentations)  	 HTFormatInit(); (       n = HTList_count(HTPresentations);         len = strlen(command);         sprintf(line, "Accept:");         env_length = strlen(line);!       StrAllocCat(command, line);         begin_ptr = command + len;         for (i=0; i < n; i++) { F           HTPresentation * pres = HTList_objectAt(HTPresentations, i);-           if (pres->rep_out == WWW_PRESENT) { 0 		sprintf(line, " %s,", HTAtom_name(pres->rep)); 		env_length += strlen(line);  		StrAllocCat(command, line);  		if (env_length > 200) { 3 			if ((tmp_ptr = strrchr(command, ',')) != NULL) {  				*tmp_ptr = '\0'; 			} 			StrAllocCat(command, crlf);   			len = strlen(command);  			sprintf(line, "Accept:"); 			env_length = strlen(line);  			StrAllocCat(command, line); 			begin_ptr = command + len;  		}            }        } ,       /* This gets rid of the last comma. */6       if ((tmp_ptr = strrchr(command, ',')) != NULL) { 	*tmp_ptr = '\0';  	StrAllocCat(command, crlf);;       } else { /* No accept stuff...get rid of "Accept:" */  	begin_ptr = '\0';       }   =       /* If reloading, send no-cache pragma to proxy servers. =        * Original patch from Ari L. <luotonen@dxcern.cern.ch>         *I        * Also send it as a Cache-Control header for HTTP/1.1. (from LYNX) 	        */        if (reloading) {/ 	sprintf(line, "Pragma: no-cache%c%c", CR, LF);  	StrAllocCat(command, line);6 	sprintf(line, "Cache-Control: no-cache%c%c", CR, LF); 	StrAllocCat(command, line);       }   N       /* This is just used for "not" sending this header on a proxy request */&       if (useKeepAlive && !do_head) { 5 	sprintf(line, "Connection: Keep-Alive%c%c", CR, LF);  	StrAllocCat(command, line);       } else if (do_head) { 0 	sprintf(line, "Connection: close%c%c", CR, LF); 	StrAllocCat(command, line);       }          if (sendAgent) {C 	sprintf(line, "User-Agent: %s%c%c", agent[selectedAgent], CR, LF);  /*3 	sprintf(line, "User-Agent:  %s/%s  libwww/%s%c%c", $ 		HTAppName ? HTAppName : "unknown",& 		HTAppVersion ? HTAppVersion : "0.0", 		HTLibraryVersion, CR, LF); */ 	StrAllocCat(command, line);       }   7       /* HTTP Referer field, specifies back-link URL */ %       if (sendReferer && HTReferer) { 6 		sprintf(line, "Referer: %s%c%c", HTReferer, CR, LF); 		StrAllocCat(command, line);  		HTReferer = NULL;        }          {  	char *tmp, *startPtr, *endPtr;   ! 	/* addr is always in URL form */ . 	if (addr && !using_proxy && !using_gateway) { 		tmp = strdup(addr);  		startPtr = strchr(tmp, '/'); 		if (startPtr) { 3 			startPtr += 2; /* Now at begining of hostname */  			if (*startPtr) { # 				endPtr = strchr(startPtr, ':');  				if (!endPtr) {$ 					endPtr = strchr(startPtr, '/'); 					if (endPtr && *endPtr) {  						*endPtr = '\0';  					} 				} else { 					*endPtr = '\0'; 				}   4 				sprintf(line, "Host: %s%c%c", startPtr, CR, LF); 				StrAllocCat(command, line);    				free(tmp);# 				tmp = startPtr = endPtr = NULL;  			} 		} + 	} else if (using_proxy || using_gateway) { 8 		sprintf(line, "Host: %s%c%c", proxy_host_fix, CR, LF); 		StrAllocCat(command, line);  	}       }   "       /* HTTP Extension headers */       /* Domain Restriction */H       sprintf(line, "Extension: Notify-Domain-Restriction%c%c", CR, LF);!       StrAllocCat(command, line);   5       /* Allow arbitrary headers sent from browser */        if (extra_headers) {
 	      int h; ) 	      for (h=0; extra_headers[h]; h++) { : 		      sprintf(line, "%s%c%c", extra_headers[h], CR, LF);# 		      StrAllocCat(command, line);  	      }       }          {          char *abspath;         char *docname;         char *hostname;          char *colon;         int portnumber;          char *auth;  	char *cookie = NULL; G 	BOOL secure = (strncmp(anAnchor->address, "https", 5) ? FALSE : TRUE);          A         abspath = HTParse(arg, "", PARSE_PATH|PARSE_PUNCTUATION); /         docname = HTParse(arg, "", PARSE_PATH); 0         hostname = HTParse(arg, "", PARSE_HOST);B         if (hostname && NULL != (colon = strchr(hostname, ':'))) {9             *(colon++) = '\0';	/* Chop off port number */ %             portnumber = atoi(colon); ( 	} else if (!strncmp(arg, "https", 5)) { 	    portnumber = HTTPS_PORT;          } else { 	    portnumber = HTTP_PORT; 	}          	/* , 	**  Add Authorization, Proxy-Authorization,* 	**  and/or Cookie headers, if applicable. 	*/  	if (using_proxy) {  	    /* 3 	    **	If we are using a proxy, first determine if 1 	    **	we should include an Authorization header 0 	    **	for the ultimate target of this request. 	    */ ' 	    char *host2 = NULL, *path2 = NULL; I 	    int port2 = (strncmp(docname, "https", 5) ? HTTP_PORT : HTTPS_PORT); . 	    host2 = HTParse(docname, "", PARSE_HOST);@ 	    path2 = HTParse(docname, "", PARSE_PATH|PARSE_PUNCTUATION); 	    if (host2) { - 		if ((colon = strchr(host2, ':')) != NULL) { ' 		    /* Use non-default port number */  		    *colon = '\0'; 		    colon++; 		    port2 = atoi(colon); 		}  	    } 	    /* 6 	    **	This composeAuth() does file access, i.e., for1 	    **	the ultimate target of the request. - AJL  	    */  	    auth_proxy = NO; F 	    if ((auth = HTAA_composeAuth(host2, port2, path2, auth_proxy)) != 		 NULL && *auth) {  		/*/ 		**  If auth is not NULL nor zero-length, it's - 		**  an Authorization header to be included.  		*/( 		sprintf(line, "%s%c%c", auth, CR, LF); 		StrAllocCat(command, line);  	    } #ifndef DISABLE_TRACE  	    if (httpTrace) {  		if (auth && *auth)A 		    fprintf(stderr, "HTTP: Sending authorization: %s\n", auth);  		elseA 		    fprintf(stderr, "HTTP: Not sending authorization (yet)\n"); 
             }  #endif             /*;             **  Add 'Cookie:' header, if it's HTTP or HTTPS '             **  document being proxied.              *//             if (!strncmp(docname, "http", 4)) { ?                 cookie = LYCookie(host2, path2, port2, secure); 
             }              FREE(host2);             FREE(path2);             /*=             **  The next composeAuth() will be for the proxy.              */ 	    auth_proxy = YES;	 	} else { 
            /* 5             **  Add cookie for a non-proxied request.              */E             cookie = LYCookie(hostname, abspath, portnumber, secure);  	    auth_proxy = NO;  	}    	/* C 	**  If we do have a cookie set, add it to the request buffer. - FM  	*/  	if (cookie) { 	    if (*cookie != '$') { 		/*0 		**  It's a historical cookie, so signal to the1 		**  server that we support modern cookies. - FM  		*/2 		StrAllocCat(command, "Cookie2: $Version=\"1\""); 		StrAllocCat(command, crlf);  #ifndef DISABLE_TRACE  		if (httpTrace)B 		    fprintf(stderr, "HTTP: Sending Cookie2: $Version =\"1\"\n"); #endif 	    } 	    if (*cookie) {  		/*7 		**  It's not a zero-length string, so add the header. 4 		**  Note that any folding of long strings has been& 		**  done already in LYCookie.c. - FM 		*/# 		StrAllocCat(command, "Cookie: ");  		StrAllocCat(command, cookie);  		StrAllocCat(command, crlf);  #ifndef DISABLE_TRACE  		if (httpTrace)< 		    fprintf(stderr, "HTTP: Sending Cookie: %s\n", cookie); #endif 	    } 	    free(cookie); 	}K         if (NULL != (auth = HTAA_composeAuth(hostname, portnumber, docname,  	     auth_proxy))) { 2             sprintf(line, "%s%c%c", auth, CR, LF);'             StrAllocCat(command, line);  #ifndef DISABLE_TRACE  	    if (httpTrace) {  		if (auth_proxy) @ 		    fprintf(stderr, "HTTP: Sending proxy authorization: %s\n",
 			    auth);  		elseA 		    fprintf(stderr, "HTTP: Sending authorization: %s\n", auth); 
             }  #endif         } else { #ifndef DISABLE_TRACE  	    if (httpTrace) {  		if (auth_proxy)  		    fprintf(stderr, 5 			"HTTP: Not sending proxy authorization (yet).\n");  		elseB 		    fprintf(stderr, "HTTP: Not sending authorization (yet).\n");
             }  #endif 	}         FREE(abspath);         FREE(hostname);          FREE(docname);       }        auth_proxy = NO;     }    #ifdef HAVE_SSL *   if (!do_connect && do_post && !do_put) { #else    if (do_post && !do_put) {  #endif #ifndef DISABLE_TRACE !       if (httpTrace || www2Trace) @         fprintf(stderr, "HTTP: Doing post, content-type '%s'\n",$                  post_content_type); #endif+       sprintf(line, "Content-type: %s%c%c", G                post_content_type ? post_content_type : "lose", CR, LF); !       StrAllocCat(command, line);        {          int content_length;            if (!post_data) 4           content_length = 4;		/* 4 == "lose" :-) */         else-           content_length = strlen(post_data); H         sprintf(line, "Content-length: %d%c%c", content_length, CR, LF);#         StrAllocCat(command, line);        }        >       StrAllocCat(command, crlf);	/* Blank line means "end" */              if (post_data)(         StrAllocCat(command, post_data);
       else%         StrAllocCat(command, "lose");  #ifdef HAVE_SSL 0   } else if (!do_connect && do_post && do_put) { #else !   } else if (do_post && do_put) {  #endifE       sprintf(line, "Content-length: %d%c%c", put_file_size, CR, LF); !       StrAllocCat(command, line); >       StrAllocCat(command, crlf);	/* Blank line means "end" */
   } else {>       StrAllocCat(command, crlf);	/* Blank line means "end" */   }    #ifndef DISABLE_TRACE    if (www2Trace)M     fprintf(stderr, "HTTP: Writing:\n%s----------------------------------\n",              command);  #endif  C   status = HTTP_NETWRITE(s, command, (int)strlen(command), handle);    if (do_post && do_put) {       char buf[BUFSIZ];        int upcnt = 0, n;          while (status > 0) {% 	n = fread(buf, 1, BUFSIZ-1, put_fp);   4 	upcnt += status = HTTP_NETWRITE(s, buf, n, handle); #ifndef DISABLE_TRACE  	if (httpTrace || www2Trace) {1 		fprintf(stderr, "[%d](%d) %s", status, n, buf);  	} #endif 	if (feof(put_fp)) { 		break; 	}       }   F       if ((status < 0) || !feof(put_fp) || (upcnt != put_file_size)) { 	char tmpbuf[BUFSIZ];    	sprintf(tmpbuf, 	    "Status: %d  --  EOF: %d  --  UpCnt/FileSize: %d/%d\n\nThe server you connected to either does not support\nthe PUT method, or an error occurred.\n\nYour upload was corrupted! Please try again!",B             status, (feof(put_fp) ? 1 : 0), upcnt, put_file_size);, 	application_error(tmpbuf, "Upload Error!");       }    }    #ifndef DISABLE_TRACE    if (httpTrace || www2Trace) {   	fprintf(stderr, "%s", command);   }  #endif     free(command);  7   /* Twirl on each request to make things look nicer */    if (HTCheckActiveIcon(1)) { #           HTTP_NETCLOSE(s, handle);            status = -1;,           HTProgress("Connection aborted.");           goto done;   }      if (status <= 0) {       if (status == 0) { #ifndef DISABLE_TRACE            if (httpTrace)E             fprintf(stderr, "HTTP: Got status 0 in initial write\n");  #endif           /* Do nothing. */        } else if  #ifndef MULTINETH         ((errno == ENOTCONN || errno == ECONNRESET || errno == EPIPE) && #else C         ((socket_errno == ENOTCONN || socket_errno == ECONNRESET || #           socket_errno == EPIPE) &&  #endif /* MULTINET, BSN */          !already_retrying && 8          /* Don't retry if we're posting. */ !do_post) {?             /* Arrrrgh, HTTP 0/1 compability problem, maybe. */  #ifndef DISABLE_TRACE              if (httpTrace)P               fprintf(stderr, "HTTP: Trying write again with HTTP0 request.\n"); #endif%             HTTP_NETCLOSE(s, handle);              extensions = NO;!             already_retrying = 1;              goto try_again;        } else { 		if (keepingalive) {  #ifndef DISABLE_TRACE  			if (httpTrace)  				fprintf(stderr, 4 				    "HTTP: Timeout on Keep-Alive. Retrying.\n"); #endif  			lsocket = -1;   			keepingalive = 0;   			HTTP_NETCLOSE(s, handle); . 			HTProgress("Server Timeout: Reconnecting"); 			goto try_again; 		}  #ifndef DISABLE_TRACE            if (httpTrace)             fprintf(stderr, I 	        "HTTP: Unexpected network WRITE error; aborting connection.\n");  #endif#           HTTP_NETCLOSE(s, handle);            status = -1;L           HTProgress("Unexpected network write error; connection aborted.");           goto done;       }    }     #ifndef DISABLE_TRACE    if (httpTrace || www2Trace) 2     fprintf(stderr, "HTTP: WRITE delivered OK\n"); #endifA   HTProgress("Done sending HTTP request; waiting for response.");   (   /*	Read the first line of the response)    **	-----------------------------------     */      { "       /* Get numeric status etc */       BOOL end_of_file = NO;,       HTAtom *encoding = HTAtom_for("8bit");)       int buffer_length = INIT_LINE_SIZE;        char msgline[256];     B       line_buffer = (char *) malloc(buffer_length * sizeof(char));     
       do {' 	  /* Loop to read in the first line */ F 	  /* Extend line buffer if necessary for those crazy WAIS URLs ;-) */5 	  if (buffer_length - length < LINE_EXTEND_THRESH) { 5 	      buffer_length = buffer_length + buffer_length;  	      line_buffer =  @ 		  (char *) realloc(line_buffer, buffer_length * sizeof(char));           }  #ifndef DISABLE_TRACE  	  if (httpTrace) 3 	      fprintf(stderr, "HTTP: Trying to read %d\n", $ 		      buffer_length - length - 1); #endif1 	  status = HTTP_NETREAD(s, line_buffer + length, * 			   buffer_length - length - 1, handle); #ifndef DISABLE_TRACE  	  if (httpTrace) ; 	      fprintf(stderr, "\nHTTP: Read status %d\n", status);  #endif 	  if (status <= 0) { , 	      /* Retry if we get nothing back too; ' 		 bomb out if we get nothing twice. */ & 	      if (status == HT_INTERRUPTED) { #ifndef DISABLE_TRACE  		  if (httpTrace)= 		      fprintf(stderr, "HTTP: Interrupted initial read.\n");  #endif* 		  HTProgress("Connection interrupted."); 		  status = HT_INTERRUPTED; 		  HTTP_NETCLOSE(s, handle);  		  goto clean_up;               } else   		  if (status < 0 &&  #ifndef MULTINETB 		    (errno == ENOTCONN || errno == ECONNRESET || errno == EPIPE) #else @ 		    (socket_errno == ENOTCONN || socket_errno == ECONNRESET || 		     socket_errno == EPIPE)  #endif /* MULTINET, BSN, GEC */ ) 		    && !already_retrying && !do_post) { 8 			  /* Arrrrgh, HTTP 0/1 compability problem, maybe. */ #ifndef DISABLE_TRACE  			  if (httpTrace)  			      fprintf(stderr,9 			          "HTTP: Trying again with HTTP0 request.\n");  #endif 			  HTTP_NETCLOSE(s, handle); 			  if (line_buffer)  			      free(line_buffer);  			  if (line_kept_clean)  			      free(line_kept_clean);  			    			  extensions = NO;  			  already_retrying = 1;. 			  HTProgress("Retrying as HTTP0 request."); 			  goto try_again; 		  } else { 			  if (keepingalive) { #ifndef DISABLE_TRACE  				if (httpTrace) 				    fprintf(stderr, 1 					"HTTP: Timeout on Keep-Alive. Retrying.\n");  #endif  				lsocket = -1;  				keepingalive = 0;  				HTTP_NETCLOSE(s, handle);/ 				HTProgress("Server Timeout: Reconnecting");  				goto try_again;  			  } #ifndef DISABLE_TRACE  			  if (httpTrace)  			      fprintf(stderr,S 				  "HTTP: Hit unexpected network read error; aborting connection; status %d.\n",  				  status); #endif 			  HTProgress @ 			      ("Unexpected network read error; connection aborted."); 			    			  HTTP_NETCLOSE(s, handle); 			  status = -1;  			  goto clean_up; 	 		      }            }     	  bytes_already_read += status;  I           sprintf(msgline, "Read %d bytes of data.", bytes_already_read);  	  HTProgress(msgline);           	  if (status == 0) {  	      end_of_file = YES; 
 	      break;            } $ 	  line_buffer[length + status] = 0;          	  if (line_buffer) {  	      if (line_kept_clean)  		  free (line_kept_clean); F 	      line_kept_clean = (char *)malloc(buffer_length * sizeof(char));; 	      memcpy(line_kept_clean, line_buffer, buffer_length);            }          * 	  eol = strchr(line_buffer + length, LF);( 	  /* Do we *really* want to do this? */8 	  if (eol && (eol != line_buffer) && (*(eol-1) == CR))  	      *(eol-1) = ' ';            	  length += status; 	   ( 	  /* Do we really want to do *this*? */ 	  if (eol) * 	      *eol = 0;		/* Terminate the line */L       /* All we need is the first line of the response.  If it's an HTTP/1.0K        * response, then the first line will be absurdly short and therefore F        * we can safely gate the number of bytes read through this code(        * (as opposed to below) to ~1000.        * Well, let's try 100. 	        */ C       } while (!eol && !end_of_file && (bytes_already_read < 100)); !   } /* Scope of loop variables */   A   /* Save total length, in case we decide later to show it all */    rawlength = length;      6   /*	We now have a terminated unfolded line. Parse it.7    **	-------------------------------------------------     */       {      int fields; *     char server_version[VERSION_LENGTH+1];     int server_status;       statusError = 0;       server_version[0] = 0;     +     fields = sscanf(line_buffer, "%20s %d", #                     server_version, $                     &server_status);      #ifndef DISABLE_TRACE !     if (httpTrace || www2Trace) { C       fprintf(stderr, "HTTP: Rx: line_buffer '%s'\n", line_buffer); L       fprintf(stderr, "HTTP: Scanned %d fields from line_buffer\n", fields);     }  #endif     1     /* Rule out HTTP/1.0 reply as best we can. */ G     if (fields < 2 || !server_version[0] || server_version[0] != 'H' || 8 	server_version[1] != 'T' || server_version[2] != 'T' ||?         server_version[3] != 'P' || server_version[4] != '/' || $         server_version[6] != '.') {	           HTAtom *encoding;    #ifndef DISABLE_TRACE          if (httpTrace)2           fprintf(stderr, "--- Talking HTTP0.\n"); #endif         H         format_in = HTFileFormat(url, &encoding, WWW_HTML, &compressed);(         start_of_data = line_kept_clean; 	done_length = length;     } else {'         /* Decode full HTTP response */ +         format_in = HTAtom_for("www/mime"); B         /* We set start_of_data to "" when !eol here because thereD          * will be a put_block done below; we do *not* use the value@          * of start_of_data (as a pointer) in the computation of8          * length or anything else in this situation. */+         start_of_data = eol ? eol + 1 : ""; P         done_length = length = eol ? length - (start_of_data - line_buffer) : 0;          #ifndef DISABLE_TRACE          if (httpTrace)2           fprintf(stderr, "--- Talking HTTP1.\n"); #endif  &         switch (server_status / 100) {
 	  case 1: 	    /* ( 	    **	HTTP/1.1 Informational statuses. 	    **	100 Continue.   	    **	101 Switching Protocols. 	    **	> 101 is unknown. 5 	    **	We should never get these, and they have only 3 	    **	the status line and possibly other headers, 3 	    **	so we'll deal with them by showing the full . 	    **	header to the user as text/plain. - FM 	    */ 8 	    HTProgress("Got unexpected Informational Status."); 	    do_head = 1;  	    break;   .           case 2:		/* Good: Got MIME object */ 	    if (do_head) {  		if (server_status == 200) ? 		    retried_with_new_nonce = 0;  /* Reset the toggle value */  		break; 	    }$             switch (server_status) {               case 204: #                 return_nothing = 1; 4                 format_in = HTAtom_for("text/html");                 break; 	      case 200:; 		retried_with_new_nonce = 0;  /* Reset the toggle value */                default: 		/*
 		 *  200 OK.  		 *  201 Created. 		 *  202 Accepted. ( 		 *  203 Non-Authoritative Information. 		 *  > 206 is unknown. - 		 *  All should return something to display.  		 */  #ifdef HAVE_SSL  	        if (do_connect) { #ifndef DISABLE_TRACE  		    if (httpTrace) 		        fprintf(stderr, 3 			    "HTTP: Proxy tunnel to '%s' established.\n",  				connect_host); #endif 		    do_connect = FALSE;  		    url = connect_url; 		    FREE(line_buffer); 		    FREE(line_kept_clean); 		    did_connect = TRUE;  		    already_retrying = TRUE; 		    eol = 0; 		    bytes_already_read = 0;  		    had_header = NO; 		    length = 0;  		    target = NULL; #ifndef DISABLE_TRACE  		    if (httpTrace) 		      fprintf(stderr, ; 			"      Will attempt handshake and resubmit headers.\n");  #endif 		    goto use_tunnel; 		}  #else  		break; #endif
             }              break;                        case 3:  	    /* % 	    **	Various forms of Redirection.  	    **	300 Multiple Choices.  	    **	301 Moved Permanently.7 	    **	302 Found (temporary; we can, and do, use GET). 2 	    **	303 See Other (temporary; always use GET). 	    **	304 Not Modified.  	    **	305 Use Proxy. 	    **	306 Set Proxy.4 	    **	307 Temporary Redirect with method retained. 	    **	> 308 is unknown.  	    */    	    if (do_head) {  		/* Just show it to user */ 		break; 	    }? 	    /* Redirect unless Multiple Choices or other bad status */ " 	    if ((server_status != 300) &&5 		(server_status != 304) && (server_status != 305) && 4 		(server_status != 306) && (server_status < 308)) {	 	      /* ; 	       * We do not load the file, but read the headers for 9 	       * the "Location:", check out that redirecting_url 8 	       * and if it's acceptible (e.g., not a telnet URL< 	       * when we have that disabled), initiate a new fetch.= 	       * If that's another redirecting_url, we'll repeat the < 	       * checks, and fetch initiations if acceptible, until; 	       * we reach the actual URL, or the redirection limit > 	       * set in HTAccess.c is exceeded.	If the status was 301= 	       * indicating that the relocation is permanent, we set = 	       * the permanent_redirection flag to make it permanent ? 	       * for the current anchor tree (i.e., will persist until 9 	       * the tree is freed or the client exits).  If the 9 	       * redirection would include POST content, we seek ? 	       * confirmation from an interactive user, with option to A 	       * use 303 for 301 (but not for 307), and otherwise refuse 9 	       * the redirection.  We also don't allow permanent @ 	       * redirection if we keep POST content.  If we don't find> 	       * the Location header or it's value is zero-length, we< 	       * display whatever the server returned, and the user> 	       * should RELOAD that to try again, or make a selection< 	       * from it if it contains links, or Left-Arrow to the! 	       * previous document. - FM 
 	       */ 	        char *cp;  ' 		/* Work around hung socket problem */ ; 		if (strstr(line_kept_clean, "Server: Microsoft-IIS/4.0")) " 			broken_Microsoft_crap_hack = 1; 		/*. 		 *  Get the rest of the headers and data, if) 		 *  any, and then close the connection.  		 */ / 		while ((status = HTTP_NETREAD(s, line_buffer, - 					   (INIT_LINE_SIZE - 1), handle)) > 0) {  		  line_buffer[status] = '\0'; . 		  StrAllocCat(line_kept_clean, line_buffer); 		}  		HTTP_NETCLOSE(s, handle); ! 		broken_Microsoft_crap_hack = 0; ! 		if (status == HT_INTERRUPTED) {  		  /* 		   *  Impatient user.  		   */  #ifndef DISABLE_TRACE  		  if (httpTrace)> 		      fprintf(stderr, "HTTP: Interrupted followup read.\n"); #endif* 		  HTProgress("Connection interrupted."); 		  status = HT_INTERRUPTED; 		  goto clean_up; 		}  	        /* ? 	        **  Look for "Set-Cookie:" and "Set-Cookie2:" headers.  	        */ $ 	        if (HTSetCookies == TRUE) { 		  char *value = NULL;  		  char *SetCookie = NULL;  		  char *SetCookie2 = NULL; 		  cp = line_kept_clean;  		  while (*cp) { 
 		      /*) 		      **  Assume a CRLF pair terminates $ 		      **  the header section. - FM
 		      */ 		      if (*cp == CR) { 			  if (*(cp+1) == LF && * 			      *(cp+2) == CR && *(cp+3) == LF) { 			      break;  			  }	 		      } " 		      if (TOUPPER(*cp) != 'S') {
 			  cp++;< 		      } else if (!my_strncasecmp(cp, "Set-Cookie:", 11)) {# 			  char *cp1 = NULL, *cp2 = NULL;  			  cp += 11; Cookie_continuation: 			  /* " 			   *  Trim leading spaces. - FM 			   */( 			  while (isspace((unsigned char)*cp)) 			      cp++; 			  /* 4 			  **  Accept CRLF, LF, or CR as end of line. - FM 			  */ , 			  if (((cp1 = strchr(cp, LF)) != NULL) ||* 			      (cp2 = strchr(cp, CR)) != NULL) { 			      if (*cp1) { 				  *cp1 = '\0';) 				  if ((cp2 = strchr(cp, CR)) != NULL)  				      *cp2 = '\0'; 			      } else {  				  *cp2 = '\0';
 			      } 			  } 			  if (*cp == '\0') {  			      if (cp1)  				  *cp1 = LF; 			      if (cp2)  				  *cp2 = CR; 			      if (value) {  				  TrimDoubleQuotes(value); 				  if (SetCookie == NULL) {) 				      StrAllocCopy(SetCookie, value);  				  } else {' 				      StrAllocCat(SetCookie, ", "); ( 				      StrAllocCat(SetCookie, value); 				  }  				  free(value);
 			      } 			      break;  			  } 			  StrAllocCat(value, cp); 			  cp += strlen(cp); 			  if (cp1) {  			      *cp1 = LF;  			      cp1 = NULL; 			  } 			  if (cp2) {  			      *cp2 = CR;  			      cp2 = NULL; 			  } 			  cp1 = cp; 			  if (*cp1 == CR) 			     cp1++; 			  if (*cp1 == LF) 			     cp1++;' 			  if (*cp1 == ' ' || *cp1 == '\t') { ! 			      StrAllocCat(value, " ");  			      cp = cp1; 			      cp++; 			      cp1 = NULL;" 			      goto Cookie_continuation; 			  } 			  TrimDoubleQuotes(value);  			  if (SetCookie == NULL) { ( 			      StrAllocCopy(SetCookie, value);
 			  } else { & 			      StrAllocCat(SetCookie, ", ");' 			      StrAllocCat(SetCookie, value);  			  } 			  FREE(value); > 		      } else if (!my_strncasecmp(cp, "Set-Cookie2:", 12))  {# 			  char *cp1 = NULL, *cp2 = NULL;  			  cp += 12; Cookie2_continuation:  			  /* " 			   *  Trim leading spaces. - FM 			   */( 			  while (isspace((unsigned char)*cp)) 			      cp++; 			  /* 4 			  **  Accept CRLF, LF, or CR as end of line. - FM 			  */ , 			  if (((cp1 = strchr(cp, LF)) != NULL) ||* 			      (cp2 = strchr(cp, CR)) != NULL) { 			      if (*cp1) { 				  *cp1 = '\0';) 				  if ((cp2 = strchr(cp, CR)) != NULL)  				      *cp2 = '\0'; 			      } else {  				  *cp2 = '\0';
 			      } 			  } 			  if (*cp == '\0') {  			      if (cp1)  				  *cp1 = LF; 			      if (cp2)  				  *cp2 = CR; 			      if (value) {  				  TrimDoubleQuotes(value); 				  if (SetCookie2 == NULL) { * 				      StrAllocCopy(SetCookie2, value); 				  } else {( 				      StrAllocCat(SetCookie2, ", ");) 				      StrAllocCat(SetCookie2, value);  				  }  				  FREE(value);
 			      } 			      break;  			  } 			  StrAllocCat(value, cp); 			  cp += strlen(cp); 			  if (cp1) {  			      *cp1 = LF;  			      cp1 = NULL; 			  } 			  if (cp2) {  			      *cp2 = CR;  			      cp2 = NULL; 			  } 			  cp1 = cp; 			  if (*cp1 == CR) 			     cp1++; 			  if (*cp1 == LF) 			     cp1++;' 			  if (*cp1 == ' ' || *cp1 == '\t') { ! 			      StrAllocCat(value, " ");  			      cp = cp1; 			      cp++; 			      cp1 = NULL;# 			      goto Cookie2_continuation;  			  } 			  TrimDoubleQuotes(value);  			  if (SetCookie2 == NULL) {) 			      StrAllocCopy(SetCookie2, value); 
 			  } else { ' 			      StrAllocCat(SetCookie2, ", "); ( 			      StrAllocCat(SetCookie2, value); 			  } 			  FREE(value);  		      } else {
 			  cp++;	 		      }  		  }  		  FREE(value);" 		  if (SetCookie || SetCookie2) {> 		      LYSetCookie(SetCookie, SetCookie2, anAnchor->address); 		      FREE(SetCookie); 		      FREE(SetCookie2);  		  } 
 	        }   	        /* 5 	         *  Look for the "Location:" in the headers.  	         */ 	        cp = line_kept_clean; 	        while (*cp) { 		  if (TOUPPER(*cp) != 'L') { 		    cp++; 5 		  } else if (!my_strncasecmp(cp, "Location:", 9)) { $ 		    char *cp1 = NULL, *cp2 = NULL; 		    cp += 9; 		    /* 		     *	Trim leading spaces. 	 		     */ ) 		    while (isspace((unsigned char)*cp))  			cp++; 		    /*1 		     *	Accept CRLF, LF, or CR as end of header. 	 		     */ - 		    if (((cp1 = strchr(cp, LF)) != NULL) || $ 			(cp2 = strchr(cp, CR)) != NULL) { 			if (*cp1) { 			    *cp1 = '\0'; * 			    if ((cp2 = strchr(cp, CR)) != NULL) 				*cp2 = '\0'; 			} else {  			    *cp2 = '\0';  			} 			/* - 			 *  Load the new URL into redirecting_url, * 			 *  and make sure it's not zero-length. 			 */% 			StrAllocCopy(redirecting_url, cp); % 			TrimDoubleQuotes(redirecting_url); " 			if (*redirecting_url == '\0') {	 			    /* 3 			     *	The "Location:" value is zero-length, and 4 			     *	thus is probably something in the body, so0 			     *	we'll show the user what was returned.
 			     */ #ifndef DISABLE_TRACE  			     if (httpTrace) 				fprintf(stderr, / 				    "HTTP: 'Location:' is zero-length!\n");  #endif 			    if (cp1)  				*cp1 = LF; 			    if (cp2)  				*cp2 = CR; 			    bad_location = 1; 			    free(redirecting_url);  			    redirecting_url = NULL; 			    HTProgress(9 			       "Got redirection with a bad Location header."); 
 			    break;  			}   #ifndef DISABLE_TRACE  			if (httpTrace) 9 			    fprintf(stderr, "HTTP: Picked up location '%s'\n",  				    redirecting_url);  #endif 			if (cp1)  			    *cp1 = LF;  			if (cp2)  			    *cp2 = CR;  #if 0 . 			if (server_status == 305) { /* Use Proxy */	 			    /* - 			     *	Make sure the proxy field ends with  			     *	a slash.
 			     */5 			    if (redirecting_url[strlen(redirecting_url)-1]  				!= '/') & 				StrAllocCat(redirecting_url, "/");	 			    /*  			     *	Append our URL. 
 			     */7 			    StrAllocCat(redirecting_url, anAnchor->address);  #ifndef DISABLE_TRACE  			    if (httpTrace) 7 			        fprintf(stderr, "HTTP: Proxy URL is '%s'\n",  					redirecting_url); #endif 			} #endif 			status = HT_REDIRECTING;  			goto clean_up;  		    }  		    break; 		  } else { 		    /*. 		     *	Keep looking for the Location header.	 		     */  		    cp++;  		  } 
 	        }   	        /* ; 	         *  If we get to here, we didn't find the Location ; 	         *  header, so we'll show the user what we got, if  	         *  anything. 	         */ #ifndef DISABLE_TRACE  		if (www2Trace || httpTrace) = 		    fprintf(stderr, "HTTP: Failed to pick up location.\n");  #endif) 	        start_of_data = line_kept_clean;  	        length = rawlength; 	        if (!bad_location) { ; 		  HTProgress("Got redirection with no Location header."); 
 	        } 	    } 	    statusError = 1;              break;             +           case 4:		/* "I think I goofed" */ #             switch (server_status)                 {                case 401: <                 /* length -= start_of_data - text_buffer; */M                 if (HTAA_shouldRetryWithAuth(start_of_data, length, s, NO)) { -                     HTTP_NETCLOSE(s, handle);  		    lsocket = -1; %                     if (line_buffer)  (                       free(line_buffer);)                     if (line_kept_clean)  ,                       free(line_kept_clean);   #ifndef DISABLE_TRACE #                     if (httpTrace)  F                       fprintf(stderr, "HTTP: close socket %d %s\n", s,D                               "to retry with Access Authorization"); #endif                       HTProgress( 6 			"Retrying with access authorization information."); #ifdef HAVE_SSL + 		    if ((using_proxy || using_gateway) && " 			!strncmp(url, "https://", 8)) {
 			url = arg;  			do_connect = TRUE;  			did_connect = FALSE;  		    }  #endif#                     goto try_again;                  } else { 		    statusError = 1;                     break;                 }                  case 403:  		statusError = 1;@                 /* 403 is "forbidden"; display returned text. */                 break;   	      case 404: 		HTProgress ("Not Found");  		statusError = 1;@                 /* 404 is "Not Found"; display returned text. */                 break;   	      case 407: 		/*. 		 *  Authorization for proxy server required.2 		 *  If we are not in fact using a proxy, proceed4 		 *  to showing the 407 body.  Otherwise, if we can: 		 *  set up authorization based on the Proxy-Authenticate2 		 *  header, and the user provides a username and 		 *  password, try again. 		 */ ' 		if (!using_proxy && !using_gateway) {   		    statusError = 1;  #ifndef DISABLE_TRACE #                     if (httpTrace)  %                       fprintf(stderr, + 				"HTTP: Got 407 but not using proxy\n");  #endif 		    break; 		} @ 		if (HTAA_shouldRetryWithAuth(start_of_data, length, s, YES)) { 		    HTTP_NETCLOSE(s, handle);  		    lsocket = -1; %                     if (line_buffer)  (                       free(line_buffer);)                     if (line_kept_clean)  ,                       free(line_kept_clean);   #ifndef DISABLE_TRACE #                     if (httpTrace)  L                       fprintf(stderr, "%s %d %s\n", "HTTP: close socket", s,J                               "to retry (407) with Access Authorization"); #endif 		    HTProgress( 5 			"Retrying with proxy authorization information.");  		    goto try_again;                  } else { #ifndef DISABLE_TRACE #                     if (httpTrace)  %                       fprintf(stderr, , 				"HTTP: Got 407 but should not retry\n"); #endif 		    statusError = 1; 		    break;                 }    	      case 408: 		/*/ 		 *  Request Timeout.  Show the status message ' 		 *  and restore the current document.  		 */   		HTProgress("Request Timeout"); 		statusError = 1;                 break;                 default: 		/* 		 *  400 Bad Request. 		 *  402 Payment Required.  		 *  403 Forbidden. 		 *  404 Not Found. 		 *  405 Method Not Allowed.  		 *  406 Not Acceptable.  		 *  409 Conflict.  		 *  410 Gone.  		 *  411 Length Required. 		 *  412 Precondition Failed.# 		 *  413 Request Entity Too Large.  		 *  414 Request-URI Too Long. ! 		 *  415 Unsupported Media Type. 2 		 *  416 List Response (for content negotiation). 		 *  > 416 is unknown.  		 */  		statusError = 1;                 break;#               } /* case 4 switch */              break;  +           case 5:		/* I think you goofed */  	    statusError = 1;              break;             $           default:		/* Bad number */ 	    statusError = 1; 9             HTAlert("Unknown status reply from server!");              break;+         } /* Switch on server_status/100 */                 }	/* Full HTTP reply */    } /* Scope of fields */      if (do_head) {&       start_of_data = line_kept_clean;       length = rawlength; +       format_in = HTAtom_for("text/plain");    }   A   /* Set up the stream stack to handle the body of the message */ #   target = HTStreamStack(format_in, $                          format_out,$                          compressed,)                          sink, anAnchor);       if (!target) {'       char buffer[1024];	/* @@@@@@@@ */   D       sprintf(buffer, "Sorry, no known way of converting %s to %s.",?               HTAtom_name(format_in), HTAtom_name(format_out));        HTProgress(buffer);        status = -1;       HTTP_NETCLOSE(s, handle);        lsocket = -1;        goto clean_up;   }      if (!return_nothing) { #ifndef DISABLE_TRACE #         if (www2Trace || httpTrace) I         	fprintf(stderr, "HTTP: Doing put_block, '%s'\n", start_of_data);  #endif 	/* Check for Keep-Alive */ # 	for (p = start_of_data; *p; p++) { 9 	    if ((*p == 'C') && !strncmp("Connection:", p, 11)) {  		char *p2;    #ifndef DISABLE_TRACE  		if (httpTrace)9 		    fprintf(stderr, "HTTP: Server Sent Connection:\n");  #endif  		for (p2 = p + 11; *p2; p2++) {2 		    if (!my_strncasecmp("Keep-Alive", p2, 10)) { 			lsocket = s; 	 			break;  		    } , 		    if (!my_strncasecmp("close", p2, 5)) { #ifndef DISABLE_TRACE  			if (httpTrace) ; 			    fprintf(stderr, "HTTP: Server Closes Connection\n");  #endif	 			break;  		    } 6 		    /* Check if found neither Keep-Alive or close */ 		    if (*p2 == ':') { 	 			break;  		    } 
 	        } 		break;@ 	    } else if ((*p == 'K') && !strncmp("Keep-Alive:", p, 11)) { #ifndef DISABLE_TRACE  		if (httpTrace)9 		    fprintf(stderr, "HTTP: Server Sent Keep-Alive:\n");  #endif 		lsocket = s; 		break; 	    } 	}   #ifndef DISABLE_TRACE '       if (httpTrace && (lsocket == -1)) B 	  fprintf(stderr, "HTTP: Server does not agree to Keep-Alive\n"); #endif:       /* Recycle the first chunk of data, in all cases. */?       (*target->isa->put_block)(target, start_of_data, length);        +       /* Go pull the bulk of the data down. C        * If we don't use length, header length is wrong due to the           * discarded first line */K       rv = HTCopy(s, target, done_length /* bytes_already_read */, handle);        if (rv == -1) { 4           (*target->isa->handle_interrupt) (target);"           status = HT_INTERRUPTED; 	  HTTP_NETCLOSE(s, handle); 	  lsocket = -1;           goto clean_up;       } 6       if (rv == -2 && !already_retrying && !do_post) { #ifndef DISABLE_TRACE            if (httpTrace)H             fprintf(stderr, "HTTP: Trying again with HTTP0 request.\n"); #endif>           /* May as well consider it an interrupt -- right? */4           (*target->isa->handle_interrupt) (target);#           HTTP_NETCLOSE(s, handle);            if (line_buffer)               free(line_buffer);           if (line_kept_clean)  "             free(line_kept_clean);
                      extensions = NO;           already_retrying = 1; 3           HTProgress("Retrying as HTTP0 request.");            goto try_again;        } 
   } else {#       /* return_nothing is high. */ H       (*target->isa->put_string) (target, "<mosaic-access-override>\n");-       HTProgress("No content was returned.");    }   '   (*target->isa->end_document)(target);   '   /* Close socket before doing free. */  	if (lsocket == -1) {  		HTTP_NETCLOSE(s, handle);  #ifndef DISABLE_TRACE  		if (httpTrace)1 			fprintf(stderr, "HTTP: Closing connection\n");  #endif	 	} else { / 		HTProgress("Leaving Server Connection Open");  #ifndef DISABLE_TRACE  		if (httpTrace)7 			fprintf(stderr, "HTTP: Keeping connection alive\n");  #endif 	}     (*target->isa->free)(target);      status = HT_LOADED;   
   /*	Clean up     */   clean_up:     if (line_buffer)       free(line_buffer);   if (line_kept_clean)       free(line_kept_clean);    done:   /* Clear out on exit */    do_post = 0;   do_head = 0;     if (statusError) { 	securityType = HTAA_NONE; #ifndef DISABLE_TRACE  	if (httpTrace) 8 		fprintf(stderr, "Resetting security type to NONE.\n"); #endif   }  #ifdef HAVE_SSL    do_connect = FALSE;    did_connect = FALSE;   FREE(connect_host);    if (lsocket == -1)     keepalive_handle = NULL; #endif /* HAVE_SSL */      return status; }      /*	Protocol descriptor */  3 PUBLIC HTProtocol HTTP = { "http", HTLoadHTTP, 0 }; 5 PUBLIC HTProtocol HTTPS = { "https", HTLoadHTTP, 0 }; 