/* misc.c : miscelanous functions. */
/* Copyright 1993 Stefane Fermigier. */
/* Read tabul.c for licence agreement. */

#include <ctype.h>
#include <string.h>
#include <stdio.h>

#include "tabul.h"

struct note_name {
	char name;
	int pitch;
};

static struct note_name notes[] = {
	{ 'c', 0 }, { 'd', 2 },
	{ 'e', 4 }, { 'f', 5 },
	{ 'g', 7 }, { 'a', 9 },
	{ 'b', 11 }, { '\0', 0 }
};

/* Convert a note name to a midi pitch. ex: c5 -> 60. Should be updated
to take into account generic chords. */
int Note2Pitch (note)
char *note;
{
	int i, j;
	int pitch;

	if ((tolower(note[0]) < 'a') && (tolower(note[0]) > 'g')) {
		fprintf (stderr, "Note name not in [a-g] range : %s\n", note);
		exit(1);
	}
	for (i=0; notes[i].name != '\0'; i++) {
		if (tolower(note[0]) == notes[i].name) {
			pitch = notes[i].pitch;
			break;
		}
	}
	j = 1;
	if (note[1] == 'b' ) {
		pitch--;
		j++;
	} else if (note[1] == '#') {
		pitch++;
		j++;
	}
	pitch += 12 * atoi(note + j);

	return pitch;
}

int ChordRoot (name, base)
char *name;
int base;
{
	char buff[NAME_LENGTH];
	char *s;
	int value;

	strcpy (buff, name);
	s = strchr (buff, '_');
	if (s != NULL)
		s[0] = '\0';
	else {
		buff[1] = '0';
		buff[2] = '\0';
	}
	value = Note2Pitch (buff);
	if (s == NULL) {
		value = (value - base) % 12;
		if (value < 0)
			value += 12;
		value += base;
	}
	return value;
}

/* break the string ``str'' into tokens, which are copied to ``list''. 
Return value is number of tokens, or negative in case of error. */
int Tokenize (str, list)
char *str;
char list [MAX_TOK] [NAME_LENGTH];
{
	int n;
	char *s;

	n = 0;
	while (1) {
		s = strtok ((n == 0) ? str : NULL, " \t\n");
		if ((s == NULL) || (s[0] == ';') || s[0] == '\0')  /* skip comments */
			break;
		if (strlen(s) + 1 >= NAME_LENGTH)
			return STAT_TOK_TOO_LONG;
		strncpy (list[n], s, NAME_LENGTH);
		n++;
		if (n >= MAX_TOK) 
			return STAT_TOO_MUCH_TOK;
	}
	list[n][0] = '\0';
	return n;
}

