

#include <stdio.h>
#include <math.h>

extern void InitLattice();
extern double S3Noise();

int NPTS;

main(argc, argv)
    int argc;
    char **argv;
{
	FILE *header, *points, *triangles;
	int i, j;
	double f, x, y, z, x2, y2;
	double freq, amp, nret, xt, yt, zt;
	double nsum;
	double twop;
	double s_rad, d_rad, prob;
	int k, T_pts, s;
	int t1, t2, t3, t4;

	freq = 2.0;
	amp = 1.0;
	if (argc < 2)
	{
		fprintf(stderr, "Warning no points argument passed.\n");
		fprintf(stderr, "Setting Number of Points to 20\n");
		NPTS = 20;
	}
	else
	{
		NPTS = atoi(argv[1]);
		if (((NPTS / 4) * 4) != NPTS)
		{
			fprintf(stderr, "Warning NPTS (%d) is not a multiple of four\n", NPTS);
			NPTS = ((NPTS / 4) * 4);
			fprintf(stderr, "Setting NPTS  to (%d)\n", NPTS);
		}
		if (argc > 2)
			freq = atof(argv[2]);
		if (argc > 3)
			amp = atof(argv[3]);
	}
header = fopen("fire_head", "w");
points = fopen("fire_pts", "w");
triangles = fopen("fire_tri", "w");
d_rad = 0.5;
	InitLattice();
t1 = 0;
for (s_rad=d_rad; s_rad<1.0; s_rad = s_rad + 0.1)
{
t1++;
}
	fprintf(header, "%d\n", t1 * ((NPTS * ((NPTS / 2) - 1)) + 2));
	fprintf(header, "%d\n", t1 * (((NPTS * 2) * ((NPTS / 2) - 2)) + (NPTS * 2)));

s = 0;
for (s_rad=d_rad; s_rad<1.0; s_rad = s_rad + 0.1)
{
	for (i=0; i<=(NPTS / 2); i++)
	{
		f = ((double)i / (NPTS / 2)) + 0.5;
		x2 = s_rad * cos(f * M_PI);
		y2 = s_rad * sin(f * M_PI);
		if ((i > 0) && (i < (NPTS / 2)))
		{
			for (j=0; j<NPTS; j++)
			{
				f = ((double)j * 2) / NPTS;
				xt = x2 * cos(f * M_PI);
				yt = y2;
				zt = x2 * sin(f * M_PI);
				nsum = 0.0;
				twop = 1.0;
				for (k=0; k<8; k++)
				{
					nret = S3Noise(twop * (xt + 1.2),
						twop * (yt + 1.2),
						twop * (zt + 1.2));
					nret = fabs(nret / twop);
					nsum = nsum + nret;
					twop = twop * 2.0;
				}
				x = xt * (1.0 + (nsum));
				y = yt * (1.0 + (nsum));
				z = zt * (1.0 + (nsum));
				fprintf(points, "%lf %lf %lf\n", x, y, z);
			}
		}
		else
		{
			nsum = 0.0;
			twop = 1.0;
			for (k=0; k<8; k++)
			{
				nret = S3Noise(twop * (1.2), twop * (y2 + 1.2),
					twop * (1.2));
				nret = fabs(nret / twop);
				nsum = nsum + nret;
				twop = twop * 2.0;
			}
			fprintf(points, "%lf %lf %lf\n", 0.0, y2 * (1.0 + (nsum)), 0.0);
		}
	}

	prob = (1.0 - s_rad) / (1.0 - d_rad);
	prob = prob * prob;
	if (prob < 0.000001) prob = 0.000001;
	T_pts = s * ((NPTS * ((NPTS / 2) - 1)) + 2);

	t1 = T_pts;
	t2 = T_pts + 1;
	t3 = T_pts + 2;
	for (j=1; j<NPTS; j++)
	{
		fprintf(triangles, "%d %d %d %f\n", t1, t2, t3, prob);
		t2++;
		t3++;
	}
	fprintf(triangles, "%d %d %d %f\n", t1, t2, t1 + 1, prob);

	t1 = T_pts + 1;
	t2 = T_pts + 2;
	t3 = T_pts + NPTS + 1;
	t4 = T_pts + NPTS + 2;
	for (i=2; i<(NPTS / 2); i++)
	{
		for (j=1; j<NPTS; j++)
		{
			fprintf(triangles, "%d %d %d %f\n", t1, t3, t4, prob);
			fprintf(triangles, "%d %d %d %f\n", t1, t4, t2, prob);
			t1++;
			t2++;
			t3++;
			t4++;
		}
		t2 -= NPTS;
		t4 -= NPTS;
		fprintf(triangles, "%d %d %d %f\n", t1, t3, t4, prob);
		fprintf(triangles, "%d %d %d %f\n", t1, t4, t2, prob);
		t1 = t2 + NPTS;
		t2 = t1 + 1;
		t3 = t4 + NPTS;
		t4 = t3 + 1;
	}

	for (j=1; j<NPTS; j++)
	{
		fprintf(triangles, "%d %d %d %f\n", t3, t2, t1, prob);
		t1++;
		t2++;
	}
	fprintf(triangles, "%d %d %d %f\n", t3, t2 - NPTS, t1, prob);
s++;
}
fclose(header);
fclose(points);
fclose(triangles);
}

