/*
 * This was an attempt on my part to use random noise to create a swirl
 * of red, orange amd yellow that looks like fire.  It failed, but the code
 * is still here in case I want to make another stab at it sometime.
 */
#include <stdio.h>
#include <sys/types.h>
#include <math.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "color.h"


extern double S3Noise();

extern Display	*dsp;
extern XColor	color[];
extern Colormap	Cmap;
extern float	view_dist;
extern float	distance;
extern int	NumCells;
extern Bool	Nomap;
extern Display	*dsp;
extern Window	Dwindow;
extern GC	DrawGC;
extern unsigned int Width, Height;


struct col_pts {
double red, green, blue;
};

extern struct col_rec Colors[];



ShadeFire()
{
	int i, j;
	struct col_pts acolor;

	for (i=0; i<17; i++)
	{
		acolor.red = 1.0;
		acolor.green = (float)(16 - i) / 16.0;
		acolor.blue = 0;
		for (j=1; j<16; j++)
		{
			Colors[(i * 15) + j].red = acolor.red * NumCells *
				(float)(j) / 15.0;
			Colors[(i * 15) + j].green = acolor.green * NumCells *
				(float)(j) / 15.0;
			Colors[(i * 15) + j].blue = acolor.blue * NumCells *
				(float)(j) / 15.0;

			color[(i * 15) + j].red = Colors[(i * 15) + j].red *
				65535 / NumCells;
			color[(i * 15) + j].green = Colors[(i * 15) + j].green *
				65535 / NumCells;
			color[(i * 15) + j].blue = Colors[(i * 15) + j].blue *
				65535 / NumCells;
			color[(i * 15) + j].flags = DoRed|DoGreen|DoBlue;
			if (Nomap == True)
			{
				XAllocColor(dsp, Cmap, &color[(i * 15) + j]);
			}
			color[(i * 15) + j].pixel = (i * 15) + j;
		}
	}
	if (Nomap == False)
	{
		XStoreColors(dsp, Cmap, color, NumCells);
	}
}




void
fireTriangle(x1, y1, z1, x2, y2, z2, x3, y3, z3, cos_theta)
	float x1, y1, z1;
	float x2, y2, z2;
	float x3, y3, z3;
	float cos_theta;
{
	int i;
	int tmp, dist;
	int xscale, yscale, xoffset, yoffset;
	int colornum;
	int red_v, green_v, blue_v;
	float x, y, z;
	float xp1, yp1, xp2, yp2, xp3, yp3;
	double xf, yf, zf;
	double nret;
	double rad;
	XPoint points[4];
	struct col_pts thiscolor;

	x = (x1 + x2 + x3) / 3.0;
	y = (y1 + y2 + y3) / 3.0;
	z = (z1 + z2 + z3) / 3.0;

	rad = sqrt((double)(x * x) + (y * y) + ((z + distance) * (z + distance)));
	rad = rad - 1.0;

	if (rad < 0.0)
		rad = 0.0;
	if (rad >= 1.0)
		rad = 0.9999;

	if (Nomap == True)
	{
		thiscolor.red = 1.0;
		thiscolor.green = 0.9999 - rad;
		thiscolor.blue = 0.0;
		red_v = thiscolor.red * NumCells * (cos_theta + 0.05);
		green_v = thiscolor.green * NumCells * (cos_theta + 0.05);
		blue_v = thiscolor.blue * NumCells * (cos_theta + 0.05);
		if (red_v > (NumCells - 1))
		{
			red_v = (NumCells - 1);
		}
		if (green_v > (NumCells - 1))
		{
			green_v = (NumCells - 1);
		}
		if (blue_v > (NumCells - 1))
		{
			blue_v = (NumCells - 1);
		}

		dist = (int)sqrt((double)3 * 256 * 256);
		colornum = 0;
		for (i=0; i<NumCells; i++)
		{
			tmp = (int)sqrt((double)(red_v - Colors[i].red) *
				(red_v - Colors[i].red) +
				(green_v - Colors[i].green) *
				(green_v - Colors[i].green) +
				(blue_v - Colors[i].blue) *
				(blue_v - Colors[i].blue));
			if (tmp < dist)
			{
				colornum = i;
				dist = tmp;
			}
		}
	}
	else
	{
		colornum = (int)(17.0 * rad);
		tmp = (int)(15.0 * (cos_theta + 0.05));
		if (tmp > 14)
		{
			tmp = 14;
		}
		colornum = (colornum * 15) + tmp + 1;
	}

	xscale = xoffset = (Width) / 2;
	yscale = yoffset = (Height) / 2;

	xp1 = (x1 * view_dist) / (view_dist - z1);
	yp1 = (y1 * view_dist) / (view_dist - z1);
	xp2 = (x2 * view_dist) / (view_dist - z2);
	yp2 = (y2 * view_dist) / (view_dist - z2);
	xp3 = (x3 * view_dist) / (view_dist - z3);
	yp3 = (y3 * view_dist) / (view_dist - z3);

	points[0].x = (int)(xp1 * xscale) + xoffset;
	points[1].x = (int)(xp2 * xscale) + xoffset;
	points[2].x = (int)(xp3 * xscale) + xoffset;
	points[3].x = points[0].x;

	points[0].y = yoffset - (int)(yp1 * yscale);
	points[1].y = yoffset - (int)(yp2 * yscale);
	points[2].y = yoffset - (int)(yp3 * yscale);
	points[3].y = points[0].y;

	XSetForeground(dsp, DrawGC, colornum);
	XFillPolygon(dsp, Dwindow, DrawGC, points, 3,
		Convex, CoordModeOrigin);
}

