#include <stdio.h>
#include <Xm/Xm.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include "compact.h"

#define	DEF_VIS		DefaultVisual(dsp, DefaultScreen(dsp))
#define	DEF_CMAP	DefaultColormap(dsp, DefaultScreen(dsp))
#define DEF_ROOT	DefaultRootWindow(dsp)
#define	DEF_BLACK	BlackPixel(dsp, DefaultScreen(dsp))
#define	DEF_WHITE	WhitePixel(dsp, DefaultScreen(dsp))

extern void readframe();
extern void InitLattice();

typedef struct res_struct {
Bool            op_help;
Bool            op_nomap;
Bool            op_lowmem;
Bool            op_noblack;
Bool            op_nowhite;
char            *op_dumpformat;
} ResRec;

ResRec		res_gotten;
XtAppContext	app;
XtTranslations	commandTable;
Display		*dsp;
Widget		top;
Colormap	Cmap;
GC		DrawGC;
GC		invGC;
XColor		color[256];
int		NumCells;
float		view_dist;
char		*Myname;
unsigned int	Width, Height;
int		ShadeType;
int		Changes = 1;
int		Erode = 0;
Bool		Mapped = False;
Bool		Nomap;
float		distance;
float		Old_distance;
int		LowMem = 0;
int		NoBlack = 0;
int		NoWhite = 0;
int		DumpFormat;

static XrmOptionDescRec Options[] = {
	{"-help", ".help", XrmoptionNoArg, "True"},
	{"-nomap", ".nomap", XrmoptionNoArg, "True"},
	{"-lowmem", ".lowMemory", XrmoptionNoArg, "True"},
	{"-noblack", ".noBlack", XrmoptionNoArg, "True"},
	{"-nowhite", ".noWhite", XrmoptionNoArg, "True"},
	{"-dformat", ".dumpFormat", XrmoptionSepArg, NULL},
};

#define offset(field)	XtOffset(struct res_struct *, field)
static XtResource res_list[] = {
	{"help", "Help", XtRBool, sizeof(Bool),
		offset(op_help), XtRString, "False"},
	{"nomap", "Nomap", XtRBool, sizeof(Bool),
		offset(op_nomap), XtRString, "False"},
	{"lowMemory", "LowMemory", XtRBool, sizeof(Bool),
		offset(op_lowmem), XtRString, "False"},
	{"noBlack", "NoBlack", XtRBool, sizeof(Bool),
		offset(op_noblack), XtRString, "False"},
	{"noWhite", "NoWhite", XtRBool, sizeof(Bool),
		offset(op_nowhite), XtRString, "False"},
	{"dumpFormat", "DumpFormat", XtRString, sizeof(char *),
		offset(op_dumpformat), XtRString, "gif"},
};
#undef offset

static char commandTranslations[] =
	"<EnterWindow>: highlight()	\n\
	 <LeaveWindow>: reset()		\n\
	 <BtnDown>:     set()		\n\
	 <BtnUp>:       notify() unset()";


void
Exit()
{
	exit(0);
}


void
HelpProc()
{
	fprintf(stderr, "Accepts all standard X options, Plus:\n");
	fprintf(stderr, "-help       (Prints this message)\n");
	fprintf(stderr, "-nomap      Use the default colormap not your own.\n");
	fprintf(stderr, "-noblack    No polygon will shade down to black.\n");
	fprintf(stderr, "-nowhite    No polygon will shade up to white.\n");
	fprintf(stderr, "-lowmem     Use less memory.  This turns off\n");
	fprintf(stderr, "            detailing and translucent polygons.\n");
	fprintf(stderr, "            as well as most editing.\n");
	fprintf(stderr, "-dformat    describe the format of dump files.\n");
	fprintf(stderr, "            only supports ebc and gif files.\n");
	fprintf(stderr, "            gif is the default.\n");
}


void
InitStuff(ac, av)
	int ac;
	char **av;
{
	int i;
	XColor tmpcolr;
	unsigned long	gcvmask = 0;
	XGCValues	gcvals;

	/*
	 * Initialize the toolkit, create an application context,
	 * open the display, create our top level shell widget,
	 * and get all our application resources.
	 */
	XtToolkitInitialize ();
	app = XtCreateApplicationContext ();
	dsp = XtOpenDisplay (app, NULL, "wframe", "Wframe",
			Options, XtNumber(Options),
			&ac, av);
	top = XtAppCreateShell("wframe", "Wframe",
			applicationShellWidgetClass, dsp, NULL, 0);
	XtGetApplicationResources(top, &res_gotten, res_list,
				XtNumber(res_list), NULL, 0);

	/*
	 * Find the number of colormap cells for this display
	 */
	NumCells = DisplayCells(dsp, DefaultScreen(dsp));

	/*
	 * If invoked with -help, just print the help, and then exit.
	 */
	if (res_gotten.op_help)
	{
		HelpProc();
		exit(0);
	}

	/*
	 * set LowMem
	 */
	if (res_gotten.op_lowmem == True)
	{
		LowMem = 1;
	}
	else
	{
		LowMem = 0;
	}

	/*
	 * set NoBlack
	 */
	if (res_gotten.op_noblack == True)
	{
		NoBlack = 1;
	}
	else
	{
		NoBlack = 0;
	}

	/*
	 * set NoWhite
	 */
	if (res_gotten.op_nowhite == True)
	{
		NoWhite = 1;
	}
	else
	{
		NoWhite = 0;
	}

	/*
	 * set DumpFormat
	 */
	DumpFormat = GIF;
	if (strcmp(res_gotten.op_dumpformat, "ebc") == 0)
	{
		DumpFormat = EBC;
	}
	else if (strcmp(res_gotten.op_dumpformat, "gif") == 0)
	{
		DumpFormat = GIF;
	}

	/*
	 * set Nomap
	 */
	Nomap = res_gotten.op_nomap;

	/*
	 * set Erode
	 */
	Erode = 0;

	/*
	 * Set the distance of the viewer.
	 */
	view_dist = 4.0;
	distance = 0.0;
	Old_distance = 0.0;

	/*
	 * Set the Width and Height
	 * of the drawing area
	 */
	Width = 500;
	Height = 500;

	/*
	 * The name I was invoked with.
	 */
	Myname = av[0];

	/*
	 * Make all mouse buttons activate command widgets.
	 */
	commandTable = XtParseTranslationTable(commandTranslations);

	/*
	 * Read the wireframe description from the passed file
	 * and initialize the random number lattice
	 */
	if (ac >= 2)
	{
		readframe(av[1]);
	}
	else
	{
		readframe(NULL);
	}
	srand(time(0));
	InitLattice();

	/*
	 * Set up the graphics context for drawing
	 */
	gcvals.foreground = DEF_WHITE;
	gcvals.background = DEF_BLACK;
	gcvmask	= GCForeground|GCBackground;
	DrawGC = XCreateGC(dsp, DEF_ROOT, gcvmask, &gcvals);
	gcvals.foreground = 1;
	gcvals.function = GXxor;;
	gcvmask	= GCForeground|GCBackground|GCFunction;
	invGC = XCreateGC(dsp, DEF_ROOT, gcvmask, &gcvals);

	/*
	 * Set up the colormap
	 */
	if (Nomap == True)
	{
		Cmap = DEF_CMAP;
	}
	else
	{
		Cmap = XCreateColormap(dsp, DEF_ROOT, DEF_VIS, AllocAll);
	}
}

