 $! NewsPatch.Com9 $! Version 2.1     22-Jul-1993  (revision history at end) 4 $! Author: Charles Bailey  bailey@genetics.upenn.eduE $! Input: P1 = name of patch file (required, type defaults to .Patch) O $!        P2 = list of source files to be backed up (optional; defaults to list B $!             following 'News Files:' header in each patch file).& $! Output: 1. Patched source file(s), 6 $!         2. Copy(ies) of the original(s), with name L $!            {name}_Pre_{patchname).{type}, where {name} and {type} are theK $!            file name and type of the source file, and {patchname} is the M $!            name of the patch file.  This is designed to save a copy of the E $!            file as it exists just before application of the patch. M $!         3. If no file {name}_Orig.{type} is found in the same directory, a L $!            copy of the unpatched file with this name will be generated asI $!            well.  This is designed to save a copy of the original file 2 $!            before the first time it is patched.M $!         4. If the file PatchList.h does not exist in the same directory, a L $!            template file is created.  This will be used to record the IDs- $!            of patches as they are applied.  $!M $! Summary: Apply an ANU News standard patch, after checking that an archival N $!          copy of the file exists (any file in the same directory with _OrigM $!          appended to the name of the original file, and with the same type O $!          as the original.  If run in interactive mode, user will be prompted L $!          to clean up after patch application, and in response to possibleK $!          trouble.  If not interactive, no files will be deleted, and any ; $!          patch with a potential problem will be skipped.  $!N $!   Define this symbol to execute the Wall patch program as a foreign commandM $!   Note: -a switch requires patch to Wall patch program from Charles Bailey I $!   If you haven't applied this patch, remove the -a from the definition  $!   below. . $    uxpatch = "$Sys_LocRoot:[Exe]UxPatch -a7" $! $    curvfy = F$Verify(0)  $    procstart = F$Time()  $    processedfiles = 0  $    successfiles = 0  $    filespurged = 0' $    On Control_y Then Goto ctrly_abort  $    say = "Write Sys$Error"" $    If F$Mode().eqs."INTERACTIVE"	 $    Then 7 $      ask = "Read Sys$Command/End=ctrlz_abort/Prompt=" 	 $    Else   $      ask = "choice = ""N"" ! "
 $    EndIf $! $    get_p1:" $    If p1.nes."" Then Goto got_p1M $    ! If we're not in interactive mode, set p1 to an illegal spec, and we'll , $    ! fall into the FNF error handler laterB $    If F$Mode().nes."INTERACTIVE" Then p1 = "[No file specified]" $    'ask' "_Patch File: " p1  $    Goto get_p1 $  $    got_p1: $    If p1.eqs."?"	 $    Then ? $      thisfname = F$Parse(F$Environment("Procedure"),,,"Name") 8 $      say "Usage: @''thisfname' Patchfile [Sourcelist]"
 $      say "" < $      say "       Patchfile = ANU News standard patch file"5 $      say "          (file type defaults to .Patch)" 
 $      say "" > $      say "       Sourcelist = List of source files affected"< $      say "          (defaults to files specified in patch"- $      say "           'News Files:' header)"  $      Exit 
 $    EndIf $    p1 = F$Parse(p1,".Patch")6 $    wild =           F$Locate("*",p1).ne.F$Length(p1)6 $    wild = wild .or. F$Locate("%",p1).ne.F$Length(p1)8 $    wild = wild .or. F$Locate("...",p1).ne.F$Length(p1) $    If wild .and. p2.nes.""	 $    Then K $      say "%NEWSPATCH-F-NOP2WLD, P2 may not be specified with wildcard P1"  $      Exit 44 ! SS$_Abort
 $    EndIf $    patfname = F$Search(p1,1) $    If (patfname.eqs."") 	 $    Then 9 $      say "%NEWSPATCH-F-FNF, patch file ''p1' not found" ! $      Exit 2320 ! SS$_NoSuchFile 
 $    EndIf $! $    process_patch:  $    startime = F$Time() $    srclist = p2 C $    say "%NEWSPATCH-I-PROCESSING, processing patch file ",patfname ( $    processedfiles = processedfiles + 1- $    Open/Read/Error=filerr tmpfil 'patfname'  $    If srclist.eqs.""	 $    Then  $      getline: 9 $      Read/End=no_file_header/Error=filerr tmpfil inline + $      pos = F$Locate("News Files:",inline) 3 $      If pos.eq.F$Length(inline) Then Goto getline @ $      srclist = F$Edit(F$Extract(pos+11,255,inline),"Collapse") $    $      filelist_loop: R $      If F$Extract(F$Length(srclist)-1,1,srclist).nes."," Then Goto filelist_done9 $      Read/End=no_file_header/Error=filerr tmpfil inline ) $      inline = F$Edit(inline,"Collapse") ! $      srclist = srclist + inline  $      Goto filelist_loop  $    $      no_file_header: $      Close tmpfil S $      say "%NEWSPATCH-W-NOFILHDR, no 'News Files:' header in patch file ",patfname # $      'ask' "_Checklist: " srclist  $      If srclist.eqs."" $      Then ? $        say "%NEWSPATCH-W-NOCHECK, no files will be backed up" , $        'ask' "Continue (Y/N) [N]: " choice $        If .not.choice 
 $        Then G $          say "%NEWSPATCH-E-USRSKIP, user cancelled patch application"  $          Goto next_patch $        EndIf $      EndIf/ $      Open/Read/Error=filerr tmpfil 'patfname' 
 $    EndIf $  $    filelist_done: 3 $    Read/End=bad_header/Error=filerr tmpfil inline  $    inlen = F$Length(inline) > $    If F$Locate("*** ",inline).ne.inlen Then Goto header_done/ $    If F$Locate("Superseded:",inline).ne.inlen 	 $    Then L $      say "%NEWSPATCH-W-SUPERSEDED, patch ",patfname," has been superseded"1 $      'ask' "Apply it anyway (Y/N) [N]: " choice ( $      If choice Then Goto filelist_done; $      say "%NEWSPATCH-I-SKIPPAT, skipping patch ",patfname  $      Close tmpfil  $      Goto next_patch
 $    EndIf- $    If F$Locate("Requires:",inline).ne.inlen 	 $    Then @ $      reqpatlist = F$Edit(F$Extract(9,inlen,inline),"Collapse") $  $      build_reqpatlist:G $      If F$Extract(F$Length(reqpatlist)-1,1,reqpatlist).nes."," Then -            Goto got_reqpats5 $      Read/End=bad_header/Error=filerr tmpfil inline ; $      reqpatlist = f$edit(reqpatlist + inline, "Collapse")  $      Goto build_reqpatlist $  $      got_reqpats:  $      i = 0 $  $      reqpatloop:- $      reqpatid = F$Element(i,",",reqpatlist) - $      If reqpatid.eqs."," Then Goto req_done - $      Open/Error=nopatlist plist Patchlist.H  $  $      plist_readloop:4 $      Read/Error=badpatlist/End=req_bad plist plineF $      If F$Locate(reqpatid,pline).ne.F$Length(pline) Then Goto req_ok $      Goto plist_readloop $  $      badpatlist:B $      say "%NEWSPATCH-E-BADPLIST, error reading file PatchList.H"; $      say "%NEWSPATCH-I-SKIPPAT, skipping patch ",patfname  $      Close plist $      Close tmpfil  $      Goto next_patch $  $      req_ok: $      Close plist $      i = i + 1 $      Goto reqpatloop $  $      nopatlist: X $      say "%NEWSPATCH-W-NOPATLST, previous patch required, can't find Patchlist.H file" $      Goto noreq_continue $  $      req_bad: K $      say "%NEWSPATCH-W-NOREQPAT, required patch not found in PatchList.H" J $      say "-NEWSPATCH-I-REQPATID, Patch ID of missing patch is ",reqpatid $      Close plist $  $      noreq_continue:9 $      'ask' "Apply this patch anyway (Y/N) [N]: " choice  $      If .not.choice  $      Then = $        say "%NEWSPATCH-I-SKIPPAT, skipping patch ",patfname  $        Close tmpfil  $        Goto next_patch $      EndIf $  $      req_done:        
 $    EndIf1 $    If F$Locate("Supplemented:",inline).ne.inlen 	 $    Then V $      say "%NEWSPATCH-I-PATSUPLMT, this patch is supplemented by (an)other patch(es)"J $      say "                        see patch header for more information"
 $    EndIf $    Goto filelist_done  $  $    bad_header: $    Close tmpfil C $    say "%NEWSPATCH-E-BADHDR, error encountered processing header" 9 $    say "%NEWSPATCH-I-SKIPPAT, skipping patch ",patfname  $    Goto next_patch $  $    filerr: $    stat = $Status 3 $    If F$TrnLNM("tmpfil").nes."" Then Close tmpfil : $    say "%NEWSPATCH-E-READERR, unable to read patch file"9 $    say "%NEWSPATCH-I-SKIPPAT, skipping patch ",patfname  $    say F$Message(stat) $    Goto next_patch $  $    header_done:  $    Close tmpfil  $! $    filcount = 0  $    prevfil = "" * $    patchnam = F$Parse(patfname,,,"Name") $    check_loop:- $    curfil = F$Element(filcount,",",srclist) ( $    If curfil.eqs."," Then Goto do_copy5 $    curfil = F$Parse(curfil,prevfil,,,"Syntax_Only")  $    If F$Search(curfil).eqs."" 	 $    Then A $      say "%NEWSPATCH-W-FNF, could not find source file ",curfil 1 $      'ask' "Skip this patch (Y/N) [N]: " choice  $      If choice $      Then D $        say "%NEWSPATCH-E-USRCAN, user cancelled patch application"= $        say "%NEWSPATCH-I-SKIPPAT, skipping patch ",patfname  $        Goto next_patch $      EndIf
 $    EndIf $    filcount = filcount + 1 $    Goto check_loop $ 
 $    do_copy:  $    filcount = 0  $    prevfil = ""  $    copy_loop: - $    curfil = F$Element(filcount,",",srclist) ) $    If curfil.eqs."," Then Goto do_patch 5 $    curfil = F$Parse(curfil,prevfil,,,"Syntax_Only")  $    If F$Search(curfil).nes."" 	 $    Then ) $      curfnam = F$Parse(curfil,,,"Name") 8 $      prifil = F$Parse(curfnam+"_Pre_"+patchnam,curfil)+ $      Copy/Log/NoConfirm 'curfil' 'prifil' 0 $      origfil = F$Parse(curfnam+"_Orig",curfil)M $      If F$Search(origfil).eqs."" Then Copy/Log/NoConfirm 'curfil' 'origfil' 
 $    EndIf $    prevfil = curfil  $    filcount = filcount + 1 $    Goto copy_loop  $  $    do_patch:? $    plistfil = F$Parse("Patchlist.h",F$Element(0,",",srclist)) ! $    If F$Search(plistfil).eqs."" 	 $    Then A $      say "%NEWSPATCH-I-CREPLIST, creating new PatchList.h file" 1 $      Open/Write/Error=writerr tmpfil 'plistfil' 3 $      Write/Error=writerr tmpfil "=+=+= End =+=+="  $      Close tmpfil  $      Goto plist_done $  $      writerr:  $      stat = $Status . $      If F$TrnLNM("tmpfil") Then Close tmpfil= $      say "%NEWSPATCH-F-WRITERR, error creating PatchList.h"  $      Exit stat $  $      plist_done:
 $    EndIf% $    srclist = "PatchList.h,"+srclist & $    Define/User Sys$Input Sys$Command $    uxpatch <'patfname' $    If $Status 	 $    Then & $      successfiles = successfiles + 15 $      'ask' "Purge changed files (Y/N) [Y]: " choice ) $      If choice.eqs."" Then choice = "Y"  $      If choice $      Then  $        filespurged = 1 $        filcount = 0  $        prevfil = ""  $  $        purge_loop:1 $        curfil = F$Element(filcount,",",srclist) - $        If curfil.eqs."," Then goto pur_done B $        curfil = F$Parse(";",curfil,prevfil,,"Syntax_Only") - ";"% $        Purge/Log/NoConfirm 'curfil'   $        filcount = filcount + 1 $        prevfil = curfil  $        Goto purge_loop $  $        pur_done: $      EndIf	 $    Else  $      GoSub del_one_patch
 $    EndIf $ 3 $      'ask' "Delete patch file (Y/N) [N]: " choice ) $      If choice.eqs."" Then choice = "N"  $      If choice $      Then 5 $        Delete/Log/NoConfirm 'F$Parse(patfname,";")'  $      EndIf $! $    next_patch: $    old_patfname = patfname $    patfname = F$Search(p1,1)M $    If (patfname.eqs."") .or. (patfname.eqs.old_patfname) Then Goto finished  $    Goto process_patch  $  $    ctrlz_abort: = $    say "%NEWSPATCH-F-CTRLZ, user aborted patch application"  $    GoSub del_one_patch $  $    ask_continue:I $    ask "Abort procedure or continue with next patch (A/C) [C]: " choice 4 $    choice = F$Edit(F$Extract(0,1,choice),"UpCase")F $    If (choice .eqs. "") .or. (choice .eqs. "C") Then Goto next_patch( $    If choice .eqs. "A" Then Goto abort $    Goto ask_continue $  $    ctrly_abort: 5 $    say "%NEWSPATCH-F-CTRLY, user aborted execution"  $  $    abort: ' $    On Control_y Then Goto last_chance 4 $    if F$Locate("ctrlz_abort",ask).ne.F$Length(ask)	 $    then & $      j = f$Locate("ctrlz_abort",ask)2 $      ask = F$Extract(0,j,ask) + "last_chance" +-9              F$Extract(j+F$Length("ctrlz_abort"),255,ask) 
 $    endif3 $    If F$TrnLNm("tmpfil").nes."" Then Close tmpfil 1 $    If F$TrnLNm("plist").nes."" Then Close plist 9 $    say "This procedure started executing at ",procstart  $    if filespurged 	 $    then 
 $      say "" R $      say "WARNING: Answering Yes to the next question will MOST PROBABLY result"I $      say "in loss of ALL copies of files purged during this procedure." 
 $      say "" 	 $    else 
 $      say "" E $      say "WARNING: Answering Yes to the next question might result" I $      say "in loss of ALL copies of files purged during this procedure." 
 $      say "" 
 $    endifH $    'ask' "Delete all files created since this time (Y/N) [N]: " choice $    If choice	 $    Then Q $      say "The DELETE command will prompt to confirm the deletion of each file."  $      choice = "YES"  $      if filespurged then -D          'ask' "Are you SURE you want to proceed (Y/N) [N]: " choice $      If choice $      Then 6 $        Delete/Log/Confirm/Since="''procstart'" *.*;*D $        say "Note: Only files in this directory have been deleted."O $        say "You will need to manually remove files created by this procedure" & $        say "in any other directory." $      EndIf
 $    EndIf $    GoTo finished $  $    last_chance:  $    say "Procedure aborted."  $    GoTo finished $  $    finished: $    curvfy = F$Verify(curvfy)A $    say F$FAO("%NEWSPATCH-I-FILES, !UL patch file!%S read, " + - F                "!UL applied successfully",processedfiles,successfiles)	 $    Exit  $!5 $!  Subroutine deletes files since last patch started  $  $      del_one_patch: @ $      say "%NEWSPATCH-W-PATCHFAIL, errors occurred during " + -#            "application of patch  " ; $      say "Application of this patch started at ",startime J $      'ask' "Delete all files created since that time (Y/N) [N]: " choice) $      If choice.eqs."" Then choice = "N"  $      If choice $      Then  $        filcount = 0  $        prevfil = ""  $  $        del_loop:1 $        curfil = F$Element(filcount,",",srclist) - $        If curfil.eqs."," Then Goto del_done K $        curfil = F$Parse(F$Parse(curfil,,,"Name","Syntax_Only")+"*.*;*", - 8                           curfil,prevfil,,"Syntax_Only")0 $        Delete/Log/Since="''startime'" 'curfil'  $        filcount = filcount + 1 $        prevfil = curfil  $        Goto del_loop $  $        del_done: $      EndIf
 $      Return  $! $! Revision History:: $!   2.1  22-Jul-1993  Mark Martinec  Mark.Martinec@ijs.si@ $!                and  Charles Bailey  bailey@genetics.upenn.edu4 $!        - cleaned up typos, fixed misc. minor bugsC $!        - added warning before deleting all files since procstart  $!        - added Ctrl-Z abort@ $!   2.0  20-Jun-1993  Charles Bailey  bailey@genetics.upenn.edu# $!        - added wildcard handling O $!        - added handling of Superseded:, Requires:, and Supplemented: headers ( $!        - added informational messages@ $!   1.4.1 8-Mar-1993  Charles Bailey  bailey@genetics.upenn.edu5 $!        - fixed typo in F$Parse() within purge_loop @ $!   1.4   8-Mar-1993  Charles Bailey  bailey@genetics.upenn.eduI $!        - added cleanup option if error occurs during patch application I $!          (works only with FAILURE mods to patch); fixed F$Parse() bugs ! $!          for nonexistent files @ $!   1.3  17-Feb-1993  Charles Bailey  bailey@genetics.upenn.eduA $!        - added support for multiple line 'News Files:' headers @ $!   1.2   9-Feb-1993  Charles Bailey  bailey@genetics.upenn.eduI $!        - changed response to missing source file from abort to warning @ $!   1.1  20-Jan-1993  Charles Bailey  bailey@genetics.upenn.eduI $!        - fixed bug which pointed patchlist.h check to wrong directory; - $!          added option to delete patch file @ $!   1.0  08-Jan-1993  Charles Bailey  bailey@genetics.upenn.edu $!        - original version