A char *connv = "CONNECT Command for DG AOS/VS, 5A(046) 15 Sep 94";   M /*  C K D C O N  --  Dumb terminal connection to remote system, for AOS/VS */  /*>  Author: Frank da Cruz (fdc@columbia.edu, FDCCU@CUVMA.BITNET),5  Columbia University Center for Computing Activities.   First released January 1985. N  Copyright (C) 1985, 1992, Trustees of Columbia University in the City of New O  York.  Permission is granted to any individual or institution to use, copy, or O  redistribute this software so long as it is not sold for profit, provided this   copyright notice is retained.   */  E /* This module brought up to 5A by Eugenia Harris at Data General. */    #nolist A #include "ckcdeb.h"                     /* Common things first */ 5 #include <signal.h>                     /* Signals */ ; #include <errno.h>                      /* Error numbers */  #include <setjmp.h>    /* Kermit-specific includes */  > #include "ckcasc.h"                     /* ASCII characters */; #include "ckcker.h"                     /* Kermit things */ C #include "ckucmd.h"                     /* For xxesc() prototype */ = #include "ckcnet.h"                     /* Network symbols */  #ifndef NOCSETS G #include "ckcxla.h"                     /* Character set translation */  #endif /* NOCSETS */   #ifdef datageneral #include <sgtty.h> #include <multitask.h> #include <packets:normal_io.h> #list   H extern short idel_tbl[7] = {0x4,0,0,0,0,0,0};   /* delimiter table -- */H                                                 /* defaults to CR only*/> /* Globals and defines for DG multi-tasking connect command */G void readfromcommline();                        /* listener sub-task */  extern int ttyfd,ttyfdout;N #define TASKID      17                  /* task id of readfromcommline task */P #define TASKPRI   200                 /* priority of readfromcommline (was 2) */H #define STACK       02000               /* default stack size (was 0) */ #define MAXINBUF    2048  static int inbufsize = MAXINBUF; extern long times(); #endif /* datageneral */  " /* Internal function prototypes */    _PROTOTYP( VOID doesc, (char) );" _PROTOTYP( VOID logchar, (char) );  _PROTOTYP( int hconne, (void) );  B #ifndef SIGUSR1                         /* User-defined signals */ #define SIGUSR1 30 #endif /* SIGUSR1 */   #ifndef SIGUSR2  #define SIGUSR2 31 #endif /* SIGUSR2 */   /* External variables */  G extern int local, escape, duplex, parity, flow, seslog, sessft, debses, G  mdmtyp, ttnproto, cmask, cmdmsk, network, nettype, deblog, sosi, tnlm, 5  xitsta, what, ttyfd, quiet, backgrd, tt_crd, tn_nlm;  extern long speed;3 extern char ttname[], sesfil[], myhost[],*ccntab[];   > #ifndef NOSETKEY                        /* Keyboard mapping */F extern KEY *keymap;                     /* Single-character key map */E extern MACRO *macrotab;                 /* Key macro pointer table */ J static MACRO kmptr = NULL;              /* Pointer to current key macro */ #endif /* NOSETKEY */   + /* Global variables local to this module */   C static int quitnow = 0,                 /* <esc-char>Q was typed */ C   dohangup = 0,                         /* <esc-char>H was typed */ B   sjval = 0,                            /* Setjump return value */<   goterr = 0,                           /* I/O error flag */D   active = 0,                           /* Lower fork active flag */?   inshift = 0;                          /* SO/SI shift state */    outshift = 0;   G static char kbuf[10], *kbp;             /* Keyboard buffer & pointer */ E static PID_T parent_id = (PID_T)0;      /* Process id of main task */   B static char *ibp;                       /* Input buffer pointer */@ static int ibc = 0;                     /* Input buffer count */A #define IBUFL 4096                      /* Input buffer length */   C static char *obp;                       /* Output buffer pointer */ A static int obc = 0;                     /* Output buffer count */ B #define OBUFL 1024                      /* Output buffer length */  @ #define TMPLEN 200                      /* Temp buffer length */   #ifdef DYNAMICK static char *ibuf, *obuf, *temp;        /* Input, output, & temp buffers */  #else 3 static char ibuf[IBUFL], obuf[OBUFL], temp[TMPLEN];  #endif /* DYNAMIC */   /* Character-set items */    #ifndef NOCSETS * #ifdef CK_ANSIC /* ANSI C prototypes... */G extern CHAR (*xls[MAXTCSETS+1][MAXFCSETS+1])(CHAR); /* Character set */ O extern CHAR (*xlr[MAXTCSETS+1][MAXFCSETS+1])(CHAR); /* translation functions */ A static CHAR (*sxo)(CHAR);       /* Local translation functions */ I static CHAR (*rxo)(CHAR);       /* for output (sending) terminal chars */ O static CHAR (*sxi)(CHAR);       /* and for input (receiving) terminal chars. */  static CHAR (*rxi)(CHAR);  #else /* Not ANSI C... */ C extern CHAR (*xls[MAXTCSETS+1][MAXFCSETS+1])(); /* Character set */ L extern CHAR (*xlr[MAXTCSETS+1][MAXFCSETS+1])(); /* translation functions. */A static CHAR (*sxo)();           /* Local translation functions */ I static CHAR (*rxo)();           /* for output (sending) terminal chars */ O static CHAR (*sxi)();           /* and for input (receiving) terminal chars. */  static CHAR (*rxi)();  #endif /* CK_ANSIC */ 7 extern int language;            /* Current language. */ G static int langsv;              /* For remembering language setting. */ > extern struct csinfo fcsinfo[]; /* File character set info. */N extern int tcsr, tcsl;          /* Terminal character sets, remote & local. */N static int tcs;                 /* Intermediate ("transfer") character set. */   #ifndef NOESCSEQ /*J   As of edit 178, the CONNECT command will skip past ANSI escape sequencesK   to avoid translating the characters within them.  This allows the CONNECT G   command to work correctly when connected to a remote host that uses a J   7-bit ISO 646 national character set, in which characters like '[' wouldI   normally be translated into accented characters, ruining the terminal's 6   interpretation (and generation) of escape sequences.  G   Escape sequences of non-ANSI/ISO-compliant terminals are not handled.  */ #ifndef SKIPESC  #define SKIPESC  #endif /* SKIPESC */ /*,   States for the escape-sequence recognizer. */L #define ES_NORMAL 0                     /* Normal, not in escape sequence */F #define ES_GOTESC 1                     /* Current character is ESC */G #define ES_ESCSEQ 2                     /* Inside an escape sequence */ G #define ES_GOTCSI 3                     /* Inside a control sequence */ N #define ES_STRING 4                     /* Inside DCS,OSC,PM, or APC string */K #define ES_TERMIN 5                     /* 1st char of string terminator */   
 static intM   skipesc = 0,                          /* Skip over ANSI escape sequences */ J   inesc = ES_NORMAL;                    /* State of sequence recognizer */ /*I   ANSI escape sequence handling.  Only the 7-bit form is treated, because H   translation is not a problem in the 8-bit environment, in which all GLI   characters are ASCII and no translation takes place.  So we don't check G   for the 8-bit single-character versions of CSI, DCS, OSC, APC, or ST. H   Here is the ANSI sequence recognizer state table, followed by the code   that implements it.      Definitions:;     CAN = Cancel                       01/08         Ctrl-X ;     SUB = Substitute                   01/10         Ctrl-Z :     DCS = Device Control Sequence      01/11 05/00   ESC P:     CSI = Control Sequence Introducer  01/11 05/11   ESC [:     ST  = String Terminator            01/11 05/12   ESC \:     OSC = Operating System Command     01/11 05/13   ESC ]:     PM  = Privacy Message              01/11 05/14   ESC ^:     APC = Application Program Command  01/11 05/15   ESC _  "   ANSI escape sequence recognizer:  +     State    Input  New State  ; Commentary   6     NORMAL   (start)           ; Start in NORMAL state  +     (any)    CAN    NORMAL     ; ^X cancels +     (any)    SUB    NORMAL     ; ^Z cancels   6     NORMAL   ESC    GOTESC     ; Begin escape sequenceD     NORMAL   other             ; NORMAL control or graphic character  ,     GOTESC   ESC               ; Start again$     GOTESC   [      GOTCSI     ; CSIC     GOTESC   P      STRING     ; DCS introducer, consume through ST C     GOTESC   ]      STRING     ; OSC introducer, consume through ST C     GOTESC   ^      STRING     ; PM  introducer, consume through ST C     GOTESC   _      STRING     ; APC introducer, consume through ST F     GOTESC   0..~   NORMAL     ; 03/00 through 17/14 = Final characterJ     GOTESC   other  ESCSEQ     ; Intermediate or ignored control character  ,     ESCSEQ   ESC    GOTESC     ; Start againF     ESCSEQ   0..~   NORMAL     ; 03/00 through 17/14 = Final characterJ     ESCSEQ   other             ; Intermediate or ignored control character  ,     GOTCSI   ESC    GOTESC     ; Start againF     GOTCSI   @..~   NORMAL     ; 04/00 through 17/14 = Final characterJ     GOTCSI   other             ; Intermediate char or ignored control char  .     STRING   ESC    TERMIN     ; Maybe have ST1     STRING   other             ; Consume all else   .     TERMIN   \      NORMAL     ; End of string0     TERMIN   other  STRING     ; Still in string */ /*)   chkaes() -- Check ANSI Escape Sequence. +   Call with EACH character in input stream. @   Sets global inesc variable according to escape sequence state. */ VOID #ifdef CK_ANSIC  chkaes(char c) #else  chkaes(c) char c;  #endif /* CK_ANSIC */  /* chkaes */ {  M     if (c == CAN || c == SUB)           /* CAN and SUB cancel any sequence */        inesc = ES_NORMAL;7     else                                /* Otherwise */ B       switch (inesc) {                  /* enter state switcher */  :         case ES_NORMAL:                 /* NORMAL state */8           if (c == ESC)                 /* Got an ESC */D             inesc = ES_GOTESC;          /* Change state to GOTESC */L           break;                        /* Otherwise stay in NORMAL state */  :         case ES_GOTESC:                 /* GOTESC state */K           if (c == '[')                 /* Left bracket after ESC is CSI */ D             inesc = ES_GOTCSI;          /* Change to GOTCSI state */J           else if (c > 057 && c < 0177) /* Final character '0' thru '~' */<             inesc = ES_NORMAL;          /* Back to normal */J           else if (c == 'P' || (c > 0134 && c < 0140)) /* P, [, ^, or _ */O             inesc = ES_STRING;          /* Switch to STRING-absorption state */ J           else if (c != ESC)            /* ESC in an escape sequence... */J             inesc = ES_ESCSEQ;          /* starts a new escape sequence */O           break;                        /* Intermediate or ignored ctrl char */   M         case ES_ESCSEQ:                 /* ESCSEQ -- in an escape sequence */ J           if (c > 057 && c < 0177)      /* Final character '0' thru '~' */E             inesc = ES_NORMAL;          /* Return to NORMAL state. */ 5           else if (c == ESC)            /* ESC ... */ J             inesc = ES_GOTESC;          /* starts a new escape sequence */O           break;                        /* Intermediate or ignored ctrl char */   M         case ES_GOTCSI:                 /* GOTCSI -- In a control sequence */ J           if (c > 077 && c < 0177)      /* Final character '@' thru '~' */?             inesc = ES_NORMAL;          /* Return to NORMAL. */ 5           else if (c == ESC)            /* ESC ... */ :             inesc = ES_GOTESC;          /* starts over. */O           break;                        /* Intermediate or ignored ctrl char */   =         case ES_STRING:                 /* Inside a string */ O           if (c == ESC)                 /* ESC may be 1st char of terminator */ 5             inesc = ES_TERMIN;          /* Go see. */ J           break;                        /* Absorb all other characters. */  J         case ES_TERMIN:                 /* May have a string terminator */E           if (c == '\\')                /* which must be backslash */ C             inesc = ES_NORMAL;          /* If so, back to NORMAL */ 7           else                          /* Otherwise */ H             inesc = ES_STRING;          /* Back to string absorption. */       }  }  #endif /* NOESCSEQ */  #endif /* NOCSETS */  > /* Connect state parent/child communication signal handlers */  M static jmp_buf con_env;          /* Environment pointer for connect errors */  /*I   Note: Some C compilers (e.g. Cray UNICOS) interpret the ANSI C standard <   about setjmp() in a way that disallows constructions like:  %     if ((var = setjmp(env)) == 0) ...   H   which prevents the value returned by longjmp() from being used at all.:   So the following handlers set a global variable instead. */ static SIGTYPI conn_int(foo) int foo; {                /* Modem read failure handler, */ B     signal(SIGUSR1,SIG_IGN);            /* Disarm the interrupt */A     sjval = 1;                          /* Set global variable */ M     longjmp(con_env,sjval);             /* Notifies parent process to stop */  }    static SIGTYP mode_chg(foo) int foo; {  <     signal(SIGUSR2,mode_chg);       /* Re-arm the signal. */=     duplex = 1 - duplex;            /* Toggle duplex mode. */ ,     debug(F101,"mode_chg duplex","",duplex); }   C /*  C K C P U T F  --  C-Kermit CONNECT Put Character to Screen  */  /*E   Output is buffered to avoid slow screen writes on fast connections.  */ int D ckcputf() {                             /* Dump the output buffer */     int x = 0;H     if (obc > 0)                        /* If we have any characters, */8       x = conxo(obc,obuf);              /* dump them, */?     obp = obuf;                         /* reset the pointer */ >     obc = 0;                            /* and the counter. */H     return(x);                          /* Return conxo's return code */ }   C /*  C K C P U T C  --  C-Kermit CONNECT Put Character to Screen  */  /*E   Output is buffered to avoid slow screen writes on fast connections.  */ int  ckcputc(c) int c; { 
     int x;   C     *obp++ = c & 0xff;                  /* Deposit the character */ 6     obc++;                              /* Count it */C     if (ibc == 0 ||                     /* If input buffer empty */ C         obc == OBUFL) {                 /* or output buffer full */ )         debug(F101,"CKCPUTC obc","",obc); >         x = conxo(obc,obuf);            /* dump the buffer, */?         obp = obuf;                     /* reset the pointer */ >         obc = 0;                        /* and the counter. */H         return(x);                      /* Return conxo's return code */     } else return(0);  }    9 /*  C K C G E T C  --  C-Kermit CONNECT Get Character  */  /**   Buffered read from communication device.@   Returns the next character, refilling the buffer if necessary.B   On error, returns ttinc's return code (see ttinc() description).A   Dummy argument for compatible calling conventions with ttinc().  */ int  ckcgetc(dummy) int dummy; { 
     int c, n;    1     debug(F101,"CKCGETC 1 ibc","",ibc); /* Log */ D     if (ibc < 1) {                      /* Need to refill buffer? */>         ibc = 0;                        /* Yes, reset count */@         ibp = ibuf;                     /* and buffer pointer */@         debug(F100,"CKCGETC 1 calling ttinc(0)","",0); /* Log */J         c = ttinc(0);                   /* Read one character, blocking */8         debug(F101,"CKCGETC 1 ttinc(0)","",c); /* Log */I         if (c < 0) {                    /* If error, return error code */              return(c);J         } else {                        /* Otherwise, got one character */D             *ibp++ = c;                 /* Advance buffer pointer */8             ibc++;                      /* and count. */	         }    ?         /* Now quickly read any more that might have arrived */   ?         if ((n = ttchk()) > 0) {        /* Any more waiting? */ C             if (n > (IBUFL - ibc))      /* Get them all at once. */ C               n = IBUFL - ibc;          /* Don't overflow buffer */ 1             if ((n = ttxin(n,(CHAR *)ibp)) > 0) { =                 ibp += n;               /* Advance pointer */ 9                 ibc += n;               /* and counter */              } else return (-1); 	         } >         debug(F101,"CKCGETC 2 ibc","",ibc); /* Log how many */         ibp = ibuf;      } L     c = *ibp++ & 0xff;                  /* Get next character from buffer */A     ibc--;                              /* Reduce buffer count */ B     return(c);                          /* Return the character */ }   4 /*  C O N E C T  --  Perform terminal connection  */   int 
 conect() {H     PID_T pid;                  /* Process id of child (modem reader) */=     int n;                      /* General purpose counter */ H     int c;                      /* c is a character, but must be signed H                                    integer to pass thru -1, which is theE                                    modem disconnection signal, and is G                                    different from the character 0377 */ 1     int c2;                     /* A copy of c */ 7     int csave;                  /* Another copy of c */ K     int num;                    /* Another counter - used with dgncinb() */ 0     char ch;                    /* Ditto here */   #ifdef DYNAMICH     if (!(ibuf = malloc(IBUFL+1))) {    /* Allocate input line buffer */C         printf("Sorry, CONNECT input buffer can't be allocated\n");          return(0);     } H     if (!(obuf = malloc(OBUFL+1))) {    /* Allocate input line buffer */D         printf("Sorry, CONNECT output buffer can't be allocated\n");         free(ibuf); ibuf = 0;          return(0);     } H     if (!(temp = malloc(TMPLEN+1))) {    /* Allocate temporary buffer */G         printf("Sorry, CONNECT temporary buffer can't be allocated\n");          free(ibuf); ibuf = 0;          free(obuf); obuf = 0;          return(0);     }  #endif /* DYNAMIC */       if (!local) {  #ifdef NETCONN?         printf("Sorry, you must SET LINE or SET HOST first\n");  #else 3         printf("Sorry, you must SET LINE first\n");  #endif /* NETCONN */         return(0);     }      if (backgrd) {         printf( N "\r\nSorry, Kermit's CONNECT command can be used only in the foreground\r\n");         return(0);     } %     if (speed < 0L && network == 0) { 4         printf("Sorry, you must SET SPEED first\n");         return(0);     }  #ifdef TCPSOCKET+     if (network && (nettype != NET_TCPB)) { 6         printf("Sorry, network type not supported\n");         return(0);     }  #endif /* TCPSOCKET */    N     if (ttyfd < 0) {                    /* If communication device not open */@         debug(F111,"ckdcon opening",ttname,0); /* Open it now */1         if (ttopen(ttname,&local,mdmtyp,0) < 0) { 8             sprintf(temp,"Sorry, can't open %s",ttname);             perror(temp); 5             debug(F110,"ckdcon open failure",temp,0);  #ifdef DYNAMIC+             if (ibuf) free(ibuf); ibuf = 0; +             if (obuf) free(obuf); obuf = 0; +             if (temp) free(temp); temp = 0;  #endif /* DYNAMIC */             return(0);	         }      } F     dohangup = 0;                       /* Hangup not requested yet */     if (!quiet) {  #ifdef NETCONN         if (network) {3             printf("Connecting to host %s",ttname);          } else { #endif /* NETCONN */.             printf("Connecting to %s",ttname);9             if (speed > -1L) printf(", speed %ld",speed);  #ifdef NETCONN	         }  #endif /* NETCONN */A         printf(".\r\nThe escape character is %s (ASCII %d).\r\n", %                dbchr(escape),escape); K         printf("Type the escape character followed by C to get back,\r\n"); =         printf("or followed by ? to see other options.\r\n");          if (seslog) { 5             printf("(Session logged to %s, ",sesfil); :             printf("%s)\r\n", sessft ? "binary" : "text");	         } 8         if (debses) printf("Debugging Display...)\r\n");     }   < /* Condition console terminal and communication line */            if (conbin(escape) < 0) { <         printf("Sorry, can't condition console terminal\n"); #ifdef DYNAMIC+             if (ibuf) free(ibuf); ibuf = 0; +             if (obuf) free(obuf); obuf = 0; +             if (temp) free(temp); temp = 0;  #endif /* DYNAMIC */         return(0);     } )     debug(F101,"connect cmask","",cmask); +     debug(F101,"connect cmdmsk","",cmdmsk);      goterr = 0; K     if ((n = ttvt(speed,flow)) < 0) {   /* Enter "virtual terminal" mode */ (         debug(F101,"CONNECT ttvt","",n);?         goterr = 1;                     /* Error recovery... */ K         tthang();                       /* Hang up and close the device. */          ttclos(0);H         if (ttopen(ttname,&local,mdmtyp,0) < 0) { /* Open it again... */:             sprintf(temp,"Sorry, can't reopen %s",ttname);             perror(temp);  #ifdef DYNAMIC+             if (ibuf) free(ibuf); ibuf = 0; +             if (obuf) free(obuf); obuf = 0; +             if (temp) free(temp); temp = 0;  #endif /* DYNAMIC */             return(0);	         } N         if (ttvt(speed,flow) < 0) {     /* Try virtual terminal mode again. */I             conres();                   /* Failure this time is fatal. */ B             printf("Sorry, Can't condition communication line\n"); #ifdef DYNAMIC+             if (ibuf) free(ibuf); ibuf = 0; +             if (obuf) free(obuf); obuf = 0; +             if (temp) free(temp); temp = 0;  #endif /* DYNAMIC */             return(0);	         }      } 4     debug(F101,"connect ttvt ok, escape","",escape);   #ifndef NOCSETS ' /* Set up character set translations */        tcs = gettcs(tcsr,tcsl);  M     if (tcsr == tcsl) {                 /* Remote and local sets the same? */ D         sxo = rxo = NULL;               /* If so, no translation. */         sxi = rxi = NULL; ?     } else {                            /* Otherwise, set up */ B         sxo = xls[tcs][tcsl];           /* translation function */K         rxo = xlr[tcs][tcsr];           /* pointers for output functions */ F         sxi = xls[tcs][tcsr];           /* and for input functions. */         rxi = xlr[tcs][tcsl];      }  /*M   This is to prevent use of zmstuff() and zdstuff() by translation functions. L   They only work with disk i/o, not with communication i/o.  Luckily Russian0   translation functions don't do any stuffing... */     langsv = language; #ifndef NOCYRIL      if (language != L_RUSSIAN) #endif /* NOCYRIL */       language = L_USASCII;    #ifdef SKIPESC /*>   We need to activate the "skip escape sequence" feature when:!   (a) translation is elected, and C   (b) the local and/or remote set is 7-bit set other than US ASCII.  */=     skipesc = (tcs != TC_TRANSP) &&     /* Not transparent */ N       (fcsinfo[tcsl].size == 128 || fcsinfo[tcsr].size == 128) && /* 7 bits */?         (fcsinfo[tcsl].code != FC_USASCII); /* But not ASCII */ I     inesc = ES_NORMAL;                  /* Initial state of recognizer */  #ifdef COMMENT     debug(F101,"tcs","",tcs);      debug(F101,"tcsl","",tcsl);      debug(F101,"tcsr","",tcsr); ;     debug(F101,"fcsinfo[tcsl].size","",fcsinfo[tcsl].size); ;     debug(F101,"fcsinfo[tcsr].size","",fcsinfo[tcsr].size);  #endif /* COMMENT */%     debug(F101,"skipesc","",skipesc);  #endif /* SKIPESC */ #endif /* NOCSETS */   /*E   This is a label we jump back to when the lower fork senses the need    to change modes. */ newfork:  >     debug(F100,"CONNECT starting readfromcommline task","",0);D     parent_id = getpid();               /* Get pid for signalling */?     signal(SIGUSR1,SIG_IGN);            /* Don't kill myself */   J /* ENH - DG specifics inserted here - we do an mtask instead of a vfork */J /* of the code that listens to the comm line and writes to the console  */- /* -- that task is called readfromcommline */   N /* ENH - commented next because timeouts should be handled with signals now */O /*  setto(channel(ttyfdout),60); */     /* Set output timeouts to 60 seconds */ M /*  setto(channel(ttyfd),2);     */     /* Set input timeouts to 2 seconds */ O     mfinit(stdout,1);                   /* Protect output to terminal screen */ ?     if (mtask(readfromcommline, STACK, TASKID, TASKPRI) != 0) { @         conres();                       /* Reset the console. */5         perror("Can't create readfromcommline fork");          if (!quiet) { @         printf("\r\nCommunications disconnect (Back at %s)\r\n",5                *myhost ? myhost : "local MV system"); 	         }          printf("\n"); M         what = W_NOTHING;               /* So console modes are set right. */  #ifndef NOCSETS >         language = langsv;              /* Restore language */ #endif /* NOCSETS */6         parent_id = (PID_T) 0;          /* Clean up */ #ifdef DYNAMIC+             if (ibuf) free(ibuf); ibuf = 0; +             if (obuf) free(obuf); obuf = 0; +             if (temp) free(temp); temp = 0;  #endif /* DYNAMIC */         return(1);N     } else {       /* otherwise start reading from the keyboard (or script) */  L         what = W_CONNECT;               /* Keep track of what we're doing */         active = 1; A         debug(F101,"CONNECT mtask succeeded, duplex:","",duplex);    F         /* Catch communication errors or mode changes in lower fork */  =         if (setjmp(con_env) == 0) {     /* Normal entry... */ L             sjval = 0;                  /* Initialize setjmp return code. */M             signal(SIGUSR1,conn_int);   /* Routine for child process exit. */ F             signal(SIGUSR2,mode_chg);   /* Routine for mode change. */	         }     /*L   Here is the big loop that gets characters from the keyboard and sends themN   out the communication device.  There are two components to the communicationJ   path: the connection from the keyboard to C-Kermit, and from C-Kermit toK   the remote computer.  The treatment of the 8th bit of keyboard characters M   is governed by SET COMMAND BYTESIZE (cmdmsk).  The treatment of the 8th bit G   of characters sent to the remote is governed by SET TERMINAL BYTESIZE =   (cmask).   This distinction was introduced in edit 5A(164).  */             while (active) { #ifndef NOSETKEYA                 if (kmptr) {            /* Have current macro? */ 6                     debug(F100,"kmptr non NULL","",0);N                     if ((c = (CHAR) *kmptr++) == NUL) { /* Get char from it */@                         kmptr = NULL;   /* If no more chars,  */C                         debug(F100,"macro empty, continuing","",0); H                         continue;       /* reset pointer and continue */                     } 7                     debug(F000,"char from macro","",c); 9                 } else                  /* No macro... */  #endif /* NOSETKEY */ J                 setto(channel(0),2);    /* Set device timeout to 2 secs */N                 while (active) {        /* Make sure connection still there */J                     /* terrible kludge calling dgncinb() directly -- we doK                        it so we can set the device timeout and thus prevent I                        this read from hanging forever when the remote has H                        disconnected -- all so that we'll pop back to the8                        prompt when the disconnect occurs                     */G                     num = dgncinb(0,&ch,1); /* Get one keyboard char */ #                     if (num != 1) { K                         if ((num == 0) || (num == -2)) /* Keep trying on */ L                             continue;                  /* timeout or none */L                         else {                         /* Otherwise it's a*/L                             c == -1;                   /* VS error or EOF */N                             break;                     /* dealt w/ in a sec */                         }                      } else {<                         c = ch & 0377;  /* Got a good one */=                         break;          /* Get out of here */                      }                  } E                 resto(channel(0));      /* Undo the device timeout */ D                 if (!active)            /* If remote disconnected */5                     break;              /* Get out */ G                 if (c == -1) {          /* If read() got an error... */ 2                     conoc(BEL);         /* Beep */I                     break;              /* and terminate the read loop */                  } 7                 /* debug(F111,"** KEYB",dbchr(c),c); */ F                 c &= cmdmsk;            /* Do any requested masking */ #ifndef NOSETKEY /*H   Note: kmptr is NULL if we got character c from the keyboard, and it isF   not NULL if it came from a macro.  In the latter case, we must avoid   expanding it again.  */J                 if (!kmptr && macrotab[c]) { /* Macro definition for c? */L                     kmptr = macrotab[c];     /* Yes, set up macro pointer */H                     continue;                /* and restart the loop, */N                 } else c = keymap[c];        /* else use single-char keymap */ #endif /* NOSETKEY */                  if (    #ifndef NOSETKEY                     !kmptr &&  #endif /* NOSETKEY */ E                     ((c & 0x7f) == escape)) { /* Escape character? */ :                     debug(F000,"connect got escape","",c);D                     c = congks(0) & 0177; /* Got esc, get its arg */-                     /* No key mapping here */ <                     doesc(c);           /* Now process it */   K                 } else {                /* It's not the escape character */ H                     csave = c;          /* Save it before translation */@                                         /* for local echoing. */ #ifndef NOCSETS  #ifndef SKIPESC 2                     /* Translate character sets */M                     if (sxo) c = (*sxo)(c); /* From local to intermediate. */ N                     if (rxo) c = (*rxo)(c); /* From intermediate to remote. */ #else N                     if (inesc == ES_NORMAL) { /* If not inside escape seq.. */6                         /* Translate character sets */L                         if (sxo) c = (*sxo)(c); /* Local to intermediate. */M                         if (rxo) c = (*rxo)(c); /* Intermediate to remote. */                      } N                     if (skipesc) chkaes(c); /* Check escape sequence status */ #endif /* SKIPESC */ #endif /* NOCSETS */ /*B  If Shift-In/Shift-Out is selected and we have a 7-bit connection,  handle shifting here. */O                     if (sosi) {                    /* Shift-In/Out selected? */ N                         if (cmask == 0177) {       /* In 7-bit environment? */I                             if (c & 0200) {        /* 8-bit character? */ M                                 if (outshift == 0) {    /* If not shifted, */ D                                     ttoc(dopar(SO));    /* shift. */1                                     outshift = 1; !                                 } $                             } else {M                                 if (outshift == 1) {    /* 7-bit character */ I                                     ttoc(dopar(SI));    /* If shifted, */ F                                     outshift = 0;       /* unshift. */!                                 }                              }                          } F                         if (c == SO) outshift = 1; /* User typed SO */F                         if (c == SI) outshift = 0; /* User typed SI */                     } L                     c &= cmask;         /* Apply Kermit-to-host mask now. *// 		    if (c == '\015') {		/* Carriage Return */  			int stuff = -1;) 			if (tnlm) {		/* TERMINAL NEWLINE ON */ " 			    stuff = LF; 	/* Stuff LF */
 #ifdef TNCODE 8 			} else if (network &&	/* TELNET NEWLINE ON/OFF/RAW */! 				   (ttnproto == NP_TELNET) &&  				   (tn_nlm != TNL_CR)) {/ 			    stuff = (tn_nlm == TNL_CRLF) ? LF : NUL;  #endif /* TNCODE */  			} 			if (stuff > -1) {) 			    ttoc(dopar('\015'));	/* Send CR */ 5 			    if (duplex) conoc('\015');	/* Maybe echo CR */ ' 			    c = stuff;			/* Char to stuff */  			    csave = c;  			} 		    } 
 #ifdef TNCODE H /* If user types the 0xff character (TELNET IAC), it must be doubled. */                     elseO                      if (dopar(c) == IAC && network && ttnproto == NP_TELNET) { ?                                         /* Send one copy now */ K                         ttoc(IAC);      /* and the other one just below. */                      }  #endif /* TNCODE */ ,                     /* Send the character */   .                     if (ttoc(dopar(c)) > -1) {G                         if (duplex) {   /* If half duplex, must echo */ '                             if (debses) J                               conol(dbchr(csave)); /* the original char */O                             else                   /* not the translated one */ +                               conoc(csave); D                             if (seslog) { /* And maybe log it too */+                                 c2 = csave; A                                 if (sessft == 0 && csave == '\r') ,                                   c2 = '\n';,                                 logchar(c2);                             }                          } L                     } else if (active){  /* UNIX doesn't check for active */;                         perror("\r\nCan't send character"); N                         break;           /* UNIX clears active flag instead */                     }                  }              } H         midkill(TASKID);                /* kill comm line reader task */G         if (sjval == 1) {               /* Read error on comm device */              dohangup = 1;  #ifdef NETCONN             if (network) {                 ttclos(0);
             }  #endif /* NETCONN */	         } N         if (sjval == 2)                 /* If it was a mode change, go back */M           goto newfork;                 /* and coordinate with other fork. */ @         conres();                       /* Reset the console. */K         if (quitnow) doexit(GOOD_EXIT,xitsta); /* Exit now if requested. */          if (dohangup > 0) {  #ifndef NODIALK             if (dohangup > 1)           /* If hangup requested, do that. */ A                 if (mdmhup() < 1)       /* Try via modem first */  #endif /* NODIAL */ L                 tthang();               /* And make sure we don't hang up */K             dohangup = 0;               /* again unless requested again. */ 	         } I         mfinit(stdout,0);               /* Un-protect output to screen */ I         what = W_NOTHING;               /* So console modes set right. */  #ifndef NOCSETS >         language = langsv;              /* Restore language */ #endif /* NOCSETS */         parent_id = (PID_T) 0; #ifdef DYNAMIC+             if (ibuf) free(ibuf); ibuf = 0; +             if (obuf) free(obuf); obuf = 0; +             if (temp) free(temp); temp = 0;  #endif /* DYNAMIC */         return(1);     } /* else */ }    void readfromcommline() {
     int c;
     int i;
     int n;I     int tx,x;                     /* variables needed for tn_doop code */    >         if (priv_can()) {               /* Cancel all privs */.             printf("?setuid error - fatal\n");              doexit(BAD_EXIT,-1);	         } H         signal(SIGINT, SIG_IGN);        /* In case these haven't been */E         signal(SIGQUIT, SIG_IGN);       /* inherited from above... */    B         inshift = outshift = 0;         /* Initial shift state. */O         sleep(1);                       /* Wait for parent's handler setup.  */ H         ibp = ibuf;                     /* Initialize input buffering */C         ibc = 0;                        /* And output buffering. */          obp = obuf;          obc = 0;I         debug(F100,"CONNECT starting port task (readfromcommline)","",0); L         while (active)  {            /* Fresh read, wait for a character. */ /*E   Get the next communication line character from our internal buffer. $   If the buffer is empty, refill it. */@                 c = ckcgetc(0);         /* Get next character */3                 /* debug(F101,"CONNECT c","",c); */                  if (c < 0) {F                     active = 0;         /* deviation from unix code */7                     if (!quiet) {       /* Failed... */ M                      printf("\r\nCommunications disconnect (Back at %s)\r\n", C                              *myhost ? myhost : "local MV system"); !                     if ( c == -3) >                            perror("\r\nCan't read character");                     }  #ifndef NODIAL%                     if (mdmhup() < 1)  #endif /* NODIAL */ A                       tthang();           /* Hang up our side. */ F                     sjval = 1;            /* Notify parent - kludge */A                     for (;;) pause();     /* Wait to be killed */                  } 1                 debug(F111,"** PORT",dbchr(c),c); 
 #ifdef TNCODE 5                 /* Handle TELNET negotiations here */ C                 if (c == IAC && network && ttnproto == NP_TELNET) { ?                     debug(F111,"got IAC from port",dbchr(c),c); @                     ckcputf();          /* Dump output buffer */<                     tx = tn_doop((c & 0xff),duplex,ckcgetc);9                     debug(F111,"tn_doop returns ","",tx);                       if (tx == 0)!                         continue; G                     else if (tx == -1) {                /* I/O error */ -                         if (active && !quiet) N                       printf("\r\nCommunications disconnect (Back at %s)\r\n",C                              *myhost ? myhost : "local MV system"); #                         active = 0; H                         sjval = 1;          /* Notify parent - kludge */D                         for (;;) pause();   /* Wait to be killed. */J                     } else if ((tx == 1) && (!duplex)) { /* ECHO change */&                         if (parent_id)M                             kill(parent_id,SIGUSR2);    /* Tell the parent */ #                         duplex = 1;  			continue;I                     } else if ((tx == 2) && (duplex)) { /* ECHO change */ &                         if (parent_id)4                             kill(parent_id,SIGUSR2);#                         duplex = 0;  			continue;:                     } else if (tx == 3) { /* Quoted IAC */                          c = 255;L                     } else continue;    /* Negotiation OK, get next char. */                 }  #endif /* TNCODE */ H                 if (debses) {           /* Output character to screen */B                     char *s;            /* Debugging display... */!                     s = dbchr(c);                      while (*s)$                       ckcputc(*s++);D                 } else {                /* or regular display ... */I                     c &= cmask;         /* Apply Kermit-to-remote mask */ :                     if (sosi) {         /* Handle SI/SO */7                         if (c == SO) {  /* Shift Out */ (                             inshift = 1;%                             continue; <                         } else if (c == SI) { /* Shift In */(                             inshift = 0;%                             continue;                          } /                         if (inshift) c |= 0200;                      }  #ifndef NOCSETS  #ifndef SKIPESC 2                     /* Translate character sets */+                     if (sxi) c = (*sxi)(c); +                     if (rxi) c = (*rxi)(c);  #else -                     if (inesc == ES_NORMAL) { 6                         /* Translate character sets *//                         if (sxi) c = (*sxi)(c); /                         if (rxi) c = (*rxi)(c);                      } O                     if (skipesc) chkaes(c); /* Adjust escape sequence status */  #endif /* SKIPESC */ #endif /* NOCSETS */I                     c &= cmdmsk;                /* Apply command mask. */ M                     if (c == CR && tt_crd) { /* SET TERM CR-DISPLAY CRLF ? */ A                         ckcputc(c);          /* Yes, output CR */ /                         if (seslog) logchar(c); H                         c = LF;              /* and insert a linefeed */                     } F                     ckcputc(c);                 /* Output to screen */N                     if (seslog) logchar(c);     /* Take care of session log */                 } 	         }  }       7 /*  H C O N N E  --  Give help message for connect.  */    int 
 hconne() {
     int c;     static char *hlpmsg[] = {  "\r\n  ? for this message",   "\r\n  0 (zero) to send a null", "\r\n  B to send a BREAK", #ifdef NETCONN- "\r\n  I to send a network interrupt packet",  #ifdef TCPSOCKET! "\r\n  A to send Are You There?",  #endif /* TCPSOCKET */ #endif /* NETCONN */- "\r\n  H to hangup and close the connection", $ "\r\n  Q to hangup and quit Kermit", "\r\n  S for status", ! "\r\n  ! to push to local shell",  "\r\n  \\ backslash code:", ' "\r\n    \\nnn decimal character code", & "\r\n    \\Onnn octal character code",, "\r\n    \\Xhh  hexadecimal character code",* "\r\n    terminate with carriage return.",D "\r\n type the escape character twice to send the escape character",7 "\r\n space-bar to resume the CONNECT command\r\n\r\n",  "" }; '     conol("\r\nPress C to return to "); 4     conol(*myhost ? myhost : "the C-Kermit prompt");     conol(", or:"); E     conola(hlpmsg);                     /* Print the help message. */ A     conol("Command>");                  /* Prompt for command. */ N     c = congks(0) & 0177;               /* Get character, strip any parity. */,     /* No key mapping or translation here */     if (c != CMDQ)       conoll(""); 8     return(c);                          /* Return it. */ }     ; /*  D O E S C  --  Process an escape character argument  */    VOID #ifdef CK_ANSIC 
 doesc(char c)  #else  doesc(c) char c; #endif /* CK_ANSIC */ 
 /* doesc */ {      CHAR d, buf[3];         while (1) { C         if (c == escape) {              /* Send escape character */ *             d = dopar(c); ttoc(d); return;G         } else                          /* Or else look it up below. */ +             if (isupper(c)) c = tolower(c);            switch(c) {   >         case 'c':                       /* Close connection */         case '\03': .             active = 0; conol("\r\n"); return;  A         case 'b':                       /* Send a BREAK signal */          case '\02':              ttsndb(); return;    #ifdef NETCONN<         case 'i':                       /* Send Interrupt */         case '\011': #ifdef TCPSOCKET
 #ifndef IP #define IP 244 #endif /* IP */ @             if (network && ttnproto == NP_TELNET) { /* TELNET */<                 buf[0] = (CHAR) IAC;    /* I Am a Command */?                 buf[1] = (CHAR) IP;     /* Interrupt Process */                  ttol(buf,2);             } else #endif /* TCPSOCKET */               conoc(BEL);              return;  #ifdef TCPSOCKET>         case 'a':                       /* "Are You There?" */         case '\01':  #ifndef AYT  #define AYT 246  #endif /* AYT */3             if (network && ttnproto == NP_TELNET) { <                 buf[0] = (CHAR) IAC;    /* I Am a Command */<                 buf[1] = (CHAR) AYT;    /* Are You There? */                 ttol(buf,2);             } else conoc(BEL);             return;  #endif /* TCPSOCKET */ #endif /* NETCONN */  4         case 'h':                       /* Hangup */-     /*  case '\010':  */		/* Too dangerous */ G             dohangup = 2; active = 0; conol("\r\nHanging up "); return;            case 'q': ;             quitnow = 1; active = 0; conol("\r\n"); return;   4         case 's':                       /* Status */             sprintf(temp, O                     "\r\nConnected %s %s", network ? "to" : "through", ttname);              conol(temp);             if (speed >= 0L) {?                 sprintf(temp,", speed %ld",speed); conol(temp); 
             } G             sprintf(temp,", %d terminal bits",(cmask == 0177) ? 7 : 8);              conol(temp);             if (parity) {                  conol(", ");!                 switch (parity) { 4                     case 'e': conol("even");  break;4                     case 'o': conol("odd");   break;4                     case 's': conol("space"); break;4                     case 'm': conol("mark");  break;                 } !                 conol(" parity"); 
             }              if (seslog) { 6                 conol(", logging to "); conol(sesfil);
             }              conoll(""); #             if (!network) shomdm();              return;   2         case '?':                       /* Help */#             c = hconne(); continue;   9         case '0':                       /* Send a null */ 4             c = '\0'; d = dopar(c); ttoc(d); return;   #ifndef NOPUSHN         case '@':                       /* Start inferior command processor */         case '!': H             conres();                   /* Put console back to normal */;             zshcmd("");                 /* Fork a shell. */ %             if (conbin(escape) < 0) { ;                 printf("Error resuming CONNECT session\n");                  active = 0; 
             }              return;  #endif /* NOPUSH */   ;         case SP:                        /* Space, ignore */              return;   3         default:                        /* Other */ >             if (c == CMDQ) {            /* Backslash escape */                 int x;                 kbp = kbuf;                  *kbp++ = c; K                 while (((c = (congks(0) & cmdmsk)) != '\r') && (c != '\n'))                    *kbp++ = c; '                 *kbp = NUL; kbp = kbuf; :                 x = xxesc(&kbp);        /* Interpret it */A                 if (x >= 0) {           /* No key mapping here */ !                     c = dopar(x);                      ttoc(c);                     return; E                 } else {                /* Invalid backslash code. */                      conoc(BEL);                      return;                  } 
             } C             conoc(BEL); return;         /* Invalid esc arg, beep */ 	         }      }  }    VOID #ifdef CK_ANSIC  logchar(char c)  #else  logchar(c) char c; #endif /* CK_ANSIC */ D /* logchar */ {                 /* Log character c to session log */     if (seslog)        if ((sessft != 0) ||           (c != '\r' &&             c != '\0' &&             c != XON &&            c != XOFF))#         if (zchout(ZSFILE,c) < 0) {              conoll(""); =             conoll("ERROR WRITING SESSION LOG, LOG CLOSED!");              seslog = 0; 	         }  } 