6 char *ckxv = "Data General tty I/O, 5A(101) 8 Feb 94";   /*  C K D T I O  */   H /* C-Kermit interrupt, terminal control & i/o functions for DG AOS/VS */   /*?   Author: Frank da Cruz (fdc@columbia.edu, FDCCU@CUVMA.BITNET), B   Columbia University Academic Information Systems, New York City.  N   Copyright (C) 1985, 1993, Trustees of Columbia University in the City of NewK   York.  The C-Kermit software may not be, in whole or in part, licensed or L   sold for profit as a software product itself, nor may it be included in orM   distributed with commercial products or otherwise distributed by commercial J   concerns to their clients or customers without written permission of theK   Office of Kermit Development and Distribution, Columbia University.  This =   copyright notice must not be removed, altered, or obscured.   B   This module originally adapted to the Data General computers by:B   Phil Julian, SAS Institute, Inc., Box 8000, Cary, NC 27512-8000.;   Adapted to C-Kermit 5A by Eugenia Harris of Data General.  */N #define MAXINBUF 2048                  /* See ckdcon.c for same definition. */ #nolist  #include <memory.h>  #include <string.h>  #include <dglib.h> #include <bit.h> #include <sysid.h> #include <sys_calls.h> #include <packets/normal_io.h>8 #include <multitask.h>                                   #include <paru.h>  #include    <stdio.h>  #include    <packets:common.h>$ #include <packets:characteristics.h> #list J #define CONINT_TSK 20                   /* Task id of interrupt-checker */C #define CONINT_PRI 0                    /* Same as calling task */   #define CONINT_STACK 02000D int con_reads_mt = 0;                   /* Flag if task is active */? int conint_ch;                          /* MT character read */ F int conint_avl;                         /* Flag that char available */
 int termtype; , /* Delimiter table -- defaults to CR only */& short idel_tbl[7] = {0x4,0,0,0,0,0,0};? #include <stdio.h>                      /* Unix Standard i/o */    #ifndef DEVNAMLEN ! #define DEVNAMLEN (L_ctermid + 6)  #endif     #ifdef  NETCONN  #undef DEVNAMLENK #define DEVNAMLEN 50                    /* longer field for host:service */  #endif  /* NETCONN */   7 #include <sys/dir.h>                    /* Directory */ = #include <ctype.h>                      /* Character types */   1 /* Maximum length for the name of a tty device */  #ifndef DEVNAMLEN  #define DEVNAMLEN 25 #endif  ? #include <stdio.h>                      /* Unix Standard i/o */ 8 #include <signal.h>                     /* Interrupts */7 #include <setjmp.h>                     /* Longjumps */ K #include "ckcdeb.h"                     /* Typedefs, formats for debug() */  #include "ckcnet.h"  #include <sys/stat.h>    #ifdef datageneral& char *ckxsys = " Data General AOS/VS"; #endif   /* Features... */    #define MYREAD   /*&  Variables available to outside world:  A    dftty  -- Pointer to default tty name string, like "/dev/tty". 7    dfloc  -- 0 if dftty is console, 1 if external line.     dfprty -- Default parity !    dfflow -- Default flow control 0    ckxech -- Flag for who echoes console typein:0      1 - The program (system echo is turned off)0      0 - The system (or front end, or terminal).E    functions that want to do their own echoing should check this flag     before doing so.   9    flfnam -- Name of lock file, including its path, e.g., A                 "/usr/spool/uucp/LCK..cul0" or "/etc/locks/tty77" >    haslock -- Flag set if this kermit established a uucp lock.:    inbufc -- number of tty line rawmode unread characters %                 (system III/V unixes) E    backgrd -- Flag indicating program executing in background ( & on  K                 end of shell command). Used to ignore INT and QUIT signals.   9 /* Declarations of variables global within this module */    B static time_t tcount;                   /* Elapsed time counter */F SIGTYP (*saval)() = NULL;               /* For saving alarm handler */   D /* The following lists of functions are somewhat out of date.  For a    better listing, see ckutio.c   K Functions for assigned communication line (either external or console tty):   E    sysinit()               -- System dependent program initialization J    ttopen(ttname,local,mdmtyp) -- Open the named tty for exclusive access.O    ttclos()                -- Close & reset the tty, releasing any access lock. K    ttpkt(speed,flow,parity)-- Put the tty in packet mode and set the speed. C    ttvt(speed,flow)        -- Put the tty in virtual terminal mode. M                               or in DIALING or CONNECTED modem control state. B    ttinl(dest,max,timo,eol,start) -- Timed read line from the tty.<    ttinc(timo)             -- Timed read character from tty.G    myread()                -- System 3 raw mode bulk buffer read, gives J                            -- subsequent chars one at a time and simulates'                            -- FIONREAD! J    ttchk()                 -- See how many characters in tty input buffer.C    ttxin(n,buf)            -- Read n characters from tty (untimed). 8    ttol(string,length)     -- Write a string to the tty.;    ttoc(c)                 -- Write a character to the tty. 5    ttflui()                -- Flush tty input buffer. B    ttfluo()                -- Flush tty output buffer.  (not used)H    ttgmdm()                -- Returns status of modem signals (not used)7    ttgspd()                -- Returns speed of tty line 8    ttsspd(cps)             -- Set line speed on tty lineD    ttimoff()               -- Turns off all pending timer interrupts@    ttscarr(carrier)        -- Copies argument to global variableB    ttwmdm(mdmsig,timo)     -- Wait for specified signal (not used)E    ttlock(ttname)          -- Lock against uucp collisions (not used) E    ttunlck()               -- Unlock "       "     "       (not used) E    look4lk(ttname)         -- Check if a lock file exists  (not used)    Functions for console terminal:   +    congm()   -- Get console terminal modes. N    concb(esc) -- Put the console in single-character wakeup mode with no echo.7    conbin(esc) -- Put the console in binary (raw) mode. @    conres()  -- Restore the console to mode obtained by congm().<    conoc(c)  -- Unbuffered output, one character to console.I    conol(s)  -- Unbuffered output, null-terminated string to the console. C    conola(s) -- Unbuffered output, array of strings to the console. @    conxo(n,s) -- Unbuffered output, n characters to the console.C    conchk()  -- Check if characters available at console (bsd 4.2).   J                 Check if escape char (^\) typed at console (System III/V).;    coninc(timo)  -- Timed get a character from the console. L    conint()  -- Enable terminal interrupts on the console if not background.M    connoi()  -- Disable terminal interrupts on the console if not background. 4    congks(timo) -- Get keyboard scan code (not used)   Time functions:   !    msleep(m) -- Millisecond sleep 2    ztime(&s) -- Return pointer to date/time string    rtimer() --  Reset timer <    gtimer()  -- Get elapsed time since last call to rtimer() */   /* System III, System V */   #ifdef UXIII #ifdef datageneral2 /* Console and terminal characteristics vectors */ short *charcurr;: short charconin[$CLMAX];    /* Console input; channel 0 */; short charconout[$CLMAX];   /* Console output; channel 1 */ 5 short chartty[$CLMAX];      /* generic tty channel */ : short charttyin[$CLMAX];    /* tty input; channel ttyfd */> short charttyout[$CLMAX];   /* tty output; channel ttyfdout */ short ch_ttold[$CLMAX];  short ch_ttraw[$CLMAX];  short ch_ttvt[$CLMAX];   short ch_ccold[$CLMAX];  short ch_ccraw[$CLMAX];  short ch_ccbrk[$CLMAX];  #undef ECHO  #include <sys/termio.h> ' /* Add synonymns for Unix type ioctl */  #define TCSETAF TCSETA #define TCSETAW TCSETA #else  #include <termio.h>  #include <sys/ioctl.h> #endif datageneral  K #include <fcntl.h>                      /* directory reading for locking */ N #include <errno.h>                      /* error numbers for system returns */ #endif   /* Declarations */  L long time();                            /* All Unixes should have this... */F extern int errno;                       /* System call error return */ extern int ttnproto; extern int ttnet; > extern int xfrcan, xfrchr, xfrnum;	/* Transfer cancellation */  F /* dftty is the device name of the default device for file transfer */O /* dfloc is 0 if dftty is the user's console terminal, 1 if an external line */   K char *dftty = CTTNAM;                   /* Remote by default, use normal */ H int dfloc = 0;                          /* controlling terminal name. */? int dfprty = 0;                         /* Parity (0 = none) */ C int dfflow = 1;                         /* Xon/Xoff flow control */ L int backgrd = 0;                        /* Assume in foreground (no '&' ) */L int ckxech = 0; /* 0 if system normally echoes console characters, else 1 */  9 /* Declarations of variables global within this module */   B static long tcount;                     /* Elapsed time counter */? static char *brnuls = "\0\0\0\0\0\0\0"; /* A string of nulls */ = static jmp_buf sjbuf, jjbuf;            /* Longjump buffer */   < static int lkf = 0,                     /* Line lock flag */L     conif = 0,                          /* Console interrupts on/off flag */K     cgmf = 0,                           /* Flag that console modes saved */ J     xlocal = 0;                         /* Flag for tty local or remote */K     curcarr = 0;                        /* Carrier mode: require/ignore. */ A int ttyfd = -1;                         /* TTY file descriptor */  int tvtflg = 0; > long ttspeed = -1;                      /* For saving speed */= int ttflow = -9;                        /* For saving flow */ = int ttld = -1;                          /* Line discipline */  int ttfdflg = 0; int ttpmsk = 0377; int ttprty = 0; C int ttpflg = 0;                         /* Parity not sensed yet */  int ttmdm = 0;D int ttcarr = CAR_AUT;                   /* Carrier handling mode. */ int telnetfd = 0;  static int netconn = 0;  int fdflag = 0; F static char escchr;                     /* Escape or attn character */K static int kerld = 0;                   /* Not selected, no special l.d. */  int x25fd = 0;   #ifdef UXIII;   static struct termio                  /* sgtty info... */ D     ttold, ttraw, tttvt,                /* for communication line */=     ccold, ccraw, cccbrk;               /* and for console */  #else ;   static struct sgttyb                  /* sgtty info... */ D     ttold, ttraw, tttvt, ttbuf,         /* for communication line */=     ccold, ccraw, cccbrk;               /* and for console */  #endif  F char flfnam[80];                        /* uucp lock file path name */K int haslock = 0;                        /* =1 if this kermit locked uucp */   O static int inbufc = 0;                  /* stuff for efficient SIII raw line */ J static int ungotn = -1;                 /* pushback to unread character */M static int conesc = 0;                  /* set to 1 if esc char (^\) typed */   O static int ttlock();                    /* definition of ttlock subprocedure */ E static int ttunlck();                   /* and unlock subprocedure */ J static char ttnmsv[DEVNAMLEN];          /* copy of open path for tthang */   #ifdef datageneralD FILE *ttfile,*ttfileout;                /* Files opened by ttopen */   J struct p_nio_ex w_io_parms;             /* ?write system call structure */I struct p_nio_ex r_io_parms;             /* ?read system call structure */   F struct p_nio_ex io_parms;               /* open structure in ttopen */N struct p_nio_ex x_io_parms;             /* ?read/?write structure for ttyfd */K struct p_nio_ex xout_parms;             /* ?write structure for ttyfdout */  struct p_screen x_io_scrn,B        r_io_scrn,io_screen;             /* Edit-read structures */  O int ttyfdout = -1;                      /* ?write Unix number for remote out */ L short timotty = 0;                      /* {Flag for timeouts (=1), value */N short timocon = 0;                      /* tty is ttyfd..., con is Unix 0/1 */J extern char *SPACMD;                    /* returns space in CURRENT dir */ #endif  < /* Timeout handler for communication line input functions */    SIGTYPE timerh(foo) int foo; {                  /* we will try to use this */      ttimoff();     longjmp(sjbuf,1);  }    ; /* Control-C trap for communication line input functions */ L /* These are not used in the VS implementation.  Instead, there is a task */L /* called conint_mt that reads characters from the keyboard and sets a    */L /* flag when it gets one.  It is then up to other routines (e.g., chkint()*/L /* to determine what to do with the characters (and zero the flag)  --ENH */   2 int cc_int;                             /* Flag */K SIGTYP (* occt)();                      /* For saving old SIGINT handler */     SIGTYPB cctrap(foo) int foo; {                  /* Needs arg for ANSI C */A   cc_int = 1;                           /* signal() prototype. */ 	   return;  }    C /*  S Y S I N I T  --  System-dependent program initialization.  */    int  sysinit() {    #ifdef datageneralH      /* Set up many things on the DG system, for initialization, etc. */             short flags[3];      char *username;
      int err;              signal(SIGALRM,SIG_IGN);   L      /* Get the terminal type, since DG terminals are different from others,9         especially in the way BS is handled ('\b' is EM). <         termtype = 0 means a regular DG style terminal, and H         termtype = 1 means an ANSI style terminal with ^H for backspace.I         If Kermit is run in batch or has redirected input, then we do not 8         want to test or set the console characteristics.      */       termtype = 0;      if (isatty(0)) { .         if (sys_gchr(channel(0),1<<31,&flags)):              { perror("sysinit: sys_gchr: "); return(1); }  8         /* Only determine whether or not it is a $TTY */6         if ((flags[1] & $DTYPE) == $TTY) termtype = 1;      }  4      zero((char *) &w_io_parms, sizeof(w_io_parms));A      w_io_parms.ich  = channel(1);                   /* stdout */ /      w_io_parms.isti = $IBIN|$RTDS|$ICRF|$OFOT;       w_io_parms.isti &= ~$IPST; "      w_io_parms.imrs = MAXINBUF-1;      w_io_parms.ibad = -1;      w_io_parms.ircl = -1;  4      zero((char *) &r_io_parms, sizeof(r_io_parms));@      r_io_parms.ich  = channel(0);                   /* stdin *//      r_io_parms.isti = $IBIN|$RTFX|$ICRF|$OFIN;       r_io_parms.isti &= ~$IPST; "      r_io_parms.imrs = MAXINBUF-1;      r_io_parms.ibad = -1;      r_io_parms.ircl = -1;  2      zero((char *) &r_io_scrn, sizeof(r_io_scrn));H      r_io_parms.etsp = 0;              /* Screen management extension */<      r_io_scrn.esfc &= ~$ESNE;         /* Echo input data */;      r_io_scrn.esfc &= ~$ESSE;         /* No screen edit */ =      r_io_scrn.esfc |= $ESGT;          /* Dump ring buffer */   4      zero((char *) &x_io_parms, sizeof(x_io_parms));H      /* $RTDY must be used instead of $RTDS since this causes failure onG       * the Prime, which is probably getting data overruns on output or @       * missing data.  Also, $RTDY is more efficient and faster.       */5      x_io_parms.isti = $IBIN|$RTFX|$ICRF|$OFIO|$IPKL;       x_io_parms.isti &= ~$IPST; "      x_io_parms.imrs = MAXINBUF-1;      x_io_parms.ibad = -1;      x_io_parms.ircl = -1;  =      /* IDEL would default to NULL, FF, CR, NL as delimiters. C       * The only delimiters here are CR and NL, for data sensitive         * records.       */      idel_tbl[0] = 0x24;       x_io_parms.idel = idel_tbl;  2      zero((char *) &x_io_scrn, sizeof(x_io_scrn));H      x_io_parms.etsp = &x_io_scrn;     /* Screen management extension */A      x_io_parms.etsp |= BIT0;          /* Turn on the high bit */ <      x_io_scrn.esfc &= ~$ESNE;         /* Echo input data */;      x_io_scrn.esfc &= ~$ESSE;         /* No screen edit */ =      x_io_scrn.esfc |= $ESGT;          /* Dump ring buffer */   J      memcpy((char *) &xout_parms,(char *) &x_io_parms,sizeof(x_io_parms));/      xout_parms.isti = $IBIN|$RTDY|$ICRF|$OFOT; H      xout_parms.etsp = 0;              /* Screen management extension */  "      username = getenv("LOGNAME");  2      /* Zero the console characteristics arrays */2      zero ((char *) charconin, sizeof(charconin));4      zero ((char *) charconout, sizeof(charconout));.      zero ((char *) chartty, sizeof(chartty));2      zero ((char *) charttyin, sizeof(charttyin));4      zero ((char *) charttyout, sizeof(charttyout));       $      /* Initialize charconin & out, 3       * and set up the console for CHAR/BREAK=BMOB         */A           if (sys_gechr( channel(0), (1<<31)|$CLMAX, charconin))  :                { perror("sysinit: gechr 0"); return(-1); }B           if (sys_gechr( channel(1), (1<<31)|$CLMAX, charconout)) :                { perror("sysinit: gechr 1"); return(-1); }!           charconin[4] &= ~$CBKM;             charconin[4] |= $CBBM;A           if (sys_sechr( channel(0), (1<<31)|$CLMAX, charconin))  ?                { perror("sysinit: sechr stdin "); return(-1); } A           if (sys_sechr( channel(1), (1<<31)|$CLMAX, charconout)) @                { perror("sysinit: sechr stdout "); return(-1); }        return(0);  }   5 /* S E T T O -- set timeout on the channel to period. =                 Save the old characteristics in char***in[].   */L /* AOS/VS device timeouts are used sparingly in this implementation of    */L /* Kermit.  In most cases, signals are used instead.                --ENH */  * int setto(chan, period) int chan, period;  {       int isconsole = 0; D      int iscon[2];       /* Flags because i/o could be redirected */  I      /* Setting is done external to here, since they can distinguish the  E         console from ttyfd device.  Both console channels must be set          the same.       */ :      if ( (chan == channel(0)) || (chan == channel(1)) ) {=           isconsole = 1; zero((char *) iscon, sizeof(iscon));            chan = channel(0);A           if (sys_gechr( channel(0), (1<<31)|$CLMAX, charconin))                  if (isatty(0)) { !                     iscon[0] = 1; 0                     perror("setto: gechr 0: ");                      return(-1);                 }           charcurr = charconin; B           if (sys_gechr( channel(1), (1<<31)|$CLMAX, charconout))                 if (isatty(1)) { !                     iscon[1] = 1; 0                     perror("setto: gechr 1: ");                      return(-1);                 }           timocon = period;       }        else { 8           if (sys_gechr( chan, (1<<31)|$CLMAX, chartty))<                { perror("setto: gechr tty: "); return(-1); }           charcurr = chartty;            timotty = period;       }  $      charcurr[1] |= (0100000>>$CTO);4      if (sys_sechr( chan, (1<<31)|$CLMAX, charcurr))-           if ((isconsole == 0) || iscon[0]) { )                perror("setto: sechr: ");                  return(-1);             } )      if (sys_stom( chan, 1<<31, period))  -           if ((isconsole == 0) || iscon[0]) { (                perror("setto: stom: ");                 return(-1);           }   #      if (isconsole == 0) return(0);              chan = channel(1); &      charconout[1] |= (0100000>>$CTO);7      if (sys_sechr( chan, (1<<31)|$CLMAX, charconout))             if (iscon[1]) { +                perror("setto: sechr 1: ");                  return(-1);           } )      if (sys_stom( chan, 1<<31, period))             if (iscon[1]) { *                perror("setto: stom 1: ");                 return(-1);           }       return(0);  }     J /* R E S T O -- reset timeouts to the previous values, and restore char */   int  resto(chan) int chan;  { #      int i, chan0, chan1, iscon[2];   6      if ( (chan==channel(0)) || (chan==channel(1)) ) {  7           chan0 = channel(0);      chan1 = channel(1);  8           iscon[0] = isatty(0);    iscon[1] = isatty(1);+           charconin[1] &= ~(0100000>>$CTO); +           if (sys_stom( chan0, 1<<31, -1))                  if (iscon[0]) {/                     perror("resto: stom 0: ");                       return(-1);                 }?           for (i = 0; i < $CLMAX; i++) if (charconin[i] != 0) { @                if (sys_sechr( chan0, (1<<31)|$CLMAX, charconin))#                     if (iscon[0]) { 5                          perror("resto: sechr 0: ");  %                          return(-1);                       }                 break;            } ,           charconout[1] &= ~(0100000>>$CTO);+           if (sys_stom( chan1, 1<<31, -1))                  if (iscon[1]) {/                     perror("resto: stom 1: ");                       return(-1);                 }@           for (i = 0; i < $CLMAX; i++) if (charconout[i] != 0) {B                if (sys_sechr( chan1, (1<<31)|$CLMAX, charconout))                 if (iscon[1]) {0                     perror("resto: sechr 1: ");                      return(-1);                 }                break;            }              timocon = 0;        }      else { )           chartty[1] &= ~(0100000>>$CTO); *           if (sys_stom( chan, 1<<31, -1)) ;                { perror("setto: stom tty: "); return(-1); } =           for (i = 0; i < $CLMAX; i++) if (chartty[i] != 0) { =                if (sys_sechr( chan, (1<<31)|$CLMAX, chartty)) A                     { perror("resto: sechr tty: "); return(-1); }                 break;            }            timotty = 0;        }             return(0);  }     4 /* S E T F L O W -- Set flow control in the device.        K     The device is assumed to be an intelligent IAC, where a CHAR/ON/IFC/OFC      could be done.   */ int setflow(chan) int chan;  {       short termparms[$CLMAX];   6      if (sys_gechr( chan, (1<<31)|$CLMAX, termparms)) 4           { perror("setflow: gechr "); return(-1); }  #      bitset(&termparms[4],$XOFC,1); #      bitset(&termparms[4],$XIFC,1);        6      if (sys_sechr( chan, (1<<31)|$CLMAX, termparms)) 4           { perror("setflow: sechr "); return(-1); }        return(0);  }     7 /* R E S F L O W -- Re-Set flow control in the device.         L     The device is assumed to be an intelligent IAC, where a CHAR/OFF/IFC/OFC     could be done.   */ int resflow(chan) int chan;  {       int i;       short termparms[$CLMAX];   6      if (sys_gechr( chan, (1<<31)|$CLMAX, termparms)) 4           { perror("resflow: gechr "); return(-1); }  #      bitset(&termparms[4],$XOFC,0); #      bitset(&termparms[4],$XIFC,0);        5      if (sys_sechr( chan, (1<<31)|$CLMAX, termparms)) 4           { perror("resflow: sechr "); return(-1); }        return(0);  }     E /* S E T S P E E D -- Set the baud rate when not possible thru IOCTL.        I     The device is assumed to be an intelligent IAC, where a CHAR/ON/BAUD=      could be done.   */ int setspeed(sp) int sp; {       short termparms[$CLMAX];   F      /* ttyfd is the Unix file number for the tty device.  Setting theF       * characteristics will set it for both ttyfd and ttyfdout, sinceD       * it is the device itself which is affected, and not just the        * channel.       */@      if (sys_gechr( channel(ttyfd), (1<<31)|$CLMAX, termparms)) 5           { perror("setspeed: gechr "); return(-1); }   L      termparms[3] &= ~$BRMSK;            /* Zero out the previous setting */      termparms[3] |= sp;       @      if (sys_sechr( channel(ttyfd), (1<<31)|$CLMAX, termparms)) 5           { perror("setspeed: sechr "); return(-1); }         return(0);  }  #endif datageneral  8 /*  S Y S C L E A N U P  --  System-dependent cleanup */   int  syscleanup() {     return(0); }   9 /*  T T O P E N  --  Open a tty for exclusive access.  */    /*
   Returns:     0 on success    -5 if device is in use #    -4 if access to device is denied (    -3 if access to lock directory denied-    -2 upon timeout waiting for device to open     -1 on other error /*7   If called with lcl < 0, sets value of lcl as follows: D   0: the terminal named by ttname is the job's controlling terminal.H   1: the terminal named by ttname is not the job's controlling terminal.F   But watch out: if a line is already open, or if requested line can't6   be opened, then lcl remains (and is returned as) -1. */ int C ttopen(ttname,lcl,modem,timo) char *ttname; int *lcl, modem,timo; {        /* AOS/VS special stuff */>     FILE *dg_open();                    /* Custom file open */M     int retrycnt = 0;                   /* Retry if Modem disc in progress */   E     char *ctermid();                    /* Wish they all had this! */      char *x;     extern char* ttyname();      char cname[DEVNAMLEN+4];   #define NAMEFD
 #ifdef NAMEFD      int i, j; char *p;.     debug(F101,"ttopen telnetfd","",telnetfd); #endif /* NAMEFD */   2     debug(F111,"ttopen entry modem",ttname,modem);"     debug(F101," ttyfd","",ttyfd);     debug(F101," lcl","",*lcl);        if (ttyfd > -1) { M         if (strncmp(ttname,ttnmsv,DEVNAMLEN))   /* are old & new the same? */ E             ttclos(ttyfd);                      /* no? - close old */ M         else                                    /* yes? - ignore this call */ @             return(0);                          /* and return */     }    #ifdef NETCONNM     if (modem < 0) {                    /* means special code for net type */          int x;         ttmdm = modem;H         modem = -modem;                 /* negative value is net type */B         fdflag = 0;                     /* stdio not redirected */E         ttyfdout = -1;                  /* only use ttyfd for nets */ @         netconn = 1;                    /* network connection *//         debug (F111,"ttopen net",ttname,modem); 
 #ifdef NAMEFD G         for (p = ttname; isdigit(*p); p++) ; /* check for all digits */ %         if (*p == '\0' && telnetfd) { G             ttyfd = atoi(ttname);       /* can we test if it's open? */ K             ttfdflg = 1;               /* we got an open file descriptor */ B             debug(F111,"ttopen got open network fd",ttname,ttyfd);I             strncpy(ttnmsv,ttname,DEVNAMLEN);   /* remember the "name" */ C             x = 1;                      /* return code is "good" */              if (telnetfd) { !                 ttnet = NET_TCPB; %                 ttnproto = NP_TELNET; 
             }          } else {I #endif /* NAMEFD */                             /* hostname or address */ D             x = netopen(ttname,lcl,modem);      /* (see ckcnet.h) */             if (x > -1) { 1                 strncpy(ttnmsv,ttname,DEVNAMLEN);              } else netconn = 0; 
 #ifdef NAMEFD 	         } 
 #endif NAMEFD   , /* ENH - left out ifdef sony_news section */  K         xlocal = *lcl = 1;              /* network connections are local */ (         debug(F101,"ttopen net x","",x); #ifdef COMMENT  /* Let netopen() handle this. */!         if ((x > -1) && (!x25fd)) H             x = tn_ini();               /* initialize telnet protocol */ #endif /* COMMENT */         return(x);=     } else {                            /* terminal device */  #endif /* NETCONN */  
 #ifdef NAMEFD  /*E   This code lets you give Kermit an open file descriptor for a serial K   communication device, rather than a device name.  Kermit assumes that the K   line is already open, locked, conditioned with the right parameters, etc.  */J         for (p = ttname; isdigit(*p); p++) ;    /* check for all digits */         if (*p == '\0') { J             ttyfd = atoi(ttname);               /* can we test if open? */:             debug(F111,"ttopen got open fd",ttname,ttyfd);I             strncpy(ttnmsv,ttname,DEVNAMLEN);   /* remember the "name" */ G             xlocal = *lcl = 1;                  /* assume it's local */ H             netconn = 0;                        /* assume not network */G             tvtflg = 0;                         /* initialize modes? */ I             ttmdm = modem;                      /* remember modem type */ J             fdflag = 0;                         /* stdio not redirected */I             ttfdflg = 1;                        /* flag we were opened */ >                                                 /* this way */$ /* ENH - left out ifdef sony_news */  D             return(0);                          /* return success */	         }  #endif /* NAMEFD */  #ifdef NETCONN      }                            #endif /* NETCONN */  < /* Here we have to open a serial device of the given name */  D     tvtflg = 0;                         /* flag for use by ttvt() */K                                         /* 0 means ttvt() not called yet */ G     fdflag = (!isatty(0) || !isatty(1));/* flag for stdio redirected */ *     debug(F101,"ttopen fdflag","",fdflag);N     ttmdm = modem;                      /* Make this available to other fns */N     xlocal = *lcl;                      /* Make this available to other fns */  7 /* Code for handling bidirectional tty lines goes here. H /* Use specified method for turning off logins and suppressing getty. */    #ifdef ACUCNTRL J     /* Should put call to priv_on() here, but that would be very risky! */A     acucntrl("disable",ttname);         /* acucntrl() program. */       /* and priv_off() here... */ #else  #ifdef ATT7300A     if ((attmodem & DOGETY) == 0)       /* offgetty() program. */ A       attmodem |= offgetty(ttname);     /* Remember response.  */  #endif /* ATT7300 */ #endif /* ACUCNTRL */    #ifdef datageneralM     /* A custom open is done for the device, but a FILE handle is also needed K      * for doing other special operations on the device.  See sysinit() for F      * the initialization of the x_io_parms and xout_parms structures.      *0      * First open up the output channel ($OFOT)       */ 0     idel_tbl[0] = 0x4;             /* CR only */     xout_parms.idel = idel_tbl;      xout_parms.ifnp = ttname;    /*     ttotmo = 0; #     saval = signal(SIGALRM,timerh);      if (timo > 0) { "         alarm(timo);                       if (setjmp(sjbuf)) {         } else {K */           /* Ignore timeout for now - let it take as long as it wants */  retry:     if ((ttfileout =9        dg_open(ttname, xout_parms.isti, xout_parms.isto,  @                xout_parms.imrs,xout_parms.ires,xout_parms.idel))        == NULL) { J           /* If a modem disconnect, or one in progress, wait and retry. */?           if ((lasterror() == ERDCT) || (lasterror() == ERCDS)) #                if (retrycnt == 0) { "                     retrycnt = 1;                      sleep(2);                       goto retry;                 }           ttyfdout = -1;1           perror("ttopen: output_line: dg_open"); L           if ((lasterror() == EREO1) || (lasterror() == EREO2)) /* in use */A               return(-5);                               /* EOF */ (           else if (lasterror() == ERFAD)K               return(-4);                               /* access denied */ N           else                                          /* some other error */               return(-1);      } .     /* Successfull opens fall through here! */     K     ttyfdout = fileno(ttfileout);               /* Note that ttyfdout is */ K     xout_parms.ich = channel(ttyfdout);         /* only used for asynch  */      1     /* Next, open up the input channel ($OFIN) */        x_io_parms.ifnp = ttname; <     /* IDEL would default to NULL, FF, CR, NL as delimiters.B      * The only delimiters here are CR and NL, for data sensitive       * records.       */      idel_tbl[0] = 0x24;      x_io_parms.idel = idel_tbl;        if ((ttfile = 9        dg_open(ttname, x_io_parms.isti, x_io_parms.isto,  ?                x_io_parms.imrs,x_io_parms.ires,x_io_parms.idel, -                (P_SCREEN *) x_io_parms.etsp))         == NULL) {            ttyfd = -1; 0           perror("ttopen: input_line: dg_open");L           if ((lasterror() == EREO1) || (lasterror() == EREO2)) /* in use */A               return(-5);                               /* EOF */ (           else if (lasterror() == ERFAD)K               return(-4);                               /* access denied */ N           else                                          /* some other error */               return(-1);         }
     else {!           ttyfd = fileno(ttfile); *           x_io_parms.ich = channel(ttyfd);     }    #endif  $     /* Make sure it's a real tty. */     if (!isatty(ttyfd)) { 4         fprintf(stderr,"%s is not a tty!\n",ttname);0         debug(F110,"ttopen not a tty",ttname,0);         close(ttyfd);          ttyfd = -1;          return(-1);      }   N     strncpy(ttnmsv,ttname,DEVNAMLEN);   /* Open, keep copy of name locally. */  > /* Caller wants us to figure out if line is controlling tty */  (     debug(F111,"ttopen ok",ttname,*lcl);     if (*lcl == -1) { J         if (strcmp(ttname,CTTNAM) == 0) {   /* "/dev/tty" always remote */3             debug(F110," Same as CTTNAM",ttname,0);              xlocal = 0; K         } else if (isatty(0)) {         /* Else, if stdin not redirected */ J             x = ttyname(0);             /* then compare its device name */M             strncpy(cname,x,DEVNAMLEN); /* (copy from internal static buf) */ *             debug(F110," ttyname(0)",x,0);J             x = ttyname(ttyfd);         /* ...with real name of ttname. */?             xlocal = (strncmp(x,cname,DEVNAMLEN) == 0) ? 0 : 1; ,             debug(F111," ttyname",x,xlocal);J         }                               /* Else, if stdin redirected... */	     }       H /* Now check if line is locked -- if so fail, else lock for ourselves */  8     lkf = 0;                            /* Check lock */     if (xlocal > 0) { !         if (ttlock(ttname) < 0) { E             fprintf(stderr,"Exclusive access to %s denied\n",ttname); %             close(ttyfd); ttyfd = -1; :             debug(F110," Access denied by lock",ttname,0);               return(-3);          } else lkf = 1;      }   8 /* Got the line, now set the desired value for local. */  !     if (*lcl != 0) *lcl = xlocal;   8 /* Request exclusive access on systems that allow it. */   #ifdef TIOCEXCL ,         if (ioctl(ttyfd,TIOCEXCL, NULL) < 0)J             fprintf(stderr,"Warning, problem getting exclusive access\n"); #endif   /* Get tty device settings */   J     ioctl(ttyfd,TCGETA,&ttold);         /* Same deal for Sys III, Sys V */     ioctl(ttyfd,TCGETA,&ttraw);      ioctl(ttyfd,TCGETA,&tttvt);   )     debug(F101,"ttopen, ttyfd","",ttyfd);   /     debug(F101,"ttopen, ttyfdout","",ttyfdout); C     /* For DG, also get the tty extended device characteristics. */ 9     sys_gechr( channel(ttyfd), (1<<31)|$CLMAX, ch_ttold); 9     sys_gechr( channel(ttyfd), (1<<31)|$CLMAX, ch_ttraw); 8     sys_gechr( channel(ttyfd), (1<<31)|$CLMAX, ch_ttvt);       debug(F101," lcl","",*lcl); (     debug(F111," lock file",flfnam,lkf);     return(0); }   ; /*  T T C L O S  --  Close the TTY, releasing any lock.  */  int  ttclos(foo) int foo; {     int x = 0;  (     debug(F101,"ttclos ttyfd","",ttyfd);:     if (ttyfd < 0) return(0);           /* Wasn't open. */J     if (ttfdflg) return(0);             /* If we got ttyfd from another */F                                         /* process, don't close it. */     tvtflg = 0;    #ifdef  NETCONN A     if (netconn) {                      /* Network connection. */ .         debug(F100,"ttclos closing net","",0);7         netclos();                      /* Close it. */          netconn = 0;         return(0);     }  #endif  /* NETCONN */        if (xlocal) { >         debug(F100,"ttclos skipping ttunlck for AOS/VS","",0);9         debug(F100,"ttclos about to call tthang()","",0);      }      if (ttyfd > 0) {N                                         /* & timer stuff &  moved closes in */:         saval = signal(SIGALRM,timerh); /* enable timer */L         alarm(5);                       /* allow 5 seconds for completion */<         if (setjmp(sjbuf)) {            /* timer went off */>             x = -1;                     /* set return value */L         } else {                        /* what we're really trying to do */             if (xlocal) { D                 if (tthang())           /* Hang up first, then... */N                     fprintf(stderr,"Warning, problem hanging up the phone\n");A                 ttres();                /* reset device modes. */ 
             }  #ifdef TIOCEXCL  #ifdef TIOCNXCL 0            if (ioctl(ttyfd, TIOCNXCL, NULL) < 0)K                 fprintf(stderr,"Problem relinquishing exclusive access\n");  #endif #endif  1             debug(F101,"ttclos, ttyfd","",ttyfd); 7             debug(F101,"ttclos, ttyfdout","",ttyfdout); ?             fclose(ttfile);                     /* Close it. */    -             /* Close the output tty device */ ?             fclose(ttfileout);                  /* Close it. */ A             x = 1;                              /* good return */ 	         } D         ttimoff();                              /* turn off timer */         if (x < 0) {E             fprintf(stderr,"?Timed out closing device: %s\n",ttnmsv); 0             debug(F100,"ttclos timed out","",0);	         }      } @     ttyfd = -1;                         /* Mark it as closed. */@     ttyfdout = -1;                      /* Mark it as closed. */  #     debug(F100,"ttclos done","",0);      return(0); }   ' /*  T T H A N G -- Hangup phone line */   
 tthang() {     unsigned short ttc_save;
     int x;  7     if (ttyfd < 0) return(0);           /* Not open. */      if (xlocal < 1) return(0);   #ifdef NETCONNA     if (netconn) {                      /* Network connection. */ :         return ((netclos() < 0) ?  -1 : 1); /* Close it */     }  #endif /* NETCONN */       ttc_save = ttraw.c_cflag; O     ttraw.c_cflag &= ~CBAUD;            /* swa: set baud rate to 0 to hangup */ @     if (ioctl(ttyfd,TCSETAF,&ttraw) < 0) return(-1); /* do it */?     msleep(100);                        /* let things settle */      ttraw.c_cflag = ttc_save; 2     debug(F100, "tthang disconnecting line","",0);>     if (sys_sechr( channel(ttyfd), (1<<31)|$CLMAX, ch_ttraw)) 2          { perror("tthang: sechr "); return(-1); }C     if (ioctl(ttyfd,TCSETAF,&ttraw) < 0) return(-1); /* un-do it */      return (0);  }     9 /*  T T R E S  --  Restore terminal to "normal" mode.  */   H ttres() {                               /* Restore the tty to normal. */
     int x;  7     if (ttyfd < 0) return(-1);          /* Not open. */   O     if (ttfdflg) return(0);             /* Don't mess with terminal modes if */ O                                         /* we got ttyfd from another process */  #ifdef  NETCONN L     if (netconn) return (0);            /* Network connection, do nothing */ #endif  /* NETCONN */   K     x = (ioctl(ttyfd,TCSETAW,&ttold) < 0);       /* restore termio stuff */   !     /* Un-set all the timeouts */      if (timotty) {          resto(channel(ttyfd)); "          resto(channel(ttyfdout));     } >     if (sys_sechr( channel(ttyfd), (1<<31)|$CLMAX, ch_ttold)) 1          { perror("ttres: sechr "); return(-1); }        return(0); }   ) /* Exclusive uucp file locking control */  /**  by H. Fischer, creative non-Bell coding !B  copyright rights for lock modules assigned to Columbia University */  @ /* The AOS/VS implementation does not use uucp locks.   --ENH */  
 static char * E xxlast(s,c) char *s; char c; {          /* Equivalent to strrchr() */ 
     int i;#     for (i = strlen(s); i > 0; i--) 1         if ( s[i-1] == c ) return( s + (i - 1) );      return(NULL);            }  static look4lk(ttname) char *ttname; { %     extern char *strcat(), *strcpy();      char *device, *devname; K     char lockfil[50];                   /* Max length for lock file name */ &     char *lockdir = "/usr/spool/uucp";  J     device = ( (devname=xxlast(ttname,'/')) != NULL ? devname+1 : ttname);  1     strcat( strcpy( lockfil, "LCK.." ), device );   L     if (access( lockdir, 04 ) < 0) {    /* read access denied on lock dir */J         fprintf(stderr,"Warning, read access to lock directory denied\n");K         return( 1 );                    /* cannot check or set lock file */      }          8     strcat(strcat(strcpy(flfnam,lockdir),"/"), lockfil);#     debug(F110,"look4lk",flfnam,0);   G     if ( ! access( flfnam, 00 ) ) {     /* print out lock file entry */          char lckcmd[40] ; 3         strcat( strcpy(lckcmd, "ls -l ") , flfnam);          system(lckcmd); #         if (access(flfnam,02) == 0) N             printf("(You may type \"! rm %s\" to remove this file)\n",flfnam);         return( -1 );      } I     if ( access( lockdir, 02 ) < 0 ) {  /* lock file cannot be written */ K         fprintf(stderr,"Warning, write access to lock directory denied\n");          return( 1 );     }   G     return( 0 );                        /* okay to go ahead and lock */  }    /*  T T L O C K  */      staticC ttlock(ttyfd) char *ttyfd; {            /* lock uucp if possible */    #ifdef datageneralF     /* The Data General locks a device when that device is opened.  So0      * return that the device is already locked.H      * Besides, because of internal multi-tasking, locking the device byI      * the ?ASSIGN call or an $IEXO flag would cause problem for the task -      * id that did not open the device first.       */  #else datageneral      int lck_fil, l4l; F     int pid_buf = getpid();             /* pid to save in lock file */         <     haslock = 0;                        /* not locked yet */     l4l = look4lk(ttyfd); <     if (l4l < 0) return (-1);           /* already locked */M     if (l4l == 1) return (0);           /* can't read/write lock directory */ B     lck_fil = creat(flfnam, 0444);      /* create lock file ... */G     if (lck_fil < 0) return (-1);       /* create of lockfile failed */ E                 /* creat leaves file handle open for writing -- hf */ O     write (lck_fil, &pid_buf, sizeof(pid_buf) ); /* uucp expects int in file */      close (lck_fil); #endif datageneral;     haslock = 1;                        /* now is locked */      return(0); }    /*  T T U N L O C K  */    staticH ttunlck() {                             /* kill uucp lock if possible */ #ifdef datageneralI     /* The DG automatically unlocks the device when it is closed, or when J      * the process is terminated for any reason.  Unlocking is not needed.'      * Also, see the note for ttlock().       */      return(0); #else -     if (haslock) return( unlink( flfnam ) );   #endif   }   C /*  T T P K T  --  Condition the communication line for packets. */ ' /*              or for modem dialing */   I #define DIALING 4               /* flags (via flow) for modem handling */  #define CONNECT 5   6 /*  If called with speed > -1, also set the speed.  */  , /*  Returns 0 on success, -1 on failure.  */  : ttpkt(speed,xflow,parity) long speed; int xflow, parity; {     int s2;      int s = -1; 
     int x;G     extern int flow;                    /* REAL flow-control setting */   7     if (ttyfd < 0) return(-1);          /* Not open. */   )     debug(F101,"ttpkt parity","",parity); '     debug(F101,"ttpkt xflow","",xflow); -     debug(F101,"ttpkt speed","",(int) speed);   O     ttprty = parity;                    /* Let other tt functions see these. */ C     ttpflg = 0;                         /* Parity not sensed yet */ C     ttpmsk = ttprty ? 0177 : 0377;      /* Parity stripping mask */      ttspeed = speed;  F #ifdef NETCONN                          /* Nothing to do for telnet */     if (netconn) return (0); #endif /* NETCONN */  -     if (ttfdflg && !isatty(ttyfd)) return(0);   /     if (xflow != FLO_DIAL && xflow != FLO_DIAX) J       ttflow = xflow;                   /* Now make this available too. */       if (xlocal) { @         s2 = (int) (speed / 10L);       /* convert bps to cps */B         s = ttsspd(s2);                 /* get associated speed */         if (s < 0)             return(-1); 0         /* carrctl() call here in UNIX code */       } (                                          #ifdef UXIII8     if (flow == FLO_XONX) ttraw.c_iflag |= (IXON|IXOFF);>     else if (flow == FLO_NONE) ttraw.c_iflag &= ~(IXON|IXOFF);      else if (flow == FLO_KEEP) {'         ttraw.c_iflag &= ~(IXON|IXOFF); 8         ttraw.c_iflag |= (ttold.c_iflag & (IXON|IXOFF));"     } else if (flow == FLO_RTSC) {%         /* RTS/CTS Flow control... */  #ifdef RTSXOFF=         /* This is the preferred way, according to SVID R4 */ .         if (ioctl(ttyfd,TCGETX,&rctsx) > -1) {.             rctsx.x_hflag |= RTSXOFF | CTSXON;D             ioctl(ttyfd,TCSETX,&rctsx); /* Ignore errors for now. */	         }  #else  #ifdef CRTSCTS+         /* Found this one in <termios.h> */ !         ttraw.c_iflag |= CRTSCTS;  #endif /* CRTSCRS */ #endif /* RTSXOFF */     }      if (flow == FLO_DTRC) { $         /* DTR/CD Flow control... */ #ifdef DTRXOFF-         /* This is straight out of SVID R3 */ .         if (ioctl(ttyfd,TCGETX,&rctsx) > -1) {-             rctsx.x_hflag |= DTRXOFF | CDXON; <             ioctl(ttyfd,TCSETX,&rctsx); /* Ignore errors. */	         }  #endif /* DTRXOFF */     } 8     if (flow == DIALING)  ttraw.c_cflag |= CLOCAL|HUPCL;3     if (flow == CONNECT)  ttraw.c_cflag &= ~CLOCAL;   $     ttraw.c_lflag &= ~(ICANON|ECHO);     ttraw.c_lflag &= ~ISIG; 9     ttraw.c_lflag |= NOFLSH;            /* Don't flush */ %     ttraw.c_iflag |= (BRKINT|IGNPAR); J     ttraw.c_iflag &= ~(IGNBRK|INLCR|IGNCR|ICRNL|IUCLC|INPCK|ISTRIP|IXANY);     ttraw.c_oflag &= ~OPOST; #ifdef datageneral8     ttraw.c_lflag &= ~CSETPM;      /* No DG page mode */ #endif     ttraw.c_cc[4] = 1;%     ttraw.c_cflag &= ~(CSIZE|PARENB); !     ttraw.c_cflag |= (CS8|CREAD);      ttraw.c_cc[5] = 0;  J #ifdef VINTR                            /* Turn off interrupt character */I     if (xlocal == 0)                    /* so ^C^C can break us out of */ :       ttraw.c_cc[VINTR] = 0;            /* packet mode. */ #endif /* VINTR */       if (s > -1) {           ttraw.c_cflag &= ~CBAUD;7         ttraw.c_cflag |= s;             /* set speed */      }   K     if (ioctl(ttyfd,TCSETAW,&ttraw) < 0) return(-1);  /* set new modes . */  #ifdef datageneral     if (flow == FLO_XONX) { $          setflow(channel(ttyfdout));!          setflow(channel(ttyfd));      }      if (flow == FLO_NONE) { $          resflow(channel(ttyfdout));!          resflow(channel(ttyfd));      } 0     /* if flow is FLO_KEEP, don't do anything */>     if (sys_gechr( channel(ttyfd), (1<<31)|$CLMAX, ch_ttraw)) 2          { perror("ttpkt: gechr: "); return(-1); } #endif       if (flow == DIALING) { #ifdef datageneral
 #ifndef aosvs @         if (fcntl(ttyfd,F_SETFL, fcntl(ttyfd, F_GETFL, 0)) < 0 )                 return(-1);  #endif #else L         if (fcntl(ttyfd,F_SETFL, fcntl(ttyfd, F_GETFL, 0) & ~O_NDELAY) < 0 )                 return(-1); K         close( open(ttnmsv,2) );        /* magic to force mode change!!! */  #endif	         }    #endif  E     ttflui();                           /* Flush any pending input */      tvtflg = 0;      return(0); }   K /*  T T V T -- Condition communication line for use as virtual terminal  */   # ttvt(speed,flow) int speed, flow; {      int s, s2;  &     debug(F101,"ttvt ttyfd","",ttyfd);(     debug(F101,"ttvt tvtflg","",tvtflg);&     debug(F101,"ttvt speed","",speed);  7     if (ttyfd < 0) return(-1);          /* Not open. */    #ifdef NETCONN     if (netconn) {A         tvtflg = 1;                     /* Network connections */ F         return(0);                      /* require no special setup */     }  #endif /* NETCONN */  O     if (tvtflg != 0 && speed == ttspeed && flow == ttflow && ttcarr == curcarr) B       return(0);                        /* Already been called. */   -     if (ttfdflg && !isatty(ttyfd)) return(0);        if (xlocal) { @         s2 = (int) (speed / 10L);       /* convert bps to cps */=         s = ttsspd(s2);                 /* Check the speed */ 1         /* ENH - UNIX has call to carrctl here */      } 8     if (flow == FLO_XONX) tttvt.c_iflag |= (IXON|IXOFF);      else if (flow == FLO_KEEP) {E         tttvt.c_iflag &= ~(IXON|IXOFF); /* Turn off Xon/Xoff flags */ M         tttvt.c_iflag |= (ttold.c_iflag & (IXON|IXOFF)); /* OR in old ones */ ?     }else if (flow == FLO_NONE) tttvt.c_iflag &= ~(IXON|IXOFF);   8     if (flow == DIALING)  tttvt.c_cflag |= CLOCAL|HUPCL;3     if (flow == CONNECT)  tttvt.c_cflag &= ~CLOCAL;   )     tttvt.c_lflag &= ~(ISIG|ICANON|ECHO); %     tttvt.c_iflag |= (IGNBRK|IGNPAR); J     tttvt.c_iflag &= ~(INLCR|IGNCR|ICRNL|IUCLC|BRKINT|INPCK|ISTRIP|IXANY);     tttvt.c_oflag &= ~OPOST;%     tttvt.c_cflag &= ~(CSIZE|PARENB); !     tttvt.c_cflag |= (CS8|CREAD);      tttvt.c_cc[4] = 1;     tttvt.c_cc[5] = 0;       if (s > -1) {           tttvt.c_cflag &= ~CBAUD;+         tttvt.c_cflag |= s; /* set speed */      }   K     if (ioctl(ttyfd,TCSETAW,&tttvt) < 0) return(-1);  /* set new modes . */    #ifdef datageneral     if (flow == FLO_XONX) { $          setflow(channel(ttyfdout));!          setflow(channel(ttyfd));      }      if (flow == FLO_NONE) { $          resflow(channel(ttyfdout));!          resflow(channel(ttyfd));      } =     if (sys_gechr( channel(ttyfd), (1<<31)|$CLMAX, ch_ttvt))  1          { perror("ttvt: gechr: "); return(-1); }  #endif       if (flow == DIALING) { #ifdef datageneral
 #ifndef aosvs @         if (fcntl(ttyfd,F_SETFL, fcntl(ttyfd, F_GETFL, 0)) < 0 )                 return(-1);  #endif #else L         if (fcntl(ttyfd,F_SETFL, fcntl(ttyfd, F_GETFL, 0) & ~O_NDELAY) < 0 )                 return(-1); K         close( open(ttnmsv,2) );        /* magic to force mode change!!! */  #endif	         }   H     ttspeed = speed;                    /* Done, remember how we were */M     ttflow = flow;                      /* called, so we can decide how to */ @     tvtflg = 1;                         /* respond next time. */   &     debug(F101,"ttvt done","",tvtflg);     return(0); }   H /*  T T S S P D  --  Return the internal baud rate code for 'speed'.  */  
 ttsspd(cps) {      int s,s2,spdok;         debug(F101,"ttsspd","",cps);    #ifdef  NETCONN      if (netconn) return (0); #endif  /* NETCONN */        if (cps < 0) return(-1);;         spdok = 1;                      /* Assume arg ok */          switch (cps) {C             case 0:   s = B0;    break; /* Just the common ones. */ F             case 11:  s = B110;  break; /* The others from ttydev.h */G             case 15:  s = B150;  break; /* could also be included if */ :             case 30:  s = B300;  break; /* necessary... */'             case 60:  s = B600;  break; '             case 120: s = B1200; break; '             case 180: s = B1800; break;   '             case 240: s = B2400; break; '             case 480: s = B4800; break; '             case 960: s = B9600; break;  #ifdef datageneral-             /* ioctl() allows other speeds */ '             case 5:     s = B50; break; '             case 7:     s = B75; break; (             case 13:    s = B134; break;)             case 360:   s = B3600; break; )             case 720:   s = B7200; break; *             case 1920:  s = B19000; break;  C             /* Some speeds are supported by the hardware thru PMGR. @                We don't bother about 45.5 but it could be added.             */G             case 38400:  if (setspeed($CR38K)) spdok = 0; s = 0; break;  #endif             default:                 spdok = 0;I                 fprintf(stderr,"Unsupported line speed - %d\n",cps * 10); >                 fprintf(stderr,"Current speed not changed\n");                 break;         }                    if (spdok)             return(s);         else             return(-1);   }  I /*  T T S C A R R  --  Set ttcarr variable, controlling carrier handling.   *I  *  0 = Off: Always ignore carrier. E.g. you can connect without carrier. O  *  1 = On: Heed carrier, except during dialing. Carrier loss gives disconnect. 4  *  2 = Auto: For "modem direct": The same as "Off".K  *            For real modem types: Heed carrier during connect, but ignore M  *                it anytime else.  Compatible with pre-5A C-Kermit versions.   *M  * As you can see, this setting does not affect dialing, which always ignores L  * carrier (unless there is some special exception for some modem type).  ItK  * does affect ttopen() if it is set before ttopen() is used.  This setting J  * takes effect on the next call to ttopen()/ttpkt()/ttvt().  And they areI  * (or should be) always called before any communications is tried, which =  * means that, practically speaking, the effect is immediate.   *B  * Of course, nothing of this applies to remote mode (xlocal = 0).  *F  * Someone has yet to uncover how to manipulate the carrier in the BSDL  * environment (or any non-termio using environment).  Until that time, this"  * will simply be a no-op for BSD.  *L  * Note that in previous versions, the carrier was most often left unchangedK  * in ttpkt()/ttvt() unless they were called with DIALING or CONNECT.  This I  * has changed.  Now it is controlled by ttcarr in conjunction with these 	  * modes.   */  int  ttscarr(carrier) int carrier; {      ttcarr = carrier; %     debug(F101, "ttscarr","",ttcarr);      return(ttcarr);  }    int @ ttgmdm() {                              /* Read modem signals */L     return(-3);                         /* ENH - return value of -3 means */M }                                       /* not implemented, which it's not */ L                                         /* because this can't (easily) be */<                                         /* done in AOS/VS */   int M ttwmdm(mdmsig,timo) int mdmsig,timo; {  /* wait timo seconds for specified */ E     return(-3);                         /* modem signals to appear */  }      long< ttgspd() {                              /* Get line speed */D     P_CHAR_EX   cp;                     /* characteristics packet */"     int         ac0,ac1,ac2,error;     static int  baud_rate[] = { L                     50,75,110,134,150,300,600,1200,1800,2000,2400,3600,4800,%                     7200,9600,19200}, +                 baud_rate_x[] = {45,38400};    #ifdef NETCONN     if (netconn) return (-1);  #endif /* NETCONN */       if (ttyfd < 0)         return (-1);
     else {         ac0 = channel(ttyfd);          ac1 = $CLMAX | BIT0;          ac2 = (P_CHAR_EX *) &cp;+         error = sys($GECHR,&ac0,&ac1,&ac2);          if (error)             return(-1);             if (cp.char_br0bit == 0).             return(baud_rate[cp.char_br_1_4]);         else0             return(baud_rate_x[cp.char_br_1_4]);     }  }    int F psuspend() {                            /* ENH - not possible in VS */     return(-1);  }    /* Interrupt Functions */    4 /* Set up terminal interrupts on console terminal */   #ifdef UXIIIG esctrp() {                              /* trap console escapes (^\) */        conesc = 1; B     signal(SIGQUIT,SIG_IGN);            /* ignore until trapped */ }  #endif  1 /*  C O N I N T  --  Console Interrupt setter  */  VOIDD conint(f,s) SIGTYP (*f)(), (*s)(); {    /* Set an interrupt trap. */  @     if (!isatty(0)) {                   /* only for real ttys */4         debug(F101,"conint not a tty","",isatty(0));         return;      } J     if (backgrd) {                      /* must ignore signals in bkgrd */A         debug(F101,"conint backgrd ignoring signals","",backgrd);          return;      } ?     else debug(F101,"conint foreground catching signals","",0);  /*=  Except for special cases below, ignore keyboard quit signal. G  ^\ too easily confused with connect escape, and besides, we don't want -  to leave lock files around.  (Frank Prindle)  */ #ifdef datageneral9     /* Set up the asynchronous task to read the console.  J      * But, I don't want them set up all the time, so I will kludge up theJ      * call in  chkint() (ckuus3.c) to see if this asynch task is running:      * conint_mt()      */  #endif     signal(SIGQUIT,SIG_IGN);   #ifdef UXIIII     signal(SIGQUIT,esctrp);             /* console escape in pkt modes */ G     if (conesc) {                       /* clear out pending escapes */          conesc = 0;      }  #endif  J     if (conif) return;                  /* Nothing to do if already on. */  G /* check if invoked in background -- if so signals set to be ignored */   ,     if (signal(SIGINT,SIG_IGN) == SIG_IGN) {K         backgrd = 1;                    /*   means running in background */  #ifdef UXIIIJ         signal(SIGQUIT,SIG_IGN);        /*   must leave signals ignored */ #endif         return;      } O     signal(SIGINT,f);                   /* Function to trap to on interrupt. */ N     signal(SIGHUP,f);                   /* Or hangup, so lock file cleared. */I     conif = 1;                          /* Flag console interrupts on. */  }     9 /*  C O N N O I  --  Reset console terminal interrupts */   C connoi() {                              /* Console-no-interrupts */   @     if (!isatty(0)) return(0);          /* only for real ttys */J     if (backgrd) return;                /* Ignore signals in background */   #ifdef datageneralA     /* Terminate the asynchronous task that reads the console for       * interrupt characters.  J      * But, I don't want to kill this task all the time, so I will kludge F      * up the call in input() (ckcfn2.c) to kill the asynch task if it      * is running: connoi_mt()      */  #endif     signal(SIGINT,SIG_DFL);      signal(SIGHUP,SIG_DFL);      signal(SIGQUIT,SIG_DFL);I     conif = 0;                          /* Flag interrupt trapping off */  }    #ifdef datageneral4 /* C O N I N T _ M T  -- Asynch read console task */   void conint_mt() {     int count = 0;       /* Any input waiting? */F     con_reads_mt = 1;                   /* Flag that task is active */H     conint_avl = 0;                     /* Flag that interrupt gotten */     while (con_reads_mt)I         if ((conint_ch = coninc(2)) > 0) { /* If character at keyboard */ =             conint_avl = 1;             /* we set the flag */ 2             while ((conint_avl) && (++count <= 5))M                 sleep(1);               /* & wait for char to be processed */ 	         } @         count = 0;                      /* initialize counter */         conint_avl = 0;  }     9 /* C O N N O I _ M T  -- Kill asynch read console task */   
 connoi_mt() {      conint_avl = 0;      if (con_reads_mt) {          con_reads_mt = 0;          midkill(CONINT_TSK);     }  }     ? /* C O N S T A _ M T  --  Start the console asynch read task */   
 consta_mt() { :     if ((con_reads_mt == 0)      /* Not already running */F      && (mtask(conint_mt, CONINT_STACK, CONINT_TSK, CONINT_PRI) != 0))2         perror("consta_mt: Can't initiate task:"); }  #endif datageneral  K /* Private buffer for myread() and its companions.  Not for use by anything J  * else.  ttflui() is allowed to reset them to initial values.  ttchk() is  * allowed to read my_count.  *L  * my_item is an index into mybuf[].  Increment it *before* reading mybuf[].  *I  * A global parity mask variable could be useful too.  We could use it to F  * let myread() strip the parity on its own, instead of stripping sign  * bits as it does now.   */     #define MYBUFLEN 256 #define PEEKTYPE long I static CHAR mybuf[MYBUFLEN];            /* Buffer, including push back */ L static int my_count = 0;                /* Number of chars still in mybuf */J static int my_item = -1;                /* Last index read from mybuf[] */   H /* myread() -- Efficient read of one character from communications line.  *J  * Uses a private buffer to minimize the number of expensive read() systemN  * calls.  Essentially performs the equivalent of read() of 1 character, whichL  * is then returned.  By reading all available input from the system buffersM  * to the private buffer in one chunk, and then working from this buffer, the N  * number of system calls is reduced in any case where more than one characterI  * arrives during the processing of the previous chunk, for instance high I  * baud rates or network type connections where input arrives in packets. K  * If the time needed for a read() system call approaches the time for more N  * than one character to arrive, then this mechanism automatically compensatesM  * for that by performing bigger read()s less frequently.  If the system load 8  * is high, the same mechanism compensates for that too.  *O  * myread() is a macro that returns the next character from the buffer.  If the L  * buffer is empty, mygetbuf() is called.  See mygetbuf() for possible error  * returns.   *I  * This should be efficient enough for any one-character-at-a-time loops. L  * For even better efficiency you might use memcpy()/bcopy() or such betweenN  * buffers (since they are often better optimized for copying), but it may notI  * be worth it if you have to take an extra pass over the buffer to strip &  * parity and check for CTRL-C anyway.  *M  * Note that if you have been using myread() from another program module, you O  * may have some trouble accessing this macro version and the private variables O  * it uses.  In that case, just add a function in this module, that invokes the 	  * macro.   */   M #define myread()  (--my_count < 0 ? mygetbuf() : 255 & (int)mybuf[++my_item])      /* not used right now */ /* myunrd(ch) CHAR ch; {      ungotn = ch; }  */  E /* mygetbuf() -- Fill buffer for myread() and return first character.   *K  * This function is what myread() uses when it can't get the next character L  * directly from its buffer.  First, it calls a system dependent myfillbuf()J  * to read at least one new character into the buffer, and then it returnsL  * the first character just as myread() would have done.  This function alsoF  * is responsible for all error conditions that myread() can indicate.  *>  * Returns: When OK     => a positive character, 0 or greater.  *          When EOF    => -2.3  *          When error  => -3, error code in errno.   *N  * Older myread()s additionally returned -1 to indicate that there was nothingH  * to read, upon which the caller would call myread() again until it gotH  * something.  The new myread()/mygetbuf() always gets something.  If itM  * doesn't, then make it do so!  Any program that actually depends on the old   * behaviour will break.  *J  * The older version also used to return -2 both for EOF and other errors,J  * and used to set errno to 9999 on EOF.  The errno stuff is gone, EOF andM  * other errors now return different results, although Kermit currently never B  * checks to see which it was.  It just disconnects in both cases.  *I  * Kermit lets the user use the quit key to perform some special commands J  * during file transfer.  This causes read(), and thus also mygetbuf(), toK  * finish without reading anything and return the EINTR error.  This should I  * be checked by the caller.  Mygetbuf() could retry the read() on EINTR, I  * but if there is nothing to read, this could delay Kermit's reaction to 4  * the command, and make Kermit appear unresponsive.  *>  * The debug() call should be removed for optimum performance.  */  int  mygetbuf() {0     my_count = myfillbuf();                     6     /* debug(F101, "myfillbuf read", "", my_count); */     if (my_count <= 0)%       return(my_count < 0 ? -3 : -2);      --my_count; *     return(255 & (int)mybuf[my_item = 0]); }     /* myfillbuf(): H  * System-dependent read() into mybuf[], as many characters as possible.  *C  * Returns: OK => number of characters read, always more than zero.   *          EOF => 0-  *          Error => -1, error code in errno.   *K  * If there is input available in the system's buffers, all of it should be I  * read into mybuf[] and the function return immediately.  If no input is L  * available, it should wait for a character to arrive, and return with thatK  * one in mybuf[] as soon as possible.  It may wait somewhat past the first N  * character, but be aware that any such delay lengthens the packet turnaroundO  * time during kermit file transfers.  Should never return with zero characters *  * unless EOF or irrecoverable read error.  *H  * Correct functioning depends on the correct tty parameters being used.J  * Better control of current parameters is required than may have been theM  * case in older Kermit releases.  For instance, O_NDELAY (or equivalent) can H  * no longer be sometimes off and sometimes on like it used to, unless aI  * special myfillbuf() is written to handle that.  Otherwise the ordinary 0  * myfillbuf()s may think they have come to EOF.  *G  * If your system has a facility to directly perform the functioning of L  * myfillbuf(), then use it.  If the system can tell you how many charactersM  * are available in its buffers, then read that amount (but not less than 1). M  * If the system can return a special indication when you try to read without J  * anything to read, while allowing you to read all there is when there isN  * something, you may loop until there is something to read, but probably that#  * is not good for the system load.   */  int 
 myfillbuf() { 
     int n;F     int retry_count = 5;                        /* max # of retries */   #ifdef NETCONN     if (netconn) {.         n = read(ttyfd, mybuf, sizeof(mybuf));         if (n <= 0) L             debug(F101,"myfillbuf() got error reading from network, ","",n);         return(n);D     } else {                                      /* console read */ #endif /* NETCONN */         while (1) { 5             n = dgncinb(ttyfd, mybuf, sizeof(mybuf));              if (n > 0) {                 return(n);
             } F             if ((n == -EROVR) || (n == -1) || (n == -2) || (n == 0)) {                  if (n == -EROVR)L                     debug(F101,"myfillbuf() got data overrun ind., ","",-n);!                 else if (n == -1) B                     debug(F101,"myfillbuf() got EOF ind., ","",n);!                 else if (n == -2) M                     debug(F101,"myfillbuf() got device timeout ind., ","",n);                  elseI                     debug(F101,"myfillbuf() got zero characters, ","",n); (                 if (--retry_count > 0) {O                     debug(F101,"myfillbuf() tries remaining, ","",retry_count); ?                     sleep(1);   /* keep trying on data over- */ E                     continue;   /* run, EOF (-1), timeout (-2) & 0 */                  } L             } else if (n < -2)                  /* VS errors complimented */B                 debug(F101,"myfillbuf() got AOS/VS error ","",-n);K             if (n == -1)                        /* EOF is -1, but caller */ K                 n = 0;                          /* wants it to be zero   */ C             else n = -1;                        /* all others -1 */              return(n);	         }  #ifdef NETCONN     }  #endif /* NETCONN */ }   O /*  T T C H K  --  Tell how many characters are waiting in tty input buffer  */   	 ttchk() { 
     int x;     PEEKTYPE n = 0;    #ifdef COMMENT /*G   This was REALLY slowing TELNET connections down!  Just do the regular K   ttyfd-based stuff here.  Let the VMS version call nettchk if it has to... G   FIONREAD definitely works for TELNET, at least on the NeXT and SUNOS.  */ #ifdef NETCONN$     if (netconn) return (nettchk()); #endif /* NETCONN */ #endif /* COMMENT */  K     if (my_count > 0)               /* Sys III, Sys V, Apollo Aegis, etc */          n += my_count;/     debug(F101,"ttchk chars available, ","",n);      return(n); }   . /*  T T F L U I  --  Flush tty input buffer */  
 ttflui() {     int ffd;  
 #ifndef UXIII      long n;  #endif  G     my_count = 0;                       /* Initialize myread() stuff */      my_item = -1;    #ifdef NETCONN#     if (netconn) return(netflui());  #endif /* NETCONN */  E     ffd = xlocal ? ttyfd : 0;           /* If not local, use stdin */ *     debug(F101,"ttflui xlocal","",xlocal);(     debug(F101,"ttflui ttyfd","",ttyfd);$     debug(F101,"ttflui ffd","",ffd);  7     if (ffd < 0) return(-1);            /* Not open. */         #ifdef UXIII #ifdef datageneralN     /* Since $ESGT is turned on in the sys_read packets, there is never a needN      * to flush the input buffer -- the system automatically does it each time      * a read is issued.      */  #endif #endif       return(0); }    int I ttfluo() {                              /* Flush output buffer - dummy */ J     return(0);                          /* POSIX is only implementation */= }                                       /* that needs this */     = /*  T T X I N  --  Get n characters from tty input buffer  */   F /*  Returns number of characters actually gotten, or -1 on failure  */  L /*  Intended for use only when it is known that n characters are actually */& /*  Available in the input buffer.  */    ttxin(n,buf) int n; CHAR *buf; {
     int x;
     int c;  K     ttpmsk = (ttprty) ? 0177: 0377;             /* parity stripping mask */       debug(F101,"ttxin: n","",n);  =     for( x = 0; (x > -1) && (x < n) && (c = myread()) >= 0; )        buf[x++] = c & ttpmsk;  0     debug(F101," x","",x);                           for (c = 0; c < n; c++)          buf[c] &= ttpmsk;      if (x > 0) buf[x] = '\0';      else if (x < 0) x = -1;      return(x); }    #define TTOLMAXT 5  9 /*  T T O L  --  Similar to "ttinl", but for writing.  */    ttol(s,n) int n; char *s; {      int x,len,tries,outfd;   #ifdef NETCONN     if (netconn) {#         if (ttyfd < 0) return (-1); 
     } else #endif /* NETCONN */"     if (ttyfdout < 0) return (-1);       debug(F101,"ttol n","",n);     tries = TTOLMAXT;      len = n;  &     while ((n > 0) && (tries-- > 0)) {3         debug(F101,"ttol try","",TTOLMAXT - tries);  #ifdef NETCONN         if (netconn)!             x = write(ttyfd,s,n);          else #endif /* NETCONN */#         x = dgncoub(ttyfdout,s,n);           if (x == n) { '             debug(F101,"ttol ok","",x);              return(len);         } else if (x < 0) { 5             debug(F101,"ttol failed","",lasterror());              return(-1);          } else {,             debug(F101,"ttol partial","",x);L             s += x;                     /* update buffer address for next */I             n -= x;                     /* update length for next read */ #             if (x > 0) msleep(100); 	         }      }      return((n < 1) ? len : -1);  }     A /*  T T O C  --  Output a character to the communication line  */  /*N  This function should only be used for interactive, character-mode operations,K  like terminal connection, script execution, dialer i/o, where the overhead 8  of the signals and alarms does not create a bottleneck. */   ttoc(c) char c; { 
     int x,xx;  #define TTOC_TMO 15      c &= 0xff;)     /* debug(F101,"ttoc","",(CHAR) c); */  #ifdef NETCONN     if (netconn) {"         if (ttyfd < 0) return(-1);
     } else #endif /* NETCONN */2     if (ttyfdout < 0) return(-1);  /* Not open. */#     saval = signal(SIGALRM,timerh);      xx = alarm(TTOC_TMO); C     if (xx < 0) xx = 0;                 /* Save old alarm value. */      if (setjmp(sjbuf)) {         ttimoff();O         if (xx - TTOC_TMO > 0) alarm(xx - TTOC_TMO); /* Restore previous one */  #ifdef NETCONN         if (!netconn) {  #endif /* NETCONN */2             /* debug(F100,"ttoc timeout","",0); */%             if (ttflow == FLO_XONX) { 2                 debug(F100,"ttoc flow","",ttflow);(                 /* issue clear device */
             }  #ifdef NETCONN	         }  #endif /* NETCONN */         return(-1);      } else { #ifdef NETCONNK         if (netconn)                    /* use ttyfd for tcp connections */ "             x = write(ttyfd,&c,1);L         else                            /* ttyfdout for local connections */ #endif /* NETCONN */*             x = (dgncoub(ttyfdout,&c,1));          if (x != 1) { G             ttimoff();                  /* If error, turn off timer, */              alarm(xx);,             debug(F101,"ttoc error x","",x);9             debug(F101,"ttoc last error","",lasterror());              return (-1);	         }      }      ttimoff();     alarm(xx);     return (0);  }   L /*  T T I N L  --  Read a record (up to break character) from comm line.  */ /*J  Reads up to "max" characters from the communication line, terminating on:   B     (a) the packet length field if the "turn" argument is zero, orK     (b) on the packet-end character (eol) if the "turn" argument is nonzero    I   and returns the number of characters read upon success, or if "max" was I   exceeded or the timeout interval expired before (a) or (b), returns -1.    N   The characters that were input are copied into "dest" with their parity bitsJ   stripped if parity was selected.  Returns the number of characters read.M   Characters after the eol are available upon the next call to this function.    L   The idea is to minimize the number of system calls per packet, and also toM   minimize timeouts.  This function is the inner loop of the program and must H   be as efficient as possible.  The current strategy is to use myread().   L   WARNING: this function calls parchk(), which is defined in another module.M   Normally, ckutio.c does not depend on code from any other module, but there J   is an exception in this case because all the other ck?tio.c modules alsoM   need to call parchk(), so it's better to have it defined in a common place.  */   /* ENH -- assume PARSENSE */   #ifdef CTRLC #undef CTRLC #endif /* CTRLC */ #define CTRLC '\03'    int N ttinl(dest,max,timo,eol,start,turn) int max,timo,turn; CHAR *dest,eol,start; {     int pktlen = -1;
     int j;     CHAR ch;     int lplen = 0;     int havelen = 0;  7     if (ttyfd < 0) return(-1);          /* Not open. */ 
     if (turn) 9         debug(F101,"ttinl read until eol, turn","",turn);      elseH         debug(F101,"ttinl read packet-length characters, turn","",turn);#     debug(F101,"ttinl max","",max); %     debug(F101,"ttinl timo","",timo);    F     *dest = '\0';                       /* Clear destination buffer */       if (timo < 0) timo = 0;      I     if (timo) {                         /* Don't time out if timo == 0 */ D         saval = signal(SIGALRM,timerh); /* Enable timer interrupt */5         alarm(timo);                    /* Set it. */      } =     if (setjmp(sjbuf)) {                /* Timer went off? */ C         debug(F100,"ttinl timout","",0); /* Get here on timeout. */ ,         debug(F110," with",(char *) dest,0);<         ttimoff();                      /* Turn off timer */D         return(-1);                     /* and return error code. */     } else {         int i, m, n;         int ccn = 0;         int flag = 0;    +         debug(F000,"ttinl start","",start); B         flag = 0;                       /* Start of packet flag */   M         ttpmsk = m = (ttprty) ? 0177 : 0377; /* Set parity stripping mask. */    E /* Now read into destination, stripping parity and looking for the */ F /* the packet terminator, and also for two Ctrl-C's typed in a row. */   ?         i = 0;                          /* Destination index */ '         debug(F101,"ttinl eol","",eol);          while (i < max-1) { -             /* debug(F101,"ttinl i","",i); */ %             if ((n = myread()) < 0) { ;                 debug(F101,"ttinl myread failure, n","",n); ;                 debug(F101,"ttinl myread errno,","",errno); 4                 /* Don't let EINTR break packets. */9                 if (n == -3 && errno == EINTR && i > 0) { 6                     debug(F101,"ttinl myread i","",i);                     continue;                  }                  break;
             } 7             debug(F101,"ttinl char","", (n & ttpmsk));   /*A   Figure out what the length is supposed to be in case the packet 6   has no terminator (as with Honeywell GCOS-8 Kermit). */ #ifndef xunchar I #define xunchar(ch) (((ch) - 32 ) & 0xFF )      /* Character to number */  #endif /* xunchar */?             if ((flag == 0) && ((n & 0x7f) == start)) flag = 1; -             if (flag) dest[i++] = n & ttpmsk;  /*G   If we have not been instructed to wait for a turnaround character, we H   can go by the packet length field.  If turn != 0, we must wait for the/   end of line (eol) character before returning.  */             if (i == 2) { 1                 pktlen = xunchar(dest[1] & 0x7f); '                 havelen = (pktlen > 1); 5                 debug(F101,"ttinl length","",pktlen); /             } else if (i == 5 && pktlen == 0) { 0                 lplen = xunchar(dest[4] & 0x7f);/             } else if (i == 6 && pktlen == 0) { B                 pktlen = lplen * 95 + xunchar(dest[5] & 0x7f) + 5;                 havelen = 1;5                 debug(F101,"ttinl length","",pktlen); 
             }  	    /* Check cancellation */ @             if (!xlocal && xfrcan && ((n & ttpmsk) == xfrchr)) {J                 if (++ccn >= xfrnum) {	/* If xfrnum in a row, bail out. */:                     if (timo) {         /* Clear timer. */"                         ttimoff();                     } B                     fprintf(stderr,"^C...\r\n"); /* Echo Ctrl-C */                     return(-2);                  } J             } else ccn = 0;             /* Not ^C, so reset ^C counter, */             if (flag == 0) {2                 debug(F101,"ttinl skipping","",n);                 continue; 
             }    !     /* Check for end of packet */    N             if (((n & 0x7f) == eol) || (!turn && havelen && (i > pktlen+1))) {(                 if ((n & 0x7f) != eol) {=                     debug(F101,"ttinl EOP length","",pktlen); /                     debug(F101,"ttinl i","",i); :                 } else debug(F101,"ttinl got eol","",eol);C                 dest[i] = '\0';         /* Terminate the string, */    ; /* Here's where we actually check and adjust the parity. */ K /* The major flaw here is if parity is NONE (ttprty = 0) and the packets */ I /* really do have no parity, then parchk() is called for every packet. */ N /* In practice, this doesn't really harm efficiency noticably, but it would */I /* be better if ttinl() had a way of knowing to stop doing this once a */ < /* particular file transfer had been started and checked. */3                 if (ttpflg++ == 0 && ttprty == 0) { >                     if ((ttprty = parchk(dest,start,i)) > 0) {                         int j;D                         debug(F101,"ttinl senses parity","",ttprty);A                         debug(F110,"ttinl packet before",dest,0); &                         ttpmsk = 0x7f;/                         for (j = 0; j < i; j++) N                           dest[j] &= 0x7f;      /* Strip parity from packet */A                         debug(F110,"ttinl packet after ",dest,0); :                     } else debug(F101,"parchk","",ttprty);                 } E                 if (timo) {                     /* Turn off timer. */                      ttimoff();                 } 0                 debug(F111,"ttinl got", dest,i);                 return(i);
             } <         }                               /* end of while() */         ttimoff();         return(-1);      }  }   B /*  T T I N C --  Read a character from the communication line  */ /*7  On success, returns the character that was read, >= 0. <  On failure, returns -1 or other negative myread error code. */   int  ttinc(timo) int timo; {      int n = 0;     CHAR ch = 0;  7     if (ttyfd < 0) return(-1);          /* Not open. */ 6     if (timo <= 0) {                    /* Untimed. */E         /* comm line failure returns -1 thru myread, so no &= 0377 */ E         n = myread();                   /* Wait for a character... */ )         /* debug(F101,"ttinc n","",n); */ '         return(n < 0 ? n : n & ttpmsk);      } else {         int xx; B         saval = signal(SIGALRM,timerh); /* Timed, set up timer. */O         xx = alarm(timo);               /* calls because I'm getting errors  */ O         if (setjmp(sjbuf))              /* about these signal calls -- " the */ O             n = -1;                     /* destination of a non-local GOTO is*/ @         else {                          /* an inactive block" */G             n = myread();               /* If managing own buffer... */ 2             /* debug(F101,"ttinc myread","",n); */	         }          ttimoff(); #ifdef NETCONN         if (netconn) {>             if (n == -2) {              /* read() returns 0 */E                 netclos();              /* on network read failure */ K                 netconn = 0;            /* ENH - deleted errno = ENOTCON */ 
             } 	         }  #endif  /* NETCONN */ N         return( (n < 0) ? n : (n & ttpmsk) ); /* Return masked char or neg. */     }  }   , /*  T T S N D B  --  Send a BREAK signal  */  
 ttsndb() {N     int x; long n; char spd;            /* In VS, the duration of the break */N                                         /* is until next write() or charac- */N     debug(F101,"ttsndb ttyfd","",ttyfd); /* teristics change                */7     if (ttyfd < 0) return(-1);          /* Not open. */    #ifdef NETCONN@     if (netconn)                        /* Send network BREAK */       return(netbreak());  #endif /* NETCONN */   #ifdef UXIII #ifdef datageneralJ     if (sys_clrdv(channel(ttyfdout),1<<31,$CDSBRK)) {   /* Send a BREAK */#         perror("Can't send BREAK");          return(-1);      }      return(0); #endif #endif }   3 /* T T S N D L B  --  Send a "long" BREAK signal */   L ttsndlb() {             /* In VS, they're long by default -- see ttsndb() */     return(ttsndb());  }     8 /*  M S L E E P  --  Millisecond version of sleep().  */   /*D  Intended only for small intervals.  For big ones, just use sleep(). */   msleep(m) int m; {   #ifdef UXIII6 #define CLOCK_TICK 17                   /* 1/60 sec */     extern long times();     long t1, t2, tarray[4];      int t3;        if (m <= 0) return(0);-     if ((t1 = times(tarray)) < 0) return(-1);      while (1) { 1         if ((t2 = times(tarray)) < 0) return(-1); +         t3 = ((int)(t2 - t1)) * CLOCK_TICK;          if (t3 > m) return(t3);      }  #endif }     2 /*  R T I M E R --  Reset elapsed time counter  */  
 rtimer() {      tcount = time( (long *) 0 ); }     L /*  G T I M E R --  Get current value of elapsed time counter in seconds  */  
 gtimer() {
     int x;,     x = (int) (time( (long *) 0 ) - tcount);     debug(F101,"gtimer","",x);     /* rtimer(); */      return( (x < 0) ? 0 : x ); }     . /*  Z T I M E  --  Return date/time string  */   ztime(s) char **s; {   #ifdef UXIIID     extern long time();                 /* Sys III/V way to do it */     char *ctime();     long clock_storage;   '     clock_storage = time( (long *) 0 ); !     *s = ctime( &clock_storage );  #endif }     2 /*  C O N G M  --  Get console terminal modes.  */   /*M  Saves current console mode, and establishes variables for switching between  2  current (presumably normal) mode and other modes. */  	 congm() { :     if (backgrd || !isatty(0)) {  /* only for real ttys */         cgmf = -1;L         return (-1);            /* it used to return a zero for this case */     }       ioctl(0,TCGETA,&ccold);      ioctl(0,TCGETA,&cccbrk);       ioctl(0,TCGETA,&ccraw);D      /* For DG, also get the tty extended device characteristics. */6      sys_gechr( channel(0), (1<<31)|$CLMAX, ch_ccold);6      sys_gechr( channel(0), (1<<31)|$CLMAX, ch_ccraw);6      sys_gechr( channel(0), (1<<31)|$CLMAX, ch_ccbrk);D      cgmf = 1;                          /* Flag that we got them. */ }       1 /*  C O N C B --  Put console in cbreak mode.  */   " /*  Returns 0 if ok, -1 if not  */   concb(esc) char esc; {
     int x;+     debug(F101,"concb backgrd","",backgrd); @     if (!isatty(0)) return(0);          /* only for real ttys */$     debug(F100,"concb isatty","",0);     if (backgrd) return(0); E     if (cgmf == 0) congm();             /* Get modes if necessary. */ N     escchr = esc;                       /* Make this available to other fns */I     ckxech = 1;                         /* Program can echo characters */  #ifdef datageneral     cccbrk.c_lflag |= CBREAK;  #endif%     cccbrk.c_lflag &= ~(ICANON|ECHO); I     cccbrk.c_cc[0] = 003;               /* interrupt char is control-c */ H     cccbrk.c_cc[1] = escchr;            /* escape during packet modes */     cccbrk.c_cc[4] = 1;      cccbrk.c_cc[5] = 1; =     x = ioctl(0,TCSETAW,&cccbrk);       /* set new modes . */  #ifdef datageneral:     if (sys_gechr( channel(0), (1<<31)|$CLMAX, ch_ccbrk)) 2          { perror("concb: gechr: "); return(-1); } #endif #ifndef NOSETBUFF     if (x > -1) setbuf(stdout,NULL);    /* Make console unbuffered. */ #endif /* NOSETBUF */      return(x); }   3 /*  C O N B I N  --  Put console in binary mode  */   " /*  Returns 0 if ok, -1 if not  */   conbin(esc) char esc; {  int filedes,filedes2;   @     if (!isatty(0)) return(0);          /* only for real ttys */E     if (cgmf == 0) congm();             /* Get modes if necessary. */ N     escchr = esc;                       /* Make this available to other fns */I     ckxech = 1;                         /* Program can echo characters */ )     ccraw.c_lflag &= ~(ISIG|ICANON|ECHO); %     ccraw.c_iflag |= (BRKINT|IGNPAR); F     ccraw.c_iflag &= ~(IGNBRK|INLCR|IGNCR|ICRNL|IUCLC|IXON|IXANY|IXOFF'                         |INPCK|ISTRIP);      ccraw.c_oflag &= ~OPOST;  J /*** Kermit used to put the console in 8-bit raw mode, but some users haveH  *** pointed out that this should not be done, since some sites actuallyH  *** use terminals with parity settings on their Unix systems, and if weN  *** override the current settings and stop doing parity, then their terminalsL  *** will display blotches for characters whose parity is wrong.  Therefore,H  *** the following two lines are commented out (Larry Afrin, Clemson U):  ***(  ***   ccraw.c_cflag &= ~(PARENB|CSIZE);$  ***   ccraw.c_cflag |= (CS8|CREAD);  ***I  *** Sys III/V sites that have trouble with this can restore these lines.   ***/      ccraw.c_cc[4] = 1;     ccraw.c_cc[5] = 1; #ifdef datageneralE     if (ioctl(0,TCSETAW,&ccraw)) return(-1);    /* set new modes . */ 9     if (sys_gechr( channel(0), (1<<31)|$CLMAX, ch_ccraw)) 3          { perror("conbin: gechr: "); return(-1); }      return(0); #else =     return(ioctl(0,TCSETAW,&ccraw) );   /* set new modes . */  #endif }     5 /*  C O N R E S  --  Restore the console terminal  */   
 conres() {H     if (cgmf == 0) return(0);           /* Don't do anything if modes */@     if (!isatty(0)) return(0);          /* only for real ttys */ #ifdef datageneral     if (timocon)  0          /* Timeouts are set, so un-set them. */          resto(channel(0));  #endifF     ckxech = 0;                         /* System should echo chars */ #ifdef datageneralE     if (ioctl(0,TCSETAW,&ccold)) return(-1);    /* set new modes . */ 9     if (sys_sechr( channel(0), (1<<31)|$CLMAX, ch_ccold)) 2          { perror("conres: sechr "); return(-1); }     return(0); #else $     return(ioctl(0,TCSETAW,&ccold)); #endif }     A /*  C O N O C  --  Output a character to the console terminal  */    conoc(c) char c; {     write(1,&c,1); }   A /*  C O N X O  --  Write x characters to the console terminal  */    conxo(x,s) char *s; int x; {     write(1,s,x);  }   ; /*  C O N O L  --  Write a line to the console terminal  */    conol(s) char *s; {      int len;     len = strlen(s);     write(1,s,len);  }   G /*  C O N O L A  --  Write an array of lines to the console terminal */    conola(s) char *s[]; {
     int i;(     for (i=0 ; *s[i] ; i++) conol(s[i]); }   9 /*  C O N O L L  --  Output a string followed by CRLF  */    conoll(s) char *s; {
     conol(s);      write(1,"\r\n",2); }     H /*  C O N C H K  --  Return how many characters available at console  */  
 conchk() {     int x; long n;       if (!isatty(0)) return (0);  #ifdef UXIII:     if (conesc) {                       /* Escape typed */         conesc = 0; <         signal(SIGQUIT,esctrp);         /* Restore escape */         return(1);     }      return(0); #else  #ifdef FIONREAD G     x = ioctl(0, FIONREAD, &n);         /* BSD and maybe some others */      return((x < 0) ? 0 : n); #else >     return(0);                          /* Others can't do. */ #endif #endif }      #ifdef datageneral  G /* D G N C O U B -- Output len characters to the file number filenum */   6 dgncoub(filenum,chs,len) int filenum, len; char *chs;  {       int ac2,err;         if (len == 0) return(0);         if (filenum == ttyfdout) {             xout_parms.ibad = chs;            xout_parms.ircl = len;           ac2 = &xout_parms;
      } else { ,           w_io_parms.ich = channel(filenum);            w_io_parms.ibad = chs;            w_io_parms.ircl = len;           ac2 = &w_io_parms;      }       %      if ((err = sys_write(ac2)) == 0) O          return(((P_NIO_EX *) ac2)->irlr);  /* ENH - change to return length */ *      if ( err != ERLTL && err != EREOF ) {(           perror("dgncoub: sys_write ");H           return(-err);                     /* ENH - change to return */H      }                                      /* negative of error code */+      else return(((P_NIO_EX *) ac2)->irlr);  }     I /* D G N C I N B -- System level read of len characters from file number  ;    fileno.  The global DG i/o structures are used for this.   A    Return codes:  irlr if data read ok, where irlr=length of data                    -1 if EOF '                   -2 if timeout occured E                   -err if an AOS/VS error occured, where err is errno  */                     dgncinb(filenum,chs,len) int filenum,len; char *chs;  {               E      int ac2,                       /* I/O parameter address block */ =          err,                       /* Error from sys_read */ >          irlr;                      /* Number of bytes read */H      int rbe;                       /* Ring buffer empty on ESGT read */        if (filenum == ttyfd) {            x_io_parms.ibad = chs;            x_io_parms.ircl = len;)           ac2 = (P_NIO_EX *) &x_io_parms;            err = sys_read(ac2);!           irlr = x_io_parms.irlr;            if (err == 0) {                return(irlr);            } F           rbe = (x_io_parms.etsp == 0) ? 0 : (x_io_scrn.esfc & $ESBE);
      } else { .           r_io_parms.ich  = channel(filenum);             r_io_parms.ibad = chs;            r_io_parms.ircl = len;)           ac2 = (P_NIO_EX *) &r_io_parms;            err = sys_read(ac2);!           irlr = r_io_parms.irlr;            if (err == 0) {                return(irlr);            } F           rbe = (r_io_parms.etsp == 0) ? 0 : (r_io_scrn.esfc & $ESBE);      }  >      if ((err != ERLTL) && (err != ERDTO) && (err != EREOF)) {7           /* NOT line-too-long, timeout, or EOF errors. 9            * Don't print error when it is a data overrun. 
            */ >           if (err != EROVR) perror("dgncinb: sys_read error");           return(-err); 
      } else { I           /* If the system read buffer was empty when a screen management I           * packet was supplied, then there is a virtual EOF condition.   =           * So we return an EOF flag in that case (rbe != 0).            */E           if ((err == EREOF) || rbe) return(-1);            /* EOF */            if (err == ERDTO) J               if (irlr <= 0)                            /* if no data, */ G                   return (-2);                          /* return -2 */ M           return(irlr);                                 /* else chars read */       } }  #endif datageneral  9 /*  C O N I N C  --  Get a character from the console  */    coninc(timo) int timo; {     int n = 0; char ch;   :     if (timo <= 0) {            /* no timeout specified */       while (1) {          /* Binary input */         n = dgncinb(0,&ch,1);          if (n == 0) continue;          if (n > 0)L             return(ch & 0377);                 /* Return the char if read */         else {%             if (lasterror() == EINTR) <               if (conesc)  {            /* If by SIGQUIT, */I                  conesc = 0;            /* the conesc variable is set, */ M                  return(escchr);        /* so return the escape character. */ J               } else continue;           /* By other signal, try again. */J             else if (n == -2) {            /* won't happen unless ?STOM */L                 debug(F101,"coninc got timeout ","",n);   /* has happened */                 continue; M             } else if (n == -1)                         /* behind our back */ =                 debug(F101,"coninc got eof indication","",n); @             else if (n < -2)            /* -n = VS error code */<                 debug(F101,"coninc got AOS/VS error","",-n);             return(-1); 	         }        }      } D     saval = signal(SIGALRM,timerh);     /* else timeout specified */     alarm(timo);     if (setjmp(sjbuf)) n = -2;	     else           n = dgncinb(0, &ch, 1); <     ttimoff();                          /* Turn off timer */!     if (n > 0) return(ch & 0377); 
     else {+         debug(F101, "coninc(timo) n","",n); 9         debug(F101, "coninc(timo) errno","",lasterror()); 4         if ((lasterror() == EINTR) && conesc != 0) {             conesc = 0; L             return(escchr);             /* User entered escape character. */E         } else if (n == -2)                        /* won't happen */ :             debug(F101, "coninc got DEVICE timeout","",n);         else if (n == -1) 9             debug(F101,"coninc got eof indication","",n); D         else if (n < -2)                    /* -n = VS error code */8             debug(F101,"coninc got AOS/VS error","",-n);         return(-1); 	         }                     }   6 /*  C O N G K S  --  Console Get Keyboard Scancode  */    #ifndef congks /*G   This function needs to be filled in with the various system-dependent I   system calls used by SUNOS, NeXT OS, Xenix, Aviion, etc, to read a full -   keyboard scan code.  For now, it's a dummy.  */ int  congks(timo) int timo; {     return(coninc(timo));  }  #endif /* congks */     I /* These security routines are here, but they're not used.  There's no */ I /* need for them in the AOS/VS implementation.  When they were here,   */ I /* they caused superuser to be turned off when kermit was started with */ I /* it on.  Seemed to cause problems instead of solve them.       --ENH */    int N priv_ini()                                  /* if superu is on, turn off    */ {      int     ac0,ac1,ac2,error;       ac0 = ac1 = ac2 = 0;  ,     error = sys( $SUSER, &ac0, &ac1, &ac2 );N     if( ac0 == -1 )                         /* if it's on...                */N         priv_off();                         /* turn it off                  */       return  0; }    int N priv_on()                                   /* turn superu on               */ {      int     ac0,ac1,ac2,error;  N     ac0 = -1;                               /* turn it on                   */     ac1 = ac2 = 0;  ,     error = sys( $SUSER, &ac0, &ac1, &ac2 );     if( error != NULL ) N         error = -1;                         /* an error                     */       return  error; }    int 
 priv_off() {      int     ac0,ac1,ac2;  N     ac0 = 1;                                /* turn it off                  */     ac1 = ac2 = 0;  ,     return  sys( $SUSER, &ac0, &ac1, &ac2 ); }    int 
 priv_can() {      return  priv_off();  }    int 
 priv_chk() {      return  priv_off();  }     VOIDI ttimoff() {                           /* Turn off any timer interrupts */ 
     alarm(0);      if (saval)       signal(SIGALRM,saval);     else       signal(SIGALRM,SIG_DFL);     saval = NULL;  }   E /* Similarly, this ctrlc_chk() routine is here, but it's not used. */     void) ctrlc_chk(buffer,n) int *buffer; int n; {  #nolist  #include <ckcker.h>  #list      extern int local,what;
     int i;     extern SIGTYP trap();   D     debug(F101,"Entering ctrlc_chk -- number of chars in buf","",n);-     debug(F101,"ctrlc_chk local =","",local); +     debug(F101,"ctrlc_chk what =","",what); M     if (what == W_CONNECT)                  /* ignore ^C's in connect mode */          return; M     if (what == W_NOTHING)                  /* don't know what's what here */ M         return;                             /* so ignore ^C in case data   */      if ((!local) && C         ((what == W_SEND) || (what == W_RECV) || (what == W_REMO)))          return; O     for (i = 0; i < n; i++)                 /* otherwise it's W_SEND, W_RECV */ O                                             /* or W_REMOTE in local mode or  */ O                                             /* W_COMMAND in either mode      */ *         if ((buffer[i] & 0177) == CTRLC) {-             debug (F101,"Got ^C...","",what); B             my_count = 0;                   /* clear out buffer */E             trap(what);                     /* call signal handler */ 	         }  } 