 /* file ckmini.c  *H  * Module of mackermit containing code for the menus and other MacIntosh
  * things.  *  */    /*N   Copyright (C) 1985, 1994, Trustees of Columbia University in the City of NewK   York.  The C-Kermit software may not be, in whole or in part, licensed or L   sold for profit as a software product itself, nor may it be included in orM   distributed with commercial products or otherwise distributed by commercial J   concerns to their clients or customers without written permission of theK   Office of Kermit Development and Distribution, Columbia University.  This =   copyright notice must not be removed, altered, or obscured.  */   /*M  John A. Oberschelp for Emory University -- vt102 printer support 22 May 1989   */ @ /* Emory contact is Peter W. Day, ospwd@emoryu1.cc.emory.edu */ J /* Paul Placeway 4/89    - fixed up things for profiling, minor changes */O /* Paul Placeway 3/28/88 - created by moving a bunch of junk out of ckmusr.c */  /*B /* fdc Aug 94 - Make this module cooperate better with ckuus*.c */   #include "ckcdeb.h"  #include "ckcker.h" + #include "ckmdef.h"		/* General Mac defs */ / #include "ckmres.h"		/* Mac resource equates */ . #include "ckmasm.h"		/* new A8 and A9 traps */ #include "ckuusr.h"  #include "ckcasc.h"  #include "ckmcon.h"  #include "ckmwin.h" * #include "ckmptp.h"		/* ckm* Prototypes */   #ifdef COMMENT extern Handle hPrintBuffer;  extern long lPrintBufferChars; #endif /* COMMENT */   /* Global Variables */  4 extern MenuHandle menus[];	/* handle on our menus */  * Cursor *watchcurs;		/* the watch cursor */ Cursor *textcurs, *normcurs;   extern int quit, what;  9 extern Boolean mcmdactive;	/* Enable menu command keys */ . extern Boolean fkeysactive;	/* Enable FKEYs */  
 #ifdef notdef 3 WindowPtr terminalWindow;	/* the terminal window */  #endif2 WindowPtr commandWindow;		/* the command window */  L extern int dfloc;                       /* Default location: remote/local */< extern int dfprty;                      /* Default parity */B extern int dfflow;                      /* Default flow control */  2 extern int local;			/* running local or remote? */  C extern long mf_sleep_time;	/* this is the number of (60Hz) ticks to + 				 * sleep before getting a nullEvent (to . 				 * flash our cursor) (and input chars from 				 * the serial line)  				 */   > extern Boolean have_128roms;	/* actually, a Mac + or better */ extern struct cmdw *cmdwl;   /* local variables */   E Boolean have_fourone = FALSE;	/* true if we are running system 4.1 or  				 * better */O Boolean have_ctrl_key = FALSE; /* true if we have an ADB (SE or II) keyboard */   I Boolean usingRAMdriver = FALSE;	/* true if using the RAM serial driver */    #ifdef COMMENT  @ short takeFRefNum;		/* file reference number of the take file */  N /****************************************************************************/N /****************************************************************************/" /* prescan() is now in ckuus4.c */ VOID prescan() {  }   $ /* cmdini() is in now in ckuus5.c */ VOID OLD_cmdini () {      short vRefNum;     Str255 volName;      OSErr err;        GetVol (&volName, &vRefNum);>     err = FSOpen ("\pKermit Takefile", vRefNum, &takeFRefNum);#     /* try to open the take file */      if (err == noErr) {  	tlevel = 1;2 	getch ();		/* get first character of take file */
 	gettoken ();      }; }				/* cmdini */     N /****************************************************************************/# /* return uppercase for a letter */ N /****************************************************************************/ char CAP (char c) {      if (islower (c)) 	return (toupper (c));     else 	return (c); }				/* CAP */     #define TAK_SERV	1 #define TAK_QUIT	2 #define TAK_SEND	3 #define TAK_RECV	4 #define TAK_GET		5 #define TAK_INP		6 #define TAK_OUT		7 #define TAK_UNK 255    char *takecmdtab[] = {
     "SERVER",      "QUIT",      "SEND",      "RECEIVE",
     "GET",     "INPUT",     "OUTPUT" };   int taketoktab[] = {
     TAK_SERV, 
     TAK_QUIT, 
     TAK_SEND, 
     TAK_RECV,      TAK_GET,     TAK_INP,     TAK_OUT  };  3 #define NUMOFCMDS (sizeof (taketoktab)/sizeof(int))   N /****************************************************************************/9 /* return the token number for a specific take command */ N /****************************************************************************/ int 
 findcmd (cmd) 
 char *cmd; { 
     int k;  #     for (k = 0; k < NUMOFCMDS; k++) & 	if (strcmp (takecmdtab[k], cmd) == 0)0 	    return (taketoktab[k]);	/* and return ID */)     return (TAK_UNK);		/* else unknown */  }				/* findcmd */       char ch;  N /****************************************************************************/N /****************************************************************************/ getch () {      long count;        count = 1;3     if (FSRead (takeFRefNum, &count, &ch) != noErr)  	ch = '\0';  }				/* getch */      / #define TOK_CMD		1	/* command id in 'theCmd' */ . #define TOK_STR		2	/* string in 'theString' */. #define TOK_NUM		3	/* number in 'theNumber' */( #define TOK_ID		4	/* identifier token */* #define TOK_EOF		5	/* end of file token */ #define TOK_SLS		6	/* ',' */ #define TOK_DOT		7	/* '.' */( #define TOK_UNK	255		/* unknown token */  
 int token; int theCmd;  char theString[256]; long theNumber;   N /****************************************************************************/N /****************************************************************************/ gettoken ()  {      int cmdid;     char *c;     char buffer[30];     Boolean comment;  (     while ((ch <= ' ') || (ch == '/')) {3 	if (ch <= ' ')		/* skip all characters <= blank */ 1 	    if (ch == '\0') {	/* except eof character */  		token = TOK_EOF;	 		return;  	    } else  		getch ();   ' 	if (ch == '/') {	/* slash / comment */  	    getch ();   	    if (ch != '*') {  		token = TOK_SLS;	 		return;  	    } 	    getch (); 	    comment = TRUE; 	    while (comment) { 		if (ch == '\0') {  		    token = TOK_EOF;
 		    return;  		}  		if (ch == '*') { 		    getch ();  		    if (ch == '/') { 			comment = FALSE;  			getch (); 		    }  		} else 		    getch ();  	    }			/* while (comment) */   	}			/* if (ch == '/') */ 1     }				/* while ((ch <= ' ') || (ch == '/')) */   "     if (ch == '"') {		/* string */ 	token = TOK_STR;  	c = theString; 
 	getch ();   	while (TRUE) {  	    if (ch == '"')  		ch = '\0';   	    if (ch == '\\') { 		getch ();  		if (ch == 'n') 		    ch = '\n'; 		else if (ch == 'b')  		    ch = '\b'; 		else if (ch == 't')  		    ch = '\t'; 	    }4 	    if ((c - theString) < (sizeof (theString) - 1)) 		*c++ = ch;   	    if (ch == '\0') { 		*c = '\0'; 		getch (); 	 		return;  	    } else  		getch ();  	}     }				/* TOK_STR */2     if ((ch >= '0') && (ch <= '9')) {	/* number */ 	token = TOK_NUM;  	theNumber = 0; 
 	getch (); 	return;     }				/* TOK_NUM */     ch = CAP (ch);@     if ((ch >= 'A') && (ch <= 'Z')) {	/* command / identifier */ 	c = buffer;C 	while ((((ch >= 'A') && (ch <= 'Z')) ||	/* get the whole string */ " 		((ch >= '0') && (ch <= '9'))) &&1 	       ((c - buffer) < (sizeof (buffer) - 1))) {  	    *c++ = ch;  	    getch (); 	    ch = CAP (ch);  	}) 	*c = '\0';		/* end the buffer with \0 */   2 	cmdid = findcmd (buffer);	/* check for command */ 	if (cmdid != TAK_UNK) { 	    token = TOK_CMD; 8 	    theCmd = cmdid;	/* return the command id if true */ 	} else ; 	    token = TOK_ID;	/* return the identifier id if true */    	return;     }				/* TOK_CMD / TOK_ID */      switch (ch) {        case '.':		/* dot */ 	token = TOK_DOT;  	break;   (       default:			/* unknown character */ 	token = TOK_UNK;      }  }				/* gettoken */       N /****************************************************************************/N /****************************************************************************/ char
 nextcmd () {      if (token == TOK_CMD) {  	switch (theCmd) { 	    case TAK_SERV:  	    displa = TRUE; 6 	    protocmd = SERV_REMO;	/* run the mac as server */ 	    what = W_RECV; : 	    scrcreate ();		/* create the packet display dialog */ 	    gettoken ();  	    return ('x');   	  case TAK_QUIT:  	    quit = TRUE;  	    what = W_NOTHING; 	    FSClose (takeFRefNum);  	    return (0);  8 	  case TAK_SEND:	/* send a file: local, remote files */ 	    gettoken ();  	    if (token != TOK_STR)
 		return (0);   ; 	    strcpy (filargs.fillcl, theString);	/* file to send */    	    gettoken (); * 	    if (token == TOK_STR) {	/* send as */% 		strcpy (filargs.filrem, theString);  		gettoken (); 	    } else ) 		zltor (filargs.fillcl, filargs.filrem);    	    cmarg = filargs.fillcl; 	    cmarg2 = filargs.filrem;   - 	    nfils = -1;		/* Use cmarg, not cmlist */  	    protocmd = SEND_REMO; 	    what = W_SEND;  	    scrcreate ();/ 	    return ('s');	/* return with send state */    	  case TAK_RECV: * 	    initfilrecv ();	/* init recv flags */ 	    protocmd = RECV_REMO; 	    what = W_RECV;  	    scrcreate (); 	    gettoken (); / 	    return ('v');	/* return with recv state */   & 	  case TAK_GET:	/* Get from server */ 	    gettoken ();  	    if (token != TOK_STR)
 		return (0);    	    strcpy (cmarg, theString);  	    protocmd = GETS_REMO; 	    what = W_RECV;  	    scrcreate (); 	    gettoken ();  	    return ('r');   	  default:  	    return (0); 	}			/* switch (theCmd) */       } else {% 	tlevel = -1;		/* no more commands */  	what = W_NOTHING; 	FSClose (takeFRefNum);  	return (0);     }    }				/* nextcmd */ #endif /* COMMENT */    N /****************************************************************************/' /* init_menus - create the menu bar. */ N /****************************************************************************/ setup_menus () { 
     int i;#     static int menus_are_drawn = 0;      THz curZone;  9     ClearMenuBar();		/* remove all menus from the list */   ;     if (!menus_are_drawn) {	/* if the first time through */  	/* B 	 * PWP: we do command keys by default ONLY on a keyboard that has 	 * a CTRL key 	 */ 	mcmdactive = have_ctrl_key; 	  	/* setup Apple menu */ 5 	if ((menus[APPL_MENU] = GetMenu (APPL_MENU)) == NIL) . 	    printerr("Couldn't get MENU", APPL_MENU); 	else + 	    AddResMenu (menus[APPL_MENU], 'DRVR');  	      	/* setup Font menu */5 	if ((menus[FONT_MENU] = GetMenu (FONT_MENU)) == NIL) . 	    printerr("Couldn't get MENU", FONT_MENU); 	else + 	    AddResMenu (menus[FONT_MENU], 'FONT');  	/* N 	 * BUG: for some reason on my Duo running 7.1, AddResMenu adds the VT100 font 	 * entries TWICE.  Bleah. 	 */ 	  #ifdef COMMENT     } else {:     	ClearMenuBar();		/* remove all menus from the list */ #endif /* COMMENT */       }      G     InsertMenu (menus[APPL_MENU], 0);	/* Put Apple Menu on menu line */   A     for (i = MIN_MENU; i <= LAST_MENU; i++) {	/* For all menus */ *         if (menus_are_drawn && menus[i]) {H 	    curZone = GetZone();       /* as per John Norstad's Disinfectant */D 	    SetZone(HandleZone((Handle) menus[i]));	/* "Toolbox Gotchas" */A 	    ReleaseResource((Handle) menus[i]);		/* free old resource */  	    SetZone(curZone); 	}     	if (mcmdactive) {) 	    if ((menus[i] = GetMenu (i)) == NIL) % 				/* Fetch it from resource file */ # 		printerr("Couldn't get MENU", i); 	 	} else { . 	    if ((menus[i] = GetMenu (i+32)) == NIL) { 				/* try to get w/o clover */ - 	        printerr("Couldn't get MENU", i+32); ? 		menus[i] = GetMenu (i);	/* Fetch normal from resource file */  	    } 	} 	if (i <= MAX_MENU) 8 	    InsertMenu (menus[i], 0);	/* Put it on menu line */ 	else 7 	    InsertMenu (menus[i], -1);	/* make it a submenu */      }           /* add the font menu too */ -     InsertMenu (menus[FONT_MENU], REMO_MENU);        /* Disable various items */ ,     DisableItem(menus[FILE_MENU], PBUF_FIL);-     DisableItem(menus[FILE_MENU], PSTAT_FIL); 3     /* DisableItem(menus[FILE_MENU], PDISC_FIL); */ 3     /* DisableItem(menus[FILE_MENU], POPEN_FIL); */ -     DisableItem(menus[FILE_MENU], TAKEW_FIL);   L     /* setup_font_menu(); -- we do this AFTER we have set up the terminal */  :     DrawMenuBar ();		/* Finish up by displaying the bar */  8     CheckItem (menus[SETG_MENU], MCDM_SETG, mcmdactive);     menus_are_drawn = 1; }				/* setup_menus */   Boolean  IsWNEImplemented ()  {      int err;     SysEnvRec theWorld; A #define FOURONEVERSION	1040	/* version == (short) (4.1 * 256.) */        /*I      * (from Mac Tech Note #158) We need ot call SysEnvirons to make sure M      * that WaitNextEvent is implemented.  If we are running on 64K ROMs, and G      * RAM HFS is running (trap 0xA060), then GetTrapAddress(0x60) will L      * return a value different from the unimplemented trap since trap 60 isL      * implemented for HFS and the 64K ROM version of GetTrapAddress doesn't/      * differentiate between OS and Tool traps.       */   3     /* These are both toolbox traps, hence the 1 */ I     err = SysEnvirons (1, &theWorld);	/* we have the glue, so machineType $ 					 * will allways be filled in */  1     /* to see if we can use the script manager */ >     have_fourone = (theWorld.systemVersion >= FOURONEVERSION);  Q     /* The Original Mac 128 keyboard, the Lisa, and the Plus did not have control K        keys, but all ADB keyboards and newer seem to, so default to yes. */ A     have_ctrl_key = !((theWorld.keyBoardType == envUnknownKbd) || / 		      (theWorld.keyBoardType == envMacKbd) || 2 		      (theWorld.keyBoardType == envMacAndPad) ||2 		      (theWorld.keyBoardType == envMacPlusKbd));  8     have_128roms = !((theWorld.machineType == envMac) ||-     		     (theWorld.machineType == envXL) || 5     		     (theWorld.machineType == envMachUnknown));           /* is WNE implemented? */ !     if (theWorld.machineType < 0) = 	return FALSE;		/* we don't know what kind of Mac this is. */   .     /* "..., 1" 'cause these are tooltraps: */J     /* 6.0.2 bug fixed by RWR <CES00661%UDACSVM.BITNET@cunyvm.cuny.edu> */     2     if ((NGetTrapAddress (num_WaitNextEvent, 1) !=5 	 NGetTrapAddress (num_UnknownTrap, 1)) &&	/* RWR  */ 6 	(NGetTrapAddress (num_JugglDispatch, 1) !=	/* RWR  */4 	 NGetTrapAddress (num_UnknownTrap, 1)))		/* RWR  */
 	return TRUE;        return FALSE;  }   < extern hmacrodefs macroshdl;	/* handle to the macro table */9 extern modrec modtable[NUMOFMODS];	/* modifier records */ 8 extern RgnHandle dummyRgn;	/* dummy region for ckmcon */? extern long MyCaretTime;	/* ticks between flashes for cursor */ 1 extern int deblog;		/* should we do debugging? */   N /****************************************************************************/H /* mac_init - Initialize the macintosh and any window, menu, or other */! /* resources we will be using. */ N /****************************************************************************/ mac_init ()  {      int err;
     int i;     CursHandle cursh;   2     deblog = 0;			/* don't do deugging to start */      /*    DebugStr("\p;hs");	*/   8     MaxApplZone ();		/* Make appl. heap big as can be */       /*C      * Last time I looked, Kermit was using 131 relocatable blocks. C      * MoreMasters() allocates 64, and we want to add a bit of slop F      * to our guess (say 1.25 * measured).  Then divide this number byE      * 64 to see how many times to call MoreMasters (3, in this case)       */ 4     MoreMasters ();		/* Create 64 master pointers */9     MoreMasters ();		/* Create 64 more master pointers */ 9     MoreMasters ();		/* Create 64 more master pointers */      err = MemError ();     if (err != noErr) , 	printerr ("Unable to create masters", err);  4     InitGraf (&qd.thePort);	/* Init the graf port */"     InitFonts ();		/* The fonts */8     FlushEvents (everyEvent, 0);	/* clear click ahead */&     InitWindows ();		/* The windows */   /* Debugger(); */      /*I      * PWP: we MUST call IsWNEImplemented() BEFORE using have_fourone, or &      * have_ctrl_key (in InitMenus() )      */ <     have_multifinder = IsWNEImplemented ();	/* See Above. */       InitMenus (); %     TEInit ();			/* Init text edit */ C     InitDialogs ((ResumeProcPtr) NILPROC);	/* The dialog manager */ 2     InitCursor ();		/* start with a nice cursor */*     SetEventMask (everyEvent - keyUpMask);       dummyRgn = NewRgn ();        normcurs = &qd.arrow; 3     if ((cursh = GetCursor (watchCursor)) != NIL) {  	HLock((Handle) cursh); . 	watchcurs = *cursh;		/* the waiting cursor */     } else {     	watchcurs = &qd.arrow;      } 3     if ((cursh = GetCursor (iBeamCursor)) != NIL) {  	HLock((Handle) cursh); / 	textcurs = *cursh;		/* the text body cursor */      } else {     	textcurs = &qd.arrow;     }   !     MyCaretTime = GetCaretTime(); -     if (MyCaretTime < 3 || MyCaretTime > 300)  	MyCaretTime = 20L;      *     setup_menus ();		/* build our menus */+     enable_fkeys(TRUE);		/* enable FKEYs */   3     inittiobufs();		/* init terminal I/O buffers */   ,     initfilset ();		/* init file settings */  4     port_open(-6);		/* open Modem port by default */          parity = DEFPAR;J     if (!setserial (innum, outnum, DSPEED, DEFPAR))	/* set speed parity */9 	macfatal("Couldn't set serial port to default speed",0);      (void) sershake(flow); 	 A     ttres();		/* (PWP) set up flow control for interactive use */      B     ttermw = consetup(TERMBOXID);	/* initialize terminal window */A     ctermw = consetup(LCMDBOXID);	/* initialize command window */ Q     rcmdw = initcmdw(RCMDBOXID, RCMDVSCROLL, RCMDHSCROLL);  /* init remote win */   R     prntw = initcmdw(RCMDBOXID, RCMDVSCROLL, RCMDHSCROLL);  /* init printer win */2     SetWTitle (prntw->window, "\pPrinter window");.     /* setwname(prntw, "\pPrinter window"); */     9     displa = TRUE;			/* Make everything goes to screen */   #     /* init (internal) clipboard */      init_scr_clip();          /* init the macro table */7     macroshdl = (hmacrodefs) NewHandle (MacroBaseSize); "     (*macroshdl)->numOfMacros = 0;  "     /* clear the prefix strings */#     for (i = 0; i < NUMOFMODS; i++)  	modtable[i].prefix[0] = '\0';  7     loadkset ();		/* PWP: get our defaults for these */      loadmset ();  H     /* Frank changed main() to call init and then set flow, parity, etc.I        so we make sure they will be set right (again) after we return. */ O /***    dfloc = local;                  /* And whether it's local or remote. */ A     dfprty = parity;                    /* Set initial parity, */ ?     dfflow = flow;                      /* and flow control. */   E 	/* we have to set up the font menu AFTER we have inited the terminal  	   and loaded any init file */      setup_font_menu();   #ifdef PROFILEJ     if (!INITPERF(&ThePGlobals, 1, 8, FALSE, TRUE, "\pCODE", 0, "\pROMII",     	          FALSE, 0, 0, 0)) * 	macfatal("Could not start profiling", 0);*     (void) PerfControl(ThePGlobals, TRUE); #endif /* PROFILE */ }				/* mac_init */   N /****************************************************************************/M /* mac_post_load_init - Finish initializing anything that needs to be done */ : /* after loading whatever init file the user clicked on */N /****************************************************************************/ mac_post_load_init() {      extern int startconnected;  1     kShowWindow(ttermw);		/* show terminal win */      if (startconnected) A 	kSelectWindow(ttermw->window);	/* and make sure it's in front */ 
     else { 	kShowWindow(ctermw);  	kSelectWindow(ctermw->window);  	/* : 	 * Normally we just let the activate event set in_front. < 	 * For some reason this is not working in this startup case= 	 * so go ahead and set it until someone figures out the bug. / 	 * Otherwise, neither window ends up in_front.  	 */ 	ctermw->in_front = TRUE;      }  }   N /****************************************************************************/G /* syscleanup() - called before leaving this program to clean up any */ ' /*    	      	   dangling Mac stuff. */ , /* Called by doexit, transfer and zkself. */N /****************************************************************************/
 syscleanup ()  { 8     enable_fkeys(TRUE);		/* re-enabled screen dumping */     /     FutzOptKey(0);		/* reset old Mac key map */       #ifdef PROFILE9     if (PERFDUMP(ThePGlobals, "\pPerform.out", true, 80)) 0 	macfatal("Could not dump profiling output", 0);"     (void) TermPerf (ThePGlobals); #endif /* PROFILE */  8     port_close();		/* close the REAL serial port down */  5     DisposeMacros ();		/* dipose all macro strings */      if (macroshdl)A 	DisposHandle ((Handle) macroshdl);	/* release the macro table */      macroshdl = 0L;           destroy_scr_clip();      9     printer_close();		/* release any printer resources */    #ifdef COMMENT     if (hPrintBuffer)  	DisposHandle(hPrintBuffer);     hPrintBuffer = 0L;     lPrintBufferChars = 0L;  #endif /* COMMENT */       DisposeRgn (dummyRgn); }				/* syscleanup */   
 #ifndef NOICP 
 #ifndef NOSPL 9     extern struct mtab *mactab;		/* For ON_EXIT macro. */      extern int nmac; #endif /* NOSPL */ #endif /* NOICP */   VOID. doclean() {				/* General cleanup upon exit */     struct cmdw *cmdw;       if (pktlog) {  	zclose(ZPFILE); 	pktlog = 0;     }      if (seslog) {  	zclose(ZSFILE); 	seslog = 0;     }  #ifdef TLOG      if (tralog) { + 	tlog(F100,"Transaction Log Closed","",0L);  	zclose(ZTFILE); 	tralog = 0;     }  #endif /* TLOG */   
 #ifndef NOICP 
 #ifndef NOSPL 9     zclose(ZRFILE);			/* READ and WRITE files, if any. */      zclose(ZWFILE);  /*M   If a macro named "on_exit" is defined, execute it.  Also remove it from the M   macro table, in case its definition includes an EXIT or QUIT command, which M   would cause much recursion and would prevent the program from ever actually 
   EXITing. *//     if (nmac) {							/* Any macros defined? */  	int k;							/* Yes */ : 	k = mlook(mactab,"on_exit",nmac); /* Look up "on_exit" */" 	if (k >= 0) {					/* If found, */A 	    *(mactab[k].kwd) = NUL;		/* poke its name from the table, */ + 	    if (dodo(k,"") > -1)		/* set it up, */ $ 		parser(1);				/* and execute it */ 	}     }  #endif /* NOSPL */ #endif /* NOICP */   /*E   Put console terminal back to normal.  This is done here because the L   ON_EXIT macro calls the parser, which meddles with console terminal modes. */6     ttclos();				/* Close external line, if any */           /*/      * Check about saving any modified buffers.       */ /     for (cmdw = cmdwl; cmdw; cmdw = cmdw->next) " 	if (cmdw->flags & CMDWF_MODIFIED) 	    checksave(cmdw);        /*G      * We don't need to do anything with the terminal name or resetting <      * the console here, since there really is no "console".      */    #ifdef DEBUG/     /* Close the debug log as the LAST thing */           if (deblog) { % 	debug(F100,"Debug Log Closed","",0);  	zclose(ZDFILE); 	deblog = 0;     }  #endif /* DEBUG */  8     syscleanup();			/* System-dependent cleanup, last */ }   N /****************************************************************************/K /* doexit(status) - exit to shell.  Perhaps we should check for abnormal */ $ /*    	      	    status codes... */ /*J  * First arg is general, system-independent symbol: GOOD_EXIT or BAD_EXIT./  * If second arg is -1, take 1st arg literally. 7  * If second arg is not -1, work it into the exit code.   */ N /****************************************************************************/ VOID doexit(exitstat,what)  int exitstat, what;  { .     debug(F101,"doexit exitstat","",exitstat);&     debug(F101,"doexit what","",what);     1     doclean();			/* First, clean up everything */      I     /* the Mac doesn't really have a good/bad exit value, so just exit */           ExitToShell ();  }				/* doexit */    /*H  * Junk so Emacs will set local variables to be compatible with Mac/MPW.  * Should be at end of file.   * This routine uses 8 char tabs  *    * Local Variables:   * tab-width: 8   * End:   */ 