 @Part(CKMKER,root="kuser") @string(-ckmver="@q<0.9(40)>")   @Chapter<MACINTOSH KERMIT>   @case(device,file="@*--------@* K This document is formatted as an ordinary, plain text ASCII disk file, from I SCRIBE text formatter source.  Typeset copies are available from Columbia  University.@*--------@*")    @Begin<Description,spread 0>C @i(Program:)@\Bill Catchings, Bill Schilit, Frank da Cruz (Columbia  University),@*+ Davide Cervone (University of Rochester),@* @ Matthias Aebi (ECOFIN Research and Consulting, Ltd., Zuerich),@*& Paul Placeway (Ohio State University).   @i(Language:)@\C (MPW)  C @i(Documentation:)@\Christine Gianone, Frank da Cruz, Paul Placeway    @i(Version:)@\@value(-ckmver)    @i(Date: )@\May 26, 1988 @end<Description>   0 @subheading<MacKermit Capabilities At A Glance:>, @begin<format,leftmargin +2,above 1,below 1>' @tabclear()@tabset(3.5inches,4.0inches)  Local operation:@\Yes ) Remote operation:@\Yes (server mode only)  Login scripts:@\No Transfer text files:@\Yes  Transfer binary files:@\Yes  MacBinary transfers:@\No' Wildcard send:@\Yes (whole HFS folders)   File transfer interruption:@\Yes" Filename collision avoidance:@\Yes Can time out:@\Yes 8th-bit prefixing:@\Yes  Repeat count prefixing:@\Yes Alternate block checks:@\Yes& Terminal emulation:@\Yes (VT100,VT102)2 Communication settings:@\Yes (Speed, Parity, Echo) XON/XOFF:@\Yes Transmit BREAK:@\Yes! IBM mainframe communication:@\Yes  Transaction logging:@\Yes  Session logging:@\Yes  Debug logging:@\No Packet logging:@\No  Act as server:@\Yes  Talk to server:@\Yes Advanced server functions:@\Yes  Local file management:@\Yes  Command/Init files:@\No  Key redefinition/macros:@\Yes  File attributes packets:@\No Command macros:@\No  Raw file transmit:@\No Long packets:@\Yes Sliding windows:@\No @end<format>   @section(Introduction) @index<Apple Macintosh>  @index<Macintosh Kermit> @index<CKMKER>J  Macintosh Kermit, or "MacKermit", is an implementation of the Kermit fileE transfer protocol for the Apple Macintosh family of computers. It was I developed at Columbia University, based on C-Kermit (which also forms the G nucleus of Unix Kermit and many other Kermit programs).  Version 0.9 of L MacKermit runs on the Macintosh 512, XL (Apple Lisa running MacWorks), 512e,M Plus, SE, and II, under the regular Finder and the Multifinder, with which it F can transfer files in the background@index<Background>.  MacKermit 0.9M probably does not run on a 128k (original, classic) Macintosh, due to lack of K sufficient memory, but should run OK on a "fat Mac" (a 128K Mac upgraded to 5 512K).  Version 0.8 should be retained for 128K Macs.   L This manual assumes you are acquainted with your Macintosh, and that you areO familiar with the general ideas of data communication and Kermit file transfer. O A very brief overview is given here, but for details consult the early chapters O of the @i<Kermit User Guide> (of which this document is a chapter), or the book J @ux<Kermit, A File Transfer Protocol>, by Frank @w<da Cruz>, Digital PressN (1987).  For further information about Kermit documentation, updates, lists of? current available versions, and ordering information, write to:  @begin<example,use r,need 5> Kermit Distribution 3 Columbia University Center for Computing Activities  612 West 115th Street  New York, NY  10025  (USA)
 @end<example>    @Section<Installation>  N Before you can use Macintosh Kermit or any other communication program on yourI Mac, you must have a way to connect it to the other computers you wish to M communicate with.  This means either a direct cable connection (usually using K a "null modem" cable), or a modem connected to your Mac and to a telephone. N The Macintosh poses two special problems at this level.  First, its connectorsK are not the standard 25-pin RS-232 style, but either 9-pin or 8-pin special K connectors which you need special adapters for.  Second, the Macintosh does N not supply a Data Terminal Ready (DTR@index<DTR>) signal, which is required byK most modems before they will operate.  To use your Mac with a modem that is K not designed specifically for the Mac, you have to either (a) configure the M modem to ignore the DTR signal, or (b) feed some other active signal into the N modem's DTR input.  The former is usually done with DIP switches on the modem,D the latter can be done in the connector that plugs into the modem byD installing a jumper wire between DTR (pin 20) and DSR (pin 6), or byL connecting the Mac's +12V output (pin 6 on the Mac's 9-pin connector) to DTR (pin 20) on the modem end.  J If you have received a Macintosh Kermit diskette from Columbia University,E there's no special software installation procedure -- just insert the H diskette, double-click on the appropriate start-up file, or on MacKermitL itself, and go.  If all the communication and other settings agree with yourC requirements, there's nothing else you need to do.  This process is , illustrated in the next section, just below.  L MacKermit is not copy-protected, and nothing out of the ordinary is requiredL to make copies onto other diskettes, or onto your hard disk if you have one.G Just use the ordinary Macintosh methods of copying files, folders, etc.   K Later, you may wish to create settings files tailored to your communication M environment, and you might also want to customize the keyboard configuration. M Use the various Settings options for this, and then select Save Settings from E the File menu.  Settings and settings files are explained in Sections " @ref<-macset> and @ref<-macsfile>.   @section(Getting Started)  @label<-macstart>   H Kermit programs perform two major functions, terminal emulation and fileM transfer.  Before transferring files between two systems you must establish a L terminal connection from your system to the other one, either direct or elseL dialed up using a modem.  Then to transfer files, login to the remote systemK if necessary, start up a Kermit program there, and then tell the two Kermit 8 programs which files to transfer, and in what direction.  M Most Kermit programs present you with a prompt, in response to which you type N a command, repeating the process until you exit from the program.  If you wantG to establish a terminal connection to another system, you must give the K CONNECT command.  Unlike these programs, MacKermit is @i<always> connected, G and whatever keystrokes you type are sent to the other system.  To give N commands to MacKermit itself, you must use the mouse@index(Mouse) to pull downL menus from the menu bar that overlays your terminal session, or type special Command-key equivalents.  N The following example shows how to transfer a file with MacKermit.  The remoteG computer is a Unix system, but the method is the same with most others.  @begin(itemize) I First insert the MacKermit diskette.  It should appear on the screen as a M diskette icon titled @b<Kermit 0.9(40)>.  Click on it twice to open if it did 9 not open automatically when you inserted it in the drive.   M Once the disk is opened, you will see three MacKermit icons across the top of K the screen.  For the Unix system and most others you can use the "@b(Normal O Settings)" icon -- to start the Kermit program click twice on it.  For linemode M connections to IBM mainframes, you would click twice on the "@b(IBM Mainframe  Linemode Settings)" icon.   M You will see a white backround with menus stored under the headings @b(File), 0 @b(Edit), @b(Settings), @b(Remote), and @b(Log).  : Move the mouse pointer to the @b(Settings) menu and select- @b(Communications...) by clicking on it once.   H MacKermit normally sets the communication speed to 9600 bits per second.M Click on the circle in front of 1200 (or whatever speed you need to match the K baud rate of your modem and/or remote system).  Check to see that the other J communication settings like parity are as required, and make any necessary changes.  1 Click on the "@q<OK>" box to accept the settings.   B If you have a Hayes-like dialout modem, follow the next two steps: @begin<enumerate> K Type AT (uppercase) and then press the Enter key.  The modem should respond N with "OK" or the digit "0" (zero).  If it doesn't, check the cable, the modem,, etc (consult your modem manual for details).  L Now type ATDT 7654321 followed by Enter (replace 7654321 by the actual phoneO number).  If the connection succeeds, you'll get a message like CONNECT (or the N digit "1"), otherwise you'll see an error message like NO CARRIER, ERROR, etc,/ or a digit like 3 or 4 (see your modem manual).  @end<enumerate> N For non-Hayes-compatible modems, follow the instructions in your modem manual.2 For direct connections, skip this step altogether.
 @end<itemize> L Now you should be talking to the Unix system.  Type a carriage return to getJ its attention, and it will issue its login prompt.  In the examples below,: underlining is used to show the parts that you would type. @begin<example>  @tabclear()@tabset(2.5inches) , Login: @ux<christin>@\@i(Login to the host.): password:@ux<      >@\@i<(Passwords normally don't echo.)>  * % @ux<kermit>@\@i(Run Kermit on the host.)  5 C-Kermit>@ux<receive>@\@i(Tell it to receive a file.) 
 @end<example>   % Now tell MacKermit what file to send:  @begin<itemize> K Use the mouse to point to the @b(File) menu and select the @b(Send File...) N option.  You can either type in the name of the file (if you know the name) orK select the alternate drive to see what files are on the disk.  Once you see K the file you want to send, click on the filename and then click on the SEND 5 option (or you can just click twice on the filename).   F A "File Transfer Status" box will appear to report the progress of theM transer.  @i(NOTE:) If the number of retries is increasing but not the number J of packets, you should check your @b(Communications...) settings under the @b(Settings) menu.  J When the file transfer is completed, the "File Transfer Status" box should4 disappear and the C-Kermit prompt should reappear.  
 @end(itemize)   K You have just transferred a file from the Macintosh to the Unix system.  To G transfer a file in the other direction, use the "@q(send )@i<filename>" L command on Unix instead of "@q(receive)", and click on "@b(Receive File...)"< from the Mac's @b(File) menu, instead of "@b(Send File...)".  H After the file is transferred, your terminal connection is automaticallyG resumed.  Once your Unix session is complete, you can log out, and then  exit from MacKermit: @begin<example>  @tabclear()@tabset(2.5inches)  C-Kermit>@ux<exit>  1 % @ux<^D>@\@i(Logout from Unix by typing Ctrl-D.) 
 @end<example>    @begin<enumerate,spread 0.5>B Select the @b(Quit) option in the @b(File) menu by clicking on it.  L Select the @b(Close) option in the @b(File) menu by clicking on it (assuming& you want to close the current folder).  L Select the @b(Eject) option in the @b(File) menu by clicking on it (assuming7 you ran Kermit from a diskette that you want to eject).  @end<enumerate> K That's the easiest and quickest way to use Kermit.  If this simple scenario O does not work for you, look for any obvious incorrect settings (speed, parity), - fix them, and try again.  Otherwise, read on.   # @Section(The Macintosh File System)   M The Macintosh file system consists of one or more disks, each disk containing J files.  There are actually two Macintosh file systems, which work slightly differently.  H Disks formatted for the older Macintosh File System (MFS)@index<MFS> areM essentially "flat".  All files on one of these disks must have a unique name. M Files may be collected together into "folders"@index<Folder>, but folders are M not analogous to directories on other file systems, and no two folders on the L same disk may contain files of the same name; the folders exist only to makeG things look nicer in the Finder.  All Macintoshes have support for MFS.   L Disks formatted with the newer Hierarchical File System (HFS)@index<HFS> areL not "flat"; each folder is a directory.  There may not be more than one fileI with the same name in a single folder, but there may be identically named  files in different folders.   F Macintosh file names may contain practically any printable characters,L including space and punctuation -- but colon (@qq[:]) may not be used; it is; used in device names and as the HFS path element separator.    @section(Menus)   L The major menus are @b(Apple), @b(File), @b(Edit), @b(Settings), @b(Remote),J and @b(Log).  The @b(Apple) menu gives some information about the program,O including the MacKermit version number and the C-Kermit protocol mudule version K number (useful in reporting bugs).  It also shows statistics about the most  recent file transfer.   N The @b(File) menu invokes Kermit's file transfer functions, @b(Send), @b(Get),, and @b(Receive).  It also allows settings toN be saved and restored, and like most Macintosh applications, includes a "quit"I entry for leaving the program, and a "transfer" entry for transferring to 1 another program without going through the Finder.   N The @b(Edit) menu provides support for Macintosh desk accessories that need toM have this menu to do cut and paste.  This menu does not currently do anything 
 in MacKermit.   I The @b(Settings) menu provides dialog boxes for file, communications, and 1 protocol settings; these will be discussed below.   K The @b(Remote) menu has the commands that can be sent to Kermit servers, as E well as an option to turn Macintosh Kermit itself into a server (also  discussed below).   L The @b(Log) menu contains commands to start and stop session and transactionN logging.  It also has an entry to dump the current screen image to the session8 log, which is only enabled when the session log is open.   @Section<Terminal Emulation>  J Before you can transfer files, you have to establish a terminal connectionN with the other computer.  You don't have to give MacKermit any special commandM to do this, just start the program.  Assuming you have a physical connection, L then the software will use it.  If you think you have a physical connection,D but don't see any results, click on the @b(Settings) menu and selectL @b(Communications) to make sure you have the right speed and parity.  If youI have to dial out to make the connection, you must do this yourself -- Mac L Kermit won't do it for you.  Depending on the type of modem, you must eitherH type dialing commands to it directly (like the Hayes ATDT command in theN example in section @ref<-macstart>), or else dial the phone manually, wait forB an answer and a carrier tone, and then put the modem in data mode.  K Once you've made the connection, you can use MacKermit's terminal emulator,  @index<VT102 Emulation> L which conforms to ANSI standard X3.64, providing a subset of the features ofI the DEC VT102 terminal (a VT100 with line and character insert and delete N functions added).  The functions provided are sufficient to allow MacKermit toG act as a terminal for the EMACS full-screen editor as it exists on most O timesharing systems, and for most host-@|resident display-oriented applications N that expect to do cursor positioning and editing on the VT100 or VT102 screen,N such as VAX TPU.  MacKermit does not currently support the following VT100/102
 functions: @Begin(Itemize,spread 0)# Double height or double width lines    Blinking   132 columns    DEC-style line wrapping   / Control characters embedded in escape sequences   	 VT52 mode 
 @End(Itemize)   (this is not an exhaustive list)  M The keyboard is set up by default as follows: If your Macintosh has a Control L key (ie. an SE or II), Kermit uses it, and the Command (Fan, Cloverleaf) keyL can be used for keyboard equivalents for menus.  If your Mac does not have aL Control key, then the Command key is used as the Control key.  The CAPS LOCKJ key forces all alphabetic characters to upper case.  The terminal emulatorJ sends ESC (escape) when the @qq(`) (accent grave) key is pressed unshiftedL (even if your keyboard has an ESC key).  The character @qq(`) can be sent byH typing Control (or Command) and the same key.  The Backspace key sends aK Delete (Rubout) and Control-@|Backspace sends a Backspace.  On the original N Mac keyboards, the main keypad Enter key sends a "short" (250ms) BREAK signal.N The Mac+, Mac SE, and Mac II do not have a main keypad Enter key, so the BREAK+ function must be reassigned to another key.    @index<Key Redefinition>N You can modify the keyboard layout any way you like, defining keyboard macros,G defining or moving the Control and Escape keys, etc., using MacKermit's G built-in key configuration features.  Older MacKermits (version 0.8 and L earlier) came with a separate key configuration program called CKMKEY.  ThisL should not be used, because it does not understand the format of the 0.9 and& later keyboard configuration software.  M MacKermit includes a mouse-controlled@index<Mouse> cursor positioning feature K for use during terminal emulation.  If the "Mouse -> Arrow Keys" feature is N turned on (via the @b[Terminal] entry of the @b[Settings] menu), then when theJ mouse button is pressed, the program acts as if you typed the VT100 keypadD arrow keys to move the terminal cursor to where the mouse cursor is.C MacKermit does this by sending the absolute strings for arrow keys, F independant of what is bound to the actual arrow keys of the keyboard.  F MacKermit sets the Mac hardware to do 8-bit data communication with noN parity@index(Parity), and then correctly sets the parity bit of each characterN itself in software, as requested in the @b<Communication> settings menu.  ThisE has the benefit of avoiding the problem of a machine which requires a L different input parity than it sends back.  MacKermit will correctly receiveB all of the characters sent to it, no matter which parity they are.  H To allow useful coexistence of desk accessories and Kermit, the terminalH emulation window may be dragged using the drag bar.  If a desk accessoryO overlays the emulation window, the emulation window can be clicked upon to move O it in front of the DA, and later dragged to reveal the hidden desk accessory so K that it can be restored to the foreground.  The same thing can be done with I Kermit's own remote response window as well.  Note that Kermit's terminal F emulation window does not accept input when any other window is in the foreground.   E MacKermit uses XON/XOFF (control-Q and control-S) flow control during C terminal emulation and file transfer.  If the other system does not F understand XON/XOFF, problems may result at high speeds.  The terminalF emulator can normally keep up at 9600 baud, and has a very large inputJ buffer, but after several continuous scrolling screens at this speed, someI characters may be lost.  When running at high baud rates on a system that G does not understand XON/XOFF flow control, either keep your terminal in K page mode, use a text paging program such as Unix "more", or view text with I a non-@|scrolling screen editor.  Also, don't drag the terminal emulation K window while characters are arriving; if you do, the characters may be lost $ and the display may become confused.  ' @index(Session Log)@index(Raw Download) J During terminal emulation, the characters displayed on the screen may alsoF be saved on the disk.  This allows you to record interactions with theH remote system, or to "capture" files that you can't transfer with KermitL protocol, for example when the remote system does not have a Kermit program.J Use the @b<Log> menu, and choose session logging to activate this feature.J The result goes into a file called "Kermit Session" in the current folder,N which is always appended to, rather than overwritten.  To create a new session( log, delete or rename the old one first.  H The following features are missing from the MacKermit terminal emulator,( and may be added in subsequent releases: @Begin(Itemize,Spread 0)H Restoration of character attributes such as underlining or highlighting.  & Cutting text from screen to clipboard.  : Transmission of raw text to host (e.g. pasting to screen).   Screen rollback.   Screen resizing.  ! Explicit modem or dialer control.    Login scripts.   Printer support.  7 Ability to use the printer port for terminal emulation.   F A way to disable XON/XOFF flow control, or select other flow controls.
 @End(Itemize)    @Section(File Transfer)   K Like most Kermit programs, MacKermit allows you to send and receive text or H binary files singly or in groups.  It will interact with a remote KermitM server, and it can act as a server itself.  However, due to the unique nature D of the Macintosh file system, there are some special considerations: @Begin(Itemize)  @begin<multiple>M @u<Mode> - Text or Binary@index<Binary Files>.  Binary means the data is sent F or stored without modification.  Text means that every carriage returnN character (CR) in a Macintosh file is translated to a carriage-return-linefeedJ (CRLF) sequence when sending, and every CRLF in an incoming file is turnedM into a CR when stored on the Mac disk.  A text file is produced when you save M a file from MacWrite or other applications using the "text only" option; text M files are not associated with any particular Macintosh application and can be 5 sent in a useful fashion to other kinds of computers.   G A word of caution about Macintosh text files: The Macintosh supports an N extended version of ASCII@index<Extended ASCII>, with characters like accentedA and umlauted vowels in the 128-255 range.  These characters allow K representation of Roman-based languages other than English, but they do not N follow any of the ISO standards for extended character sets, and thus are onlyM useful on a Mac.  When transferring text files, you should ensure that either J there are no extended characters in the file, or that the other system can& understand the Mac's 8-bit characters. @end<multiple>  : @u<Fork> - Data or Resource.  Macintosh files may have twoI "forks"@index(Fork).  The data fork contains data for an application; the G resource fork contains icons, strings, dialog boxes, and so forth.  For M instance, a MacWrite document contains text and formatting information in the L data fork, and fonts in the resource fork.  For applications, the executable$ code is stored in the resource fork.
 @End(Itemize)   G File transfer is initiated when you select @b(Send file...), @b(Receive H File...), or @b(Get file from server...) from MacKermit's @b(File) menu.  M File transfers can be canceled by clicking on the Cancel File or Cancel Group N buttons.  These will always work when sending.  When receiving, they will workM if the opposite Kermit honors this (optional) feature of the protocol.  There N is also an "emergency exit" from any protocol operation, which can be taken atJ any time by typing "Command-@q(.)" -- that is, hold down the Command (Fan,  Cloverleaf) key and type period.  L The progress of file transfer operations can be logged into a Macintosh fileF called a "transaction log".  This log will show the names of the filesK transferred, the date and time, and the completion status.  This feature is M useful with long unattended transfers -- you can come back later and read the I transaction log to find out what happened.  The transaction log is called 
 "Kermit Log".   M The current version of Mac Kermit can only send one fork of a file at a time. G When a file has two forks, there is no provision for sending both forks N together.  This restriction may be lifted in future releases of MacKermit, forN example by converting applications to MacBinary@index<MacBinary> format during
 transmission.    @subsection(Sending Files)N To send files, first put the remote Kermit in server mode, or else give it theH RECEIVE command.  Then use the mouse to select @b(Send file...) from theL @b(File) menu.  This will give you a MacKermit file-open box, which includesK the standard Macintosh dialog items -- a file list, Disk and Eject buttons, L etc.  You can either send one file at a time, by clicking on its name in theI file list, or send the entire contents of the current HFS folder (for HFS N disks only, of course).  Clicking the Disk button will switch the file list toN another physical disk.  If desired, you can type an alternate name to send theM file under.  When you select a file, MacKermit examines its type; if the type I is APPL, then MacKermit expects to send the resource fork in binary mode, K otherwise the data fork in text mode.  The Mode and Fork radio buttons will K display these choices; you may change them before clicking the Send button.    @subsection(Receiving Files)G You can receive or get multiple files, providing the opposite Kermit is I capable of sending multiple files in a single transaction (most are).  To J receive files, first give the remote Kermit a SEND command and then selectH @b(Receive file...) from the @b(File) menu.  To get files from a server,N first put the remote Kermit into server mode, then select the @b(Get file fromN server...) option from the @b(File menu), and type in the name of the file youG want to get, or a wildcard designator for multiple files, in the remote  system's filename syntax.   L As each file arrives at the Mac, it will be decoded according to the currentN mode (text or binary), and stored in the default fork (data or resource).  TheF file names will be either the names the files arrive with (overwritingJ existing files of the same names) or new unique names (when name conflictsK occur), according to the current default for name collisions.  You may also K elect to perform an "attended" receive, in which you have an opportunity to G override file defaults on a per-file basis (do this in the @b(Protocol) L section of the @b(Settings) menu).  But attended operation must be used withH caution -- if you take too long (more than about a minute) to execute anL incoming file's dialog box, the opposite Kermit could time out and terminateM the transaction.  If this happens, tell the opposite Kermit to send again and " try again with the receive dialog.  M The folder for new files is the same as the location of the settings file, or N if no settings file was used then the new files appear on the desktop.  If youH are transferring a lot of files and want to keep them together, create aN folder, drag the settings file into it, and double click on the settings file;- all created files will appear in that folder.    @section(Remote Commands)   J When connected to a Kermit server, MacKermit is capable of issuing specialM file management and other commands to it.  The @b(Remote) menu contains these K commands.  You may request directory listings, you can delete files, change L directories, etc, on server's machine.  The response from these commands (ifK any) is displayed in a special pop-up window.  Responses to multiple Remote N commands are separated by a dashed line.  The response window can be scrolled,K sized, and positioned, and can be hidden by clicking the menu item "@b(Hide K Response)" or the window's go-away box; all text remains intact and will be L appended to the next time you do a Remote command; it can also be brought toM the foreground by clicking the @b(Show Response) menu item.  Note that typein L to the terminal emulator will not take effect when the response window -- orJ any other window (such as a desk accessory) -- is up front.  This is not a> bug, but a feature of the Macintosh user interface guidelines.  F If the response buffer gets too full (greater than 30,000 characters),O MacKermit will remove enough text from the beginning of the buffer, in 512 byte 5 chunks, to make it less than 30,000 characters again.   N A Remote command can be canceled by taking the Emergency Exit (Command-@q<.>).M To disengage from the remote Kermit server, click on @b(Bye) or @b(Finish) in  the @b(Remote) menu.   @section(Server Operation)  M MacKermit may itself act as a Kermit server.  Just set the desired parameters I in the @b(Settings) menu, then click on @b(Be a Server) in the @b(Remote) G menu.  The MacKermit server can respond to SEND, GET, REMOTE DIRECTORY, E FINISH, and BYE commands.  You can send single or multiple files to a N MacKermit server, and you can get a single file from it by name.  You can alsoM get all the files in the current folder by using a colon (@qq<:>) as the file ! specification in the GET command:  @example<GET :> K If you give the FINISH command, MacKermit will return to terminal mode.  If ; you give the BYE command, the Macintosh will reboot itself.   M You can take MacKermit out of server mode from the Mac keyboard by typing the % emergency exit sequence, Command-dot.    @section(Settings) @label<-macset>   M You can change File, Communications, Protocol, Terminal, Keyboard macros, and O Keyboard modifier settings by using the @b(Settings) pull-@|down menu.  You can I save and load these settings by invoking the appropriate selection in the M @b(File) menu.  If the "bundle bit" has been correctly set on your version of O MacKermit (it should be), then you can double-@|click on the resulting document ' to start MacKermit with those settings.   ? The @b(File) settings establish the defaults for file transfer:  @Begin(Itemize) @ @u<Attended> versus @u<Unattended> operation for incoming files.  F @u<Naming>: When doing @u(unattended) file reception, whether incoming@ files should supersede existing files of the same name, or a newD unique name should be assigned to them.  If the latter, the new nameF is formed by adding a dot and a number to the end.  For instance, if aD file called FOO exists and a file called FOO arrives, MacKermit willC store the arriving file as FOO.1; if FOO.1 exists, then FOO.2, etc.   G @u<Mode>: text or binary.  Used for received files only.  When sending, D MacKermit tries to figure out an appropriate mode for the file being: sent (but then lets you override it the Send File dialog).  L @u<Fork>: which fork -- data or resource -- to send, or to store an incoming
 file into.
 @End(Itemize)   H The @b<Communications> settings allow you to set the baud rate (anywhereM between 300 baud and 57@q<.>6K baud, except 38@q<.>4K baud), and parity (odd, N even, mark, space, or none).  When the parity is set to @u(none) the MacintoshL uses an 8-bit-wide connection.  All other parity settings tell the MacintoshN to use a 7-bit-wide connection, and to request 8th-bit prefixing@index<8th-bitC Prefixing> when transferring 8-bit data.  If the remote host or the N communication path uses any kind of parity, then you won't be able to transferH files successfully unless you tell MacKermit (and in most cases also theJ Kermit on the other end) about it.  Duplex is selected in the @b(Terminal)	 settings.   N The @b<Protocol> settings allow you to set packet parameters for both incomingK and outbound packets.  These include the block check type (1 or 2 character B checksum, 3-character 16-bit CRC-CCITT), line turnaround handshakeH character (for file transfer with half duplex systems), packet start andL end characters, padding, packet length, timeout interval, and packet length.I Characters are specified by entering their ASCII value in decimal, e.g. 1 D for Control-A, 13 for Control-M (Carriage Return), etc.  The RECEIVEH parameters are conveyed by MacKermit to the other Kermit.  For instance,J if you set the receive-packet-length to 500, MacKermit will tell the otherF Kermit to send 500-character packets.  The SEND parameters are used to4 override negotiated values, and need rarely be used.   @index<Long Packets>K Long packets are selected by setting the RECEIVING packet length between 95 E and 1000.  Normally, you should not change the sending length because G MacKermit, and most other Kermits, will configure themselves correctly. J Note also that the fastest file transfers will happen with long packets inK the range of 300-500.  Very long packets actually end up being much slower, K because the operating systems in both the Mac and the other machine have to H do more work to cope with such long inputs, and, under noisy conditions,K the probability is higher that a longer packet will be struck by noise, and  will take longer to retransmit.   I The @b<Terminal> settings let you modify the characteristics of the VT102 N emulator, such as auto-linefeed, autowrap, autorepeat keys, block vs underlineN cursor, blinking vs steady cursor, inverted screen (reverse video), and smoothJ scrolling.  There is also a "visible bell@index<Bell>" for those who can'tL hear the audible bell produced upon receipt of a Control-G, and an option toL display control characters visibly by showing their numeric ASCII values (inD decimal) in a single character cell.  If local echo is needed, as in: half-duplex connections, that must be specified here also.   @Section(Settings Files) @label<-macsfile>   6 @index(Settings Files)@index(MacKermit Settings Files)N  You can start MacKermit with all its "factory settings" by double clicking onK the MacKermit icon.  Factory settings are designed for direct communication K with most other microcomputers, DEC minis and mainframes, etc: 9600 bps, no F parity, XON/XOFF, remote echo, etc.  You can change the communication,L protocol, file, keyboard, and terminal settings by going through the optionsK in the @b(Settings) menu.  Once you have set all parameters as desired, you J can save your settings in a "MacKermit settings file" by selected "@b(SaveG Settings...)" from the @b(File) menu.  A settings file is, in Macintosh J terminology, a "MacKermit document".  You'll recognize it because it looksN like a dog-eared piece of paper with the MacKermit icon superimposed.  You can! have more than one settings file.   N There are two ways to use a settings file.  First, you can double-click on it,K just as you can double-click on a MacWrite document to start up MacWrite to K edit a particular file.  This method starts up MacKermit with all the saved L settings.  The other method is to click on the "@b(Load Settings...)" optionJ in the @b(File) menu from inside MacKermit.  This lets you change settingsL without leaving and restarting the program.  @b(Load Settings...)  shows allK MacKermit settings files in the selected folder.  Opening one of them loads 0 all its settings, removing all current settings.  I You can "edit" a MacKermit settings file by loading it, going through the H @q(Settings) menu, and then saving the settings either in a new file, or overwriting the same file.  M As distributed by Columbia, Mac Kermit comes with two settings files.  One is N called "Normal Settings", and is pretty much identical to Mac Kermit's factoryK settings.  The other is "IBM Mainframe Linemode Settings".  It selects mark G parity, local echo, XON half-duplex line turnaround handshake.  You can M use these files as-is, customize them for your own environment, or create new C settings files for all the different kinds of systems that you use.   $ @Section<Reconfiguring the Keyboard>   @index(Key Redefinition)J Beginning with version 0.9, MacKermit has keyboard configuration functionsK built in.  These are accessed through the @b[Set Key Macros] and the @b[Set , Modifiers] entries in the @b[Settings] menu.  D The Macintosh keyboard is composed of normal keys and modifier keys.H Modifier keys are those keys that, when held down, change the meaning ofJ other keys.  On the Mac these are: SHIFT, CAPS LOCK, OPTION, CONTROL (onlyI on the Mac II and SE), and COMMAND (also known as APPLE, CLOVER, or FAN). H Normal keys are the letters, numbers, special symbols, arrow keys, spaceH bar, and function keys.  Only one normal key can be typed at a time, but< one or more modifier keys can be pressed down along with it.  ? When you type a key, Kermit reads both the ASCII value, and the N keyboard-independent scan code for that key.  Kermit looks in its table of keyL macros to see if there is a macro for this combination of key and modifiers,J and if so sends the macro.  If there is no macro, Kermit then looks in itsF modifier table to see if any of the modifiers do special things to theL character; if so, it does these to the character.  Finally, Kermit sends theM character.  In the normal case when there is no macro and no modifiers apply, @ the character sent is simply the ASCII value for that character.  M It is important to keep in mind that if the parity setting is something other M than @u[none], the high (8th) bit will be stripped off of the characters when M they are transmitted.  Since most systems do not understand characters in the E range 128 -- 255 (decimal), you should avoid using the Apple extended E characters (accented vowels, for example) during terminal connection.     @SubSection<Defining Key Macros>  L To define a new key macro, select the @b[Key Macros] entry.  A dialog windowL will appear, asking you to press the key to define.  Type the key (includingM any of the modifiers).  A new dialog will appear, with an editable text field L in it.  Enter the definition for the key here.  Your definition may be up toM 255 characters long, and can include all of the control characters (including K NUL).  Special characters can be included in the macro by entering a @qq<\> N (backslash), followed by up to 3 @i<octal> (base 8) digits for the value (justI like in the C programming language).  For example, an ASCII NUL (value 0) J would be written as @qq<\000>, carriage return (ASCII 13) would be writtenK @qq<\015> (1 x 8 + 5 = 13).  Also, control characters may be entered with a G backslash, followed by a caret (or circumflex, @qq<^>), followed by the E corresponding letter.  Thus a Control-G (value 7) could be entered as F @qq<\007>, @qq<\^G>, or @qq<\^g>.  To include a literal backslash in a) definition, type in two of them: @qq<\\>.   
 @index<BREAK> J BREAK conditions are also programmable as macros.  If the entire macro theI string is @qq<\break>, then typing the defined key will send a short (1/4 J second) break.  A long (3.5 second) BREAK is defined with @qq<\longbreak>.N Note that a macro can define either a BREAK, or a string of normal characters,
 but not both.   # @SubSection<Defining Key Modifiers>   K Skip ahead to the next section if you already know about things like SHIFT,  CAPS LOCK, CONTROL, and META.   K On a typewriter the only modifier key is SHIFT.  Typing a character with no M modifier key depressed selects a lowercase letter or the character printed on K the lower face of the keytop (say, the digit "4").  Typing a character with K SHIFT depressed selects an uppercase letter or the character printed on the J upper face of the keytop (say, a dollar sign).  Some keyboards also have aL SHIFT LOCK key, which stays down once pressed and pops up the next time it'sO pressed; its operation is equivalent to holding down SHIFT.  And some keyboards K have a CAPS LOCK key which operates like SHIFT LOCK, but only upon letters.   J Computer terminals also have a modifier key called CONTROL (or CTRL).  ItsJ function is a little less obvious: it is intended to produce one of the 33A characters in the "control range" of the ASCII alphabet.  Control K characters are not graphic -- they are intended for use as format effectors K (like carriage return, formfeed, tab, backspace), for transmission control, G or for device control.  The remaining 95 characters -- letters, digits, J punctuation, and space -- are the graphic characters.  When a character isM typed with the CONTROL modifier pressed, its "control equivalent" (if any) is K transmitted.  By convention, the control equivalent of A is Control-A, B is C Control-B, etc, and there are also seven special control characters J generally associated with punctuation characters or special keys.  For theJ "alphabetic" control characters Control-A through Control-Z, SHIFT or CAPSJ LOCK modifiers are ignored; for the others, operation varies from terminal to terminal.  I The SHIFT and CONTROL modifiers allow all 128 ASCII characters to be sent H from a normal typewriter-like keyboard that has about 50 keys.  However,K certain host-resident computer applications -- notably the full screen text K editor EMACS and its descendents -- can be used to greater advantage with a J 256 character 8-bit alphabet (EMACS responds to single-character commands,K and the more characters a terminal can send, the more commands are directly  available).    @index<META Key>L For this purpose, some terminals also provide a META modifier key.  This keyM simply causes the high-order ("8th") bit of the selected 7-bit ASCII value to I be set to 1 upon transmission.  This can only work when the connection is K 8-data-bits-@|no-parity.  When parity is in use, EMACS allows a sequence of E two 7-bit ASCII characters to represent a single meta character.  The N advantage of having a real META modifier key is that it can be held down whileK the actual key is struck repeatedly or even autorepeats, whereas a use of a I "meta prefix" such as <escape> requires much more typing.  To illustrate, M suppose META-F is the command to go forward one word.  If you want to execute K this operation repeatedly, just hold down META and F and let it autorepeat. 5 If you don't have a META key, then you'd have to type ( <escape>F@|<escape>F@|<escape>F..., etc.  K A common problem faced by computer users who switch from one terminal or PC D to another is the placement of the modifiers and other special keys.E DEC, IBM, Apple, and other manufacturers consistently move these keys H around on new models of their keyboards.  MacKermit allows you to assignI any of various functions to any of the Mac's modifier keys, and to assign H any desired character or character sequence to the regular keys, so thatD you can tailor the layout of your Mac's keyboard to suit your taste.   @subsection<Modifiers Dialog>   F To change the action of any of the modifier keys, select @b[Modifiers]D from the @b[Settings] menu.  A dialog will appear that looks roughly< like the one in Figure @ref<-macmkey> (the @qq(%) represents the Apple or Clover key).    @Begin(Figure) @bar() @blankspace(1) @begin(example,group) +      Modifier Pattern:  -->   Modification:   D   Ctrl Opt Lock Shift  %      Unmodify Caps Ctrl Meta Prefix string:C                                                        ____________ D   [X]  [ ] [ ]  [ ]   [ ]   |   [ ]    [ ]  [X]  [ ]  [____________]D   [ ]  [ ] [ ]  [ ]   [X]   |   [ ]    [ ]  [X]  [ ]  [____________]I   [ ]  [X] [ ]  [ ]   [ ]   |   [x]    [ ]  [ ]  [ ]  [@ux<\033        >] D   [ ]  [ ] [ ]  [ ]   [ ]   |   [ ]    [ ]  [ ]  [ ]  [____________]  *                 (Cancel)   (Help)   ( OK )
 @end(example) ' @caption(MacKermit Key Modifier Dialog)  @tag<-macmkey> @bar() @End(Figure)  J The check boxes are divided into rows, each one describing a modification.K The left half of each row describes the modifier combination to look for; a J checked box means that this key is down, and an unchecked box means "don'tK care".  Note that there is no way to specify a key being up, and lines with G nothing checked on the left side will be ignored; the character will be % modified in the normal Macintosh way.   H The right half describes what modification to do to the characters.  TheO Unmodify modification says "make this the character that would be sent from the L same key with no modifer keys pressed".  In other words, un-Option, un-Caps,N un-Control, and un-Shift this character.  The Caps modification translates allN letters to upper case, Ctrl makes the letter a contol character, Meta sets theN high (8th) bit on the character, and if a Prefix string is present, it is sent before the character is.   @i<Hints about modifiers:> @begin<itemize> N Beware of the Option key.  It changes the value of any characters you use withK it.  If you type Option-F, the Mac will send a D, if you type Option-B, the N Mac will send a @qq(:), etc.  If you want to use the option key as a modifier,$ be sure to check the "Unmodify" box.  H To use MacKermit with a version of EMACS that does not accept 8-bit MetaM characters, define a key, like Option, to be unmodified, with a prefix string K of @q(\033) (ASCII Escape), as in Figure @ref<-macmkey>.  Then you can hold K down Option and type F (or any other key) repeatedly, or let it autorepeat, 9 and MacKermit will send the correct prefix-Meta sequence.   I When interpreting a keystoke, MacKermit checks the list of modifiers from K top to bottom, applying the first one that matches.  This means that if you H want a different modifier for Command-Option and just plain Command, you= must put the definition for Command-Option first in the list. 
 @end<itemize>    @section<Bootstrapping>  @index<Bootstrapping MacKermit> N This section applies if you do not have a MacKermit diskette, but MacKermit is3 available for downloading from some other computer.   D MacKermit is distributed in source form for building on a Macintosh,> running Apple's Macintosh Programmers Workbench (in MPW C), inG @index<Binhex> @q(.HQX) "BinHex 4" form, and sometimes also as a binary J resource file.  Those who want to work from the source are referred to the% file @q(CKMKER.BLD) for instructions.   G If you're downloading, it's best to work with @q<CKMKER.HQX>, a textual I encoding of the MacKermit application.  Download this using any technique L available to you -- an old release of Kermit, an Xmodem implementation, evenM raw screen capture.  Then run @index<BinHex> BinHex (version 4) to convert it N into a working application (select @b(Upload -> Application) from the @b(File)@ menu).  Eveything will be set up correctly -- icons, forks, etc.  L If you don't have the @q<.HQX> file available, but you do have access to theH binary resource file (its name will be @q(CKMKER.RSRC), @q(ckmker.rsrc),G @q(CKMKER.RSR), @q(ckmker.rsr), @q(%ckmker) or some variation on these, N depending on what system it's stored on and how it got there), AND if you haveG "MacPut" on your system and MacTerminal on your Mac, AND if you have an K 8-bit-wide (no parity) data path between your Mac and your system, then you E can use MacPut to download the binary resource file to your Mac using M MacTerminal's "MacBinary" format (a variant of XMODEM).  After doing this you M must use a program such as @index<Setfile> SetFile or @index<ResEdit> ResEdit N on the Mac to set the author to KR09, the type to APPL, and turn on the bundleI bit.  Do not bother with the CKMKEY program, as it is not used with newer K MacKermits.  If you have an earlier release of MacKermit, you may use it in   place of MacTerminal and MacPut.  2 @section(Differences Between Versions 0.8 and 0.9)  G MacKermit 0.8(34) runs on the 128K Mac, the 512K Mac, and the Mac Plus, M but not on the Macintosh II or SE.  MacKermit 0.9(40) runs on all Macs except J the 128K original.  You should use version 0.9 unless you have a 128K Mac.  K The second major difference is that the program is has been translated into K Apple MPW C, so that it can be edited, compiled, and built on the Macintosh C itself.  This was done originally by Jim Noble of Planning Research I Corporation, who converted MacKermit from SUMACC C (which had to be cross L compiled on a UNIX system) to Megamax C.  Jim's version was converted to MPWI C by Matthias Aebi, who also added most of the new features listed below. K Paul Placeway integrated the program with the current (long packet) version . of C-Kermit and added additional new features.  O Besides these important differences, there were many other changes from version  0.8 to version 0.9, including: @begin<itemize,spread 0.2>9 The Cursor with open desk accessories now works correctly    Long packet support    New program icon  % New settings files are no longer TEXT   E Settings can now be written back to an already existing settings file   < Key redefinition function built in to Kermit, no more CKMKEY  % Server mode directory listing feature    Multifile (folder) send    Server "Delete" file command   Server "Space" command  = Get whole folder content from the server with filename @qq<:>   . Recognition of all the different Mac keyboards  ) Support of menu command keys (key macros)   > Terminal settings dialog separated from communication settings   Non-transparent terminal mode   D Display of statistics and protocol version to "About Kermit" dialog.   Parity problems fixed    Session logging    Transaction logging    Multifinder support   7 Additions to the VT102 emulator (smooth scrolling, etc)   # Rearrangement of menus and displays   ? Program no longer hangs if remote response window gets too full   / Program now works correctly on 64K ROM machines    A new manual
 @end<itemize> E This manual applies in large part to version 0.8(34), except that the K older version is missing the new features listed above, and it comes in two E pieces: CKMKER and CKMKEY.  The CKMKEY program is used to program the G keys, like the @b(Set Key Macros...) and @b(Set Modifiers) described in K this manual, and creates a settings file which Kermit itself uses.  The old 7 version only works well with early Macintosh keyboards. 