3 /* $Id: ckmpri.c,v 1.5 91/12/15 23:17:46 rick Exp $ *  * $Source: /uw/mackermit/RCS/ckmpri.c,v $D  *------------------------------------------------------------------  * $Log:	ckmpri.c,v $ )  * Revision 1.5  91/12/15  23:17:46  rick   * ut9  *  )  * Revision 1.4  91/10/13  13:44:33  rick   * UT(7)  *  )  * Revision 1.3  91/10/03  12:43:06  rick   * UT(5)  *  D  *------------------------------------------------------------------  * $Endlog$   */    /*  * file ckmpri.c  *L  * Module of mackermit containing code for handling printing.  This code was?  * originally put into ckmusr by John A. Oberschelp of Emory U.   *  */    /*N   Copyright (C) 1985, 1992, Trustees of Columbia University in the City of NewK   York.  Permission is granted to any individual or institution to use this O   software as long as it is not sold for profit.  This copyright notice must be M   retained.  This software may not be included in commercial products without ,   written permission of Columbia University. */   #include "ckcdeb.h"  #include "ckcker.h"   + #include "ckmdef.h"		/* General Mac defs */ / #include "ckmres.h"		/* Mac resource equates */ . #include "ckmasm.h"		/* new A8 and A9 traps */$ #include "ckmcon.h"		/* for fonts */* #include "ckmptp.h"		/* ckm* Prototypes */6 #include "ckmwin.h"		/* text edit window structures */   int		to_printer = FALSE; int		to_screen = TRUE; int		printer_is_on_line_num; #ifdef COMMENT Handle	hPrintBuffer = 0L;  long	lPrintBufferSize; long	lPrintBufferChars = 0L; long	lPrintBufferAt; #endif /* COMMENT */  ! Boolean printer_is_setup = false;  THPrint	PrintStuff = NULL;  4 extern	MenuHandle menus[];	/* handle on our menus */  8 extern struct cmdw *prntw;		/* local "printer" window */   DialogPtr	printingDialog;  DialogPtr	bufferingDialog; DialogPtr	overflowingDialog; DialogPtr	overflowedDialog;  DialogPtr	pauseDialog;  " #define MIN(a,b) ((a)<(b))?(a):(b)" #define MAX(a,b) ((a)>(b))?(a):(b)  N /****************************************************************************/P /*  add_to_print  --  Add string of length len to "printer" text edit record  */& /*		      Made from conxo();				    */N /****************************************************************************/ void add_to_print (int len, char *s)  {  #ifdef COMMENT         register char *t;   '     /* change NLs to CRs for the Mac */ )     for (t = s; *t && (t - s < len); t++)      	if (*t == LF)
 	    *t = CR;  #endif  6     /* debug (F101, "add_to_print here: ", s, len); */+     if ((prntw->teh == NULL) || (len <= 0))  	return;       TEDeactivate(prntw->teh);      if (trimcon(prntw, len)) {=     	/* put up a dialog saying that things are overflowing */      } A     TEInsert (s, (long) len, prntw->teh);	/* insert the string */ ,     TESetSelect(TE_MAX, TE_MAX, prntw->teh);     TEActivate(prntw->teh); 1     rcdwscroll (prntw);		/* possibly scroll it */ 5     updatepstat();		/* possibly enable print menus */  }				/* add_to_print */    /*-  * Update the capturing printer output dialog   */  void
 upd_ptr_dlg()  { )     if (to_printer && !bufferingDialog) { G 	bufferingDialog = GetNewDialog(BUFFERINGBOXID, NILPTR, (WindowPtr)-1);  	DrawDialog(bufferingDialog); 0     } else if (!to_printer && bufferingDialog) { 	DisposDialog(bufferingDialog);  	bufferingDialog = NULL; 	if (overflowingDialog) { % 	    DisposDialog(overflowingDialog);  	    overflowingDialog = NULL; 	}     }  }    /*)  * Print the internal text capture buffer   */  void now_print()  {      long length;     CharsHandle h;     /* CursHandle watchcurs; */    #ifdef COMMENT     short itemhit;- 	if (lPrintBufferChars >= lPrintBufferSize) { : 		overflowedDialog = GetNewDialog(OVERFLOWEDBOXID, NILPTR, 						(WindowPtr) - 1);  		circleOK(overflowedDialog);   7 		ModalDialog ((ModalFilterProcPtr) NILPROC, &itemhit); ! 		DisposDialog(overflowedDialog); # 		if (itemhit == 2)	/* if Cancel */ 
 		    return;  		if (itemhit == 3) {  			DisposHandle(hPrintBuffer); 			hPrintBuffer = 0L;  			lPrintBufferChars = 0L; 			updatepstat(); 
 			return; 		}  	} #endif /* COMMENT */   #ifdef COMMENTD 	if (lPrintBufferChars > lPrintBufferSize) {	/* if buffer wrapped */ 		length = lPrintBufferSize; 		index = lPrintBufferAt; 	 	} else {  		length = lPrintBufferChars; 
 		index = 0L;  	}8 	printer(hPrintBuffer, length, index, lPrintBufferSize);   	DisposHandle(hPrintBuffer); 	hPrintBuffer = 0L;  	lPrintBufferChars = 0L; #endif /* COMMENT */       if (!prntw) { &     	printerr("prntw is NULL!!!!", 0);     	return;     }      %     length = (*prntw->teh)->teLength;      h = TEGetText(prntw->teh);  1     printer((Handle) h, length, 0L, 0x7FFFFFFFL);        updatepstat(); }    /*  * printer_init   * initialize the printer stuff   */  int  printer_init() {      Boolean brc;     4     PrintStuff = (THPrint)NewHandle(sizeof(TPrint));
     PrOpen();      if (PrError() != noErr) { # 	DisposHandle((Handle) PrintStuff);  	PrintStuff = NULL; ' 	printerr("Could not open printer", 0); 
 	return 0;     } P     brc = PrValidate(PrintStuff);	/* load reasonable defaults into PrintStuff */
     return 1;  }    /*5  * Release any resources used by the printing system.   */  void printer_close()  {      if (!PrintStuff) 	return;  B     PrClose();		/* close the printer file and release resources */&     DisposHandle((Handle) PrintStuff);     PrintStuff = NULL; }    /*  * dopagesetup  * Call the page setup dialog   */  void
 dopagesetup()  {      if (!PrintStuff) 	if (!printer_init())  	    return;     /     printer_is_setup = PrStlDialog(PrintStuff);  }    /*
  * printer  * h - handle to text to print%  * length - number of chars in buffer #  * index - starting index in buffer '  * limit - buffer limit (to wrap index)   */  void7 printer (Handle h, long length, long index, long limit)  {      char	PrintBufferChar;      CursHandle	watchcurs;      int		typeOfDriver;     int		chrExtra;     int		leftMargin;     GrafPtr	oldPort;     int		temp;     TPPrPort	myPrPort;     TPrStatus	myStRec;  C     if (!PrintStuff)		/* make sure we have enabled printer stuff */  	if (!printer_init())  	    return;  L     if (!printer_is_setup)	/* give the user a chance to set page settings */ 	dopagesetup();        GetPort(&oldPort);  =     temp = PrJobDialog(PrintStuff);	/* do print job dialog */      if (!temp) { 	PrClose();  	SetPort(oldPort); 	return;     } J     printingDialog = GetNewDialog(PRINTINGBOXID, NILPTR, (WindowPtr) - 1);      DrawDialog (printingDialog);'     watchcurs = GetCursor(watchCursor);      SetCursor(*watchcurs);  /     myPrPort = PrOpenDoc(PrintStuff, nil, nil); 4     typeOfDriver = ((*PrintStuff)->prStl.wDev) >> 8;7     if (typeOfDriver == 3) {		 /* PostScript (laser) */  	TextFont(courier);  	TextSize(10); 	chrExtra = 0; 	leftMargin = 36;      } else { 	TextFont(VT100FONT); 
 	TextSize(9);  	chrExtra = 1; 	leftMargin = 36;      }        printer_is_on_line_num = 1;      PrOpenPage(myPrPort, nil);     MoveTo(leftMargin, 1 * 12);        do { 	if (PrError() != noErr)   	    break;  	PrintBufferChar = (*h)[index];  	switch (PrintBufferChar) {  	  case 015:		/* CR */) 	    if (++printer_is_on_line_num > 60) {  		PrClosePage(myPrPort); 		PrOpenPage(myPrPort, nil); 		printer_is_on_line_num = 1;  	    }5 	    MoveTo(leftMargin, printer_is_on_line_num * 12);  	    break;    	  case 014:		/* FF */' 	    if (printer_is_on_line_num != 1) {          	PrClosePage(myPrPort); #         	PrOpenPage(myPrPort, nil); $         	printer_is_on_line_num = 1; 	    }5 	    MoveTo(leftMargin, printer_is_on_line_num * 12);  	    break;    	  default:  	    DrawChar(PrintBufferChar);  	    Move(chrExtra, 0);  	    break;  	}  6 	if (++index == limit)    /* if time to wrap buffer */ 	    index = 0L;       } while (--length);      PrClosePage(myPrPort);       PrCloseDoc(myPrPort);      if ((PrError() == noErr) && 0 	((**PrintStuff).prJob.bJDocLoop == bSpoolLoop))0 	PrPicFile(PrintStuff, nil, nil, nil, &myStRec);5     if ((PrError() != noErr) && (PrError() != 128)) { ) 	printerr ("Printer error: ", PrError());      }   !     DisposDialog(printingDialog);        SetPort(oldPort);      InitCursor();  }      void	 pr_stat()  {      DialogPtr	printDialog;     Str255	arg1, arg2, arg3;     long	length;     short	itemhit;    D     printDialog = GetNewDialog(PRINTBOXID, NILPTR, (WindowPtr) - 1);     circleOK(printDialog);   #ifdef COMMENTE     NumToString(MAX(lPrintBufferChars - lPrintBufferSize, 0L), arg1); @     NumToString(MIN(lPrintBufferSize, lPrintBufferChars), arg2);(     NumToString(lPrintBufferSize, arg3);%     ParamText (arg1, arg2, arg3, "");  #endif%     length = (*prntw->teh)->teLength;   K     /* NumToString(MAX(lPrintBufferChars - lPrintBufferSize, 0L), arg1); */      arg1[0] = 1;&     arg1[1] = '?';				/* chars lost */5     NumToString(length, arg2);			/* chars buffered */ 4     NumToString(TE_TOOBIG, arg3);		/* buffer size */%     ParamText (arg1, arg2, arg3, "");        do {6 	ModalDialog ((ModalFilterProcPtr) NILPROC, &itemhit);   	switch (itemhit) { 
 	  case 1:
 	  case 2:
 	  case 3:	 	  break;    	}     } while (itemhit > 3);       DisposDialog(printDialog); }      /*H  * Junk so Emacs will set local variables to be compatible with Mac/MPW.  * Should be at end of file.  *    * Local Variables:   * tab-width: 8   * End:   */ 