 /*  * File ckmscr.c  *$  * Mac Kermit file transfer display.  *&  * Original by: Bill Schilit, May 1984&  * Modified by many others since then.  */  /*N   Copyright (C) 1984, 1994, Trustees of Columbia University in the City of NewK   York.  The C-Kermit software may not be, in whole or in part, licensed or L   sold for profit as a software product itself, nor may it be included in orM   distributed with commercial products or otherwise distributed by commercial J   concerns to their clients or customers without written permission of theK   Office of Kermit Development and Distribution, Columbia University.  This =   copyright notice must not be removed, altered, or obscured.  */ #include "ckcdeb.h"  #include "ckcker.h"   + #include "ckmdef.h"		/* General Mac defs */ 3 #include "ckmres.h"						/* Mac resource equates */ . #include "ckmptp.h"						/* ckm* Prototypes */  1 int scrpkt, scrnak;						/* NAK, packet counts */ ' long scrck;								/* char (K) count */ O int scrpacln, scrcksum, scrwslots, scrbufnum; /* pkt len, checksum, win size */  long scrfsize, scrffc;: DialogPtr scrdlg = (DialogPtr) NULL;	/* screen's dialog */   extern char filnam[];  extern int what, binary;   void update_scr_therm();G static pascal void draw_screen_xfr_therm (WindowPtr win, short itemno);  static char cwdbuf[81];   N /****************************************************************************/A /* scrcreate - create the status display.  Called when a protocol E  *    	       menu item is selected and a display is desired (I don't ?  *    	       think you'd want to see this for REMOTE command).   *  */ N /****************************************************************************/
 scrcreate() {      Rect itemr;      short itype;     Handle itemhdl;        if (scrdlg != NULL) / 	printerr ("scrcreate with active screen!", 0);   =     scrdlg = GetNewDialog (SCRBOXID, NILPTR, (WindowPtr) -1);      scrck = -1;      scrnak = scrpkt = 0;     scrpacln = scrcksum = 0;     scrwslots = scrbufnum = -1;      scrfsize = scrffc = 0;     ffc = 0;          SetStrText (SRES_PTTXT, : 				"\pEmergency exit: hold down \021 and type a period.",* 				scrdlg);				/* yes, so set the text */  ' 	SetStrText (SRES_BTEXT, "\p", scrdlg); & 	strcpy(cwdbuf,"Current Directory: "); 	strncat(cwdbuf,zgtdir(),60);  	c2pstr(cwdbuf);) 	SetStrText (SRES_BTEXT, cwdbuf, scrdlg); & 	debug(F101,"scrcreate what","",what);. 	debug(F101,"scrcreate protocmd","",protocmd);  . 	switch (what) {						/* What are we doing? */ 	  case W_SEND: . 		SetStrText (SRES_DIR,"\p   Sending",scrdlg); 		break; 	  case W_REMO:  	  case W_RECV:  		if (protocmd == SERV_REMO)3 		  SetStrText (SRES_DIR,"\p   Server",scrdlg);		    		else/ 		  SetStrText (SRES_DIR,"\pReceiving",scrdlg);  		break; 	  default:  		SetStrText (SRES_DIR, > 					(protocmd == SEND_REMO) ? "\p   Sending" : "\pReceiving",
 					scrdlg);  		break; 	}<     GetDItem (scrdlg, SRES_THERM, &itype, &itemhdl, &itemr);(     SetDItem (scrdlg, SRES_THERM, itype,$ 			  (Handle) draw_screen_xfr_therm,
 			  &itemr);      update_scr_therm();   3     miniparser (TRUE);					/* keep things moving */  } /* scrcreate */     N /****************************************************************************/< /* scrdispose - called to finish up the status display, on a1  *    	      	transaction complete screen() call.   */ N /****************************************************************************/ void scrdispose (Boolean wait) {      EventRecord dummyEvt;        if (scrdlg == NULL) < 	  printerr ("scrdispose called with no screen active!", 0);       SysBeep (3);  *     if (wait) {			/* deactivate buttons */5 		HiliteControl (getctlhdl (SRES_CANF, scrdlg), 255); 5 		HiliteControl (getctlhdl (SRES_CANG, scrdlg), 255);   0 		if (tlevel < 0)	{	/* if no takefile running */ 			SetStrText (SRES_PTTXT,5 						"\pType a key or click the mouse to continue.", * 						scrdlg);		/* yes, so set the text */K 	    /* wait for mouse or key down and discard the event when it happens */   = 			while (!GetNextEvent (keyDownMask + mDownMask, &dummyEvt))  			  /* do nothing */ ;  		}      } else {8 		SetStrText (SRES_PTTXT, "\pNormal cleanup",  scrdlg);     }      DisposDialog (scrdlg);     scrdlg = NULL; } /* scrdispose */   void update_scr_therm() {     GrafPtr savePort;      C     GetPort (&savePort);				/* there just has to be a better way */      SetPort (scrdlg); /     draw_screen_xfr_therm (scrdlg, SRES_THERM);      SetPort (savePort);  }    static pascal void5 draw_screen_xfr_therm (WindowPtr win, short itemno) {  #pragma unused (win)     Rect r, itemr;     short itype;     Handle itemhdl;      PenState oldpenstate;   ;     if (itemno != SRES_THERM)			/* Shouldn't ever happen */ 
 	  return;  ?     GetPenState(&oldpenstate);			/* save so we can fuss with */      PenNormal();     8     GetDItem (scrdlg, itemno, &itype, &itemhdl, &itemr);          /* EraseRect(&itemr); */       if (fsize <= 0L) {  (     	/* Frame the thermometer in gray */ 		PenPat(qd.gray); 		PenSize (2, 2);  		FrameRect(&itemr); 		InsetRect(&itemr, 2, 2); 		EraseRect(&itemr); 	      } else {        	/* Frame the thermometer */ 		PenSize (2, 2);  		FrameRect(&itemr);   		InsetRect(&itemr, 2, 2); 		PenPat (qd.white); 		FrameRect(&itemr); 		InsetRect(&itemr, 2, 2); 	      	/* F 	 * We want to fill first (ffc / fsize) of (itemr.right - itemr.left) ' 	 * with black, and the rest with gray.  	 */ 	  		r.top = itemr.top; 		r.bottom = itemr.bottom; 		r.left = itemr.left; 		r.right = itemr.leftH 		  + (((long) (itemr.right - itemr.left) * (long) ffc) / (long) fsize);1 		if (r.right > itemr.right)		/* reality check */  		  r.right = itemr.right; 	 8 		if (r.left < r.right)			/* has any been transfered? */ 		  FillRect (&r, qd.dkGray);  	 : 		if (r.right < itemr.right) {	/* any left to transfer? */ 			r.left = r.right; 			r.right = itemr.right;  			FillRect (&r, qd.ltGray); 		}      }           scrfsize = fsize;      scrffc = ffc;      <     SetPenState(&oldpenstate);			/* restore old pen state */ }   H /* ststrings - translation of SCR_ST subfunctions to descriptive text */   char *ststrings[] = { $     ": Transferred OK",		/* ST_OK */!     ": Discarded",		/* ST_DISC */ "     ": Interrupted",		/* ST_INT */      ": Skipped ",		/* ST_SKIP */!     ": Fatal error"		/* ST_ERR */  };  F /* scrtosresnum - table to translate from SCR_XXX values into resourceC  *    	       	  item numbers.  Entries we aren't interested in are #  *    	          set to SRES_UNDEF.   */    int scrtoresnum[] = { #     SRES_UNDEF,			/* 0 - nothing */ (     SRES_FILN,			/* SCR_FN - filename */,     SRES_AFILN,			/* SCR_AN - as filename */*     SRES_UNDEF,			/* SCR_FS - file size */.     SRES_UNDEF,			/* SCR_XD - x-packet data */A     SRES_PTEXT,			/* SCR_ST - status (goes in prev. text area) */ .     SRES_UNDEF,			/* SCR_PN - packet number */6     SRES_UNDEF,			/* SCR_PT - packet type (special) */5     SRES_BTEXT,			/* SCR_TC - transaction complete */ 7     SRES_ITEXT,			/* SCR_EM - error msg (does alert) */ 0     SRES_ITEXT,			/* SCR_WM - warning message */)     SRES_BTEXT,			/* SCR_TU - arb text */ )     SRES_BTEXT,			/* SCR_TN - arb text */ )     SRES_BTEXT,			/* SCR_TZ - arb text */ )     SRES_BTEXT,			/* SCR_QE - arb text */ )     SRES_ITEXT			/* SCR_DT - date text */  };  N /****************************************************************************/E /* screen - display status information on the screen during protocol. E  *    	    Here we just set the items in their StatText dialog boxes, B  *    	    updates occur through the miniparser, which we are nice0  *    	    enough to call here to handle things.  */ N /****************************************************************************/4 _PROTOTYP( VOID screen, (int, char, long, char *) );   VOID) screen (int f, char c, long n, char *s) { + /* s is a C string (not a Pascal Str255) */ 
     int rnum;      long i;      char buf[256];(     extern int spktl, rln, bctu, wslots;      static char last_st = ST_OK;J     static char got_err = 0; /* becomes true if we get an error message */  )     if (scrdlg == NULL)		/* not using? */ 
 	  return;  0     miniparser (TRUE);		/* keep the mac going */  :     if (quiet)			/* Silent?  Then just do miniparser(). */
 	  return;   #ifdef COMMENT/     if (f == SCR_EM) {					/* error message? */ & 		printerr (s, 0);				/* display it */  		return;							/* and return */     }  #endif       /*C      * This is a really ugly hack (which *I* didn't create), but... ?      * If we are seeing the name of an incoming file, then call A      * dorecvdialog() to give the user a possible chance (if they B      * have asked for interactive recieve dialogs) to put the file      * somewhere interactively.       *4      * Putting this hook in here is really a kludge.      */ 4     if (f == SCR_FN) {					/* seeing a file name? */( 		SetStrText (SRES_AFILN, "\p", scrdlg);3 		if (what == W_RECV)				/* of an incoming file? */ A 		  dorecvdialog (s, &cmarg2);	/* yes, allow user to do dialog */  	}<     rnum = scrtoresnum[f];				/* load default DITL number */+ 										/* where result will be posted */   4     switch (f) {						/* according to function... */+       case SCR_EM:						/* error message */ -       case SCR_WM:						/* warning message */  		got_err = 1;1 		SysBeep(3);						/* get the user's attention */  		Delay ((long) 10, &i);
 		SysBeep(3);  		Delay ((long) 10, &i);
 		SysBeep(3);  		if (n != 0L) { 			strcpy (buf, s);  			strcat (buf, " ");  			s = &buf[strlen(buf)];  			NumToString(n, s); 
 			p2cstr(s);  			s = buf;  		}  		break;        	  case SCR_FN: , 		got_err = 0;					/* Reset for this file */( 		SetStrText (SRES_ITEXT, "\p", scrdlg); 		break;   	  case SCR_CD: ( 		SetStrText (SRES_BTEXT, "\p", scrdlg);' 		strcpy(cwdbuf,"Current Directory: ");  		strncat(cwdbuf,zgtdir(),60); 		c2pstr(cwdbuf); * 		SetStrText (SRES_BTEXT, cwdbuf, scrdlg); 		break;  $ 	  case SCR_FS:						/* File Size */$ 	  case SCR_AN:						/* "As-Name" */1 		if ((filargs.filflg & (FIL_RSRC | FIL_DATA)) ==  			(FIL_RSRC | FIL_DATA)) {  			/* in MacBinary mode */) 			SetStrText (SRES_FFORK, "\p", scrdlg); 7 			SetStrText (SRES_FMODE, "\pMacBinary Mode", scrdlg); 
 		} else {8 			SetStrText (SRES_FFORK, (filargs.filflg & FIL_RSRC) ?- 						"\pRSRC Fork" : "\pData Fork", scrdlg); 8 			SetStrText (SRES_FMODE, (filargs.filflg & FIL_BINA) ?/ 						"\pBinary Mode" : "\pText Mode", scrdlg);  		}  		break;  ' 	  case SCR_PT:						/* Packet type? */ 3 		if (what == W_SEND) {		    /* sent a packet... */  			i = spktl-bctu;1 			if (i+2 <= MAXPACK) i += 2;	/* short packet */ ' 		} else {						/* received a packet */  			i = rln + bctu;7 			if (rln <= MAXPACK)			/* if it was a short packet */ 6 			  i += 2;					/* then add space for SEQ and TYPE */ 		} % 		if (i != scrpacln) {			/* Length */  			scrpacln = i;- 			SetNumText (SRES_PACSZ, scrpacln, scrdlg);  		}  		/* checksum type */  		if (bctu != scrcksum) {  			scrcksum = bctu; - 			SetNumText (SRES_CKSUM, scrcksum, scrdlg);  		}  	  		/* window size */  		if ((wslots != scrwslots) 2 			|| ((what == W_SEND) && (sbufnum != scrbufnum))5 			|| ((what != W_SEND) && (rbufnum != scrbufnum))) {  			char *cp;   			scrwslots = wslots; 			if (what == W_SEND) 			  scrbufnum = sbufnum;  			else  			  scrbufnum = rbufnum;   C 			NumToString ((wslots - scrbufnum), buf); /* convert to number */  			p2cstr(buf); 3 			strcat (buf, "/");			/* make it be a fraction */ $ 			cp = (char *) buf + strlen (buf); 			NumToString (scrwslots, cp);  			p2cstr(cp);9 			c2pstr(buf);				/* convert whole buf back to string */ : 			SetStrText (SRES_WINSZ, (unsigned char *) buf, scrdlg); 		}  		if (c == 'Y') 1 		  return;						/* don't do anything for yaks */   ; 		if (c == 'N' || c == 'Q' ||		/* check for all types of */ " 			c == 'T' || c == '%')	/* NAK */? 		  i = ++scrnak, rnum = SRES_NRTY; /* increment nak counter */  		elseD 		  i = ++scrpkt, rnum = SRES_NPKT; /* else increment pkt counter */  3 		NumToString (i, buf);			/* translate to number */  		p2cstr(buf);  		s = buf;						/* new buffer */ 		break;							/* all done */   $       case SCR_ST:						/* status */, 		last_st = c;					/* PWP: save for later */ 		if (f == ST_SKIP)  		  strcpy(buf, s); 8 		else /* file name; should be same as filargs.fillcl */ 		  strcpy (buf, filnam); / 		strcat (buf, ststrings[c]);		/* add status */ 
 		s = buf; #ifdef COMMENTD 		SetStrText (SRES_BTEXT, "\p", scrdlg);	/* clear eg. remote size */= 		SetStrText (SRES_ITEXT, "\p", scrdlg);	/* clear eg. date */  #endif 		break;  3       case SCR_TC:						/* transaction completed */ + 		if (!server) {					/* are we a server? */ # 			/* if not, dispose the screen */ . 			scrdispose ((last_st != ST_OK) || got_err);# 			got_err = 0;				/* reset this */ % 			return;						/* and we are done */  		} $ 		s = "Server transaction complete"; 		break;   #ifdef COMMENT,       case SCR_DT:		/* file creation date */1         strcpy (buf, "Creation date: __/__/__ ");  		buf[15] = s[4];  		buf[16] = s[5];  		buf[18] = s[6];  		buf[19] = s[7];  		buf[21] = s[2];  		buf[22] = s[3];  		strcat (buf, &s[8]);
 		s = buf; 		break; #endif /* COMMENT */  -       case SCR_QE:						/* Quantity equals */          strcpy (buf, s); 		strcat (buf, " = "); 		s = &buf[strlen(buf)]; 		NumToString(n, s); 		p2cstr(s);
 		s = buf;8 		scrck = -1;						/* force update of # Ks transfered */ 		break;     }   ?     if (rnum != SRES_UNDEF)				/* have DITL number for this? */ B 	SetStrText (rnum, c2p_tmp(s), scrdlg); /* yes, so set the text */  /     if ((scrfsize != fsize) || (scrffc != ffc))  	  update_scr_therm();  @     if ((i = (ffc + 512) / 1024) != scrck) { /* Size changed? */* 		scrck = i;						/* remember new value */4 		NumToString (scrck, buf);		/* convert to number */ 		p2cstr(buf);+ 		if (fsize != 0) {				/* know the size? */  			char *cp;3 			strcat (buf, "/");			/* make it be a fraction */ $ 			cp = (char *) buf + strlen (buf);* 			NumToString ((fsize + 512) / 1024, cp); 			p2cstr(cp); 		}  		c2pstr(buf);8 		SetStrText (SRES_KXFER, (unsigned char *)buf, scrdlg);     }  } /* screen */  N /****************************************************************************/B /* scrmydlg - handle dialog events occuring in the screen (status)B  *    	      dialog.  Called by the miniparser when a dialog event5  *    	      occurs and we are supposed to handle it.   */ N /****************************************************************************/ scrmydlg (item) int item; {      switch (item) {        case SRES_CANF:  		cxseen = TRUE; 		break;       case SRES_CANG:  		czseen = TRUE; 		break;     }  } /* scrmydlg */   /*H  * Junk so Emacs will set local variables to be compatible with Mac/MPW.  * Should be at end of file.  *    * Local Variables:   * tab-width: 4   * End:   */ 