 /*  * file ckmsfp.c  *>  * Module of MacKermit containing standard file package calls:  *#  *    dosenddialog() - Send file... &  *    dorecvdialog() - Receive file....  *    dogetfdialog() - Get file from server...  */  * Bill Schilit, Columbia University, May, 1984   */    /*N   Copyright (C) 1984, 1994, Trustees of Columbia University in the City of NewK   York.  The C-Kermit software may not be, in whole or in part, licensed or L   sold for profit as a software product itself, nor may it be included in orM   distributed with commercial products or otherwise distributed by commercial J   concerns to their clients or customers without written permission of theK   Office of Kermit Development and Distribution, Columbia University.  This =   copyright notice must not be removed, altered, or obscured.  */  N /* Version 0.8(35) - Jim Noble at Planning Research Corporation, June 1987. */4 /* Ported to Megamax native Macintosh C compiler. */' /* Edit by Bill on Wed May 15, 15:48 */ F /* change name of rtol to sfprtol, make it the common file rtol rtn */H /* either use RSRC & BINA if .RSRC extension, or use current defaults */' /* Edit by Bill on Wed May 15, 15:48 */ 9 /* in initfilerecv make sure kermit flag binary is set */      #include "ckcdeb.h" - #include "ckcker.h"		/* Kermit definitions */   8 #include "ckmdef.h"		/* Common Mac module definitions */( #include "ckmres.h"		/* resource defs */* #include "ckmptp.h"		/* ckm* Prototypes */  ! FILINF filargs;			/* is global */   9 int radflgs[] = {FIL_DATA, FIL_RSRC, FIL_TEXT, FIL_BINA}; < int radnotflgs[] = {FIL_RSRC, FIL_DATA, FIL_BINA, FIL_TEXT};  ! /* Globals used by SEND dialog */   $ SFReply sfr;			/* holds file info */7 Boolean sendselflg;		/* TRUE means file was selected */ 7 Boolean sendasflg;		/* TRUE means AS field is active */   M int sendusercvdef = FALSE;	/* use rec. file mode defaults as send defaults */   N /****************************************************************************/: /* gethdl - return a control handle given a resource ID */N /****************************************************************************/ Handle gethdl (item, dp) 	 int item; 
 DialogPtr dp;  {      short itype;     Rect ibox;     Handle ihdl;  .     GetDItem (dp, item, &itype, &ihdl, &ibox);     return (ihdl); }				/* gethdl */       N /****************************************************************************/: /* setfilflgs - Manage the filflg word and radio controls.  *D  * Flags will be changed when the resource ID of item hit (passed toG  * this routine) is one of the radio items, or alternately routines can D  * modify the filflg word itself and the radio items will be updated  * accordingly.   *D  * N.B. Each dialog using these flags has them defined with the same  * DITL item numbers.   *  */ N /****************************************************************************/ setfilflgs (item, dlg) DialogPtr dlg; {      ControlHandle ctlhdl; 
     int i;       switch(item) {,       case RADITM_MACB:	/* MacBinary mode */ 	filargs.filflg &= ~FIL_TEXT; 2 	filargs.filflg |= FIL_BINA | FIL_RSRC | FIL_DATA; 	binary = XYFT_M;  	break;  	 '       case RADITM_TEXT:	/* Text mode */ G 	if ((filargs.filflg & (FIL_RSRC | FIL_DATA)) == (FIL_RSRC | FIL_DATA))  	  filargs.filflg &= ~FIL_RSRC;  	filargs.filflg &= ~FIL_BINA;  	filargs.filflg |= FIL_TEXT; 	binary = XYFT_T;  	break;  	 )       case RADITM_BINA:	/* Binary mode */ G 	if ((filargs.filflg & (FIL_RSRC | FIL_DATA)) == (FIL_RSRC | FIL_DATA))  	  filargs.filflg &= ~FIL_RSRC;  	filargs.filflg &= ~FIL_TEXT;  	filargs.filflg |= FIL_BINA; 	binary = XYFT_B;  	break;  	 )       case RADITM_DATA:			/* Data fork */  	filargs.filflg &= ~FIL_RSRC;  	filargs.filflg |= FIL_DATA; 	break;  	 -       case RADITM_RSRC:			/* Resource fork */  	filargs.filflg &= ~FIL_DATA;  	filargs.filflg |= FIL_RSRC; 	break;        }      /* if MacBinary mode */ L     if ((filargs.filflg & (FIL_RSRC | FIL_DATA)) == (FIL_RSRC | FIL_DATA)) {2 	SetCtlValue (getctlhdl(RADITM_MACB, dlg), btnOn);3 	SetCtlValue (getctlhdl(RADITM_TEXT, dlg), btnOff); 3 	SetCtlValue (getctlhdl(RADITM_BINA, dlg), btnOff);   2 	SetCtlValue (getctlhdl(RADITM_DATA, dlg), btnOn);2 	SetCtlValue (getctlhdl(RADITM_RSRC, dlg), btnOn);C 	HiliteControl(getctlhdl(RADITM_DATA, dlg), 255);  /* disable it */ C 	HiliteControl(getctlhdl(RADITM_RSRC, dlg), 255);  /* disable it */ %     } else {	/* not MacBinary mode */ 2 	SetCtlValue(getctlhdl(RADITM_MACB, dlg), btnOff);@ 	HiliteControl(getctlhdl(RADITM_DATA, dlg), 0);  /* enable it */@ 	HiliteControl(getctlhdl(RADITM_RSRC, dlg), 0);  /* enable it */A 	for (i = RADITM_FIRST; i <= RADITM_LAST; i++) {	/* update all */ H 	    ctlhdl = getctlhdl (i, dlg);   /* get a handle on his radio item */ 	    SetCtlValue (ctlhdl, 2 			 (filargs.filflg & radflgs[i - RADITM_FIRST]) ? 			 btnOn :  			 btnOff); 	}     }  } /* setfilflgs */  N /****************************************************************************/N /****************************************************************************/  ) setfilnams (remfid, dlg) DialogPtr dlg; {   /     filargs.filrem[0] = 0;	/* no remote file */   9     p2cstr (&sfr.fName);	/* convert filename to C form */ * 				/* copy sfr into local name storage */1     strcpy (filargs.fillcl, (char *) &sfr.fName); :     c2pstr (&sfr.fName);	/* convert back to pascal form */  :     if (remfid != 0) {		/* fetch remote name if present */1 	GetIText (gethdl (remfid, dlg), filargs.filrem);  				/* in an edittext field */ 	p2cstr(filargs.filrem);     }  #ifdef COMMENTE     binary = (filargs.filflg & FIL_BINA);	/* selected binary mode? */  #endif /* COMMENT */ } /* setfilnams */   Boolean isfolder;   N /****************************************************************************/A /* sendmydlg - SFPGetFIle item hit filter for "send file" dialog.   *H  * This filter is called by SFPGetFile to let the programmer handle hitsF  * on his custom items.  Our items are 2 sets of buttons for selectingF  * the fork (data or resource) and the transfer mode (binary or text).<  * Also we have an EditText item for filling in the AS name.  *D  * The buttons are set when the user clicks, but they also are givenF  * values depending on the selection of a file.  If the file's type isE  * "APPL" then controls "Resource" and "Binary" are automaticlly set, G  * otherwise the controls "Data" and "Text" are set.  SF-File keeps the H  * SFReply upto date when a file name is selected, but...  unfortunatelyD  * we are called before the SFReply is updated and so when we notice8  * "getNmList" is hit we defer our update for one cycle.  *F  * Our other item, the TextEdit item to set the "AS" file name, can beH  * enabled or disabled to allow the selection of a file name by typing aB  * character (standard SFGetFile stuff).  By using the global flagG  * sendasflg and an event filter we switch between sending the chars to H  * SF-File for filename selection and to ModalDialog for TextEdit of ourF  * AS name.  Since it would be nice to get rid of that blinking cursorE  * in the TextEdit item our DITL has an invisible EditText item which #  * becomes active for this purpose.   *A  * At startup the AS field is disabled (the invisible EditText is B  * current and sndasflg is FALSE).  The user can make AS active byC  * clicking in it.  The user can toggle by clicking on the StatText 4  * "AS" -- though I won't tell anybody if you don't.  *  */ N /****************************************************************************/ pascal short sendmydlg (ITEM, DLG)  short ITEM;  DialogPtr DLG; { 2     Boolean isappl;			/* file is an application */     short RSLT;   :     if (sendselflg) {			/* file name selection occured? */4 	sendselflg = FALSE;		/* yes, don't do this again */ 	 7 	p2cstr (&sfr.fName);		/* convert filename to C form */ E 	zltor ((char *)&sfr.fName, filargs.filrem); /* and to remote form */ 8 	c2pstr (&sfr.fName);		/* convert back to pascal form */  @ 	SetIText (gethdl (SEND_ASFN, DLG), /* display converted name */1 		  c2p_tmp(filargs.filrem)); /* in "As" field */ ? 	setfilnams (SEND_ASFN, DLG);	/* set file names since double */  					/* clicking fouls us */  = 	filargs.filflg &= ~FIL_RBDT;	/* turn off all of our flags */ 3 	isappl = (sfr.fType == 'APPL');	/* application? */ D 	if ((Length(sfr.fName) == 0) && !isfolder) {	/* check for folder */) 	    /* change the button if necessary */ 4 	    SetCTitle (getctlhdl (getOpen, DLG), "\pOpen"); 	    isfolder = TRUE; 3 	} else if ((Length(sfr.fName) != 0) && isfolder) { 4 	    SetCTitle (getctlhdl (getOpen, DLG), "\pSend"); 	    isfolder = FALSE; 	}; 	if (sendusercvdef) {		/* use recieve file type defaults */ & 	    filargs.filflg = filargs.fildflg;0 	} else {			/* figure out defaults on our own */6 	    filargs.filflg |= (isappl) ?   /* update flags */. 		(FIL_RSRC | FIL_BINA) :	   /* application */1 		(FIL_DATA | FIL_TEXT);	   /* not application */  	}     } 1     switch (ITEM) {			/* according to the item */ 0       case getNmList:			/* user hit file name */% 	if (sendasflg) {		/* "As" active? */ : 	    sendasflg = FALSE;		/* yes -> deactivate "As" name */H 	    SelIText (DLG, SEND_INVT, 0,256); /* activate invisible editText */ 	}7 	sendselflg = TRUE;		/* next time around set buttons */ 0 	break;				/* nothing more to do in this pass */  3       case SEND_ASFN:			/* hit EditText for "AS" */ 5 	sendasflg = TRUE;		/* let modal filter pass to us */  	break;   !       case getOpen:			/* done? */ 2 	setfilnams (SEND_ASFN, DLG);	/* set file names */ 	break;				/* done... */  3       case SEND_ALL:			/* hit send all check box */ 8 	filargs.filflg ^= FIL_ALLFL;	/* toggle send all flag */    = 	SetCtlValue (getctlhdl (SEND_ALL, DLG),	/* set the ctl value ! 						 * according to the flag */ 6 		     (filargs.filflg & FIL_ALLFL) ? btnOn : btnOff); 	break;      }   B     setfilflgs (ITEM, DLG);	/* check for and handle radio items */&     RSLT = ITEM;		/* pass item back */     return RSLT; }				/* sendmydlg */      N /****************************************************************************/? /* sendfilter - SFPGetFile event filter for "send file" dialog.   *C  * This filter is the same form as a ModalDialog filter, it is used F  * internally by SFPGetFile's ModalDialog call.  Our filter allows theB  * user to select a file by typing the first character, which is aE  * normal function of SFGetFile but is broken when we use EditText in B  * our customized SFGetFile box.  Return 0x1000+char in itemhit toD  * SFGetFile instead of letting ModalDialog handle it with a call toC  * TextEdit.  Using a global flag "sendasflg" we decide to send the :  * character to TextEdit via ModalDialog, or to SFGetFile.  *  */ N /****************************************************************************/ pascal Boolean) sendfilter (THEDIALOG, THEEVENT, ITEMHIT)  DialogPtr THEDIALOG; #pragma unused (THEDIALOG) EventRecord *THEEVENT; short *ITEMHIT;  { )     Boolean RETVAL;		/* returned value */   :     RETVAL = FALSE;		/* default is to left Modal handle */  2     if (THEEVENT->what == keyDown)	/* key down? */5 	if (!sendasflg) {	/* and the text isn't selected? */ ) 	    /* then use as file name selector */ . 	    /* return char+0x1000 to SFPGetfile... */4 	    *ITEMHIT = 0x1000 + (THEEVENT->message & 0x7f);6 	    RETVAL = TRUE;	/* let SFP handle it, not modal */ 	}     return RETVAL; }				/* sendfilter */       N /****************************************************************************/C /* recvmydlg - SFPPutFile item filter for "receive file" dialog. */ N /****************************************************************************/ pascal short recvmydlg (ITEM, DLG)  short ITEM;  DialogPtr DLG; {      short RSLT;        RSLT = ITEM;       switch (ITEM) {        case RECV_PROC: < 	filargs.filflg &= ~FIL_DODLG;	/* no more dialogs for me! */" 	RSLT = RECV_RBTN;		/* did "OK" */         case RECV_RBTN: C 	setfilnams (0, DLG);	/* set names -- this does a p2c(sfr.fName) */  	break;      } =     setfilflgs (ITEM, DLG);	/* check for and handle radios */      return RSLT; }				/* recvmydlg */  - Point recvpt = {75, 100};	/* Used as Point */ , Point sendpt = {75, 80};	/* Used as Point */  N /****************************************************************************/< /* dosenddialog - Use SFPGetFile to fetch a file to send. */4 /* lclf: local file name;  remf: remote file name */N /****************************************************************************/ dosenddialog (lclf, remf)  char *lclf[], *remf[]; {      filargs.filflg = 0; 6     sendasflg = FALSE;		/* "AS" starts off inactive */9     sendselflg = TRUE;		/* need to update file buttons */        isfolder = FALSE; #     /* all file types, 2 filters */ 1     /* $$$ 5th arg (0) was (SFTypeList) NILPTR */   <     SFPGetFile (sendpt, "", (FileFilterProcPtr) NILPROC, -1,, 		0, sendmydlg, &sfr, DLG_SEND, sendfilter);       *lclf = filargs.fillcl;      *remf = filargs.filrem; >     filargs.filvol = sfr.vRefNum;	/* remember volume number *//     return (sfr.good);			/* pass back return */  } /* dosenddialog */  N /****************************************************************************/ /*H  * dorecvdialog() -- if we are doing interactively choosing a file name,=  *                   put up the dialog to let the user do it.   */ N /****************************************************************************/ dorecvdialog (fn, lclf) 1 char *fn;				/* recieved file name -- C string */ L char *lclf[];     /* pointer to local file name storage.  Ptr to C string */ {      int err;  H     if (!(filargs.filflg & FIL_DODLG)) { /* don't want to do dialogs? */+ 	*lclf = "";			/* then use a null string */   	return;				/* and return now */     } #     for (;;) {				/* keep trying */ 6 	filargs.filflg &= ~(FIL_RBDT);	/* clear file modes */? 	filargs.filflg |= sfprtol (fn);	/* convert fn and set modes */   2 	SFPPutFile (recvpt, "\pReceive as:", c2p_tmp(fn),? 		    recvmydlg, &sfr, DLG_RECV, (ModalFilterProcPtr) NILPROC);    	*lclf = filargs.fillcl;; 	filargs.filvol = sfr.vRefNum;	/* remember volume number */    	if (!sfr.good) {		/* CANCEL */ * 	    cxseen = TRUE;		/* indicate cancel */ 	    return;	 	} else {  	    /* delete if there */> 	    err = FSDelete (c2p_tmp(filargs.fillcl), filargs.filvol);- 	    if (err == fnfErr)		/* everything ok? */ ! 		return;			/* yes, return now */  	}   	if (ioutil (err))! 	  return;			/* until no error */      }  } /* dorecvdialog */  N /****************************************************************************/N /****************************************************************************/ initfilrecv() {   D     filargs.filflg = filargs.fildflg;	/* default flags are active */?     warn = !(filargs.filflg & FIL_OKILL); /* set kermit flag */  #ifdef COMMENTE     binary = (filargs.filflg & FIL_BINA); /* selected binary mode? */  #endif /* COMMENT */-     filargs.filsiz = 0;			/* no known size */  } /* initfilrecv */   N /****************************************************************************/A /* initialize the file settings, called only at init time		    */ N /****************************************************************************/ initfilset() {@     filargs.filvol = 0;			/* default volume is always default */E     filargs.fildflg = FIL_DATA | FIL_TEXT; /* default file setting */      /* if no settings file */  } /* initfilset */  N /****************************************************************************/N /****************************************************************************/ int  dogetfdialog (remf) 
 char *remf[];  {      DialogPtr getfdlg;     ControlHandle getbhdl;     Handle remfhdl;      short item;   ?     getfdlg = GetNewDialog (DLG_GETF, NILPTR, (WindowPtr) - 1);      circleOK(getfdlg);     *     remfhdl = gethdl (GETF_REMF, getfdlg);-     getbhdl = getctlhdl (GETF_GETB, getfdlg); F     HiliteControl (getbhdl, 255);	/* start with deactive Get button */       for (;;) {3 	ModalDialog ((ModalFilterProcPtr) NILPROC, &item);  	switch (item) { 	  case ok: 7 	    if (filargs.filrem[0] == '\0') /* no file name? */ 3 	      break;			/* then they hit CR, don't allow */ 5 	    *remf = filargs.filrem;	/* fill in for return */ + 	    initfilrecv ();		/* init recv flags */  	  case cancel:  	    DisposDialog (getfdlg); 	    return (item == ok);  	  case GETF_REMF:( 	    GetIText (remfhdl, filargs.filrem); 	    p2cstr(filargs.filrem);A 	    HiliteControl (getbhdl, (filargs.filrem[0] == 0) ? 255 : 0);  	    break;  	}     }  } /* dogetfdialog */  & #define RSXLEN 5		/* ".rsrc" length */  N /****************************************************************************/C /* sfprtol - translate remote file name to a local file name and */ - /*    	  and figure out the flags as well. */ N /****************************************************************************/ int  sfprtol (fn)A char *fn;		      /* File name from remote kermit -- a C string */  { 
     int l;     register char *cp;     K     for (cp = fn, l = 0; *cp && (l < 32); cp++) { /* Upper to lower case */  	if (isupper(*cp)) 	  *cp = tolower(*cp);. 	if (*cp == ':')			/* Colons to underscores */
 	  *cp = '_';      } I     fn[32] = '\0';	/* Make SURE that the name is at most 31 chars long */      7     if ((l = strlen (fn)) > RSXLEN &&	/* Big enough? */ = 	(strcmp (&fn[l - RSXLEN], ".rsrc") == 0 ||	/* and matches */  							/* extension? */ > 	 strcmp (&fn[l - RSXLEN], ".RSRC") == 0)) {	/* either way? */6 	fn[l - RSXLEN] = '\0';		/* so remove the extension */9 	return (FIL_BINA | FIL_RSRC);	/* want rsrc and binary */      } B     return (filargs.fildflg & FIL_RBDT); /* else return default */ } /* sfprtol */   N /****************************************************************************/ /*&  *	set_cwd - set the working directoryA  *	   Originally wdset() from NCSA Telnet for the Macintosh, v2.2   */ N /****************************************************************************/  . Point cwdpt = {100, 100};		/* Used as Point */   int  set_cwd() {      SFReply reply;     int err;  *     err = SetVol (NILPTR, filargs.filvol);2     SFPPutFile (cwdpt, "\pSet Transfer Directory",. 		"Doesn't Matter", 0L, &reply, CWDBOXID, 0L);       if (!reply.good)       return(-1); (     err = SetVol(NILPTR, reply.vRefNum);     if (err == noErr) E       filargs.filvol = reply.vRefNum;	/* it worked -- remember CWD */      else;       printerr("Trouble setting transfer directory:", err);      return(err); } 