7 char *connv = "OS/2 CONNECT command 5A(155), 4 Oct 94";   > /* C K O C O N  --  Kermit connect command for OS/2 systems */   /*?   Author: Frank da Cruz (fdc@columbia.edu, FDCCU@CUVMA.BITNET), B   Columbia University Academic Information Systems, New York City.  N   Copyright (C) 1985, 1994, Trustees of Columbia University in the City of NewK   York.  The C-Kermit software may not be, in whole or in part, licensed or L   sold for profit as a software product itself, nor may it be included in orM   distributed with commercial products or otherwise distributed by commercial J   concerns to their clients or customers without written permission of theK   Office of Kermit Development and Distribution, Columbia University.  This =   copyright notice must not be removed, altered, or obscured.   L   Originally adapted to OS/2 by Chris Adie of Edinburgh University, ScotlandL   (C.Adie@edinburgh.ac.uk), 1988, from UNIX C-Kermit CONNECT module by FrankM   da Cruz, Columbia University.  VT102 terminal emulation originally by Chris K   Adie, 1988 ("If the code looks a bit funny sometimes, it's because it was    machine translated to C.")  N   Adapted to C-Kermit 5A by Kai Uwe Rommel (rommel@informatik.tu-muenchen.de),/   1992-93 (present address: rommel@ars.muc.de).   M   Many changes by Frank da Cruz (fdc@columbia.edu): numerous bug fixes (tabs, H   cursor/attributes save/restore, scrolling, keypad modes, etc), new SETJ   TERMINAL commands, TCP/IP TELNET support, printer support, character-setL   support, APC escape sequence handling, print/dump screen, complete rewriteM   of character attribute handling & screen reversal and rollback, addition of J   VT220 and ANSI emulations, keyboard verbs, Compose key, Hebrew features,J   context-sensitive popup screens, cosmetic improvements, commentary, etc:E   1992-present.  (Hopefully much of the funny-looking code looks less 
   funny now.)   ;   Additional code by Jeffrey Altman ( p00118@psilink.com ): D   changes to keyboard handling, mouse support, ...: 1993 to present. */   /*N  * =============================#includes=====================================  */   B #include "ckcdeb.h"             /* Typedefs, debug formats, etc */8 #include "ckcker.h"             /* Kermit definitions */= #include "ckcasc.h"             /* ASCII character symbols */ ? #include "ckcxla.h"             /* Character set translation */ 5 #include "ckcnet.h"             /* Network support */ I #include "ckuusr.h"             /* For terminal type definitions, etc. */ ? #include "ckocon.h"             /* Keyboard verb definitions */   5 #include <ctype.h>              /* Character types */ C #include <io.h>                 /* File io function declarations */ K #include <process.h>            /* Process-control function declarations */ C #include <stdlib.h>             /* Standard library declarations */  #include <sys/types.h> #include <sys/stat.h>  #include <stdio.h> #include <string.h>  #include <assert.h>    #ifndef __32BIT__  #define far _far #define near _near #define pascal _pascal #endif /* __32BIT__ */   #ifdef OS2MOUSE  #define INCL_MOU #endif /* OS2MOUSE */    #define INCL_NOPM  #define INCL_VIO #define INCL_ERRORS  #define INCL_DOSPROCESS  #define INCL_DOSSEMAPHORES #define INCL_DOSDEVIOCTL #define INCL_WINCLIPBOARD  #include <os2.h>? #undef COMMENT                /* COMMENT is defined in os2.h */    #ifdef CK_NETBIOS  #include "ckonbi.h"  extern UCHAR NetBiosRemote[] ; #endif /* CK_NETBIOS */    #ifndef min ) #define min(a,b) ((a) <= (b) ? (a) : (b))  #endif /* min */  D #define MAXCOL 132                      /* Maximum screen columns */A #define MAXROW 255                      /* Maximum screen rows */    /*N  * =============================#defines======================================  */     #ifdef TRUE  #undef TRUE  #endif /* TRUE */  #define TRUE 1   #ifdef FALSE #undef FALSE #endif /* FALSE */ #define FALSE 0   $ #define UPWARD   6			/* Scroll up */& #define DOWNWARD 7			/* Scroll down */E #define LBUFSIZE roll.bufsize		/* Maximum lines in rollback buffer */  /*  *N  * =============================typedefs======================================  */  typedef int bool;   F typedef struct ascreen_rec {    /* Structure for saving screen info */     unsigned char   ox;      unsigned char   oy;      unsigned char   att;     char            *scrncpy; 
 } ascreen;   /* Key names */   < static char *keynam[512];		/* Names of keys, by scan code */  5 static struct vik_rec {			/* Very Important Keys - */ ,     KEY help;				/* We look these up once */5     KEY exit;				/* and remember where they are... */      KEY upscn;     KEY dnscn;     KEY upone;     KEY dnone;     KEY homscn;      KEY endscn;      KEY hangup;      KEY xbreak;      KEY lbreak; 
     KEY dump;      KEY prtscn;      KEY os2;     KEY printff;     KEY flipscn;     KEY debug;     KEY reset;     KEY compose; } vik; /*  *N  * =============================externals=====================================  */ N extern CHAR (*xls[MAXTCSETS+1][MAXFCSETS+1])(CHAR);  /* Character set xlate */E extern CHAR (*xlr[MAXTCSETS+1][MAXFCSETS+1])(CHAR);  /* functions. */ 7 extern int language;            /* Current language. */ 4 extern struct langinfo langs[]; /* Language info. */= extern struct csinfo fcsinfo[]; /* File character set info */ N extern int tcsr, tcsl;          /* Terminal character sets, remote & local. */  M extern int tnlm, tn_nlm;        /* Terminal newline mode, ditto for TELNET */ B extern int tt_crd;              /* Carriage-return display mode */N extern int tt_bell;             /* How to handle incoming Ctrl-G characters */ extern long     speed, vernum;D extern int      local, escape, duplex, parity, flow, seslog, sessft,K                 cmdmsk, cmask, sosi, xitsta, debses, mdmtyp, carrier, what;   extern int	cflg, cnflg, stayflg;+ extern int      network, nettype, ttnproto;   
 #ifndef NOSPL 3 extern struct mtab *mactab;		/* Main macro table */ ) extern int nmac;			/* Number of macros */  #endif /* NOSPL */   extern KEY      *keymap; extern MACRO    *macrotab;# extern char     ttname[], sesfil[];  extern void     cc_trap();   extern char     *printfile;    #ifdef __32BIT__ extern HMTX hmtxScreenSem ;  extern HMUX hmuxKeyStroke ;  #endif /* __32BIT__ */ #ifdef OS2MOUSE  extern HMTX hmtxMouseSem ; extern HMOU hMouse ; #endif /* OS2MOUSE */  /*G  * =============================variables==============================   */    /*J   These are RGB bits for the fore- and background colors in the PC's videoM   adapter, 3 bits for each color.  These default values can be changed by the K   SET TERMINAL COLOR command (in ckuus7.c) or by CSI3x;4xm escape sequences    from the host. */ #ifdef MONO  int     colornormal     = 0x07;  int     colorunderline  = 0x01;  int     colorreverse    = 0x70;  int     colorstatus     = 0x70;  int     colorhelp       = 0x70;  #else  int     colornormal     = 0x30;  int     colorunderline  = 0x3E;  int     colorreverse    = 0x70;  int     colorstatus     = 0x74;  int     colorhelp       = 0x27;  #endif /* MONO */  int     colorborder     = 0x00;    int     colorcmd;  int     scrninitialised = 0;   /*I   The video adapter stores each screen character in a two-byte cell.  The N   first byte of each cell contains the 8-bit character value.  The second byteG   contains the video attributes for the character, and looks like this:   #          Background      Foreground           Color           Color%     +---+---+---+---+---+---+---+---+ %     | b | R | G | B | i | R | G | B | %     +---+---+---+---+---+---+---+---+ #       b = blink       i = intensity         0 = nonblinking 0 = normal       1 = blinking    1 = high  N   The i bit applies to the foreground color.  The meaning of the b bit dependsO   on the VIO state; it can mean (a) the foreground character blinks, or (b) the N   background color is high-intensity.  C-Kermit uses (b) because blinking onlyI   works in a fullscreen session.  See the call to VioSetState().  The RGB :   bits select the desired mixture of Red, Green, and Blue.  I   The swapcolors macro exchanges the fore- and background colors (the RGB I   bits) but leaves the intensity/blink bits where there are.  Thus if the I   foreground color is bold and the background color is not bold, the same "   will be true after swapcolors(). */L #define swapcolors(x) (((x)&(unsigned)0x88)|(((x)&0x70)>>4)|(((x)&0x07)<<4))  7 static int tn_bold = 0;			/* TELNET negotiation bold */ , int esc_exit = 0;			/* Escape back = exit */ char * esc_msg;   ; static long waittime;			/* Timeout on CTS during CONNECT */  #define INTERVAL 100L    static char termessage[MAXCOL]; 3 static FILE *lst = NULL;		/* List (print) device */ < static bool lstclosed = TRUE;		/* List device closed flag */  
 #ifdef CK_APC ? extern int apcactive;			/* Application Program Command (APC) */ ' extern int apcstatus;			/* items ... */ # static int apclength = 0;            #ifdef DCMDBUF extern char *apcbuf; #else  extern char apcbuf[];  #endif /* DCMDBUF */% static int apcbuflen = APCBUFLEN - 2;  #endif /* CK_APC */    char * keydefptr = NULL; int keymac = 0;  int keymacx = -1;    int #   xsize = -1,				/* Screen width */ $   ysize = -1;				/* Screen height */   . ascreen		            /* For saving screens: */'   vt100screen,				/* terminal screen */ $   commandscreen,			/* OS/2 screen */&   savedscreen,				/* (various uses) *//   helpscreen;				/* Screen behind popup help */ = extern ascreen mousescreen; /* Screen during mouse actions */    2 static unsigned char			/* Video attribute bytes */J   attribute = NUL,                      /* Current video attribute byte */H   savedattribute = NUL,                 /* Saved video attribute byte */J   defaultattribute = NUL;               /* Default video attribute byte */    /*M   Note, the following are related to the VT terminal screen, not the PC video H   adapter.  That is, 'attribute' (above) is the PC video attribute byte,@   'attrib' (below) is the VT terminal attribute structure.  etc. */N static struct {                         /* Character attributes, 1 bit each */;     unsigned reversed:1;                /* Reverse video */ 6     unsigned blinking:1;                /* Blinking */D     unsigned underlined:1;              /* Underlined (simulated) */C     unsigned bold:1;                    /* Bold (high intensity) */ 7     unsigned invisible:1;               /* Invisible */  } attrib, savedattrib;  ) /* Screen rollback buffer, circular... */    static struct paging_record { N     int flag;                           /* Nonzero means we are rolled back */L     int numlines;                       /* How many lines saved in buffer */?     int topline;                        /* Index of top line */ B     int botline;                        /* Index of bottom line */C     int current;                        /* Index of current line */ ?     char *buffer;                       /* Pointer to buffer */ <     int bufsize;                        /* Size of buffer */<     int linesleft;			/* How many lines above current line */6     int nextline;			/* Next line in rollback buffer */ } roll;   + int wherex;				/* Screen column, 1-based */ ( int wherey;				/* Screen row, 1-based */N static int margintop = 1;               /* Top of scrolling region, 1-based */E static int marginbot = 24;              /* Bottom of same, 1-based */   D static int active, quitnow, hangnow, inshift, outshift, tcs, langsv;  H static char answerback[81] = "OS/2 C-Kermit\r"; /* Default answerback */G static char usertext[(MAXCOL) + 1];     /* Status line and its parts */ # static char statusline[MAXCOL + 1];  static char exittext[(20) + 1];  #define HLPTXTLEN 41  static char helptext[HLPTXTLEN]; static char filetext[(20) + 1]; - static char savefiletext[(20) + 1] = { NUL };  #define HSTNAMLEN 41  static char hostname[HSTNAMLEN];  J static unsigned char graphicset[32] = { /* VT100/200 graphic characters */3     0x20, 0x04, 0xB0, 0x1A, 0x17, 0x1B, 0x19, 0xF8, 3     0xF1, 0x15, 0x12, 0xD9, 0xBF, 0xDA, 0xC0, 0xC5, 3     0xC4, 0xC4, 0xC4, 0xC4, 0xC4, 0xC3, 0xB4, 0xC1, 2     0xC2, 0xB3, 0xF3, 0xF2, 0xE3, 0x9D, 0x9C, 0xFA };   #define DEFTABS \ K "0T0000000T0000000T0000000T0000000T0000000T0000000T0000000T0000000T0000000\ > T0000000T0000000T0000000T0000000T0000000T0000000T0000000T000";  B static char htab[133] = DEFTABS         /* Default tab settings */  " static VIOCURSORINFO crsr_command; static VIOCURSORINFO crsr_info;    static int row = 0;  static int column = 0; static int achar;   M static unsigned char g0 = 'B';          /* Default G0 charset is US ASCII. */ 6 static unsigned char g1 = 'B';          /* G1 also. */! static unsigned char *g0g1 = &g0;   ; static bool     printon        = FALSE; /* Printer is on */ H static bool     printregion    = FALSE; /* Print extent = full screen */< static bool     xprintff       = FALSE; /* Print formfeed */E static bool     turnonprinter  = FALSE; /* Time to turn on printer */ K static bool     xprint         = FALSE; /* Transparent print in progress */ A static bool     turnoffprinter = FALSE; /* Time to turn it off */   " static bool     wrapit    = FALSE;" static bool     literal   = FALSE;! static bool     screenon  = TRUE; K static bool     cursoron  = TRUE;       /* For speed, turn off when busy */ G static bool     cursorena = TRUE;       /* Cursor enabled / disabled */ " static bool     relcursor = FALSE;" static bool     keylock   = FALSE;% static bool     vt52graphics = FALSE;   / static unsigned char saveg0, saveg1, *saveg0g1; + static bool     saverelcursor, saved=FALSE;   < static bool     dwl[MAXROW];		/* Double-width line buffer */> static bool     dwls = FALSE;           /* For optimisation */9 static bool     deccolm = FALSE;	/* 80/132-column mode */ A static bool     decscnm = FALSE;	/* Normal/reverse screen mode */ = static bool     insertmode = FALSE;	/* Insert/replace mode */  /*F   Terminal parameters that can also be set externally by SET commands.E   Formerly they were declared and initialized here, and had different =   names, as shown in the comments.  Now they are declared and !   initialized in ckuus7.c.  - fdc  */F static int my_tt_type;                  /* Prevailing terminal type */< static bool tt_hebrew = 0;		/* Keyboard is in Hebrew mode */J static int c1controls;                  /* Flag for C1 controls allowed */@ static bool send_c1 = FALSE;		/* Flag for sending C1 controls */   /*G   VT220 and higher Pn's for terminal ID string are (* = Not supported):    *  1 - 132 columns      2 - Printer port    *  3 - ReGIS graphics    *  4 - Sixel graphics !   *  6 - DECSED - Selective erase #   *  7 - DRCS - Soft character sets     *  8 - UDK - User-defined keysF   *  9 - National Replacement Character Sets can be designated by host   * 13 - Local editing      15 - Technical character set   * 18 - Windowing Capability    * 19 - Dual sessions */F struct tt_info_rec tt_info[] = {        /* Indexed by terminal type */2   "NONE",      "",                      /* None */6   "VT52",      "/Z",                    /* DEC VT52 */'   "ANSI",      "",			/* "ANSI" (BBS) */ 7   "VT100",     "[?1c",                  /* DEC VT100 */ 7   "VT102",     "[?6c",                  /* DEC VT102 */ 7   "VT220",     "[?62;2;15c"             /* DEC VT220 */  #ifdef COMMENT7 , "VT320"      "[?63;2;15c",            /* DEC VT320 */  #endif /* COMMENT */ };C int max_tt = TT_VT320;                  /* Highest terminal type */    /* SET TERMINAL values ... */   + extern int tt_arrow;			/* Arrow-key mode */ ) extern int tt_keypad;			/* Keypad mode */ $ extern int tt_wrap;			/* Autowrap */) extern int tt_type;			/* Terminal type */ ) extern int tt_cursor;			/* Cursor type */ 9 extern int tt_answer;			/* Answerback enabled/disabled */ 5 extern int tt_scrsize;			/* Scrollback buffer size */ , extern int tt_roll;			/* Scrollback style */' extern int tt_rows;			/* Screen rows */ * extern int tt_cols;			/* Screen columns */) extern int tt_ctstmo;			/* CTS timeout */ ' extern int tt_hide;			/* Hide-cursor */ + extern int tt_pacing;			/* Output-pacing */ " extern int tt_mouse;			/* Mouse */  / /* Escape-sequence parser state definitions. */ D /* For explanation, see ckucon.c, where this code is copied from. */  L #define ES_NORMAL 0                     /* Normal, not in escape sequence */F #define ES_GOTESC 1                     /* Current character is ESC */G #define ES_ESCSEQ 2                     /* Inside an escape sequence */ G #define ES_GOTCSI 3                     /* Inside a control sequence */ N #define ES_STRING 4                     /* Inside DCS,OSC,PM, or APC string */K #define ES_TERMIN 5                     /* 1st char of string terminator */    #define ESCBUFLEN 128   % static int      escstate = ES_NORMAL;  static int      escnext = 1; static int      esclast = 0;  ' /* Escape-sequence processing buffer */   , static unsigned char escbuffer[ESCBUFLEN+1];   /*%    For pushing back input characters, <    e.g. converting 8-bit controls to 7-bit escape sequences. */4 static int f_pushed = 0, c_pushed = 0, f_popped = 0;  ; static unsigned char sgrcols[8] = {0, 4, 2, 6, 1, 5, 3, 7};    /* Function prototypes */   ? static CHAR (*sxo)(CHAR); /* Character translation functions */ C static CHAR (*rxo)(CHAR); /* for output (sending) terminal chars */ I static CHAR (*sxi)(CHAR); /* and for input (receiving) terminal chars. */  static CHAR (*rxi)(CHAR);    #ifndef NOTTOCI  int ttoci(char c); #endif /* NOTTOCI */  9 static int popuphelp(int);		/* Pop-up help panel maker */   ; static void ipadl25(void);		/* Default status-line maker */ B static void line25(void);		/* General-purpose status-line maker */ static void xline25(char *);# static void save_status_line(void); & static void restore_status_line(void);" static void resethebrewmode(void); static int status_saved = -1;    int restorescreen(ascreen *); # static int sendchar(unsigned char);    static void bleep(void);" static void checkscreenmode(void);" static void clearscreen(int, int); static void clrtoeoln(void); static void doesc(int c);  static void esc25(int);  static void flipscreen(void);  static void helpline(char *);  static void killcursor(void);  static void lgotoxy(int, int);0 static void movetoscreen(char *, int, int, int); static void newcursor(void); static void printeron(void); static void printeroff(void);   static void prtscreen(int, int);$ static void restorecursormode(void);% void savescreen(ascreen *, int, int); ' static void scroll(int, int, int, int);  static void scrollback(int);  static void setcursormode(void);! static void setmargins(int, int); & static void strinsert(char *, char *);( static void toplinetocyclicbuffer(void); static void wrtch(char); static int sendescseq(char *);   int ckcgetc(int);  void cwrite(unsigned char);    extern int concooked(void);  extern int conraw(void); extern int xxesc(char **);   /* Thread stuff... */    #ifdef __32BIT__ HEV threadsem, threadsem2 ;  ULONG semcount, semcount2;= #define THRDSTKSIZ      131072  /* Needed for Mouse Thread */  #else I static long int threadsem, threadsem2;	/* Semaphore for thread running */  #define THRDSTKSIZ      2048M static char            stack[THRDSTKSIZ];       /* Stack for second thread */ M static char            stack2[THRDSTKSIZ];       /* Stack for third thread */  #endif /* __32BIT__ */* static TID             threadid,threadid2;  
 static int #ifdef COMMENTM   iskipesc = 0,                         /* Skip over ANSI escape sequences */ J   inesc = ES_NORMAL,                    /* State of sequence recognizer */ #endif /* COMMENT */L   oskipesc = 0,                         /* Esc seq recognizer for keys... */   outesc = ES_NORMAL;    /*5    C H K A E S  --  Check ANSI Escape Sequence state. F    Previously used for both input and output, now (edit 190) used only;    for output of keystrokes.  Input is handled in cwrite().  */ int  chkaes(int esc, char c) { M     if (c == CAN || c == SUB)           /* CAN and SUB cancel any sequence */        esc = ES_NORMAL;7     else                                /* Otherwise */ B       switch (esc) {                    /* enter state switcher */  :         case ES_NORMAL:                 /* NORMAL state */8           if (c == ESC)                 /* Got an ESC */D             esc = ES_GOTESC;            /* Change state to GOTESC */L           break;                        /* Otherwise stay in NORMAL state */  :         case ES_GOTESC:                 /* GOTESC state */K           if (c == '[')                 /* Left bracket after ESC is CSI */ D             esc = ES_GOTCSI;            /* Change to GOTCSI state */J           else if (c == 'P' || (c > 0134 && c < 0140)) /* P, ], ^, or _ */O             esc = ES_STRING;            /* Switch to STRING-absorption state */ J           else if (c > 057 && c < 0177) /* Final character '0' thru '~' */<             esc = ES_NORMAL;            /* Back to normal */J           else if (c != ESC)            /* ESC in an escape sequence... */J             esc = ES_ESCSEQ;            /* starts a new escape sequence */O           break;                        /* Intermediate or ignored ctrl char */   M         case ES_ESCSEQ:                 /* ESCSEQ -- in an escape sequence */ J           if (c > 057 && c < 0177)      /* Final character '0' thru '~' */E             esc = ES_NORMAL;            /* Return to NORMAL state. */ 5           else if (c == ESC)            /* ESC ... */ J             esc = ES_GOTESC;            /* starts a new escape sequence */O           break;                        /* Intermediate or ignored ctrl char */   M         case ES_GOTCSI:                 /* GOTCSI -- In a control sequence */ J           if (c > 077 && c < 0177)      /* Final character '@' thru '~' */?             esc = ES_NORMAL;            /* Return to NORMAL. */ 5           else if (c == ESC)            /* ESC ... */ :             esc = ES_GOTESC;            /* starts over. */O           break;                        /* Intermediate or ignored ctrl char */   =         case ES_STRING:                 /* Inside a string */ O           if (c == ESC)                 /* ESC may be 1st char of terminator */ 5             esc = ES_TERMIN;            /* Go see. */ J           break;                        /* Absorb all other characters. */  J         case ES_TERMIN:                 /* May have a string terminator */E           if (c == '\\')                /* which must be backslash */ C             esc = ES_NORMAL;            /* If so, back to NORMAL */ 7           else                          /* Otherwise */ H             esc = ES_STRING;            /* Back to string absorption. */       }      return(esc); }   H /* ------------------------------------------------------------------ */H /* ipadl25 - Make normal CONNECT-mode status line                     */H /* ------------------------------------------------------------------ */ static void  ipadl25() {      int i, j, n;     char *s, *p;"     strcpy(usertext," C-Kermit ");     if (debses)        strcat(usertext,"DEBUG"); /     else if (tt_type > -1 && tt_type <= max_tt) /       strcat(usertext,tt_info[tt_type].x_name);      if (tt_hebrew)       strcat(usertext,"-H");     if (printon) { 	strcpy(filetext,"PRINTER ON");      } else if ( !network )-       sprintf(filetext, "Serial %ld", speed);      else       switch ( nettype ) {         case NET_DEC:            switch ( ttnproto ) {              case NP_LAT:-               strcpy(filetext, "DECnet LAT");                break;             case NP_CTERM:/               strcpy(filetext, "DECnet CTERM");                break;             default:)               strcpy(filetext, "DECnet");                break;           }          break;       case NET_TCPB:         switch ( ttnproto ) {            case NP_TELNET: '             strcpy(filetext, "TELNET");              break;           default:'             strcpy(filetext, "TCP/IP");              break;	         }          break;       case NET_PIPE:'         strcpy(filetext, "Named Pipe");          break;       case NET_BIOS:$         strcpy(filetext, "NetBIOS");         break;       }   1     if (vik.help > 255 && keynam[vik.help - 256]) <       sprintf(helptext, "Help: %s", keynam[vik.help - 256]);     else3       sprintf(helptext, "Help: ^%c?", ctl(escape));   1     if (vik.exit > 255 && keynam[vik.exit - 256]) B       sprintf(exittext, "%s %s", esc_msg, keynam[vik.exit - 256]);     else9       sprintf(exittext, "%s ^%c?", esc_msg, ctl(escape));   "     strncpy(hostname, ttname, 40); #ifdef CK_NETBIOS 8     if ( ( nettype == NET_BIOS ) && ( *ttname == '*' ) )>        strncpy(hostname+1, NetBiosRemote, NETBIOS_NAME_LEN ) ; #endif /* CK_NETBIOS */      if (!network)        strupr(hostname); 
     line25();  }   H /* ------------------------------------------------------------------ */H /* CursorUp -                                                         */H /* ------------------------------------------------------------------ */ static void  cursorup() {.     if ((relcursor ? margintop : 1) != wherey) 	lgotoxy(wherex, wherey - 1);  }   H /* ------------------------------------------------------------------ */H /* CursorDown -                                                       */H /* ------------------------------------------------------------------ */ static void  cursordown() {2     if ((relcursor ? marginbot : ysize) != wherey) 	lgotoxy(wherex, wherey + 1);  }   H /* ------------------------------------------------------------------ */H /* CursorRight -                                                      */H /* ------------------------------------------------------------------ */ static void  cursorright() { 7     if (wherex < (dwl[wherey - 1] ? xsize - 1 : xsize))  	lgotoxy(wherex + 1, wherey);  }   H /* ------------------------------------------------------------------ */H /* CursorLeft -                                                       */H /* ------------------------------------------------------------------ */ static void  cursorleft() {     if (wherex > 1)  	lgotoxy(wherex - 1, wherey);  }   H /* ------------------------------------------------------------------ */ /* ReverseScreen						      */& /* fixed by fdc, edit 190					      */H /* ------------------------------------------------------------------ */ static void  reversescreen() {      int             i, r, c, x;      USHORT          n;%     unsigned char   cell[MAXCOL * 2];    #ifdef OS2MOUSE     os2_mousehide() ; #endif /* OS2MOUSE */      n = xsize * 2;<     for (r = 0; r < ysize; r++) {	   /* Loop for each row */G 	VioReadCellStr(cell, &n, r, 0, 0); /* Read this row from the screen */ F 	for (c = 0; c < xsize; c++) {	   /* Loop for each character in row */8 	    x = c + c + 1;		   /* Location of attribute byte */# 	    cell[x] = swapcolors(cell[x]);  	}=    VioWrtCellStr(cell, n, r, 0, 0); /* Write the row back. */      }  #ifdef OS2MOUSE     os2_mouseshow() ; #endif }    voidH reverserange( SHORT fromrow, SHORT fromcol, SHORT torow, SHORT tocol ) {     int             r, c;      SHORT           temp;      USHORT          n;     unsigned char   cell[2];     unsigned char   D[80];   #ifdef OS2MOUSE      os2_mousehide() ;  #endif /* OS2MOUSE */   8     sprintf( D, "ReverseRange: from (%d,%d) to (%d,%d)"," 	    fromrow,fromcol,torow,tocol);     debug(F100,D,"",0);   G     if ( fromrow > torow || ( fromrow == torow && fromcol > tocol ) ) {  	temp = fromcol ;  	fromcol = tocol ; 	tocol = temp ;      }      if ( fromrow > torow ) { 	temp = fromrow ;  	fromrow = torow ; 	torow = temp ;      } ,     for ( r = fromrow ; r <= torow ; r++ ) {) 	for ( c = ( r==fromrow ? fromcol : 0 ) ; . 	     c <= ( r == torow ? tocol : xsize -1 ) ;
 	     c++ ) {  	    n = 2 ;) 	    VioReadCellStr(cell, &n, r, c, 0 ) ; $ 	    cell[1] = swapcolors(cell[1]) ;( 	    VioWrtCellStr( cell, n, r, c, 0 ) ; 	}     }  #ifdef OS2MOUSE      os2_mouseshow() ;  #endif }   ( static void				/* Flip screen between */0 flipscreen() {				/* normal and reverse video */     unsigned char fg, bg;      reversescreen();3     if (decscnm) {			/* Currently reverse-video? */ J         defaultattribute = colornormal;	/* Yes, go back to normal color */4         decscnm = FALSE;		/* Change DECSCNM value */
     } else {	 3         defaultattribute = swapcolors(colornormal);          decscnm = TRUE;      } O     /* Subsequent chars are written with current attributes, colors swapped. */ &     attribute = swapcolors(attribute);0     colorunderline = swapcolors(colorunderline); }   G /* ----------------------------------------------------------------- */ G /* ClrScreen -                                                       */ G /* ----------------------------------------------------------------- */  static void 
 clrscreen() {      int             i, j;      int             nlines;      USHORT          n;&     char            cells[MAXCOL * 2];   #ifdef OS2MOUSE      os2_mousehide() ;  #endif9     /* Copy lines on screen to extended display buffer */   5     n = xsize * 2;			/* Size of screen-line buffer */ C     for (i = ysize - 1; i >= 0; i--) {	/* Start at screen bottom */ C 	VioReadCellStr((char *) cells, &n, i, 0, 0); /* Get screen line */ A 	for (j = 0; j < xsize; j++) {	/* Look at the characters in it */ 9 	    if (cells[j * 2] != ' ')	/* Is this one nonblank? */ 4 	      break;			/* Yes, stop looking at this line */ 	}3 	if (j < xsize)			/* If this is a nonblank line, */ ( 	  break;			/* quit the big loop too. */     }   4     /* Now we've located the lowest nonblank line */  :     nlines = i;				/* Number of lines to clear, minus 1 */#     for (i = 0; i <= nlines; ++i) { . 	roll.botline = (roll.botline + 1) % LBUFSIZE; 	if (roll.numlines < LBUFSIZE) 	  roll.numlines++;  	else 0 	  roll.topline = (roll.topline + 1) % LBUFSIZE;F 	VioReadCellStr((roll.buffer + xsize * 2 * roll.botline),&n, i, 0, 0);     }      for (i = 0; i < ysize; i++)        dwl[i] = FALSE;      dwls = FALSE; %     clearscreen(0, defaultattribute);  #ifdef OS2MOUSE      os2_mouseshow() ;  #endif }   G /* ----------------------------------------------------------------- */ G /* PrtScreen - Copy lines on screen to printer.                      */ G /* parameters = Top line to print, bottom line to print, 1-based.    */ G /* ----------------------------------------------------------------- */  static void			   prtscreen(int top, int bot) {      int    i, j, first, last; 
     USHORT n;      char   cells[MAXCOL * 2]; "     char   outbuf[MAXCOL + 1];	     ,     if (printon)			/* Printer already on? */
       return; :     if (top < 1 || bot > ysize)		/* Args out of bounds? */
       return;   (     printeron();			/* Turn on printer */ #ifdef OS2MOUSE      os2_mousehide() ;  #endif%     if (lst) {				/* If printer on */ 3 	n = xsize * 2;			/* Line width, incl attributes */ A 	for (i = top; i <= bot; i++) {  /* For each screen line, i... */ : 	    /* Internally, screen lines are 0-based, so "i-1". */D 	    VioReadCellStr((char *) cells, &n, i-1, 0, 0); /* Get line i */E 	    for (j = 0; j < xsize; j++)	/* Strip away the attribute bytes */  	      outbuf[j] = cells[j+j];H             for (j = xsize - 1; j >= 0; j--) /* Strip trailing blanks */" 	      if (outbuf[j] != SP) break;1 	    outbuf[j+1] = NUL;		/* Terminate with NUL */ 7 	    fprintf(lst,"%s\r\n",outbuf); /* Print the line */  	}1 	if (xprintff /* && top == 1 && bot == ysize */ )  	  fprintf(lst,"%c",FF); #ifdef OS2MOUSE  	os2_mouseshow() ; #endif 	printeroff();     }  }   
 static int pnumber(int *achar) {      int num = 0;/     while (isdigit(*achar)) {		/* Get number */ " 	num = (num * 10) + (*achar) - 48;4 	*achar = (escnext<=esclast)?escbuffer[escnext++]:0;     }      return (num);  }    static void  clreoscr_escape() {      char cell[2]; 
     int i;  %     if (wherex == 1 && wherey == 1) { 
 	clrscreen();  	return;     }      cell[0] = ' '; #ifdef COMMENT /* Wrong!  - fdc */      cell[1] = attribute; #else      cell[1] = defaultattribute;  #endif /* COMMENT */B     i = (xsize * ysize) - (((wherey - 1) * xsize) + (wherex - 1)); #ifdef OS2MOUSE      os2_mousehide() ;  #endif /* OS2MOUSE */ 4     VioWrtNCell(cell, i, wherey - 1, wherex - 1, 0); #ifdef OS2MOUSE      os2_mouseshow() ;  #endif(     for (i = wherey - 1; i < ysize; i++) 	dwl[i] = FALSE;     dwls = FALSE;      for (i = 0; i < ysize; i++)  	if (dwl[i]) { 	    dwls = TRUE;  	    break;  	} }    static void  clrboscr_escape() {      char cell[2]; 
     int i;       cell[0] = ' '; #ifdef COMMENT /* Wrong!  - fdc */      cell[1] = attribute; #else      cell[1] = defaultattribute;  #endif /* COMMENT */(     i = ((wherey - 1) * xsize) + wherex; #ifdef OS2MOUSE      os2_mousehide() ;  #endif /* OS2MOUSE */ "     VioWrtNCell(cell, i, 0, 0, 0); #ifdef OS2MOUSE      os2_mouseshow() ;  #endif      for (i = 0; i < wherey; i++)       dwl[i] = FALSE;      dwls = FALSE;      for (i = 0; i < ysize; i++)        if (dwl[i]) {  	  dwls = TRUE; 	 	  break;        }  }    static void  clrbol_escape() {      char cell[2];        cell[0] = ' '; #ifdef COMMENT     cell[1] = attribute; #else      cell[1] = defaultattribute;  #endif /* COMMENT */ #ifdef OS2MOUSE      os2_mousehide() ;  #endif /* OS2MOUSE */ 0     VioWrtNCell(cell, wherex, wherey - 1, 0, 0); #ifdef OS2MOUSE      os2_mouseshow() ;  #endif }    static void  clrline_escape() {     char cell[2];        cell[0] = ' '; #ifdef COMMENT     cell[1] = attribute; #else      cell[1] = defaultattribute;  #endif /* COMMENT */ #ifdef OS2MOUSE      os2_mousehide() ;  #endif /* OS2MOUSE */ /     VioWrtNCell(cell, xsize, wherey - 1, 0, 0);  #ifdef OS2MOUSE      os2_mouseshow() ;  #endif }    static void  decdwl_escape(bool dwlflag) {      unsigned char   linenumber;      unsigned char   newx; &     char            cells[MAXCOL * 2];     int             i;     USHORT          n;   #ifdef OS2MOUSE      os2_mousehide() ;  #endif /* OS2MOUSE */       /* DECDWL */      linenumber = wherey - 1;%     if (dwlflag != dwl[linenumber]) {  	/* change size */ 	n = xsize * 2; 6 	VioReadCellStr((char *) cells, &n, linenumber, 0, 0);2 	if (dwlflag) {			/* Make this line double size */8 	    for (i = xsize / 2 - 1; i >= 0; --i) { /* Expand */ 		cells[4 * i] = cells[2 * i]; 		cells[4 * i + 2] = ' ';  	    }! 	    newx = (wherex - 1) * 2 + 1;  	    dwls = TRUE; , 	} else {			/* Make this line single size */) 	    for (i = 0; i <= xsize / 2 - 1; ++i) # 	      cells[2 * i] = cells[4 * i]; ( 	    for (i = xsize / 2; i < xsize; ++i) 	      cells[2 * i] = ' ';! 	    newx = (wherex - 1) / 2 + 1;  	    dwls = FALSE;  	    for (i = 0; i < ysize; i++) 	      if (dwl[i]) { 		  dwls = TRUE;
 		  break; 	      } 	}4 	VioWrtCellStr((char *) cells, n, linenumber, 0, 0); 	dwl[linenumber] = dwlflag;  	if (newx >= xsize)  	  newx = xsize - 1; 	lgotoxy(newx, wherey);      }  #ifdef OS2MOUSE      os2_mouseshow() ;  #endif }    static void 
 printeron() { )     if (printon)			/* It's already on. */ 
       return; 7     if (lstclosed || !lst) {		/* Open printer device */ 2 	if (!printfile)			/* If printer not redirected */5 	  lst = fopen("prn", "w");	/* open the PRN device */  	else				/* otherwise */D 	  lst = fopen(printfile, "ab"); /* open the file in append mode. */     }       if (lst) {				/* Open OK? */ 	strcpy(savefiletext,filetext);  	strcpy(filetext,"PRINTER ON"); 
 	line25();( 	lstclosed = FALSE;		/* So not closed */+ 	printon = TRUE;			/* and printer is on. */      }  }    static void ( printeroff() {				/* Turn off printer */+     if (!printon)			/* It's already off. */ 
       return;      if (lst && !lstclosed)       fclose(lst);     lstclosed = TRUE;      printon = FALSE;1     if (savefiletext[0]) {		/* Fix status line */  	strcpy(filetext,savefiletext);  	savefiletext[0] = NUL;      } 
     line25();  }   - #define CK_BORDER			/* Allow border colors */    static int cmd_border = -1;    static void 
 setborder() {  #ifdef CK_BORDER7     VIOOVERSCAN vo;			/* Set border (overscan) color */ =     vo.cb = sizeof(vo);			/* for terminal emulation window */      vo.type = 1;     vo.color = colorborder;       VioSetState((PVOID) &vo, 0); #endif /* CK_BORDER */ }    static void 2 saveborder() {				/* Save command-screen border */ #ifdef CK_BORDER     VIOOVERSCAN vo;      vo.cb = sizeof(vo);      vo.type = 1;      VioGetState((PVOID) &vo, 0);     cmd_border = vo.color; #endif /* CK_BORDER */ }    static void  restoreborder() {  #ifdef CK_BORDER9     VIOOVERSCAN vo;			/* Restore command-screen border */ +     if (cmd_border < 0)			/* None saved. */ 
       return;      vo.cb = sizeof(vo);      vo.type = 1;     vo.color = cmd_border;     cmd_border = 0;       VioSetState((PVOID) &vo, 0); #endif /* CK_BORDER */ }   0 static void				/* Reset the terminal emulator */5 doreset(int x) {			/* x = 0 (soft), nonzero (hard) */ 
     int i;  7     defaultattribute = colornormal;	/* Normal colors */      if (decscnm)2       colorunderline = swapcolors(colorunderline);:     attribute = defaultattribute;	/* Default attributes */,     attrib.blinking = FALSE;		/* No blink */'     attrib.bold = FALSE;		/* No bold */ 2     attrib.invisible = FALSE;		/* Not invisible */2     attrib.underlined = FALSE;		/* No underline */4     attrib.reversed = FALSE;		/* No reverse video */6     g0 = g1 = 'B';			/* ASCII (not UK) in G0 and G1 */%     g0g1 = &g0;				/* (sort of...) */ .     printon = FALSE;			/* Printer is not on */=     printregion = FALSE;		/* Printer extent is full screen */ 4     screenon = TRUE;			/* The screen is turned on */
 #ifdef CK_APC 7     apcactive = 0;			/* An APC command is not active */      apclength = 0;			/* ... */ #endif /* CK_APC */ >     vt52graphics = FALSE;		/* Get out of VT52 graphics mode */+     saved = FALSE;			/* Nothing is saved */ ;     tnlm = tt_crd = FALSE;		/* We're not in newline mode */ <     insertmode = FALSE;			/* Not in character-insert mode */;     tt_arrow = TTK_NORM;		/* Arrow keypad to cursor mode */ B     tt_keypad = TTK_NORM;		/* Auxilliary keypad to numeric mode */9     tt_wrap = TRUE;			/* (FALSE for real VT terminal!) */ ?     tt_type = my_tt_type;		/* Terminal type back to original */ 3     send_c1 = FALSE;			/* Don't send C1 controls */ 3     keylock = FALSE;			/* Keyboard is not locked */ +     deccolm = FALSE;			/* 80-column mode */ ;     decscnm = FALSE;			/* Screen is not in reverse video */ D     for (i = 0; i < ysize; i++)		/* Not in double-width-line mode */       dwl[i] = FALSE;      dwls = FALSE; B     for (i = 1; i < xsize; i++)		/* Tab settings every 8 spaces */:       htab[i] = (i % 8) == 1 ? 'T' : '0'; /* was "== 0" */:     relcursor = FALSE;			/* Cursor position is absolute */A     setmargins(1, ysize);		/* Scrolling region is whole screen */ @     escstate = ES_NORMAL;		/* In case we're stuck in a string */-     setborder();			/* Restore border color */ /     cursorena = TRUE;			/* Cursor is enabled */ 9     resethebrewmode();			/* Leave Hebrew keyboard mode */ =     setcursormode();			/* Get rid of any unwanted blinking */ 4     if (x) clrscreen();			/* Now clear the screen */(     newcursor();			/* Put up a cursor *//     if (roll.flag)			/* Were we rolled back? */ -       roll.flag = 0;			/* Not any more ... */ 4     ipadl25();				/* Put back regular status line */ }    static void 7 savecurpos(int x) {			/* x: 0 = cursor only, 1 = all */ 1     saved = TRUE;			/* Remember they are saved */ 0     row = wherey;			/* Current row (absolute) */6     column = wherex;			/* Current column (absolute) */     if (x) {> 	savedattribute = attribute;	/* Current PC video attributes */> 	savedattrib = attrib;		/* Current DEC character attributes */8 	saverelcursor = relcursor;	/* Cursor addressing mode */$ 	saveg0 = g0;			/* Character sets */
 	saveg1 = g1;  	saveg0g1 = g0g1;      }  }    static void  restorecurpos(int x) {?     if (saved == FALSE) {		/* Nothing saved, home the cursor */ ' 	lgotoxy(1, relcursor ? margintop : 1);  	return;     }  #ifdef COMMENTJ /*  Wrong!  Restoring the saved parameters does not unsave them.  -fdc  */     saved = FALSE; #endif /* COMMENT */4     lgotoxy(column, row);		/* Goto saved position */     if (x) {; 	attribute = savedattribute;	/* Restore saved attributes */  	attrib = savedattrib;@ 	relcursor = saverelcursor;	/* Restore cursor addressing mode */, 	g0 = saveg0;			/* Restore character sets */
 	g1 = saveg1;  	g0g1 = saveg0g1;      }  }    /*H   Hebrew keyboard-mode support functions.  These are needed when using aH   non-Hebrew keyboard to enter Hebrew letters during CONNECT mode.  WhenL   the keyboard is in "English" mode, the main keypad acts normally.  When itK   is in Hebrew mode, the lowercase letters (and some punctuation marks) are H   mapped to Hebrew letters.  Keyboard mode is set via the keyboard verbsA   \KkbHebrew and \KkbHebrew, and also by DECHEBM escape sequences G   (CSI ? 35 h / l) from the host (handled in vtescape()).  Both methods    invoke these routines.   */ static void 4 sethebrewmode() {			/* Enter Hebrew keyboard mode */ /*K   This is the WordPerfect / Windows / Microsoft Word mapping.  If different H   mappings are needed, we can add them via a parameter to this function,N   settable by a SET TERMINAL HEBREW-KEYMAP command.  Note that we don't changeK   the keymap by executing a macro (like MS-DOS Kermit's KEYBOARDS/KEYBOARDR N   macros) since that causes disconcerting and lengthy screen flashes as Kermit7   pops back and forth between CONNECT and command mode.  */9     keymap[ 39] =  44;			/* ' (Apostrophe) = , (Comma) */ .     keymap[ 44] = 154;			/* , (Comma) = Taw */6     keymap[ 46] = 149;			/* . (Period) = Final Zade */5     keymap[ 47] =  46;			/* / (Slash) = . (Period) */ :     keymap[ 59] = 147;			/* ; (Semicolon) = Terminal Pe */'     keymap[ 97] = 153;			/* a = Shin */ &     keymap[ 98] = 144;			/* b = Nun */&     keymap[ 99] = 129;			/* c = Bet */(     keymap[100] = 130;			/* d = Gimel */'     keymap[101] = 151;			/* e = Qoph */ '     keymap[102] = 139;			/* f = Kaph */ '     keymap[103] = 146;			/* g = Ayin */ &     keymap[104] = 137;			/* h = Yod */,     keymap[105] = 143;			/* i = Final Nun */'     keymap[106] = 135;			/* j = Chet */ (     keymap[107] = 140;			/* k = Lamed */-     keymap[108] = 138;			/* l = Final Kaph */ '     keymap[109] = 150;			/* m = Zade */ &     keymap[110] = 142;			/* n = Mem */,     keymap[111] = 141;			/* o = Final Mem */%     keymap[112] = 148;			/* p = Pe */ ,     keymap[113] =  47;			/* q = / (slash) */'     keymap[114] = 152;			/* r = Resh */ (     keymap[115] = 131;			/* s = Dalet */(     keymap[116] = 128;			/* t = Aleph */&     keymap[117] = 133;			/* u = Waw */%     keymap[118] = 132;			/* v = He */ 1     keymap[119] =  39;			/* w = ' (Apostrophe) */ )     keymap[120] = 145;			/* x = Samech */ &     keymap[121] = 136;			/* y = Tet */'     keymap[122] = 134;			/* z = Zain */      tt_hebrew = TRUE;      if (!roll.flag)        ipadl25() ;  }    static void 7 resethebrewmode() {			/* Enter English keyboard mode */  /*N   Warning: This routine assumes that main keypad keys (lowercase Roman letters;   and punctuation marks) are normally mapped to themselves.  */
     KEY k;'     keymap[39] = 39;			/* Apostrophe */ "     keymap[44] = 44;			/* Comma */#     keymap[46] = 46;			/* Period */ "     keymap[47] = 47;			/* Slash */&     keymap[59] = 59;			/* Semicolon */1     for (k = 97; k < 123; k++)		/* Letters a-z */        keymap[k] = k;     tt_hebrew = FALSE;     if (!roll.flag)        ipadl25() ;  }    /*H   The flow of characters from the communication device to the screen is:                                			   +---(debug)----+ 			   |              |/   rdcomwrtscr --> cwrite --+--> vt100 --> wrtch  			   |              | 			   +--> vtescape--+  J   rdcomwrtscr() reads character from communication device via ttinc() and:3    - converts 8-bit controls to 7-bit ESC sequences      - handles TELNET negotiations'    - handles SO/SI (NOTE: this prevents      - handles charset translation(    - handles newline-mode and cr-display    - handles connection loss(    - passes all output chars to cwrite()  
   cwrite()-    - handles debug output, direct to wrtch(). )    - detects and parses escape-sequences: *      . builds up escape sequence in buffer4      . when complete, calls vtescape(), or does APC.K    - when not debugging & not in esc seq, sends all other chars to vt100().   	   vt100() M    - handles ctrl chars in straightforward, modeless way (ENQ, tab, BS, beep) D    - *thinks* it handles SO/SI, but never gets called for this (???)H    - handles graphic chars via mode (g0, g1, vtgraphics, etc) -> wrtch()    - handles wraparound      vtescape()@    - acts on escape sequences, changes state, moves cursor, etc. */  I /*  V T E S C A P E  --  Interpret a VT52/100/102/220 escape sequence  */  /*A   Called after an escape sequence has been received and collected     into escbuffer[]. To be added:  $   ISO 2022 Character-set designation7   DEC national vs multinational character-set (DECNRCM)    Addition of G2, G3   Single shifts &   Locking shifts beyond SO/SI (G2, G3)   Soft character sets (DRCS)   User Defined Keys (DECUDK)  @   DECSTR    220   CSI ! p               Soft reset, keeps screenJ   DECSCL    220   CSI Pl; Pc " p        Set conformance level + soft resetD   DECSCA    220   CSI Ps " q            Select erasable/not erasable7   DECSEL    220   CSI ? Pn K            Selective erase    etc etc... */ static void  vtescape() {     unsigned char   j;     unsigned char   k;     unsigned char   l;!     unsigned char   blankcell[2];      int             i;     int             pn[11];      bool            private;      char            tempstr[20];     int             fore, back;   @     escstate = ES_NORMAL;		/* Set escape state back to normal */:     escnext = 1;			/* Point to beginning of esc seq buf */.     if (debses)				/* If TERMINAL DEBUG ON, */5       return;				/* we don't actually do anything. */ 6     achar = (escnext<=esclast)?escbuffer[escnext++]:0;%     if (screenon || (achar == '[')) {  	/* screen escape sequences  */ $ 	switch (achar) {		/* First Level */ 	case '[':			/* CSI */ 	    {4 		achar = (escnext<=esclast)?escbuffer[escnext++]:0;% 		switch (achar) {	/* Second level */ % 		case 'A':		/* Cursor up one line */  		    cursorup();  		    wrapit = FALSE;  		    break;' 		case 'B':		/* Cursor down one line */  		    cursordown();  		    wrapit = FALSE;  		    break;4 		case 'C':		/* Cursor forward, stay on same line */ 		    cursorright(); 		    if (dwl[wherey - 1]) 		      cursorright(); 		    break;1 		case 'D':		/* Cursor back, stay on same line */  		    cursorleft();  		    if (dwl[wherey - 1]) 		      cursorleft();  		    break;3 		case 'J':		/* Erase from cursor to end of scrn */  		    clreoscr_escape(); 		    break;3 		case 'K':		/* Erase from cursor to end of line */  		    clrtoeoln(); 		    break; 		case '?':		/* DEC private */ 		    private = TRUE; 8 		    achar = (escnext<=esclast)?escbuffer[escnext++]:0; 		    goto LB2001; 		case 'f':  		case 'H':	/* Cursor Home */ , 		    lgotoxy(1, relcursor ? margintop : 1); 		    break;, 		case 'g':	/* Tab Clear at this position */ 		    htab[wherex] = '0';  		    break; 		case '}': 9 		case 'm':	/* Normal Video - Exit all attribute modes */ # 		    attribute = defaultattribute;  		    attrib.blinking = FALSE; 		    attrib.bold = FALSE; 		    attrib.invisible = FALSE;   		    attrib.underlined = FALSE; 		    attrib.reversed = FALSE; 		    break; 		case 'r':		/* Reset Margin */  		    setmargins(1, ysize);  		    lgotoxy(1, 1); 		    break;2 		  case 's':		/* ANSI.SYS save cursor position */ 		    savecurpos(0); 		    break;5 		  case 'u':		/* ANSI.SYS restore cursor position */  		    restorecurpos(0);  		    break; 		case 'c':  		case 'h':  		case 'l':  		case 'n':  		case 'x':  		    pn[1] = 0; 		    private = FALSE; 		    k = 1; 		    goto LB2003;$ 		case ';':		/* As in ESC [ ; 7 m */ 		    pn[1] = 0; 		    private = FALSE; 		    k = 1; 		    goto LB2002; 		case 'L':  		case 'M':  		case '@':  		case 'P':  		    pn[1] = 1; 		    private = FALSE; 		    k = 1; 		    goto LB2002;" 		default:	/* Pn - got a number */ 		    private = FALSE; 	    LB2001:* 		    {		/* Esc [ Pn...Pn x   functions */ 			pn[1] = pnumber(&achar); 	 			k = 1; 	 		LB2002: ) 			while (achar == ';') {	/* get Pn[k] */ 9 			    achar = (escnext<=esclast)?escbuffer[escnext++]:0;  			    k++;  			    if (achar == '?'): 			     achar = (escnext<=esclast)?escbuffer[escnext++]:0; 			    pn[k] = pnumber(&achar);  			} 			pn[k + 1] = 1; 	 		LB2003: % 			switch (achar) { /* Third level */ % 			case 'A':	/* Cursor up Pn lines */  			    do {  				cursorup();  				wrapit = FALSE;  				pn[1] = pn[1] - 1; 			    } while (!(pn[1] <= 0)); 
 			    break; ' 			case 'B':	/* Cursor down pn lines */  			    do {  				cursordown();  				wrapit = FALSE;  				pn[1] = pn[1] - 1; 			    } while (!(pn[1] <= 0)); 
 			    break; ( 			case 'C':	/* Cursor right pn chars */ 			    do {  				cursorright(); 				if (dwl[wherey - 1]) 				    cursorright(); 				pn[1] = pn[1] - 1; 			    } while (pn[1] > 0); 
 			    break; , 			case 'D':	/* Cursor Left pn characters */ 			    do {  				cursorleft();  				if (dwl[wherey - 1]) 				    cursorleft();  				pn[1] = pn[1] - 1; 			    } while (pn[1] > 0); 
 			    break; ( 			case 'f':	/* Direct cursor address */ 			case 'H': 			    if (pn[1] == 0) 				pn[1] = 1; 			    if (relcursor)  				pn[1] += margintop - 1;  			    if (pn[1] > ysize)  			        pn[1] = ysize;  			    if (pn[2] == 0) 				pn[2] = 1; 			    if (dwl[pn[1] - 1]) { 				pn[2] = 2 * pn[2] - 1; 				if (pn[2] > xsize) 				    pn[2] = xsize - 1;  			    } else if (pn[2] > xsize) 				pn[2] = xsize; 			    wrapit = FALSE; 			    lgotoxy(pn[2], pn[1]); 
 			    break; $ 			case 'c':	/* Device Attributes */ 			    if (pn[1] == 0)1 			      if (tt_type >= 0 && tt_type <= max_tt) {   				  if (!network) msleep(100);( 				  sendescseq(tt_info[tt_type].x_id);
 			      }
 			    break;  			case 'g': 			    if (pn[1] == 3) { 				/* clear all tabs */ 				for (j = 1; j <=xsize; ++j)  				    htab[j] = '0'; 			    } else if (pn[1] == 0) ' 				/* clear tab at current position */  				htab[wherex] = '0'; 
 			    break;  			case 'h':	/* Set Mode */  			    for (j = 1; j <= k; ++j)  				if (private)* 				    switch (pn[j]) {	/* Field specs */ 				    case 1:	/* DECCKM  */  					tt_arrow = TTK_APPL;  					break; ( 				    case 2:	/* DECANM : ANSI/VT52 */ 					tt_type = my_tt_type; 					vt52graphics = FALSE; 					break; + 				    case 3:	/* DECCOLM = 132 Columns */  					deccolm = TRUE; 					clrscreen();  					break; - 				    case 4:	/* DECSCLM - Smooth scroll */  					break; . 				    case 5:	/* DECSCNM - Reverse screen */' 					if (decscnm) /* Already reverse */ 
 					  break; 	 					else  					  flipscreen(); 					break; - 				    case 6:	/* DECOM - Relative origin */  					relcursor = TRUE; 					lgotoxy(1, margintop);  					break; - 				    case 7:	/* DECAWM - Auto Wrap mode */  					tt_wrap = TRUE; 					break;  #ifdef COMMENT) 				    case 8:	/* DECARM - Autorepeat */  					break; ) 				    case 9:	/* DECINLM - Interlace */  					break;  #endif /* COMMENT */ #ifdef __32BIT__2 				    case 18:    /* DECPFF - Print Form Feed */ 					xprintff = TRUE;  					break; . 				    case 19:	/* DECPEX - Printer extent */+ 					printregion = FALSE; /* Full screen */  					break;  #endif /* __32BIT__ */, 				    case 25:   /* DECTCEM - Cursor On */ 					newcursor();  					cursorena = TRUE; 					break;  				    case 35: /* DECHEBM */% 					/* Enter Hebrew keyboard mode */  					sethebrewmode();  					break;  #ifdef COMMENT 				    case 38: /* DECTEK */ ) 					/* Enter Tektronix 4010/4014 mode */  					break;  				    case 42: /* DECNRCM */ 					/* Use 7-bit NRC */ 					break;  				    case 43: /* DECGEPM */' 					/* Graphics Expanded Print mode */  				    case 44: /* DECGPCM */$ 					/* Graphics Print Color mode */ 				    case 45: /* DECGPCS */, 					/* Graphics Print Color syntax = RGB */ 				    case 46: /* DECGPBM */) 					/* Graphics Print Background mode */  				    case 47: /* DECGRCM */& 					/* Graphics Rotated Print mode */ 					break;  #endif /* COMMENT */ 				    default: 					break;  				} else	/* Not private */ 				    switch (pn[j]) {% 				    case 2: /* Keyboard locked */  					keylock = TRUE; 					break; & 				    case 4: /* ANSI insert mode */ 					if (tt_type >= TT_VT102)  					  insertmode = TRUE;  					break; , 				    case 12:	/* SRM - Send Receive ON */" 					duplex = 0; /* Remote echo */ 					break;  				    case 20:( 					/* LNM - linefeed / newline mode */ 					tt_crd = tnlm = TRUE; 					break;  				    default: 					break; 	 				    } 
 			    break;  			case 'l':	/* Reset Mode */ 6 			    for (j = 1; j <= k; ++j) /* Go thru all pn's */ 				if (private), 				    switch ((pn[j])) {	/* Field specs */. 				    case 1:	/* DECCKM - Cursor key mode */ 					tt_arrow = TTK_NORM;  					break; ( 				    case 2:	/* DECANM : ANSI/VT52 */ 					tt_type = TT_VT52;  					vt52graphics = FALSE; 					break; * 				    case 3:	/* DECCOLM - 80 Columns */ 					deccolm = FALSE;  					clrscreen();  					break; . 				    case 4:	/* DECSCLM - Jump scrolling */ 					break; - 				    case 5:	/* DECSCNM - Normal screen */ ( 					if (!decscnm) /* Already normal? */
 					  break; 	 					else  					  flipscreen(); 					break; - 				    case 6:	/* DECOM - Absolute origin */  					relcursor = FALSE;  					lgotoxy(1, 1);  					break; ( 				    case 7:	/* DECAWM - Auto wrap */ 					tt_wrap = FALSE;  					break;  #ifdef COMMENT* 				    case 8:	/* DECARM - Auto repeat */ 					break; ) 				    case 9:	/* DECINLM - Interlace */  					break;  #endif /* COMMENT */ #ifdef __32BIT__2 				    case 18:    /* DECPFF - Print Form Feed */ 					xprintff = FALSE; 					break; , 				    case 19:	/* DECPEX - Print extent */% 					printregion = TRUE; /* Region */  					break;  #endif /* __32BIT__ */- 				    case 25:   /* DECTCEM - Cursor Off */  					if (cursorena)  					  killcursor(); 					cursorena = FALSE;  					break;  				    case 35: /* DECHEBM */& 					/* Enter English keyboard mode */ 					resethebrewmode();  					break;  #ifdef COMMENT 				    case 38: /* DECTEK */ ( 					/* Exit Tektronix 4010/4014 mode */ 					break;  				    case 42: /* DECNRCM */+ 					/* Use 8-bit multinational char set */  					break;  				    case 43: /* DECGEPM */% 					/* Graphics Normal Print mode */  				    case 44: /* DECGPCM */) 					/* Graphics Print Monochrome mode */  				    case 45: /* DECGPCS */, 					/* Graphics Print Color syntax = HLS */ 				    case 46: /* DECGPBM */, 					/* Graphics Print No-Background mode */ 				    case 47: /* DECGRCM */( 					/* Graphics Unrotated Print mode */ 					break;  #endif /* COMMENT */ 				    default: 					break;  				} else	/* Not private */ 				    switch (pn[j]) {' 				    case 2:	/* Keyboard unlocked */  					keylock = FALSE;  					break; & 				    case 4:	/* ANSI insert mode */ 					insertmode = FALSE; 					break; - 				    case 12:	/* SRM - Send Receive OFF */ ! 					duplex = 1; /* Local echo */  					break;  				    case 20:( 					/* LNM - linefeed / newline mode */ 					tt_crd = tnlm = FALSE;  					break;  				    default: 					break; 	 				    } 
 			    break;  			case 'i':	/* Media Copy */  #ifdef __32BIT__ /*;   This code crashes the 16-bit version with Stack Overflow. H   Print-Whole-Screen & Print-Cursor-Line support added in edit 190, fdc. */0 			    if (pn[1] == 0)  /* Print whole screen */+ 			      prtscreen(printregion?margintop:1, " 					printregion?marginbot:ysize);6 			    else if (pn[1] == 1 &&  /* Print cursor line */7 			             private == TRUE) /* Only if ESC [?1i */ " 			      prtscreen(wherey,wherey); /*  I   For pn = 4 or 5, we should differentiate here between transparent print J   (private == FALSE) and autoprint (private == TRUE).  As presently coded,J   we always do transparent print.  Autoprint means that the current screenI   line is printed as soon as the cursor leaves it, i.e. when the terminal D   receives a linefeed, form feed, or vertical tab, or when it wraps. */ 			    else if (pn[1] == 4) {  				turnoffprinter = TRUE; 				xprint = FALSE;  			    } else if (pn[1] == 5) ' 			      turnonprinter = xprint = TRUE;   L /*  6 and 7 are not in the VT102 manual.  Maybe in the Scottish version?  */  9 			    else if (pn[1] == 6) /* Turn off screen display */  			      screenon = FALSE;8 			    else if (pn[1] == 7) /* Turn on screen display */ 			      screenon = TRUE;  #endif /* __32BIT__ */
 			    break;  			case 'q':		/* Load LEDs */  			    break;		/* (nothing) */ 			case 'n':( 			    /* Pages 103-104, VT220 manual */4 			    if (pn[1] == 5) 	/* Terminal Status Report */1 			      sendescseq("[0n"); 	/* Terminal is OK */ : 			    else if (pn[1] == 6) { /* Cursor position report */ #ifndef __32BIT__  /*J   16-bit version must use a hand-coded in-line version of sprintf to avoidG   the function call that would crash the program with a stack overflow. 5   Handles numbers 0 - 999.  No range checking.  - fdc  */ 				int i = 0, j;  				tempstr[i++] = '[';  				if ((j = wherey / 100) > 0) % 				  tempstr[i++] = (char) (j + 48); ( 				if ((j = (wherey % 100) / 10) > 0 || 				    wherey > 99)% 				  tempstr[i++] = (char) (j + 48);   				if ((j = wherey % 10) > 0 || 				    wherey > 9) % 				  tempstr[i++] = (char) (j + 48);  				tempstr[i++] = ';';  				if ((j = wherex / 100) > 0) % 				  tempstr[i++] = (char) (j + 48); ( 				if ((j = (wherex % 100) / 10) > 0 || 				    wherex > 99)% 				  tempstr[i++] = (char) (j + 48);   				if ((j = wherex % 10) > 0 || 				    wherex > 9) % 				  tempstr[i++] = (char) (j + 48);  				tempstr[i++] = 'R';  				tempstr[i] = '\0'; 				sendescseq(tempstr); #else . /* 32-bit version can call sprintf() here.  *// 				sprintf(tempstr,"[%d;%dR", wherey, wherex);  				sendescseq(tempstr); #endif /* __32BIT__ */  			    } else if (pn[1] == 15) { 				/* DECDSR Printer status */ / 				sendescseq("[?10n"); /* Printer is ready */   			    } else if (pn[1] == 26) {, 				/* DECDSR Keyboard language, UK or US */# 				sendescseq((g0 == (CHAR) 'A') ?  					"[?27;2n" : 					"[?27;1n" );   			    } else if (pn[1] == 25) {3 				/* DECDSR UDK status; 20=unlocked, 21=locked */  				sendescseq("[?21n"); 			    }
 			    break; : 			case 'x': /* DECREQTPARM Request Terminal Parameters */ 			    if (pn[1] > 1) 
 				break; 			    tempstr[0] = '[';- 			    tempstr[1] = (pn[1] == 0) ? '2' : '3';  			    tempstr[2] = ';';( 			    tempstr[5] = '2'; /* Nbits = 7 */ 			    switch (parity) {			      			      case 0:) 				tempstr[3] = '1'; /* Parity = None */ , 				/* Nbits depends on TERMINAL BYTESIZE */ 				if (cmask == 0xFF)' 				  tempstr[5] = '1'; /* Nbits = 8 */ 
 				break; 			      case 'e':) 				tempstr[3] = '5'; /* Parity = Even */ 
 				break; 			      case 'o':( 				tempstr[3] = '4'; /* Parity = Odd */
 				break; 			      case 'm':) 				tempstr[3] = '3'; /* Parity = Mark */ 
 				break; 			      default: * 				tempstr[3] = '2'; /* Parity = Space */
 				break; 			    } 			    tempstr[4] = ';'; 			    switch (speed) {  			    case 50: 
 				i = 0;
 				break; 			    case 75: 
 				i = 8;
 				break; 			    case 110: 				i = 16; 
 				break; 			    case 133: 				i = 14; 
 				break; 			    case 150: 				i = 32; 
 				break; 			    case 200: 				i = 40; 
 				break; 			    case 300: 				i = 48; 
 				break; 			    case 600: 				i = 56; 
 				break; 			    case 1200:  				i = 64; 
 				break; 			    case 1800:  				i = 72; 
 				break; 			    case 2000:  				i = 80; 
 				break; 			    case 2400:  				i = 88; 
 				break; 			    case 3600:  				i = 96; 
 				break; 			    case 4800:  				i = 104;
 				break; 			    case 9600:  				i = 112;
 				break; 			    case 19200: 				i = 120;
 				break; 			    default:  				i = 128;
 				break; 			    } #ifndef __32BIT__  /*%   Hand-coded sprintf() again.  - fdc.  */ 			    {
 				int x, j; 
 				x = i;
 				i = 6; 				tempstr[i++] = ';';  				if ((j = x / 100) > 0)% 				  tempstr[i++] = (char) (j + 48); ( 				if ((j = (wherey % 100) / 10) > 0 || 				    wherey > 99)% 				  tempstr[i++] = (char) (j + 48);   				if ((j = wherey % 10) > 0 || 				    wherey > 9) % 				  tempstr[i++] = (char) (j + 48);  				tempstr[i++] = ';';  				if ((j = x / 100) > 0)% 				  tempstr[i++] = (char) (j + 48); ( 				if ((j = (wherey % 100) / 10) > 0 || 				    wherey > 99)% 				  tempstr[i++] = (char) (j + 48);   				if ((j = wherey % 10) > 0 || 				    wherey > 9) % 				  tempstr[i++] = (char) (j + 48);  				tempstr[i++] = ';';  				tempstr[i++] = '1';  				tempstr[i++] = ';';  				tempstr[i++] = '0';  				tempstr[i++] = 'x';  				tempstr[i++] = '\0'; 			    } #else 1 			    sprintf(&tempstr[6], ";%d;%d;1;0x", i, i);  #endif /* __32BIT__ */ 			    sendescseq(tempstr); 
 			    break; 1 			case 'm':	/* Select Graphic Rendition (SGR) */  			case '}':	/* (Why this?) */6 			    for (j = 1; j <= k; ++j) /* Go thru all Pn's */* 				switch ((pn[j])) {   /* This one... */. 				case 0:	/* Set all attributes to normal */% 				    attribute = defaultattribute;   				    attrib.blinking = FALSE; 				    attrib.bold = FALSE;! 				    attrib.invisible = FALSE; " 				    attrib.underlined = FALSE;  				    attrib.reversed = FALSE; 				    break; 				case 1:	/* Turn on BOLD */! 				    /* No colors involved. */ , 				    if (attrib.bold) /* Already bold? */ 				      break;0 				    attribute ^= 8;  /* No, flip the bit. */* 				    attrib.bold = TRUE; /* Remember */ 				    break;# 				case 4:	/* Turn on UNDERLINE */   				    /* Simulated by color */ 				    if (attrib.underlined) 				      break;! 				    attrib.underlined = TRUE;  #ifdef COMMENT3 				    attribute = (attribute & (unsigned) 0x80) | " 				      (colorunderline & 0x7F); #else # 				    attribute = colorunderline; 0 				    if (attrib.bold) /* If currently bold */0 				      attribute ^= 0x08; /* flip bold bit */. 				    if (attrib.blinking) /* If blinking */1 				      attribute ^= 0x80; /* flip blink bit */  #endif /* COMMENT */ 				    if (attrib.reversed), 				      attribute = swapcolors(attribute); 				    break;#     				case 5:	/* Turn on BLINK */ 0 				    /* Simulated by background intensity) */ 				    if (attrib.blinking) 				      break; 				    attrib.blinking = TRUE; % 				    attribute ^= (unsigned) 0x80;  				    break;' 				case 7:	/* Turn on REVERSE VIDEO */  				    if (attrib.reversed) 				      break; 				    attrib.reversed = TRUE; * 				    attribute = swapcolors(attribute); 				    break;# 				case 8:	/* Turn on INVISIBLE */ 2 				    attrib.invisible = TRUE; /* (see wrtch) */ 				    break;  % 				/* 22-27 are VT220 extensions. */     				case 22: /* Turn BOLD Off */  			            if (!attrib.bold) 				      break; 				    attrib.bold = FALSE; 				    attribute ^= 8;  				    break;% 				case 24: /* Turn UNDERLINE Off */  				    if (!attrib.underlined)  				      break;" 				    attrib.underlined = FALSE;( 				    /* Go back to normal coloring */ #ifdef COMMENT2 				    attribute = (attribute & (unsigned)0x80) | 				      (colornormal & 0x7F);  #else % 				    attribute = defaultattribute; 0 				    if (attrib.bold) /* If currently bold */0 				      attribute ^= 0x08; /* flip bold bit */. 				    if (attrib.blinking) /* If blinking */1 				      attribute ^= 0x80; /* flip blink bit */  #endif /* COMMENT */ 				    if (attrib.reversed), 				      attribute = swapcolors(attribute);   				    break;%     				case 25: /* Turn BLINK Off */  				    if (!attrib.blinking)  				      break;  				    attrib.blinking = FALSE;$ 				    attribute ^= (unsigned)0x80; 				    break;) 				case 27: /* Turn REVERSE VIDEO Off */  				    if (!attrib.reversed)  				      break;  				    attrib.reversed = FALSE;* 				    attribute = swapcolors(attribute); 				    break;$ 				case 28:/* Turn INVISIBLE Off */! 				    attrib.invisible = FALSE;  				    break;   				case 30: /* Colors */  				case 31: 				case 32: 				case 33: 				case 34: 				case 35: 				case 36: 				case 37:% 				    /* Select foreground color */  				    if (decscnm) { 					i = (attribute & 0x8F); 					l = sgrcols[pn[j] - 30]; " 					attribute = (i | ((l << 4))); 				    } else { 					i = (attribute & 0xF8);+ 					attribute = (i | sgrcols[pn[j] - 30]); 	 				    }  				    break; 				case 40: 				case 41: 				case 42: 				case 43: 				case 44: 				case 45: 				case 46: 				case 47:% 				    /* Select background color */  				    if (!decscnm) {  					i = (attribute & 0x8F); 					l = sgrcols[pn[j] - 40]; " 					attribute = (i | ((l << 4))); 				    } else { 					i = (attribute & 0xF8);+ 					attribute = (i | sgrcols[pn[j] - 40]); 	 				    }  				    break; 				default: 				    break; 				} 
 			    break; 0 			case 'r':	/* Set margin (scrolling region) */# 			    if ((k < 2) || (pn[2] == 0))  				pn[2] = ysize; 			    if (pn[1] == 0) 				pn[1] = 1; 			    if ((pn[1] > 0) &&  				(pn[1] < pn[2]) && 				(pn[2] <= ysize)) {  				setmargins(pn[1], pn[2]); * 				lgotoxy(1, relcursor ? margintop : 1); 			    }
 			    break;  			case 'J':	/* Clear screen */  			    switch ((pn[1])) { + 			    case 0:	/* Clear to end of screen */  				clreoscr_escape();
 				break;' 			    case 1:	/* Clear to beginning */  				clrboscr_escape();
 				break;( 			    case 2:	/* Clear whole screen */ + 				if (tt_type != TT_ANSI) { /* DEC ... */  				    int sx, sy; ! 				    sx = wherex; sy = wherey; / 				    clrscreen(); /* Cursor does not move */  				    lgotoxy(sx,sy); ( 				} else { /* ANSI homes the cursor */ 				    clrscreen(); 				} 
 				break; 			    default: 
 				break; 			    }
 			    break;  			case 'K':	/* Clear line */  			    switch ((pn[1])) { ) 			    case 0:	/* Clear to end of line */  				clrtoeoln();
 				break;' 			    case 1:	/* Clear to beginning */  				clrbol_escape();
 				break;, 			    case 2:	/* Clear whole cursor line */ 				clrline_escape(); 
 				break; 			    default: 
 				break; 			    }
 			    break;  			case 'L':	/* Insert lines */ # 			    for (i = 1; i <= pn[1]; ++i) 3 				scroll(DOWNWARD, wherey - 1, marginbot - 1, 1); 
 			    break;  			case 'M':	/* Delete lines */ # 			    for (i = 1; i <= pn[1]; ++i) 1 				scroll(UPWARD, wherey - 1, marginbot - 1, 1); 
 			    break; $ 			case '@':	/* Insert characters */ 			    blankcell[0] = ' ';  			    blankcell[1] = attribute;( 			    pn[1] *= dwl[wherey - 1] ? 2 : 1;& 			    if (pn[1] > xsize + 1 - wherex) 				pn[1] = xsize + 1 - wherex;  #ifdef OS2MOUSE  			    os2_mousehide() ; #endif /* OS2MOUSE */  			    VioScrollRt(wherey - 1, 					wherex - 1, 					wherey - 1, 					xsize - 1,  					pn[1],  					blankcell,  					0 					);  #ifdef OS2MOUSE  			    os2_mouseshow() ; #endif /* OS2MOUSE */ 
 			    break;  			case 'P':	/* DeleteChar */  			    blankcell[0] = ' ';  			    blankcell[1] = attribute;( 			    pn[1] *= dwl[wherey - 1] ? 2 : 1;& 			    if (pn[1] > xsize + 1 - wherex) 				pn[1] = xsize + 1 - wherex;  #ifdef OS2MOUSE  			    os2_mousehide() ; #endif /* OS2MOUSE */  			    VioScrollLf(wherey - 1, 					wherex - 1, 					wherey - 1, 					xsize - 1,  					pn[1],  					blankcell,  					0 					);  #ifdef OS2MOUSE  			    os2_mouseshow() ; #endif /* OS2MOUSE */ 
 			    break;  			default: 
 			    break;  			} 		    }  		    break; 		} " 	    }			/* Left square bracket */ 	    break; 5 	case '7':		/* Save cursor position and attributes */  	    savecurpos(1);  	    break; 8 	case '8':		/* Restore Cursor Position and attributes */ 	    restorecurpos(1); 	    break; 
 	case 'A':/ 	    if (tt_type == TT_VT52)	/* VT52 control */  	      cursorup(); 	    break; 
 	case 'B':/ 	    if (tt_type == TT_VT52)	/* VT52 control */  	      cursordown(); 	    break; 
 	case 'C':/ 	    if (tt_type == TT_VT52)	/* VT52 control */  	      cursorright();  	    break; 
 	case 'D':/ 	    if (tt_type == TT_VT52)	/* VT52 control */  	      cursorleft(); 	    else {			/* Index */  		if (wherey == marginbot) {< 		    toplinetocyclicbuffer(); /* Save in rollback buffer */6 		    scroll(UPWARD, margintop - 1, marginbot - 1, 1); 		} else 		  cursordown();  	    } 	    break;  	case 'E':			/* Next Line */ 	    wrtch(13);  	    wrtch(10);  	    break; 
 	case 'F':/ 	    if (tt_type == TT_VT52)	/* VT52 control */  	      vt52graphics = TRUE;  	    break; 
 	case 'G':/ 	    if (tt_type == TT_VT52)	/* VT52 control */  	      vt52graphics = FALSE; 	    break; 
 	case 'H': 	    if (tt_type >= TT_VT100) {  		/* Set Tab Stop */ 		htab[wherex] = 'T';  	    } 	    /* Set Tab Stop */ 	 	    else  		lgotoxy(1, 1); 	    /* VT52 control */  	    break; ) 	case 'I':			/* Reverse Linefeed, VT52 */ ' 	case 'M':			/* Reverse Index, VT102 */ 1 	    if ((tt_type == TT_VT52  && achar == 'I') || * 		(tt_type >= TT_VT100 && achar == 'M')) {7 		if (margintop == wherey) /* "==", not ">="!  - fdc */ 6 		  scroll(DOWNWARD, margintop - 1, marginbot - 1, 1); 		else 		  cursorup();  		break; 	    } 	    break; 
 	case 'J': 	    if (tt_type == TT_VT52) 	      /* VT52 control */  	      clreoscr_escape();  	    break; 
 	case 'K': 	    if (tt_type == TT_VT52) 	      /* VT52 control */  	      clrtoeoln();  	    break;  #ifdef __32BIT__ /*H   VT52 printer controls.  For now, autoprint is treated like transparentJ   print.  32-bit version only, to avoid stack overflows in 16-bit version.   Edit 190, fdc. */% 	case 'V':			/* Print cursor line */  / 	    if (tt_type == TT_VT52)	/* VT52 control */   	      prtscreen(wherey,wherey); 	    break;  	case ']':			/* Print screen */ / 	    if (tt_type == TT_VT52)	/* VT52 control */  	      prtscreen(1,ysize); 	    break; ' 	case 'W':			/* Transparent print on */  	case '^':			/* Autoprint on */ / 	    if (tt_type == TT_VT52)	/* VT52 control */ % 	      turnonprinter = xprint = TRUE;  	    break; ( 	case 'X':			/* Transparent print off */  	case '_':			/* Autoprint off */1 	    if (tt_type == TT_VT52) {	/* VT52 control */  		turnoffprinter = TRUE; 		xprint = FALSE;  	    } 	    break;  #endif /* __32BIT__ */( 	case 'Y':			/* Direct cursor address */1 	    if (tt_type == TT_VT52) {	/* VT52 control */ 4 		achar = (escnext<=esclast)?escbuffer[escnext++]:0; 		row = achar - 31; 4 		achar = (escnext<=esclast)?escbuffer[escnext++]:0; 		column = achar - 31; 		lgotoxy(column, row);  	    } 	    break; , 	case 'Z':			/* DECID - Identify Terminal */- 	    if (tt_type >= 0 && tt_type <= max_tt) {  		if (!network) msleep(100);$ 		sendescseq(tt_info[tt_type].x_id); 	    } 	    break; 
 	case 'c': 	    /* Reset */ 	    doreset(1); 	    break; 
 	case '#': 	    /* Esc # sequence */ 7 	    achar = (escnext<=esclast)?escbuffer[escnext++]:0;  	    switch (achar) {  	    case '3': 		decdwl_escape(TRUE); 		break; 	    case '4': 		decdwl_escape(TRUE); 		break; 	    case '5': 		decdwl_escape(FALSE);  		break; 	    case '6': 		decdwl_escape(TRUE); 		break;  	    case '8':			/* Self Test */ 		{  		    char cell[2];  		    cell[0] = 'E'; 		    cell[1] = 7; 		    /* Self Test */  #ifdef OS2MOUSE  		    os2_mousehide() ;  #endif /* OS2MOUSE */ ' 		    VioWrtNCell(cell, 1920, 0, 0, 0);  #ifdef OS2MOUSE  		    os2_mouseshow() ;  #endif 		    setmargins(1, ysize);  		    lgotoxy(1, 1); 		}  		break;
 	    default:  		break; 	    } /* Esc # sequence */  	    break;   # 	case '=':			/* Application mode */  	    tt_keypad = TTK_APPL; 	    break;  	case '>':			/* Numeric mode */  	    tt_keypad = TTK_NORM; 	    break; " 	case '<':			/* Enter ANSI mode */ 	    /* VT52 control */  	    if (tt_type == TT_VT52) 	      tt_type = my_tt_type; 	    break; 
 	case '(':7 	    achar = (escnext<=esclast)?escbuffer[escnext++]:0;  	    g0 = achar; 	    break; 
 	case ')':7 	    achar = (escnext<=esclast)?escbuffer[escnext++]:0;  	    g1 = achar; 	    break; 	 	case SP: 7 	    achar = (escnext<=esclast)?escbuffer[escnext++]:0;  	    if (tt_type >= TT_VT220) {  		if (achar == 'F')	/* S7C1T */  		  send_c1 = FALSE;$ 		else if (achar == 'G')	/* S8C1T */& 		  if (c1controls && (cmask == 0xFF)) 		    send_c1 = TRUE;  	    } 	    break; 	 	default: ) 	    if (achar == 12) {		/* ESC Ctrl-L */  		lgotoxy(1, 1); 		clrscreen(); 	    } 	    break;  	} /* First Level Case  */$     } /* Screen escape sequences  */  ( /* Host said to turn off the printer. */     if (turnoffprinter) {        printeroff();        turnoffprinter = FALSE;    }   3 /* If printer is on, print this escape sequence. */        if (printon) { 	fprintf(lst, "%c", 27); 	if (esclast > 0) {  	    /* print esc sequence */ # 	    for (i = 1; i <= esclast; ++i) ( 	      fprintf(lst, "%c", escbuffer[i]); 	}     }  /*C   If we just got a "printer on" directive, turn on the printer now. =   This way, the "printer on" directive itself is not printed.  */=     if (turnonprinter) {		/* Last command was "printer on" */ 
 	printeron();  	turnonprinter = FALSE;      }  }   H /* ================================================================== */H /* VT100  -  emulate a DEC VT terminal writing a character            */H /* ================================================================== */ static void  vt100(unsigned char vtch) {      int             i, j;      char           *s, str[2];       if (tt_type == TT_NONE) { 
 	wrtch(vtch);  	return;     } else if (screenon) {) 	if (vtch < 32) {	/* Control Character */ B 	    achar = vtch;	/* Let the rest of this module see the value */ 	    switch (achar) {   	      case FF:			/* Formfeed */ 		if (tt_type == TT_ANSI) {  		    clrscreen(); 		    break; 		} /* else fall thru... */   	      case LF:			/* Linefeed */$ 	      case 11:			/* Vertical tab */ 		wrtch((char) LF);  		break;' 	      case CR:			/* Carriage return */  		wrtch((char) achar); 		break; #ifdef COMMENT /* This is just plain wrong. */  	      case 27:			/* ESC */ 
 		vtescape();  		break; #endif /* COMMENT */   	      case 14:			/* SO */: 		if (tt_type != TT_ANSI)	/* "ANSI music" protection... */ 		  g0g1 = &g1;  		break;   	      case 15:			/* SI */- 		if (tt_type != TT_ANSI)	/* Ditto, gag... */  		  g0g1 = &g0;  		break;   	      case 8:			/* BS */  		wrtch((char) achar); 		break;   	      case 7:			/* BEL */
 		bleep(); 		break;   	      case 5:			/* ENQ */ 		if (tt_answer) { 		    int x;, 		    x = (tt_pacing > -1) ? tt_pacing : 50; 		    s = answerback;  		    while (*s) {$ 			if (x > 0 && !network) msleep(x); 			sendchar(*s++); 		    }  		}  		break;$ 	      case 9:		/* Horizontal tab */ 		j = dwl[wherey - 1] ? 2 : 1;
 		i = wherex; / 		if (j == 2 && htab[(i - 1) / j + 1] == 'T') { 
 		    i++; 		    cursorright(); 		}  		if (i < xsize)
 		    do { 			i++;  			cursorright(); 0 		    } while ((htab[(i - 1) / j + 1] != 'T') && 			     (i <= xsize - j)); 		break;  	      default:		/* ignore it */ 		break; 	    }# 	    /* End of Control Character */ 	 	} else { 0 	    if (vtch != DEL) {		/* Normal character. */ 		if (tt_type >= TT_VT100) {= 		    if (*g0g1 == 'A' && tcsr == FC_USASCII && vtch == 35) { : 			/* UK ISO 646 character-set, # = Pound Sterling Sign */ 			vtch = 156;8 		    } else if ((*g0g1 == '0') && /* VT graphics set */* 			       (95 <= vtch) && (vtch <= 126)) { 			literal = TRUE;  			vtch = graphicset[vtch - 95]; 		    } 
 		} else {: 		    if (vt52graphics && (95 <= vtch) && (vtch <= 126)) { 			literal = TRUE;  			vtch = graphicset[vtch - 95]; 		    }  		}  		/* On the right margin? */8 		if (wherex != (dwl[wherey - 1] ? xsize - 1 : xsize)) {, 		    wrtch(vtch);	/* Not on right margin */2 		    if (dwl[wherey-1])	/* Write the character */3 			wrtch(' ');	/* Handle double-width characters */  		    wrapit = FALSE; " 		} else {		/* On right margin. */( 		    if (wrapit) {	/* Time to wrap?  */9 			if (marginbot <= wherey) { /* Scroll if bottom line */ : 			    toplinetocyclicbuffer(); /* Save in rollback buf */7 			    scroll(UPWARD, margintop - 1, marginbot - 1, 1); 5 			    lgotoxy(1, wherey);	/* Go to new bottom row */ , 			} else		/* Not bottom line, just wrap. */3 			    lgotoxy(1, wherey + 1); /* Go to next row */ - 			wrtch(vtch);	/* Now write the character */ 7 			if (dwl[wherey - 1]) /* Take care of double-width */  			    wrtch(' ');2 			wrapit = FALSE;	/* Remember wrapping is done */& 		    } else {		/* Not time to wrap */4 			i = dwl[wherey - 1] ? 2 : 1; /* Write the char */ 			str[0] = vtch;  			str[1] = ' '; #ifdef OS2MOUSE  			os2_mousehide() ; #endif /* OS2MOUSE */  			VioWrtCharStrAtt(&vtch, i,  					 wherey - 1,  					 xsize - i, 					 &attribute, 	 					 0);  #ifdef OS2MOUSE  			os2_mouseshow() ; #endif 			literal = FALSE; 3 			if ((tt_wrap && !deccolm)) /* If TERM WRAP ON */ 2 			    wrapit = TRUE; /* need to wrap next time */ 		    }  		}  	    }			/* Normal char */ 	}     }       if (printon && (vtch != 27))       fprintf(lst, "%c", vtch);  }   # /* Save current status of screen */  void3 savescreen(ascreen *scrn, int wherex, int wherey) { '     USHORT n = xsize * (ysize + 1) * 2; &     debug(F101,"x_save scrn","",scrn);*     debug(F101,"x_save wherex","",wherex);*     debug(F101,"x_save wherey","",wherey);     scrn->ox = wherex;     scrn->oy = wherey;     scrn->att = attribute; #ifdef OS2MOUSE      os2_mousehide() ;  #endif:     VioReadCellStr((char *) (scrn->scrncpy), &n, 0, 0, 0); #ifdef OS2MOUSE      os2_mouseshow() ;  #endif }    /* Restore a saved screen */ restorescreen(ascreen *scrn) {?     movetoscreen(scrn->scrncpy, 1, 1, xsize * (ysize + 1) * 2);      attribute = scrn->att;     wherey = scrn->oy;     wherex = scrn->ox;&     debug(F101,"x_rest scrn","",scrn);*     debug(F101,"x_rest wherex","",wherex);*     debug(F101,"x_rest wherey","",wherey);     lgotoxy(wherex, wherey); }   
 #ifdef M_I286 " /* Avoid 16-bit stack overflows */# #define logchar(c) zchout(ZSFILE,c)  #else  static void  logchar(char c) {      if (zchout(ZSFILE,c) < 0) {  	conoll("");2 	conoll("ERROR WRITING SESSION LOG, LOG CLOSED!"); 	seslog = 0;     }  }  #endif /* M_I286 */   
 static int sendchar(CHAR c) { #ifndef NOTTOCI  /*N    NOTE: ttoci() uses an ioctl() that has been observed to hang, inexplicably,N    on some systems (e.g. high-end PS/2s that haven't been rebooted in a month,I    and have been going back and forth between SLIP and Kermit.)  In fact, L    this was reported only once, and rebooting the system made the problem go    away.  I    A NEWER NOTE: As of 8 May 94, ttoci() uses DosWrite, but first does an K    ioctl() to make sure the connection is OK.  Hopefully, this combines the L    the benefits of both methods: failure detection, buffering, flow control. */     int x, i = 0;      long wait = 0; /*J   Send a character to the serial line in immediate mode, checking to avoidO   overwriting a character already waiting to be sent.  If we fail, e.g. because L   FLOW is RTS/CTS and CTS is not on (like when modems are retraining), enter'   a retry loop up to the timeout limit.  */9     x = ttoci(dopar(c));		/* Try to send the character */ (     if (x) {				/* Transmission error */ 	KEY k; 
 	int w, oldw;   * 	debug(F101,"sendchar blocked char","",c);4 	oldw = 0;			/* For updating status line once/sec */4 	save_status_line();		/* Save current status line */           do {# 	    w = (waittime - wait) / 1000L; ; 	    if (w != oldw) {		/* Countdown timer in status line */  		oldw = w; 3 		sprintf(usertext, " TRANSMISSION BLOCKED: %d",w);  		helptext[0] = '\0';  		line25();  	    }7 	    if (conchk() > 0) {		/* Is a keystroke waiting? */  		k = congks(0);		/* Read it */ - 		k = keymap[k];		/* Get value from keymap */ ! 		debug(F101,"BLOCKED key","",k); > 		if (k == (F_KVERB | K_EXIT)) { /* Let them escape back... */$ 		    active = FALSE;	/* this way */ 		    return 0; - 		} else if (k == escape) { /* or this way */  		    k = congks(0); 		    k = keymap[k];1 		    if ((k == 'c') || (k == 'C') || (k == 3)) {  			active = FALSE; 			return 0; 		    } else bleep(); 2 		} else bleep();		/* Anything else, just beep. */ 	    }+ 	    DosSleep(INTERVAL);		/* Sleep a bit */ ; 	    wait += INTERVAL;		/* Go round till limit exhausted */ 1 	    x = ttoci(dopar(c));	/* Try to send again */ ) 	} while ((x != 0) && (wait < waittime));  	restore_status_line();      } A     if (wait >= waittime) {		/* Go back to prompt if we failed */ D 	while (conchk() > 0) congks(0);	/* Flush any remaining typeahead */ 	active = FALSE;
 	if (network)  	  sprintf(termessage,8 		  "Can't transmit to network, error status: %d\n", x); 	else { @ 	    sprintf(termessage,"Serial port blocked%s%s%s%s%s%s%s%s\n",  		    ( x & TX_WAITING_FOR_CTS )4 		    ? "\nTx waiting for CTS to be turned ON" : "",  		    ( x & TX_WAITING_FOR_DSR )4 		    ? "\nTx waiting for DSR to be turned ON" : "",  		    ( x & TX_WAITING_FOR_DCD )4 		    ? "\nTx waiting for DCD to be turned ON" : "",  		    ( x & TX_WAITING_FOR_XON )2 		    ? "\nTx waiting because XOFF received" : "",$ 		    ( x & TX_WAITING_TO_SEND_XON )5 		    ? "\nTx waiting because XOFF transmitted" : "", ' 		    ( x & TX_WAITING_WHILE_BREAK_ON ) 7 		    ? "\nTx because BREAK is being transmitted" : "", $ 		    ( x & TX_WAITING_TO_SEND_IMM ); 		    ? "\nCharacter waiting to transmit immediately" : "",   		    ( x & RX_WAITING_FOR_DSR )7 		    ? "\nRx waiting for DSR to be turned ON" : "" ) ;  	}     }  #else /* NOTTOCI is defined */ /*F   On the other hand, using DosWrite() (via ttoc()) makes C-Kermit hangH   if modem signals are not just right, plus we can't handle CTS blockage.   this way, nor do we get the OS/2 error code. */     if (ttoc(dopar(c)) < 0) {  	active = FALSE;- 	sprintf(termessage,"Can't transmit to %s\n", ' 		network ? "network" : "serial port");      }  #endif /* NOTTOCI */    return 0; }   
 static int# sendcharduplex(unsigned char key) {      unsigned char csave;  3     key &= cmdmsk;			/* Do any requested masking */      csave = key;  @     if (outesc == ES_NORMAL) {		/* If not inside escape seq.. */# 					/* Translate character sets */ 9 	if (sxo) key = (*sxo)(key);	/* Local to intermediate. */ : 	if (rxo) key = (*rxo)(key);	/* Intermediate to remote. */     } /     if (oskipesc) outesc = chkaes(outesc, key); 3     /* Check output (key) escape sequence status */   /     if (sosi) {				/* Shift-In/Out selected? */ 2 	if (cmask == 0177) {		/* In 7-bit environment? */. 	    if (key & 0200) {		/* 8-bit character? */, 		if (outshift == 0) {	/* If not shifted, */  		    sendchar(SO);	/* shift. */ 		    outshift = 1;  		} 
 	    } else { , 		if (outshift == 1) {	/* 7-bit character */% 		    sendchar(SI);	/* If shifted, */ " 		    outshift = 0;	/* unshift. */ 		}  	    } 	}4 	if (key == SO) outshift = 1;    /* User typed SO */4 	if (key == SI) outshift = 0;    /* User typed SI */     }   8     key &= cmask;			/* Apply Kermit-to-host mask now. */7     if (key == '\015') {		/* Handle TERMINAL NEWLINE */  	int stuff = -1;( 	if (tnlm) {			/* TERMINAL NEWLINE ON */! 	    stuff = LF;			/* Stuff LF */ 
 #ifdef TNCODE 7 	} else if (network &&		/* TELNET NEWLINE ON/OFF/RAW */  		   (ttnproto == NP_TELNET) &&  		   (tn_nlm != TNL_CR)) {- 	    stuff = (tn_nlm == TNL_CRLF) ? LF : NUL;  #endif /* TNCODE */  	} 	if (stuff > -1) {/ 	    sendchar(dopar('\015'));	/* Send the CR */ - 	    if (duplex) {		/* If local echoing... */ ) 		cwrite('\015');		/*   echo to screen */ % 		if (seslog)		/*   and if logging */ " 		  logchar(csave);	/*   log it */ 	    } 	    key = stuff;  	    csave = key; B 	} else if (tt_crd && duplex) {	/* CR-DISPLAY CRLF & local echo */8 	    cwrite(CR);			/* so we have to echo CRLF locally */ 	    if (seslog) 	      logchar(csave); 	    csave = LF;- 	    key = CR;			/* ... but only send a CR */  	}     } 
 #ifdef TNCODE L     /* If user types the 0xff character (TELNET IAC), it must be doubled. */     else@       if (dopar(key) == IAC && network && ttnproto == NP_TELNET)3 	sendchar(IAC); /* and the other one just below. */  #endif /* TNCODE */        sendchar(dopar(key));      if (duplex) {  	cwrite(csave);  	if (seslog) logchar(csave);     }  }   F /*  S E N D E S C S E Q  --  Send ESC followed by the given string  */ /*A   Used for sending host-requested reports, as well as for sending L   F-keys, arrow keys, etc.  Translation, shifting, etc, are not issues here. */
 static int sendescseq(CHAR *s) {      char c;      int pause;  .     pause = (tt_pacing > -1) ? tt_pacing : 50;  2     /* Handle 7-bit vs 8-bit escape sequences...*/  I     if (send_c1 && ((*s == '[' || *s == 'O'))) /* 8-bit C1 controls... */ -       c = (*s++ ^ (CHAR) 0x40) | (CHAR) 0x80; .     else				/* Or 7-bit escape sequences... */       c = ESC;     sendchar(c);  5     if (duplex) {			/* Half duplex, echo it to the */ # 	cwrite(c);			/* console too ... */ ? 	if (seslog) logchar(c);		/* and maybe log it in session log */      } 6     for ( ; *s; s++ ) {			/* Same deal for the rest */D 	if (!network) msleep(pause);	/* But sleep between each character */6 	sendchar(*s);			/* Otherwise sendchars can overrun */* 	if (duplex) {			/* unbuffered UARTs... */ 	    cwrite(*s); 	    if (seslog) logchar(*s);  	}     }  }   3 static void				/* Push from CONNECT mode to OS/2 */  os2push() {      VIOMODEINFO mi; +     savescreen(&savedscreen,wherex,wherey);      mi.cb = sizeof(mi);      VioGetMode(&mi, 0);      concooked();     clearscreen(1, colorcmd);      restorecursormode();.     puts("Enter EXIT to return to C-Kermit.");     zshcmd(""); 
     conraw(); 
     connoi();      VioSetMode(&mi, 0); 7     setborder();			/* Put back CONNECT screen border */      setcursormode();      restorescreen(&savedscreen);/     if (cursorena)			/* If cursor is enabled */ <       newcursor();			/* turn it on explicitly, in case... */ }    void8 os2debugoff() {				/* Turn off debugging from outside */#     debug(F100,"os2debugoff","",0); !     attribute = defaultattribute;  }    void5 os2bold() {				/* Toggle boldness from the outside */      tn_bold = 1 - tn_bold; }   - static void				/* Toggle session debugging */ 
 flipdebug() {      if (debses) { < 	attribute = defaultattribute;	/* Back to normal coloring */0 	debses = 0;			/* Turn off session debug flag */     } else {/ 	debses = 1;			/* Turn on session debug flag */      } '     if (!roll.flag && status_saved < 0)        ipadl25(); }    /* Initialize key map */   void keymapinit() {  -     keymap[0x103] = 0x00;		/* Ctrl-2 = NUL */ ;     keymap[0x200 | DEL ] = DEL;		/* Ctrl-Backspace = DEL */ 7     keymap[0x200 | ' ' ] = 0x00;	/* Ctrl-Space = NUL */   F     keymap[0x200 | '+' ] = '+';		/* Predefine ambiguous keypad keys */     keymap[0x200 | '-' ] = '-';      keymap[0x200 | '*' ] = '*';      keymap[0x200 | '/' ] = '/';       keymap[0x200 | '\r'] = '\r';      keymap[0x200 | '\n'] = '\n';     keymap[0x200 | '.' ] = '.';      keymap[0x200 | ',' ] = ',';      keymap[0x200 | '0' ] = '0';      keymap[0x200 | '1' ] = '1';      keymap[0x200 | '2' ] = '2';      keymap[0x200 | '3' ] = '3';      keymap[0x200 | '4' ] = '4';      keymap[0x200 | '5' ] = '5';      keymap[0x200 | '6' ] = '6';      keymap[0x200 | '7' ] = '7';      keymap[0x200 | '8' ] = '8';      keymap[0x200 | '9' ] = '9';   ,     keymap[0x109] = 9;			/* Tab-Key = Tab */>     keymap[0x10f] = 8;			/* Shift-Tab = Backtab = Backspace */C     keymap[0x11B] = 27;                 /* Shift-Escape = Escape */ 2     keymap[0x10f] = 8;			/* Backtab = Backspace */6     keymap[270] = 8;			/* Alt-Backspace = Backspace */4     keymap[0x153] = 127;		/* Keypad Del sends DEL */3     keymap[595] = 127;			/* Gray Delete send DEL */    #ifndef NOKVERBS9     keymap[511] = F_KVERB | K_HOLDSCRN; /* Hold Screen */ 9     keymap[767] = F_KVERB | K_HOLDSCRN; /* Hold Screen */        /* Arrow keys */  ;     keymap[584] = F_KVERB | K_UPARR;	/* Up Arrow    Gray */ >     keymap[328] = F_KVERB | K_UPARR;	/* Up Arrow    Numeric */;     keymap[587] = F_KVERB | K_LFARR;	/* Left Arrow  Gray */ =     keymap[331] = F_KVERB | K_LFARR;	/* Left Arrow  Numeric*/ ;     keymap[589] = F_KVERB | K_RTARR;	/* Right Arrow Gray */ >     keymap[333] = F_KVERB | K_RTARR;	/* Right Arrow Numeric */;     keymap[592] = F_KVERB | K_DNARR;	/* Down Arrow  Gray */ >     keymap[336] = F_KVERB | K_DNARR;	/* Down Arrow  Numeric */       /* Screen scroll */   H     keymap[585] = F_KVERB | K_UPSCN;	/* Page Up:        Up one screen */H     keymap[329] = F_KVERB | K_UPSCN;	/* PgUp:           Up one screen */F     keymap[644] = F_KVERB | K_UPONE;	/* Ctrl Page Up:   Up one line */F     keymap[388] = F_KVERB | K_UPONE;	/* Ctrl PgUp:      Up one line */J     keymap[593] = F_KVERB | K_DNSCN;	/* Page Down:      Down one screen */J     keymap[337] = F_KVERB | K_DNSCN;	/* PgDn:           Down one screen */H     keymap[630] = F_KVERB | K_DNONE;	/* Ctrl Page Down: Down one line */H     keymap[374] = F_KVERB | K_DNONE;	/* Ctrl PgDn:      Down one line */I     keymap[583] = F_KVERB | K_HOMSCN;	/* Gray Home:      Top of buffer */ I     keymap[327] = F_KVERB | K_HOMSCN;	/* Numeric Home:   Top of buffer */ L     keymap[591] = F_KVERB | K_ENDSCN;	/* Gray End:       Bottom of buffer */L     keymap[335] = F_KVERB | K_ENDSCN;	/* Numeric End:    Bottom of buffer */       /* Numeric keypad */  5     keymap[315] = F_KVERB | K_PF1;	/* F1 = DEC PF1 */ 5     keymap[316] = F_KVERB | K_PF2;	/* F2 = DEC PF2 */ 5     keymap[317] = F_KVERB | K_PF3;	/* F3 = DEC PF3 */ 5     keymap[318] = F_KVERB | K_PF4;	/* F4 = DEC PF4 */   G     keymap[385] = F_KVERB | K_KP0;	/* Alt-0, Top Rank = DEC Keypad 0 */ G     keymap[376] = F_KVERB | K_KP1;	/* Alt-1, Top Rank = DEC Keypad 1 */ G     keymap[377] = F_KVERB | K_KP2;	/* Alt-2, Top Rank = DEC Keypad 2 */ G     keymap[378] = F_KVERB | K_KP3;	/* Alt-3, Top Rank = DEC Keypad 3 */ G     keymap[379] = F_KVERB | K_KP4;	/* Alt-4, Top Rank = DEC Keypad 4 */ G     keymap[380] = F_KVERB | K_KP5;	/* Alt-5, Top Rank = DEC Keypad 5 */ G     keymap[381] = F_KVERB | K_KP6;	/* Alt-6, Top Rank = DEC Keypad 6 */ G     keymap[382] = F_KVERB | K_KP7;	/* Alt-7, Top Rank = DEC Keypad 7 */ G     keymap[383] = F_KVERB | K_KP8;	/* Alt-8, Top Rank = DEC Keypad 8 */ G     keymap[384] = F_KVERB | K_KP9;	/* Alt-9, Top Rank = DEC Keypad 9 */   K     keymap[386] = F_KVERB | K_KPMINUS;	/* Alt -, Top Rank = DEC Keypad - */ J     keymap[307] = F_KVERB | K_KPCOMA;	/* Alt-Comma = DEC Keypad comma   */I     keymap[308] = F_KVERB | K_KPDOT;	/* Alt-Period = DEC Keypad period */ K     keymap[284] = F_KVERB | K_KPENTER;	/* Alt-Enter  = DEC Keypad Enter  */        /* The compose key */   ;     keymap[302] = F_KVERB | K_COMPOSE;	/* Alt-c, Compose */        /* Kermit action verbs */ I     /* Default mappings designed so key names are valid on all systems */   @     keymap[275] = F_KVERB | K_RESET;	/* Alt-R, Reset emulator */@     keymap[387] = F_KVERB | K_RESET;	/* Alt-=, Reset emulator */>     keymap[301] = F_KVERB | K_EXIT;	/* Alt-x, Exit emulator */<     keymap[304] = F_KVERB | K_BREAK;	/* Alt-b, Send BREAK */B     keymap[294] = F_KVERB | K_LBREAK;	/* Alt-l, Send Long BREAK */D     keymap[278] = F_KVERB | K_HANGUP;	/* Alt-u, Hangup connection */B     keymap[281] = F_KVERB | K_DUMP;	/* Alt-p, Print/Dump screen */M     keymap[370] = F_KVERB | K_PRTSCN;	/* Ctrl-PrintScreen, Toggle printing */ >     keymap[415] = F_KVERB | K_PRINTFF;	/* Alt-End, Print FF */D     keymap[417] = F_KVERB | K_DOS;	/* Alt-Page Down, Push to OS/2 */@     keymap[303] = F_KVERB | K_FLIPSCN;	/* Alt-v, video toggle */B     keymap[288] = F_KVERB | K_DEBUG;	/* Alt-d, Toggle debugging */5     keymap[291] = F_KVERB | K_HELP;	/* Alt-h, Help */ @     keymap[510] = F_KVERB | K_IGNORE;	/* Num Lock, don't beep */@     keymap[766] = F_KVERB | K_IGNORE;	/* Num Lock, don't beep */ #endif /* NOKVERBS */  }    #ifndef NOKVERBS   VOID keynaminit() {  / /*  These names apply only to US keyboards.  */   
     int i;       for (i = 0; i < 512; i++)        keynam[i] = NULL;   !     keynam[259 - 256] = "Ctrl-2";      keynam[265 - 256] = "Tab";(     keynam[270 - 256] = "Alt-Backspace";$     keynam[271 - 256] = "Shift-Tab";      keynam[272 - 256] = "Alt-q";      keynam[273 - 256] = "Alt-w";      keynam[274 - 256] = "Alt-e";      keynam[275 - 256] = "Alt-r";      keynam[276 - 256] = "Alt-t";      keynam[277 - 256] = "Alt-y";      keynam[278 - 256] = "Alt-u";      keynam[279 - 256] = "Alt-i";      keynam[280 - 256] = "Alt-o";      keynam[281 - 256] = "Alt-p";      keynam[282 - 256] = "Alt-[";D     keynam[283 - 256] = "Shift-Esc";	/* Fullscreen sessions only! */$     keynam[284 - 256] = "Alt-Enter";      keynam[286 - 256] = "Alt-a";      keynam[287 - 256] = "Alt-s";      keynam[288 - 256] = "Alt-d";      keynam[289 - 256] = "Alt-f";      keynam[290 - 256] = "Alt-g";      keynam[291 - 256] = "Alt-h";      keynam[292 - 256] = "Alt-j";      keynam[293 - 256] = "Alt-k";      keynam[294 - 256] = "Alt-l";      keynam[295 - 256] = "Alt-;";      keynam[296 - 256] = "Alt-'";$     keynam[297 - 256] = "Alt-grave";!     keynam[299 - 256] = "Alt-\\";       keynam[300 - 256] = "Alt-z";      keynam[301 - 256] = "Alt-x";      keynam[302 - 256] = "Alt-c";      keynam[303 - 256] = "Alt-v";      keynam[304 - 256] = "Alt-b";      keynam[305 - 256] = "Alt-n";      keynam[306 - 256] = "Alt-m";      keynam[307 - 256] = "Alt-,";      keynam[308 - 256] = "Alt-.";      keynam[309 - 256] = "Alt-?";#     keynam[311 - 256] = "Alt-Kp *";      keynam[315 - 256] = "F1";      keynam[316 - 256] = "F2";      keynam[317 - 256] = "F3";      keynam[318 - 256] = "F4";      keynam[319 - 256] = "F5";      keynam[320 - 256] = "F6";      keynam[321 - 256] = "F7";      keynam[322 - 256] = "F8";      keynam[323 - 256] = "F9";      keynam[324 - 256] = "F10";"     keynam[327 - 256] = "Kp Home";     keynam[329 - 256] = "PgUp"; #     keynam[330 - 256] = "Alt-Kp -"; #     keynam[334 - 256] = "Alt-Kp +"; !     keynam[335 - 256] = "Kp End";      keynam[337 - 256] = "PgDn"; !     keynam[339 - 256] = "Kp Del"; "     keynam[350 - 256] = "Ctrl-F1";"     keynam[351 - 256] = "Ctrl-F2";"     keynam[352 - 256] = "Ctrl-F3";"     keynam[353 - 256] = "Ctrl-F4";"     keynam[354 - 256] = "Ctrl-F5";"     keynam[355 - 256] = "Ctrl-F6";"     keynam[356 - 256] = "Ctrl-F7";"     keynam[357 - 256] = "Ctrl-F8";"     keynam[358 - 256] = "Ctrl-F9";#     keynam[359 - 256] = "Ctrl-F10"; !     keynam[360 - 256] = "Alt-F1"; !     keynam[361 - 256] = "Alt-F2"; !     keynam[362 - 256] = "Alt-F3"; !     keynam[363 - 256] = "Alt-F4"; !     keynam[364 - 256] = "Alt-F5"; !     keynam[365 - 256] = "Alt-F6"; !     keynam[366 - 256] = "Alt-F7"; !     keynam[367 - 256] = "Alt-F8"; !     keynam[368 - 256] = "Alt-F9"; "     keynam[369 - 256] = "Alt-F10";,     keynam[370 - 256] = "Ctrl-Print Screen";$     keynam[371 - 256] = "Ctrl-Kp 4";$     keynam[372 - 256] = "Ctrl-Kp 6";$     keynam[373 - 256] = "Ctrl-Kp 1";&     keynam[373 - 256] = "Ctrl-Kp End";$     keynam[374 - 256] = "Ctrl-Kp 4";$     keynam[374 - 256] = "Ctrl-PgDn";$     keynam[375 - 256] = "Ctrl-Kp 7";'     keynam[375 - 256] = "Ctrl-Kp Home";       keynam[376 - 256] = "Alt-1";      keynam[377 - 256] = "Alt-2";      keynam[378 - 256] = "Alt-3";      keynam[379 - 256] = "Alt-4";      keynam[380 - 256] = "Alt-5";      keynam[381 - 256] = "Alt-6";      keynam[382 - 256] = "Alt-7";      keynam[383 - 256] = "Alt-8";      keynam[384 - 256] = "Alt-9";      keynam[385 - 256] = "Alt-0";$     keynam[386 - 256] = "Alt-minus";      keynam[387 - 256] = "Alt-=";$     keynam[388 - 256] = "Ctrl-PgUp";     keynam[389 - 256] = "F11";     keynam[390 - 256] = "F12";#     keynam[393 - 256] = "Ctrl-F11"; #     keynam[394 - 256] = "Ctrl-F12"; "     keynam[395 - 256] = "Alt-F11";"     keynam[396 - 256] = "Alt-F12";$     keynam[397 - 256] = "Ctrl-Kp 8";$     keynam[398 - 256] = "Ctrl-Kp -";$     keynam[399 - 256] = "Ctrl-Kp 5";$     keynam[400 - 256] = "Ctrl-Kp +";$     keynam[401 - 256] = "Ctrl-Kp 2";$     keynam[402 - 256] = "Ctrl-Kp 0";&     keynam[403 - 256] = "Ctrl-Kp Del";&     keynam[403 - 256] = "Ctrl-Kp Del";#     keynam[404 - 256] = "Ctrl-Tab"; $     keynam[405 - 256] = "Ctrl-Kp /";$     keynam[406 - 256] = "Ctrl-Kp *";'     keynam[408 - 256] = "Alt-Up Arrow"; &     keynam[409 - 256] = "Alt-Page Up";)     keynam[411 - 256] = "Alt-Left Arrow"; *     keynam[413 - 256] = "Alt-Right Arrow";"     keynam[415 - 256] = "Alt-End";)     keynam[416 - 256] = "Alt-Down Arrow"; (     keynam[417 - 256] = "Alt-Page Down";%     keynam[418 - 256] = "Alt-Insert"; %     keynam[419 - 256] = "Alt-Delete"; #     keynam[420 - 256] = "Alt-Kp /"; "     keynam[421 - 256] = "Alt-Tab";'     keynam[422 - 256] = "Alt-Kp Enter"; #     keynam[510 - 256] = "Num Lock";       keynam[510 - 256] = "Pause";&     keynam[511 - 256] = "Scroll Lock";(     keynam[522 - 256] = "Ctrl-Kp Enter";     keynam[583 - 256] = "Home"; "     keynam[585 - 256] = "Page Up";     keynam[591 - 256] = "End";$     keynam[593 - 256] = "Page Down";*     keynam[627 - 256] = "Ctrl-Left Arrow";+     keynam[628 - 256] = "Ctrl-Right Arrow"; #     keynam[629 - 256] = "Ctrl-End"; )     keynam[630 - 256] = "Ctrl-Page Down"; $     keynam[631 - 256] = "Ctrl-Home";)     keynam[639 - 256] = "Ctrl-Backspace"; '     keynam[644 - 256] = "Ctrl-Page Up"; (     keynam[653 - 256] = "Ctrl-Up Arrow";*     keynam[657 - 256] = "Ctrl-Down Arrow";&     keynam[658 - 256] = "Ctrl-Insert";&     keynam[659 - 256] = "Ctrl-Delete";#     keynam[766 - 256] = "Num Lock";       keynam[766 - 256] = "Pause";&     keynam[767 - 256] = "Scroll Lock"; }    /* DEC F-key strings */  static char * fkeys[] = { 4  "[17~","[18~","[19~","[20~","[21~",	/* F6  - F10 */4  "[23~","[24~","[25~","[26~","[28~",	/* F11 - F15 */3  "[29~","[31~","[32~","[33~","[34~"	/* F16 - F20 */  };   /* DEC Editing key strings */  static char * ekeys[] = {      "[1~",	/* Find */      "[2~",	/* Insert */      "[3~",	/* Remove */      "[4~",	/* Select */       "[5~",	/* Previous Screen */     "[6~"	/* Next Screen */  };   #ifdef NETCONN #ifdef TCPSOCKET do_tn_cmd(CHAR x) {      CHAR temp[3]; 8     if (network && ttnproto == NP_TELNET) { /* TELNET */ 	temp[0] = (CHAR) IAC;
 	temp[1] = x;  	temp[2] = NUL;  	ttol((CHAR *)temp,2);     } else         bleep(); }  #endif /* TCPSOCKET */ #endif /* NETCONN */    2 /*  D O K V E R B  --  Execute a keyboard verb  */   static void 9 dokverb(int k) {			/* 'k' is the kverbs[] table index. */ 
     int x;>     char escbuf[10];			/* For building key escape sequences */ /*D   Items are grouped according to function, and checked approximately+   in order of how frequently they are used.  */-     k &= ~(F_KVERB);			/* Clear KVERB flag */   +     if (k >= K_ACT_MIN && k <= K_ACT_MAX) {   5 	switch (k) {			/* Common Kermit actions first ... */    	  case K_EXIT:			/* \Kexit: */ @ 	    active = FALSE; return;	/*   Exit from terminal emulator */  	  case K_BREAK:			/* \Kbreak */, 	    ttsndb(); return;		/*   Send a BREAK */% 	  case K_DOS:			/* \Kdos or \Kos2 */ / 	    os2push(); return;		/*   Push to system */   	  case K_RESET:			/* \Kreset */9 	    doreset(1); return;		/*   Reset terminal emulator */  	  case K_HELP:			/* \Khelp */6 	    popuphelp(0); return;	/*   Pop-up help message */! 	  case K_PRTSCN:		/* \Kprtscn */ 2 	    if (printon) {		/*   Toggle printer on/off *// 		xprint = FALSE;		/*   It's on, turn it off */  		printeroff(); & 	    } else {			/*   vice versa ... */ 		printeron(); 	    } 	    return;  	  case K_DUMP:			/* \Kdump   */B 	    x = xprintff; xprintff = 0;	/*   Print/Dump current screen */ 	    prtscreen(1,ysize); 	    xprintff = x; return;5 	  case K_PRINTFF:		/* \KprintFF - Print Form Feed */  	    printeron(); . 	    fprintf(lst,"%c",FF);	/* Send formfeed */ 	    printeroff(); 	    return;! 	  case K_HANGUP:		/* \Khangup */ - 	    hangnow = 1;		/*   Hang up connection */ 0 	    active = 0;			/*   and return to prompt. */% 	    strcpy(termessage, "Hangup.\n");  	    return; 	  case K_NULL:			/* \Knull */5 	    sendcharduplex('\0'); return; /*   Send a NUL */ " 	  case K_LBREAK:		/* \Klbreak: */2 	    ttsndlb(); return;		/*   Send a Long BREAK */  	  case K_DEBUG:			/* \Kdebug */2 	    flipdebug(); return;	/*   Toggle debugging */# 	  case K_FLIPSCN:		/* \KflipScn */ / 	    flipscreen(); return;	/*   Toggle video */ % 	  case K_HOLDSCRN:		/* \KholdScrn */ 8 	    save_status_line();		/* Save current status line */ 	    strcpy(usertext, 9 		   " Scroll-Lock      Press (almost) any key to unlock"  		   ); 3 	    helptext[0] = exittext[0] = hostname[0] = NUL; / 	    line25();			/* Make special status line */ . 	    congks(0);			/* Wait for any keystroke */5 	    restore_status_line();	/* Restore status line */  	    return;! 	  case K_IGNORE:		/* \Kignore */  	    return; #ifdef NETCONN #ifdef TCPSOCKET- 	  case K_TN_AYT:		/* TELNET Are You There */  	    do_tn_cmd((CHAR) AYT);  	    return;1 	  case K_TN_IP:			/* TELNET Interrupt Process */  	    do_tn_cmd((CHAR) IP); 	    return; #endif /* TCPSOCKET */ #endif /* NETCONN */% 	  default:			/* None of the above */ 0 	    return;			/* Ignore this key and return. */ 	}     } D     if (k >= K_ROLLMIN && k <= K_ROLLMAX) { /* Screen rollback... */ 	scrollback(k);  	return;     } I     if (k >= K_ARR_MIN && k <= K_ARR_MAX) { /* DEC arrow (cursor) keys */  	if (tt_type >= TT_VT100) @ 	  sprintf(escbuf,"%c%c",( (tt_arrow == TTK_APPL) ? 'O' : '[' ), 		  'A' + (k - K_UPARR));  	else - 	  sprintf(escbuf,"%c", 'A' + (k - K_UPARR));  	sendescseq(escbuf); 	return;     } 5     if (k >= K_PF1 && k <= K_PF4) {	/* DEC PF keys */  	char *p = escbuf;: 	if (tt_type >= TT_VT100)	/* SS3 P..S for VT100 & above */ 	  *p++ = 'O';: 	*p++ = 'P' + (k - K_PF1);	/* or just ESC P..S for VT52 */
 	*p = NUL; 	sendescseq(escbuf); 	return;     } A     if (k >= K_KP0 && k <= K_KP9) {	/* DEC numeric keypad keys */ 8 	if (tt_keypad == TTK_NORM)	/* Keypad in numeric mode */5 	  sendcharduplex((CHAR) ('0' + (CHAR) (k - K_KP0))); ! 	else {				/* Application mode */  	    sprintf(escbuf,
 		    "%c%c", * 		    ((tt_type >= TT_VT100) ? 'O' : '?'), 		    ('p' + (k - K_KP0))  		    ); 	    sendescseq(escbuf); 	} 	return;     } J     if (k >= K_KPCOMA && k <= K_KPDOT) { /* DEC keypad punctuation keys */8 	if (tt_keypad == TTK_NORM)	/* Keypad in numeric mode */8 	  sendcharduplex((CHAR) (',' + (CHAR) (k - K_KPCOMA)));, 	else {				 /* Keypad in application mode */ 	    sprintf(escbuf,
 		    "%c%c", * 		    ((tt_type >= TT_VT100) ? 'O' : '?'), 		    ('l' + (k - K_KPCOMA)) 		    ); 	    sendescseq(escbuf); 	} 	return;     } 5     if (k == K_KPENTER) {		/* DEC keypad Enter key */ : 	if (tt_keypad == TTK_NORM) {	/* Keypad in numeric mode */* 	    sendcharduplex('\015');	/* Send CR */ 	    if (tnlm)? 	      sendcharduplex('\012');	/* Newline mode, send LF too */  , 	} else {			/* Keypad in application mode */ 	    sprintf(escbuf,
 		    "%c%M", ) 		    ((tt_type >= TT_VT100) ? 'O' : '?')  		    ); 	    sendescseq(escbuf); 	} 	return;     } I     if (k >= K_DECFIND && k <= K_DECNEXT) { /* DEC editing keypad keys */ 6         if (tt_type >= TT_VT220)	/* VT220 and above */$ 	  sendescseq(ekeys[k - K_DECFIND]); 	else bleep(); 	return;     } I     if (k >= K_DECF6 && k <= K_DECF20) { /* DEC top-rank function keys */ 9         if (tt_type >= TT_VT220) {	 /* VT220 and above */ $ 	    sendescseq(fkeys[k - K_DECF6]); 	    return;  	} else {			/* VT102 or lower */ 	    switch (k) {  	      case K_DECF11:  		sendcharduplex(ESC); return; 	      case K_DECF12:  		sendcharduplex(BS); return;  	      case K_DECF13:  		sendcharduplex(LF); return;  	      default: 
 		bleep();
 		return;  	    }		 	}     } ,     if (k == K_COMPOSE) {		/* Compose key */ 	int i;  	CHAR x1, x2, c; 	save_status_line();9 	strcpy(exittext,"Cancel: Space"); /* Make special one */ @ 	sprintf(usertext," COMPOSE: [  ]"); /* with mini-echo-buffer */. 	if (vik.help > 255 && keynam[vik.help - 256])9 	  sprintf(helptext, "Help: %s", keynam[vik.help - 256]); 
 	line25();G 	while ((x1 = keymap[congks(0)]) == K_HELP) /* Let them ask for help */  	  popuphelp(2);1 	if (macrotab[x1] || (x1 <= SP) || (x1 > 0x7E)) {  	    if (x1 != SP) bleep();  	    goto compose_exit;  	}	 ? 	sprintf(usertext," COMPOSE: [%c ]", x1); /* Echo first char */ 
 	line25();  + 	while ((x2 = keymap[congks(0)]) == K_HELP)  	  popuphelp(2); 	if (x2 <= SP || x2 > 0x7E) {  	    if (x2 != SP) bleep();  	    goto compose_exit;  	}	 E 	sprintf(usertext," COMPOSE: [%c%c]", x1, x2); /* Echo second char */ 
 	line25();@ 	for (i = 0; i < nl1ktab; i++)	/* Look up the 2-char sequence */4 	  if ((x1 == l1ktab[i].c1) && (x2 == l1ktab[i].c2)) 	    break; % 	if (i >= nl1ktab) {		/* Not found */ 
 	    bleep();  	    goto compose_exit; 2 	} else c = l1ktab[i].c3;	/* Character we found */F 	if (sxi) c = (*sxi)((CHAR)c);	/* Xlate from remote to intermediate */C 	if (rxi) c = (*rxi)((CHAR)c);	/* and from intermediate to local */ " 	sendcharduplex(c);		/* Send it */5 	msleep(333);			/* Some time to look at minibuffer */ -       compose_exit:			/* Common exit point */ 2 	restore_status_line();		/* Restore status line */ 	return;     }   :     if (k == K_KB_HEB) {		/* Hebrew keyboard support... */ 	sethebrewmode();  	return;     }      if (k == K_KB_ENG) { 	resethebrewmode();  	return;     }    #ifdef COMMENT@     if (k >= K_UDKF6 && k <= K_UDKF20) { /* User-Defined Keys */% 	return;				/* Not implemented yet */      }  #endif /* COMMENT */ }  #endif /* NOKVERBS */   4 /*  S E N D K E Y D E F  --  Send key definition  */    static void  sendkeydef(unsigned char *s) {    #ifndef NOKVERBS     int x, y, brace = 0;     int pause;     char * p, * b; #define K_BUFLEN 30 8     char kbuf[K_BUFLEN + 1];		/* Key verb name buffer */ #endif /* NOKVERBS */   .     pause = (tt_pacing > -1) ? tt_pacing : 50;  5     for ( ; *s; s++ ) {			/* Go through the string */  #ifdef NOKVERBS ? 	if (!network) msleep(pause);	/* To prevent UART overruns... */ : 	sendcharduplex(*s);		/* Send each character literally. */    #else	/* \Kverb support ... */  * 	if (*s != CMDQ) {		/* Normal character */> 	    if (!network) msleep(pause); /* Prevent UART overruns. */' 	    sendcharduplex(*s);		/* Send it */ % 	    continue;			/* Get next, etc. */  	}$ 	b = s++;			/* Get next character */ 	if (!*s) {  	    keydefptr = NULL; 	    return; 	}' 	if (*s == '{') {		/* Opening brace? */   	    brace = 1;			/* Remember */& 	    s++;			/* Go to next character */ 	    if (!*s) {  		keydefptr = NULL; 	 		return;  	    } 	}1 	if (*s == 'K' || *s == 'k') {	/* Have K verb? */ 	 	    s++;  	    if (!*s) {  		keydefptr = NULL; 	 		return;  	    }   /*K   We assume that the verb name is {braced}, or it extends to the end of the F   string, s, or it ends with a space, control character, or backslash. */7 	    p = kbuf;			/* Copy verb name into local buffer */  	    x = 0; < 	    while ((x++ < K_BUFLEN) && (*s > SP) && (*s != CMDQ)) { 		if (brace && *s == '}') {  		    break; 		}  		*p++ = *s++; 	    }< 	    if (*s && !brace)		/* If we broke because of \, etc, */4 	      s--;			/*  back up so we get another look. */ 	    brace = 0; ! 	    *p = NUL;			/* Terminate. */ . 	    p = kbuf;			/* Point back to beginning */( 	    debug(F110,"sendkeydef kverb",p,0);7 	    y = xlookup(kverbs,p,nkverbs,&x); /* Look it up */ ) 	    debug(F101,"sendkeydef lookup",0,y);  	    if (y > -1) { #ifdef __32BIT__ 		{ @ 		    DosRequestMutexSem( hmtxScreenSem, SEM_INDEFINITE_WAIT ) ; 		    dokverb(y) ;      + 		    DosReleaseMutexSem( hmtxScreenSem ) ;  		}  #else  		dokverb(y);	 #endif /* __32BIT__ */
 #ifndef NOSPL $ 	    } else {			/* Is it a macro? */ 		y = mxlook(mactab,p,nmac); 		if (y > -1) { 2 		    keymac = 1;		/* Flag for key macro active */( 		    keymacx = y;	/* Key macro index */4 		    keydefptr = s;	/* Where to resume next time */2 		    debug(F111,"sendkeydef mxlook",keydefptr,y);+ 		    active = 0;		/* Leave CONNECT mode */  		}  #endif /* NOSPL */ 	    }9 	} else if (*s == 'V' || *s == 'v') { /* Have \v(xxx)? */  	    s++;			/* Next char */ 
 	    if (!*s)  	      return;1 	    if (*s != '(') {		/* Should be left paren */ ; 		if (!network) msleep(pause); /* Prevent UART overruns. */  		sendcharduplex(CMDQ); ; 		if (!network) msleep(pause); /* Prevent UART overruns. */  		sendcharduplex(*s);  		continue;  	    }% 	    b = s - 1;			/* Save my place */ " 	    s++;			/* Point past paren */+ 	    p = kbuf;			/* Point to word buffer */ % 	    x = 0;			/* Copy verb into it */ 9 	    while ((x++ < K_BUFLEN) && (*s > SP) && (*s != ')'))  	      *p++ = *s++;  	    *p = NUL;4 	    if (*s != ')') {		/* Have terminating paren? */; 		if (!network) msleep(pause); /* Prevent UART overruns. */ 5 		sendcharduplex(CMDQ);	/* No, send this literally */  		s = b; 		continue; 
 	    } else { * 		p = kbuf;		/* Point back to beginning */' 		debug(F110,"sendkeydef v(verb)",p,0); # 		p = nvlook(p);		/* Look it up. */  		if (!p)			/* Not found, */' 		  continue;		/* continue silently. */  		while (*p) {		/* Send it. */? 		    if (!network) msleep(pause); /* Prevent UART overruns. */  		    sendcharduplex(*p++);  		} 
 		if (!*s) 		  return;  	    }# 	} else {			/* Not \K, \{K or \V */ > 	    if (!network) msleep(pause); /* Prevent UART overruns. */< 	    sendcharduplex(CMDQ);	/* Back up and send backslash, */0 	    if (brace) {		/* and maybe a left brace, */; 		if (!network) msleep(pause); /* Prevent UART overruns. */  		sendcharduplex('{'); 		brace = 0; 	    }> 	    if (!network) msleep(pause);	/* Prevent UART overruns. */? 	    if (*s) sendcharduplex(*s);	/* and this char literally. */  	} 	if (!*s) {  	    keydefptr = NULL; 	    return; 	} #endif /* NOKVERBS */      }      keydefptr = NULL;  }    /* Scrollback handler */ /*F   Totally rewritten for edit 190 to allow TERMINAL ROLL options and to   use new keymap  - fdc. */ static void % scrollback(int key) {			/* Keycode */ /     int nlines,				/* How many lines to roll */ 2       nolblines,			/* Lines above top of screen */       i, il;				/* Workers */        /* Initialization */   #ifdef DEBUG     if (deblog) { % 	debug(F101,"scrollback key","",key); 2 	debug(F101,"scrollback botline","",roll.botline);4 	debug(F101,"scrollback numlines","",roll.numlines);6 	debug(F101,"scrollback linesleft","",roll.linesleft);4 	debug(F101,"scrollback nextline","",roll.nextline);, 	debug(F101,"scrollback flag","",roll.flag);- 	debug(F101,"scrollback tt_roll","",tt_roll);      }  #endif /* DEBUG */  9     if (!roll.flag) {			/* Set if we are not at bottom */   	roll.linesleft = roll.numlines; 	roll.nextline = roll.botline;     }   4     if (cursorena)			/* If cursor not already off */)       killcursor();			/*  turn it off. */  /*N   If TERMINAL ROLL OFF, we just process the argument key and return control ofK   the keyboard to the user.  This lets the user type characters to the host L   while looking at rollback screens, as well as view new incoming charactersN   on an old screen.  But it can result in some confusion by mixing new and old"   material in the rollback buffer.  F   If TERMINAL ROLL ON, the user is held captive inside the rolled-backN   screens, allowed to type only rollback keys until reaching the bottom again,M   and no characters are read from the communication device while rolled back. G   This prevents transmission of characters to the host, and it prevents 9   mixture of new and old material in the rollback buffer.  *//     do {				/* If ROLL is ON, this is a loop */   ; 	while (roll.flag && tt_roll) {	/* Get another keystroke */  	    key = keymap[congks(0)]; 4 	    if (key & F_KVERB)		/* It has to be a \Kverb */
 	      break; 1 	    bleep();			/* if not, stay in little loop */  	}  5 	switch (key &= ~(F_KVERB)) {	/* Handle the key... */   5 	  case K_HOMSCN:		/* Scrolling UP (backwards) ... */  	  case K_UPSCN: 	  case K_UPONE:= 	    if (roll.linesleft <= 0) {	/* Can't go any further up */  		bleep();		/* Beep */ 		if (!roll.flag)  		  return;  		else if (tt_roll) 
 		  continue;  		else {/ 		    if (cursorena)	/* If cursor is enabled */ + 		      newcursor();	/* turn it back on. */ 
 		    return;  		}  	    }7 	    if (!roll.flag)		/* If not scrolled up already, */ H 	      savescreen(&savedscreen,wherex,wherey); /* save current screen */A 	    nlines = key == K_UPSCN ? ysize /* How far depends on key */ , 	      : key == K_HOMSCN  ? roll.linesleft : 		1;9 	    if (nlines > roll.linesleft) /* Don't go past top */  	      nlines = roll.linesleft; 2 	    debug(F101,"scrollback up nlines","",nlines);8 	    if (nlines >= ysize) {	/* More than screen size? */ 		if (nlines > ysize) - 		  roll.nextline = roll.topline + ysize - 1; < 		debug(F101,"scrollback up whole screen","",roll.nextline);# 		for (il = ysize; il >= 1; il--) {  		    movetoscreen( - 				 roll.buffer + xsize * 2 * roll.nextline,  				 1, il, xsize * 2);  		    if (roll.nextline == 0) % 		      roll.nextline = LBUFSIZE - 1; 
 		    else 		      roll.nextline--; 		} /* for-loop */D 	    } else { /* nlines < ysize, so we can scroll some lines down */7 		debug(F101,"scrollback up partial screen","",nlines); ) 		scroll(DOWNWARD, 0, ysize - 1, nlines); $ 		for (il = 1; il <= nlines; il++) {; 		    movetoscreen(roll.buffer + xsize * 2 * roll.nextline, $ 				 1, nlines - il + 1, xsize * 2); 		    if (roll.nextline <= 0) % 		      roll.nextline = LBUFSIZE - 1; 
 		    else 		      roll.nextline--; 		}  	    } 	    roll.linesleft -= nlines; 	    roll.flag = 1;  	    break;     	  case K_DNSCN:			/* Go down */ 	  case K_DNONE:6 	    if (!roll.flag) {		/* If we're not rolled back */( 		bleep();		/* nothing to do, so beep */ 		if (tt_roll)
 		  continue;  		else {/ 		    if (cursorena)	/* If cursor is enabled */ + 		      newcursor();	/* turn it back on. */ 
 		    return;  		}  	    }H 	    nlines = key == K_DNSCN ? ysize : 1; /* Screen Down or Line Down */1 	    if (nlines > roll.numlines - roll.linesleft) / 	      nlines = roll.numlines - roll.linesleft; 4 	    debug(F101,"scrollback down nlines","",nlines); 	    if (nlines < ysize), 	      scroll(UPWARD, 0, ysize - 1, nlines);	 	    do { " 		if (++roll.nextline >= LBUFSIZE) 		  roll.nextline = 0; 		roll.linesleft++; 9 		/* Lines of extended display above top of the screen */ - 		nolblines = roll.numlines - roll.linesleft; 9 		/* Number of extended display buffer lines on screen */  		if (nolblines >= ysize) {   		    i = roll.nextline + ysize; 		    if (i >= LBUFSIZE) 		      i -= LBUFSIZE;& 		    /* Move from buffer to screen */2 		    movetoscreen(roll.buffer + xsize * 2 * i, 1,$ 				 ysize - nlines + 1, xsize * 2);0 		} else {		/* Move from saved current screen */ 		    movetoscreen(  				 &(savedscreen.scrncpy[ ) 					 (ysize - 1 - nolblines) * xsize * 2  						       ]), 				 1,  				 ysize - nlines + 1, 				 xsize * 2 				 );  		}  		nlines--;  	    } while (nlines > 0); 	    break;   ) 	  case K_ENDSCN:		/* Scroll to bottom */ 7 	    if (!roll.flag) {		/* If we're not rolled back, */  		bleep();		/* just beep, */' 		if (cursorena)		/* restore cursor, */ # 		  newcursor();		/* and return. */ 	 		return; 4 	    } else {			/* Otherwise, set exit condition. */! 		roll.linesleft = roll.numlines;  	    } 	    break;   2 	  case K_DUMP: {		/* Print/Dump current screen */ 	    int x;   	    x = xprintff; xprintff = 0; 	    prtscreen(1,ysize); 	    xprintff = x; 	    continue; 	  }   	  case K_HELP:			/* Help */9 	    popuphelp(0);		/* Watch out, this turns cursor on */ * 	    killcursor();		/* Turn it back off */ 	    continue;  ' 	  default:			/* Not a rollback key. */ 
 	    bleep();  	    continue;   	} /* switch (key) */     ; 	/* If we're still rolled back, make special status line */   ' 	if (roll.linesleft != roll.numlines) { * 	    roll.flag = 1;			/* (Just in case) */F 	    sprintf(usertext, " Scroll: %d/%d", /* Do special status line. */% 		    roll.numlines - roll.linesleft,  		    roll.numlines  		    );6 	    if (vik.upscn > 255 && keynam[vik.upscn - 256]) {1 		strncpy(helptext, keynam[vik.upscn - 256], 20); 3 		if (vik.dnscn > 255 && keynam[vik.dnscn - 256]) {  		    if (HLPTXTLEN ) 			- (int)strlen(keynam[vik.upscn - 256]) 0 			- (int)strlen(keynam[vik.dnscn - 256]) > 0) { 			strcat(helptext,"/");, 			strcat(helptext,keynam[vik.dnscn - 256]); 		    }  		}  	    } else - 	      strcpy(helptext, "\\KupScn,\\KdnScn");    	    if ((vik.help > 255) && 		(keynam[vik.help - 256]) && @ 		((HSTNAMLEN - 6 - (int)strlen(keynam[vik.help - 256])) > 0)) {8 		sprintf(hostname, "Help: %s", keynam[vik.help - 256]);? 	    } else if (vik.homscn > 255 && keynam[vik.homscn - 256]) { - 		strcpy(hostname, keynam[vik.homscn - 256]); 5 		if (vik.endscn > 255 && keynam[vik.endscn - 256]) {  		    if (HSTNAMLEN - 1 * 			- (int)strlen(keynam[vik.homscn - 256])1 			- (int)strlen(keynam[vik.endscn - 256]) > 0) {  			strcat(hostname,"/");- 			strcat(hostname,keynam[vik.endscn - 256]);  		    }  		}  	    } else / 	      strcpy(hostname, "\\KhomScn,\\KendScn");  	    exittext[0] = '\0'; 	    /* filetext[0] = '\0'; */. 	    line25();			/* Display the status line */ 	};     } while (tt_roll && (roll.linesleft != roll.numlines));  /*C   Get here after processing one keystroke and TERMINAL ROLL is OFF, B   or when TERMINAL ROLL is ON, only when we've reached the bottom. */D     if (roll.linesleft == roll.numlines) { /* We're at the bottom */ 	if (roll.flag) { 4 	    roll.flag = 0;			/* Reset scrolled-back flag */? 	    restorescreen(&savedscreen);	/* Put back current screen */ 3 	    ipadl25();			/* Put back normal status line */  	}     } /     if (cursorena)			/* If cursor is enabled */ +       newcursor();			/* turn it back on. */      return;  }    static void  vt100key(int key) {    #ifdef NOKVERBS 6     char str[3];			/* Not needed in simplified code */     int prt, st; #endif /* NOKVERBS */   7     if ( keydefptr ) {			/* First send any leftovers */ 8 	sendkeydef( keydefptr );	/* from previous session... */2 	keydefptr = NULL;		/* and then forget about it */ 	return;7     } else if ( macrotab[key] ) {	/* Check for macro */ ; 	sendkeydef(macrotab[key]);	/* This also handles \Kverbs */  	return;     } 9     key = keymap[key];			/* If no macro, check keymap. */   5     if (key < 0x100) {			/* If it's a regular key, */ 0 	sendcharduplex((char) key);	/* just send it, */0 	if (tt_pacing > 0)		/* taking care of pacing */ 	  msleep(tt_pacing); 0 	if (key == CR && tnlm) {	/* and newline mode */ 	    sendcharduplex(LF);) 	    if (tt_pacing > 0)		/* and pacing */  	      msleep(tt_pacing);  	}         return;      }    #ifndef NOKVERBS  ?     if (IS_KVERB(key))			/* Specially precoded keyboard verb */  #ifdef __32BIT__       { @       DosRequestMutexSem( hmtxScreenSem, SEM_INDEFINITE_WAIT ) ;:       dokverb(key) ;       /* We already know its index */+       DosReleaseMutexSem( hmtxScreenSem ) ;        }  #else 5       dokverb(key);			/* We already know its index */  #endif /* __32BIT__ */     else8       bleep();				/* Extended key with no definition. */(     return;				/* Just beep & return. */    : #else /* Old way, pre-edit-190, hardwired scan codes... */       switch (key & 0xFF) {         case 72:				/* Up Arrow */"         if (tt_type >= TT_VT100) {%             if (tt_arrow == TTK_APPL) 0 	      sendescseq("OA");		/* Application mode */             else4 	      sendescseq("[A");		/* Normal (cursor) mode */         } else 	  sendescseq("A");          break;&       case 75:				/* 587 Left Arrow */"         if (tt_type >= TT_VT100) {%             if (tt_arrow == TTK_APPL) !                 sendescseq("OD");              else!                 sendescseq("[D");          } else             sendescseq("D");         break;%     case 77:				/* 589 Right Arrow */ "         if (tt_type >= TT_VT100) {%             if (tt_arrow == TTK_APPL) !                 sendescseq("OC");              else!                 sendescseq("[C");          } else             sendescseq("C");         break;$     case 80:				/* 592 Down Arrow */"         if (tt_type >= TT_VT100) {%             if (tt_arrow == TTK_APPL) !                 sendescseq("OB");              else!                 sendescseq("[B");          } else             sendescseq("B");         break;!     case 15:				/* 271 Backtab */ 1         sendcharduplex(8);		/* Sends backspace */          break;     case 83:				/* 127 DEL */ 0         sendcharduplex(127);		/* Sends delete */         break;     case 59:				/* 315 F1 */;         if (tt_type >= TT_VT100)        /* Sends DEC PF1 */  	  sendescseq("OP");         else 	  sendescseq("P");          break;     case 60:				/* 316 F2 */;         if (tt_type >= TT_VT100)        /* Sends DEC PF2 */  	  sendescseq("OQ");         else 	  sendescseq("Q");          break;     case 61:				/* 317 F3 */3         if (tt_type >= TT_VT100)	/* Send DEC PF3 */  	  sendescseq("OR");         else 	  sendescseq("R");          break;     case 62:				/* 318 F4 */;         if (tt_type >= TT_VT100)        /* Sends DEC PF4 */  	  sendescseq("OS");         else 	  sendescseq("S");          break;&     case 120:				/* Alt-1 ... Alt-9 */(     case 121:				/* 376, 377, ... 384 */
     case 122: 
     case 123: 
     case 124: 
     case 125: 
     case 126: 
     case 127: 
     case 128: /     case 129:				/* 385 .. This one is Alt-0 */          /* numeric 1-9,0 */ A 	if (tt_keypad == TTK_NORM) {	/* Keypad digits in numeric mode */ 7 	    if (key == 129) key = 48;	/* Watch out for zero */  	    else key -= 71;9 	    sendcharduplex((unsigned char)key);	/* Send digit */ 3         } else {			/* Keypad in Application mode */ +             key = 'q' + (key & 0xFF) - 120;              if (key == 'z')  	      key = 'p';              /* alt 0 */ $             if (tt_type >= TT_VT100) 	      strcpy(str, "O ");              else 	      strcpy(str, "? ");              str[1] = key;              sendescseq(str);	         }          break;.     case 63:				/* Keypad minus = F5 or ... */     case 64:				/* F6 */8 	if (tt_keypad == TTK_NORM)	/* Keypad in numeric mode */ 	  sendcharduplex('-'); C         else if (tt_type >= TT_VT100)	/* Application mode, VT102 */  	  sendescseq("Om");,         else				/* Application mode, VT52 */ 	  sendescseq("?m");         break;.     case 65:				/* Keypad comma = F7 or ... */     case 66:				/* F8 */1 	if (tt_keypad == TTK_NORM)	/* Numeric mode... */  	  sendcharduplex(','); %         else if (tt_type >= TT_VT100)  	  sendescseq("Ol");         else 	  sendescseq("?l");         break;(     case 67:				/* Keypad period = F9 */ 	if (tt_keypad == TTK_NORM)  	    sendcharduplex('.'); %         else if (tt_type >= TT_VT100)              sendescseq("On");          else             sendescseq("?n");          break;(     case 68:				/* Keypad Enter = F10 */ 	if (tt_keypad == TTK_NORM) { 8 	    sendcharduplex('\015');	/* Numeric mode, send CR */ 	    if (tnlm)> 	      sendcharduplex('\012');	/* Newline mode, send LF too */'         } else if (tt_type >= TT_VT100)  	  sendescseq("OM");         else 	  sendescseq("?M");         break;"     case 255:				/* Scroll-Lock */	         { .             strcpy(usertext, " Scroll-Lock ");             *exittext = '\0';              *helptext = '\0';              line25(); 0             while (keymap[congks(0)] != 0x1FF) ;             ipadl25();	         }          break;     case 81:				/* Page-Down */ (     case 118:				/* Control-Page-Down */         bleep();0         /* since not in extended display mode */         break;7     case 71:				/* Home, enter extended display mode */      case 73:				/* Page-Up  */&     case 132:				/* Control-Page-Up */         if (roll.numlines == 0)  	  bleep();  	else  	  scrollback(key);          break;"     case 16:				/* Alt-Q = Quit */       doesc('Q'); break;.     case 45:				/* Alt-X = Return to prompt */       doesc('C'); break;(     case 48:				/* Alt-B = Send BREAK */       doesc('B'); break;-     case 38:				/* Alt-L = Send Long BREAK */        doesc('L'); break;$     case 35:				/* Alt-H = Hangup */       doesc('H'); break;%     case 131:				/* Alt-= is Reset */        doreset(1);        break;+     case 53:				/* Alt-? or Alt-/ = Help */ H       strcpy(usertext, " Press (almost) any key to restore the screen");       exittext[0] = '\0';        helptext[0] = '\0';        hostname[0] = '\0';        line25();        popuphelp(0);        ipadl25();       break;)     case 19:				/* Alt-R = Flip screen */        flipscreen();        break;1     case 25: {				/* Alt-P = print/dump screen */        int x;!       x = xprintff; xprintff = 0; 4       prtscreen(1,ysize);		/*   Print/Dump screen */       xprintff = x;        break;     } .     case 32:				/* Alt-D = Toggle debugging */       flipdebug();       break;$     default:				/* Others, ignore */       break;"     } /* of switch (key & 0xFF) */   #endif /* NOKVERBS */    }   H /* ------------------------------------------------------------------ */H /* cwrite - check and process escape sequence                         */H /* ------------------------------------------------------------------ */   static char old_c = 0;    void					/* Note, not static! */6 cwrite(unsigned char ch) {		/* Used by ckcnet.c for */( 					/* TELNET options debug display. */ /*    Edit 190.L    New code, supporting APC, and integrating escape sequence state switchingL    that was formerly done, but not used to good advantage, in chkaes().  TheI    additional complexity comes from the fact that ESC is not used only to L    commence escape sequences, but also, in the case of APC, OSC, PM, etc, to=    terminate them.  New code also supports session debugging.  */     if (tt_type == TT_NONE) {  	vt100(ch);  	return;     } 7     if (debses && !f_pushed) {		/* Session debugging */  	unsigned char ch8; , 	ch8 = f_popped ? ((ch ^ 0x40) | 0x80) : ch;- 	if (ch8 < 32) {			/* C0 Control character */ : 	    attribute = colorunderline;	/* Use underline color */. 	    if (decscnm)		/* Handle flipped screen */) 	      attribute = swapcolors(attribute); > 	    wrtch((char)(ch8 | 64));	/* Write corresponding letter */# 	} else if (ch8 == 127) {	/* DEL */ 6 	    attribute = colorunderline;	/* Underline color */. 	    if (decscnm)		/* Handle flipped screen */) 	      attribute = swapcolors(attribute); & 	    wrtch('?');			/* question mark */6 	} else if (ch8 > 127 && ch8 < 160) { /* C1 control */6 	    attribute = colorunderline;	/* Underline color */. 	    if (decscnm)		/* Handle flipped screen */) 	      attribute = swapcolors(attribute); - 	    wrtch(ch8);			/* The character itself */ ? 	} else if (escstate != ES_NORMAL) { /* Part of Esc sequence */ B 	    attribute = swapcolors(defaultattribute); /* Reverse video */ 	    wrtch(ch8);# 	} else {			/* Regular character */ 6 	    attribute = defaultattribute; /* Normal colors */F 	    if (tn_bold) attribute ^= 8; /* (only for TELNET debugging...) */ 	    wrtch(ch8); 	}B 	if (ch8 == LF && old_c == CR) {	/* Break lines for readability */ 	    wrtch(CR);  	    wrtch(LF);  	}- 	old_c = ch8;			/* Remember this character */ "     }					/* for CRLF matching. */ /*K   Even if debugging, we still plow through the escape-sequence state table  9   switcher, but we don't call any of the action routines. E   This lets us highlight text that appears inside an escape sequence.  */@     if (escstate == ES_NORMAL) {	/* Not in an escape sequence */4 	if (ch == ESC) {		/* This character is an Escape */7 	    escstate = ES_GOTESC;	/* Change state to GOTESC */ 4             esclast = 0;		/* Reset buffer pointer */5     	} else				/* Not an ESC, stay in NORMAL state */ A 	  if (!debses) vt100(ch);	/* and send to vt100() for display. */ ( 	return;				/* Return in either case. */     }   % /* We are in an escape sequence... */   M     if (escstate != ES_STRING && escstate != ES_TERMIN) { /* Not in string */ * 	if (ch < SP) {			/* Control character? */H 	    if (ch == CAN || ch == SUB) { /* These cancel an escape sequence */0 		escstate = ES_NORMAL;	/* Go back to normal. */@ 	    } else if (ch == BS && esclast > 0) { /* Erases previous */2 		esclast--;		/* escape sequence char (really?) */ 	    } else if (ch == ESC) {; 		escstate = ES_GOTESC;	/* Escape sequence was restarted */ * 		esclast = 0;		/* Reset buffer pointer */ 	    } 	    return; 	} /*3   Put this character in the escape sequence buffer. H   But we don't put "strings" in this buffer; either absorb them silentlyM   (as with Operating System Command), or handle them specially (as with APC). (   Note that indexing starts at 1, not 0. */ 	if (esclast < ESCBUFLEN)  	  escbuffer[++esclast] = ch;      }   7 /* Note: vtescape() sets escstate back to ES_NORMAL. */   3     if (tt_type == TT_VT52) {		/* VT52 Emulation */          switch (esclast) {.           case 1:			/* First char after Esc */$ 	    if (ch != 'Y')		/* If not Y, */7 	      vtescape();		/* then it's a complete sequence */  	    break; 3 	  case 3:			/* Can only happen with Y<row><col> */ ( 	    vtescape();			/* Cursor position */7           case 2:			/* First part of cursor position */  	    break; 9           default:	  		/* Something unexpected, ignore */  	    escstate = ES_NORMAL;             break;	         }   	return;				/* Done with VT52 */     }   H     /* The rest of this routine handles ANSI/VT1xx/VT2xx emulation... */     A     switch (escstate) {			/* Enter esc sequence state switcher */   =       case ES_GOTESC:			/* GOTESC state, prev char was Esc */ 5 	if (ch == '[')			/* Left bracket after ESC is CSI */ 6 	  escstate = ES_GOTCSI;		/* Change to GOTCSI state */? 	else if (ch == '_' ||		/* Application Program Command (APC) */o7 		 ch == 'P' ||		/* Device Control String Introducer */c+ 		 ch == '^' ||		/* Privacy Message (PM) */u5 		 ch == ']') {		/* Operating System Command (OSC) */E> 	    escstate = ES_STRING;	/* Enter STRING-absorption state */
 #ifdef CK_APCo8 	    if (ch == '_') {		/* Application Program Command */+ 		apcactive = 1;		/* Set APC-Active flag */a4 		apclength = 0;		/* and reset APC buffer pointer */ 	    } #endif /* CK_APC */rO         } else if ((ch > 057) && (ch < 0177)) /* Or final char, '0' thru '~' */s$ 	  vtescape();			/* Go act on it. */ 	elseo 	  escstate = ES_ESCSEQ; 	break;s  =       case ES_ESCSEQ:			/* ESCSEQ -- in an escape sequence */tH         if (ch > 057 && ch < 0177)	/* Final character is '0' thru '~' */# 	  vtescape();			/* Go handle it */  	break;n  =       case ES_GOTCSI:			/* GOTCSI -- In a control sequence */aA 	if (ch > 077 && ch < 0177)	/* Final character is '@' thru '~' */d$ 	  vtescape();			/* Go act on it. */ 	break;V  -       case ES_STRING:			/* Inside a string */d9 	if (ch == ESC)			/* ESC may be 1st char of terminator */c9 	  escstate = ES_TERMIN;		/* Change state to find out. */C
 #ifdef CK_APCaG 	else if (apcactive && (apclength < apcbuflen))	/* If in APC string, */e9 	  apcbuf[apclength++] = ch;	/* deposit this character */  #endif /* CK_APC */u- 	break;				/* Absorb all other characters. */a 		:       case ES_TERMIN:			/* May have a string terminator */1 	if (ch == '\\') {		/* which must be backslash */a6 	    escstate = ES_NORMAL;	/* If so, back to NORMAL */
 #ifdef CK_APC 5 	    if (apcactive) {		/* If it was an APC string, */c: 		apcbuf[apclength] = NUL; /* terminate it and then ... */ 		if (apcstatus != APC_OFF) {o; 		    active = FALSE;	/* exit from the terminal emulator */c6 		    return;		/* with the apcactive flag still set */ 		} else apcactive = 0;u #endif /* CK_APC */s 	    }- 	} else {			/* Just a stray Esc character. */A= 	    escstate = ES_STRING;	/* Return to string absorption. */ 
 #ifdef CK_APC.G 	    if (apcactive && (apclength+1 < apcbuflen)) { /* In APC string, */=< 		apcbuf[apclength++] = ESC; /* deposit the Esc character */9 		apcbuf[apclength++] = ch;  /* and this character too */e 	    } #endif /* CK_APC */r 	}     }i }   O /*---------------------------------------------------------------------------*/aO /* scrninit                                                                  */ O /*---------------------------------------------------------------------------*/n static void* scrninit() {       setborder();  '     if ( roll.bufsize != tt_scrsize ) {u"         if ( roll.buffer != NULL ) 	    free(roll.buffer);o 	roll.buffer = NULL; 	scrninitialised = 0;r     }*     if (!scrninitialised) {  	scrninitialised = 1;l  	defaultattribute = colornormal; 	attribute = defaultattribute; 	/* Initialise paging info */ $         if ( roll.buffer == NULL ) { 	  roll.bufsize = tt_scrsize;i0 	  roll.buffer = malloc(tt_scrsize * xsize * 2); 	} 	assert(roll.buffer != NULL);f 	roll.numlines = 0;n 	roll.topline = 0; 	roll.botline = LBUFSIZE - 1;O 	roll.flag = 0;  	clearscreen(0, attribute);*( 	savescreen(&vt100screen,wherex,wherey);     }n }N  O /*---------------------------------------------------------------------------*/EO /* bleep                                                                     */ O /*---------------------------------------------------------------------------*/  static voidN	 bleep() {e<     switch(tt_bell) {			/* Follows TERMINAL BELL setting. */       case 1:				/* AUDIBLE */- 	DosBeep(880, 50);		/* 880 MHz for 50 msec */  	return;       case 2:				/* VISIBLE */' 	flipscreen();			/* Flash the screen */M" 	msleep(250);			/* for 250 msec */ 	flipscreen(); 	return;%       default:				/* NONE or other */= 	return;     }  }d  O /*---------------------------------------------------------------------------*/FO /* wrtch                                                                     *//O /*---------------------------------------------------------------------------*/u static voidl wrtch(char ch) {     char cell[2];=  H     if (printon && xprint && !debses)	/* If transparent print active, */2       return;				/*  we don't touch the screen. */  7     if (ch >= ' ' || literal) {		/* Normal character */  	if (attrib.invisible) 	  ch = ' ';+ 	if ((tt_type >= TT_VT102) && insertmode) {c 	    cell[0] = ch; 	    cell[1] = attribute;c #ifdef OS2MOUSE	 	    os2_mousehide() ; #endif /* OS2MOUSE */r4 	    VioScrollRt(wherey - 1, wherex - 1, wherey - 1, 			xsize - 1, 1, cell, 0); #ifdef OS2MOUSE  	    os2_mouseshow() ; #endif 	} else. #ifdef OS2MOUSEc 	  os2_mousehide() ; #endif /* OS2MOUSE */nE 	    VioWrtCharStrAtt(&ch, 1, wherey - 1, wherex - 1, &attribute, 0);e #ifdef OS2MOUSEe 	os2_mouseshow() ; #endif 	literal = FALSE;  	if (++wherex > xsize) { 	    wherex = 1; 	    wrtch(LF);  	}'     } else {				/* Control character */  	switch (ch) {	 	case LF:= 	    if (wherey == marginbot) {= 		if (margintop == 1)  		  toplinetocyclicbuffer();2 		scroll(UPWARD, margintop - 1, marginbot - 1, 1);
 	    } else {[ 		wherey++;M 		if (wherey == ysize + 1) 		    wherey--;n 	    } 	    break; 	 	case CR:e 	    wherex = 1; 	    break; 	 	case BS:n 	    if (wherex > 1) 		wherex--;s 	    break;f	 	case 12:* 	    if (wherex < xsize) 		wherex++;t 	    break; 
 	case BEL: 	    DosBeep(440, 100);e 	    break;  	default:{		/* Ignore */ 	    } 	}     }i     if (cursoron)i) 	VioSetCurPos(wherey - 1, wherex - 1, 0);  }   O /*---------------------------------------------------------------------------*/aO /* clearscreen                                                               */ O /*---------------------------------------------------------------------------*/m static voidt  clearscreen(int all, int attr) {     char cell[2];,     cell[0] = ' ';     cell[1] = attr;, #ifdef OS2MOUSEo    os2_mousehide() ; #endif /* OS2MOUSE */tB     VioWrtNCell(cell, xsize * ysize + (all ? xsize : 0), 0, 0, 0); #ifdef OS2MOUSEO    os2_mouseshow() ; #endif     lgotoxy(1, 1); }m  O /*---------------------------------------------------------------------------*/nO /* lgotoxy                                                                   */HO /*---------------------------------------------------------------------------*/o static voide lgotoxy(int x, int y) {/     wherex = x;*     wherey = y;=     if (cursoron)i.       VioSetCurPos(wherey - 1, wherex - 1, 0); }   O /*---------------------------------------------------------------------------*/,O /* scroll                                                                    */NO /*---------------------------------------------------------------------------*/. static voidM5 scroll(int updown, int top, int bottom, int nlines) {d     char blankcell[2];
     int i;       blankcell[0] = ' ';o #ifdef COMMENT     blankcell[1] = attribute;  #else  /*F    Fixed by fdc, Jan 94 -- If the new bottom line inherits the currentC    character attributes, then it will be padded out to the end withnJ    attribute-bearing spaces.  Create the new line with default attributes,D    then let subsequent-character writing operations take care of the    per-character attributes. */$     blankcell[1] = defaultattribute; #endif /* COMMENT */     switch (updown) {t     case UPWARD: #ifdef OS2MOUSE  	os2_mousehide() ; #endif> 	VioScrollUp(top, 0, bottom, xsize - 1, nlines, blankcell, 0);$         VioShowBuf(0, xsize * 2, 0);I         /* There is a bug in early OS/2 2.0 8514/A PM drivers that causes F          * wrong screen update after a scroll operation. We just forceC          * a correct screen update of the line in question here. */  #ifdef OS2MOUSEi 	os2_mouseshow() ; #endif 	if (dwls) {- 	    for (i = top; i <= bottom - nlines; i++)n  	      dwl[i] = dwl[i + nlines];4 	    for (i = bottom - nlines + 1; i <= bottom; i++) 	      dwl[i] = FALSE; 	} 	break;      case DOWNWARD: #ifdef OS2MOUSEk 	os2_mousehide() ; #endif> 	VioScrollDn(top, 0, bottom, xsize - 1, nlines, blankcell, 0);,         VioShowBuf(xsize * 2, xsize * 2, 0); #ifdef OS2MOUSEe 	os2_mouseshow() ; #endif 	if (dwls) {- 	    for (i = bottom; i >= top + nlines; i--)k 		dwl[i] = dwl[i - nlines];i. 	    for (i = top + nlines - 1; i >= top; i--) 	        dwl[i] = FALSE; 	} 	break;i     default: /* ignore */ ;.     }d     if (dwls) {x 	dwls = FALSE; 	for (i = 0; i < ysize; i++) 	    if (dwl[i]) { 		dwls = TRUE; 		break; 	    }     }  }d  O /*---------------------------------------------------------------------------*/ O /* movetoscreen                                                              */cO /*---------------------------------------------------------------------------*/  static voids3 movetoscreen(char *source, int x, int y, int len) {d #ifdef OS2MOUSEn     os2_mousehide() ;p #endif /* OS2MOUSE */d0     VioWrtCellStr(source, len, y - 1, x - 1, 0); #ifdef OS2MOUSEc     os2_mouseshow() ;  #endif }B  O /*---------------------------------------------------------------------------*/tO /* toplinetocyclicbuffer                                                     */LO /*---------------------------------------------------------------------------*/h static void  toplinetocyclicbuffer() {/     USHORT n = xsize * 2;/$     if (roll.numlines == LBUFSIZE) {  	if (++roll.topline == LBUFSIZE) 	  roll.topline = 0;
     } else       roll.numlines++;#     if (++roll.botline == LBUFSIZE)c       roll.botline = 0;  #ifdef OS2MOUSEm     os2_mousehide() ;u #endif<     VioReadCellStr((roll.buffer + xsize * 2 * roll.botline), 		   &n, 0, 0, 0); #ifdef OS2MOUSE      os2_mouseshow() ;v #endif }u  O /*---------------------------------------------------------------------------*//O /* cleartoeol                                                                */ O /*---------------------------------------------------------------------------*/  static void 
 clrtoeoln() {b     char cell[2];        cell[0] = ' '; #ifdef COMMENT     cell[1] = attribute; #elset     cell[1] = defaultattribute;r #endif /* COMMENT */ #ifdef OS2MOUSEt     os2_mousehide() ;c #endif /* OS2MOUSE */rE     VioWrtNCell(cell, xsize + 1 - wherex, wherey - 1, wherex - 1, 0);  #ifdef OS2MOUSEi     os2_mouseshow() ;u #endif };  O /*---------------------------------------------------------------------------*/ O /* setmargins                                                                */eO /*---------------------------------------------------------------------------*/t static voidi setmargins(int top, int bot) {     margintop = top;     marginbot = bot; }o  O /*---------------------------------------------------------------------------*/fO /* killcursor                                                                */ O /*---------------------------------------------------------------------------*/  static void  killcursor() {     VIOCURSORINFO nocursor;u+     if (!cursoron)			/* It's already off */f
       return; A     VioGetCurType(&crsr_info, 0);	/* Store current cursor type */l;     nocursor = crsr_info;		/* MS C allows structure copy */i     nocursor.attr = -1;l2     VioSetCurType(&nocursor, 0);	/* Hide cursor */     cursoron = FALSE;n }h  O /*---------------------------------------------------------------------------*/oO /* newcursor                                                                 */ O /*---------------------------------------------------------------------------*/c static void 
 newcursor() {w)     if (cursoron)			/* It's already on */a
       return;t!     VioSetCurType(&crsr_info, 0); ,     VioSetCurPos(wherey - 1, wherex - 1, 0);     cursoron = TRUE; }   O /*---------------------------------------------------------------------------*/XO /* line25                                                                    */NO /*---------------------------------------------------------------------------*/    #define STATUS_MAX 10*% static char *save_status[STATUS_MAX];x' static char *save_usertext[STATUS_MAX];x' static char *save_exittext[STATUS_MAX];x' static char *save_helptext[STATUS_MAX];x' static char *save_filetext[STATUS_MAX];x+ static char *save_savefiletext[STATUS_MAX]; ' static char *save_hostname[STATUS_MAX];0   static void0 save_status_line() {C     if ((++status_saved >= (STATUS_MAX - 1)) || (status_saved < 0))0
       return;t  8     if (!(save_status[status_saved] = malloc(MAXCOL+1)))
       return;V     else;       strncpy(save_status[status_saved],statusline,MAXCOL);i  :     if (!(save_usertext[status_saved] = malloc(MAXCOL+1)))
       return;h     else;       strncpy(save_usertext[status_saved],usertext,MAXCOL);s  :     if (!(save_exittext[status_saved] = malloc(MAXCOL+1)))
       return;0     else=       strncpy(save_exittext[status_saved],exittext,MAXCOL+1);c  :     if (!(save_helptext[status_saved] = malloc(MAXCOL+1)))
       return;o     else=       strncpy(save_helptext[status_saved],helptext,MAXCOL+1);n  :     if (!(save_filetext[status_saved] = malloc(MAXCOL+1)))
       return;      else=       strncpy(save_filetext[status_saved],filetext,MAXCOL+1);p  >     if (!(save_savefiletext[status_saved] = malloc(MAXCOL+1)))
       return;      elseE       strncpy(save_savefiletext[status_saved],savefiletext,MAXCOL+1);o  :     if (!(save_hostname[status_saved] = malloc(MAXCOL+1)))
       return;o     else=       strncpy(save_hostname[status_saved],hostname,MAXCOL+1);o }    static voidA restore_status_line() {lA     if ((status_saved >= (STATUS_MAX - 1)) || (status_saved < 0))s
       return;g  $     if (save_status[status_saved]) {6 	strncpy(statusline,save_status[status_saved],MAXCOL);! 	free(save_status[status_saved]);/     }c  &     if (save_usertext[status_saved]) {2 	strncpy(usertext,save_usertext[status_saved],20);# 	free(save_usertext[status_saved]);      }n  &     if (save_exittext[status_saved]) {2 	strncpy(exittext,save_exittext[status_saved],20);# 	free(save_exittext[status_saved]);t     }t  &     if (save_helptext[status_saved]) {2 	strncpy(helptext,save_helptext[status_saved],20);# 	free(save_helptext[status_saved]);h     }t  &     if (save_filetext[status_saved]) {2 	strncpy(filetext,save_filetext[status_saved],20);# 	free(save_filetext[status_saved]);l     }m  *     if (save_savefiletext[status_saved]) {: 	strncpy(savefiletext,save_savefiletext[status_saved],20);' 	free(save_savefiletext[status_saved]);      }t  &     if (save_hostname[status_saved]) {2 	strncpy(hostname,save_hostname[status_saved],20);# 	free(save_hostname[status_saved]);p     }        status_saved--; 
     line25();r }r   static voidG strinsert(char *d, char *s) {a     while (*s)       *d++ = *s++; }s   static voidC xline25(char *s) {     char attr;     attr = colorstatus;  #ifdef OS2MOUSEe     os2_mousehide() ;s #endif /* OS2MOUSE */o3     VioWrtCharStrAtt(s, xsize, ysize, 0, &attr, 0);t #ifdef OS2MOUSEW     os2_mouseshow() ;  #endif }    static voidt
 line25() {     char *s = statusline;*     int  i;e       for (i = 0; i < xsize; i++)  	s[i] = ' ';E     if (usertext[0]) strinsert(&s[00], usertext);	/* Leftmost item *//1     if (helptext[0]) strinsert(&s[18], helptext);01     if (exittext[0]) strinsert(&s[32], exittext); >     i = strlen(filetext);		/* How much needed for last item */     if (i > 0) {8 	strinsert(&s[79 - i], filetext); /* Right-justify it */ 	if (hostname[0]) { 5 	    i = 31 - i;			/* Space remaining for hostname */ < 	    if ((int) strlen(hostname) > (i - 1)) { /* Too long? */ 		int j;1 		for (j = i; j > 0 && hostname[j] != ':'; j--) ;	/ 		if (j > 0) {		/* Cut off ":service" if any */* 		    hostname[j] = '\0';t 		} else {		/* Or else ... */e0 		    hostname[i - 3] = '.'; /* show ellipsis */ 		    hostname[i - 2] = '.'; 		    hostname[i - 1] = '\0';A 		}b 	    } 	}     }d     if (hostname[0])"       strinsert(&s[47], hostname);     xline25(s);_ }l   #ifdef COMMENT static voide sendescseq(char * s) {     sendchar(27);n     while (*s) { 	if (!network) msleep(50); 	sendchar(*s++);     }m }t #endif /* COMMENT */   /*O  * RDCOMWRTSCR  --  Read from the communication device and write to the screen.o2  * This function is executed by a separate thread.  */i   int. ckcgetc(int dummy) {     return ttinc(1); }h  c #ifdef __32BIT__ void   rdcomwrtscr(void * pArgList) #else  void FAR
 rdcomwrtscr()e #endif /* __32BIT__ */ /* rdcomwrtscr */ {      int c, cx, tx;  ;     DosSetPrty(PRTYS_THREAD, PRTYC_FOREGROUNDSERVER, 0, 0);I #ifdef __32BIT__     DosPostEventSem(threadsem);  #else >     DosSemClear(&threadsem);		/* Let 'em know we've started */ #endif       while (active) {. 	if (f_pushed) {			/* Handle 8-bit controls */; 	    c = c_pushed;		/* by converting to ESC + 7-bit char */d 	    f_pushed = 0; 	    f_popped = 1;	 	} else {E9 	    c = ttinc(-50);		/* Get a character from the host */s3 	    cx = c & cmask;		/* C1 check must be masked */  	    f_popped = 0;: 	    if (tt_type >= TT_VT220) {	  /* VT220 and above... */9 		if (c1controls &&	  /* Character set has C1 controls */e7 		   (cx > 127) && (cx < 160) /* It's a C1 character */ 	 		    ) {  		    f_pushed = 1;e# 		    c_pushed = (c & 0x7F) | 0x40;, 		    c = ESC; 		}o 	    } 	}( 	if (!active)			/* Connection broken? */	 	  break;a3 	if (c >= 0) {			/* Got character with no error? */o  
 #ifdef TNCODEe-   	    /* Handle TELNET negotiations here */	a8 	    if (c == IAC && network && ttnproto == NP_TELNET) {= 		if ((tx = tn_doop((CHAR)(c & 0xff),duplex,ckcgetc)) == 0) {/ 		    continue;t( 		} else if (tx == -1) {	/* I/O error */1 		    strcpy(termessage, "Connection closed.\n");f  		    active = FALSE;	/* Quit */ 		    break;) 		} else if (tx == 1) {	/* ECHO change */ & 		    duplex = 1;		/* Get next char */ 		    continue;_) 		} else if (tx == 2) {	/* ECHO change */n& 		    duplex = 0;		/* Get next char */ 		    continue;s( 		} else if (tx == 3) {	/* Quoted IAC */' 		    c = 255;		/* proceeed with it. */c/ 		} else continue;	/* Unknown, get next char */h 	    } #endif /* TNCODE */v   #ifdef __32BIT__? 	    DosRequestMutexSem( hmtxScreenSem, SEM_INDEFINITE_WAIT ) ;  #ifdef OS2MOUSE( 	    if ( hMouse )@ 	      DosRequestMutexSem( hmtxMouseSem, SEM_INDEFINITE_WAIT ) ; #endif /* OS2MOUSE */c #elseg 	    DosEnterCritSec();v #endif /* __32BIT__ */D 	    if (tt_hide && cursoron && cursorena) /* Kill cursor if more */@ 	      if (ttchk() > 20)		/* than 20 input chars are buffered */ 		killcursor();i  3             c &= cmask;			/* Maybe strip 8th bit */i  = 	    if (sosi && !debses) {	/* Handle Shift In / Shift Out */   		if (c == SO) {	/* Shift Out */ 		    inshift = 1; 		    goto cont;& 		} else if (c == SI) { /* Shift In */ 		    inshift = 0; 		    goto cont; 		}b 		if (inshift) c |= 0200;r 	    }@ 	    if (escstate == ES_NORMAL) { /* Translate character sets */ 		if (sxi) c = (*sxi)((CHAR)c);t 		if (rxi) c = (*rxi)((CHAR)c);n 	    } #ifdef COMMENT- 	    /* No longer needed, done in cwrite() */d2 	    if (iskipesc) inesc = chkaes(inesc, (CHAR)c);( 	    /* Adjust escape sequence status */ #endif /* COMMENT */, 	    c &= cmdmsk;		/* Apply command mask. */ 	    if ((!debses) && (eH 	       (tnlm && (c == LF || c == FF || c == 11)) || /* NEWLINE-MODE? */4 	       (c == CR && tt_crd)  /* CR-DISPLAY CRLF ? */ 		)) {) 		cwrite((char) CR);	/* Yes, output CR */S! 		if (seslog) logchar((char) CR);d+ 		c = LF;		     /* and insert a linefeed */  	    } 	    cwrite((char) c);# 	    if (seslog) logchar((char) c);=   cont:	;  #ifdef __32BIT__ #ifdef OS2MOUSEs 	    if ( hMouse )+ 	      DosReleaseMutexSem( hmtxMouseSem ) ;a #endif /* OS2MOUSE */e* 	    DosReleaseMutexSem( hmtxScreenSem ) ; #else  	    DosExitCritSec(); #endif /* __32BIT__ */   	} else if (c == -2) {             active = FALSE; 0 	    strcpy(termessage, "Connection closed.\n");             /* link broken */ 0 	} else if (tt_hide && !cursoron && cursorena) { #ifdef __32BIT__? 	    DosRequestMutexSem( hmtxScreenSem, SEM_INDEFINITE_WAIT ) ;( #ifdef OS2MOUSES 	    if ( hMouse )@ 	      DosRequestMutexSem( hmtxMouseSem, SEM_INDEFINITE_WAIT ) ; #endif /* OS2MOUSE */  #else  	    DosEnterCritSec();w #endif /* __32BIT__ */ 	    newcursor();a #ifdef __32BIT__ #ifdef OS2MOUSEO 	    if ( hMouse )+ 	      DosReleaseMutexSem( hmtxMouseSem ) ;  #endif /* OS2MOUSE */a* 	    DosReleaseMutexSem( hmtxScreenSem ) ; #else* 	    DosExitCritSec(); #endif /* __32BIT__ */ 	}     }    #ifdef __32BIT__    _endthread() ;t #else D     DosEnterCritSec();		/* Stop thread 1 discarding our stack before 				 * we've gone */>     DosSemClear(&threadsem);	/* Tell him we're going to die */     DosExit(EXIT_THREAD, 0); #endif /* __32BIT__ */ }   4 /* POPUPHELP  --  Give help message for connect.  */   static int helpcol, helprow; static int helpwidth;*   static voidN2 helpstart(int w, int h) {		/* Start help window */     unsigned char cell[2];       cell[1] = colorhelp;     helpwidth = w;,     helpcol = (xsize - w) / 2;		/* Column */,     helprow = (ysize - h) / 2 - 1;	/* Row */;     cell[0] = 201;			/* IBM upper left box corner double */s #ifdef OS2MOUSEe     os2_mousehide() ;  #endif /* OS2MOUSE */ .     VioWrtNCell(cell, 1, helprow, helpcol, 0);;     cell[0] = 205;			/* Center box bar horizontal double */e:     VioWrtNCell(cell, helpwidth, helprow, helpcol + 1, 0);8     cell[0] = 187;			/* Upper right box corner double */>     VioWrtNCell(cell, 1, helprow, helpcol + helpwidth + 1, 0); #ifdef OS2MOUSE      os2_mouseshow() ;  #endif }    static void;2 helpline(char *s) {			/* Add line to popup help */     unsigned char cell[2];
     int i;  .     i = strlen(s);			/* Length of this line */     helprow++;     cell[1] = colorhelp;9     cell[0] = 186;			/* IBM center bar vertical double */7 #ifdef OS2MOUSEc     os2_mousehide() ;/ #endif /* OS2MOUSE */N.     VioWrtNCell(cell, 1, helprow, helpcol, 0);>     VioWrtCharStrAtt(s, i, helprow, helpcol + 1, &cell[1], 0);     cell[0] = ' ';B     VioWrtNCell(cell, helpwidth - i, helprow, helpcol + 1 + i, 0);9     cell[0] = 186;			/* IBM center bar vertical double */_>     VioWrtNCell(cell, 1, helprow, helpcol + helpwidth + 1, 0); #ifdef OS2MOUSE      os2_mouseshow() ;  #endif }m   static void * helpend() {				/* End of popup help box */     unsigned char cell[2];   #ifdef OS2MOUSE      os2_mousehide() ;r #endif /* OS2MOUSE */a     helprow++;     cell[1] = colorhelp;;     cell[0] = 200;			/* IBM lower left box corner double */ .     VioWrtNCell(cell, 1, helprow, helpcol, 0);;     cell[0] = 205;			/* Center box bar horizontal double */ :     VioWrtNCell(cell, helpwidth, helprow, helpcol + 1, 0);8     cell[0] = 188;			/* Lower right box corner double */>     VioWrtNCell(cell, 1, helprow, helpcol + helpwidth + 1, 0); #ifdef OS2MOUSE-     os2_mouseshow() ;- #endif }*  
 static int popuphelp(int x) {
     int c, n;      char line[81];     char kn[41];     char *s;     static char *hlpmsg[] = {-   "", "   " Command:   (SPACE to cancel)",   "",j.   "    C    to return to the C-Kermit prompt",0   "    U    to hangUp and return to the prompt",)   "    Q    to hangup and Quit C-Kermit",t1   "    !    to enter the OS/2 command processor",t1   "    F    to print or File the current screen",u   "",,#   "    0    (zero) to send a null",i+   "   ^%c    to send the escape character",o$   "    B    to send a BREAK signal","   "    L    to send a Long BREAK",   "",t
 #ifdef TNCODE +   "    I    to Interrupt process (TELNET)", 1   "    A    to send \"Are you there?\" (TELNET)",y   "",x #endif /* TNCODE */ 1   "    \\    backslash escape (end with ENTER):", .   "         \\nnn   decimal code, like \\199",-   "         \\Onnn  octal code, like \\o307", 2   "         \\Xhh   hexadecimal code, like \\xC7",   ""};0 #define HELPSIZE (sizeof(hlpmsg)/sizeof(char *))       static char *cmposmsg[] = { 4   " COMPOSE SEQUENCES FOR MULTINATIONAL CHARACTERS",   "",T6   " Press two keys to compose the desired character:",   "",y   " First  Second  Result", -   "   '     Vowel   Vowel with acute accent", -   "   `     Vowel   Vowel with grave accent", 8   "   \"     Vowel   Vowel with diaeresis/trema/umlaut",+   "   ^     Vowel   Vowel with circumflex",    "   *       A     A ring",   "   ,       C     C cedilla", '   "   ~     N,A,O   Letter with tilde",v    "   A       E     AE digraph",#   "   O       /     O with stroke",s$   "   s       s     German sharp s",   "",v(   " And others; see the documentation.", };5 #define COMPOSESIZE (sizeof(cmposmsg)/sizeof(char *))    #ifdef COMMENT@     unsigned char cell[MAXCOL * 2];	/* For saving status line */
     USHORT w;C     w = xsize * 2; #ifdef OS2MOUSE_     os2_mousehide() ;' #endifE     VioReadCellStr(cell, &w, ysize - 1, 0, 0); /* Read status line *// #ifdef OS2MOUSE      os2_mouseshow() ;  #endif #else /* !COMMENT */ #ifdef __32BIT__>     DosRequestMutexSem( hmtxScreenSem, SEM_INDEFINITE_WAIT ) ; #endif /* __32BIT__ */8     save_status_line();			/* Save current status line */ #endif /* COMMENT */  *     savescreen(&helpscreen,wherex,wherey);     if (cursorena)       killcursor();r7     if (x > 0) {			/* List escape-character commands */eA 	n = (x == 1) ? HELPSIZE : COMPOSESIZE; /* or compose-key help */-  	helpstart(x == 1 ? 47 : 52, n); 	for (c = 0; c < n; c++) {, 	    s = (x == 1) ? hlpmsg[c] : cmposmsg[c]; 	    if (strchr(s, '%')) {  		sprintf(line, s, ctl(escape)); 		helpline(line);s 	    } else  	      helpline(s);r 	}  %     } else {				/* List "hot keys" */w  C 	strcpy(usertext, " Press (almost) any key to restore the screen");-/ 	exittext[0] = helptext[0] = hostname[0] = NUL; 
 	line25();   	if (roll.flag) { A 	    s = " OS/2 C-KERMIT - SCREEN ROLLBACK KEYS"; /* Box title */-0 	    n = 13;			/* How many lines for help box */D 	    if (vik.upscn   < 256) n--;	/* Deduct for verbs not assigned */  	    if (vik.upone   < 256) n--;  	    if (vik.dnscn   < 256) n--;  	    if (vik.dnone   < 256) n--;  	    if (vik.homscn  < 256) n--;  	    if (vik.endscn  < 256) n--;  	    if (vik.prtscn  < 256) n--;  6 	    helpstart(50, n);		/* Make popup window 50 x n */ 	    helpline(s);		/* 1 */ 	    helpline("");		/* 2 */,  6 	    if (vik.upscn > 255 && keynam[vik.upscn - 256]) {) 		strncpy(kn,keynam[vik.upscn - 256],40);e= 		sprintf(line,"  %-15.14s%s",kn,"Roll backward one screen");* 		helpline(line);		/* 3 */ 	    }6 	    if (vik.upone > 255 && keynam[vik.upone - 256]) {) 		strncpy(kn,keynam[vik.upone - 256],40);x6 		sprintf(line,"  %-15.14s%s",kn,"Backward one line"); 		helpline(line);		/* 4 */ 	    }6 	    if (vik.dnscn > 255 && keynam[vik.dnscn - 256]) {) 		strncpy(kn,keynam[vik.dnscn - 256],40);/< 		sprintf(line,"  %-15.14s%s",kn,"Roll forward one screen"); 		helpline(line);		/* 5 */ 	    }6 	    if (vik.dnone > 255 && keynam[vik.dnone - 256]) {) 		strncpy(kn,keynam[vik.dnone - 256],40);L5 		sprintf(line,"  %-15.14s%s",kn,"Forward one line");( 		helpline(line);		/* 6 */ 	    }8 	    if (vik.homscn > 255 && keynam[vik.homscn - 256]) {* 		strncpy(kn,keynam[vik.homscn - 256],40);6 		sprintf(line,"  %-15.14s%s",kn,"Back to beginning"); 		helpline(line);		/* 7 */ 	    }8 	    if (vik.endscn > 255 && keynam[vik.endscn - 256]) {* 		strncpy(kn,keynam[vik.endscn - 256],40);3 		sprintf(line,"  %-15.14s%s",kn,"Forward to end");s 		helpline(line);		/* 8 */ 	    }4 	    if (vik.dump > 255 && keynam[vik.dump - 256]) {( 		strncpy(kn,keynam[vik.dump - 256],40);= 		sprintf(line,"  %-15.14s%s",kn,"Print the current screen");  		helpline(line);		/* 9 */ 	    } 	    helpline("");		/* 10 */ 	    helpline(tt_roll ?=9 		     " TERMINAL ROLL is ON: No other keys are valid." :m3 		     " TERMINAL ROLL is OFF: All keys are valid."  		     );			/* 11 */B 	    sprintf(line, " Rollback buffer size: %d lines.",tt_scrsize); 	    helpline(line);		/* 12 */E 	    helpline(" Use SET TERMINAL SCROLLBACK to change it."); /* 13 */   & 	} else {			/* Regular help message */ 	    1# 	    n = 19;			/* How many lines */ + 	    s = " OS/2 C-KERMIT - IMPORTANT KEYS";sD 	    if (vik.upscn   < 256) n--;	/* Deduct for verbs not assigned */  	    if (vik.dnscn   < 256) n--;  	    if (vik.flipscn < 256) n--;  	    if (vik.debug   < 256) n--;  	    if (vik.reset   < 256) n--;  	    if (vik.prtscn  < 256) n--;  	    if (vik.printff < 256) n--;  	    if (vik.compose < 256) n--;  6 	    helpstart(50, n);		/* Make popup window 50 x n */ 	    helpline(s);		/* 1 */ 	    helpline("");		/* 2 */)  2 	    if (vik.exit > 255 && keynam[vik.exit - 256])- 	      strncpy(kn,keynam[vik.exit - 256],40);l	 	    else., 	      sprintf(kn, "Ctrl-%c?", ctl(escape));E 	    sprintf(line,"  %-15.14s%s",kn,"Return to the C-Kermit prompt");- 	    helpline(line);			/* 3 */  6 	    if (vik.hangup > 255 && keynam[vik.hangup - 256])/ 	      strncpy(kn,keynam[vik.hangup - 256],40);-	 	    else-, 	      sprintf(kn, "Ctrl-%cH", ctl(escape));H 	    sprintf(line,"  %-15.14s%s",kn,"Hang up and return to the prompt"); 	    helpline(line);			/* 4 */  0 	    if (vik.os2 > 255 && keynam[vik.os2 - 256]), 	      strncpy(kn,keynam[vik.os2 - 256],40);	 	    else , 	      sprintf(kn, "Ctrl-%c!", ctl(escape));D 	    sprintf(line,"  %-15.14s%s",kn,"Enter OS/2 command processor"); 	    helpline(line);			/* 5 */  6 	    if (vik.xbreak > 255 && keynam[vik.xbreak - 256])/ 	      strncpy(kn,keynam[vik.xbreak - 256],40);f	 	    elsej, 	      sprintf(kn, "Ctrl-%cB", ctl(escape));$ 	    sprintf(line,"  %-15.14s%s",kn,* 		    (network && ttnproto == NP_TELNET) ? 		    "Send TELNET BREAK" :s 		    "Send a BREAK signal"	 		    ); 	    helpline(line);			/* 6 */   	    if (!network) {7 		if ((vik.lbreak > 255) && (keynam[vik.lbreak - 256]))s, 		  strncpy(kn,keynam[vik.lbreak - 256],40); 		else) 		  sprintf(kn, "Ctrl-%cL", ctl(escape)); = 		sprintf(line,"  %-15.14s%s",kn,"Send a Long BREAK signal");S 		helpline(line);			/* 7 */U 	    }  2 	    if (vik.dump > 255 && keynam[vik.dump - 256])- 	      strncpy(kn,keynam[vik.dump - 256],40);.	 	    elsei, 	      sprintf(kn, "Ctrl-%cF", ctl(escape));@ 	    sprintf(line,"  %-15.14s%s",kn,"Print the current screen"); 	    helpline(line);			/* 8 */  8 	    if (vik.prtscn > 255 && keynam[vik.prtscn - 256]) {* 		strncpy(kn,keynam[vik.prtscn - 256],40);3 		sprintf(line,"  %-15.14s%s%s",kn,"Turn printer ",c 			printon ? "OFF" : "ON");o! 		helpline(line);		/* 9, maybe */  	    }  : 	    if (vik.printff > 255 && keynam[vik.printff - 256]) {+ 		strncpy(kn,keynam[vik.printff - 256],40);-? 		sprintf(line,"  %-15.14s%s",kn,"Print formeed / page eject");o" 		helpline(line);		/* 10, maybe */ 	    }  6 	    if (vik.upscn > 255 && keynam[vik.upscn - 256]) {) 		strncpy(kn,keynam[vik.upscn - 256],40);n= 		sprintf(line,"  %-15.14s%s",kn,"Roll backward one screen"); " 		helpline(line);		/* 11, maybe */ 	    }  6 	    if (vik.dnscn > 255 && keynam[vik.dnscn - 256]) {) 		strncpy(kn,keynam[vik.dnscn - 256],40); < 		sprintf(line,"  %-15.14s%s",kn,"Roll forward one screen");" 		helpline(line);		/* 12, maybe */ 	    }  : 	    if (vik.flipscn > 255 && keynam[vik.flipscn - 256]) {+ 		strncpy(kn,keynam[vik.flipscn - 256],40);s# 		sprintf(line,"  %-15.14s%s%s",kn,($ 			(decscnm ? "Normal" : "Reverse"), 			" screen video");" 		helpline(line);		/* 13, maybe */ 	    }  6 	    if (vik.debug > 255 && keynam[vik.debug - 256]) {) 		strncpy(kn,keynam[vik.debug - 256],40);i> 		sprintf(line,"  %-15.14s%s%s",kn,"Turn terminal debugging ", 			debses ? "OFF" : "ON");" 		helpline(line);		/* 14, maybe */ 	    }  6 	    if (vik.reset > 255 && keynam[vik.reset - 256]) {) 		strncpy(kn,keynam[vik.reset - 256],40);t@ 		sprintf(line,"  %-15.14s%s",kn,"Reset the terminal emulator");" 		helpline(line);		/* 15, maybe */ 	    }  : 	    if (vik.compose > 255 && keynam[vik.compose - 256]) {+ 		strncpy(kn,keynam[vik.compose - 256],40);a@ 		sprintf(line,"  %-15.14s%s",kn,"Compose a special character");" 		helpline(line);		/* 16, maybe */ 	    }   	    helpline("");		/* 17 */B 	    sprintf(line," or the CONNECT-mode escape character Ctrl-%c", 		    ctl(escape));; 	    helpline(line);		/* 18 */B 	    helpline(" followed by ? for additional commands."); /* 19 */   	}     } 2     helpend();				/* Write bottom of help panel */;     c = keymap[congks(0)];		/* Wait till user hits a key */i/     if (cursorena)			/* If cursor is enabled */ *       newcursor();			/* turn it back on */>     restorescreen(&helpscreen);		/* Restore terminal screen */ #ifdef COMMENT #ifdef OS2MOUSE;     os2_mousehide() ;i #endif /* OS2MOUSE */FI     VioWrtCellStr(cell, w, ysize -1, 0, 0); /* Restore the status line */  #ifdef OS2MOUSE}     os2_mouseshow() ;l #endif #else      restore_status_line(); #ifdef __32BIT__)     DosReleaseMutexSem( hmtxScreenSem ) ;c #endif /* __32BIT__ */ #endif /* COMMENT */     return (c);t }u  < /* CHSTR  --  Make a printable string out of a character  */   static char* chstr(int c) {     static char s[8];/     char *cp = s;        if (c < SP || c == DEL) %       sprintf(cp, "CTRL-%c", ctl(c));      else       sprintf(cp, "'%c'\n", c);      cp = s;=     return (cp); }F  6 /* DOESC  --  Process an escape character argument  */   static void  esc25(int h) {"     strcpy(usertext, " Command:");D     strcpy(exittext, h ? "" : (esc_exit ? "Exit: c" : "Prompt: c"));)     strcpy(helptext, h ? "" : "Help: h"); 
     line25();l }t   static voidf doesc(int c) {
     int x;     CHAR d, temp[8];       while (1) {S/ 	if (c == escape) {	/* Send escape character */- 	    sendchar((char)c);S 	    return;7 	} else if (isupper(c))	/* Or else look it up below. */) 	    c = tolower(c);  
 	switch (c) {   " 	case 'c':		/* Return to prompt */ 	case '\03': 	    active = 0; 	    return;  3 	case 'u':		/* Hangup and return to command mode */o 	    hangnow = 1;f 	    active = 0;% 	    strcpy(termessage, "Hangup.\n");, 	    return;  . 	case 'q':               /* Hangup and quit */ 	    active = 0; 	    hangnow = 1;l 	    quitnow = 1;n. 	    strcpy(termessage, "Hangup and quit.\n"); 	    return;   	case '!':		/* Push to OS/2 */ 	    os2push();; 	    return;  % 	case 'b':		/* Send a BREAK signal */o 	case '\02': 	    ttsndb(); 	    return;  * 	case 'l':		/* Send a Long BREAK signal */
 	case '\014':= 	    ttsndlb();  	    return;  # 	case 'f':		/* Print/dump screen */l  	    x = xprintff; xprintff = 0; 	    prtscreen(1,ysize); 	    xprintff = x; 	    return;  & 	case '0':		/* Send a NUL character */ 	    c = '\0'; 	    sendchar((char)c);2 	    return;   #ifdef NETCONN #ifdef TCPSOCKET0 	case 'i':			/* Send TELNET Interrupt Process */ 	    do_tn_cmd((CHAR) IP); 	    return;  # 	case 'a':			/* "Are You There?" */; 	    do_tn_cmd((CHAR) AYT);  	    return; #endif /* TCPSOCKET */ #endif /* NETCONN */           case '\\':
             {                  char kbuf[32];) 		char *kbp = kbuf, *text = usertext + 2;)  
 		*kbp++ = c;i  (                 strcpy(usertext, " \\");/                 strcpy(exittext,"Exit: ENTER");r                  helptext[0] = 0;                 line25();   ? 		while (((c = (coninc(0) & cmdmsk)) != '\r') && (c != '\n')) {O$                   if ( c == '\b' ) {+                     if ( kbp > kbuf + 1 ) {r 		      *--kbp = 0;a"                       *--text = 0;                     }*?                   } else if ( kbp - kbuf < sizeof(kbuf) - 2 ) {d 		    *kbp++ = c;=                      *text++ = c;                     *text = 0;                   }n                   line25();e                 }e   		*kbp = 0; kbp = kbuf;{% 		c = xxesc(&kbp);	/* Interpret it */t   		if (c >= 0) {p% 	            sendcharduplex((char)c); 
 		    return;L) 		} else {		/* Invalid backslash code. */	 		    conoc(BEL);o
 		    return;  		}  	    }             return;	   	case SP:		/* Space, ignore */ 	    return;   	default:		/* Other */ 	    conoc(BEL);) 	    return;		/* Invalid esc arg, beep */  	}     }e }   < /* CHECKSCREENMODE  --  Make sure we are in a usable mode */  * int					/* NOTE: not static, on purpose */$ ttgwsiz() {				/* Get Window Size */     if (xsize < 0 || ysize < 0)K       checkscreenmode();1     return((tt_rows < 1 || tt_cols < 1) ? 0 : 1);c }i   static void  checkscreenmode() {      VIOMODEINFO  m;	0 #ifdef COMMENT				/* Moved to setcursormode() */     VIOINTENSITY vi;       vi.cb = sizeof(vi);      vi.type = 2;     vi.fs = 1;     VioSetState(&vi, 0); #endif /* COMMENT */          m.cb = sizeof(m); #     assert(VioGetMode(&m, 0) == 0);v  K     /* Terminal screen not created yet, or user changed the screen size. */   K     if ( xsize != min(MAXCOL, m.col) || ysize != min(MAXROW, m.row) - 1 ) {r 	scrninitialised = 0;  	if ( roll.buffer )t 	  free(roll.buffer);e 	roll.buffer = NULL; 	if ( vt100screen.scrncpy )R 	  free(vt100screen.scrncpy);  	vt100screen.scrncpy = NULL; 	if ( commandscreen.scrncpy )  	  free(commandscreen.scrncpy);o 	commandscreen.scrncpy = NULL; 	if ( savedscreen.scrncpy )  	  free(savedscreen.scrncpy);; 	savedscreen.scrncpy = NULL; 	if ( helpscreen.scrncpy ) 	  free(helpscreen.scrncpy); 	helpscreen.scrncpy = NULL;  #ifdef OS2MOUSE  	if ( mousescreen.scrncpy )t 	  free(mousescreen.scrncpy);  	mousescreen.scrncpy = NULL; #endif /* OS2MOUSE */s(    tt_cols = xsize = min(MAXCOL, m.col);* 	tt_rows = ysize = min(MAXROW, m.row) - 1; /*L   If there is a scrolling window in effect, this will wipe it out.  However,M   this code is executed only upon the first CONNECT, or when the user changedeL   screen sizes while escaped back.  Any nondefault scrolling region does notM   make sense under these conditions anyway.  The "if" clause is commented out	L   because leaving it in could do more harm than good, for example if the new2   screen is smaller than the old scrolling region.           if (!relcursor)	 */ 	  marginbot = ysize;      }d!     if ( !vt100screen.scrncpy ) { 7 	vt100screen.scrncpy = malloc(xsize * (ysize + 1) * 2);      } (     assert(vt100screen.scrncpy != NULL);!     if ( !commandscreen.scrncpy )m>       commandscreen.scrncpy = malloc(xsize * (ysize + 1) * 2);*     assert(commandscreen.scrncpy != NULL);     if ( !savedscreen.scrncpy )	<       savedscreen.scrncpy = malloc(xsize * (ysize + 1) * 2);(     assert(savedscreen.scrncpy != NULL);     if ( !helpscreen.scrncpy );       helpscreen.scrncpy = malloc(xsize * (ysize + 1) * 2); '     assert(helpscreen.scrncpy != NULL);  #ifdef OS2MOUSEe     if ( !mousescreen.scrncpy ) <       mousescreen.scrncpy = malloc(xsize * (ysize + 1) * 2);(     assert(mousescreen.scrncpy != NULL); #endif /* OS2MOUSE */; }/   static voide setcursormode() {      VIOMODEINFO vmi;     VIOCURSORINFO vci;     VIOINTENSITY vi;     int cell, bottom, top;       vmi.cb = sizeof(vmi);w     VioGetMode(&vmi, 0);      cell   = vmi.vres / vmi.row;       VioGetCurType(&vci, 0);8     crsr_command = vci;        vci.cEnd   = cell - 1;.     vci.yStart = (tt_cursor == 0) ? cell - 2 :7                  cell - 1 - (cell - 2) * tt_cursor / 2;        VioSetCurType(&vci, 0);n /*E   Note: For some reason, choosing vi.fs = 0 makes *everything* blink. G   Receipt of "turn-on-blink" escape sequences turn off blinking.  Thus,rJ   everything is backwards.  But when vi.fs = 1, the sense is not reversed.   A puzzle.r */     vi.cb = sizeof(vi);y3     vi.type = 2;			/* High-intensity vs blinking */N6     vi.fs = 1;				/* 0 = blinking, 1 = hi intensity */     VioSetState(&vi, 0); }	   static voidl restorecursormode() {l$     VioSetCurType(&crsr_command, 0); }    #ifdef __32BIT__ /* C O N K B D H A N D L E R */    void conkbdhandler(void *pArgList) {x     int c, cm, cx, tx;        DosPostEventSem(threadsem2);  C   while (active) {		/* Read the keyboard and write to comms line *//% 	c = congks(1);			/* Get keystroke */u+ 	if (!active)			/* Exit if this happened */t+ 	  break;			/*  (in any of various ways) */   	if (c == -1) {			/* like:... */ 	    if (!active)a- 	      strcpy(termessage, "Carrier lost.\n");r 	    continue; 	}' 	cm = keymap[c];			/* Do key mapping */ 7 	if (cm == escape) {		/* Is it the escape character? */v? 	    DosRequestMutexSem( hmtxScreenSem, SEM_INDEFINITE_WAIT ) ;n? 	    save_status_line();		/* Yes, save current status line.  */ $ 	    esc25(0);			/* Make new one. */5 	    c = keymap[congks(0)];	/* Get escape command. */nG 	    if (c == '?' || c == 'h' || c == 'H') { /* They want help menu. */x! 	        esc25(1);		/* Show it */t6 		c = popuphelp(1);	/* Then get real escape command */ 	    }% 	    doesc(c);			/* And process it */i: 	    restore_status_line();	/* Then restore status line */)    	DosReleaseMutexSem( hmtxScreenSem ) ;t$ 	} else {			/* Ordinary character */1 	    if (!keylock)		/* If keyboard not locked, */s) 	      vt100key(c);		/* go process it. */i 	}     } /* while (active) */       _endthread() ; }g #endif /* __32BIT__ */    0 /*  C O N E C T  --  Perform CONNECT command  */   int				/* NOTE: Not static */r
 conect() {     USHORT          len, x, y;E     int             i, c, cm;	/* c is a character, but must be signed , 				 * integer to pass thru -1, which is the) 				 * modem disconnection signal, and is + 				 * different from the character 0377 */n  "     char errmsg[50], *erp, ac, bc;  
 #ifdef CK_APC      apcactive = FALSE; #endif /* CK_APC */t      if (!network && speed < 0) {. 	printf("Sorry, you must set speed first.\n"); 	return (0);     }r  *     if ((escape < 0) || (escape > 0177)) {7 	printf("Escape character out of range: %d\n", escape);M 	return (0);     }mE     if (ttopen(ttname, &local, network ? -nettype : mdmtyp, 0) < 0) {k 	erp = errmsg;. 	sprintf(erp, "Sorry, can't open %s", ttname); 	perror(errmsg); 	return (0);     }a;     /* Condition console terminal and communication line */m      if (ttvt(speed, flow) < 0) {7 	printf("Sorry, Can't condition communication line\n");  	return (0);     } E     if (!network && carrier != CAR_OFF && (ttgmdm() & BM_DCD) == 0) {e6         printf("No carrier detected on %s.\n",ttname);B 	printf("Hint: Use the DIAL command, or else SET CARRIER OFF.\n"); 	printf(I   "If you want to make a network connection, use SET HOST or TELNET.\n");  	return (0);     } 9     my_tt_type = tt_type;		/* Remember prevailing type */ <     what = W_CONNECT;			/* Keep track of what we're doing */  4     /* Will C-Kermit exit when user escapes back? */  +     esc_exit = (cflg || cnflg) && !stayflg; .     esc_msg  = esc_exit ? "Exit:" : "Prompt:";  *     /* Construct ENQ/Answerback message */0     sprintf(answerback,"OS/2 C-Kermit %ld %s\n", 	    vernum, 	    tt_info[my_tt_type].x_name  	    );   2     /* Initialize Very Important Keys structure */       vik.help = 0;a     vik.exit = 0;p     vik.upscn = 0;     vik.dnscn = 0;     vik.upone = 0;     vik.dnone = 0;     vik.homscn = 0;/     vik.endscn = 0;e     vik.hangup = 0;      vik.xbreak = 0;m     vik.lbreak = 0;      vik.dump = 0;m     vik.prtscn = 0;      vik.os2 = 0;     vik.printff = 0;     vik.flipscn = 0;     vik.debug = 0;     vik.reset = 0;     vik.compose = 0;  $     for (i = 256; i < KMSIZE; i++) {4 	if (!vik.help && (keymap[i] == (F_KVERB | K_HELP))) 	  vik.help = i;9 	else if (!vik.exit && (keymap[i] == (F_KVERB | K_EXIT)))  	  vik.exit = i;+ 	else if (keymap[i] == (F_KVERB | K_UPSCN))r 	  vik.upscn = i;a+ 	else if (keymap[i] == (F_KVERB | K_DNSCN))k 	  vik.dnscn = i;n+ 	else if (keymap[i] == (F_KVERB | K_UPONE))l 	  vik.upone = i;v+ 	else if (keymap[i] == (F_KVERB | K_DNONE))/ 	  vik.dnone = i; , 	else if (keymap[i] == (F_KVERB | K_HOMSCN)) 	  vik.homscn = i;, 	else if (keymap[i] == (F_KVERB | K_ENDSCN)) 	  vik.endscn = i;= 	else if (!vik.hangup && (keymap[i] == (F_KVERB | K_HANGUP)))* 	  vik.hangup = i;< 	else if (!vik.xbreak && (keymap[i] == (F_KVERB | K_BREAK))) 	  vik.xbreak = i;= 	else if (!vik.lbreak && (keymap[i] == (F_KVERB | K_LBREAK)))c 	  vik.lbreak = i;9 	else if (!vik.dump && (keymap[i] == (F_KVERB | K_DUMP)))  	  vik.dump = i;? 	else if (!vik.flipscn && (keymap[i] == (F_KVERB | K_FLIPSCN)))  	  vik.flipscn = i;+; 	else if (!vik.debug && (keymap[i] == (F_KVERB | K_DEBUG)))  	  vik.debug = i; ; 	else if (!vik.reset && (keymap[i] == (F_KVERB | K_RESET)))l 	  vik.reset = i;o7 	else if (!vik.os2 && (keymap[i] == (F_KVERB | K_DOS)))s 	  vik.os2 = i;i= 	else if (!vik.prtscn && (keymap[i] == (F_KVERB | K_PRTSCN)))e 	  vik.prtscn = i;? 	else if (!vik.printff && (keymap[i] == (F_KVERB | K_PRINTFF)))g 	  vik.printff = i;t? 	else if (!vik.compose && (keymap[i] == (F_KVERB | K_COMPOSE)))  	  vik.compose = i;      } 0     keymac = 0;				/* Initialize \Kmacro flag */#     keymacx = -1;			/* and index */e  =     outshift = inshift = 0;		/* Initial SI/SO shift state. */n@     langsv = language;			/* No language rules during CONNECT! */     language = L_USASCII;l,     if (debses) {			/* Session debugging? */5 	tcs = TC_TRANSP;		/* No character-set translation */c0 	sxo = rxo = NULL;		/* If so, no translation. */ 	sxi = rxi = NULL;; 	escstate = ES_NORMAL;		/* No escape-sequence processing */ $ 	tt_wrap = TRUE;			/* Always wrap */*     } else {				/* No session debugging */5 	tcs = gettcs(tcsr,tcsl);	/* Get intermediate set. */ ; 	if (tcsr == tcsl) {		/* Remote and local sets the same? */a4 	    sxo = rxo = NULL;		/* If so, no translation. */ 	    sxi = rxi = NULL;# 	} else {			/* Otherwise, set up */i5 	    sxo = xls[tcs][tcsl];	/* translation function */a> 	    rxo = xlr[tcs][tcsr];	/* pointers for output functions */9 	    sxi = xls[tcs][tcsr];	/* and for input functions. */S 	    rxi = xlr[tcs][tcsl]; 	}     }o /*@   C1 Control characters are possible only if the remote terminalC   character set does not include graphic characters in the C1 area.  */B     c1controls = (tcsl != tcsr) &&	/* Transparent character-set */=                  (tcsr != FC_CP850) &&	/* or IBM code page */  		 (tcsr != FC_CP437) && 		 (tcsr != FC_CP852) &&3 		 (tcsr != FC_NEXT) &&	/* or NeXT character set */ / 		 (tcsr != FC_APPQD);	/* or Apple Quickdraw */    #ifdef COMMENT     iskipesc =   #endif /* COMMENT */<       oskipesc = (tcs != TC_TRANSP) &&	/* Not transparent */N       (fcsinfo[tcsl].size == 128 || fcsinfo[tcsr].size == 128) && /* 7 bits */$ 	(fcsinfo[tcsl].code != FC_USASCII); #ifdef COMMENT     inesc =  #endif /* COMMENT */<       outesc = ES_NORMAL;		/* Initial state of recognizer */   #ifdef CK_BORDER4     saveborder();			/* Save command-screen border */ #endif /* CK_BORDER */;     checkscreenmode();			/* Initialize terminal emulator */+     setcursormode();B     VioGetCurPos(&y, &x, 0);		/* Command screen cursor position */     wherex = x + 1;      wherey = y + 1; H     savescreen(&commandscreen,wherex,wherey); /* Remember OS/2 screen */>     colorcmd = commandscreen.scrncpy[(x + y * xsize) * 2 + 1];     scrninit();e?     restorescreen(&vt100screen);	/* Put up previous terminal */ # 					/* emulation screen, if any */e'     newcursor();			/* Install cursor */*.     conraw();				/* Put console in raw mode */1     connoi();				/* No interrupts from console */'*     ipadl25();				/* Put up status line */3     waittime = tt_ctstmo * 1000L;	/* CTS timeout */	  H     /* Create a thread to read the comms line and write to the screen */  7     active = 1;			/* So thread 2 doesn't end at once */      quitnow = 0;     hangnow = 0;     termessage[0] = 0;   #ifdef __32BIT__.     DosCreateEventSem(NULL, &threadsem, 0, 0);+     DosResetEventSem(threadsem, &semcount);r?     threadid = _beginthread( &rdcomwrtscr, 0, THRDSTKSIZ, 0 ) ;e     if ( threadid == -1 ) {	( 	printf("Sorry, can't create thread\n"); 	return (0);     }d$     DosWaitEventSem(threadsem, -1L); #else /* Not __32BIT__ */nH     DosSemSet(&threadsem);	/* Thread 2 will clear this when it starts *//     if (DosCreateThread(rdcomwrtscr, &threadid,v" 			(PBYTE)(stack + THRDSTKSIZ))) {( 	printf("Sorry, can't create thread\n"); 	return (0);     } >     DosSemWait(&threadsem, -1L);/* Wait for thread to start */H     DosSemSet(&threadsem);	/* Thread 2 will clear this on termination */ #endif /* __32BIT__ */   #ifdef __32BIT__4    /* Use a separate thread for Keyboard handling */  /     DosCreateEventSem(NULL, &threadsem2, 0, 0); -     DosResetEventSem(threadsem2, &semcount2); B     threadid2 = _beginthread( &conkbdhandler, 0, THRDSTKSIZ, 0 ) ;     if ( threadid2 == -1) {A( 	printf("Sorry, can't create thread\n"); 	return (0);     }'%     DosWaitEventSem(threadsem2, -1L);n   #ifdef OS2MOUSEv     if (tt_mouse)        os2_mouseon() ;0 #endif /* OS2MOUSE */g       while (active) {; 	active = network ||		/* I/O error on network connection */u0 	  (carrier == CAR_OFF) ||	/* Carrier dropped */  	    ((ttgmdm() & BM_DCD) != 0); 	DosSleep( 1000 ) ;*     }   .     debug( F100,"Exiting connect mode","",0) ; #ifdef COMMENT /*I   If APC commands come too quickly, this thread dies upon startup and itseL   threadid gets used by the mouse.  So we can't wait for it to die.  Why areI   we waiting anyway?  We no longer allow it to take direct control of thenJ   keyboard, so even if it takes a couple of milliseconds to die off, there   shouldn't be any problems. */,     DosWaitThread( &threadid2, DCWW_WAIT ) ;1     debug( F100,"conkbdhandler() is dead","",0) ;) #endif /* COMMENT */ #ifdef OS2MOUSEn     if (tt_mouse)w       os2_mouseoff() ; #endif /* OS2MOUSE */    #else /* Not __32BIT__ */ 1    /* Perform keyboard handling in main thread */h  E     while (active) {		/* Read the keyboard and write to comms line */e% 	c = congks(2);			/* Get keystroke */ + 	if (!active)			/* Exit if this happened */d+ 	  break;			/*  (in any of various ways) */-  	if (c == -1) {			/* like:... */? 	    active = network ||		/* I/O error on network connection */ 4 	      (carrier == CAR_OFF) ||	/* Carrier dropped */ 		((ttgmdm() & BM_DCD) != 0);n 	    if (!active) - 	      strcpy(termessage, "Carrier lost.\n");  	    continue; 	}' 	cm = keymap[c];			/* Do key mapping */ 6 	DosEnterCritSec();		/* Protect the runtime library */7 	if (cm == escape) {		/* Is it the escape character? */	? 	    save_status_line();		/* Yes, save current status line.  */n$ 	    esc25(0);			/* Make new one. */5 	    c = keymap[congks(0)];	/* Get escape command. */ G 	    if (c == '?' || c == 'h' || c == 'H') { /* They want help menu. */e! 	        esc25(1);		/* Show it */	6 		c = popuphelp(1);	/* Then get real escape command */ 	    }% 	    doesc(c);			/* And process it */c: 	    restore_status_line();	/* Then restore status line */$ 	} else {			/* Ordinary character */1 	    if (!keylock)		/* If keyboard not locked, */ ) 	      vt100key(c);		/* go process it. */  	}8 	DosExitCritSec();		/* Let others use runtime library */     } /* while (active) */   #endif /* __32BIT__ */   #ifdef __32BIT__      DosWaitThread(&threadid, 0);2     debug(F100,"rdcomwrtscr() thread dead","",0) ;      DosCloseEventSem(threadsem); #elseCH     DosSemWait(&threadsem, -1L);/* Wait for other thread to terminate */ #endif  /     language = langsv;			/* Restore language */ 9     concooked();			/* Restore console to "cooked" mode */	+     savescreen(&vt100screen,wherex,wherey);      x = cursoron; 4     cursoron = TRUE;			/* Needed for lgotoxy()... */;     restoreborder();			/* Put back command-screen border */	@     restorescreen(&commandscreen);	/* Put back command screen */>     restorecursormode();		/* Put command-screen cursor back */8     cursoron = x;			/* Remember this for next time... */0     if (termessage[0]!='\0') printf(termessage);     if (hangnow) { #ifndef NODIAL       if (mdmhup() < 1)e #endif /* NODIAL */	
 	tthang();     }a     if (quitnow)         doexit(GOOD_EXIT,0);     what = W_NOTHING;a     return (1);F } 