L /*  File CKOCON.H  --  OS/2 C-Kermit keyboard verb definitions & tables.  */   /*?   Author: Frank da Cruz (fdc@columbia.edu, FDCCU@CUVMA.BITNET), B   Columbia University Academic Information Systems, New York City.  H   Copyright (C) 1994, Trustees of Columbia University in the City of NewK   York.  The C-Kermit software may not be, in whole or in part, licensed or L   sold for profit as a software product itself, nor may it be included in orM   distributed with commercial products or otherwise distributed by commercial J   concerns to their clients or customers without written permission of theK   Office of Kermit Development and Distribution, Columbia University.  This =   copyright notice must not be removed, altered, or obscured.  */ #ifndef NOKVERBS #ifndef CKOCON_H #define CKOCON_H  % /* DEC VT keyboard key definitions */   + #define K_COMPOSE      1		/* Compose key */    /* DEC arrow keys */   #define K_ARR_MIN     100 #define K_UPARR       10		/* DEC Up Arrow key */2 #define K_DNARR       11		/* DEC Down Arrow key */3 #define K_RTARR       12		/* DEC Right Arrow key */ 2 #define K_LFARR       13		/* DEC Left Arrow key */ #define K_ARR_MAX     13  : #define K_GOLD        15		/* DEC Gold key (same as PF1) */+ #define K_PF1         15		/* DEC PF1 key */ + #define K_PF2         16		/* DEC PF2 key */ + #define K_PF3         17		/* DEC PF3 key */ + #define K_PF4         18		/* DEC PF4 key */   , #define K_KP0         20		/* DEC Keypad 0 */, #define K_KP1         21		/* DEC Keypad 1 */1 #define K_KP2         22		/* etc ... through 9 */  #define K_KP3         23 #define K_KP4         24 #define K_KP5         25 #define K_KP6         26 #define K_KP7         27 #define K_KP8         28 #define K_KP9         290 #define K_KPCOMA      30		/* DEC keypad comma */0 #define K_KPMINUS     31		/* DEC keypad minus */1 #define K_KPDOT       32		/* DEC keypad period */ 0 #define K_KPENTER     33		/* DEC keypad enter */   /* DEC Top-Rank F keys */   * #define K_DECF6       46		/* DEC F6 key */0 #define K_DECF7       47		/* etc, through F20 */ #define K_DECF8       48 #define K_DECF9       49 #define K_DECF10      50 #define K_DECF11      51 #define K_DECF12      52 #define K_DECF13      53 #define K_DECF14      54 #define K_DECF15      55, #define K_DECHELP     55		/* DEC Help key */ #define K_DECF16      56* #define K_DECDO       56		/* DEC Do key */ #define K_DECF17      57 #define K_DECF18      58 #define K_DECF19      59 #define K_DECF20      60   /* DEC editing keys */  , #define K_DECFIND     71		/* DEC Find key */. #define K_DECINSERT   72		/* DEC Insert key */. #define K_DECREMOVE   73		/* DEC Remove key */. #define K_DECSELECT   74		/* DEC Select key */7 #define K_DECPREV     75		/* DEC Previous Screen key */ 3 #define K_DECNEXT     76		/* DEC Next Screen key */    /* DEC User-Defined Keys */   7 #define K_UDKF6       86		/* DEC User Defined Key F6 */ 7 #define K_UDKF7       87		/* DEC User Defined Key F7 */ 3 #define K_UDKF8       88		/* etc ... through F20 */  #define K_UDKF9       89 #define K_UDKF10      90 #define K_UDKF11      91 #define K_UDKF12      92 #define K_UDKF13      93 #define K_UDKF14      94 #define K_UDKF15      95 #define K_UDKF16      96 #define K_UDKF17      97 #define K_UDKF18      98 #define K_UDKF19      99 #define K_UDKF20     100  " /* Kermit screen-scrolling keys */   #define K_ROLLMIN    110> #define K_DNONE      110		/* Screen rollback: down one line */@ #define K_DNSCN      111		/* Screen rollback: down one screen */< #define K_UPONE      112		/* Screen rollback: Up one line */> #define K_UPSCN      113		/* Screen rollback: Up one screen */> #define K_ENDSCN     114		/* Screen rollback: latest screen */> #define K_HOMSCN     115		/* Screen rollback: oldest screen */ #define K_ROLLMAX    115  @ #define K_LFONE      120		/* Horizontal Scroll: Left one cell */@ #define K_LFPAGE     121		/* Horizontal Scroll: Left one page */A #define K_RTONE      122		/* Horizontal Scroll: Right one cell */ A #define K_RTPAGE     123		/* Horizontal Scroll: Right one page */   ' /* Keyboard language switching verbs */   ? #define K_KB_ENG     130		/* Switch keyboard to English mode */ > #define K_KB_HEB     131		/* Switch keyboard to Hebrew mode */? #define K_KB_RUS     132		/* Switch keyboard to Russian mode */    /* Mouse actions */   ; #define K_MARKBEG    180      /* Begin selection of text */ 9 #define K_MARKEND    181      /* End selection of text */ 6 #define K_CUT        182      /* Cut data to buffer */: #define K_PASTE      183      /* Paste data from buffer */  " /* Miscellaneous Kermit actions */  9 #define K_ACT_MIN    200		/* Lowest Action verb number */ 8 #define K_EXIT       200		/* Return to command parser */, #define K_BREAK      201		/* Send a BREAK */. #define K_RESET      202		/* Reset emulator */7 #define K_DOS        203		/* Push to DOS (i.e. OS/2) */ 6 #define K_HANGUP     204		/* Hang up the connection */+ #define K_DUMP       205		/* Dump screen */ 1 #define K_LBREAK     206		/* Send a Long BREAK */ * #define K_NULL       207		/* Send a NUL */+ #define K_HELP       208		/* Pop-up help */ + #define K_HOLDSCRN   209		/* Hold screen */ @ #define K_IGNORE     210		/* Ignore this key, don't even beep */8 #define K_LOGOFF     211		/* Turn off session logging */7 #define K_LOGON      212		/* Turn on session logging */ 0 #define K_MODELINE   213		/* Toggle mode line */> #define K_NETHOLD    214		/* Put network connection on hold */> #define K_NEXTSESS   215		/* Toggle to next network session */+ #define K_STATUS     216		/* Show status */ ? #define K_TERMTYPE   217		/* Toggle term type: text/graphics */ , #define K_PRTSCN     218		/* Print Screen */. #define K_PRINTFF    219		/* Print formfeed */+ #define K_FLIPSCN    220		/* Flip screen */ 0 #define K_DEBUG      221		/* Toggle debugging */4 #define K_TN_AYT     222		/* TELNET Are You There */8 #define K_TN_IP      223		/* TELNET Interrupt Process */: #define K_ACT_MAX    223		/* Highest Action verb number */  9 #include "ckucmd.h"			/* For struct keytab definition. */  /*@   Table of keyboard verbs, associating name with symbol (value).8   Names are chosen for compatibility with MS-DOS Kermit.I   Keyword strings MUST be in lowercase and must be in alphabetical order!  */ struct keytab kverbs[] = {#     "break",      K_BREAK,       0, #     "compose",    K_COMPOSE,     0, #     "debug",      K_DEBUG,       0, #     "decdo",      K_DECDO,       0, #     "decf10",     K_DECF10,      0, #     "decf11",     K_DECF11,      0, #     "decf12",     K_DECF12,      0, #     "decf13",     K_DECF13,      0, #     "decf14",     K_DECF14,      0, #     "decf16",     K_DECF16,      0, #     "decf16",     K_DECF16,      0, #     "decf17",     K_DECF17,      0, #     "decf18",     K_DECF18,      0, #     "decf19",     K_DECF19,      0, #     "decf20",     K_DECF20,      0, #     "decf6",      K_DECF6,       0, #     "decf7",      K_DECF7,       0, #     "decf8",      K_DECF8,       0, #     "decf9",      K_DECF9,       0, #     "decfind",    K_DECFIND,     0, #     "dechelp",    K_DECHELP,     0, #     "decinsert",  K_DECINSERT,   0, #     "decnext",    K_DECNEXT,     0, #     "decprev",    K_DECPREV,     0, #     "decremove",  K_DECREMOVE,   0, #     "decselect",  K_DECSELECT,   0, #     "dnarr",      K_DNARR,       0, #     "dnone",      K_DNONE,       0, #     "dnscn",      K_DNSCN,       0, #     "dos",        K_DOS,         0, #     "dump",       K_DUMP,        0, #     "endscn",     K_ENDSCN,      0, #     "exit",       K_EXIT,        0, #     "flipscn",    K_FLIPSCN,     0, #     "gold",       K_GOLD,        0, #     "hangup",     K_HANGUP,      0, #     "help",       K_HELP,        0, #     "holdscrn",   K_HOLDSCRN,    0, #     "homscn",     K_HOMSCN,      0, #     "ignore",     K_IGNORE,      0, #     "kbenglish",  K_KB_ENG,      0, #     "kbhebrew",   K_KB_HEB,      0, #     "kp0",        K_KP0,         0, #     "kp1",        K_KP1,         0, #     "kp2",        K_KP2,         0, #     "kp3",        K_KP3,         0, #     "kp4",        K_KP4,         0, #     "kp5",        K_KP5,         0, #     "kp6",        K_KP6,         0, #     "kp7",        K_KP7,         0, #     "kp8",        K_KP8,         0, #     "kp9",        K_KP9,         0, #     "kpcoma",     K_KPCOMA,      0, #     "kpdot",      K_KPDOT,       0, #     "kpenter",    K_KPENTER,     0, #     "kpminus",    K_KPMINUS,     0, #     "lbreak",     K_LBREAK,      0, #     "lfarr",      K_LFARR,       0, & /*  "lfone",      K_LFONE,       0, */& /*  "lfpage",     K_LFPAGE,      0, */#     "logoff",     K_LOGOFF,      0, #     "logon",      K_LOGON,       0, & /*  "modeline",   K_MODELINE,    0, */& /*  "nethold",    K_NETHOLD,     0, */& /*  "nextsession",K_NEXTSESS,    0, */#     "null",       K_NULL,        0, #     "os2",        K_DOS,         0, #     "pf1",        K_PF1,         0, #     "pf2",        K_PF2,         0, #     "pf3",        K_PF3,         0, #     "pf4",        K_PF4,         0, #     "printff",    K_PRINTFF,     0, #     "prtscn",     K_PRTSCN,      0, #     "reset",      K_RESET,       0, #     "rtarr",      K_RTARR,       0, & /*  "rtone",      K_RTONE,       0, */& /*  "rtpage",     K_RTPAGE,      0, */& /*  "status",     K_STATUS,      0, */& /*  "termtype",   K_TERMTYPE,    0, */#     "tn_ayt",     K_TN_AYT,      0, #     "tn_ip",      K_TN_IP,       0,  #ifdef COMMENT#     "udkf6",      K_UDKF6,       0, #     "udkf7",      K_UDKF7,       0, #     "udkf8",      K_UDKF8,       0, #     "udkf9",      K_UDKF9,       0, #     "udkf10",     K_UDKF10,      0, #     "udkf11",     K_UDKF11,      0, #     "udkf12",     K_UDKF12,      0, #     "udkf13",     K_UDKF13,      0, #     "udkf14",     K_UDKF14,      0, #     "udkf15",     K_UDKF15,      0, #     "udkf16",     K_UDKF16,      0, #     "udkf17",     K_UDKF17,      0, #     "udkf18",     K_UDKF18,      0, #     "udkf19",     K_UDKF19,      0, #     "udkf20",     K_UDKF20,      0,  #endif /* COMMENT */#     "uparr",      K_UPARR,       0, #     "upone",      K_UPONE,       0, "     "upscn",      K_UPSCN,       0 };7 int nkverbs = (sizeof(kverbs) / sizeof(struct keytab));   / /* Compose-key support structures and tables */    struct compose_key_tab {4     CHAR c1;				/* First char of compose sequence */5     CHAR c2;				/* Second char of compose sequence */ /     CHAR c3;				/* Character that it maps to */  }; /*C   Eventually we need a bunch of these tables, one for each language F   group, roughly corresponding to Latin Alphabets, and should use the :   appropriate one depending on the terminal character-set. */# struct compose_key_tab l1ktab[] = { )     'A', '`', (CHAR) 0xC0,		/* A grave */ )     '`', 'A', (CHAR) 0xC0,		/* A grave */ 0     'A', (CHAR) 0x27, (CHAR) 0xC1,	/* A acute */0     (CHAR) 0x27, 'A', (CHAR) 0xC1,	/* A acute */.     'A', '^', (CHAR) 0xC2,		/* A circumflex */.     '^', 'A', (CHAR) 0xC2,		/* A circumflex */)     'A', '~', (CHAR) 0xC3,		/* A tilde */ )     '~', 'A', (CHAR) 0xC3,		/* A tilde */ -     'A', '"', (CHAR) 0xC4,		/* A diaeresis */ -     '"', 'A', (CHAR) 0xC4,		/* A diaeresis */ .     'A', '*', (CHAR) 0xC5,		/* A ring above */.     '*', 'A', (CHAR) 0xC5,		/* A ring above */*     'A', 'E', (CHAR) 0xC6,		/* A with E */+     'C', ',', (CHAR) 0xC7,		/* C Cedilla */ +     ',', 'C', (CHAR) 0xC7,		/* C Cedilla */ )     'E', '`', (CHAR) 0xC8,		/* E grave */ )     '`', 'E', (CHAR) 0xC8,		/* E grave */ 0     'E', (CHAR) 0x27, (CHAR) 0xC9,	/* E acute */0     (CHAR) 0x27, 'E', (CHAR) 0xC9,	/* E acute */.     'E', '^', (CHAR) 0xCA,		/* E circumflex */.     '^', 'E', (CHAR) 0xCA,		/* E circumflex */-     'E', '"', (CHAR) 0xCB,		/* E diaeresis */ -     '"', 'E', (CHAR) 0xCB,		/* E diaeresis */ )     'I', '`', (CHAR) 0xCC,		/* I grave */ )     '`', 'I', (CHAR) 0xCC,		/* I grave */ 0     'I', (CHAR) 0x27, (CHAR) 0xCD,	/* I acute */0     (CHAR) 0x27, 'I', (CHAR) 0xCD,	/* I acute */.     'I', '^', (CHAR) 0xCE,		/* I circumflex */.     '^', 'I', (CHAR) 0xCE,		/* I circumflex */-     'I', '"', (CHAR) 0xCF,		/* I diaeresis */ -     '"', 'I', (CHAR) 0xCF,		/* I diaeresis */ /     '-', 'D', (CHAR) 0xD0,		/* Icelandic Eth */ /     'D', '-', (CHAR) 0xD0,		/* Icelandic Eth */ )     'N', '~', (CHAR) 0xD1,		/* N tilde */ )     '~', 'N', (CHAR) 0xD1,		/* N tilde */ )     'O', '`', (CHAR) 0xD2,		/* O grave */ )     '`', 'O', (CHAR) 0xD2,		/* O grave */ 0     'O', (CHAR) 0x27, (CHAR) 0xD3,	/* O acute */0     (CHAR) 0x27, 'O', (CHAR) 0xD3,	/* O acute */.     'O', '^', (CHAR) 0xD4,		/* O circumflex */.     '^', 'O', (CHAR) 0xD4,		/* O circumflex */)     'O', '~', (CHAR) 0xD5,		/* O tilde */ )     '~', 'O', (CHAR) 0xD5,		/* O tilde */ -     'O', '"', (CHAR) 0xD6,		/* O diaeresis */ -     '"', 'O', (CHAR) 0xD6,		/* O diaeresis */ 2     'O', '/', (CHAR) 0xD8,		/* O oblique stroke */2     '/', 'O', (CHAR) 0xD8,		/* O oblique stroke */)     'U', '`', (CHAR) 0xD9,		/* U grave */ )     '`', 'U', (CHAR) 0xD9,		/* U grave */ 0     'U', (CHAR) 0x27, (CHAR) 0xDA,	/* U acute */0     (CHAR) 0x27, 'U', (CHAR) 0xDA,	/* U acute */.     'U', '^', (CHAR) 0xDB,		/* U circumflex */.     '^', 'U', (CHAR) 0xDB,		/* U circumflex */-     'U', '"', (CHAR) 0xDC,		/* U diaeresis */ -     '"', 'U', (CHAR) 0xDC,		/* U diaeresis */ 0     'Y', (CHAR) 0x27, (CHAR) 0xDD,	/* Y acute */0     (CHAR) 0x27, 'Y', (CHAR) 0xDD,	/* Y acute */1     'H', 'T', (CHAR) 0xDE,		/* Icelandic Thorn */ 1     'T', 'H', (CHAR) 0xDE,		/* Icelandic Thorn */ 3     's', 's', (CHAR) 0xDF,		/* German scharfes s */ )     'a', '`', (CHAR) 0xE0,		/* a grave */ )     '`', 'a', (CHAR) 0xE0,		/* a grave */ 0     'a', (CHAR) 0x27, (CHAR) 0xE1,	/* a acute */0     (CHAR) 0x27, 'a', (CHAR) 0xE1,	/* a acute */.     'a', '^', (CHAR) 0xE2,		/* a circumflex */.     '^', 'a', (CHAR) 0xE2,		/* a circumflex */)     'a', '~', (CHAR) 0xE3,		/* a tilde */ )     '~', 'a', (CHAR) 0xE3,		/* a tilde */ -     'a', '"', (CHAR) 0xE4,		/* a diaeresis */ -     '"', 'a', (CHAR) 0xE4,		/* a diaeresis */ .     'a', '*', (CHAR) 0xE5,		/* a ring above */.     '*', 'a', (CHAR) 0xE5,		/* a ring above */*     'a', 'e', (CHAR) 0xE6,		/* a with e */+     'c', ',', (CHAR) 0xE7,		/* c cedilla */ +     ',', 'c', (CHAR) 0xE7,		/* c cedilla */ )     'e', '`', (CHAR) 0xE8,		/* e grave */ )     '`', 'e', (CHAR) 0xE8,		/* e grave */ 0     'e', (CHAR) 0x27, (CHAR) 0xE9,	/* e acute */0     (CHAR) 0x27, 'e', (CHAR) 0xE9,	/* e acute */.     'e', '^', (CHAR) 0xEA,		/* e circumflex */.     '^', 'e', (CHAR) 0xEA,		/* e circumflex */-     'e', '"', (CHAR) 0xEB,		/* e diaeresis */ -     '"', 'e', (CHAR) 0xEB,		/* e diaeresis */ )     'i', '`', (CHAR) 0xEC,		/* i grave */ )     '`', 'i', (CHAR) 0xEC,		/* i grave */ 0     'i', (CHAR) 0x27, (CHAR) 0xED,	/* i acute */0     (CHAR) 0x27, 'i', (CHAR) 0xED,	/* i acute */.     'i', '^', (CHAR) 0xEE,		/* i circumflex */.     '^', 'i', (CHAR) 0xEE,		/* i circumflex */-     'i', '"', (CHAR) 0xEF,		/* i diaeresis */ -     '"', 'i', (CHAR) 0xEF,		/* i diaeresis */ /     '-', 'd', (CHAR) 0xF0,		/* Icelandic eth */ /     'd', '-', (CHAR) 0xF0,		/* Icelandic eth */ )     'n', '~', (CHAR) 0xF1,		/* n tilde */ )     '~', 'n', (CHAR) 0xF1,		/* n tilde */ )     'o', '`', (CHAR) 0xF2,		/* o grave */ )     '`', 'o', (CHAR) 0xF2,		/* o grave */ 0     'o', (CHAR) 0x27, (CHAR) 0xF3,	/* o acute */0     (CHAR) 0x27, 'o', (CHAR) 0xF3,	/* o acute */.     'o', '^', (CHAR) 0xF4,		/* o circumflex */.     '^', 'o', (CHAR) 0xF4,		/* o circumflex */)     'o', '~', (CHAR) 0xF5,		/* o tilde */ )     '~', 'o', (CHAR) 0xF5,		/* o tilde */ -     'o', '"', (CHAR) 0xF6,		/* o diaeresis */ -     '"', 'o', (CHAR) 0xF6,		/* o diaeresis */ /     '-', ':', (CHAR) 0xF7,		/* Division sign */ 2     'o', '/', (CHAR) 0xF8,		/* o oblique stroke */2     '/', 'o', (CHAR) 0xF8,		/* o oblique stroke */)     'u', '`', (CHAR) 0xF9,		/* u grave */ )     '`', 'u', (CHAR) 0xF9,		/* u grave */ 0     'u', (CHAR) 0x27, (CHAR) 0xFA,	/* u acute */0     (CHAR) 0x27, 'u', (CHAR) 0xFA,	/* u acute */.     'u', '^', (CHAR) 0xFB,		/* u circumflex */.     '^', 'u', (CHAR) 0xFB,		/* u circumflex */-     'u', '"', (CHAR) 0xFC,		/* u diaeresis */ -     '"', 'u', (CHAR) 0xFC,		/* u diaeresis */ 0     'y', (CHAR) 0x27, (CHAR) 0xFD,	/* y acute */0     (CHAR) 0x27, 'y', (CHAR) 0xFD,	/* y acute */1     'h', 't', (CHAR) 0xFE,		/* Icelandic thorn */ 1     't', 'h', (CHAR) 0xFE,		/* Icelandic thorn */ -     'y', '"', (CHAR) 0xFF,		/* y diaeresis */ -     '"', 'y', (CHAR) 0xFF,		/* y diaeresis */ &     '+', '+', '#',			/* Number sign */"     'A', 'A', '@',			/* At sign */"     'a', 'a', '@',			/* At sign */'     '(', '(', '[',			/* Left bracket */ %     '/', '/', '\\',			/* Backslash */ %     '/', '<', '\\',			/* Backslash */ (     ')', ')', ']',			/* Right bracket */%     '(', '-', '{',			/* Left brace */ '     '/', '^', '|',			/* Vertical bar */ &     ')', '-', '}',			/* Right brace */6     '!', '!', (CHAR) 0xA1,		/* Inverted exclamation */+     'C', '/', (CHAR) 0xA2,		/* Cent sign */ +     'c', '/', (CHAR) 0xA2,		/* Cent sign */ 5     'L', '-', (CHAR) 0xA3,		/* Pound sterling sign */ 5     'l', '-', (CHAR) 0xA3,		/* Pound sterling sign */ *     'Y', '-', (CHAR) 0xA5,		/* Yen sign */*     'y', '-', (CHAR) 0xA5,		/* Yen sign */,     '|', '|', (CHAR) 0xA6,		/* Broken bar */0     'S', 'O', (CHAR) 0xA7,		/* Paragraph sign */0     'S', '!', (CHAR) 0xA7,		/* Paragraph sign */0     'S', '0', (CHAR) 0xA7,		/* Paragraph sign */0     's', 'o', (CHAR) 0xA7,		/* Paragraph sign */0     's', '!', (CHAR) 0xA7,		/* Paragraph sign */0     's', '0', (CHAR) 0xA7,		/* Paragraph sign *//     'X', 'O', (CHAR) 0xA4,		/* Currency sign */ /     'X', '0', (CHAR) 0xA4,		/* Currency sign */ /     'x', 'o', (CHAR) 0xA4,		/* Currency sign */ /     'x', '0', (CHAR) 0xA4,		/* Currency sign */ 0     'C', 'O', (CHAR) 0xA9,		/* Copyright sign */0     'C', '0', (CHAR) 0xA9,		/* Copyright sign */0     'c', 'o', (CHAR) 0xA9,		/* Copyright sign */0     'c', '0', (CHAR) 0xA9,		/* Copyright sign */2     'A', '_', (CHAR) 0xAA,		/* Feminine ordinal */2     'a', '_', (CHAR) 0xAA,		/* Feminine ordinal */6     '<', '<', (CHAR) 0xAB,		/* Left angle quotation */*     '-', ',', (CHAR) 0xAC,		/* Not sign */-     '-', '-', (CHAR) 0xAD,		/* Soft hyphen */ 6     'R', 'O', (CHAR) 0xAE,		/* Registered Trademark */6     'r', 'o', (CHAR) 0xAE,		/* Registered Trademark */(     '-', '^', (CHAR) 0xAF,		/* Macron */-     '0', '^', (CHAR) 0xB0,		/* Degree sign */ 4     '+', '-', (CHAR) 0xB1,		/* Plus or minus sign *//     '2', '^', (CHAR) 0xB2,		/* Superscript 2 */ /     '3', '^', (CHAR) 0xB3,		/* Superscript 3 */ =     (CHAR) 0x27, (CHAR) 0x27, (CHAR) 0xB4, /* Acute accent */ ,     '/', 'U', (CHAR) 0xB5,		/* Micro sign */,     'U', '/', (CHAR) 0xB5,		/* Micro sign */,     '/', 'u', (CHAR) 0xB5,		/* Micro sign */,     'u', '/', (CHAR) 0xB5,		/* Micro sign */.     'P', '!', (CHAR) 0xB6,		/* Pilcrow sign */.     'p', '!', (CHAR) 0xB6,		/* Pilcrow sign */,     '.', '^', (CHAR) 0xB7,		/* Middle dot */)     ',', ',', (CHAR) 0xB8,		/* Cedilla */ /     '1', '^', (CHAR) 0xB9,		/* Superscript 1 */ 3     'O', '_', (CHAR) 0xBA,		/* Masculine ordinal */ 3     'o', '_', (CHAR) 0xBA,		/* Masculine ordinal */ 7     '>', '>', (CHAR) 0xBB,		/* Right angle quotation */ 6     '1', '4', (CHAR) 0xBC,		/* Fraction one quarter */3     '1', '2', (CHAR) 0xBD,		/* Fraction one half */ 8     '?', '?', (CHAR) 0xBF,		/* Inverted question mark */5     'x', 'x', (CHAR) 0xD7,		/* Multiplication sign */ 4     'X', 'X', (CHAR) 0xD7		/* Multiplication sign */ };@ int nl1ktab = (sizeof(l1ktab) / sizeof(struct compose_key_tab));   #endif /* CKOCON_H */  #endif /* NOKVERBS */ 