 /*   File INSTALL.CMD (CKOINS.CMD)      Tue Oct  4 21:22:40 1994  L   A REXX Program to install OS/2 C-Kermit 5A(190) on OS/2 1.x, 2.x, or Warp.2   Written by Jeffrey Altman, Altmania Productions,)   and Frank da Cruz, Columbia University,    June 1993 - Oct 1994. -   All rights assigned to Columbia University.   N   Copyright (C) 1993, 1994, Trustees of Columbia University in the City of NewK   York.  The C-Kermit software may not be, in whole or in part, licensed or L   sold for profit as a software product itself, nor may it be included in orM   distributed with commercial products or otherwise distributed by commercial J   concerns to their clients or customers without written permission of theK   Office of Kermit Development and Distribution, Columbia University.  This =   copyright notice must not be removed, altered, or obscured.  */   /*M   All the files to be installed must be in the same directory as INSTALL.CMD.    This script:  <   . Installs either the 16-bit or 32-bit version of C-KermitA     depending on the version of OS/2 being used, and which one(s)      is/are on the install disk.   2   . Creates a directory for C-Kermit if necessary.  :   . Creates a C-Kermit program object on the OS/2 Desktop.  H   . Customizes the CKERMOD.INI file according to the user's preferences.  ;   . Installs the network DLLS, CKO{16,32}{I12,I20,F13}.DLL.   ;   . Updates the CONFIG.SYS file only at the user's request.      * New for version 190:  H   . TCP/IP-only installation - no questions about serial ports & modems.  >   . Does not overwrite existing CKERMOD.INI, KDD or KSD files.  -   . CKERMIT.CMD matches CKERMOD.INI settings.   C   . Sets up full VT220 key mappings in CKERMOD.INI if user says to.   )   . Uses Rexx procedures and subroutines.   D   . Adds .INI files for various external protocols and key mappings.  H   . Optional command-line parameter to specify the destination directory */   Revision = 190 RexxUtils = LoadRexxUtils() % os2ver = WhichOS2Version( RexxUtils ) % bootdrive = GetBootDrive( RexxUtils ) $ startdir = ChangeToSourceDirectory()2 spacerequired = HowMuchSpaceRequired( RexxUtils )  CALL ClearScreen CALL Welcome CKOVer = WhichKermitVersion()  CALL GetDir( ARG(1) )  CALL CheckSpace  CALL CreateDir( tcpip = IsIBMTCPIPInstalled( RexxUtils )  9 newInstall = \ FileExists( destination || 'ckermod.ini' )  IF newInstall THEN DO & serial = InstallSerialSupport( tcpip )	 IF serial 	   THEN DO      CALL GetModem      CALL GetPort     CALL GetSpeed    END 	   ELSE DO      modem = ""
     port = ""      speed = ""   END  CALL GetRunMode  vt220 = InstallVT220KeyMap() END  ELSE DO    serial = 0   modem = ""   port = ""    speed = ""   vt220 = 0  END    CALL InstallFiles  CALL SetIcon CALL BuildFolderObject CALL BuildProgramObject  CALL BuildUpdatesObject  CALL UpdateConfigSys	 CALL Done  EXIT  E /*******************************************************************/   K INSTALLFILES : PROCEDURE EXPOSE RexxUtils OS2Ver CKOVer destination updest, F                                 destnopath runmode serial tcpip vt220,;                                 modem port speed revision ;  CALL InstallCKermitExe CALL InstallTcpIpDlls  CALL InstallSyslevelFiles  CALL InstallCKermitIco CALL InstallDocs CALL InstallCkermitIni CALL InstallCkermodIni CALL InstallRexxCmdFiles CALL InstallDialingSupportFiles  CALL InstallExternalProtocols  CALL InstallCkermitCmd CALL InstallKeyboardDefs CALL InstallCharSets RETURN /* InstallFiles */   E /*******************************************************************/    LOADREXXUTILS: PROCEDURE ;  /* Load RexxUtil if available */    SIGNAL ON SYNTAX NAME NoRexxUtil IF RxFuncQuery('SysLoadFuncs')  A   THEN CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'   CALL SysLoadFuncs    SAY "RexxUtils installed. :-)" SIGNAL OFF SYNTAX  RETURN 1   NOREXXUTIL: " SAY "RexxUtils not installed. :-(" CALL RxFuncDrop 'SysLoadFuncs' SIGNAL OFF SYNTAX  RETURN 0 /* LoadRexxUtils */  E /*******************************************************************/    WhichOS2Version : PROCEDURE ;  RexxUtils = ARG(1) /* Determine OS/2 Version */ IF RexxUtils   THEN OS2Ver = SysOS2Ver()    ELSE OS2Ver = 1.x           G /* We assume this because RexxUtils is missing and Rexx is installed */ G /* I have no other way of determining what the version is without    */ G /* SysOS2Ver()                                                       */  SAY "OS/2 Version is "OS2Ver# RETURN OS2Ver /* WhichOS2Version */   E /*******************************************************************/    GetBootDrive : PROCEDURE ; RexxUtils = ARG(1)" /* Determining Boot information */ IF RexxUtils8   THEN bootpath = SysSearchPath( 'PATH', 'COUNTRY.SYS' )7   ELSE bootpath = MySearchPath( 'PATH', 'COUNTRY.SYS' ) 7 RETURN FILESPEC( "drive", bootpath ) /* GetBootDrive */   E /*******************************************************************/   6 ChangeToSourceDirectory : PROCEDURE EXPOSE sourcedir ;; /* Save Current Directory and change to Source Directory */  startdir = DIRECTORY()$ PARSE SOURCE system calltype command$ drive = FILESPEC( "DRIVE", command )" path = FILESPEC( "PATH", command )( IF SUBSTR( path, LENGTH(path), 1 ) = '\'J   THEN sourcedir = DIRECTORY( drive || SUBSTR( path, 1, LENGTH(path)-1 ) )-   ELSE sourcedir = DIRECTORY( drive || path ) - RETURN startdir /* ChangeToSourceDirectory */   E /*******************************************************************/   " HowMuchSpaceRequired : PROCEDURE ; RexxUtils = ARG(1)L /* SpaceRequired is the amount of free space required to install C-Kermit */ IF RexxUtils	   THEN DO      spacerequired = 0 *     rc = SysFileTree( '*.*', 'file', 'F' )     DO i = 1 to file.0/       PARSE VAR file.i date time size atts name 1       spacerequired = spacerequired + 1024 + size 	       END      END    ELSE spacerequired = 720000 / RETURN spacerequired /* HowMuchSpaceRequired */   E /*******************************************************************/   * ClearScreen : PROCEDURE EXPOSE RexxUtils ;5 /* Clear screen and prompt user for drive and path */  '@echo off'  IF RexxUtils   THEN CALL SysCls
   ELSE "CLS"   RETURN /* ClearScreen */  E /*******************************************************************/    Welcome : PROCEDURE ; N SAY "+======================================================================+"N SAY "|        Welcome to the OS/2 C-Kermit Installation Procedure.          |"N SAY "|     You are about to install C-Kermit 5A(190) on your computer.      |"N SAY "|                Press <Ctrl-C> to cancel at any time.                 |"N SAY "+======================================================================+" SAY "" RETURN /* Welcome */  E /*******************************************************************/   : WhichKermitVersion : PROCEDURE EXPOSE RexxUtils startdir ;
 CKOVer = 0   IF FileExists("ckoker16.exe")      THEN CKOVer = 16      IF FileExists("ckoker32.exe")      THEN DO        IF CKOVer = 16         THEN CKOVer = "16/32"          IF CKOVer = 0          THEN CKOVer = "32"     END    IF CKOVer = 0 	   THEN DO 5     SAY "Sorry, but the source directory" DIRECTORY() >     SAY "does not contain either the 16-bit or 32-bit version"     SAY "of C-Kermit."
     SAY "".     SAY "Unable to complete the installation."     rc = DIRECTORY( startdir )     EXIT   END & RETURN CKOVer /* WhichKermitVersion */  E /*******************************************************************/   K InstallCKermitExe :  PROCEDURE EXPOSE OS2Ver CKOVer RexxUtils destination ; 9 SAY "Installing the C-Kermit application, CKERMIT.EXE..."  SELECT  B   WHEN substr(OS2Ver,1,1) = "1" & (CKOVer = 16 | CKOVer = "16/32")     THEN DO .       CALL Install 'ckoker16.exe', ckermit.exe     END 
           .   WHEN substr(OS2Ver,1,1) = "2" & CKOVer = 16      THEN DO .       CALL Install 'ckoker16.exe', ckermit.exe     END   B   WHEN substr(OS2Ver,1,1) = "2" & (CKOVer = 32 | CKOVer = "16/32")     THEN DO .       CALL Install 'ckoker32.exe', ckermit.exe     END   	 OTHERWISE M   SAY "Can't install" CKOVer"-bit version of C-Kermit on OS/2 version" OS2Ver #   CALL UnableToCompleteInstallation  END  SAY "" RETURN /* InstallCKermitExe */  E /*******************************************************************/   J InstallTcpIpDlls :  PROCEDURE EXPOSE OS2Ver CKOVer RexxUtils destination ;4 SAY "Installing the C-Kermit TCP/IP Support DLLs..." SELECT  B   WHEN substr(OS2Ver,1,1) = "1" & (CKOVer = 16 | CKOVer = "16/32")     THEN DO !       CALL Install 'cko16i12.dll' !       CALL Install 'cko16f13.dll'      END 
           .   WHEN substr(OS2Ver,1,1) = "2" & CKOVer = 16      THEN DO !       CALL Install 'cko16i12.dll' !       CALL Install 'cko16f13.dll'      END   B   WHEN substr(OS2Ver,1,1) = "2" & (CKOVer = 32 | CKOVer = "16/32")     THEN DO !       CALL Install 'cko32i12.dll' !       CALL Install 'cko32i20.dll' !       CALL Install 'cko32f13.dll'      END   	 OTHERWISE M   SAY "Can't install" CKOVer"-bit version of C-Kermit on OS/2 version" OS2Ver #   CALL UnableToCompleteInstallation  END   C /* now remove fake tcpipdll.dll from 189 if found in destination */ 
 IF RexxUtils  	   THEN DO @     CALL SysFileTree destination || 'tcpipdll.dll', 'file', 'FO'     IF file.0 > 0 %       THEN CALL Backup 'tcpipdll.dll'      END 	   ELSE DO >     CALL STREAM ckfound || 'tcpipdll.dll', 'c', 'query exists'     IF "\"RESULT <> "\" %       THEN CALL Backup 'tcpipdll.dll'      END    SAY "" RETURN /* InstallCKOTcpIpDll */   E /*******************************************************************/   @ InstallSyslevelFiles : PROCEDURE EXPOSE OS2Ver CKOVer RexxUtils,5                                         destination ; 8 SAY "Installing the Syslevel data file, SYSLEVEL.CKO..." SELECT  B   WHEN substr(OS2Ver,1,1) = "1" & (CKOVer = 16 | CKOVer = "16/32")     THEN DO .       CALL Install 'ckosysl.ck1', syslevel.cko     END 
           .   WHEN substr(OS2Ver,1,1) = "2" & CKOVer = 16      THEN DO .       CALL Install 'ckosysl.ck1', syslevel.cko     END   B   WHEN substr(OS2Ver,1,1) = "2" & (CKOVer = 32 | CKOVer = "16/32")     THEN DO .       CALL Install 'ckosysl.ck2', syslevel.cko     END   	 OTHERWISE    NOP  END  SAY ""! RETURN /* InstallSyslevelFiles */   E /*******************************************************************/   < InstallCkermitIco : PROCEDURE EXPOSE RexxUtils destination ;  % SAY "Installing the C-Kermit Icon..." ) CALL Install 'ckermit.ico', 'ckermit.ico'  SAY "" RETURN /* InstallCkermitIco */  E /*******************************************************************/   > InstallRexxCmdFiles : PROCEDURE EXPOSE RexxUtils destination ;  3 SAY "Installing the C-Kermit Rexx Command Files..." % CALL Install 'xsend.cmd', 'xsend.cmd'  SAY ""  RETURN /* InstallRexxCmdFiles */  E /*******************************************************************/   6 InstallDocs : PROCEDURE EXPOSE RexxUtils destination ;  : SAY "Installing distribution information file, READ.ME..."! CALL Install 'read.me', 'read.me'  SAY ""  J SAY "Installing documentation for recent C-Kermit updates, CKERMIT.INF..." CALL Install 'ckermit.inf' SAY "" RETURN /* InstallDocs */  E /*******************************************************************/   C InstallExternalProtocols : PROCEDURE EXPOSE RexxUtils destination ;   < SAY "Installing scripts for accessing external protocols..."# CALL Install 'p101.ini', 'p101.ini' # CALL Install 'p200.ini', 'p200.ini' ' CALL Install 'cexyz2.ini', 'cexyz2.ini' * CALL Install 'm2zmodem.ini', 'm2zodem.ini', /* Not really an external protcol, but... */+ CALL Install 'emacskey.ini', 'emacskey.ini'    SAY ""% RETURN /* InstallExternalProtocols */   E /*******************************************************************/   < InstallCkermitIni : PROCEDURE EXPOSE RexxUtils destination ;  J SAY "Installing the standard C-Kermit initialization file, CKERMIT.INI..." CALL Install 'ckermit.ini' SAY "" RETURN /* InstallCkermitIni */  E /*******************************************************************/   I InstallCkermodIni : PROCEDURE EXPOSE RexxUtils destination vt220 serial , @                                      modem port speed revision ;  . IF FileExists( destination || 'ckermod.ini' )  THEN DO O   SAY "Installing new C-Kermit customization file, CKERMOD." || revision || '.' 0   CALL Install 'ckermod.ini', 'ckermod.'revision   END 	 ELSE DO   C   SAY "Installing your C-Kermit customization file, CKERMOD.INI..."    /*$     Backup ckermod.ini if necessary,#     Read ckermod.ini from diskette, J     write ckermod.ini to dest directory with changes from previous dialog.   */     CALL Backup 'ckermod.ini' #   modini = destination"ckermod.ini"   > /*  IF FileExists( destination || 'Backup\ckermod.ini' )      8     THEN modinisrc = destination || 'Backup\ckermod.ini'"     ELSE modinisrc = 'ckermod.ini' */   modinisrc = 'ckermod.ini'      os2section = 0   LINEIN( modinisrc, 1, 0 ) "   DO WHILE lines( modinisrc ) <> 0!     linetxt = LINEIN( modinisrc ) %     upperlinetxt = TRANSLATE(linetxt) 
     SELECTE       WHEN (substr( upperlinetxt, 1, 5) = ':OS/2') & (os2section = 0)          THEN DO .           /* SAY "...Entering OS/2 section" */)           rc = LINEOUT( modini, linetxt )            os2section = 1         END   J       WHEN (substr( upperlinetxt, 1, 9 ) = "SET MODEM") & (os2section = 1)         THEN IF serial  8           THEN rc = LINEOUT( modini, 'set modem' modem )8         ELSE rc = LINEOUT( modini, ';set modem <modem>')         L       WHEN (substr( upperlinetxt, 1, 10 ) = ";SET MODEM") & (os2section = 1)         THEN IF serial  8           THEN rc = LINEOUT( modini, 'set modem' modem ):           ELSE rc = LINEOUT( modini, ';set modem <modem>')  I       WHEN (substr( upperlinetxt, 1, 8 ) = "SET PORT") & (os2section = 1)          THEN IF serial6           THEN rc = LINEOUT( modini, 'set port' port )8           ELSE rc = LINEOUT( modini, ';set port <port>')
           J       WHEN (substr( upperlinetxt, 1, 9 ) = ";SET PORT") & (os2section = 1)         THEN IF serial6           THEN rc = LINEOUT( modini, 'set port' port )8           ELSE rc = LINEOUT( modini, ';set port <port>')  J       WHEN (substr( upperlinetxt, 1, 9 ) = "SET SPEED") & (os2section = 1)         THEN IF serial8           THEN rc = LINEOUT( modini, 'set speed' speed ):           ELSE rc = LINEOUT( modini, ';set speed <speed>')  L       WHEN (substr( upperlinetxt, 1, 10 ) = ";SET SPEED") & (os2section = 1)         THEN IF serial8           THEN rc = LINEOUT( modini, 'set speed' speed ):           ELSE rc = LINEOUT( modini, ';set speed <speed>')  D       WHEN (substr( upperlinetxt, 1, 3 ) = 'END') & (os2section = 1)         THEN DO -           /* SAY "...Leaving OS/2 section" */ O      /* linetxt = 'take' TRANSLATE( destination, '/', '\' ) || 'ckovtk2.ini' */ * 	  linetxt = 'take \m(_inidir)ckovtk2.ini'           IF vt2200             THEN rc = LINEOUT( modini, linetxt )'           rc = LINEOUT( modini, "end" )            os2section = 0         END          OTHERWISE '         rc = LINEOUT( modini, linetxt )      END    END  END    /* Close files */ # rc = STREAM( modini, 'C', 'CLOSE' ) & rc = STREAM( modinisrc, 'C', 'CLOSE' ) SAY "" RETURN /* InstallCkermodIni */  E /*******************************************************************/   D InstallDialingSupportFiles: PROCEDURE EXPOSE RexxUtils destination ;  / IF \ FileExists( destination || 'ckermit.kdd' ) 	   THEN DO K     SAY "Installing Sample C-Kermit dialing directory file, CKERMIT.KDD..."      CALL Install 'ckermit.kdd'     END 
   ELSE DO C     SAY "Existing C-Kermit dialing directory file, CKERMIT.KDD, ",            || "has been preserved."     END  SAY ""  / IF \ FileExists( destination || 'ckermit.ksd' ) 	   THEN DO L     SAY "Installing sample C-Kermit services directory file, CKERMIT.KSD..."     CALL Install 'ckermit.ksd'     END 
   ELSE DO C     SAY "Existing C-Kermit services directory file, CKERMIT.KSD, ",           || "has been preserved."     END  SAY ""' RETURN /* InstallDialingSupportFiles */   E /*******************************************************************/   H InstallCkermitCmd : PROCEDURE EXPOSE RexxUtils destination serial port ;  - IF FileExists( destination || 'ckermit.cmd' )  THEN DO H   SAY "Existing C-kermit startup file, CKERMIT.CMD, has been preserved."   END  ELSE DO ?   SAY "Installing sample C-Kermit startup file, CKERMIT.CMD..."    CALL Backup 'ckermit.cmd'    cmdsrc = 'ckermit.cmd'(   cmdfile = destination || 'ckermit.cmd'     LINEIN( cmdsrc, 1, 0 )   DO WHILE lines( cmdsrc ) <> 0      linetxt = LINEIN( cmdsrc )'     upperlinetxt = TRANSLATE( linetxt ) 
     SELECT4       WHEN substr( upperlinetxt, 1, 8 ) = 'MODE COM'         THEN IF serial           THEN DO )             newlinetxt = 'MODE ' || port, B                     || substr( linetxt, 10, length( linetxt ) -9 )/             rc = LINEOUT( cmdfile, newlinetxt )              END 9           ELSE rc = LINEOUT( cmdfile, 'REM ' || linetxt )              5       WHEN substr( upperlinetxt, 1, 9 ) = '"MODE COM'          THEN IF serial           THEN DO ,             newlinetxt = '"MODE ' || port,  I                           || substr( linetxt, 11, length( linetxt ) -10 ) /             rc = LINEOUT( cmdfile, newlinetxt )              END &           ELSE rc = LINEOUT( cmdfile,,H                         '"REM 'SUBSTR( linetxt, 2, LENGTH(linetxt)-1 ) )             9       WHEN substr( upperlinetxt, 1, 12 ) = 'REM MODE COM'          THEN IF serial           THEN DO )             newlinetxt = 'MODE ' || port, I                           || substr( linetxt, 14, length( linetxt ) -13 ) /             rc = LINEOUT( cmdfile, newlinetxt )              END /           ELSE rc = LINEOUT( cmdfile, linetxt )        :       WHEN substr( upperlinetxt, 1, 13 ) = '"REM MODE COM'         THEN IF serial           THEN DO *             newlinetxt = '"MODE ' || port,I                           || substr( linetxt, 15, length( linetxt ) -14 ) /             rc = LINEOUT( cmdfile, newlinetxt )              END /           ELSE rc = LINEOUT( cmdfile, linetxt )               OTHERWISE (         rc = LINEOUT( cmdfile, linetxt )        END    END   &   rc = STREAM( cmdfile, 'C', 'CLOSE' )%   rc = STREAM( cmdsrc, 'C', 'CLOSE' )  END  SAY "" RETURN /* InstallCkermitCmd */  E /*******************************************************************/   G InstallKeyboardDefs : PROCEDURE EXPOSE RexxUtils destination revision ;   , IF FileExists( destination || ckovtk2.ini )  THEN DO L   SAY "Installing new C-Kermit VT220 keyboard definitions file as CKOVTK2.",     || revision 0   CALL Install 'ckovtk2.ini', 'ckovtk2.'revisionI   SAY "Your old copy has been preserved as" destination || "ckovtk2.ini."    END  ELSE DO K   SAY "Installing C-Kermit VT220 keyboard definitions file, CKOVTK2.INI..."    CALL Install 'ckovtk2.ini'   END  SAY ""  RETURN /* InstallKeyboardDefs */  E /*******************************************************************/   : InstallCharSets : PROCEDURE EXPOSE RexxUtils destination ;  M SAY "Installing character-set tables CP437.TXT, CP850.TXT, and LATIN1.TXT..."  CALL Install 'cp437.txt' CALL Install 'cp850.txt' CALL Install 'latin1.txt'  SAY "" RETURN /* InstallCharSets */  E /*******************************************************************/   9 SetIcon : PROCEDURE EXPOSE RexxUtils destination updest ;    IF RexxUtils	   THEN DO G     SAY "Assigning the C-Kermit icon to" updest || CKERMIT.EXE || "..." 3     rc = SysSetIcon( destination || 'ckermit.exe',, 3                      destination || 'ckermit.ico' ) 
     SAY ""   END  RETURN /* SetIcon */  E /*******************************************************************/   B BuildFolderObject : PROCEDURE EXPOSE RexxUtils destination OS2Ver,2                                       newInstall ;  : /* Build C-Kermit Folder Object if version 2.x or later */* IF RexxUtils & SUBSTR( OS2Ver,1,1 ) = "2" 	   THEN DO !       title = "C-Kermit for OS/2"      classname = 'WPFolder'     location = '<WP_DESKTOP>' "     setup = 'OBJECTID=<CK_FOLDER>'     IF \ newInstall 
       THEN DO          option = 'update' )         SAY "Updating C-Kermit Folder..." 	       END 
       ELSE DO          option = 'update'       )         SAY "Building C-Kermit Folder..." 	       END   C     rc = SysCreateObject(classname, title, location, setup, option) 
     SAY ""   END  RETURN /* BuildFolderObject */  E /*******************************************************************/   C BuildUpdatesObject : PROCEDURE EXPOSE RexxUtils destination OS2Ver, 2                                       newInstall ;  ; /* Build C-Kermit Updates Object if version 2.x or later */ * IF RexxUtils & SUBSTR( OS2Ver,1,1 ) = "2" 	   THEN DO '     title = "Updates to Using C-Kermit"      classname = 'WPProgram'      location = '<CK_FOLDER>' /*(     setup = 'EXENAME=e.exe;STARTUPDIR=',0             destination';PARAMETERS=ckermit.upd' */+     setup = 'EXENAME=view.exe;STARTUPDIR=', 0             destination';PARAMETERS=ckermit.inf'       option = 'update'       3     SAY "Building Using C-Kermit Updates Object..."   C     rc = SysCreateObject(classname, title, location, setup, option) 
     SAY ""   END  RETURN /* BuildUpdatesObject */   E /*******************************************************************/   K BuildProgramObject : PROCEDURE EXPOSE RexxUtils destination OS2Ver runmode, 2                                       newInstall ;  ; /* Build C-Kermit Program Object if version 2.x or later */ * IF RexxUtils & SUBSTR( OS2Ver,1,1 ) = "2" 	   THEN DO      IF CKOVer = "16"+       THEN title = "OS/2 C-Kermit (16-bit)" +       ELSE title = "OS/2 C-Kermit (32-bit)"      classname = 'WPProgram'      location = '<CK_FOLDER>'       IF \ newInstall 
       THEN DO ?         setup = 'EXENAME='destination'ckermit.exe;STARTUPDIR=', H             destination';ICONFILE='destination'ckermit.ico;PARAMETERS=%'         option = 'update' 1         SAY "Updating C-Kermit Program Object..." 	       END 
       ELSE DO (         IF TRANSLATE(runmode) = "WINDOW"F           THEN setup = 'EXENAME='destination'ckermit.exe;STARTUPDIR=',F             destination';PROGTYPE=WINDOWABLEVIO;ICONFILE='destination,&             'ckermit.ico;PARAMETERS=%'F           ELSE setup = 'EXENAME='destination'ckermit.exe;STARTUPDIR=',C             destination';PROGTYPE=FULLSCREEN;ICONFILE='destination, &             'ckermit.ico;PARAMETERS=%'           option = 'update'       1         SAY "Building C-Kermit Program Object..." 	       END   C     rc = SysCreateObject(classname, title, location, setup, option) 
     SAY ""   END  RETURN /* BuildProgramObject */   E /*******************************************************************/   I UpdateConfigSys : PROCEDURE EXPOSE RexxUtils destination tcpip bootdrive, N                                 vt220 updest destnoslash configupdate ckover ;  O SAY "Your CONFIG.SYS file defines several environment variables that determine" N SAY "how OS/2 and your applications work.  With your permission, this program"& SAY "will make the following changes:" SAY ""O SAY " 1. The C-Kermit directory," destination || ", will be added to your PATH" N SAY "    to allow C-Kermit to be executed from any OS/2 Command Line session." SAY ""R SAY " 2. The C-Kermit directory," destination || ", will be added to your LIBPATH"K SAY "    to allow C-Kermit (or external protocols) to find necessary DLLs."  SAY ""P SAY " 3. The C-Kermit directory," destination || ", will be added to your DPATH"B SAY "    to allow the C-Kermit to find your initialization files." SAY ""T SAY " 4. The C-Kermit directory," destination || ", will be added to your BOOKSHELF"A SAY "    to allow the view command to find the CKERMIT.INF file."  SAY ""N SAY "Please enter 'Yes' to allow this program to update your CONFIG.SYS file."J SAY "A backup copy will be made in the root directory of your boot drive."" SAY "Update CONFIG.SYS? (Yes/No):"   CALL Confirmation  IF RESULT <> 'Y'	   THEN DO      configupdate = 0
     SAY "":     SAY "  OK, your CONFIG.SYS file has not been changed."
     CALL Done    END    configupdate = 1 SAY ""  + /* Back up the existing CONFIG.SYS file. */ 
 IF RexxUtils  
   THEN DO )     tempname = bootdrive || "\CONFIG.???" (     backup = SysTempFileName( tempname )     END 	   ELSE DO      n = 100 )     backup = bootdrive || "\CONFIG." || n +     CALL STREAM backup, 'c', 'query exists'      DO WHILE "\"RESULT <> "\"        n = n + 1 +       backup = bootdrive || "\CONFIG." || n -       CALL STREAM backup, 'c', 'query exists' 	       END      END   . SAY "Backing up CONFIG.SYS to" backup || "...". copy bootdrive || "\Config.Sys" backup "> NUL" SAY ""  @ /* Generate a temporary file name for the new CONFIG.SYS file */ IF RexxUtils	   THEN DO +     tempname = bootdrive || "\CONFIG??.INS" &     temp = SysTempFileName( tempname )     END 
   ELSE DO 
     n = 100     temp = bootdrive || "\CONFIG" || n || ".INS")     CALL STREAM temp, 'c', 'query exists'      DO WHILE "\"RESULT <> "\"        n = n + 1 2       temp = bootdrive || "\CONFIG" || n || ".INS"+       CALL STREAM temp, 'c', 'query exists' 	       END      END   - /* Generate the temporary CONFIG.SYS file. */  SAY "Updating CONFIG.SYS..."  L /* Change to a neutral directory so that SearchPath searches will succeed */! rc = DIRECTORY( bootdrive"\OS2" ) * LINEIN( bootdrive || "\Config.sys", 1, 0 )  1 DO WHILE lines( bootdrive || "\Config.sys" ) <> 0 0   linetxt = LINEIN( bootdrive || "\Config.sys" )#   upperlinetxt = TRANSLATE(linetxt)    SELECT1     WHEN COMPARE( upperlinetxt, "SET PATH" ) = 9  
       THEN DO          SETLOCAL         len = LENGTH(linetxt) A         rc = VALUE('PATH', SUBSTR( upperlinetxt, 10, len - 10 ),, %                    'OS2ENVIRONMENT' )          IF RexxUtils=           THEN ckfound = SysSearchPath( 'PATH', ckermit.exe ) <           ELSE ckfound = MySearchPath( 'PATH', ckermit.exe )         IF ckfound'\' = '\' 1           THEN IF SUBSTR( linetxt, len, 1 ) = ';' D             THEN rc = LINEOUT( temp, linetxt || destnoslash || ';' )K             ELSE rc = LINEOUT( temp, linetxt || ';' || destnoslash || ';' )            ELSE DO N             ckpath = FILESPEC('DRIVE', ckfound ) || FILESPEC('PATH', ckfound )             IF ckpath = updest0               THEN rc = LINEOUT( temp, linetxt )               ELSE DO I                 ckpathnoslash = SUBSTR( ckpath, 1, LENGTH( ckpath ) - 1 ) 8                 pos = POS( ckpathnoslash, upperlinetxt )C                 rc = LINEOUT( temp, SUBSTR( linetxt, 1, pos - 1 ) , 7                                     || destnoslash';' , N                                     || SUBSTR( linetxt, pos, len - pos + 1 ) )                 SAY ""                  SAY "  WARNING:"H                 SAY "    An earlier version of 'CKERMIT.EXE' exists in",1                     "    directory" ckpath || "."                  IF RexxUtils                   THEN DO 4                     SAY "Press any key to continue."F                     PARSE UPPER VALUE SysGetKey('NOECHO') WITH confirm                     END                    ELSE DO 4                     SAY "Press <Enter> to continue."$                     PARSE PULL dummy                     END                    END 
           END          ENDLOCAL         END   2     WHEN COMPARE( upperlinetxt, "SET DPATH" ) = 10
       THEN DO          SETLOCAL         len = LENGTH(linetxt) B         rc = VALUE('DPATH', SUBSTR( upperlinetxt, 11, len - 11 ),,%                    'OS2ENVIRONMENT' )          IF RexxUtils>           THEN ckfound = SysSearchPath( 'DPATH', ckermit.ini )=           ELSE ckfound = MySearchPath( 'DPATH', ckermit.ini ) =         IF ckfound = "" | ckfound = DIRECTORY()"\CKERMIT.INI" 1           THEN IF SUBSTR( linetxt, len, 1 ) = ';' D             THEN rc = LINEOUT( temp, linetxt || destnoslash || ';' )K             ELSE rc = LINEOUT( temp, linetxt || ';' || destnoslash || ';' )            ELSE DO N             ckpath = FILESPEC('DRIVE', ckfound ) || FILESPEC('PATH', ckfound )             IF ckpath = updest0               THEN rc = LINEOUT( temp, linetxt )               ELSE DO I                 ckpathnoslash = SUBSTR( ckpath, 1, LENGTH( ckpath ) - 1 ) 8                 pos = POS( ckpathnoslash, upperlinetxt )C                 rc = LINEOUT( temp, SUBSTR( linetxt, 1, pos - 1 ) , 7                                     || destnoslash';' , N                                     || SUBSTR( linetxt, pos, len - pos + 1 ) )                 SAY ""                  SAY "  WARNING:"H                 SAY "    An earlier version of 'CKERMIT.INI' exists in",1                     "    directory" ckpath || "."                  IF RexxUtils                   THEN DO 4                     SAY "Press any key to continue."F                     PARSE UPPER VALUE SysGetKey('NOECHO') WITH confirm                     END                    ELSE DO 4                     SAY "Press <Enter> to continue."$                     PARSE PULL dummy                     END                  END 
           END          ENDLOCAL         END   6     WHEN COMPARE( upperlinetxt, "SET BOOKSHELF" ) = 14
       THEN DO          SETLOCAL         len = LENGTH(linetxt) F         rc = VALUE('BOOKSHELF', SUBSTR( upperlinetxt, 15, len - 15 ),,%                    'OS2ENVIRONMENT' )          IF RexxUtilsB           THEN ckfound = SysSearchPath( 'BOOKSHELF', ckermit.inf )A           ELSE ckfound = MySearchPath( 'BOOKSHELF', ckermit.inf ) =         IF ckfound = "" | ckfound = DIRECTORY()"\CKERMIT.INF" 1           THEN IF SUBSTR( linetxt, len, 1 ) = ';' D             THEN rc = LINEOUT( temp, linetxt || destnoslash || ';' )K             ELSE rc = LINEOUT( temp, linetxt || ';' || destnoslash || ';' )            ELSE DO N             ckpath = FILESPEC('DRIVE', ckfound ) || FILESPEC('PATH', ckfound )             IF ckpath = updest0               THEN rc = LINEOUT( temp, linetxt )               ELSE DO I                 ckpathnoslash = SUBSTR( ckpath, 1, LENGTH( ckpath ) - 1 ) 8                 pos = POS( ckpathnoslash, upperlinetxt )C                 rc = LINEOUT( temp, SUBSTR( linetxt, 1, pos - 1 ) , 7                                     || destnoslash';' , N                                     || SUBSTR( linetxt, pos, len - pos + 1 ) )                 SAY ""                  SAY "  WARNING:"H                 SAY "    An earlier version of 'CKERMIT.INF' exists in",1                     "    directory" ckpath || "."                  IF RexxUtils                   THEN DO 4                     SAY "Press any key to continue."F                     PARSE UPPER VALUE SysGetKey('NOECHO') WITH confirm                     END                    ELSE DO 4                     SAY "Press <Enter> to continue."$                     PARSE PULL dummy                     END                  END 
           END          ENDLOCAL         END   2     WHEN (COMPARE( upperlinetxt, "LIBPATH" ) = 8) 
       THEN DO          SETLOCAL         len = LENGTH(linetxt) B         rc = VALUE('LIBPATH', SUBSTR( upperlinetxt, 9, len - 9 ),,%                    'OS2ENVIRONMENT' )          IF RexxUtils  @           THEN ckfound = SysSearchPath( 'LIBPATH', ckermit.ini )?           ELSE ckfound = MySearchPath( 'LIBPATH', ckermit.ini )          IF ckfound'\' = '\'            THEN DO .             IF SUBSTR( linetxt, len, 1 ) = ';'F               THEN rc = LINEOUT( temp, linetxt || destnoslash || ';' )M               ELSE rc = LINEOUT( temp, linetxt || ';' || destnoslash || ';' )                END            ELSE DO N             ckpath = FILESPEC('DRIVE', ckfound ) || FILESPEC('PATH', ckfound )             IF ckpath = updest               THEN DO -                 rc = LINEOUT( temp, linetxt )                  END                ELSE DO I                 ckpathnoslash = SUBSTR( ckpath, 1, LENGTH( ckpath ) - 1 ) 8                 pos = POS( ckpathnoslash, upperlinetxt )C                 rc = LINEOUT( temp, SUBSTR( linetxt, 1, pos - 1 ) , 7                                     || destnoslash';' , N                                     || SUBSTR( linetxt, pos, len - pos + 1 ) )                 SAY ""                  SAY "  WARNING:"@                 SAY "    " || ckpath "is located in the LIBPATH"T                 SAY "     and it appears to be a previous installation of C-Kermit."S                 SAY "     If you have difficulties starting C-Kermit, try removing" O                 SAY "    " || ckpath "from the LIBPATH statement in CONFIG.SYS" ,                 SAY "     and restart OS/2."                 IF RexxUtils                   THEN DO 4                     SAY "Press any key to continue."F                     PARSE UPPER VALUE SysGetKey('NOECHO') WITH confirm                     END                    ELSE DO 4                     SAY "Press <Enter> to continue."$                     PARSE PULL dummy                     END                  END 
           END          ENDLOCAL         END   
     OTHERWISE #       rc = LINEOUT( temp, linetxt )    END  END    /* Close files */ ! rc = STREAM( temp, 'C', 'CLOSE' ) 7 rc = STREAM( bootdrive || "\Config.sys", 'C', 'CLOSE' )   + COPY temp bootdrive || "\Config.sys > NUL"  
 IF RexxUtils  !   THEN rc = SysFileDelete( temp )     ELSE "CMD /C DEL" temp "> NUL"   SAY "". SAY "  Your CONFIG.SYS file has been updated."= SAY "  Your old CONFIG.SYS has been copied to " backup || "." , SAY "  After reading the following message,") SAY "  Please Shutdown and Restart OS/2."    RETURN /* UpdateConfigSys */  E /*******************************************************************/   K Done : PROCEDURE EXPOSE RexxUtils destination OS2Ver vt220 updest startdir, &                         configupdate ;   SAY ""M SAY "C-Kermit has been successfully installed in the directory" updest || "."  SAY "" IF SUBSTR( OS2Ver, 1, 1 ) = "2" E   THEN SAY "  To start C-Kermit from the desktop, click on its icon."  IF configupdate    THEN  G     SAY "  To start C-Kermit from a command window, just type CKERMIT." 	   ELSE DO G     SAY "  To start C-Kermit from a command window, just type CKERMIT," I     SAY "  or if" updest "is not in your PATH, type" updest || "CKERMIT."    END  SAY "" IF vt220J   THEN SAY "Read the" updest || "CKOVTK2.INI file for VT220 key mappings."M SAY "Please consult the book 'Using C-Kermit' for complete instructions, and" K SAY "also VIEW the CKERMIT.INF file for information about program updates." M SAY "If you don't have 'Using C-Kermit', please telephone +1 212 854-3703 or" % SAY "+1 800 366-2665 (USA) to order."  SAY ""F SAY "In particular, see pages 419-427 for additional installation and" SAY "startup options." SAY "" IF RexxUtils
   THEN DO I     SAY "Press any key to exit from the C-Kermit installation procedure." 6     PARSE UPPER VALUE SysGetKey('NOECHO') WITH confirm     END 	   ELSE DO I     SAY "Press <Enter> to exit from the C-kermit installation procedure."      PARSE PULL dummy   END  rc = DIRECTORY( startdir ) EXIT RETURN /* Done */   E /*******************************************************************/   3 Install : PROCEDURE EXPOSE RexxUtils destination ;     IF "\"ARG(2) = "\"   THEN destname = ARG(1)   ELSE destname = ARG(2)   CALL Backup destname+ COPY ARG(1) destination || destname "> NUL"   
 IF RC > 0 	   THEN DO      CALL BEEP 262, 750K     SAY "ERROR:" destname "could not be installed in directory" destination 
     SAY ""     CALL FAILURE   END  RETURN RC /* Install */   E /*******************************************************************/   1 Backup : PROCEDURE EXPOSE RexxUtils destination ;    IF RexxUtils
   THEN DO 8     CALL SysFileTree destination || ARG(1), 'file', 'FO'     IF file.0 > 0 
       THEN DO =         CALL SysFileTree destination || 'BACKUP', 'dir', 'DO'          IF dir.0 = 04           THEN CALL SysMkDir destination || 'BACKUP'  I         CALL SysFileTree destination || 'BACKUP\' || ARG(1), 'file', 'FO'          IF file.0 > 0 D           THEN CALL SysFileDelete destination || 'BACKUP\' || ARG(1)  M         COPY destination || ARG(1) destination || 'BACKUP\' || ARG(1) '> NUL' 0         CALL SysFileDelete destination || ARG(1)
       END      END 	   ELSE DO :     CALL STREAM destination || ARG(1), 'c', 'query exists'     IF "\"RESULT <> "\" 
       THEN DO 2         "CMD /C DIR" destination || "BACKUP > NUL"         IF RC <> 08           THEN 'CMD /C MD' destination || 'BACKUP > NUL'  K         CALL STREAM destination || "BACKUP\" || ARG(1), 'c', 'query exists'          IF "\"RESULT <> "\" F           THEN "CMD /C DEL" destination || "BACKUP\" || ARG(1) "> NUL"  H   	COPY destination || ARG(1) destination || 'BACKUP\' || ARG(1) '> NUL'# 	"CMD /C DEL" destination || ARG(1)          END      END  RETURN /* Backup */   E /*******************************************************************/   ' Confirmation: PROCEDURE EXPOSE OS2Ver ;    retval = ""  DO WHILE retval = ""   IF SUBSTR(OS2Ver, 1, 1 ) > 1     THEN CALL CHAROUT ,">"   PARSE PULL response    SELECTG     WHEN ( TRANSLATE( response ) = 'N' | TRANSLATE( response ) = 'NO' )        THEN retval = 'N'   H     WHEN ( TRANSLATE( response ) = 'Y' | TRANSLATE( response ) = 'YES' )       THEN retval = 'Y'   
     OTHERWISE        SAY ""?       SAY "Invalid response.  Please type Y or Yes or N or No."    END  END   RETURN retval /* Confirmation */  E /*******************************************************************/ E /* This procedure duplicates as best as possible the RexxUtil      */ E /* function SysSearchPath.                                         */    MySearchPath : PROCEDURE ;  + _path = VALUE( ARG(1), , "OS2ENVIRONMENT" ) + IF SUBSTR( _path, LENGTH(_path), 1 ) <> ";"    THEN _path = _path || ";" $ PARSE UPPER VAR _path _dir ";" _path- DO WHILE ("\"_dir <> "\") | ("\"_path <> "\") 8   CALL STREAM _dir || "\" || ARG(2), 'c', 'query exists'   IF "\"RESULT <> "\" %     THEN RETURN _dir || "\" || ARG(2) -     ELSE PARSE UPPER VAR _path _dir ";" _path    END  RETURN "" /* MySearchPath */  E /*******************************************************************/     IsIBMTCPIPInstalled: PROCEDURE ; RexxUtils = ARG(1), etcpath = VALUE( "ETC", , "OS2ENVIRONMENT" ) len = LENGTH(etcpath)  IF len = 0     THEN tcpip = 0 ELSE DO $   IF SUBSTR( etcpath, len, 1 ) = ';'     THEN DO -       etcpath = SUBSTR( etcpath, 1, len - 1 )        len = len - 1      END $   IF SUBSTR( etcpath, len, 1 ) = '\'     THEN DO -       etcpath = SUBSTR( etcpath, 1, len - 1 )        len = len - 1      END )   tcppath = SUBSTR( etcpath, 1, len - 3 )    IF RexxUtils     THEN DO D       CALL SysFileTree tcppath || "\dll\tcpipdll.dll", 'file', 'FO'        tcpip = file.0     END 	   ELSE DO D     CALL STREAM tcppath || "\dll\tcpipdll.dll", "C", "QUERY EXISTS"      IF "\"RESULT <> "\"        THEN tcpip = 1       ELSE tcpip = 0   END  END & RETURN tcpip /* IsIBMTCPIPInstalled */  E /*******************************************************************/   J GETDIR : PROCEDURE EXPOSE RexxUtils destination OS2Ver updest destnoslash,2                           sourcedir installdrive ; IF ARG(1) = "" THEN DOO   SAY "Please enter the complete path where you want C-Kermit to be installed." K   SAY "Just press the Enter key to accept the default path, C:\CKERMIT\..." P   SAY "If this is an upgrade, it is recommended that you use the same directory"O   SAY "as your previous installation.  No INI files other than CKERMIT.INI are" 5   SAY "overwritten, and all files will be backed up."    IF SUBSTR(OS2Ver, 1, 1 ) > 1     THEN CALL CHAROUT ,">"   PARSE PULL destination   END  ELSE destination = ARG(1) 0 destination = TRANSLATE( destination, '\', '/' )  ( /* Use default if nothing was entered */ IF "\"destination = "\" "   THEN destination = "C:\CKERMIT\"  6 /* Check to make sure there is a trailing backslash */7 IF SUBSTR( destination, LENGTH(destination), 1 ) <> "\" '   THEN destination = destination || "\"   H /* Check to make sure a drive is specified - use startup drive if not */, installdrive = FILESPEC("DRIVE",destination) IF installdrive = ""2   THEN installdrive = FILESPEC("DRIVE", startdir)   > /* Check to make sure a path is specified - use root if not */, installpath  = FILESPEC("PATH", destination) IF installpath = ""    THEN installpath= "\"   6 /* Build fully qualified destination directory name */* destination = installdrive || installpath   & /* And guaranteed-uppercase version */ updest = TRANSLATE(destination)   # /* And a version without a slash */ A destnoslash = SUBSTR( destination, 1, LENGTH( destination ) - 1 )   B /* Ensure that source and destination directories are different */( IF sourcedir"\" = TRANSLATE(destination)	   THEN DO 
     SAY ""C     SAY "The source and destination directories must be different."      CALL GETDIR 
     RETURN   END     /* Validate the install drive */ IF RexxUtils   THEN  G     IF POS( TRANSLATE( installdrive ), "A: B: " || SysDriveMap() ) <> 0        THEN valid = 1       ELSE valid = 0	   ELSE DO %     'CMD /C DIR' installdrive '> NUL' 
     IF rc = 0        THEN valid = 1       ELSE valid = 0     END 
 IF \ valid	   THEN DO 
     SAY "",     SAY installdrive "is not a valid drive."     CALL GETDIR 
     RETURN   END   # /* Confirm destination directory */  SAY ""E SAY "You have asked that C-Kermit be installed in" destination || "."   SAY "Is this correct? (Yes/No):" CALL Confirmation  IF RESULT <> 'Y'  	   THEN DO      CALL GETDIR 
     RETURN   END  SAY "" RETURN /* GetDir */   E /*******************************************************************/   A CheckSpace : PROCEDURE EXPOSE RexxUtils destination installdrive, 4                               spacerequired OS2Ver ;  ! /* Check Available Drive Space */  IF RexxUtils	   THEN DO M   PARSE UPPER VALUE SysDriveInfo( installdrive ) WITH sysinfodrive freespace,      drivesize volumelabel      IF freespace < spacerequired       THEN DO N       SAY "Drive" installdrive "does not have enough free space for C-Kermit."F       SAY "C-Kermit needs" spacerequired "bytes.  Drive" installdrive,*         "only has" freespace "bytes free."C       SAY "Enter 'Yes' to choose another drive, or 'No' to cancel."        CALL Confirmation        IF RESULT = 'Y'          THEN DO            CALL GETDIR            CALL CheckSpace            RETURN         END          ELSE DO            SAY ""           EXIT         END        END      END /* RexxUtils */  RETURN /* CheckSpace */   E /*******************************************************************/   C CreateDir : PROCEDURE EXPOSE RexxUtils destination startdir OS2Ver, ,                              spacerequired ;  9 SAY "Creating destination directory" destination || "..."  IF RexxUtilsA   THEN rc = SysMkDir(SUBSTR(destination,1,LENGTH(destination)-1)) F   ELSE 'CMD /C MD' SUBSTR(destination,1,LENGTH(destination)-1) '> NUL'   SELECT   WHEN rc = 0      THEN SAY ""    8   WHEN ( rc = 5 & RexxUtils ) | ( rc = 1 & \ RexxUtils )     THEN DO 3       SAY "Directory" destination "already exists." F       SAY "Enter 'Yes' to continue or 'No' to choose a new directory."       CALL Confirmation        IF RESULT <> 'Y'         THEN DO            CALL GETDIR            CALL CheckSpace            CALL CreateDir           RETURN         END        SAY ""     END      OTHERWISE      DO:       SAY "Can't create destination directory" destination       SAY ""        rc = DIRECTORY( startdir )       CALL GETDIR        CALL CheckSpace        CALL CreateDir       RETURN     END  END  RETURN /* CreateDir */  E /*******************************************************************/   5 GETMODEM : PROCEDURE EXPOSE RexxUtils OS2Ver modem  ;    SAY ""H SAY "C-Kermit is designed to work with many different brands of modems."F SAY "Please choose your preferred modem type from the following list:" SAY ""G SAY " attdtdm            attisn             attmodem           att7300" G SAY " ccitt-v25bis       cermetek           concord            courier" L SAY " df03-ac            df100-series       df200-series       digitel-dt22"D SAY " gdc-212a/ed        hayes              microcom           none"D SAY " penril             pep-telebit        racalvadic         rolm"G SAY " slow-telebit       sportster          telebit            unknown" F SAY " usrobotics-212a    v32-telebit        v42-telebit        ventel" SAY ""7 SAY "Pressing the Enter key by itself selects HAYES..."  IF SUBSTR(OS2Ver, 1, 1 ) > 1   THEN CALL CHAROUT ,">" PARSE PULL modem  & /* Use Hayes if nothing was entered */
 IF modem = ""    THEN modem = "hayes"   umodem = TRANSLATE(modem) K IF  (umodem \= "ATTDTDM") & (Umodem \= "ATTISN") & (Umodem \= "ATTMODEM"),  7   & (Umodem \= "ATT7300") & (Umodem \= "CCITT-V25BIS"),    & (Umodem \= "CERMETEK"), J   & (Umodem \= "CONCORD") & (Umodem \= "COURIER") & (Umodem \= "DF03-AC"),<   & (Umodem \= "DF100-SERIES") & (Umodem \= "DF200-SERIES"),;   & (Umodem \= "DIGITAL-DT22") & (Umodem \= "GDC-212A/ED"),    & (Umodem \= "HAYES"),  G   & (Umodem \= "MICROCOM") & (Umodem \= "NONE") & (Umodem \= "PENRIL"), N   & (Umodem \= "PEP-TELEBIT") & (Umodem \= "RACALVADIC") & (Umodem \= "ROLM"),9   & (Umodem \= "SLOW-TELEBIT") & (Umodem \= "SPORTSTER"),    & (Umodem \= "TELEBIT"),:   & (Umodem \= "UNKNOWN") & (Umodem \= "USROBOTICS-212A"),   & (Umodem \= "V32-TELEBIT"),4   & (Umodem \= "V42-TELEBIT") & (Umodem \= "VENTEL")	   THEN DO *     SAY "'"modem"' is not a valid choice."     CALL GETMODEM 
     RETURN   END   6 SAY "You have chosen '"modem"' as your default modem."  SAY "Is this correct? (Yes/No):"   CALL Confirmation  IF RESULT <> 'Y'	   THEN DO      CALL GETMODEM 
     RETURN   END  RETURN /* GetModem */   E /*******************************************************************/   2 GETPORT : PROCEDURE EXPOSE RexxUtils OS2Ver port ;   SAY ""D SAY "C-Kermit can work with all valid serial communication devices."6 SAY "ISA and EISA machines support COM1 through COM4."6 SAY "MicroChannel machines support COM1 through COM8."C SAY "However, most computers have only COM1 and COM2 regardless of"  SAY "their architecture."  SAY ""J SAY "Please choose the communications port to which your" modem "modem is"< SAY "connected.  Pressing <Enter> by itself selects COM1..." IF SUBSTR(OS2Ver, 1, 1 ) > 1   THEN CALL CHAROUT ,">" PARSE PULL port   % /* Use com1 if nothing was entered */  IF port = ""   THEN port = "com1"  D IF LENGTH( port ) <> 4 | TRANSLATE( SUBSTR( port, 1, 3 ) ) <> "COM",6   | SUBSTR( port, 4, 1) < 1 | SUBSTR( port, 4, 1 ) > 8	   THEN DO )     SAY "'"port"' is not a valid choice."      CALL GETPORT
     RETURN   END   C SAY "You have chosen '"port"' as your default communications port."   SAY "Is this correct? (Yes/No):"   CALL Confirmation  IF RESULT <> 'Y'	   THEN DO      CALL GETPORT
     RETURN   END  RETURN /* GetPort */  E /*******************************************************************/   4 GETSPEED : PROCEDURE EXPOSE RexxUtils OS2Ver speed ;   SAY ""E SAY "C-Kermit can communicate at all hardware-supported transmission" E SAY "speeds.  Please select one of the following speeds, measured in" @ SAY "bits per second, as the default speed for port" port || "." SAY ""' SAY "  50    200   2400   9600   57600" ' SAY "  75    300   3600  14400   76800" ' SAY " 110    600   4800  19200  115200" ' SAY " 150   1200   7200  38400        "  SAY ""4 SAY "Pressing <Enter> by itself selects 9600 bps..." IF SUBSTR(OS2Ver, 1, 1 ) > 1   THEN CALL CHAROUT ,">" PARSE PULL speed  % /* Use 9600 if nothing was entered */ 
 IF speed = ""    THEN speed = "9600"   D IF speed <> "50" & speed <> "75" & speed <> "110" & speed <> "150" ,G   & speed <> "200" & speed <> "300" & speed <> "600" & speed <> "1200", J   & speed <> "2400" & speed <> "3600" & speed <> "4800" & speed <> "7200",M   & speed <> "9600" & speed <> "14400" & speed <> "19200" & speed <> "38400", ;   & speed <> "57600" & speed <> "76800" & speed <> "115200" 
   THEN DO *     SAY "'"speed"' is not a valid choice."     CALL GETSPEED 
     RETURN   END   C SAY "You have chosen '"speed"' as your default transmission speed."   SAY "Is this correct? (Yes/No):"   CALL Confirmation  IF RESULT <> 'Y'	   THEN DO      CALL GETSPEED 
     RETURN   END  RETURN /* GetSpeed */   E /*******************************************************************/   8 GETRUNMODE : PROCEDURE EXPOSE RexxUtils OS2Ver runmode ;   IF SUBSTR( OS2Ver, 1, 1 ) = "2" 	   THEN DO 
     SAY ""M     SAY "C-Kermit may be run either in a full screen session or in a window." M     SAY "Full screen sessions are faster, window sessions give you access to" H     SAY "more OS/2 features, like cut and paste.  Please select either:"
     SAY ""     SAY "  Fullscreen"     SAY "  Window"
     SAY ""6     SAY "Pressing <Enter> by itself selects Window..."      IF SUBSTR(OS2Ver, 1, 1 ) > 1       THEN CALL CHAROUT ,">"     PARSE PULL runmode  0     /* Run in a window if nothing was entered */     IF runmode = ''        THEN runmode = "Window"   #     Urunmode = TRANSLATE( runmode ) 3     IF Urunmode <> "WINDOW"    & Urunmode <> "W" &, 0       Urunmode <> "FULLSCREEN" & Urunmode <> "F"
       THEN DO 0         SAY "'"runmode"' is not a valid choice."         CALL GETRUNMODE          RETURN	       END        IF Urunmode = "W"        THEN runmode = "Window"        IF Urunmode = "F" !       THEN runmode = "Fullscreen"   A     SAY "You have chosen to run C-Kermit in a" runmode "session." $     SAY "Is this correct? (Yes/No):"       CALL Confirmation      IF RESULT <> 'Y'
       THEN DO          CALL GETRUNMODE          RETURN	       END 
     SAY ""   END  RETURN /* GetRunMode */   E /*******************************************************************/   : UnableToCompleteInstallation : PROCEDURE EXPOSE startdir ;   rc = Directory( startdir ) SAY ""D SAY "The above error has prevented the successful completion of the"D SAY "C-Kermit Installation routine.  Please take corrective actions" SAY "and retry this operation."  SAY "" EXIT) RETURN /* UnableToCompleteInstallation */   E /*******************************************************************/   0 InstallSerialSupport : PROCEDURE EXPOSE OS2Ver ;   retval = 0  
 IF \ARG(1)   THEN retval = 1 	   ELSE DO I     SAY "IBM TCP/IP is installed on this machine, and C-Kermit will be"   L     SAY "configured to use it.  Do you also wish to use C-Kermit for serial"F     SAY "communications via modems or direct serial-port connections?"     SAY "(Yes/No): "     IF Confirmation() = 'Y'        THEN retval = 1      
     SAY ""   END ( RETURN retval /* InstallSerialSupport */  E /*******************************************************************/     InstallVT220KeyMap : PROCEDURE ;   retval = 0  J   SAY "Do you want full VT220 terminal key mappings installed? (Yes/No): "   IF Confirmation() = 'Y'      THEN retval = 1    SAY ""& RETURN retval /* InstallVT220KeyMap */  E /*******************************************************************/   ) FileExists : PROCEDURE EXPOSE RexxUtils ; 
 Retval = 0 IF RexxUtils	   THEN DO )     CALL SysFileTree ARG(1), "file", "FO"      IF file.0 > 0        THEN Retval = 1      END 	   ELSE DO +     CALL STREAM ARG(1), 'c', 'query exists'      IF "\"RESULT <> "\"        THEN Retval = 1      END 
 RETURN Retval   E /*******************************************************************/    Failure : PROCEDURE   , SAY "C-Kermit Installation has failed. :-("  SAY ""  I SAY "The installation process has encountered an error which prevents it" ? SAY "from installing one or more files.  Possible causes are: " ( SAY "   (1) the source file is missing;"B SAY "   (2) the destination filename already exists and is marked"$ SAY "       read-only or system; or"G SAY "   (3) the destination filename is an EXE or DLL and is currently" - SAY "       in use by an active application."  SAY ""N SAY "Please take corrective actions and reexecute the installation procedure." EXIT   RETURN    # /* End OS/2 C-Kermit INSTALL.CMD */ 