6 /*  C K O N B I  --  OS/2-specific NetBios support  */   /*   COPYRIGHT NOTICE:   N   Copyright (C) 1985, 1994, Trustees of Columbia University in the City of NewK   York.  The C-Kermit software may not be, in whole or in part, licensed or L   sold for profit as a software product itself, nor may it be included in orM   distributed with commercial products or otherwise distributed by commercial J   concerns to their clients or customers without written permission of theK   Office of Kermit Development and Distribution, Columbia University.  This =   copyright notice must not be removed, altered, or obscured.  */   /*5    developed by Jeffrey Altman <p00118@psilink.com>            Supports:$       Traditional NetBios interface:-          IBM Lan Adapter and Protocol Support #          IBM OS/2 Extended Services $          IBM Communication Manager/2         Newer Netbeui Interface:(          Microsoft LAN Manager Requester!          IBM LAN Server Requester !          Novell Netware Requester  */   #ifdef CK_NETBIOS  #ifndef CKCMAI #ifndef CKONBI_H #define CKONBI_H  F /*------------------------------------------------------------------*/F /*             TYPE DEFINITIONS FOR DATA DECLARATIONS               */F /*------------------------------------------------------------------*/     typedef unsigned char byte;    typedef unsigned short word;   typedef unsigned long dword;   #pragma seg16(address)  )   typedef unsigned char * _Seg16 address;    #pragma seg16(HSEM16)    typedef void * _Seg16 HSEM16;    typedef HSEM16 * PHSEM16;   D /*----------------------------------------------------------------*/D /*                       NETBIOS COMMAND CODES                    */D /*----------------------------------------------------------------*/  B      #define   NB_CALL_WAIT                                 0x0010B      #define   NB_LISTEN_WAIT                               0x0011B      #define   NB_HANG_UP_WAIT                              0x0012B      #define   NB_SEND_WAIT                                 0x0014B      #define   NB_RECEIVE_WAIT                              0x0015B      #define   NB_RECEIVE_ANY_WAIT                          0x0016B      #define   NB_CHAIN_SEND_WAIT                           0x0017B      #define   NB_SEND_DATAGRAM_WAIT                        0x0020B      #define   NB_RECEIVE_DATAGRAM_WAIT                     0x0021B      #define   NB_SEND_BROADCAST_DATAGRAM_WAIT              0x0022B      #define   NB_RECEIVE_BROADCAST_DATAGRAM_W              0x0023B      #define   NB_ADD_NAME_WAIT                             0x0030B      #define   NB_DELETE_NAME_WAIT                          0x0031B      #define   NB_RESET_WAIT                                0x0032B      #define   NB_STATUS_WAIT                               0x0033B      #define   NB_SESSION_STATUS_WAIT                       0x0034B      #define   NB_CANCEL_WAIT                               0x0035B      #define   NB_ADD_GROUP_NAME_WAIT                       0x0036B      #define   NB_UNLINK_WAIT                               0x0070B      #define   NB_SEND_NO_ACK_WAIT                          0x0071B      #define   NB_CHAIN_SEND_NO_ACK_WAIT                    0x0072B      #define   NB_FIND_NAMEWAIT                             0x0078  B      #define   NB_CALL                                      0x0090B      #define   NB_LISTEN                                    0x0091B      #define   NB_HANG_UP                                   0x0092B      #define   NB_SEND                                      0x0094B      #define   NB_RECEIVE                                   0x0095B      #define   NB_RECEIVE_ANY                               0x0096B      #define   NB_CHAIN_SEND                                0x0097B      #define   NB_SEND_DATAGRAM                             0x00A0B      #define   NB_RECEIVE_DATAGRAM                          0x00A1B      #define   NB_SEND_BROADCAST_DATAGRAM                   0x00A2B      #define   NB_RECEIVE_BROADCAST_DATAGRAM                0x00A3B      #define   NB_ADD_NAME                                  0x00B0B      #define   NB_DELETE_NAME                               0x00B1B      #define   NB_STATUS                                    0x00B3B      #define   NB_SESSION_STATUS                            0x00B4B      #define   NB_ADD_GROUP_NAME                            0x00B6B      #define   NB_SEND_NO_ACK                               0x00F1B      #define   NB_CHAIN_SEND_NO_ACK                         0x00F2B      #define   NB_LAN_STATUS_ALERT                          0x00F3B      #define   NB_FIND_NAME                                 0x00F8  B      #define   NB_INVALID_COMMAND_CODE                      0x00FF    D /*----------------------------------------------------------------*/D /*                       NETBIOS RETURN CODES                     */D /*----------------------------------------------------------------*/  B      #define   NB_COMMAND_SUCCESSFUL                        0x0000B      #define   NB_ILLEGAL_BUFFER_LEN                        0x0001B      #define   NB_INVALID_COMMAND                           0x0003B      #define   NB_COMMAND_TIME_OUT                          0x0005B      #define   NB_MESSAGE_INCOMPLETE                        0x0006B      #define   NB_DATA_NOT_RECEIVED                         0x0007B      #define   NB_ILLEGAL_LOCAL_SESSION                     0x0008B      #define   NB_NO_RES_AVAILABLE                          0x0009B      #define   NB_SESSION_CLOSED                            0x000AB      #define   NB_COMMAND_CANCELLED                         0x000BB      #define   NB_DUPLICATE_NAME                            0x000DB      #define   NB_NAME_TABLE_FULL                           0x000EB      #define   NB_CMND_CMPL_DEREGISTERED                    0x000FB      #define   NB_SESSION_TABLE_FULL                        0x0011B      #define   NB_SES_OPEN_REJECTED                         0x0012B      #define   NB_ILLEGAL_NAME_NUMBER                       0x0013B      #define   NB_REMOTE_NAME_NOT_FOUND                     0x0014B      #define   NB_LOCAL_NAME_NOT_FOUND                      0x0015B      #define   NB_NAME_IN_USE                               0x0016B      #define   NB_NAME_DELETED                              0x0017B      #define   NB_SESSION_ENDED_ABNORMALLY                  0x0018B      #define   NB_NAME_CONFLICT                             0x0019B      #define   NB_INTERFACE_BUSY                            0x0021B      #define   NB_MAX_CMNDS_EXCEEDED                        0x0022B      #define   NB_INVALID_ADAPTER                           0x0023B      #define   NB_CMND_ALREADY_COMPLETED                    0x0024B      #define   NB_CMND_INVALID_TO_CANCEL                    0x0026B      #define   NB_NAME_DEFINED_BY_OTHERS                    0x0030B      #define   NB_ENVIRONMENT_NOT_DEFINED                   0x0034B      #define   NB_NO_OS_RESOURCES                           0x0035B      #define   NB_MAX_APPL_EXCEEDED                         0x0036B      #define   NB_NO_SAP_AVAILABLE                          0x0037B      #define   NB_INADEQUATE_RESOURCES                      0x0038B      #define   NB_INVALID_NCB_ADDRESS                       0x0039B      #define   NB_RESET_INVALID                             0x003AB      #define   NB_INVALID_DD_ID                             0x003BB      #define   NB_SEGMENT_LOCK_UNSUCCESSFUL                 0x003CB      #define   NB_DD_OPEN_ERROR                             0x003FB      #define   NB_OS_ERROR_DETECTED                         0x0040B      #define   NB_PERM_RING_STATUS                          0x004F  B      #define   NB_UNEXPECTED_CCB_ERROR                      0x00F6B      #define   NB_ADAPTER_OPEN_ERROR                        0x00F8B      #define   NB_ADAPTER_HANDLER_ERROR                     0x00F9B      #define   NB_ADAPTER_CHECK                             0x00FAB      #define   NB_CODE_NOT_OPERATIONAL                      0x00FBB      #define   NB_OPEN_FAILURES                             0x00FCB      #define   NB_UNEXPECTED_CLOSE                          0x00FD  B      #define   NB_COMMAND_IN_PROCESS                        0x00FF  F /*------------------------------------------------------------------*/F /*               NETBIOS NCB SESSION STATES                         */F /*------------------------------------------------------------------*/  B      #define   NB_SESSION_STATE_CLOSED                      0x0000B      #define   NB_SESSION_STATE_LISTEN_PENDING              0x0001B      #define   NB_SESSION_STATE_CALL_PENDING                0x0002B      #define   NB_SESSION_STATE_SESSION_ACTIVE              0x0003B      #define   NB_SESSION_STATE_HANGUP_PENDING              0x0004B      #define   NB_SESSION_STATE_HANGUP_COMPLETE             0x0005B      #define   NB_SESSION_STATE_SESSION_ABORTED             0x0006  F /*------------------------------------------------------------------*/F /*               NETBIOS NCB DATA DECLARATIONS                      */F /*------------------------------------------------------------------*/    struct     network_control_block  {G   byte       ncb_command;               /* Netbios command code      */ G   byte       ncb_retcode;               /* Return code               */ G   byte       ncb_lsn;                   /* Local session number      */ G   byte       ncb_num;                   /* Number of application name*/ G   address    ncb_buffer_address;        /* Address of message buffer */ G   word       ncb_length;                /* length of message buffer  */ G   byte       ncb_callname[16];          /* Destination name          */ G   byte       ncb_name[16];              /* Source name               */ G   byte       ncb_rto;                   /* Receive timeout           */ G   byte       ncb_sto;                   /* Send timeout              */ G   union                                 /* Offset 44 parameters      */     {G    address   ncb_post_address;          /* Address of post routine   */ G    HSEM16    ncb_post_handle;           /* Handle to event semaphore */ 	    struct      { G     word     ncb_post_addr_offset;      /* Offset of post routine    */ G     word     ncb_dd_id;                 /* Device driver ID          */ 	     } DD;     } off44; G   byte       ncb_lana_num;              /* Adapter number            */ G   byte       ncb_cmd_cplt;              /* Command status            */ G   byte       ncb_reserve[14];           /* Reserved (except RESET)   */   };     ! struct     ncb_status_information   {G   byte       burned_in_addr[6];         /* Adapter's burned in addr  */ G   byte       reserved1[2];              /* RESERVED always X'0000'   */ G   word       software_level_number;     /* X'FFnn' - nn is level num */ G   word       reporting_period;          /* reporting period (minutes)*/ G   word       frmr_frames_received;      /* Number of FRMR received   */ G   word       frmr_frames_sent;          /* Number of FRMR sent       */ G   word       bad_iframes_received;      /* # bad Iframes received    */ G   word       aborted_transmissions;     /* # aborted transmits       */ G   dword      packets_transmitted;       /* # Successfully transmitted*/ G   dword      packets_received;          /* # Successfully received   */ G   word       bad_iframes_transmitted;   /* # bad Iframes transmitted */ G   word       lost_data_count;           /* Lost SAP buffer data cnt  */ G   word       t1_expiration_count;       /* Number of T1 expirations  */ G   word       ti_expiration_count;       /* Number of Ti expirations  */ G   address    extended_status_table;     /* Address of extended status*/ G   word       number_of_free_ncbs;       /* Number of NCBs available  */ G   word       max_configured_ncbs;       /* Configured NCB maximum    */ G   word       max_allowed_ncbs;          /* Maximum NCBs (always 255) */ G   word       busy_condition_count;      /* Local station busy count  */ G   word       max_datagram_size;         /* Maximum datagram packet   */ G   word       pending_sessions;          /* Number of pending sessions*/ G   word       max_configured_sessions;   /* Configured session maximum*/ G   word       max_allowed_sessions;      /* Maximum sessions (254)    */ G   word       max_data_packet_size;      /* Maximum session packet    */ G   word       number_of_names_present;   /* Number of names in table  */   };      struct     ncb_extended_status  {G   byte       reserved[40];              /* RESERVED                  */ G   byte       local_adapter_address[6];  /* Adapter's local address   */   };      struct     ncb_session_status   {G   byte       name_number_of_sessions;   /* Name number for sessions  */ G   byte       sessions_using_name;       /* # of sessions using name  */ G   byte       active_rcv_datagrams;      /* # of receive datagrams out*/ G   byte       active_receive_anys;       /* # of RECEIVE.ANY cmnds out*/ G   byte       local_session_number;      /* Local session number      */ G   byte       session_state;             /* State of session          */ G   byte       local_name[16];            /* Local name                */ G   byte       remote_name[16];           /* Remote name               */ G   byte       active_receives;           /* # of RECEIVE cmnds out    */ G   byte       active_sends;              /* # of SEND, CHAIN.SEND out */   };      struct     ncb_find_name_info   {G   word       nodes_responding;          /* Number of nodes responding*/ G   byte       reserved;                  /* RESERVED                  */ G   byte       name_status;               /* Unique/Group name flag    */   };      struct     ncb_lan_header_entry   {G   byte       lan_entry_length;          /* Length of entry           */ G   byte       lan_pcf0;                  /* Physical control field 0  */ G   byte       lan_pcf1;                  /* Physical control field 1  */ G   byte       lan_destination_addr[6];   /* Destination address       */ G   byte       lan_source_addr[6];        /* Source address            */ G   byte       lan_routing_info[18];      /* Routing information       */   };    struct     ncb_chain_send   {G   byte       ncb_command;               /* Netbios command code      */ G   byte       ncb_retcode;               /* Return code               */ G   byte       ncb_lsn;                   /* Local session number      */ G   byte       not_used1;                 /* Not used                  */ G   address    ncb_buffer_address;        /* Address of message buffer */ G   word       ncb_length;                /* Length of message buffer  */ G   word       buffer_two_length;         /* Length of second buffer   */ G   address    buffer_two_address;        /* Address to second buffer  */ G   byte       reserved[10];              /* RESERVED                  */ G   byte       not_used2[18];             /* Not used                  */ G   union                                 /* Offset 44 parameters      */     {G    address   ncb_post_address;          /* Address of post routine   */ 	    struct      { G     word     ncb_post_addr_offset;      /* Offset of post routine    */ G     word     ncb_dd_id;                 /* Device driver ID          */ 	     } DD;     } off44 ;G   byte       ncb_lana_num;              /* Adapter number            */ G   byte       ncb_cmd_cplt;              /* Command status            */ G   byte       ncb_reserve[14];           /* Reserved                  */   };      struct     ncb_reset  {G   byte       ncb_command;               /* Netbios command code      */ G   byte       ncb_retcode;               /* Return code               */ G   byte       ncb_lsn;                   /* Local session number      */ G   byte       ncb_num;                   /* Number of application name*/ G   address    dd_name_address;           /* Device drive name address */ G   byte       not_used1[2];              /* Not used                  */ G   byte       req_sessions;              /* # of sessions requested   */ G   byte       req_commands;              /* # of commands requested   */ G   byte       req_names;                 /* # of names requested      */ G   byte       req_name_one;              /* Name number one request   */ G   byte       not_used2[12];             /* Not used                  */ G   byte       act_sessions;              /* # of sessions obtained    */ G   byte       act_commands;              /* # of commands obtained    */ G   byte       act_names;                 /* # of names obtained       */ G   byte       act_name_one;              /* Name number one response  */ G   byte       not_used3[4];              /* Not used                  */ G   byte       load_session;              /* Number of sessions at load*/ G   byte       load_commands;             /* Number of commands at load*/ G   byte       load_names;                /* Number of names at load   */ G   byte       load_stations;             /* Number of stations at load*/ G   byte       not_used4[2];              /* Not used                  */ G   byte       load_remote_names;         /* Number of remote names    */ G   byte       not_used5[5];              /* Not used                  */ G   word       ncb_dd_id;                 /* NCB device driver ID      */ G   byte       ncb_lana_num;              /* Adapter number            */ G   byte       not_used6;                 /* Not used                  */ G   byte       ncb_reserve[14];           /* NCB error information     */   };   F /*------------------------------------------------------------------*/F /*               NETBIOS TRACE DATA DECLARATIONS                    */F /*------------------------------------------------------------------*/   struct     ncb_entry_header   {G   byte       trace_adapter_number;      /* Adapter number for trace  */ G   byte       trace_environment_id;      /* Trace environment ID      */ G   byte       trace_type;                /* Trace type                */ G   byte       trace_modifier;            /* Trace modifier            */ G   byte       reserved[4];               /* RESERVED                  */   };    struct     ncb_trace_ncb  {G   struct     ncb_entry_header common;   /* Trace entry header        */ G   byte       byte_preceding_ncb;        /* Byte preceding NCB        */ G   byte       byte_following_ncb;        /* Byte following NCB        */ G   address    post_address;              /* Address of post routine   */ G   address    data_address;              /* Address of data           */ G   byte       data_sample[16];           /* Sample of data at address */   };      struct     ncb_trace_status   {G   struct     ncb_entry_header common;   /* Trace entry header        */ G   word       ds_register;               /* DS register contents      */ G   word       ss_register;               /* SS register contents      */ G   word       sp_register;               /* SP register contents      */ G   address    data_address;              /* Address of data           */   };       struct     ncb_trace_ring_status  {G   struct     ncb_trace_status common;   /* Trace entry header        */ G   word       ring_status;               /* Ring status               */   };      struct     ncb_system_action  {G   struct     ncb_trace_status common;   /* Trace entry header        */ G   byte       system_action_id;          /* System action ID          */ G   byte       sap_value;                 /* SAP value affected        */   };      struct     ncb_trace_pc_error   {G   struct     ncb_trace_status common;   /* Trace entry header        */ G   word       error_code;                /* PC-Detected error code    */   };     # struct     ncb_trace_adapter_status   {G   struct     ncb_trace_status common;   /* Trace entry header        */ G   word       status_code;               /* Adapter Check reason code */   };      struct     ncb_trace_dlc_status   {G   struct     ncb_trace_status common;   /* Trace entry header        */ G   word       station_id;                /* Station ID                */ G   word       dlc_status;                /* DLC Status code           */ G   byte       frmr_data[5];              /* FRMR data                 */ G   byte       access_priority;           /* Access priority           */ G   byte       remote_node_addr[6];       /* Remote node address       */   };       struct     ncb_trace_return_code  {G   struct     ncb_trace_status common;   /* Trace entry header        */ G   byte       msg_header_xmit[16];       /* Message header transmitted*/   };      struct     ncb_trace_receive  {G   struct     ncb_trace_status common;   /* Trace entry header        */ G   byte       msg_header_rcv[16];        /* Message header received   */   };      struct     ncb_trace_ccb  {G   struct     ncb_trace_status common;   /* Trace entry header        */ G   byte       ccb_data[16];              /* CCB data structure        */   };   ! extern unsigned NETBIOS (char *); * #pragma linkage(NETBIOS, far16 pascal)       union ncb_types     {    struct fncb {)        struct network_control_block bncb;         HSEM16 ncb_semaphore;    } basic_ncb;     struct ncb_chain_send send;    struct ncb_reset reset;    };   A /**************************************************************** A  *                                                              * A  *              Begin NETBEUI declarations and constants        * A  *                                                              * B  ****************************************************************/   #define DEVLEN 8 #define NETBIOS_NAME_LEN 16    typedef struct netbios_info_0 { 4     char           nb0_net_name[NETBIOS_NAME_LEN+1];1 } NETINFO0, *PNETINFO0;      /* netbios_info_0 */    typedef struct netbios_info_1 { 4     char           nb1_net_name[NETBIOS_NAME_LEN+1];K     char           nb1_driver_name[DEVLEN+1];/* OS/2 device driver name  */ K     unsigned char  nb1_lana_num;       /* LAN adapter number of this net */      char           nb1_pad_1; #     unsigned short nb1_driver_type; "     unsigned short nb1_net_status;K     unsigned long  nb1_net_bandwidth;  /* Network bandwidth, bits/second */ K     unsigned short nb1_max_sess;       /* Max number of sessions         */ K     unsigned short nb1_max_ncbs;       /* Max number of outstanding NCBs */ K     unsigned short nb1_max_names;      /* Max number of names            */ 1 } NETINFO1, *PNETINFO1;      /* netbios_info_1 */   A /**************************************************************** A  *                                                              * A  *              Special values and constants                    * A  *                                                              * B  ****************************************************************/     /*'  *      Driver types (nb1_driver_type).   */    #define NB_TYPE_NCB     1  #define NB_TYPE_MCB     2    /*'  *      Bits defined in nb1_net_status.   */   @ #define NB_LAN_FLAGS_MASK       0x3FFF  /* Mask for LAN Flags */J #define NB_LAN_MANAGED          0x0001  /* LAN is managed by redirector */F #define NB_LAN_LOOPBACK         0x0002  /* LAN is a loopback driver */G #define NB_LAN_SENDNOACK        0x0004  /* LAN allows SendNoAck NCBs */ D #define NB_LAN_LMEXT            0x0008  /* LAN supports LAN Manager L                                                             extended NCBs */J #define NB_LAN_INTNCB           0x0010  /* LAN allows NCB submission at */K                                         /* interrupt time (from NCBDone) */ & #define NB_LAN_NORESET          0x0040  I #define NB_OPEN_MODE_MASK       0xC000  /* Mask for NetBios Open Modes */ L #define NB_OPEN_REGULAR         0x4000  /* NetBios opened in Regular mode */O #define NB_OPEN_PRIVILEGED      0x8000  /* NetBios opened in Privileged mode */ N #define NB_OPEN_EXCLUSIVE       0xC000  /* NetBios opened in Exclusive mode */   /*#  *      Open modes for NetBiosOpen.   */    #define NB_REGULAR      1  #define NB_PRIVILEGED   2  #define NB_EXCLUSIVE    3   ' #define NCBSIZE sizeof(union ncb_types) 5 #define BNCBSIZE sizeof(struct network_control_block)  typedef union ncb_types NCB;1 typedef union ncb_types * PNCB, * _Seg16 PNCB16 ; ? typedef struct ncb_status_information STATUSINFO, *PSTATUSINFO; = typedef struct ncb_session_status SESSIONINFO, *PSESSIONINFO; : typedef struct ncb_find_name FINDNAMEINFO, *PFINDNAMEINFO;= typedef struct pbuf2 { USHORT Length; PBYTE Buffer; } *PBuf2;   F USHORT NCBAddGroupName(BOOL Netbeui, PNCB Ncb,USHORT lana,PBYTE name);A USHORT NCBAddName(BOOL Netbeui, PNCB Ncb,USHORT lana,PBYTE name); @ USHORT NCBCall(BOOL Netbeui, PNCB Ncb,USHORT lana,PBYTE lclname,D    PBYTE rmtname,USHORT recv_timeout,USHORT send_timeout,BOOL wait);F USHORT NCBCancel(BOOL Netbeui, PNCB Ncb,USHORT lana,PNCB NcbToCancel);B USHORT NCBChainSend(BOOL Netbeui, PNCB Ncb,USHORT lana,USHORT lsn,H    PBYTE message,USHORT length,PBYTE Buffer2, USHORT Length2,BOOL wait);G USHORT NCBChainSendNoAck(BOOL Netbeui, PNCB Ncb,USHORT lana,USHORT lsn, H    PBYTE message,USHORT length,PBYTE Buffer2, USHORT Length2,BOOL wait);4 USHORT NCBClose(BOOL Netbeui, PNCB Ncb,USHORT lana);E USHORT NCBConfig(BOOL Netbeui, PNCB Ncb,USHORT lana,PUSHORT sessions, #    PUSHORT commands,PUSHORT names); G USHORT NCBDeleteName(BOOL Netbeui, PNCB Ncb,USHORT lana,PBYTE lclname); @ USHORT NCBHangup(BOOL Netbeui, PNCB Ncb,USHORT lana,USHORT lsn);B USHORT NCBListen(BOOL Netbeui, PNCB Ncb,USHORT lana,PBYTE lclname,D    PBYTE rmtname,USHORT recv_timeout,USHORT send_timeout,BOOL wait);M USHORT NCBReceive(BOOL Netbeui, PNCB Ncb,USHORT lana,USHORT lsn,PBYTE buffer,     USHORT length,BOOL wait);C USHORT NCBReceiveAny(BOOL Netbeui, PNCB Ncb,USHORT lana,USHORT lsn, )    PBYTE buffer,USHORT length,BOOL wait); I USHORT NCBReceiveBroadcast(BOOL Netbeui, PNCB Ncb,USHORT lana,USHORT lsn, )    PBYTE buffer,USHORT length,BOOL wait); H USHORT NCBReceiveDatagram(BOOL Netbeui, PNCB Ncb,USHORT lana,USHORT lsn,)    PBYTE buffer,USHORT length,BOOL wait); C USHORT NCBReset(BOOL Netbeui, PNCB Ncb,USHORT lana,USHORT sessions, !    USHORT commands,USHORT names); K USHORT NCBSend(BOOL Netbeui, PNCB Ncb,USHORT lana,USHORT lsn,PBYTE message,     USHORT length,BOOL wait);F USHORT NCBSendBroadcast(BOOL Netbeui, PNCB Ncb,USHORT lana,USHORT lsn,*    PBYTE message,USHORT length,BOOL wait);E USHORT NCBSendDatagram(BOOL Netbeui, PNCB Ncb,USHORT lana,USHORT lsn, 8    PBYTE rmtname,PBYTE message,USHORT length,BOOL wait);B USHORT NCBSendNoAck(BOOL Netbeui, PNCB Ncb,USHORT lana,USHORT lsn,*    PBYTE message,USHORT length,BOOL wait);E USHORT NCBStatus(BOOL Netbeui, PNCB Ncb, USHORT lana, PBYTE callname, /    PSTATUSINFO pInfo, word length, BOOL wait ); K USHORT NCBSessionStatus(BOOL Netbeui, PNCB Ncb, USHORT lana, PBYTE lclname, 0    PSESSIONINFO pInfo, word length, BOOL wait );M USHORT NCBFindName( BOOL Netbeui, PNCB Ncb, USHORT lana, PFINDNAMEINFO pInfo,     USHORT length, BOOL wait ) ; # USHORT netbios_avail(BOOL Netbeui); 4 USHORT loadapi(PSZ module, PSZ proc, PFN FAR *addr);  D #define NB_ADAPTERS 4               /* number of virtual adapters */D #define NB_LSN 2                    /* number of NetBios sessions */D #define NB_NCB MAXWS+3              /* number of outstanding NCBs */D #define NB_NAMES 2                  /* number of names            */E #define NB_RECV_TIMEOUT 0           /* seconds                    */  E #define NB_SEND_TIMEOUT 0           /* seconds                    */     extern BOOL NetbeuiAPI ; extern USHORT netbiosAvail ;+ _PROTOTYP( void os2_netbiosinit, (void) ) ; - _PROTOTYP( void os2_netbioscleanup,(void) ) ;     0 /* Declarations of 16-bit Semaphore interface */  < APIRET16 APIENTRY16 Dos16CreateSem( USHORT, PHSEM16, PSZ ) ;2 APIRET16 APIENTRY16 Dos16SemWait( HSEM16, LONG ) ;+ APIRET16 APIENTRY16 Dos16SemSet( HSEM16 ) ; - APIRET16 APIENTRY16 Dos16SemClear( HSEM16 ) ; - APIRET16 APIENTRY16 Dos16CloseSem( HSEM16 ) ;    #endif /* CKONBI_H */  #endif /* CKCMAI */  #endif /* CK_NETBIOS */ 