J /* XSEND.CMD - A C-Kermit Rexx program to transmit an entire            */J /*             directory tree from one computer to another.             */J /*                                                                      */J /* Alias: CKOXSE.CMD.                                                   */J /* Author: Jeffrey Altman - Altmania Productions                        */J /* Version 2, July 16, 1994                                             */J /*                                                                      */J /* Format:                                                              */J /*  XSEND <PATH> <FILESPEC>  e.g., XSEND C:\\ *                         */J /*  (Note: backslashes must be doubled.)                                */J /*                                                                      */J /* To send an entire directory tree from one OS/2 System to another:    */J /*                                                                      */J /* REMOTE                                                               */J /*  set file type labeled                                               */J /*  set file collision update                                           */J /*  server                                                              */J /*                                                                      */J /* LOCAL                                                                */J /*  define xsend rexx call xsend.cmd '\%1 \%2'                          */J /*  set file type labeled                                               */J /*  xsend <path> <filespec>                                             */J /*  finish                                                              */J /*                                                                      */J /* CAUTION: The above procedure is not recommended for sending from an  */J /* HPFS volume to a FAT volume.  Any other combination is OK.           */J /*                                                                      */J /* You can also XSEND from OS/2 to DOS or UNIX, but you should use      */J /* BINARY rather than LABELED mode.  When sending to UNIX in this way,  */J /* the resulting text files will still be in OS/2 format (CRLF rather   */J /* than LF line terminators).  You should only XSEND to DOS from a      */J /* FAT volume.                                                          */J /*                                                                      */J /* Homework:  Modify this program for sending directory trees to VMS.   */J /* Hints: "mkdir" -> "create/dir", "cd .." -> "cd [-]", etc.            */J /*                                                                      */9 call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'  call SysLoadFuncs    PARSE ARG path filespec   $ IF path = "" | filespec = "" THEN DO     SAY "XSEND <path> <filespec>"
    RETURN  END   I SAY "Sending all files" filespec "in directory tree" path "to the Server"    call XSEND path, filespec  RETURN   XSEND: PROCEDURE   path = ARG(1)  filespec = ARG(2)    startdir = DIRECTORY( path )    ' call SysFileTree filespec, 'file', 'FO'  do i=1 to file.0    'send' FILESPEC('name',file.i)   end   ! call SysFileTree '*', 'dir', 'DO'  do i=1 to dir.0 $   directory = FILESPEC('name',dir.i)   'remote host mkdir' directory    'remote cd'         directory     call XSEND directory, filespec   'remote cd ..'   end    call DIRECTORY startdir  RETURN  