3 char *ckxv = "Atari ST tty I/O, 5A(087), 9 Dec 93";    /*  C K S T I O  */   G /* C-Kermit interrupt, terminal control & i/o functions for Atari ST */    /*H  Author: Frank da Cruz (fdc@cunixc.cc.columbia.edu, FDCCU@CUVMA.BITNET),O  Columbia University Center for Computing Activities.  Many other contributors.   First released January 1985. M  Copyright (C) 1985, 1992, Trustees of Columbia University in the City of New O  York.  Permission is granted to any individual or institution to use, copy, or O  redistribute this software so long as it is not sold for profit, provided this   copyright notice is retained.)  Extensive modifications for Atari ST by: +  Bruce Moore (mooreb@iccgcc.decnet.ab.com).  */  ? /* Includes for all Unixes (conditional includes come later) */   / #include "ckcdeb.h"			/* This moved to here. */ 6 #include "ckcnet.h"			/* Symbols for network types. */  / #include <errno.h>			/* System error numbers */ ' #include <osbind.h>			/* OS bindings */ ' #include <xbios.h>			/* Xtended BIOS */ . #include <time.h>			/* time_t typedef, etc. *// #include <signal.h>			/* Signals for cc trap */ ! #define _auxis() (!! Bconstat(1))   #define _auxos() (!! Bcostat(1)) #define _auxin() Bconin(1) #define _auxout(x) Bconout(1,x)   ! #define _conis() (!! Bconstat(2))   #define _conos() (!! Bcostat(2))# #define _necin() (Bconin(2) & 0x7f)  #define _conout(x) Bconout(2,x)   1 /* Maximum length for the name of a tty device */    #ifndef DEVNAMLEN  #define DEVNAMLEN 25 #endif  * #include "ckuver.h"			/* Version herald */ char *ckxsys = HERALD;   /*&  Variables available to outside world:  A    dftty  -- Pointer to default tty name string, like "/dev/tty". 7    dfloc  -- 0 if dftty is console, 1 if external line.     dfprty -- Default parity !    dfflow -- Default flow control 0    ckxech -- Flag for who echoes console typein:0      1 - The program (system echo is turned off)0      0 - The system (or front end, or terminal).E    functions that want to do their own echoing should check this flag     before doing so.   ;    *flfnam  -- Name of lock file, including its path, e.g., A                 "/usr/spool/uucp/LCK..cul0" or "/etc/locks/tty77" =    *lkflfn  -- Name of link to lock file, including its paths ?    *haslock -- Flag set if this kermit established a uucp lock. D    backgrd -- Flag indicating program executing in background ( & onK                 end of shell command). Used to ignore INT and QUIT signals. O    *rtu_bug -- Set by stptrap().  RTU treats ^Z as EOF (but only when we handle                  SIGTSTP)  L  Functions for assigned communication line (either external or console tty):  E    sysinit()               -- System dependent program initialization @    *syscleanup()            -- System dependent program shutdownO    ttopen(ttname,local,mdmtyp,timo) -- Open the named tty for exclusive access. O    ttclos()                -- Close & reset the tty, releasing any access lock. E    *ttsspd(cps)             -- Set the transmission speed of the tty. P    *ttgspd()                -- Get (read) the the transmission speed of the tty.L    ttpkt(speed,flow,parity) -- Put the tty in packet mode and set the speed.C    ttvt(speed,flow)        -- Put the tty in virtual terminal mode. O                                 or in DIALING or CONNECTED modem control state. 9    ttres()                 -- Restore original tty modes. E    *ttscarr(carrier)        -- Set carrier control mode, on/off/auto. ;    ttinl(dest,max,timo)    -- Timed read line from the tty. <    ttinc(timo)             -- Timed read character from tty.J    ttchk()                 -- See how many characters in tty input buffer.D    *ttxin(n,buf)            -- Read n characters from tty (untimed).8    ttol(string,length)     -- Write a string to the tty.;    ttoc(c)                 -- Write a character to the tty. 5    ttflui()                -- Flush tty input buffer. 0    ttsndb()                -- Send BREAK signal.5    ttsndlb()               -- Send Long BREAK signal. H    ttlock(ttname)          -- "Lock" tty device against uucp collisions.0    ttunlck()               -- Unlock tty device. */   /* Functions for console terminal:   +    congm()   -- Get console terminal modes. N    concb(esc) -- Put the console in single-character wakeup mode with no echo.7    conbin(esc) -- Put the console in binary (raw) mode. @    conres()  -- Restore the console to mode obtained by congm().<    conoc(c)  -- Unbuffered output, one character to console.I    conol(s)  -- Unbuffered output, null-terminated string to the console. C    conola(s) -- Unbuffered output, array of strings to the console. @    conxo(n,s) -- Unbuffered output, n characters to the console.C    conchk()  -- Check if characters available at console (bsd 4.2). J                 Check if escape char (^\) typed at console (System III/V).;    coninc(timo)  -- Timed get a character from the console. 1    congks(timo)  -- Timed get keyboard scan code. L    conint()  -- Enable terminal interrupts on the console if not background.M    connoi()  -- Disable terminal interrupts on the console if not background.    Time functions  =    msleep(m) -- Millisecond sleep (already defined by MWC!!!) 2    ztime(&s) -- Return pointer to date/time string    rtimer() --  Reset timer <    gtimer()  -- Get elapsed time since last call to rtimer() */   /* Declarations */  6 time_t time();				/* All Unixes should have this... */  2 extern char *malloc(), *getenv();	/* and these. */E extern int errno;                       /* System call error code. */ ' long ttgspd();				/* Declared below. */   F /* dftty is the device name of the default device for file transfer */O /* dfloc is 0 if dftty is the user's console terminal, 1 if an external line */   C int dfloc = 1;                  /* Default local(0) or remote(1) */ : char *dftty = CTTNAM;		/* Remote by default, use normal */7 char *dfmdm = "con:";		/* controlling terminal name. */   1 int dfprty = 0;			/* Default parity (0 = none) */ & int ttprty = 0;			/* Parity in use. */6 static int ttpmsk = 0377;	/* Parity stripping mask. */$ int ttmdm = 0;			/* Modem in use. */3 int ttcarr = CAR_AUT;		/* Carrier handling mode. */ - int dfflow = 1;			/* Xon/Xoff flow control */ 6 int backgrd = 0;		/* Assume in foreground (no '&' ) */1 int fdflag = 0;			/* Flag for redirected stdio */ 6 int tvtflg = 0;			/* Flag that ttvt has been called */* long ttspeed = -1;		/* For saving speed */' int ttflow = -9;		/* For saving flow */ & int ttld = -1;			/* Line discipline */   extern int ttnproto; extern int ttnet;   L int ckxech = 0; /* 0 if system normally echoes console characters, else 1 */  9 /* Declarations of variables global within this module */   2 static time_t tcount;			/* Elapsed time counter */  & static char				/* A string of nulls */A *brnuls = "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0";   + /* static */				/* (Not static any more) */ , int ttyfd = -1;				/* TTY file descriptor */  9 static SIGTYP (*cc_handler) ();		/* Our Ctrl-C handler */ 2 static SIGTYP (*oldint) ();		/* And the old one */  < static int lkf = 0,                     /* Line lock flag */K     cgmf = 0,                           /* Flag that console modes saved */ J     xlocal = 0,                         /* Flag for tty local or remote */6     curcarr = 0;			/* Carrier mode: require/ignore. */  3 static int netconn = 0;			/* 1 if network socket */ F static char escchr;                     /* Escape or attn character *// static char pushchar = 0;		/* Push character */   6 int haslock = 0;			/* =1 if this kermit locked uucp */M static int conesc = 0;                  /* set to 1 if esc char (^\) typed */   ) _PROTOTYP( static int ttlock, (char *) ); ( _PROTOTYP( static int ttunlck, (void) ); #ifdef CK_ANSIC 
 static char *  xxlast(char *s, char c)  #else 
 static char *  xxlast(s,c) char *s; char c; #endif /* CK_ANSIC */ B /* xxlast */ {		/*  Last occurrence of character c in string s. */
     int i;#     for (i = strlen(s); i > 0; i--) 1         if ( s[i-1] == c ) return( s + (i - 1) );      return(NULL);  }   J static char ttnmsv[DEVNAMLEN];          /* copy of open path for tthang */  C /*  S Y S I N I T  --  System-dependent program initialization.  */    int  sysinit() {      return(0); }   B /*  S Y S C L E A N U P  --  System-dependent program cleanup.  */   int  syscleanup() {     return(0); }   9 /*  T T O P E N  --  Open a tty for exclusive access.  */    /*   Call with:@     ttname: character string - device name or network host name.     lcl:7   If called with lcl < 0, sets value of lcl as follows: D   0: the terminal named by ttname is the job's controlling terminal.H   1: the terminal named by ttname is not the job's controlling terminal.F   But watch out: if a line is already open, or if requested line can't6   be opened, then lcl remains (and is returned as) -1.
     modem:0   Less than zero: ttname is a network host name.8   Zero or greater: ttname is a terminal device name.    :   Zero means a local connection (don't use modem signals).%   Positive means use modem signals.       timo:   0 = no timer. M   nonzero = number of seconds to wait for open() to return before timing out.   
   Returns:     0 on success    -5 if device is in use #    -4 if access to device is denied (    -3 if access to lock directory denied-    -2 upon timeout waiting for device to open     -1 on other error */D ttopen(ttname,lcl,modem,timo) char *ttname; int *lcl, modem, timo; {  G     if (ttyfd > -1) return(0);		/* If already open, ignore this call */ ;     ttmdm = modem;			/* Make this available to other fns */ ;     xlocal = *lcl;			/* Make this available to other fns */   &     if (strcmp(ttname, "aux:") == 0) { 	if (xlocal < 0) {9 	    if (isatty(0))	/* If con: is controlling terminal */ 8 		xlocal = 1;	/* ttname(aux) not controlling terminal */	 	    else 7 		xlocal = 0;	/* ttname(aux) is controlling terminal */  	}
     } else2 	return(-1);		/* aux: is the only legal device! */  8 /* Got the line, now set the desired value for local. */  !     if (*lcl != 0) *lcl = xlocal;      ttyfd = 1;  K     /* Done, make entries in debug log, restore Ctrl-C trap, and return. */ )     debug(F101,"ttopen, ttyfd","",ttyfd);      debug(F101," lcl","",*lcl);      return(0); }   ; /*  T T C L O S  --  Close the TTY, releasing any lock.  */    int ? ttclos(foo) int foo; {			/* Arg req'd for signal() prototype */ (     debug(F101,"ttclos ttyfd","",ttyfd);:     if (ttyfd < 0) return(0);           /* Wasn't open. */     tvtflg = 0;        if (xlocal) { / 	debug(F100,"ttclos about to call ttres","",0); > 	ttres();                            /* Reset device modes. */
 	tthang();     } M     ttyfd = -1;                         /* Invalidate the file descriptor. */   #     debug(F100,"ttclos done","",0);      return(0); }   A /*  T T H A N G  --  Hangup phone line or network connection.  */  /*
   Returns:   0 if it does nothing. 0   1 if it believes that it hung up successfully.2  -1 if it believes that the hangup attempt failed. */   int 
 tthang() {     /* Maybe later... */     return (0);  }   9 /*  T T R E S  --  Restore terminal to "normal" mode.  */   H /* ske@pkmab.se: There are two choices for what this function should do.G  * (1) Restore the tty to current "normal" mode, with carrier treatment J  * according to ttcarr, to be used after every kermit command. (2) RestoreH  * the tty to the state it was in before kermit opened it. These choicesL  * conflict, since ttold can't hold both choices of tty parameters.  ttres()H  * is currently being called as in choice (1), but ttold basically holdsJ  * the initial parameters, as in (2), and the description at the beginning  * of this file says (2).   *I  * I don't think restoring tty parameters after all kermit commands makes H  * much of a difference.  Restoring them upon exit from kermit may be ofI  * some use in some cases (when the line is not restored automatically on #  * close, by the operating system).   *E  * I can't choose which one it should be, so I haven't changed it. It F  * probably works as it is, too. It would probably even work even with  * ttres() entirely deleted...  *E  * (from fdc: Actually, this function operates in remote mode too, so E  * it restores the console (command) terminal to whatever mode it was I  * in before packet operations began, so that commands work right again.)   */ H ttres() {                               /* Restore the tty to normal. */7     if (ttyfd < 0) return(-1);          /* Not open. */      return(0); }   C /*  T T P K T  --  Condition the communication line for packets. */ ' /*              or for modem dialing */   I #define DIALING 4               /* flags (via flow) for modem handling */  #define CONNECT 5   6 /*  If called with speed > -1, also set the speed.  */  , /*  Returns 0 on success, -1 on failure.  */  8 ttpkt(speed,flow,parity) long speed; int flow, parity; {     int s2;      int s = 0;  7     if (ttyfd < 0) return(-1);          /* Not open. */   %     debug(F101,"ttpkt flow","",flow); -     debug(F101,"ttpkt speed","",(int) speed); %     debug(F101,"ttpkt flow","",flow);   :     if (tvtflg == 0 && speed == ttspeed && flow == ttflow)' 	return(0);			/* Already been called */   O     ttprty = parity;                    /* Let other tt functions see these. */ >     ttpmsk = ttprty ? 0177 : 0377;	/* Parity stripping mask */     ttspeed = speed;7     ttflow = flow;			/* Now make this available too. */        if (xlocal) { 3 	s2 = (int) (speed / 10L);	/* Convert bps to cps */ 0 	s = ttsspd(s2);			/* Check and set the speed */% 	debug(F101,"ttpkt carrier","",flow); 
     } else 	s = 0;   6     tvtflg = 0;				/* So ttvt() will work next time */     return(s); }   K /*  T T V T -- Condition communication line for use as virtual terminal  */   ( ttvt(speed,flow) long speed; int flow; {     int s, s2;  &     debug(F101,"ttvt ttyfd","",ttyfd);(     debug(F101,"ttvt tvtflg","",tvtflg);7     if (ttyfd < 0) return(-1);          /* Not open. */   O     if (tvtflg != 0 && speed == ttspeed && flow == ttflow && ttcarr == curcarr) -       return(0);			/* Already been called. */   /     if (xlocal) {			/* For external lines... */  	s2 = (int) (speed / 10L);, 	s = ttsspd(s2);			/* Check/set the speed */
     } else 	s = 0;   7     ttspeed = speed;			/* Done, remember how we were */ :     ttflow = flow;			/* called, so we can decide how to */0     ttcarr = curcarr;			/* respond next time. */     tvtflg = 0;   &     debug(F101,"ttvt done","",tvtflg);     return(s); }   ; /*  T T S S P D  --  Checks and sets transmission rate.  */   < /*  Call with speed in characters (not bits!) per second. */? /*  Returns internal speed code if successful, -1 otherwise. */    int  ttsspd(cps) int cps; {
     int s;        debug(F101,"ttsspd","",cps);     s = -1;   4     /* First check that the given speed is valid. */  &     switch (cps >= 0 ? cps : (-cps)) {6     case 5:	s = 15;	break;	/* Just the common ones. */     case 11:	s = 13;	break;      case 15:	s = 11;	break;      case 30:	s = 9;	break;     case 60:	s = 8;	break;     case 120:	s = 7;	break;      case 180:	s = 6;	break;      case 240:	s = 4;	break;      case 480:	s = 2;	break;      case 960:	s = 1;	break;      case 1920:	s = 0;	break;     default: 	return(-1);     }   #     if ((long) cps * 10 == ttspeed)  	return(s);        if (cps >= 0) { 8 	Rsconf(s, !!ttflow, -1,-1,-1,-1);	/* Set speed, flow */ 	ttspeed = (long) cps * 10;      }        return(s); }   ? /* T T G S P D  -  Get speed of currently selected tty line  */    long) ttgspd() {				/* Get current tty speed */      char *s;       if (ttspeed == -1) {2 	if ((s = getenv("SPEED")) || (s=getenv("BAUD")) ) 	    ttspeed = (long) atoi(s);     }      return(ttspeed); }   . /*  T T F L U I  --  Flush tty input buffer */   int 
 ttflui() {     while (_auxis()) 	(void) _auxin();      return(0); }    /* Interrupt Functions */   1 /*  C O N I N T  --  Console Interrupt setter  */    /*L   First arg is pointer to function to handle SIGTERM & SIGINT (like Ctrl-C).@   Second arg is pointer to function to handle SIGTSTP (suspend). */  , VOID					/* Set terminal interrupt traps. */ #ifdef CK_ANSIC * conint(SIGTYP (*f)(int), SIGTYP (*s)(int)) #else " conint(f,s) SIGTYP (*f)(), (*s)(); #endif /* CK_ANSIC */  /* conint */ { 	cc_handler = f;A         oldint = signal(SIGINT,f);	/* Catch terminal interrupt */  }   9 /*  C O N N O I  --  Reset console terminal interrupts */    VOIDC connoi() {                              /* Console-no-interrupts */  	cc_handler = NULL; D         signal(SIGINT,oldint);		/* Restore old terminal interrupt */ }   0 /*  G E N B R K  --  Simulate a modem break.  */   #define BSPEED 5 VOID genbrk(fn,msec) int fn, msec; {      int oldspeed; 
     int x, y;   %     oldspeed = (int) (ttgspd() / 10); "     ttsspd(15);					/* 150 baud */       y = strlen(brnuls);       x = ( BSPEED * 100 ) / msec;     if (x > y) x = y; F     ttol(brnuls, (( BSPEED * 100 ) / msec ));	/* A plethora of nuls */  '     msleep(100);				/* Sleep 100 ms. */ 0     ttsspd(oldspeed);				/* restore old speed */     return(0); }   O /*  T T C H K  --  Tell how many characters are waiting in tty input buffer  */   H /*  Some callers of this want to know whether there is something to readL  *  either in the system buffers or in our private buffers (and mostly don'tM  *  care how many characters, just whether it's more than zero or not), while H  *  some others would be better off with the number of characters in our  *  private buffers only.   *M  *  Some systems can say how many characters there are in the system buffers. K  *  Others can not. For those that can't, the number in the private buffers K  *  will have to do (or should we put the tty into O_NDELAY-mode and try to I  *  read one character?). If the system can tell whether there is zero or M  *  more than zero characters, we can return 1 in the latter case even if the @  *  private buffer is empty. (That is good for sliding windows.)  */  int 	 ttchk() {      return(_auxis());  }   = /*  T T X I N  --  Get n characters from tty input buffer  */   F /*  Returns number of characters actually gotten, or -1 on failure  */  L /*  Intended for use only when it is known that n characters are actually */& /*  Available in the input buffer.  */   int   ttxin(n,buf) int n; CHAR *buf; {     CHAR *p;  I     ttpmsk = (ttprty) ? 0177 : 0377;         /* Parity stripping mask. */      debug(F101,"ttxin n","",n);   $     for (p = buf; _auxis() && n--; ) 	*p++ = _auxin() & ttpmsk;       *p = '\0';     return((int) (p - buf)); }   G /*  T T O L  --  Write string s, length n, to communication device.  */  /*
   Returns::    >= 0 on success, number of characters actually written.    -1 on failure.  */ int  ttol(s,n) int n; char *s; { 
     int i;       for(i = n; i--; )  	_auxout(*s++);      return(n); }   A /*  T T O C  --  Output a character to the communication line  */    /*N  This function should only be used for interactive, character-mode operations,K  like terminal connection, script execution, dialer i/o, where the overhead 8  of the signals and alarms does not create a bottleneck. */ int  #ifdef CK_ANSIC  ttoc(char c) #else  ttoc(c) char c;  #endif /* CK_ANSIC */  /* ttoc */ {     c &= 0xff;A     if (ttyfd < 0) return(-1);          /* Check for not open. */      _auxout(c);      return(0); }   L /*  T T I N L  --  Read a record (up to break character) from comm line.  */ /*K   Reads up to "max" characters from the communication line, terminating on:    B     (a) the packet length field if the "turn" argument is zero, orK     (b) on the packet-end character (eol) if the "turn" argument is nonzero   I   and returns the number of characters read upon success, or if "max" was I   exceeded or the timeout interval expired before (a) or (b), returns -1.   N   The characters that were input are copied into "dest" with their parity bitsJ   stripped if parity was selected.  Returns the number of characters read.M   Characters after the eol are available upon the next call to this function.   L   The idea is to minimize the number of system calls per packet, and also toM   minimize timeouts.  This function is the inner loop of the program and must H   be as efficient as possible.  The current strategy is to use myread().  L   WARNING: this function calls parchk(), which is defined in another module.M   Normally, ckutio.c does not depend on code from any other module, but there J   is an exception in this case because all the other ck?tio.c modules alsoM   need to call parchk(), so it's better to have it defined in a common place.  */ #ifdef CTRLC #undef CTRLC #endif /* CTRLC */ #define CTRLC '\03'  /*3   We have four different declarations here because: N   (a) to allow Kermit to be built without the automatic parity sensing feature4   (b) one of each type for ANSI C, one for non-ANSI. */   int  #ifdef PARSENSE  #ifdef CK_ANSIC C ttinl(CHAR *dest, int max,int timo, CHAR eol, CHAR start, int turn)  #else N ttinl(dest,max,timo,eol,start,turn) int max,timo,turn; CHAR *dest, eol, start; #endif /* CK_ANSIC */  #else /* not PARSENSE */ #ifdef CK_ANSIC - ttinl(CHAR *dest, int max,int timo, CHAR eol)  #else 7 ttinl(dest,max,timo,eol) int max,timo; CHAR *dest, eol;  #endif /* __SDTC__ */  #endif /* PARSENSE */ 
 /* ttinl */ {   '     time_t tfinal;			/* Time to quit */ +     int count;				/* Number rec'd so far */ %     int c;				/* Current character */ '     int ccn;				/* Control-C counter */   7     if (ttyfd < 0) return(-1);          /* Not open. */   #     debug(F101,"ttinl max","",max); %     debug(F101,"ttinl timo","",timo);   '     ccn = 0;				/* Control-C counter */ A     ttpmsk = (ttprty) ? 0177 : 0377;	/* Parity stripping mask. */ F     *dest = '\0';                       /* Clear destination buffer */)     if (timo < 0) timo = 0;		/* Safety */        tfinal = time(NULL) + timo; +     for (count = 0; count < max; count++) { 1 	while (timo && ! _auxis()) {	/* Timed read... */ G 	    if (_conis() && (pushchar = coninc(0)) == CTRLC) {	/* ^C on con?*/ * 		if (cc_handler) {		/* Handler active? *// 		    pushchar = 0;		/* Flush push character */ 1 		    (* cc_handler) (SIGINT);	/* Call handler */  		}  	    }7 	    if (time(NULL) > tfinal) {	/* If read times out */ " 		debug(F100,"ttinl timout","",0);# 		debug(F111," with", dest, count);  		return(-1);		/* Time out */  	    } 	} 	c = _auxin(); #ifdef COMMENT3 /* Not needed, since we're always in local mode. */  	if ((c & 0x7f) == CTRLC) {  	    if (++ccn > 1) { 1 		fprintf(stderr, "^C...\r\n");	/* Echo Ctrl-C */ 
 		return(-2);  	    }, 	} else				/* Not ^C, so reset ^C counter */
 	    ccn = 0;  #endif /* COMMENT */ 	if ((c & 0x7f) == eol) { ( 	    debug(F101,"ttinl got eol","",eol);4 	    *dest = '\0';		/* Yes, terminate the string, */ 	    break;  	} 	*dest++ = c & ttpmsk;     }      return(count); }   B /*  T T I N C --  Read a character from the communication line  */ /*7  On success, returns the character that was read, >= 0. <  On failure, returns -1 or other negative myread error code. */ int  ttinc(timo) int timo; {      time_t tfinal;
     int m;  7     if (ttyfd < 0) return(-1);          /* Not open. */   A     ttpmsk = (ttprty) ? 0177 : 0377;	/* Parity stripping mask. */ )     if (timo < 0) timo = 0;		/* Safety */      tfinal = time(NULL) + timo;   4     while (timo && ! _auxis()) {	/* Timed read... */C 	if (_conis() && (pushchar = coninc(0)) == CTRLC) {	/* ^C on con?*/ . 	    if (cc_handler) {			/* Handler active? */, 		pushchar = 0;			/* Flush push character */- 		(* cc_handler) (SIGINT);	/* Call handler */  	    } 	} 	if (time(NULL) > tfinal)  	    return(-1);     }      return(_auxin() & ttpmsk); }   B /*  S N D B R K  --  Send a BREAK signal of the given duration  */  
 static int #ifdef CK_ANSIC 1 sndbrk(int msec)			/* Argument is milliseconds */  #else  sndbrk(msec) int msec; #endif /* CK_ANSIC */  /* sndbrk */ {     genbrk(ttyfd, msec); }   , /*  T T S N D B  --  Send a BREAK signal  */   int 
 ttsndb() {     return(sndbrk(275)); }   3 /*  T T S N D L B  --  Send a Long BREAK signal  */    int  ttsndlb() {      return(sndbrk(1500));  }   8 /*  M S L E E P  --  Millisecond version of sleep().  */   /*E   Call with number of milliseconds (thousandths of seconds) to sleep. E   Intended only for small intervals.  For big ones, just use sleep().    Highly system-dependent.+   Returns 0 always, even if it didn't work. ?   The problem is that MWC\msleep takes a long.  Kludge, kludge!  */  
 #ifdef GEMDOS 
 #ifdef msleep 
 #undef msleep  #else	/* msleep */. #error Must add -Dmsleep=mnap on command line! #endif	/* msleep */  int  mnap(m) int m; {.     msleep((long) m);			/* Use MWC function */ }  #else	/* GEMDOS */ int  msleep(m) int m; {     clock_t elapsed;     clock_t done;   +     done = clock() + (clock_t) m / CLK_TCK; /     while ((elapsed = clock() - done) < 0x7FFF)  	; }  #endif	/* GEMDOS */   2 /*  R T I M E R --  Reset elapsed time counter  */   VOID
 rtimer() {"     tcount = time( (time_t *) 0 ); }     L /*  G T I M E R --  Get current value of elapsed time counter in seconds  */   int 
 gtimer() {
     int x;.     x = (int) (time( (time_t *) 0 ) - tcount);     debug(F101,"gtimer","",x);     return( (x < 0) ? 0 : x ); }     . /*  Z T I M E  --  Return date/time string  */   VOID ztime(s) char **s; {     char *ctime();     time_t clock_storage;   )     clock_storage = time( (time_t *) 0 ); !     *s = ctime( &clock_storage );  }   2 /*  C O N G M  --  Get console terminal modes.  */   /*E   Saves initial console mode, and establishes variables for switching ;   between current (presumably normal) mode and other modes. C   Should be called when program starts, but only after establishing 5   whether program is in the foreground or background. E   Returns 1 if it got the modes OK, 0 if it did nothing, -1 on error.  */ int 	 congm() {      return(0); }     1 /*  C O N C B --  Put console in cbreak mode.  */   " /*  Returns 0 if ok, -1 if not  */   int  #ifdef CK_ANSIC  concb(char esc)  #else  concb(esc) char esc; #endif /* CK_ANSIC */ 
 /* concb */ { @     if (!isatty(0)) return(0);          /* only for real ttys */N     escchr = esc;                       /* Make this available to other fns */I     ckxech = 1;                         /* Program can echo characters */      return(0); }   3 /*  C O N B I N  --  Put console in binary mode  */   " /*  Returns 0 if ok, -1 if not  */   int  #ifdef CK_ANSIC  conbin(char esc) #else  conbin(esc) char esc;  #endif /* CK_ANSIC */  /* conbin */  { @     if (!isatty(0)) return(0);          /* only for real ttys */     debug(F100,"conbin","",0);N     escchr = esc;                       /* Make this available to other fns */I     ckxech = 1;                         /* Program can echo characters */      return(0); }     5 /*  C O N R E S  --  Restore the console terminal  */    int 
 conres() {'     debug(F100,"entering conres","",0); @     if (!isatty(0)) return(0);          /* only for real ttys */(     debug(F100,"conres isatty ok","",0);F     ckxech = 0;                         /* System should echo chars */     return(0); }   A /*  C O N O C  --  Output a character to the console terminal  */    int  #ifdef CK_ANSIC 
 conoc(char c)  #else  conoc(c) char c; #endif /* CK_ANSIC */ 
 /* conoc */ {      putchar(c);      fflush(stdout);  }   A /*  C O N X O  --  Write x characters to the console terminal  */    int  conxo(x,s) char *s; int x; {     while (x--)  	putchar(*s++);      fflush(stdout);  }   ; /*  C O N O L  --  Write a line to the console terminal  */    int  conol(s) char *s; {      fputs(s, stdout);      fflush(stdout);  }   G /*  C O N O L A  --  Write an array of lines to the console terminal */    int  conola(s) char *s[]; {
     int i;(     for (i=0 ; *s[i] ; i++) conol(s[i]); }   9 /*  C O N O L L  --  Output a string followed by CRLF  */    int  conoll(s) char *s; {     fputs(s, stdout);      fputs("\r\n", stdout); }   H /*  C O N C H K  --  Return how many characters available at console  */   int 
 conchk() {@     if (xlocal)			/* If this Kermit is running on a local box */: 	return(_conis());	/* Return chars available at console */2     else			/* This Kermit running on remote box */9 	return(_auxis());	/* Otherwise return chars available */  }   9 /*  C O N I N C  --  Get a character from the console  */    int  coninc(timo) int timo; {     time_t tfinal;     CHAR ch;       if (timo < 0) timo = 0;      tfinal = time(NULL) + timo;   :     if (pushchar) {			/* Do we have a pushed character? */+ 	ch = pushchar & 0377;		/* If so, use it */ $ 	pushchar = 0;			/* But only once */A     } else if (xlocal) {		/* If Kermit is running on local box */ % 	if (timo) {			/* If timed read... */ 7 	    while (! _conis()) {		/* While no console chars */ 1 		if (time(NULL) > tfinal)	/* If time is up... */ ( 		    return(-1);		/* tell our caller */ 	    } 	} 	ch = _necin() & 0377;6     } else {			/* This Kermit running on remote box */% 	if (timo) {			/* If timed read... */ 7 	    while (! _auxis()) {		/* While no console chars */ 1 		if (time(NULL) > tfinal)	/* If time is up... */ ( 		    return(-1);		/* tell our caller */ 	    } 	} 	ch = _auxin() & 0377;     } #     if (ch == CTRLC) {			/* ^C ? */ ( 	if (cc_handler)			/* Handler active? */0 	    (* cc_handler) (SIGINT);	/* Call handler */     }      return(ch);  }   6 /*  C O N G K S  --  Console Get Keyboard Scancode  */   #ifndef congks /*G   This function needs to be filled in with the various system-dependent I   system calls used by SUNOS, NeXT OS, Xenix, Aviion, etc, to read a full -   keyboard scan code.  For now, it's a dummy.  */ int  congks(timo) int timo; {     return(coninc(timo));  }  #endif /* congks */   I /*  T T S C A R R  --  Set ttcarr variable, controlling carrier handling.   *I  *  0 = Off: Always ignore carrier. E.g. you can connect without carrier. O  *  1 = On: Heed carrier, except during dialing. Carrier loss gives disconnect. 4  *  2 = Auto: For "modem direct": The same as "Off".K  *            For real modem types: Heed carrier during connect, but ignore M  *                it anytime else.  Compatible with pre-5A C-Kermit versions.   *M  * As you can see, this setting does not affect dialing, which always ignores L  * carrier (unless there is some special exception for some modem type).  ItK  * does affect ttopen() if it is set before ttopen() is used.  This setting J  * takes effect on the next call to ttopen()/ttpkt()/ttvt().  And they areI  * (or should be) always called before any communications is tried, which =  * means that, practically speaking, the effect is immediate.   *B  * Of course, nothing of this applies to remote mode (xlocal = 0).  *F  * Someone has yet to uncover how to manipulate the carrier in the BSDL  * environment (or any non-termio using environment).  Until that time, this"  * will simply be a no-op for BSD.  *L  * Note that in previous versions, the carrier was most often left unchangedK  * in ttpkt()/ttvt() unless they were called with DIALING or CONNECT.  This I  * has changed.  Now it is controlled by ttcarr in conjunction with these 	  * modes.   */  int  ttscarr(carrier) int carrier; {      ttcarr = carrier; %     debug(F101, "ttscarr","",ttcarr);      return(ttcarr);  }   * /*  T T G M D M  --  Get modem signals  */ /*H  Looks for RS-232 modem signals, and returns those that are on in as itsO  return value, in a bit mask composed of the BM_xxx values defined in ckcdeb.h. 
  Returns:   -3 Not implemented I  -2 if the communication device does not have modem control (e.g. telnet) 
  -1 on error. K  >= 0 on success, with a bit mask containing the modem signals that are on.  */   int 
 ttgmdm() {     return(-3);  }   @ /*  P S U S P E N D  --  Put this process in the background.  */   /*G   Call with flag nonzero if suspending is allowed, zero if not allowed. A   Returns 0 on apparent success, -1 on failure (flag was zero, or     kill() returned an error code. */ int  psuspend(flag) int flag; {       return(-1);  } 