> char *ckxv = "UNIX Communications support, 5A(160), 4 Oct 94";   /*  C K U T I O  */   K /* C-Kermit interrupt, communications control and I/O functions for UNIX */    /*L   NOTE TO CONTRIBUTORS: This file, and all the other C-Kermit files, must beJ   compatible with C preprocessors that support only #ifdef, #else, #endif,J   #define, and #undef.  Please do not use #if, logical operators, or otherJ   preprocessor features in any of the portable C-Kermit modules.  You can,I   of course, use these constructions in system-specific modules when they    are supported. */   /*?   Author: Frank da Cruz (fdc@columbia.edu, FDCCU@CUVMA.BITNET), B   Columbia University Academic Information Systems, New York City.  N   Copyright (C) 1985, 1994, Trustees of Columbia University in the City of NewK   York.  The C-Kermit software may not be, in whole or in part, licensed or L   sold for profit as a software product itself, nor may it be included in orM   distributed with commercial products or otherwise distributed by commercial J   concerns to their clients or customers without written permission of theK   Office of Kermit Development and Distribution, Columbia University.  This =   copyright notice must not be removed, altered, or obscured.  */   /* Includes */   #include "ckcsym.h" , #include "ckcdeb.h"			/* This goes first! *// #include <errno.h>			/* System error numbers */    #ifdef __386BSD__  #define ENOTCONN 57  #else  #ifdef __bsdi__  #define ENOTCONN 57  #else  #ifdef __FreeBSD__ #define ENOTCONN 57  #endif /* __FreeBSD__ */ #endif /* __bsdi__ */  #endif /* __386BSD__ */   6 #include "ckcnet.h"			/* Symbols for network types. */  O #ifdef XENIX /* Was M_UNIX but XENIX implies M_UNIX and applies to XENIX too */  /*B   <sys/socket.h> included above via "ckcnet.h" defines FIONREAD asF   something.  Due to this, in_chk() uses the FIONREAD instead of RDCHKE   and the hot keys during file transfer (X to cancel file etc) do not %   work because FIONREAD doesn't work.   *   NOTE: This might also be true elsewhere. */ #ifdef FIONREAD  #undef FIONREAD  #endif /* FIONREAD */  #endif /* XENIX */   /*F   The directory-related includes are here because we need to test someK   file-system-related symbols to find out which system we're being compiled B   under.  For example, MAXNAMLEN is defined in BSD4.2 but not 4.1. */) #ifdef SDIRENT				/* Directory bits... */  #define DIRENT #endif /* SDIRENT */   #ifdef XNDIR #include <sys/ndir.h>  #else /* !XNDIR */ #ifdef NDIR  #include <ndir.h>  #else /* !NDIR, !XNDIR */ 
 #ifdef RTU #include "/usr/lib/ndir.h" #else /* !RTU, !NDIR, !XNDIR */ 
 #ifdef DIRENT  #ifdef SDIRENT #include <sys/dirent.h>  #else  #include <dirent.h>  #endif /* SDIRENT */9 #else /* !RTU, !NDIR, !XNDIR, !DIRENT, i.e. all others */  #include <sys/dir.h> #endif /* DIRENT */  #endif /* RTU */ #endif /* NDIR */  #endif /* XNDIR */  ( /* Definition of HZ, used in msleep() */   #ifdef MIPS   #define HZ ( 1000 / CLOCK_TICK ) #else  #ifdef ATTSV #ifndef NAP 
 #ifndef TRS16  #include <sys/param.h> #else   #define HZ ( 1000 / CLOCK_TICK ) #endif /* TRS16 */ #ifdef NAPHACK' #define nap(x) (void)syscall(3112, (x))  #define NAP  #endif /* NAPHACK */ #endif /* NAP */ #endif /* ATTSV */ #endif /* MIPS */   
 #ifdef M_UNIX > #undef NGROUPS_MAX		/* Prevent multiple definition warnings */ #endif /* M_UNIX */   
 #ifdef SELECT  #ifdef COHERENT B #include <sys/select.h>		/* Needed for -DSELECT in the makefile */ #endif /* COHERENT */ 
 #ifdef QNX #include <sys/select.h>  #endif /* QNX */ #endif /* SELECT */    /*C   NOTE: HP-UX 8.0 has a <sys/poll.h>, but there is no corresponding <   library routine, so _poll comes up undefined at link time. */ #ifdef CK_POLL4 #ifndef AIXRS			/* IBM AIX needs special handling */@ #include <poll.h>		/* "standard" (SVID) i/o multiplexing, etc */ #else /* AIXRS */ + #ifdef SVR4			/* AIX 3.2 is like SVID... */  #include <poll.h> % #else				/* But AIX 3.1 is not ... */ ? #include <sys/poll.h>		/* The include file is in include/sys */ F #define events reqevents	/* And it does not map IBM-specific member */A #define revents rtnevents	/* names to the System V equivalents */  #endif /* SVR4 */  #endif /* AIXRS */ #endif /* CK_POLL */  5 #include <signal.h>                     /* Signals */    /* For setjmp and longjmp */  
 #ifndef ZILOG  #include <setjmp.h>  #else  #include <setret.h>  #endif /* ZILOG */  1 /* Maximum length for the name of a tty device */    #ifndef DEVNAMLEN  #define DEVNAMLEN 25 #endif /* DEVNAMLEN */   #ifdef	NETCONN #undef DEVNAMLEN: #define DEVNAMLEN 50			/* longer field for host:service */ #endif  /* NETCONN */    /*D   The following test differentiates between 4.1 BSD and 4.2 & later.F   If you have a 4.1BSD system with the DIRENT library, this test couldJ   mistakenly diagnose 4.2BSD and then later enable the use of system callsI   that aren't defined.  If indeed there are such systems, we can use some J   other way of testing for 4.1BSD, or add yet another compile-time switch. */   #ifdef BSD4  #ifdef MAXNAMLEN #ifndef FT21) #ifndef FT18				/* Except for Fortune. */ 
 #define BSD42  #endif /* FT18 */  #endif /* FT21 */  #endif /* MAXNAMLEN */ #endif /* BSD4 */  /*,  MINIX 1.0 support added by Charles Hedrick,1  Rutgers University <hedrick@aramis.rutgers.edu>.   MINIX also has V7 enabled.  */ #ifdef MINIX #define TANDEM 0 #define MYREAD #include <limits.h>  #endif /* MINIX */  E #ifdef CK_REDIR		/* <sys/wait.h> needed only for REDIRECT command. */  /*C   If anybody can figure out how to make this work with NeXTSTEP, be K   my guest!  (NeXTBlah/NeXTBlah/bsd/sys/wait.h does not define WEXITSTATUS)  */; #ifndef CK_WAIT_H			/* If wait.h not already included... */ ( #include <sys/wait.h>			/* Include it */ #endif /* CK_WAIT_H */ #endif /* CK_REDIR */   * #include "ckuver.h"			/* Version herald */ char *ckxsys = HERALD;  # /* UUCP lockfile name definition */    #ifndef NOUUCP  & /* Name of UUCP tty device lockfile */   #ifdef LINUXFSSTND #ifndef HDBUUCP  #define HDBUUCP  #endif /* HDBUUCP */ #endif /* LINUXFSSTND */   #ifdef ACUCNTRL  #define LCKDIR #endif /* ACUCNTRL */    /*@   PIDSTRING means use ASCII string to represent pid in lockfile. */ #ifndef PIDSTRING  #ifdef HDBUUCP #define PIDSTRING  #else  #ifdef BSD44 #define PIDSTRING  #else  #ifdef RTAIX #define PIDSTRING  #else  #ifdef AIXRS #define PIDSTRING  #else  #ifdef COHERENT  #define PIDSTRING  #endif /* COHERENT */  #endif /* AIXRS */ #endif /* RTAIX */ #endif /* BSD44 */ #endif /* HDBUUCP */ #endif /* PIDSTRING */  % /* Now the PIDSTRING exceptions... */   " #ifdef HPUX10				/* HP-UX 10.00 */ #ifdef PIDSTRING #undef PIDSTRING #endif /* PIDSTRING */ #endif /* HPUX10 */   1 #ifdef __bsdi__				/* BSDI (at least thru 1.1) */  #ifdef PIDSTRING #undef PIDSTRING #endif /* __bsdi__ */  #endif /* PIDSTRING */   /*1   LOCK_DIR is the name of the lockfile directory. L   If LOCK_DIR is already defined (e.g. on command line), we don't change it. */ #ifndef LOCK_DIR #ifdef BSD44 #ifdef __386BSD__ # #define LOCK_DIR "/var/spool/lock";  #else  #ifdef __FreeBSD__# #define LOCK_DIR "/var/spool/lock";  #else  #ifdef __NetBSD__ # #define LOCK_DIR "/var/spool/lock";  #else # #define LOCK_DIR "/var/spool/uucp";  #endif /* __NetBSD__ */  #endif /* __FreeBSD__ */ #endif /* __386BSD__ */  #else  #ifdef DGUX430$ #define LOCK_DIR "/var/spool/locks"; #else 
 #ifdef HPUX10 $ #define LOCK_DIR "/var/spool/locks"; #else ) #ifdef RTAIX				/* IBM RT PC AIX 2.2.1 */  #define LOCK_DIR "/etc/locks"; #else  #ifdef AIXRS #define LOCK_DIR "/etc/locks"; #else  #ifdef ISIII #define LOCK_DIR "/etc/locks"; #else  #ifdef HDBUUCP
 #ifdef M_SYS5 # #define LOCK_DIR "/usr/spool/uucp";  #else 
 #ifdef M_UNIX # #define LOCK_DIR "/usr/spool/uucp";  #else  #ifdef SVR4 $ #define LOCK_DIR "/var/spool/locks"; #else 
 #ifdef SUNOS4 $ #define LOCK_DIR "/var/spool/locks"; #else  #ifdef LINUXFSSTND #define LOCK_DIR "/var/lock";  #else $ #define LOCK_DIR "/usr/spool/locks"; #endif /* LINUXFSSTND */ #endif /* SUNOS4 */  #endif /* SVR4 */  #endif /* M_UNIX */  #endif /* M_SYS5 */  #else 
 #ifdef LCKDIR ' #define LOCK_DIR "/usr/spool/uucp/LCK";  #else  #ifdef COHERENT # #define LOCK_DIR "/usr/spool/uucp";  #else # #define LOCK_DIR "/usr/spool/uucp";  #endif /* COHERENT */  #endif /* LCKDIR */  #endif /* HDBUUCP */ #endif /* ISIII */ #endif /* AIXRS */ #endif /* RTAIX */ #endif /* HPUX10 */  #endif /* DGUX430 */ #endif /* BSD44 */' #endif /* !LOCK_DIR (outside ifndef) */      ' #ifdef OSF2				/* OSF/1 2.0 or later */ 6 #ifdef LOCK_DIR				/* (maybe 1.x too, who knows...) */ #undef LOCK_DIR $ #define LOCK_DIR "/var/spool/locks"; #endif /* LOCK_DIR */  #endif /* OSF2 */    #ifdef SVR4 
 #ifndef BSD44 
 #ifndef LOCKF 8 #define LOCKF				/* Use lockf() on tty device in SVR4 */ #endif /* LOCKF */ #endif /* BSD44 */ #endif /* SVR4 */   - #ifdef NOLOCKF				/* NOLOCKF cancels LOCKF */  #ifdef LOCKF #undef LOCKF #endif /* LOCKF */ #endif /* NOLOCKF */   #endif /* !NOUUCP */   #ifdef ATTSV #define MYREAD #endif /* ATTSV */   #ifdef ATT7300 #ifndef MYREAD #define MYREAD #endif /* MYREAD */ = /* bits for attmodem: internal modem in use, restart getty */  #define ISMODEM 1  #define DOGETY 512 #endif  /* ATT7300 */    #ifdef BSD42 #define MYREAD #endif /* BSD42 */   #ifdef POSIX #define MYREAD #endif /* POSIX */ #ifdef __bsdi__  #ifndef O_NDELAY #define O_NDELAY O_NONBLOCK  #endif /* O_NDELAY */  #endif /* __bsdi__ */    /*&  Variables available to outside world:  A    dftty  -- Pointer to default tty name string, like "/dev/tty". 7    dfloc  -- 0 if dftty is console, 1 if external line.     dfprty -- Default parity !    dfflow -- Default flow control 0    ckxech -- Flag for who echoes console typein:0      1 - The program (system echo is turned off)0      0 - The system (or front end, or terminal).E    functions that want to do their own echoing should check this flag     before doing so.   :    flfnam  -- Name of lock file, including its path, e.g.,A                 "/usr/spool/uucp/LCK..cul0" or "/etc/locks/tty77" <    lkflfn  -- Name of link to lock file, including its paths>    haslock -- Flag set if this kermit established a uucp lock.D    backgrd -- Flag indicating program executing in background ( & onK                 end of shell command). Used to ignore INT and QUIT signals. N    rtu_bug -- Set by stptrap().  RTU treats ^Z as EOF (but only when we handle                 SIGTSTP)  L  Functions for assigned communication line (either external or console tty):  E    sysinit()               -- System dependent program initialization ?    syscleanup()            -- System dependent program shutdown O    ttopen(ttname,local,mdmtyp,timo) -- Open the named tty for exclusive access. O    ttclos()                -- Close & reset the tty, releasing any access lock. D    ttsspd(cps)             -- Set the transmission speed of the tty.O    ttgspd()                -- Get (read) the the transmission speed of the tty. L    ttpkt(speed,flow,parity) -- Put the tty in packet mode and set the speed.C    ttvt(speed,flow)        -- Put the tty in virtual terminal mode. O                                 or in DIALING or CONNECTED modem control state. 9    ttres()                 -- Restore original tty modes. D    ttscarr(carrier)        -- Set carrier control mode, on/off/auto.;    ttinl(dest,max,timo)    -- Timed read line from the tty. <    ttinc(timo)             -- Timed read character from tty.I    myread()                -- Raw mode bulk buffer read, gives subsequent K                                 chars one at a time and simulates FIONREAD. K    myunrd(c)               -- Places c back in buffer to be read (one only) J    ttchk()                 -- See how many characters in tty input buffer.C    ttxin(n,buf)            -- Read n characters from tty (untimed). 8    ttol(string,length)     -- Write a string to the tty.;    ttoc(c)                 -- Write a character to the tty. 5    ttflui()                -- Flush tty input buffer. 0    ttsndb()                -- Send BREAK signal.5    ttsndlb()               -- Send Long BREAK signal.   H    ttlock(ttname)          -- "Lock" tty device against uucp collisions.0    ttunlck()               -- Unlock tty device.  <                               For ATT7300/Unix PC, System V:G    attdial(ttname,speed,telnbr) -- dials ATT7300/Unix PC internal modem @    offgetty(ttname)        -- Turns off getty(1m) for comms line<    ongetty(ttname)         -- Restores getty() to comms line */   /* Functions for console terminal:   +    congm()   -- Get console terminal modes. N    concb(esc) -- Put the console in single-character wakeup mode with no echo.7    conbin(esc) -- Put the console in binary (raw) mode. @    conres()  -- Restore the console to mode obtained by congm().<    conoc(c)  -- Unbuffered output, one character to console.I    conol(s)  -- Unbuffered output, null-terminated string to the console. C    conola(s) -- Unbuffered output, array of strings to the console. @    conxo(n,s) -- Unbuffered output, n characters to the console.C    conchk()  -- Check if characters available at console (bsd 4.2). J                 Check if escape char (^\) typed at console (System III/V).;    coninc(timo)  -- Timed get a character from the console. 1    congks(timo)  -- Timed get keyboard scan code. L    conint()  -- Enable terminal interrupts on the console if not background.M    connoi()  -- Disable terminal interrupts on the console if not background.    Time functions  !    msleep(m) -- Millisecond sleep 2    ztime(&s) -- Return pointer to date/time string    rtimer() --  Reset timer <    gtimer()  -- Get elapsed time since last call to rtimer() */   /* Conditional Includes */  % /* Whether to include <sys/file.h> */    #ifdef RTU				/* RTU doesn't */  #define NOFILEH  #endif /* RTU */   #ifdef CIE				/* CIE does. */  #undef NOFILEH #endif /* CIE */  % #ifdef BSD41				/* 4.1 BSD doesn't */  #define NOFILEH  #endif /* BSD41 */  / #ifdef is68k				/* is68k (whatever that is)  */  #define NOFILEH  #endif /* is68k */   #ifdef MINIX				/* MINIX */  #define NOFILEH  #endif /* MINIX */  ! #ifdef COHERENT				/* Coherent */  #define NOFILEH  #endif /* COHERENT */   1 #ifndef NOFILEH				/* Now include if selected. */  #include <sys/file.h>  #endif /* NOFILEH */   /* POSIX */   0 #ifdef BSD44ORPOSIX			/* POSIX uses termios.h */ #define TERMIOS  #ifdef __bsdi__  #ifdef POSIX; #undef _POSIX_SOURCE			/* Get extra stuff from termios.h */  #endif /* POSIX */ #endif /* __bsdi__ */  #include <termios.h> #ifdef __bsdi__  #ifdef POSIX #define _POSIX_SOURCE  #endif /* POSIX */ #endif /* __bsdi__ */ # #ifndef BSD44				/* Really POSIX */  #ifndef CK_QNX32/ #define NOSYSIOCTLH			/* No ioctl's allowed. */ 4 #undef ultrix				/* Turn off any ultrix features. */ #endif /* CK_QNX32 */  #endif /* BSD44 */ #endif /* POSIX */   /* System III, System V */   #ifdef ATTSV
 #ifndef BSD44 
 #ifndef POSIX  #include <termio.h>  #endif /* POSIX */ #endif /* BSD44 */, /* #ifdef SVR4 */			/* Sys V R4 and later */ #ifdef TERMIOXF /* Need this for termiox structure, RTS/CTS and DTR/CD flow control */ #include <termiox.h>   struct termiox rctsx;  #else  #ifdef STERMIOX  #include <sys/termiox.h>   struct termiox rctsx;  #endif /* STERMIOX */  #endif /* TERMIOX */ /* #endif */ /* SVR4 */  #endif /* ATTSV */  > #ifdef COHERENT			/* Use termio.h, not sgtty.h for Coherent */ #include <termio.h>  #endif /* COHERENT */   ( #ifdef MINIX				/* MINIX uses ioctl's */4 #define NOSYSIOCTLH			/* but has no <sys/ioctl.h> */ #endif /* MINIX */   /* Others */  . #ifndef NOSYSIOCTLH			/* Others use ioctl() */
 #ifdef SUN4S5  /*F   This is to get rid of cpp warning messages that occur because all ofE   these symbols are defined by both termios.h and ioctl.h on the SUN.  */ #undef ECHO 
 #undef NL0
 #undef NL1 #undef TAB0  #undef TAB1  #undef TAB2  #undef XTABS
 #undef CR0
 #undef CR1
 #undef CR2
 #undef CR3
 #undef FF0
 #undef FF1
 #undef BS0
 #undef BS1
 #undef TOSTOP 
 #undef FLUSHO 
 #undef PENDIN 
 #undef NOFLSH  #endif /* SUN4S5 */  #include <sys/ioctl.h> #endif /* NOSYSIOCTLH */  " /* Whether to include <fcntl.h> */  6 #ifndef is68k				/* Only a few don't have this one. */
 #ifndef BSD41  #ifndef FT21 #ifndef FT18 #ifndef COHERENT #include <fcntl.h> #endif /* COHERENT */  #endif /* FT18 */  #endif /* FT21 */  #endif /* BSD41 */ #endif /* not is68k */   #ifdef COHERENT  #ifdef _I386 #include <fcntl.h> #else  #include <sys/fcntl.h> #endif /* _I386 */ #endif /* COHERENT */   6 #ifdef ATT7300				/* Unix PC, internal modem dialer */ #include <sys/phone.h> #endif /* ATT7300 */  & #ifdef HPUX				/* HP-UX variations. */ #define HPUXJOBCTL2 #include <sys/modem.h>			/* HP-UX modem signals */# #ifdef hp9000s500			/* Model 500 */  #undef HPUXJOBCTL  #endif /* hp9000s500 */  #ifdef HPUXPRE65 #undef HPUXJOBCTL  typedef long mflag;  #endif /* HPUXPRE65 */ #ifdef HPUXJOBCTL : #include <sys/bsdtty.h>			/* HP-UX Berkeley tty support */ #endif /* HPUXJOBCTL */  #endif /* HPUX */   & /* BSD, V7, Coherent, Minix, et al. */  ' #ifdef SVORPOSIX			/* Sys V or POSIX */ " #ifdef OXOS				/* Olivetti X/OS */ #include <sys/time.h>  #else  #ifdef BSD44				/* 4.4BSD */ #include <sys/time.h>  #else  #ifdef __linux__			/* Linux */2 /* Kludge to fix redefinition in <linux/wait.h> */ #undef WNOHANG #undef WUNTRACED #include <linux/fs.h>  #include <linux/tty.h> #include <sys/time.h>  #ifdef LINUXHISPEED  #include <linux/serial.h>  #endif /* LINUXHISPEED */  #else  #ifdef AIXRS				/* IBM AIX */  #include <sys/time.h>  #endif /* AIXRS */ #endif /* __linux__ */ #endif /* BSD44 */ #endif /* OXOS */   7 #ifdef NOIEXTEN				/* This is broken on some systems */ ) #undef IEXTEN				/* like Convex/OS 9.1 */  #endif /* NOIEXTEN */ 2 #ifndef IEXTEN				/* Turn off ^O/^V processing. */3 #define IEXTEN 0			/* Needed, at least, on BSDI. */  #endif /* IEXTEN */   $ #else  /* Not AT&T Sys V or POSIX */  A #include <sgtty.h>                      /* So we use <sgtty.h> */ , #ifndef PROVX1				/* Now <sys/time.h> ... */
 #ifndef V7
 #ifndef BSD41  #ifndef COHERENTO #include <sys/time.h>                   /* Clock info (for break generation) */  #endif /* COHERENT */  #endif /* BSD41 */ #endif /* V7 */  #endif /* PROVX1 */  #endif /* SVORPOSIX */   #ifdef PS2AIX10 I #include <sys/time.h>                   /* Clock info for PS/2 AIX 1.x */  #endif /* PS2AIX10 */   ! #ifdef OSF				/* DEC OSF/1 1.0 */  #include <sys/timeb.h> #endif /* OSF */   #ifdef BSD41				/* BSD 4.1 */  #include <sys/timeb.h> #endif /* BSD41 */    #ifdef FT21				/* For:Pro 2.1 */ #include <sys/timeb.h> #endif /* FT21 */    #ifdef BSD29				/* BSD 2.9 */  #include <sys/timeb.h> #endif /* BSD29 */  
 #ifdef TOWER1 F #include <sys/timeb.h>                  /* Clock info for NCR Tower */ #endif /* TOWER1 */    #ifdef COHERENT F #include <sys/timeb.h>                  /* Clock info for NCR Tower */ #endif /* COHERENT */    #ifdef aegis #include "/sys/ins/base.ins.c" #include "/sys/ins/error.ins.c"  #include "/sys/ins/ios.ins.c"  #include "/sys/ins/sio.ins.c"  #include "/sys/ins/pad.ins.c"  #include "/sys/ins/time.ins.c" #include "/sys/ins/pfm.ins.c"  #include "/sys/ins/pgm.ins.c"  #include "/sys/ins/ec2.ins.c" # #include "/sys/ins/type_uids.ins.c"  #include <default_acl.h> #undef TIOCEXCL  #undef FIONREAD  #endif /* aegis */  6 #ifdef sxaE50				/* PFU Compact A SX/A TISP V10/L50 */ #undef FIONREAD  #endif /* sxaE50 */   = /* The following #defines are catch-alls for those systems */ 3 /* that didn't have or couldn't find <file.h>... */   
 #ifndef FREAD  #define FREAD 0x01 #endif /* FREAD */   #ifndef FWRITE #define FWRITE 0x10  #endif /* FWRITE */    #ifndef O_RDONLY #define O_RDONLY 000 #endif /* O_RDONLY */    /* Declarations */   #ifdef OXOS 
 #undef TCGETA 
 #undef TCSETA  #undef TCSETAW #undef TCSETAF #define TCGETA TCGETS  #define TCSETA TCSETS  #define TCSETAW TCSETSW  #define TCSETAF TCSETSF  #define termio termios #endif /* OXOS */    #ifdef HPUX  #include <time.h>  #else 0 #ifdef _POSIX_SOURCE			/* This includes MINIX */
 #ifndef AIXRS  #include <time.h>  #endif /* AIXRS */ #ifdef __GNUC__  #ifdef XENIX /*C   Because Xenix <time.h> doesn't declare time() if we're using gcc.  */ time_t time(); #endif /* XENIX */ #endif /* __GNUC__ */  #else 6 time_t time();				/* All Unixes should have this... */ #endif /* _POSIX_SOURCE */ #endif /* HPUX */ / /* Special stuff for V7 input buffer peeking */   
 #ifdef  V7 int kmem[2] = { -1, -1};" char *initrawq(), *qaddr[2]={0,0};
 #define CON 0 
 #define TTY 1  #endif /* V7 */   F /* dftty is the device name of the default device for file transfer */O /* dfloc is 0 if dftty is the user's console terminal, 1 if an external line */   
 #ifndef DFTTY 
 #ifdef PROVX1 I     char *dftty = "/dev/com1.dout"; /* Only example so far of a system */      char *dfmdm = "none"; L     int dfloc = 1;                  /* that goes in local mode by default */ #else K     char *dftty = CTTNAM;               /* Remote by default, use normal */      char *dfmdm = "none"; H     int dfloc = 0;                      /* controlling terminal name. */ #endif /* PROVX1 */  #else =     char *dftty = DFTTY;		/* Default location specified on */ .     char *dfmdm = "none";		/* command line. */H     int dfloc = 1;                      /* controlling terminal name. */ #endif /* DFTTY */  
 #ifdef RTUD     int rtu_bug = 0;		    /* set to 1 when returning from SIGTSTP */ #endif /* RTU */  G     int dfprty = DEFPAR;                /* Default parity (0 = none) */ H     int ttprty = 0;                     /* The parity that is in use. */2     int ttpflg = 0;			/* Parity not sensed yet. */;     static int ttpmsk = 0377;		/* Parity stripping mask. */ ;     int ttmdm = 0;                      /* Modem in use. */ 7     int ttcarr = CAR_AUT;		/* Carrier handling mode. */ 5     int dfflow = FLO_XONX;		/* Default is Xon/Xoff */ L     int backgrd = 0;                    /* Assume in foreground (no '&' ) */
 #ifdef ultrix 3     int iniflags = 0;			/* fcntl flags for ttyfd */  #endif /* ultrix */ 5     int fdflag = 0;			/* Flag for redirected stdio */ ;     int ttfdflg = 0;			/* Open File descriptor was given */ :     int tvtflg = 0;			/* Flag that ttvt has been called */0     long ttspeed = -1L;			/* For saving speed */,     int ttflow = -9;			/* For saving flow */*     int ttld = -1;			/* Line discipline */   #ifdef sony_news=     static int km_con = -1;		/* Kanji mode for console tty */ A     static int km_ext = -1;		/* Kanji mode for external device */  #endif /* sony_news */   /*E   Having this module rely on external globals is bad, but fixing this K   requires overhaul of the ck*tio.c modules for all the different operating <   systems supported by C-Kermit.  Left for a future release. */0 extern int ttnproto;			/* Defined in ckcnet.c */- extern int ttnet;			/* Defined in ckcnet.c */ < extern int xfrcan, xfrchr, xfrnum;	/* Defined in ckcmai.c */ extern int suspend;   L int ckxech = 0; /* 0 if system normally echoes console characters, else 1 */  9 /* Declarations of variables global within this module */   2 static time_t tcount;			/* Elapsed time counter */A static SIGTYP (*saval)() = NULL;	/* For saving alarm() handler */  #ifndef NOJCD static SIGTYP (*jchdlr)() = NULL;	/* For checking suspend handler */ #endif /* NOJC */ 3 static int jcshell = -1;		/* And flag for result */    /*G   BREAKNULS is defined for systems that simulate sending a BREAK signal 4   by sending a bunch of NUL characters at low speed. */
 #ifdef PROVX1  #ifndef BREAKNULS  #define BREAKNULS  #endif /* BREAKNULS */ #endif /* PROVX1 */   	 #ifdef V7  #ifndef BREAKNULS  #define BREAKNULS  #endif /* BREAKNULS */ #endif /* V7 */    #ifdef BREAKNULS& static char				/* A string of nulls */A *brnuls = "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0";  #endif /* BREAKNULS */  - #ifdef CK_POSIX_SIG				/* Longjump buffers */ 5 static sigjmp_buf sjbuf;		/* POSIX signal handling */  #else  static jmp_buf sjbuf;  #endif /* CK_POSIX_SIG */   	 #ifdef V7  static jmp_buf jjbuf;  #endif /* V7 */   + /* static */				/* (Not static any more) */ , int ttyfd = -1;				/* TTY file descriptor */  7 int telnetfd = 0;			/* File descriptor is for telnet */ 3 int x25fd = 0;				/* File descriptor is for X.25 */   < static int lkf = 0,                     /* Line lock flag */K     cgmf = 0,                           /* Flag that console modes saved */ J     xlocal = 0,                         /* Flag for tty local or remote */6     curcarr = 0;			/* Carrier mode: require/ignore. */  > static int netconn = 0;			/* 1 if network connection active */  F static char escchr;                     /* Escape or attn character */   #ifdef COHERENT 
 #ifdef SELECT D     static struct timeval tv;		/* Needed for -DSELECT in makefile */ #endif /* SELECT */  #endif /* COHERENT */   
 #ifdef QNXF     static struct timeval tv;		/* For getting time, from sys/time.h */     static struct timezone tz; #else  #ifdef SOLARISF     static struct timeval tv;		/* For getting time, from sys/time.h */     static struct timezone tz; #else  #ifdef HPUX F     static struct timeval tv;		/* For getting time, from sys/time.h */     static struct timezone tz; #else  #ifdef __linux__F     static struct timeval tv;		/* For getting time, from sys/time.h */     static struct timezone tz; #else  #ifdef PS2AIX10 F     static struct timeval tv;		/* For getting time, from sys/time.h */     static struct timezone tz; #else  #ifdef AIXRSF     static struct timeval tv;		/* For getting time, from sys/time.h */     static struct timezone tz; #else  #ifdef BSD44F     static struct timeval tv;		/* For getting time, from sys/time.h */     static struct timezone tz; #else  #ifdef BSD42F     static struct timeval tv;		/* For getting time, from sys/time.h */     static struct timezone tz;
 #ifdef OSFB     static struct timeb ftp;            /* And from sys/timeb.h */ #endif /* OSF */ #else  #ifdef OXOS F     static struct timeval tv;		/* For getting time, from sys/time.h */     static struct timezone tz; #endif /* OXOS */  #endif /* BSD42 */ #endif /* BSD44 */ #endif /* AIXRS */ #endif /* PS2AIX10 */  #endif /* __linux__ */ #endif /* HPUX */  #endif /* SOLARIS */ #endif /* QNX */   #ifdef BSD29O     static long xclock;                  /* For getting time from sys/time.h */ B     static struct timeb ftp;            /* And from sys/timeb.h */ #endif /* BSD29 */   #ifdef BSD41O     static long xclock;                  /* For getting time from sys/time.h */ B     static struct timeb ftp;            /* And from sys/timeb.h */ #endif /* BSD41 */   #ifdef FT21 O     static long xclock;                  /* For getting time from sys/time.h */ B     static struct timeb ftp;            /* And from sys/timeb.h */ #endif /* FT21 */   
 #ifdef TOWER1 @     static long xclock;			/* For getting time from sys/time.h */8     static struct timeb ftp;		/* And from sys/timeb.h */ #endif /* TOWER1 */    #ifdef COHERENT @     static long xclock;			/* For getting time from sys/time.h */8     static struct timeb ftp;		/* And from sys/timeb.h */ #endif /* COHERENT */   	 #ifdef V7      static long xclock;  #endif /* V7 */   ! /* sgtty/termio information... */   * #ifdef BSD44ORPOSIX			/* POSIX or BSD44 */   static struct termios      ttold, ttraw, tttvt, ttcur,      ccold, ccraw, cccbrk;  #else					/* BSD, V7, etc */  & #ifdef COHERENT				/* Hack alert... */
 #define ATTSV  #endif /* COHERENT */    #ifdef ATTSVD   static struct termio ttold = {0}; /* Init'd for word alignment, */E   static struct termio ttraw = {0}; /* which is important for some */ @   static struct termio tttvt = {0}; /* systems, like Zilog... */#   static struct termio ttcur = {0}; #   static struct termio ccold = {0}; #   static struct termio ccraw = {0}; $   static struct termio cccbrk = {0}; #else ;   static struct sgttyb                  /* sgtty info... */ =     ttold, ttraw, tttvt, ttcur, 	/* for communication line */ 0     ccold, ccraw, cccbrk;		/* and for console */ #ifdef TIOCGETC  #ifdef MINIX:   static struct sgttyb tchold, tchnoi;	/* Special chars */ #else &   static struct tchars tchold, tchnoi; #endif /* MINIX */   static int tcharf; #endif /* TIOCGETC */  #ifdef TIOCGLTC  #ifdef MINIX(   static struct sgttyb ltchold, ltchnoi; #else )   static struct ltchars ltchold, ltchnoi;  #endif /* MINIX */   static int ltcharf;  #endif /* TIOCGLTC */ %   int lmodef = 0;			/* Local modes */    int lmode = 0; #endif /* ATTSV */ #endif /* BSD44ORPOSIX */   
 #ifdef PROVX1    static struct sgttyb ttbuf;  #endif /* PROVX1 */   
 #ifdef ultrix  /* do we really need this? */    static struct sgttyb vanilla;  #endif /* ultrix */    #ifdef ATT7300K static int attmodem = 0;                /* ATT7300 internal-modem status */ A struct updata dialer = {0};		/* Condition dialer for data call */  #endif /* ATT7300 */   #ifndef NOUUCP1 char flfnam[80];			/* UUCP lock file path name */ 
 #ifdef HPUX10 0 char lock2[80];				/* Name of second lockfile */ #endif /* HPUX10 */  #else  char flfnam[8];  #endif /* NOUUCP */    #ifdef RTAIX0 char lkflfn[80];			/* and possible link to it */ #endif /* RTAIX */6 int haslock = 0;			/* =1 if this kermit locked uucp */   #ifndef OXOS #ifdef SVORPOSIXM static int conesc = 0;                  /* set to 1 if esc char (^\) typed */  #else 	 #ifdef V7  static int conesc = 0; #else 
 #ifdef C70 static int conesc = 0; #endif /* C70 */ #endif /* V7 */  #endif /* SVORPOSIX */ #endif /* OXOS */   B static char ttnmsv[DEVNAMLEN];		/* Copy of open path for tthang */   #ifdef aegisG static status_$t st;                    /* error status return value */ H static short concrp = 0;                /* true if console is CRP pad */ #define CONBUFSIZ 10F static char conbuf[CONBUFSIZ];          /* console readahead buffer */I static int  conbufn = 0;                /* # chars in readahead buffer */ K static char *conbufp;                   /* next char in readahead buffer */ : static uid_$t ttyuid;                   /* tty type uid */= static uid_$t conuid;                   /* stdout type uid */    /* APOLLO Aegis main()+  * establish acl usage and cleanup handling #  *    this makes sure that CRP pads #  *    get restored to a usable mode   */ ( main(argc,argv) int argc; char **argv; {         status_$t status;          pfm_$cleanup_rec dirty;            PID_T pid = getpid();   9         /* acl usage according to invoking environment */           default_acl(USE_DEFENV);  .         /* establish a cleanup continuation */%         status = pfm_$cleanup(dirty); -         if (status.all != pfm_$cleanup_set) { A                 /* only handle faults for the original process */ H                 if (pid == getpid() && status.all > pgm_$max_severity) {# 		    /* blew up in main process */  		    status_$t quo; 		    pfm_$cleanup_rec clean;   + 		    /* restore the console in any case */  		    conres();     		    /* attempt a clean exit */: 		    debug(F101, "cleanup fault status", "", status.all);  6 		    /* doexit(), then send status to continuation */  		    quo = pfm_$cleanup(clean);& 		    if (quo.all == pfm_$cleanup_set)( 		      doexit(pgm_$program_faulted,-1);+ 		    else if (quo.all > pgm_$max_severity) 3 		      pfm_$signal(quo); /* blew up in doexit() */                  } 7                 /* send to the original continuation */ $                 pfm_$signal(status);                 /*NOTREACHED*/ 	    }#         return(ckcmai(argc, argv));  }  #endif /* aegis */  3 /* ANSI-style prototypes for internal functions. */ D /* Functions used outside this module are prototyped in ckcker.h. */  
 #ifdef apollo  _PROTOTYP( SIGTYP timerh, () );  _PROTOTYP( SIGTYP cctrap, () );  _PROTOTYP( SIGTYP esctrp, () );   _PROTOTYP( SIGTYP sig_ign, () ); #else " _PROTOTYP( SIGTYP timerh, (int) );" _PROTOTYP( SIGTYP cctrap, (int) );" _PROTOTYP( SIGTYP esctrp, (int) ); #endif /* apollo */ # _PROTOTYP( int do_open, (char *) ); & _PROTOTYP( static int in_chk, (int) );) _PROTOTYP( static int ttrpid, (char *) ); ) _PROTOTYP( static int ttlock, (char *) ); ( _PROTOTYP( static int ttunlck, (void) );" _PROTOTYP( int mygetbuf, (void) );# _PROTOTYP( int myfillbuf, (void) );   _PROTOTYP( VOID conbgt, (int) ); #ifdef ACUCNTRL - _PROTOTYP( VOID acucntrl, (char *, char *) );  #endif /* ACUCNTRL */    #ifdef BSD44ORPOSIX 2 _PROTOTYP( int carrctl, (struct termios *, int) ); #else  #ifdef ATTSV1 _PROTOTYP( int carrctl, (struct termio *, int) );  #else 1 _PROTOTYP( int carrctl, (struct sgttyb *, int) );  #endif /* ATTSV */ #endif /* BSD44ORPOSIX */    #ifdef ATT73001 _PROTOTYP( int attdial, (char *, long, char *) ); $ _PROTOTYP( int offgetty, (char *) );# _PROTOTYP( int ongetty, (char *) );  #endif /* ATT7300 */   #ifdef CK_ANSIC 
 static char *  xxlast(char *s, char c)  #else 
 static char *  xxlast(s,c) char *s; char c; #endif /* CK_ANSIC */ B /* xxlast */ {		/*  Last occurrence of character c in string s. */
     int i;(     for (i = (int)strlen(s); i > 0; i--)1         if ( s[i-1] == c ) return( s + (i - 1) );      return(NULL);  }   < /* Timeout handler for communication line input functions */   SIGTYP timerh(foo) int foo; {     ttimoff(); #ifdef CK_POSIX_SIG      siglongjmp(sjbuf,1); #else      longjmp(sjbuf,1);  #endif /* CK_POSIX_SIG */  }   ; /* Control-C trap for communication line input functions */    int cc_int;				/* Flag */ 8 SIGTYP (* occt)();			/* For saving old SIGINT handler */   SIGTYP3 cctrap(foo) int foo; {			/* Needs arg for ANSI C */ *   cc_int = 1;				/* signal() prototype. */	   return;  }   C /*  S Y S I N I T  --  System-dependent program initialization.  */    int  ttgwsiz() {      int x = -1;  #ifndef NONAWS      extern int tt_rows, tt_cols;  
 #ifdef QNX /*A   NOTE: TIOCGWSIZ works here too, but only in the 32-bit version. .   This works for both 16- and 32-bit versions. */5     extern int dev_size(int, int, int, int *, int *); 
     int r, c; 
     x = 0;+     if (dev_size(0, -1, -1, &r, &c) == 0) { " 	debug(F101,"ttgwsiz QNX r","",r);" 	debug(F101,"ttgwsiz QNX c","",c); 	if (r > 0 && c > 0) { 	    tt_rows = r;  	    tt_cols = c;  	    x = 1;  	}     } else x = -1; #else  #ifdef TIOCGWINSZ   K /* Note, this was M_UNIX, changed to XENIX to allow cross compilation... */ & #ifdef XENIX				/* SCO UNIX 3.2v4.0 */? #include <sys/stream.h>			/* typedef mblk_t needed by ptem.h */ + #include <sys/ptem.h>			/* for ttgwsiz() */  #endif /* XENIX */  , #ifdef I386IX				/* Ditto for Interactive */ #include <sys/stream.h>  #include <sys/ptem.h>  #endif /* I386IX */        struct winsize w; 4     if (ioctl(0, (int)TIOCGWINSZ, (char *)&w) < 0) { 	x = -1;.     } else if (w.ws_row > 0 && w.ws_col > 0) { 	tt_rows = w.ws_row; 	tt_cols = w.ws_col;* 	debug(F101,"ttgwsiz tt_rows","",tt_rows);* 	debug(F101,"ttgwsiz tt_cols","",tt_cols); 	x = 1;      } else x = 0;  #endif /* QNX */ #endif /* TIOCGWINSZ */  #endif /* NONAWS */      return(x); }    int  sysinit() { 
     int x; #ifdef aegis #ifdef CK_CURSES     char trmbuf[1024]; #endif /* CK_CURSES */ #endif /* aegis */   /*6   BEFORE ANYTHING ELSE: Initialize the setuid package..   Change to the user's real user and group ID.*   If this can't be done, don't run at all. */0     debug(F100,"sysinit calling priv_ini","",0);     if (x = priv_ini()) { 7 	if (x & 1) fprintf(stderr,"Fatal: setuid failure.\n"); 7 	if (x & 2) fprintf(stderr,"Fatal: setgid failure.\n"); @ 	if (x & 4) fprintf(stderr,"Fatal: C-Kermit setuid to root!\n");	 	exit(1);      }  #ifndef NOJC /*$   Get the initial job control state.F   If it is SIG_IGN, that means the shell does not support job control,+   and so we'd better not suspend ourselves.  */ #ifdef SIGTSTP%     jchdlr = signal(SIGTSTP,SIG_IGN);      if (jchdlr == SIG_IGN) {
 	jcshell = 0; , 	debug(F100,"sysinit jchdlr: SIG_IGN","",0);#     } else if (jchdlr == SIG_DFL) { , 	debug(F100,"sysinit jchdlr: SIG_DFL","",0);
 	jcshell = 1;      } else {* 	debug(F100,"sysinit jchdlr: other","",0);
 	jcshell = 3;      } 7     (VOID) signal(SIGTSTP,jchdlr);	/* Put it back... */  #endif /* SIGTSTP */ #endif /* NOJC */   6     conbgt(0);				/* See if we're in the background */   #ifdef aegis- #ifdef CK_CURSES			/* Apollo Aegis only... */ I     tgetent(trmbuf, getenv("TERM"));	/* Start vt100 emulator if needed */  #endif /* CK_CURSES */ #endif /* aegis */  '     congm();				/* Get console modes */   7     (VOID) signal(SIGALRM,SIG_IGN);	/* Ignore alarms */ - #ifndef SIGUSR1				/* User-defined signals */  #define SIGUSR1 30 #endif /* SIGUSR1 */   #ifndef SIGUSR2  #define SIGUSR2 31 #endif /* SIGUSR2 */  E     (VOID) signal(SIGUSR1,SIG_IGN);	/* Ignore user-defined signals */ *     (VOID) signal(SIGUSR2,SIG_IGN);	/*  */  . #ifdef SIGDANGER			/* Ignore danger signals */ /*F   This signal is sent when the system is low on swap space.  ProcessesM   that don't handle it are candidates for termination.  If swap space doesn't M   clear out enough, we still might be terminated via kill() -- nothing we can J   do about that!  Conceivably, this could be improved by installing a realK   signal handler that warns the user, but that would be pretty complicated, M   since we are not always in control of the screen -- e.g. during remote-mode    file transfer. */?     (VOID) signal(SIGDANGER,SIG_IGN);	/* e.g. on RS/6000 AIX */  #endif /* SIGDANGER */   #ifdef SIGPIPE /*B   This one comes when a TCP/IP connection is broken by the remote.J   We prefer to catch this situation by examining error codes from write(). */#     (VOID) signal(SIGPIPE,SIG_IGN);  #endif /* SIGPIPE */  
 #ifdef ultrix ,     gtty(0,&vanilla);			/* Get sgtty info */2     iniflags = fcntl(0,F_GETFL,0);	/* Get flags */ #else 
 #ifdef AUX:     set42sig();				/* Don't ask! (hakanson@cs.orst.edu) */ #endif /* AUX */ #endif /* ultrix */   7     ttgwsiz();				/* Get window (screen) dimensions. */        return(0); }   B /*  S Y S C L E A N U P  --  System-dependent program cleanup.  */   int  syscleanup() {
 #ifdef ultrix <     stty(0,&vanilla);                   /* Get sgtty info */3     fcntl(0,F_SETFL,iniflags);		/* Restore flags */  #endif /* ultrix */ C     /* No need to call anything in the suid package here, right? */      return(0); }   9 /*  T T O P E N  --  Open a tty for exclusive access.  */    /*   Call with:@     ttname: character string - device name or network host name.     lcl:7   If called with lcl < 0, sets value of lcl as follows: D   0: the terminal named by ttname is the job's controlling terminal.H   1: the terminal named by ttname is not the job's controlling terminal.F   But watch out: if a line is already open, or if requested line can't6   be opened, then lcl remains (and is returned as) -1.
     modem:0   Less than zero: ttname is a network host name.8   Zero or greater: ttname is a terminal device name.    :   Zero means a local connection (don't use modem signals).%   Positive means use modem signals.       timo:   0 = no timer. M   nonzero = number of seconds to wait for open() to return before timing out.   
   Returns:     0 on success    -5 if device is in use #    -4 if access to device is denied (    -3 if access to lock directory denied-    -2 upon timeout waiting for device to open     -1 on other error */+ static int ttotmo = 0;			/* Timeout flag */ : /* Flag kept here to avoid being clobbered by longjmp.  */   int D ttopen(ttname,lcl,modem,timo) char *ttname; int *lcl, modem, timo; {   #ifdef BSD44 #define ctermid(x) strcpy(x,"")  #else  #ifdef SVORPOSIX #ifndef CIE :     extern char *ctermid();		/* Wish they all had this! */ #else					/* CIE Regulus */  #define ctermid(x) strcpy(x,"")  #endif /* CIE */ #endif /* SVORPOSIX */ #endif /* BSD44 */  
 #ifdef ultrix      int temp = 0;  #endif /* ultrix */   +     char *x;				/* Worker string pointer */   
 #ifndef MINIX      extern char* ttyname();  #endif /* MINIX */     char cname[DEVNAMLEN+4];  
 #ifndef pdp11 I #define NAMEFD	 /* Feature to allow name to be an open file descriptor */  #endif /* pdp11 */  
 #ifdef NAMEFD      char *p;  .     debug(F101,"ttopen telnetfd","",telnetfd); #endif /* NAMEFD */   2     debug(F111,"ttopen entry modem",ttname,modem);"     debug(F101," ttyfd","",ttyfd);     debug(F101," lcl","",*lcl);    #ifdef MAXNAMLEN0     debug(F100,"ttopen MAXNAMLEN defined","",0); #else 6     debug(F100,"ttopen MAXNAMLEN *NOT* defined","",0); #endif   #ifdef BSD4 +     debug(F100,"ttopen BSD4 defined","",0);  #else 1     debug(F100,"ttopen BSD4 *NOT* defined","",0);  #endif   #ifdef BSD42,     debug(F100,"ttopen BSD42 defined","",0); #else 2     debug(F100,"ttopen BSD42 *NOT* defined","",0); #endif /* BSD42 */  
 #ifdef MYREAD -     debug(F100,"ttopen MYREAD defined","",0);  #else 3     debug(F100,"ttopen MYREAD *NOT* defined","",0);  #endif /* MYREAD */   6     if (ttyfd > -1) {			/* if device already opened */N         if (strncmp(ttname,ttnmsv,DEVNAMLEN)) /* are new & old names equal? */>           ttclos(ttyfd);		/* no, close old ttname, open new */3         else 				/* else same, ignore this call, */ ! 	  return(0);			/* and return. */      }    #ifdef	NETCONN=     if (modem < 0) {			/* modem < 0 = special code for net */  	int x;  	ttmdm = modem; 5 	modem = -modem;			/* Positive network type number */ * 	fdflag = 0;			/* Stdio not redirected. */3 	netconn = 1;			/* And it's a network connection */ ' 	debug(F111,"ttopen net",ttname,modem); 
 #ifdef NAMEFD @ 	for (p = ttname; isdigit(*p); p++) ; /* Check for all digits */F  	if (*p == '\0' && (telnetfd || x25fd)) { /* Avoid X.121 addresses */B 	    ttyfd = atoi(ttname);	/* Is there a way to test it's open? */7 	    ttfdflg = 1;		/* We got an open file descriptor */ ; 	    debug(F111,"ttopen got open network fd",ttname,ttyfd); A 	    strncpy(ttnmsv,ttname,DEVNAMLEN); /* Remember the "name". */ * 	    x = 1;			/* Return code is "good". */ 	    if (telnetfd) { 		ttnet = NET_TCPB;  		ttnproto = NP_TELNET; 
 #ifdef SUNX25  	    } else if (x25fd) { 		ttnet = NET_SX25;  		ttnproto = NP_NONE;  #endif /* SUNX25 */		  	    }, 	} else {			/* Host name or address given */ #endif /* NAMEFD */ : 	    x = netopen(ttname, lcl, modem); /* (see ckcnet.h) */ 	    if (x > -1) {# 		strncpy(ttnmsv,ttname,DEVNAMLEN);  	    } else netconn = 0;
 #ifdef NAMEFD  	} #endif /* NAMEFD */   " #ifdef sony_news			/* Sony NEWS */> 	if (ioctl(ttyfd,TIOCKGET,&km_ext) < 0) { /* Get Kanji mode */9 	    perror("ttopen error getting Kanji mode (network)"); ? 	    debug(F111,"ttopen error getting Kanji mode","network",0); 8 	    km_ext = -1;		/* Make sure this stays undefined. */ 	} #endif /* sony_news */  9 	xlocal = *lcl = 1;		/* Network connections are local. */ ! 	debug(F101,"ttopen net x","",x);  #ifdef COMMENT /* Let netopen() do this */  	if (x > -1 && !x25fd)3 	  x = tn_ini();			/* Initialize TELNET protocol */  #endif /* COMMENT */ 	return(x); %     } else {				/* Terminal device */  #endif	/* NETCONN */  
 #ifdef NAMEFD  /*E   This code lets you give Kermit an open file descriptor for a serial K   communication device, rather than a device name.  Kermit assumes that the K   line is already open, locked, conditioned with the right parameters, etc.  */@ 	for (p = ttname; isdigit(*p); p++) ; /* Check for all digits */ 	if (*p == '\0') {B 	    ttyfd = atoi(ttname);	/* Is there a way to test it's open? */3 	    debug(F111,"ttopen got open fd",ttname,ttyfd); A 	    strncpy(ttnmsv,ttname,DEVNAMLEN); /* Remember the "name". */ 1 	    xlocal = *lcl = 1;		/* Assume it's local. */ 3 	    netconn = 0;		/* Assume it's not a network. */ 8 	    tvtflg = 0;			/* Might need to initialize modes. *// 	    ttmdm = modem;		/* Remember modem type. */ . 	    fdflag = 0;			/* Stdio not redirected. */6 	    ttfdflg = 1;		/* Flag we were opened this way. */  " #ifdef sony_news			/* Sony NEWS */  	    /* Get device Kanji mode */- 	    if (ioctl(ttyfd,TIOCKGET,&km_ext) < 0) { , 		perror("ttopen error getting Kanji mode");5 		debug(F101,"ttopen error getting Kanji mode","",0); 5 		km_ext = -1;		/* Make sure this stays undefined. */  	    } #endif /* sony_news */& 	    return(0);			/* Return success */ 	} #endif /* NAMEFD */  #ifdef NETCONN     }  #endif /* NETCONN */  = /* Here we have to open a serial device of the given name. */   I     occt = signal(SIGINT, cctrap);	/* Set Control-C trap, save old one */   /     tvtflg = 0;			/* Flag for use by ttvt(). */ 1 				/* 0 = ttvt not called yet for this device */   H     fdflag = (!isatty(0) || !isatty(1)); /* Flag for stdio redirected */*     debug(F101,"ttopen fdflag","",fdflag);  N     ttmdm = modem;                      /* Make this available to other fns */N     xlocal = *lcl;                      /* Make this available to other fns */  : /* Code for handling bidirectional tty lines goes here. */H /* Use specified method for turning off logins and suppressing getty. */   #ifdef ACUCNTRL J     /* Should put call to priv_on() here, but that would be very risky! */A     acucntrl("disable",ttname);         /* acucntrl() program. */       /* and priv_off() here... */ #else  #ifdef ATT7300A     if ((attmodem & DOGETY) == 0)       /* offgetty() program. */ =       attmodem |= offgetty(ttname);	/* Remember response.  */  #endif /* ATT7300 */ #endif /* ACUCNTRL */    /*A  In the following section, we open the tty device for read/write. B  If a modem has been specified via "set modem" prior to "set line"F  then the O_NDELAY parameter is used in the open, provided this symbolH  is defined (e.g. in fcntl.h), so that the program does not hang waitingG  for carrier (which in most cases won't be present because a connection I  has not been dialed yet).  O_NDELAY is removed later on in ttopen().  It E  would make more sense to first determine if the line is local before F  doing this, but because ttyname() requires a file descriptor, we have"  to open it first.  See do_open().  <  Now open the device using the desired treatment of carrier.E  If carrier is REQUIRED, then open could hang forever, so an optional G  timer is provided.  If carrier is not required, the timer should never !  go off, and should do no harm...  */(     ttotmo = 0;				/* Flag no timeout */     if (timo > 0) {  	int xx;; 	saval = signal(SIGALRM,timerh);	/* Timed, set up timer. */ & 	xx = alarm(timo);		/* Timed open() */" 	debug(F101,"ttopen alarm","",xx); 	if (  #ifdef CK_POSIX_SIG  	    sigsetjmp(sjbuf,1)  #else  	    setjmp(sjbuf) #endif /* CK_POSIX_SIG */  	    ) {& 	    ttotmo = 1;			/* Flag timeout. */  	} else ttyfd = do_open(ttname); 	ttimoff(); $ 	debug(F111,"ttopen","modem",modem); 	debug(F101," ttyfd","",ttyfd); ' 	debug(F101," alarm return","",ttotmo); #     } else ttyfd = do_open(ttname); ,     debug(F111,"ttopen ttyfd",ttname,ttyfd);4     if (ttyfd < 0) {			/* If couldn't open, fail. */ #ifdef ATT7300? 	if (attmodem & DOGETY)		/* was getty(1m) running before us? */ 3 	  ongetty(ttnmsv);		/* yes, restart on tty line */ < 	attmodem &= ~DOGETY;		/* no phone in use, getty restored */ #else  #ifdef ACUCNTRL I         /* Should put call to priv_on() here, but that would be risky! */ 6 	acucntrl("enable",ttname);	/* acucntrl() program. */	 	/* and priv_off() here... */  #endif /* ACUNTRL */ #endif /* ATT7300 */  6 	signal(SIGINT,occt);		/* Put old Ctrl-C trap back. */? 	if (errno == EACCES) {		/* Device is protected against user */ ) 	    perror(ttname);		/* Print message */ 9 	    debug(F111,"ttopen tty access denied",ttname,errno);  	    return(-4);! 	} else return(ttotmo ? -2 : -1);      }   $     /* Make sure it's a real tty. */7     if (!isatty(ttyfd) && strcmp(ttname,"/dev/null")) { 8 	fprintf(stderr,"%s is not a terminal device\n",ttname);) 	debug(F110,"ttopen not a tty",ttname,0);  	close(ttyfd); 	ttyfd = -1; 	signal(SIGINT,occt);  	return(-1);     }    #ifdef aegisD 	/* Apollo C runtime claims that console pads are tty devices, whichC 	 * is reasonable, but they aren't any good for packet transfer. */ - 	ios_$inq_type_uid((short)ttyfd, ttyuid, st);  	if (st.all != status_$ok) {: 	    fprintf(stderr, "problem getting tty object type: "); 	    error_$print(st);< 	} else if (ttyuid != sio_$uid) { /* reject non-SIO lines */ 	    close(ttyfd); ttyfd = -1;$ 	    errno = ENOTTY; perror(ttname); 	    signal(SIGINT,occt);  	    return(-1); 	} #endif /* aegis */  I     strncpy(ttnmsv,ttname,DEVNAMLEN);   /*  Keep copy of name locally. */   > /* Caller wants us to figure out if line is controlling tty */       if (*lcl < 0) {  	int x0 = 0, x1 = 0;J         if (strcmp(ttname,CTTNAM) == 0) {   /* "/dev/tty" always remote */             xlocal = 0; 0 	    debug(F111," ttname=CTTNAM",ttname,xlocal);  J     /* If any of 0, 1, or 2 not redirected, we can use ttyname() to get */1     /* the name of the controlling terminal... */    /*L   Warning: on some UNIX systems (SVR4?), ttyname() reportedly opens /dev butD   never closes it.  If it is called often enough, we run out of fileI   descriptors and subsequent open()'s of other devices or files can fail.  */  G         } else if ((x0 = isatty(0)) || (x1 = isatty(1)) || isatty(2)) { 
 #ifndef MINIX  	    if (x0)5 	      x = ttyname(0);		/* and compare it with the */ ) 	    else if (x1)		/* tty device name. */  	      x = ttyname(1); 	    else x = ttyname(2); M             strncpy(cname,x,DEVNAMLEN); /* (copy from internal static buf) */  	    debug(F110," cname",x,0);F             x = ttyname(ttyfd);         /* Get real name of ttname. */
 	    if (x) {  		if (*x) { 9 		    xlocal = (strncmp(x,cname,DEVNAMLEN) == 0) ? 0 : 1; & 		    debug(F111," ttyname",x,xlocal); 		}  	    } else xlocal = 1;  #else 4 	    xlocal = 1;			/* Can't do this test in MINIX */ #endif /* MINIX */J         } else {                        /* Else, if stdin redirected... */ #ifdef SVORPOSIXN /* System V provides nice ctermid() function to get name of controlling tty */N             ctermid(cname);             /* Get name of controlling terminal */+             debug(F110," ctermid",cname,0);   M             x = ttyname(ttyfd);         /* Compare with name of comm line. */ ?             xlocal = (strncmp(x,cname,DEVNAMLEN) == 0) ? 0 : 1; ,             debug(F111," ttyname",x,xlocal); #else  /* Just assume local */              xlocal = 1;  #endif /* SVORPOSIX */6             debug(F101," redirected stdin","",xlocal);	         }      }    #ifndef NOFDZEROJ /* Note, the following code was added so that Unix "idle-line" snoopers */I /* would not think Kermit was idle when it was transferring files, and */  /* maybe log people out. */ *     if (xlocal == 0) {			/* Remote mode */9 	if (fdflag == 0) {		/* Standard i/o is not redirected */ 1 	    debug(F100,"ttopen setting ttyfd = 0","",0); 
 #ifdef LYNXOS 2 	    /* On Lynx OS, fd 0 is open for read only. */ 	    dup2(ttyfd,0);  #endif /* LYNXOS */ / 	    close(ttyfd);		/* Use file descriptor 0 */  	    ttyfd = 0; , 	} else {			/* Standard i/o is redirected */4 	    debug(F101,"ttopen stdio redirected","",ttyfd); 	}     }  #endif /* NOFDZERO */   H /* Now check if line is locked -- if so fail, else lock for ourselves */J /* Note: After having done this, don't forget to delete the lock if you */- /* leave ttopen() with an error condition. */   8     lkf = 0;                            /* Check lock */     if (xlocal > 0) {  	int xx; int xpid;=         if ((xx = ttlock(ttname)) < 0) { /* Can't lock it. */ 8             debug(F111,"ttopen ttlock fails",ttname,xx);G 	    /* WARNING - This close() can hang if tty is an empty socket... */ 2             close(ttyfd);		/* Close the device. */3 	    ttyfd = -1;			/* Erase its file descriptor. */ 4 	    signal(SIGINT,occt);	/* Put old SIGINT back. */; 	    if (xx == -2) {		/* If lockfile says device in use, */  #ifndef NOUUCP6 		debug(F111,"ttopen reading lockfile pid",flfnam,xx); 		priv_on();< 		xpid = ttrpid(flfnam);	/* Try to read pid from lockfile */) 		priv_off();		/* Turn privs back off. */ ( 		if (xpid > -1) {	/* If we got a pid */= 		    printf("Locked by process %d\n",xpid); /* tell them. */  		} else if (*flfnam) { = 		    char *p = malloc(280); /* Print a directory listing. */  /*H   Note: priv_on() won't help here, because we do not pass privs along toL   to inferior processes, in this case ls.  So if the real user does not haveI   directory-listing access to the lockfile directory, this will result in L   something like "not found".  That's why we try this only as a last resort. */, 		    if (p) {		/* If we got the space... */ 			extern char *DIRCMD; $ 			sprintf(p,"%s %s",DIRCMD,flfnam);! 			zsyscmd(p);	/* Get listing. */   			free(p);	/* free the space */ 		    }  		}  #endif /* NOUUCP */ + 		return(-5);		/* Code for device in use */ , 	    } else return(-3);		/* Access denied */         } else lkf = 1;      }   8 /* Got the line, now set the desired value for local. */  !     if (*lcl != 0) *lcl = xlocal;   " /* Some special stuff for v7... */  
 #ifdef  V7
 #ifndef MINIX :     if (kmem[TTY] < 0) {		/*  If open, then skip this.  */6 	qaddr[TTY] = initrawq(ttyfd);   /* Init the queue. */. 	if ((kmem[TTY] = open("/dev/kmem", 0)) < 0) {: 	    fprintf(stderr, "Can't read /dev/kmem in ttopen.\n"); 	    perror("/dev/kmem"); 
 	    exit(1);  	}     }  #endif /* !MINIX */  #endif /* V7 */   ) /* No failure returns after this point */   
 #ifdef ultrix #     ioctl(ttyfd, TIOCMODEM, &temp);  #ifdef TIOCSINUSE 7     if (xlocal && ioctl(ttyfd, TIOCSINUSE, NULL) < 0) { : 	fprintf(stderr, "Can't set in-use flag on %s.\n",ttname); 	perror("TIOCSINUSE");     }  #endif /* TIOCSINUSE */  #endif /* ultrix */    /* Get tty device settings */   ! #ifdef BSD44ORPOSIX			/* POSIX */      tcgetattr(ttyfd,&ttold);B     debug(F101,"ttopen tcgetattr ttold.c_lflag","",ttold.c_lflag);     tcgetattr(ttyfd,&ttraw);     tcgetattr(ttyfd,&tttvt);' #else					/* BSD, V7, and all others */  #ifdef ATTSV				/* AT&T UNIX */      ioctl(ttyfd,TCGETA,&ttold); E     debug(F101,"ttopen ioctl TCGETA ttold.c_lflag","",ttold.c_lflag);      ioctl(ttyfd,TCGETA,&ttraw);      ioctl(ttyfd,TCGETA,&tttvt);  #else      gtty(ttyfd,&ttold); ?     debug(F101,"ttopen gtty ttold.sg_flags","",ttold.sg_flags);   " #ifdef sony_news			/* Sony NEWS */I     if (ioctl(ttyfd,TIOCKGET,&km_ext) < 0) { /* Get console Kanji mode */ + 	perror("ttopen error getting Kanji mode"); 4 	debug(F101,"ttopen error getting Kanji mode","",0);5 	km_ext = -1;			/* Make sure this stays undefined. */      }  #endif /* sony_news */   #ifdef TIOCGETC 1     tcharf = 0;				/* In remote mode, also get */ 1     if (xlocal == 0) {			/* special characters */ ) 	if (ioctl(ttyfd,TIOCGETC,&tchold) < 0) { / 	    debug(F100,"ttopen TIOCGETC failed","",0); 	 	} else { # 	    tcharf = 1;			/* It worked. */ : 	    ioctl(ttyfd,TIOCGETC,&tchnoi); /* Get another copy */+ 	    debug(F100,"ttopen TIOCGETC ok","",0);  	}     }	 #else 3     debug(F100,"ttopen TIOCGETC not defined","",0);  #endif /* TIOCGETC */    #ifdef TIOCGLTC 1     ltcharf = 0;			/* In remote mode, also get */ 7     if (xlocal == 0) {			/* local special characters */ * 	if (ioctl(ttyfd,TIOCGLTC,&ltchold) < 0) {/ 	    debug(F100,"ttopen TIOCGLTC failed","",0); 	 	} else { # 	    ltcharf = 1;		/* It worked. */ ; 	    ioctl(ttyfd,TIOCGLTC,&ltchnoi); /* Get another copy */ + 	    debug(F100,"ttopen TIOCGLTC ok","",0);  	}     }	 #else 3     debug(F100,"ttopen TIOCGLTC not defined","",0);  #endif /* TIOCGLTC */    #ifdef TIOCLGET      lmodef = 0; +     if (ioctl(ttyfd,TIOCLGET,&lmode) < 0) { + 	debug(F100,"ttopen TIOCLGET failed","",0);      } else { 	lmodef = 1;' 	debug(F100,"ttopen TIOCLGET ok","",0);      }  #endif /* TIOCLGET */   I     gtty(ttyfd,&ttraw);                 /* And a copy of it for packets*/ M     gtty(ttyfd,&tttvt);                 /* And one for virtual tty service */    #endif /* ATTSV */ #endif /* BSD44ORPOSIX */   F /* Section for changing line discipline.  It's restored in ttres(). */   #ifdef AIXRS
 #ifndef AIX41 +     { union txname ld_name; int ld_idx = 0;        ttld = 0;          do {!   	  ld_name.tx_which = ld_idx++; %   	  ioctl(ttyfd, TXGETCD, &ld_name); + 	  if (!strncmp(ld_name.tx_name, "rts", 3))    	    ttld |= 1; #         } while (*ld_name.tx_name); 2         debug(F101,"AIX line discipline","",ttld);       }  #endif /* AIX41 */ #endif /* AIXRS */   #ifdef BSD41F /* For 4.1BSD only, force "old" tty driver, new one botches TANDEM. */     { int k;G       ioctl(ttyfd, TIOCGETD, &ttld);	/* Get and save line discipline */ 3       debug(F101,"4.1bsd line discipline","",ttld); 6       k = OTTYDISC;			/* Switch to "old" discipline */%       k = ioctl(ttyfd, TIOCSETD, &k); )       debug(F101,"4.1bsd tiocsetd","",k);      }  #endif /* BSD41 */   #ifdef aegisI     /* This was previously done before the last two TCGETA or gtty above, L      * in both the ATTSV and not-ATTSV case.  If it is not okay to have only4      * one copy if it here instead, give us a shout!      */ 7     sio_$control((short)ttyfd, sio_$raw_nl, false, st); ;     if (xlocal) {       /* ignore breaks from local line */ ?         sio_$control((short)ttyfd, sio_$int_enable, false, st); @         sio_$control((short)ttyfd, sio_$quit_enable, false, st);     }  #endif /* aegis */   #ifdef VXVE C     ttraw.c_line = 0;                   /* STTY line 0 for VX/VE */ C     tttvt.c_line = 0;                   /* STTY line 0 for VX/VE */      ioctl(ttyfd,TCSETA,&ttraw);  #endif /* vxve */   = /* If O_NDELAY was used during open(), then remove it now. */    #ifdef O_NDELAY .     if (fcntl(ttyfd, F_GETFL, 0) & O_NDELAY) {  
 #ifndef aegis E 	if (fcntl(ttyfd,F_SETFL, fcntl(ttyfd, F_GETFL, 0) & ~O_NDELAY) < 0 ) $ 	    perror("Can't unset O_NDELAY"); #endif /* aegis */A 	/* Some systems, notably Xenix (don't know how common this is in E 	 * other systems), need special treatment to get rid of the O_NDELAY E 	 * behaviour on read() with respect to carrier presence (i.e. read() C 	 * returning 0 when carrier absent), even though the above fcntl() D 	 * is enough to make read() wait for input when carrier is present.E 	 * This magic, in turn, requires CLOCAL for working when the carrier E 	 * is absent. But if xlocal == 0, presumably you already have CLOCAL B 	 * or you have a carrier, otherwise you wouldn't be running this. 	 */ #ifdef ATTSV #ifdef BSD44 #ifdef __bsdi__  	if (xlocal) 	  ttraw.c_cflag |= CLOCAL;  #endif /* __bsdi__ */ % 	tcsetattr(ttyfd, TCSADRAIN, &ttraw);  #else /* !BSD44 */ 	if (xlocal) { 	    ttraw.c_cflag |= CLOCAL; " 	    ioctl(ttyfd, TCSETA, &ttraw); 	} #endif /* BSD44 */ #endif /* ATTSV */> #ifndef NOCOTFMC /* = NO Close(Open()) To Force Mode Change */I /* Reportedly lets uugetty grab the device in SCO UNIX 3.2 / XENIX 2.3 */ @ 	close( priv_opn(ttname, O_RDWR) ); /* Magic to force change. */ #endif /* NOCOTFMC */      }  #endif /* O_NDELAY */   H /* Instruct the system how to treat the carrier, and set a few other tty  * parameters.  *K  * This also undoes the temporary setting of CLOCAL that may have been done J  * for the close(open()) above (except in Xenix).  Also throw in ~ECHO, toJ  * prevent the other end of the line from sitting there talking to itself,6  * producing garbage when the user performs a connect.  *F  * SCO Xenix unfortunately seems to ignore the actual state of CLOCAL.I  * Now it thinks CLOCAL is always on. It seems the only real solution for D  * Xenix is to switch between the lower and upper case device names.  *F  * This section may at some future time expand into setting a completeH  * collection of tty parameters, or call a function shared with ttpkt()/J  * ttvt() that does so.  On the other hand, the initial parameters are notH  * that important, since ttpkt() or ttvt() should always fix that before1  * any communication is done.  Well, we'll see...   */      if (xlocal) {      	curcarr = -2;# 	carrctl(&ttraw, ttcarr == CAR_ON);    #ifdef COHERENT  #define SVORPOSIX  #endif /* COHERENT */    #ifdef SVORPOSIX 	ttraw.c_lflag &= ~ECHO; 	ttold.c_lflag &= ~ECHO; #ifdef BSD44ORPOSIX % 	tcsetattr(ttyfd, TCSADRAIN, &ttraw);  #else  	ioctl(ttyfd, TCSETA, &ttraw); #endif /* BSD44ORPOSIX */    #else /* BSD, etc */ 	ttraw.sg_flags &= ~ECHO;  	ttold.sg_flags &= ~ECHO;  	stty(ttyfd,&ttraw); #endif /* SVORPOSIX */   #ifdef COHERENT  #undef SVORPOSIX #endif /* COHERENT */   , /*	ttflui();  This fails for some reason  */     }           /* Get current speed */        ttspeed = ttgspd(); ,     debug(F101,"ttopen ttspeed","",ttspeed);  K     /* Done, make entries in debug log, restore Ctrl-C trap, and return. */   )     debug(F101,"ttopen, ttyfd","",ttyfd);      debug(F101," lcl","",*lcl); (     debug(F111," lock file",flfnam,lkf);     signal(SIGINT,occt);     return(0); }     G /*  D O _ O P E N  --  Do the right kind of open() call for the tty. */    int  do_open(ttname) char *ttname; {   - #ifndef	O_NDELAY			/* O_NDELAY not defined */      return(priv_opn(ttname,2));   #else					/* O_NDELAY defined */   #ifdef ATT7300 /*J  Open comms line without waiting for carrier so initial call does not hangF  because state of "modem" is likely unknown at the initial call  -jrd.K  If this is needed for the getty stuff to work, and the open would not work G  without O_NDELAY when getty is still on, then this special case is ok.   Otherwise, get rid of it. -ske  */0     return(priv_opn(ttname, O_RDWR | O_NDELAY));   #else	/* !ATT7300 */  L     /* Normal case. Use O_NDELAY according to SET CARRIER. See ttscarr(). */   L     return(priv_opn(ttname, O_RDWR | ((ttcarr != CAR_ON) ? O_NDELAY : 0) ));   #endif	/* !ATT7300 */  #endif	/* O_NDELAY */  }   ; /*  T T C L O S  --  Close the TTY, releasing any lock.  */    int ? ttclos(foo) int foo; {			/* Arg req'd for signal() prototype */      int xx, x = 0;  (     debug(F101,"ttclos ttyfd","",ttyfd);:     if (ttyfd < 0) return(0);           /* Wasn't open. */  3     if (ttfdflg)			/* If we inherited ttyfd from */ 9       return(0);			/* another process, don't close it. */   6     tvtflg = 0;				/* (some day get rid of this...) */   #ifdef	NETCONN8     if (netconn) {			/* If it's a network connection. */' 	debug(F100,"ttclos closing net","",0); 4 	netclos();			/* Let the network module close it. */1 	netconn = 0;			/* No more network connection. */  	return(0);      }  #endif	/* NETCONN */  9     if (xlocal) {			/* We're closing a SET LINE device */ 3 #ifdef FT21				/* Fortune 2.1-specific items ... */  	ioctl(ttyfd,TIOCHPCL, NULL);  #endif /* FT21 */ 0 #ifdef ultrix				/* Ultrix-specific items ... */ #ifdef TIOCSINUSE 3 	/* Unset the INUSE flag that we set in ttopen() */   	ioctl(ttyfd, TIOCSINUSE, NULL); #endif /* TIOCSINUSE */  	ioctl(ttyfd, TIOCNMODEM, &x); #ifdef COMMENT 	/* What was this? */  	ioctl(ttyfd, TIOCNCAR, NULL); #endif /* COMMENT */ #endif /* ultrix */ 1 	debug(F100,"ttclos about to call ttunlck","",0); E         if (ttunlck())                  /* Release uucp-style lock */ 9 	  fprintf(stderr,"Warning, problem releasing lock\r\n");        }      if ( 	xlocal  #ifdef NOFDZERO 
 	|| ttyfd > 0  #endif /* NOFDZERO */  	) {> 	saval = signal(SIGALRM,timerh); /* Enable timer interrupt. */1 	xx = alarm(8);			/* Allow 8 seconds for this. */ " 	debug(F101,"ttclos alarm","",xx); 	if (  #ifdef CK_POSIX_SIG  	    sigsetjmp(sjbuf,1)  #else  	    setjmp(sjbuf) #endif /* CK_POSIX_SIG */ ! 	    ) {				/* Timer went off? */  	    x = -1;0 	} else {			/* What we're really trying to do */0 	    debug(F100,"ttclos calling tthang()","",0);- 	    tthang();			/* Hang up first, then... */ / 	    debug(F100,"ttclos calling ttres()","",0); ) 	    ttres();			/* Reset device modes. */  	}3 	debug(F101,"ttclos about to call close","",ttyfd); ( 	close(ttyfd);			/* Close the device. */ 	x = 1; # 	ttimoff();			/* Turn off timer. */ 
 	if (x < 0) { > 	    fprintf(stderr,"?Timed out closing device: %s\n",ttnmsv);) 	    debug(F100,"ttclos timed out","",0);  	}     }   D /* For bidirectional lines, restore getty if it was there before. */       if (xlocal) {   2 #ifdef ACUCNTRL				/* 4.3BSD acucntrl() method. */= 	acucntrl("enable",ttnmsv);	/* Enable getty on the device. */  #else 7 #ifdef ATT7300				/* ATT UNIX PC (3B1, 7300) method. */ ? 	if (attmodem & DOGETY)		/* Was getty(1m) running before us? */ 9 	  ongetty(ttnmsv);		/* Yes, restart getty on tty line */ < 	attmodem &= ~DOGETY;		/* No phone in use, getty restored */ #endif /* ATT7300 */5 #endif /* System-dependent getty-restoring methods */      }    #ifdef sony_news7     km_ext = -1;			/* Invalidate device's Kanji-mode */  #endif /* sony_news */  M     ttyfd = -1;                         /* Invalidate the file descriptor. */ #     debug(F100,"ttclos done","",0);      return(0); }   A /*  T T H A N G  --  Hangup phone line or network connection.  */  /*
   Returns:   0 if it does nothing. 0   1 if it believes that it hung up successfully.2  -1 if it believes that the hangup attempt failed. */  3 #define HUPTIME 500			/* Milliseconds for hangup */    int 
 tthang() { #ifdef NOLOCAL     return(0); #else 6     int x = 0;				/* Sometimes used as return code. */
 #ifndef POSIX      int z;				/* worker */ #endif /* POSIX */   #ifdef COHERENT  #define SVORPOSIX  #endif /* COHERENT */   8 #ifdef SVORPOSIX			/* AT&T, POSIX, HPUX declarations. */)     int spdsav;				/* for saving speed */      int spdsavi; #ifdef HPUX  /*K   Early versions of HP-UX omitted the mflag typedef.  If you get complaints D   about it, just change it to long (or better still, unsigned long). */	     mflag        dtr_down = 00000000000,        modem_rtn,       modem_sav;     char modem_state[64];  #endif /* HPUX */ #     int flags;				/* fcntl flags */      unsigned short ttc_save; #endif /* SVORPOSIX */   #ifdef COHERENT  #undef SVORPOSIX #endif /* COHERENT */   H     if (ttyfd < 0) return(0);           /* Don't do this if not open  */@     if (xlocal < 1) return(0);		/* Don't do this if not local */   #ifdef NETCONN,     if (netconn)			/* Network connection. */<       return((netclos() < 0) ? -1 : 1);	/* Just close it. */ #endif /* NETCONN */  1 /* From here down, we handle real tty devices. */    #ifdef BSD44ORPOSIX , /* Should add some error checking here... */*     debug(F100,"tthang POSIX style","",0);;     tcgetattr(ttyfd, &ttcur);		/* Get current attributes */ 9     spdsav = cfgetospeed(&ttcur);	/* Get current speed */ :     spdsavi = cfgetispeed(&ttcur);	/* Get current speed *//     cfsetospeed(&ttcur,B0);		/* Replace by 0 */      cfsetispeed(&ttcur,B0); 0     if (tcsetattr(ttyfd,TCSADRAIN,&ttcur) == -1)4       debug(F100,"tthang tcsetattr fails","",errno);"     msleep(HUPTIME);			/* Sleep */=     cfsetospeed(&ttcur,spdsav);		/* Restore previous speed */       cfsetispeed(&ttcur,spdsavi);&     tcsetattr(ttyfd,TCSADRAIN,&ttcur);     return(1);   #else /* BSD44ORPOSIX */  " #ifdef aegis				/* Apollo Aegis */F     sio_$control((short)ttyfd, sio_$dtr, false, st);    /* DTR down */$     msleep(HUPTIME);					/* pause */D     sio_$control((short)ttyfd, sio_$dtr, true,  st);    /* DTR up */     return(1); #endif /* aegis */  ' #ifdef ANYBSD				/* Any BSD version. */ (     debug(F100,"tthang BSD style","",0);7     if (ioctl(ttyfd,TIOCCDTR,0) < 0) {	/* Clear DTR. */ . 	debug(F101,"tthang TIOCCDTR fails","",errno); 	return(-1);     } .     msleep(HUPTIME);			/* For about 1/2 sec */     errno = 0;2     x = ioctl(ttyfd,TIOCSDTR,0);	/* Restore DTR */     if (x < 0) { 	/* G 	  For some reason, this tends to fail with "no such device or address" D 	  but the operation still works, probably because of the close/open= 	  later on.  So let's not scare the user unnecessarily here.  	*/ B 	debug(F101,"tthang TIOCSDTR errno","",errno); /* Log the error */% 	x = 1;				/* Pretend we succeeded */ ,     } else if (x == 0) x = 1;		/* Success */ #ifdef COMMENT #ifdef FT21 #     ioctl(ttyfd, TIOCSAVEMODES, 0);      ioctl(ttyfd, TIOCHPCL, 0);1     close(ttyfd);			/* Yes, must do this twice */ C     if ((ttyfd = open(ttnmsv,2)) < 0)	/* on Fortune computers... */ $       return(-1);			/* (but why?) */     else x = 1;  #endif /* FT21 */  #endif /* COMMENT */<     close(do_open(ttnmsv));		/* Clear i/o error condition */     errno = 0; #ifdef COMMENT5 /* This is definitely dangerous.  Why was it here? */ 3     z = ttvt(ttspeed,ttflow);		/* Restore modes. */ +     debug(F101,"tthang ttvt returns","",z);      return(z < 0 ? -1 : 1);  #else      return(x); #endif /* COMMENT */ #endif /* ANYBSD */    #ifdef ATTSV				H /* AT&T UNIX section, includes HP-UX and generic AT&T System III/V... */   #ifdef HPUX D /* Hewlett Packard allows explicit manipulation of modem signals. */   #ifdef COMMENT /* Old way... */*     debug(F100,"tthang HP-UX style","",0);B     if (ioctl(ttyfd,MCSETAF,&dtr_down) < 0)        /* lower DTR */5       return(-1);		    	           /* oops, can't. */ <     msleep(HUPTIME);			           /* Pause half a second. */.     x = 1;				           /* Set return code */I     if (ioctl(ttyfd,MCGETA,&modem_rtn) > -1) {     /* Get line status. */ @ 	if ((modem_rtn & MDCD) != 0)      	   /* Check if CD is low. */G 	  x = -1;                                  /* CD didn't drop, fail. */      } else x = -1;  G     /* Even if above calls fail, RTS & DTR should be turned back on. */      modem_rtn = MRTS | MDTR;4     if (ioctl(ttyfd,MCSETAF,&modem_rtn) < 0) x = -1;     return(x); #else & /* New way, from Hellmuth Michaelis */5     debug(F100,"tthang HP-UX style, HPUXDEBUG","",0); I     if (ioctl(ttyfd,MCGETA,&modem_rtn) == -1) { /* Get current status. */ D 	debug(F100,"tthang HP-UX: can't get modem lines, NO HANGUP!","",0); 	return(-1);     } *     sprintf(modem_state,"%#lx",modem_rtn);E     debug(F110,"tthang HP-UX: modem lines got = ",modem_state,0);     2     modem_sav = modem_rtn;		/* save line status */,     modem_rtn &= ~MDTR;			/* DTR bit down */*     sprintf(modem_state,"%#lx",modem_rtn);J     debug(F110,"tthang HP-UX: modem lines lowered DTR = ",modem_state,0); >     if (ioctl(ttyfd,MCSETAF,&modem_rtn) < 0) { /* lower DTR */3 	debug(F100,"tthang HP-UX: can't lower DTR!","",0); ! 	return(-1);			/* oops, can't. */      } 1     msleep(HUPTIME);			/* Pause half a second. */ #     x = 1;				/* Set return code */ E     if (ioctl(ttyfd,MCGETA,&modem_rtn) > -1) { /* Get line status. */ ' 	sprintf(modem_state,"%#lx",modem_rtn); B 	debug(F110,"tthang HP-UX: modem lines got = ",modem_state,0);    9 	if ((modem_rtn & MDCD) != 0) {	/* Check if CD is low. */ ; 	    debug(F100,"tthang HP-UX: DCD didn't get down!","",0); * 	    x = -1;			/* CD didn't drop, fail. */	 	} else { 0 	    debug(F100,"tthang HP-UX: DCD down!","",0); 	}     } else { 	x = -1;9 	debug(F100,"tthang HP-UX: can't get DCD status !","",0);      }   G     /* Even if above calls fail, RTS & DTR should be turned back on. */        modem_sav |= (MRTS | MDTR); .     if (ioctl(ttyfd,MCSETAF,&modem_sav) < 0) { 	x = -1;F 	debug(F100,"tthang HP-UX: can't set saved state |=(RTS | DTR)","",0);     } else {' 	sprintf(modem_state,"%#lx",modem_sav); D 	debug(F110,"tthang HP-UX: final modem lines = ",modem_state,0);    
     }    	     return(x); #endif /* COMMENT */   #else /* AT&T but not HP-UX */  K /* SVID for AT&T System V R3 defines ioctl's for handling modem signals. */ H /* It is not known how many, if any, systems actually implement them, */) /* so we include them here in ifdef's. */    #ifndef _IBMR2 /*5   No modem-signal twiddling for IBM RT PC or RS/6000. 5   In AIX 3.1 and earlier, the ioctl() call is broken. A   This code could be activated for AIX 3.1 with PTF 2006 or later A   (e.g. AIX 3.2), but close/open does the job too, so why bother.  */  #ifdef TIOCMBIS				/* Bit Set */" #ifdef TIOCMBIC				/* Bit Clear */ #ifdef TIOCM_DTR			/* DTR */  1 /* Clear DTR, sleep 300 msec, turn it back on. */ F /* If any of the ioctl's return failure, go on to the next section. */  (     z = TIOCM_DTR;			/* Code for DTR. */: #ifdef TIOCM_RTS			/* Lower RTS too if symbol is known. */     z |= TIOCM_RTS;			 #endif /* TIOCM_RTS */  0     debug(F101,"tthang TIOCM signal mask","",z);B     if (ioctl(ttyfd,TIOCMBIC,&z) > -1) {   /* Try to lower DTR. */' 	debug(F100,"tthang TIOCMBIC ok","",0); 0 	msleep(HUPTIME);		   /* Pause half a second. */C 	if (ioctl(ttyfd,TIOCMBIS,&z) > -1) { /* Try to turn it back on. */ + 	    debug(F100,"tthang TIOCMBIS ok","",0);  #ifndef CLSOPN& 	    return(1);			/* Success, done. */ #endif /* CLSOPN */ + 	} else {			/* Couldn't raise, continue. */ 2 	    debug(F101,"tthang TIOCMBIS errno","",errno); 	}/     } else {				/* Couldn't lower, continue. */ /  	debug(F101,"tthang TIOCMBIC errno","",errno);      }  #endif /* TIOCM_DTR */ #endif /* TIOCMBIC */  #endif /* TIOCMBIS */  #endif /* _IBMR2 */  /*N   General AT&T UNIX case, not HPUX.  The following code is highly suspect.  NoL   two AT&T-based systems seem to do this the same way.  The object is simplyK   to turn off DTR and then turn it back on.  SVID says the universal method K   for turning off DTR is to set the speed to zero, and this does seem to do N   the trick in all cases.  But neither SVID nor any known man pages say how toJ   turn DTR back on again.  Some variants, like most Xenix implementations,H   raise DTR again when the speed is restored to a nonzero value.  OthersM   require the device to be closed and opened again, but this is risky because ?   getty could seize the device during the instant it is closed.  */  ' /* Return code for ioctl failures... */  #ifdef ATT63003     x = 1;				/* ATT6300 doesn't want to fail... */  #else      x = -1;  #endif /* ATT6300 */  +     debug(F100,"tthang get settings","",0); C     if (ioctl(ttyfd,TCGETA,&ttcur) < 0) /* Get current settings. */ 3       return(x);			/* Fail if this doesn't work. */ E     if ((flags = fcntl(ttyfd,F_GETFL,0)) < 0) /* Get device flags. */        return(x);<     ttc_save = ttcur.c_cflag;		/* Remember current speed. */     spdsav = ttc_save & CBAUD;)     debug(F101,"tthang speed","",spdsav);    #ifdef O_NDELAY 2     debug(F100,"tthang turning O_NDELAY on","",0);D     fcntl(ttyfd, F_SETFL, flags | O_NDELAY); /* Activate O_NDELAY */ #endif /* O_NDELAY */   ; #ifdef ATT7300 /* This is the way it is SUPPOSED to work */ >     ttcur.c_cflag &= ~CBAUD;		/* Change the speed to zero.  */ #else  #ifdef RTAIX>     ttcur.c_cflag &= ~CBAUD;		/* Change the speed to zero.  */? #else          /* This way really works but may be dangerous */  #ifdef u3b2 @     ttcur.c_cflag = ~(CBAUD|CLOCAL);	/* Special for AT&T 3B2s */ 					/* (CLOCAL must be OFF) */  #else # #ifdef SCO3R2				/* SCO UNIX 3.2 */  /*E   This is complete nonsense, but an SCO user claimed this change made D   hanging up work.  Comments from other SCO UNIX 3.2 users would be    appreciated. */     ttcur.c_cflag = CBAUD|B0;  #else $ #ifdef AIXRS				/* AIX on RS/6000 */ /*@   Can't set speed to zero on AIX 3.1 on RS/6000 64-port adapter,G   even though you can do it on the built-in port and the 8- and 16-port ,   adapters.  (Untested on 128-port adapter.) */D     ttcur.c_cflag = CLOCAL|HUPCL|spdsav; /* Speed 0 causes EINVAL */! #else					/* None of the above */  /*E   Set everything, including the speed, to zero, except for the CLOCAL    and HUPCL bits.  */!     ttcur.c_cflag = CLOCAL|HUPCL;  #endif /* AIXRS */ #endif /* SCO3R2 */  #endif /* u3b2 */  #endif /* RTAIX */ #endif /* ATT7300 */   #ifdef COMMENT8     /* and if none of those work, try one of these... */     ttcur.c_cflag = 0;     ttcur.c_cflag = CLOCAL; $     ttcur.c_cflag &= ~(CBAUD|HUPCL);$     ttcur.c_cflag &= ~(CBAUD|CREAD);*     ttcur.c_cflag &= ~(CBAUD|CREAD|HUPCL);     /* or other combinations */  #endif /* COMMENT */  
 #ifdef TCXONC %     debug(F100,"tthang TCXONC","",0);      ioctl(ttyfd, TCXONC, 1); #endif /* TCXONC */    #ifdef TIOCSTART(     debug(F100,"tthang TIOCSTART","",0);     ioctl(ttyfd, TIOCSTART, 0);  #endif /* TIOCSTART */  B     if (ioctl(ttyfd,TCSETAF,&ttcur) < 0) { /* Fail if we can't. */2 	fcntl(ttyfd, F_SETFL, flags);	/* Restore flags */& 	return(-1);			/* before returning. */     } 3     msleep(300);			/* Give modem time to notice. */   K /* Now, even though it doesn't say this in SVID or any man page, we have */ M /* to close and reopen the device.  This is not necessary for all systems, */ M /* but it's impossible to predict which ones need it and which ones don't. */    #ifdef ATT7300 /*C   Special handling for ATT 7300 UNIX PC and 3B1, which have "phone" L   related ioctl's for their internal modems.  attmodem has getty status and L   modem-in-use bit.  Reportedly the ATT7300/3B1 PIOCDISC call is necessary, O   but also ruins the file descriptor, and no other phone(7) ioctl call can fix  N   it.  Whateverit does, it seems to escape detection with PIOCGETA and TCGETA.H   The only way to undo the damage is to close the fd and then reopen it. */     if (attmodem & ISMODEM) { / 	debug(F100,"tthang attmodem close/open","",0); ? 	ioctl(ttyfd,PIOCUNHOLD,&dialer); /* Return call to handset. */ 7 	ioctl(ttyfd,PIOCDISC,&dialer);	/* Disconnect phone. */ / 	close(ttyfd);			/* Close and reopen the fd. */ - 	ttyfd = priv_opn(ttnmsv, O_RDWR | O_NDELAY); 5 	attmodem &= ~ISMODEM;		/* Phone no longer in use. */      }  #else /* !ATT7300 */J /* It seems we have to close and open the device for other AT&T systems */G /* too, and this is the place to do it.  The following code does the */ N /* famous close(open(...)) magic by default.  If that doesn't work for you, */J /* then try uncommenting the following statement or putting -DCLSOPN in */ /* the makefile CFLAGS. */   /* #define CLSOPN */  K #ifndef SCO32 /* Not needed by, and harmful to, SCO UNIX 3.2 / Xenix 2.3 */    #ifdef O_NDELAY " #define OPENFLGS O_RDWR | O_NDELAY #else  #define OPENFLGS O_RDWR  #endif   #ifndef CLSOPND /* This method is used by default, i.e. unless CLSOPN is defined. */F /* It is thought to be safer because there is no window where getty */O /* can seize control of the device.  The drawback is that it might not work. */   =     debug(F101,"tthang close(open()), OPENFLGS","",OPENFLGS); &     close(priv_opn(ttnmsv, OPENFLGS));   #else K /* This method is used if you #define CLSOPN.  It is more likely to work */ = /* than the previous method, but it's also more dangerous. */   :     debug(F101,"tthang close/open, OPENFLGS","",OPENFLGS);     close(ttyfd);      msleep(10); ;     ttyfd = priv_opn(ttnmsv, OPENFLGS);	/* Open it again */  #endif /* CLSOPN */  #undef OPENFLGS    #endif /* SCO32 */ #endif /* ATT7300 */  ; /* Now put all flags & modes back the way we found them. */ 1 /* (Does the order of ioctl & fcntl matter ? ) */   /     debug(F100,"tthang restore settings","",0); 8     ttcur.c_cflag = ttc_save;		/* Get old speed back. */@     if (ioctl(ttyfd,TCSETAF,&ttcur) < 0) /* ioctl parameters. */       return(-1);  #ifdef O_NDELAY  /*L   This is required for IBM RT and RS/6000, probably helps elsewhere too (?).F   After closing a modem line, the modem will probably not be assertingG   carrier any more, so we should not require carrier any more.  If this J   causes trouble on non-IBM UNIXes, change the #ifdef to use _IBMR2 rather   than O_NDELAY. */?     flags &= ~O_NDELAY;			/* Don't require carrier on reopen */  #endif /* O_NDELAY */ >     if (fcntl(ttyfd,F_SETFL,flags) < 0)	/* fcntl parameters */       return(-1);        return(1); #endif /* not HPUX */  #endif /* ATTSV */ #endif /* BSD44ORPOSIX */  #endif /* NOLOCAL */ }    /*H   Major change in 5A(174).  We used to use LPASS8, if it was defined, toH   allow 8-bit data and Xon/Xoff flow control at the same time.  But thisJ   LPASS8 business seems to have been causing trouble for everybody but me!K   For example, Annex terminal servers, commonly used with Encore computers, K   do not support LPASS8 even though the Encore itself does.  Ditto for many J   other terminal servers, TELNET connections, rlogin connections, etc etc.L   Now, reportedly, even vanilla 4.3 BSD systems can't do this right on theirL   serial lines, even though LPASS8 is a feature of 4.3BSD.  So let's turn itH   off for everybody.  That means we goes back to using raw mode, with no   flow control.  Phooey.  L   NOTE: This must be done before the first reference to LPASS8 in this file,'   and after the last #include statment.  */
 #ifdef LPASS8 
 #undef LPASS8  #endif /* LPASS8 */   9 /*  T T R E S  --  Restore terminal to "normal" mode.  */   H /* ske@pkmab.se: There are two choices for what this function should do.G  * (1) Restore the tty to current "normal" mode, with carrier treatment J  * according to ttcarr, to be used after every kermit command. (2) RestoreH  * the tty to the state it was in before kermit opened it. These choicesL  * conflict, since ttold can't hold both choices of tty parameters.  ttres()H  * is currently being called as in choice (1), but ttold basically holdsJ  * the initial parameters, as in (2), and the description at the beginning  * of this file says (2).   *I  * I don't think restoring tty parameters after all kermit commands makes H  * much of a difference.  Restoring them upon exit from kermit may be ofI  * some use in some cases (when the line is not restored automatically on #  * close, by the operating system).   *E  * I can't choose which one it should be, so I haven't changed it. It F  * probably works as it is, too. It would probably even work even with  * ttres() entirely deleted...  *E  * (from fdc: Actually, this function operates in remote mode too, so E  * it restores the console (command) terminal to whatever mode it was I  * in before packet operations began, so that commands work right again.)   */  int H ttres() {                               /* Restore the tty to normal. */
     int x;  7     if (ttyfd < 0) return(-1);          /* Not open. */   D     if (ttfdflg) return(0);		/* Don't mess with terminal modes if */, 					/* we got ttyfd from another process */ #ifdef	NETCONNB     if (netconn) return (0);		/* Network connection, do nothing */ #endif	/* NETCONN */  9 /* Real terminal device, so restore its original modes */   / #ifdef BSD44ORPOSIX			/* For POSIX like this */ *     x = tcsetattr(ttyfd,TCSADRAIN,&ttold);! #else					/* For all others... */ B #ifdef ATTSV                            /* For AT&T versions... */F     x = ioctl(ttyfd,TCSETAW,&ttold);	/* Restore tty modes this way. */ #else ' /* Here we restore the modes for BSD */   3 #ifdef LPASS8				/* Undo "pass8" if it were done */      if (lmodef) { & 	if (ioctl(ttyfd,TIOCLSET,&lmode) < 0), 	  debug(F100,"ttres TIOCLSET failed","",0); 	else ( 	  debug(F100,"ttres TIOCLSET ok","",0);     }  #endif /* LPASS8 */   = #ifdef CK_DTRCTS		   /* Undo hardware flow if it were done */      if (lmodef) { '  	if (ioctl(ttyfd,TIOCLSET,&lmode) < 0) -  	  debug(F100,"ttres TIOCLSET failed","",0);   	else)  	  debug(F100,"ttres TIOCLSET ok","",0);      }  #endif /* CK_DTRCTS */  4 #ifdef TIOCGETC				/* Put back special characters */"     if (tcharf && (xlocal == 0)) {' 	if (ioctl(ttyfd,TIOCSETC,&tchold) < 0) , 	  debug(F100,"ttres TIOCSETC failed","",0); 	else ( 	  debug(F100,"ttres TIOCSETC ok","",0);     }  #endif /* TIOCGETC */   : #ifdef TIOCGLTC				/* Put back local special characters */#     if (ltcharf && (xlocal == 0)) { ( 	if (ioctl(ttyfd,TIOCSLTC,&ltchold) < 0), 	  debug(F100,"ttres TIOCSLTC failed","",0); 	else ( 	  debug(F100,"ttres TIOCSLTC ok","",0);     }  #endif /* TIOCGLTC */   L     x = stty(ttyfd,&ttold);             /* restore tty modes the old way. */       if (!xlocal)4       msleep(100);			/* This replaces sleep(1)... */& 					/* Put back sleep(1) if tty is */! 					/* messed up after close. */  #endif /* ATTSV */ #endif /* BSD44ORPOSIX */   /     debug(F101,"ttres tty modes restore","",x);  #ifndef QNX 2     if (x < 0) debug(F101,"ttres errno","",errno); #endif /* QNX */   #ifdef AIXRS
 #ifndef AIX41 :     x = ioctl(ttyfd, ttld & 1 ? TXADDCD : TXDELCD, "rts");=     debug(F101,"ttres AIX line discipline rts restore","",x);  #endif /* AIX41 */ #endif /* AIXRS */   #ifdef BSD415     if (ttld > -1) {			/* Put back line discipline */ # 	x = ioctl(ttyfd, TIOCSETD, &ttld); 2 	debug(F101,"ttres line discipline restore","",x);2 	if (x < 0) debug(F101,"...ioctl errno","",errno); 	ttld = -1;      }  #endif /* BSD41 */   #ifdef sony_news;     x = xlocal ? km_ext : km_con;	/* Restore Kanji mode. */ <     if (x != -1) {			/* Make sure we know original modes. */% 	if (ioctl(ttyfd,TIOCKSET, &x) < 0) { * 	    perror("ttres can't set Kanji mode");7 	    debug(F101,"ttres error setting Kanji mode","",x);  	    return(-1); 	}     } /     debug(F100,"ttres set Kanji mode ok","",0);  #endif /* sony_news */  :     tvtflg = 0;				/* Invalidate terminal mode settings */     return(x); }    #ifndef NOUUCP
 #ifdef HPUX10   B /* Aliases (different drivers) for HP-UX 10.00 dialout devices: */  ? static char *devprefix[] = { "tty", "ttyd", "cul", "cua", "" };   / /*  T T C H K P I D  --  Check lockfile pid  */  /*>   Read pid from lockfile named f, check that it's still valid.   If so, return 1.#   On failure to read pid, return 1. I   Otherwise, try to delete lockfile f and return 0 if successful, else 1.  */
 static int ttchkpid(f) char *f; {     int pid, x;      priv_on();0     pid = ttrpid(f);			/* Read pid from file. */     priv_off(); =     if (pid > -1) {			/* If we were able to read the pid.. */ # 	debug(F101,"ttchkpid pid","",pid); 0 	errno = 0;			/* See if process still exists. */ 	x = kill((PID_T) pid,0); " 	debug(F101,"ttchkpid kill","",x);, 	debug(F101,"ttchkpid kill errno","",errno);4 	if (x < 0 && errno == ESRCH) { /* pid is invalid */- 	    debug(F111,"removing stale lock",f,pid);  	    if (!backgrd)F 	      printf("Removing stale lock %s (pid %d terminated)\n", f, pid); 	    priv_on(); / 	    x = unlink(f);		/* Remove the lockfile. */  	    priv_off();, 	    debug(F111,"ttchkpid unlink",flfnam,x); 	    if (x > -1)7 	      return(0);		/* Device is not locked after all */  	    else if (!backgrd) 3 	      perror("Failure to remove stale lock file");  	} 	return(1);      }  }  #endif /* HPUX10 */   F /*  T T R P I D  --  Read pid from lockfile "name" (used by ttlock) */  
 static int ttrpid(name) char *name; {     int x, fd, pid;         debug(F110,"ttrpid",name,0);     if (!name) return(-1);     if (!*name) return(-1); :     fd = open(name,O_RDONLY);		/* Try to open lockfile. */     if (fd > 0) {    #ifdef PIDSTRING 	char buf[12];; 	x = read(fd, buf, 11);		/* For HDBUUCP, read pid string */ * 	debug(F101,"ttrpid PIDSTRING read","",x); 	if (x < 0) return(-1);  	buf[11] = '\0';
 	if (x == 11) @ 	  x = sscanf(buf,"%d",&pid);	/* Get the integer pid from it. */ #else E 	x = read(fd, (char *)&pid, sizeof(pid)); /* Else read integer pid */ ( 	debug(F101,"ttrpid integer read","",x); #endif /* PIDSTRING */  / 	if (x < 0) pid = -1;		/* Return any errors. */ ' 	close(fd);			/* Close the lockfile. */      } else pid = -1;$     debug(F101,"ttrpid pid","",pid);     return(pid); }  #endif /* NOUUCP */    /*  T T L O C K  */    /*K   This function attempts to coordinate use of the communication device with D   other copies of Kermit and any other program that follows the UUCPM   device-locking conventions, which, unfortunately, vary among different UNIX I   implementations.  The idea is to look for a file of a certain name, the M   "lockfile", in a certain directory.  If such a file is found, then the line M   is presumed to be in use, and Kermit should not use it.  If no such file is N   found, Kermit attempts to create one so that other programs will not use theM   same line at the same time.  Because the lockfile and/or the directory it's L   in might lack write permission for the person running Kermit, Kermit couldE   find itself running setuid to uucp or other user that does have the M   necessary permissions.  At startup, Kermit has changed its effective uid to G   the user's real uid, and so ttlock() must switch back to the original K   effective uid in order to create the lockfile, and then back again to the M   real uid to prevent unauthorized access to other directories or files owned '   by the user the program is setuid to.   J   Totally rewritten for C-Kermit 5A to eliminate windows of vulnerability,I   based on suggestions from Warren Tucker.  Call with pointer to name of     tty device.  Returns:       0 on success    -1 on failure   K   Note: Once privileges are turned on using priv_on(), it is essential that 9   they are turned off again before this function returns.  */2 #ifdef SVR4				/* Lockfile uses device numbers. */ /*I   Although I can't find this in writing anywhere (e.g. in SVID for SVR4), G   it is the behavior of the "reference version" of SVR4, i.e. the Intel C   port from UNIX Systems Laboratories, then called Univel UnixWare,    now called Novell UnixWare.  */- #ifndef LFDEVNO				/* Define this for SVR4 */ 8 #ifndef AIXRS				/* But not for RS/6000 AIX 3.2, etc. */2 #ifndef BSD44				/* If anybody else needs it... */ #ifndef __386BSD__ #ifndef HPUX10- #ifndef IRIX51				/* SGI IRIX 5.1 or later */  #define LFDEVNO  #endif /* IRIX51 */  #endif /* HPUX10 */  #endif /* __386BSD__ */  #endif /* BSD44 */ #endif /* AIXRS */8 #endif /* LFDEVNO */			/* ... define it here or on CC */' #endif /* SVR4 */			/* command line. */    #ifdef COHERENT  #define LFDEVNO  #endif /* COHERENT */    #ifdef LFDEVNO; #include <sys/stat.h>			/* For major() & minor() macros. */ & 					/* Should be in <sys/types.h>. */+ #ifndef major				/* If we didn't find it */ & #ifdef SVR4				/* then for Sys V R4 */( #include <sys/mkdev.h>			/* look here */% #else					/* or for SunOS versions */  #ifdef SUNOS4				/* ... */+ #include <sys/sysmacros.h>		/* look here */ ( #else					/* Otherwise take a chance: */< #define	major(dev) ( (int) ( ((unsigned)(dev) >> 8) & 0xff))+ #define	minor(dev) ( (int) ( (dev) & 0xff))  #endif /* SUNOS4 */  #endif /* SVR4 */  #endif /* major */ #endif /* LFDEVNO */ /*H   Note for RS/6000: routines ttylock(devicename), ttyunlock(devicename),H   and ttylocked(devicename) from the standard library (libc.a) could be L   used here instead.  It's not clear whether there is any advantage in this. */  
 static int ttlock(ttdev) char *ttdev; {
     int x;  
 #ifdef NOUUCP      strcpy(flfnam,"NOLOCK");     haslock = 1;     return(0); #else /* !NOUUCP */    #ifndef HPUX10  7     int lockfd;				/* File descriptor for lock file. */ 3     PID_T pid;				/* Process id of this process. */ 6     int fpid;				/* pid found in existing lockfile. */5     int tries;				/* How many times we've tried... */  #ifdef LFDEVNO:     struct stat devbuf;			/* For device numbers (SVR4). */ #endif /* LFDEVNO */   #ifdef PIDSTRING6     char pid_str[12];			/* My pid in string format. */ #endif /* PIDSTRING */       char *device, *devname;   8 #define LFNAML 50			/* Max length for lock file name. *//     char lockfil[LFNAML];		/* Lock file name */  #ifdef RTAIX<     char lklockf[LFNAML];		/* Name for link to lock file  */ #endif /* RTAIX */;     char tmpnam[LFNAML+30];		/* Temporary lockfile name. */ C     char *lockdir = LOCK_DIR;		/* Defined near top of this file, */ ! 					/* or on cc command line. */   =     haslock = 0;                        /* Not locked yet. */ 3     *flfnam = '\0';			/* Lockfile name is empty. */ 3     pid = getpid();			/* Get id of this process. */   4 /*  Construct name of lockfile and temporary file */  B /*  device  = name of tty device without the path, e.g. "ttyh8" */C /*  lockfil = name of lock file, without path, e.g. "LCK..ttyh8" */   I     device = ((devname = xxlast(ttdev,'/')) != NULL ? devname+1 : ttdev);   3 #ifdef ISIII				/* Interactive System III, PC/IX */      strcpy(lockfil, device); #else 8 #ifdef LFDEVNO				/* Lockfilename has device numbers. */      if (stat(ttdev,&devbuf) < 0)       return(-1);  #ifdef COHERENT !     sprintf(lockfil,"LCK..%d.%d", 8 	    major(devbuf.st_rdev),	   /* major device number */= 	    0x1f & minor(devbuf.st_rdev)); /* minor device number */  #else (     sprintf(lockfil,"LK.%03d.%03d.%03d",& 	    major(devbuf.st_dev),	/* inode */5 	    major(devbuf.st_rdev),	/* major device number */ 6 	    minor(devbuf.st_rdev));	/* minor device number */ #endif /* COHERENT */  #else					/* Others... */  #ifdef PTX				/* Dynix PTX */ =     if (device != &ttdev[5] && strncmp(ttdev,"/dev/",5)==0) { 3 	sprintf(lockfil,"LCK..%.3s%s", &ttdev[5], device); 
     } else #endif /* PTX */'     sprintf(lockfil,"LCK..%s", device); ! #ifdef M_XENIX				/* SCO Xenix */      { int x; char c;I       x = (int)strlen(lockfil) - 1;	/* Get last letter of device name. */ 7       if (x > 0) {			/* If it's uppercase, lower it. */  	  c = lockfil[x];7 	  if (c >= 'A' && c <= 'Z') lockfil[x] += ('a' - 'A');        }      }  #endif /* M_XENIX */ #ifdef RTAIX     strcpy(lklockf,device);  #endif /* RTAIX */ #endif /* LFDEVNO */ #endif /* ISIII */  I /*  flfnam = full lockfile pathname, e.g. "/usr/spool/uucp/LCK..ttyh8" */ B /*  tmpnam = temporary unique, e.g. "/usr/spool/uucp/LTMP..pid" */  ,     sprintf(flfnam,"%s/%s",lockdir,lockfil); #ifdef RTAIX,     sprintf(lkflfn,"%s/%s",lockdir,lklockf); #endif /* RTAIX */5     sprintf(tmpnam,"%s/LTMP.%05d",lockdir,(int) pid); )     debug(F110,"ttlock flfnam",flfnam,0); )     debug(F110,"ttlock tmpnam",tmpnam,0);   7     priv_on();				/* Turn on privileges if possible. */ E     lockfd = creat(tmpnam, 0444);	/* Try to create temp lock file. */ ,     if (lockfd < 0) {			/* Create failed. */0 	debug(F111,"ttlock creat failed",tmpnam,errno); 	if (errno == ENOENT) {  	    perror(lockdir);	    < 	    printf("UUCP not installed or Kermit misconfigured\n");	 	} else {  	    perror(lockdir); : 	    unlink(tmpnam);		/* Get rid of the temporary file. */ 	}+ 	priv_off();			/* Turn off privileges!!! */ ) 	return(-1);			/* Return failure code. */      } H /* Now write the pid into the temp lockfile in the appropriate format */  / #ifdef PIDSTRING			/* For Honey DanBer UUCP, */ 1     sprintf(				/* write PID as decimal string */ 
 	    pid_str,  #ifdef LINUXFSSTND* 	    "%010d\n",			/* with leading zeros */ #else  #ifdef COHERENT ) 	    "%d\n",			/* with leading nothing */  #else * 	    "%10d\n",			/* with leading blanks */ #endif /* COHERENT */  #endif /* LINUXFSSTND */ 	    (int) pid 	    );      write(lockfd, pid_str, 11); :     debug(F111,"ttlock hdb pid string",pid_str,(int) pid);  * #else /* Not PIDSTRING, use integer PID */  .     write(lockfd, (char *)&pid, sizeof(pid) );*     debug(F101,"ttlock pid","",(int) pid);   #endif /* PIDSTRING */  A /* Now try to rename the temp file to the real lock file name. */ A /* This will fail if a lock file of that name already exists.  */   3     close(lockfd);			/* Close the temp lockfile. */ @     chmod(tmpnam,0444);			/* Permission for a valid lock. */         tries = 0;%     while (!haslock && tries++ < 2) { A 	haslock = (link(tmpnam,flfnam) == 0); /* Create a link to it. */ 4 	if (haslock) {			      /* If we got the lockfile */ #ifdef RTAIX 	    link(flfnam,lkflfn);  #endif /* RTAIX */     #ifdef LOCKF #ifdef F_TLOCK /*D   Advisory file locking works on SVR4, so we use it.  In fact, it isL   necessary in some cases, e.g. when SLIP is involved.  But it still doesn'tK   seem prevent multiple users accessing the same device by different names.  */6             while ( lockf(ttyfd, F_TLOCK, 0L) != 0 ) {F                 debug(F111, "ttlock: lockf returns errno", "", errno);<                 if ( (++tries >= 3) || (errno != EAGAIN) ) {A                     x = unlink(flfnam); /* remove the lockfile */ 9                     debug(F111,"ttlock unlink",flfnam,x);                       haslock = 0; 		    break; 		}                  sleep(2);  	    }3 	    if (haslock)		/* If we got an advisory lock */  #endif /* F_TLOCK */ #endif /* LOCKF */! 	      break;			/* We're done. */   2 	} else {			/* We didn't create a new lockfile. */E 	    if ((fpid = ttrpid(flfnam)) > -1) {	/* Read pid from old one. */  		if (fpid > 0) { ( 		    debug(F101,"ttlock fpid","",fpid);4 		    errno = 0;		/* See if process still exists. */ 		    x = kill((PID_T) fpid,0); % 		    debug(F101,"ttlock kill","",x); / 		    debug(F101,"ttlock kill errno","",errno); 9 		    if (x < 0 && errno == ESRCH) { /* pid is invalid */ 2 			debug(F111,"ttlock removing stale lock",flfnam, 			      fpid);  			if (!backgrd) 			  printf(3 				"Removing stale lock %s (pid %d terminated)\n",  				 flfnam,fpid);1 			x = unlink(flfnam); /* remove the lockfile. */ ( 			debug(F111,"ttlock unlink",flfnam,x);- 			continue;	/* and go back and try again. */ 7 		    } else if ((x < 0 && errno == EPERM) || x == 0) { , 			unlink(tmpnam);	/* Delete the tempfile */1 			debug(F101,"ttlock found tty locked","",fpid); # 			priv_off();	/* Turn off privs */ / 			return(-2);	/* Code for device is in use. */  		    } 
 		} else {2 		    debug(F101,"ttlock can't get fpid","",fpid); 		    break; 		} 9 	    } else break;		/* Couldn't read pid from old file */  	}     } :     unlink(tmpnam);			/* Unlink (remove) the temp file. */'     priv_off();				/* Turn off privs */ ?     return(haslock ? 0 : -1);		/* Return link's return code. */    #else /* HPUX10 */   /*N   HP-UX 10.00 gets its own copy of this routine.  The behavior of this routineM   is modeled after the observed behavior of the HP-UX 10.00 IC2 'cu' program. K   Dialout device names consist of a prefix, an instance (interface) number, M   the letter "p", and a port number, e.g.  tty0p0, cul1p0, cua0p1, etc.  Each I   physical device can have (at least) four names (drivers): "tty" (direct N   out), "cul" (dialout), "cua" (automatic dialout), and "ttyd" (dialin).  EachN   of these is followed by the <instance>p<port>, e.g. "0p0", which is referredN   to below as the "unit".  This routine checks for all four aliases of a givenI   unit.  If it decides the device is free, then if it is a "cua" or "cul" G   device, it creates a second lockfile with the "ttyd" prefix.  This is K   exactly what cu does.  If the "set line" device does not happen to have a M   unit number, then it is used literally and no synomyms are searched for and    only one lockfile is created.  */8 #define LFNAML 80			/* Max length for lock file name. */  7     int lockfd;				/* File descriptor for lock file. */ 3     PID_T pid;				/* Process ID of this process. */ 6     int fpid;				/* pid found in existing lockfile. */5     int tries;				/* How many times we've tried... */      int i, k;				/* Workers */  4     char *device, *devname;		/* "/dev/xxx", "xxx" */9     char *unit, *p;			/* <instance>p<port> part of xxx */   8     char lockfil[LFNAML];		/* Lockfile name (no path) */8     char tmpnam[LFNAML];		/* Temporary lockfile name. */@     char *lockdir = "/var/spool/locks";	/* Lockfile directory */  =     haslock = 0;                        /* Not locked yet. */ 3     *flfnam = '\0';			/* Lockfile name is empty. */ ,     lock2[0] = '\0';			/* Second one too. */-     pid = getpid();			/* Get my process ID */  /*2   Construct name of lockfile and temporary file...>   device  = name of tty device without the path, e.g. "tty0p0"?   lockfil = name of lock file, without path, e.g. "LCK..tty0p0"  */I     device = ((devname = xxlast(ttdev,'/')) != NULL ? devname+1 : ttdev); )     debug(F110,"TTLOCK device",device,0); '     sprintf(lockfil,"LCK..%s", device);   /     k = 0;				/* Assume device is not locked */ 3     unit = device;			/* Unit = <instance>p<port> */ >     while (*unit && !isdigit(*unit))	/* Search for digit... */
       unit++; 3     p = unit;				/* Verify <num>p<num> format... */ '     debug(F110,"TTLOCK unit 1",unit,0); <     while (*p && isdigit(*p++)) ;	/* This does not assume */5     if (*p++ == 'p')			/* any particular number of */ D       while (*p && isdigit(*p++)) ;	/* digits before & after "p". */     if (*p) unit = "";'     debug(F110,"TTLOCK unit 2",unit,0);   5     if (*unit) {			/* Device name has unit number. */ G 	/* The following loop not only searches for the various lockfile    */ G 	/* synonyms, but also removes all -- not just one -- stale lockfile */ G 	/* for the device, should there be more than one.  See ttchkpid().  */ ; 	for (i = 0; *devprefix[i]; i++) { /* For each driver... */  	    /* Make lockfile name */ = 	    sprintf(lock2,"%s/LCK..%s%s",lockdir,devprefix[i],unit);   	    priv_on();			/* Privs on */9 	    k = zchki(lock2) != -1;	/* See if lockfile exists */ " 	    priv_off();			/* Privs off */3 	    debug(F111,"TTLOCK check for lock A",lock2,k); C 	    if (k) if (ttchkpid(lock2)) { /* If pid still active, fail. */  		strcpy(flfnam,lock2); 
 		return(-2);  	    } 	}3     } else {				/* Some other device-name format */ 0 	/* This takes care of symbolic links, etc... */$ 	/* But does not chase them down! */E 	sprintf(lock2,"%s/LCK..%s",lockdir,device); /* Use the name as-is */  	priv_on(); ; 	k = zchki(lock2) != -1;		/* Check for existing lockfile */  	priv_off();/ 	debug(F111,"TTLOCK check for lock B",lock2,k); < 	if (k) if (ttchkpid(lock2)) {	/* Check pid from lockfile */ 	    strcpy(flfnam,lock2); 	    return(-2); 	}     }  /*N   Get here only if there is no (more) lockfile, so now we make one (or two)...F   flfnam = full lockfile pathname, e.g. "/usr/spool/uucp/LCK..cul0p0".F   tmpnam = unique temporary filname, e.g. "/usr/spool/uucp/LTMP..pid". */F     sprintf(flfnam,"%s/%s",lockdir,lockfil); /* Our SET LINE device */  J     /* If dialout device, also make one for corresponding dialin device */     lock2[0] = '\0';*     if (!strncmp(device,"cu",2) && *unit) 6       sprintf(lock2, "%s/LCK..ttyd%s", lockdir, unit);  O     sprintf(tmpnam,"%s/LTMP.%05d",lockdir,(int) pid); /* Make temporary name */  #ifdef DEBUG     if (deblog) { & 	debug(F110,"TTLOCK flfnam",flfnam,0);% 	debug(F110,"TTLOCK lock2",lock2,0);	 & 	debug(F110,"TTLOCK tmpnam",tmpnam,0);     }  #endif /* DEBUG */ /*    Lockfile permissions...=    444 is standard, HP-UX 10.00 uses 664.  It doesn't matter. F    Kermit uses 444; the difference lets us tell whether Kermit created    the lock file.  */+     priv_on();				/* Turn on privileges. */ E     lockfd = creat(tmpnam, 0444);	/* Try to create temporary file. */ ,     if (lockfd < 0) {			/* Create failed. */0 	debug(F111,"ttlock creat failed",tmpnam,errno); 	if (errno == ENOENT) {  	    perror(lockdir);	    < 	    printf("UUCP not installed or Kermit misconfigured\n");	 	} else {  	    perror(lockdir); : 	    unlink(tmpnam);		/* Get rid of the temporary file. */ 	}+ 	priv_off();			/* Turn off privileges!!! */ ) 	return(-1);			/* Return failure code. */      } *     debug(F110,"TTLOCK temp ok",tmpnam,0);  A /* Now write our pid into the temp lockfile in integer format. */   1     i = write(lockfd, (char *)&pid, sizeof(pid));    #ifdef DEBUG     if (deblog) { ! 	debug(F101,"TTLOCK pid","",pid); 0 	debug(F101,"TTLOCK sizeof pid","",sizeof(pid));- 	debug(F101,"TTLOCK write pid returns","",i);      }  #endif /* DEBUG */   /*A   Now try to rename the temporary file to the real lockfile name. B   This will fail if a lock file of that name already exists, which.   will catch race conditions with other users. */3     close(lockfd);			/* Close the temp lockfile. */      chmod(tmpnam,0444);        tries = 0;%     while (!haslock && tries++ < 2) { A 	haslock = (link(tmpnam,flfnam) == 0); /* Create a link to it. */ & 	debug(F101,"TTLOCK link","",haslock);2 	if (haslock) {			/* If we made the lockfile... */   7 #ifndef NOLOCKF				/* Can be canceled with -DNOLOCKF */  /*D   Create an advisory lock on the device through its file descriptor.H   This code actually seems to work.  If it is executed, and then anotherL   process tries to open the same device under a different name to circumvent/   the lockfile, they get a "device busy" error.  */- 	    debug(F100,"TTLOCK LOCKF code...","",0); 6             while ( lockf(ttyfd, F_TLOCK, 0L) != 0 ) {=                 debug(F111, "TTLOCK lockf error", "", errno); <                 if ( (++tries >= 3) || (errno != EAGAIN) ) {A                     x = unlink(flfnam); /* Remove the lockfile */  		    if (errno == EACCES)= 		      printf("Device already locked by another process\n");                       haslock = 0; 		    break; 		}                  sleep(2);  	    } #endif /* NOLOCKF */  6 	    if (haslock) {		/* If we made the lockfile ... */9 		if (lock2[0]) {		/* if there is to be a 2nd lockfile */ 2 		    lockfd = creat(lock2, 0444); /* Create it */6 		    debug(F111,"TTLOCK lock2 creat", lock2, lockfd);5 		    if (lockfd > -1) {	/* Created OK, write pid. */ - 			write(lockfd, (char *)&pid, sizeof(pid) ); ! 			close(lockfd);	/* Close and */ - 			chmod(lock2, 0444); /* set permissions. */ . 		    } else {		 /* Not OK, but don't fail. */7 			lock2[0] = '\0'; /* Just remember it's not there. */  		    }  		}   		break;			/* and we're done. */ 	    } 	}     } :     unlink(tmpnam);			/* Unlink (remove) the temp file. */'     priv_off();				/* Turn off privs */ 1     i = haslock ? 0 : -1;		/* Our return value */ &     debug(F101,"TTLOCK returns","",i);     return(i); #endif /* HPUX10 */  #endif /* !NOUUCP */ }    /*  T T U N L O C K  */   
 static intF ttunlck() {                             /* Remove UUCP lockfile(s). */ #ifndef NOUUCP       if (haslock && *flfnam) { ( 	priv_on();			/* Turn privileges on.  */4 	if (unlink(flfnam) < 0)		/* Remove the lockfile. */; 	  printf("Warning - Can't remove lockfile: %s\n", flfnam); ( 	*flfnam = '\0';			/* Erase the name. */   #ifdef RTAIX7 	if (unlink(lkflfn) < 0)		/* Remove link to lockfile */ E 	  printf("Warning - Can't remove secondary lockfile: %s\n", lkflfn);  	*lkflfn = '\0'; #else 
 #ifdef HPUX10 7 	if (lock2[0]) {			/* If there is a second lockfile, */ 1 	    if (unlink(lock2) < 0)	/*  remove it too. */ G 	      printf("Warning - Can't remove secondary lockfile: %s\n",lock2); - 	    lock2[0] = '\0';		/* Forget its name. */  	} #endif /* HPUX10 */  #endif /* RTAIX */   #ifdef LOCKF #ifdef F_ULOCKD         (VOID) lockf(ttyfd, F_ULOCK, 0L); /* Remove advisory lock */ #endif /* F_ULOCK */ #endif /* LOCKF */) 	priv_off();			/* Turn privileges off. */      }  #endif /* !NOUUCP */     return(0); }    /*+   4.3BSD-style UUCP line direction control. *   (Stan Barber, Rice U, 1980-something...) */ #ifndef NOUUCP #ifdef ACUCNTRL  VOID, acucntrl(flag,ttname) char *flag, *ttname; {,     char x[DEVNAMLEN+32], *device, *devname;  F     if (strcmp(ttname,CTTNAM) == 0 || xlocal == 0) /* If not local, */#       return;				/* just return. */ K     device = ((devname = xxlast(ttname,'/')) != NULL ? devname+1 : ttname); 4     if (strncmp(device,"LCK..",4) == 0) device += 5;:     sprintf(x,"/usr/lib/uucp/acucntrl %s %s",flag,device);     debug(F110,"called ",x,0);     zsyscmd(x);  }  #endif /* ACUCNTRL */  #endif /* NOUUCP */    /*8   T T H F L O W  --  Set or Reset hardware flow control.  F   This is an attempt to collect all hardware-flow-control related codeI   into a single module.  Thanks to Rick Sladkey and John Kohl for lots of    help here.  Overview:   J   Hardware flow control is not supported in many UNIX implementions.  EvenJ   when it is supported, there is no (ha ha) "standard" for the programmingK   interface.  In general, 4.3BSD and earlier (sometimes), 4.4BSD, System V, F   SunOS, AIX, etc, have totally different methods.  (And, not strictlyN   relevant here, the programming interface often brings one only to a no-op in   the device driver!)   K   Among all these, we have two major types of APIs: those in which hardware J   flow control is determined by bits in the same termio/termios/sgtty modeM   word(s) that are used for controlling such items as CBREAK vs RAW mode, and L   which are also used by the ttvt(), ttpkt(), conbin(), and concb() routinesE   for changing terminal modes.  And those that use entirely different 
   mechanisms.   L   In the first category, it is important that any change in the mode bits beI   reflected in the relevant termio(s)/sgtty structure, so that subsequent N   changes to that structure do not wipe out the effects of this routine.  ThatF   is why a pointer, attrs, to the appropriate structure is passed as a   parameter to this routine.  N   The second category should give us no worries, since any changes to hardwareL   flow control accomplished by this routine should not affect the termio(s)/N   sgtty structures, and therefore will not be undone by later changes to them.  H   The second argument, status, means to turn on hardware flow control if&   nonzero, and to turn it off if zero.  '   Returns: 0 on success, -1 on failure.  */
 static int tthflow(flow, status, attrs)6     int flow,				/* Type of flow control (ckcdeb.h) */)     status;				/* Nonzero = turn it on */  					/* Zero = turn it off */ * #ifdef BSD44ORPOSIX			/* POSIX or BSD44 */     struct termios *attrs; #else					/* System V */ #ifdef ATTSV     struct termio *attrs;  #else					/* BSD, V7, etc */.     struct sgttyb *attrs;		/* sgtty info... */ #endif /* ATTSV */ #endif /* BSD44ORPOSIX */  /* tthflow */ {   -     int x = 0;				/* tthflow() return code */   * #ifndef OXOS				/* NOT Olivetti X/OS... */ /*4   For SunOS 4.0 and later in the BSD environment ...  M   The declarations are copied and interpreted from the System V header files, J   so we don't actually have to pull in all the System V junk when buildingM   C-Kermit for SunOS in the BSD environment, which would be dangerous because M   having those symbols defined would cause us to take the wrong paths through M   the code.  The code in this section is used in both the BSD and Sys V SunOS    versions.  */ #ifdef SUNOS41 /*H   In SunOS 4.1 and later, we use the POSIX calls rather than ioctl callsN   because GNU CC uses different formats for the _IOxxx macros than regular CC;J   the POSIX forms work for both.  But the POSIX calls are not available in   SunOS 4.0. */6 #define CRTSCTS 0x80000000		/* RTS/CTS flow control */# #define TCSANOW 0			/* Do it now */        struct termios {* 	unsigned long c_iflag;		/* Input modes */+ 	unsigned long c_oflag;		/* Output modes */ , 	unsigned long c_cflag;		/* Control modes */4 	unsigned long c_lflag;		/* Line discipline modes */
 	char c_line;  	CHAR c_cc[17];      };     struct termios temp;  4 _PROTOTYP( int tcgetattr, (int, struct termios *) );9 _PROTOTYP( int tcsetattr, (int, int, struct termios *) );  /*G   When CRTSCTS is set, SunOS won't do output unless both CTS and CD are I   asserted.  So we don't set CRTSCTS unless CD is up.  This should be OK, L   since we don't need RTS/CTS during dialing, and after dialing is complete,H   we should have CD.  If not, we still communicate, but without RTS/CTS. */+     int mflags;				/* Modem signal flags */ -     if (!status) {			/* Turn hard flow off */ @ 	if (tcgetattr(ttyfd, &temp) > -1 && /* Get device attributes */8 	    (temp.c_cflag & CRTSCTS)) { /* Check for RTS/CTS */: 	    temp.c_cflag &= ~CRTSCTS;	/* It's there, remove it */( 	    x = tcsetattr(ttyfd,TCSANOW,&temp); 	}'     } else {				/* Turn hard flow on */ B 	if (ioctl(ttyfd,TIOCMGET,&mflags) > -1 && /* Get modem signals */0 	    (mflags & TIOCM_CAR)) {		/* Check for CD */- 	    debug(F100,"tthflow SunOS has CD","",0); D 	    if (tcgetattr(ttyfd, &temp) > -1 && /* Get device attributes */6 		!(temp.c_cflag & CRTSCTS)) { /* Check for RTS/CTS */2 		temp.c_cflag |= CRTSCTS;	/* Not there, add it */% 		x = tcsetattr(ttyfd,TCSANOW,&temp);  	    }	 	} else {  	    x = -1;, 	    debug(F100,"tthflow SunOS no CD","",0); 	}     }  #else 
 #ifdef QNX     struct termios temp;C     if (tcgetattr(ttyfd, &temp) > -1) {	/* Get device attributes */ * 	if (!status) {			/* Turn hard flow off */? 	    if ((temp.c_cflag & (IHFLOW|OHFLOW)) == (IHFLOW|OHFLOW)) { ? 		temp.c_cflag &= ~(IHFLOW|OHFLOW); /* It's there, remove it */ % 		attrs->c_cflag &= ~(IHFLOW|OHFLOW); % 		x = tcsetattr(ttyfd,TCSANOW,&temp);  	    }# 	} else {			/* Turn hard flow on */ ? 	    if ((temp.c_cflag & (IHFLOW|OHFLOW)) != (IHFLOW|OHFLOW)) { : 		temp.c_cflag |= (IHFLOW|OHFLOW); /* Not there, add it */: 		temp.c_iflag &= ~(IXON|IXOFF);   /* Bye to IXON/IXOFF */3 		ttraw.c_lflag |= IEXTEN;         /* Must be on */ % 		x = tcsetattr(ttyfd,TCSANOW,&temp); $ 		attrs->c_cflag |= (IHFLOW|OHFLOW);" 		attrs->c_iflag &= ~(IXON|IXOFF); 	    } 	}     } else { 	x = -1;1 	debug(F100, "tthflow QNX getattr fails", "", 0);      }  #else  #ifdef POSIX_CRTSCTS /*=   POSIX_CRTSCTS is defined in ckcdeb.h or on CC command line. 1   Note: Do not assume CRTSCTS is a one-bit field!  */     struct termios temp;C     if (tcgetattr(ttyfd, &temp) > -1) {	/* Get device attributes */ * 	if (!status) {			/* Turn hard flow off */G 	    if ((temp.c_cflag & CRTSCTS) == CRTSCTS) { /* Check for RTS/CTS */ 7 		temp.c_cflag &= ~CRTSCTS;	/* It's there, remove it */  		attrs->c_cflag &= ~CRTSCTS; % 		x = tcsetattr(ttyfd,TCSANOW,&temp);  	    }# 	} else {			/* Turn hard flow on */ / 	    if ((temp.c_cflag & CRTSCTS) != CRTSCTS) { 2 		temp.c_cflag |= CRTSCTS; /* Not there, add it */> 		temp.c_iflag &= ~(IXON|IXOFF|IXANY); /* Bye to IXON/IXOFF */% 		x = tcsetattr(ttyfd,TCSANOW,&temp);  		attrs->c_cflag |= CRTSCTS;( 		attrs->c_iflag &= ~(IXON|IXOFF|IXANY); 	    } 	}     } else { 	x = -1;5 	debug(F100, "tthflow POSIX_CRTSCTS no attr", "", 0);      }  #else 
 #ifdef SUNOS4  /*D   SunOS 4.0 (and maybe earlier?).  This code is dangerous because itI   prevents compilation with GNU gcc, which uses different formats for the H   _IORxxx macros than regular cc.  SunOS 4.1 and later can use the POSIX1   routines above, which work for both cc and gcc.  */M #define TCGETS _IOR(T, 8, struct termios) /* Get modes into termios struct */ M #define TCSETS _IOW(T, 9, struct termios) /* Set modes from termios struct */ 8 #define CRTSCTS 0x80000000		  /* RTS/CTS flow control */   	struct termios { . 	    unsigned long c_iflag;		/* Input modes *// 	    unsigned long c_oflag;		/* Output modes */ 0 	    unsigned long c_cflag;		/* Control modes */8 	    unsigned long c_lflag;		/* Line discipline modes */ 	    char c_line;  	    CHAR c_cc[17];  	};  	struct termios temp; @ 	if (ioctl(ttyfd,TCGETS,&temp) > -1) {	/* Get terminal modes. */, 	    if (status) {			/* Turn hard flow on */5 		temp.c_cflag |= CRTSCTS;	/* Add RTS/CTS to them. */ 6 		x = ioctl(ttyfd,TCSETS,&temp);	/* Set them again. */6 		attrs->c_cflag |= CRTSCTS;	/* Add to global info. */) 	    } else {				/* Turn hard flow off */  		temp.c_cflag &= ~CRTSCTS;   		x = ioctl(ttyfd,TCSETS,&temp); 		attrs->c_cflag &= ~CRTSCTS;  	    } 	}& #else					/* Not SunOS 4.0 or later */% #ifdef AIXRS				/* IBM AIX RS/6000 */ / #ifndef AIX41				/* But only pre-4.x == SVR4 */      if (status) { > 	if ((x = ioctl(ttyfd, TXADDCD, "rts")) < 0 && errno != EBUSY)5 	  debug(F100,"hardflow TXADDCD (rts) error", "", 0);      } else {? 	if ((x = ioctl(ttyfd, TXDELCD, "rts")) < 0 && errno != EINVAL) 5 	  debug(F100,"hardflow TXDELCD (rts) error", "", 0);      }  #endif /* AIX41 */ #else					/* Not AIX RS/6000 */   ! #ifdef ATTSV				/* System V... */    #ifdef M_UNIX				/* SCO UNIX */ . #ifdef POSIX				/* SCO - POSIX untested !!! */     struct termios temp;,     if ((x = tcgetattr(ttyfd, &temp)) == -1) #else  /* POSIX */     struct termio temp; 0     if ((x = ioctl(ttyfd, TCGETA, &temp)) == -1) #endif /* POSIX */     { 3 	debug(F100,"SCO hardflow get modes error", "", 0);      } else {! 	if (status) {			/* Turn it ON */ % 	    temp.c_cflag |= RTSFLOW|CTSFLOW; ' 	    attrs->c_cflag |= RTSFLOW|CTSFLOW; 
 #ifdef ORTSFL  	    temp.c_cflag &= ~ORTSFL;  	    attrs->c_cflag &= ~ORTSFL;  #endif /* ORTSFL */ ) 	    temp.c_iflag &= ~(IXON|IXOFF|IXANY); + 	    attrs->c_iflag &= ~(IXON|IXOFF|IXANY);  	} else {			/* Turn it OFF */ 
 #ifdef ORTSFL / 	    temp.c_cflag &= ~(RTSFLOW|CTSFLOW|ORTSFL); 1 	    attrs->c_cflag &= ~(RTSFLOW|CTSFLOW|ORTSFL);  #else  /* ORTSFL */ ( 	    temp.c_cflag &= ~(RTSFLOW|CTSFLOW);* 	    attrs->c_cflag &= ~(RTSFLOW|CTSFLOW); #endif /* ORTSFL */  	}	 	if ((x =  #ifdef POSIX 	tcsetattr(ttyfd, &temp) #else  	ioctl(ttyfd, TCSETA, &temp) #endif /* POSIX */ 	)  == -1 ) 5 	  debug(F100,"SCO hardflow set modes error", "", 0);      }  #else /* Not SCO UNIX */&     if (!status) {			/* Turn it OFF */ #ifdef RTSXOFF. 	debug(F100,"tthflow ATTSV RTS/CTS OFF","",0);$ 	rctsx.x_hflag &= ~(RTSXOFF|CTSXON);  	x = ioctl(ttyfd,TCSETX,&rctsx);. 	debug(F101,"tthflow ATTSV RTSXOFF OFF","",x); #endif /* RTSXOFF */ #ifdef DTRXOFF- 	debug(F100,"tthflow ATTSV DTR/CD OFF","",0); # 	rctsx.x_hflag &= ~(DTRXOFF|CDXON);   	x = ioctl(ttyfd,TCSETX,&rctsx);. 	debug(F101,"tthflow ATTSV DTRXOFF OFF","",x); #endif /* DTRXOFF */!     } else {				/* Turn it ON. */ 6 	if (flow == FLO_RTSC) {	/* RTS/CTS Flow control... */ #ifdef RTSXOFF: 	    /* This is the preferred way, according to SVID R4 */+ 	    if (ioctl(ttyfd,TCGETX,&rctsx) > -1) { . 		debug(F100,"tthflow ATTSV RTS/CTS ON","",0);$ 		rctsx.x_hflag |= RTSXOFF | CTSXON;! 		x = ioctl(ttyfd,TCSETX,&rctsx);  	    } #else  	    x = -1; #endif /* RTSXOFF */< 	} else if (flow == FLO_DTRC) {	/* DTR/CD Flow control... */ #ifdef DTRXOFF* 	    /* This is straight out of SVID R4 */+ 	    if (ioctl(ttyfd,TCGETX,&rctsx) > -1) { - 		debug(F100,"tthflow ATTSV DTR/CD ON","",0); $ 		rctsx.x_hflag &= ~(DTRXOFF|CDXON);! 		x = ioctl(ttyfd,TCSETX,&rctsx);  	    } #else  	    x = -1; #endif /* DTRXOFF */ 	}     }  #endif /* M_UNIX (SCO) */    #else /* not System V... */    #ifdef CK_DTRCTS
 #ifdef LDODTR 
 #ifdef LDOCTS 3     x = LDODTR | LDOCTS;		/* Found only on UTEK? */ E     if (flow == FLO_DTRT && status) {	/* Use hardware flow control */  	if (lmodef) {" 	    x = ioctl(ttyfd,TIOCLBIS,&x); 	    if (x < 0) { 4 	        debug(F100,"hardflow TIOCLBIS error","",0);
 	    } else {  		lmodef++; * 		debug(F100,"hardflow TIOCLBIS ok","",0); 	    } 	}     } else { 	if (lmodef) {" 	    x = ioctl(ttyfd,TIOCLBIC,&x); 	    if (x < 0) { 4 	        debug(F100,"hardflow TIOCLBIC error","",0);
 	    } else {  		lmodef++; * 		debug(F100,"hardflow TIOCLBIC ok","",0); 	    } 	}     }  #endif /* LDODTR */  #endif /* LDOCTS */  #endif /* CK_DTRCTS */ #endif /* ATTSV */ #endif /* AIXRS */ #endif /* SUNOS4 */  #endif /* QNX */ #endif /* POSIX_CRTSCTS */ #endif /* SUNOS41 */   #else /* OXOS */  1     struct termios temp;		/* Olivetti X/OS ... */   "     x = ioctl(ttyfd,TCGETS,&temp);     if (x == 0) { = 	temp.c_cflag &= ~(CRTSCTS|CDTRCTS|CBRKFLOW|CDTRDSR|CRTSDSR);  	if (status) { 	    switch (flow) {C 	      case FLO_RTSC: temp.c_cflag |= CRTSCTS; /* RTS/CTS (hard) */  		break;C 	      case FLO_DTRT: temp.c_cflag |= CDTRCTS; /* DTR/CTS (hard) */  		break; 	    } 	} 	x = ioctl(ttyfd,TCSETS,&temp);      }  #endif /* OXOS */      return(x); }   B /*  T T P K T  --  Condition the communication line for packets */* /*                 or for modem dialing */   /*0   If called with speed > -1, also set the speed.&   Returns 0 on success, -1 on failure.  F   NOTE: the "xflow" parameter is supposed to be the currently selectedJ   type of flow control, but for historical reasons, this parameter is alsoF   used to indicate that we are dialing.  Therefore, when the true flowK   control setting is needed, we access the external variable "flow", rather %   than trusting our "xflow" argument.  */ int  #ifdef CK_ANSIC ( ttpkt(long speed, int xflow, int parity) #else 8 ttpkt(speed,xflow,parity) long speed; int xflow, parity; #endif /* CK_ANSIC */ 
 /* ttpkt */ {  #ifndef NOLOCAL      int s2;      int s = -1;  #endif /* NOLOCAL */ #ifndef SVORPOSIX 
     int x; #endif /* SVORPOSIX */6     extern int flow;			/* REAL flow-control setting */  7     if (ttyfd < 0) return(-1);          /* Not open. */   )     debug(F101,"ttpkt parity","",parity); '     debug(F101,"ttpkt xflow","",xflow); -     debug(F101,"ttpkt speed","",(int) speed);   O     ttprty = parity;                    /* Let other tt functions see these. */ .     ttpflg = 0;				/* Parity not sensed yet */>     ttpmsk = ttprty ? 0177 : 0377;	/* Parity stripping mask */=     ttspeed = speed;			/* Make global copy for this module */   0 #ifdef NETCONN				/* Nothing to do for telnet */     if (netconn) return (0); #endif /* NETCONN */  -     if (ttfdflg && !isatty(ttyfd)) return(0);    #ifdef COHERENT  #define SVORPOSIX  #endif /* COHERENT */   , #ifndef SVORPOSIX			/* Berkeley, V7, etc. */
 #ifdef LPASS8  /*K  For some reason, with BSD terminal drivers, you can't set FLOW to XON/XOFF I  after having previously set it to NONE without closing and reopening the 8  device.  Unless there's something I overlooked below... */@     if (ttflow == FLO_NONE && flow == FLO_XONX && xlocal == 0) {9 	debug(F101,"ttpkt executing horrible flow kludge","",0);  	ttclos(0);			/* Close it */ 	x = 0; / 	ttopen(ttnmsv,&x,ttmdm,0);	/* Open it again */      }  #endif /* LPASS8 */  #endif /* SVORPOSIX */   #ifdef COHERENT  #undef SVORPOSIX #endif /* COHERENT */   /     if (xflow != FLO_DIAL && xflow != FLO_DIAX) :       ttflow = xflow;			/* Now make this available too. */   #ifndef NOLOCAL      if (xlocal) { 3 	s2 = (int) (speed / 10L);	/* Convert bps to cps */ 0 	s = ttsspd(s2);			/* Check and set the speed */& 	debug(F101,"ttpkt carrier","",xflow);9  	carrctl(&ttraw, xflow != FLO_DIAL /* Carrier control */  		&& (ttcarr == CAR_ON)); 2 	tvtflg = 0;			/* So ttvt() will work next time */     }  #endif /* NOLOCAL */   #ifdef COHERENT  #define SVORPOSIX  #endif /* COHERENT */   % #ifndef SVORPOSIX			/* BSD section */ 8     if (flow == FLO_RTSC ||		/* Hardware flow control */ 	flow == FLO_DTRC || 	flow == FLO_DTRT) { 	tthflow(flow, 1, &ttraw);8 	debug(F100,"ttpkt hard flow, TANDEM off, RAW on","",0);@ 	ttraw.sg_flags &= ~TANDEM;	/* Turn off software flow control */- 	ttraw.sg_flags |= RAW;		/* Enter raw mode */ 8     } else if (flow == FLO_NONE) {	/* No flow control */6 	debug(F100,"ttpkt no flow, TANDEM off, RAW on","",0);@ 	ttraw.sg_flags &= ~TANDEM;	/* Turn off software flow control */> 	tthflow(flow, 0, &ttraw);	/* Turn off any hardware f/c too */- 	ttraw.sg_flags |= RAW;		/* Enter raw mode */ G     } else if (flow == FLO_KEEP) {	/* Keep device's original setting */ 2 	debug(F100,"ttpkt keeping original TANDEM","",0); 	ttraw.sg_flags &= ~TANDEM; - 	ttraw.sg_flags |= (ttold.sg_flags & TANDEM); > 	/* NOTE: We should also handle hardware flow control here! */     }   K /* SET FLOW XON/XOFF is in effect, or SET FLOW KEEP resulted in Xon/Xoff */   :     if ((flow == FLO_XONX) || (ttraw.sg_flags & TANDEM)) {, 	debug(F100,"ttpkt turning on TANDEM","",0);/ 	ttraw.sg_flags |= TANDEM;	/* So ask for it. */   3 #ifdef LPASS8				/* Can pass 8-bit data through? */ J /* If the LPASS8 local mode is available, then flow control can always  */J /* be used, even if parity is none and we are transferring 8-bit data.  */? /* But we only need to do all this if Xon/Xoff is requested. */ K /* BUT... this tends not to work through IP or LAT connections, terminal */ @ /* servers, telnet, rlogin, etc, so it is currently disabled. */, 	x = LPASS8;			/* If LPASS8 defined, then */0 	debug(F100,"ttpkt executing LPASS8 code","",0);, 	if (lmodef) {			/* TIOCLBIS must be too. */; 	    x = ioctl(ttyfd,TIOCLBIS,&x); /* Try to set LPASS8. */  	    if (x < 0) { * 		debug(F100,"ttpkt TIOCLBIS error","",0);
 	    } else {  		lmodef++; ' 		debug(F100,"ttpkt TIOCLBIS ok","",0);  	    } 	} /*7  But if we use LPASS8 mode, we must explicitly turn off "  terminal interrupts of all kinds. */% #ifdef TIOCGETC				/* Not rawmode, */ 3 	if (tcharf && (xlocal == 0)) {	/* must turn off */ 3 	    tchnoi.t_intrc = -1;	/* interrupt character */ 3 	    tchnoi.t_quitc = -1;	/* and quit character. */ . 	    tchnoi.t_startc = 17;	/* Make sure xon */5 	    tchnoi.t_stopc = 19;	/* and xoff not ignored. */  #ifndef NOBRKC/ 	    tchnoi.t_eofc = -1;		/* eof character. */  / 	    tchnoi.t_brkc = -1;		/* brk character. */   #endif /* NOBRKC */ - 	    if (ioctl(ttyfd,TIOCSETC,&tchnoi) < 0) { + 		debug(F100,"ttpkt TIOCSETC failed","",0); 
 	    } else { 
 		tcharf = 1; ' 		debug(F100,"ttpkt TIOCSETC ok","",0);  	    } #ifdef COMMENT! /* only for paranoid debugging */  	    if (tcharf) { 		struct tchars foo; 		char tchbuf[100];  		ioctl(0,TIOCGETC,&foo);  		sprintf(tchbuf, ; 		    "intr=%d,quit=%d, start=%d, stop=%d, eof=%d, brk=%d", - 		    foo.t_intrc, foo.t_quitc, foo.t_startc, , 		    foo.t_stopc, foo.t_eofc,  foo.t_brkc);% 		debug(F110,"ttpkt chars",tchbuf,0);  	    } #endif /* COMMENT */ 	}: 	ttraw.sg_flags |= CBREAK;	/* Needed for unknown reason */ #endif /* TIOCGETC */   ( /* Prevent suspend during packet mode */% #ifdef TIOCGLTC				/* Not rawmode, */ 4 	if (ltcharf && (xlocal == 0)) {	/* must turn off */2 	    ltchnoi.t_suspc = -1;	/* suspend character */? 	    ltchnoi.t_dsuspc = -1;	/* and delayed suspend character */ - 	    if (ioctl(ttyfd,TIOCSLTC,&tchnoi) < 0) { + 		debug(F100,"ttpkt TIOCSLTC failed","",0); 
 	    } else {  		ltcharf = 1;' 		debug(F100,"ttpkt TIOCSLTC ok","",0);  	    } 	} #endif /* TIOCGLTC */    #else /* LPASS8 not defined */  2 /* Previously, BSD-based implementations always */L /* used rawmode for packets.  Now, we use rawmode only if parity is NONE. */M /* This allows the flow control requested above to actually work, but only */ N /* if the user asks for parity (which also means they get 8th-bit quoting). */  ! 	if (parity) {			/* If parity, */ 2 	    ttraw.sg_flags &= ~RAW;	/* use cooked mode */ #ifdef COMMENT /* WHY??? */ 	    if (xlocal) #endif /* COMMENT */  	      ttraw.sg_flags |= CBREAK;: 	    debug(F101,"ttpkt cooked, cbreak, parity","",parity);% #ifdef TIOCGETC				/* Not rawmode, */ 7 	    if (tcharf && (xlocal == 0)) { /* must turn off */ 0 		tchnoi.t_intrc = -1;	/* interrupt character */0 		tchnoi.t_quitc = -1;	/* and quit character. */+ 		tchnoi.t_startc = 17;	/* Make sure xon */ 2 		tchnoi.t_stopc = 19;	/* and xoff not ignored. */ #ifndef NOBRKC+ 		tchnoi.t_eofc = -1;	/* eof character. */  + 		tchnoi.t_brkc = -1;	/* brk character. */   #endif /* NOBRKC */ * 		if (ioctl(ttyfd,TIOCSETC,&tchnoi) < 0) {/ 		    debug(F100,"ttpkt TIOCSETC failed","",0); 
 		} else { 		    tcharf = 1; + 		    debug(F100,"ttpkt TIOCSETC ok","",0);  		}  	    } #endif /* TIOCGETC */ % #ifdef TIOCGLTC				/* Not rawmode, */ ( /* Prevent suspend during packet mode */8 	    if (ltcharf && (xlocal == 0)) { /* must turn off *// 		ltchnoi.t_suspc = -1;	/* suspend character */ < 		ltchnoi.t_dsuspc = -1;	/* and delayed suspend character */* 		if (ioctl(ttyfd,TIOCSLTC,&tchnoi) < 0) {/ 		    debug(F100,"ttpkt TIOCSLTC failed","",0); 
 		} else { 		    ltcharf = 1;+ 		    debug(F100,"ttpkt TIOCSLTC ok","",0);  		}  	    } #endif /* TIOCGLTC */  	} else {			/* If no parity, */ : 	    ttraw.sg_flags |= RAW;	/* must use 8-bit raw mode. */; 	    debug(F101,"ttpkt setting rawmode, parity","",parity);  	} #endif /* LPASS8 */ #     } /* End of Xon/Xoff section */   J     /* Don't echo, don't map CR to CRLF on output, don't fool with case */ #ifdef LCASE*     ttraw.sg_flags &= ~(ECHO|CRMOD|LCASE); #else $     ttraw.sg_flags &= ~(ECHO|CRMOD); #endif /* LCASE */  
 #ifdef TOWER1 I     ttraw.sg_flags &= ~ANYP;            /* Must set this on old Towers */  #endif /* TOWER1 */   D     if (stty(ttyfd,&ttraw) < 0) return(-1); /* Set the new modes. */%     debug(F100,"ttpkt stty ok","",0);    #ifdef sony_news?     x = xlocal ? km_ext : km_con;	/* Put line in ASCII mode. */ <     if (x != -1) {			/* Make sure we know original modes. */ 	x &= ~KM_TTYPE; 	x |= KM_ASCII; % 	if (ioctl(ttyfd,TIOCKSET, &x) < 0) { * 	    perror("ttpkt can't set ASCII mode");7 	    debug(F101,"ttpkt error setting ASCII mode","",x);  	    return(-1); 	}     } /     debug(F100,"ttpkt set ASCII mode ok","",0);  #endif /* sony_news */  9     if (xlocal == 0)			/* Turn this off so we can read */ B       signal(SIGINT,SIG_IGN);		/* Ctrl-C chars typed at console */  6     tvtflg = 0;				/* So ttvt() will work next time */     return(0);   #endif /* Not ATTSV or POSIX */    /* AT&T UNIX and POSIX */    #ifdef COHERENT  #define SVORPOSIX  #endif /* COHERENT */    #ifdef SVORPOSIX+     if (flow == FLO_XONX) {		/* Xon/Xoff */  	ttraw.c_iflag |= (IXON|IXOFF);  	tthflow(flow, 0, &ttraw);-     } else if (flow == FLO_NONE) {	/* None */ @ 	/* NOTE: We should also turn off hardware flow control here! */  	ttraw.c_iflag &= ~(IXON|IXOFF); 	tthflow(flow, 0, &ttraw);-     } else if (flow == FLO_KEEP) {	/* Keep */ > 	ttraw.c_iflag &= ~(IXON|IXOFF);	/* Turn off Xon/Xoff flags */F 	ttraw.c_iflag |= (ttold.c_iflag & (IXON|IXOFF)); /* OR in old ones */> 	/* NOTE: We should also handle hardware flow control here! */ #ifdef __linux__A /* In Linux case, we do this, which is unlikely to be portable */ >         ttraw.c_cflag &= ~CRTSCTS;	/* Turn off RTS/CTS flag */G         ttraw.c_cflag |= (ttold.c_cflag & CRTSCTS); /* OR in old one */  #endif /* __linux__ */1     } else if (flow == FLO_RTSC ||	/* Hardware */  	       flow == FLO_DTRC ||  	       flow == FLO_DTRT) { , 	ttraw.c_iflag &= ~(IXON|IXOFF);	/* (190) */ 	tthflow(flow, 1, &ttraw);     } $     ttraw.c_lflag &= ~(ICANON|ECHO);C     ttraw.c_lflag &= ~ISIG;		/* Do NOT check for interrupt chars */    #ifndef OXOS
 #ifdef QNXA     if (flow != FLO_RTSC && flow != FLO_DTRC && flow != FLO_DTRT)  #endif /* QNX */ #ifndef COHERENT@       ttraw.c_lflag &= ~IEXTEN;		/* Turn off ^O/^V processing */ #endif /* COHERENT */  #else /* OXOS */9     ttraw.c_cc[VDISCARD] = ttraw.c_cc[VLNEXT] = CDISABLE;  #endif /* OXOS */ /     ttraw.c_lflag |= NOFLSH;		/* Don't flush */ %     ttraw.c_iflag |= (BRKINT|IGNPAR);  #ifdef ATTSV #ifdef BSD44D     ttraw.c_iflag &= ~(IGNBRK|INLCR|IGNCR|ICRNL|INPCK|ISTRIP|IXANY); #else J     ttraw.c_iflag &= ~(IGNBRK|INLCR|IGNCR|ICRNL|IUCLC|INPCK|ISTRIP|IXANY); #endif /* BSD44 */ #else /* POSIX */ >     ttraw.c_iflag &= ~(IGNBRK|INLCR|IGNCR|ICRNL|INPCK|ISTRIP); #endif /* ATTSV */     ttraw.c_oflag &= ~OPOST;%     ttraw.c_cflag &= ~(CSIZE|PARENB); '     ttraw.c_cflag |= (CS8|CREAD|HUPCL);  #ifdef IX370J     ttraw.c_cc[4] = 48;  /* So Series/1 doesn't interrupt on every char */     ttraw.c_cc[5] = 1; #elsea2 #ifndef VEOF	/* for DGUX this is VEOF, not VMIN */L     ttraw.c_cc[4] = 1;   /* [VMIN]  return max of this many characters or */ #elset #ifndef OXOS #ifdef VMINh     ttraw.c_cc[VMIN] = 1;s #endif /* VMIN */n #else /* OXOS */     ttraw.c_min = 1; #endif /* OXOS */r #endif /* VEOF */s3 #ifndef VEOL	/* for DGUX this is VEOL, not VTIME */ N     ttraw.c_cc[5] = 0;	 /* [VTIME] when this many secs/10 expire w/no input */ #else  #ifndef OXOS #ifdef VTIME     ttraw.c_cc[VTIME] = 0; #endif /* VTIME */ #else /* OXOS */     ttraw.c_time = 0;d #endif /* OXOS */s #endif /* VEOL */. #endif /* IX370 */  2 #ifdef VINTR				/* Turn off interrupt character */8     if (xlocal == 0)			/* so ^C^C can break us out of */0       ttraw.c_cc[VINTR] = 0;		/* packet mode. */ #endif /* VINTR */   #ifdef BSD44ORPOSIXn:     if (tcsetattr(ttyfd,TCSADRAIN,&ttraw) < 0) return(-1); #else /* ATTSV */yK     if (ioctl(ttyfd,TCSETAW,&ttraw) < 0) return(-1);  /* set new modes . */s #endif /* BSD44ORPOSIX */m     tvtflg = 0;d     return(0); #endif /* ATTSV */   #ifdef COHERENT  #undef SVORPOSIX #endif /* COHERENT */b   }d  K /*  T T V T -- Condition communication line for use as virtual terminal  */    #ifndef NOLOCALc int< #ifdef CK_ANSICt ttvt(long speed, int flow) #else6& ttvt(speed,flow) long speed; int flow; #endif /* CK_ANSIC */  /* ttvt */ {     int s, s2;  &     debug(F101,"ttvt ttyfd","",ttyfd);(     debug(F101,"ttvt tvtflg","",tvtflg);&     debug(F101,"ttvt speed","",speed);$     debug(F101,"ttvt flow","",flow);7     if (ttyfd < 0) return(-1);          /* Not open. */I #ifdef NETCONN     if (netconn) {( 	tvtflg = 1;			/* Network connections */9 	debug(F100,"ttvt network connection, skipping...","",0);(, 	return(0);			/* require no special setup */     }e #endif /* NETCONN */  O     if (tvtflg != 0 && speed == ttspeed && flow == ttflow && ttcarr == curcarr)        {t: 	  debug(F100,"ttvt modes already set, skipping...","",0);* 	  return(0);			/* Already been called. */       }*  $     if (ttfdflg && !isatty(ttyfd)) {8 	debug(F100,"ttvt using external fd, skipping...","",0); 	return(0);      }c  -     debug(F100,"ttvt setting modes...","",0);m  /     if (xlocal) {			/* For external lines... *// 	s2 = (int) (speed / 10L);, 	s = ttsspd(s2);			/* Check/set the speed */: 	carrctl(&tttvt, flow != FLO_DIAL /* Do carrier control */> 		&& (ttcarr == CAR_ON || (ttcarr == CAR_AUT && ttmdm != 0)));
     } else       s = s2 = -1;   #ifdef COHERENTs #define SVORPOSIXX #endif /* COHERENT */    #ifndef SVORPOSIXc     /* Berkeley, V7, etc */ 8     if (flow == FLO_RTSC ||		/* Hardware flow control */ 	flow == FLO_DTRC || 	flow == FLO_DTRT)       tthflow(flow, 1, &tttvt);/8     if (flow == FLO_XONX) {		/* Xon/Xoff flow control */, 	tttvt.sg_flags |= TANDEM;	/* Ask for it. */6 	tthflow(flow, 0, &tttvt);	/* Turn off hardware f/c */"     } else if (flow == FLO_KEEP) { 	tttvt.sg_flags &= ~TANDEM;e- 	tttvt.sg_flags |= (ttold.sg_flags & TANDEM);C> 	/* NOTE: We should also handle hardware flow control here! */"     } else if (flow == FLO_NONE) {- 	tttvt.sg_flags &= ~TANDEM;	/* No Xon/Xoff */f6 	tthflow(flow, 0, &tttvt);	/* Turn off hardware f/c */     }UC     tttvt.sg_flags |= RAW;              /* Raw mode in all cases */*
 #ifdef TOWER1L?     tttvt.sg_flags &= ~(ECHO|ANYP);     /* No echo or parity */S #elsen5     tttvt.sg_flags &= ~ECHO;            /* No echo */i #endif /* TOWER1 */   8     if (stty(ttyfd,&tttvt) < 0)		/* Set the new modes */       return(-1);l    #else /* It is ATTSV or POSIX */  8     if (flow == FLO_RTSC ||		/* Hardware flow control */ 	flow == FLO_DTRC || 	flow == FLO_DTRT) { 	tthflow(flow, 1, &tttvt);>     } else if (flow == FLO_XONX) {	/* Software flow control */6 	tttvt.c_iflag |= (IXON|IXOFF);	/* On if requested. */6 	tthflow(flow, 0, &tttvt);	/* Turn off hardware f/c */"     } else if (flow == FLO_KEEP) {> 	tttvt.c_iflag &= ~(IXON|IXOFF);	/* Turn off Xon/Xoff flags */F 	tttvt.c_iflag |= (ttold.c_iflag & (IXON|IXOFF)); /* OR in old ones */> 	/* NOTE: We should also handle hardware flow control here! */ #ifdef __linux__>         tttvt.c_cflag &= ~CRTSCTS;	/* Turn off RTS/CTS flag */G         tttvt.c_cflag |= (ttold.c_cflag & CRTSCTS); /* OR in old one */I #endif /* __linux__ */-     } else if (flow == FLO_NONE) {	/* NONE */O6 	tthflow(flow, 0, &tttvt);	/* Turn off hardware f/c */8 	tttvt.c_iflag &= ~(IXON|IXOFF);	/* Turn off Xon/Xoff */     }E   #ifndef OXOS #ifdef COHERENTV)     tttvt.c_lflag &= ~(ISIG|ICANON|ECHO);e #elseh0     tttvt.c_lflag &= ~(ISIG|ICANON|ECHO|IEXTEN); #endif /* COHERENT */e
 #ifdef QNX     /* Needed for hwfc */.A     if (flow == FLO_RTSC || flow == FLO_DTRC || flow == FLO_DTRT)c       tttvt.c_lflag |= IEXTEN; #endif /* QNX */ #else /* OXOS */)     tttvt.c_lflag &= ~(ISIG|ICANON|ECHO);d9     tttvt.c_cc[VDISCARD] = tttvt.c_cc[VLNEXT] = CDISABLE;f #endif /* OXOS */,%     tttvt.c_iflag |= (IGNBRK|IGNPAR);. #ifdef ATTSV #ifdef BSD44D     tttvt.c_iflag &= ~(INLCR|IGNCR|ICRNL|BRKINT|INPCK|ISTRIP|IXANY); #else J     tttvt.c_iflag &= ~(INLCR|IGNCR|ICRNL|IUCLC|BRKINT|INPCK|ISTRIP|IXANY); #endif /* BSD44 */ #else /* POSIX */a>     tttvt.c_iflag &= ~(INLCR|IGNCR|ICRNL|BRKINT|INPCK|ISTRIP); #endif /* ATTSV */     tttvt.c_oflag &= ~OPOST;%     tttvt.c_cflag &= ~(CSIZE|PARENB);Y'     tttvt.c_cflag |= (CS8|CREAD|HUPCL);IE #ifndef VEOF	/* DGUX termio has VEOF at entry 4, see comment above */n     tttvt.c_cc[4] = 1; #elseg #ifndef OXOS #ifdef VMINr     tttvt.c_cc[VMIN] = 1;g #endif /* VMIN */X #else /* OXOS */     tttvt.c_min = 1; #endif /* OXOS */n #endif /* VEOF */IE #ifndef VEOL	/* DGUX termio has VEOL at entry 5, see comment above */e     tttvt.c_cc[5] = 0; #else  #ifndef OXOS #ifdef VTIME     tttvt.c_cc[VTIME] = 0; #endif /* VTIME */ #else /* OXOS */     tttvt.c_time = 0;  #endif /* OXOS */i #endif /* VEOL */N   #ifdef BSD44ORPOSIXl:     if (tcsetattr(ttyfd,TCSADRAIN,&tttvt) < 0) return(-1); #else /* ATTSV */ K     if (ioctl(ttyfd,TCSETAW,&tttvt) < 0) return(-1);  /* set new modes . */d #endif /* BSD44ORPOSIX */  #endif /* ATTSV */  7     ttspeed = speed;			/* Done, remember how we were */S:     ttflow = flow;			/* called, so we can decide how to */+     tvtflg = 1;				/* respond next time. */X&     debug(F101,"ttvt done","",tvtflg);     return(0);   #ifdef COHERENTd #undef SVORPOSIX #endif /* COHERENT *//   }E #endif /* NOLOCAL */  ; /*  T T S S P D  --  Checks and sets transmission rate.  */C  < /*  Call with speed in characters (not bits!) per second. */M /*  Returns -1 on failure, 0 if it did nothing, 1 if it changed the speed. */G   #ifndef NOLOCALN int  ttsspd(cps) int cps; { #ifdef POSIXM /* Watch out, speed_t should be unsigned, so don't compare with -1, etc... */f     speed_t				  #else/     intN #endif /* POSIX */       s, s2;6     int ok = 1;				/* Speed check result, assume ok */  ! #ifdef __linux__			/* Linux... */' #ifdef ASYNC_SPD_MASKe     unsigned int spd_flags = 0;_!     struct serial_struct serinfo;s #endif /* ASYNC_SPD_MASK */_ #endif /* __linux__ */  $     debug(F101,"ttsspd cps","",cps);(     debug(F101,"ttsspd ttyfd","",ttyfd);*     debug(F101,"ttsspd xlocal","",xlocal);  C     if (ttyfd < 0 || xlocal == 0 )	/* Don't set speed on console *//       return(0);   #ifdef	NETCONN     if (netconn)       return(0); #endif	/* NETCONN */       if (cps < 0) return(-1);7     s = s2 = 0;				/* NB: s and s2 might be unsigned */2  4     /* First check that the given speed is valid. */       switch (cps) {
 #ifndef MINIX;!       case 0:   s = B0;    break;K!       case 5:   s = B50;   break;H!       case 7:   s = B75;   break;K #endif /* MINIX */!       case 11:  s = B110;  break;n
 #ifndef MINIXr!       case 15:  s = B150;  break; !       case 20:  s = B200;  break;s #endif /* MINIX */!       case 30:  s = B300;  break;l
 #ifndef MINIX !       case 60:  s = B600;  break;D #endif /* MINIX */!       case 120: s = B1200; break;l
 #ifndef MINIX/!       case 180: s = B1800; break;* #endif /* MINIX */!       case 240: s = B2400; break; !       case 480: s = B4800; break; 
 #ifndef MINIXRK       case 888: s = B75; s2 = B1200; break; /* 888 = 75/1200 split speed */o #endif /* MINIX */!       case 960: s = B9600; break; 
 #ifdef B14400E#       case 1440: s = B14400; break;f #endif /* B14400 */f
 #ifdef B19200e#       case 1920: s = B19200; break;  #else/ #ifdef EXTA !       case 1920: s = EXTA; break;4 #endif /* EXTA */C #endif /* B19200 */)
 #ifdef B28800d#       case 2880: s = B28800; break;  #endif /* B28800 */ 
 #ifdef B38400        case 3840: s = B38400; #ifdef __linux__ #ifdef ASYNC_SPD_MASK;B         spd_flags = ~ASYNC_SPD_MASK;	/* Nonzero, but zero flags */ #endif /* ASYNC_SPD_MASK */f #endif /* __linux__ */ 	break;y! #else /* B38400 not defined... */  #ifdef EXTB !       case 3840: s = EXTB; break;d #endif /* EXTB */L #endif /* B38400 */    #ifdef HPUX  #ifdef _B57600$       case 5760: s = _B57600; break; #endif /* _B57600 */ #ifdef _B115200V&       case 11520: s = _B115200; break; #endif /* _B115200 */  #else  #ifdef __linux__ #ifdef ASYNC_SPD_MASKb /*)   This bit from <carlo@sg.tn.tudelft.nl>:tN   "Only note to make is maybe this: When the ASYNC_SPD_CUST flags are set thenJ   setting the speed to 38400 will set the custom speed (and ttgspd returnsJ   38400), but speeds 57600 and 115200 won't work any more because I didn'tK   want to mess up the speed flags when someone is doing sophisticated stuffs   like custom speeds..." */=       case 5760: s = B38400; spd_flags = ASYNC_SPD_HI; break;t?       case 11520: s = B38400; spd_flags = ASYNC_SPD_VHI; break;  #endif /* ASYNC_SPD_MASK */  #else 
 #ifdef QNX
 #ifdef B57600 #       case 5760: s = B57600; break;e #endif /* B57600 */e
 #ifdef B76800m#       case 7680: s = B76800; break;s #endif /* B76800 */  #ifdef B115200%       case 11520: s = B115200; break;i #endif /* B115200 */ #else 
 #ifdef B57600o#       case 5760: s = B57600; break;, #endif /* B57600 */e #ifdef B115200%       case 11520: s = B115200; break;e #endif /* B115200 */ #endif /* QNX */ #endif /* __linux__ */ #endif /* HPUX */h       default:1 	ok = 0;				/* Good speed not found, so not ok */g 	break;g     }t"     debug(F101,"ttsspd ok","",ok);      debug(F101,"ttsspd s","",s);       if (!ok) {! 	debug(F100,"ttsspd fails","",0);  	return(-1);     } else { #ifdef BSD44ORPOSIXO 	int x;l #endif /* BSD44ORPOSIX */   ( 	if (!s2) s2 = s;		/* Set input speed */   #ifdef BSD44ORPOSIXr5 	x = tcgetattr(ttyfd,&ttcur);	/* Get current speed */ % 	debug(F101,"ttsspd tcgetattr","",x);t 	if (x < 0)l 	  return(-1); #ifdef __linux__ #ifdef ASYNC_SPD_MASK - 	debug(F101,"ttsspd spd_flags","",spd_flags); 0 	if (spd_flags && spd_flags != ASYNC_SPD_CUST) {3 	    if (ioctl(ttyfd, TIOCGSERIAL, &serinfo) < 0) {c0 		debug(F100,"ttsspd: TIOCGSERIAL failed","",0);
 		return(-1);e6 	    } else debug(F100,"ttsspd: TIOCGSERIAL ok","",0);& 	    serinfo.flags &= ~ASYNC_SPD_MASK;3 	    serinfo.flags |= (spd_flags & ASYNC_SPD_MASK);t1 	    if (ioctl(ttyfd, TIOCSSERIAL, &serinfo) < 0)  	      return(-1); 	} #endif /* ASYNC_SPD_MASK */  #endif /* __linux__ */ 	cfsetospeed(&ttcur,s);m 	cfsetispeed(&ttcur,s2); 	cfsetospeed(&ttraw,s);  	cfsetispeed(&ttraw,s2); 	cfsetospeed(&tttvt,s);  	cfsetispeed(&tttvt,s2); 	cfsetospeed(&ttold,s);t 	cfsetispeed(&ttold,s2);' 	x = tcsetattr(ttyfd,TCSADRAIN,&ttcur);t% 	debug(F101,"ttsspd tcsetattr","",x);r 	if (x < 0) return(-1);  #else  #ifdef ATTSV: 	if (cps == 888) return(-1);	/* No split speeds, sorry. */0 	if (ioctl(ttyfd,TCGETA,&ttcur) < 0) return(-1); 	ttcur.c_cflag &= ~CBAUD;  	ttcur.c_cflag |= s; 	tttvt.c_cflag &= ~CBAUD;  	tttvt.c_cflag |= s; 	ttraw.c_cflag &= ~CBAUD;y 	ttraw.c_cflag |= s; 	ttold.c_cflag &= ~CBAUD;  	ttold.c_cflag |= s;1 	if (ioctl(ttyfd,TCSETAW,&ttcur) < 0) return(-1);t #else-( 	if (gtty(ttyfd,&ttcur) < 0) return(-1);+ 	ttcur.sg_ospeed = s; ttcur.sg_ispeed = s2;y+ 	tttvt.sg_ospeed = s; tttvt.sg_ispeed = s2;n+ 	ttraw.sg_ospeed = s; ttraw.sg_ispeed = s2;e+ 	ttold.sg_ospeed = s; ttold.sg_ispeed = s2;-( 	if (stty(ttyfd,&ttcur) < 0) return(-1); #endif /* ATTSV */ #endif /* BSD44ORPOSIX */p     }i+     return(1);				/* Return 1 = success. */y }v #endif /* NOLOCAL */  ? /* T T G S P D  -  Get speed of currently selected tty line  */p   /*N   Unreliable.  After SET LINE, it returns an actual speed, but not necessarilyM   the real speed.  On some systems, it returns the line's nominal speed, from)L   /etc/ttytab.  Even if you SET SPEED to something else, this function might
   not notice.m */ long3 ttgspd() {				/* Get current serial device speed */t #ifdef POSIX'     speed_t				/* Should be unsigned */  #else       int					/* Isn't unsigned */ #endif /* POSIX */       s;     long ss; #ifdef __linux__ #ifdef ASYNC_SPD_MASKt     unsigned int spd_flags = 0; !     struct serial_struct serinfo;l #endif /* ASYNC_SPD_MASK */n #endif /* __linux__ */   #ifdef NETCONN<     if (netconn) return(-1);		/* -1 if network connection */ #endif /* NETCONN */  (     debug(F101,"ttgspd ttyfd","",ttyfd); #ifdef __linux__ #ifdef ASYNC_SPD_MASK ;     debug(F100,"ttgspd Linux ASYNC_SPD_MASK defined","",0);( #elseI?     debug(F100,"ttgspd Linux ASYNC_SPD_MASK not defined","",0);e #endif /* ASYNC_SPD_MASK */  #endif /* __linux__ */       if (ttyfd < 0) { #ifdef BSD44ORPOSIXo 	s = cfgetospeed(&ccold);o) 	debug(F101,"ttgspd cfgetospeed 1","",s);r #elsen #ifdef ATTSV 	s = ccold.c_cflag & CBAUD;n #else 2 	s = ccold.sg_ospeed;		/* (obtained by congm()) */ #endif /* ATTSV */ #endif /* BSD44ORPOSIX */(       } else { #ifdef BSD44ORPOSIXe- 	if (tcgetattr(ttyfd,&ttcur) < 0) return(-1);  	s = cfgetospeed(&ttcur);/) 	debug(F101,"ttgspd cfgetospeed 2","",s);  #ifdef __linux__ #ifdef ASYNC_SPD_MASKn, 	if (ioctl(ttyfd,TIOCGSERIAL,&serinfo) > -1). 	  spd_flags = serinfo.flags & ASYNC_SPD_MASK;- 	debug(F101,"ttgspd spd_flags","",spd_flags);d #endif /* ASYNC_SPD_MASK */4 #endif /* __linux__ */ #elsek #ifdef ATTSV0 	if (ioctl(ttyfd,TCGETA,&ttcur) < 0) return(-1); 	s = ttcur.c_cflag & CBAUD;  #elsen( 	if (gtty(ttyfd,&ttcur) < 0) return(-1); 	s = ttcur.sg_ospeed;* #endif /* ATTSV */ #endif /* BSD44ORPOSIX */      } #     debug(F101,"ttgspd code","",s);. #ifdef __linux__ #ifdef ASYNC_SPD_MASKO0     debug(F101,"ttgspd spd_flags","",spd_flags); #endif /* ASYNC_SPD_MASK */d #endif /* __linux__ */     switch (s) {	 #ifdef B0f!       case B0:    ss = 0L; break;  #endif /* B0 */   
 #ifndef MINIX  /*L  MINIX defines the Bxx symbols to be bps/100, so B50==B75, B110==B134==B150,I  etc, making for many "duplicate case in switch" errors, which are fatal.  */
 #ifdef B50"       case B50:   ss = 50L; break; #endif /* B50 */
 #ifdef B75"       case B75:   ss = 75L; break; #endif /* B75 */ #endif /* MINIX */   #ifdef B110*#       case B110:  ss = 110L; break;I #endif /* B110 */I  
 #ifndef MINIX  #ifdef B134 #       case B134:  ss = 134L; break;u #endif /* B134 */d #ifdef B150/#       case B150:  ss = 150L; break;* #endif /* B150 */  #endif /* MINIX */   #ifdef B200h#       case B200:  ss = 200L; break;  #endif /* B200 */    #ifdef B300e#       case B300:  ss = 300L; break;e #endif /* B300 */O   #ifdef B600y#       case B600:  ss = 600L; break;  #endif /* B600 */X   #ifdef B1200$       case B1200: ss = 1200L; break; #endif /* B1200 */   #ifdef B1800$       case B1800: ss = 1800L; break; #endif /* B1800 */   #ifdef B2400$       case B2400: ss = 2400L; break; #endif /* B2400 */   #ifdef B4800$       case B4800: ss = 4800L; break; #endif /* B4800 */   #ifdef B9600$       case B9600: ss = 9600L; break; #endif /* B9600 */  
 #ifdef B19200*&       case B19200: ss = 19200L; break; #elset #ifdef EXTAa$       case EXTA: ss = 19200L; break; #endif /* EXTA */  #endif /* B19200 */N  
 #ifndef MINIXH
 #ifdef B38400        case B38400:         ss = 38400L; #ifdef __linux__ #ifdef ASYNC_SPD_MASKd         switch(spd_flags) {32           case ASYNC_SPD_HI:  ss =  57600L; break;2           case ASYNC_SPD_VHI: ss = 115200L; break; 	} #endif /* ASYNC_SPD_MASK */i #endif /* __linux__ */         break; #else  #ifdef EXTBt$       case EXTB: ss = 38400L; break; #endif /* EXTB */d #endif /* B38400 *// #endif /* MINIX */   #ifdef HPUXn #ifdef _B57600'       case _B57600: ss = 57600L; break;  #endif /* _B57600 */ #ifdef _B115200f)       case _B115200: ss = 115200L; break;  #endif /* _B115200 */C #else 
 #ifdef QNX
 #ifdef B57600c&       case B57600: ss = 57600L; break; #endif /* B57600 */e
 #ifdef B76800T&       case B76800: ss = 76800L; break; #endif /* B76800 *// #ifdef B115200(       case B115200: ss = 115200L; break; #endif /* B115200 */ #else/
 #ifdef B57600O&       case B57600: ss = 57600L; break; #endif /* B57600 */d #ifdef B115200(       case B115200: ss = 115200L; break; #endif /* B115200 */ #endif /* QNX */ #endif /* HPUX */          default: 	ss = -1; break;     }/%     debug(F101,"ttgspd speed","",ss);t     return(ss);B }e  A /* ckumyr.c by Kristoffer Eriksson, ske@pkmab.se, 15 Mar 1990. */*   #ifdef COHERENT  #ifdef FIONREAD  #undef FIONREADX #endif #define FIONREAD TIOCQUERY #define PEEKTYPE int #elsec #define PEEKTYPE longs #endif /* COHERENT */4  
 #ifdef MYREADe  K /* Private buffer for myread() and its companions.  Not for use by anythingnJ  * else.  ttflui() is allowed to reset them to initial values.  ttchk() is  * allowed to read my_count.  *L  * my_item is an index into mybuf[].  Increment it *before* reading mybuf[].  *I  * A global parity mask variable could be useful too.  We could use it toiF  * let myread() strip the parity on its own, instead of stripping sign  * bits as it does now.d  */I #define MYBUFLEN 256
 #ifdef SUNX25s /*G   On X.25 connections, there is an extra control byte at the beginning.  */H static CHAR x25buf[MYBUFLEN+1];		/* Communication device input buffer */ static CHAR  *mybuf = x25buf+1;f #elseT static CHAR mybuf[MYBUFLEN]; #endif /* SUNX25 */i  > static int my_count = 0;		/* Number of chars still in mybuf */< static int my_item = -1;		/* Last index read from mybuf[] */  H /* myread() -- Efficient read of one character from communications line.  *J  * Uses a private buffer to minimize the number of expensive read() systemN  * calls.  Essentially performs the equivalent of read() of 1 character, whichL  * is then returned.  By reading all available input from the system buffersM  * to the private buffer in one chunk, and then working from this buffer, theiN  * number of system calls is reduced in any case where more than one characterI  * arrives during the processing of the previous chunk, for instance highiI  * baud rates or network type connections where input arrives in packets./K  * If the time needed for a read() system call approaches the time for more N  * than one character to arrive, then this mechanism automatically compensatesM  * for that by performing bigger read()s less frequently.  If the system loadd8  * is high, the same mechanism compensates for that too.  *O  * myread() is a macro that returns the next character from the buffer.  If the"L  * buffer is empty, mygetbuf() is called.  See mygetbuf() for possible error  * returns.u  *I  * This should be efficient enough for any one-character-at-a-time loops.2L  * For even better efficiency you might use memcpy()/bcopy() or such betweenN  * buffers (since they are often better optimized for copying), but it may notI  * be worth it if you have to take an extra pass over the buffer to stripT&  * parity and check for CTRL-C anyway.  *M  * Note that if you have been using myread() from another program module, you O  * may have some trouble accessing this macro version and the private variables0O  * it uses.  In that case, just add a function in this module, that invokes the_	  * macro.   */DM #define myread()  (--my_count < 0 ? mygetbuf() : 255 & (int)mybuf[++my_item])   F /* Specification: Push back up to one character onto myread()'s queue.  *O  * This implementation: Push back characters into mybuf. At least one character K  * must have been read through myread() before myunrd() may be used.  AftercK  * EOF or read error, again, myunrd() can not be used.  Sometimes more thanfJ  * one character can be pushed back, but only one character is guaranteed.I  * Since a previous myread() must have read its character out of mybuf[],_K  * that guarantees that there is space for at least one character.  If pusheI  * back was really needed after EOF, a small addition could provide that.   *B  * myunrd() is currently not called from anywhere inside kermit...  */  #ifdef NOTUSED myunrd(ch) CHAR ch; {n     if (my_item >= 0) {  	mybuf[my_item--] = ch;e 	++my_count;     }d }c #endif  E /* mygetbuf() -- Fill buffer for myread() and return first character.i  *K  * This function is what myread() uses when it can't get the next character/L  * directly from its buffer.  First, it calls a system dependent myfillbuf()J  * to read at least one new character into the buffer, and then it returnsL  * the first character just as myread() would have done.  This function alsoF  * is responsible for all error conditions that myread() can indicate.  *:  * Returns: When OK	=> a positive character, 0 or greater.  *	    When EOF	=> -2.-  *	    When error	=> -3, error code in errno.   *N  * Older myread()s additionally returned -1 to indicate that there was nothingH  * to read, upon which the caller would call myread() again until it gotI  * something.  The new myread()/mygetbuf() always gets something.  If it /M  * doesn't, then make it do so!  Any program that actually depends on the old)  * behaviour will break.  *J  * The older version also used to return -2 both for EOF and other errors,J  * and used to set errno to 9999 on EOF.  The errno stuff is gone, EOF andM  * other errors now return different results, although Kermit currently nevernB  * checks to see which it was.  It just disconnects in both cases.  *I  * Kermit lets the user use the quit key to perform some special commands J  * during file transfer.  This causes read(), and thus also mygetbuf(), toK  * finish without reading anything and return the EINTR error.  This should*I  * be checked by the caller.  Mygetbuf() could retry the read() on EINTR,tI  * but if there is nothing to read, this could delay Kermit's reaction to/4  * the command, and make Kermit appear unresponsive.  *>  * The debug() call should be removed for optimum performance.  */d intl mygetbuf() {     my_count = myfillbuf();k0     debug(F101, "myfillbuf read", "", my_count);     if (my_count <= 0)%       return(my_count < 0 ? -3 : -2);      --my_count;n*     return(255 & (int)mybuf[my_item = 0]); }r   /* myfillbuf(): H  * System-dependent read() into mybuf[], as many characters as possible.  *C  * Returns: OK => number of characters read, always more than zero.   *          EOF => 0-  *          Error => -1, error code in errno.n  *K  * If there is input available in the system's buffers, all of it should beeI  * read into mybuf[] and the function return immediately.  If no input ismL  * available, it should wait for a character to arrive, and return with thatK  * one in mybuf[] as soon as possible.  It may wait somewhat past the firstnN  * character, but be aware that any such delay lengthens the packet turnaroundO  * time during kermit file transfers.  Should never return with zero characterse*  * unless EOF or irrecoverable read error.  *H  * Correct functioning depends on the correct tty parameters being used.J  * Better control of current parameters is required than may have been theN  * case in older Kermit releases.  For instance, O_NDELAY (or equivalent) can I  * no longer be sometimes off and sometimes on like it used to, unless a  J  * special myfillbuf() is written to handle that.  Otherwise the ordinary 0  * myfillbuf()s may think they have come to EOF.  *G  * If your system has a facility to directly perform the functioning of/L  * myfillbuf(), then use it.  If the system can tell you how many charactersM  * are available in its buffers, then read that amount (but not less than 1).XM  * If the system can return a special indication when you try to read without/J  * anything to read, while allowing you to read all there is when there isN  * something, you may loop until there is something to read, but probably that#  * is not good for the system load.   */t   #ifdef SVORPOSIXC 	/* This is for System III/V with VMIN>0, VTIME=0 and O_NDELAY off, F 	 * and CLOCAL set any way you like.  This way, read() will do exactlyD 	 * what is required by myfillbuf(): If there is data in the buffersF 	 * of the O.S., all available data is read into mybuf, up to the sizeA 	 * of mybuf.  If there is none, the first character to arrive is  	 * awaited and returned.c 	 */ inti
 myfillbuf() { 
 #ifdef sxaE50 H     /* From S. Dezawa at Fujifilm in Japan.  I don't know why this is *//     /* necessary for the sxa E50, but it is. */f#     return read(ttyfd, mybuf, 255);/ #elsee
     int n;/     /* sizeof(mybuf) should be MYBUFL == 256 */;*     n = read(ttyfd, mybuf, sizeof(mybuf));+     debug(F101,"SVORPOSIX myfillbuf","",n);m     return(n); #endif /* sxaE50 */; }e   #else /* not AT&T or POSIX */r   #ifdef aegisC 	/* This is quoted from the old myread().  The semantics seem to bet? 	 * alright, but maybe errno would not need to be set even wheno+ 	 * there is no error?  I don't know aegis.c 	 */ inte
 myfillbuf() {      int count;  C     count = ios_$get((short)ttyfd, ios_$cond_opt, mybuf, 256L, st);      errno = EIO;E     if (st.all == ios_$get_conditional_failed) /* get at least one *//7       count = ios_$get((short)ttyfd, 0, mybuf, 1L, st); #     if (st.all == ios_$end_of_file)        return(0);$     else if (st.all != status_$ok) {
 	errno = EIO;  	return(-1);     }o     return(count); }B #else /* !aegis */   #ifdef FIONREAD C 	/* This is for systems with FIONREAD.  FIONREAD returns the number D 	 * of characters available for reading. If none are available, wait; 	 * until something arrives, otherwise return all there is.s 	 */ inta
 myfillbuf() {e     PEEKTYPE avail;t
     int x;  
 #ifdef SUNX25i /*O   SunLink X.25 support in this routine from Stefaan A. Eeckels, Eurostat (CEC).RK   Depends on SunOS having FIONREAD, not because we use it, but just so thisdM   code is grouped correctly within the #ifdefs.  Let's hope Solaris keeps it.   I   We call x25xin() instead of read() so that Q-Bit packets, which contain O   X.25 service-level information (e.g. PAD parameter changes), can be processed I   transparently to the upper-level code.  This is a blocking read, and so*O   we depend on higher-level code (such as ttinc()) to set any necessary alarms.  */         extern int nettype;t)     if (netconn && nettype == NET_SX25) {t3 	while ((x = x25xin(sizeof(x25buf), x25buf)) < 1) ; D 	return(x - 1);	        /* "-1" compensates for extra status byte */	     }      #endif /* SUNX25 */k  '     x = ioctl(ttyfd, FIONREAD, &avail);      if (x < 0) {' 	debug(F101,"myfillbuf FIONREAD","",x);e( 	debug(F101,"myfillbuf errno","",errno);     }c     if (x < 0 || avail == 0)       avail = 1;       if (avail > MYBUFLEN)e       avail = MYBUFLEN;i  ,     return(read(ttyfd, mybuf, (int) avail)); }    #else /* !FIONREAD */dE /* Add other systems here, between #ifdef and #else, e.g. NETCONN. */IE /* When there is no other possibility, read 1 character at a time. */t intt
 myfillbuf() {l!     return read(ttyfd, mybuf, 1);D }7   #endif /* !FIONREAD */ #endif /* !aegis */  #endif /* !ATTSV */e   #endif /* MYREAD */   . /*  T T F L U I  --  Flush tty input buffer */   int'
 ttflui() { #ifdef BSD44
     int n; #endif /* BSD44 */ #ifndef SVORPOSIXo
     int n; #endif /* SVORPOSIX */  
 #ifdef MYREAD} /*5   Flush internal MYREAD buffer *FIRST*, in all cases.r */-     my_count = 0;			/* Reset count to zero */t0     my_item = -1;			/* And buffer index to -1 */ #endif /* MYREAD */    #ifdef NETCONN /*A   Network flush is done specially, in the network support module.t */&     debug(F100,"ttflui netflui","",0);#     if (netconn) return(netflui());  #endif /* NETCONN */  (     debug(F101,"ttflui ttyfd","",ttyfd);     if (ttyfd < 0) return(-1);   #ifdef aegis8     sio_$control((short)ttyfd, sio_$flush_in, true, st);     if (st.all != status_$ok) {I5 	fprintf(stderr, "flush failed: "); error_$print(st);r8     } else {      /* sometimes the flush doesn't work */         for (;;) { 	    char buf[256];/D             /* eat all the characters that shouldn't be available */N             ios_$get((short)ttyfd, ios_$cond_opt, buf, 256L, st); /* (void) */=             if (st.all == ios_$get_conditional_failed) break;/C             fprintf(stderr, "flush failed(2): "); error_$print(st);t	         }g     }n #else  #ifdef BSD44				/* 4.4 BSD */A@     n = FREAD;                          /* Specify read queue */$     debug(F100,"ttflui BSD44","",0);     ioctl(ttyfd,TIOCFLUSH,&n); #else  #ifdef POSIX				/* POSIX *//$     debug(F100,"ttflui POSIX","",0);     tcflush(ttyfd,TCIFLUSH); #elsed #ifdef ATTSV				/* System V */ #ifndef VXVE$     debug(F100,"ttflui ATTSV","",0);     ioctl(ttyfd,TCFLSH,0); #endif /* VXVE */ * #else					/* Not BSD44, POSIX, or Sys V */5 #ifdef TIOCFLUSH			/* Those with TIOCFLUSH defined */  #ifdef ANYBSD				/* Berkeley */u@     n = FREAD;                          /* Specify read queue *//     debug(F100,"ttflui TIOCFLUSH ANYBSD","",0);d     ioctl(ttyfd,TIOCFLUSH,&n);  #else					/* Others (V7, etc) */(     debug(F100,"ttflui TIOCFLUSH","",0);     ioctl(ttyfd,TIOCFLUSH,0);  #endif /* ANYBSD *// #else					/* All others... */v /*@   No system call (that we know about) for input buffer flushing.C   So see how many there are and read them in a loop, using ttinc(). G   ttinc() is buffered, so we're not getting charged with a system call  &   per character, just a function call. */     if ((n = ttchk()) > 0) {% 	debug(F101,"ttflui read loop","",n);   	while ((n--) && ttinc(0) > 0) ;     }a #endif /* TIOCFLUSH */ #endif /* ATTSV */ #endif /* POSIX */ #endif /* BSD44 */ #endif /* aegis */     return(0); }    void
 ttflux() {
 #ifdef MYREADu /*   Flush internal MYREAD buffer.d */-     my_count = 0;			/* Reset count to zero */b0     my_item = -1;			/* And buffer index to -1 */ #endif /* MYREAD */d }    inte' ttfluo() {				/* Flush output buffer */a #ifdef POSIX$     return(tcflush(ttyfd,TCOFLUSH)); #elses #ifdef OXOSf"     return(ioctl(ttyfd,TCFLSH,1)); #else +     return(0);				/* All others, nothing */g #endif /* OXOS */n #endif /* POSIX */   }_   /* Interrupt Functions */*  4 /* Set up terminal interrupts on console terminal */  / #ifndef FIONREAD			/* We don't need esctrp() */_2 #ifndef SELECT				/* if we have any of these... */ #ifndef CK_POLLn
 #ifndef RDCHK    #ifndef OXOS #ifdef SVORPOSIX SIGTYP8 esctrp(foo) int foo; {			/* trap console escapes (^\) */B     signal(SIGQUIT,SIG_IGN);            /* ignore until trapped */     conesc = 1;t2     debug(F101,"esctrp caught SIGQUIT","",conesc); }* #endif /* SVORPOSIX */ #endif /* OXOS */   	 #ifdef V7t SIGTYP8 esctrp(foo) int foo; {			/* trap console escapes (^\) */B     signal(SIGQUIT,SIG_IGN);            /* ignore until trapped */     conesc = 1;u2     debug(F101,"esctrp caught SIGQUIT","",conesc); }  #endif /* V7 */>  
 #ifdef C70 SIGTYP8 esctrp(foo) int foo; {			/* trap console escapes (^\) */     conesc = 1; B     signal(SIGQUIT,SIG_IGN);            /* ignore until trapped */ }  #endif /* C70 */   #endif /* RDCHK */ #endif /* CK_POLL */ #endif /* SELECT */( #endif /* FIONREAD */d  ( /*  C O N B G T  --  Background Test  */  - static int jc = 0;			/* 0 = no job control */s   /*G   Call with flag == 1 to prevent signal test, which can not be expectedGK   to work during file transfer, when SIGINT probably *is* set to SIG_IGN.  p  K   Call with flag == 0 to use the signal test, but only if the process-groupiH   test fails, as it does on some UNIX systems, where getpgrp() is buggy,H   requires an argument when the man page says it doesn't, or vice versa.  sM   If flag == 0 and the process-group test fails, then we determine backgroundY=   status simply (but not necessarily reliably) from isatty().c  L   conbgt() sets the global backgrd = 1 if we appear to be in the background,K   and to 0 if we seem to be in the foreground.  conbgt() is highly prone toc   misbehavior. */ VOID conbgt(flag) int flag; {5     int x = -1,				/* process group or SIGINT test */c%         y = 0;				/* isatty() test */T /*J   Check for background operation, even if not running on real tty, so thatJ   background flag can be set correctly.  If background status is detected,E   then Kermit will not issue its interactive prompt or most messages.)C   If your prompt goes away, you can blame (and fix?) this function.c */  ) /* Use process-group test if possible. */I  + #ifdef POSIX				/* We can do it in POSIX */e #define PGROUP_T #elsea$ #ifdef BSD4				/* and in BSD 4.x. */ #define PGROUP_T #else{- #ifdef HPUXJOBCTL			/* and in most HP-UX's */s #define PGROUP_T #else : #ifdef TIOCGPGRP			/* and anyplace that has this ioctl. */ #define PGROUP_T #endif /* TIOCGPGRP */ #endif /* HPUXJOBCTL */l #endif /* BSD4 */n #endif /* POSIX */  1 #ifdef MIPS				/* Except if it doesn't work... */; #undef PGROUP_T_ #endif /* MIPS */p   #ifdef PGROUP_T  /*J   Semi-reliable process-group test.  Check whether this process's group isJ   the same as the controlling terminal's process group.  This works if theL   getpgrp() call doesn't lie (as it does in the SUNOS System V environment). */:     PID_T mypgrp = (PID_T)0;		/* Kermit's process group */@     PID_T ctpgrp = (PID_T)0;		/* The terminal's process group */ #ifndef _POSIX_SOURCEa /*I   The getpgrp() prototype is obtained from system header files for POSIX eL   and Sys V R4 compilations.  Other systems, who knows.  Some complain aboutJ   a duplicate declaration here, others don't, so it's safer to leave it in   if we don't know for certain.( */ #ifndef SVR4 #ifndef PS2AIX10     extern PID_T getpgrp();f #endif /* PS2AIX10 */r #endif /* SVR4 */b #endif /* _POSIX_SOURCE */   /* Get my process group. */,  - #ifdef SVR3 /* Maybe this should be ATTSV? */ / /* This function is not described in SVID R2 */e     mypgrp = getpgrp();T=     debug(F101,"ATTSV conbgt process group","",(int) mypgrp);o #else  #ifdef POSIX     mypgrp = getpgrp();S=     debug(F101,"POSIX conbgt process group","",(int) mypgrp);  #elseb #ifdef OSFPC     mypgrp = getpgrp();*;     debug(F101,"OSF conbgt process group","",(int) mypgrp);  #elseo
 #ifdef QNX     mypgrp = getpgrp();m;     debug(F101,"QNX conbgt process group","",(int) mypgrp);u #else /* BSD, V7, etc */     mypgrp = getpgrp(0);;     debug(F101,"BSD conbgt process group","",(int) mypgrp);w #endif /* QNX */ #endif /* OSFPC */ #endif /* POSIX */ #endif /* SVR3 */z  - /* Now get controlling tty's process group */o #ifdef BSD44ORPOSIX=/     ctpgrp = tcgetpgrp(1);		/* The POSIX way */fF     debug(F101,"POSIX conbgt terminal process group","",(int) ctpgrp); #else 6     ioctl(1, TIOCGPGRP, &ctpgrp);	/* Or the BSD way */J     debug(F101,"non-POSIX conbgt terminal process group","",(int) ctpgrp); #endif /* BSD44ORPOSIX */e  5     if ((mypgrp > (PID_T) 0) && (ctpgrp > (PID_T) 0))oL       x = (mypgrp == ctpgrp) ? 0 : 1;	/* If they differ, then background. */,     else x = -1;			/* If error, remember. */1     debug(F101,"conbgt process group test","",x);  #endif /* PGROUP_T */&  , /* Try to see if job control is available */  " #ifdef NOJC				/* User override */+     jc = 0;				/* No job control allowed */      debug(F111,"NOJC","jc",jc);n #elseo #ifdef BSD44     jc = 1;s #elseN2 #ifdef SVR4ORPOSIX			/* POSIX actually tells us */.     debug(F100,"SVR4ORPOSIX jc test...","",0); #ifdef _SC_JOB_CONTROL #ifdef __bsdi__I     jc = 1;) #else  #ifdef __386BSD__G     jc = 1;l #else =     jc = sysconf(_SC_JOB_CONTROL);	/* Whatever system says */h     if (jc < 0) { 1 	debug(F101,"sysconf fails, jcshell","",jcshell);e" 	jc = (jchdlr == SIG_DFL) ? 1 : 0;
     } else5       debug(F111,"sysconf(_SC_JOB_CONTROL)","jc",jc);s #endif /* __386BSD__ */  #endif /* __bsdi__ */d #elseI #ifdef _POSIX_JOB_CONTROL "     jc = 1;				/* By definition */8     debug(F111,"_POSIX_JOB_CONTROL is defined","jc",jc); #elsel3     jc = 0;				/* Assume job control not allowed */MH     debug(F111,"SVR4ORPOSIX _SC/POSIX_JOB_CONTROL not defined","jc",jc); #endif /* _POSIX_JOB_CONTROL */* #endif /* _SC_JOB_CONTROL */ #elses #ifdef BSD4,(     jc = 1;				/* Job control allowed */*     debug(F111,"BSD job control","jc",jc); #elseR
 #ifdef SVR3JC      jc = 1;				/* JC allowed */d+     debug(F111,"SVR3 job control","jc",jc);  #elses #ifdef OXOS,     jc = 1;				/* JC allowed */s+     debug(F111,"X/OS job control","jc",jc);) #else/ #ifdef HPUX9     jc = 1;				/* JC allowed */ 0     debug(F111,"HP-UX 9.0 job control","jc",jc); #elsew #ifdef HPUX9     jc = 1;				/* JC allowed */e1     debug(F111,"HP-UX 10.0 job control","jc",jc);  #elsea#     jc = 0;				/* JC not allowed */n0     debug(F111,"job control catch-all","jc",jc); #endif /* HPUX10 */  #endif /* HPUX9 */ #endif /* OXOS */  #endif /* SVR3JC */  #endif /* BSD4 */  #endif /* SVR4ORPOSIX */ #endif /* BSD44 */ #endif /* NOJC */c"     debug(F101,"conbgt jc","",jc); #ifndef NOJC,     debug(F101,"conbgt jcshell","",jcshell); /*K   At this point, if jc == 1 but jcshell == 0, it means that the OS supportsEK   job control, but the shell or other process we are running under does noteL   (jcshell is set in sysinit()) and so if we suspend ourselves, nothing good   will come of it.  So..._ */     if (jc < 0) jc = 0; '     if (jc > 0 && jcshell == 0) jc = 0;	 #endif /* NOJC *//   /*   Another background test.A   Test if SIGINT (terminal interrupt) is set to SIG_IGN (ignore), E   which is done by the shell (sh) if the program is started with '&'. =   Unfortunately, this is NOT done by csh or ksh so watch out! E   Note, it's safe to set SIGINT to SIG_IGN here, because further downa%   we always set it to something else.  */A     if (x < 0 && !flag) {		/* Didn't get good results above... */f   	SIGTYP (*osigint)();,  ? 	osigint = signal(SIGINT,SIG_IGN);	/* What is SIGINT set to? */e1 	x = (osigint == SIG_IGN) ? 1 : 0;	/* SIG_IGN? */?/ 	debug(F101,"conbgt osigint","",(int) osigint);O' 	debug(F101,"conbgt signal test","",x);*     }l  ? /* Also check to see if we're running with redirected stdio. */nK /* This is not really background operation, but we want to act as though */: /* it were. */  )     y = (isatty(0) && isatty(1)) ? 1 : 0;a*     debug(F101,"conbgt isatty test","",y);   #ifdef BSD29F /* The process group and/or signal test doesn't work under these... */     backgrd = !y;  #elsee
 #ifdef sxaE50a     backgrd = !y;d #else. #ifdef MINIX     backgrd = !y;t #else      if (x > -1)m"       backgrd = (x || !y) ? 1 : 0;     else backgrd = !y; #endif /* BSD29 */ #endif /* sxaE50 */u #endif /* MINIX */,     debug(F101,"conbgt backgrd","",backgrd); }   1 /*  C O N I N T  --  Console Interrupt setter  */i   /*L   First arg is pointer to function to handle SIGTERM & SIGINT (like Ctrl-C).@   Second arg is pointer to function to handle SIGTSTP (suspend). */  , VOID					/* Set terminal interrupt traps. */ #ifdef CK_ANSICc
 #ifdef apollo-" conint(f,s) SIGTYP (*f)(), (*s)(); #else;* conint(SIGTYP (*f)(int), SIGTYP (*s)(int)) #endif /* apollo */d #elseg" conint(f,s) SIGTYP (*f)(), (*s)(); #endif /* CK_ANSIC */e /* conint */ {  +     conbgt(0);				/* Do background test. */s  C /* Set the desired handlers for hangup and software termination. */c  B     signal(SIGTERM,f);                  /* Software termination */   #ifdef COMMENT /*I   Prior to edit 184, we used to trap SIGHUP here.  That is clearly wrong; J   on some systems, it would leave the user's process on the terminal afterJ   the phone hung up.  But the trap was here for a reason: most likely someL   UNIX systems (init, getty, or login) fail to properly restore the terminalL   modes after regaining control of a hung-up-upon login terminal.  ThereforeF   removing this trap is likely to cause problems too.  A more sensibleL   approach would be to use a special handler for HANGUP, which would restoreL   the terminal modes and then exit().  But that could leave zombie processesK   around (like the lower CONNECT fork, or any fork started by zxcmd()), but0K   there is probably no clean, portable, reliable way for Kermit to kill all K   its forks.  So we just exit() and hope that UNIX fixes the terminal modes()   before the next person tries to log in.e */4     signal(SIGHUP,f);                   /* Hangup */ #endif /* COMMENT */  < /* Now handle keyboard stop, quit, and interrupt signals. */H /* Check if invoked in background -- if so signals set to be ignored. */G /* However, if running under a job control shell, don't ignore them. */DL /* We won't be getting any, as we aren't in the terminal's process group. */  ,     debug(F101,"conint backgrd","",backgrd);"     debug(F101,"conint jc","",jc);  >     if (backgrd && !jc) {		/* In background, ignore signals */< 	debug(F101,"conint background ignoring signals, jc","",jc); #ifdef SIGTSTP;         signal(SIGTSTP,SIG_IGN);        /* Keyboard stop */a #endif /* SIGTSTP */;         signal(SIGQUIT,SIG_IGN);        /* Keyboard quit */o@         signal(SIGINT,SIG_IGN);         /* Keyboard interrupt */5     } else {				/* Else in foreground or suspended */b< 	debug(F101,"conint foreground catching signals, jc","",jc);F         signal(SIGINT,f);               /* Catch terminal interrupt */  / #ifdef SIGTSTP				/* Keyboard stop (suspend) */e* 	debug(F101,"conint SIGSTSTP","",(int) s); 	if (s == NULL) s = SIG_DFL;, #ifdef NOJC				/* No job control allowed. */ 	signal(SIGTSTP,SIG_IGN);,# #else					/* Job control allowed */t 	if (jc)				/* if available. */e 	  signal(SIGTSTP,s);r 	elsea 	  signal(SIGTSTP,SIG_IGN);t #endif /* NOJC */  #endif /* SIGTSTP */   #ifndef OXOS #ifdef SVORPOSIX9 #ifndef FIONREAD			/* Watch out, we don't know this... */  #ifndef SELECT #ifndef CK_POLL=
 #ifndef RDCHKdE         signal(SIGQUIT,esctrp);         /* Quit signal, Sys III/V. *// #endif /* RDCHK */ #endif /* CK_POLL */ #endif /* SELECT */* #endif /* FIONREAD */ G         if (conesc) conesc = 0;         /* Clear out pending escapes */  #elsei	 #ifdef V7 ?         signal(SIGQUIT,esctrp);         /* V7 like Sys III/V */          if (conesc) conesc = 0;) #else  #ifdef aegisK         signal(SIGQUIT,f);              /* Apollo, catch it like others. */g #elsetO         signal(SIGQUIT,SIG_IGN);        /* Others, ignore like 4D & earlier. */h #endif /* aegis */ #endif /* V7 */  #endif /* SVORPOSIX */ #endif /* OXOS */w     }n }i    9 /*  C O N N O I  --  Reset console terminal interrupts */C  1 SIGTYP					/* Dummy function to ignore signals */! #ifdef CK_ANSIC_ sig_ign(int foo) #elseL sig_ign(foo) int foo;f #endif /* CK_ANSIC */(9 /* sig_IGN */ {				/* Just like the real one, but has  */C }					/* different address. */   VOIDC connoi() {                              /* Console-no-interrupts */n       debug(F100,"connoi","",0); #ifdef SIGTSTP     signal(SIGTSTP,SIG_DFL); #endif /* SIGTSTP */L     /* Note the locally defined replacement for SIG_IGN that is used here */L     /* for the SIGINT setting.  This is done so that the Sys V background */M     /* test -- (signal(SIGINT,SIG_IGN) == SIG_IGN) -- can work.  If we use */nJ     /* the real SIG_IGN here, then conint will always decide that this */ /     /* program is running in the background! */i  -     signal(SIGINT,sig_ign);		/* <--- note! */        signal(SIGHUP,SIG_DFL);      signal(SIGQUIT,SIG_IGN);     signal(SIGTERM,SIG_IGN); }m  J /*  I N I T R A W Q  --  Set up to read /dev/kmem for character count.  */  
 #ifdef  V7 /*D  Used in Version 7 to simulate Berkeley's FIONREAD ioctl call.  ThisH  eliminates blocking on a read, because we can read /dev/kmem to get theD  number of characters available for raw input.  If your system can'tE  or you won't let the world read /dev/kmem then you must figure out a J  different way to do the counting of characters available, or else replace0  this by a dummy function that always returns 0. */ /*&  * Call this routine as: initrawq(tty)B  * where tty is the file descriptor of a terminal.  It will returnE  * (as a char *) the kernel-mode memory address of the rawq charactereE  * count, which may then be read.  It has the side-effect of flushingv  * input on the terminal.e  */* /*B  * John Mackin, Physiology Dept., University of Sydney (Australia)&  * ...!decvax!mulga!physiol.su.oz!john  *A  * Permission is hereby granted to do anything with this code, asl@  * long as this comment is retained unmodified and no commercial  * advantage is gained.e  */ 
 #ifndef MINIXo #ifndef COHERENT #include <a.out.h> #include <sys/proc.h>i #endif /* COHERENT */  #endif /* MINIX */   #ifdef COHERENT  #include <l.out.h> #include <sys/proc.h>  #endif /* COHERENT */t   char * initrawq(tty) int tty; { #ifdef MINIX     return(0); #elsen #ifdef UTS24     return(0); #elsef #ifdef BSD29     return(0); #else0     long lseek();       static struct nlist nl[] = {         {PROCNAME},          {NPROCNAME},         {""}     };     static struct proc *pp;0     char *qaddr, *p, c;*
     int m;     PID_T pid, me;N     NPTYPE xproc;                       /* Its type is defined in makefile. */     int catch();       me = getpid();4     if ((m = open("/dev/kmem", 0)) < 0) err("kmem");     nlist(BOOTNAME, nl);-     if (nl[0].n_type == 0) err("proc array");a  (     if (nl[1].n_type == 0) err("nproc");  '     lseek(m, (long)(nl[1].n_value), 0);h$     read (m, &xproc, sizeof(xproc));#     saval = signal(SIGALRM, catch);w     if ((pid = fork()) == 0) {         while(1)             read(tty, &c, 1);,     }c
     alarm(2);r       if(setjmp(jjbuf) == 0) {         while(1) 	  read(tty, &c, 1);     }o     signal(SIGALRM, SIG_DFL);d  
 #ifdef DIRECTr'     pp = (struct proc *) nl[0].n_value;c #elsen=     if (lseek(m, (long)(nl[0].n_value), 0) < 0L) err("seek");nL     if (read(m, &pp, sizeof(pp)) != sizeof(pp))  err("no read of proc ptr"); #endif'     lseek(m, (long)(nl[1].n_value), 0);(#     read(m, &xproc, sizeof(xproc));a  >     if (lseek(m, (long)pp, 0) < 0L) err("Can't seek to proc");I     if ((p = malloc(xproc * sizeof(struct proc))) == NULL) err("malloc");_K     if (read(m,p,xproc * sizeof(struct proc)) != xproc*sizeof(struct proc))K         err("read proc table");o;     for (pp = (struct proc *)p; xproc > 0; --xproc, ++pp) {e2         if (pp -> p_pid == (short) pid) goto iout;     }b     err("no such proc");   iout:g
     close(m);e$     qaddr = (char *)(pp -> p_wchan);
     free (p);)     kill(pid, SIGKILL);n     wait((WAIT_T *)0);     return (qaddr);	 #endif #endif #endif }   $ /*  More V7-support functions...  */   static VOIDt err(s) char *s; {e     char buf[200];  3     sprintf(buf, "fatal error in initrawq: %s", s);=     perror(buf);     doexit(1,-1);r }o   static VOID  catch(foo) int foo; {      longjmp(jjbuf, -1);r }o    0 /*  G E N B R K  --  Simulate a modem break.  */   #ifdef MINIX #define BSPEED B110* #else  #define BSPEED B150. #endif /* MINIX */   VOID genbrk(fn,msec) int fn, msec; {I     struct sgttyb ttbuf;     int ret, sospeed, x, y;o  &     ret = ioctl(fn, TIOCGETP, &ttbuf);     sospeed = ttbuf.sg_ospeed;     ttbuf.sg_ospeed = BSPEED;d&     ret = ioctl(fn, TIOCSETP, &ttbuf);     y = (int)strlen(brnuls);      x = ( BSPEED * 100 ) / msec;     if (x > y) x = y;k8     ret = write(fn, brnuls, (( BSPEED * 100 ) / msec ));     ttbuf.sg_ospeed = sospeed;&     ret = ioctl(fn, TIOCSETP, &ttbuf);     ret = write(fn, "@", 1);     return;" }n #endif /* V7 */t   /*L   I N C H K  --  Check if chars waiting to be read on given file descriptor.5   Returns number of characters waiting, 0 or greater.e  3   This routine is a merger of ttchk() and conchk().o6   Conchk calls it with 0; ttchk() calls it with ttyfd. */
 static int in_chk(fd) int fd; {&     int x, n = 0;			/* Return value */       if (fd < 0) return(0);   #ifdef FIONREAD(?     x = ioctl(fd, FIONREAD, &n);	/* BSD and hopefully others *//3     debug(F101,"in_chk FIONREAD return code","",x);;-     debug(F101,"in_chk FIONREAD count","",n);   #else /* FIONREAD not defined */
 #ifdef  V7 #ifdef MINIX
     n = 0; #else B     lseek(kmem[TTY], (long) qaddr[TTY], 0); /* 7th Edition Unix */)     x = read(kmem[TTY], &n, sizeof(int));f      if (x != sizeof(int)) n = 0; #endif /* MINIX */ #else /* Not V7 */
 #ifdef PROVX1v@     x = ioctl(fd, TIOCQCNT, &ttbuf);	/* DEC Pro/3xx Venix V.1 */     n = ttbuf.sg_ispeed & 0377;      if (x < 0) n = 0;, #elseo. #ifdef RDCHK				/* This mostly SCO-specific */     n = rdchk(fd);$     debug(F101,"in_chk rdchk","",n); #else /* No RDCHK */
 #ifdef SELECT,     {e+ 	fd_set rfds;			/* Read file descriptors */i( 	FD_ZERO(&rfds);			/* Initialize them */4 	FD_SET(fd,&rfds);		/* We want to look at this fd */@ 	tv.tv_sec = tv.tv_usec = 0L;	/* A 0-valued timeval structure */ #ifdef BSD44@ 	n = select( FD_SETSIZE, &rfds, (fd_set *)0, (fd_set *)0, &tv ); #else= #ifdef BSD43@ 	n = select( FD_SETSIZE, &rfds, (fd_set *)0, (fd_set *)0, &tv ); #else  #ifdef SOLARIS@ 	n = select( FD_SETSIZE, &rfds, (fd_set *)0, (fd_set *)0, &tv ); #elseE
 #ifdef QNX@ 	n = select( FD_SETSIZE, &rfds, (fd_set *)0, (fd_set *)0, &tv ); #else 6 #ifdef COHERENT		/* needed for -DSELECT in makefile */@ 	n = select( FD_SETSIZE, &rfds, (fd_set *)0, (fd_set *)0, &tv ); #elseM: 	n = select( FD_SETSIZE, &rfds, (int *)0, (int *)0, &tv ); #endif /* COHERENT */c #endif /* QNX */ #endif /* SOLARIS */ #endif /* BSD43 */ #endif /* BSD44 */$ 	debug(F101,"in_chk select n","",n);     }  #else* #ifdef CK_POLL     {t       struct pollfd pfd;         pfd.fd = fd;       pfd.events = POLLIN;       pfd.revents = 0;       n = poll(&pfd, 1, 0);n%       debug(F101,"in_chk poll","",n);l,       if ((n > 0) && (pfd.revents & POLLIN)) 	n = 1;m     }  #endif /* CK_POLL */ #endif /* SELECT */* #endif /* RDCHK */ #endif /* PROVX1 */  #endif /* V7 */( #endif /* FIONREAD */E  K /* From here down, treat console and communication device differently... */s  .     if (fd == 0 && ttyfd != 0) {	/* Console */   #ifdef SVORPOSIX #ifndef FIONREAD #ifndef SELECT #ifndef CK_POLLl
 #ifndef RDCHK  /*H   This is the hideous hack used in System V and POSIX systems that don'tG   support FIONREAD, rdchk(), select(), poll(), etc, in which the user'stI   CONNECT-mode escape character is attached to SIGQUIT.  Used, obviously,    only on the console. */8 	if (conesc) {			/* Escape character typed == SIGQUIT */+ 	    debug(F100,"in_chk conesc","",conesc);, 	    conesc = 0;1 	    signal(SIGQUIT,esctrp);	/* Restore signal */  	    n += 1; 	} #endif /* RDCHK */ #endif /* CK_POLL */ #endif /* SELECT */e #endif /* FIONREAD */y #endif /* SVORPOSIX */  % 	return(n);			/* Done with console */g     }t  < /* Communications device, might also have stuff buffered. */  
 #ifdef MYREADc /*D   For myread() users, add the contents of myread()'s private buffer.L   Sometimes, this is all there is to construct a result of in_chk(ttyfd) on. */.     debug(F101,"in_chk my_count","",my_count);     if (my_count > 0)        n += my_count; #endif /* MYREAD */        return(n < 0 ? 0 : n); }(    O /*  T T C H K  --  Tell how many characters are waiting in tty input buffer  */l  H /*  Some callers of this want to know whether there is something to readL  *  either in the system buffers or in our private buffers (and mostly don'tM  *  care how many characters, just whether it's more than zero or not), whilePH  *  some others would be better off with the number of characters in our  *  private buffers only.   *M  *  Some systems can say how many characters there are in the system buffers.iK  *  Others can not. For those that can't, the number in the private buffersbK  *  will have to do (or should we put the tty into O_NDELAY-mode and try tobI  *  read one character?). If the system can tell whether there is zero orhM  *  more than zero characters, we can return 1 in the latter case even if theo@  *  private buffer is empty. (That is good for sliding windows.)  */c int,	 ttchk() {s     return(in_chk(ttyfd)); }   = /*  T T X I N  --  Get n characters from tty input buffer  */h  F /*  Returns number of characters actually gotten, or -1 on failure  */  L /*  Intended for use only when it is known that n characters are actually */& /*  Available in the input buffer.  */   int,  ttxin(n,buf) int n; CHAR *buf; {     register int x, c;        debug(F101,"ttxin n","",n);      if (n < 1) return(0);uA     ttpmsk = (ttprty) ? 0177 : 0377;	/* Parity stripping mask. */   
 #ifdef SUNX25 =     if (netconn && (ttnet == NET_SX25))	/* X.25 connection */e       return(x25xin(n,buf)); #endif /* SUNX25 */*  
 #ifdef MYREAD $     debug(F101,"ttxin MYREAD","",0);     c = -2;i=     for( x = 0; (x > -1) && (x < n) && (c = myread()) >= 0; )t       buf[x++] = c & ttpmsk;     if (c < 0) {) 	debug(F101,"ttxin myread returns","",c);d 	if (c == -3) x = -1;      }n #elser     x = read(ttyfd,buf,n);-     for (c = 0; c < n; c++) buf[c] &= ttpmsk;e     debug(F101," x","",x); #endif /* MYREAD */f     if (x > 0) buf[x] = '\0';u     if (x < 0) x = -1;     return(x); }   G /*  T T O L  --  Write string s, length n, to communication device.  */  /*
   Returns::    >= 0 on success, number of characters actually written.    -1 on failure.e */ #define TTOLMAXT 5 int  ttol(s,n) int n; CHAR *s; {      int x, len, tries;$     if (ttyfd < 0)			/* Not open? */       return(-1);	       debug(F101,"ttol n","",n);     debug(F110,"ttol s",s,0);n  9     tries = TTOLMAXT;			/* Allow up to this many tries */t.     len = n;				/* Remember original length */6     while (n > 0 && tries-- > 0) {	/* Be persistent */, 	debug(F101,"ttol try","",TTOLMAXT - tries);4 	x = write(ttyfd,s,n);		/* Write string to device */ 	if (x == n) {			/* Worked? */) 	    debug(F101,"ttol ok","",x);	/* OK */E 	    return(len);		/* Done */t* 	} else if (x < 0) {		/* No, got error? */( 	    debug(F101,"ttol failed","",errno); #ifdef TCPSOCKET( 	    if (netconn && ttnet == NET_TCPB) {, 		if (errno) perror("TCP/IP"); /* Say why */) 		ttclos(0);		/* Close the connection. */e 	    } #endif /* TCPSOCKET */ 	    return(-1);. 	} else {			/* No error, so partial success */% 	    debug(F101,"ttol partial","",x);y2 	    s += x;			/* Point to part not written yet */" 	    n -= x;			/* Adjust length */0 	    if (x > 0) msleep(100);	/* Wait 100 msec */! 	}				/* Go back and try again */      } 7     return(n < 1 ? len : -1);		/* Return the results */  }   A /*  T T O C  --  Output a character to the communication line  */    /*N  This function should only be used for interactive, character-mode operations,K  like terminal connection, script execution, dialer i/o, where the overhead*8  of the signals and alarms does not create a bottleneck. */ intg #ifdef CK_ANSICl ttoc(char c) #elsea ttoc(c) char c;e #endif /* CK_ANSIC */d /* ttoc */ {8 #define TTOC_TMO 15			/* Timeout in case we get stuck */     int xx;      c &= 0xff;)     /* debug(F101,"ttoc","",(CHAR) c); */T.     if (ttyfd < 0)			/* Check for not open. */       return(-1); @     saval = signal(SIGALRM,timerh);	/* Enable timer interrupt */7     xx = alarm(TTOC_TMO);		/* for this many seconds. */i5     if (xx < 0) xx = 0;			/* Save old alarm value. */I)     /* debug(F101,"ttoc alarm","",xx); */      if ( #ifdef CK_POSIX_SIG  	sigsetjmp(sjbuf,1)  #elseF 	setjmp(sjbuf) #endif /* CK_POSIX_SIG */e 	) {		/* Timer went off? */t+ 	ttimoff();			/* Yes, cancel this alarm. */pH 	if (xx - TTOC_TMO > 0) alarm(xx - TTOC_TMO); /* Restore previous one */.         /* debug(F100,"ttoc timeout","",0); */ #ifdef NETCONN 	if (!netconn) { #endif /* NETCONN */% 	    debug(F101,"ttoc timeout","",c);r 	    if (ttflow == FLO_XONX) { 		int x = 0, y;n= 		debug(F101,"ttoc flow","",ttflow); /* Maybe we're xoff'd */  #ifdef POSIX6 		y = tcflow(ttyfd,TCOON); /* POSIX way to unstick. */! 		debug(F100,"ttoc tcflow","",y);. #else,+ #ifdef BSD4				/* Berkeley way to do it. */h #ifdef TIOCSTART@ /* .... Used to be "ioctl(ttyfd, TIOCSTART, 0);".  Who knows? */" 		y = ioctl(ttyfd, TIOCSTART, &x);$ 		debug(F101,"ttoc TIOCSTART","",y); #endif /* TIOCSTART */ #endif /* BSD4 */e+ 					/* Is there a Sys V way to do this? */, #endif /* POSIX */ 	    } #ifdef NETCONN	         }  #endif /* NETCONN */) 	return(-1);			/* Return failure code. */T     } else {? 	if (write(ttyfd,&c,1) < 1) {	/* Try to write the character. */)3 	    ttimoff();			/* Failed, turn off the alarm. */ / 	    alarm(xx);			/* Restore previous alarm. */ < 	    debug(F101,"ttoc error","",errno); /* Log the error, */3 	    return(-1);			/* and return the error code. */  	}     } 4     ttimoff();				/* Success, turn off the alarm. *//     alarm(xx);				/* Restore previous alarm. */t)     return(0);				/* Return good code. */c }   L /*  T T I N L  --  Read a record (up to break character) from comm line.  */ /*K   Reads up to "max" characters from the communication line, terminating on:l  B     (a) the packet length field if the "turn" argument is zero, orK     (b) on the packet-end character (eol) if the "turn" argument is nonzero=     (c) two Ctrl-C's in a rowi  I   and returns the number of characters read upon success, or if "max" was*I   exceeded or the timeout interval expired before (a) or (b), returns -1.E  N   The characters that were input are copied into "dest" with their parity bitsJ   stripped if parity was selected.  Returns the number of characters read.M   Characters after the eol are available upon the next call to this function.n  L   The idea is to minimize the number of system calls per packet, and also toM   minimize timeouts.  This function is the inner loop of the program and musteH   be as efficient as possible.  The current strategy is to use myread().  L   WARNING: this function calls parchk(), which is defined in another module.M   Normally, ckutio.c does not depend on code from any other module, but theresJ   is an exception in this case because all the other ck?tio.c modules alsoM   need to call parchk(), so it's better to have it defined in a common place.i  G   Since this function has grown to have its fingers so deeply into the eK   protocol, it is slated for removal: rpack() will take care of everything.  */ #ifdef CTRLC #undef CTRLC #endif /* CTRLC */ #define CTRLC '\03'E /*3   We have four different declarations here because: N   (a) to allow Kermit to be built without the automatic parity sensing feature4   (b) one of each type for ANSI C, one for non-ANSI. */ into #ifdef PARSENSEm #ifdef CK_ANSICMC ttinl(CHAR *dest, int max,int timo, CHAR eol, CHAR start, int turn)_ #else*N ttinl(dest,max,timo,eol,start,turn) int max,timo,turn; CHAR *dest, eol, start; #endif /* CK_ANSIC */T #else /* not PARSENSE */ #ifdef CK_ANSICO- ttinl(CHAR *dest, int max,int timo, CHAR eol)o #elsea7 ttinl(dest,max,timo,eol) int max,timo; CHAR *dest, eol;e #endif /* __SDTC__ */  #endif /* PARSENSE */ 
 /* ttinl */ {l   #ifndef MYREAD     CHAR ch; #endif /* MYREAD */n #ifdef PARSENSEX     int pktlen = -1;     int lplen = 0;     int havelen = 0; #endif /* PARSENSE */   7     if (ttyfd < 0) return(-1);          /* Not open. */x  #     debug(F101,"ttinl max","",max);e%     debug(F101,"ttinl timo","",timo);o  F     *dest = '\0';                       /* Clear destination buffer */)     if (timo < 0) timo = 0;		/* Safety */w4     if (timo) {				/* Don't time out if timo == 0 */ 	int xx;= 	saval = signal(SIGALRM,timerh);	/* Enable timer interrupt */t! 	xx = alarm(timo);		/* Set it. */ ! 	debug(F101,"ttinl alarm","",xx);,     }s     if ( #ifdef CK_POSIX_SIG  	sigsetjmp(sjbuf,1)  #elsel 	setjmp(sjbuf) #endif /* CK_POSIX_SIG */R) 	) {                /* Timer went off? */T< 	debug(F100,"ttinl timout","",0); /* Get here on timeout. */+ 	/* debug(F110," with",(char *) dest,0); */t" 	ttimoff();			/* Turn off timer */+ 	return(-1);			/* and return error code. */      } else {- 	register int i, m, n;		/* local variables */~
 	int ccn = 0;s #ifdef PARSENSE  	int flag = 0;$ 	debug(F000,"ttinl start","",start); #endif /* PARSENSE */O  F 	ttpmsk = m = (ttprty) ? 0177 : 0377; /* Set parity stripping mask. */   #ifdef COMMENT /*   No longer needed.d */
 #ifdef SUNX25 +         if (netconn && (ttnet == NET_SX25)), #ifdef PARSENSE + 	  return(x25inl(dest,max,timo,eol,start));  #elset% 	  return(x25inl(dest,max,timo,eol));" #endif /* PARSENSE */) #endif /* SUNX25 */l #endif /* COMMENT */  E /* Now read into destination, stripping parity and looking for the */0F /* the packet terminator, and also for two Ctrl-C's typed in a row. */  " 	i = 0;				/* Destination index */  	debug(F101,"ttinl eol","",eol);  
 #ifdef MYREADn 	while (i < max-1) {& 	    /* debug(F101,"ttinl i","",i); */ 	    if ((n = myread()) < 0) {- 		debug(F101,"ttinl myread failure, n","",n);r, 		debug(F101,"ttinl myread errno","",errno);& 		/* Don't let EINTR break packets. */+ 		if (n == -3 && errno == EINTR && i > 0) {f( 		    debug(F101,"ttinl myread i","",i); 		    continue;w 		}t 		break; 	    } #elset9 	while ((i < max-1)  &&  (n = read(ttyfd, &ch, 1)) > 0) {  	    n = ch; #endif /* MYREAD */p  5 	    /* debug(F101,"ttinl char","", (n & ttpmsk)); */    #ifdef PARSENSE  /*A   Figure out what the length is supposed to be in case the packetn6   has no terminator (as with Honeywell GCOS-8 Kermit). */ #ifndef xunchar/D #define xunchar(ch) (((ch) - 32 ) & 0xFF )	/* Character to number */ #endif /* xunchar */8 	    if ((flag == 0) && ((n & 0x7f) == start)) flag = 1;& 	    if (flag) dest[i++] = n & ttpmsk; /*G   If we have not been instructed to wait for a turnaround character, wetH   can go by the packet length field.  If turn != 0, we must wait for the/   end of line (eol) character before returning.  */ 	    if (i == 2) {# 		pktlen = xunchar(dest[1] & 0x7f);a 		havelen = (pktlen > 1); ' 		debug(F101,"ttinl length","",pktlen);f( 	    } else if (i == 5 && pktlen == 0) {" 		lplen = xunchar(dest[4] & 0x7f);( 	    } else if (i == 6 && pktlen == 0) {4 		pktlen = lplen * 95 + xunchar(dest[5] & 0x7f) + 5; 		havelen = 1;' 		debug(F101,"ttinl length","",pktlen);f 	    } #else* 	    dest[i++] = n & ttpmsk; #endif /* PARSENSE *// /*D   Use parity mask, rather than always stripping parity, to check forI   cancellation.  Otherwise, runs like \x03\x83\x03 in packet could cancelO#   the transfer when parity is NONE.a */ 	    /* Check cancellation */y9 	    if (!xlocal && xfrcan && ((n & ttpmsk) == xfrchr)) {y< 		if (++ccn >= xfrnum) {	/* If xfrnum in a row, bail out. */% 		    if (timo) {		/* Clear timer. *//
 			ttimoff();e 		    }l4 		    fprintf(stderr,"^C...\r\n"); /* Echo Ctrl-C */ 		    return(-2);( 		}c; 	    } else ccn = 0;		/* No cancellation, reset counter, */n   #ifdef PARSENSE  	    if (flag == 0) {r$ 		debug(F101,"ttinl skipping","",n); 		continue;R 	    } #endif /* PARSENSE */O  !     /* Check for end of packet */A  	 	    if (/ #ifdef PARSENSEt /*>   Purely length-driven if SET HANDSHAKE NONE (i.e. turn == 0).C   This allows packet terminators and handshake characters to appearg'   literally inside a packet data field.u */ 		(havelen && (i > pktlen+1) &&)* 		 (!turn || (turn && (n & 0x7f) == eol))) #ifdef COMMENT) 		(!turn && havelen && (i > pktlen+1)) ||g: 		(turn && havelen && (i > pktlen+1) && (n & 0x7f) == eol) #endif /* COMMENT */ #else /* !PARSENSE */t /*=   Built without PARSENSE, so just look for packet terminator.e */ 		((n & 0x7f) == eol)c #endif /* PARSENSE */" 		) {f #ifndef PARSENSE% 		debug(F101,"ttinl got eol","",eol); 3 		dest[i] = '\0';		/* Yes, terminate the string, */ # 		/* debug(F101,"ttinl i","",i); */n #elsee 		if ((n & 0x7f) != eol) {/ 		    debug(F101,"ttinl EOP length","",pktlen);*! 		    debug(F101,"ttinl i","",i);e, 		} else debug(F101,"ttinl got eol","",eol);. 		dest[i] = '\0';		/* Terminate the string, */ 		/* Parity checked yet? */l, 	        if (ttpflg++ == 0 && ttprty == 0) {A 		    if ((ttprty = parchk(dest,start,i)) > 0) { /* No, check. */ 	 			int j;e/ 			debug(F101,"ttinl senses parity","",ttprty);*, 			debug(F110,"ttinl packet before",dest,0); 			ttpmsk = 0x7f;a 			for (j = 0; j < i; j++)4 			  dest[j] &= 0x7f;	/* Strip parity from packet */, 			debug(F110,"ttinl packet after ",dest,0);6 		    } else ttprty = 0;	/* restore if parchk error */ 		}n #endif /* PARSENSE */-% 		if (timo) {			/* Turn off timer. */  		    ttimoff(); 		} " 		debug(F111,"ttinl got", dest,i); 		return(i); 	    } 	}				/* end of while() */ 	ttimoff();n 	return(-1);     }  }   B /*  T T I N C --  Read a character from the communication line  */ /*7  On success, returns the character that was read, >= 0.s<  On failure, returns -1 or other negative myread error code. */ int  ttinc(timo) int timo; {M       int n = 0; #ifndef MYREAD     CHAR ch = 0; #endif /* MYREAD */n  7     if (ttyfd < 0) return(-1);          /* Not open. */ $     if ((timo <= 0)			/* Untimed. */
 #ifdef MYREAD 8 	|| (my_count > 0)		/* Buffered char already waiting. */ #endif /* MYREAD */* 	) {
 #ifdef MYREADXE         /* Comm line failure returns -1 thru myread, so no &= 0377 */i. 	n = myread();			/* Wait for a character... */) 	/* debug(F000,"ttinc MYREAD n","",n); */a  	return(n < 0 ? n : n & ttpmsk); #elseuH         while ((n = read(ttyfd,&ch,1)) == 0) /* Wait for a character. *//         /* Shouldn't have to loop in ver 5A. */_ #ifdef NETCONN	  a1 	  if (netconn) {		/* Special handling for net */ 5 	      netclos();		/* If read() returns 0 it means */t6 	      netconn = 0;		/* the connection has dropped. */ 	      errno = ENOTCONN; 	      return(-2); 	  } #endif /* NETCONN */ 	  ;%      /* debug(F000,"ttinc","",ch); */ /         return( (n < 1) ? -3 : (ch & ttpmsk) );  #endif /* MYREAD */f      } else {				/* Timed read */ 	int xx;D 	saval = signal(SIGALRM,timerh);	/* Set up handler, save old one. */2 	xx = alarm(timo);		/* Set alarm, save old one. */ 	if (a #ifdef CK_POSIX_SIG  	    sigsetjmp(sjbuf,1)S #elsed 	    setjmp(sjbuf) #endif /* CK_POSIX_SIG */0 	    ) {		/* Timer expired */  	    n = -1;			/* set flag */ 	 	} else { 
 #ifdef MYREAD 3 	    n = myread();		/* If managing own buffer... */d+ 	    /* debug(F101,"ttinc myread","",n); */e #elsen< 	    n = read(ttyfd,&ch,1);	/* Otherwise call the system. */) 	    /* debug(F101,"ttinc read","",n); */a 	    if (n > 0)I 	      n = ch & 255;	 	    else09 	      n = (n < 0) ? -3 : -2;	/* Special return codes. */	 #endif /* MYREAD */e 	}& 	ttimoff();			/* Turn off the timer */ /* #ifdef COMMENT */> 	if (n == -1) xx -= timo;	/* and restore any previous alarm */8 	if (xx < 0) xx = 0;		/* adjusted by timeout interval */% 	alarm(xx);			/* if timer expired. */l /* #endif */ /* COMMENT */ #ifdef NETCONN 	if (netconn) {s+ 	    if (n == -2) {		/* read() returns 0 */r+ 		netclos();		/* on network read failure */D 		netconn = 0; 		errno = ENOTCONN;e 	    } 	} #endif	/* NETCONN */G 	return( (n < 0) ? n : (n & ttpmsk) ); /* Return masked char or neg. */(     }I }D  B /*  S N D B R K  --  Send a BREAK signal of the given duration  */   #ifndef NOLOCAL1
 static int #ifdef CK_ANSICE3 sndbrk(int msec) {			/* Argument is milliseconds */  #elset sndbrk(msec) int msec; { #endif /* CK_ANSIC */)
 #ifndef POSIXr
     int x, n;h #endif /* POSIX */   #ifdef OXOSc #define BSDBREAK #endif /* OXOS */s  
 #ifdef ANYBSDb #define BSDBREAK #endif /* ANYBSD */o   #ifdef BSD44 #define BSDBREAK #endif /* BSD44 */   #ifdef COHERENTt #define BSDBREAK #endif /* COHERENT */h  
 #ifdef PROVX11
     char spd;  #endif /* PROVX1 */   (     debug(F101,"ttsndb ttyfd","",ttyfd);7     if (ttyfd < 0) return(-1);          /* Not open. */S   #ifdef NETCONN,     if (netconn) 			/* Send network BREAK */       return(netbreak());  #endif /* NETCONN */  ?     if (msec < 1 || msec > 5000) return(-1); /* Bad argument */	  # #ifdef POSIX				/* Easy in POSIX */d'     debug(F101,"sndbrk POSIX","",msec); *     return(tcsendbreak(ttyfd,msec / 375)); #elseo
 #ifdef PROVX1 C     gtty(ttyfd,&ttbuf);                 /* Get current tty flags */r8     spd = ttbuf.sg_ospeed;              /* Save speed */?     ttbuf.sg_ospeed = B50;              /* Change to 50 baud */02     stty(ttyfd,&ttbuf);                 /*  ... */B     n = (int)strlen(brnuls);		/* Send the right number of nulls */     x = msec / 91;     if (x > n) x = n;I     write(ttyfd,brnuls,n);;     ttbuf.sg_ospeed = spd;              /* Restore speed */a2     stty(ttyfd,&ttbuf);                 /*  ... */     return(0); #elsey #ifdef aegis:     sio_$control((short)ttyfd, sio_$send_break, msec, st);     return(0); #else	 #ifdef BSDBREAK/A     n = FWRITE;                         /* Flush output queue. */ 3 /* Watch out for int vs long problems in &n arg! */c*     debug(F101,"sndbrk BSDBREAK","",msec);A     ioctl(ttyfd,TIOCFLUSH,&n);          /* Ignore any errors.. */0C     if (ioctl(ttyfd,TIOCSBRK,(char *)0) < 0) {  /* Turn on BREAK */ #         perror("Can't send BREAK");*         return(-1);;     } M     x = msleep(msec);                    /* Sleep for so many milliseconds */_D     if (ioctl(ttyfd,TIOCCBRK,(char *)0) < 0) {  /* Turn off BREAK */!         perror("BREAK stuck!!!");w>         doexit(BAD_EXIT,-1);		/* Get out, closing the line. */D                                         /*   with bad exit status */     }t     return(x); #elsed #ifdef ATTSV /*H   No way to send a long BREAK in Sys V, so send a bunch of regular ones.M   (Actually, Sys V R4 is *supposed* to have the POSIX tcsendbreak() function,i5   but there's no way for this code to know for sure.)_ */'     debug(F101,"sndbrk ATTSV","",msec);=     x = msec / 275;d     for (n = 0; n < x; n++) {,) 	if (ioctl(ttyfd,TCSBRK,(char *)0) < 0) {H  	    perror("Can't send BREAK"); 	    return(-1); 	}     }t     return(0); #elser
 #ifdef  V7$     debug(F101,"sndbrk V7","",msec);6     return(genbrk(ttyfd,250));		/* Simulate a BREAK */ #endif /* V7 */  #endif /* BSDBREAK */	 #endif /* ATTSV */ #endif /* aegis */ #endif /* PROVX1 */e #endif /* POSIX */ }f  , /*  T T S N D B  --  Send a BREAK signal  */   ints
 ttsndb() {     return(sndbrk(275)); }d  3 /*  T T S N D L B  --  Send a Long BREAK signal  */e   int  ttsndlb() {_     return(sndbrk(1500));k }  #endif /* NOLOCAL */  8 /*  M S L E E P  --  Millisecond version of sleep().  */   /*E   Call with number of milliseconds (thousandths of seconds) to sleep.PE   Intended only for small intervals.  For big ones, just use sleep().    Highly system-dependent.+   Returns 0 always, even if it didn't work.l */  @ /* Define MSLFTIME for systems that must use an ftime() loop. *// #ifdef ANYBSD				/* For pre-4.2 BSD versions */s #ifndef BSD4 #define MSLFTIME #endif /* BSD4 */n #endif /* ANYBSD */(  ' #ifdef TOWER1				/* NCR Tower OS 1.0 */m #define MSLFTIME #endif /* TOWER1 */F  ) #ifdef COHERENT         /* Coherent... */mE #ifndef _I386           /* Maybe Coherent/386 should get this, too */s2 #define MSLFTIME        /* Opinions are divided */ #endif /* _I386 */ #endif /* COHERENT */i   int* msleep(m) int m; {  
 #ifdef SELECTn     int t1;t%     debug(F101,"msleep SELECT","",m);u     if (m <= 0) return(0);1     if (m >= 1000) {			/* Catch big arguments. */  	sleep(m/1000);R 	m = m % 1000; 	if (m < 10) return(0);o     }a #ifndef COHERENT% /* Hmmm...  what's all this then?  */1G     if (gettimeofday(&tv, &tz) < 0) return(-1); /* Get current time. */o5     t1 = tv.tv_sec;                     /* Seconds *// #endif /* COHERENT */ :     tv.tv_sec = 0;                      /* Use select() */     tv.tv_usec = m * 1000L;o #ifdef BSD44<     select( 0, (fd_set *)0, (fd_set *)0, (fd_set *)0, &tv ); #else  #ifdef __linux__<     select( 0, (fd_set *)0, (fd_set *)0, (fd_set *)0, &tv ); #elses #ifdef BSD43<     select( 0, (fd_set *)0, (fd_set *)0, (fd_set *)0, &tv ); #elseg
 #ifdef QNX<     select( 0, (fd_set *)0, (fd_set *)0, (fd_set *)0, &tv ); #elsel #ifdef COHERENTb<     select( 0, (fd_set *)0, (fd_set *)0, (fd_set *)0, &tv ); #elseh3     select( 0, (int *)0, (int *)0, (int *)0, &tv );  #endif /* COHERENT */k #endif /* QNX */ #endif /* BSD43 */ #endif /* __linux__ */ #endif /* BSD44 */     return(0);   #else					/* Not SELECT */ #ifdef CK_POLL#     debug(F101,"msleep POLL","",m); $     poll((struct pollfd *) 0, 0, m);     return(0);   #else					/* Not POLL */
 #ifdef USLEEP. /*D   "This routine is implemented using setitimer(2); it requires eightE   system calls...".  In other words, it might take 5 minutes to sleep    for 100 milliseconds...T */%     debug(F101,"msleep USLEEP","",m); 1     if (m >= 1000) {			/* Catch big arguments. */e 	sleep(m/1000);s 	m = m % 1000; 	if (m < 10) return(0);      } %     usleep((unsigned int)(m * 1000));e     return(0); #elseo #ifdef aegis     time_$clock_t dur;  $     debug(F101,"msleep aegis","",m);     dur.c2.high16 = 0;O     dur.c2.low32  = 250 * m; /* one millisecond = 250 four microsecond ticks */m(     time_$wait(time_$relative, dur, st);     return(0); #elseh
 #ifdef PROVX1 $     debug(F101,"msleep Venix","",m);     if (m <= 0) return(0);$     sleep(-((m * 60 + 500) / 1000));     return(0); #elseo
 #ifdef NAP"     debug(F101,"msleep NAP","",m);     nap((long)m);t     return(0); #elseu #ifdef ATTSV
 #ifndef BSD44 7     extern long times();		/* Or #include <times.h> ? */  #endif /* BSD44 */     long t1, t2, tarray[4];(     int t3;g   #ifdef COMMENT- /* This better be picked up in ckcdeb.h... */G     char *getenv();* #endif /* COMMENT */     char *cp = getenv("HZ");     int CLOCK_TICK;=     int hertz;  #     if (cp && (hertz = atoi(cp))) { #         CLOCK_TICK  = 1000 / hertz;r/     } else {				/* probably single user mode */s	 #ifdef HZv!         CLOCK_TICK  = 1000 / HZ;	s #else" 	static warned = 0;OF 	/* HZ always exists in, for instance, SCO Xenix, so you don't have toE 	 * make special #ifdefs for XENIX here, like in ver 4F. Also, if you_G 	 * have Xenix, you have should have nap(), so the best is to use -DNAP * 	 * in the makefile. Most systems have HZ. 	 */! 	CLOCK_TICK = 17;		/* 1/60 sec */X 	if (!warned) {aK           printf("warning: environment variable HZ bad... using HZ=%d\r\n",a 		 1000 / CLOCK_TICK);           warned = 1;  	} #endif /* !HZ */     }|$     debug(F101,"msleep ATTSV","",m);     if (m <= 0) return(0);1     if (m >= 1000) {			/* Catch big arguments. */  	sleep(m/1000);p 	m = m % 1000; 	if (m < 10) return(0);i     }e-     if ((t1 = times(tarray)) < 0) return(-1);      while (1) {s1         if ((t2 = times(tarray)) < 0) return(-1); +         t3 = ((int)(t2 - t1)) * CLOCK_TICK;          if (t3 > m) return(t3);      }  #else /* Not ATTSV */4, #ifdef MSLFTIME				/* Use ftime() loop... */     int t1, t3 = 0;d'     debug(F101,"msleep MSLFTIME","",m);t     if (m <= 0) return(0);1     if (m >= 1000) {			/* Catch big arguments. */  	sleep(m/1000);/ 	m = m % 1000; 	if (m < 10) return(0);      }v
 #ifdef QNX,     ftime(&ftp);			/* void ftime() in QNX */ #else 9     if (ftime(&ftp) < 0) return(-1);	/* Get base time. */e #endif /* QNX */2     t1 = ((ftp.time & 0xff) * 1000) + ftp.millitm;     while (1) {/:         ftime(&ftp);			/* Get current time and compare. */=         t3 = (((ftp.time & 0xff) * 1000) + ftp.millitm) - t1;.         if (t3 > m) return(0);     }= #elseD< /* This includes true POSIX, which has no way to do this. */(     debug(F101,"msleep busy loop","",m);1     if (m >= 1000) {			/* Catch big arguments. */f 	sleep(m/1000);u 	m = m % 1000; 	if (m < 10) return(0);(     }T=     if (m > 0) while (m > 0) m--;	/* Just a dumb busy loop */(     return(0); #endif /* MSLFTIME */t #endif /* ATTSV */ #endif /* NAP */ #endif /* PROVX1 */( #endif /* aegis */ #endif /* SELECT */l #endif /* CK_POLL */ #endif /* USLEEP */a };  2 /*  R T I M E R --  Reset elapsed time counter  */   VOID
 rtimer() {"     tcount = time( (time_t *) 0 ); }t    L /*  G T I M E R --  Get current value of elapsed time counter in seconds  */   int 
 gtimer() {
     int x;.     x = (int) (time( (time_t *) 0 ) - tcount);     debug(F101,"gtimer","",x);     return( (x < 0) ? 0 : x ); }i    . /*  Z T I M E  --  Return date/time string  */   VOID ztime(s) char **s; {  1 #undef ZTIMEV7				/* Which systems need to use */h2 #ifdef COHERENT				/* old UNIX Version 7 way... */ #define ZTIMEV7b #endif /* COHERENT */7
 #ifdef TOWER1C #define ZTIMEV7y #endif /* TOWER1 */t
 #ifdef ANYBSDt
 #ifndef BSD42r #define ZTIMEV7a #endif /* BSD42 */ #endif /* ANYBSD */s	 #ifdef V7a
 #ifndef MINIXt #define ZTIMEV7G #endif /* MINIX */ #endif /* V7 */g #ifdef POSIX #define ZTIMEV7e #endif /* POSIX */   #ifdef ATTSV				/* AT&T way */< /*  extern long time(); */		/* Theoretically these should */9     char *ctime();			/* already been dcl'd in <time.h> */P     long clock_storage;o'     clock_storage = time( (long *) 0 );s!     *s = ctime( &clock_storage );p #else($ #ifdef PROVX1				/* Venix 1.0 way */     int utime[2];P     time(utime);     *s = ctime(utime); #else7  #ifdef BSD42				/* 4.2BSD way */     char *asctime();     struct tm *localtime();*     struct tm *tp;     gettimeofday(&tv, &tz);i     time(&tv.tv_sec);*     tp = localtime(&tv.tv_sec);      *s = asctime(tp);' #elsef #ifdef MINIX				/* MINIX way */i #ifdef COMMENT?     extern long time();			/* Already got these from <time.h> */      extern char *ctime();i #endif /* COMMENT */     time_t utime[2];     time(utime);     *s = ctime(utime); #else ' #ifdef ZTIMEV7				/* The regular way */s     char *asctime();     struct tm *localtime();O     struct tm *tp;     long xclock;     time(&xclock);     tp = localtime(&xclock);     *s = asctime(tp);t' #else					/* Catch-all for others... */sL     *s = "Ddd Mmm 00 00:00:00 0000\n"	/* Return dummy in asctime() format */ #endif /* ZTIMEV7 */ #endif /* MINIX */ #endif /* BSD42 */ #endif /* PROVX1 */n #endif /* SVORPOSIX */ }   2 /*  C O N G M  --  Get console terminal modes.  */   /*E   Saves initial console mode, and establishes variables for switchingr;   between current (presumably normal) mode and other modes.PC   Should be called when program starts, but only after establishingt5   whether program is in the foreground or background.NE   Returns 1 if it got the modes OK, 0 if it did nothing, -1 on error.* */ inta	 congm() {m     int fd; 8     if (backgrd || !isatty(0)) {	/* If in background. */4 	cgmf = -1;			/* Don't bother, modes are garbage. */ 	return(-1);     }t5     if (cgmf > 0) return(0);		/* Already did this. */ @     debug(F100,"congm getting modes","",0); /* Need to do it. */ #ifdef aegis.     ios_$inq_type_uid(ios_$stdin, conuid, st);     if (st.all != status_$ok) { 4 	fprintf(stderr, "problem getting stdin objtype: "); 	error_$print(st);     }a"     concrp = (conuid == mbx_$uid);     conbufn = 0; #endif /* aegis */  D     if ((fd = open(CTTNAM,2)) < 0) {	/* Open controlling terminal */ #ifdef COMMENT. 	fprintf(stderr,"Error opening %s\n", CTTNAM); 	perror("congm");i 	return(-1); #elsed 	fd = 0; #endif /* COMMENT */     }, #ifdef BSD44ORPOSIX*-     if (tcgetattr(fd,&ccold) < 0) return(-1); .     if (tcgetattr(fd,&cccbrk) < 0) return(-1);-     if (tcgetattr(fd,&ccraw) < 0) return(-1);O #else/ #ifdef ATTSV1     if (ioctl(fd,TCGETA,&ccold)  < 0) return(-1); 1     if (ioctl(fd,TCGETA,&cccbrk) < 0) return(-1); 1     if (ioctl(fd,TCGETA,&ccraw)  < 0) return(-1);b #ifdef VXVE 8     cccbrk.c_line = 0;			/* STTY line 0 for CDC VX/VE */1     if (ioctl(fd,TCSETA,&cccbrk) < 0) return(-1); 7     ccraw.c_line = 0;			/* STTY line 0 for CDC VX/VE */h0     if (ioctl(fd,TCSETA,&ccraw) < 0) return(-1); #endif /* VXVE */N #elsee(     if (gtty(fd,&ccold) < 0) return(-1);)     if (gtty(fd,&cccbrk) < 0) return(-1); (     if (gtty(fd,&ccraw) < 0) return(-1); #endif /* ATTSV */ #endif /* BSD44ORPOSIX */ " #ifdef sony_news			/* Sony NEWS */F     if (ioctl(fd,TIOCKGET,&km_con) < 0) { /* Get console Kanji mode */* 	perror("congm error getting Kanji mode");3 	debug(F101,"congm error getting Kanji mode","",0);f5 	km_con = -1;			/* Make sure this stays undefined. */u 	return(-1);     }/ #endif /* sony_news */     if (fd > 0)e       close(fd);-     cgmf = 1;				/* Flag that we got them. */o     return(1); }h    1 /*  C O N C B --  Put console in cbreak mode.  */n  " /*  Returns 0 if ok, -1 if not  */   inta #ifdef CK_ANSICr concb(char esc)r #elsek concb(esc) char esc; #endif /* CK_ANSIC */ 
 /* concb */ { 
     int x;%     debug(F101,"concb cgmf","",cgmf);,+     debug(F101,"concb backgrd","",backgrd);a  7     if (cgmf < 1)			/* Did we get console modes yet? */c.       if (!backgrd)			/* No, in background? */* 	congm();			/* No, try to get them now. */0     if (cgmf < 1)			/* Still don't have them? */!       return(0);			/* Give up. */m'     debug(F101,"concb ttyfd","",ttyfd);*+     debug(F101,"concb ttfdflg","",ttfdflg);x+     if (ttfdflg && ttyfd >= 0 && ttyfd < 3)        return(0);@     if (!isatty(0)) return(0);          /* Only for real ttys */$     debug(F100,"concb isatty","",0);+     debug(F101,"concb suspend","",suspend); ?     if (backgrd) return(0);		/* Do nothing if in background. */eN     escchr = esc;                       /* Make this available to other fns */I     ckxech = 1;                         /* Program can echo characters */r #ifdef aegis     conbufn = 0;0     if (concrp) return(write(1, "\035\002", 2));H     if (conuid == input_pad_$uid) {pad_$raw(ios_$stdin, st); return(0);} #endif /* aegis */   #ifdef COHERENT  #define SVORPOSIX( #endif /* COHERENT */   & #ifndef SVORPOSIX			/* BSD, V7, etc */F     cccbrk.sg_flags |= CBREAK;          /* Set to character wakeup, */6     cccbrk.sg_flags &= ~ECHO;           /* no echo. */     x = stty(0,&cccbrk); #else					/* Sys V and POSIX */e #ifndef OXOS8     debug(F101,"concb cccbrk.c_flag","",cccbrk.c_lflag);
 #ifdef QNX      /* Don't mess with IEXTEN */%     cccbrk.c_lflag &= ~(ICANON|ECHO);, #elseI #ifdef COHERENT	%     cccbrk.c_lflag &= ~(ICANON|ECHO);T #else ,     cccbrk.c_lflag &= ~(ICANON|ECHO|IEXTEN); #endif /* COHERENT */, #endif /* QNX */I     cccbrk.c_lflag |= ISIG;    	/* Allow SIGINT, etc, in command mode. */B #else /* OXOS */-     debug(F100,"concb OXOS is defined","",0); %     cccbrk.c_lflag &= ~(ICANON|ECHO);L;     cccbrk.c_cc[VDISCARD] = cccbrk.c_cc[VLNEXT] = CDISABLE;; #endif /* OXOS */F #ifdef VSUSP:     debug(F101,"concb c_cc[VSUSP]","",cccbrk.c_cc[VSUSP]); #endif /* VSUSP */
 #ifndef VINTR 2     debug(F101,"concb c_cc[0]","",cccbrk.c_cc[0]);I     cccbrk.c_cc[0] = 003;               /* Interrupt char is Control-C */  #else 6     debug(F101,"concb c_cc[VINTR]","",cccbrk.c_cc[0]);     cccbrk.c_cc[VINTR] = 003;O #endif /* VINTR */
 #ifndef VQUITtH     cccbrk.c_cc[1] = escchr;            /* escape during packet modes */ #else0      cccbrk.c_cc[VQUIT] = escchr; #endif /* VQUIT */ #ifndef VEOF     cccbrk.c_cc[4] = 1;" #else  #ifndef OXOS #ifdef VMIN      cccbrk.c_cc[VMIN] = 1; #endif /* VMIN */l #else /* OXOS */     cccbrk.c_min = 1;l #endif /* OXOS */c #endif /* VEOF */l #ifdef ZILOG     cccbrk.c_cc[5] = 0;S #elsel #ifndef VEOL     cccbrk.c_cc[5] = 1;s #elseT #ifndef OXOS #ifdef VTIME     cccbrk.c_cc[VTIME] = 1;t #endif /* VTIME */ #else /* OXOS */     cccbrk.c_time = 1; #endif /* OXOS */o #endif /* VEOL */1 #endif /* ZILOG */) #ifdef BSD44ORPOSIX			/* Set new modes */1'     x = tcsetattr(0,TCSADRAIN,&cccbrk);l0 #else /* ATTSV */      			/* or the POSIX way */5     x = ioctl(0,TCSETAW,&cccbrk);	/* the Sys V way */) #endif /* BSD44ORPOSIX */  #endif /* SVORPOSIX */   #ifdef COHERENTe #undef SVORPOSIX #endif /* COHERENT */I  
 #ifndef aegist #ifndef NOSETBUFF     if (x > -1) setbuf(stdout,NULL);    /* Make console unbuffered. */ #endif /* NOSETBUF */e #endif /* aegis */  
 #ifdef  V7
 #ifndef MINIXD     if (kmem[CON] < 0) {!         qaddr[CON] = initrawq(0);x4         if((kmem[CON] = open("/dev/kmem", 0)) < 0) {@             fprintf(stderr, "Can't read /dev/kmem in concb.\n");              perror("/dev/kmem");             exit(1);	         }d     }_ #endif /* MINIX */ #endif /* V7 */n%     debug(F101,"concb returns","",x);      return(x); }s  3 /*  C O N B I N  --  Put console in binary mode  */E  " /*  Returns 0 if ok, -1 if not  */   intK #ifdef CK_ANSIC  conbin(char esc) #elses conbin(esc) char esc;) #endif /* CK_ANSIC */} /* conbin */  {u@     if (!isatty(0)) return(0);          /* only for real ttys */-     congm();				/* Get modes if necessary. */e     debug(F100,"conbin","",0);N     escchr = esc;                       /* Make this available to other fns */I     ckxech = 1;                         /* Program can echo characters */l #ifdef aegis     conbufn = 0;0     if (concrp) return(write(1, "\035\002", 2));#     if (conuid == input_pad_$uid) {i 	pad_$raw(ios_$stdin, st); 	return(0);n       }t #endif /* aegis */   #ifdef COHERENTy #define SVORPOSIX  #endif /* COHERENT */s   #ifdef SVORPOSIX #ifndef OXOS
 #ifdef QNX)     ccraw.c_lflag &= ~(ISIG|ICANON|ECHO);  #else  #ifdef COHERENT )     ccraw.c_lflag &= ~(ISIG|ICANON|ECHO);  #elsei0     ccraw.c_lflag &= ~(ISIG|ICANON|ECHO|IEXTEN); #endif /* COHERENT */i #endif /* QNX */ #else /* OXOS */)     ccraw.c_lflag &= ~(ISIG|ICANON|ECHO);P9     ccraw.c_cc[VDISCARD] = ccraw.c_cc[VLNEXT] = CDISABLE;F #endif /* OXOS */e%     ccraw.c_iflag |= (BRKINT|IGNPAR);= #ifdef ATTSV #ifdef BSD44@     ccraw.c_iflag &= ~(IGNBRK|INLCR|IGNCR|ICRNL|IXON|IXANY|IXOFF'                         |INPCK|ISTRIP);% #else%F     ccraw.c_iflag &= ~(IGNBRK|INLCR|IGNCR|ICRNL|IUCLC|IXON|IXANY|IXOFF'                         |INPCK|ISTRIP);  #endif /* BSD44 */ #else /* POSIX */mI     ccraw.c_iflag &= ~(IGNBRK|INLCR|IGNCR|ICRNL|IXON|IXOFF|INPCK|ISTRIP);l #endif /* ATTSV */     ccraw.c_oflag &= ~OPOST; #ifdef COMMENT /*   WHAT THE HECK WAS THIS FOR? D   The B9600 setting (obviously) prevents CONNECT from working at anyF   speed other than 9600 when you are logged in to the 7300 on a serialG   line.  Maybe some of the other flags are necessary -- if so, put backfG   the ones that are needed.  This code is supposed to work the same, noRJ   matter whether you are logged in to the 7300 on the real console device,   or through a serial port.d */ #ifdef ATT73009     ccraw.c_cflag = CLOCAL | B9600 | CS8 | CREAD | HUPCL;  #endif /* ATT7300 */ #endif /* COMMENT */  J /*** Kermit used to put the console in 8-bit raw mode, but some users haveH  *** pointed out that this should not be done, since some sites actuallyH  *** use terminals with parity settings on their Unix systems, and if weN  *** override the current settings and stop doing parity, then their terminalsL  *** will display blotches for characters whose parity is wrong.  Therefore,H  *** the following two lines are commented out (Larry Afrin, Clemson U):  ***(  ***   ccraw.c_cflag &= ~(PARENB|CSIZE);$  ***   ccraw.c_cflag |= (CS8|CREAD);  ***I  *** Sys III/V sites that have trouble with this can restore these lines.e  ***/g
 #ifndef VINTRh8     ccraw.c_cc[0] = 003;		/* Interrupt char is Ctrl-C */ #else.     ccraw.c_cc[VINTR] = 003; #endif /* VINTR */
 #ifndef VQUITf<     ccraw.c_cc[1] = escchr;		/* Escape during packet mode */ #else      ccraw.c_cc[VQUIT] = escchr;  #endif /* VQUIT */ #ifndef VEOF     ccraw.c_cc[4] = 1; #elset #ifndef OXOS #ifdef VMINt     ccraw.c_cc[VMIN] = 1;e #endif /* VMIN */t #else /* OXOS */     ccraw.c_min = 1; #endif /* OXOS */i #endif /* VEOF */c   #ifdef ZILOG     ccraw.c_cc[5] = 0; #elset #ifndef VEOL     ccraw.c_cc[5] = 1; #elset #ifndef OXOS #ifdef VTIME     ccraw.c_cc[VTIME] = 1; #endif /* VTIME */ #else /* OXOS */     ccraw.c_time = 1;t #endif /* OXOS */a #endif /* VEOL */k #endif /* ZILOG */   #ifdef BSD44ORPOSIXe*     return(tcsetattr(0,TCSADRAIN,&ccraw)); #else 9     return(ioctl(0,TCSETAW,&ccraw));	/* Set new modes. */s #endif /* BSD44ORPOSIX */i   #else /* Berkeley, etc. */H     ccraw.sg_flags |= (RAW|TANDEM);     /* Set rawmode, XON/XOFF (ha) */F     ccraw.sg_flags &= ~(ECHO|CRMOD);    /* Set char wakeup, no echo */     return(stty(0,&ccraw));  #endif /* SVORPOSIX */   #ifdef COHERENTs #undef SVORPOSIX #endif /* COHERENT */i   }     5 /*  C O N R E S  --  Restore the console terminal  */y   intr
 conres() {&     debug(F101,"conres cgmf","",cgmf);A     if (cgmf < 1) return(0);		/* Do nothing if modes unchanged */c@     if (!isatty(0)) return(0);          /* only for real ttys */(     debug(F100,"conres isatty ok","",0);F     ckxech = 0;                         /* System should echo chars */   #ifdef aegis     conbufn = 0;0     if (concrp) return(write(1, "\035\001", 2));#     if (conuid == input_pad_$uid) {R 	pad_$cooked(ios_$stdin, st);  	return(0);      }  #endif /* aegis */   #ifdef BSD44ORPOSIX 2     debug(F100,"conres restoring tcsetattr","",0);*     return(tcsetattr(0,TCSADRAIN,&ccold)); #elsee #ifdef ATTSV.     debug(F100,"conres restoring ioctl","",0);$     return(ioctl(0,TCSETAW,&ccold));  #else /* BSD, V7, and friends */" #ifdef sony_news			/* Sony NEWS */     if (km_con != -1)aA       ioctl(0,TIOCKSET,&km_con);	/* Restore console Kanji mode */E #endif /* sony_news */     msleep(100);-     debug(F100,"conres restoring stty","",0);	     return(stty(0,&ccold));. #endif /* ATTSV */ #endif /* BSD44ORPOSIX */t }   A /*  C O N O C  --  Output a character to the console terminal  */    intr #ifdef CK_ANSIC*
 conoc(char c)e #else* conoc(c) char c; #endif /* CK_ANSIC */<
 /* conoc */ {>     return(write(1,&c,1)); }*  A /*  C O N X O  --  Write x characters to the console terminal  */)   int> conxo(x,s) int x; char *s; {     return(write(1,s,x));  }e  ; /*  C O N O L  --  Write a line to the console terminal  */d   intF conol(s) char *s; {f     int len;     len = (int)strlen(s);      return(write(1,s,len));  }l  G /*  C O N O L A  --  Write an array of lines to the console terminal */    int. conola(s) char *s[]; {
     int i;=     for (i=0 ; *s[i] ; i++) if (conol(s[i]) < 0) return(-1);;e     return(0); }   9 /*  C O N O L L  --  Output a string followed by CRLF  */;   inte conoll(s) char *s; {
     conol(s);n     return(write(1,"\r\n",2)); }   H /*  C O N C H K  --  Return how many characters available at console  */ /*J   We could also use select() here to cover a few more systems that are notD   covered by any of the following, e.g. HP-UX 9.0x on the model 800. */ inte
 conchk() {=     static int contyp = 0;		/* +1 for isatty, -1 otherwise */D  6     if (contyp == 0)			/* This prevents unnecessary */G       contyp = (isatty(0) ? 1 : -1);	/* duplicated calls to isatty() */F*     debug(F101,"conchk contyp","",contyp);      if (backgrd || (contyp < 0))       return(0);   #ifdef aegisF     if (conbufn > 0) return(conbufn);   /* use old count if nonzero */  !     /* read in more characters */	"     conbufn = ios_$get(ios_$stdin,?               ios_$cond_opt, conbuf, (long)sizeof(conbuf), st); *     if (st.all != status_$ok) conbufn = 0;     conbufp = conbuf;      return(conbufn); #else.     return(in_chk(0)); #endif /* aegis */ }   9 /*  C O N I N C  --  Get a character from the console  */* /*L   Call with timo > 0 to do a timed read, timo == 0 to do an untimed blockingH   read.  Upon success, returns the character.  Upon failure, returns -1.K   A timed read that does not complete within the timeout period returns -1.( */ int) coninc(timo) int timo; {     int n = 0; CHAR ch;	     int xx;e* #ifdef aegis				/* Apollo Aegis only... */&     debug(F101,"coninc timo","",timo);     fflush(stdout);e     if (conchk() > 0) {t 	--conbufn;f 	return(*conbufp++ & 0377);i     }H #endif /* aegis */  E     if (timo <= 0 ) {                   /* Untimed, blocking read. */m1 	while (1) {			/* Keep trying till we get one. */r1 	    n = read(0, &ch, 1);	/* Read a character. */.2 	    if (n == 0) continue;	/* Shouldn't happen. *// 	    if (n > 0)			/* If read was successful, */ 5 	      return(ch & 0377);	/* return the character. */e  , /* Come here if read() returned an error. */  B 	    debug(F101, "coninc(0) errno","",errno); /* Log the error. */ #ifndef OXOS #ifdef SVORPOSIXM #ifdef CIE                             /* CIE Regulus has no EINTR symbol? */d
 #ifndef EINTR  #define EINTR 4, #endif /* EINTR */ #endif /* CIE */ /*N   This routine is used for several different purposes.  In CONNECT mode, it isM   used to do an untimed, blocking read from the keyboard in the lower CONNECTwG   fork.  During local-mode file transfer, it reads a character from the=J   console to interrupt the file transfer (like A for a status report, X toM   cancel a file, etc).  Obviously, we don't want the reads in the latter caseIF   to be blocking, or the file transfer would stop until the user typedM   something.  Unfortunately, System V does not allow the console device input J   buffer to be sampled nondestructively (e.g. by conchk()), so a kludge isM   used instead.  During local-mode file transfer, the SIGQUIT signal is armed.J   and trapped by esctrp(), and this routine pretends to have read the quitM   character from the keyboard normally.  But, kludge or no kludge, the read()eJ   issued by this command, under System V only, can fail if a signal -- ANYN   signal -- is caught while the read is pending.  This can occur not only whenN   the user types the quit character, but also during telnet negotiations, whenL   the lower CONNECT fork signals the upper one about an echoing mode change.N   When this happens, we have to post the read() again.  This is apparently not'   a problem in BSD-based UNIX versions.i */1 	    if (errno == EINTR)		/* Read interrupted. */ + 	      if (conesc)  {		/* If by SIGQUIT, */l2  		 conesc = 0;		/* the conesc variable is set, */9  		 return(escchr);	/* so return the escape character. */i9 	     } else continue;		/* By other signal, try again. */S #else  /*J   This might be dangerous, but let's do this on non-System V versions too,K   since at least one SunOS 4.1.2 user complains of immediate disconnectionsk(   upon first making a TELNET connection. */1 	    if (errno == EINTR)		/* Read interrupted. */d 	      continue; #endif /* SVORPOSIX */ #else /* OXOS */1 	    if (errno == EINTR)		/* Read interrupted. */e 	      continue; #endif /* OXOS */  	    return(-1);			/* Error */ 	}     }o       if (timo <= 0)$       /* This should never happen *//       debug(F100,"coninc HORRIBLE ERROR","",0);n   /* Timed read... */f  A     saval = signal(SIGALRM,timerh);	/* Set up timeout handler. */k,     xx = alarm(timo);			/* Set the alarm. */)     debug(F101,"coninc alarm set","",xx);i     if ( #ifdef CK_POSIX_SIG  	sigsetjmp(sjbuf,1)& #else+ 	setjmp(sjbuf) #endif /* CK_POSIX_SIG */=! 	)				/* The read() timed out. */i(       n = -2;				/* Code for timeout. */     else       n = read(0, &ch, 1);&     ttimoff();				/* Turn off timer */)     if (n > 0)				/* Got character OK. */f*       return(ch & 0377);		/* Return it. */   /*F   read() returned an error.  Same deal as above, but without the loop. */'     debug(F101, "coninc(timo) n","",n);c/     debug(F101, "coninc(timo) errno","",errno);  #ifndef OXOS #ifdef SVORPOSIX3     if (n == -1 && errno == EINTR && conesc != 0) {t 	conesc = 0;7 	return(escchr);			/* User entered escape character. */ ,     } else				/* n == 0 shouldn't happen. */ #endif /* SVORPOSIX */ #endif /* ! OXOS */i       return(-1);  }   6 /*  C O N G K S  --  Console Get Keyboard Scancode  */   #ifndef congks /*G   This function needs to be filled in with the various system-dependent/I   system calls used by SUNOS, NeXT OS, Xenix, Aviion, etc, to read a full -   keyboard scan code.  For now, it's a dummy.	 */ inti congks(timo) int timo; {     return(coninc(timo));i }l #endif /* congks */d   #ifdef ATT7300  E /*  A T T D I A L  --  Dial up the remote system using internal modem L  * Purpose: to open and dial a number on the internal modem available on theJ  * ATT7300 UNIX PC.  Written by Joe Doupnik. Superceeds version written by;  * Richard E. Hill, Dickinson, TX. which employed dial(3c). A  * Uses information in <sys/phone.h> and our status int attmodem.   */ @ attdial(ttname,speed,telnbr) char *ttname,*telnbr; long speed; {     char *telnum;n     int ttclos();f  J     attmodem &= ~ISMODEM;                       /* modem not in use yet */H                     /* Ensure O_NDELAY is set, else i/o traffic hangs */I                     /* We turn this flag off once the dial is complete */m?     fcntl(ttyfd, F_SETFL, fcntl(ttyfd, F_GETFL, 0) | O_NDELAY);k  I     /* Condition line, check availability & DATA mode, turn on speaker */f2     if (ioctl(ttyfd,PIOCOFFHOOK, &dialer) == -1) {(         printf("cannot access phone\n");         ttclos(0);         return (-2);     }CI     ioctl(ttyfd,PIOCGETP,&dialer);      /* get phone dialer parameters */l  F     if (dialer.c_lineparam & VOICE) {	/* phone must be in DATA mode */?         printf(" Should not dial with modem in VOICE mode.\n"); A         printf(" Exit Kermit, switch to DATA and retry call.\n");          ttclos(0);         return (-2);     }l4 #ifdef ATTTONED				/* Old way, tone dialing only. */<     dialer.c_lineparam = DATA | DTMF;	/* Dial with tones, */8     dialer.c_lineparam &= ~PULSE;	/* not with pulses. */ #elsee/     /* Leave current pulse/tone state alone. */h@     /* But what about DATA?  Add it back if you have trouble. */J     /* sys/phone says you get DATA automatically by opening device RDWR */ #endifM     dialer.c_waitdialtone = 5;                  /* wait 5 sec for dialtone */d #ifdef COMMENTH     dialer.c_feedback = SPEAKERON|NORMSPK|RINGON;  /* control speaker */ #elsedB     /* sys/phone says RINGON used only for incoming voice calls */,     dialer.c_feedback &= ~(SOFTSPK|LOUDSPK);+     dialer.c_feedback |= SPEAKERON|NORMSPK;I #endifH     dialer.c_waitflash = 500;                   /* 0.5 sec flash hook */J     if(ioctl(ttyfd,PIOCSETP,&dialer) == -1) {   /* set phone parameters */5         printf("Cannot set modem characteristics\n");f         ttclos(0);         return (-2);     }p@     ioctl(ttyfd,PIOCRECONN,0);		/* Turns on speaker for pulse */   #ifdef COMMENTE     fprintf(stderr,"Phone line status. line_par:%o dialtone_wait:%o \H line_status:%o feedback:%o\n",.     dialer.c_lineparam, dialer.c_waitdialtone,,     dialer.c_linestatus, dialer.c_feedback); #endif  I     attmodem |= ISMODEM;                        /* modem is now in-use *//
     sleep(1); I     for (telnum = telnbr; *telnum != '\0'; telnum++)    /* dial number */  #ifdef ATTTONED/       /* Tone dialing only */i.       if (ioctl(ttyfd,PIOCDIAL,telnum) != 0) { 	  perror("Error in dialing");
 	  ttclos(0);' 	  return(-2);       }m' #else /* Allow Pulse or Tone dialing */d     switch (*telnum) {@       case 't': case 'T': case '%':	/* Tone dialing requested */ 	dialer.c_lineparam |= DTMF; 	dialer.c_lineparam &= ~PULSE;+ 	if (ioctl(ttyfd,PIOCSETP,&dialer) == -1) {e2 	    printf("Cannot set modem to tone dialing\n"); 	    ttclos(0);d 	    return(-2); 	} 	break;N7       case 'd': case 'D': case 'p': case 'P': case '^':" 	dialer.c_lineparam |= PULSE;i 	dialer.c_lineparam &= ~DTMF; + 	if (ioctl(ttyfd,PIOCSETP,&dialer) == -1) { 3 	    printf("Cannot set modem to pulse dialing\n");  	    ttclos(0);  	    return(-2); 	} 	break;d       default:0         if (ioctl(ttyfd,PIOCDIAL,telnum) != 0) { 	    perror("Dialing error");" 	    ttclos(0);i 	    return(-2); 	} 	break;t     }  #endif  >     ioctl(ttyfd,PIOCDIAL,"@");		/* terminator for data call */,     do {				/* wait for modems to Connect */B         if (ioctl(ttyfd,PIOCGETP,&dialer) != 0)	{ /* get params */, 	    perror("Cannot get modems to connect"); 	    ttclos(0);e 	    return(-2); 	}:     } while ((dialer.c_linestatus & MODEMCONNECTED) == 0);%     /* Turn off O_NDELAY flag now. */l@     fcntl(ttyfd, F_SETFL, fcntl(ttyfd, F_GETFL, 0) & ~O_NDELAY);G     signal(SIGHUP, ttclos);             /* hangup on loss of carrier */;<     return(0);                          /* return success */ }c   /*E   Offgetty, ongetty functions. These function get the 'getty(1m)' off B   and restore it to the indicated line.  Shell's return codes are:/     0: Can't do it.  Probably a user logged on. '     1: No need.  No getty on that line.c;     2: Done, you should restore the getty when you're done./G   DOGETY System(3), however, returns them as 0, 256, 512, respectively. 3   Thanks to Kevin O'Gorman, Anarm Software Systems.m  /    getoff.sh looks like:   geton.sh looks like:,*      setgetty $1 0           setgetty $1 1$      err=$?                  exit $?      sleep 2      exit $err */  K /*  O F F G E T T Y  --  Turn off getty(1m) for the communications tty line C  * and get status so it can be restarted after the line is hung up.   */f inth  offgetty(ttname) char *ttname; {     char temp[30];I     while (*ttname != '\0') ttname++;       /* seek terminator of path */eJ     ttname -= 3;                            /* get last 3 chars of name */1     sprintf(temp,"/usr/bin/getoff.sh %s",ttname);.     return(zsyscmd(temp)); }i  K /*  O N G E T T Y  --  Turn on getty(1m) for the communications tty line */r   intl ongetty(ttname) char *ttname; {      char temp[30];E     while (*ttname != '\0') ttname++;       /* comms tty path name */0     ttname -= 3;0     sprintf(temp,"/usr/bin/geton.sh %s",ttname);     return(zsyscmd(temp)); }t #endif /* ATT7300 */  I /*  T T S C A R R  --  Set ttcarr variable, controlling carrier handling.G  *I  *  0 = Off: Always ignore carrier. E.g. you can connect without carrier.CO  *  1 = On: Heed carrier, except during dialing. Carrier loss gives disconnect.E4  *  2 = Auto: For "modem direct": The same as "Off".K  *            For real modem types: Heed carrier during connect, but ignorefM  *                it anytime else.  Compatible with pre-5A C-Kermit versions.(  *M  * As you can see, this setting does not affect dialing, which always ignoreseL  * carrier (unless there is some special exception for some modem type).  ItK  * does affect ttopen() if it is set before ttopen() is used.  This setting(J  * takes effect on the next call to ttopen()/ttpkt()/ttvt().  And they areI  * (or should be) always called before any communications is tried, whichh=  * means that, practically speaking, the effect is immediate.!  *B  * Of course, nothing of this applies to remote mode (xlocal = 0).  *F  * Someone has yet to uncover how to manipulate the carrier in the BSDL  * environment (or any non-termio using environment).  Until that time, this"  * will simply be a no-op for BSD.  *L  * Note that in previous versions, the carrier was most often left unchangedM  * in ttpkt()/ttvt() unless they were called with FLO_DIAL or FLO_DIAX.  This/I  * has changed.  Now it is controlled by ttcarr in conjunction with these 	  * modes.   */i into ttscarr(carrier) int carrier; {t     ttcarr = carrier;r%     debug(F101, "ttscarr","",ttcarr);      return(ttcarr);  }s  : /* C A R R C T L  --  Set tty modes for carrier treatment.  *M  * Sets the appropriate bits in a termio or sgttyb struct for carrier control0J  * (actually, there are no bits in sgttyb for that), or performs any otherN  * operations needed to control this on the current system.  The function doesN  * not do the actual TCSETA or stty, since often we want to set other bits tooO  * first.  Don't call this function when xlocal is 0, or the tty is not opened.n  *N  * We don't know how to do anything like carrier control on non-ATTSV systems,N  * except, apparently, ultrix.  See above.  It is also known that this doesn'tM  * have much effect on a Xenix system.  For Xenix, one should switch back and=F  * forth between the upper and lower case device files.  Maybe later. >  * Presently, Xenix will stick to the mode it was opened with.  *4  * carrier: 0 = ignore carrier, 1 = require carrier.E  * The current state is saved in curcarr, and checked to save labour.e  */a #ifdef SVORPOSIX int  #ifdef BSD44ORPOSIXl; carrctl(ttpar, carrier)	struct termios *ttpar; int carrier;  #else /* ATTSV */K: carrctl(ttpar, carrier)	struct termio *ttpar; int carrier; #endif /* BSD44ORPOSIX */f /* carrctl */ { &     debug(F101, "carrctl","",carrier);     if (carrier)        ttpar->c_cflag &= ~CLOCAL;     else       ttpar->c_cflag |= CLOCAL;(     return(0); }r" #else /* Berkeley, V7, et al... */ int,< carrctl(ttpar, carrier) struct sgttyb *ttpar; int carrier; {&     debug(F101, "carrctl","",carrier);     if (carrier == curcarr)	       return(0);     curcarr = carrier;
 #ifdef ultrixs #ifdef COMMENT /*G   Old code from somebody at DEC that tends to get stuck, time out, etc.  */     if (carrier) {  	ioctl(ttyfd, TIOCMODEM, &temp); 	ioctl(ttyfd, TIOCHPCL, 0);/     } else {> 	/* (According to the manuals, TIOCNCAR should be preferred */ 	/* over TIOCNMODEM...) */! 	ioctl(ttyfd, TIOCNMODEM, &temp);P     }  #elsef /*D   New code from Jamie Watson that, he says, eliminates the problems. */     if (carrier) { 	ioctl(ttyfd, TIOCCAR);l 	ioctl(ttyfd, TIOCHPCL);     } else { 	ioctl(ttyfd, TIOCNCAR);     }	 #endif /* COMMENT */ #endif /* ultrix */n     return(0); }  #endif /* SVORPOSIX */    * /*  T T G M D M  --  Get modem signals  */ /*H  Looks for RS-232 modem signals, and returns those that are on in as itsO  return value, in a bit mask composed of the BM_xxx values defined in ckcdeb.h.e
  Returns:   -3 Not implemented I  -2 if the communication device does not have modem control (e.g. telnet)i
  -1 on error.fK  >= 0 on success, with a bit mask containing the modem signals that are on.W */   /*@   Define the symbol K_MDMCTL if we have Sys V R3 / 4.3 BSD style+   modem control, namely the TIOCMGET ioctl.P */   #ifdef BSD43 #define K_MDMCTL #endif  
 #ifdef SUNOS4  #define K_MDMCTL #endif  
 #ifdef QNX #define K_MDMCTL #else/ #ifdef TIOCMGETC #define K_MDMCTL #endif /* TIOCMGET *// #endif /* QNX */   int 
 ttgmdm() {  
 #ifdef QNX #include <sys/qioctl.h>   -     unsigned long y, mdmbits[2] = { 0L, 0L };      int z = 0;  K     if (!qnx_ioctl( ttyfd, QCTL_DEV_CTL, &mdmbits[0], 8, &mdmbits[0], 4)) {t 	y = mdmbits[0];: 	if (y & 0x100000L) z |= BM_CTS;	/* Values from comment */6 	if (y & 0x200000L) z |= BM_DSR;	/* in sys/qioctl.h */  	if (y & 0x800000L) z |= BM_DCD;  	if (y & 0x400000L) z |= BM_RNG;  	if (y & 0x000001L) z |= BM_DTR;  	if (y & 0x000002L) z |= BM_RTS; 	return(z);(     } else return(-1); #else ) #ifdef HPUX				/* HPUX has its own way */a
     int x, z;f  & #ifdef HPUX10				/* Modem flag word */6     mflag y;				/* mflag typedef'd in <sys/modem.h> */ #elseU #ifdef HPUX9     mflag y; #elseS #ifdef HPUX8     mflag y; #else 6     unsigned long y;			/* Not sure about pre-8.0... */ #endif /* HPUX8 */ #endif /* HPUX9 */ #endif /* HPUX10 */d  +     if (netconn)			/* Network connection */v*       return(-2);			/* No modem signals */  *     if (xlocal)				/* Get modem signals */!       x = ioctl(ttyfd,MCGETA,&y);h     else       x = ioctl(0,MCGETA,&y);n     if (x < 0) return(-1);     debug(F101,"ttgmdm","",y);  +     z = 0;				/* Initialize return value */i  C /* Now set bits for each modem signal that is reported to be on. */i   #ifdef MCTSb     /* Clear To Send */      if (y & MCTS) z |= BM_CTS; #endif #ifdef MDSRa     /* Data Set Ready */     if (y & MDSR) z |= BM_DSR; #endif #ifdef MDCDn     /* Carrier */a     if (y & MDCD) z |= BM_DCD; #endif
 #ifdef MRI     /* Ring Indicate */e     if (y & MRI) z |= BM_RNG;  #endif #ifdef MDTR      /* Data Terminal Ready */)     if (y & MDTR) z |= BM_DTR; #endif #ifdef MRTS.     /* Request To Send */l     if (y & MRTS) z |= BM_RTS; #endif     return(z);   #else /* ! HPUX */   #ifdef K_MDMCTLo /*J   Note, <sys/ttycom> might have already been included by by <sys/ioctl.h>.@   Hence the following ifndef on a symbol which is defined there. */ #ifndef TIOCMGET #include <sys/ttycom.h>, #endif /* TIOCMGET */u       int x, y, z;  +     if (netconn)			/* Network connection */c*       return(-2);			/* No modem signals */       if (xlocal)e<       x = ioctl(ttyfd,TIOCMGET,&y);	/* Get modem signals. */     else       x = ioctl(0,TIOCMGET,&y);h$     debug(F101,"ttgmdm ioctl","",x);     if (x < 0) {% 	debug(F101,"ttgmdm errno","",errno);  	return(-1);*     } else debug(F101,"ttgmdm bits","",y);  ,     z = 0;				/* Initialize return value. */ #ifdef TIOCM_CTS     /* Clear To Send */t#     if (y & TIOCM_CTS) z |= BM_CTS;e #endif #ifdef TIOCM_DSR     /* Data Set Ready */#     if (y & TIOCM_DSR) z |= BM_DSR;= #endif #ifdef TIOCM_CAR     /* Carrier */S#     if (y & TIOCM_CAR) z |= BM_DCD;t #endif #ifdef TIOCM_RNG     /* Ring Indicate */t#     if (y & TIOCM_RNG) z |= BM_RNG;D #endif #ifdef TIOCM_DTR     /* Data Terminal Ready */ #     if (y & TIOCM_DTR) z |= BM_DTR;4 #endif #ifdef TIOCM_RTS     /* Request To Send */*#     if (y & TIOCM_RTS) z |= BM_RTS;  #endif     return(z);   #else /* !K_MDMCTL catch-All */   +     if (netconn)			/* Network connection */r*       return(-2);			/* No modem signals */  3     return(-3);				/* Sorry, I don't know how... */p   #endif /* K_MDMCTL */u #endif /* HPUX */  #endif /* QNX */ }   @ /*  P S U S P E N D  --  Put this process in the background.  */   /*G   Call with flag nonzero if suspending is allowed, zero if not allowed. A   Returns 0 on apparent success, -1 on failure (flag was zero, or     kill() returned an error code. */ intS psuspend(flag) int flag; {  
 #ifdef RTU     extern int rtu_bug;  #endif /* RTU */       if (flag == 0) return(-1);   #ifdef NOJCr     return(-1);  #elseo #ifdef SIGTSTP /*E   The big question here is whether job control is *really* supported.SD   There's no way Kermit can know for sure.  The fact that SIGTSTP isF   defined does not guarantee the Unix kernel supports it, and the factD   that the Unix kernel supports it doesn't guarantee that the user's;   shell (or other process that invoked Kermit) supports it.e */
 #ifdef RTU     rtu_bug = 1; #endif /* RTU */     if (kill(0,SIGSTOP) < 0s #ifdef MIPSO" /* Let's try this for MIPS too. */ 	&& kill(getpid(),SIGSTOP) < 0 #endif /* MIPS */s- 	) {				/* If job control, suspend the job */, 	perror("suspend");t' 	debug(F101,"psuspend error","",errno);  	return(-1);     }C#     debug(F100,"psuspend ok","",0);K     return(0); #elsee     return(-1);d #endif /* SIGTSTP */ #endif /* NOJC */  }s   /*F   setuid package, by Kristoffer Eriksson, with contributions from Dean   Long and fdc.o */   #ifndef _POSIX_SOURCE( #ifndef SUNOS4 #ifndef NEXT #ifndef PS2AIX10 #ifndef sequentm- extern UID_T getuid(), geteuid(), getreuid();e- extern GID_T getgid(), getegid(), getregid();/ #endif /* sequent */ #endif /* PS2AIX10 */e #endif /* NEXT */  #endif /* SUNOS4 */T #endif /* _POSIX_SOURCE */   /* Subject: Set-user-id. To: fdc@watsun.cc.columbia.edu (Frank da Cruz)  Date: Sat, 21 Apr 90 4:48:25 MES( From: Kristoffer Eriksson <ske@pkmab.se>  M This is a set of functions to be used in programs that may be run set-user-id>K and/or set-group-id. They handle both the case where the program is not runoK with such privileges (nothing special happens then), and the case where oneaL or both of these set-id modes are used.  The program is made to run with theE user's real user and group ids most of the time, except for when moret4 privileges are needed.  Don't set-user-id to "root".  < This works on System V and POSIX.  In BSD, it depends on the "saved-set-user-id" feature. */  2 #define UID_ROOT 0			/* Root user and group ids */ #define GID_ROOT 0   /*F   The following code defines the symbol SETEUID for UNIX systems basedF   on BSD4.4 (either -Encumbered or -Lite).  This program will then useG   seteuid() and setegid() instead of setuid() and setgid(), which still A   don't allow arbitrary switching.  It also avoids setreuid() andeF   setregid(), which are included in BSD4.4 for compatibility only, areJ   insecure, and print warnings to stderr under at least one system (NetBSDH   1.0).  Note that POSIX systems should still use setuid() and setgid();D   the seteuid() and setegid() functions are BSD4.4 extensions to the7   POSIX model.  Mike Long <mike.long@analog.com>, 8/94.  */ #ifdef BSD44 #define SETEUIDk #endif /* BSD44 */   /*J   The following construction automatically defines the symbol SETREUID forG   UNIX versions based on Berkeley Unix 4.2 and 4.3.  If this symbol is tH   defined, then this program will use getreuid() and getregid() calls inH   preference to getuid() and getgid(), which in Berkeley-based Unixes doG   not allow arbitrary switching back and forth of real & effective uid. K   This construction also allows -DSETREUID to be put on the cc command line K   for any system that has and wants to use setre[ug]id().  It also prevents;G   automatic definition of SETREUID if -DNOSETREU is included on the cc o&   command line (or otherwise defined). */. #ifdef FT18				/* None of this for Fortune. */ #define NOSETREU #endif /* FT18 */   
 #ifdef ANYBSDl
 #ifndef BSD29 
 #ifndef BSD41t #ifndef SETREUID #ifndef NOSETREU #ifndef SETEUID  #define SETREUID #endif /* SETEUID */( #endif /* NOSETREU */                    #endif /* SETREUID */m #endif /* !BSD41 */, #endif /* !BSD29 */  #endif /* ANYBSD */I  ' /* Variables for user and group IDs. */d  8 static UID_T realuid = (UID_T) -1, privuid = (UID_T) -1;8 static GID_T realgid = (GID_T) -1, privgid = (GID_T) -1;    9 /* P R I V _ I N I  --  Initialize privileges package  */(  K /* Called as early as possible in a set-uid or set-gid program to store the0I  * set-to uid and/or gid and step down to the users real uid and gid. TheoG  * stored id's can be temporarily restored (allowed in System V) duringdH  * operations that require the privilege.  Most of the time, the programK  * should execute in unpriviliged state, to not impose any security threat.1  *J  * Note: Don't forget that access() always uses the real id:s to determine.  * file access, even with privileges restored.  *;  * Returns an error mask, with error values or:ed together:t  *   1 if setuid() fails,,  *   2 if setgid() fails, andnG  *   4 if the program is set-user-id to "root", which can't be handled.   *F  * Only the return value 0 indicates real success. In case of failure,F  * those privileges that could be reduced have been, at least, but the+  * program should be aborted none-the-less.	  *H  * Also note that these functions do not expect the uid or gid to changeI  * without their knowing. It may work if it is only done temporarily, butB  * you're on your own.  */  intC priv_ini() {     int err = 0;       /* Save real ID:s. */,     realuid = getuid();e     realgid = getgid();g  D     /* Save current effective ID:s, those set to at program exec. */     privuid = geteuid();     privgid = getegid();  G     /* If running set-uid, go down to real uid, otherwise remember that	&      * no privileged uid is available.      *      * Exceptions:      *D      * 1) If the real uid is already "root" and the set-uid uid (theG      * initial effective uid) is not "root", then we would have trouble I      * if we went "down" to "root" here, and then temporarily back to the H      * set-uid uid (not "root") and then again tried to become "root". II      * think the "saved set-uid" is lost when changing uid from effectiveaI      * uid "root", which changes all uid, not only the effective uid. But G      * in this situation, we can simply go to "root" and stay there allFI      * the time. That should give sufficient privilege (understatement!),a0      * and give the right uids for subprocesses.      *F      * 2) If the set-uid (the initial effective uid) is "root", and weI      * change uid to the real uid, we can't change it back to "root" whenRJ      * we need the privilege, for the same reason as in 1). Thus, we can'tI      * handle programs that are set-user-id to "root" at all. The program,F      * should be stopped.  Use some other uid.  "root" is probably tooF      * privileged for such things, anyway. (The uid is reverted to the#      * real uid until termination.)r      *J      * These two exceptions have the effect that the "root" uid will neverI      * be one of the two uids that are being switched between, which alsobC      * means we don't have to check for such cases in the switchingF      * functions.c      *I      * Note that exception 1) is handled by these routines (by constantly J      * running with uid "root", while exception 2) is a serious error, and=      * is not provided for at all in the switching functions.       */      if (realuid == privuid) 6 	privuid = (UID_T) -1;		/* Not running set-user-id. */  G     /* If running set-gid, go down to real gid, otherwise remember that &      * no privileged gid is available.      *H      * There are no exception like there is for the user id, since thereE      * is no group id that is privileged in the manner of uid "root".tC      * There could be equivalent problems for group changing if the(C      * program sometimes ran with uid "root" and sometimes not, butC2      * that is already avoided as explained above.      *H      * Thus we can expect always to be able to switch to the "saved set-F      * gid" when we want, and back to the real gid again. You may alsoG      * draw the conclusion that set-gid provides for fewer hassles thanf      * set-uid.T      */s  >     if (realgid == privgid)		/* If not running set-user-id, */9       privgid = (GID_T) -1;		/*  remember it this way. */F  8     err = priv_off();			/* Turn off setuid privilege. */  6     if (privuid == UID_ROOT)		/* If setuid to root, */+       err |= 4;				/* return this error. */i  7     if (realuid == UID_ROOT)		/* If real id is root, */g:       privuid = (UID_T) -1;		/* stay root at all times. */       return(err); }"    L /* Macros for hiding the differences in UID/GID setting between various UnixL  * systems. These macros should always be called with both the privileged IDM  * and the non-privileged ID. The one in the second argument, will become theOI  * effective ID. The one in the first argument will be retained for later.
  * retrieval.   */( #ifdef SETREUIDp #ifdef SAVEDUID0J /* On BSD systems with the saved-UID feature, we just juggle the effectiveL  * UID back and forth, and leave the real UID at its true value.  The kernelL  * allows switching to both the current real UID, the effective UID, and theK  * UID which the program is set-UID to.  The saved set-UID always holds the)M  * privileged UID for us, and the real UID will always be the non-privileged,iJ  * and we can freely choose one of them for the effective UID at any time.  */ > #define switchuid(hidden,active) setreuid( (UID_T) -1, active)> #define switchgid(hidden,active) setregid( (GID_T) -1, active)    #else   /* SETREUID,!SAVEDUID */  H /* On systems with setreXid() but without the saved-UID feature, notably@  * BSD 4.2, we swap the real and effective UIDs each time.  It'sI  * the effective UID that we are interested in, but we have to retain theeH  * unused UID somewhere to enable us to restore it later, and we do thisL  * in the real UID.  The kernel only allows switching to either the current 3  * real or the effective UID, unless you're "root".K  */C8 #define switchuid(hidden,active)	setreuid(hidden,active)8 #define switchgid(hidden,active)	setregid(hidden,active) #endif    #else /* !SETREUID, !SAVEDUID */   #ifdef SETEUID /*E   BSD 4.4 works similarly to System V and POSIX (see below), but usestJ   seteXid() instead of setXid() to change effective IDs.  In addition, theB   seteXid() functions work the same for "root" as for other users. */0 #define switchuid(hidden,active)	seteuid(active)0 #define switchgid(hidden,active)	setegid(active)   #else /* !SETEUID */  K /* On System V and POSIX, the only thing we can change is the effective UIDpN  * (unless the current effective UID is "root", but initsuid() avoids that forL  * us).  The kernel allows switching to the current real UID or to the savedN  * set-UID.  These are always set to the non-privileged UID and the privilegedK  * UID, respectively, and we only change the effective UID.  This breaks ifcM  * the current effective UID is "root", though, because for "root" setuid/gidtJ  * becomes more powerful, which is why initsuid() treats "root" specially.J  * Note: That special treatment maybe could be ignored for BSD?  Note: ForJ  * systems that don't fit any of these four cases, we simply can't support  * set-UID.t  */e/ #define switchuid(hidden,active)	setuid(active))/ #define switchgid(hidden,active)	setgid(active)t   #endif /* SETEUID */ #endif /* SETREUID */      9 /* P R I V _ O N  --  Turn on the setuid and/or setgid */O  A /* Go to the privileged uid (gid) that the program is set-user-id!A  * (set-group-id) to, unless the program is running unprivileged.oB  * If setuid() fails, return value will be 1. If getuid() fails itG  * will be 2.  Return immediately after first failure, and the functionpA  * tries to restore any partial work done.  Returns 0 on success.fD  * Group id is changed first, since it is less serious than user id.  */  int	 priv_on() {      if (privgid != (GID_T) -1)%       if (switchgid(realgid,privgid))          return(2);       if (privuid != (UID_T) -1)'       if (switchuid(realuid,privuid)) {( 	  if (privgid != (GID_T) -1)e  	    switchgid(privgid,realgid);
 	  return(1);F       }{     return(0); }   7 /* P R I V _ O F F  --  Turn on the real uid and gid */,  C /* Return to the unprivileged uid (gid) after an temporary visit to/G  * privileged status, unless the program is running without set-user-idFF  * (set-group-id). Returns 1 for failure in setuid() and 2 for failureE  * in setgid() or:ed together. The functions tries to return both uid D  * and gid to unprivileged state, regardless of errors. Returns 0 on  * success.s  */g intR priv_off() {     int err = 0;       if (privuid != (UID_T) -1)&        if (switchuid(privuid,realuid)) 	  err |= 1;       if (privgid != (GID_T) -1)&        if (switchgid(privgid,realgid))
 	err |= 2;       return(err); }   L /* Turn off privilege permanently.  No going back.  This is necessary beforeK  * a fork() on BSD43 machines that don't save the setUID or setGID, because J  * we swap the real and effective ids, and we don't want to let the forkedL  * process swap them again and get the privilege back. It will work on otherL  * machines too, such that you can rely on its effect always being the same,I  * for instance, even when you're in priv_on() state when this is called.aL  * (Well, that part about "permanent" is on System V only true if you followF  * this with a call to exec(), but that's what we want it for anyway.)/  * Added by Dean Long -- dlong@midgard.ucsc.edu*  */e inte priv_can() {   #ifdef SETREUIDn     int err = 0;     if (privuid != (UID_T) -1)%        if (setreuid(realuid,realuid))i 	  err |= 1;       if (privgid != (GID_T) -1)&         if (setregid(realgid,realgid))
  	  err |= 2;;       return(err);   #else  #ifdef SETEUID     int err = 0;     if (privuid != (UID_T) -1) 	if (setuid(realuid)) { * 	    debug(F101,"setuid failed","",errno); 	    err |= 1;$ 	    debug(F101,"ruid","",getuid());% 	    debug(F101,"euid","",geteuid());o 	}$     debug(F101,"setuid","",realuid);     if (privgid != (GID_T) -1)         if (setgid(realgid)) {* 	    debug(F101,"setgid failed","",errno); 	    err |= 2;$ 	    debug(F101,"rgid","",getgid());% 	    debug(F101,"egid","",getegid());1 	}$     debug(F101,"setgid","",realgid);     return(err); #elsegN     /* Easy way of using setuid()/setgid() instead of setreuid()/setregid().*/     return(priv_off());* #endif /* SETEUID */ #endif /* SETREUID */  }i  B /* P R I V _ O P N  --  For opening protected files or devices. */   int". priv_opn(name, modes) char *name; int modes; {
     int x;*     priv_on();				/* Turn privileges on */8     x = open(name, modes);		/* Try to open the device */,     priv_off();				/* Turn privileges off */1     return(x);				/* Return open's return code */  }i  . /*  P R I V _ C H K  --  Check privileges.  */  N /*  Try to turn them off.  If turning them off did not succeed, cancel them */   int_ priv_chk() {     int x, y = 0;"+     x = priv_off();			/* Turn off privs. */}>     if (x != 0 || getuid() == privuid || geteuid() == privuid)       y = priv_can(); >     if (x != 0 || getgid() == privgid || getegid() == privgid)       y = y | priv_can();a     return(y); })   UID_Tt real_uid() {     return(realuid); };   VOID2 ttimoff() {				/* Turn off any timer interrupts */     int xx;e /*L   As of 5A(183), we set SIGALRM to SIG_IGN (to ignore alarms) rather than toL   SIG_DFL (to catch alarms, or if there is no handler, to exit).  This is toL   cure (mask, really) a deeper problem with stray alarms that occurs on someJ   systems, possibly having to do with sleep(), that caused core dumps.  ItM   should be OK to do this, because no code in this module uses nested alarms.i9   (But we still have to watch out for SCRIPT and DIAL...)  */     xx = alarm(0);,     /* debug(F101,"ttimoff alarm","",xx); */-     if (saval) {			/* Restore any previous */f- 	signal(SIGALRM,saval);		/* alarm handler. */s< 	/* debug(F101,"ttimoff alarm restoring saval","",saval); */ 	saval = NULL;     } else {2 	signal(SIGALRM,SIG_IGN);	/* Used to be SIG_DFL */0 	/* debug(F100,"ttimoff alarm SIG_IGN","",0); */     }/ }o   #ifdef CK_REDIR  intt ttruncmd(s) char *s; {#     int r = 0;				/* Return code */t# 					/* 0 = failure, 1 = success */	 #ifdef WIFEXITED #ifndef WEXITSTATUSt #ifdef w_retcode& #define WEXITSTATUS(x) ((x).w_retcode) #endif /* w_retcode */ #endif /* WEXITSTATUS */ #ifdef WEXITSTATUS #define CK_FUN_OKe #endif /* WEXITSTATUS */ #endif /* WIFEXITED */ #ifdef NEXT F #define waitpid(pid,status,option) wait4((pid),(status),(option),NULL) #else( #ifdef sony_newsF #define waitpid(pid,status,option) wait4((pid),(status),(option),NULL) #endif /* sony_news */ #endif /* NEXT */d   #ifdef CK_FUN_OK     PID_T pid;       if (ttyfd == -1) {( 	printf("?Sorry, device is not open\n"); 	return(0);f     }o+     conres();				/* Make console normal  */_7     if ((pid = fork()) == 0) {		/* Make a child fork */=$ 	/* give it stdin,out to the line */( 	if (priv_can())			/* Turn off privs. */ 	  exit(1);e 	dup2(ttyfd, 0); 	dup2(ttyfd, 1);! 	_exit(system(s) ? BAD_EXIT : 0);;     } else {4 	WAIT_T status;			/* This is int for all but NeXT */ 	SIGTYP (*istat)(), (*qstat)();I  - 	if (pid == (PID_T) -1)		/* fork() failed? */m
 	  return(0);aC 	istat = signal(SIGINT,SIG_IGN); /* Let the fork handle keyboard */)< 	qstat = signal(SIGQUIT,SIG_IGN); /* interrupts itself... */  ' 	if (waitpid(pid, &status, 0) != pid) {C2 	    printf("?Can't wait for child process?\r\n");	 	} else {. 	    if (WIFEXITED(status)) {; 		if (WEXITSTATUS(status)) {, 		    printf("?Command exit status: %d\r\n", 			   WEXITSTATUS(status));& 		} else r = 1; 
 	    } else {h; 		printf("?Command did not exit - cancelling it now.\r\n");y 		kill(pid, SIGKILL);- 	    } 	}0 	signal(SIGINT,istat);		/* Restore interrupts */ 	signal(SIGQUIT,qstat);s     } >     concb((char)escchr);		/* Restore console to CBREAK mode */ #else=E     printf("?Sorry, can't execute this command - pieces missing.\n");| #endif /* CK_FUN_OK */     return(r); }) #endif /* CK_REDIR */t   #ifdef OXOSA #undef kill  #endif /* OXOS */p   #ifdef OXOSg intI# priv_kill(pid, sig) int pid, sig; { 
     int	i;       if (priv_on())- 	debug(F100,"priv_kill priv_on failed","",0);      i = kill(pid, sig);/     if (priv_off()) . 	debug(F100,"priv_kill priv_off failed","",0);     return(i); }a #endif /* OXOS */ 