 #ifndef VMS H       ERROR -- CKVCON.C is used only on the OpenVMS(tm) Operating System #endif /* VMS */ #define CONN_OS_ARCH_STRING \ ,         "Connect Command 5A(036) 15 Sep 94"; #ifdef __ALPHA          /* do nothing */  #else  # ifdef VAX  #  module ckvcon "5.0-036" # else #ifndef __GNUC__G       ERROR -- CKVCON.C unknown architecture, neither VAX(tm) nor Alpha  # endif /* __GNUC__ */ # endif /* VAX */  #endif /* __ALPHA */  " char *connv = CONN_OS_ARCH_STRING;  K /*  C K V C O N  --  Dumb terminal connection to remote system, for VMS  */  /*?   Author: Frank da Cruz (fdc@columbia.edu, FDCCU@CUVMA.BITNET), B   Columbia University Academic Information Systems, New York City.  N   Copyright (C) 1985, 1994, Trustees of Columbia University in the City of NewK   York.  The C-Kermit software may not be, in whole or in part, licensed or L   sold for profit as a software product itself, nor may it be included in orM   distributed with commercial products or otherwise distributed by commercial J   concerns to their clients or customers without written permission of theK   Office of Kermit Development and Distribution, Columbia University.  This =   copyright notice must not be removed, altered, or obscured.  */ /*K  * Orignally adapted from the UNIX C-Kermit CONNECT module by S. Rubenstein N  * for systems without fork().  This version of conect() uses contti(&c, &src)N  * to return when a character is available from either the console or the commD  * line, to allow sending/receiving without breaking the connection.  *
  * Edit by  *&  * 010 06-Mar-1989 mab	General cleanupG  * 011 23-Mar-1989 mab	Clean up doesc() code.  Add malloc() in place of 7  *		 	static buffer space.  Also increase buffer space. (  * 012 27-Sep-1989 mab	Add XON sequence.=  * 013 30-Mar-1991 fdc  Add so/si, character set translation. D  * 014 06-Apr-1991 fdc  Adapted for TGV MultiNet TCP/IP connections.C  * 015 21-Jun-1991 tmk  Cleaned up typo in session logging display. L  * 016 28-Nov-1991 fdc  "Back at <hostname>", disallow CONNECT in backgroundL  * 017 25-Dec-1991 fdc  Added support for NOPUSH, added "Hanging up" message5  * 018 11-Jan-1992 fdc  Added support for key mapping J  * 019 27-Jan-1992 fdc  Added support for ANSI escape sequence recognition>  * 020 00-May-1992 fdc  Rewrote conect() to used buffered i/o.M  * 021 10-Jun-1992 fdc  Added support for Wollongong WIN/TCP from Ray Hunter. 3  *                      Fix messed-up help message. @  * 022 20-Jun-1992 fdc  Fixed handling of CR on TELNET sessions.D  * 023 28-Jun-1992 fdc  Cosmetic cleanup of "Connecting..." message.>  * 024 12-Jul-1992 fdc  Added mdmhup() feature (see ckudia.c).E  * 025 29-Jul-1992 fdc  Grouped TELNET IP and AYT into single writes. B  * 026 13-Aug-1992 fdc  Added support for SET TELNET NEWLINE-MODE.M  * 027 05-Sep-1992 lt   Added architecture ifdefs for OpenVMS, Alpha, at top. F  * 028 08-Sep-1992 fdc  Separated input and output SO/SO shift states.H  * 029 11-Oct-1992 fdc  Reduce modem-vs-net confusion in ttopen() calls.I  * 030 27-Oct-1993 fdc  Correct a typo in network protocol-checking code. F  * 031 23-Oct-1993 fdc  Reset i/o buffer pointers upon new connection.,  * 032 14-Feb-1994 fdc  Some minor cleanups.I  * 033  9-Mar-1994 fdc  Fixed failure to display quoted TELNET IAC (255). 0  * 034  2-Jul-1994 fdc  Add initial APC support.(  * 035  9-Jul-1994 fdc  Fix APC support.?  * 036 15-Sep-1994 fdc  Add support for SET TELNET NEWLINE RAW.   */    #include "ckcdeb.h"  #include "ckcasc.h"  #include "ckcker.h"  #include "ckucmd.h"  #include "ckcnet.h"  #include "ckvvms.h"  #ifndef NOCSETS 5 #include "ckcxla.h"			/* Character set translation */  #endif /* NOCSETS */ #include <stdio.h> #include <ctype.h> #include <signal.h>  #include <setjmp.h>   8 static int src;				/* Where input character came from */  M extern int local, speed, escape, duplex, parity, flow, seslog, mdmtyp, batch; A extern int cmask, cmdmsk, debses, sosi, ttyfd, what, quiet, tnlm,   tt_crd, tn_nlm;) extern char ttname[], sesfil[], myhost[];   ' #ifndef NOICP				/* Keyboard mapping */  #ifndef NOSETKEY4 extern KEY *keymap;			/* Single-character key map */7 extern MACRO *macrotab;			/* Key macro pointer table */ > static MACRO kmptr = NULL;		/* Pointer to current key macro */ #endif /* NOSETKEY */  #endif /* NOICP */   /* Network support */ 6 extern int ttnproto,			/* Virtual terminal protocol */-   network,				/* Network connection active */     nettype;				/* Network type */   #ifndef NOCSETS  #ifdef CK_ANSIC G extern CHAR (*xls[MAXTCSETS+1][MAXFCSETS+1])(CHAR); /* Character set */ O extern CHAR (*xlr[MAXTCSETS+1][MAXFCSETS+1])(CHAR); /* translation functions */ ; static CHAR (*sxo)(CHAR);	/* Local translation functions */ C static CHAR (*rxo)(CHAR);	/* for output (sending) terminal chars */ I static CHAR (*sxi)(CHAR);	/* and for input (receiving) terminal chars. */  static CHAR (*rxi)(CHAR);  #else C extern CHAR (*xls[MAXTCSETS+1][MAXFCSETS+1])();	/* Character set */ L extern CHAR (*xlr[MAXTCSETS+1][MAXFCSETS+1])();	/* translation functions. */8 static CHAR (*sxo)();		/* Local translation functions */@ static CHAR (*rxo)();		/* for output (sending) terminal chars */F static CHAR (*sxi)();		/* and for input (receiving) terminal chars. */ static CHAR (*rxi)();  #endif /* CK_ANSIC */ - extern int language;		/* Current language. */ = extern struct csinfo fcsinfo[]; /* File character set info */ F extern int tcsr, tcsl;		/* Terminal character sets, remote & local. */+ static int langsv;		/* Remember language */ 4 static int tcs;			/* Intermediate (xfer) char set */  ) _PROTOTYP( VOID doesc, (unsigned char) );  #endif /* NOCSETS */  ) #ifdef NOCSETS				/* No character sets */  #ifndef CK_APC				/* No APC */ #ifndef NOESCSEQ9 #define NOESCSEQ			/* So no escape sequence recognizer */  #endif /* NOESCSEQ */  #endif /* CK_APC */  #endif /* NOCSETS */  
 #ifdef CK_APC ? extern int apcactive;			/* Application Program Command (APC) */ ' extern int apcstatus;			/* items ... */ # static int apclength = 0;            #ifdef DCMDBUF extern char *apcbuf; #else  extern char apcbuf[];  #endif /* DCMDBUF */% static int apcbuflen = APCBUFLEN - 2;  #endif /* CK_APC */   7 int i, active;				/* Variables global to this module */  static char *p;    #ifndef NOESCSEQ /*J   As of edit 178, the CONNECT command will skip past ANSI escape sequencesK   to avoid translating the characters within them.  This allows the CONNECT G   command to work correctly when connected to a remote host that uses a J   7-bit ISO 646 national character set, in which characters like '[' wouldI   normally be translated into accented characters, ruining the terminal's 6   interpretation (and generation) of escape sequences.  G   Escape sequences of non-ANSI/ISO-compliant terminals are not handled.  */ /*,   States for the escape-sequence recognizer. */: #define ES_NORMAL 0			/* Normal, not in escape sequence */4 #define ES_GOTESC 1			/* Current character is ESC */5 #define ES_ESCSEQ 2			/* Inside an escape sequence */ 5 #define ES_GOTCSI 3			/* Inside a control sequence */ 9 #define ES_STRING 4			/* Inside OSC, PM, or APC string */ 9 #define ES_TERMIN 5			/* 1st char of string terminator */   
 static int6   escseq = 0,				/* Skip over ANSI escape sequences */9   inesc = ES_NORMAL,			/* State of sequence recognizer */ 4   oldesc = -1;				/* Previous state of recognizer */ /*I   ANSI escape sequence handling.  Only the 7-bit form is treated, because H   translation is not a problem in the 8-bit environment, in which all GLI   characters are ASCII and no translation takes place.  So we don't check M   for the 8-bit single-character versions of CSI, DCS, OSC, APC, or ST.  Here H   is the ANSI sequence recognizer state table, followed by the code that   implements it.     Definitions:;     CAN = Cancel                       01/08         Ctrl-X ;     SUB = Substitute                   01/10         Ctrl-Z :     DCS = Device Control Sequence      01/11 05/00   ESC P:     CSI = Control Sequence Introducer  01/11 05/11   ESC [:     ST  = String Terminator            01/11 05/12   ESC \:     OSC = Operating System Command     01/11 05/13   ESC ]:     PM  = Privacy Message              01/11 05/14   ESC ^:     APC = Application Program Command  01/11 05/15   ESC _  "   ANSI escape sequence recognizer:  +     State    Input  New State  ; Commentary   6     NORMAL   (start)           ; Start in NORMAL state  +     (any)    CAN    NORMAL     ; ^X cancels +     (any)    SUB    NORMAL     ; ^Z cancels   6     NORMAL   ESC    GOTESC     ; Begin escape sequenceD     NORMAL   other             ; NORMAL control or graphic character  ,     GOTESC   ESC               ; Start again$     GOTESC   [      GOTCSI     ; CSIC     GOTESC   P      STRING     ; DCS introducer, consume through ST C     GOTESC   ]      STRING     ; OSC introducer, consume through ST C     GOTESC   ^      STRING     ; PM  introducer, consume through ST C     GOTESC   _      STRING     ; APC introducer, consume through ST F     GOTESC   0..~   NORMAL     ; 03/00 through 17/14 = Final characterJ     GOTESC   other  ESCSEQ     ; Intermediate or ignored control character  ,     ESCSEQ   ESC    GOTESC     ; Start againF     ESCSEQ   0..~   NORMAL     ; 03/00 through 17/14 = Final characterJ     ESCSEQ   other             ; Intermediate or ignored control character  ,     GOTCSI   ESC    GOTESC     ; Start againF     GOTCSI   @..~   NORMAL     ; 04/00 through 17/14 = Final characterJ     GOTCSI   other             ; Intermediate char or ignored control char  .     STRING   ESC    TERMIN     ; Maybe have ST1     STRING   other             ; Consume all else   .     TERMIN   \      NORMAL     ; End of string0     TERMIN   other  STRING     ; Still in string */ /*)   chkaes() -- Check ANSI Escape Sequence. +   Call with EACH character in input stream. @   Sets global inesc variable according to escape sequence state. */ VOID #ifdef CK_ANSIC  chkaes(char c) #else  chkaes(c) char c;  #endif /* CK_ANSIC */  /* chkaes */ {  3     oldesc = inesc;			/* Remember previous state */ D     if (c == CAN || c == SUB)		/* CAN and SUB cancel any sequence */       inesc = ES_NORMAL;     else				/* Otherwise */ 3       switch (inesc) {			/* enter state switcher */   % 	case ES_NORMAL:			/* NORMAL state */ # 	  if (c == ESC)			/* Got an ESC */ 5 	    inesc = ES_GOTESC;		/* Change state to GOTESC */ 0 	  break;			/* Otherwise stay in NORMAL state */  % 	case ES_GOTESC:			/* GOTESC state */ 6 	  if (c == '[')			/* Left bracket after ESC is CSI */5 	    inesc = ES_GOTCSI;		/* Change to GOTCSI state */ E 	  else if (c == 'P' || (c > 0134 && c < 0140)) { /* P, [, ^, or _ */ A 	      inesc = ES_STRING;	/* Switch to STRING-absorption state */ 
 #ifdef CK_APC 8 	      if (c == '_' && apcstatus != APC_OFF) { /* APC */! 		  debug(F100,"APC begin","",0); , 		  apcactive = 1;	/* Set APC-Active flag */5 		  apclength = 0;	/* and reset APC buffer pointer */  	      } #endif /* CK_APC */ E 	  } else if (c > 057 && c < 0177) /* Final character '0' thru '~' */ - 	    inesc = ES_NORMAL;		/* Back to normal */ 9 	  else if (c != ESC)		/* ESC in an escape sequence... */ ; 	    inesc = ES_ESCSEQ;		/* starts a new escape sequence */ 3 	  break;			/* Intermediate or ignored ctrl char */   8 	case ES_ESCSEQ:			/* ESCSEQ -- in an escape sequence */> 	  if (c > 057 && c < 0177)	/* Final character '0' thru '~' */6 	    inesc = ES_NORMAL;		/* Return to NORMAL state. */$ 	  else if (c == ESC)		/* ESC ... */; 	    inesc = ES_GOTESC;		/* starts a new escape sequence */ 3 	  break;			/* Intermediate or ignored ctrl char */   8 	case ES_GOTCSI:			/* GOTCSI -- In a control sequence */> 	  if (c > 077 && c < 0177)	/* Final character '@' thru '~' */0 	    inesc = ES_NORMAL;		/* Return to NORMAL. */$ 	  else if (c == ESC)		/* ESC ... */+ 	    inesc = ES_GOTESC;		/* starts over. */ 3 	  break;			/* Intermediate or ignored ctrl char */   ( 	case ES_STRING:			/* Inside a string */: 	  if (c == ESC)			/* ESC may be 1st char of terminator */& 	    inesc = ES_TERMIN;		/* Go see. */
 #ifdef CK_APC H 	  else if (apcactive && (apclength < apcbuflen)) /* If in APC string */: 	    apcbuf[apclength++] = c;	/* deposit this character */ #endif /* CK_APC */ . 	  break;			/* Absorb all other characters. */  5 	case ES_TERMIN:			/* May have a string terminator */ 2 	  if (c == '\\') {		/* which must be backslash */5 	      inesc = ES_NORMAL;	/* If so, back to NORMAL */ 
 #ifdef CK_APC 7 	      if (apcactive) {		/* If it was an APC string, */ < 		  apcbuf[apclength] = NUL; /* terminate it and then ... */0 		  debug(F111,"APC complete",apcbuf,apclength);; 		  printf("\r\n");	/* prevent CR-overstriking and...    */ 7 		  ckcputf();		/* flush screen-output buffer and... */ 8 		  active = 0;		/* exit from the terminal emulator.. */4 		  return;		/* with the apcactive flag still set */ 	      } #endif /* CK_APC */  	  } else {			/* Otherwise */ : 	      inesc = ES_STRING;	/* Back to string absorption. */
 #ifdef CK_APC H 	      if (apcactive && (apclength+1 < apcbuflen)) { /* In APC string */> 		  apcbuf[apclength++] = ESC; /* deposit the Esc character */; 		  apcbuf[apclength++] = c;   /* and this character too */  	      } #endif /* CK_APC */  	  }       }  }  #endif /* NOESCSEQ */   . static char *ibp;			/* Input buffer pointer */+ static int ibc;				/* Input buffer count */ . #define IBUFL 1024			/* Input buffer length */  / static char *obp;			/* Output buffer pointer */ , static int obc;				/* Output buffer count *// #define OBUFL 1024			/* Output buffer length */    #ifdef DYNAMICC static char *ibuf = NULL, *obuf = NULL;	/* Line and temp buffers */  #else % static char ibuf[IBUFL], obuf[OBUFL];  #endif /* DYNAMIC */  , char kbuf[10], *kbp;			/* Keyboard buffer */  4 /*  C O N E C T  --  Perform terminal connection  */  1 int inshift, outshift;			/* SO/SI shift states */   C /*  C K C P U T C  --  C-Kermit CONNECT Put Character to Screen  */  /*E   Output is buffered to avoid slow screen writes on fast connections.  */ int + ckcputf() {				/* Dump the output buffer */ 
     int x;3     if (obc > 0)			/* If we have any characters, */ ,       x = conxo(obc,obuf);		/* dump them, */*     obp = obuf;				/* reset the pointer */&     obc = 0;				/* and the counter. */2     return(x);				/* Return conxo's return code */ }    int  ckcputc(c) int c; { 
     int x;  4     *obp++ = c & 0xff;			/* Deposit the character */     obc++;				/* Count it */1     if (ibc == 0 ||			/* If input buffer empty */ . 	obc == OBUFL) {			/* or output buffer full */- 	x = conxo(obc,obuf);		/* dump the buffer, */ & 	obp = obuf;			/* reset the pointer */" 	obc = 0;			/* and the counter. */. 	return(x);			/* Return conxo's return code */     } else return(0);  }   9 /*  C K C G E T C  --  C-Kermit CONNECT Get Character  */  /**   Buffered read from communication device.@   Returns the next character, refilling the buffer if necessary.B   On error, returns ttinc's return code (see ttinc() description).A   Dummy argument for compatible calling conventions with ttinc(). >   NOTE: We don't have a macro for this because we have to pass9   a pointer to this function as an argument to tn_doop().  */ int  ckcgetc(dummy) int dummy; { 
     int c, n;   8     if (ibc > 0) {			/* Have buffered port characters */$ 	src = 1;			/* Say source is port */- 	c = *ibp++ & 0xff;		/* Get next character */ * 	ibc--;				/* Reduce input buffer count *// 	debug(F101,"CKCGETC buffered port char","",c); 2 	return(c);			/* Return buffered port character */+     } else {				/* Need to refill buffer */ , 	contti(&c, &src);		/* Read one character */3 	if (src < 0) {			/* If error, return error code */  	    return(src); @ 	} else if (src == 0) {		/* Got a character from the keyboard */. 	    debug(F101,"CKCGETC keyboard char","",c); 	    return(c); & 	} else {			/* Got a port character */- 	    ibp = ibuf;			/* Reset buffer pointer */ . 	    *ibp++ = c;			/* Deposit the character */  	    ibc++;			/* and count it */@ 	    if ((n = ttchk()) > 0) {	/* Any more characters waiting? */4 		if (n > (IBUFL - ibc))	/* Get them all at once. */4 		  n = IBUFL - ibc;	/* Don't overflow the buffer */> 		if ((n = ttxin(n,(CHAR *)ibp)) > 0) /* Read waiting chars */$ 		  ibc += n;		/* Advance counter */ 	    }3 	    ibp = ibuf;			/* Reset buffer pointer again */ > 	    c = *ibp++ & 0xff;		/* Get first character from buffer */' 	    ibc--;			/* Reduce buffer count */ * 	    debug(F101,"CKCGETC port char","",c);, 	    return(c);			/* Return the character */ 	}     }  }    int 
 conect() {4     int c;			/* c is a character, but must be signed, 				   integer to pass thru -1, which is the) 				   modem disconnection signal, and is + 				   different from the character 0377 */ %     int c2, csave;		/* Copies of c */      char errmsg[50], *erp, *cp;      int n, x;				/* Workers */       if (!local) {  #ifdef NETCONN8 	printf("Sorry, you must SET LINE or SET HOST first\n"); #else , 	printf("Sorry, you must SET LINE first\n"); #endif /* NETCONN */ 	return(-2);     }      if (batch) { 	printf("\n\I Sorry, Kermit's CONNECT command can be used only on a real terminal.\n"); < 	printf("If this is not a batch a job, then you must:\n\n");. 	printf("$ DEFINE SYS$INPUT SYS$COMMAND\n\n");E 	printf("in your DCL command procedure before starting Kermit.\n\n");  	return(0);      }  #ifdef TCPSOCKET+     if (network && (nettype != NET_TCPB)) { 3 	printf("Sorry, network type not supported yet\n");  	return(0);      }  #endif /* TCPSOCKET */  $     if (speed < 0 && network == 0) {- 	printf("Sorry, you must SET SPEED first\n");  	return(-2);     } *     if ((escape < 0) || (escape > 0177)) {< 	printf("Your escape character is not ASCII - %d\n",escape); 	return(-2);     } =     if (ttyfd < 0) {			/* If communication device not open */ : 	debug(F111,"ckvcon opening",ttname,0); /* Open it now. */ 	if (ttopen(ttname,  		   &local,! 		   network ? -nettype : mdmtyp,  		   0
 		   ) < 0) {  	    erp = errmsg;0 	    sprintf(erp,"Sorry, can't open %s",ttname); 	    perror(errmsg);0 	    debug(F110,"ckvcon open failure",errmsg,0); 	    return(-2); 	}     }      if (!quiet) {  #ifdef NETCONN 	if (network) { . 	    printf("\nConnecting to host %s",ttname);	 	} else {  #endif /* NETCONN */) 	    printf("\nConnecting to %s",ttname); 2 	    if (speed > -1L) printf(", speed %ld",speed); #ifdef NETCONN 	} #endif /* NETCONN */: 	printf(".\r\nThe escape character is %s (ASCII %d).\r\n", 	       dbchr(escape),escape);D 	printf("Type the escape character followed by C to get back,\r\n");6 	printf("or followed by ? to see other options.\r\n"); 	if (seslog) {1 	    printf("(Session logged to %s)\r\n",sesfil);  	}1 	if (debses) printf("Debugging Display...)\r\n");  	printf("\r\n");     }   7 /* Condition console terminal and communication line */        if (conbin(escape) < 0) { 5 	printf("Sorry, can't condition console terminal\n");  	return(-2);     }      if (ttvt(speed,flow) < 0) { 9 	/* tthang(); */ /* Closing it should be quite enough! */  	ttclos(0); + 	if (ttopen(ttname,		/* Open it again... */  		   &local,! 		   network ? -nettype : mdmtyp,  		   0
 		   ) < 0) {  	    erp = errmsg;2 	    sprintf(erp,"Sorry, can't reopen %s",ttname); 	    perror(errmsg); 	    return(0);  	}C 	if (ttvt(speed,flow) < 0) {	/* Try virtual terminal mode again. */ 2 	    conres();			/* Failure this time is fatal. */; 	    printf("Sorry, Can't condition communication line\n");  	    return(0);  	}     } 4     debug(F101,"connect ttvt ok, escape","",escape);  
 #ifdef CK_APC      apcactive = apclength = 0; #endif /* CK_APC */    #ifndef NOCSETS ' /* Set up character set translations */    #ifdef KANJI /* Kanji not supported yet */ -     if (fcsinfo[tcsr].alphabet == AL_JAPAN || ' 	fcsinfo[tcsl].alphabet == AL_JAPAN ) {  	tcs = TC_TRANSP; 
     } else #endif /* KANJI */ #ifdef CYRILLIC /       if (fcsinfo[tcsl].alphabet == AL_CYRIL) {  	  tcs = TC_CYRILL;        } else #endif /* CYRILLIC */  	tcs = TC_1LATIN;   ?     if (tcsr == tcsl) {			/* Remote and local sets the same? */ 0 	sxo = rxo = NULL;		/* If so, no translation. */ 	sxi = rxi = NULL;'     } else {				/* Otherwise, set up */ 2 	sxo = xls[tcs][tcsl];		/* translation function */; 	rxo = xlr[tcs][tcsr];		/* pointers for output functions */ 6 	sxi = xls[tcs][tcsr];		/* and for input functions. */ 	rxi = xlr[tcs][tcsl];     }  /*M   This is to prevent use of zmstuff() and zdstuff() by translation functions. L   They only work with disk i/o, not with communication i/o.  Luckily Russian0   translation functions don't do any stuffing... */     langsv = language; #ifndef NOCYRIL      if (language != L_RUSSIAN) #endif /* NOCYRIL */       language = L_USASCII;    #ifndef NOESCSEQ /*7   We need to activate escape-sequence recognition when: "   (a) translation is elected, and:M   (b) the local and/or remote set is 7-bit set other than US or UK ASCII, or:    (c) TERMINAL APC is not OFF. */8     escseq = (tcs != TC_TRANSP) &&	/* Not transparent */N       (fcsinfo[tcsl].size == 128 || fcsinfo[tcsr].size == 128) && /* 7 bits */9 	(fcsinfo[tcsl].code != FC_USASCII) && /* Not US ASCII */ 9 	(fcsinfo[tcsl].code != FC_UKASCII);   /* Not UK ASCII */  #ifdef COMMENT     debug(F101,"tcs","",tcs);      debug(F101,"tcsl","",tcsl);      debug(F101,"tcsr","",tcsr); ;     debug(F101,"fcsinfo[tcsl].size","",fcsinfo[tcsl].size); ;     debug(F101,"fcsinfo[tcsr].size","",fcsinfo[tcsr].size);  #endif /* COMMENT */ #endif /* NOESCSEQ */  #endif /* NOCSETS */   #ifndef NOESCSEQ
 #ifdef CK_APC .     escseq = escseq || (apcstatus != APC_OFF); #endif /* CK_APC */ :     inesc = ES_NORMAL;			/* Initial state of recognizer */#     debug(F101,"escseq","",escseq);  #endif /* NOESCSEQ */    #ifdef DYNAMIC     if (!ibuf) {B 	if (!(ibuf = malloc(IBUFL+1))) { /* Allocate input line buffer */@ 	    printf("Sorry, CONNECT input buffer can't be allocated\n"); 	    return(0); 	 	} else {  	    ibp = ibuf;
 	    ibc = 0;  	}     }      if (!obuf) {F 	if (!(obuf = malloc(OBUFL+1))) {    /* Allocate output line buffer */A 	    printf("Sorry, CONNECT output buffer can't be allocated\n");  	    return(0); 	 	} else {  	    obp = obuf;
 	    obc = 0;  	}     }  #else      ibp = ibuf;      ibc = 0;     obp = obuf;      obc = 0; #endif /* DYNAMIC */  7     inshift = outshift = 0;		/* Initial SI/SO states */      active = 1;   !     do {				/* Top of big loop */  #ifndef NOSETKEY /*K   Before reading anything from the keyboard, continue expanding the current     active keyboard macro, if any. */' 	if (kmptr) {			/* Have active macro */ 5 	    src = 0;			/* Pretend char came from keyboard */ H 	    if ((c = (CHAR) *kmptr++) == NUL) { /* but get it from the macro */2 		kmptr = NULL;		/* If no more chars in macro,  */. 		continue;		/* reset pointer and continue. */ 	    } 	} else 				/* OTHERWISE... */ #endif /* NOSETKEY */  /*L   contti() samples the keyboard and the communication device, in that order,L   in what amounts to a busy loop, and does not return until it has somethingH   from one or the other.  This drives the VAX crazy, and also gives poorG   performance: input is character-at a time, and the keyboard buffer is J   checked at least once for every character that comes in from the remote.C   Somebody who knows something about VMS, PLEASE FIND A BETTER WAY.   K   We want a version of contti() that does what select() does in BSD, and we H   also want it to be buffered internally, so it doesn't have to call theN   operating system for every single input character.  And most of all we don'tH   want it to run a busy loop all the time.  No doubt this involves ASTs,*   things of which I know nothing.    - fdc */* 	c = ckcgetc(0);			/* Calls contti()... */ /*&   Get here with a character in c, and:     src = -1 Communication error#          1 Character from comm line !          0 Character from console  */7 	if (src < 0) {			/* Comm line hangup or other error */  /*E   We should check WHY src < 0 and not just dive under for ANY reason.  */: 	    if (!quiet) printf("\r\nCommunications disconnect "); 	    active = 0; 	} else if (!src) {  /*    Character from console  */- 	    c &= cmdmsk;		/* Do requested masking */ 
 #ifndef NOICP  #ifndef NOSETKEY /*H   Note: kmptr is NULL if we got character c from the keyboard, and it isF   not NULL if it came from a macro.  In the latter case, we must avoid   expanding it again.  */D 	    if (!kmptr && macrotab[c]) { /* If a macro is assigned to it *// 		kmptr = macrotab[c];	/* set up the pointer */ % 		continue;		/* and do this again. */ < 	    } else c = keymap[c];	/* Else use single-char keymap */ #endif /* NOSETKEY */  #endif /* NOICP */ 	    csave = c; 	 	    if ( 
 #ifndef NOICP  #ifndef NOSETKEY 		    !kmptr &&  #endif /* NOSETKEY */  #endif /* NOICP */3 		((c & 0x7f) == escape)) { /* Escape character? */ 1 		conresne();		/* Restore to normal attributes */  		c = coninc(0) & 0177;  		doesc(c);  		conbin(escape); ( 	    } else {			/* Ordinary character */ #ifndef NOCSETS  #ifdef NOESCSEQ   		/* Translate character sets */; 		if (sxo) c = (*sxo)(c); /* From local to intermediate. */ < 		if (rxo) c = (*rxo)(c); /* From intermediate to remote. */ #else < 		if (inesc == ES_NORMAL) { /* If not inside escape seq.. */$ 		    /* Translate character sets */: 		    if (sxo) c = (*sxo)(c); /* Local to intermediate. */; 		    if (rxo) c = (*rxo)(c); /* Intermediate to remote. */  		} ; 		if (escseq) chkaes(c); /* Check escape sequence status */  #endif /* NOESCSEQ */  #endif /* NOCSETS */ /*B  If Shift-In/Shift-Out is selected and we have a 7-bit connection,  handle shifting here. */0 		if (sosi) {		     /* Shift-In/Out selected? */6 		    if (cmask == 0177) { /* In 7-bit environment? */2 			if (c & 0200) {          /* 8-bit character? */1 			    if (outshift == 0) { /* If not shifted, */ + 				if (ttoc(dopar(SO)) < 0) { /* shift. */  				    active = 0;  				    continue;  				}  				outshift = 1;  			    } 			} else { 1 			    if (outshift == 1) { /* 7-bit character */ 0 				if (ttoc(dopar(SI)) < 0) { /* If shifted, */ 				    active = 0;  				    continue;  				}   				outshift = 0; /* unshift. */ 			    } 			} 		    } 4 		    if (c == SO) outshift = 1;	/* User typed SO */4 		    if (c == SI) outshift = 0;	/* User typed SI */ 		} 3 		c &= cmask;		/* Apply Kermit-to-host mask now. */   * 		if (c == '\015') {	/* Carriage Return */ 		    int stuff = -1; , 		    if (tnlm) {		/* TERMINAL NEWLINE ON */ 			stuff = LF; 	/* Stuff LF */
 #ifdef TNCODE ; 		    } else if (network && /* TELNET NEWLINE ON/OFF/RAW */ $ 			       (ttnproto == NP_TELNET) && 			       (tn_nlm != TNL_CR)) { + 			stuff = (tn_nlm == TNL_CRLF) ? LF : NUL;  #endif /* TNCODE */  		    }  		    if (stuff > -1) { % 			ttoc(dopar('\015'));	/* Send CR */ 1 			if (duplex) conoc('\015');	/* Maybe echo CR */ # 			c = stuff;			/* Char to stuff */ 
 			csave = c;  		    }  		} 
 #ifdef TNCODE H /* If user types the 0xff character (TELNET IAC), it must be doubled. */ 		else> 		  if (dopar(c) == IAC && network && ttnproto == NP_TELNET) {" 		      			/* Send one copy now */6 		      ttoc(IAC);	/* and the other one just below. */ 		  }  #endif /* TNCODE */ 9 		if (ttoc(dopar(c)) < 0) { /* Now send the character. */  		    active = 0;  		    continue;  		} # 		if (duplex) {		/* Half duplex? */ * 		    if (debses)		/* Yes, echo locally */6 		      conol(dbchr(csave)); /* in appropriate mode */
 		    else 		      conoc(csave); ; 		    if (seslog) zchout(ZSFILE,c); /* And maybe log it. */  		}			 	    }	 	} else {  /*?   Character from communications device or network connection...  */
 #ifdef TNCODE   	    /* Handle telnet options */C 	    if (network && ttnproto == NP_TELNET && ((c & 0xff) == IAC)) { & 		ckcputf();		/* Dump output buffer */? 		if ((x = tn_doop(c & 0xff, duplex, ckcgetc)) == -1 && !quiet) - 		  printf("\r\nCommunications disconnect "); ; 		if (x == 1) duplex = 1;	/* Change duplex if necessary. */  		if (x == 2) duplex = 0;  		if (x == 3)		/* Quoted IAC */  		  c = 255; 		else
 		  continue;  	    } #endif /* TNCODE */ 4 	    if (debses) {		/* Output character to screen */& 		char *s;		/* Debugging display... */ 		s = dbchr(c);  		while (*s) 		  ckcputc(*s++);# 	    } else {			/* or regular... */ % 		c &= cmask;		/* Do first masking */ ! 		if (sosi) {		/* Handle SI/SO */ $ 		    if (c == SO) {	/* Shift Out */ 			inshift = 1;  			continue;* 		    } else if (c == SI) { /* Shift In */ 			inshift = 0;  			continue; 		    }  		    if (inshift) c |= 0200;  		}  #ifndef NOCSETS  		if ( #ifndef NOESCSEQ; 		    inesc == ES_NORMAL	/* If not in an escape sequence */  #else  		    1  #endif /* NOESCSEQ */ * 		    ) {			/* Translate character sets */# 		    if (sxi) c = (*sxi)((CHAR)c); # 		    if (rxi) c = (*rxi)((CHAR)c);  		}  #endif /* NOCSETS */   #ifndef NOESCSEQ5 		    if (escseq)		/* If handling escape sequences */ / 		      chkaes((char)c);	/* update our state */ 
 #ifdef CK_APC  /*G   If we are handling APCs, we have several possibilities at this point: 5    1. Ordinary character to be written to the screen. L    2. An Esc; we can't write it because it might be the beginning of an APC.L    3. The character following an Esc, in which case we write Esc, then char,;       but only if we have not just entered an APC sequence.  */' 		if (escseq && apcstatus != APC_OFF) { 7 		    if (inesc == ES_GOTESC) /* Don't write ESC yet */  		      continue; 3 		    else if (oldesc == ES_GOTESC && !apcactive) { & 			ckcputc(ESC);	/* Write saved ESC */  			if (seslog) zchout(ZSFILE,c); 		    }  		}  #endif /* CK_APC */  #endif /* NOESCSEQ */  		if (
 #ifdef CK_APC  		    !apcactive #else  		    1  #endif /* CK_APC */ 	 		    ) { # 		    c &= cmdmsk;	/* Apply mask */ = 		    if (c == CR && tt_crd) { /* SET TERM CR-DISPLA CRLF? */ # 			ckcputc(c);	/* Yes, output CR */   			if (seslog) zchout(ZSFILE,c);' 			c = LF;		/* and insert a linefeed */  		    } . 		    ckcputc(c);		/* Put it on the screen. */ 		} 9 		if (seslog) zchout(ZSFILE,c); /* If logging, log it. */  	    } 	}     } while (active); 
     cancio(); 
     conres();      if (!quiet
 #ifdef CK_APC  	&& !apcactive #endif /* CK_APC */  	)$       printf("\r\n(Back at %s)\r\n",- 	     *myhost ? myhost : "local VMS system");      what = W_NOTHING;  #ifndef NOCSETS /     language = langsv;			/* Restore language */  #endif /* NOCSETS */     return(1); }   7 /*  H C O N N E  --  Give help message for connect.  */    VOID
 hconne() {
     int c;     static char *hlpmsg[] = {  "\n", N "  C to return to C-Kermit prompt,   H to hangup and close the connection,\n",@ "  B to send a BREAK,                L to send a Long BREAK,\n",
 #ifdef TNCODE D "  A to send TELNET Are You There,   I to send TELNET Interrupt,\n", #endif /* TNCODE */ : "  0 (zero) to send a null,          X to send an XON,\n",
 #ifdef NOPUSH @ "  S for status of connection,       ? for this message, or:\n", #else D "  @ to enter DCL,                   S for status of connection,\n", "  ? for this message, or:\n", #endif /* NOPUSH */ & "  \\ to begin a backslash escape:\n",( "    \\nnn  (decimal character code)\n",& "    \\Onnn (octal character code)\n",, "    \\Xhh  (hexadecimal character code)\n",* "    Terminate with carriage return.\n\n",F " Type the escape character again to send the escape character, or\n",: " press the space-bar to resume the CONNECT command.\n\n", "" };  /*>   Need to save term characteristics/ allow disable binary mode:   print message, get text and then restore previous state. */'     conol("\r\nPress C to return to "); 4     conol(*myhost ? myhost : "the C-Kermit prompt");     conoll(", or:");3     conola(hlpmsg);			/* Print the help message. */ 2     conol("Command>");			/* Prompt for command. */     c = coninc(0) & 0x7f;      conoc(c);				/* Echo it. */      if (c != CMDQ)       conoll(""); 
     doesc(c);  }   ; /*  D O E S C  --  Process an escape character argument  */    VOID #ifdef CK_ANSIC  doesc(register unsigned char c)  #else " doesc(c) register unsigned char c; #endif /* CK_ANSIC */  /* doesc() */ { 
     int d;     char sbuf[35];  (     c &= 0177;				/* Mask off 8th bit */  <     if (c == escape) {			/* If it's the escape character, */+         d = dopar(c);			/* just send it. */          ttoc(d); 	return;     } F     if (isupper(c)) c = tolower(c);	/* Convert to lowercase letter. */&     if (iscntrl(c)) c += 'a' - '\001';  /     switch (c) {			/* Take requested action. */        case 'b': & 	ttsndb();			/* Send a BREAK signal */ 	break; 
 #ifdef TNCODE .       case 'i':				/* Send TELNET interrupt */
 #ifndef IP #define IP 244 #endif /* IP */ 5 	if (network && ttnproto == NP_TELNET) { /* TELNET */  	    CHAR temp[3];) 	    temp[0] = IAC;		/* I Am a Command */ + 	    temp[1] = IP;		/* Interrupt Process */  	    temp[2] = NUL;  	    ttol((CHAR *)temp,2); 	} else conoc(BEL);  	break; )       case 'a':				/* "Are You There?" */        case '\01':  #ifndef AYT  #define AYT 246  #endif /* AYT */( 	if (network && ttnproto == NP_TELNET) { 	    CHAR temp[3];) 	    temp[0] = IAC;		/* I Am a Command */ ) 	    temp[1] = AYT;		/* Are You There? */  	    temp[2] = NUL;  	    ttol((CHAR *)temp,2); 	} else conoc(BEL);  #endif /* TNCODE */  	break; )       case 'c':				/* Return to prompt */  	active = 0; 	conol("\r\n");  	break; /       case 'h':				/* Hang up the connection */  #ifndef NODIAL8 	if (mdmhup() < 1)		/* Try via modem first, otherwise */ #endif /* NODIAL */ + 	  tthang();			/* the old-fashioned way. */  	conol("\r\nHanging up "); 	break; 1       case 'l':				/* Send a Long BREAK signal */  	ttsndlb();  	break;        case 's':				/* Status */ * 	sprintf(sbuf,"Connected thru %s",ttname);
 	conol(sbuf); # 	sprintf(sbuf,", speed: %d",speed); 
 	conol(sbuf);  	if (seslog) {/ 	    sprintf(sbuf,", logging file: %s",sesfil);  	    conol(sbuf);  	} 	conoll(""); 	break;  #ifndef NOPUSH       case '!':        case '@': - 	conres();			/* Put console back to normal */  	zshcmd("");			/* Start DCL. */  	if (conbin(escape) < 0) {3 	    printf("Error returning to remote session\n");  	    active = 0; 	} 	return; #endif /* NOPUSH */          case 'x':				/* XON */ /*?   NOTE: Here we should also issue QIO's to clear XOFF deadlock.  */ 	ttoc(dopar(XON)); 	break; "       case '?':				/* Give Help */
 	hconne(); 	break; $       case '0':				/* Send a NULL */
 	c = '\0'; 	d = dopar(c);	 	ttoc(d);  	break; $       case SP:				/* Ignore space */ 	break;        default:) 	if (c == CMDQ) {		/* Backslash escape */  	    int x;  	    kbp = kbuf; 	    *kbp++ = c;@ 	    while (((c = (coninc(0) & cmdmsk)) != '\r') && (c != '\n')) 	      *kbp++ = c; 	    *kbp = NUL; kbp = kbuf; 	    x = xxesc(&kbp);  	    if (x >= 0) { 		c = dopar(x); 
 		ttoc(c);	 		return; 
 	    } else { 
 		conoc(BEL); 	 		return;  	    } 	}1 	conoc(BEL); return;		/* Invalid esc arg, beep */      }  } 