 #ifndef VMS H       ERROR -- CKVFIO.C is used only on the OpenVMS(tm) Operating System #endif /* VMS */   #ifdef __ALPHA6 # define CKVFIO_OS_ARCH_STRING " OpenVMS(tm) AXP(tm)";          /* do nothing */  #else  # ifdef VAX  #  module ckvfio "2.0-116"7 #  define CKVFIO_OS_ARCH_STRING " OpenVMS(tm) VAX(tm)";  # else #  ifdef __GNUC__ @ #     define CKVFIO_OS_ARCH_STRING " OpenVMS(tm) VAX(tm) (GCC)"; #  else I #     ERROR -- CKVTIO.C unknown architecture, neither VAX(tm) nor AXP(tm)  #  endif /* __GNUC__ */  # endif /* VAX */  #endif /* __ALPHA */  0 char *ckzv = "File support, 2.0(117), 4 Oct 94";% char *ckzsys = CKVFIO_OS_ARCH_STRING;    /* lt. 1992-10-08 End   */   ? /* C K V F I O  --  Kermit file system support for VAX/VMS.  */    /*?   Author: Frank da Cruz (fdc@columbia.edu, FDCCU@CUVMA.BITNET), B   Columbia University Academic Information Systems, New York City.  N   Copyright (C) 1985, 1994, Trustees of Columbia University in the City of NewK   York.  The C-Kermit software may not be, in whole or in part, licensed or L   sold for profit as a software product itself, nor may it be included in orM   distributed with commercial products or otherwise distributed by commercial J   concerns to their clients or customers without written permission of theK   Office of Kermit Development and Distribution, Columbia University.  This =   copyright notice must not be removed, altered, or obscured.  */   /*   Originally adapted to VMS by: :   Stew Rubenstein, Harvard University Chemical Labs, 1985,   Contributors: N   Frank da Cruz (fdc), Columbia University Center, New York, NY (1985-present)I   Stew Rubenstein, Harvard University Chemical Labs, Cambridge, MA (1985) E   Martin Minow (MM), Digital Equipment Corporation, Maynard MA (1985) F   Dan Schullman (DS), Digital Equipment Corporation, Maynard MA (1985)F   Mark Buda (MAB), Digital Equipment Corporation, Nashua, NH (1989-90)J   Terry Kennedy (TMK), St. Peter's College, Jersey City, NJ (1990-present)@   William Bader (WB), Lehigh University, Bethlehem, PA (1990-93)A   Gary Mussar (GM), Bell-Northern Research, Ottawa, Canada (1991)    James Sturdevant (JS) (1992)B   Tarjei T. Jensen (ttj), Norwegian Hydrographic Service (1993-94)!   Mark Berryman (mb), SAIC (1994)  */ /* Edit history 1  * 003 20-Mar-85 MM  fixed fprintf bug in zsout.c :  * 004 21-Mar-84 MM  create text files in variable-stream.J  * 005  8-May-85 MM  filled in zkself (not tested), fixed other minor bugs:  * 006  5-Jul-85 DS  handle version number in zltor, zrtol6  * 007 11-Jul-85 fdc fix zclose() to give return codesH  * 008 19-Mar-86 fdc Fix system() for "!", zopeni() for REMOTE commands.#  * 008 17-Sep-87 fdc Define PWDCMD.   * 009 (???)G  * 010 24-Jan-88 fdc Add zgtdir() function, even tho it doesn't work... ?  * 011 14-Feb-89 mab Make zgtdir() work in V2/V3 C envirements, C  *		     Make zkself work using delprc() using Will Wood's changes. N  * 012 26-Feb-89 mab Add function that searches for kermit.ini file in various  *                   ways :  * 013 05-Mar-89 mab Add Barry Archers enhancements/fixes.F  * 014 15-Mar-89 mab Check for non-null data, not array of pointers in  *                   zkermini G  * 015 04-Apr-89 mab Add latent support for attribute packet.  Clean up $  *		     file name translation code.:  * 016 05-Apr-89 mab Add PWP code to optimize packetizing.>  * 017 16-Apr-89 mab PWP changes broke REMOTE command.  Fixed.C  * 018 18-Apr-89 mab #ifdef chkfn.  This removes a lot of overhead. &  *		     Add code to gtdir() for V4.x.+  * 019 12-Jun-89 mab Add PWP's encode logic A  * 020 09-Jul-89 mab Add logic to check for system() availability L  * 021 10-Jul-89 mab Fix SHOW USER USERNAME.  Added space after 'SHOW USER'.I  * 022 27-Sep-89 mab Added zmail/zprint, plus added changes from CKUFIO.C )  * 023 01-Dec-89 mab Add RMS file support O  * 024 20-Jul-90 wb  Add support for old VAX C & VMS versions + zstrip & rename N  * 025 29-Jul-90 tmk Change space command to show avail, not used (match spec)L  * 026 29-Jul-90 tmk Hack out the RMS stuff - it can come back when it works@  * 027 29-Jul-90 tmk Likewise the VMS V3 stuff - ancient history?  * 028 29-Jul-90 tmk Replace the attribute stuff. It now works. /  * 029 31-Jul-90 tmk Fix CWD command (via hack) N  * 030 31-Jul-90 tmk Fix assorted bugs preventing remote commands from workingA  * 031 31-Jul-90 tmk Correctly handle interrupted remote commands C  * 032 04-Aug-90 tmk Start work on full RMS support for input files >  * 033 04-Aug-90 tmk Tack LF on end of subprocess output linesF  * 034 04-Aug-90 tmk Complete work on full RMS support for input filesC  * 035 04-Aug-90 tmk Add support for Fortran CC, fill in recfm data <  * 036 05-Aug-90 tmk Add trailing CRLF on print format filesD  * 037 12-Aug-90 tmk Start work on full RMS support for output files9  * 038 12-Aug-90 tmk Honor first free byte (FFB) on SENDs L  * 039 13-Aug-90 tmk Finished first cut of full RMS support for output files7  * 040 29-Sep-90 tmk Add iswild() from FDC for edit 157 L  * 041 06-Oct-90 tmk Add filetype IMAGE support for outbound transfers. NoteC  *		     that this doesn't currently work as the receiver overrides   *		     it (must talk to fdc). L  * 042 06-Oct-90 tmk Make logfiles MRS=80. Being able to edit them outweighs$  *		     any use for un-split lines.N  * 043 17-Oct-90 wb  Make zclosf() remove delete mailboxes & deassign channelsK  *                   used to talk to the subprocess, so quotas are not used F  *                   up after repeated mailbox use (installed by fdc).N  * 044 19-Oct-90 fdc Changed zxcmd() to use the fp[] arrays in the normal way,B  *                   and zsyscmd to call zxcmd(ZIFILE) rather thanK  *                   zxcmd(ZSYSFN).  Got rid of all calls to system(), used E  *                   zsyscmd() instead, so commands like DIR could be I  *                   interrupted.  Made zoutdump() return(-1) rather than J  *                   exit() when "line too long for buffer", and increased6  *                   line output buffer from 1K to 4K.K  * 045 01-Nov-90 tmk Corrected behavior of error check on $create call so a ,  *		     file supersede would work properly.M  * 046 01-Nov-90 tmk Clone binary flag to ofile_bmode so we have a consistent C  *		     view of this flag during file operations - the binary flag 9  *		     tends to toggle when we don't want/expect it to. L  * 047 01-Nov-90 tmk Make IMAGE mode work. Note that image mode is only used<  *		     when VMS is sending a file, and includes all record=  *		     control characters not normally sent. Only useful in   *		     unusual circumstances. M  * 048 01-Nov-90 tmk Remove spurious \n from zsoutl() which caused debug logs :  *		     to have spurious <CR>'s when viewed with editors.N  * 049 02-Nov-90 fdc Adapt to dynamic allocation of file i/o buffers.  ChangesG  *                   are within #ifdef DYNAMIC..#else..#endif brackets. ;  * 050 02-Nov-90 fdc Make zsyscmd() close inferior process. O  * 051 ??-???-?? ??? Add ckermit_init logical, return 0 on wildcard operations. O  * 052 24-Dec-90 tmk Fix performance problems after 32Kb w/ ASCII receives, fix A 		     2-nulls-per-32Kb in binary mode bug (actually in ckcker.h,  		     this is a placeholder).<  * 053 13-Jan-91 tmk Add support for SET FILE RECORD-LENGTH.L  * 054 14-Jan-91 tmk Fix cases of /x/CR/LF/y/ and /x/CR/LF/y/CR/LF/ in ASCII  *		     file receives. I  * 055 16-Jan-91 tmk Log requested file type to debug log when receiving. <  * 056 16-Jan-91 tmk Add support for all zstime() functions.8  * 057 17-Jan-91 tmk Add support for zchkspa() function.I  * 058 17-Jan-91 tmk Move debug() call into if clause in zxpand, per fdc. ;  * 059 18-Jan-91 tmk Support remote (DECnet) file accesses. &  * 060 18-Jan-91 tmk Fix READ command.L  * 061 30-Jan-91 tmk Support creation of UNDEFINED file types for brain-dead  *		     BASIC implementation.<  * 062 30-Jan-91 tmk Fix REMOTE commands when VERIFY is set.M  * 063 29-Mar-91 tmk Add padding factor for received text files to accomodate 7  *		     space taken up by record delimiters (per fdc). L  * 064 29-Mar-91 gm  Remove unnecessary mem-mem moves during ASCII receives.:  *		     (Installed by tmk. To back out, #define OLD_WAY).I  * 065 30-Mar-91 tmk First pass at implementing LABELED. Send only, dummy   *		     data records.L  * 066 02-Apr-91 tmk Finish first pass at LABELED. Send VMS filename, attri-A  *		     butes. Still need ACL's, "hidden" char. longword, recep-   *		     tion.L  * 067 09-Apr-91 tmk LABELED bugfixes - VMSFILE is 70 bytes, not 74, use the@  *		     xab$w_lrl field instead of rab$w_rsz, fab$w_deq insteadB  *		     of xab$w_rsz, fab$b_bks instead of xab$b_bkz, always pro-9  *		     cess an even multiple of 512 bytes when LABELED. N  * 068 14-Apr-91 tmk Don't use C definition of fab$b_journal as it doesn't ex-9  *		     ist before C V3.1. Compute it ourselves instead. L  * 069 15-Apr-91 tmk Initial work on retrieving ACL information for LABELED.?  * 070 16-Apr-91 tmk Make edits 066-069 compatible with DECnet. =  * 071 21-May-91 tmk Address R. Weiner QAR item 2 (filesize). G  * 072 21-Jun-91 tmk Check (and prohibit) spawns from captive accounts. F  * 073 21-Jun-91 tmk Fix session logging (for Charlie Luce/DECUServe).J  * 074 21-Jun-91 tmk Rework 071 to only apply to SPAWN/PUSH and not to the8  *		     pseudo-builtins like DEL, SPACE, WHO, PWD, etc.K  * 075 21-Jun-91 tmk Fix possible endless loop when flushing output file in )  *		     zclosf() after zoutdump() error. B  * 076 21-Jun-91 tmk First pass on handling inbound LABELED files.L  * 077 14-Nov-91 tmk Fix zprint(), zmail() (need to use system() for these).6  *                   This is a partial backout of 044.M  * 078 14-Nov-91 tmk Various cleanups.  Delete files after successful mailing @  *		     or printing, remove dead code inside #ifdef COMMENT andL  *                   #ifdef OLD_WAY, fix typo in spawning message, make sure1  *                   all source lines < 80 chars. L  * 079 22-Nov-91 fdc Change zmail(), zprint() error return values to improve  *		     error reporting. N  * 080 18-Jan-92 tmk Fix REMOTE so output from a remote command correctly dis-A  *		     plays on terminal. This has been broken since 040 or so. N  * 081 10-Jun-92 tmk Add William Bader's fix for fixed-length files which have'  *                   record attributes. K  * 082 03-Jul-92 tmk Fix really bad bug introduced in 081 (which made *all* 9  *                   fixed-format files be sent as text). M  * 083 15-Jul-92 jah Fix fencepost error in zoutdump when line breaks at 32K. D  * 084 03-Aug-92 fdc Remove current directory from init file search.7  * 085 26-Aug-92 tmk Add Bernd Onasch's fix for fgen(). M  * 086 28-Aug-92 tmk Fix bug reported by Bill Hoelzer where C-K would execute 7  *		     a file named "." as a C-K initialization file. L  * 087 04-Sep-92 tmk Fix bug reported by Chuck McMichael where C-K would notA  *		     set the FFB properly when receiving a labeled file which 3  *		     did not have the FFB on a record boundary. M  * 088 09-Sep-92 tmk Fix Hunter Goatley's problem with SPAWN command ignoring   *		     Ctrl-C./  * 089 11-Sep-92  js Fixed malloc() in zmail(). L  * 090 28-Oct-92 tmk Fix null-byte error introduced by 087. Gee, this looked&  *		     so simple when I designed it.L  * 091 02-Nov-92 tmk Start work on fixing spawn/push/remote commands, due to  *		     popular whining. A  * 092 03-Nov-92 tmk Finish up initial 091 work. Vote for Kermit! M  * 093 03-Nov-92 fdc Change zkermini() to work with "-y" command-line option. M  * 094 04-Nov-92 tmk Make zxpand() not return all files if given null string. M  * 095 05-Nov-92 fdc Make zxcmd(), zclose(), etc, handle ZRFILE (OPEN !READ). O  * 096 17-Feb-93 fdc prevent zopeno from calling zstime if date struct is NULL, C  *                   and add support for ZMFILE (misc output file). O  * 097 08-Apr-93 tmk Correctly handle "international VMS" which uses <> instead (  *		     of [] for directory delimiters.I  * 098 16-May-93 fdc ANSIfication for GNU CC, from James Sturdevant, plus L  *                   add FAB$M_PRN to list of text-file types, for VMS batch  *                   logs.M  * 099 07-Jun-93 fdc Fix calculation of file size in zchki(), fix declaration M  *                   of mbxnam[] (add one to size) to prevent overflow, which K  *                   would result in failure of server to respond to REMOTE A  *                   directory, etc.  Both fixes from Bill Glass. I  * 100 21-Jun-93 fdc file_date[] and attr_date[] declarations in zstime() N  *                   changed from long to unsigned long to prevent signed dateH  *                   comparisons, which could prevent SET FILE COLLISIONA  *                   UPDATE from working.  From James Sturdevant. <  * 101  8-Aug-93 fdc Add types to all function declarations.L  * 102 18-Aug-93 ttj Minor updates in zsattr() and do_label_recv() mainly toO  *                   quieten the compiler (which had every reason to complain). *  * 103  5-Nov-93 wb  Add isdir() function.,  * 104  8-Nov-93 wb  Add zfcdate() function.J  * 105 25-Nov-93 fdc Correct record format for session log; change name of?  *                   password structure member of zattr struct. H  * 106 22-Dec-93 tmk Correct fd "leakage" in OPEN READ/CLOSE READ pairs.2  * 107 26-Feb-94 mb  Addition of zmkdir() routine.F  * 108 27-Mar-94 tmk Increase max record size for logs from 80 to 254.<  *                   Add support for file append operations.M  *                   Make zkself() retry a few times to avoid zombies on BYE. ?  * 109  5-Apr-94 tmk Fix xx->lengthk not being set in zsattr(). D  * 110  8-Jun-94 tmk Use private fab in zchki (fixes OPEN READ bug).K  * 111 17-Jun-94 tmk Let zsattr() work even if there is no rights database. :  * 112  7-Jul-94 js  A couple small ANSIfications for gcc.L  * 113  7-Aug-94 fdc Make zshcmd()/zsyscmd() return proper return code, withL  *                   help from Larry Henry at TWG.  Still not quite right...D  * 114 29-Sep-94 fdc Increase max wildcard matches from 500 to 4096.,  * 115  4-Oct-94 mb  Add support for RESEND.&  * 116 26-Oct-94 mb  Minor fix to 115.K  * 117  1-Nov-94 wb  A couple #ifdefs added to allow compilation in VMS v4.   */   - /* Definitions of some VMS system commands */   9 char *DIRCMD = "directory ";		/* For directory listing */ B char *DIRCM2 = "directory ";		/* For directory listing, no args */2 char *DELCMD = "delete ";		/* For file deletion */1 char *TYPCMD = "type ";			/* For typing a file */ F char *SPACMD = "show quota "; 		/* Space/quota of current directory */B char *SPACM2 = "show quota "; 		/* Space/quota of specified dir */? char *WHOCMD = "show users ";		/* For seeing who's logged in */ C char *PWDCMD = "show default ";		/* For seeing current directory */    /*D   Functions (n is one of the predefined file numbers from ckermi.h):  8    zopeni(n,name)   -- Opens an existing file for input.3    zopeno(n,name)   -- Opens a new file for output. %    zclose(n)        -- Closes a file. B    zchin(n)         -- Gets the next character from an input file.O    zsout(n,s)       -- Write a null-terminated string to output file, buffered. A    zsoutl(n,s)      -- Like zsout, but appends a line terminator. E    zsoutx(n,s,x)    -- Write x characters to output file, unbuffered. E    zchout(n,c)      -- Add a character to an output file, unbuffered. O    zchki(name)      -- Check if named file exists and is readable, return size. :    zchko(name)      -- Check if named file can be created.K    zchkspa(name,n)  -- Check if n bytes available to create new file, name. K    znewn(name,s)    -- Make a new unique file name based on the given name. -    zdelet(name)     -- Delete the named file. N    zxpand(string)   -- Expands the given wildcard string into a list of files.G    znext(string)    -- Returns the next file from the list in "string". L    zxcmd(n,cmd)     -- Execute the command in a lower fork on file number n.M    zclosf()         -- Close input file associated with zxcmd()'s lower fork. ?    zrtol(n1,n2)     -- Convert remote filename into local form. ?    zltor(n1,n2)     -- Convert local filename into remote form. 0    zchdir(dirnam)   -- Change working directory.D    zhome()          -- Return pointer to home directory name string.#    zkself()         -- Log self out K    zsattr(struc zattr *) -- Return attributes for file which is being sent. E    zkermini(n1,n2)  -- Find kermit.ini using default scanning process   */    /* Includes */   #define CKVFIO_C #include "ckcdeb.h"  #include "ckcasc.h"  #include "ckcker.h"  #include "ckvvms.h"  #include <stdio.h> #include <types.h> #include <stat.h>  #include <ctype.h> #include <time.h>  #include <errno.h> #include <rms.h> #include <ssdef.h> #include <descrip.h> #include <dvidef.h>  #include <dcdef.h> #include <iodef.h> #include <jpidef.h>  #include <signal.h>  #include <string.h>  #include <syidef.h>  #include <uaidef.h>   3 /* rms.h above includes nam, fab, xab and rmsdef */ < /* vms v4 headers do not check against multiple inclusion */G /* ifndefs below prevent multiple declaration of FAB and NAM structs */    #ifndef FAB$C_BID 5 #include <fab.h>			/* These are needed for isdir() */  #endif /* FAB$C_BID */   #ifndef NAM$C_BID  #include <nam.h> #endif /* NAM$C_BID */   #include <lnmdef.h>  #include <rmsdef.h>   6 #define MAXWLD 4096			/* Maximum wildcard filenames */  D /* external def. of things used in buffered file input and output */   #ifdef DYNAMIC$ extern CHAR *zinbuffer, *zoutbuffer; #else & extern CHAR zinbuffer[], zoutbuffer[]; #endif /* DYNAMIC */   extern CHAR *zinptr, *zoutptr; extern int zincnt, zoutcnt;  extern int binary; extern int frecl;  extern int rcflag;   extern long vernum;    /* Declarations */  + FILE *fp[ZNFILS] = { 			/* File pointers */ J     NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL };  1 static long iflen = -1;			/* Input file length */ 2 static long oflen = -1;			/* Output file length */8 static int fcount;			/* Number of files in wild group */; static char nambuf[255];		/* maximum size of a file spec */ ! static char cwdbuf[NAM$C_MAXRSS]; 1 static struct iosb_struct tmpiosb;	/* For QIOW */   8 extern unsigned long vms_status;	/* Used by CHECK_ERR */  8 static int cflag;			/* Flag indicating console in use */   int check_spawn(void); int do_label_recv(void); int do_label_send(char *name);E static int parse_fname(char *cp, int cp_len, char *defnam, int flag); . int fgen(char *pat, char *resarry[], int len); char *getenv(), *strcpy();  * /* static */				/* Not static any more! */7 char *mtchs[MAXWLD],			/* Matches found for filename */ .   **mtchptr;				/* Pointer to current match */  G static unsigned short mbx_chan;		/* Mailbox chan for REMOTE commands */ + static int subprocess_input = 0, sub_count; , static char *sub_ptr, sub_buf[SUB_BUF_SIZE];  / #define	SUPERSAFE			/* For safe subprocesses */  static unsigned long sub_pid;    /*#  * Structures for input (SEND) file   */    static	struct FAB fab_ifile; static	struct RAB rab_ifile;" static	struct XABDAT xabdat_ifile;" static	struct XABFHC xabfhc_ifile;" static	struct XABPRO xabpro_ifile;" static	struct XABALL xaball_ifile; static	int ifile_bmode;  static	int ifile_bcount; static	char aclbuf[512]; static	unsigned long uchar = 0;    /*'  * Structures for output (RECEIVE) file   */    static	struct FAB fab_ofile; static	struct RAB rab_ofile;" static	struct XABDAT xabdat_ofile;" static	struct XABFHC xabfhc_ofile;" static	struct XABPRO xabpro_ofile;" static	struct XABALL xaball_ofile;" static	struct XABRDT xabrdt_ofile; static	int ofile_dump; static	int ofile_bmode;  static	int ofile_lblopts;  static	int ofile_lblproc;  static	char revdat[8]; static	unsigned short revnum;  static	char ofile_vmsname[255];  static	char ofile_vmsacl[512]; static	int ofile_acllen; static	short ofile_ffb;    /*  * Common RMS items   */ ! static	unsigned long int rms_sts;   = /*  I S W I L D  --  Tells whether filespec "str" is wild  */ ' /*  Returns 0 if not wild, 1 if wild */    int  iswild(str) char *str; {     char c;       while ((c = *str++) != '\0')*       if (c == '*' || c == '%') return(1);     return(0); }    #ifdef CK_TMPDIR  K /*  I S D I R  --  Tells if string pointer s is the name of a directory. */ 4 /*  Returns 1 if directory, 0 if not a directory. */$ /*  Contributed by William Bader. */   int  isdir(s) char *s; { 
     int x;     struct stat statbuf;     int i, s_len;      char *full_name;#     static char dot_dir[] = ".dir"; (     static char zero_dir[] = "[000000]";  :     char name_buf[255];			/* Was 512 but that's too big */ 					/* for unsigned char! */      struct FAB fab;      struct NAM nam;   #     struct dsc$descriptor_s indesc; *     $DESCRIPTOR(lnmtable, "LNM$FILE_DEV");     int new_len;     int serial_num;      struct { 	short length; 	short code; 	char *address; 
 	int *len;
 	int term;     } itemlist;        if (!s) return(0);     if (!*s) return(0);   B     /* Determine if this is something we can SET DEFAULT to...  */       s_len = strlen(s);  F     if (s[s_len-1] != ':' && s[s_len-1] != ']' && s[s_len-1] != '>') {.     	/* Does not look like a directory name */     	return(0);      }   3     /* Check that the directory part is valid... */   1     if (s[s_len-1] == ']' || s[s_len-1] == '>') {          fab = cc$rms_fab;          nam = cc$rms_nam;            fab.fab$l_dna = 0;         fab.fab$b_dns = 0;           fab.fab$l_fna = s;         fab.fab$b_fns = s_len;           fab.fab$l_fop = 0;         fab.fab$w_ifi = 0;         fab.fab$l_nam = &nam;   !         nam.nam$l_esa = name_buf; )         nam.nam$b_ess = sizeof(name_buf);          nam.nam$b_nop = 0;         nam.nam$l_rlf = 0;         nam.nam$l_rsa = 0;         nam.nam$b_rsl = 0;         nam.nam$l_fnb = 0;  "         i = sys$parse(&fab, 0, 0); #ifdef COMMENT7 	printf("parse returned %d 0x%x, nam fnb is %d 0x%x\n", , 	       i, i, nam.nam$l_fnb, nam.nam$l_fnb); #endif /* COMMENT */$         if ((i & 1) == 0) return(0);     }   .     /* Check that the logical name is valid */       i = s_len - 1;&     while (i >= 0 && s[i] != ':') i--;        if (i >= 0 && s[i] == ':') {3     	if (i == 0) return(0);		/* Single colon (:) */      	if (s[i-1] == ':') { >     	    if (i > 1) return(1);	/* DECnet node name (blah::) */,     	    else return(0);		/* or :: alone. */     	} 	s_len = i;  	full_name = malloc(s_len + 1);  	if (!full_name) return(0); " 	/* Logicals must be upper case */ 	for (i = 0; i < s_len; i++) { 	    full_name[i] = s[i]; 4 	    if (full_name[i] >= 'a' && full_name[i] <= 'z') 		full_name[i] -= ('a' - 'A'); 	} 	  	indesc.dsc$w_length = s_len; " 	indesc.dsc$a_pointer = full_name;$ 	indesc.dsc$b_class = DSC$K_CLASS_S;$ 	indesc.dsc$b_dtype = DSC$K_DTYPE_T;  . 	itemlist.length = new_len = sizeof(name_buf); 	itemlist.code = LNM$_STRING;  	itemlist.address = name_buf;  	itemlist.len = &new_len;  	itemlist.term = 0;   5 	i = sys$trnlnm(0, &lnmtable, &indesc, 0, &itemlist); 1 	if (i != SS$_NORMAL || new_len < 0) new_len = 0; A 	if (new_len >= sizeof(name_buf)) new_len = sizeof(name_buf) - 1;  	name_buf[new_len] = '\0';   #ifdef COMMENTD 	printf("trnlnm result %d 0x%x, '%.*s'\n", i, i, new_len, name_buf); #endif /* COMMENT */   	free(full_name);    	if (new_len == 0) {( 	    /* Could still be a device name. */, 	    /* Only disks have serial numbers... */ 	    serial_num = 0;4 	    itemlist.length = new_len = sizeof(serial_num);$ 	    itemlist.code = DVI$_SERIALNUM;- 	    itemlist.address = (char *) &serial_num;  	    itemlist.len = &new_len;  	    itemlist.term = 0; : 	    i = sys$getdvi(0, 0, &indesc, &itemlist, 0, 0, 0, 0); #ifdef COMMENT5 	    printf("getdvi ret %d 0x%x, serial %d len %d\n",   		   i, i, serial_num, new_len); #endif /* COMMENT */2 	    return(((i & 1) == 1 && new_len > 0) ? 1: 0);  ) 	} else if (name_buf[new_len-1] == ':' ||   			name_buf[new_len-1] == ']' ||  			name_buf[new_len-1] == '>') { 	    /* Check returned value */  	    if (new_len > 2 && F 	        (name_buf[new_len-1] == ']' || name_buf[new_len-1] == '>') &&& 	        name_buf[new_len-2] == '.') {< 	    	/* Remove trailing dot in directory of logical name */0 	    	name_buf[new_len-2] = name_buf[new_len-1];! 	    	name_buf[new_len-1] = '\0';  	    } 	    return( isdir(name_buf) ); 	 	} else { B 	    /* Logical name is just a random string signifying nothing */ 	    return( 0 );  	}     }        return(1); }  #endif /* CK_TMPDIR */  & /*  Z K S E L F  --  Log self out.  */   int 
 zkself() {
     int i;     unsigned long int rms_s; /*K   We need a better way.  If C-Kermit was spawned, this does not log out the ?   whole job.    It also does not hang up LAT terminal sessions.  */     for (i = 0; i < 10; i++) {: 	rms_s = sys$delprc(0,0);	/* Maybe some output is still */% 	debug(F101,"zkself rms_s","",rms_s); : 	if (rms_s == SS$_NORMAL)	/* queued; try a few times... */ 	  exit(1); 
 	sleep(1);     }      exit(rms_s == SS$_NORMAL);M     return(0); /* dummy - required as this is called in a non-void context */  }   8 /*  Z O P E N I  --  Open an existing file for input. */   int # zopeni(n,name) int n; char *name; { !     debug(F111," zopeni",name,n); &     debug(F101,"  fp","",(int) fp[n]);     if (chkfn(n)) return(0);<     if (n == ZSYSFN) {			/* Input from a system function? */; 	debug(F110," zopeni called with ZSYSFN, failing!",name,0); % 	*nambuf = '\0';			/* No filename. */  	return(0);			/* fail. */      } 9     zincnt = 0;				/* Initializing these couldn't hurt */      zinptr = zinbuffer; .     if (n == ZSTDIO) {			/* Standard input? */ 	if (isatty(0)) { , 	    ermsg("?Terminal input not allowed\n");H 	    debug(F110," zopeni attempted input from unredirected stdin","",0); 	    return(0);  	} 	fp[ZIFILE] = stdin; 	return(1);      }  /*M  * We open the file but waffle on the access mode we're going to use. We then N  * inspect the file characteristics to see if the organization is fixed or un-N  * defined. If it is, we convert to block mode operation. This is needed sinceO  * VMS maintains a "first free byte" field to tell us how much of the last rec- N  * ord really contains data, but won't terminate reads at that point. Thus, ifL  * we want to SEND the exact same file we RECEIVEd, we have to honor the FFB  * internally.  */ %     if (n == ZIFILE || n == ZRFILE) {  	ifile_bmode = 0;  	ifile_bcount = 0; 	fab_ifile = cc$rms_fab;- 	fab_ifile.fab$b_fac = FAB$M_BRO | FAB$M_GET;  /*J  * Some non-VMS DECnet implementations don't allow switching modes, so setG  * block-I/O only mode if the user said SET FILE TYPE IMAGE or LABELED.   */ * 	if (binary == XYFT_I || binary == XYFT_L)1 	    fab_ifile.fab$b_fac = FAB$M_BIO | FAB$M_GET;  	fab_ifile.fab$l_fna = name;$ 	fab_ifile.fab$b_fns = strlen(name);- 	fab_ifile.fab$l_xab = (char *)&xabdat_ifile;  	rab_ifile = cc$rms_rab;" 	rab_ifile.rab$l_fab = &fab_ifile; 	xabdat_ifile = cc$rms_xabdat;0 	xabdat_ifile.xab$l_nxt = (char *)&xabfhc_ifile; 	xabfhc_ifile = cc$rms_xabfhc;0 	xabfhc_ifile.xab$l_nxt = (char *)&xabpro_ifile; 	xabpro_ifile = cc$rms_xabpro;$ 	memset(&aclbuf, 0, sizeof(aclbuf));> 	xabpro_ifile.xab$l_aclsts = SS$_NORMAL;		/* Oh Joy! DECnet */- 	xabpro_ifile.xab$l_aclbuf = (char *)&aclbuf; , 	xabpro_ifile.xab$w_aclsiz = sizeof(aclbuf); 	xabpro_ifile.xab$l_aclctx = 0; 0 	xabpro_ifile.xab$l_nxt = (char *)&xaball_ifile; 	xaball_ifile = cc$rms_xaball;    	rms_sts = sys$open(&fab_ifile); 	if (rms_sts != RMS$_NORMAL) {; 	    debug(F101," zopeni $open failed, status","",rms_sts); D 	    debug(F101," zopeni $open failed, stv","",fab_ifile.fab$l_stv); 	    return(0);  	}( 	if (!(xabpro_ifile.xab$l_aclsts & 1)) {5 	    if (xabpro_ifile.xab$l_aclsts != SS$_ACLEMPTY) { 3 		debug(F101," zopeni $open ACL failed, status","",  		  xabpro_ifile.xab$l_aclsts);  		return(0); 	    } 	} /*D  * We have the file opened. See if it's fixed or undefined format...  */ ( 	if (fab_ifile.fab$b_rfm == FAB$C_UDF) {F 	    debug(F100," zopeni undefined file format - using blk I/O","",0); 	    ifile_bmode = 1;  	}( 	if (fab_ifile.fab$b_rfm == FAB$C_FIX) {C 	    if ((fab_ifile.fab$b_rat & (FAB$M_FTN | FAB$M_CR | FAB$M_PRN)) 	 		== 0) { ? 		debug(F100," zopeni fixed file format - using blk I/O","",0);  		ifile_bmode = 1; 	    }   	}5 	debug(F101," zopeni binary flag at open","",binary);  	if (binary == XYFT_I) {A 	    debug(F100," zopeni using IMAGE mode by user request","",0);  	    ifile_bmode = 1;  	} 	if (binary == XYFT_L) {C 	    debug(F100," zopeni using LABELED mode by user request","",0);  	    ifile_bmode = 2;  	} 	rab_ifile.rab$l_rop = 0; # 	rms_sts = sys$connect(&rab_ifile);  	if (rms_sts != RMS$_NORMAL) {> 	    debug(F101," zopeni $connect failed, status","",rms_sts); 	    return(0);  	}8 	debug(F100," zopeni RMS operations completed ok","",0);= 	fp[n] = fopen("NLA0:","r");	/* it wants a fp, give it one */ ' 	zincnt = 0;			/* reset input buffer */  	if (binary == XYFT_L)1 	    do_label_send(name);	/* make a file label */  	return(1);      } +     zincnt = 0;				/* Reset input buffer */ .     fp[n] = fopen(name,"r");		/* Real file. */-     debug(F111," zopeni", name, (int) fp[n]); (     if (fp[n] == NULL) perror("zopeni");$     return((fp[n] != NULL) ? 1 : 0); }   4 /*  Z O P E N O  --  Open a new file for output.  */   int  zopeno(n,name,zz,fcb) ?     int n; char *name; struct zattr *zz; struct filinfo *fcb; {   H /* As of Version 5A, the attribute structure and the file information */, /* structure are included in the arglist. */       int fildes;      int writeover = 0;     extern int rs_len;     char p[4];       if (n != ZDFILE)#       debug(F111," zopeno",name,n); !     if (chkfn(n) != 0) return(0);   1     zoutcnt = 0;		/* (PWP) reset output buffer */      zoutptr = zoutbuffer; 3     cflag = 0;			/* default to not using console */    /*  * Open Terminal or STDIO   */   )     if ((n == ZCTERM) || (n == ZSTDIO)) {  	fp[ZOFILE] = stdout; $ 	cflag = 1;		/* say using console */ 	if (n != ZDFILE) 1 	    debug(F101," fp[]=stdout", "", (int) fp[n]);  	return(1);      }    /*D  * Open Debug, Transaction, Packet, Session logfile, or a Write fileO  * The only other possibility at this point is the output file, so we test that   */        if (fcb):       debug(F101," zopeno fcb disposition", "", fcb->dsp);     if (zz) E       debug(F111," zopeno zz disposition",zz->disp.val,zz->disp.len);        if (n != ZOFILE) {1 	strcpy(p,"w");				/* Assume write/create mode */ - 	if (fcb) {				/* If called with an FCB... */ 7 	    if (fcb->dsp == XYFZ_A)		/* Does it say Append? */   	    strcpy(p,"a");			/* Yes. */ 	} 	if (n != ZSFILE) 5 	  /* was mrs = 80; 254 is max record size for EDT */ : 	  fp[n] = fopen(name, p, "rat=cr", "rfm=var", "mrs=254"); 	else 0 	  fp[n] = fopen(name, p, "ctx=stm", "rfm=stm");# 	if (fp[n] == NULL) {		/* Failed */ 8 	    debug(F101,"zopeno VAXCRTL failed errno","",errno);4 	    perror(name);		/* Print system error message */ 	} else {			/* Didn't fail */ , 	    debug(F100,"zopeno VAXCRTL ok", "", 0); 	}! 	return((fp[n] != NULL) ? 1 : 0);      }    /*+  * Open a file to store data being RECEIVEd   */        if (n == ZOFILE) { 	switch (binary) { 	    case XYFT_T: 1 		debug(F100," zopeno receiving TEXT file","",0);  		break; 	    case XYFT_B: 3 		debug(F100," zopeno receiving BINARY file","",0);  		break; 	    case XYFT_I: ? 		debug(F100," zopeno receiving IMAGE file-program bug!","",0);  		break; 	    case XYFT_L: 4 		debug(F100," zopeno receiving LABELED file","",0); 		break; 	    case XYFT_U: 6 		debug(F100," zopeno receiving UNDEFINED file","",0); 		break;
 	    default: 4 		debug(F101," zopeno unknown file type","",binary); 	} 	ofile_bmode = binary; 	ofile_dump = 0; 	ofile_ffb = -1; 	fab_ofile = cc$rms_fab; 	fab_ofile.fab$l_fna = name;$ 	fab_ofile.fab$b_fns = strlen(name);! 	fab_ofile.fab$l_fop = FAB$M_MXV; ! 	fab_ofile.fab$b_fac = FAB$M_PUT;  /*K  * Note that we could actually implement a true overwrite (step on existing K  * file version) operation here by testing for a new XYFZ_* type as well in L  * the line below, and then simply not doing a RAB$M_EOF about 25 lines downM  * from here. We might also have to do something to reset the file allocation M  * so we aren't left with a large number of "leftover" blocks if the new file   * is smaller than the old one.   */  	if (fcb) {  	    if (fcb->dsp == XYFZ_A) {" 		fab_ofile.fab$l_fop = FAB$M_CIF; /*D   This is for RESEND.  If the output mode is APPEND and the incomingD   attributes structure (zz) says "Resend", then we know this file is   being resent.  */, 		if (*(zz->disp.val) == 'R' && ofile_bmode) 		  writeover = 1;: 		debug(F101," zopeno APPENDing, writeover","",writeover); 		if (writeover)3 		  debug(F101," zopeno RESEND, rs_len","",rs_len);  /*K   So if writeover != 0, we can take rs_len to be the length of the existing N   file to keep, and to write over the rest, which normally should be the final   block. */ 	    } 	} 	if (ofile_bmode) { % 	    fab_ofile.fab$b_fac = FAB$M_BIO; 6 	    debug(F101," zopeno using record size","",frecl);! 	    fab_ofile.fab$w_mrs = frecl;  	    if (ofile_bmode == XYFT_U) ' 	      fab_ofile.fab$b_rfm = FAB$C_UDF; 	 	    else ' 	      fab_ofile.fab$b_rfm = FAB$C_FIX; 	 	} else { $ 	    fab_ofile.fab$b_rat = FAB$M_CR;% 	    fab_ofile.fab$b_rfm = FAB$C_VAR;  	}! 	fab_ofile.fab$b_shr = FAB$M_NIL; - 	fab_ofile.fab$l_xab = (char *)&xabdat_ofile;  	rab_ofile = cc$rms_rab;" 	rab_ofile.rab$l_fab = &fab_ofile;	 	if (fcb) 2 	    if ((fcb->dsp == XYFZ_A) && (writeover == 0))" 		rab_ofile.rab$l_rop = RAB$M_EOF; 	xabdat_ofile = cc$rms_xabdat;0 	xabdat_ofile.xab$l_nxt = (char *)&xabfhc_ofile; 	xabfhc_ofile = cc$rms_xabfhc; 	if (zz)0 	  zstime(name, zz, 2);		/* set creation date */9 	if (ofile_bmode == XYFT_L) {	/* defer open if labeled */ ; 	    ofile_lblproc = 0;		/* haven't processed labels yet */ " 	    ofile_lblopts = fcb->lblopts;4 	    debug(F101," zopeno lblopts","",ofile_lblopts);8 	    debug(F100," zopeno RMS operations deferred","",0);	 	} else { & 	    rms_sts = sys$create(&fab_ofile); 	    if (!(rms_sts & 1)) {: 		debug(F101," zopeno $create failed, status","",rms_sts); 		return(0); 	    }' 	    rms_sts = sys$connect(&rab_ofile); " 	    if (rms_sts != RMS$_NORMAL) {; 		debug(F101," zopeno $connect failed, status","",rms_sts);  		return(0); 	    }/ 	    if (writeover == 1) {		/* if resend ... */ 4 		rab_ofile.rab$l_bkt = (unsigned long) rs_len >> 9;= 		rms_sts = sys$space(&rab_ofile);/* space forward to last */ / 		rab_ofile.rab$l_bkt = 0;	/* complete block */  		if (rms_sts != RMS$_NORMAL) { = 		    debug(F101," zopeno $space failed, status","",rms_sts);  		    return(0); 		}  	    }< 	    debug(F100," zopeno RMS operations completed ok","",0); 	}= 	fp[n] = fopen("NLA0:","r");	/* it wants a fp, give it one */  	return(1);      }  }   . /*  Z C L O S E  --  Close the given file.  */  K /*  Returns 0 if arg out of range, 1 if successful, -1 if close failed.  */    int  zclose(n) int n; {     int x=0;       debug(F101," zclose","",n);       if (chkfn(n) < 1) return(0);  > /* If this is the subprocess file, close it to flush output */  D     if ((n == ZIFILE || (n == ZRFILE)) && (subprocess_input != 0)) {4         debug(F100, "zclose calling zclosf", "", 0); 	return (zclosf(n));     }    /* Input file */  )     if ((n == ZIFILE) || (n == ZRFILE)) { ! 	rms_sts = sys$close(&fab_ifile);  	if (rms_sts != RMS$_NORMAL) {< 	    debug(F101," zclose $close failed, status","",rms_sts); 	    return(-1); 	}8 	debug(F100," zclose RMS operations completed ok","",0);/ 	x = fclose(fp[n]);		/* close the dummy file */ % 	fp[n] = NULL;			/* and mark it so */  	iflen = -1; 	return(1);      }    /* Output file */ ? /* This can probably be combined with the ZIFILE stuff later */        if (n == ZOFILE) {- 	ofile_dump = 1;				/* force complete dump */  	while (zoutcnt != 0) { 7 	    rms_sts = zoutdump();		/* flush buffers to disk */  	    if (rms_sts != 0)& 		return(-1);			/* in case of error */ 	}  ? 	if (ofile_bmode == XYFT_L) { /* update revisions if labeled */ ? 	    debug(F100," zclose updated labeled revision count","",0); 1 	    memmove(&xabrdt_ofile.xab$q_rdt, revdat, 8); 2 	    memmove(&xabrdt_ofile.xab$w_rvn, &revnum, 2); 	} 	if (cflag != 1) {% 	    rms_sts = sys$close(&fab_ofile); " 	    if (rms_sts != RMS$_NORMAL) {9 		debug(F101," zclose $close failed, status","",rms_sts); 
 		return(-1);  	    }4 	    x = fclose(fp[n]);			/* close the dummy file */	 	} else {  	    cflag = 0;  	}8 	debug(F100," zclose RMS operations completed ok","",0);& 	fp[n] = NULL;				/* and mark it so */ 	iflen = -1; 	return(1);      }        /* Other kind of file */  .     if ((fp[n] != stdout) && (fp[n] != stdin))       x = fclose(fp[n]);     fp[n] = NULL; 0     iflen = -1;					/* Invalidate file length */     debug(F101,"  x","",x); 2     if (x == EOF)				/* if we got a close error */       return (-1);     else       return (1);  }    int  get_subprc_line() {      struct iosb_struct subiosb;        unsigned int sts;  /*L  * Someone complained that subprocess deletion would hang the Kermit server.O  * This can be triggered by sending something silly like REMOTE HOST STOP/ID=0. J  * If SUPERSAFE is defined we will check to make sure the subprocess stillO  * exists before every read from the mailbox. This will slow things down a bit, 4  * but should stop the "C-Kermit just dies" reports.  */  #ifdef	SUPERSAFE     unsigned short pid;        struct itmlstdef { 	short int buflen; 	short int itmcod; 	char *bufaddr;  	long int *retlen;     };!     struct itmlstdef itmlst[] = {  	4, JPI$_PID, (char *)&pid, 0, 	0, 0, 0, 0      };8     sts = sys$getjpiw(0, &sub_pid, 0, &itmlst, 0, 0, 0);  >     debug(F101,"get_subprc_line sys$getjpiw status", "", sts);     if (sts == SS$_NONEXPR)  	return(-1); #endif	/* SUPERSAFE */  M     sts = sys$qiow(QIOW_EFN, mbx_chan, IO$_READVBLK, &subiosb, 0, 0, sub_buf,  	 sizeof(sub_buf), 0, 0, 0, 0);   ;     debug(F101,"get_subprc_line sys$qiow status", "", sts);      if (sts != SS$_NORMAL) 	return(-1);  N     debug(F101,"get_subprc_line sys$qiow subiosb.status", "", subiosb.status);(     if (subiosb.status == SS$_ENDOFFILE) 	return(-1);  %     if (subiosb.status != SS$_NORMAL)  	return(-1);  !     sub_buf[subiosb.size] = '\r'; %     sub_buf[subiosb.size + 1] = '\n'; %     sub_buf[subiosb.size + 2] = '\0'; !     sub_count = subiosb.size + 2;      sub_ptr = sub_buf;       return(0); }   ; /*  Z C H I N  --  Get a character from the input file.  */   J /*  Returns -1 if EOF, 0 otherwise with character returned in argument  */   int  zchin(n,c) int n, *c; { 
     int a;   #ifdef DEBUG!     if (chkfn(n) < 1) return(-1);  #endif  *     if (n == ZIFILE && subprocess_input) { 	if (--sub_count < 0) ' 	    if (get_subprc_line()) return(-1);  	a = *sub_ptr++;     } else { 	a = zminchar();     }      if (a == EOF) return(-1);      *c = (unsigned char)a;     return(0); }   / /*  Z S I N L  --  Read a line from a file.  */    /*:   Writes the line into the address provided by the caller.#   n is the Kermit "channel number". H   Writing terminates when newline is encountered, newline is not copied.?   Writing also terminates upon EOF or if length x is exhausted. +   Returns 0 on success, -1 on EOF or error.  */   int ! zsinl(n,s,x) int n, x; char *s; {      int a, z = 0;      int old;  6     if (chkfn(n) < 1) {			/* Make sure file is open */ 	return(-1);     }      a = -1;      while (x--) { $ 	old = a;			/* Previous character */; 	if (zchin(n,&a) < 0)		/* Read a character from the file */ , 	  return(-1);			/* Signal EOF if problem */ 	a = a & 0377;
 #ifdef NLCHAR F 	if (a == (char) NLCHAR) break;	/* Single-character line terminator */ #else  	if (a == '\r') {  	    continue; 	} 	if (old == '\r') {  	    if (a == '\n') break; 	    else *s++ = '\r'; 	} #endif /* NLCHAR */  	*s = a; 	s++;      }      *s = '\0';     return(z); }   3 /*  Z I N F I L L  --  Read a line from a file.  */    /*E  * (re)fill the buffered file input buffer with data.  All file input D  * should go through this routine, usually by calling the zminchar()  * macro (defined in ckcker.h).   */    int  zinfill() {      char cchar;      int linelen;       if (subprocess_input) { # 	if (get_subprc_line()) return(-1);  /*H  * The size problem should never happen.  sub_buf of a size greater then&  * 1k is highly unlikely to be needed.  */   	if (INBUFSIZE < SUB_BUF_SIZE) {@ 	    fprintf(stderr,"zinfill: sub_buf too large for zinbuffer"); 	    exit(); 	} 	zinptr = sub_buf; 	zincnt = sub_count;     } else { 	if (ifile_bmode != 0) {: 	    rab_ifile.rab$l_rop = RAB$M_BIO;	/* block mode I/O */ #ifdef DYNAMIC% 	    rab_ifile.rab$l_ubf = zinbuffer;  #else & 	    rab_ifile.rab$l_ubf = &zinbuffer; #endif /* DYNAMIC */ /*F   There is a serious flaw here, namely that reading blocks rather thanE   records *includes* the record pad byte (NUL) when the record has an K   odd length.  All RMS records are stored on even-numbered byte boundaries. H   Kermit-32 did it right, sigh.  So we need a total rewrite to allow forF   odd-length records.  Hmmm.. I wonder what the impact on RESEND is... */ 	    rab_ifile.rab$w_usz = 512; $ 	    rms_sts = sys$read(&rab_ifile); 	    if (rms_sts == RMS$_EOF) ! 		return(-1);			/* end of file */ " 	    if (rms_sts != RMS$_NORMAL) {9 		debug(F101," zinfill $read failed, status","",rms_sts);  		return(-1);			/* fatal */  	    }2 	    ifile_bcount++;		/* Say another block read */ 	    zincnt = 512; 	    zinptr = zinbuffer;  E 	    if (rab_ifile.rab$l_bkt != 0) { /* If just a file position... */ @ 		ifile_bcount = rab_ifile.rab$l_bkt; /* update block counter */ 	    }2 	    if (ifile_bcount == xabfhc_ifile.xab$l_ebk) {4 		if (ifile_bmode == 1)	/* BINARY but not LABELED */& 		    zincnt = xabfhc_ifile.xab$w_ffb; 	    }E 	    if (rab_ifile.rab$l_bkt != 0) { /* If just a file position... */ 2 		return(0);		    /*...then done                */ 	    }. 	    zincnt--;			/* one less char in buffer */G 	    return((int)(*zinptr++) & 0377); /* because we return the first */  	}' 	if (fab_ifile.fab$b_rat & FAB$M_FTN) {  #ifdef DYNAMIC' 	    rab_ifile.rab$l_ubf = zinbuffer+2;  #else ( 	    rab_ifile.rab$l_ubf = &zinbuffer+2; #endifD 	    rab_ifile.rab$w_usz = INBUFSIZE-4;	/* space for carriage ctl */	 	} else {  #ifdef DYNAMIC% 	    rab_ifile.rab$l_ubf = zinbuffer;  #else & 	    rab_ifile.rab$l_ubf = &zinbuffer; #endifF 	    rab_ifile.rab$w_usz = INBUFSIZE-2;	/* space for possible CR/LF */ 	}1 	rab_ifile.rab$l_rop = 0;		/* doing record I/O */  	rms_sts = sys$get(&rab_ifile);  	if (rms_sts == RMS$_EOF) % 	    return(-1);				/* end of file */  	if (rms_sts != RMS$_NORMAL) {; 	    debug(F101," zinfill $get failed, status","",rms_sts);  	   return(-1);				/* fatal */ 	}   /*M  * Do assorted contortions with Fortran carriage control to make it formatted N  * ASCII instead, since many systems don't know about Fortran format in files.  */   ' 	if (fab_ifile.fab$b_rat & FAB$M_FTN) { = 	    linelen = rab_ifile.rab$w_rsz-1;	/* sans control code */ . 	    cchar = zinbuffer[2];		/* control code */ 	    switch (cchar) {  		case '\0':			/* data<CR> */  		case '+': 6 		    zinbuffer[linelen+3] = '\r';/*  insert return */ 		    zinptr = zinbuffer+3; ) 		    zincnt = linelen+1;		/* count it */  		    break;  		case '$':			/* <LF>data<CR> */ 		case ' ': 0 		    zinbuffer[2] = '\n';	/*  insert newline */6 		    zinbuffer[linelen+3] = '\r';/*  insert return */ 		    zinptr = zinbuffer+2; + 		    zincnt = linelen+2;		/*  count 'em */  		    break;( 		case '0':			/* <LF><CR><LF>data<CR> */4 		    zinbuffer[0] = '\n';	/*  insert 1st newline */3 		    zinbuffer[1] = '\r';	/*  insert 1st return */ 4 		    zinbuffer[2] = '\n';	/*  insert 2nd newline */: 		    zinbuffer[linelen+3] = '\r';/*  insert 2nd return */ 		    zinptr = zinbuffer; + 		    zincnt = linelen+4;		/*  count 'em */  		    break;  		case '1':			/* <FF>data<CR> */1 		    zinbuffer[2] = '\f';	/*  insert formfeed */ 6 		    zinbuffer[linelen+3] = '\r';/*  insert return */ 		    zinptr = zinbuffer+2; + 		    zincnt = linelen+2;		/*  count 'em */  		    break; 		default:			/* <LF>data<CR> */ 0 		    zinbuffer[2] = '\n';	/*  insert newline */6 		    zinbuffer[linelen+3] = '\r';/*  insert return */ 		    zinptr = zinbuffer+2; + 		    zincnt = linelen+2;		/*  count 'em */  		    break; 	    }	 	} else { " 	    zincnt = rab_ifile.rab$w_rsz;. 	    zinptr = zinbuffer;			/* reset pointer */ 	}   /*K  * Here we see if we need to insert CR/LF pairs at the record boundary. For I  * the moment, we will add them if the file has "carriage return carriage L  * control" when looked at by a DIRECTORY command. As of edit 036 we also doI  * this for "print file carriage control" files. I'm open to comments de- ,  * scribing cases where this doesn't work...  */   4 	if (fab_ifile.fab$b_rat & (FAB$M_CR | FAB$M_PRN)) { 	    zinbuffer[zincnt] = '\r';" 	    zinbuffer[zincnt + 1] = '\n'; 	    zincnt += 2;  	}     } -     zincnt--;			/* one less char in buffer */ F     return((int)(*zinptr++) & 0377); /* because we return the first */ }      A /*  Z F S E E K -- Seek to a given position with an input file */ A /*                 Assumes block-mode I/O being used           */    int  zfseek(long pos) {     long offset;  J     rab_ifile.rab$l_bkt = (unsigned long) pos >> 9; /* Get block number */3     rab_ifile.rab$l_bkt++;		/* VBN's are 1-based */ C     offset = (unsigned long) pos & 511;	/* Get offset with block */ 2     if (zinfill() != 0) {		/* Read in the block */8 	rab_ifile.rab$l_bkt = 0;	/* Sequentially from now on */ 	return(-1);     } <     rab_ifile.rab$l_bkt = 0;		/* Sequentially from now on */7     if (offset != 0) {			/* if not block boundary... */ < 	zincnt = zincnt - offset;	/* ...adjust count and pointer */ 	zinptr = zinptr + offset;     }      return(0); }   B /*  Z S O U T  --  Write a string to the given file, buffered.  */   int  zsout(n,s) int n; char *s; { #ifdef DEBUG!     if (chkfn(n) < 1) return(-1);  #endif6     fputs(s, fp[n]);			/* Don't use fprintf here MM */     return(0); }      N /*  Z S O U T L  --  Write string to file, with line terminator, buffered.  */   int  zsoutl(n,s) int n; char *s; {  #ifdef DEBUG!     if (chkfn(n) < 1) return(-1);  #endif1     fputs(s, fp[n]);			/* Don't use fprintf MM */      putc('\n', fp[n]);     return(0); }      @ /*  Z S O U T X  --  Write x characters to file, unbuffered.  */   int " zsoutx(n,s,x) int n, x; char *s; { #ifdef DEBUG!     if (chkfn(n) < 1) return(-1);  #endif%     return(write(fileno(fp[n]),s,x));  }      ; /*  Z C H O U T  --  Add a character to the given file.  */    int  #ifdef CK_ANSIC  zchout(register int n, char c) #else # zchout(n,c) register int n; char c;  #endif /* CK_ANSIC */  /* zchout */ { #ifdef DEBUG!     if (chkfn(n) < 1) return(-1);  #endif     if (n == ZSFILE) {L     	return(write(fileno(fp[n]),&c,1)); /* Use unbuffered for session log */     } else {B 	if (putc(c,fp[n]) == EOF)	/* If true, maybe there was an error */; 	  return(ferror(fp[n]) ? -1 : 0); /* Check to make sure */  	else				/* Otherwise... */ ) 	  return(0);			/* There was no error. */      }  }   E /*  Z O U T D U M P  --  dump buffered output characters to file.  */   ' /* Buffered file output, buffer dump */    /*L  * No, this isn't an entry in the 199x Obfuscated C programming contest, norL  * did we get it at an all-night convenience store. VMS requires that streamL  * format files be written as records, so we have to do _lots_ of contortion<  * to make sure we write whole lines as records. Not pretty.  */    int  zoutdump() {
     int ocnt;      int wrote_one_line = 0; !     CHAR *optr, *srcptr, *endptr;      char csave;   /     debug(F101," zoutdump zoutcnt","",zoutcnt); 7     debug(F101," zoutdump ofile_bmode","",ofile_bmode);  /*N  * Well, this could be to the console. If it is, chop it into itty-bitty partsL  * (the VMS CRTL can't handle a %s spec bigger than 512 bytes) and print it.  */ 9     if (cflag == 1) {			/* If we're dumping to console */  	endptr = zoutbuffer + zoutcnt; 6 	for (optr = zoutbuffer; optr < endptr; optr += 511) {; 	    if (optr+511 < endptr) {	/* More than 511, break up */  		csave = *(optr+511); 		*(optr+511) = '\0';  		printf("%s", optr);  		*(optr+511) = csave; 	    } 	    else { 2 		*endptr = '\0';		/* Make sure null-terminated */ 		printf("%s", optr);  	    } 	}
 	zoutcnt = 0;  	zoutptr = zoutbuffer; 	return(0);      }    /*4  * Do we need to processed TYPE LABELED contortions?  */   5     if (ofile_bmode == XYFT_L) {	/* Is it labeled? */ A 	if (ofile_lblproc == 0)	{	/* I've never gone this way before? */ F 	    rms_sts = do_label_recv();	/* Beyond revolving rainbow door... */ 	    if (rms_sts == -1) 4 		return(-1);		/* Got a hard error in label proc. */) 	    if (rms_sts == 1 && ofile_dump != 1) 5 		return(0);		/* Exit so we can fill up the buffer */  	}     }  /*  * Well, we could be lucky...   */      if (zoutcnt == 0)  	return(0);  /*0  * Oh well. See if doing binary - that's easy...  */      if (ofile_bmode) { 	if (zoutcnt == OBUFSIZE) {  #ifdef DYNAMIC& 	    rab_ofile.rab$l_rbf = zoutbuffer; #else ' 	    rab_ofile.rab$l_rbf = &zoutbuffer;  #endif /* DYNAMIC */$ 	    rab_ofile.rab$w_rsz = OBUFSIZE;. 	    if (ofile_ffb != -1 && ofile_dump == 1) { 		/*1 		 * Only do this when doing _last_ file segment.  		 */ % 		xabfhc_ofile.xab$w_ffb = ofile_ffb;  		if (ofile_ffb)/ 		    rab_ofile.rab$w_rsz -= (512 - ofile_ffb); 6 		debug(F101," zoutdump ofile_ffb","",(int)ofile_ffb);; 		debug(F101," zoutdump rab$w_rsz","",rab_ofile.rab$w_rsz);  	    }% 	    rms_sts = sys$write(&rab_ofile); " 	    if (rms_sts != RMS$_NORMAL) {; 		debug(F101," zoutdump $write failed, status","",rms_sts); 
 		return(-1);  	    }	 	} else {  #ifdef DYNAMIC& 	    rab_ofile.rab$l_rbf = zoutbuffer; #else ' 	    rab_ofile.rab$l_rbf = &zoutbuffer;  #endif# 	    rab_ofile.rab$w_rsz = zoutcnt; 0 	    xabfhc_ofile.xab$w_ffb = (zoutcnt & 511)+1; 	    if (ofile_ffb != -1) { % 		xabfhc_ofile.xab$w_ffb = ofile_ffb;  		if (ofile_ffb)/ 		    rab_ofile.rab$w_rsz -= (512 - ofile_ffb); 6 		debug(F101," zoutdump ofile_ffb","",(int)ofile_ffb);; 		debug(F101," zoutdump rab$w_rsz","",rab_ofile.rab$w_rsz);  	    }% 	    rms_sts = sys$write(&rab_ofile); " 	    if (rms_sts != RMS$_NORMAL) {; 		debug(F101," zoutdump $write failed, status","",rms_sts); 
 		return(-1);  	    } 	}: 	debug(F100," zoutdump RMS operations completed ok","",0);
 	zoutcnt = 0;  	zoutptr = zoutbuffer; 	return(0);      }    /*J  * Must be ASCII. This is harder, and weirder... It's actually easier thanJ  * it looks, but there's (unfortunately) no really easy way to _implement_  * it. (sigh, whimper, groan)   */   H     srcptr = zoutbuffer;            /* Points to first line in buffer */L     endptr = zoutbuffer + zoutcnt;  /* Points to location after last char */ zoutdump_ascii: G     /* Scan through buffer until we find a CR or we run out of chars */ F     for (optr = srcptr; optr < endptr; optr++) if (*optr == CR) break;  I     /* If there are at least 2 chars left in the buffer when we stop   */ I     /* scanning, then it is assumed the above loop terminated because  */ I     /* it found the CR and that both the CR and LF are present in the  */ I     /* buffer (situation normal.                                       */ I     /* If there are not 2 chars left in the buffer, we have one of two */ I     /* cases which we treat identically:                               */ I     /*  1) If there are 0 chars left in the buffer, then the line's    */ I     /*     terminating CR LF are yet to come. So... we copy the data   */ I     /*     to the front of the buffer and exit (next time it should be */ I     /*     there.)                                                     */ I     /*  2) If there is one char left in the buffer, we have the case of*/ I     /*     a line with the CR but no LF present. So... do the same     */ I     /*     because the LF will be coming next time.                    */ 8     if (optr+2 > endptr) {			/* drat! ran off the end */( 	if (ofile_dump && (srcptr == endptr)) {I         /* If the beginning and end ptrs are the same, then there the  */ I         /* is empty. Good news, 'cause we're clsoing up.               */ 2 	    zoutcnt = 0;        /* No looping, please. */ 	    zoutptr = zoutbuffer; 	}> 	else if (ofile_dump) {		/* but it's cool, we're closing up */I         /* Oops, we've got a line with no LF and maybe no CR. Well     */ I         /* write it out and exit abnormally.                           */ " 	    rab_ofile.rab$l_rbf = srcptr;' 	    rab_ofile.rab$w_rsz = optr-srcptr; # 	    rms_sts = sys$put(&rab_ofile);  	    zoutcnt = 0;  	    zoutptr = zoutbuffer;" 	    if (rms_sts != RMS$_NORMAL) {: 		debug(F101, " zoutdump $put failed, status","",rms_sts);
 		return(-1);  	    }B 	} else if (wrote_one_line) {	/* it's still cool, we did one... */8 	    zoutcnt = optr - srcptr;	/* number of chars left */H 	    if (optr < endptr) zoutcnt++; /*[jah083] including CR if present */4 		if (zoutcnt) memmove(zoutbuffer, srcptr, zoutcnt);( 	        /* Move'em to front of buffer*/" 	    zoutptr = zoutbuffer+zoutcnt; 	} else {			/* WRONG!!! */I         /* We've got a buffer full of chars with no LF (it may or may  */ I         /* not have a terminating CR. In either case its just plain too*/ I         /* long. I suppose we could check here for the optr+1 == endptr*/ I         /* which indicates that there was a CR but no LF so we could   */ I         /* issue a "line barely too long", but, is it useful?          */ 1 	    debug(F100, "zoutdump: line too long","",0); , 	    zoutcnt = 0;		/* No looping, please. */ 	    zoutptr = zoutbuffer; 	    return(-1); 	}6 	debug(F101, " zoutdump exiting, zoutcnt","",zoutcnt); 	return(0);      }   5     /* We now have a line that we can write, so... */   !     rab_ofile.rab$l_rbf = srcptr; &     rab_ofile.rab$w_rsz = optr-srcptr;"     rms_sts = sys$put(&rab_ofile);!     if (rms_sts != RMS$_NORMAL) { 9 	debug(F101, " zoutdump $put failed, status","",rms_sts);  	return(-1);     } - 	srcptr = optr + 2;		/* Account for CR, LF */      wrote_one_line = 1;      goto zoutdump_ascii; }   E /*  C H K F N  --  Internal function to verify file number is ok.  */    /*	  Returns: #   -1: File number n is out of range )    0: n is in range, but file is not open !    1: n in range and file is open  */   int  chkfn(n) int n; {      switch (n) {
 	case ZCTERM: 
 	case ZSTDIO: 
 	case ZIFILE: 
 	case ZOFILE: 
 	case ZDFILE: 
 	case ZTFILE: 
 	case ZPFILE: 
 	case ZSFILE:  		break;& 	case ZSYSFN:			/* System functions */ 		return(0);* 	case ZRFILE:			/* READ and WRITE files */
 	case ZWFILE:          case ZMFILE: 		break;	 	default: 8 	    debug(F101,"chkfn: file number out of range","",n);: 	    fprintf(stderr,"?File number out of range - %d\n",n); 	    return(-1);     } &     return( (fp[n] == NULL) ? 0 : 1 ); }   B /*  Z C H K I  --  Check if input file exists and is readable.  */   /*
   Returns:3    >= 0 if the file can be read (returns the size). 3      -1 if file doesn't exist or can't be accessed, C      -2 if file exists but is not readable (e.g. a directory file). 9      -3 if file exists but protected against read access.  */   long zchki(name) char *name; {      struct stat buf;     int x; long y;     struct FAB fab_chki;     struct XABFHC xabfhc_chki;  J /* This is _really_ bad. But there's a fundamental assumption in the upperI  * levels that one can call zchki() without any context to validate file- K  * names, directory names, etc. which would be painful (to the other imple- K  * mentations) to change. So, if we get an argument which ends in ':', '>', G  * or ']', we'll return an immediate OK with a size of 0. Bad directory L  * names will be caught in zchdir anyway. This has the nice side-effect thatJ  * saying (for example) GET dir-spec will implicitly get all files in that.  * directory. Not bad for a total kludge, huh?  */      x = strlen(name);      if (name[x-1] == ':')  	return(0);      if (name[x-1] == ']')  	return(0);      if (name[x-1] == '>')  	return(0);        fab_chki = cc$rms_fab;#     fab_chki.fab$b_fac = FAB$M_BIO;      fab_chki.fab$l_fna = name;&     fab_chki.fab$b_fns = strlen(name);.     fab_chki.fab$l_xab = (char *)&xabfhc_chki;      xabfhc_chki = cc$rms_xabfhc;"     rms_sts = sys$open(&fab_chki);-     if (rms_sts == RMS$_PRV)			/* No privs */  	return(-3);!     if (rms_sts != RMS$_NORMAL) { 6 	debug(F101," zchki $open failed, status","",rms_sts); 	return(-1);     } B     iflen = ((xabfhc_chki.xab$l_ebk-1)*512)+xabfhc_chki.xab$w_ffb;  #     rms_sts = sys$close(&fab_chki); !     if (rms_sts != RMS$_NORMAL) { 7 	debug(F101," zchki $close failed, status","",rms_sts);  	return(-1);     } -     strcpy(nambuf,name);		/* preserve name */ ?     debug(F111," zchki access ok:",name,(int) iflen); /* Yes */ '     return( (iflen > -1) ? iflen : 0 );  }   ; /*  Z C H K O  --  Check if output file can be created.  */    /*J  Returns -1 if write permission for the file would be denied, 0 otherwise. */ int  zchko(name) char *name; { 2     return(0);				/* Always creates new version */ }   L /*  Z C H K S P A  --  Check if there is enough space to store the file.  */   /*1  Call with file specification f, size n in bytes. ?  Returns -1 on error, 0 if not enough space, 1 if enough space.  */   int  zchkspa(f,n) char *f; long n; {    /*K  * This is complicated. The user could have specified an explicit path when L  * sending the file, or could have done a CWD, or could be using the defaultK  * directory. If not the latter, the path may not even be a disk device, as K  * CWD LPA0: is perfect legal for uploading to the lineprinter. After that, K  * if it's a disk, we should check the user's quota.  However, the user may K  * have SYSPRV, EXQUOTA, BYPASS, or maybe even GRPPRV, and it would be hard K  * to  properly check for all these cases.  So, if the file will fit on the   * disk, we'll accept it.   */        char   *zgtdir();        struct itmlstdef { 	short int buflen; 	short int itmcod; 	char *bufaddr;  	long int *retlen;     };       static char device[64];        struct dsc$descriptor_s : 	dev_desc = {sizeof(device), DSC$K_DTYPE_T, DSC$K_CLASS_S, 		      (char *)&device}; L     unsigned long freeblocks, freelength, devclass, classlength, fileblocks;       struct itmlstdef itmlst[] = 5 	{4,DVI$_FREEBLOCKS,0,0,4,DVI$_DEVCLASS,0,0,0,0,0,0};        int rms_sts;  6 /* First, figure out the device we're interested in */  <     strcpy(device, zgtdir());			/* Handles default or CWD */  7     if (strchr(f, ':'))				/* If user specified path */  	strncpy(device, f, 63);  6     debug(F110," zchkspa target device is ",device,0);  H /* Next, ask for free block count and device type (disk vs. non-disk) */  ,     itmlst[0].bufaddr = (char *)&freeblocks;#     itmlst[0].retlen = &freelength; *     itmlst[1].bufaddr = (char *)&devclass;$     itmlst[1].retlen = &classlength;  9     rms_sts = sys$getdviw(0,0,&dev_desc,&itmlst,0,0,0,0);   ?     debug(F101," zchkspa $getdvi returned rms_sts","",rms_sts);        if (devclass != DC$_DISK) - 	return(1);				/* assume space if not disk */        if (rms_sts != SS$_NORMAL)- 	return(1);				/* assume free space if err */   E     debug(F101," zchkspa $getdvi returned freeblocks","",freeblocks);   ' /* Pad file size if it's a text file */        if (ofile_bmode == XYFT_T) 	n += (n/40) * 3;   ?     fileblocks = n / 512 + 1;			/* compute file size in blks */ ! 						/* we may want some fuzz */ !     if (fileblocks >= freeblocks)  	return(0);				/* Won't fit */     else 	return(1);				/* Will fit */  }   / /*  Z D E L E T  --  Delete the named file.  */    int  zdelet(name) char *name; {     return(delete(name));  }   ? /*  Z R T O L  --  Convert remote filename into local form.  */    VOID' zrtol(name,name2) char *name, *name2; {      int count = 9, vflag = 0;      char *cp, c;+     static char *spcl_set = "_-$[]<>:.\";";   '     for (cp=name2; c = *name; name++) {   	if (islower(c)) c = toupper(c); 	if (!isalnum(c) && " 	    !strchr(spcl_set,c)) c = 'X'; 	*cp++ = c;      } $     *cp = '\0';				/* End of name */#     debug(F110," zrtol: ",name2,0);  }   I /*  Z L T O R  --  Convert filename from local format to common form.  */    VOID' zltor(name,name2) char *name, *name2; {      char *cp, *pp;   /*  * Copy name to output string   */        strcpy(name2,name);    /*@  * Parse the filename and type, with the default filename of "X"  */   8     parse_fname(name2, 100, "X", PARSE_NAME|PARSE_TYPE);#     debug(F110," zltor: ",name2,0);  }   * /*  Z C H D I R  --  Change directory.  */   int  zchdir(dirnam) char *dirnam; {       char   *zgtdir(); "     char   dir_buff[NAM$C_MAXRSS];     int    status;       if (*dirnam == '\0')C         strcpy(dirnam,getenv("HOME"));	/* default to current dir */   >     status = chdir(dirnam);		/* change first in parent proc */     return(status == 0); }   ? /*  Z H O M E  --  Return pointer to user's home directory.  */    char *	 zhome() {      return(getenv("HOME"));  }   D /*  Z G T D I R  --  Return pointer to user's current directory.  */   char *
 zgtdir() { #ifdef VMS_V40 #define	OLD_VMS  #endif #ifdef VMS_V42 #define	OLD_VMS  #endif #ifdef VMS_V44 #define	OLD_VMS  #endif #ifdef VAXC023 #define	OLD_VMS  #endif #ifdef VAXC024 #define	OLD_VMS  #endif   #ifdef OLD_VMS     static char *gtdir_buf = 0; '     static char sysdisk[] = "SYS$DISK"; !     char tmp_buf[NAM$C_MAXRSS+1];      struct dsc$descriptor_s F 	tmp_buf_dsc = {sizeof(tmp_buf),DSC$K_DTYPE_T,DSC$K_CLASS_S,&tmp_buf},H 	sysdisk_dsc = {sizeof(sysdisk)-1,DSC$K_DTYPE_T,DSC$K_CLASS_S,&sysdisk};     unsigned short int buf_len;    /*I  * Allocate buffer dynamically, first time through.  This makes the image   * smaller.   */   7     if (!gtdir_buf) gtdir_buf = malloc(NAM$C_MAXRSS+1);    /*  * Translate device name.   */   !     LIB$SYS_TRNLOG(	&sysdisk_dsc,  			&buf_len, 			&tmp_buf_dsc, 			0,  			0,  			0);     tmp_buf[buf_len] = '\0';     strcpy(gtdir_buf,tmp_buf);   /*  * Get directory name.  */   (     sys$setddir(	0,	  /* New dir addr */ 			&buf_len, /* length addr */ 			&tmp_buf_dsc);      tmp_buf[buf_len] = '\0';     strcat(gtdir_buf,tmp_buf);  F     return(gtdir_buf);  /* Can't seem to make LINK find getcwd()... */ 			/* (wbader: removed &) */ #else      char *getcwd();      char *buf;       buf = cwdbuf;      return(getcwd(buf,100)); #endif }   O /*  Z X C M D  --  Run a system command so its output can be read as a file. */    int 1 zxcmd(filnum, comand) int filnum; char *comand; { *     char mbxnam[21], inpchan[6] = "NLA0:";     unsigned long sts, pid;      int one=1;       struct dsc$descriptor_s 1 	mbx_desc = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0}, 1 	cmd_line = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0}, 1 	inp_desc = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};        struct itmlstdef { 	short int buflen; 	short int itmcod; 	char *bufaddr;  	long int *retlen;     };  !     struct itmlstdef itmlst[] = {  	4, JPI$_PID, (char *)&pid, 0, 	0, 0, 0, 0      };  +     debug(F101,"zxcmd filnum", "", filnum); -     if (filnum != ZIFILE && filnum != ZRFILE)  	return(0);   1     sts = sys$getjpiw(0, 0, 0, &itmlst, 0, 0, 0);   4     debug(F101,"zxcmd sys$getjpiw status", "", sts);     if (sts != SS$_NORMAL) 	return(0);   +     sprintf(mbxnam,"KERMIT$MBX_%08X", pid); 3     debug(F110,"zxcmd mailbox logical", mbxnam, 0);   +     mbx_desc.dsc$w_length = strlen(mbxnam); $     mbx_desc.dsc$a_pointer = mbxnam;  H     sts = sys$crembx(0, &mbx_chan, SUB_BUF_SIZE, 0, 0, 0, &mbx_desc, 0);  3     debug(F101,"zxcmd sys$crembx status", "", sts);      if (sts != SS$_NORMAL) 	return(0);   :     debug(F101,"zxcmd sys$crembx mbx_chan", "", mbx_chan);       strcat(mbxnam, ":");     mbx_desc.dsc$w_length++;  +     cmd_line.dsc$w_length = strlen(comand); $     cmd_line.dsc$a_pointer = comand;  ,     inp_desc.dsc$w_length = strlen(inpchan);%     inp_desc.dsc$a_pointer = inpchan;   G     sts = lib$spawn(&cmd_line, &inp_desc, &mbx_desc, &one, 0, &sub_pid,  		    0, 0, 0, &mbx_chan);  2     debug(F101,"zxcmd lib$spawn status", "", sts);     if (sts != SS$_NORMAL) 	return(0);        subprocess_input = 1;      sub_count = 0;E     fp[filnum] = fopen("NLA0:","r");	/* It wants a fp, give it one */ 3     debug(F101,"zxcmd fp[filnum]", "", fp[filnum]); B     fp[ZSYSFN] = fp[filnum];		/* Set ZSYSFN too, so we remember */     return(1); }   7 /*  Z C L O S F  - close the suprocess output file.  */    int  zclosf(filnum) int filnum; {     unsigned long sts;        if (subprocess_input != 0) { 	sts = sys$delprc(&sub_pid, 0);   1 	debug(F101,"zclosf sys$delprc status", "", sts);    	sts = sys$delmbx(mbx_chan);  1 	debug(F101,"zclosf sys$delmbx status", "", sts);    	sts = sys$dassgn(mbx_chan);  1 	debug(F101,"zclosf sys$dassgn status", "", sts);   0 	sub_ptr = sub_buf;			/* flush remaining data */ 	sub_count = 1;  	*sub_buf = '\0';  	zincnt = 0;  4 	fclose(fp[filnum]);			/* Close the place-holders */  	fp[filnum] = fp[ZSYSFN] = NULL;     } 0     subprocess_input = 0;			/* Say we're done */     return(1); }   K /*  Z X P A N D  --  Expand a wildcard string into an array of strings.  */    /*I   Returns the number of files that match fn1, with data structures set up H   so that first file (if any) will be returned by the next znext() call. */ int  zxpand(fn) char *fn; {2     if (strlen(fn) == 0)		/* Nothing asked for, */*       return(0);			/* nothing returned. */;     fcount = fgen(fn,mtchs,MAXWLD);	/* Look up the file. */      if (fcount > 0) { / 	mtchptr = mtchs;		/* Save pointer for next. */ ' 	debug(F111," zxpand",mtchs[0],fcount);      }      return(fcount);  }   J /*  Z N E X T  --  Get name of next file from list created by zxpand(). */   /*N  Returns >0 if there's another file, with its name copied into the arg string,  or 0 if no more files in list.  */ int  znext(fn) char *fn; {   ,     if (fcount-- > 0) strcpy(fn,*mtchptr++);     else *fn = '\0';%     debug(F111," znext",fn,fcount+1);      return(fcount+1);  }   : /*  Z N E W N  --  Make a new name for the given file.  */   VOID znewn(fn,s) char *fn, **s; {"     static char buf[NAM$C_MAXRSS];  >     strcpy(buf, fn);			/* Version numbers are handled by OS */
     *s = buf;  }    /*  * fgen:>  *  This is the actual name generator.  It is passed a string,F  *  possibly containing wildcards, and an array of character pointers.G  *  It finds all the matching filenames and stores them into the array. D  *  The returned strings are allocated from a static buffer local toG  *  this module (so the caller doesn't have to worry about deallocating A  *  them); this means that successive calls to fgen will wipe out =  *  the results of previous calls.  This isn't a problem here 5  *  because we process one wildcard string at a time.   *<  * Input: a wildcard string, an array to write names to, the  *        length of the array.F  * Returns: the number of matches.  The array is filled with filenamesI  *          that matched the pattern.  If there wasn't enough room in the   *	    array, -1 is returned.   */  int 6 fgen(pat,resarry,len) char *pat,*resarry[]; int len; {     struct dsc$descriptor_s / 	file_spec = {0,DSC$K_DTYPE_T,DSC$K_CLASS_S,0}, , 	result = {0,DSC$K_DTYPE_T,DSC$K_CLASS_D,0},+ 	deflt = {0,DSC$K_DTYPE_T,DSC$K_CLASS_S,0}; &     unsigned long context = 0, status;     int count = 0;     char *def_str = "*.*";  *     file_spec.dsc$w_length  = strlen(pat);"     file_spec.dsc$a_pointer = pat;  ,     deflt.dsc$w_length  = sizeof(def_str)-1;"     deflt.dsc$a_pointer = def_str;       while (count < lenF 	   && (status = LIB$FIND_FILE(&file_spec, &result, &context, &deflt)) 		== RMS$_NORMAL) { 6     	resarry[count] = malloc(result.dsc$w_length + 1);D 	strncpy(resarry[count], result.dsc$a_pointer, result.dsc$w_length);, 	resarry[count][result.dsc$w_length] = '\0';	 	count++;      }  #ifdef DVI$_ALT_HOST_TYPE ;     LIB$FIND_FILE_END(&context);	/* Only on V4 and later */  #endif     LIB$SFREE1_DD(&result); <     if (status == RMS$_FNF) return((count <= len) ? 0 : -1);*     if (status == RMS$_NMF) return(count);N     /* Bernd Onasch says that VMS sometimes returns RMS$_NORMAL here, so... */-     if (status == RMS$_NORMAL) return(count); '     /* Some other status.  Return 0. */ H     /* Improve this later based on results from following debug stmt. */;     debug(F101,"fgen unexpected failure status","",status);      return(0); }   ) /*  Z R E N A M E  --  Rename a file.  */   " /*  Call with old and new names */+ /*  Returns 0 on success, -1 on failure. */  int # zrename(old,new) char *old, *new; {      int sts;       sts = rename(old,new);       return((sts ? -1 : 0));  }   ; /*  Z C F D A T  --  Return a file's modification time.  */    char * zfcdat(name) char *name; { /*L   Returns modification date/time of file whose name is given in the argument=   string.  Return value is a pointer to a string of the form:         yyyymmdd hh:mm:ss   M   for example 19931231 23:59:59, which represents the local time (no timezone M   or daylight savings time finagling required).  Returns an empty string ("") G   on failure.  The text pointed to by the string pointer is in a static J   buffer, and so should be copied to a safe place by the caller before any$   subsequent calls to this function. */   /*J   Contributed by William Bader, 9 Nov 93, based on UNIX version: "It wouldK   probably be possible to get the date by opening the file and requesting a @   NAM block like ckvfio.c does, but stat seems to do the trick." */     struct stat statbuf;     struct tm *tm;     static char datebuf[20];       datebuf[0] = '\0';       if (name &&          *name &&$         stat(name,&statbuf) != -1 &&,         (tm = localtime(&statbuf.st_mtime)))5       sprintf(datebuf, "%04d%02d%02d %02d:%02d:%02d", 8         tm->tm_year + 1900, tm->tm_mon + 1, tm->tm_mday,-         tm->tm_hour, tm->tm_min, tm->tm_sec);        return(datebuf); }      D /*  Z S T I M E  --  Set or compare a file's creation date/time.  */   /*K  * Note: There's an additional value for parameter X on VAX/VMS systems. As K  * it's horribly painful to change a file's creation date after-the-fact we K  * call zstime with an argument  of 2 to pre-set the date when creating the K  * file. An argument of 0 (which the main-line code thinks sets the date of K  * the output file) returns success but does nothing.  Note that an invalid K  * or missing attribute packet will cause $bintim to return an error, which K  * causes the routine to exit. Since we pre-set the binary time to zero, we K  * will create the file "now", or say the incoming file is newer, whichever   * is appropriate.  */  int 2 zstime(f,yy,x) char *f; struct zattr *yy; int x; {     int rms_sts;7     static char mth[13][4] = {	"JAN","FEB","MAR","APR",  				"MAY","JUN","JUL","AUG", 				"SEP","OCT","NOV","DEC", 				""};I     static char cdate[23];	      /* Creation date yyyymmdd hh:mm:ss.00 */      static char mnum[2];     struct dsc$descriptor_s < 	bintim_desc = {sizeof(cdate), DSC$K_DTYPE_T, DSC$K_CLASS_S, 			 (char *)&cdate};-     unsigned long file_date[2], attr_date[2];   @ /* First, make a system quadword date from what we got passed */       char *dptr = yy->date.val;     if (!dptr) return(-1);,     strcpy(cdate,"dd-mmm-yyyy 00:00:00.00");6     attr_date[0]=0;				/* clear time in case of err */     attr_date[1]=0; +     strncpy(cdate+7, dptr, 4);			/* yyyy */      dptr += 4;     strncpy(mnum, dptr, 2); 4     strncpy(cdate+3, mth[atoi(mnum)-1], 3);	/* mm */     dptr += 2;'     strncpy(cdate, dptr, 2);			/* dd */      dptr += 3;.     strncpy(cdate+12, dptr, 8);			/* hhmmss */(     cdate[23] = '\0';				/* terminate */3     rms_sts = sys$bintim(&bintim_desc, &attr_date);       if (rms_sts != SS$_NORMAL) {4 	debug(F101," zstime - $bintim returns","",rms_sts); 	return(-1);     } (     debug(F110," zstime built",cdate,0);;     sprintf(cdate, "%08X%08X", attr_date[1], attr_date[0]); /     debug(F110," $bintim attr_date", cdate, 0);        if (x == 1) {  	fab_ifile = cc$rms_fab;- 	fab_ifile.fab$b_fac = FAB$M_BIO | FAB$M_GET;  	fab_ifile.fab$l_fna = f; ! 	fab_ifile.fab$b_fns = strlen(f); - 	fab_ifile.fab$l_xab = (char *)&xabdat_ifile;  	rab_ifile = cc$rms_rab;" 	rab_ifile.rab$l_fab = &fab_ifile; 	xabdat_ifile = cc$rms_xabdat;  	rms_sts = sys$open(&fab_ifile); 	if (rms_sts != RMS$_NORMAL) {; 	    debug(F101," zstime $open failed, status","",rms_sts);  	    return(-1); 	}/ 	memcpy(file_date, &xabdat_ifile.xab$q_cdt, 8); 8 	sprintf(cdate, "%08x%08x", file_date[1], file_date[0]);, 	debug(F110," $bintim file_date", cdate, 0);! 	rms_sts = sys$close(&fab_ifile);  	if (rms_sts != RMS$_NORMAL) {< 	    debug(F101," zstime $close failed, status","",rms_sts); 	    return(-1); 	}# 	if (attr_date[1] < file_date[1]) { 7 	    debug(F100," zstime incoming file is older","",0);  	    return(1);  	}$ 	if (attr_date[1] == file_date[1]) {( 	    if (attr_date[0] <= file_date[0]) {A 		debug(F100," zstime incoming file is older, not by much","",0);  		return(1); 	    }3 	debug(F100," zstime incoming file is newer","",0);  	return(0);  	}     }        if (x == 0) { . 	return(0);			/* say we did it (see header) */     }        if (x == 2) { / 	memcpy(&xabdat_ofile.xab$q_cdt, attr_date, 8); + 	return(0);			/* Set date in output file */      }        return(-1);  }   6 /*  Z K E R M I N I  --  Find initialization file.  */ /*5   Places name of init file in buffer pointed to by s. D   If no init file found, the device name of the null device is used.   returns 0 always.  */ int 8 zkermini(s, s_len, def) char *s; int s_len; char *def; {     FILE fd;     struct dsc$descriptor_s - 		dsc_in = {0,DSC$K_DTYPE_T,DSC$K_CLASS_S,0}, . 		dsc_out = {0,DSC$K_DTYPE_T,DSC$K_CLASS_D,0},. 		dsc_def = {0,DSC$K_DTYPE_T,DSC$K_CLASS_S,0};     int max_len;     long unsigned int rms_s;(     unsigned long find_file_context = 0;       struct TRNLIST {/ 	char *name;			/* ASCII file or logical name */ 8 	unsigned char flag;		/* Zero to use default filename */	     } *p;   %     static struct TRNLIST slist[] = { 2 	{"", 0},			/* Dummy first entry points to file */= 	{"ckermit_ini:", 0},		/* CKERMIT_INI: points to directory */ = 	{"ckermit_init", 1},		/* CKERMIT_INIT points to file      */ = 	{"sys$login:",   0},		/* CKERMIT.INI in login directory   */  	{"", 0}     };%     p = slist;				/* Point to list */ 5     if (rcflag) {			/* Name given on command line? */ ; 	slist[0].name = def;		/* Yes, stuff its name into slist */  	slist[1].name = "";     } else {				/* No, */ & 	*p++;				/* skip past dummy entry. */     } =     while(*(p->name)) {			/* Search the list top to bottom */   A 	dsc_in.dsc$w_length = strlen(p->name); /* Length of work area */ 8 	dsc_in.dsc$a_pointer = p->name; /* Address of string */   	if (!(p->flag)) {B 	    dsc_def.dsc$w_length = strlen(def); /* Length of work area */9 	    dsc_def.dsc$a_pointer = def; /* Address of string */ 	 	} else { 8 	    dsc_def.dsc$w_length = 0;	/* Length of work area */7 	    dsc_def.dsc$a_pointer = 0;	/* Address of string */  	} 	rms_s = LIB$FIND_FILE(  				&dsc_in,	/* File spec */$ 				&dsc_out,	/* Result file spec */% 				&find_file_context, /* Context */ % 				&dsc_def,	/* Default file spec */  				0,		/* Related spec */ 				0,		/* STV error */  				0);		/* Flags */   	if (rms_s == RMS$_NORMAL) {C 	    max_len = ((unsigned short int) dsc_out.dsc$w_length < s_len ? 8 		       (unsigned short int) dsc_out.dsc$w_length : 0); 	    if (!max_len) 	      fprintf(stderr,A 		"%%ZKERMINI out string not long enough, ignoring .ini file\n"); 	 	    else 0 	      strncpy(s,dsc_out.dsc$a_pointer,max_len);+ 	    LIB$FIND_FILE_END(&find_file_context); 6 	    LIB$SFREE1_DD(&dsc_out);	/* Return dyno memory */ 	    return(0);  	} 	p++; ' 	LIB$FIND_FILE_END(&find_file_context);      }  /*M  * No initialization file found.  We can't return the null string because the K  * runtime library will successfully open it if the file ".;" exists in the D  * user's directory.  Instead we return the name of the null device.  */ 6     strcpy(s, "NLA0:");				/* Return null init file */     LIB$SFREE1_DD(&dsc_out);     return(0); }   
 static int% parse_fname(cp, cp_len, defnam, flag) . char *cp;		/* Pointer to file spec to parse */% int cp_len;		/* Length of cp field */ & char *defnam;		/* Default file spec */$ int flag;		/* Flag word PARSE_xxx */ {      struct FAB fab;      struct NAM nam; %     char expanded_name[NAM$C_MAXRSS];      int long rms_status;     int cur_len = 0;       fab = cc$rms_fab;      fab.fab$l_nam = &nam;      fab.fab$l_fna = cp;      fab.fab$b_fns = strlen(cp);      if (defnam) {   	fab.fab$b_dns = strlen(defnam); 	fab.fab$l_dna = defnam;
     } else 	fab.fab$l_dna = 0;        nam = cc$rms_nam; +     nam.nam$l_esa = (char *)&expanded_name; *     nam.nam$b_ess = sizeof(expanded_name);  )     if (!CHECK_ERR("%%CKERMIT-W-PARSE, ",  		sys$parse(&fab)))  	return(-1);  1     *cp = '\0';			/* Make a zero length string */ 0     if ((PARSE_NODE & flag) && nam.nam$b_node &&$ 		cur_len+nam.nam$b_node < cp_len) { 	cur_len += nam.nam$b_node; 2 	strncat(cp, nam.nam$l_node, (int)nam.nam$b_node);     } 1     if ((PARSE_DEVICE & flag) && nam.nam$b_dev && # 		cur_len+nam.nam$b_dev < cp_len) {  	cur_len += nam.nam$b_dev;0 	strncat(cp, nam.nam$l_dev, (int)nam.nam$b_dev);     } 4     if ((PARSE_DIRECTORY & flag) && nam.nam$b_dir &&# 		cur_len+nam.nam$b_dir < cp_len) {  	cur_len += nam.nam$b_dir;0 	strncat(cp, nam.nam$l_dir, (int)nam.nam$b_dir);     } 0     if ((PARSE_NAME & flag) && nam.nam$b_name &&$ 		cur_len+nam.nam$b_name < cp_len) { 	cur_len += nam.nam$b_name; 2 	strncat(cp, nam.nam$l_name, (int)nam.nam$b_name);     } 0     if ((PARSE_TYPE & flag) && nam.nam$b_type &&$ 		cur_len+nam.nam$b_type < cp_len) { 	cur_len += nam.nam$b_type; 2 	strncat(cp, nam.nam$l_type, (int)nam.nam$b_type);     } 2     if ((PARSE_VERSION & flag) && nam.nam$b_ver &&# 		cur_len+nam.nam$b_ver < cp_len) {  	cur_len += nam.nam$b_ver;0 	strncat(cp, nam.nam$l_ver, (int)nam.nam$b_ver);     }      return(cur_len); }   O /*  Z S A T T R  --  Fill in a Kermit attribute structure for current file.  */    /*M  Fills in a Kermit file attribute structure for the file which is to be sent. E  Returns 0 on success with the structure filled in, or -1 on failure. 9  If any string member is null, then it should be ignored. 8  If any numeric member is -1, then it should be ignored. */ int  zsattr(xx) struct zattr *xx; {     long k; 
     int x;7     static char mth[13][4] = {	"JAN","FEB","MAR","APR",  				"MAY","JUN","JUL","AUG", 				"SEP","OCT","NOV","DEC", 				""};2     static char recfm[15];	    /* record format */M     static char cdate[20];          /* Creation date [yy]yymmdd[hh:mm[:ss]]*/ ;     static char creater_id[31];	    /* Creator ID string */ <     static unsigned char genprot;   /* Generic protection */:     static unsigned short lclprot;  /* Local protection */K     static long sysparam_size=0;    /* Length of system paramater buffer */ L     static char *sysparam_adr=0;    /* Address of system paramater buffer */$     char type;			    /* File type */     short int asctim_retlen;;     char asctim_buf[24];	    /* Work buffer for ASCTIM() */      struct dsc$descriptor_s B      asctim_dsc = {sizeof(asctim_buf),DSC$K_DTYPE_T,DSC$K_CLASS_S, 		     (char *)&asctim_buf}; /*  static long int i;  */!     static unsigned short id_len; +     static struct dsc$descriptor_s id_str = 2       {31,DSC$K_DTYPE_T,DSC$K_CLASS_S,creater_id};   /*  * Zero out strings   */   
     type = 0;      recfm[0] = '\0';     cdate[0] = '\0';     creater_id[0] = '\0';      id_len = 0; 4     genprot = 0;			/* Blank protection by default */     lclprot = 0;   /*D  * See if we are sending "attributes" from a REMOTE command response  */        if (*nambuf == '\0') {7 	xx->lengthk = 1;		/* Number of 1K blocks rounded up */ ; 	xx->type.len = 0;		/* File type can't be filled in here */  	xx->type.val = ""; 7 	xx->date.len = strlen(cdate);	/* File creation date */  	xx->date.val = (char *)&cdate; 9 	xx->creator.len = strlen(creater_id); /* File creator */ ' 	xx->creator.val = (char *)&creater_id; ) 	xx->account.len = 0;		/* File account */  	xx->account.val = "";# 	xx->area.len = 0;		/* File area */  	xx->area.val = ""; + 	xx->password.len = 0;		/* Area password */  	xx->password.val = ""; ) 	xx->blksize = -1L;		/* File blocksize */ ' 	xx->access.len = 0;		/* File access */  	xx->access.val = ""; - 	xx->encoding.len = 1;		/* Transfer syntax */ % 	xx->encoding.val = "A";		/* ASCII */ 2 	xx->disp.len = 0;		/* Disposition upon arrival */ 	xx->disp.val = ""; ; 	xx->lprotect.len = sizeof(lclprot); /* Local protection */ % 	xx->lprotect.val = (char *)&lclprot; = 	xx->gprotect.len = sizeof(genprot); /* Generic protection */  	xx->gprotect.val = &genprot; 3 	xx->systemid.len = 2;		/* System ID for DEC/VMS */  	xx->systemid.val = "D7"; 3 	xx->recfm.len = strlen(recfm);	/* Record format */   	xx->recfm.val = (char *)&recfm;D 	xx->sysparam.len = sysparam_size; /* System-dependent parameters */! 	xx->sysparam.val = sysparam_adr;  	xx->length = 1;			/* Length */ / 	return(0);			/* mumble sweet nothings at it */      }    /*  * Load the generic protection  */   E     x = xabpro_ifile.xab$w_pro >> XAB$V_WLD;	/* grab returned info */ @     if (!(x & XAB$M_NOREAD))  genprot |= 1+32;	/* Read access */G     if (!(x & XAB$M_NOWRITE)) genprot |= 2+8;	/* Write+Append access */ D     if (!(x & XAB$M_NOEXE))   genprot |= 4;	/* Execute protection */@     if (!(x & XAB$M_NODEL))   genprot |= 16;	/* Delete Access */=     lclprot = xabpro_ifile.xab$w_pro;		/* local protection */    /*F  * Convert creation date from an internal value to common ascii string  */   E     sys$asctim(&asctim_retlen,&asctim_dsc,&xabdat_ifile.xab$q_cdt,0); %     asctim_buf[asctim_retlen] = '\0'; 2     debug(F110," zsattr asctim_buf",asctim_buf,0);F     for (x = 0; strncmp(mth[x], asctim_buf+3,3); x++) /* Find month */       ; /     strncpy(cdate,asctim_buf+7,4);	/* 'yyyy' */ +     sprintf(cdate+4,"%02d",x+1);	/* 'mm' */ /     strncpy(cdate+6,asctim_buf+0,2);	/* 'dd' */ 7     strncpy(cdate+8,asctim_buf+11,9);	/* ' hh:mm:ss' */      if (cdate[6] == ' ') 	cdate[6] = '0';(     debug(F110," zsattr cdate",cdate,0);   /*+  * Convert the owner UIC into an alpha name   */        creater_id[0] = '\0'; H     rms_sts = sys$idtoasc(xabpro_ifile.xab$l_uic,&id_len,&id_str,0,0,0);?     creater_id[id_len] = '\0';			/* terminating null, please */ G     debug(F111," zsattr $idtoasc owner",creater_id,strlen(creater_id)); "     if (rms_sts == SS$_NOSUCHID ||1 #ifdef SS$_NORIGHTSDB	/* only vms 5 and higher */  	rms_sts == SS$_NORIGHTSDB ||  #endif /* SS$_NORIGHTSDB */  	rms_sts == SS$_IVIDENT) { 	creater_id[0] = '\0';6 	rms_sts = SS$_NORMAL;			/* if unknown, null it out */     }      if (!(rms_sts & 1)) { : 	debug(F101," zsattr $idtoasc failed, status","",rms_sts); 	return(-1);				/* fatal */      }    /*&  * Fill in the record format blockette  */   C     if (fab_ifile.fab$b_rat & (FAB$M_CR | FAB$M_FTN | FAB$M_PRN)) {  	strcpy(recfm,"AMJ");      } else { 	strcpy(recfm,"F"); 0 	sprintf(recfm+1,"%05d",xabfhc_ifile.xab$w_lrl);     } 4     debug(F111," zsattr recfm",recfm,strlen(recfm));   /*&  * Fill in the returned data structure  */   F     xx->lengthk = (iflen/1024)+1;	/* Number of 1K blocks rounded up */?     xx->type.len = 0;			/* File type can't be filled in here */      xx->type.val = "";:     xx->date.len = strlen(cdate);	/* File creation date */"     xx->date.val = (char *)&cdate;<     xx->creator.len = strlen(creater_id); /* File creator */*     xx->creator.val = (char *)&creater_id;,     xx->account.len = 0;		/* File account */     xx->account.val = ""; '     xx->area.len = 0;			/* File area */      xx->area.val = "";.     xx->password.len = 0;		/* Area password */     xx->password.val = "";-     xx->blksize = -1L;			/* File blocksize */ +     xx->access.len = 0;			/* File access */      xx->access.val = "";0     xx->encoding.len = 1;		/* Transfer syntax */(     xx->encoding.val = "A";		/* ASCII */6     xx->disp.len = 0;			/* Disposition upon arrival */     xx->disp.val = "";>     xx->lprotect.len = sizeof(lclprot); /* Local protection */(     xx->lprotect.val = (char *)&lclprot;@     xx->gprotect.len = sizeof(genprot);	/* Generic protection */      xx->gprotect.val = &genprot;6     xx->systemid.len = 2;		/* System ID for DEC/VMS */     xx->systemid.val = "D7";6     xx->recfm.len = strlen(recfm);	/* Record format */#     xx->recfm.val = (char *)&recfm; G     xx->sysparam.len = sysparam_size;	/* System-dependent parameters */ $     xx->sysparam.val = sysparam_adr;&     xx->length = iflen;			/* Length */1     debug(F111," zsattr lengthk","",xx->lengthk); /     debug(F111," zsattr length","",xx->length);      return(0); }   7 /* Z M K D I R  --  Create directory(s) if necessary */  /*
    Call with: C      A pointer to a file specification that might contain directory ;      information.  The filename is expected to be included. I      If the file specification does not include any directory separators, +      then it is assumed to be a plain file. G      If one or more directories are included in the file specification, C      this routine tries to create them if they don't already exist.     Returns: H      0 on success, i.e. the directory was created, or didn't need to be.)     -1 on failure to create the directory (    VMS version by Mark Berryman, Feb 94. */   int  zmkdir(path) char *path; {     unsigned int
       status,  /*    SYS$PARSE(), */        LIB$CREATE_DIR(),        LIB$LOCC();        struct FAB dir_fab;      struct NAM dir_nam; .     struct dsc$descriptor_s expanded_filename;#     $DESCRIPTOR(close_bracket,"]");   %     char expanded_name[NAM$C_MAXRSS];        dir_fab = cc$rms_fab;      dir_fab.fab$l_fna = path; %     dir_fab.fab$b_fns = strlen(path); !     dir_fab.fab$l_nam = &dir_nam;        dir_nam = cc$rms_nam; 0     dir_nam.nam$l_esa = (char *) &expanded_name;.     dir_nam.nam$b_ess = sizeof(expanded_name);  %     status = sys$parse(&dir_fab,0,0);   D /*  If the result of SYS$PARSE is RMS$_NORMAL we need do nothing. */      if (status == RMS$_NORMAL) {1 	debug(F100,"zmkdir path already exists",path,0); 
 	return 0;     } ,     debug(F111,"zmkdir status",path,status);.     debug(F101,"zmkdir RMS$_DNF","",RMS$_DNF);  B /*  If the result is anything other than RMS$_DNF, it is fatal. */     if (status != RMS$_DNF)  	return -1;   M /*  The parse succeeded but said the directory didn't exist, so create it. */ 2     expanded_filename.dsc$b_class = DSC$K_CLASS_S;2     expanded_filename.dsc$b_dtype = DSC$K_DTYPE_T;>     expanded_filename.dsc$a_pointer = (char *) &expanded_name;7     expanded_filename.dsc$w_length = dir_nam.nam$b_esl;   M /*  Strip the resulting specification to include only device and directory */ 9     status = LIB$LOCC(&close_bracket,&expanded_filename); ,     expanded_filename.dsc$w_length = status;  <     debug(F110,"zmkdir creating",(char *) &expanded_name,0);:     status = LIB$CREATE_DIR(&expanded_filename,0,0,0,0,0);0     debug(F101,"zmkdir final status","",status);,     return (status == SS$_CREATED ? 0 : -1); }   8 /*  Z M A I L  --  Send file f as mail to address p.  */ /*   Returns 0 on success5    2 if mail delivered but temp file can't be deleted    -2 if mail can't be delivered  */ int  zmail(p,f) char *p; char *f; {     char *zmbuf;C     static char spbuf[] = "$ mail %s %s/subj=\"Enclosed file %s\""; !     static char spbuf2[] = "%s;";      unsigned long int sts;  :     zmbuf = malloc(strlen(p)+(2*strlen(f))+sizeof(spbuf));"     sprintf(zmbuf,spbuf, f, p, f);     sts = system(zmbuf);;     debug(F111," zmail: system returns status ",zmbuf,sts);      free(zmbuf);     if ((sts&1) != 1) { ,       debug(F101," zmail: returning","",-2);       return(-2);      } -     zmbuf = malloc(strlen(f)+sizeof(spbuf2));      sprintf(zmbuf,spbuf2, f);      sts = delete(zmbuf);;     debug(F111," zmail: delete returns status ",zmbuf,sts);      free(zmbuf);     if (sts) sts = 2; +     debug(F101," zmail: returning","",sts);      return(sts); }   4 /* Z P R I N T  --  Print file f with options p.  */ /*&   Returns 0 on success, -3 on failure. */ int  zprint(p,f) char *p; char *f; {      char *zmbuf;1     static char spbuf[] = "$ print/delete %s %s";      unsigned long int sts;  6     zmbuf = malloc(strlen(p)+strlen(f)+sizeof(spbuf));     sprintf(zmbuf,spbuf, p, f);      sts = system(zmbuf);<     debug(F111," zprint: system returns status ",zmbuf,sts);     free(zmbuf);9     debug(F101," zprint: returning","",(sts&1) ? 0 : -3);      return((sts&1) ? 0 : -3);  }   C /* Z S Y S C M D  --  Execute a DCL command with direct output.  */    /*L  * Since it's really difficult to have an alternate CLI under VMS (since theK  * MCR interface isn't documented and POSIX hasn't published the interface, C  * we'll just assume everybody uses DCL and hand it of to zshcmd().   */  int  zsyscmd(s) char *s; {      return(zshcmd(s)); }   I /* Z S H C M D  --  Execute a default CLI command with direct output.  */    /*K  * As it's _REALLY_ unlikely that the user is using MCR as his default CLI, K  * and DEC doesn't document how to write any other alternate CLIs, use DCL.   */   A #ifndef	SS$_EXPRCLM		/* VMS doesn't return this yet, but let's */ E #define SS$_EXPRCLM 10804	/* be forward-thinking and anticpate VMS */ : #endif /* SS$_EXPRCLM */	/* V6.0, which will return it. */ int  zshcmd(s) char *s; {     unsigned long sts, cc;     int (*cct)();      struct dsc$descriptor_s 1 	cmd_line = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};        if (check_spawn() != 0) { > 	debug(F100," zshcmd: spawning prohibited by UAF flags","",0); 	return(0);      } E     cct = signal(SIGINT,SIG_DFL);	/* Let inferior process catch ^C */   &     cmd_line.dsc$w_length = strlen(s);     cmd_line.dsc$a_pointer = s;        if (!(*s))6 	printf("Type LOGOUT to return to VMS C-Kermit.\n\n");B     sts = lib$spawn(&cmd_line, 0, 0, 0, 0, 0, &cc, 0, 0, 0, 0, 0);     signal(SIGINT,cct);  /*L  * Note: We can't check for this beforehand as doing a getjpi for prclm willH  *	 only return the UAF value, not the available value. So we try it and)  *	 print this message if it didn't work.   */   7     if ((sts == SS$_EXQUOTA) || (sts == SS$_EXPRCLM)) {  	printf(G "Your account does not have sufficient quotas to use this command.\n");  	printf(F "Please ask your system manager to increase your UAF PRCLM quota.\n");     } 0     debug(F101,"zshcmd LIB$SPAWN sts", "", sts);/     debug(F101,"zshcmd LIB$SPAWN cc ", "", cc);      if (sts == SS$_NORMAL)5       return(cc == SS$_NORMAL ? 1 : 0);	/* Success */      else        return(0);			/* Failure */ }   O /*  Z S T R I P  --  Strip device & directory name from file specification.  */   M /*  Strip pathname from filename "name", return pointer to result in name2 */   ? static char work[257];	/* buffer for use by zstrip and zltor */    VOID) zstrip(name,name2) char *name, **name2; {      char *cp, *pp;(     debug(F110," zstrip before",name,0);     pp = work;  ? /*  NODE::DEV:[DIR] terminates on on final ':', '>' or ']'.  */   (     for (cp = name; *cp != '\0'; cp++) {K     	if (*cp == '/' || *cp == ':' || *cp == '>' || *cp == ']') /* slash? */ 
 	  pp = work; 4 	else if (*cp == ';')		/* Chop off version number */	 	  break;  	else				/* Part of filename */  	  *pp++ = *cp;      } -     *pp = '\0';				/* Terminate the string */      *name2 = work;)     debug(F110," zstrip after",*name2,0);  }    int  zchkpath(s) char *s; { /*<   This needs to be replaced with something more intelligent.I   The idea is to see if the file, whose specification is pointed to by s, F   is in the current directory.  This function should return 0 if it s,C   nonzero otherwise.  Presently we rely on being called with a full G   filespec of the form DISK:[DEV]NAME.TYP;V, so this works more or less G   by accident.  What we really need is to call some kind of VMS service F   to get the NODE::DEV:[DIR] of the file, and compare with the current   NODE::DEV:[DIR]. */     char *p;*     p = zgtdir();			/* Get current dir. */$     debug(F110,"zchkpath file",s,0);+     debug(F110,"zchkpath current dir",p,0); 5     return(strncmp(p,s,strlen(p)));	/* Compare it. */  }    #ifdef OLD_VMS static VOID @ descname(desc,name) struct dsc$descriptor_s *desc; char *name; {;     desc->dsc$w_length = strlen(name);	/* Length of name */ .     desc->dsc$a_pointer = name;		/* Address */D     desc->dsc$b_class = DSC$K_CLASS_S;	/* String descriptor class */C     desc->dsc$b_dtype = DSC$K_DTYPE_T;	/* ASCII string data type */  }    /* VMS version of RENAME */  int /* ? */ 5 rename(oldname, newname) char oldname[], newname[]; { /     struct dsc$descriptor_s old_desc, new_desc;      int lib$rename_file();  "     /* Build string descriptors */  !     descname(&old_desc, oldname); !     descname(&new_desc, newname);   &     /* Call lib$rename_file routine */  G     return(lib$rename_file(&old_desc, &new_desc, 0,0,0,0,0,0,0,0,0,0));  }  #endif /* OLD_VMS */   /*(  * Check to see if we have spawn priv's.  */  int  check_spawn() {      struct itmlstdef { 	short int buflen; 	short int itmcod; 	char *bufaddr;  	long int *retlen;     };       struct itmlstdef itmlst[] =   	{4,JPI$_UAF_FLAGS,0,0,0,0,0,0};  ,     unsigned long uaf_flags, uaf_flags_size;  +     itmlst[0].bufaddr = (char *)&uaf_flags; '     itmlst[0].retlen = &uaf_flags_size;   L     if ((vms_status = sys$getjpiw(0, 0, 0, &itmlst, 0, 0, 0)) != SS$_NORMAL)) 	return(-1);				/* Assume the worst... */   $     if (uaf_flags & UAI$M_CAPTIVE) {K 	printf("\nThis command cannot be executed. Your account is CAPTIVE.\n\n");  	return(-1);     } 4 #ifdef	UAI$M_RESTRICTED			/* for pre-V5.2 systems */'     if (uaf_flags & UAI$M_RESTRICTED) { K 	printf("\nThis command cannot be executed. Your account is CAPTIVE.\n\n");  	return(-1);     }  #endif	/* uai$v_restricted */      return(0); }    /*0  * Stuff having to do with SET FILE TYPE LABELED  */  char * get_vms_vers() {     static char sysver[9];     int len;     struct itmlst {  		  short int buflen;  		  short int code;  		  char *bufadr;  		  int *retlen; 		  } vms_sysver[2];       vms_sysver[0].buflen = 8; &     vms_sysver[0].code = SYI$_VERSION;+     vms_sysver[0].bufadr = (char *)&sysver;       vms_sysver[0].retlen = &len;     vms_sysver[1].buflen = 0;      vms_sysver[1].code = 0; )     sys$getsyiw(0,0,0,&vms_sysver,0,0,0);      sysver[8]='\0';      len = 7;      while (sysver[len] == ' ') { 	sysver[len] = '\0'; 	len--;      }      return(sysver);  }    int ! do_label_send(name) char *name; {      int pad_size;   ?     zinptr += sprintf(zinptr,"KERMIT LABELED FILE:02D704VERS"); O     zinptr += sprintf(zinptr,"%08d%s", strlen(get_vms_vers()), get_vms_vers()); =     zinptr += sprintf(zinptr,"05KVERS00000008%08ld", vernum); <     zinptr += sprintf(zinptr,"07VMSNAME%08d", strlen(name));)     zinptr += sprintf(zinptr,"%s", name); 2     zinptr += sprintf(zinptr,"07VMSFILE%08d", 70);0     memmove(zinptr, &xabpro_ifile.xab$w_pro, 2);     zinptr += 2;0     memmove(zinptr, &xabpro_ifile.xab$l_uic, 4);     zinptr += 4;-     memmove(zinptr, &fab_ifile.fab$b_rfm, 1);      zinptr += 1;-     memmove(zinptr, &fab_ifile.fab$b_org, 1);      zinptr += 1;-     memmove(zinptr, &fab_ifile.fab$b_rat, 1);      zinptr += 1;=     memmove(zinptr, &uchar, 4);			/* Dummy for file chars. */      zinptr += 4;-     memmove(zinptr, &fab_ifile.fab$b_fsz, 1);      zinptr += 1;0     memmove(zinptr, &xabfhc_ifile.xab$w_lrl, 2);     zinptr += 2;-     memmove(zinptr, &fab_ifile.fab$w_mrs, 2);      zinptr += 2;0     memmove(zinptr, &xabfhc_ifile.xab$l_ebk, 4);     zinptr += 4;0     memmove(zinptr, &xabfhc_ifile.xab$w_ffb, 2);     zinptr += 2;0     memmove(zinptr, &xabfhc_ifile.xab$l_hbk, 4);     zinptr += 4;-     memmove(zinptr, &fab_ifile.fab$w_deq, 2);      zinptr += 2;-     memmove(zinptr, &fab_ifile.fab$b_bks, 1);      zinptr += 1;-     memmove(zinptr, &fab_ifile.fab$w_gbc, 2);      zinptr += 2;5     memmove(zinptr, &xabfhc_ifile.xab$w_verlimit, 2);      zinptr += 2;K     memmove(zinptr, &fab_ifile.fab$b_rfm+1, 1);	/* This is fab$b_journal */      zinptr += 1;0     memmove(zinptr, &xabdat_ifile.xab$q_cdt, 8);     zinptr += 8;0     memmove(zinptr, &xabdat_ifile.xab$q_rdt, 8);     zinptr += 8;0     memmove(zinptr, &xabdat_ifile.xab$w_rvn, 2);     zinptr += 2;0     memmove(zinptr, &xabdat_ifile.xab$q_edt, 8);     zinptr += 8;0     memmove(zinptr, &xabdat_ifile.xab$q_bdt, 8);     zinptr += 8;)     if (xabpro_ifile.xab$w_acllen != 0) { E 	zinptr += sprintf(zinptr,"06VMSACL%08d", xabpro_ifile.xab$w_acllen); 5 	memmove(zinptr, &aclbuf, xabpro_ifile.xab$w_acllen); % 	zinptr += xabpro_ifile.xab$w_acllen;      } /     zinptr += sprintf(zinptr,"04DATA00000000"); <     zincnt = (zinptr - zinbuffer);		/* Size of this beast */:     zinptr = zinbuffer;				/* Reset pointer for readout */     return(1); }    /*L  * Note that we don't honor SET FILE COLLISION APPEND for labeled receives -J  * the whole point of labeled receives is to generate an exact copy of the#  * source file, attributes and all.   */  int  do_label_recv() {      char *recv_ptr;      char buffer[16];     char vmsfile[70];      char *filptr = vmsfile;      int lblen, alen;-     int gotname = 0, gotfile = 0, gotacl = 0;      char *i, *j;     unsigned short jnlflg;  >     debug(F101," in do_label_recv, options","",ofile_lblopts);5     ofile_lblproc = 1;				/* Don't come here again */   E     if (strncmp(zoutbuffer,"KERMIT LABELED FILE:02D704VERS",30) != 0) . 	return(0);			/* Just continue if unlabeled */  =     recv_ptr = zoutbuffer+30;		/* start at front of buffer */         memcpy(buffer, recv_ptr, 8);     recv_ptr += 8;     buffer[8] = '\0';      lblen = atoi(buffer);   $     memcpy(buffer, recv_ptr, lblen);     recv_ptr += lblen;     buffer[lblen] = '\0'; :     debug(F110,"  file created under VAX/VMS: ",buffer,0);        memcpy(buffer, recv_ptr, 7);     recv_ptr += 7;-     if (strncmp(buffer, "05KVERS", 7) != 0) { ) 	debug(F100,"  lost sync at KVERS","",0);  	return(-1);     }         memcpy(buffer, recv_ptr, 8);     recv_ptr += 8;     buffer[8] = '\0';      lblen = atoi(buffer);   $     memcpy(buffer, recv_ptr, lblen);     recv_ptr += lblen;     buffer[lblen] = '\0'; >     debug(F110,"  file created with C-Kermit/VMS: ",buffer,0);       next_label:       memcpy(buffer, recv_ptr, 2);     recv_ptr += 2;     buffer[2] = '\0';      lblen = atoi(buffer);      if (lblen == 0) { 0 	debug(F100,"  lost sync at next_label: ","",0); 	return(-1);     }   $     memcpy(buffer, recv_ptr, lblen);     recv_ptr += lblen;     buffer[lblen] = '\0'; )     debug(F110,"  found tag: ",buffer,0); )     if (strcmp(buffer, "VMSNAME") == 0) {  	memcpy(buffer, recv_ptr, 8);          recv_ptr += 8; 	buffer[8] = '\0'; 	lblen = atoi(buffer);( 	memcpy(ofile_vmsname, recv_ptr, lblen);         recv_ptr += lblen; 	ofile_vmsname[lblen] = '\0';  	gotname++; = 	debug(F110,"  loaded file name block as: ",ofile_vmsname,0); ! 	i = strstr(ofile_vmsname, "::");  	if (i != NULL) {  	    i += 2;6 	    memmove(ofile_vmsname, i, strlen(ofile_vmsname)); 	}-         if ((ofile_lblopts & LBL_PTH) == 0) { % 	    i = strrchr(ofile_vmsname, ':'); % 	    j = strrchr(ofile_vmsname, ']');  	    if (j == NULL) " 		j = strrchr(ofile_vmsname, '>'); 	    if (j > i)  		i = j;	 	    i++; 6 	    memmove(ofile_vmsname, i, strlen(ofile_vmsname)); 	}* 	if (strchr(ofile_vmsname, ';') != NULL) {' 	    for (alen = strlen(ofile_vmsname);  		 ofile_vmsname[alen] != ';';
 		 alen--) 	    ;  	    ofile_vmsname[alen] = '\0'; 	}6 	debug(F110,"  resultant filespec: ",ofile_vmsname,0); 	goto next_label;      } .     else if (strcmp(buffer, "VMSFILE") == 0) { 	memcpy(buffer, recv_ptr, 8);  	recv_ptr += 8;  	buffer[8] = '\0'; 	lblen = atoi(buffer);" 	memcpy(vmsfile, recv_ptr, lblen); 	recv_ptr += lblen;  	vmsfile[lblen] = '\0';  	gotfile++; 2 	debug(F100,"  loaded file attribute block","",0); 	goto next_label;      } -     else if (strcmp(buffer, "VMSACL") == 0) {  	memcpy(buffer, recv_ptr, 8);  	recv_ptr += 8;  	buffer[8] = '\0'; 	ofile_acllen = atoi(buffer); . 	memcpy(ofile_vmsacl, recv_ptr, ofile_acllen); 	recv_ptr += ofile_acllen;# 	ofile_vmsacl[ofile_acllen] = '\0'; 
 	gotacl++;, 	debug(F100,"  loaded file ACL block","",0); 	goto next_label;      } +     else if (strcmp(buffer, "DATA") == 0) {  	memcpy(buffer, recv_ptr, 8);  	recv_ptr += 8;  	buffer[8] = '\0'; 	lblen = atoi(buffer); 	if (lblen != 0) {: 	    debug(F101,"  length of DATA tag not zero","",lblen); 	    return(-1); 	}7 	debug(F100,"  positioned at start of file data","",0);  	goto all_set;     } 
     else {/ 	debug(F110,"  unrecognized label: ",buffer,0);  	memcpy(buffer, recv_ptr, 8);  	recv_ptr += 8;  	buffer[8] = '\0'; 	lblen = atoi(buffer); 	recv_ptr += lblen;  	goto next_label;      }        all_set:'     if (gotfile != 1 || gotname != 1) { : 	debug(F100,"  missing one or more required labels","",0); 	return(-1);     }    /*  * Prep the characteristics   */   0     fab_ofile.fab$b_fac = FAB$M_BIO | FAB$M_PUT;$     fab_ofile.fab$l_fop = FAB$M_MXV;)     if ((ofile_lblopts & LBL_NAM) != 0) { % 	fab_ofile.fab$l_fna = ofile_vmsname; - 	fab_ofile.fab$b_fns = strlen(ofile_vmsname);      } 0     fab_ofile.fab$l_xab = (char *)&xabdat_ofile;     rab_ofile = cc$rms_rab; %     rab_ofile.rab$l_fab = &fab_ofile; !     xabdat_ofile = cc$rms_xabdat; 3     xabdat_ofile.xab$l_nxt = (char *)&xabrdt_ofile; !     xabrdt_ofile = cc$rms_xabrdt; 3     xabrdt_ofile.xab$l_nxt = (char *)&xabfhc_ofile; !     xabfhc_ofile = cc$rms_xabfhc; 3     xabfhc_ofile.xab$l_nxt = (char *)&xabpro_ofile; !     xabpro_ofile = cc$rms_xabpro; 3     xabpro_ofile.xab$l_nxt = (char *)&xaball_ofile; !     xaball_ofile = cc$rms_xaball;    /*  * Load 'em up  */   0     memmove(&xabpro_ofile.xab$w_pro, filptr, 2);     filptr += 2;'     if ((ofile_lblopts & LBL_OWN) != 0) - 	memmove(&xabpro_ofile.xab$l_uic, filptr, 4);      filptr += 4;-     memmove(&fab_ofile.fab$b_rfm, filptr, 1);      filptr += 1;-     memmove(&fab_ofile.fab$b_org, filptr, 1);      filptr += 1;-     memmove(&fab_ofile.fab$b_rat, filptr, 1);      filptr += 1;!     filptr += 4;			/* reserved */ -     memmove(&fab_ofile.fab$b_fsz, filptr, 1);      filptr += 1;0     memmove(&xabfhc_ofile.xab$w_lrl, filptr, 2);     filptr += 2;-     memmove(&fab_ofile.fab$w_mrs, filptr, 2);      filptr += 2;0     memmove(&xabfhc_ofile.xab$l_ebk, filptr, 4);     filptr += 4;3 /* preserve this as RMS won't remember it for us */ #     memmove(&ofile_ffb, filptr, 2);      filptr += 2;0     memmove(&xaball_ofile.xab$l_alq, filptr, 4);     filptr += 4;0     memmove(&xaball_ofile.xab$w_deq, filptr, 2);     filptr += 2;0     memmove(&xaball_ofile.xab$b_bkz, filptr, 1);     filptr += 1;-     memmove(&fab_ofile.fab$w_gbc, filptr, 2);      filptr += 2;5     memmove(&xabfhc_ofile.xab$w_verlimit, filptr, 2);      filptr += 2;      memmove(&jnlflg, filptr, 1);     if (jnlflg !=0) 9 	debug(F100,"  journaling status removed for file","",0);      filptr += 1;0     memmove(&xabdat_ofile.xab$q_cdt, filptr, 8);     filptr += 8;      memmove(&revdat, filptr, 8);     filptr += 8;      memmove(&revnum, filptr, 2);     filptr += 2;0     memmove(&xabdat_ofile.xab$q_edt, filptr, 8);     filptr += 8;'     if ((ofile_lblopts & LBL_BCK) != 0) - 	memmove(&xabdat_ofile.xab$q_bdt, filptr, 8);      filptr += 8;   /*	  * ACL's?   */   8     if ((ofile_lblopts & LBL_ACL) != 0 && gotacl != 0) {3 	xabpro_ofile.xab$l_aclbuf = (char *)&ofile_vmsacl; * 	xabpro_ofile.xab$w_aclsiz = ofile_acllen;     }    /*/  * Give it a quick whirl around the dance floor   */   %     rms_sts = sys$create(&fab_ofile);      if (!(rms_sts & 1)) { 3 	debug(F101,"  $create failed, status","",rms_sts);  	return(-1);     }   7     if((ofile_lblopts & LBL_ACL) != 0 && gotacl != 0) { ( 	if (!(xabpro_ofile.xab$l_aclsts & 1)) {K 	    debug(F101,"  ACL chain failed, status","",xabpro_ofile.xab$l_aclsts);  	    return(-1); 	}     }   &     rms_sts = sys$connect(&rab_ofile);     if (!(rms_sts & 1)) { 4 	debug(F101,"  $connect failed, status","",rms_sts); 	return(-1);     }    /*K  * Slide the remainder of the data to the head of the buffer and adjust the N  * counter and pointer. This will cause the buffer to be re-filled to the fullH  * 32Kb capacity, which is necessary for proper operation of zoutdump().  */   7     zoutcnt -= ((char *)recv_ptr - (char *)zoutbuffer); *     memcpy(zoutbuffer, recv_ptr, zoutcnt);#     zoutptr = zoutbuffer + zoutcnt; )     return(1);				/* Go fill some more */  }     