 #ifndef VMS O # error -- CKVTIO.C is used only on the VMS(tm) or OpenVMS(tm) Operating System  #endif /* VMS */   #ifdef __ALPHA6 # define CKVTIO_OS_ARCH_STRING " OpenVMS(tm) AXP(tm)"; #else  # ifdef VAX  #  module ckvtio "2.0-077"7 #  define CKVTIO_OS_ARCH_STRING " OpenVMS(tm) VAX(tm)";  # else #  ifdef __GNUC__ > #   define CKVTIO_OS_ARCH_STRING " OpenVMS(tm) VAX(tm) (GCC)"; #  else G #   error -- CKVTIO.C unknown architecture, neither VAX(tm) nor AXP(tm)  #  endif /* __GNUC__ */  # endif /* VAX */  #endif /* __ALPHA */ /*!   Module version number and date. 2   Also update the module number above accordingly. */6 char *ckxv = "Communications I/O 2.0(077), 22 Sep 94"; /*F   This is the default architecture and operating system herald string.6   It is redetermined dynamically in sysinit() below.   */% char *ckxsys = CKVTIO_OS_ARCH_STRING;   E /*  C K V T I O  --  Terminal and Interrupt Functions for VAX/VMS  */   J /* C-Kermit interrupt, terminal control & i/o functions for VMS systems */   /*?   Author: Frank da Cruz (fdc@columbia.edu, FDCCU@CUVMA.BITNET), B   Columbia University Academic Information Systems, New York City.  N   Copyright (C) 1985, 1994, Trustees of Columbia University in the City of NewK   York.  The C-Kermit software may not be, in whole or in part, licensed or L   sold for profit as a software product itself, nor may it be included in orM   distributed with commercial products or otherwise distributed by commercial J   concerns to their clients or customers without written permission of theK   Office of Kermit Development and Distribution, Columbia University.  This =   copyright notice must not be removed, altered, or obscured.  */   /* Edit History   *   * Originally adapted to VMS by:;  * Stew Rubenstein, Harvard University Chemical Labs, 1985.   *  * Cast of characters:J  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * **  * wb  William Bader     Lehigh University&  * mab Mark Buda         Digital (DEC)#  * fdc Frank da Cruz     Columbia U 4  * HG  Hunter Goatley    Western Kentucky University4  * jh  James Harvey      Indiana / Purdue University7  * ttj Tarjei T. Jensen  Norwegian Hydrographic Service -  * tmk Terry Kennedy     Saint Peters College    * MM  Martin Minow      Digital   * mlo Mike O'Malley     Digital   * DS  Dan Schullman     Digital  * js  James Sturdevant    * LT  Lee Tibbert       DigitalJ  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *E  * 006  8-May-85 MM   Got rid of "typeahead buffer" code as it didn't :  *		      solve the problem of data overruns at 4800 Baud.9  *		      Added vms "read a char" routine that checks for   *		      CTRL/C, CTRL/Z, etc.E  * 007 16-May-85 fdc  Changed calling convention of ttopen(), make it @  *  	    	      set value of its argument "lcl", to tell whether:  *                    C-Kermit is in local or remote mode..  * 008 11 Jun 85 MM   Fix definition of CTTNAMI  * 009 18 Jun 85 fdc  Move def of CTTNAM to ckcdeb.h so it can be shared. 6  * 010 25 Jun 85 MM   Added sysinit() to open console.=  * 011  5 Jul 85 DS   Treat hangup of closed line as success. C  * 012 11 Jul 85 fdc  Add gtimer(), rtimer() for timing statistics. D  * 013 14 Sep 87 fdc  Add parity strip to ttinl(), add syscleanup().G  * 014 14 Feb 89 mab  Make break REALLY work.  Add IOSB's to all QIO's. <  * 015 26 Feb 89 mab  Add dcl exit handler and minor cleanup:  * 016 23-Mar-89 mab  Add IO$M_BREAKTHRU to IO$_WRITEVBLK.:  *		      Add zchkspd() function to check for valid speed.>  * 017 04-Apr-89 mab  Fix some minor bugs to local/remote code@  * 018 23-Apr-89 mab  Add some of Valerie Mates' parity changes.B  * 019 25-Apr-89 mab  Change baud to 110 for V4.x break routine as9  * 		      50 baud is not supported on most Muxes by VMS. >  * 020 13-Jun-89 mab  Fix on exquota problem on qiow(readvblk)7  * 021 08-Jul-89 mab  Add ^C/^Y abort server mode code. #  * 022 11-May-90 mab  Add V5A code  @  * 023 20-Jul-90 wb   Add support for old VAX C and VMS versions0  * 024 22-Sep-90 wb   Fixes to cps/bps confusion.  * 025 26-Sep-90 tmk  Fix the ztime() functionK  * 026 29-Sep-90 tmk  Edit 024 cause a server command to give some blither- B  *		      ings about unsupported line speeds.  Added a simple hack@  *		      to exit quietly if the passed speed is 0.  AdventurousA  *		      maintainers may want to look in ttpkt(), where ttsspd() 0  *		      is being called with a value of -1/10.L  * 027 11-Oct-90 fdc  Made ttol return number of chars successfully written.<  *                    Made ztime() use ctime() in all cases.C  *                    Another fix (from tmk) for bps/cps confusion. E  *                    Wrapped source lines longer than 80 characters. I  * 028 18-Oct-90 fdc  Added comments to concb() and vms_getchar() to show K  *                    how to make Ctrl-C trap work.  Didn't actually do it, N  *                    though, because Ctrl-Y apparently still can't be caught.L  *                    Also, more minor reformatting.  Adjust time() declare.J  *                    Added support for automatic parity sense in ttinl(),O  *                    within #ifdef PARSENSE conditionals.  Built with PARSENSE (  *                    defined, works ok.G  * 029  5-Apr-91 fdc  Extensive reworking of many routines to allow for @  *		      network connections, addition of TGV MultiNet support.M  * 030 31-Aug-91 tmk  Fix problem with INPUT statements not timing out due to .  *		      extraneous rtimer() inside gtimer().-  * 032  6-Nov-91 fdc  Correct parity problem. 4  * 032  6-Nov-91 fdc  Cosmetic cleanup in sysinit().D  * 033 14-Jan-91 fdc  Fix to get_qio_maxbuf_size to prevent crashes:F  *                    remove "&" from "!test_qio(ttychn,max,&tmpbuf)",.  *                    from John Schultz at 3M.N  * 034  8-Feb-92 fdc  Don't change EIGHTBIT setting in ttvt, concb, or conbin.M  *                    Set EIGHTBIT in ttpkt only if parity is not NONE.  From 2  *                    Alan Robiette, Oxford U, UK.K  * 035 10-Jun-92 fdc  Added code from Ray Hunter of The Wollongong Group to M  *                    support both WIN/TCP and TGV Multinet.  Network section I  *                    of contti() redone to eliminate polling loop.  It's (  *                    infinitely faster.K  * 036 11-Jun-92 tmk  Fixed up edit 034 so 8-bit characters could be passed &  *                    in connect mode.L  * 037 19-Jun-92 fdc  Totally rewrote all the serial input and mode-setting G  *                    routines in this module to use nonblocking, fully G  *                    buffered input and to share a common buffer.  All I  *                    serial-line input is localized to a single routine, M  *                    txbufr(), which, in turn is known only to ttinc().  The L  *                    other input routines, ttxin() and ttinl(), simply callM  *                    ttinc().  ttchk() and ttflui() are totally cognizant of F  *                    the buffer.  ttinl() now recognizes packets withL  *                    printable start characters and/or lacking terminators,I  *                    so VMS C-Kermit can now engage in "Doomsday Kermit" M  *                    protocol.  ttvt() and ttpkt() were merged into a single M  *                    new (static) routine, ttbin(), which no longer puts the K  *                    device into PASALL mode (which defeats flow control). N  *                    Added ttsndlb() to send a Long BREAK.  Much fine-tuning,K  *                    testing, and filling-in remains to be done, including N  *                    (a) make ttopen() and ttclos() aware of LAT devices; (b)L  *                    check remaining BYTLM quota before issuing a read, (c)J  *                    integrate network and serial buffers, and much more.M  *                    Anyway, this code seems to run faster than ever before, G  *                    and for the first time I can actually use sliding L  *                    windows AND long packets on my 8-year old MicroVAX-II.N  * 038 28-Jun-92 tmk  Additional work on edit 37, general cleanup of old defs.*  * 039  1-Jul-92 wb   Changes for VMS 4.4.@  * 040  4-Jul-92 tmk  Add modem signal support (ttgmdm routine).I  * 041  4-Jul-92 tmk  Add tgetent(), worker routine for el-cheapo curses. 2  * 042  4-Jul-92 jh   Enable typeahead in ttbin().L  * 043 21-Aug-92 fdc  Make default flow control be KEEP instead of Xon/Xoff.M  * 044  6-Sep-92 fdc  Put default flow back to Xon/Xoff, but allow KEEP to be M  *                    used to restore device's original flow-control setting. M  * 045 23-Sep-92 fdc  Add sleep(1) to tthang().  Seems to fix HANGUP command. M  *                    Suggested by Lee Tibbert.  Change ttbin() to use global N  *                    flow variable rather than its flow parameter for settingN  *                    flow control, to ensure the desired type of flow control5  *                    is used during DIAL operations. L  * 046 26-Sep-92 fdc  Change sleep(1) in tthang() to sleep(3).  Annoying butL  *                    necessary.  IO$M_HANGUP takes about 3 seconds, but theH  *                    sys$qiow() function returns immediately instead of9  *                    waiting for the action to complete. L  * 047 08-Oct-92 HG   Add call to sys$alloc in ttopen() to prevent user with>  *		      SHARE from getting port in use.  Some add'l cleanup.D  * 048 12-Oct-92 LT   Minor changes to support DEC TCP/IP (nee UCX).3  * 049 25-Oct-92 fdc  Adapt cancio() to DEC TCP/IP. D  *                    Remove superfluous ttflui() call from ttpkt().M  *                    Add code from Lee Tibbert to sysinit() to figure out OS 7  *                    and architecture name at runtime. L  * 050 18-Nov-92 fdc  Read from comm device in 1024-byte chunks, rather thanM  *                    trusting the qio_maxbuf_size.  This should reduce BYTLM M  *                    quota-exceeded errors.  Suggested by tmk as a temporary !  *                    workaround. @  * 051 10-May-93 fdc  Add support for SET TRANSFER CANCELLATION.M  * 052 16-May-93 fdc  Change VMSTCPIP to TCPIPLIB to agree with new CKCNET.H. E  * 053 16-May-93 fdc  ANSIfication for GNU CC, from James Sturdevant. N  * 054 08-Jun-83 fdc  Add TT$M_LOCALECHO and TT$M_ESCAPE to the terminal modesK  *                    we handle, to prevent "getty babble" with modems, VAX   *                    PSI, etc. N  * 055 16-Jun-93 fdc  Edit 054 only affected ttbin().  This edit does the sameH  *                    for conbin() and concb().  Fixes double echoing in>  *                    command mode when coming in via VAX PSI.=  * 056  8-Aug-93 fdc  Add types to all function declarations. K  * 057 17-Aug-93 fdc  Add GET_SDC macro as in CKVIOC.C, accounting for GCC. D  *                    From Tarjei T. Jensen <tarjeij@extern.uio.no>.K  * 058 27-Sep-93 HG   Fix for real the SHARE issue when allocating terminal @  *		      by dropping SHARE before trying to assign the channel.M  * 059  7-Oct-93 mlo  Added support for CMU-OpenVMS/IP ("CMU/Tek").  Requires B  *                    CMU-OpenVMS/IP sockets library, also by mlo.J  * 060  9-Oct-93 HG   Fix improper call to vms_assign_channel in edit 058,4  *                    noticed by Fritz@GEMS.VCU.EDU.M  * 061  9-Oct-93 fdc  For some reason, conbin() was turning off flow control. L  *                    This caused massive data loss during CONNECT mode whenJ  *                    running C-Kermit from a low-speed connection throughH  *                    a DECserver.  Now conbin() leaves the console flow,  *                    control setting alone.J  * 062 10-Oct-93 ttj  Change parameters to time() and ctime() from long toO  *                    time_t (pointers).  Made prototype for vms_assign_channel <  *                    and caught an erroneous function call.L  * 063  9-Nov-93 fdc  In sysinit(), don't run sys$getdviw() on the "console"O  *                    if the console is not a terminal (from tcwkw@sf.msc.edu). N  *                    And (blame this one on me) _never_ set the backgrd flag.>  * 064 25-Nov-93 fdc  Fixed coninc(n) to return -1 on timeout.J  * 065  9-Dec-93 fdc  Fix transfer cancellation to account for parity, and3  *                    allow it only in remote mode. O  * 066 13-Dec-93 fdc  Make debug logging in ttol() show why packet writes fail. H  * 067 15-Dec-93 fdc  New, MAXBUF-proof ttol() recovers from failures byJ  *                    writing the packet in chunks, whose size is computedM  *                    dynamically.  This seems to cause no noticable slowdown +  *                    in the transfer rate. B  * 068 31-Dec-93 fdc  Fix bug in parity-detection code in ttinl().E  * 069 14-Dec-93 fdc  Add ttgwsiz() routine, code from John Berryman. I  * 070 14-MAR-94 mlo  CMU_TCPIP modifications: contti - return error (-1) I  *                    if number of characters read is zero; cancio - pass B  *                    correct i/o channel for ttyfd to sys$cancel.I  * 071 15-MAR-94 mlo  ttol() - add #ifdef DEBUG for compiles with NODEBUG F  * 072 27-Mar-94 fdc  Straighten out some ttsspd()/ttgspd() confusion.@  * 073 11-AUG-94 fdc  Make conoll() return a proper return code.E  * 074 12-AUG-94 fdc  Make syscleanup() handle conres() error.  Make  M  * 075 20-AUG-94 js   Make congm() get terminal type, etc, to remove annoying H  *                    "Sorry, terminal type not supported" messages when4  *                    running from a .COM file, etc.M  * 076 02-Sep-94 fdc  Call con_cancel() in syscleanup() to cancel any pending F  *                    console i/o, hopefully eliminating zombies after/  *                    after disconnection, etc. L  * 077 22-Sep-94 mlo  Don't call sys$cancel() in cancio() on CMU/Tek network=  *                    connections - it breaks the connection.   */    /*&  Variables available to outside world:  A    dftty  -- Pointer to default tty name string, like "/dev/tty". F    dfloc  -- 0 if dftty is console(remote), 1 if external line(local).    dfprty -- Default parity !    dfflow -- Default flow control 0    ckxech -- Flag for who echoes console typein:0      1 - The program (system echo is turned off)0      0 - The system (or front end, or terminal).E    functions that want to do their own echoing should check this flag     before doing so.   
    backgrd9      Flag indicating program not executing interactively. A      Used to ignore INT and QUIT signals, suppress messages, etc. 
    vms_status 7      Status returned by most recent VMS system service, %      can be used for error reporting.   L  Functions for assigned communication line (either external or console tty):  J    ttopen(ttname,local,mdmtyp) -- Open the named tty for exclusive access.O    ttclos()                -- Close & reset the tty, releasing any access lock. K    ttpkt(speed,flow)       -- Put the tty in packet mode and set the speed. C    ttvt(speed,flow)        -- Put the tty in virtual terminal mode. 3 				or in DIALING or CONNECTED modem control state. ;    ttinl(dest,max,timo)    -- Timed read line from the tty. <    ttinc(timo)             -- Timed read character from tty.J    ttchk()                 -- See how many characters in tty input buffer.C    ttxin(n,buf)            -- Read n characters from tty (untimed). 8    ttol(string,length)     -- Write a string to the tty.;    ttoc(c)                 -- Write a character to the tty. 5    ttflui()                -- Flush tty input buffer. 2    tt_cancel()		   -- Cancel any asynch I/O to tty */   /* Functions for console terminal: +    congm()   -- Get console terminal modes. N    concb(esc) -- Put the console in single-character wakeup mode with no echo.7    conbin(esc) -- Put the console in binary (raw) mode. @    conres()  -- Restore the console to mode obtained by congm().<    conoc(c)  -- Unbuffered output, one character to console.I    conol(s)  -- Unbuffered output, null-terminated string to the console. N    conola(s) -- Unbuffered output, array of lines to the console, CRLFs added.@    conxo(n,s) -- Unbuffered output, n characters to the console.C    conchk()  -- Check if characters available at console (bsd 4.2). < 		Check if escape char (^\) typed at console (System III/V).;    coninc(timo)  -- Timed get a character from the console. L    conint()  -- Enable terminal interrupts on the console if not background.M    connoi()  -- Disable terminal interrupts on the console if not background. O    contti()  -- Get a character from either console or tty, whichever is first.    Time functions  !    msleep(m) -- Millisecond sleep 2    ztime(&s) -- Return pointer to date/time string*    rtimer()  -- Reset elapsed time counter     gtimer()  -- Get elapsed time */   /* Includes *// #include "ckcdeb.h"			/* Formats for debug() */  #include "ckcasc.h"  #include "ckcker.h"    #include "ckvvms.h"   , #include <stdio.h>			/* Unix Standard i/o */& #include <signal.h>			/* Interrupts */% #include <setjmp.h>			/* Longjumps */  #include <iodef.h> #include <ttdef.h> #include <tt2def.h>  #include <ssdef.h> #include <descrip.h> #include <dvidef.h>  #include <dcdef.h> #include <devdef.h>  #include <time.h>  #include <syidef.h>  #include <prvdef.h>    /* lt 1992-10-08 Begin  */  #ifndef __ALPHA  # ifndef __GNUC__  #  define void int # endif /* __GNUC__ */ #endif /* __ALPHA */ /* lt 1992-10-08 End  */   M #if defined(VMS_V40) || defined(VMS_V42) || defined(VMS_V44) /* No starlet */  #define IO$_TTY_PORT 41  #else  #include <starlet.h> #endif /* (Old VMS) */   /* Macros */  > #define xx_inc(timo) (--ttxbn>=0?ttxbuf[ttxbp++]:txbufr(timo))   /* Declarations */   #ifndef __ALPHA  #ifndef MULTINET     time_t time(); #endif #endif6     char *ctime();			/* Convert to asctime() string */  +     void dcl_exit_h();			/* Exit handler */ G     unsigned short vms_assign_channel(struct dsc$descriptor_s *ttname);      VOID tt_cancel();    /**   This is the device name for the console.@   When we use SYS$INPUT, it prevents CONNECT from working in DCL:   procedures that do not "$ DEFINE SYS$INPUT SYS$COMMAND".G   When we use SYS$COMMAND, it allows CONNECT to work in DCL procedures, K   but it forces the command parser to read from the terminal, and therefore J   prevents inclusion of Kermit commands as "image data" in DCL procedures. */  #define CONDEVICE    "SYS$INPUT"! #define CONDEV_COLON "SYS$INPUT:"   F /* dftty is the device name of the default device for file transfer */O /* dfloc is 1 if dftty is the user's console terminal, 0 if an external line */        char *dftty = CTTNAM; 4     int dfloc = 0;			/* Default location is local */-     int dfprty = 0;			/* Parity (0 = none) */ )     int ttprty = 0;			/* Parity in use */ 2     int ttpflg = 0;			/* Parity not sensed yet. */=     int backgrd = 0;			/* Running in "background" (no tty) */ E     static int ttpmsk = 0377;		/* Communication device parity mask */ ;     int ttmdm = 0;                      /* Modem in use. */ B     int dfflow = FLO_XONX;		/* Default flow control is Xon/Xoff */-     int batch = 0;			/* Assume interactive */ 6     int ttcarr = CAR_AUT;		/* Carrier Handling Mode */:     int tvtflg = 0;			/* Flag that ttvt has been called *//     long ttspeed = -1;			/* For saving speed */ ,     int ttflow = -9;			/* For saving flow */  L int ckxech = 0; /* 0 if system normally echoes console characters, else 1 */  H unsigned int vms_status;	    /* Used for system service return status */  ( /* Structures used within this module */   #ifndef TT$C_BAUD_38400  #define TT$C_BAUD_38400	0x11 #endif /* TT$C_BAUD_38400 */   static struct {      unsigned char dec;     unsigned short int line;     } ttspeeds[] = { 	{TT$C_BAUD_50,       5},  	{TT$C_BAUD_75,       7},  	{TT$C_BAUD_110,     11},  	{TT$C_BAUD_134,     13},           {TT$C_BAUD_150,     15}, 	{TT$C_BAUD_300,     30},  	{TT$C_BAUD_600,     60},  	{TT$C_BAUD_1200,   120},  	{TT$C_BAUD_1800,   180},  	{TT$C_BAUD_2000,   200},  	{TT$C_BAUD_2400,   240},  	{TT$C_BAUD_3600,   360},  	{TT$C_BAUD_4800,   480},  	{TT$C_BAUD_7200,   720},  	{TT$C_BAUD_9600,   960},  	{TT$C_BAUD_19200, 1920},  	{TT$C_BAUD_38400, 3840},  	{0,                   0} };  9 /* Declarations of variables global within this module */    /* was long... */  #define TIME_T time_t  #ifdef __ALPHA
 #ifdef WINTCP 
 #undef TIME_T  #define TIME_T long  #endif /* WINTCP */  #endif /* __ALPHA */  6 static TIME_T tcount = 0;		/* For timing statistics */  6 static char brkarray[] = {		/* For simulating BREAK */  H  '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0',H  '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0',H  '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0',G  '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0'  };  , int ttyfd = -1;				/* TTY file descriptor */   #ifdef COMMENT /* old */< static int conif = 0,			/* Console interrupts on/off flag */-     conclass = 0,			/* Console device type */ 4     cgmf = 0,				/* Flag that console modes saved */J     xlocal = 0,                         /* Flag for tty local or remote */(     ttychn = 0,				/* TTY i/o channe; */,     conchn = 0,				/* Console i/o channel */:     con_queued = 0,			/* console i/o queued in contti() */5     tt_queued = 0,			/* tty i/o queued in contti() */ 3     conch,				/* console input character buffer  */ 5     curcarr = 0,			/* Carrier mode: require/ignore */ -     ttch;				/* tty input character buffer */  #else /* new */  static unsigned short (     ttychn = 0,				/* TTY i/o channe; */,     conchn = 0,				/* Console i/o channel */:     con_queued = 0,			/* console i/o queued in contti() */5     tt_queued = 0;			/* tty i/o queued in contti() */   < static int conif = 0,			/* Console interrupts on/off flag */-     conclass = 0,			/* Console device type */ 4     cgmf = 0,				/* Flag that console modes saved */J     xlocal = 0,                         /* Flag for tty local or remote */3     conch,				/* console input character buffer  */ 5     curcarr = 0,			/* Carrier mode: require/ignore */ -     ttch;				/* tty input character buffer */  #endif /* COMMENT */  < static unsigned char escchr;		/* Escape or attn character */D static char ttnmsv[80];          	/* copy of open path for tthang */1 static char lclnam[80];			/* Local device name */    static char tt_fulldevnam[65];N static struct dsc$descriptor_s tt_fulldevnam_d;	/* Descriptor for line name */  E static long int qio_maxbuf_size;	/* Maximum size of QIO to succeed */ J static unsigned long dclexh_status;	/* Exit status for DCL exit handler */4 static struct iosb_struct coniosb, ttiosb, wrk_iosb; static struct tt_mode 6     ttold, ttraw, tttvt,		/* for communication line */0     ccold, ccraw, cccbrk,		/* and for console */
     cctmp;   /* Network support */   0 #include "ckcnet.h"			/* Network type symbols */& extern int ttnet;			/* Network type */7 static int network = 0;			/* 1 if network connection */ > extern int xfrcan, xfrchr, xfrnum;	/* Transfer cancellation */   /*C   Select proper library function for getting socket device channel.  */ #ifdef TCPIPLIB  #if defined (__DECC)$ # define GET_SDC (short)decc$get_sdc@ #elif (defined (VAXC) || defined (__VAXC) || defined (__GNUC__)) # define GET_SDC vaxc$get_sdc  #else / # error unknown compiler, not DECC and not VAXC  #endif /* __DECC */  #endif /* TCPIPLIB */   ) /* Needed for parity fixes in edit 036 */ 1 extern int parity;			/* current parity setting */    /*   New buffered input scheme. */ #define TTXBUF  
 #ifdef TTXBUF 2 #define TTXBUFL RBSIZ			/* Internal buffer size */  * CHAR 	ttxbuf[TTXBUFL+1];		/* The buffer */: int 	ttxbp = 0, ttxbn = 0;		/* Buffer pointer and count */   /*
   T X B U F R   E   Read bytes from communication device into internal buffer ttxbuf[]. E   To be called only when input buffer is empty, i.e. when ttxbn == 0.   L   Other comm-device reading routines, like ttinc, ttinl, ttxin, should checkM   the internal buffer first, and call this routine for a refill if necessary.   E   When data is read successfully, the first character is returned and N   the global buffer count, ttxbn, is set to the number of characters remainingG   in ttxbuf after it, and the global buffer offset, ttxbp, is set to 1.   J   When data is not read successfully, -1 is returned indicating a timeout,!   or -2 indicating disconnection.  */ int . txbufr(timo) int timo; {		/* TT Buffer Read */     int count;)     int func;				/* Read function code */ !     int mask;				/* Event mask */ 0     int vms_status;			/* Read QIO return code */@     static int trmmsk[2] = {0,0};	/* Terminal read break mask */E     static int trmlong[8] = {0,0,0,0,0,0,0,0}; /* Break on nothing */   /     debug(F101,"txbufr entry, ttxbn","",ttxbn); 1     if (ttxbn > 0) {			/* Should not be called */ E 	debug(F101,"txbufr called with ttxbn","",ttxbn); /* if ttxbn > 0! */ 	 	ttxbn--;   	return(ttxbuf[ttxbp++] & 0xff);     } =     ttxbp = ttxbn = 0;			/* Reset buffer pointer and count */      ttxbuf[0] = NUL;  !     if (timo < 0)			/* Be safe */        timo = 0; &     debug(F101,"txbufr timo","",timo);  N     func = IO$_READVBLK | IO$M_NOFILTR;	/* Read virtual block, no filtering */5     trmmsk[0] = sizeof(trmlong);	/* No terminators */ 9     trmmsk[1] = (int)&trmlong;		/* Keep all characters */    /*M   We try to scoop up as many as we can in a nonblocking read (timed, but with I   timeout value of 0).  This is supposed to return immediately with up to *   "count" characters placed in our buffer. */7     count = TTXBUFL;			/* Maximum characters to read */    #ifdef COMMENT /*L   This causes problems because we are not adjusting according to the CURRENTK   BYTLM quota, but rather to the one that was obtained when Kermit started. D   Since the quota is dynamic, it might have been reduced since then. */      if (count > qio_maxbuf_size) 	count = qio_maxbuf_size;  #else  /*K   So for now we use 1024, which tends to be smaller than the value obtained M   above.  Later, this should be changed to find out the remaining BYTLM quota G   and use that instead.  This size can be overridden at compile time by    defining the symbol... */ #ifndef CKV_IO_SIZE  #define CKV_IO_SIZE 1024 #endif /* CKV_IO_SIZE */       if (count > CKV_IO_SIZE) 	count = CKV_IO_SIZE;  #endif /* COMMENT */  )     debug(F101,"txbufr 1 read","",count); M     vms_status = sys$qiow(QIOW_EFN, ttychn, func|IO$M_TIMED, &wrk_iosb, 0, 0, & 			  ttxbuf, count, 0, &trmmsk, 0, 0); /*%  * Did something _really_ bad happen?   */ #     if (vms_status != SS$_NORMAL) { < 	debug(F101,"txbufr 1 serious error, status","",vms_status); 	return(-2);     } 1     debug(F101,"txbufr 1 size","",wrk_iosb.size); 3     debug(F101,"txbufr 1 iosb","",wrk_iosb.status); +     debug(F110,"txbufr 1 ttxbuf",ttxbuf,0);  /*  * How about a hangup?  */ F     if (wrk_iosb.status == SS$_HANGUP) { /* Check for disconnection */$ 	debug(F100,"txbufr 1 hangup","",0); 	return(-2);     }  /*  * Did anything useful happen?  */      if (wrk_iosb.size > 0) {0 	ttxbn = wrk_iosb.size;		/* Set buffer count. */0 	ttxbn--;			/* Less one for the one we return */= 	return(ttxbuf[ttxbp++] & 0xff);	/* Return it, bump offset */      }  /*  * An unexpected status?  */ )     if (wrk_iosb.status != SS$_TIMEOUT) { E 	debug(F101, "txbufr 1 unexpected iosb status", "", wrk_iosb.status); % 	return(-2);			/* Call it a hangup */      }  /*H  * If we didn't get any characters, then try a blocking, possibly timed,M  * read for a single character.  Since this routine will be called again very J  * soon, the first read with a zero timeout will have the rest of the userD  * data in it.  Thus, this isn't as inefficient as it first appears.  */      if (timo > 0)        func |= IO$M_TIMED; )     debug(F101,"txbufr 2 read","",count); B     vms_status = sys$qiow(QIOW_EFN, ttychn, func, &wrk_iosb, 0, 0,% 			  ttxbuf, 1, timo, &trmmsk, 0, 0); 5     debug(F101,"txbufr 2 vms_status", "",vms_status); :     debug(F101,"txbufr 2 iosb status","",wrk_iosb.status); /*%  * Did something _really_ bad happen?   */ #     if (vms_status != SS$_NORMAL) { " 	debug(F101,"txbufr fails","",-2); 	return(-2);     } 1     debug(F101,"txbufr 2 size","",wrk_iosb.size); 3     debug(F101,"txbufr 2 iosb","",wrk_iosb.status); +     debug(F110,"txbufr 2 ttxbuf",ttxbuf,0);    /*  * How about a hangup?  */ F     if (wrk_iosb.status == SS$_HANGUP) { /* Check for disconnection */$ 	debug(F100,"txbufr 2 hangup","",0); 	return(-2);     }    /*  * Did anything useful happen?  */      if(wrk_iosb.size > 0) { 0 	ttxbn = wrk_iosb.size;		/* Set buffer count. */0 	ttxbn--;			/* Less one for the one we return */= 	return(ttxbuf[ttxbp++] & 0xff);	/* Return it, bump offset */      }    /*  * An unexpected status?  */ )     if (wrk_iosb.status != SS$_TIMEOUT) { E 	debug(F101, "txbufr 2 unexpected iosb status", "", wrk_iosb.status); % 	return(-2);			/* Call it a hangup */      }    /*  * Otherwise it's a timeout   */ 5     debug(F100, "txbufr 2 returning timeout", "", 0);      return(-1);  }   E /*  T T I N C  --  Read a character from the communication device  */  /*@   ttinc() maintains an internal buffer to minimize system calls.@   Returns the next character, or -1 if there is a timeout, or -2D   on communications disconnect.  Calls txbufr() to refill its buffer   when necessary.  */ int  ttinc(timo) int timo; {      int x; unsigned char c;    #ifdef NETCONN     if (network)       return(netinc(timo));  #endif /* NETCONN */  '     debug(F101,"ttinc ttxbn","",ttxbn); =     if (--ttxbn >= 0) {			/* Something in internal buffer? */ 8 	c = ttxbuf[ttxbp++];		/* Yes, return next character. */$ 	debug(F101,"ttinc returns c","",c); 	return(c & 0xff);>     } else if ((x = txbufr(timo)) < 0) { /* No, fill buffer */> 	debug(F101,"ttinc timed out","",x); /* Pass along failure. */ 	return(x);      } else {				/* Success. */$ 	debug(F101,"ttinc returns x","",x);. 	return(x & 0xff);		/* Return the character */     }  }   8 /*  T T X I N  --  Get n bytes from tty input buffer  */ /*@   Call with n = number of bytes to get, buf = where to put them.  B   This routine assumes that the given number of bytes is availableG   and will not return until they are gotten.  You should only call this G   routine after calling ttchk to find out how many bytes are waiting to 
   to be read.   
   Returns:1   -1 on error, number of chars gotten on success.  */ int   ttxin(n,buf) int n; CHAR *buf; {
     int i, x;        debug(F101,"ttxin","",n);    #ifdef NETCONN     if (network) { 	for (i = 0; i < n; i++) {( 	    if ((x = ttinc(0)) < 0) return(-1); 	    buf[i] = (char) x;  	}     } else { #endif /* NETCONN */ /* xx_inc() is a macro */  	for (i = 0; i < n; i++) {) 	    if ((x = xx_inc(0)) < 0) return(-1);  	    buf[i] = (char) x;  	} #ifdef NETCONN     }  #endif /* NETCONN */     buf[i] = NUL;      return(i); }   @ /*  T T F L U I  --  Flush communication device input buffer  */   int 
 ttflui() {
     int n;     debug(F100,"ttflui","",0); #ifdef NETCONN     if (network)       return(netflui()); #endif /* NETCONN */  <     ttxbn = ttxbp = 0;			/* Flush internal buffer *FIRST* */     if ((n = ttchk()) > 0) {! 	debug(F101,"ttflui count","",n);  #ifdef NETCONN
 	if (network) E 	  while ((n--) && ttinc(2) > -1) ; /* Don't worry, it's buffered. */  	else  #endif /* NETCONN */F 	  while ((n--) && xx_inc(2) > -1) ; /* Don't worry, it's buffered. */     }      return(0); }   A /*  T T C H K  --  Check how many bytes are waiting to be read */  /*H   Returns number of bytes waiting, or -1 if connection has been dropped.H   The number of bytes waiting includes those in our internal buffer plus'   those in VMS's internal input buffer.  */, int					/* Check how many bytes are ready */+ ttchk() {				/* for reading from network */      static struct {  	unsigned short count; 	unsigned char first;  	unsigned char reserved1;   	long reserved2; } ttchk_struct;   #ifdef NETCONN8     if (network)			/* If network connection active... */3       return(nettchk());		/* Check real network. */  #endif /* NETCONN */        CHECK_ERR("ttchk: sys$qiow",E 	sys$qiow(QIOW_EFN, ttychn, IO$_SENSEMODE|IO$M_TYPEAHDCNT, &wrk_iosb, ; 		 0, 0, &ttchk_struct, sizeof(ttchk_struct), 0, 0, 0, 0));  #ifdef DEBUG9     debug(F101,"ttchk count","",(int)ttchk_struct.count);      if (ttchk_struct.count) ;       debug(F101,"ttchk first","",(int)ttchk_struct.first);  #endif /* DEBUG */@     return(vms_status & 1 ? ttchk_struct.count + ttxbn : ttxbn); }    #ifdef CTRLC #undef CTRLC #endif /* CTRLC */ #define CTRLC '\03'   L /*  T T I N L  --  Read a record (up to break character) from comm line.  */ /*K   Reads up to "max" characters from the communication line, terminating on:   B     (a) the packet length field if the "turn" argument is zero, orK     (b) on the packet-end character (eol) if the "turn" argument is nonzero      (c) two Ctrl-C's in a row   I   and returns the number of characters read upon success, or if "max" was I   exceeded or the timeout interval expired before (a) or (b), returns -1.   N   The characters that were input are copied into "dest" with their parity bitsJ   stripped if parity was selected.  Returns the number of characters read.M   Characters after the eol are available upon the next call to this function.   F   Since this function has grown to have its fingers so deeply into theK   protocol, it is slated for removal: rpack() will take care of everything.  */   int  #ifdef CK_ANSIC D ttinl(CHAR *dest, int max, int timo, CHAR eol, CHAR start, int turn) #else L ttinl(dest,max,timo,eol,start,turn) int max,timo,turn; CHAR *dest,eol,start; #endif /* CK_ANSIC */ 
 /* ttinl */ {      int x, y, c, i, j;)     int ccn = 0;		/* Control C counter */ 
     int flag;      int cc;      unsigned char *cp;     int pktlen = -1;     int lplen = 0;     int havelen = 0;  '     debug(F101,"ttinl start","",start); %     debug(F101,"ttinl turn","",turn);      i = j = flag = 0; E     ttpmsk = (ttprty) ? 0177 : 0377;	/* Set parity stripping mask. */      while (i < max) { = 	cc = network ? ttinc(timo) : xx_inc(timo); /* Read a byte */ $ 	if (cc < 0)			/* Check for error */ 	  return(-1); 	/* Check for cancellation */ 6 	if (!xlocal && xfrcan && ((cc & ttpmsk) == xfrchr)) {? 	    if (++ccn >= xfrnum) {	/* If xfrnum in a row, bail out. */ 0 		fprintf(stderr,"^C...\r\n"); /* Echo Ctrl-C */
 		return(-2);  	    }5 	} else ccn = 0;			/* No cancel, so reset counter, */   - 	if ((flag == 0) && ((cc & 0x7f) == start)) { ( 	    debug(F100,"ttinl got start","",0);( 	    flag = 1;			/* Got packet start. */ 	}, 	if (flag) {			/* If we're in a packet... */ 	    dest[i++] = cc & ttpmsk; 1 	    if ((cc & 0x7f) == eol) { /* Stop at eol. */ & 		debug(F101,"ttinl got eol, i","",i); 		break; 	    } 	} /*G   If we have not been instructed to wait for a turnaround character, we H   can go by the packet length field.  If turn != 0, we must wait for the/   end of line (eol) character before returning.  */ #ifndef xunchar D #define xunchar(ch) (((ch) - 32 ) & 0xFF )	/* Character to number */ #endif /* xunchar */   	if (i == 2) {& 	    pktlen = xunchar(dest[1] & 0x7f); 	    havelen = (pktlen > 1);* 	    debug(F101,"ttinl length","",pktlen);$ 	} else if (i == 5 && pktlen == 0) {% 	    lplen = xunchar(dest[4] & 0x7f); $ 	} else if (i == 6 && pktlen == 0) {7 	    pktlen = lplen * 95 + xunchar(dest[5] & 0x7f) + 5;  	    havelen = 1; * 	    debug(F101,"ttinl length","",pktlen); 	}A 	if (havelen && !turn && (i > pktlen+1)) { /* Use length field */ . 	    debug(F101,"ttinl break on length","",i); 	    break;  	}     } 0     dest[i] = '\0';			/* Terminate the string */*     debug(F101,"ttinl loop done, i","",i);#     debug(F101,"ttinl max","",max); /     debug(F101,"ttinl dest[i-1]","",dest[i-1]); #     debug(F101,"ttinl eol","",eol);        if (i >= max) { * 	debug(F100,"ttinl buffer overflow","",0);= 	return(-1);	/* Overflowed dest buffer without getting eol */      }      x = i;				/* Size. */ *     debug(F111,"ttinl got packet",dest,x);  5     debug(F101,"ttinl size","",x);	/* Log the size */ /     dest[x] = '\0';			/* Terminate with null */   J     if (ttpflg++ == 0 && ttprty == 0) {	/* Check and adjust the parity. */2         if ((ttprty = parchk(dest,start,x)) > 0) {8 	    debug(F000,"ttinl parchk senses parity","",ttprty); 	    ttpmsk = 0x7f; @ 	    for (i = 0; i < x; i++)	/* Strip parity from this packet */ 	      dest[i] &= 0x7f;  	}: 	if (ttprty < 0) ttprty = 0;	/* Restore if parchk error */     } %     return(x);				/* Return length */  }    #endif /* TTXBUF */   9 SIGTYP (*saval)() = NULL;		/* For saving alarm handler */    VOID2 ttimoff() {				/* Turn off any timer interrupts */
     alarm(0);      if (saval) { 	signal(SIGALRM,saval);  	saval = NULL;     } else {- 	signal(SIGALRM,SIG_IGN);	/* (was SIG_DFL) */      }  }   < /*  P R I N T _ M S G  --  Log an error message from VMS  */   int  print_msg(s) char *s; {      long int blen = 0;0     char buf[PMSG_BUF_SIZE], msg[PMSG_MSG_SIZE];!     struct dsc$descriptor_s b = {  	PMSG_BUF_SIZE-1,  	DSC$K_DTYPE_T,  	DSC$K_CLASS_S,(char *)&buf      };  H     if (!((vms_status = sys$getmsg(vms_status, &blen, &b, 0, 0)) & 1)) {+ 	fprintf(stderr,"print_msg; sys$getmsg\n");  	return(-1);     }      buf[blen] = '\0'; %     sprintf(msg, "%s: %s\n", s, buf);      debug(F100,s,"",0);      ermsg(msg);      return(0); }   C /*  S Y S I N I T  --  System-dependent program initialization.  */    #ifndef DVI$_FULLDEVNAM  #define DVI$_FULLDEVNAM 232  #endif /* DVI$_FULLDEVNAM */   #ifndef DVI$_STS #define DVI$_STS 226 #endif /* DVI$_STS */    int 5 ttgwsiz() {				/* Get console window (screen) size */      int x = -1;       extern int tt_rows, tt_cols;7     typedef struct {			/* define an item list struct */ ' 	short length;			/* length of buffer */  	short code;			/* item code */! 	void *ptr;			/* ptr to buffer */ + 	void *retlen;			/* ptr to return length */      } item_list;     int status, iosb[2];6     item_list tt_dvi[] = {		/* Item list for GETDVI */ 	{4,DVI$_DEVBUFSIZ,&tt_cols,0},  	{4,DVI$_TT_PAGE,&tt_rows,0}, 
 	{0,0,0,0}     };!     $DESCRIPTOR(sysin,CONDEVICE); 9     status = sys$getdviw(0,0,&sysin,&tt_dvi,&iosb,0,0,0);      if ((status & 1) == 0)       return(-1); .     if (tt_rows < 1 || tt_cols < 1) return(0);     return(1); }    int  sysinit() {      extern int speed;      extern char ttname[];      extern char *ckzsys;E     struct itmlst dviitm[] = {{64,DVI$_FULLDEVNAM,(char *)&lclnam,0}, 8 			{sizeof(conclass),DVI$_DEVCLASS,(char *)&conclass,0}, 				{0,0,0,0}};        static struct desblk {6 	long int *fl;			/* Forward link.  Used by VMS only */* 	void (*fncpnt)();		/* Function to call */2 	unsigned char argcnt;		/* Only one arg allowed */5 	unsigned char filler[3];	/* Filler.  Must be zero */ 7 	long int *sts;			/* Address of sts (written by VMS) */ 8     } dclexh_ = {0,dcl_exit_h,1,{0,0,0},&dclexh_status};   #define GETCKXSYS  /*-   Get architecture and operating system name.  */ #ifdef GETCKXSYS   #if defined(__ALPHA)       ckxsys = " OpenVMS AXP";  > #elif !(defined(__VAX) || defined (VAX) || defined (__GNUC__)); # error Unknown Hardware type, not VAX(tm) and not AXP (TM)  #else /* VAX */   6 /* OK, we have a VAX so what is the name of the OS? */  J #ifndef SYI$_ARCH_NAME    /* Should be in syidef.h but is not there yet */ # define SYI$_ARCH_NAME 4454 #endif /* SYI$_ARCH_NAME */        struct iosb_t { / 	short int status;		/* System service status */  	short int unused[3];      } iosb;        struct itmlst_t { 3 	short unsigned int buffer_len;	/* Buffer length */ . 	short unsigned int item_code;	/* Item code */- 	char*buffer;			/* Where to write SYI info */ = 	long unsigned int *ret_len;	/* Pointer to returned length */ + 	long unsigned int mbz;		/* Must Be Zero */   
     } itmlst;   A     char arch_name[sizeof ("Alpha") - 1]; /* Architecture name */ 5     long unsigned int ret_len;		/* Returned length */  /*O   $getsyi of "hw_arch" will fail prior to VMS 5.5.  This failure indicates that N   the OS name is "VAX/VMS" (sic).  Use success or failure or $getsyi "hw_arch"L   rather than the more straight forward $getsyi "node_swvers" because latterI   is defined as four (4) characters and will get strange representing VMS    10.0.  */  D /*  Default -- Not strictly correct but traditional & familiar... */     ckxsys = " VAX/VMS";  +     itmlst.buffer_len = sizeof (arch_name); &     itmlst.item_code = SYI$_ARCH_NAME;     itmlst.buffer = arch_name;     itmlst.ret_len = &ret_len;     itmlst.mbz = 0;        if ((sys$getsyiw (0, 0, 0, 		    &itmlst, 		    &iosb, 		    0, 0) & 1) == 1) 	if ((iosb.status & 1) == 1) 	    ckxsys = " OpenVMS VAX";   6     ckzsys = ckxsys;			/* Same deal for file module */   #endif /* OS Type */ #endif /* GETCKXSYS */   /*=  * Set up DCL Exit handler.  This allows us to reset terminal ,  * and any other modifications we have done.  */ +     debug(F101,"sysinit ttychn","",ttychn); +     debug(F101,"sysinit conchn","",conchn); )     if (!CHECK_ERR("sysinit: sys$dclexh",  		   sys$dclexh(&dclexh_))) { B         debug(F100,"sysinit failed to declare exit handler","",0); #ifdef COMMENT 	return(0);  #endif /* COMMENT */     } G     if (ttychn)                     	/* if comms line already opened */ -       return(0);			/* (how could it be???) */   .     if (!conchn) {			/* Get console channel */ #ifdef CMU_TCPIPM       /* need to open console using libcmu routine to enable `select' call on         * file descriptor zero.	        */        cmu_stdin_open(dftty);       conchn = cmu_get_sdc(0); #else &       struct dsc$descriptor_s devnam =6 		{sizeof(dftty)-1,DSC$K_DTYPE_T,DSC$K_CLASS_S,dftty};+       conchn = vms_assign_channel(&devnam);  #endif /* CMU_TCPIP */     } ,     congm();				/* Get and save its modes */ /*&  * Parse console terminal device name.  */ D     if (isatty(0)) {		     /* So following won't fail under batch */" 	CHECK_ERR("sysinit: sys$getdviw",< 		  sys$getdviw(0, conchn, 0, &dviitm, &wrk_iosb, 0, 0, 0));' 	debug(F111,"sysinit","lclnam",lclnam);   $ 	if (!CHECK_ERR("sysinit: sys$qiow",2 		       sys$qiow(QIOW_EFN, conchn, IO$_SENSEMODE, 				&wrk_iosb, 0, 0,( 				&ccold, sizeof(ccold), 0, 0, 0, 0))) 	  return(-1);9 	ttspeed = speed = ttispd((unsigned char) wrk_iosb.size); * 	debug(F111,"sysinit speed",lclnam,speed); 	strncpy(ttname,lclnam,80);      }        /* Initialize descriptor */ 0     tt_fulldevnam_d.dsc$b_dtype = DSC$K_DTYPE_T;0     tt_fulldevnam_d.dsc$b_class = DSC$K_CLASS_S;  $     debug(F100,"sysinit done","",0);     return(0); }    /*>  * DCL Exit handler.  This is the cleanup handler for program.B  * Any final cleanup (closing channels etc) should be done at this	  * point.   */  VOID) dcl_exit_h(sts) unsigned long int *sts; {      syscleanup();      return;  }   ? /*  S Y S C L E A N U P -- System-dependent program epilog.  */      int  syscleanup() {
     int x;     extern zclosf();     void con_cancel();,     debug(F101,"syscleanup entry","",ttyfd);4     con_cancel();		/* Cancel pending console i/o. */:     ttclos(ttyfd);		/* Do the cleanup no matter what... */C     zclosf(ZSYSFN);		/* Close various files and kill child procs */  #ifdef COMMENT"     /* This is a bit extreme... */,     if ((x = conres()) < 0) exit(SS$_ABORT); #else 
     conres();  #endif /* COMMENT */)     debug(F101,"syscleanup conres","",x);      printf("\r");      return(0); }   9 /*  T T O P E N  --  Open a tty for exclusive access.  */   , /*  Returns 0 on success, -1 on failure.  */ /*7   If called with lcl < 0, sets value of lcl as follows: D   0: the terminal named by ttname is the job's controlling terminal.H   1: the terminal named by ttname is not the job's controlling terminal.F   But watch out: if a line is already open, or if requested line can't6   be opened, then lcl remains (and is returned as) -1. */ int D ttopen(ttname,lcl,modem,timo) char *ttname; int *lcl, modem, timo; {     extern int speed; 
     int s, x; 6     unsigned long int no_share_priv[2], prev_privs[2];0     unsigned long int devchar, devclass, devsts; /*    char dvibuf[65]; */ G     struct dsc$descriptor_s devnam = {0,DSC$K_DTYPE_T,DSC$K_CLASS_S,0}; L     struct itmlst dviitm[] = {{64,DVI$_FULLDEVNAM,(char *)&tt_fulldevnam,0},5 			{sizeof(devchar),DVI$_DEVCHAR,(char *)&devchar,0}, 8 			{sizeof(devclass),DVI$_DEVCLASS,(char *)&devclass,0},/ 			{sizeof(devsts),DVI$_STS,(char *)&devsts,0},  			{0,0,0,0}};   #ifdef NETCONN?     if (network && ttyfd > -1) {	/* if device already opened */ G         if (strncmp(ttname,ttnmsv,80))	/* are new & old names equal? */ >           ttclos(ttyfd);		/* no, close old ttname, open new */3         else 				/* else same, ignore this call, */ ! 	  return(0);			/* and return. */      } =     if (modem < 0) {			/* modem < 0 = special code for net */  	int x;  	ttmdm = modem; 5 	modem = -modem;			/* Positive network type number */ ' 	debug(F111,"ttopen net",ttname,modem); 6 	x = netopen(ttname, lcl, modem); /* (see ckcnet.h) */ 	if (x > -1) {& 	    strncpy(ttnmsv,ttname,DEVNAMLEN); 	    network = 1;  #ifdef COMMENT  /* Let netopen() handle this. */5 	    x = tn_ini();		/* Initialize telnet protocol. */  #endif /* COMMENT */ 	    ttnet = modem;  	} else network = 0;         return(x);     }  #endif /* NETCONN */  7     if (ttychn) return(0);		/* Close channel if open */   *     devnam.dsc$w_length  = strlen(ttname);"     devnam.dsc$a_pointer = ttname;<     sys$getdviw(0, 0, &devnam, &dviitm, &wrk_iosb, 0, 0, 0);@     tt_fulldevnam[65] = '\0';		/* Make sure it has an end.... */  8     if (devclass != DC$_TERM) {		/* Is it a terminal? */ 	fprintf(stderr,8 		"%%CKERMIT-W-NOTTERM, %s is not a terminal\n",ttname); 	return(-1);     } 8     if (!(devchar & DEV$M_AVL)) {	/* Is it available? */ 	fprintf(stderr,> 		"%%CKERMIT-W-NOTAVAL, %s is not available\n",tt_fulldevnam); 	return(-5);     } 7     if (!(devsts & UCB$M_ONLINE)) {	/* Is it online? */  	fprintf(stderr,; 		"%%CKERMIT-W-OFFLINE, %s is not online\n",tt_fulldevnam);  	return(-5);     } ;     ttmdm = modem;			/* Make this available to other fns */ ;     xlocal = *lcl;			/* Make this available to other fns */    /*D  *  Set up the tt_fulldevnam_d descriptor for use by ttclos() later.  */ :     tt_fulldevnam_d.dsc$w_length  = strlen(tt_fulldevnam);2     tt_fulldevnam_d.dsc$a_pointer = tt_fulldevnam;   /*I  *  Assume the user has SHARE privilege enabled and turn it off.  This is F  *  necessary to prevent a privileged user from assigning a channel to/  *  a device already in use by another process.   */ #     no_share_priv[0] = PRV$M_SHARE; 3     sys$setprv (0, &no_share_priv, 0, &prev_privs);   E     ttychn = vms_assign_channel(&devnam); /* Get a channel for it. */   D     sys$setprv (1, &prev_privs, 0, 0);	/* Re-enable the old privs */  '     debug(F111,"ttopen","modem",modem); $     debug(F101," ttychn","",ttychn);  ;     if (!ttychn) return(-1);		/* If couldn't open, fail. */  /*M  * Check for maximum size of QIO, so as to not get the dreaded quota exceeded C  * status returned.  When doing a QIO that has a larger buffer than *  * MAXBUF, exceeded quota wil be returned.  *D  * Example: MAXBUF = 2048, QIO = 1936, overhead is 112 will succeed.  *	    QIO of 1937 will fail.   *1  * This can change for different versions of VMS.   */ 2     qio_maxbuf_size = get_qio_maxbuf_size(ttychn);  L     strncpy(ttname,tt_fulldevnam,80);	/* Copy true name back to main pgm  */  B     strcpy(ttnmsv,ttname);		/* Open, keep copy of name locally. */6     ttxbn = ttxbp = 0;			/* Initialize input buffer */  > /* Caller wants us to figure out if line is controlling tty */  (     debug(F111,"ttopen ok",ttname,*lcl);     if (*lcl < 0) {  	if (conclass == DC$_TERM)5 	  xlocal = (strncmp(ttname,lclnam,80) == 0) ? 0 : 1;  	else ? 	  xlocal = 1;		     /* If not a term, then we must be local */ % 	debug(F111,"ttyname",lclnam,xlocal);      } &     if (!CHECK_ERR("ttopen: sys$qiow",; 	sys$qiow(QIOW_EFN, ttychn, IO$_SENSEMODE, &wrk_iosb, 0, 0, 3 		 &ttold, sizeof(ttold), 0, 0, 0, 0))) return(-1);   <     ttspeed = speed = ttispd((unsigned char) wrk_iosb.size);  8 /* Got the line, now set the desired value for local. */       if (*lcl) *lcl = xlocal;       tttvt = ttold;     ttraw = ttold;     debug(F101," lcl","",*lcl);      return(0); }    #ifdef COMMENT /*   Old version. */ unsigned long int + vms_assign_channel(ttname) char *ttname;  {      unsigned int channel = 0; B     struct dsc$descriptor_s d = {0,DSC$K_DTYPE_T,DSC$K_CLASS_S,0};  %     d.dsc$w_length  = strlen(ttname);      d.dsc$a_pointer = ttname; 4     if (!CHECK_ERR("vms_assign_channel: sys$assign",, 	sys$assign(&d, &channel, 0, 0))) return(0);     return(channel); }  #else  /*"   New version from Hunter Goatley. */ unsigned short int= vms_assign_channel(ttname) struct dsc$descriptor_s *ttname; {      unsigned short channel = 0;    #ifdef COMMENT /* what's all this then ... */B     struct dsc$descriptor_s d = {0,DSC$K_DTYPE_T,DSC$K_CLASS_S,0};%     d.dsc$w_length  = strlen(ttname);      d.dsc$a_pointer = ttname;  #endif /* COMMENT */  4     if (!CHECK_ERR("vms_assign_channel: sys$assign",0 	sys$assign(ttname, &channel, 0, 0))) return(0);   #ifdef NEW_STUFF_FROM_BRUCE_DAY  /*#   Which is not presently defined... H   This is supposed to allow C-Kermit to go into protocol mode on an LTA )   device without a prior CONNECT command.  */ #ifdef IO$M_LT_CONNECTJ     vms_status = sys$qiow(QIOW_EFN, channel, IO$_TTY_PORT|IO$M_LT_CONNECT,=                           &wrk_iosb, 0, 0, 0, 0, 0, 0, 0, 0); G     debug(F101, "vms_assign_channel LAT connect status","",vms_status); J     debug(F101, "vms_assign_channel LAT connect iosb","",wrk_iosb.status); #endif /* IO$M_LT_CONNECT */% #endif /* NEW_STUFF_FROM_BRUCE_DAY */        return(channel); }  #endif /* COMMENT */  8 /*  T T C L O S  --  Close the communication device.  */   int  ttclos(ttyfd) int ttyfd; { #ifdef NETCONN.     if (network) {			/* Network connection. */' 	debug(F100,"ttclos closing net","",0);  	netclos();			/* Close it. */ 
 	network = 0;  	return(0);      }  #endif /* NETCONN *//     if (!ttychn) return(0);		/* Wasn't open. */  /*F   Observations indicate that it can take 20-30 seconds for DTR to dropG   after closing the device.  Perhaps a call to tthang() should go here.  */"     ttres();				/* Reset modes. */   /*@   Assume it's a LAT device and try to do a LAT disconnect on it.>   If it fails, then it's not a LAT device and no harm is done. */ #ifdef IO$M_LT_DISCON H     vms_status = sys$qiow(QIOW_EFN, ttychn, IO$_TTY_PORT|IO$M_LT_DISCON,( 			  &wrk_iosb, 0, 0, 0, 0, 0, 0, 0, 0);A     debug(F101, "ttclos LAT disconnect, status", "", vms_status); D     debug(F101, "ttclos LAT disconnect, iosb", "", wrk_iosb.status); #else >     debug(F100, "ttclos LAT disconnect not supported", "", 0); #endif /* IO$M_LT_DISCON */ (     if (!CHECK_ERR("ttclos: sys$dassgn",! 	sys$dassgn(ttychn))) return(-1); +     ttychn = 0;				/* Mark it as closed. */      return(0); }     > /*  T T R E S  --  Restore terminal to its original modes.  */   int - ttres() {				/* Restore the tty to normal. */  #ifdef NETCONNB     if (network) return (0);		/* Network connection, do nothing */ #endif /* NETCONN */  -     if (!ttychn) return(-1);		/* Not open. */   /     tt_cancel();			/* Cancel outstanding I/O */ 8     msleep(250);			/* Wait for pending i/o to finish. */*     debug(F101,"ttres, ttychn","",ttychn);%     if (!CHECK_ERR("ttres: sys$qiow", 9 	sys$qiow(QIOW_EFN, ttychn, IO$_SETMODE, &wrk_iosb, 0, 0, 7     		 &ttold, sizeof(ttold), 0, 0, 0, 0))) return(-1);      return(0); }   8 /*  T T B I N  --  Code shared by ttpkt() and ttvt()  */ /*L   Puts communication device in "binary" mode.  In VMS there's no distinctionN   between device modes for terminal connection, packet operation, and dialing. */
 static int9 ttbin(speed, xflow, xparity) int speed, xflow, xparity; { 
     int s;9     extern int flow;			/* Global flow control variable */    #ifdef NETCONNC     if (network) return(0);		/* Nothing to do on net connections */  #endif /* NETCONN */-     if (!ttychn) return(-1);		/* Not open. */   ;     ttspeed = speed;			/* Keep local copies of arguments */ 0     if (xflow != FLO_DIAL && ttflow != FLO_DIAX)8       ttflow = xflow;			/* for other CKVTIO routines. */     if (xparity > -1) {  	ttprty  = xparity; + 	ttpflg  = 0;			/* Parity not sensed yet */ < 	ttpmsk  = ttprty ? 0177 : 0377;	/* Parity stripping mask */& 	debug(F101,"ttbin ttprty","",ttprty);     } 3     ttraw = ttold;			/* Get a fresh copy of this */   A     if ((s = ttsspd(speed/10)) < 0)	/* Get internal speed code */        s = 0;   /*8  * Log original terminal settings for debugging purposes  */ 9     debug(F101, "original ttraw.basic", "", ttraw.basic); ?     debug(F101, "original ttraw.extended", "", ttraw.extended);    /*?  * Settings based on call parameters flow-control and parity... F  * NOTE: we are using the GLOBAL copy of flow, not our parameter here.F  * This is because the parameter might be FLO_DIAL or FLO_DIALX, which  * is not flow control at all.  */ 4     if (flow == FLO_XONX) {				/* FLOW = XON/XOFF */- 	ttraw.basic |=  (TT$M_HOSTSYNC|TT$M_TTSYNC); 6     } else if (flow == FLO_NONE) {			/* FLOW = NONE */- 	ttraw.basic &= ~(TT$M_HOSTSYNC|TT$M_TTSYNC); 6     } else if (flow == FLO_KEEP) {			/* FLOW = KEEP */ /*>  * Put flow-control paramaters back the way we found them when  * the device was first opened.   */ ! 	if (ttold.basic & TT$M_HOSTSYNC)   	  ttraw.basic |= TT$M_HOSTSYNC; 	else ! 	  ttraw.basic &= ~TT$M_HOSTSYNC;  	if (ttold.basic & TT$M_TTSYNC)  	  ttraw.basic |= TT$M_TTSYNC; 	else  	  ttraw.basic &= ~TT$M_TTSYNC;  /*F   NOTE: any other FLOW-related parameters should also be handled here.C   READSYNC?  And especially if DEC ever implements RTS/CTS or other &   hardware flow control for (Open)VMS. */     }    /*E   EIGHTBIT setting depends on GLOBAL copy of parity variable, not our    parameter. */     if (parity == 0)H       ttraw.basic  |= TT$M_EIGHTBIT;	/* Allow 8-bit data if no parity */     else				/* Otherwise */ 7       ttraw.basic  &= ~TT$M_EIGHTBIT;	/* 7-bit data. */   4     ttraw.basic |= TT$M_NOECHO;		/* Turn off echo */;     ttraw.basic |= TT$M_NOBRDCST;	/* Turn off broadcasts */ ;     ttraw.basic &= ~TT$M_NOTYPEAHD;	/* Enable type-ahead */ D     ttraw.basic &= ~TT$M_ESCAPE;	/* Disable escape-seq processing */@     ttraw.extended &= ~TT2$M_LOCALECHO;	/* Disable local echo */C     ttraw.extended |= TT2$M_PASTHRU;	/* Enable pass-through mode */ G     ttraw.extended |= TT2$M_ALTYPEAHD;	/* Use big type-ahead buffers */    /*2  * Report what we did so we can check for problems  */ 0     debug(F101, "ttraw.basic", "", ttraw.basic);6     debug(F101, "ttraw.extended", "", ttraw.extended);  I     vms_status = sys$qiow(QIOW_EFN, ttychn, IO$_SETMODE, &wrk_iosb, 0, 0, ' 			 &ttraw, sizeof(ttraw), s, 0, 0, 0);   ?     if (vms_status != SS$_NORMAL) {	/* Error queuing request */  	print_msg("ttbin: sys$qiow"); 	return(-1);     } F     if (wrk_iosb.status != SS$_NORMAL) { /* Error executing request */ 	vms_status = wrk_iosb.status;$ 	print_msg("ttbin: sys$qiow(iosb)"); 	return(-1);     }       debug(F100,"ttbin ok","",0);     return(0);				/* All OK */ }   E /*  T T P K T  --  Condition the communication device for packets. */    #ifdef COMMENT< #define DIALING	4		/* Flags (via flow) for modem handling */4 #define CONNECT 5		/* NOT YET IMPLEMENTED IN VMS! */ #endif /* COMMENT */  , /*  Returns 0 on success, -1 on failure.  */   int 8 ttpkt(speed,flow,parity) long speed; int flow, parity; {
     int x;%     debug(F101,"ttpkt flow","",flow); A     x = ttbin(speed,flow,parity);	/* Put device in binary mode */ #     debug(F101,"ttpkt ttbin","",x);      return(x); }   G /*  T T V T  --  Condition communication device terminal connection. */    int ( ttvt(speed,flow) long speed; int flow; {
     int x;$     debug(F101,"ttvt flow","",flow);H     if ((x = ttbin(speed,flow,-1)) > -1) /* Put device in binary mode */       tvtflg = 1; "     debug(F101,"ttvt ttbin","",x);     return(x); }   F /* T T I S P D  -- Return binary baud rate for internal coded speed */   int & ttispd(ispeed) unsigned char ispeed; {
     int s;   #ifdef NETCONN     if (network) return(-1); #endif /* NETCONN */  < /* When the line is set, grab the line speed  and save it */  #     for (s = 0;  ttspeeds[s].dec && # 	(ttspeeds[s].dec != ispeed);  s++)  		;   J /* If speed is zero, then no match.  Set speed to -1 so it is undefined */  @     return(ttspeeds[s].line ? (int) ttspeeds[s].line * 10 : -1); }     H /*  T T S S P D  --  Return the internal baud rate code for 'speed'.  */   int  ttsspd(cps) int cps; {
     int s;     char msg[50];    #ifdef	NETCONN     if (network) return(0);  #endif	/* NETCONN */  /     if (cps <= 0)			/* 026 Unknown cps fails */        return (-1);G     for (s = 0;  ttspeeds[s].line && (ttspeeds[s].line != cps);  s++) ;      if (ttspeeds[s].line) { E         ttspeed = cps * 10L;		/* Make a copy global to this module */ < 	if (ttspeed == 70L)		/* ... in bits per second, not cps, */2 	  ttspeed = 75L;		/* because ttgspd() uses it! */ 	return(ttspeeds[s].dec);      } else {5 	sprintf(msg,"Unsupported line speed - %d\n",cps*10);  	ermsg(msg);& 	ermsg("Current speed not changed\n"); 	return(-1);     }  }      /* Interrupt Functions */     1 /*  C O N I N T  --  Console Interrupt setter  */    static int (*cctrap)();    VOID #ifdef CK_ANSIC * conint(SIGTYP (*f)(int), SIGTYP (*s)(int)) #else % conint(f,s) int (*f)(int), (*s)(int);  #endif /* CK_ANSIC */ . /* conint */ {				/* Set an interrupt trap. */  +     cctrap = f;				/* Make a global copy */ (     debug(F101,"conint batch","",batch);<     if (batch) return;			/* Ignore signals in background. */   #ifdef COMMENT /*    Forget this whole thing. ;    The batch flag should be set in only one place: congm().  */   /*D   Check if invoked in background -- if so signals set to be ignored.<   But VMS has no notion of background, so no worries, right? */     if (!isatty(0)) { 2 	debug(F100,"conint isatty diagnoses batch","",0); #ifdef COMMENT 	batch = backgrd = 1;  #else  /*E   But we still might need to know whether we are running under batch. J   In which case, the test above is probably inadequate.  According to CarlM   Friedberg <friedberg@esb.com>, "I believe this can be done unambiguously by I   checking that (1) SYS$GETJPI returns a null string as the terminal; and M   (2) the current process is NOT a subprocess (a subprocess ALWAYS has a null C   string as its terminal ID). The real test is if PCB$L_STS has the M   PCB$M_BATCH bit set.  If the current process is a subprocess, then the test N   must be repeated for the MASTER (root) process in the job tree.  It is legalL   to run Kermit in a subprocess from within a batch job... and in that case,L   it should still behave like a batch job (no terminal input; must execute a   SET LINE command). */ 	batch = 1; 
 	backgrd = 0;  #endif /* COMMENT */ 	return;     }  #endif /* COMMENT */2     signal(SIGINT,f);			/* Function to trap to. */3     conif = 1;				/* Flag console interrupts on. */  }   9 /*  C O N N O I  --  Reset console terminal interrupts */    VOID) connoi() {				/* Console-no-interrupts */   ;     if (batch) return;			/* must ignore signals in bkgrd */    #ifdef COMMENT /* wrong... */     signal(SIGINT,SIG_DFL);  #else  /* right?.. */     signal(SIGINT,SIG_IGN);  #endif /* COMMENT */     conif = 0; }   G /*  T T O L  --  Write string s, length n, to communication device.  */    #ifndef IO$M_BREAKTHRU #define IO$M_BREAKTHRU	0x0200  #endif /* IO$M_BREAKTHRU */    #ifndef SS$_EXQUOTA    #define SS$_EXQUOTA 28 #endif /* SS$_EXQUOTA */   int  ttol(s,n) int n; CHAR *s; {      int -       remaining,			/* Amount left to write */ 0       size;				/* How much to write this time */6     static int max = 0;			/* Chunk size for writing */   #ifdef NETCONN*     debug(F101,"ttol network","",network);0     if (network)			/* If SET HOST connection, */2 	return(nettol(s,n));		/* call network package. */ #endif /* NETCONN */  % /* It's not a SET HOST connection. */   (     debug(F101,"ttol ttychn","",ttychn);-     if (!ttychn) return(-1);		/* Not open. */ #     debug(F101,"ttol length","",n); "     debug(F101,"ttol max","",max);     1 /* Have we already calculated a chunk size? */         9     if (max == 0) {			/* No, try to send whole packet. */ F 	vms_status = sys$qiow(QIOW_EFN, ttychn, IO$_WRITEVBLK|IO$M_BREAKTHRU,, 			      &wrk_iosb, 0, 0, s, n, 0, 0, 0, 0);  	if (vms_status == SS$_NORMAL) {" 	    debug(F101,"ttol 1 ok","",n); 	    return(n);  	} #ifdef DEBUG 	if (deblog) {			/* Failed. */; 	    debug(F101,"ttol 1 error, vms_status","",vms_status);	 5 	    debug(F101,"ttol 1 iosb size","",wrk_iosb.size); 9 	    debug(F101,"ttol 1 iosb status","",wrk_iosb.status);  	} #endif7 	if (vms_status != SS$_EXQUOTA)	/* "Quota exceeded"? */ 3 	  return(-3);			/* No, something else, give up. */  /*J   Here we should find out what MAXBUF is (not to mention BYTLM, BIOLM, andK   friends), and chop up the packet into pieces accordingly.  But reportedly H   this information, and how to use it (percent overhead, etc), is highlyN   VMS-version-dependent.  So instead we just try different numbers.  Our firstE   attempt keeps dividing it in half until it works, down to about 70.  */ 	do { ( 	    max = (max == 0) ? n / 2 : max / 2;% 	    debug(F101,"ttol 2 max","",max); , 	    vms_status = sys$qiow(QIOW_EFN, ttychn,# 				  IO$_WRITEVBLK|IO$M_BREAKTHRU, + 				  &wrk_iosb, 0, 0, s, max, 0, 0, 0, 0); 6   	    debug(F101,"ttol 2 vms_status","",vms_status); " 	    if (vms_status == SS$_NORMAL)
 	      break; . 	} while (max > 70);		/* 70 is the minimum. */ 	 : 	if (vms_status != SS$_NORMAL)	/* Loop exhausted, fail. */ 	  return(-3);     0     } else {				/* We already calculated max. */  F 	size = (max > n) ? n : max;  	/* Write 1st chunk, but not too much */F 	vms_status = sys$qiow(QIOW_EFN, ttychn, IO$_WRITEVBLK|IO$M_BREAKTHRU,/ 			      &wrk_iosb, 0, 0, s, size, 0, 0, 0, 0); 0 	debug(F101,"ttol 3 vms_status","",vms_status);  	if (vms_status != SS$_NORMAL) 	  return(-3);1 	if (size == n) {		/* (Not strictly necessary) */ $ 	    debug(F101,"ttol 3 done","",n);   	    return(n);  	}       }	 /*    G   We have written the first chunk successfully, now write the remaining F   max-sized chunks, plus the (usually) less-than-max-sized last chunk. */         remaining = n;     while (1) { ! 	s += max;			/* Where to start */ 0 	remaining -= max;		/* How much left to write */= 	size = (remaining < max) ?	/* How much to write this time */  	  remaining : max;  	if (size < 1)			/* Done? */	 	  break;    %   	debug(F101,"ttol 4 size","",size); H   	vms_status = sys$qiow(QIOW_EFN, ttychn, IO$_WRITEVBLK|IO$M_BREAKTHRU,/ 			      &wrk_iosb, 0, 0, s, size, 0, 0, 0, 0); 0 	debug(F101,"ttol 4 vms_status","",vms_status);  	if (vms_status != SS$_NORMAL) 	  return(-3);     } #     debug(F101,"ttol 5 done","",n);      return(n); }   A /*  T T O C  --  Output a character to the communication line  */    int  #ifdef CK_ANSIC  ttoc(char c) #else  ttoc(c) char c;  #endif	/* CK_ANSIC */  /* ttoc */ { #ifdef NETCONN     if (network) { 	return(nettoc(c));      } else { #endif /* NETCONN */ 	debug(F101,"ttoc char","",c); 	if (!ttychn) { - 	    debug(F100,"ttoc ttychn not open","",0); " 	    return(-1);			/* Not open. */ 	}	   	if (CHECK_ERR("ttoc: sys$qiow",@ 		      sys$qiow(QIOW_EFN, ttychn, IO$_WRITEVBLK|IO$M_BREAKTHRU,/ 			       &wrk_iosb, 0, 0, &c, 1, 0, 0, 0, 0))) 
 	  return(0);  #ifdef NETCONN     }  #endif /* NETCONN */     return(-1);  }   H /*  T T _ C A N C E L  --  Cancel i/o on tty channel if not complete  */   VOID
 tt_cancel() { 
     int mask;  #ifdef NETCONN     if (network) return; #endif /* NETCONN */:     CHECK_ERR("tt_cancel: sys$cancel",sys$cancel(ttychn));     tt_queued = 0; }   N /*  C O N _ C A N C E L  --  Cancel i/o on console channel if not complete  */   VOID con_cancel() {
     int mask;   ;     CHECK_ERR("con_cancel: sys$cancel",sys$cancel(conchn));      con_queued = 0;  }   A /*  S N D B R K  --  Send a BREAK signal of the given length.  */    int  sndbrk(msec) int msec; {     int long x = 0;      int brklen; #     struct iosb_struct  tmp_ttiosb;      struct tt_mode ttchr; 7 #ifndef TT$M_BREAK			/* For old VMS with no BREAK... */  /*E   Note: 110 is used instead of 50, because 50 is not supported by all    VAX serial port controllers. */7 #define BRKSPD = 110			/* Speed for simulating BREAK */ @ #define BRKSYM = TT$C_BAUD_110;		/* VMS symbol for this speed */ #endif /* TT$M_BREAK */    #ifdef NETCONN,     if (network) 			/* Send network BREAK */6       return(netbreak());		/* Length doesn't matter */ #endif /* NETCONN */  6     if (!ttychn) return(-1);		/* SET LINE not done. */&     debug(F101,"sndbrk msec","",msec);  #     tt_cancel();			/* Cancel I/O */   : #ifndef TT$M_BREAK			/* VMS doesn't have BREAK function */  @ /* Send the right number of NULs at BREAK-simulation speed... */  O     brklen = ( BRKSPD * 1000 ) / ( msec * 10 ); /* Calculate number of chars */ =     if (brklen > sizeof(brkarray)) brklen = sizeof(brkarray); )     debug(F101,"sndbrk speed","",BRKSPD); *     debug(F101,"sndbrk brklen","",brklen);'     if (!CHECK_ERR("ttsndb: SENSEMODE", ; 	sys$qiow(QIOW_EFN, ttychn, IO$_SENSEMODE, &wrk_iosb, 0, 0, 2 		&ttchr, sizeof(ttchr), 0, 0, 0, 0))) return(-1);(     if (!CHECK_ERR("ttsndb: SETMODE(1)",; 	sys$qiow(QIOW_EFN, ttychn, IO$_SETMODE, &tmp_ttiosb, 0, 0, 7 		&ttchr, sizeof(ttchr), BRKSYM, 0, 0, 0))) return(-1); +     if (!CHECK_ERR("ttsndb: writing nulls", F 	sys$qiow(QIOW_EFN, ttychn, IO$_WRITEVBLK|IO$M_BREAKTHRU, &tmp_ttiosb,= 		 0, 0, (char *) brkarray, brklen, 0, 0, 0, 0))) return(-1); (     if (!CHECK_ERR("ttsndb: SETMODE(2)",; 	sys$qiow(QIOW_EFN, ttychn, IO$_SETMODE, &tmp_ttiosb, 0, 0, > 		&ttchr, sizeof(ttchr), wrk_iosb.size, 0, 0, 0))) return(-1); #else '     if (!CHECK_ERR("ttsndb: SENSEMODE", ; 	sys$qiow(QIOW_EFN, ttychn, IO$_SENSEMODE, &wrk_iosb, 0, 0, 2 		&ttchr, sizeof(ttchr), 0, 0, 0, 0))) return(-1);+     x = TT$M_BREAK;			/* Break signal on */ (     if (!CHECK_ERR("ttsndb: SETMODE(1)",9 	sys$qiow(QIOW_EFN, ttychn, IO$_SETMODE, &wrk_iosb, 0, 0, 2 		&ttchr, sizeof(ttchr), 0, 0, x, 0))) return(-1);8     msleep(msec);			/* Sleep requested amount of time */$     x = 0;				/* Break signal off */(     if (!CHECK_ERR("ttsndb: SETMODE(2)",9 	sys$qiow(QIOW_EFN, ttychn, IO$_SETMODE, &wrk_iosb, 0, 0, 2 		&ttchr, sizeof(ttchr), 0, 0, x, 0))) return(-1); #endif /* TT$M_BREAK */      return(0); }   , /*  T T S N D B  --  Send a BREAK signal  */   int 
 ttsndb() {     return(sndbrk(275)); }   3 /*  T T S N D L B  --  Send a Long BREAK signal  */    int  ttsndlb() {      return(sndbrk(1500));  }   8 /*  T T H A N G  --  Hang up the communications line  */ /*E   Warning: As written, this function DOES NOT WORK on terminal server K   ports.  This is a shortcoming of VMS, confirmed by the Digital Diagnostic L   Center (or whatever DDC stands for).  Someone should add code here to testJ   if the ttychn device is not a real terminal, and if so to handle it someJ   other way, like set the speed to zero for a sec, or close and reopen the	   device.  */ int 
 tthang() {=     if (!xlocal) return(0);		/* Only on local connections. */    #ifdef NETCONN.     if (network) {			/* Network connection. */ 	int x; . 	if (netclos() < 0) return(-1);	/* Close it */         tvtflg = 0;          x = 1;0 	netopen(ttnmsv, &x, ttmdm);	/* Open it again */         return(1);     }  #endif /* NETCONN */  ,     if (!ttychn) return(0);		/* Not open. */  ,     tt_cancel();			/* Cancel pending i/o. */ /*G   This is NOT listed in the VMS Terminal Driver as one of the functions &   that does NOT work with LAT devices. */'     debug(F101,"tthang 1","",gtimer()); &     if (!CHECK_ERR("tthang: sys$qiow",E 	sys$qiow(QIOW_EFN, ttychn, IO$_SETMODE|IO$M_HANGUP, &wrk_iosb, 0, 0, ! 		0, 0, 0, 0, 0, 0))) return(-1);  /*I   The following 3-second sleep is required because the sys$qiow() returns M   immediately, about 2.5 seconds before VMS brings DTR back up.  Without this F   sleep(), DIAL does not work at all if DIAL HANGUP is ON, and, worse,A   subsequent operations on the device can hang the Kermit process    uninterruptibly. */
     sleep(3); '     debug(F101,"tthang 2","",gtimer());      return(1); }   8 /*  M S L E E P  --  Millisecond version of sleep().  */   /*@  Handles intervals up to about 7 minutes (2**32 / 10**7 seconds) */ int  msleep(m) int m; {       struct time_struct { 	long int hi, lo;      } t;       if (m <= 0) return(0);<     t.hi = -10000 * m;  /*  Time in 100-nanosecond units  */     t.lo = -1;(     if (!CHECK_ERR("msleep: sys$schdwk",& 	sys$schdwk(0, 0, &t, 0))) return(-1);     sys$hiber();!     debug(F101,"msleep ok","",m);      return(0); }   2 /*  R T I M E R --  Reset elapsed time counter  */   VOID
 rtimer() {!     tcount = time( (TIME_T *) 0);  }     L /*  G T I M E R --  Get current value of elapsed time counter in seconds  */   int 
 gtimer() {
     int x;.     x = (int) (time( (TIME_T *) 0 ) - tcount);     return( (x < 0) ? 0 : x ); }   . /*  Z T I M E  --  Return date/time string  */   VOID ztime(s) char **s; {     static TIME_T clock; #ifdef COMMENT #ifdef bogus      static char time_string[24];     struct dsc$descriptor_s t = B 	{sizeof(time_string)-1,DSC$K_DTYPE_T,DSC$K_CLASS_S,&time_string};  '     if (!CHECK_ERR("ztime: sys$asctim", & 	sys$asctim(0, &t, 0, 0))) return(-1);'     time_string[t.dsc$w_length] = '\0';      *s = &time_string; #else      char *asctime();     struct tm *tp;       time(&clock);      tp = localtime(&clock);      *s = asctime(tp);  #endif /* bogus */ #else /* not COMMENT */  /*J  Apparently ctime() is available in old C libraries, even though asctime()5  is not.  Let's use the same method for all versions.  */     time(&clock);      *s = ctime(&clock);  #endif /* COMMENT */ }   2 /*  C O N G M  --  Get console terminal modes.  */   /*L  Saves current console mode, and establishes variables for switching between2  current (presumably normal) mode and other modes. */ int 	 congm() {      char s[] = CONDEV_COLON;J     struct itmlst dviitm[] = { {4,DVI$_DEVCLASS,(char *)&dviitm[0].adr,0}, 			{0,0,0,0}}; #ifdef COMMENT /* old */     struct dsc$descriptor_s =       r = {sizeof(s),DSC$K_DTYPE_T,DSC$K_CLASS_S,(char *)&s};  #else /* from ttj */     struct dsc$descriptor_s ;       devnam = {sizeof(s)-1,DSC$K_DTYPE_T,DSC$K_CLASS_S,s};  #endif /* COMMENT */  %     debug(F101,"congm cgmf","",cgmf); <     if (cgmf) return(-1);		/* If called already, then nop */  (     if (!CHECK_ERR("congm: sys$getdviw",F 	sys$getdviw(0, 0, &devnam, &dviitm, &wrk_iosb, 0, 0, 0))) return(-1);J     debug(F101, "congm: devclass", "", (unsigned long int) dviitm[0].adr);8     if ((unsigned long int) dviitm[0].adr != DC$_TERM) { 	batch = 1;      } . #ifdef COMMENT				/* Let's try it anyway... */       else { #endif /* COMMENT */ 	/* ; 	   NOTE: Reportedly, when C-Kermit is run from a .COM file G            it complains "Sorry, terminal type not supported: vt300-80". H            Reportedly, the cure is to execute the following code always,G            not just when the if condition above is false; i.e. just get G            rid of {, } else {, and }.  But some of the following system D            calls look like they might be dangerous on non-terminals,J            so widespread testing would be needed.  Better safe than sorry.
         */1         debug(F101, "congm: conchn", "", conchn); + 	if (!conchn) {			/* Get console channel */ * 	    $DESCRIPTOR(sys_input, CONDEV_COLON);* 	    conchn = vms_assign_channel(&devnam); 	}
 	if (!conchn)  	  return(-1);)         if (!CHECK_ERR("congm: sys$qiow", ?     	sys$qiow(QIOW_EFN, conchn, IO$_SENSEMODE, &wrk_iosb, 0, 0, >     	         &ccold, sizeof(ccold), 0, 0, 0, 0))) return(-1);         ccraw = cccbrk = ccold;  #ifdef COMMENT     }  #endif /* COMMENT */-     cgmf = 1;				/* Flag that we got them. */      return(0); }   1 /*  C O N C B --  Put console in cbreak mode.  */   " /*  Returns 0 if ok, -1 if not  */   int  #ifdef CK_ANSIC  concb(char esc)  #else  concb(esc) char esc; #endif /* CK_ANSIC */ 
 /* concb */ { 
     int x;  '     debug(F101,"concb batch","",batch);      if (batch) return(0); 7     if (!cgmf) congm();			/* Get modes if necessary. */ :     escchr = esc;			/* Make this available to other fns */4     ckxech = 1;				/* Program can echo characters */ /*F   Note: PASTHRU / PASSALL is what is preventing the Ctrl-C trap in theM   main program from working.  This business can be removed without any effect M   at all on the command parser -- everything still works: completion, ?-help, G   editing, etc.  The only problem is that Ctrl-Y is not trapped, so the 7   program dies and leaves the terminal in no-echo mode.  */7     cccbrk.extended |= TT2$M_PASTHRU | TT2$M_ALTYPEAHD;      if (parity) "       cccbrk.basic |= TT$M_NOECHO;     else2       cccbrk.basic |= TT$M_NOECHO | TT$M_EIGHTBIT;E     cccbrk.basic &= ~TT$M_ESCAPE;	/* Disable escape-seq processing */ @     cccbrk.extended &= ~TT2$M_LOCALECHO; /* and local echoing */%     if (!CHECK_ERR("concb: sys$qiow", 9 	sys$qiow(QIOW_EFN, conchn, IO$_SETMODE, &wrk_iosb, 0, 0, =     	    	 &cccbrk, sizeof(cccbrk), 0, 0, 0, 0))) return(-1);       debug(F100,"concb ok","",0);     return(0); }   3 /*  C O N B I N  --  Put console in binary mode  */   " /*  Returns 0 if ok, -1 if not  */   int  #ifdef CK_ANSIC  conbin(char esc) #else  conbin(esc) char esc;  #endif /* CK_ANSIC */  /* conbin */ {  (     debug(F101,"conbin batch","",batch);     if (batch) return(0); 7     if (!cgmf) congm();			/* Get modes if necessary. */ :     escchr = esc;			/* Make this available to other fns */4     ckxech = 1;				/* Program can echo characters */6     ccraw.extended |= TT2$M_PASTHRU | TT2$M_ALTYPEAHD;D     ccraw.basic &= ~TT$M_ESCAPE;	/* Disable escape-seq processing */?     ccraw.extended &= ~TT2$M_LOCALECHO;	/* and local echoing */      if (parity) !       ccraw.basic |= TT$M_NOECHO;      else1       ccraw.basic |= TT$M_NOECHO | TT$M_EIGHTBIT;  #ifdef COMMENT2     ccraw.basic &= ~(TT$M_HOSTSYNC | TT$M_TTSYNC); #endif /* COMMENT */&     if (!CHECK_ERR("conbin: sys$qiow",9 	sys$qiow(QIOW_EFN, conchn, IO$_SETMODE, &wrk_iosb, 0, 0, ;     	    	 &ccraw, sizeof(ccraw), 0, 0, 0, 0))) return(-1);      return(0); }     5 /*  C O N R E S  --  Restore the console terminal  */    int 
 conres() {&     debug(F101,"conres cgmf","",cgmf);<     if (!cgmf) return(0);		/* Do nothing if modes unknown */     if (batch) return(0);        msleep(250);1     ckxech = 0;				/* System should echo chars */ &     if (!CHECK_ERR("conres: sys$qiow",9 	sys$qiow(QIOW_EFN, conchn, IO$_SETMODE, &wrk_iosb, 0, 0, 1 	&ccold, sizeof(ccold), 0, 0, 0, 0))) return(-1); !     debug(F100,"conres ok","",0);      return(0); }     D /*  C O N R E S N E --  Restore the console terminal with No Echo */   int  conresne() {(     debug(F101,"conresne cgmf","",cgmf);?     if (!cgmf) return(0);		/* Don't do anything if modes unk */      if (batch) return(0);        msleep(250);2     ckxech = 1;				/* Program should echo chars */       cctmp = ccold;     cctmp.basic |= TT$M_NOECHO; &     if (!CHECK_ERR("conres: sys$qiow",9 	sys$qiow(QIOW_EFN, conchn, IO$_SETMODE, &wrk_iosb, 0, 0, 1 	&cctmp, sizeof(cctmp), 0, 0, 0, 0))) return(-1); #     debug(F100,"conresne ok","",0);      return(0); }   A /*  C O N O C  --  Output a character to the console terminal  */    int  #ifdef CK_ANSIC 
 conoc(char c)  #else  conoc(c) char c; #endif /* CK_ANSIC */ 
 /* conoc */ {      if (batch) putchar(c);     else" 	if (!CHECK_ERR("conoc: sys$qiow",= 	    sys$qiow(QIOW_EFN, conchn, IO$_WRITEVBLK|IO$M_BREAKTHRU, 8 		     &wrk_iosb, 0, 0, &c, 1, 0, 0, 0, 0))) return(-1);     return(1); }   A /*  C O N X O  --  Write x characters to the console terminal  */    int  conxo(x,s) char *s; int x; {-     if (batch) fprintf(stdout, "%.*s", x, s); *     else if (!CHECK_ERR("conxo: sys$qiow",9 	sys$qiow(QIOW_EFN, conchn, IO$_WRITEVBLK|IO$M_BREAKTHRU, 3 		 &wrk_iosb, 0, 0, s, x, 0, 0, 0, 0))) return(-1);      return(0); }   ; /*  C O N O L  --  Write a line to the console terminal  */    int  conol(s) char *s; {      int len;        if (batch) fputs(s, stdout);
     else { 	len = strlen(s); " 	if (!CHECK_ERR("conol: sys$qiow",H 	    sys$qiow(QIOW_EFN, conchn, IO$_WRITEVBLK|IO$M_BREAKTHRU, &wrk_iosb,. 		     0, 0, s, len, 0, 0, 0, 0))) return(-1);     }      return(1); }   L /*  C O N O L A  --  Write an array of lines to console, with CRLFs added */   int  conola(s) char *s[]; {
     int i;     char t[100], *cp;        for (i=0 ; *s[i] ; i++) {  	strncpy(t,s[i],100); ' 	for (cp = t + strlen(t); --cp >= t;) { & 	    if (*cp != '\n' && *cp != '\r') { 		cp++; + 		*cp++ = '\r'; *cp++ = '\n'; *cp++ = '\0';  		break; 	    } 	} 	if (conol(t) < 0) return(-1);     }      return(0); }   9 /*  C O N O L L  --  Output a string followed by CRLF  */    int  conoll(s) char *s; {
     int x;     x = conol(s);      if (x > -1)        x = conol("\r\n");     return(x); }     A /*  C O N C H K  --  Check if characters available at console  */    int 
 conchk() {     struct { 	unsigned short count; 	unsigned char first;  	unsigned char reserved1;  	long reserved2; 	} t;        if (batch) return(0); (     return(CHECK_ERR("conchk: sys$qiow",E 	sys$qiow(QIOW_EFN, conchn, IO$_SENSEMODE|IO$M_TYPEAHDCNT, &wrk_iosb, 4 		 0, 0, &t, sizeof(t), 0, 0, 0, 0)) ? t.count : 0); }   9 /*  C O N I N C  --  Get a character from the console  */    int > coninc(timo) int timo; {		/* Timo > 0 = timeout in seconds. */     int n = 0;     unsigned char ch;      int func, mask;   &     debug(F101,"coninc timo","",timo);2     debug(F101,"coninc con_queued","",con_queued);       if (batch)       return(getchar());       mask = 1 << CON_EFN;  D     if (con_queued) {		/* If a console read was already posted... */ 				/* e.g. by contti() ... */: 	if (timo > 0) {			    /* If a timeout was specified... */9 	    struct { int hi, lo; } qtime;   /* Set a timer... */ H 	    qtime.hi = -10*1000*1000*timo;  /* in VMS "delta-time" notation. */ /*M   If the timo value is big enough to make the delta-time overflow an integer,    substitute something useful. */  1 	    if (qtime.hi > 0)		/* Did it go positive? */ 6 	      qtime.hi = -0x7fffffff;	/* Yes, so fudge it. */ 	    qtime.lo = -1; D 	    sys$setimr(TIM_EFN, &qtime, 0, 0, 0); /* Specify event flag. */5 	    mask |= TIM_EFN;		/* And add it to read mask. */  	}= 	sys$wflor(CON_EFN, mask);	/* Wait for SETIMR to complete. */ 4 	sys$readef(CON_EFN, &mask);	/* Read event flags. */; 	if (mask & (1 << CON_EFN)) {	/* We got a console event? */ C 	    ch = (unsigned char) conch;	/* (see contti() about this...) */ 9 	    CHECK_ERR("coninc: coniosb.status", coniosb.status);  	    con_queued = 0; 	} else {			/* We didn't */ 3 	    ch = -1;			/* So indicate that coninc() ... */ 0 	    vms_status = SS$_TIMEOUT;	/*  timed out. */ 	}5     } else {				/* Console read not already posted */ $ 	func = IO$_READVBLK | IO$M_NOFILTR;" 	if (timo > 0) func |= IO$M_TIMED; 	CHECK_ERR("coninc: sys$qiow",E 	  sys$qiow(QIOW_EFN, conchn, func, &wrk_iosb,0,0,&ch,1,timo,0,0,0));      }      if (vms_status & 1) { $ 	if (wrk_iosb.status == SS$_TIMEOUT) 	  return(-1);) 	else return( (ch == '\r') ? '\n' : ch );      } else return(-1); }     H /*  V M S _ G E T C H A R -- get a character from the console (no echo).?  *	Since we use raw reads, we must check for ctrl/c, ctrl/y and =  *	ctrl/z ourselves.  We probably should post a "mailbox" for A  *	ctrl/c and ctrl/y so the poor user can abort a runaway Kermit. A  *	Note: this routine intends for ctrl/z (eof) to be "permanent". <  *	Currently, no kermit routine calls "clearerror".  If this1  *	changes, the following code must be rewritten.   */    int  vms_getchar() {      register unsigned int ch;      static int ateof = 0;        if (ateof)       return (EOF);      ch = coninc(0);      switch (ch) {        case ('Y' - 64):       case ('C' - 64): #ifndef COMMENT  /*G   Just call the same handler that signal(SIGINT,xxx) would have invoked F   if Ctrl-C had been trapped.  The pointer to the handler was saved in   cctrap by conint().  */ 	if (cctrap) 	  (*cctrap)(SIGINT,0);  #else 1 	ttclos(ttyfd);			/* Close down other terminal	*/ , 	conres();			/* And cleanup console modes	*/& 	exit(SS$_ABORT);		/* Fatal exit.			*/ #endif /* COMMENT */       case ('Z' - 64): 	ateof = 1;  	return (EOF);         default:
 	return (ch);      }  }   A /*  C O N T T I  --  Get character from console then from tty  */  /*3   This is used in conect() when NO_FORK is defined. C   src is returned with 1 if the character came from the comm. line, C   0 if it was from the console, and with -1 if there was any error.  */ #ifdef TCPIPLIB  /*  * Network/console read posted?   */  static int	nettty_queued	= 0;  static int	netcon_queued	= 0;  #endif /* TCPIPLIB */    int  contti(c, src) int *c, *src; {   #ifndef TCPIPLIB'     int mask = 1<<CON_EFN | 1<<TTY_EFN;      int x; unsigned char cc;   #else /* TCPIPLIB */   #ifdef CMU_TCPIP"     int s;					/* select status */0     fd_set exceptfds;				/* select exceptions */A     static struct timeval timeout;		/* for non-blocking select */  #endif /* CMU_TCPIP */  - #define NET_EFN 7				/* Network event flag */   '     int				mask;		/* Event flag mask */   8     static CHAR			concc;		/* Console and network data */     static CHAR			netcc;  '     static struct iosb_struct	net_iosb; >     static struct iosb_struct	con_iosb;	/* IO status blocks */   /*I   Buffered network data, count, next character.  Declared in CKCNET.C ...  */     extern CHAR			ttibuf[];      extern int			ttibn;	     extern int			ttibp;  #endif /* TCPIPLIB */   1     *src = -1;				/* Assume there was an error */    #ifdef TCPIPLIB 9     if (network) {			/* For active network connections */ # 	debug(F100,"contti network","",0);    	if (ttibn > 0) {  		/*A 		 * Handle the case where data remains in our "internal" buffer.  		 * We need to: 		 *; 		 *	-- Handle the console keyboard (is a character ready?) ; 		 *	-- Return one character from the network buffer if not  		 *) 		 * Post a new console read if necessary  		 */  	        if (!netcon_queued) { #ifdef CMU_TCPIP1 			cmu_stdin_read(IO$_READVBLK, &concc, 1, 0, 0);  #else 3         		if (!CHECK_ERR("contti: console sys$qio", <                     		sys$qio(CON_EFN, conchn, IO$_READVBLK,  					&con_iosb, 0, 0, &concc, 1, 					0, 0, 0, 0))) return(-1); #endif /* CMU_TCPIP */              		netcon_queued = 1; 		}  		/* 		 * Console character ready?  		 */  #ifdef CMU_TCPIP 		exceptfds = mask = 1; 7 		if (select(1, &mask, 0, &exceptfds, &timeout) == 1) {  			/*  			 * check for error  			 */  			if (FD_ISSET(0,&exceptfds)) { 				return(-1);  			} #else +        		(void) sys$readef(CON_EFN, &mask);   % 	        if (mask & (1 << CON_EFN)) {  #endif /* CMU_TCPIP */ 			/*  			 * Yes, return it 			 */ 			netcon_queued = 0;  #ifndef CMU_TCPIP - 		 	if (!CHECK_ERR("contti: con_iosb.status", " 					con_iosb.status)) return(-1); #endif /* CMU_TCPIP */ 			*c   = concc & 0xff;  		    	*src = 0; 		    	return(1);  		}  		/*7 		 * No console data; return buffered network character  		 */ 
 		ttibn--; 		*c   = ttibuf[ttibp++];  		*src = 1;  		return(1); 	} 	/* 4 	 * No buffered data; post network and console reads 	 */         if (!nettty_queued) {  #ifdef CMU_TCPIP 		/*" 		 * network read is always posted 		 */  #else ! /*     -lt.  1992-09-14  begin */ D /* All the event flag numbers should be obtained using lib$get_ef().B  * Using hard coded numbers, especially < 31 is tres dangereuse!!!B  * Be careful, one must also change the event flag cluster used byK  * sys$readef. It is *not* just a simple matter of changing a few #defines.   *F  * At least for DEC TCP/IP Services, socket calls return a proper file>  * descriptor (fd).  OpenVMS system services require a channelK  * (from sys$assign).  The two are *not* the same.  The call vaxc$get_sdc() *  * maps from a DEC TCP/IP fd to a channel.  *H  * This is "gag me with a spoon" code, but it gets thing up and running.  *  */  #ifdef DEC_TCPIP   	{ 	   static int last_ttyfd = -1; # 	   static short int net_chan = -1;    	if (ttyfd != last_ttyfd){ 		last_ttyfd = ttyfd;  #ifdef COMMENT
 #ifdef __DECC . 		net_chan = (short) decc$get_sdc(last_ttyfd); #else  #ifdef VAXC & 		net_chan = vaxc$get_sdc(last_ttyfd); #else 8 #		error CALL TO GET_SDC requires DECC or VAXC compiler! #endif	/* VAXC */  # endif	/* DECC */ #else /* COMMENT */ ! 		net_chan = GET_SDC(last_ttyfd);  #endif /* COMMENT */     		}   5             if (!CHECK_ERR("contti: network sys$qio", M                     sys$qio(NET_EFN, net_chan, IO$_READVBLK, &net_iosb, 0, 0, @                             &netcc, 1, 0, 0, 0, 0))) return(-1);     	}   #else /* Not DEC_TCPIP */   5             if (!CHECK_ERR("contti: network sys$qio", J                     sys$qio(NET_EFN, ttyfd, IO$_READVBLK, &net_iosb, 0, 0,@                             &netcc, 1, 0, 0, 0, 0))) return(-1); #endif /* DEC_TCPIP */ #endif /* CMU_TCPIP */ 	    nettty_queued = 1;  	}           if (!netcon_queued) {  #ifdef CMU_TCPIP3 	    cmu_stdin_read(IO$_READVBLK, &concc, 1, 0, 0);  #else 5             if (!CHECK_ERR("contti: console sys$qio", E                     sys$qio(CON_EFN, conchn, IO$_READVBLK, &con_iosb, 1 			    0, 0, &concc, 1, 0, 0, 0, 0))) return(-1);  #endif /* CMU_TCPIP */             netcon_queued = 1; 	} 	/*  	 * Wait for a character 	 */ #ifdef CMU_TCPIP% 	exceptfds = mask = (1 | (1<<ttyfd)); B 	s = select(ttyfd, &mask, 0, &exceptfds, 0); /*a blocking select*/   	if (FD_ISSET(0,&exceptfds)) 	    return(-1);    	if (FD_ISSET(ttyfd,&exceptfds)) 	    return(-1);   	if (FD_ISSET(0,&mask)) {  	    *c   	  = concc & 0xff; 	    *src 	  = 0;  	    netcon_queued = 0;  	} 	else { ! 	    if (FD_ISSET(ttyfd,&mask)) { ! 		s = cmu_read(ttyfd, &netcc, 1); 
 		if (s <= 0)  		    return(-1);  		*c   	  = netcc & 0xff;  		*src 	  = 1; 		nettty_queued = 0; 	    	}  	} #else ,     	mask = (1 << CON_EFN) | (1 << NET_EFN);  +         if (!CHECK_ERR("contti: sys$wflor", 4             		sys$wflor(CON_EFN, mask))) return(-1);  ,         if (!CHECK_ERR("contti: sys$readef",6             		sys$readef(CON_EFN, &mask))) return(-1);  $         if (mask & (1 << CON_EFN)) { 	    /*  	     * Console  	     */5             if (!CHECK_ERR("contti: con_iosb.status", $ 			    con_iosb.status)) return(-1);  #             *c   	  = concc & 0xff;  	    *src 	  = 0;              netcon_queued = 0;  +         } else if (mask & (1 << NET_EFN)) {  	    /*  	     * Network  	     */" 	    if (!(net_iosb.status & 1)) { 		/* 		 * Network read error  		 */ 
 #ifdef WINTCP 0 		_$set_vaxc_error(SS$_NORMAL, net_iosb.status);( 		win$perror("contti: net_iosb.status"); #else  #ifdef MULTINET  #ifdef COMMENT /*?   When user hangs up, this prints an unnecessary scary message,    like "Operation would block."  */+ 		socket_perror("contti: net_iosb.status");  #endif /* COMMENT */ #endif /* MULTINET */  #endif /* WINTCP */ 
 		return(-1);  	    }   	    if (net_iosb.size == 0) { 		/* 		 * Handle reset from remote  		 */ 
 		return(-1);  	    } 	    *c   	  = netcc & 0xff; 	    *src 	  = 1;              nettty_queued = 0;	         }  #endif /* CMU_TCPIP */     } else				/* Not network */  #endif /* TCPIPLIB */    /*I   Should we worry about a network connection that's running under BATCH ?  */     if (batch) {			/* Batch? */ ! 	debug(F100,"contti batch","",0);  	if ((*c = getchar()) != EOF) {  	    *src = 0;	 	} else {  	    *src = 1; 	    *c = ttinc(0);  	}1     } else {				/* Interactive but not network */   
 #ifdef TTXBUF 6 	if (ttxbn > 0) {		/* Buffered port chars available */  = /* Post a read on the console if one is not posted already */    	    if (!con_queued) { + 		if (!CHECK_ERR("contti: console sys$qio", . 			     sys$qio(CON_EFN, conchn, IO$_READVBLK, 				     &coniosb, 0, 0,! 				     &conch, 1, 0, 0, 0, 0)))  		  return(-1);  		con_queued = 1;  	    }  E /* See if a console character has been read and if so, return it.  */   ' 	    (void) sys$readef(CON_EFN, &mask); ! 	    if (mask & (1 << CON_EFN)) {  		con_queued = 0; * 		if (!CHECK_ERR("contti: coniosb.status", 			       coniosb.status)) 		  return(-1);  		*c   = conch & 0xff; 		*src = 0;  		return(1); 	    }  = /* No console character, so return buffered port character */    	    *c = ttinc(0);  	    *src = 1; 	    return(1);  	}  C /* No buffered port data; post both network and console reads... */    #endif /* TTXBUF */   8         mask = 1<<CON_EFN | 1<<TTY_EFN;	/* Event mask */  / 	debug(F101,"contti interactive mask","",mask);   <         if (!con_queued) {		/* Console read not queued... */5             if (!CHECK_ERR("contti: console sys$qio", < 		    sys$qio(CON_EFN, conchn, IO$_READVBLK, &coniosb, 0, 0,8                     &conch, 1, 0, 0, 0, 0))) return(-1); 	    con_queued = 1;* 	    debug(F100,"contti con_queued","",0); 	}5         if (!tt_queued) {		/* Port read not queued */ 1             if (!CHECK_ERR("contti: tty sys$qio", A             sys$qio(TTY_EFN, ttychn, IO$_READVBLK, &ttiosb, 0, 0, 7                     &ttch, 1, 0, 0, 0, 0))) return(-1);  	    tt_queued = 1; ) 	    debug(F100,"contti tt_queued","",0);  	}  2 /* Wait for one of the queued reads to complete */  +         if (!CHECK_ERR("contti: sys$wflor", 2             sys$wflor(CON_EFN, mask))) return(-1);( 	debug(F100,"contti sys$wflor ok","",0);  : /* Read the event flags to see which read was completed */  ,         if (!CHECK_ERR("contti: sys$readef",6             sys$readef(CON_EFN, &mask))) return(-1);		) 	debug(F100,"contti sys$readef ok","",0);     F /* Return the character with the appropriate source (src) indicator */  6         if (!(*src = ((mask & 1<<CON_EFN) ? 0 : 1))) {             *c = conch; @             CHECK_ERR("contti: coniosb.status", coniosb.status);             con_queued = 0;          } else {/             *c = (ttprty ? ttch & 0177 : ttch); ' 	    if (ttiosb.status == SS$_HANGUP) { ; 		fprintf(stderr,"\n%%CKERMIT-F-HANGUP, data set hang-up");  		*src = -1; 		return(1); 	    }>             CHECK_ERR("contti: ttiosb.status", ttiosb.status);             tt_queued = 0;	         } )         if (!(vms_status & 1)) *src = -1;      } &     debug(F101,"contti *src","",*src);      return((*src > -1) ? 1 : 0); }    /*
   C A N C I O B   Cancel pending I/O requests on console and communication device. */ VOID cancio()  {  #ifdef NETCONN     if (network) { #ifdef TCPIPLIB  #ifdef DEC_TCPIP 	short int net_chan = -1;  #ifdef COMMENT
 #ifdef __DECC ( 	net_chan = (short) decc$get_sdc(ttyfd); #else  /* !__DECC */ #ifdef VAXC   	net_chan = vaxc$get_sdc(ttyfd); #else  /* !VAXC */7 # error CALL TO GET_SDC requires DECC or VAXC compiler!  #endif /* VAXC */  #endif /* __DECC */  #else  /* COMMENT */ 	net_chan = GET_SDC(ttyfd);  #endif /* COMMENT */7         if (nettty_queued) (void) sys$cancel(net_chan);  #else  /* DEC_TCPIP */ #ifdef CMU_TCPIP>     /* not going to do this when CMU is the network transport.8      * the sys$cancel will cause the channel to shutdown      *@      * if (nettty_queued) (void) sys$cancel(cmu_get_sdc(ttyfd));      */  #else  /* !CMU_TCPIP */ 3        if (nettty_queued) (void) sys$cancel(ttyfd);  #endif /* CMU_TCPIP */ #endif /* DEC_TCPIP */5         if (netcon_queued) (void) sys$cancel(conchn);            netcon_queued = 0;         nettty_queued = 0; 	return; #else /* Not TCPIPLIB */ 	return; #endif /* TCPIPLIB */      }  #endif /* NETCONN */       if (!batch) { /         CHECK_ERR("cancio: console sys$cancel",               sys$cancel(conchn));+         CHECK_ERR("cancio: tty sys$cancel",               sys$cancel(ttychn));         con_queued = 0;          tt_queued = 0;     }  }    /* get_qio_maxbuf_size()  *E  * Get maximum size of QIO that can occur without getting the dreaded   * exceeded quota status.   */    #ifndef SYI$_MAXBUF  #define SYI$_MAXBUF 4175 #endif /* SYI$_MAXBUF */   int 7 get_qio_maxbuf_size(ttychn) unsigned long int ttychn; {      unsigned char *tmpbuf;     int unsigned long max=0;>     struct itmlst syiitm[] = { {2,SYI$_MAXBUF,(char *)&max,0},     		{0,0,0,0}};        if (!ttychn) return(-1);  6     if (!CHECK_ERR("get_qio_maxbuf_size: sys$getsyiw", 	sys$getsyiw(	 0	/* efn */ 			,0	/* csidadr */  			,0	/* nodename */ 			,&syiitm /* itmlst */ 			,&wrk_iosb /* iosb */ 			,0	/* astadr */ 			,0)))	/* astprm */ $ 		exit(SS$_ABORT);		/* Fatal exit */        if (!(tmpbuf = malloc(max))) 	return(0);         for (; max > 0; max -= 16) {D 	if (!test_qio(ttychn,max,tmpbuf)) /* (was &tmpbuf, caused crash) */ 	{ 	    free(tmpbuf); 	    return(max);  	}     }        free(tmpbuf); M     printf("\n%%CKERMIT-F-get_qio_maxbuf_size, Could not get maxbuf size\n"); &     exit(SS$_ABORT);		/* Fatal exit */ }    int  test_qio(ttychn,max,dest)  unsigned long int ttychn; 
 long int max;  unsigned char *dest; { !     static int trmmsk[2] = {0,0};    /*    trmmsk[1] = 1 << eol; */  D     vms_status = sys$qiow(QIOW_EFN, ttychn, IO$_READVBLK|IO$M_TIMED,3 			  &wrk_iosb, 0, 0, dest, max, 0, &trmmsk, 0, 0);       return( !(vms_status & 1) ||= 	(!(wrk_iosb.status & 1)) && wrk_iosb.status != SS$_TIMEOUT);  }      /*  * Flush tt output buffer   */    int 
 ttfluo() {  
     long n=0;    #ifdef NETCONN     if (network) return(0);  #endif /* NETCONN */  -     if (!ttychn) return(-1);		/* Not open. */   &     if (!CHECK_ERR("ttfluo: sys$qiow",? 	sys$qiow(QIOW_EFN, ttychn, IO$_READVBLK|IO$M_TIMED|IO$M_PURGE, * 		 &wrk_iosb, 0, 0, &n, 0, 0, 0, 0, 0))) { 	perror("flush failed"); 	return(-1); 	}     return(0); }   * /*  T T G M D M  --  Get modem signals  */ /*J  Looks for the modem signals CTS, DSR, and CTS, and returns those that areL  on in as its return value, in a bit mask as described for ttwmdm.  Returns:  -3 Not implemented +  -2 if the line does not have modem control 
  -1 on error. K  >= 0 on success, with a bit mask containing the modem signals that are on.  */ int 
 ttgmdm() {     struct { 	unsigned char type; 	unsigned char spare1; 	unsigned char modem;  	unsigned char spare2; 	unsigned long filler;     } mdminfo;     int retval;    #ifdef NETCONN     if (network) return(-2); #endif /* NETCONN */H     vms_status = sys$qiow(QIOW_EFN, ttychn, IO$_SENSEMODE|IO$M_RD_MODEM,/ 			  &wrk_iosb, 0, 0, &mdminfo, 0, 0, 0, 0, 0);   #     if (vms_status != SS$_NORMAL) { : 	debug(F101,"ttgmdm serious error, status","",vms_status); 	return(-1);     }   1     debug(F101,"ttgmdm iosb","",wrk_iosb.status); .     debug(F101,"ttgmdm type","",mdminfo.type);0     debug(F101,"ttgmdm modem","",mdminfo.modem);  (     if (wrk_iosb.status != SS$_NORMAL) {< 	debug(F101,"ttgmdm iosb error, status","",wrk_iosb.status); 	return(-1);     }    #ifdef DT$_LAT"     if (mdminfo.type == DT$_LAT) {6 	debug(F101,"ttgmdm LAT port, no modem control","",0); 	return(-2);     }  #endif /* DT$_LAT */       if (mdminfo.type == 0) {= 	debug(F101,"ttgmdm unknown driver, modem","",mdminfo.modem);  	return(-2);     }   A     retval = BM_DTR | BM_RTS;		/* Not visible, set by TTDRIVER */ $     if (mdminfo.modem & TT$M_DS_CTS) 	retval |= BM_CTS;$     if (mdminfo.modem & TT$M_DS_DSR) 	retval |= BM_DSR;(     if (mdminfo.modem & TT$M_DS_CARRIER) 	retval |= BM_DCD;%     if (mdminfo.modem & TT$M_DS_RING)  	retval |= BM_RNG;     return(retval);  }    /*K   Return serial communication device speed.  Speed is retreived from a qiow J   initially.  It is then changed only at user request.  (Yes, but it wouldM   still be better to do another qiow here to actually read the speed from the 6   device so we know it is what we think it should be!) */ long
 ttgspd() {     extern int speed;  #ifdef NETCONN<     if (network) return(-1);		/* -1 if network connection */ #endif /* NETCONN */     return(ttspeed); }     I /*  T T S C A R R  --  Set ttcarr variable, controlling carrier handling.   *I  *  0 = Off: Always ignore carrier. E.g. you can connect without carrier. O  *  1 = On: Heed carrier, except during dialing. Carrier loss gives disconnect. 4  *  2 = Auto: For "modem direct": The same as "Off".K  *            For real modem types: Heed carrier during connect, but ignore M  *                it anytime else.  Compatible with pre-5A C-Kermit versions.   *M  * As you can see, this setting does not affect dialing, which always ignores L  * carrier (unless there is some special exception for some modem type).  ItK  * does affect ttopen() if it is set before ttopen() is used.  This setting J  * takes effect on the next call to ttopen()/ttpkt()/ttvt().  And they areI  * (or should be) always called before any communications is tried, which =  * means that, practically speaking, the effect is immediate.   *B  * Of course, nothing of this applies to remote mode (xlocal = 0).  *F  * Someone has yet to uncover how to manipulate the carrier in the BSDL  * environment (or any non-termio using environment).  Until that time, this"  * will simply be a no-op for BSD.  *L  * Note that in previous versions, the carrier was most often left unchangedK  * in ttpkt()/ttvt() unless they were called with DIALING or CONNECT.  This I  * has changed.  Now it is controlled by ttcarr in conjunction with these 	  * modes.   */  int  ttscarr(carrier) int carrier; {        return(-1);  }    int  psuspend(x) int x; {       return(-1);  }    #ifdef CK_CURSES /*-   tgetent() support for VMS curses emulation. +   Used by all three VMS fullscreen methods. 8   Called from "SET FILE DISPLAY FULLSCREEN" in ckuus7.c. */( int isvt52 = 0;				/* VT52/VT1xx flag */   int $ tgetent(lp, term) char *lp, *term; {6     debug(F101,"tgetent terminal type","",ccold.type);>     debug(F101,"tgetent terminal extended","",ccold.extended);  ?     if ((ccold.type == DT$_VT5X) || (ccold.type == DT$_VT55)) { ! 	debug(F100,"tgetent VT5x","",0);  	isvt52 = 1; 	return(1);      } <     if ((ccold.extended & TT2$M_ANSICRT) == TT2$M_ANSICRT) {$ 	debug(F100,"tgetent ANSICRT","",0); 	isvt52 = 0; 	return(1);      } :     if ((ccold.extended & TT2$M_DECCRT) == TT2$M_DECCRT) {# 	debug(F100,"tgetent DECCRT","",0);  	isvt52 = 0; 	return(1);      } 5     return(0);				/* Not a supported terminal type */  }  #endif /* CK_CURSES */