! MMS description file for LIBHTMLW
! Bjorn S. Nilsson, Aleph, CERN, 20-Nov-1993
! (Mosaic version 2.0)
!
! Usage:
!       $ MMS                           for DEC/UCX
!       $ MMS/MACRO=(MULTINET=1)        for Multinet
! Add a DEBUG=1 macro when debugging.
! Add a AXP=1 macro when compiling on AXP platforms.
!
! You may have to use the /IGNORE=WARNING qualifier to make MMS run all
! the way through if you get (acceptable) compilation warnings.
!

CC = cc/warn=NOINFO
LIBTARGET = libhtmlw.olb

.IFDEF AXP
CQUALAXP=/Standard=VAXC
.ELSE
CQUALAXP=
.ENDIF

.IFDEF DEBUG
CQUAL = /NoOpt/Debug$(CQUALAXP)
.ELSE
CQUAL = $(CQUALAXP)
.ENDIF

.IFDEF MULTINET
CDEFS = /DEFINE=(MOTIF,XMOSAIC,MULTINET)
.ELSE
CDEFS = /DEFINE=(MOTIF,XMOSAIC,UCX)
.ENDIF

.FIRST
      Define Sys SYS$Library

MODULES =  HTML HTMLlists HTMLformat HTMLparse HTMLimages HTMLwidgets \
 HTML-PSformat HTMLjot

CFILES = $(MODULES:=.c)

OBJECTS = $(CFILES:.c=.obj)

$(LIBTARGET) : $(LIBTARGET)($(MODULES)) $(OBJECTS)
	@ Write SYS$Output "Library libhtmlw.olb built."

.c.obj :
	$(CC)$(CDEFS)$(CQUAL) $*.c

clean :
	Delete/Log *.OBJ;*
	Delete/Log $(LIBTARGET);*

