! MMS description file for LIBWWW2
! Bjorn S. Nilsson, Aleph, CERN, 20-Nov-1993
! (Mosaic version 2.0)
!
! Usage:
!       $ MMS                           for DEC/UCX
!       $ MMS/MACRO=(MULTINET=1)        for Multinet
! Add a DEBUG=1 MACRO when debugging.
! Add a AXP=1   MACRO when compiling on AXP platforms.
!
! You may have to use the /IGNORE=WARNING qualifier to make MMS run all
! the way through if you get (acceptable) compilation warnings.
!

CC = CC/warn=noinfo
LIBTARGET = libwww.olb

ADD_DEFS =
!ADD_DEFS = ,DIRECT_WAIS

.IFDEF AXP
CQUALAXP=/Standard=VAXC
.ELSE
CQUALAXP=
.ENDIF

.IFDEF DEBUG
CQUAL = /NoOpt/Debug$(CQUALAXP)
CDEBUGDEF = ,DEBUG
.ELSE
CQUAL = $(CQUALAXP)
CDEBUGDEF =
.ENDIF

.IFDEF MULTINET
CDEFS = /Define=(MULTINET$(CDEBUGDEF) $(ADD_DEFS))
.ELSE
CDEFS = /Define=(UCX$(CDEBUGDEF) $(ADD_DEFS))
.ENDIF

MODULES = \
 HTAccess \
 HTAlert \
 HTAnchor \
 HTAtom \
 HTSort \
 HTChunk \
 HTFTP \
 HTFWriter \
 HTFile \
 HTFormat \
 HTGopher \
 HTInit \
 HTList \
 HTMIME \
 HTML \
 HTMLDTD \
 HTMLGen \
 HTNews \
 HTParse \
 HTPlain \
 HTMosaicHTML \
 HTString \
 HTTCP \
 HTTP \
 HTTelnet \
 HTWSRC \
 HTWriter \
 SGML \
 HTIcon \
 HTCompressed \
 HTAAUtil \
 HTAssoc \
 HTUU \
 HTAABrow

CFILES = $(MODULES:=.c)

OBJECTS = $(CFILES:.c=.obj)

$(LIBTARGET) : $(LIBTARGET)($(MODULES)) $(OBJECTS)
	@ Write SYS$Output "Library libwww.obj built."

.c.obj :
	$(CC)$(CDEFS)$(CQUAL) $*.C

clean :
	Delete/Log *.OBJ;*
	Delete/Log $(LIBTARGET);*

