! MMS description file for LIBXMX
! Bjorn S. Nilsson, Aleph, CERN, 20-Nov-1993
! (Mosaic version 2.0)
!
! Usage:
!       $ MMS                           for DEC/UCX
!       $ MMS/MACRO=(MULTINET=1)        for Multinet
! Add a DEBUG=1 MACRO when debugging.
! Add a AXP=1   MACRO when compiling on AXP platforms.
!
! You may have to use the /IGNORE=WARNING qualifier to make MMS run all
! the way through if you get (acceptable) compilation warnings.
!

CC = CC/warn=noinfo
LIBTARGET = libxmx.olb

.IFDEF AXP
CQUALAXP=/Standard=VAXC
.ELSE
CQUALAXP=
.ENDIF

.IFDEF DEBUG
CQUAL = /NoOpt/Debug$(CQUALAXP)
.ELSE
CQUAL = $(CQUALAXP)
.ENDIF

.IFDEF MULTINET
CDEFS = /Define=MULTINET
.ELSE
CDEFS = /Define=(UCX)
.ENDIF

MODULES =  Xmx Xmx2

CFILES = $(MODULES:=.c)

OBJECTS = $(CFILES:.c=.obj)

$(LIBTARGET) : $(LIBTARGET)($(MODULES)) $(OBJECTS)
	@ Write SYS$Output "Library libXmx.olb built."

.c.obj :
	$(CC)$(CQUAL)$(CDEFS) $*.C

clean :
	Delete/Log *.OBJ;*
	Delete/Log $(LIBTARGET);*

