! MMS description file for Mosaic
! Bjorn S. Nilsson, Aleph, CERN, 21-Nov-1993
! (Mosaic version 2.0)
!
! Usage:
!       $ MMS                           for DEC/UCX
!       $ MMS/MACRO=(MULTINET=1)        for Multinet
! Add a DEBUG=1 macro when debugging.
! Add a AXP=1 macro when compiling on AXP platforms.
!
! You may have to use the /IGNORE=WARNING qualifier to make MMS run all
! the way through if you get (acceptable) compilation warnings.
!

! If your server does not have 17 pt fonts or Lucida fonts, keep the next line.
VMS_DEFS = NO_17_PT,NO_LUCIDA,

!CC = CC/warn=noinfo

.IFDEF AXP
NAME = MOSAIC-24A-AXP
CQUALAXP=/Standard=VAXC
.ELSE
NAME = MOSAIC-24A-VAX
CQUALAXP=
.ENDIF

.IFDEF DEBUG
CQUAL =/NoOpt/Debug$(CQUALAXP)
LINK_OPTIONS =/Debug
.ELSE
CQUAL =$(CQUALAXP)
LINK_OPTIONS =/NoDebug/Trace
.ENDIF

.IFDEF MULTINET
.IFDEF DEBUG
CDEFS =/Define=($(VMS_DEFS)MULTINET,DEBUGVMS)
.ELSE
CDEFS =/Define=($(VMS_DEFS)MULTINET,HOME_PAGE_DEFAULT="""http://www.memphis.edu""")
.ENDIF
OPTION_FILE = Multinet.Opt
TCP=MULTINET
.ELSE
.IFDEF DEBUG
CDEFS =/Define=($(VMS_DEFS)UCX,DEBUGVMS)
.ELSE
CDEFS =/Define=($(VMS_DEFS)UCX)
.ENDIF
.IFDEF AXP
OPTION_FILE = UCX-axp.Opt
.ELSE
OPTION_FILE = UCX.Opt
.ENDIF
TCP=UCX
.ENDIF
LIBS = $(OPTION_FILE)/Opt

.FIRST
	@ Define Sys SYS$Library
	@ Topdir = F$Environment("Default")-"SRC]"
	@ Define LIBWWW2  'Topdir'LIBWWW2]
	@ Define LIBXMX   'Topdir'LIBXMX]
	@ Define LIBHTMLW 'Topdir'LIBHTMLW]
	@ Define BITMAPS 'Topdir'.SRC.BITMAPS]
.IFDEF MULTINET
.ELSE
	@ Define Netinet SYS$Library
.ENDIF
.IFDEF AXP
	@ Define DECC$User_Include 'F$Environment("Default")',LIBWWW2,LIBHTMLW,LIBXMX,SYS$Library
	@ Define DECC$System_Include 'F$Environment("Default")',LIBWWW2,LIBHTMLW,LIBXMX,SYS$Library
.ELSE
	@ Define VAXC$Include 'F$Environment("Default")',LIBWWW2,LIBHTMLW,LIBXMX,SYS$Library
	@ Define C$Include 'F$Environment("Default")',LIBWWW2,LIBHTMLW,LIBXMX,SYS$Library
.ENDIF

PROG_LIBS = [-.LIBHTMLW]LIBHTMLW.OLB, [-.LIBXMX]LIBXMX.OLB, [-.LIBWWW2]LIBWWW.OLB
PROG_LIBSQ = [-.LIBHTMLW]LIBHTMLW.OLB/LIB, [-.LIBXMX]LIBXMX.OLB/LIB, [-.LIBWWW2]LIBWWW.OLB/LIB

CFILES = main.c gui.c gui-dialogs.c gui-menubar.c gui-documents.c mo-www.c\
  mo-dtm.c hotlist.c whine.c history.c\
  annotate.c pan.c grpan.c grpan-www.c audan.c globalhist.c img.c\
  picread.c xpmhash.c xpmread.c gifread.c pixmaps.c\
  medcut.c mo-hdf.c vms.c
OBJS = main.obj,gui.obj,gui-dialogs.obj,gui-menubar.obj,gui-documents.obj,mo-www.obj,\
  mo-dtm.obj,hotlist.obj,whine.obj,history.obj,\
  annotate.obj,pan.obj,grpan.obj,grpan-www.obj,audan.obj,globalhist.obj,img.obj,\
  picread.obj,xpmhash.obj,xpmread.obj,gifread.obj,pixmaps.obj,\
  medcut.obj,mo-hdf.obj,vms.obj

!AUXCFILES = hdf-browse.c
!AUXOBJS = hdf-browse.obj
AUXCFILES =
AUXOBJS =

HFILES = mosaic.h

$(NAME).exe : $(OBJS) $(AUXOBJS) $(PROG_LIBS)
	LINK$(LINK_OPTIONS)/Exe=$(NAME).exe $(OBJS),$(PROG_LIBSQ),[]$(LIBS)
!	LINK$(LINK_OPTIONS)/Exe=$(NAME).exe $(OBJS)$(AUXOBJS),$(PROG_LIBSQ),[]$(LIBS)
	@ Write SYS$Output "Linking done. Welcome to VMS Mosaic 2.4A"

$(OBJS) : $(HFILES)

gui.obj : xresources.h

hdf-browse.obj : hdf-browse.c [-.libhtmlw]HTML.h
	$(CC)$(CDEFS)$(CQUAL) hdf-browse.c

.c.obj :
	$(CC)$(CDEFS)$(CQUAL) $*.C

clean :
	Delete/Log *.OBJ;*

