/*
 * Emulate UNIX functions required by mosaic.
 */
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include descrip

#define DEBUG 1

FILE *popen ( char *cmd, char *type ) { return (FILE *) 0; };

void pclose ( int stream ) { return; }

#ifdef OSU
int getpwuid ( int uid ) { return 0; };
#endif /* OSU -- RJF */

/*****************************************************************************/
#ifdef fopen
#undef fopen
#endif
FILE *fopen_vms ( const char *fspec, const char *mode )
{
    int i, j, colon, lbrack, rbrack, slash;
    char tmpbuf[256];
    /*
     * Scan file spec and see if it needs fixed up.
     */
#ifdef DEBUG
    printf("/vms/ fopen_vms: '%s' '%s'\n", fspec, mode );
#endif
    if ( *fspec == '#' ) {
	printf("/vms/ bugcheck, attempt to open workfile %s\n", fspec);
	return 0;
    }
    colon = lbrack = rbrack = -1; slash = 0;
    for ( i = 0; fspec[i]; i++ ) {
        char letter = fspec[i];
	if ( letter == '/' ) slash++;
	else if ( (letter == '[') || (letter == '<') ) lbrack = i;
	else if ( (letter == ']') || (letter == '>') ) rbrack = i;
	else if ( letter == ':' ) colon = i;
    }
    if ( (slash > 0) && ((colon >= 0) || (lbrack >= 0) || (rbrack >= 0)) ) {
	/*
	 * Replace slashes with VMS dir spec.
	 */
	char *optr;
	optr = tmpbuf;
	if ( i > sizeof(tmpbuf) ) i = sizeof(tmpbuf);
	for ( j = 0; j < i; j++ ) {
	    *optr = fspec[j];
	    if ( *optr == '/' ) {
		--slash;
		if ( slash > 0 ) {
		   /* slash delimits intermediate directories */
		    if ( lbrack < 0 ) *optr = '[';
		    else if ( j == (rbrack+1) ) {
			/* "[dir]/dir" case. */
			--optr; *optr = '.';
		    } else *optr = '.';
		    /* Change .something dirs non-dot name */
		    if ( fspec[j+1] == '.' ) j++;
		} else {
		    /* Last slash */
		    if ( rbrack >= 0 ) *optr = fspec[rbrack];
		    else *optr = ']';
		    if ( (j == (colon+1)) || (j == (rbrack+1)) ) --optr;
		}
	    }
	    optr++;
	}
	*optr = '\0';
	fspec = tmpbuf;
#ifdef DEBUG
	printf("             Re-vamped fspec: '%s'\n", fspec );
#endif
    }

    return fopen ( fspec, mode, "mbc=64" );
}

#ifdef OSU
/*****************************************************************************/
/* Make jacket routine for system() calls.  Intercept rm commands and handle
 * internally.  
 */
#ifdef system
#undef system
#endif
int system_vms ( const char *command )
{
    int cmdlen, background, status, lib$spawn();
    static int cmd_alloc = 0;
    static char *cmd;
    char vms_cmd[256];
    $DESCRIPTOR(vms_cmd_dx, vms_cmd);
    /*
     * Make local copy of command string that we can edit.
     */
    cmdlen = strlen ( command );
    if ( cmdlen + 100 > cmd_alloc ) {
	if ( cmd_alloc > 0 ) free ( cmd );
	cmd = malloc ( cmdlen + 100 );
    }
    strcpy ( cmd, command );
    /*
     * Trim trailing ampersand and whitespace
     */
    background = 0;
    while ( cmdlen > 0 ) {
	if ( cmd[cmdlen-1] == '&' ) background = 1;
	else if ( !isspace(cmd[cmdlen-1]) ) break;
	--cmdlen;
    }
    cmd[cmdlen] = '\0';
    if ( cmdlen <= 0 ) return 0;
    /*
     * see if cmd is /bin/rm and handle internally.
     */
    if ( (cmdlen > 8) && (strncmp ( "/bin/rm ", cmd, 8 ) == 0) ) {
	/* Parse filename out of command and remove that file */
	int i, len;
	char *iptr, fname[256];
	for ( iptr = &cmd[8]; isspace(*iptr); iptr++ );
	while ( *iptr == '-' ) {
	    /* Skip option spec and following white space */
	    while ( *iptr && !isspace(*iptr) ) iptr++;
	    while ( isspace ( *iptr ) ) iptr++;
	}
	/*
	 * Copy element.
	 */
	for ( i = 0; i < sizeof(fname)-1; i++ ) {
	    fname[i] = *iptr;
	    if ( (*iptr == '\0') || isspace(*iptr) ) break;
	    iptr++;
	}
	fname[i] = '\0';
#ifdef DEBUG
	printf("Removing file: '%s'\n", fname );
#endif
	return remove ( fname );
    }
    /*
     * See if commands were blocked.
     */
    if ( (cmd[0] == '(') && (cmd[cmdlen-1] == ')') ) {
    }
    /*
     * Use LIB$SPAWN instead of system() since it lets us put tasks in
     * background.
     */
    if ( cmdlen > 205 ) cmd[205] = '\0';
    sprintf(vms_cmd, "@MOSAIC_EXEC_PATH:MOSAIC_EXEC %s", cmd );
    vms_cmd_dx.dsc$w_length = strlen(vms_cmd);

    status = lib$spawn ( &vms_cmd_dx, 0, 0, &background );
#ifdef DEBUG
    printf("spawned:'%s', sts: %d\n", vms_cmd, status );
#endif
    return status;
}
#endif /* OSU -- RJF */
