/*
 * Cipher Tools V-Crack Zero++
 * Copyright (C) 1998 aempirei
 * Revised 16apr98
 * Published by The Ambient Empire
 * see vcrack.txt for license information
 */

#include <stdio.h>
#include <stdlib.h>

void showtitle(void);
void showhelp(void);

void main(int argc, char *argv[]) {
   FILE *cstream[2];

   int i, j, m, n, r,
   passlen = 0L;

   long k, l, filelen, count[256] = { 0L };

   unsigned long mean = 0L, higcd = 0L, total = 0L;
   unsigned long gcd[49] = { 0L };

   register unsigned char byte;
   unsigned char password[48];

   struct flag {
      unsigned long tally, score;
   } flag[49] = { { 0L }, { 0L } };

   showtitle();

   if(argc == 1) {
	fprintf(stderr, "ERROR: no input file specified\n");
	showhelp(); exit(EXIT_FAILURE);
   }

   if(argc == 2) {
	fprintf(stderr, "ERROR: no output file specified\n");
	showhelp(); exit(EXIT_FAILURE);
   }

   for(i = 3; i < 49; i++) {
   k = 0;

      if((cstream[0] = fopen(argv[1], "rb")) == NULL) {
	 fprintf(stderr, "ERROR: unable to open '%s'\n", argv[1]);
	 exit(EXIT_FAILURE);
      }

      if((cstream[1] = fopen(argv[1], "rb")) == NULL) {
	 fprintf(stderr, "ERROR: unable to open '%s'\n", argv[1]);
	 exit(EXIT_FAILURE);
      }

      fseek(cstream[0], 0L, SEEK_END);
      filelen = ftell(cstream[0]);
      fseek(cstream[0], 0L, SEEK_SET);
      fseek(cstream[1], i,  SEEK_SET);

      for(l = i; l < filelen; l++)
	 if(fgetc(cstream[0]) == fgetc(cstream[1])) k++;

      fclose(cstream[0]);
      fclose(cstream[1]);

      mean += flag[i].tally = k;
      total++;

      for(j = 3; j < 49; j++) {
	 flag[j].score = flag[j].tally * 4 * total / mean;
	 if(flag[j].score < 7) flag[j].score = 0L;
      }
   }

   for(i = 48; i > 3; i--) {
      gcd[i] += flag[i].score;
      for(j = i - 1; j > 2; j--) {
	 m = i;
	 n = j;
	 do {
	    r = m % n;
	    m = n;
	    n = r;
	 } while(n);
	 gcd[m] += flag[m].score;
      }
   }

   for(i = 3; i < 49; i++) {
      if(gcd[i] > higcd) {
	 higcd = gcd[i];
	 passlen = i;
      }
   }

   if(passlen == 0) {
	 fprintf(stderr, "WARNING: possibly not encrypted\n");
	 exit(EXIT_FAILURE);
   }

   printf("password: \"");

   for(i = 0; i < passlen; i++) {
      if((cstream[0] = fopen(argv[1], "rb")) == NULL) {
	 fprintf(stderr, "ERROR: unable to open '%s'\n", argv[1]);
	 exit(EXIT_FAILURE);
      }

      for(j = 0; j < 256; j++) count[j] = 0L;
      higcd = 0L;

      for(l = 0L; l < filelen; l++) {
	 byte = fgetc(cstream[0]);
	 if((l % passlen) == i) {
	    for(j = 0L; j < 256; j++) {
	       if(((byte ^ j) == ' ') ||
		  ((byte ^ j) == 'e') ||
		  ((byte ^ j) == 't') ||
		  ((byte ^ j) == 'o') ||
		  ((byte ^ j) == 's')) count[j] += 1;
	    }
	 }
      }

      fclose(cstream[0]);

      for(j = 0; j < 256; j++) {
	 if(count[j] > higcd) {
	    higcd = count[j];
	    byte = j;
	 }
      }

      password[i] = byte;

      if(byte > 31) putchar(byte);
      else putchar('.');
   }
   printf("\"\n");
   printf("decrypted text saved to '%s'\n", argv[2]);

   if((cstream[0] = fopen(argv[1], "rb")) == NULL) {
      fprintf(stderr, "ERROR: unable to open '%s'\n", argv[1]);
      exit(EXIT_FAILURE);
   }
   if((cstream[1] = fopen(argv[2], "wb")) == NULL) {
      fprintf(stderr, "ERROR: unable to open '%s'\n", argv[2]);
      exit(EXIT_FAILURE);
   }

   for(k = 0L; k < filelen; k++) {
      byte = fgetc(cstream[0]);
      fputc(byte ^ password[(int)(k % passlen)], cstream[1]);
   }

   fclose(cstream[0]);
   fclose(cstream[1]);

}

void showtitle() {
   fprintf(stderr, "\n    ************************************************************************");
   fprintf(stderr, "\n    * Cipher Tools V-Crack Zero++                   Ambient Empire 16apr98 *");
   fprintf(stderr, "\n    * Copyright (C) 1998 aempirei               see vcrack.txt for license *");
   fprintf(stderr, "\n    ************************************************************************\n\n");
}

void showhelp() {
   fprintf(stderr, "\nUSAGE:  vcrack <ciphertext> <plaintext>\n\n");
   fprintf(stderr, "  <ciphertext>           specifies the filename for the encrypted text input\n");
   fprintf(stderr, "  <plaintext>            specifies the filename for the decrypted text output\n");
}

