$ perl 'f$env("procedure")' "''p1'" "''p2'" "''p3'" "''p4'" "''p5'" "''p6'" "''p7'" "''p8'"!
$ exit++ + ++$status!=0 and $exit=$status=undef; while($#ARGV != -1 and $ARGV[$#ARGV] eq ''){pop @ARGV;}
    eval 'exec perl -S $0 "$@"'
        if 0;

#############################################################################
# pod2usage -- command to print usage messages from embedded pod docs
#
# Copyright (c) 1996-2000 by Bradford Appleton. All rights reserved.
# This file is part of "PodParser". PodParser is free software;
# you can redistribute it and/or modify it under the same terms
# as Perl itself.
#############################################################################

use strict;
use diagnostics;

=head1 NAME

pod2usage - print usage messages from embedded pod docs in files

=head1 SYNOPSIS

=over 12

=item B<pod2usage>

[B<-help>]
[B<-man>]
[B<-exit>S< >I<exitval>]
[B<-output>S< >I<outfile>]
[B<-verbose> I<level>]
[B<-pathlist> I<dirlist>]
I<file>

=back

=head1 OPTIONS AND ARGUMENTS

=over 8

=item B<-help>

Print a brief help message and exit.

=item B<-man>

Print this command's manual page and exit.

=item B<-exit> I<exitval>

The exit status value to return.

=item B<-output> I<outfile>

The output file to print to. If the special names "-" or ">&1" or ">&STDOUT"
are used then standard output is used. If ">&2" or ">&STDERR" is used then
standard error is used.

=item B<-verbose> I<level>

The desired level of verbosity to use:

    1 : print SYNOPSIS only
    2 : print SYNOPSIS sections and any OPTIONS/ARGUMENTS sections
    3 : print the entire manpage (similar to running pod2text)

=item B<-pathlist> I<dirlist>

Specifies one or more directories to search for the input file if it
was not supplied with an absolute path. Each directory path in the given
list should be separated by a ':' on Unix (';' on MSWin32 and DOS).

=item I<file>

The pathname of a file containing pod documentation to be output in
usage mesage format (defaults to standard input).

=back

=head1 DESCRIPTION

B<pod2usage> will read the given input file looking for pod
documentation and will print the corresponding usage message.
If no input file is specifed than standard input is read.

B<pod2usage> invokes the B<pod2usage()> function in the B<Pod::Usage>
module. Please see L<Pod::Usage/pod2usage()>.

=head1 SEE ALSO

L<Pod::Usage>, L<pod2text(1)>

=head1 AUTHOR

Please report bugs using L<http://rt.cpan.org>.

Brad Appleton E<lt>bradapp@enteract.comE<gt>

Based on code for B<pod2text(1)> written by
Tom Christiansen E<lt>tchrist@mox.perl.comE<gt>

=cut

use Pod::Usage;
use Getopt::Long;

## Define options
my %options = ();
my @opt_specs = (
    "help",
    "man",
    "exit=i",
    "output=s",
    "pathlist=s",
    "verbose=i",
);

## Parse options
GetOptions(\%options, @opt_specs)  ||  pod2usage(2);
pod2usage(1)  if ($options{help});
pod2usage(VERBOSE => 2)  if ($options{man});

## Dont default to STDIN if connected to a terminal
pod2usage(2) if ((@ARGV == 0) && (-t STDIN));

@ARGV = ("-")  unless (@ARGV > 0);
if (@ARGV > 1) {
    print STDERR "pod2usage: Too many filenames given\n\n";
    pod2usage(2);
}

my %usage = ();
$usage{-input}    = shift(@ARGV);
$usage{-exitval}  = $options{"exit"}      if (defined $options{"exit"});
$usage{-output}   = $options{"output"}    if (defined $options{"output"});
$usage{-verbose}  = $options{"verbose"}   if (defined $options{"verbose"});
$usage{-pathlist} = $options{"pathlist"}  if (defined $options{"pathlist"});

pod2usage(\%usage);


