# Copyright (c) 2003, Dick Munroe (munroe@csworks.com),
#                     Cottage Software Works, Inc.
#                     All rights reserved.
#
# This program, comes with ABSOLUTELY NO WARRANTY.
# This is free software, and you are welcome to redistribute it
# under the conditions of the GNU GENERAL PUBLIC LICENSE, version 2.
#
# Specialize the behavior of VMS::Librarian for Object libraries.
#
# Revision History:
#
#   1.00    06-May-2003	Dick Munroe (munroe@csworks.com)
#	    Initial Version Created.
#

package VMS::Librarian::Object ;

$VERSION = "1.00" ;

use strict ;
use 5.6.1 ;

use VMS::Librarian qw(VLIB_CRE_OBJCASING VLIB_OBJECT) ;

@VMS::Librarian::Object::ISA = qw(VMS::Librarian) ;

sub creopt
{
    my $self = shift ;

    return $self->SUPER::creopt(
	TYPE=>VLIB_OBJECT,
	IDXOPT=>VLIB_CRE_OBJCASING,
	KEYLEN=>128,
	ALLOC=>200,
	ENTALL=>200,
	IDXMAX=>2,
	@_) ;
}

sub new
{
    my $thePackage = shift ;

    return $thePackage->SUPER::new(@_,TYPE=>VLIB_OBJECT) ;
}

1;
__END__
