$! SITE_DELIVER.COM	-- I program to respond to misc. mail requests
$!
$! Author: Richard Levitte <levitte@lp.se>
$!
$!	P1	route parameter
$!	P2	DATA file
$!	P3	file with recipient
$!	P4	originator
$!
$! Let's first check if this is a callback or not, and do appropriate changes
$	if P1 .nes. "__CALLBACK"
$	then
$! Remove all rogue symbols.  That's the only way.
$	    delete/symbol/global/all
$! And now for local settings
$	    if f$search("MX_DIR:MX_SITE_INFO.COM") .nes. ""
$	    then 
$		@MX_DIR:MX_SITE_INFO
$	    endif
$
$! These can't be overriden by users.
$	    Remove_Response_file :== NO
$	    Do_Not_Forward :== NO
$	    Do_Not_Instruct :== NO
$	    Select_Instructions == ""
$	    No_From :== no
$	    No_Reply_To :== no
$	    No_Errors_To :== no
$	    No_Subject :== no
$	    No_Blank_Line :== no
$
$	    Save_To :==
$	    Save_Dir :==
$	    Purge_Keep :==
$	    Do_uudecode :== no
$	    Skip_Headers :== yes
$	    Skip_Signature :== yes
$	else
$	    P1 = "__"+f$edit(P2,"TRIM")
$	    P2 = P3
$	    P3 = P4
$	    P4 = P5
$	    P5 = P6
$	    P6 = P7
$	    P7 = P8
$	    P8 = ""
$	endif
$
$! Programs used by this script
$	MX_ENTER :== $MX_EXE:MX_SITE_IN
$	SD_CALLBACK :== @'f$element(0,";",f$environment("PROCEDURE")) __CALLBACK
$	define SD_directories MX_EXE:,MX_SITE_DIR:
$	
$! Usefull stuff
$	_pid = f$getjpi("","pid")
$	domain = f$trnlnm("MX_NODE_NAME")
$	admin = "system@" + domain
$
$! Do we debug?
$	site_debug == f$trnlnm("MX_SITE_DEBUG")
$	set noverify
$	if site_debug then set verify
$
$! OK, let's check the P1 argument.  We accept several parts, divided by
$! semicolons.  The semicolon can be escaped the Unix way, with a backslash.
$! The following global are created:
$!	
$!	site_P_n		the amount of arguments found in P1
$!	site_P1			\
$!	...			 > The symbols holding the arguments
$!	site_P'site_P_n'	/
$!	
$	_arguments = P1
$	site_P_n == 0
$ site_arg_loop:
$	if _arguments .eqs. "" then goto site_arg_loop_end
$	site_P_n == site_P_n + 1
$	site_P'site_P_n' == ""
$	_site_P = ""
$ site_arg_loop_inner: 
$	_p = f$locate(";", _arguments)
$	_site_P = _site_P + f$extract(0,_p,_arguments)
$	_arguments = f$extract(_p,f$length(_arguments)-_p,_arguments)
$	if _arguments .eqs. "" then goto site_arg_loop_unescape
$	! We now know that _arguments starts with a semi.
$	_arguments = _arguments - ";"
$	if f$extract(_p-1,1,_site_P) .eqs. "\"
$	then
$	    _site_P = _site_P + ";"
$	    goto site_arg_loop_inner
$	endif
$ site_arg_loop_unescape:
$	_p = f$locate("\", _site_P)
$	if _p .lt. f$length(_site_P)-1
$	then
$	    site_P'site_P_n' == site_P'site_P_n' + f$extract(0,_p,_site_P) -
		  + f$extract(_p+1,1,_site_P)
$	    _site_P = f$extract(_p+2,f$length(_site_P)-p-2,_site_P)
$	    goto site_arg_loop_unescape
$	endif
$	if _p .eq. f$length(_site_P)-1 then _site_P = _site_P - "\"
$	site_P'site_P_n' == site_P'site_P_n' + _site_P
$	goto site_arg_loop
$ site_arg_loop_end:
$
$! The first argument is REQUIRED!!!
$	if f$type(site_P1) .eqs. ""
$	then
$	    request "MX_SITE trying to run SITE_DELIVER.COM without first argument!"
$	    write sys$output "MX_SITE trying to run SITE_DELIVER.COM without first argument!"
$	    exit
$	endif
$! Fix the first argument
$	site_P1 == f$edit(site_P1,"TRIM")
$	if f$extract(0,2,site_P1) .nes. "__" then site_P1 == "SD_" + site_P1
$
$! Debugging stuff (goes into a log file if there is such a beast
$	if site_debug
$	then
$	    _sav_ver = f$verify(0)
$	    write sys$output "P1: ",P1
$	    _n = 0
$ loop_site_args:
$	    _n = _n + 1
$	    if _n .le. site_P_n
$	    then
$		write sys$output "	site_P",_n,": ",site_P'_n'
$		goto loop_site_args
$	    endif
$	    write sys$output "P2: ",P2
$	    write sys$output "P3: ",P3," :"
$	    type 'P3'		! It's a file containing the recipients...
$	    write sys$output "P4: ",P4
$	    !'f$verify(_sav_ver)
$	endif
$
$! P1 isn't needed anymore, so we shove the other arguments down one step.
$! this makes built-in modules and external ones behave the same.
$	P1 = P2
$	P2 = P3
$	P3 = P4
$	P4 = P5
$	P5 = P6
$	P6 = P7
$	P7 = P8
$	P8 = ""
$! Let's do the job.  Some thing are internal in this file, others are in
$! separate files.  The warning handler will take care of that automatically,
$! but a warning will still be produced...  oh well...
$	on warning then goto runfile
$	goto 'site_P1'
$
$ runfile:
$	on warning then exit
$	if f$extract(0,2,site_P1) .nes. "__"
$	then
$	    if f$search("SD_DIRECTORIES:"+site_P1+".EXE") .nes. ""
$	    then
$		MCR SD_DIRECTORIES:'site_P1'.EXE 'P1' 'P2' "''P3'"
$		exit
$	    endif
$	    if f$search("SD_DIRECTORIES:"+site_P1+".COM") .nes. ""
$	    then
$		@SD_DIRECTORIES:'site_P1'.COM 'P1' 'P2' "''P3'"
$		exit
$	    endif
$	    if f$search("SD_DIRECTORIES:"+site_P1+".LINK") .nes. ""
$	    then
$		open/read SD_L_file1 SD_DIRECTORIES:'site_P1'.LINK
$		read/end=_nolink/err=_nolink SD_L_file1 line
$		close SD_L_file1
$		line = f$parse(line,"SD_DIRECTORIES:.COM;")
$		if f$parse(line,,,"TYPE") .eqs. ".COM"
$		then
$		    @'line' 'P1' 'P2' "''P3'"
$		else
$		    MCR 'line' 'P1' 'P2' "''P3'"
$		endif
$		exit
$ _nolink: 
$		close SD_L_file1
$	    endif
$	    request "MX_SITE trying to run a non-existent image or subprocedure: site_P1 = ""''site_p1'"""
$	    write sys$output "MX_SITE trying to run a non-existent image or subprocedure: site_P1 = """,site_p1,""""
$	else
$	    request "MX_SITE trying to go to a non-existent callback: site_P1 = ""''site_p1'"""
$	    write sys$output "MX_SITE trying to go to a non-existent callback: site_P1 = """,site_p1,""""
$	endif
$	exit
$	    
$	
$!----- Internal methods ------------------------------------------------------
$! Normal INFO
$!X-Instructions: To receive general info about ''domain',
$!X-Instructions: send a message to ''Info_address'.
$!
$! For administrators:
$!
$!	You can configure this thing by setting the /ROUTE parameter
$!	to something like this:
$!
$!	  /ROUTE="INFO;response_file;organization;info-address;return-address"
$!
$!	For example, Yoyodine Inc. might want the following:
$!
$!	  /ROUTE="INFO;MX_DIR:YOYODINE.TXT;Yoyodine Inc.;Info@yoyodine.com;staff@yoyodine.com"
$
$ SD_INFO:
$	on warning then exit
$
$! Setting a few defaults.  Do not change these.  Instead, write a procedure
$! called MX_DIR:MX_SITE_INFO.COM.
$	if f$type(Info_address) .eqs. "" then -
	    Info_address == "<Info@" + domain + ">"
$	if f$type(Organization) .eqs. "" then -
	    Organization == ""
$
$	Response_file :== MX_DIR:INFO.TXT
$
$! Now, let's see what the user might wish to use
$	if f$type(site_P2) .nes. "" then Response_file == site_P2
$	if f$type(site_P3) .nes. "" then Organization == site_P3
$	if f$type(site_P4) .nes. "" then Info_address == site_P4
$	if f$type(site_P5) .nes. "" then Return_address == site_P5
$
$	Header_From == "Automagic reply <" + Return_address + ">"
$	Header_Subject == "Information"
$	if Organization .nes. "" then Header_Subject == "Information about " -
	   + Organization
$	Remove_Response_file :== no
$	goto __AutoAnswer
$
$
$!----- CALLBACKS -------------------------------------------------------------
$!
$! Callback labels always start with `__'!
$!
$
$! __AutoAnswer:  General auto answer machine
$! Variables to use to change the behavior of this callback:
$!
$!	Response_file		name of the file to send
$!	Remove_Response_file	IF true, remove the response file once used.
$!				Defauls is NO.
$!	Return_address		the return-path of the envelope
$!	
$!	Header_From		\
$!	Header_Reply_To		 \  Header values
$!	Header_Errors_To	 /
$!	Header_Subject		/
$!	
$!	No_From			If true, to not include a From: line.
$!	No_Reply_To		If true, to not include a Reply-To: line.
$!	No_Errors_To		If true, to not include a Errors-To: line.
$!	No_Subject		If true, to not include a Subject: line.
$!	No_Blank_Line		If true, to not include a blank line after
$!				the headers.
$!
$!				The No_* symbols are for the case when you
$!				want to send a file which includes those
$!				headers
$!
$!	Do_Not_Forward		If true, the mail received will not be
$!				forwarded to 'Return_address'.  If not true
$!				or doesn not exist, the mail received will
$!				be forward if it contains more than headers
$!				and signature.  Default is NO.
$!	Do_Not_Instruct		If true, do not run the instruction feature.
$!				Default is NO.
$!	Select_Instructions	If non-empty, only give instructions on modules
$!				whose name is included in the value (comma-
$!				separated names).
$!
$!	Skip_Headers		If true, skip the headers
$!	Skip_Signature		If true, skip the signature
$!	
$! __AutoAnswer also looks through this file and all SD_DIRECTORIES:SD_*.COM
$! for lines starting with "$!X-Instructions: ", and uses them to build
$! X-Instructions: headers.
$!
$! __AutoAnswer also has the capability to save a uuencoded file automatically.
$! The following global symbols control that behavior:
$!	
$!	Save_To			the file name to save the temporary uuencoded
$!				file with.
$!	Save_Dir		The directory where all the files are saved.
$!	Purge_Keep		How many version back should be kept?
$!	Do_uudecode		if false, do NOT uudecode the file, just
$!				save it.
$
$ __AutoAnswer:
$	on warning then exit
$
$	! Last chance to set these right
$	if f$type(Return_address) .eqs. "" then -
	    Return_address == "<" + admin + ">"
$	if f$type(Error_address) .eqs. "" then -
	    Error_address == "<postmaster@" + domain + ">"
$
$	! Sanity check
$	_Old_Response_file = Response_file
$	if f$search(Response_file) .eqs. "" then Response_file == ""
$	if Response_file .eqs. "" then Remove_Response_file :== NO
$	if Return_address - "<" .eqs Return_address then -
	   Return_address == "<"+Return_address+">"
$
$	if f$type(Header_From) .eqs. "" then Header_From == ""
$	if f$type(Header_Reply_To) .eqs. "" then Header_Reply_To == ""
$	if f$type(Header_Errors_To) .eqs. "" then Header_Errors_To == ""
$	if f$type(Header_Subject) .eqs. "" then Header_Subject == ""
$
$	if Header_From .eqs. "" then Header_From == Return_address
$	if Header_Reply_To .eqs. "" then Header_Reply_To == Return_address
$	if Header_Errors_To .eqs. "" then Header_Errors_To == Error_address
$	if Header_Subject .eqs. "" then Header_Subject == "Automagic answer"
$
$	_SD_forward_file := mx_site_dir:AA_site_forw_'_pid'.tmp
$	_SD_to_file := mx_site_dir:AA_site_to_'_pid'.tmp
$	_SD_text_file := mx_site_dir:AA_txt_forw_'_pid'.tmp
$	_SD_search_file := mx_site_dir:AA_site_search_'_pid'.tmp
$
$	if f$trnlnm("SD_L_file1") .nes. "" then close SD_L_file1
$	! This file gets the address to forward to.
$	open/write SD_L_file1 '_SD_forward_file'
$	write SD_L_file1 Return_address
$	close SD_L_file1
$	! This file gets the address to reply to.
$	open/write SD_L_file1 '_SD_to_file'
$	write SD_L_file1 P3
$	close SD_L_file1
$	! This is the file containing the message to send back.
$	open/write SD_L_file1 '_SD_text_file'
$	if .not. No_Reply_To then write SD_L_file1 "Reply-To: ",Header_Reply_To
$	if .not. No_Errors_To then write SD_L_file1 "Errors-To: ",Header_Errors_To
$	write SD_L_file1 "X-Comment: This message was sent to you automagically, using"
$	write SD_L_file1 "X-Comment: a SITE_DELIVER.COM for MX by Richard Levitte"
$	if Do_Not_Instruct then goto _loop_SD_files_end
$
$	Select_Instructions == "," + Select_Instructions + ","
$
$	_SD_instruction_line = 0
$	_SD_file = f$element(0,";",f$environment("PROCEDURE"))
$	goto _open_SD_file
$
$ _loop_SD_files:
$	_SD_file = f$search("SD_directories:SD_*.COM")
$	if _SD_file .eqs. "" then goto _loop_SD_files_end
$	_SD_file_name = f$parse(_SD_file,,,"NAME")
$	if Select_Instructions .nes. ",,"
$	then
$	    if Select_Instructions - (","+_SD_file_name+",") -
	       .nes. Select_Instructions .or. -
	       Select_Instructions - (","+_SD_file_name-"SD_"+",") -
	       .nes. Select_Instructions -
		then goto _loop_SD_files
$	endif
$	if f$type(_SD_done_'_SD_file_name') .nes. "" then -
	   goto _loop_SD_files
$	_SD_done_'_SD_file_name' := YES
$ _open_SD_file:
$	if f$trnlnm("SD_L_file2") .nes. "" then close SD_L_file2
$	sear '_SD_file' "$!X-INSTRUCTIONS:" /output='_SD_search_file'
$	open/read SD_L_file2 '_SD_search_file'
$ _loop_SD_file:
$	read/end=_loop_SD_file_end/err=_loop_SD_file_end SD_L_file2 _line
$	if f$edit(f$extract(0,18,_line),"UPCASE") .eqs. "$!X-INSTRUCTIONS: "
$	then
$	    _tmp = f$extract(18,f$length(_line)-18,_line)
$	    _line = ""
$	    ! Double all double quotes
$ _loop_SD_file_line:
$	    _tmp1 = f$element(0,"""",_tmp)
$	    sh sym _tmp1
$	    sh sym _tmp
$	    _line = _line + _tmp1
$	    if _tmp .nes. _tmp1 then _line = _line + """"""
$	    sh sym _line
$	    _tmp = _tmp - _tmp1 - """"
$	    if _tmp .nes. "" then goto _loop_SD_file_line
$
$	    ! The following does the actual expansion of ''symbol'
$	    _line = """" + _line + """"
$	    _line = '_line'
$
$	    ! Time to write
$	    _SD_instruction_line = _SD_instruction_line + 1
$	    write SD_L_file1 f$fao("X-Instruction!03ZL: ",_SD_instruction_line),_line
$	endif
$	goto _loop_SD_file
$ _loop_SD_file_end:
$	close SD_L_file2
$	delete '_SD_search_file';*
$	goto _loop_SD_files
$ _loop_SD_files_end: 
$
$	if .not. No_From then write SD_L_file1 "From: ",Header_From
$	if .not. No_Subject then write SD_L_file1 "Subject: ",Header_Subject
$	if .not. No_Blank_Line then write SD_L_file1 ""
$	if Response_file .eqs. ""
$	then
$	    if _Old_Response_file .nes. "NLA0:"
$	    then
$		if _Old_Response_file .eqs. ""
$		then
$		    write SD_L_file1 "There was nothing I could send to you."
$		else
$		    write SD_L_file1 "For some reason, you only receive junk, when you should have received"
$		    write SD_L_file1 _Old_Response_file,"."
$		endif
$		write SD_L_file1 "Complain to ",Error_address,"."
$	    endif
$	else
$	    type 'Response_file' /output=SD_L_file1
$	endif
$	close SD_L_file1
$	if Remove_Response_file then delete/log 'f$parse(Response_file,";*")
$
$	if f$type(Do_Not_Forward) .eqs. "" then Do_Not_Forward := NO
$	if Do_Not_Forward then goto _AutoAnswer_loop_end
$
$	open/read SD_L_file1 'P1'
$	if Save_To .nes. "" then open/write SD_L_file2 'Save_Dir''Save_To'
$	_past_headers = .not. Skip_Headers
$	_past_begin = .not. Do_uudecode
$ _AutoAnswer_loop:
$	read/end=_AutoAnswer_loop_end/err=_AutoAnswer_loop_end SD_L_file1 -
	    _line
$	write sys$output ": ",_line
$	! The standard says a mail signature starts with a line having
$	! "-- " as its' contents.  Skip when you find such a line.
$	if Skip_Signature then if _line .eqs. "-- " .and. _past_headers then -
	   goto _AutoAnswer_loop_end
$	if _line .eqs. "-- " .and. _past_headers then goto _AutoAnswer_loop_end
$	if Do_uudecode
$	then
$	    _l = f$edit(_line,"compress,trim,lowercase")
$	    if f$element(0," ",_l) .eqs. "begin" then _past_begin := yes
$	    if _past_begin .and. Save_To .nes. "" then write SD_L_file2 _line
$	else
$	    _l = f$edit(_line,"collapse,lowercase")
$	    if _l .nes. ""
$	    then
$		if _past_headers
$		then
$		    if Save_To .eqs. "" then goto _AutoAnswer_forward
$		    write SD_L_file2 _line
$		endif
$	    else
$		_past_headers := yes
$		if Save_To .nes. "" then write SD_L_file2 _line
$	    endif
$	endif
$	goto _AutoAnswer_loop
$ _AutoAnswer_forward: 
$	MX_ENTER 'P1' '_SD_forward_file' "''P3'"
$ _AutoAnswer_loop_end:
$	if f$trnlnm("SD_L_file2") .nes. "" then close SD_L_file2
$	if f$trnlnm("SD_L_file1") .nes. "" then close SD_L_file1
$
$	if Do_uudecode
$	then
$	    _save_default = f$env("default")
$	    set noon
$	    set default 'Save_Dir'
$	    mcr ucx$uudecode 'Save_To'
$	    ! In case it's too much or too little
$	    set file/prot=(g:re,w:re) *.*;*
$	    if Purge_Keep .nes. "" then purge/keep='Purge_Keep'
$	    delete 'Save_To';*
$	    set on
$	    set default '_save_default'
$	endif
$
$! Send automagic text back to the sender.
$	MX_ENTER '_SD_text_file' '_SD_to_file' "''Return_address'"
$	_tmp = $status
$	if f$search("''_SD_forward_file'") .nes. "" then -
	   delete/log '_SD_forward_file';*
$	if f$search("''_SD_to_file'") .nes. "" then -
	   delete/log '_SD_to_file';*
$	if f$search("''_SD_text_file'") .nes. "" then -
	   delete/log '_SD_text_file';*
$	if f$search("''_SD_search_file'") .nes. "" then -
	   delete/log '_SD_search_file';*
$	set nover
$	exit _tmp
