  L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *;  *               %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\ <  *               %% \                                   %% \=  *               %%  \__________________________________%%  \ >  *               %%  |                                  %%   \?  *               %%  |              LnmTool             %%    | ?  *               %%  |          Modify.c   c2003        %%    | ?  *               %%  |            Lyle W. West          %%    | ?  *               %%  |                                  %%    | ?  *               %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    | ?  *               \                                        \   | ?  *                \                                        \  | ?  *                 \                                        \ | ?  *                  \________________________________________\|   *  *  *:  *   Copyright (C) 2003 Lyle W. West, All Rights Reserved.  *K  *   Permission is granted to copy and use this program so long as [1] this I  *   copyright notice is preserved, and [2] no financial gain is involved I  *   in copying the program.  This program may not be sold as "shareware" H  *   or "public domain" software without the express, written permission  *   of the author.   *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */    #include "version.h" #pragma module modify VERSION    #include <stdio.h> #include <clidef.h>  #include <ctype.h> #include <descrip.h> #include <jpidef.h>  #include <lnmdef.h>  #include <psldef.h>  #include <ssdef.h> #include <string.h>  #include <types.h> #include <X11/cursorfont.h>  #include <X11/Intrinsic.h> #include <X11/StringDefs.h>  #include <X11/Xos.h> #include <X11/Xlib.h>  #include <X11/Xutil.h> #include <Xm/MwmUtil.h>  #include <Xm/Xm.h> #include <Xm/BulletinB.h>  #include <Xm/CascadeB.h> #include <Xm/Frame.h>  #include <Xm/Label.h>  #include <Xm/LabelG.h> #include <Xm/List.h> #include <Xm/MainW.h>  #include <Xm/PushB.h>  #include <Xm/PushBG.h> #include <Xm/RowColumn.h>  #include <Xm/Text.h> #include "defs.h"  #include "externs.h"   extern void AddTableTextCB();  extern void OptsTableSelCB();  extern void PopupDoneCB(); extern void PushButtonCB();  extern void ModifyTableSelCB();  extern void UpdateOptsList();  extern int  TableSort();        N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: CopyTableList B  * Description: Routine used to copy Table list stuctures from theB  *              AscTableList to AscModifyTableList, or vice-versa.  *+  *      Inputs: source/destination constant   *     Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */   void CopyTableList(int destlist) {      int indx = 0;      XmString CsTblName;      TABLE_LST *SrcPtr;     TABLE_LST *DestPtr;   6         /* Copy AscTableList --> AscModifyTableList */  J     if(destlist == CURRENT_TO_MODIFY) {     /* see defs.h for constants */          if(AscModifyTableList) {&             cfree(AscModifyTableList);-             XmStringFree(CsTmodifyListItems); 	         } O         AscModifyTableList = (TABLE_LST *) calloc(NumTbl+1, sizeof(TABLE_LST)); %         DestPtr = AscModifyTableList;          SrcPtr = AscTableList;     } L     else {      /* MODIFY_TO_CURRENT: AscModifyTableList --> AscTableList */         if(AscTableList) {              cfree(AscTableList);'             XmStringFree(CsTlistItems); 	         } L         AscTableList = (TABLE_LST *) calloc(NumModify+1, sizeof(TABLE_LST));         DestPtr = AscTableList; $         SrcPtr = AscModifyTableList;     }   &     while(strlen(SrcPtr->TableName)) {6         strcpy(DestPtr->TableName, SrcPtr->TableName);-         DestPtr->LnmCount = SrcPtr->LnmCount;          DestPtr++;         SrcPtr++;      }   C     if(destlist == CURRENT_TO_MODIFY) DestPtr = AscModifyTableList;       else DestPtr = AscTableList;  8         /* Move table list onto compound string array */  '     if(destlist == CURRENT_TO_MODIFY) { *         XmListDeleteAllItems(ModifyListW);         NumModify = NumTbl; %         DestPtr = AscModifyTableList;          n = 0;,         while(strlen(DestPtr->TableName)) { A             CsTmodifyListItems[n] = (XmString) XmStringCreateLtoR .                 (DestPtr->TableName, charset);             DestPtr++;             n++;	         }      } +     else {          /* MODIFY_TO_CURRENT */ 
 #ifdef ARF-         XmListDeleteAllItems(MainTableListW);  #endif         NumTbl = NumModify;          DestPtr = AscTableList;          n = 0;+         while(strlen(DestPtr->TableName)) { ;             CsTlistItems[n] = (XmString) XmStringCreateLtoR .                 (DestPtr->TableName, charset);             DestPtr++;             n++;	         }      }   =         /* Update the target table list with all new items */   
     n = 0;'     if(destlist == CURRENT_TO_MODIFY) { =         XtSetArg(args[n], XmNitems, CsTmodifyListItems); n++; 5         XtSetArg(args[n], XmNitemCount, NumTbl); n++; 7         XtSetArg(args[n], XmNvisibleItemCount, 8); n++; *         XtSetValues(ModifyListW, args, n);     } +     else {          /* MODIFY_TO_CURRENT */ 7         XtSetArg(args[n], XmNitems, CsTlistItems); n++; 8         XtSetArg(args[n], XmNitemCount, NumModify); n++;7         XtSetArg(args[n], XmNvisibleItemCount, 5); n++; -         XtSetValues(MainTableListW, args, n);      }        if(LoggingEnabled) {)         if(destlist == CURRENT_TO_MODIFY) L             fprintf(lnmlog_fp, "    CopyTableList: NumModify=%d\n", NumTbl);M         else fprintf(lnmlog_fp, "    CopyTableList: NumTbl=%d\n", NumModify);      } 
 #ifdef LNMDBG &     if(destlist == CURRENT_TO_MODIFY) <         printf("    CopyTableList: NumModify=%d\n", NumTbl);@     else printf("    CopyTableList:    NumTbl=%d\n", NumModify); #endif }             N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: ModifyAddTable@  * Description: User has selected the 'Add Table' button in the A  *              Modify Tables or the Optional Tables window. This E  *              routine creates a new TABLE_LIST structure reflecting B  *              the change, alpha sorts the tables, and places the?  *              table names into the 'AscModifyTableList' list.   *  *      Inputs: None  *     Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void ModifyAddTable()  {      int indx = 0;      XmString CsTblName;      OPTS_LST *OptsPtr;     TABLE_LST *TempAscList;      TABLE_LST *NewPtr;     TABLE_LST *OldPtr;  D         /* copy current list of tablenames into a temporary array */  E     TempAscList = (TABLE_LST *) calloc(NumModify, sizeof(TABLE_LST));      NewPtr = TempAscList;       OldPtr = AscModifyTableList;&     while(strlen(OldPtr->TableName)) {5         strcpy(NewPtr->TableName, OldPtr->TableName); ,         NewPtr->LnmCount = OldPtr->LnmCount;         NewPtr++;          OldPtr++;      }   E         /* copy the added tablename to the top of the new table list, C            then append the contents of the temp list to new list */        cfree(AscModifyTableList);N     AscModifyTableList = (TABLE_LST *) calloc(NumModify+1, sizeof(TABLE_LST));     OldPtr = TempAscList;       NewPtr = AscModifyTableList;,     strcpy(NewPtr->TableName, ModifyAddStr);     NewPtr->LnmCount = 32768; 
     NewPtr++; &     while(strlen(OldPtr->TableName)) {5         strcpy(NewPtr->TableName, OldPtr->TableName); ,         NewPtr->LnmCount = OldPtr->LnmCount;         NewPtr++;          OldPtr++;      }      cfree(TempAscList);   *         /* sort new list of table names */       NumModify++;      NewPtr = AscModifyTableList;E     qsort( (void *) NewPtr, NumModify, sizeof(TABLE_LST), TableSort);   8         /* Move table list into compound string array */  &     XmListDeleteAllItems(ModifyListW);%     XmStringFree(CsTmodifyListItems);       NewPtr = AscModifyTableList;  
     n = 0;&     while(strlen(NewPtr->TableName)) {=         CsTmodifyListItems[n] = (XmString) XmStringCreateLtoR )             (NewPtr->TableName, charset);          NewPtr++;          n++;     }   
     n = 0;9     XtSetArg(args[n], XmNitems, CsTmodifyListItems); n++; 4     XtSetArg(args[n], XmNitemCount, NumModify); n++;&     XtSetValues(ModifyListW, args, n);  <         /* Update Optional Tables list to reflect changes */       UpdateOptsList(MODIFYLIST);      OptsPtr = AscOptsTableList;   )     XmListDeleteAllItems(OptTablesListW); 4     for(indx = 0; indx < NumAvailableOpts; indx++) {          CsToptsListItems[indx] =G             (XmString) XmStringCreateLtoR(OptsPtr->TableName, charset);          OptsPtr++;     }   )         /* update Optional Tables List */   
     n = 0;7     XtSetArg(args[n], XmNitems, CsToptsListItems); n++; ;     XtSetArg(args[n], XmNitemCount, NumAvailableOpts); n++; )     XtSetValues(OptTablesListW, args, n);        if(LoggingEnabled) {K         fprintf(lnmlog_fp, "   ModifyAddTable: NumModify=%d,   Added %s\n", )                 NumModify, ModifyAddStr);      } 
 #ifdef LNMDBG ;     printf("   ModifyAddTable: NumModify=%d,   Added %s\n", -                     NumModify, ModifyAddStr);  #endif }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *!  *    Function: ModifyRemoveTable F  * Description: Rebuild the AscModifyTableList structure after a table   *              has been removed  *              .   *2  *      Inputs: Offset into the AscModifyTableList  *     Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ $ void ModifyRemoveTable(int position) {      int indx = 0;      int tblcnt = NumModify - 1;      char RemovedStr[50];     XmString CsTblName;      OPTS_LST *OptsPtr;     TABLE_LST *TempAscList;      TABLE_LST *OldPtr;     TABLE_LST *NewPtr;  E     TempAscList = (TABLE_LST *) calloc(NumModify, sizeof(TABLE_LST));   ?         /* copy strings from old ascii array until we reach the %            tablename to be removed */         OldPtr = AscModifyTableList;     NewPtr = TempAscList;      while(indx < position) {5         strcpy(NewPtr->TableName, OldPtr->TableName); ,         NewPtr->LnmCount = OldPtr->LnmCount;         indx++;          OldPtr++;          NewPtr++;      }   B         /*  Skip over removed string and finish copying strings */  *     strcpy(RemovedStr, OldPtr->TableName);
     OldPtr++;      indx = position;     while(indx < tblcnt) {5         strcpy(NewPtr->TableName, OldPtr->TableName); ,         NewPtr->LnmCount = OldPtr->LnmCount;         indx++;          OldPtr++;          NewPtr++;      }        cfree(AscModifyTableList);N     AscModifyTableList = (TABLE_LST *) calloc(NumModify+1, sizeof(TABLE_LST));  E         /* copy revised table name list into newly allocated array */        OldPtr = TempAscList;       NewPtr = AscModifyTableList;&     while(strlen(OldPtr->TableName)) {5         strcpy(NewPtr->TableName, OldPtr->TableName); ,         NewPtr->LnmCount = OldPtr->LnmCount;         OldPtr++;          NewPtr++;      }      cfree(TempAscList);      NumModify--;  &     XmListDeleteAllItems(ModifyListW);%     XmStringFree(CsTmodifyListItems);       NewPtr = AscModifyTableList;
     n = 0;&     while(strlen(NewPtr->TableName)) {=         CsTmodifyListItems[n] = (XmString) XmStringCreateLtoR )             (NewPtr->TableName, charset);          NewPtr++;          n++;     }   
     n = 0;9     XtSetArg(args[n], XmNitems, CsTmodifyListItems); n++; 4     XtSetArg(args[n], XmNitemCount, NumModify); n++;&     XtSetValues(ModifyListW, args, n);  B         /* Update Optional Tables list to reflect removed table */       UpdateOptsList(MODIFYLIST);      OptsPtr = AscOptsTableList;   )     XmListDeleteAllItems(OptTablesListW); 4     for(indx = 0; indx < NumAvailableOpts; indx++) {          CsToptsListItems[indx] =G             (XmString) XmStringCreateLtoR(OptsPtr->TableName, charset);          OptsPtr++;     }   )         /* update Optional Tables List */   
     n = 0;7     XtSetArg(args[n], XmNitems, CsToptsListItems); n++; ;     XtSetArg(args[n], XmNitemCount, NumAvailableOpts); n++; )     XtSetValues(OptTablesListW, args, n);        if(LoggingEnabled) {K         fprintf(lnmlog_fp, "ModifyRemoveTable: NumModify=%d, Removed %s\n", #             NumModify, RemovedStr);      } 
 #ifdef LNMDBG ;     printf("ModifyRemoveTable: NumModify=%d, Removed %s\n", +                     NumModify, RemovedStr);  #endif }     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *'  *    Function: CreateModifyTablePopup  ?  * Description: This routine creates a dialog which is used to  A  *              modify the current list of logical name tables to I  *              display logical name information. It is executed at image ?  *              startup, but not managed until user selects the =  *              Modify Table button in the OptionMenu widget.   *  *      Inputs: None  *     Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void CreateModifyTablePopup()  {      char textstr[50];      XmString CsStr;      XmString label_text;B     Widget ModifyFrame, ModifyListLbl, OptTablesLbl, TableTextLbl;  @         /* create a BulletinBoard dialog for the Modify popup */  =     label_text = XmStringCreateLtoR("Modify Table", charset); 
     n = 0;+     XtSetArg(args[n], XmNheight, 605); n++; *     XtSetArg(args[n], XmNwidth, 325); n++;7     XtSetArg(args[n], XmNdialogTitle, label_text); n++; 3     XtSetArg(args[n], XmNautoUnmanage, False); n++; G     XtSetArg(args[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++; A     ModifyDlg = XmCreateBulletinBoardDialog(LnmForm, "ModifyDlg", :                                                  args, n);     XmStringFree(label_text);   1         /* Create label for Modify list widget */   #     sprintf(textstr,"Modify List"); 1     CsStr = XmStringCreateLtoR(textstr, charset); 
     n = 0;%     XtSetArg(args[n], XmNx, 50); n++; %     XtSetArg(args[n], XmNy, 25); n++; @     XtSetArg(args[n], XmNalignment, XmALIGNMENT_BEGINNING); n++;2     XtSetArg(args[n], XmNlabelString, CsStr); n++;G     ModifyListLbl = XmCreateLabel(ModifyDlg, "ModifyListLbl", args, n); !     XtManageChild(ModifyListLbl);      XmStringFree(CsStr);  5         /* Create the list widget for Modify table */   
     n = 0;%     XtSetArg(args[n], XmNx, 50); n++; %     XtSetArg(args[n], XmNy, 46); n++; *     XtSetArg(args[n], XmNwidth, 225); n++;2     XtSetArg(args[n], XmNshadowThickness, 3); n++;;     XtSetArg(args[n], XmNselectionPolicy, XmBROWSE_SELECT); C     XtSetArg(args[n], XmNscrollBarDisplayPolicy, XmAS_NEEDED); n++; :     XtSetArg(args[n], XmNlistSizePolicy, XmCONSTANT); n++;3     XtSetArg(args[n], XmNvisibleItemCount, 8); n++; ,     XtSetArg(args[n], XmNitemCount, 0); n++;J     ModifyListW = XmCreateScrolledList(ModifyDlg, "ModifyListW", args, n);     XtManageChild(ModifyListW);        XtAddCallback(ModifyListW,-                   XmNbrowseSelectionCallback, #                   ModifyTableSelCB,                    NULL);  *         /* Create label for text widget */  "     sprintf(textstr,"Table Name");1     CsStr = XmStringCreateLtoR(textstr, charset); 
     n = 0;%     XtSetArg(args[n], XmNx, 50); n++; &     XtSetArg(args[n], XmNy, 210); n++;@     XtSetArg(args[n], XmNalignment, XmALIGNMENT_BEGINNING); n++;2     XtSetArg(args[n], XmNlabelString, CsStr); n++;E     TableTextLbl = XmCreateLabel(ModifyDlg, "TableTextLbl", args, n);       XtManageChild(TableTextLbl);     XmStringFree(CsStr);  <         /* Create the text widget for Optional Table name */  
     n = 0;%     XtSetArg(args[n], XmNx, 50); n++; &     XtSetArg(args[n], XmNy, 230); n++;*     XtSetArg(args[n], XmNwidth, 225); n++;2     XtSetArg(args[n], XmNshadowThickness, 3); n++;<     XtSetArg(args[n], XmNeditMode, XmSINGLE_LINE_EDIT); n++;.     XtSetArg(args[n], XmNeditable, True); n++;;     XtSetArg(args[n], XmNnavigationType, XmTAB_GROUP); n++; @     TableTextW = XmCreateText(ModifyDlg, "TableTextW", args, n);     XtManageChild(TableTextW);       XtAddCallback(TableTextW,**                   XmNvalueChangedCallback,!                   AddTableTextCB,%                   CHANGED);%     XtAddCallback(TableTextW,%*                   XmNmodifyVerifyCallback,!                   AddTableTextCB,_                   VERIFY);     XtAddCallback(TableTextW, &                   XmNactivateCallback,!                   AddTableTextCB,                    ACTIVATE);     XtAddCallback(TableTextW,c*                   XmNmotionVerifyCallback,!                   AddTableTextCB,                    MOTION);    :         /* Create label for Optional Tables list widget */  '     sprintf(textstr,"Optional Tables");%1     CsStr = XmStringCreateLtoR(textstr, charset); 
     n = 0;%     XtSetArg(args[n], XmNx, 50); n++; &     XtSetArg(args[n], XmNy, 280); n++;@     XtSetArg(args[n], XmNalignment, XmALIGNMENT_BEGINNING); n++;2     XtSetArg(args[n], XmNlabelString, CsStr); n++;2     XtSetArg(args[n], XmNtraversalOn, False); n++;E     OptTablesLbl = XmCreateLabel(ModifyDlg, "OptTablesLbl", args, n);d     XmStringFree(CsStr);      XtManageChild(OptTablesLbl);/     XtSetMappedWhenManaged(OptTablesLbl, TRUE);l  8         /* Create the list widget for Optional Tables */  
     n = 0;%     XtSetArg(args[n], XmNx, 50); n++;e&     XtSetArg(args[n], XmNy, 300); n++;*     XtSetArg(args[n], XmNwidth, 225); n++;2     XtSetArg(args[n], XmNshadowThickness, 3); n++;@     XtSetArg(args[n], XmNselectionPolicy, XmBROWSE_SELECT); n++;C     XtSetArg(args[n], XmNscrollBarDisplayPolicy, XmAS_NEEDED); n++;c:     XtSetArg(args[n], XmNlistSizePolicy, XmCONSTANT); n++;3     XtSetArg(args[n], XmNvisibleItemCount, 8); n++;<,     XtSetArg(args[n], XmNitemCount, 0); n++;4     OptTablesListW = XmCreateScrolledList(ModifyDlg,I                                               "OptTablesListW", args, n);<"     XtManageChild(OptTablesListW);1     XtSetMappedWhenManaged(OptTablesListW, TRUE);   !     XtAddCallback(OptTablesListW,m-                   XmNbrowseSelectionCallback,m!                   OptsTableSelCB,i                   NULL);  #         /* Create the Add button */.  6     label_text = XmStringCreateLtoR(" Add ", charset);  
     n = 0;%     XtSetArg(args[n], XmNx, 55); n++;d&     XtSetArg(args[n], XmNy, 470); n++;)     XtSetArg(args[n], XmNwidth, 80); n++;n*     XtSetArg(args[n], XmNheight, 30); n++;7     XtSetArg(args[n], XmNlabelString, label_text); n++; 0     XtSetArg(args[n], XmNsensitive, False); n++;=     AddBtn = XmCreatePushButton(ModifyDlg, " Add ", args, n);u     XtManageChild(AddBtn);     XmStringFree (label_text);       XtAddCallback(AddBtn,e&                   XmNactivateCallback,                   PushButtonCB,                    ADD_BTN);a  &         /* Create the Remove button */  7     label_text = XmStringCreateLtoR("Remove", charset);*  
     n = 0;&     XtSetArg(args[n], XmNx, 190); n++;&     XtSetArg(args[n], XmNy, 470); n++;)     XtSetArg(args[n], XmNwidth, 80); n++;L*     XtSetArg(args[n], XmNheight, 30); n++;7     XtSetArg(args[n], XmNlabelString, label_text); n++;E0     XtSetArg(args[n], XmNsensitive, False); n++;A     RemoveBtn = XmCreatePushButton(ModifyDlg, "Remove", args, n);e     XtManageChild(RemoveBtn);e     XmStringFree (label_text);       XtAddCallback(RemoveBtn,&                   XmNactivateCallback,                   PushButtonCB,s                   REMOVE_BTN);    >         /* create a frame widget for the Tables list widget */  
     n = 0;%     XtSetArg(args[n], XmNx, 10); n++;a%     XtSetArg(args[n], XmNy, 10); n++;i*     XtSetArg(args[n], XmNwidth, 305); n++;+     XtSetArg(args[n], XmNheight, 520); n++;_7     XtSetArg(args[n], XmNshadowType, XmSHADOW_IN); n++;e2     XtSetArg(args[n], XmNshadowThickness, 3); n++;0     XtSetArg(args[n], XmNmarginHeight, 10); n++;/     XtSetArg(args[n], XmNmarginWidth, 10); n++;tC     ModifyFrame = XmCreateFrame(ModifyDlg, "ModifyFrame", args, n);      XtManageChild(ModifyFrame);   G         /* Create main BulletinBoard buttons, first is Commit button */t  7     label_text = XmStringCreateLtoR("Commit", charset);l  
     n = 0;%     XtSetArg(args[n], XmNx, 35); n++;s&     XtSetArg(args[n], XmNy, 555); n++;)     XtSetArg(args[n], XmNwidth, 90); n++;M*     XtSetArg(args[n], XmNheight, 30); n++;7     XtSetArg(args[n], XmNlabelString, label_text); n++;r0     XtSetArg(args[n], XmNsensitive, False); n++;B     CommitBtn = XmCreatePushButton(ModifyDlg, "Acommit", args, n);     XtManageChild(CommitBtn);t     XmStringFree (label_text);       XtAddCallback(CommitBtn,&                   XmNactivateCallback,                   PushButtonCB,T                   COMMIT_BTN);  &         /* Create the Cancel button */  7     label_text = XmStringCreateLtoR("Cancel", charset);a  
     n = 0;&     XtSetArg(args[n], XmNx, 200); n++;&     XtSetArg(args[n], XmNy, 555); n++;)     XtSetArg(args[n], XmNwidth, 90); n++;e*     XtSetArg(args[n], XmNheight, 30); n++;7     XtSetArg(args[n], XmNlabelString, label_text); n++;w/     XtSetArg(args[n], XmNsensitive, True); n++;EB     CancelBtn = XmCreatePushButton(ModifyDlg, "Acancel", args, n);     XtManageChild(CancelBtn);a     XmStringFree (label_text);       XtAddCallback(CancelBtn,&                   XmNactivateCallback,                   PopupDoneCB,                   CANCEL_BTN);       return;R }T    N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: UpdateOptsListL  * Description: LnmTool has two significant Table lists, the Main Table listJ  *              and the Modify Table list. Most of the time, one is mirrorK  *              of the other. Exceptions are, 1) at startup, the Main TablelM  *              is created by extracting all index defs from LNM$DCL_LOGICAL.eL  *              This list is then copied int the Modify Table list; 2) AfterJ  *              user selects the Confirm button on tthe Modify dialog, theH  *              contents of the Modify Table list are copied to the MainL  *              Table list. This routine's purpose in life is to verify thatF  *              any table active in either list does not appear in theI  *              Optional Tables list. It is called just prior to updatingyG  *              either list, and the caller specifies the list to checkaH  *              against. This would be a) commit changes to Main, b) theE  *              result of an Add/Remove operation from Modify dialog.t  *  *      Inputs: None  *     Returns: None  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */*" void UpdateOptsList(int SourceTbl) {d     int Match = FALSE;     int indx = 0;      int OptIndx;     int TblIndx;     int TableMax;_       OPTS_LST *OptsSrc;     OPTS_LST *OptsDest;L     OPTS_LST *OptsLast;      TABLE_LST *TablePtr;     TABLE_LST *TableRef;       cfree(AscOptsTableList);H     AscOptsTableList = (OPTS_LST *) calloc(NumOpts+1, sizeof(OPTS_LST));        OptsSrc = AscOptsMasterList;      OptsDest = AscOptsTableList;  !     if(SourceTbl == MODIFYLIST) {e&         TableRef = AscModifyTableList;         TableMax = NumModify;;     }      else {       /* MAINLIST */           TableRef = AscTableList;         TableMax = NumTbl;     }aH     if(LoggingEnabled) fprintf(lnmlog_fp, "Using List %d\n", SourceTbl);
 #ifdef LNMDBGf)     printf("Using List %d\n", SourceTbl);e #endif     NumAvailableOpts = NumOpts;s     OptIndx = 0;     TblIndx = 0;     TablePtr = TableRef;     while(OptIndx < NumOpts) {         Match = FALSE;#         while(TblIndx < TableMax) {8F             if(strcmp(OptsSrc->TableName, TablePtr->TableName) == 0) {                 Match = TRUE;a
             }          if(Match) {=F             if(LoggingEnabled) fprintf(lnmlog_fp, "Matched with %s\n",$                 OptsSrc->TableName);
 #ifdef LNMDBGa@                 printf("Matched with %s\n", OptsSrc->TableName); #endif#                 NumAvailableOpts--;o#                 TblIndx = TableMax; 
             }i             else {                 if(!indx) {eD                     strcpy(OptsDest->TableName, OptsSrc->TableName);-                     OptsDest->Active = FALSE;                      indx++;e                 }d                 TblIndx++;                 TablePtr++; 
             }b	         }r         indx = 0;P         OptIndx++;         OptsLast = OptsSrc;t         OptsSrc++;         if(!Match) OptsDest++;         TblIndx = 0;$         TablePtr = TableRef;             }l0     if(LoggingEnabled) fprintf(lnmlog_fp, "\n");
 #ifdef LNMDBGi     printf("\n");e #endif }     