N (*****************************************************************************N  *                               Q L O G I N                                 *N  *                              -------------                                *N  *                                                                           *N  *  This module is part of the QLogin package developed by Marc A. Shannon   *N  *  of the Computer Club at Carnegie-Mellon University.                      *N  *                                                                           *N  *  This program, either complete or in part, may not be redistributed for   *N  *  profit.  This program, and all modules, are:                             *N  *      Copyright (C) 1991 by Marc A. Shannon and the CMU Computer Club      *N  *                                                                           *N  *  Redistribution of this package is not otherwise restricted.              *N  *                                                                           *O  *****************************************************************************)  [Ident('V1.0'),   Environment('Queue'),  Inherit('Common',          'QueueDef',          'Interact',           'Sys$Library:Starlet')]
 Module Queue;   J { Queue maintains the list of users waiting for access to the system.  AllL   controls, such as releasing someone, adding someone new, etc. are provided	   here. }   % Var Queue : [Static, Volatile] Record <                                   Head, Tail : QueueEntryPtr#                                End;    [Asynchronous]+ Procedure Insert_Into_Queue(PID : Unsigned; 1                             Terminal : GenString; 2                             Terminal_Chan : Word);   Var NewEntry : QueueEntryPtr;    Begin      NumInQueue := NumInQueue + 1;    New(NewEntry);     NewEntry^.PID := PID;"    NewEntry^.Terminal := Terminal;,    NewEntry^.Terminal_Chan := Terminal_Chan;$    NewEntry^.EntryNum := NumInQueue;      If Queue.Head = Nil Then        Queue.Head := NewEntry    Else        Begin &          Queue.Tail^.Next := NewEntry;%          NewEntry^.Prev := Queue.Tail 
       End;    Queue.Tail := NewEntry;  '    Write_File(DevChan := Terminal_Chan, )               DataFile := 'QLOGIN_INFO');       NewEntry^.State := Notify;        If NumInQueue = 1 Then WakeUp End;   [Asynchronous]4 Procedure Delete_From_Queue(Var Entry : QueueEntry);   Begin (    $DASSGN(Chan := Entry.Terminal_Chan);    Resume_Proc(Entry.PID);    Entry.State := Unused; 	    WakeUp  End;  2 Procedure KillEntry(Var OldEntry : QueueEntryPtr);    Var UpdEntryNum : QueueEntryPtr;   Begin      If OldEntry^.Prev <> Nil Then-       OldEntry^.Prev^.Next := OldEntry^.Next;      If OldEntry^.Next <> Nil Then-       OldEntry^.Next^.Prev := OldEntry^.Prev;      If OldEntry = Queue.Head Then#       Queue.Head := OldEntry^.Next;      If OldEntry = Queue.Tail Then#       Queue.Tail := OldEntry^.Prev;        NumInQueue := NumInQueue - 1;  !    UpdEntryNum := OldEntry^.Next;     While UpdEntryNum <> Nil Do       Begin <          UpdEntryNum^.EntryNum := UpdEntryNum^.EntryNum - 1;-          If UpdEntryNum^.State = Waiting Then )             UpdEntryNum^.State := Notify; )          UpdEntryNum := UpdEntryNum^.Next 
       End;  	    WakeUp  End;   [Asynchronous,Global] 0 Procedure Dump_Queue(Var CurEntry : QueueEntry);   Var Loop : QueueEntryPtr;      TmpStr : LongString;   Begin     Loop := Queue.Head;    While Loop <> Nil Do        Begin @          WriteV(TmpStr, 'Queue #', Loop^.EntryNum:0, ': State=',;                 Loop^.State, ', Terminal=', Loop^.Terminal, ;                 ', Channel=', Hex(Loop^.Terminal_Chan, 4)); 5          Write_Out(DevChan := CurEntry.Terminal_Chan, #                    Data := TmpStr);           Loop := Loop^.Next 	       End  End;   End.