6 /* Supporting routines which may sometimes be missing..    Copyright (C) 1988 Free Software Foundation   This file is part of GNU Tar.   ? GNU Tar is free software; you can redistribute it and/or modify D it under the terms of the GNU General Public License as published byC the Free Software Foundation; either version 2, or (at your option)  any later version.  : GNU Tar is distributed in the hope that it will be useful,> but WITHOUT ANY WARRANTY; without even the implied warranty of= MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the , GNU General Public License for more details.  A You should have received a copy of the GNU General Public License ; along with GNU Tar; see the file COPYING.  If not, write to I the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */    #include <stdio.h> #include <sys/types.h> #include <signal.h>  #include <errno.h> #ifndef STDC_HEADERS extern int errno;  #endif   #ifdef BSD42 #include <sys/file.h>  #else 
 #ifndef V7 #include <fcntl.h> #endif #endif   #include "tar.h" #include "port.h"    extern long baserec;  ? /* All machine-dependent #ifdefs should appear here, instead of G    being scattered through the file.  For UN*X systems, it is better to E    figure out what is needed in the configure script, for most of the     features. */    #ifdef __MSDOS__ char TTY_NAME[] = "con";   #else /* not __MSDOS__ */    char TTY_NAME[] ="/dev/tty";   #endif /* not __MSDOS__ */  % /* End of system-dependent #ifdefs */      #ifndef HAVE_VALLOC  /*A  * valloc() does a malloc() on a page boundary.  On some systems, 0  * this can make large block I/O more efficient.  */  char *
 valloc (size)  	unsigned size;  {  	return (malloc (size)); }  #endif /* !HAVE_VALLOC */    #ifndef HAVE_MKDIR /*>  * Written by Robert Rother, Mariah Corporation, August 1985.   *B  * If you want it, it's yours.  All I ask in return is that if youA  * figure out how to do this in a Bourne Shell script you send me 
  * a copy.  *					sdcsvax!rmr or rmr@uscd  *C  * Severely hacked over by John Gilmore to make a 4.2BSD compatible #  * subroutine.	11Mar86; hoptoad!gnu   *L  * Modified by rmtodd@uokmax 6-28-87 -- when making an already existing dir,1  * subroutine didn't return EEXIST.  It does now.   */    /*  * Make a directory.  */  int  mkdir(dpath, dmode) 
 	char *dpath;  	int dmode;  {  	int cpid, status; 	struct stat statbuf;   ! 	if (stat(dpath,&statbuf) == 0) { : 		errno = EEXIST;		/* Stat worked, so it already exists */ 		return -1; 	}  H 	/* If stat fails for a reason other than non-existence, return error */! 	if (errno != ENOENT) return -1;     	switch (cpid = fork()) {   ! 	case -1:			/* Error in fork() */ ) 		return(-1);		/* Errno is set already */    	case 0:				/* Child process */  		/*9 		 * Cheap hack to set mode of new directory.  Since this : 		 * child process is going away anyway, we zap its umask.> 		 * FIXME, this won't suffice to set SUID, SGID, etc. on this# 		 * directory.  Does anybody care?  		 */ , 		status = umask(0);	/* Get current umask */? 		status = umask(status | (0777 & ~dmode)); /* Set for mkdir */ 1 		execl("/bin/mkdir", "mkdir", dpath, (char *)0); ) 		_exit(-1);		/* Can't exec /bin/mkdir */  	   	default:			/* Parent process */> 		while (cpid != wait(&status)) ;	/* Wait for kid to finish */ 	}  9 	if (WTERMSIG(status) != 0 || WEXITSTATUS(status) != 0) { , 		errno = EIO;		/* We don't know why, but */% 		return -1;		/* /bin/mkdir failed */  	}  
 	return 0; }    int  rmdir(dpath)
 	char *dpath;  {  	int cpid, status; 	struct stat statbuf;   ! 	if (stat(dpath,&statbuf) != 0) { . 		/* Stat just set errno.  We don't have to */ 		return -1; 	}   	switch (cpid = fork()) {   ! 	case -1:			/* Error in fork() */ ) 		return(-1);		/* Errno is set already */    	case 0:				/* Child process */ 1 		execl("/bin/rmdir", "rmdir", dpath, (char *)0); ) 		_exit(-1);		/* Can't exec /bin/mkdir */  	   	default:			/* Parent process */> 		while (cpid != wait(&status)) ;	/* Wait for kid to finish */ 	}  9 	if (WTERMSIG(status) != 0 || WEXITSTATUS(status) != 0) { , 		errno = EIO;		/* We don't know why, but */% 		return -1;		/* /bin/mkdir failed */  	}  
 	return 0; }  #endif /* !HAVE_MKDIR */   #ifndef HAVE_RENAME  /* Rename file FROM to file TO. (    Return 0 if successful, -1 if not. */   int  rename (from, to)       char *from;      char *to; {    struct stat from_stats;      if (stat (from, &from_stats))      return -1;  %   if (unlink (to) && errno != ENOENT)      return -1;     if (link (from, to))     return -1;  '   if (unlink (from) && errno != ENOENT)      {        unlink (to);       return -1;     }      return 0;  }  #endif /* !HAVE_RENAME */    #ifdef minixB /* Minix has bcopy but not bzero, and no memset.  Thanks, Andy. */ void
 bzero (s1, n)  	register char *s1;  	register int n; {  	while (n--) *s1++ = '\0'; }    /* It also has no bcmp() */  int  bcmp (s1, s2, n)   	register char *s1,*s2;  	register int n; {  	for ( ; n-- ; ++s1, ++s2) {# 		if (*s1 != *s2) return *s1 - *s2;  	}
 	return 0; }    /*+  * Groan, Minix doesn't have execlp either!   *-  * execlp(file,arg0,arg1...argn,(char *)NULL) B  * exec a program, automatically searching for the program through#  * all the directories on the PATH.   *B  * This version is naive about variable argument lists, it assumesG  * a straightforward C calling sequence.  If your system has odd stacks 0  * *and* doesn't have execlp, YOU get to fix it.  */  int  execlp(filename, arg0) 	char *filename, *arg0;  {  	register char *p, *path;      	register char *fnbuffer;  	char **argstart = &arg0;  	struct stat statbuf;  	extern char **environ;   $ 	if ((p = getenv("PATH")) == NULL) {A 		/* couldn't find path variable -- try to exec given filename */ - 		return execve(filename, argstart, environ);  	}   	/* A 	 * make a place to build the filename.  We malloc larger than we * 	 * need, but we know it will fit in this. 	 */7 	fnbuffer = malloc( strlen(p) + 1 + strlen(filename) );  	if (fnbuffer == NULL) { 		errno = ENOMEM;  		return -1; 	}   	/* = 	 * try each component of the path to see if the file's there  	 * and executable.  	 */# 	for (path = p ; path ; path = p) { ' 		/* construct full path name to try */ & 		if ((p = index(path,':')) == NULL) { 			strcpy(fnbuffer, path);
 		} else {# 			strncpy(fnbuffer, path, p-path);  			fnbuffer[p-path] = '\0'; # 			p++;		/* Skip : for next time */  		}  		if (strlen(fnbuffer) != 0) 			strcat(fnbuffer,"/"); 		strcat(fnbuffer,filename);  : 		/* check to see if file is there and is a normal file */% 		if (stat(fnbuffer, &statbuf) < 0) {  			if (errno == ENOENT) 2 				continue; /* file not there,keep on looking */ 			else 3 				goto fail; /* failed for some reason, return */  		} * 		if (!S_ISREG(statbuf.st_mode)) continue;  - 		if (execve(fnbuffer, argstart, environ) < 0  		    && errno != ENOENT 		    && errno != ENOEXEC) {1 			/* failed, for some other reason besides "file & 			 * not found" or "not a.out format" 			 */
 			goto fail;  		}    		/*; 		 * If we got error ENOEXEC, the file is executable but is > 		 * not an object file.  Try to execute it as a shell script,1 		 * returning error if we can't execute /bin/sh.  		 *7 		 * FIXME, this code is broken in several ways.  Shell < 		 * scripts should not in general be executed by the user's9 		 * SHELL variable program.  On more mature systems, the 9 		 * script can specify with #!/bin/whatever.  Also, this 8 		 * code clobbers argstart[-1] if the exec of the shell 		 * fails.  		 */  		if (errno == ENOEXEC) {  			char *shell;   2 			/* Try to execute command "sh arg0 arg1 ..." */) 			if ((shell = getenv("SHELL")) == NULL)  				shell = "/bin/sh"; 			argstart[-1] = shell; 			argstart[0] = fnbuffer;) 			execve(shell, &argstart[-1], environ); $ 			goto fail;	/* Exec didn't work */ 		}    		/*  8 		 * If we succeeded, the execve() doesn't return, so we; 		 * can only be here is if the file hasn't been found yet. $ 		 * Try the next place on the path. 		 */  	}  8 	/* all attempts failed to locate the file.  Give up. */ 	errno = ENOENT;   fail:t 	free(fnbuffer); 	return -1;( }1 #endif /* minix */     #ifdef EMUL_OPEN3s #include "open3.h" /*9  * open3 -- routine to emulate the 3-argument open systemf4  * call that is present in most modern Unix systems.I  * This version attempts to support all the flag bits except for O_NDELAYyO  * and O_APPEND, which are silently ignored.  The emulation is not as efficientlK  * as the real thing (at worst, 4 system calls instead of one), but there's    * not much I can do about that.  *#  * Written 6/10/87 by rmtodd@uokmax   *  * open3(path, flag, mode))  * Attempts to open the file specified byGC  * the given pathname.  The following flag bits (#defined in tar.h) "  * specify options to the routine:#  *	O_RDONLY	file open for read only,$  *	O_WRONLY	file open for write only*  *	O_RDWR		file open for both read & write?  * (Needless to say, you should only specify one of the above).oC  * 	O_CREAT		file is created with specified mode if it needs to be.76  *	O_TRUNC		if file exists, it is truncated to 0 bytesB  *	O_EXCL		used with O_CREAT--routine returns error if file existsG  * Function returns file descriptor if successful, -1 and errno if not.t  */l   /*6  * array to give arguments to access for various modesE  * FIXME, this table depends on the specific integer values of O_XXX,iJ  * and also contains integers (args to 'access') that should be #define's.  */Y static int modes[] = 	{ 		04, /* O_RDONLY */ 		02, /* O_WRONLY */ 		06, /* O_RDWR */; 		06, /* invalid but we'd better cope -- O_WRONLY+O_RDWR */  	};p  @ /* Shut off the automatic emulation of open(), we'll need it. */ #undef open.   int  open3(path, flags, mode) char *path;  int flags, mode; {  	int exists = 1; 	int call_creat = 0; 	int fd; 	/*EC 	 * We actually do the work by calling the open() or creat() system9E 	 * call, depending on the flags.  Call_creat is true if we will use f) 	 * creat(), false if we will use open().r 	 */   	/*pD 	 * See if the file exists and is accessible in the requested mode.  	 * G 	 * Strictly speaking we shouldn't be using access, since access checks1B 	 * against real uid, and the open call should check against euid.= 	 * Most cases real uid == euid, so it won't matter.   FIXME. C 	 * FIXME, the construction "flags & 3" and the modes table depends @ 	 * on the specific integer values of the O_XXX #define's.  Foo! 	 */) 	if (access(path,modes[flags & 3]) < 0) {t 		if (errno == ENOENT) {  			/* the file does not exist */ 			exists = 0;
 		} else {& 			/* probably permission violation */ 			if (flags & O_EXCL) {3 				/* Oops, the file exists, we didn't want it. */;1 				/* No matter what the error, claim EEXIST. */E 				errno = EEXIST;	 			}
 			return -1;  		}t 	}  7 	/* if we have the O_CREAT bit set, check for O_EXCL */e 	if (flags & O_CREAT) {w# 		if ((flags & O_EXCL) && exists) {p8 			/* Oops, the file exists and we didn't want it to. */ 			errno = EEXIST;
 			return -1;G 		}t 		/*? 		 * If the file doesn't exist, be sure to call creat() so thata- 		 * it will be created with the proper mode.k 		 */  		if (!exists) call_creat = 1;	 	} else {	? 		/* If O_CREAT isn't set and the file doesn't exist, error. */* 		if (!exists) { 			errno = ENOENT;
 			return -1;  		}s 	}   	/*lC 	 * If the O_TRUNC flag is set and the file exists, we want to callWB 	 * creat() anyway, since creat() guarantees that the file will be- 	 * truncated and open()-for-writing doesn't.*D 	 * (If the file doesn't exist, we're calling creat() anyway and the+ 	 * file will be created with zero length.)  	 */1 	if ((flags & O_TRUNC) && exists) call_creat = 1;* 	/* actually do the call */' 	if (call_creat) { 		/*= 		 * call creat.  May have to close and reopen the file if weo9 		 * want O_RDONLY or O_RDWR access -- creat() only givess 		 * O_WRONLY. 		 */s 		fd = creat(path,mode);. 		if (fd < 0 || (flags & O_WRONLY)) return fd; 		if (close(fd) < 0) return -1;d1 		/* Fall out to reopen the file we've created */i 	}   	/* B 	 * calling old open, we strip most of the new flags just in case. 	 */@ 	return open(path, flags & (O_RDONLY|O_WRONLY|O_RDWR|O_BINARY)); }  #endif /* EMUL_OPEN3 */i   #ifndef HAVE_MKNOD #ifdef __MSDOS__ typedef int dev_t; #endif /* Fake mknod by complaining */F into mknod(path, mode, dev)
 	char		*path;- 	unsigned short	mode;e 	dev_t		dev; { 	 	int		fd;f 	;0 	errno = ENXIO;		/* No such device or address */% 	return -1;		/* Just give an error */  }u   /* Fake links by copying */e int! link(path1, path2) 	char		*path1; 	char		*path2; {  	char	buf[256];  	int	ifd, ofd;
 	int	nrbytes;N
 	int	nwbytes;   @ 	fprintf(stderr, "%s: %s: cannot link to %s, copying instead\n", 		tar, path1, path2); 0 	if ((ifd = open(path1, O_RDONLY|O_BINARY)) < 0) 		return -1;$ 	if ((ofd = creat(path2, 0666)) < 0) 		return -1; /*	setmode(ofd, O_BINARY); */ 6 	while ((nrbytes = read(ifd, buf, sizeof(buf))) > 0) {8 		if ((nwbytes = write(ofd, buf, nrbytes)) != nrbytes) { 			nrbytes = -1;	 			break;f 		}; 	}< 	/* Note use of "|" rather than "||" below: we want to close& 	 * the files even if an error occurs. 	 */= 	if ((nrbytes < 0) | (0 != close(ifd)) | (0 != close(ofd))) {) 		unlink(path2); 		return -1; 	}
 	return 0; }f  I /* everyone owns everything on MS-DOS (or is it no one owns anything?) */s ints chown(path, uid, gid)r 	char	*path;	 	int	uid; 	 	int	gid;h {r
 	return 0; }s   int.	 geteuid()y {m
 	return 0; }  #endif	/* !HAVE_MKNOD */   #ifdef __TURBOC__i #include <time.h>c #include <fcntl.h> #include <io.h>*   struct utimbuf { %   time_t  actime;		/* Access time. */n,   time_t  modtime;		/* Modification time. */ };   intf+ utime (char *filename, struct utimbuf *utb)e {"   struct tm *tm;   struct ftime filetime;   time_t when;	   int fd;e
   int status;      if (utb == 0)e     when = time (0);   else     when = utb->modtime;      fd = _open (filename, O_RDWR);   if (fd == -1)      return -1;     tm = localtime (&when);/   if (tm->tm_year < 80)l     filetime.ft_year = 0;)   else(     filetime.ft_year = tm->tm_year - 80;%   filetime.ft_month = tm->tm_mon + 1;h    filetime.ft_day = tm->tm_mday;   if (tm->tm_hour < 0)     filetime.ft_hour = 0;(   else#     filetime.ft_hour = tm->tm_hour;t   filetime.ft_min = tm->tm_min;($   filetime.ft_tsec = tm->tm_sec / 2;  $   status = setftime (fd, &filetime);   _close (fd);   return status; }f #endif /* __TURBOC__ */   F /* Stash argv[0] here so panic will know what the program is called */ char *myname = 0;"   void panic(s) char *s; {e 	if(myname)e 		fprintf(stderr,"%s:",myname);  	fprintf(stderr,s);f 	putc('\n',stderr);t
 	exit(12); }	     PTRo ck_malloc(size)	 size_t size; { 	 	PTR ret;e  
 	if(!size)	 		size++;  	ret=malloc(size); 	if(ret==0)m$ 		panic("Couldn't allocate memory"); 	return ret; }o  ( /* Used by alloca.c and bison.simple. */ char *
 xmalloc(size)	 size_t size; {N! 	return (char *) ck_malloc(size);  }/   PTRd ck_realloc(ptr,size) PTR ptr; size_t size; { 	 	PTR ret;n  	 	if(!ptr)a 		ret=ck_malloc(size); 	else  		ret=realloc(ptr,size); 	if(ret==0) ' 		panic("Couldn't re-allocate memory");a 	return ret; }r  K /* Implement a variable sized buffer of 'stuff'.  We don't know what it is,iN    nor do we care, as long as it doesn't mind being aligned on a char boundry.  */s   struct buffer {l 	int	allocated;h 	int	length;	 	char	*b;a };   #define MIN_ALLOCATE 50s   char *
 init_buffer()a {p 	struct buffer *b;  5 	b=(struct buffer *)ck_malloc(sizeof(struct buffer));t 	b->allocated=MIN_ALLOCATE;i& 	b->b=(char *)ck_malloc(MIN_ALLOCATE);
 	b->length=0;l 	return (char *)b; }u   void flush_buffer(bb)	 char *bb;i {( 	struct buffer *b;   	b=(struct buffer *)bb;  	free(b->b); 	b->b=0; 	b->allocated=0;
 	b->length=0;b 	free((void *)b);h },   void add_buffer(bb,p,n)	 char *bb;l char *p; int n; {  	struct buffer *b;   	b=(struct buffer *)bb;x 	if(b->length+n>b->allocated) {*( 		b->allocated=b->length+n+MIN_ALLOCATE;- 		b->b=(char *)ck_realloc(b->b,b->allocated);p 	} 	bcopy(p,b->b+b->length,n);p 	b->length+=n; }    char * get_buffer(bb)	 char *bb;N {  	struct buffer *b;   	b=(struct buffer *)bb;e
 	return b->b;/ }    char * merge_sort(list,n,off,cmp) char *list;e
 int (*cmp)();o unsigned n;3 int off; {n 	char *ret;c   	char *alist,*blist; 	unsigned alength,blength;   	char *tptr;	 	int tmp;u
 	char **prev;l: #define NEXTOF(ptr)	(* ((char **)(((char *)(ptr))+off) ) )	 	if(n==1)e 		return list; 	if(n==2) {f# 		if((*cmp)(list,NEXTOF(list))>0) {r 			ret=NEXTOF(list); 			NEXTOF(ret)=list; 			NEXTOF(list)=0; 			return ret; 		}* 		return list; 	} 	alist=list; 	alength=(n+1)/2;p
 	blength=n/2;)7 	for(tptr=list,tmp=(n-1)/2;tmp;tptr=NEXTOF(tptr),tmp--)n 		;n 	blist=NEXTOF(tptr); 	NEXTOF(tptr)=0;  ) 	alist=merge_sort(alist,alength,off,cmp);:) 	blist=merge_sort(blist,blength,off,cmp);O
 	prev = &ret;e 	for(;alist && blist;) { 		if((*cmp)(alist,blist)<0) {i 			tptr=NEXTOF(alist); 			*prev = alist;e 			prev = &(NEXTOF(alist));	 			alist=tptr;
 		} else { 			tptr=NEXTOF(blist); 			*prev = blist;T 			prev = &(NEXTOF(blist));r 			blist=tptr; 		}* 	}
 	if(alist) 		*prev = alist; 	elsen 		*prev = blist;   	return ret; }e   void ck_close(fd) int fd;s {, 	if(close(fd)<0) {* 		msg_perror("can't close a file #%d",fd); 		exit(EX_SYSTEM); 	} }    #include <ctype.h>  G /* Quote_copy_string is like quote_string, but instead of modifying thegH    string in place, it malloc-s a copy  of the string, and returns that.H    If the string does not have to be quoted, it returns the NULL string.D    The allocated copy can, of course, be freed with free() after the    caller is done with it.  */  char * quote_copy_string(string)f
 char *string;  {n 	char	*from_here;) 	char	*to_there = 0; 	char	*copy_buf = 0; 	int	c;; 	int	copying = 0;    	from_here=string; 	while(*from_here) { 		c= *from_here++; 		if(c=='\\') {s 			if(!copying) {e
 				int n;   				n=(from_here-string)-1;f 				copying++;5 				copy_buf=(char *)malloc(n+5+strlen(from_here)*4);p 				if(!copy_buf)l 					return 0; 				bcopy(string,copy_buf,n);e 				to_there=copy_buf+n; 			} 			*to_there++='\\'; 			*to_there++='\\'; 		} else if(isprint(c)) {d 			if(copying) 				*to_there++= c;n
 		} else { 			if(!copying) {i
 				int	n;   				n=(from_here-string)-1;  				copying++;5 				copy_buf=(char *)malloc(n+5+strlen(from_here)*4);  				if(!copy_buf)e 					return 0; 				bcopy(string,copy_buf,n);  				to_there=copy_buf+n; 			} 			*to_there++='\\'; 			if(c=='\n') *to_there++='n';e$ 			else if(c=='\t') *to_there++='t';$ 			else if(c=='\f') *to_there++='f';$ 			else if(c=='\b') *to_there++='b';$ 			else if(c=='\r') *to_there++='r';& 			else if(c=='\177') *to_there++='?';	 			else {E 				to_there[0]=(c>>6)+'0';T  				to_there[1]=((c>>3)&07)+'0'; 				to_there[2]=(c&07)+'0';T 				to_there+=3; 			} 		}e 	} 	if(copying) { 		*to_there='\0';s 		return copy_buf; 	} 	return (char *)0; }e    B /* Un_quote_string takes a quoted c-string (like those produced by?    quote_string or quote_copy_string and turns it back into the(.    un-quoted original.  This is done in place.  */o  : /* There is no un-quote-copy-string.  Write it yourself */   char * un_quote_string(string)d
 char *string;r {. 	char *ret;e 	char *from_here;= 	char *to_there;	 	int	tmp;s   	ret=string; 	to_there=string;a 	from_here=string; 	while(*from_here) { 		if(*from_here!='\\') { 			if(from_here!=to_there) 				*to_there++= *from_here++; 			elsen 				from_here++,to_there++;  			continue; 		}t 		switch(*++from_here) { 		case '\\': 			*to_there++= *from_here++;w	 			break;n 		case 'n':  			*to_there++= '\n';& 			from_here++;e	 			break;/ 		case 't':  			*to_there++= '\t';_ 			from_here++;		 			break;a 		case 'f':t 			*to_there++= '\f';f 			from_here++;w	 			break;Y 		case 'b':c 			*to_there++= '\b';e 			from_here++;.	 			break;	 		case 'r':t 			*to_there++= '\r';| 			from_here++;L	 			break;f 		case '?':s 			*to_there++= 0177;  			from_here++;r	 			break;i 		case '0':t 		case '1':  		case '2':l 		case '3':  		case '4':  		case '5':a 		case '6':s 		case '7':t 			tmp= *from_here - '0';D 			from_here++;D) 			if(*from_here<'0' || *from_here>'7') {i 				*to_there++= tmp; 
 				break; 			} 			tmp= tmp*8 + *from_here-'0';k 			from_here++;i) 			if(*from_here<'0' || *from_here>'7') {a 				*to_there++= tmp;h
 				break; 			} 			tmp=tmp*8 + *from_here-'0'; 			from_here++;o 			*to_there=tmp;r	 			break;t
 		default:	 			ret=0;n 			*to_there++='\\'; 			*to_there++= *from_here++; 	 			break;  		}) 	} 	if(*to_there) 		*to_there++='\0';a 	return ret; }t   void ck_pipe(pipes)s int *pipes;t {  	if(pipe(pipes)<0) {" 		msg_perror("can't open a pipe"); 		exit(EX_SYSTEM); 	} }a     #ifndef HAVE_STRSTRp /*0  * strstr - find first occurrence of wanted in s  */r  - char *				/* found string, or NULL if none */o strstr(s, wanted)  char *s;
 char *wanted;f {b 	register char *scan;{ 	register size_t len;e 	register char firstc;   	if (*wanted == '\0')- 	  return (char *)0; 	/*/< 	 * The odd placement of the two tests is so "" is findable.- 	 * Also, we inline the first char for speed. 8 	 * The ++ on scan has been moved down for optimization. 	 */ 	firstc = *wanted; 	len = strlen(wanted);E 	for (scan = s; *scan != firstc || strncmp(scan, wanted, len) != 0; )i 		if (*scan++ == '\0') 			return (char *)0;
 	return scan;d }  #endif /* !HAVE_STRSTR */    #ifndef HAVE_FTRUNCATE   #ifdef F_CHSIZEe int/ ftruncate (fd, length)      int fd;      off_t length; {i&   return fcntl (fd, F_CHSIZE, length); }t #else /* !F_CHSIZE */  #ifdef F_FREESPs@ /* code courtesy of William Kucharski, kucharsk@Solbourne.com */   intm ftruncate(fd, length)c3 int fd;                       /* file descriptor */e1 off_t length;         /* length to set file to */s {  	struct flock fl;    	fl.l_whence = 0;  	fl.l_len = 0; 	fl.l_start = length;d7 	fl.l_type = F_WRLCK;    /* write lock on file space */n   	/* 8 	 * This relies on the UNDOCUMENTED F_FREESP argument to= 	 * fcntl(2), which truncates the file so that it ends at thee% 	 * position indicated by fl.l_start.m 	 *1$ 	 * Will minor miracles never cease? 	 */  " 	if (fcntl(fd, F_FREESP, &fl) < 0) 	    return -1;   
 	return 0; }r   #else /* !F_FREESP */i   inti ftruncate(fd, length)e int fd;s
 off_t length;  {;
 	errno = EIO;s 	return -1;& }e #endif /* !F_FREESP */ #endif /* !F_CHSIZE */ #endif /* !HAVE_FTRUNCATE */     extern FILE *msg_file;  & #if defined (HAVE_VPRINTF) && __STDC__ #include <stdarg.h>o   void msg(char *str,...) {( 	va_list args;   	va_start(args,str); 	fflush(msg_file); 	fprintf(stderr,"%s: ",tar); 	if(f_sayblock) > 		fprintf(stderr,"rec %d: ",baserec + (ar_record - ar_block)); 	vfprintf(stderr,str,args);i 	va_end(args); 	putc('\n',stderr);  	fflush(stderr); }r   void msg_perror(char *str,...). {n 	va_list args; 	int save_e;   	save_e=errno; 	fflush(msg_file); 	fprintf(stderr,"%s: ",tar); 	if(f_sayblock)a> 		fprintf(stderr,"rec %d: ",baserec + (ar_record - ar_block)); 	va_start(args,str); 	vfprintf(stderr,str,args);( 	va_end(args); 	errno=save_e;
 	perror(" ");a 	fflush(stderr); }r& #endif /* HAVE_VPRINTF and __STDC__ */  & #if defined(HAVE_VPRINTF) && !__STDC__ #include <varargs.h> void msg(str,va_alist)d
 char *str; va_dcl {e 	va_list args;   	fflush(msg_file); 	fprintf(stderr,"%s: ",tar); 	if(f_sayblock)	> 		fprintf(stderr,"rec %d: ",baserec + (ar_record - ar_block)); 	va_start(args); 	vfprintf(stderr,str,args);k 	va_end(args); 	putc('\n',stderr);> 	fflush(stderr); }E   void msg_perror(str,va_alist)
 char *str; va_dcl {l 	va_list args; 	int save_e;   	save_e=errno; 	fflush(msg_file); 	fprintf(stderr,"%s: ",tar); 	if(f_sayblock) > 		fprintf(stderr,"rec %d: ",baserec + (ar_record - ar_block)); 	va_start(args); 	vfprintf(stderr,str,args);h 	va_end(args); 	errno=save_e;
 	perror(" ");* 	fflush(stderr); }e* #endif /* HAVE_VPRINTF and not __STDC__ */  2 #if !defined(HAVE_VPRINTF) && defined(HAVE_DOPRNT) void
 msg(str,args)>
 char *str;	 int args;y {b 	fflush(msg_file); 	fprintf(stderr,"%s: ",tar); 	if(f_sayblock)h> 		fprintf(stderr,"rec %d: ",baserec + (ar_record - ar_block)); 	_doprnt(str, &args, stderr);g 	putc('\n',stderr);) 	fflush(stderr); }*   void msg_perror(str,args)
 char *str; {r 	int save_e;   	save_e=errno; 	fflush(msg_file); 	fprintf(stderr,"%s: ",tar); 	if(f_sayblock)l> 		fprintf(stderr,"rec %d: ",baserec + (ar_record - ar_block)); 	_doprnt(str, &args, stderr);= 	errno=save_e;
 	perror(" ");( 	fflush(stderr); }N* #endif /* !HAVE_VPRINTF and HAVE_DOPRNT */  3 #if !defined(HAVE_VPRINTF) && !defined(HAVE_DOPRNT)a void msg(str,a1,a2,a3,a4,a5,a6)b
 char *str; {f 	fflush(msg_file); 	fprintf(stderr,"%s: ",tar); 	if(f_sayblock)t> 		fprintf(stderr,"rec %d: ",baserec + (ar_record - ar_block));' 	fprintf(stderr,str,a1,a2,a3,a4,a5,a6);l 	putc('\n',stderr);e 	fflush(stderr); }s   void! msg_perror(str,a1,a2,a3,a4,a5,a6) 
 char *str; {T 	int save_e;   	save_e=errno; 	fflush(msg_file); 	fprintf(stderr,"%s: ",tar); 	if(f_sayblock)E> 		fprintf(stderr,"rec %d: ",baserec + (ar_record - ar_block));' 	fprintf(stderr,str,a1,a2,a3,a4,a5,a6);p 	fprintf(stderr,": "); 	errno=save_e;
 	perror(" ");  } + #endif /* !HAVE_VPRINTF and !HAVE_DOPRNT */(