 /*  *  R  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  *    *   Facility:  		LIST.H  *  (  *   Author:          	Baron L. Chandler  *  3  *   Organization:     	Western Kentucky Unviersity .  * 			Academic Computing and Research Services(  * 			Bowling Green, Kentucky USA  42101  *  =  *   Purpose:		These routines provide support for the dynamic 6  * 			allocation of data storage for the queue and job  * 			information in QUE_MON.   *    *   Revision History:  *  M  *        01-000         Baron L. Chandler                  January 29, 1992    * 			Created.  *  R  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  *    */     < #include <stdlib.h>			/* standard text processing library */: #include <string.h>			/* string description library	    */  A /*                       -=*( List Node Structure )*=-			      */    struct listnode        {  	char *data; 	struct listnode *next;      };  K globalvalue long que_mon_notpresent, que_mon_errdurdel, que_mon_errdurretr;      /*  *  R  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  *    * Function:	create_list   * Author:    	Baron L. Chandler  * Date:      	January 29, 1992   *  +  * Function:  	Initializes the linked list.   *  0  * Inputs:    Address of the list to initialize.  *  R  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  *    */   = /*                           -=*( Create List )*=-			      */   " create_list(struct listnode *list)   {        list->data = 0;      list->next = 0;       }      /*  *  R  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  *    * Function:	insert_element    * Author:    	Baron L. Chandler  * Date:      	January 29, 1992   *  4  * Function:  	Puts something into the linked list..  *  M  * Inputs:      Address of the list, the data, and the size of the data to be 
  *		inserted.   *  R  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  *    */   @ /*                           -=*( Insert Element )*=-			      */  B insert_element(struct listnode *list, char datum[], int datumsize)   {     struct listnode *tmp, *tempnode;  6     /* Create a new node and allocate memory for it */  /     tempnode = malloc(sizeof(struct listnode));      (*tempnode).next = 0; )     (*tempnode).data = malloc(datumsize); /     memcpy(tempnode -> data, datum, datumsize);    2     /* Traverse the list until reaching the end */       tmp = list;      while (tmp->next)          tmp = tmp->next;  -     /* Add new node to the end of the list */        tmp->next = tempnode;        return tempnode->data;   }    /*  *  R  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  *    * Function:	destroy_list    * Author:    	Baron L. Chandler  * Date:      	January 29, 1992   *  G  * Function:  	Deletes all nodes in the list and frees up their memory.   *  -  * Inputs:    Address of the list to destroy.   *  R  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  *    */   > /*                           -=*( Destroy List )*=-			      */    # destroy_list(struct listnode *list)    {    struct listnode *tmp, *next;  P     /* Traverse and de-allocate dynamic storage as you move from node to node */       tmp = list;      while (tmp->next) {  	    next = tmp->next; 	    free(tmp->data);  	    free(tmp);  	    tmp = next; 	}  ;     /* Reset the list pointers so that it is again empty */        list -> next =0;     list -> data =0;   }    /*  *  R  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  *    * Function:	delete_element    * Author:    	Baron L. Chandler  * Date:      	January 29, 1992   *  C  * Function:  	Deletes a specified element from the list structure.   *  @  * Inputs:    	Address of the list to modify, element to delete.  *  R  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  *    */   @ /*                           -=*( Delete Element )*=-			      */    @ delete_element(struct listnode *list, char data[], int datasize)   {    struct listnode *tmp, *prev; int found = 0;  I     /* Traverse the list looking for the data.  Set found to 1 when we */ 4     /* find the data we are looking for.			       */          tmp = list; 
     prev = 0; &     while ( (tmp->next) && (!found)) {         prev=tmp;  	tmp = tmp->next; / 	if ( !(memcmp( (tmp->data) , data, datasize)))  		found = 1; 	}  @     /* Check for an error, although there should never be one */       if (!found) { 5   	lib$signal(que_mon_errdurdel, que_mon_notpresent);  	return;     }   J     /* Delete the current node, tmp, by looping around it, then free it */       prev->next = tmp->next;      free(tmp->data);     free(tmp);    }   /*  *  R  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  *    * Function:	retrieve_element    * Author:    	Baron L. Chandler  * Date:      	January 29, 1992   *  @  * Function:  	Locate an element in a list and return its value.  *  F  * Inputs:    Address of the list to search, data for which to search.  *  R  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  *    */   @ /*                         -=*( Retrieve Element )*=-			      */  B retrieve_element(struct listnode *list, char data[], int datasize)   {    struct listnode *tmp, *prev; int found = 0;  2     /* Traverse the list and locate the element */       tmp = list; 
     prev = 0; &     while ( (tmp->next) && (!found)) {         prev=tmp;  	tmp = tmp->next; , 	if ( !(memcmp( tmp->data, data, datasize))) 		found = 1; 	}       if (!found) { 4 	lib$signal(que_mon_errdurretr, que_mon_notpresent); 	return;     }        return tmp->data;     }     /*  *  R  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  *    * Function:	get_element   * Author:    	Baron L. Chandler  * Date:      	January 29, 1992   *  G  * Function:  	Retrieves a specific element from the list, specified by +  *		the number of its position in the list.   *  K  * Inputs:    Address of the list to search, the position number to return.   *  R  * =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  *    */   + get_element(struct listnode *list, int num)    {        struct listnode *tmp;      int count = 0;       tmp = list->next; -     while ( (tmp->next) && (count != num) ) {  	count = count + 1;  	tmp = tmp->next;  	}       if (count!=num) { 4 	lib$signal(que_mon_errdurretr, que_mon_notpresent); 	return;     }        return tmp->data;    } 