H *======================================================================= *      *  Title:        SWING *                  *  Version:      1-001 *                 G *  Abstract:     SWING is a VMS utility for displaying and manipulating % *                VMS directory trees.  *                  *  Environment:  VMS *                 > *  Author:       Eric Andresen of General Research Corporation *                  *  Date:         24-SEP-1986   *                 H *-----------------------------------------------------------------------         program swing          include '($smgdef)'        include 'swing.cmn'   B       integer    ikey, old_level, old_line, isave, code, code_type       logical    crt, finished0       character  key, choice*(PD_MAX_CHOICE_LEN)         if ( .not. crt() )  C      .   call print_message( 'You must use a DEC CRT terminal', 1 )          call be_square       call load_nodes        call define_smg_layout       call load_display        call draw_screen  "       do while ( .not. finished )   2          call smg$read_keystroke( keyboard, ikey )  %          call print_message( ' ', 0 )             old_line = cur_line          old_level = cur_level(          old_rend = node(node_num).rend   )          if ( ikey .eq. smg$k_trm_do .or. .      .        ikey .eq. smg$k_trm_ctrlp ) then;             call pd_get_choice( board_id, keyboard, width,  <      .                          pull_choices, choice, code )!             code_type = code / 10              else             code_type = 0              code = 0             end if  -          if ( ikey .eq. smg$k_trm_ctrlz .or.  2      .        ikey .eq. smg$k_trm_lowercase_x .or.2      .        ikey .eq. smg$k_trm_uppercase_x .or.2      .        ikey .eq. smg$k_trm_lowercase_e .or.2      .        ikey .eq. smg$k_trm_uppercase_e .or.,      .        ikey .eq. smg$k_trm_enter .or.)      .        ikey .eq. smg$k_trm_cr .or. !      .        code .eq. 91 ) then              finished = .true.   3             else if ( ikey .eq. smg$k_trm_up ) then              ii = cur_level             jj = cur_line - 1 C             do while( node_pointer(ii,jj) .eq. 0 .and. jj .ge. 1 )                  jj = jj - 1             end do*             if ( jj .ge. 1 ) cur_line = jj5             call update_screen( old_line, old_level )   5             else if ( ikey .eq. smg$k_trm_down ) then              ii = cur_level             jj = cur_line + 1 I             do while( node_pointer(ii,jj) .eq. 0 .and.jj .le. num_lines)                  jj = jj + 1             end do2             if ( jj .le. num_lines ) cur_line = jj5             call update_screen( old_line, old_level )   6             else if ( ikey .eq. smg$k_trm_right ) then             ii = cur_level + 1             jj = cur_line I             do while( node_pointer(ii,jj) .eq. 0 .and.ii.le. MAX_LEVELS)                  ii = ii + 1             end do4             if ( ii .le. MAX_LEVELS ) cur_level = ii5             call update_screen( old_line, old_level )   5             else if ( ikey .eq. smg$k_trm_left .and.  -      .                cur_level .ge. 1 ) then              ii = cur_level - 1             jj = cur_line C             do while( node_pointer(ii,jj) .eq. 0 .and. jj .ge. 1 )                  jj = jj - 1             end do!             if ( jj .ge. 1 ) then                 cur_level = ii                 cur_line = jj                end if 5             call update_screen( old_line, old_level )   ,             else if ( code_type .eq. 1 .or. :      .                ikey .eq. smg$k_trm_lowercase_c .or.<      .                ikey .eq. smg$k_trm_uppercase_c ) then)             call create_directory( code )   ,             else if ( code_type .eq. 2 .or. :      .                ikey .eq. smg$k_trm_lowercase_r .or.<      .                ikey .eq. smg$k_trm_uppercase_r ) then(             call rename_directory( 20 )   ,             else if ( code_type .eq. 3 .or. :      .                ikey .eq. smg$k_trm_lowercase_m .or.<      .                ikey .eq. smg$k_trm_uppercase_m ) then(             call rename_directory( 30 )   ,             else if ( code_type .eq. 4 .or. :      .                ikey .eq. smg$k_trm_lowercase_d .or.<      .                ikey .eq. smg$k_trm_uppercase_d ) then)             call delete_directory( code )   ,             else if ( code_type .eq. 5 .or. :      .                ikey .eq. smg$k_trm_lowercase_p .or.<      .                ikey .eq. smg$k_trm_uppercase_p ) then!             call hardcopy( code )   ,             else if ( code_type .eq. 6 .or. :      .                ikey .eq. smg$k_trm_lowercase_s .or.<      .                ikey .eq. smg$k_trm_uppercase_s ) then+             call record_structure( .true. )   ,             else if ( code_type .eq. 7 .or. :      .                ikey .eq. smg$k_trm_lowercase_o .or.<      .                ikey .eq. smg$k_trm_uppercase_o ) then%             call change_options( 71 )   ,             else if ( code_type .eq. 8 .or. 2      .                ikey .eq. smg$k_trm_pf2 .or.3      .                ikey .eq. smg$k_trm_help .or. :      .                ikey .eq. smg$k_trm_lowercase_h .or.<      .                ikey .eq. smg$k_trm_uppercase_h ) then             call help( code )              end if  E          call smg$set_cursor_abs( window2, cur_line, cur_level*17+1 )          end do         call exit_swing 	       end          subroutine be_square         integer*2  len_root $       integer*4  sys$setddir, status       character  root*255   5       status = sys$setddir( %val(0), len_root, root )          do ii = 1, len_root 7          if ( root(ii:ii) .eq. '<'  ) root(ii:ii) = '[' 7          if ( root(ii:ii) .eq. '>'  ) root(ii:ii) = ']'        end do  @       status = sys$setddir( root(1:len_root), %val(0), %val(0) )         return	       end          subroutine help          include    'swing.cmn'       include    '($hlpdef)'  .       external   LIB$PUT_OUTPUT, LIB$GET_INPUT  2       integer    isave, flags, input, output, stat        integer    lbr$output_help  6       call smg$save_physical_screen( board_id, isave )         flags = hlp$m_prompt  %       output = %loc( lib$put_output ) $       input =  %loc( lib$get_input )  +       stat = lbr$output_help( %val(output), $      .                        width,&      .                        'swing',&      .                        'swing',$      .                        flags,+      .                        %val(input) )   9       call smg$restore_physical_screen( board_id, isave )          if ( .not. stat ) then          call print_message(  @      .        'There is no SWING.HLB help file in SYS$HELP', 0 )          end if          return	       end   '       subroutine change_options( code )          include    'swing.cmn'              integer code         if ( code .eq. 71 ) then(          use_window1 = .not. use_window1          end if   #       if ( .not. use_window1 ) then *          call smg$erase_display( window1 )
          else           call update_window1          end if          return	       end   *       subroutine rename_directory( code )          include    'swing.cmn'       include    '($ssdef)'        include    '($smgdef)'  B       character  new_dir*42, key, string*39, message*255, file*255@       integer    ikey, len_string, lib$rename_file, code, parentA       integer    sys$getmsg, istat, len_message, ipos, from_level 9       integer    old_line, old_level, from_num, from_line <       logical    dir_to_file, finished, check_directory_move         if ( code .eq. 20 ) then  %          call print_message( ' ', 0 ) 1          call smg$set_cursor_abs( window3, 1, 1 ) 1          call smg$read_string( keyboard, string,  D      .                         'Enter new name to give directory: ',;      .                         39,,,,len_string,, window3 )             new_dir = ' '          jj = 0             do ii = 1, len_stringI             if (string(ii:ii) .ne. '[' .and. string(ii:ii) .ne. ']'.and.  H      .         string(ii:ii) .ne. '<' .and. string(ii:ii) .ne. '>' .and.H      .         string(ii:ii) .ne. '.' .and. string(ii:ii) .gt. ' ' .and.,      .         string(ii:ii) .ne. ';' ) then                jj = jj + 1-                new_dir(jj:jj) = string(ii:ii)                 end if           end do   ,          call str$upcase( new_dir, new_dir )            if ( jj .ne. 0 ) then2             if ( dir_to_file( node(node_num).spec,5      .                        node(node_num).length,  1      .                        file, ipos ) ) then t                ISTAT = MODIFY_FILE_PROT(FILE, 32767, 1)		!Set protection on directory file to allow rename operation                 IF ( ISTAT ) THEN.                istat = lib$rename_file( file, B      .                                  new_dir(1:jj)//'.DIR;1',,,+      .                                  1 )   0                if ( istat .eq. ss$_normal ) thenI                   call file_to_dir( file(1:ipos)//new_dir(1:jj)//'.DIR',  8      .                              node(node_num).spec,:      .                              node(node_num).length,9      .                              node(node_num).name )                       parent = 04                   call move_node( node_num, parent )     +                   call adjust_node_pointers          #                   call load_display   0                   cur_line = node(node_num).line2                   cur_level = node(node_num).level  ;                   call update_screen( cur_line, cur_level )   A                   call print_message( 'Subdirectory renamed', 0 )   "                   do_save = .true.                     elseF                   call sys$getmsg( %val(istat), len_message, message, -      .                             %val(1), ) A                   call print_message( message(1:len_message), 0 )                    end if                ELSE C                CALL SYS$GETMSG( %VAL(ISTAT), LEN_MESSAGE, MESSAGE,  -      .                             %VAL(1), ) >                CALL PRINT_MESSAGE( MESSAGE(1:LEN_MESSAGE), 0 )                END IF                 end if              else-             call smg$erase_display( window3 )              end if  &          else if ( code .eq. 30 ) then            from_num = node_num          from_line = cur_line (          from_level = cur_level         :          node(from_num).rend = smg$m_reverse + smg$m_blink  H          call smg$change_rendition( window2, from_line, from_level*17+1,@      .                              1, 12, node(from_num).rend )  I          call print_message( 'Travel to new parent directory and hit '//  G      .                       'RETURN - Hit any other key to abort', 0 ) G          call smg$set_cursor_abs( window2, from_line, from_level*17+1 )             finished = .false.   %          do while ( .not. finished )    5             call smg$read_keystroke( keyboard, ikey )                old_line = cur_line !             old_level = cur_level +             old_rend = node(node_num).rend    -             if ( ikey .eq. smg$k_trm_cr .or.  1      .           ikey .eq. smg$k_trm_enter ) then                  finished = .true.  6                else if ( ikey .eq. smg$k_trm_up ) then                ii = cur_level                  jj = cur_line - 1F                do while( node_pointer(ii,jj) .eq. 0 .and. jj .ge. 1 )                    jj = jj - 1                 end do -                if ( jj .ge. 1 ) cur_line = jj 8                call update_screen( old_line, old_level )   8                else if ( ikey .eq. smg$k_trm_down ) then                ii = cur_level                  jj = cur_line + 19                do while( node_pointer(ii,jj) .eq. 0 .and. -      .                   jj .le. num_lines )                     jj = jj + 1                 end do 5                if ( jj .le. num_lines ) cur_line = jj 8                call update_screen( old_line, old_level )  9                else if ( ikey .eq. smg$k_trm_right ) then !                ii = cur_level + 1                 jj = cur_line  9                do while( node_pointer(ii,jj) .eq. 0 .and. .      .                   ii .le. MAX_LEVELS )                    ii = ii + 1                 end do 7                if ( ii .le. MAX_LEVELS ) cur_level = ii 8                call update_screen( old_line, old_level )  8                else if ( ikey .eq. smg$k_trm_left .and. 0      .                   cur_level .ge. 1 ) then!                ii = cur_level - 1                 jj = cur_lineF                do while( node_pointer(ii,jj) .eq. 0 .and. jj .ge. 1 )                    jj = jj - 1                 end do $                if ( jj .ge. 1 ) then                    cur_level = ii                   cur_line = jj                    end if8                call update_screen( old_line, old_level )                   else                  finished = .true.                end if   H             call smg$set_cursor_abs( window2, cur_line, cur_level*17+1 )            end do   ,          node(from_num).rend = smg$m_reverse  H          call smg$change_rendition( window2, from_line, from_level*17+1,@      .                              1, 12, node(from_num).rend )  *          if ( ikey .eq. smg$k_trm_cr .or. .      .        ikey .eq. smg$k_trm_enter ) then  H             if ( .not. check_directory_move( from_num, node_num ) ) then8                call update_screen( cur_line, cur_level )F                call print_message( 'Rename would cause too great a '//(      .            'directory depth', 0 )                return $                end if                 2             if ( dir_to_file( node(from_num).spec,5      .                        node(from_num).length,  1      .                        file, ipos ) ) then   t                ISTAT = MODIFY_FILE_PROT(FILE, 32767, 1)		!Set protection on directory file to allow rename operation                 IF ( ISTAT ) THEN.                istat = lib$rename_file( file, E      .                 node(node_num).spec(1:node(node_num).length)// '      .                 '*.dir;1',,, 1 )                    if ( istat ) then6                   call move_node( from_num, node_num )     +                   call adjust_node_pointers          #                   call load_display   0                   cur_line = node(from_num).line2                   cur_level = node(from_num).level  ;                   call update_screen( cur_line, cur_level )   H                   call print_message( 'Subdirectory has been moved', 0 )  "                   do_save = .true.                     elseF                   call sys$getmsg( %val(istat), len_message, message, -      .                             %val(1), ) A                   call print_message( message(1:len_message), 0 )                    end if                   ELSEF                   CALL SYS$GETMSG( %VAL(ISTAT), LEN_MESSAGE, MESSAGE, -      .                             %VAL(1), ) A                   CALL PRINT_MESSAGE( MESSAGE(1:LEN_MESSAGE), 0 )                    END IF                end if              else-             call smg$erase_display( window3 )              end if
          else *          call smg$erase_display( window3 )          end if          return	       end   @       logical function check_directory_move( from_num, cur_num )         include 'swing.cmn'   6       integer from_num, cur_num, from_levels, ptr(0:7)         from_levels = 1          ptr(0) = from_num   !       ptr(1) = node(ptr(0)).child        do while( ptr(1) .ne. 0 ) 1         if ( from_levels .lt. 2 ) from_levels = 2 #         ptr(2) = node(ptr(1)).child "         do while( ptr(2) .ne. 0 ) 3           if ( from_levels .lt. 3 ) from_levels = 3 %           ptr(3) = node(ptr(2)).child $           do while( ptr(3) .ne. 0 ) 5             if ( from_levels .lt. 4 ) from_levels = 4 '             ptr(4) = node(ptr(3)).child &             do while( ptr(4) .ne. 0 ) 7               if ( from_levels .lt. 5 ) from_levels = 5 )               ptr(5) = node(ptr(4)).child (               do while( ptr(5) .ne. 0 ) 9                 if ( from_levels .lt. 6 ) from_levels = 6 +                 ptr(6) = node(ptr(5)).child *                 do while( ptr(6) .ne. 0 ) ;                   if ( from_levels .lt. 7 ) from_levels = 7=-                   ptr(7) = node(ptr(6)).child=,                   do while( ptr(7) .ne. 0 ) =                     if ( from_levels .lt. 8 ) from_levels = 8 0                     ptr(7) = node(ptr(7)).sister                   end do.                   ptr(6) = node(ptr(6)).sister                 end do,                 ptr(5) = node(ptr(5)).sister               end do*               ptr(4) = node(ptr(4)).sister             end do(             ptr(3) = node(ptr(3)).sister           end do&           ptr(2) = node(ptr(2)).sister         end do$         ptr(1) = node(ptr(1)).sister       end do  :       if ( node(cur_num).level + from_levels .gt. 7 ) then'          check_directory_move = .false. 
          else &          check_directory_move = .true.          end if)         return	       end)  )       subroutine move_node( num, parent )a    C       include    'swing.cmn'  $       logical    found_node, greater.       integer    num, ii, jj, parent, ptr(0:7)         found_node = .false.       ii = 1  <       do while ( .not. found_node .and. ii .le. num_nodes ) -          if ( node(ii).sister .eq. num ) then'             found_node = .true._.             node(ii).sister = node(num).sister  4             else if ( node(ii).child .eq. num ) then             found_node = .true. -             node(ii).child = node(num).sister              end if          ii = ii + 1       end do  $       if ( .not. found_node ) return         node(num).sister = 0         if ( parent .eq. 0 ) thenl          ii = cur_level - 1           jj = cur_line@          do while( node_pointer(ii,jj) .eq. 0 .and. jj .ge. 1 )              jj = jj - 1q          end doc          if ( jj .ge. 1 ) then(             parent = node_pointer(ii,jj)             else             parent = 1             end if          end ife  +       if ( node(parent).child .eq. 0 ) then_!          node(parent).child = num   
          else            ii = node(parent).child6          if ( node(num).name .lt. node(ii).name ) then1             node(num).sister = node(parent).child=$             node(parent).child = num               else             greater = .true.              do while ( greater )1                if ( node(ii).sister .eq. 0 ) then '                   node(ii).sister = num #                   greater = .false.e                     else i                   jj = iin&                   ii = node(ii).sister?                   if ( node(num).name .lt. node(ii).name ) theni*                      node(jj).sister = num*                      node(num).sister = ii&                      greater = .false.                      end ifu*                   end if                               end do             end if                      end ifc      l       ptr(0) = num  (       call change_spec( parent, ptr(0) )!       ptr(1) = node(ptr(0)).childL       do while( ptr(1) .ne. 0 )+*         call change_spec( ptr(0), ptr(1) )#         ptr(2) = node(ptr(1)).child "         do while( ptr(2) .ne. 0 ) ,           call change_spec( ptr(1), ptr(2) )%           ptr(3) = node(ptr(2)).child $           do while( ptr(3) .ne. 0 ) .             call change_spec( ptr(2), ptr(3) )'             ptr(4) = node(ptr(3)).childt&             do while( ptr(4) .ne. 0 ) 0               call change_spec( ptr(3), ptr(4) ))               ptr(5) = node(ptr(4)).child (               do while( ptr(5) .ne. 0 ) 2                 call change_spec( ptr(4), ptr(5) )+                 ptr(6) = node(ptr(5)).child *                 do while( ptr(6) .ne. 0 ) 4                   call change_spec( ptr(5), ptr(6) )-                   ptr(7) = node(ptr(6)).childc,                   do while( ptr(7) .ne. 0 ) 6                     call change_spec( ptr(6), ptr(7) )0                     ptr(7) = node(ptr(7)).sister                   end do.                   ptr(6) = node(ptr(6)).sister                 end do,                 ptr(5) = node(ptr(5)).sister               end do*               ptr(4) = node(ptr(4)).sister             end do(             ptr(3) = node(ptr(3)).sister           end do&           ptr(2) = node(ptr(2)).sister         end do$         ptr(1) = node(ptr(1)).sister       end do         return	       endc _+       subroutine change_spec( parent, ptr )_         include    'swing.cmn'         character  spec*255d%       integer    len, parent, ptr, jj          jj = node(ptr).length - 1 
       ii = jj_        do while ( ii .gt. 1 .and.6      .           node(ptr).spec(ii:ii) .ne. '[' .and. 2      .           node(ptr).spec(ii:ii) .ne. '.' )           ii = ii - 1       end do       ii = ii + 1q  7       spec = node(parent).spec(1:node(parent).length)//q,      .       node(ptr).spec(ii:jj)//'.DIR;1'         call file_to_dir( spec, '      .                  node(ptr).spec,r)      .                  node(ptr).length,r(      .                  node(ptr).name )         return	       ends  )       subroutine create_directory( code )          include    'swing.cmn'       include    '($ssdef)'   ;       character  new_dir*42, term*5, string*39, message*255 2       integer    iterm, len_string, lib$create_dir5       integer    sys$getmsg, istat, len_message, code   "       call print_message( ' ', 0 ).       call smg$set_cursor_abs( window3, 1, 1 ).       call smg$read_string( keyboard, string, 6      .                      'New subdirectory name: ',8      .                      39,,,,len_string,, window3 )         new_dir = ' 'e       jj = 0         do ii = 1, len_string H          if ( string(ii:ii) .ne. '[' .and. string(ii:ii) .ne. ']' .and. G      .        string(ii:ii) .ne. '<' .and. string(ii:ii) .ne. '>' .and.iH      .        string(ii:ii) .ne. '.' .and. string(ii:ii) .gt. ' ' ) then             jj = jj + 1n*             new_dir(jj:jj) = string(ii:ii)             end if       end do  )       call str$upcase( new_dir, new_dir )h         if ( jj .ne. 0 ) then.;          istat = lib$create_dir( '[.'//new_dir(1:jj)//']' )T  +          if ( istat .eq. ss$_created ) thene               do_save = .true.  4             call add_node( new_dir(1:jj), node_num )  %             call adjust_node_pointers                     call load_display%  5             call update_screen( cur_line, cur_level )t  ?             call print_message( 'Created new subdirectory', 0 )   (             else if ( .not. istat ) then@             call sys$getmsg( %val(istat), len_message, message, '      .                       %val(1), ) ;             call print_message( message(1:len_message), 0 )y               else-             call smg$erase_display( window3 )              end if  
          else *          call smg$erase_display( window3 )          end if          return	       endn  ,       subroutine add_node( new_dir, parent )         include    'swing.cmn'  $       character new_dir*42, spec*2554       integer   parent, len, new_node, free_node, ii       logical   greater   ,       call str$trim( new_dir, new_dir, len )  7       spec = node(parent).spec(1:node(parent).length)//s%      .       new_dir(1:len)//'.DIR;1'          new_node = free_node()         call file_to_dir( spec, ,      .                  node(new_node).spec,.      .                  node(new_node).length,-      .                  node(new_node).name )4  +       if ( node(parent).child .eq. 0 ) then &          node(parent).child = new_node  
          elset           ii = node(parent).child;          if ( node(new_node).name .lt. node(ii).name ) then,6             node(new_node).sister = node(parent).child5             node(parent).child = new_node            d               else             greater = .true.              do while ( greater )1                if ( node(ii).sister .eq. 0 ) thens,                   node(ii).sister = new_node#                   greater = .false.d                     else                     jj = iis&                   ii = node(ii).sisterD                   if ( node(new_node).name .lt. node(ii).name ) then/                      node(jj).sister = new_nodee/                      node(new_node).sister = ii<&                      greater = .false.                      end ife*                   end if                               end do             end if                      end if1         return	       end:          integer function free_node         include 'swing.cmn'          integer ii  *       if ( num_nodes .lt. MAX_NODES ) then"          num_nodes = num_nodes + 1#          node(num_nodes).length = 0 "          node(num_nodes).child = 0#          node(num_nodes).sister = 0           free_node = num_nodes  
          elseD          ii = 1E(          do while ( ii .le. MAX_NODES ) .             if ( node(ii).length .eq. 0 ) then"                node(ii).length = 0!                node(ii).child = 0."                node(ii).sister = 0                free_node = ii.                return                 end if              ii = ii + 1s          end do G          if ( num_nodes .gt. MAX_NODES .or. num_lines .gt. MAX_LINES )  G      .      call print_message( 'Directory structure is too large', 1 )           end if          return	       end   )       subroutine delete_directory( code )u         include    'swing.cmn'       include    '($ssdef)'   A       character  spec(0:MAX_LEVELS)*255, search(0:MAX_LEVELS)*255j7       character  term*5, string*3, message*255, name*50_(       integer    iterm, len_string, codeB       integer    sys$getmsg, istat, len_message, len(0:MAX_LEVELS)5       integer    icont(MAX_LEVELS), lib$find_file, iiu       logical    found_node   "       call print_message( ' ', 0 ).       call smg$set_cursor_abs( window3, 1, 1 ).       call smg$read_string( keyboard, string, A      .                      'Enter YES to to delete this direc'// B      .                      'tory and all directories below it: ',7      .                      3,,,,len_string,, window3 )f  '       call str$upcase( string, string )   #       if ( string .eq. 'YES' ) thenE            do_save = .true.   H          call print_message('Deleting current directory structure...',0)  !          delete_problem = .false. H          search(0)=node(node_num).spec(1:node(node_num).length)//'*.dir'            icont(0) = 0 I          do while ( lib$find_file( search(0), spec(0), icont(0) ) )       >           call file_to_dir( spec(0), search(1), len(1), name )2           search(1) = search(1)(1:len(1))//'*.dir'           icont(1) = 0J           do while ( lib$find_file( search(1), spec(1), icont(1) ) )      ?            call file_to_dir( spec(1), search(2), len(2), name )d3            search(2) = search(2)(1:len(2))//'*.dir'e            icont(2) = 0 K            do while ( lib$find_file( search(2), spec(2), icont(2) ) )       @             call file_to_dir( spec(2), search(3), len(3), name )4             search(3) = search(3)(1:len(3))//'*.dir'             icont(3) = 0L             do while ( lib$find_file( search(3), spec(3), icont(3) ) )      A              call file_to_dir( spec(3), search(4), len(4), name )_5              search(4) = search(4)(1:len(4))//'*.dir'e              icont(4) = 0 M              do while ( lib$find_file( search(4), spec(4), icont(4) ) )      .B               call file_to_dir( spec(4), search(5), len(5), name )6               search(5) = search(5)(1:len(5))//'*.dir'               icont(5) = 0N               do while ( lib$find_file( search(5), spec(5), icont(5) ) )      C                call file_to_dir( spec(5), search(6), len(6), name ) 7                search(6) = search(6)(1:len(6))//'*.dir'                 icont(6) = 0iN                do while ( lib$find_file( search(6), spec(6), icont(6) ))      D                 call file_to_dir( spec(6), search(7), len(7), name )8                 call delete_files( search(7)(1:len(7)) )                end do 1                call lib$find_file_end( icont(6) )j7                call delete_files( search(6)(1:len(6)) )a               end do0               call lib$find_file_end( icont(5) )6               call delete_files( search(5)(1:len(5)) )              end do /              call lib$find_file_end( icont(4) )e5              call delete_files( search(4)(1:len(4)) ).             end do.             call lib$find_file_end( icont(3) )4             call delete_files( search(3)(1:len(3)) )            end do -            call lib$find_file_end( icont(2) ) 3            call delete_files( search(2)(1:len(2)) )d           end do,           call lib$find_file_end( icont(1) )2           call delete_files( search(1)(1:len(1)) )          end do +          call lib$find_file_end( icont(0) )j@          call delete_files( search(0)(1:node(node_num).length) )  %          if ( cur_level .ge. 1 ) then              ii = cur_level - 1             jj = cur_line=C             do while( node_pointer(ii,jj) .eq. 0 .and. jj .ge. 1 ) d                jj = jj - 1             end do!             if ( jj .ge. 1 ) then -                node_num = node_pointer(ii,jj)c                elseu                node_num = 1                 end if              else             node_num = 1             end if  "          call adjust_node_pointers          call load_display  )          cur_level = node(node_num).levele'          cur_line = node(node_num).line_  2          call update_screen( cur_line, cur_level )  #          if ( delete_problem ) thencG             call print_message( 'Attempted to delete subdirectory - '//(;      .           'but some files could not be deleted', 0 )e             elseE             call print_message( 'Deleted subdirectory structure', 0 )              end if
          else   :          call print_message( 'No directories deleted', 0 )          end if          return	       endu l)       subroutine delete_files( dir_spec )e         include    'swing.cmn'       include    '($smgdef)'  A       integer    icontext, lib$delete_file, modify_file_prot, ptra'       character  dir_spec*(*), spec*255 &       logical    find_node, found_node         ii = len( dir_spec )<       do while ( dir_spec(ii:ii) .eq. ' ' .and. ii .gt. 0 )           ii = ii - 1       end do  2       if ( find_node( dir_spec(1:ii), ptr ) ) then          found_node = .true.=          call smg$change_rendition( window2, node(ptr).line,  9      .                              node(ptr).level*17+1,_*      .                              1, 12,C      .                              smg$m_blink + node(ptr).rend ) c
          else           found_node = .false.           end ifa         icontext = 0H       do while( lib$find_file( dir_spec(:ii)//'*.*;*', spec, icontext ))2          if ( .not. lib$delete_file( spec ) ) then1             call str$trim( spec, spec, len_spec ) B             if ( modify_file_prot( spec(1:len_spec), 0, 0 ) ) then.                istat = lib$delete_file( spec )9                if ( .not. istat ) delete_problem = .true.(                else >                call lib$spawn( 'SET PROT=(S:D,O:D,G:D,W:D) '//E      .                         dir_spec(:ii)//'*.*;*', 'NL:', 'NL:' ) .                istat = lib$delete_file( spec )9                if ( .not. istat ) delete_problem = .true.                 end if              end if       end do(       call lib$find_file_end( icontext )  %       call dir_to_file( dir_spec, ii,o$      .                  spec, ipos )/       if ( .not. lib$delete_file( spec ) ) then .          call str$trim( spec, spec, len_spec )?          if ( modify_file_prot( spec(1:len_spec), 0, 0 ) ) then +             istat = lib$delete_file( spec )w6             if ( .not. istat ) delete_problem = .true.             else  ;             call lib$spawn( 'SET PROT=(S:D,O:D,G:D,W:D) '//)B      .                      dir_spec(:ii)//'*.*;*', 'NL:', 'NL:' )5             istat = lib$delete_file( dir_spec(1:ii) )e6             if ( .not. istat ) delete_problem = .true.             end if          end if)  &       if ( .not. delete_problem ) then2          if ( found_node ) call delete_node( ptr )
          elsel          if ( found_node ) (@      .      call smg$change_rendition( window2, node(ptr).line, <      .                                 node(ptr).level*17+1,-      .                                 1, 12, 8      .                                 node(ptr).rend )           end ifs         return	       end   1       logical function find_node( dir_spec, ptr )          include    'swing.cmn'         character  dir_spec*(*)o       integer    ii, jj, ptr       logical    found_node(         ii = len( dir_spec )<       do while ( dir_spec(ii:ii) .eq. ' ' .and. ii .gt. 0 )           ii = ii - 1       end do         jj = 1       found_node = .false.#       do while ( .not. found_node )(H          if ( node(jj).spec(1:node(jj).length) .eq. dir_spec(1:ii) )then             found_node = .true.              ptr = jj             end if          jj = jj + 1       end do         find_node = found_node         return	       endl f#       subroutine delete_node( ptr )e         include    'swing.cmn'       include    '($smgdef)'         logical    found_node        integer    ptr, ii         found_node = .false.       ii = 1  <       do while ( .not. found_node .and. ii .le. num_nodes ) -          if ( node(ii).sister .eq. ptr ) thenm             found_node = .true. .             node(ii).sister = node(ptr).sister  4             else if ( node(ii).child .eq. ptr ) then             found_node = .true.n-             node(ii).child = node(ptr).sister              end if          ii = ii + 1       end do         if ( found_node ) then          node(ptr).name = ' '_6          call smg$put_chars( window2, node(ptr).name, 6      .                                node(ptr).line, @      .                                node(ptr).level * 17 + 1,,6      .                                node(ptr).rend )          node(ptr).level = 0          node(ptr).length = 0l          node(ptr).sister = 0a          node(ptr).child = 0          end if          return	       end  .8       subroutine file_to_dir( file, dir, len_dir, name )  +       character dir*(*), file*(*), name*(*) )       integer   len_dir, kk, ii, len_noden         kk = 1'       do while ( file(kk:kk) .ne. '[' )h          kk = kk + 1       end do       dir = file(kk:)i         ii = 1&       do while ( dir(ii:ii) .ne. ']' )          ii = ii + 1       end do  
       jj = ii=&       do while ( dir(jj:jj) .ne. '.' )          jj = jj + 1       end do         dir(ii:ii) = '.'       dir(jj:) = ']'         len_dir = jj              len_node = jj - ii - 1!       if ( len_node .le. 9 ) then           name = '['//dir(ii:jj)e
          else &          name = '['//dir(ii:ii+9)//'*'          end if          return	       end   >       logical function dir_to_file( dir, len_dir, file, ipos )  !       character dir*(*), file*(*) !       integer   len_dir, ii, ipose         ii = len_dir6       do while ( dir(ii:ii) .ne. '.' .and. ii .gt. 0 )          ii = ii - 1                 end do         if ( ii .ne. 0 ) thenn          dir_to_file = .true.i          file = dir(          file(ii:ii) = ']'"          file(len_dir:) = '.dir;1'          ipos = ii  
          elseiG          call print_message( 'Operation not allowed on main directory',        .                       0 )          dir_to_file = .false.          end ifa         return	       end   5       subroutine update_screen( old_line, old_level )          include    '($smgdef)'       include    'swing.cmn'  1       integer    old_line, old_level, sys$setddir   4       node_num = node_pointer( cur_level, cur_line )  2       call smg$begin_pasteboard_update( board_id )  C       call smg$change_rendition( window2, old_line, old_level*17+1, 2      .                           1, 12, old_rend )C       call smg$change_rendition( window2, cur_line, cur_level*17+1, '      .                           1, 12, D      .                           smg$m_bold + node(node_num).rend )          call update_window1)  0       call smg$end_pasteboard_update( board_id )  +       if ( cur_line .gt. bottom_line ) thend(          do ii = bottom_line+1, cur_lineE             call smg$move_virtual_display( window2, board_id,23-ii,1)o          end do !          top_line = cur_line - 19           bottom_line = cur_line(  0          else if ( cur_line .lt. top_line ) then)          do ii = top_line-1, cur_line, -1 E             call smg$move_virtual_display( window2, board_id, 4-ii,1)           end dot          top_line = cur_line$          bottom_line = cur_line + 19          end ifp  B       istat = sys$setddir( node(node_num).spec, %val(0), %val(0) )         return	       end  n!       subroutine hardcopy( code )d         include    '($smgdef)'       include    'swing.cmn'  B       integer    column, num, ii, jj, level, ikey, start, end, len       integer    codeeA       character  hard_node*12, dashes*12, out_line(MAX_LINES)*132=       character  one_line*255a  $       data dashes / '------------' /         open( unit=1,       .      name='swing.lis',l#      .      carriagecontrol='list',       .      status='new',       .      recl=255,o      .      err=99 )  G       call print_message( 'Creating hardcopy listing in SWING.LIS', 0 )          last_level = 1       line = 0       do ii = 0, MAX_LEVELS           last_line(ii) = 1       end do         w       do ii = 1, num_lines          out_line(ii) = ' '        end do         $         do jj = 1, num_lines!          do level = 0, MAX_LEVELS 5             if ( node_pointer(level,jj) .ne. 0 ) thens+                num = node_pointer(level,jj)g  &                column = level * 17 + 1$                line = node(num).line  >                call str$trim( hard_node, node(num).name, len )'                if ( level .lt. 7 ) then 8                   if ( node_pointer(level+1,jj) .ne. 0 )C      .               hard_node = hard_node(1:len)//dashes(len+1:12):                   end if  ;                out_line(line)(column:column+11) = hard_noden'                if ( level .gt. 0 ) then ;                   out_line(line)(column-3:column-1) = '---'   3                   if ( level .le. last_level ) thens<                      out_line(line)(column-3:column-3) = '+'H                      if ( out_line(line-1)(column-3:column-3) .eq. '+' )A      .                  out_line(line-1)(column-3:column-3) = '|'   ?                      else if ( level .eq. last_level + 1 ) thenl?                      out_line(line)(column-5:column-2) = '----'                       end ifn  3                   if ( level .lt. last_level ) thenaH                      if ( out_line(last_line(level))(column-3:column-3) )      .                    .eq. '+' ) thens-                         ll = last_line(level)                          else1                         ll = last_line(level) + 1                          end if'                      do kk = ll, line-1 =                         out_line(kk)(column-3:column-3) = '|'p                      end doi                      end ifn                   end if  !                last_level = levell&                last_line(level) = line                end if           end dot       end do         do ii = 1, num_lines9          call str$trim( out_line(ii), out_line(ii), len )),          write( 1, 100 ) out_line(ii)(1:len) 100      format( a )       end do  9       call print_message( 'Finished creating SWING.LIS', a      .                    0 )          close( unit=1 )n         return  A 99    call print_message( 'Unable to open file for hardcopy', 0 )o       return	       end          subroutine load_nodes0         include    'swing.cmn'         integer*2  len_roote4       integer*4  icontext(MAX_LEVELS), lib$find_file>       character  input*255, spec*255, search(0:MAX_LEVELS)*255         do ii = 1, MAX_LINES          do jj = 0, MAX_LEVELS#             node_pointer(jj,ii) = 0           end do        end do  ?       call get_location( disk, len_disk, root, len_root )                found = .false.t       lowest_level = 0       last_level = 1       line = 0       num_nodes = 0l       node_num = 0         ii = 1B       do while ( root(ii:ii) .ne. '.' .and. root(ii:ii) .ne. ']' )          ii = ii + 1       end do         main = root(:ii-1)//']'        len_main = iid       spec = mainn  "       if ( main .eq. '[000000]' ) E      .   call print_message( 'Master file directory not allowed', 1 )          ii = 0?       if ( .not. update .and. lib$find_file( main(1:len_main)// *      .     'swing.sav', input, ii ) ) then            open( unit=1, n      .         readonly,3      .         name=main(1:len_main)//'swing.sav',        .         status='old',&      .         carriagecontrol='list',#      .         access='sequential',("      .         form='unformatted',      .         recl=73, )      .         organization='sequential', %      .         recordtype='variable',D      .         err=99 )   =          read( 1, err=99 ) num_lines, num_nodes, lowest_levelg            do ii = 1, num_linesnD             read( 1, err=99 ) (node_pointer(jj,ii), jj=0,MAX_LEVELS)          end do=            do ii = 1, num_nodes.&             read( 1, err=99 ) node(ii)          end do             close( unit=1 )  #          swing_file_exists = .true.X  
          elseiD 99       call print_message( 'Searching directory structure...', 0 )  /          call append_node( 0, spec, search(1) )             icontext(1) = 0I          do while ( lib$find_file( search(1), spec, icontext(1) ) )       0           call append_node( 1, spec, search(2) )           icontext(2) = 0(J           do while ( lib$find_file( search(2), spec, icontext(2) ) )      1            call append_node( 2, spec, search(3) )n            icontext(3) = 0K            do while ( lib$find_file( search(3), spec, icontext(3) ) )      f2             call append_node( 3, spec, search(4) )             icontext(4) = 0 L             do while ( lib$find_file( search(4), spec, icontext(4) ) )      3              call append_node( 4, spec, search(5) )t              icontext(5) = 0M              do while ( lib$find_file( search(5), spec, icontext(5) ) )       4               call append_node( 5, spec, search(6) )               icontext(6) = 0 N               do while ( lib$find_file( search(6), spec, icontext(6) ) )      5                call append_node( 6, spec, search(7) )t                icontext(7) = 0N                do while ( lib$find_file( search(7), spec, icontext(7) ))      6                 call append_node( 7, spec, search(0) )                end do(4                call lib$find_file_end( icontext(7) )               end do3               call lib$find_file_end( icontext(6) )(              end do 2              call lib$find_file_end( icontext(5) )             end do1             call lib$find_file_end( icontext(4) )i            end do20            call lib$find_file_end( icontext(3) )           end do/           call lib$find_file_end( icontext(2) )l          end do(.          call lib$find_file_end( icontext(1) )          end ifo         return	       ende )3       subroutine append_node( level, spec, search )/         include    '($smgdef)'       include    'swing.cmn'  +       integer    level, len_node, free_node %       character  spec*255, search*255(         node_num = free_node()  9       if ( level .gt. lowest_level ) lowest_level = level '       if ( level .le. last_level ) thenl          line = line + 1          num_lines = line )          if ( num_lines .gt. MAX_LINES ) 4G      .      call print_message( 'Directory structure is too large', 1 ))  1          node(last_node(level)).sister = node_num 
          elsef*          node(node_num-1).child = node_num          end if          if ( level .ne. 0 ) then!          call file_to_dir( spec,  /      .                     node(node_num).spec, 1      .                     node(node_num).length, 0      .                     node(node_num).name )  
          else .          call str$trim( spec, spec, len_node )#          node(node_num).spec = speci)          node(node_num).length = len_nodee%          if ( len_node .le. 10 ) thenl&             node(node_num).name = spec             else0             node(node_num).name = spec(:11)//'*'             end if          end if)          node(node_num).line = line"       node(node_num).level = level)       node(node_num).rend = smg$m_reversen  )       node_pointer(level,line) = node_nums  F       search = node(node_num).spec(1:node(node_num).length)//'*.dir;1'         last_level = level!       last_node(level) = node_numl         return	       end          subroutine load_display(         include    '($smgdef)'       include    'swing.cmn'         integer    jj, level         using_screen = .true.n         if ( .not. found ) thene          cur_level = 0          cur_line = 1           end ifd         last_level = 0       line = 0       do ii = 0, MAX_LEVELSn          last_line(ii) = 1       end do         1  :       if ( lowest_level .gt. 4 .and. width .ne. 132 ) then          width = 132'          call pd_undraw_bar( board_id )j*          call smg$erase_display( window1 )*          call smg$erase_display( window2 )*          call smg$erase_display( window3 )C          istat = smg$change_pbd_characteristics( board_id,132,,24 ) <          call smg$set_display_scroll_region( window3, 1, 2 )/          call pd_load_bar( width, pull_choices)_%          call pd_draw_bar( board_id )   A          else if ( lowest_level .le. 4 .and. width .ne. 80 ) thenn          width = 80 '          call pd_undraw_bar( board_id )v*          call smg$erase_display( window1 )*          call smg$erase_display( window2 )*          call smg$erase_display( window3 )B          istat = smg$change_pbd_characteristics( board_id,80,,24 )<          call smg$set_display_scroll_region( window3, 1, 2 )/          call pd_load_bar( width, pull_choices) %          call pd_draw_bar( board_id )i          end if   2       call smg$begin_pasteboard_update( board_id )  '       call smg$erase_display( window2 )          do jj = 1, num_lines!          do level = 0, MAX_LEVELS 0             if ( node_pointer(level,jj) .ne. 0 )A      .         call add_node_to_display( node_pointer(level,jj) )           end don       end do  & c     PUT UNDERLINES ON THE LEAF NODES         do jj = 2, num_lines          do ii = 2, MAX_LEVELS1             if ( node_pointer(ii,jj) .ne. 0 .and.13      .           node_pointer(ii-1,jj) .ne. 0 .and. 4      .           node_pointer(ii,jj-1) .ne. 0 ) then,                kk = node_pointer( ii, jj-1 )>                node(kk).rend = smg$m_underline + smg$m_reverseD                istat = smg$change_rendition( window2, node(kk).line,B      .                                       node(kk).level*17+1, C      .                                       1, 12, node(kk).rend )*                end if           end dot       end do  0       call smg$end_pasteboard_update( board_id )         if ( .not. found )G      .   call print_message( 'The current directory was not found in'// 3      .                       ' your save file', 0 )          return	       endm .+       subroutine add_node_to_display( num )c         include    '($smgdef)'       include    'swing.cmn'         integer    column, num  $       node(num).rend = smg$m_reverse         level =  node(num).level       column = level * 17 + 1        line =   node(num).line   A       call smg$put_chars( window2, node(num).name, line, column,,f*      .                    node(num).rend )E       call smg$draw_line( window2, line, column-3, line, column-1 )  (  '       if ( level .eq. last_level ) then H          call smg$draw_line( window2, line-1, column-3, line, column-3 )3          else if ( level .eq. last_level + 1 ) then F          call smg$draw_line( window2, line, column-5, line, column-2 )/          else if ( level .lt. last_level ) thenlB          call smg$draw_line( window2, last_line(level), column-3, -      .                       line, column-3 )           end ifi  <       if ( .not. found .and. root .eq. node(num).spec ) then          found = .true.           cur_line = line          cur_level = level          end if          last_level = level       last_line(level) = line          return	       end  o%       subroutine adjust_node_pointersg         include    '($smgdef)'       include    'swing.cmn'         integer ll, jj, ptr(0:7)         do ll = 1, MAX_LINES          do jj = 0, MAX_LEVELS#             node_pointer(jj,ll) = 0t          end do        end do         do jj = 0, MAX_LEVELS           ptr(jj) = 0       end do         ll = 1     !LINE       ptr(0) = 1         node_pointer(0,ll) = 1!       ptr(1) = node(ptr(0)).child        do while( ptr(1) .ne. 0 ) #         node_pointer(1,ll) = ptr(1)e         node(ptr(1)).line = ll         node(ptr(1)).level = 1#         ptr(2) = node(ptr(1)).child "         do while( ptr(2) .ne. 0 ) %           node_pointer(2,ll) = ptr(2)             node(ptr(2)).line = ll            node(ptr(2)).level = 2%           ptr(3) = node(ptr(2)).child $           do while( ptr(3) .ne. 0 ) '             node_pointer(3,ll) = ptr(3)n"             node(ptr(3)).line = ll"             node(ptr(3)).level = 3'             ptr(4) = node(ptr(3)).child.&             do while( ptr(4) .ne. 0 ) )               node_pointer(4,ll) = ptr(4) $               node(ptr(4)).line = ll$               node(ptr(4)).level = 4)               ptr(5) = node(ptr(4)).child (               do while( ptr(5) .ne. 0 ) +                 node_pointer(5,ll) = ptr(5) &                 node(ptr(5)).line = ll&                 node(ptr(5)).level = 5+                 ptr(6) = node(ptr(5)).childe*                 do while( ptr(6) .ne. 0 ) -                   node_pointer(6,ll) = ptr(6)1(                   node(ptr(6)).line = ll(                   node(ptr(6)).level = 6-                   ptr(7) = node(ptr(6)).childe,                   do while( ptr(7) .ne. 0 ) /                     node_pointer(7,ll) = ptr(7) *                     node(ptr(7)).line = ll*                     node(ptr(7)).level = 70                     ptr(7) = node(ptr(7)).sister4                     if ( ptr(7) .ne. 0 ) ll = ll + 1                   end do.                   ptr(6) = node(ptr(6)).sister2                   if ( ptr(6) .ne. 0 ) ll = ll + 1                 end do,                 ptr(5) = node(ptr(5)).sister0                 if ( ptr(5) .ne. 0 ) ll = ll + 1               end do*               ptr(4) = node(ptr(4)).sister.               if ( ptr(4) .ne. 0 ) ll = ll + 1             end do(             ptr(3) = node(ptr(3)).sister,             if ( ptr(3) .ne. 0 ) ll = ll + 1           end do&           ptr(2) = node(ptr(2)).sister*           if ( ptr(2) .ne. 0 ) ll = ll + 1         end do$         ptr(1) = node(ptr(1)).sister(         if ( ptr(1) .ne. 0 ) ll = ll + 1       end do         lowest_level = 0       do ii = 1, num_nodes1          if ( node(ii).level .gt. lowest_level ) u)      .      lowest_level = node(ii).leveld       end do  %       if ( lowest_level .gt. 7 ) thene@          call print_message( 'Directory nesting is to deep', 1 )          end if          num_lines = ll&       if ( num_lines .gt. MAX_LINES ) D      .   call print_message( 'Directory structure is too large', 1 )         return	       end   +       subroutine record_structure( search )          include    'swing.cmn'              character  spec*255e       logical    search_       integer    icontexto  0       if ( search .and. swing_file_exists ) then          do ii = 1, num_nodes.             node(ii).length = 0              node(ii).child = 0             node(ii).sister = 0           end do             call load_nodes               call load_display    n2          call update_screen( cur_line, cur_level )          end ifo  e       do_save = .false.   ;       call print_message( 'Saving directory structure', 0 )a         icontext = 0?       do while( lib$find_file( main(1:len_main)//'swing.sav;*', 0      .                         spec, icontext ))2          if ( .not. lib$delete_file( spec ) ) then1             call str$trim( spec, spec, len_spec ) B             if ( modify_file_prot( spec(1:len_spec), 0, 0 ) ) then.                istat = lib$delete_file( spec )                else >                call lib$spawn( 'SET PROT=(S:D,O:D,G:D,W:D) '//>      .                         main(1:len_main)//'swing.sav', -      .                         'NL:', 'NL:' ) .                istat = lib$delete_file( spec )                end if              end if       end do(       call lib$find_file_end( icontext )         open( unit=2, 0      .      name=main(1:len_main)//'swing.sav',       .      status='new',e#      .      carriagecontrol='list',        .      access='sequential',      .      form='unformatted',a      .      recl=73,&      .      organization='sequential',"      .      recordtype='variable',      .      iostat=istat,       .      err=99 )  3       write( 2 ) num_lines, num_nodes, lowest_level          do ii = 1, num_lines;          write( 2 ) (node_pointer(jj,ii), jj=0, MAX_LEVELS)e       end do         do ii = 1, num_nodes          write( 2 ) node(ii)       end do         close( unit=2 )-  D       call print_message( 'Finished saving directory structure', 0 )         return  E 99    call print_message( 'Unable to record directory structure', 0 )        return	       end  l       subroutine draw_screen         include    '($smgdef)'       include    'swing.cmn'  ;       integer    ii, jj, kk, smg$change_pbd_characteristics)%       integer    smg$change_renditioni  2       call smg$begin_pasteboard_update( board_id )  ?       call smg$paste_virtual_display( window2, board_id, 3, 1 ) ?       call smg$paste_virtual_display( window1, board_id, 2, 1 )t@       call smg$paste_virtual_display( window3, board_id, 23, 1 )  9       call smg$set_display_scroll_region( window3, 1, 2 )i  "       call pd_draw_bar( board_id )         top_line = 1       bottom_line = 20  4       node_num = node_pointer( cur_level, cur_line )  C       call smg$change_rendition( window2, cur_line, cur_level*17+1,e(      .                           1, 12, C      .                           smg$m_bold + node(node_num).rend )n  +       if ( cur_line .gt. bottom_line ) then !          top_line = cur_line - 19l          bottom_line = cur_line ;          call smg$move_virtual_display( window2, board_id,  :      .                                  23 - cur_line, 1 )0          else if ( cur_line .lt. top_line ) then          top_line = cur_line$          bottom_line = cur_line + 19;          call smg$move_virtual_display( window2, board_id, l8      .                                     cur_line, 1 )          end if'         call update_window1e  0       call smg$end_pasteboard_update( board_id )  B       call smg$set_cursor_abs( window2, cur_line, cur_level*17+1 )         update = .true.          return	       endt s       subroutine update_window1s         include    '($smgdef)'       include    'swing.cmn'         integer    start         if ( use_window1 ) then   @       start = ( width - (len_disk + node(node_num).length) ) / 2#       if ( start .le. 0 ) start = 1   *       call smg$erase_line( window1, 1, 1 )  #       call smg$put_chars( window1,  ,      .                    disk(1:len_disk)//G      .                    node(node_num).spec(1:node(node_num).length),e6      .                    1, start,, smg$m_underline )         end if         return	       endi  ?       subroutine get_location( disk, len_disk, root, len_root )r              integer*2  len_rootl&       integer*4  sys$setddir, len_disk"       character  root*255, disk*31  7       call lib$sys_trnlog( 'SYS$DISK', len_disk, disk )l4       istat = sys$setddir( %val(0), len_root, root )         root = root(1:len_root)          return	       end0         logical function crt         include    '($dvidef)'       include    '($ttdef)'_       include    '($tt2def)'         include    'swing.cmn'         integer*2  b2(14) F       integer*4  b4(7), buf, len_buf, sys$trnlog, sys$getdvi, dev_type"       logical*4  for$bjtest, istat  "       equivalence ( b4(1), b2(1) )         b2(1) = 4n       b2(2) = dvi$_devdepend2        b4(2) = %loc( buf )        b4(3) = %loc( len_buf )t         b2(7) = 4i       b2(8) = dvi$_devtype       b4(5) = %loc( dev_type )"       b4(6) = %loc( len_dev_type )         b4(7) = 0i  5       istat = sys$getdviw( ,, 'SYS$COMMAND', b4,,,, )   8       crt      = ( for$bjtest( buf, tt2$v_deccrt ) .or. :      .                            dev_type .eq. tt$_vt52 )-       avo      = for$bjtest( buf, tt2$v_avo )l         return       end        f"       subroutine define_smg_layout         include    '($smgdef)'       include    'swing.cmn'  (       integer smg$create_virtual_display,       record /pd_choice_type/ sub_choices(9)         call define_paste_board    c     CREATE THE WINDOWS  <       istat = smg$create_virtual_display(  1, 132, window1 )  D       istat = smg$create_virtual_display(  MAX_LINES, 132, window2 )  <       istat = smg$create_virtual_display(  2, 132, window3 )         pull_choices.number = 99'       pull_choices.choice(1) = 'Create'n       pull_choices.code(1) = 10        pull_choices.ptr(1) = 0 '       pull_choices.choice(2) = 'Rename'(       pull_choices.code(2) = 20        pull_choices.ptr(2) = 0 %       pull_choices.choice(3) = 'Move'        pull_choices.code(3) = 30        pull_choices.ptr(3) = 0 '       pull_choices.choice(4) = 'Delete'        pull_choices.code(4) = 40g       pull_choices.ptr(4) = 0r&       pull_choices.choice(5) = 'Print'       pull_choices.code(5) = 50        pull_choices.ptr(5) = 0h%       pull_choices.choice(6) = 'Save'c       pull_choices.code(6) = 60a       pull_choices.ptr(6) = 0((       pull_choices.choice(7) = 'Options'       pull_choices.code(7) = 70h2       pull_choices.ptr(7) = %loc( sub_choices(7) )%       pull_choices.choice(8) = 'Help'        pull_choices.code(8) = 80d       pull_choices.ptr(8) = 0(%       pull_choices.choice(9) = 'Exit'        pull_choices.code(9) = 90s2       pull_choices.ptr(9) = %loc( sub_choices(9) )         sub_choices(1).number = 04       sub_choices(2).number = 0        sub_choices(3).number = 0p       sub_choices(4).number = 0o         sub_choices(5).number = 0          sub_choices(6).number = 0c         sub_choices(7).number = 1 4       sub_choices(7).choice(1) = 'display directory'!       sub_choices(7).code(1) = 71w         sub_choices(8).number = 0e         sub_choices(9).number = 2 *       sub_choices(9).choice(1) = 'ok exit'!       sub_choices(9).code(1) = 91 )       sub_choices(9).choice(2) = 'cancel'c!       sub_choices(9).code(2) = 92   ,       call pd_load_bar( width, pull_choices)              use_window1 = .false.          return	       endn i3       subroutine set_notab( terminal, save_buffer )l  < C     ROUTINE USES THE IO$_SETMODE FUNCTION TO SET TERMINAL  C     CHARACTERISTICSl         include    '($iodef)'        include    '($ttdef)'b       include    '($tt2def)'  & c                LAYOUT OF char_buffer cd2 c     --------------------------------------------? c     |    buffer size     |   type   |   class  |  <- longword G c     |page len  |   terminal characteristics    |  <- longword (TTDEF)nH c     |    extended terminal characteristics     |  <- longword (TT2DEF)2 c     --------------------------------------------2 c     31                                         0         integer*2  iosb(4)?       integer*4  status, sys$trnlog, sys$assign, sys$qiow, chanl/       integer*4  char_buffer(3), save_buffer(3)        character  terminal*(*)e  -       status = sys$assign( terminal, chan,, )=  #       status = sys$qiow ( %val(1), X&      .                    %val(chan), .      .                    %val(io$_sensemode),"      .                    iosb,,, ,      .                    %ref(save_buffer),(      .                    %val(12),,,, )  %       char_buffer(1) = save_buffer(1) =       char_buffer(2) = jibclr( save_buffer(2), tt$v_mechtab )d%       char_buffer(3) = save_buffer(3)   #       status = sys$qiow ( %val(1),  &      .                    %val(chan), ,      .                    %val(io$_setmode),"      .                    iosb,,, ,      .                    %Ref(char_buffer),(      .                    %val(12),,,, )         return	       end   #       subroutine define_paste_board          include    '($smgdef)'       include    'swing.cmn'  * C     DEC FORGOT THIS PARAMETER IN $SMGDEF4       parameter  SMG$S_PASTEBOARD_INFO_BLOCK = '20'x  &       integer    smg$create_pasteboard,       integer    smg$create_virtual_keyboard$       integer    smg$set_keypad_mode.       integer    smg$get_pasteboard_attributes         record     /smgdef/ tablen  3       call set_notab( 'SYS$COMMAND', set_term_buf )   /       istat = smg$create_pasteboard( board_id )'  B       istat = smg$get_pasteboard_attributes(board_id, %ref(table),H      .                                %ref(SMG$S_PASTEBOARD_INFO_BLOCK))         width = table.smg$w_width   5       istat = smg$create_virtual_keyboard( keyboard )e0       istat = smg$set_keypad_mode( keyboard, 1 )         call sm_allow_repaint          return       end      g 4       subroutine exit_swing          include    'swing.cmn'         character  string*3j       integer    len_stringp  1       if ( do_save .and. swing_file_exists ) theno)          call record_structure( .false. )o          end ift  /       call smg$delete_pasteboard( board_id, 1 )2  >       call smg$change_pbd_characteristics( board_id, 80,, 24 )  8       call reset_terminal( 'SYS$COMMAND', set_term_buf )         stop ' '	       end   8       subroutine reset_terminal( terminal, char_buffer )  < C     ROUTINE USES THE IO$_SETMODE FUNCTION TO SET TERMINAL  C     CHARACTERISTICS          include    '($iodef)'   & c                LAYOUT OF char_buffer c 2 c     --------------------------------------------? c     |    buffer size     |   type   |   class  |  <- longwordcG c     |page len  |   terminal characteristics    |  <- longword (TTDEF)_H c     |    extended terminal characteristics     |  <- longword (TT2DEF)2 c     --------------------------------------------2 c     31                                         0         integer*2  iosb(4)?       integer*4  status, sys$trnlog, sys$assign, sys$qiow, chan_&       integer*4  reset, char_buffer(3)       character  terminal*(*)d  -       status = sys$assign( terminal, chan,, )n  #       status = sys$qiow ( %val(1), F&      .                    %val(chan), ,      .                    %val(io$_setmode),"      .                    iosb,,, ,      .                    %ref(char_buffer),(      .                    %val(12),,,, )         return	       end   0       subroutine print_message( message, abort )         include    'swing.cmn'         logical    abort, erased       character  message*(*)         if ( using_screen ) then  %          if ( message .eq. ' ' ) then.$             if ( .not. erased ) then                erased = .true.0                call smg$erase_display( window3 )3                call smg$erase_line( window3, 2, 1 )p                end if                else             erased = .false.-             call smg$erase_display( window3 ) ;             call smg$put_chars( window3, message, 2, 1, 1 )e             end if  %          if ( abort ) call exit_swingu                   
          else'$          print *, 'SWING: ', message          if ( abort ) stop ' '          end if=         return	       ende  >       INTEGER*4 FUNCTION MODIFY_FILE_PROT ( FILE, PROT, CODE )  H C     Modifies  the protection  on a specified  file.  The file's accessH C     control list, if it  has one, is not modified.  The status of  the0 C     operation is returned as a function value.  H C     This routine will fail if the protection on the file (prior to theH C     modification) is such that we do not have read and write access toH C     it.  It will also fail if the file has already been opened without C     write-shareability.    C     Greg Janee, 19-MAR-1986v  H C-----------------------------------------------------------------------   C     Arguments: C + C     FILE      type:      character string $ C               access:    read onlyA C               mechanism: by descriptor, fixed-length descriptorn C H C     The filename of  the file whose  protection is to be modified.  IfH C     the string is larger than 255 bytes, only the first 255  bytes are C     used.a Cs( C     PROT      type:      unsigned word$ C               access:    read only' C               mechanism: by reference  ClH C     The bit mask  that is to replace  or modify the  file's protectionH C     bits.  The mask  should be  specified in  the format  described byH C     section 12.13 of the VAX Record Management Services Reference Man-
 C     ual. C > C     The order is SYSTEM, OWNER, GROUP, WORLD (bits 0 to 15).E C     Within each subfield, the bits are READ, WRITE, EXECUTE, DELETE H C     (low to high).  To turn off access you set the bit associated with2 C     that access.  The structure looks like this: C > C       |   WORLD   | |  GROUP    | |  OWNER   | |  SYSTEM   |< C         D  E  W  R    D  E  W  R   D  E  W  R   D  E  W  R< C        15 14 13 12   11 10  9  8   7  6  5  4   3  2  1  0 C  C 2 C     CODE      type:      signed longword integer$ C               access:    read only' C               mechanism: by referencen C(H C     The type of modification to be performed on  the file's protectionH C     bits.  A  value of 0 indicates the  bits are to be replaced by theH C     PROT argument;  values  1, 2, and 3 indicate  the bits  are  to beH C     ANDed, inclusive-ORed, or  exclusive-ORed with the  PROT argument,H C     respectively.  The  protection  bits  are left  unchanged  for all$ C     other values of this argument.  H C=======================================================================         IMPLICIT  NONE         INCLUDE   '($FABDEF)'        INCLUDE   '($XABDEF)'        INCLUDE   '($XABPRODEF)'  H C     We have to define our own structure to access a XABPRO because DEC/ C     is too stupid to define theirs correctly.e         STRUCTURE /XABPRO/          UNION             MAPn$                RECORD /XABDEF/     A             END MAP              MAP)$                RECORD /XABPRODEF1/ B             END MAP.          END UNION       END STRUCTUREo         CHARACTER FILE*(*)       INTEGER*2 PROT       INTEGER*4 CODE         RECORD    /FABDEF/ FAB       RECORD    /XABPRO/ XAB         INTRINSIC JMIN0(       INTRINSIC LEN        EXTERNAL  LIB$INSV       EXTERNAL  LIB$MOVC5        EXTERNAL  SYS$CLOSE)       INTEGER*4 SYS$CLOSE        EXTERNAL  SYS$OPEN       INTEGER*4 SYS$OPEN  H C-----------------------------------------------------------------------  H C     First initialize and  link a FAB and XAB.  Note that  if we do notH C     open the  file with some sort  of write access the protection will C     not be changed.i  0       CALL LIB$MOVC5 ( 0, 0, 0, FAB$C_BLN, FAB )         FAB.FAB$B_BID = FAB$C_BID        FAB.FAB$B_BLN = FAB$C_BLN        FAB.FAB$B_FAC = FAB$M_PUTt"       FAB.FAB$L_FNA = %LOC( FILE )D       CALL LIB$INSV ( JMIN0( LEN(FILE), 255 ), 0, 8, FAB.FAB$B_FNS )  H C     RMS will balk if the  file has been opened by  someone else.  WithH C     the following SHR options we'll at least get through the case when, C     the file has been opened write-shared.  9       FAB.FAB$B_SHR = FAB$M_SHRPUT .OR. FAB$M_SHRGET .OR. C      .                FAB$M_SHRDEL .OR. FAB$M_SHRUPD .OR. FAB$M_UPI.  !       FAB.FAB$L_XAB = %LOC( XAB )5  3       CALL LIB$MOVC5 ( 0, 0, 0, XAB$C_PROLEN, XAB )o  $       XAB.A.XAB$B_BLN = XAB$C_PROLEN!       XAB.A.XAB$B_COD = XAB$C_PROu  H C-----------------------------------------------------------------------  H C     There is  no RMS service to  change file protections.  To do so weH C     open the file with write access and then close  it with a new pro- C     tection mask.   (       MODIFY_FILE_PROT = SYS$OPEN( FAB ))       IF ( .NOT.MODIFY_FILE_PROT ) RETURNe  !       IF     ( CODE .EQ. 0 ) THENe5          XAB.B.XAB$W_PRO =                       PROT/!       ELSEIF ( CODE .EQ. 1 ) THEN 5          XAB.B.XAB$W_PRO = XAB.B.XAB$W_PRO .AND. PROT$!       ELSEIF ( CODE .EQ. 2 ) THEN 5          XAB.B.XAB$W_PRO = XAB.B.XAB$W_PRO .OR.  PROT !       ELSEIF ( CODE .EQ. 3 ) THENp5          XAB.B.XAB$W_PRO = XAB.B.XAB$W_PRO .XOR. PROTi       END IF  )       MODIFY_FILE_PROT = SYS$CLOSE( FAB )p       RETURN  H C=======================================================================  	       END  ."       subroutine sm_repaint_screen         include 'swing.cmn'l  )       call smg$repaint_screen( board_id )          return	       end   !       subroutine sm_allow_repaintc         include 'swing.cmn'2         integer  address        external sm_repaint_screen  *       address =  %loc( sm_repaint_screen ):       call smg$set_out_of_band_asts( board_id, '800000'x, 4      .                               %val(address) )         return	       end,