unit Afdd;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Sockets;

type
  TAFDDForm = class(TForm)
    AFDDOK: TBitBtn;
    Edit1: TEdit;
    DirectInfo: TMemo;
    Label1: TLabel;
    SearchButt: TButton;
    FoundLabel: TLabel;
    FoundBox: TMemo;
    Timer1: TTimer;
    Sockets1: TSockets;
    procedure SearchButtClick(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure AFDDOKClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Sockets1DataAvailable(Sender: TObject; Socket: Word);
    procedure Sockets1SessionConnected(Sender: TObject; Socket: Word);
    procedure Sockets1SessionClosed(Sender: TObject; Socket: Word);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AFDDForm: TAFDDForm;
  atick: integer;
  sock_open: boolean;

implementation

{$R *.DFM}


procedure TAFDDForm.SearchButtClick(Sender: TObject);
{ The users has clicked SEARCH... time to ask Merlin
  about the user in the Edit Box }
begin
   FoundBox.Clear;
   atick := 0;
   if Edit1.Text = '' then
      ShowMessage ('Enter a search string in the box first.')
   else begin
      Sockets1.IPAddr := 'merlin.arc.nasa.gov';
      Sockets1.Port := '3000';
      Sockets1.SConnect;
      sock_open := true;
   end;
end;

procedure TAFDDForm.Edit1Change(Sender: TObject);
begin
   FoundBox.Clear;
   atick := 0;
end;

procedure TAFDDForm.AFDDOKClick(Sender: TObject);
begin
   FoundBox.Clear;
   Edit1.Clear;
end;

procedure TAFDDForm.Timer1Timer(Sender: TObject);
begin
   atick := atick + 1;
   if atick >= 12 then AFDDForm.ModalResult := mrOK;
end;

procedure TAFDDForm.FormActivate(Sender: TObject);
begin
   atick := 0;
end;

procedure TAFDDForm.Sockets1DataAvailable(Sender: TObject; Socket: Word);
var
   st, line: string;
   ls, i: integer;
begin
   st := Sockets1.Text;
   ls := length(st);
   line := '';
   for i := 1 to ls do begin
      if st[i] = #10 then begin
         FoundBox.Lines.Add (line);
         line := '';
      end
      else line := line + st[i];
   end;
end;

procedure TAFDDForm.Sockets1SessionConnected(Sender: TObject;
  Socket: Word);
begin
   Sockets1.Text := 'L' + Edit1.Text;
end;

procedure TAFDDForm.Sockets1SessionClosed(Sender: TObject; Socket: Word);
begin
   if sock_open then Sockets1.SClose;
end;

initialization
   sock_open := false;
   end.

end.
