/*
 *  General Purpose TCP Server.  (GPSERVER)
 *
 *  This server is called anytime the server receives a request for the
 *  GPSERVER TCP port.  The first packet must include the purpose
 *  as the first character in the packet (as described below).  The
 *  remainder of the packet (and all subsequent packets) are defined
 *  by the function code.
 *
 *
 *  To compile and link this server 
 *    $ CC S
 *    $ LINK S,SYS$INPUT:/OPT
 *    MULTINET:MULTINET_SOCKET_LIBRARY/SHARE
 *    SYS$SHARE:VAXCRTL/SHARE
 *    ^Z
 *
 */

#include "multinet_root:[multinet.include.sys]types.h"
#include "multinet_root:[multinet.include.sys]socket.h"
#include "multinet_root:[multinet.include.netinet]in.h"
#include <stdio.h>
#include "multinet_root:[multinet.include]netdb.h"

main()
{
	unsigned short s, vs;
	int i, n, status;
	char buf[256];
        char subtype;
	struct sockaddr_in sin;
	struct hostent *hp;
	static struct {int Size; char *Ptr;} Descr={9 ,"SYS$INPUT"};


/*
 *  $ASSIGN a channel to SYS$INPUT. This channel is the channel
 *  to the network connection.
 */

	status = SYS$ASSIGN(&Descr, &s, 0, 0);
	if (!(status&1)) {
		exit(status);
	}


/*
 *  Who made the connection to us?  (Currently unused info).
 */

/*	n = sizeof(sin);
	if (getpeername(s, &sin, &n) < 0) {
		socket_perror("GPServer getpeername");
		exit(0x10000000);
	}   */

/*
 *  `sin' will be a sockaddr_in structure describing the
 *  remote IP address (and port #) which the connection
 *  was made from.  (Currently unused info).
 */

        hp = gethostbyaddr(&sin.sin_addr, sizeof(sin.sin_addr), AF_INET);

/*
 *  First buffer... the first character contains the operation to be
 *  performed.
 *
 *
 *
 *  socket_read() will return 0 on end-of-file, or -1 on error...
 */
	n = socket_read(s, buf, sizeof(buf));

	if (n <= 0) {
	    socket_perror("GPSERVER: empty request received.");
	}


        subtype = buf[0];

/******************************************************************************
 *
 *  Defined service subtypes (first character):
 *
 *     A - Test that service is up... send rest of buffer to RAGOSTA
 *     L - Lookup EMail/phone info... 
 *     S - Send status information... see below for definition
 *     U - Send updated events information
 *
 *****************************************************************************/


        switch (subtype) {
           
           case 'a':
           case 'A':
                n--;
                send_sys (buf, &n);
                strcpy(buf,"Server listening!");
                n = 16;
                i = socket_write(s, buf, n);
                break;

           case 'l':
           case 'L':
                lookup_stuff (&s, buf, &n);
                break;

           case 's':
           case 'S':
                get_status (buf, &n);
                i = socket_write (s, buf, n);
                break;

           case 'u':
           case 'U':
                break;

           default:
                send_sys (buf, &n);
/*                socket_perror("GPSERVER: unknown subtype received."); */
                break;
           }


/*
 *  Now close down the connection...
 */

	socket_close(s);

/*
 *  Exit successfully.
 */

	exit(1);
}
