 $! ALPHA_COMPILE.COM $! $! Version: 1.3-1  $! Date:    22-Sept-1995 $! $! Author: Lenny Szubowicz $! $! Abstract: $!C $!	The ALPHA_COMPILE.COM procedure can be used to compile a private > $!	version of a module that is compiled during the build of anD $!	OpenVMS Alpha base level.  This procedure attempts to compile the? $!	source module using the same compiler options that were used  $!	during the base level build.  $!	 > $!	This procedure uses the facility ASM data file to determineA $!	the necessary prefix files and macro libraries.  Similarly, if A $!	directed by the ASM data file, the module is compiled multiple : $!	times to produce variant versions of the object module. $!	 F $!	Before you use this procedure you should be aware of the following: $!	 I $!	(1)  You need to use a directory structure that mimics the result disk J $!	     structure; i.e. device:[...facility.SRC],device:[...facility.OBJ],  $!	     device:[...facility.LIS] $!	 F $!	(2)  You may also wish to define the logical name DSKD$ as a rootedF $!	     device name that makes your local facility directory appear toF $!	     be a top-level directory on the DSKD$ device.  For example, if; $!	     you have WORK1:[JODI_DEVO.PROJ1.SYS.SRC] you would:  $!	 = $!	       DEFINE DSKD$/TRANS=CONCEAL WORK1:[JODI_DEVO.PROJ1.]  $!	 E $!	     The ALPHA_COMPILE.COM procedure has been recently enhanced to D $!	     automatically define the DSKD$ logical name if the directory> $!	     path to the source module requires more than 2 levels. $!	     E $!	(3)  Your current default device and directory should be expressed D $!	     in terms of DSKD$.  However, the ALPHA_COMPILE.COM procedureD $!	     has been recently enhanced to automatically comply with thisG $!	     requirement whenever it automatically defines the DSKD$ logical  $!	     name (item 2 above). $!	 A $!	(4)  You need to have used the USE_BASE_LEVEL.COM procedure to + $!	     select the compilers and libraries.  $!, $!	There are two ways to use this procedure. $! $! Usage 1:  $!" $!	@ALPHA_COMPILE source[switches] $!G $!	This procedure will atttempt to obtain guidance from the appropriate I $!	facilityASM.DAT file about prefix file names, output module name, macr D $!	libraries, and additional compiler options.  You can also specifyF $!	additional switches.  Note that if you do, you must not include anyH $!	spaces between the source file name and the qualifiers.  For example: $!( $!		@ALPHA_COMPILE [.SRC]SYSQIOREQ/NOOPT $!E $!	If the source module is not found in the appropriate ASM file, the  $!	procedure assumes usage 2.  $! $! Usage 2:  $!6 $!	@ALPHA_COMPILE source1[+source2][switches] [module] $!C $!	Specifically, this case applies when you have specified multiple > $!	source modules and/or have specified an output module name. $!@ $!	In this case, the procedure does not take any guidance from aC $!	facilityASM.DAT file.  You can exert additional control over the 7 $!	actions taken by defining the following DCL symbols:  $!) $!	olb	Object library name (def=facility) # $!	gbl	LIBRARY/gbl  (def=NOGLOBALS) = $!	ml1	Name of first macro library (def=EXECML$ or EXECLIBH$) 1 $!	ml2	Name of second macro library (.MAR and .C) 0 $!	ml3	Name of third macro library (.MAR and .C)1 $!	ml4	Name of fourth macro library (.MAR and .C) 0 $!	ml5	Name of fifth macro library (.MAR and .C)& $!	opt	Additional switches for compile $!	  $! $!- $ saved_vfy = f$verify(f$trnlnm("DEBUG_COM")) 
 $ set noon $! $ defi*ne := define/nolog  $!B $ tmp1_file_name = "sys$scratch:t1_" + f$getjpi("","pid") + ".tmp" $!E $ found_in_facasm = "N"		! Assume source not found in FACASM.DAT file  $!? $ o_ml1 = "''ml1'"		! Original values in case not in FACASM.DAT  $ o_ml2 = "''ml2'" $ o_ml3 = "''ml3'" $ o_ml4 = "''ml4'" $ o_ml5 = "''ml5'" $ o_opt = "''opt'" $ o_gbl = "''gbl'" $ o_olb = "''olb'" $!< $ prefix1 = ""			! Initialize global facASM prefixes to null $ prefix2 = "" $ prefix3 = "" $ prefix4 = "" $ prefix5 = "" $!: $ orig_def = ""			! Did not change default directory (yet) $! $! $ on control_y then goto abort $! $!- $ supported_types = ".MAR.M64.BLI.B32.B64.C."  $ macro_type          = ".MAR" $ evax_assembler_type = ".M64" $ bliss_type          = ".B32" $ bliss64_type        = ".B64" $ ansi_cc_type        = ".C" $ cc_type	      = ".C" $! $ lang = ""  $!1 $ build_arch = 1	! AXP cross build hosted on VAX    $ if f$type(AXP_NATIVE) .nes. "" $ then- $    if axp_native .eq. 1 then build_arch = 2  $ endif  $ * $ if f$getsyi("ARCH_TYPE") .ne. build_arch $ then $   write sys$output "" O $   write sys$output "%COMPILE-W-DIFFARCH, ",F$GETSYI("ARCH_NAME")," system ",- L                       F$GETSYI("NODENAME")," architecture is different from"_ $   write sys$output "                     what was used to build baselevel ",F$TRNLNM("RESD$")  $ endif  $! $! $get_p1: $ if p1 .eqs. "" $ thenJ $     read/end=ok_done/error=ok_done/prompt="Source file: " sys$command p1 $     goto get_p1  $ endif  $!/ $ switches = f$extract(f$locate("/",p1),999,p1)  $ p1 = f$element(0,"/",p1)   $! $!F $! The user's current default directory needs to minic the result diskL $! structure.  Specifically, this procedure expects that the source file can> $! specified in this fashion: DSKD$:[facility.SRC]source_file J $! However, we allow the user fairly wide latitude.  If the directory pathL $! to the file contains more than two levels, we reduce it to the right-mostL $! two levels and define the rooted device logical name DSKD$ to include theE $! remaining left-most levels.  We then set the default directory to: F $! DSKD$:[first-of-2-right-most].  Since the source file may have beenK $! specified relative to the original default directory, the directory path - $! to the source file is altered accordingly.  $!	 9 $ if f$element(2,".",f$parse(p1,,,"directory")) .nes. "."  $ then $!' $   src_dir = f$parse(p1,,,"directory") $ $   src_dev = f$parse(p1,,,"device") $!
 $down_dir:8 $     src_dev = src_dev + f$element(0,".",src_dir) + "."> $     src_dir = f$extract(f$locate(".",src_dir)+1,999,src_dir)< $   if f$element(2,".",src_dir) .nes. "." then goto down_dir $!) $   define dskd$/trans=conceal 'src_dev'] ' $   orig_def = f$environment("default") 2 $   set default dskd$:['f$element(0,".",src_dir)']( $   p1 = f$parse("dskd$:[''src_dir'",p1) $! $   write sys$output "" N $   write sys$output "Logical name DSKD$ is now defined as ",f$trnlnm("DSKD$")N $   write sys$output "Your default directory is now ",f$environment("default") $   write sys$output ""  $! $ endif  $!@ $! Whatever is now the top-level directory is the facility name. $!> $ fac = f$element(0,".",f$directory() - "[" - "]" - "<" - ">") $!= $ facnam == fac		! RESCOM$:LINK_DRIVER.COM uses FACNAM symbol  $! $!N $! Determine if we should use the FACASM.DAT file to build the compile command $!G $! If the command line includes multiple sources separated by "+" or if I $! an explicit output module name has been specified, then do not use any  $! FACASM.DAT file.  $!2 $ if f$trnlnm("facasm") .nes. "" then close facasmL $ if f$locate("+",p1) .lt. f$length(p1) .or. p2 .nes. "" then goto no_facasm $!H $! Only a single module on the command line.  Remember original name for  $! later use if FACASM.DAT used. $! $ src_name = p1 1 $ src_module = f$parse(p1,,,"name","syntax_only")  $!F $! Attempt to the the FACASM.DAT file first locally then on the RESD$./ $! If found, use it, otherwise proceed without.  $!; $ facasm_name = f$search("dskd$:[''fac'.com]''fac'asm.dat") X $ if facasm_name .eqs. "" then facasm_name = f$search("resd$:[''fac'.com]''fac'asm.dat")- $ if facasm_name .eqs. "" then goto no_facasm  $!0 $ open/read/error=no_facasm facasm 'facasm_name' $ write sys$output "" . $ write sys$output "Reading file ",facasm_name $ write sys$output ""  $ goto next_asm  $! $! $no_facasm:  $ write sys$output "" K $ write sys$output "Proceeding without guidance from a ",fac,"ASM.DAT file"  $ write sys$output ""  $ goto parse_param   $! $!
 $next_asm:% $ read/end=eof_facasm facasm asm_line 7 $ asm_line = f$edit(asm_line,"UNCOMMENT,TRIM,COMPRESS")  $!& $ if f$extract(0,1,asm_line) .eqs. "$" $ then $!( $   asm_line = f$extract(1,999,asm_line)	 $   i = 0 
 $next_dcl:) $     asm_dcl = f$element(i,";",asm_line)  $     if asm_dcl .nes. ";"
 $     then $       'asm_dcl'  $       i = i + 1  $       goto next_dcl  $     endif  $! $ endif  $!9 $ if f$extract(0,1,asm_line) .nes. "%" then goto next_asm & $ asm_line = f$edit(asm_line,"UPCASE")M $ if f$locate(src_module,asm_line) .ge. f$length(asm_line) then goto next_asm  $!2 $ p1 = f$element(1,"/",asm_line)			!source modulesE $ p2 = f$element(0,"/",f$extract(1,999,asm_line))	!output module name  $!
 $parse_param:  $!? $ lprefix1 = ""			!Initialize local per module prefixes to null  $ lprefix2 = ""  $ lprefix3 = ""  $ lprefix4 = ""  $ lprefix5 = ""  $! $!) $! First consider the global prefix files  $! $ num_prefix = 0 $next_gprefix:! $     num_prefix = num_prefix + 1 $ $     if prefix'num_prefix' .nes. ""
 $     then0 $       lprefix'num_prefix' = prefix'num_prefix' $       goto next_gprefix  $     endif  $ num_prefix = num_prefix - 1  $!D $! Then consider and local prefix files specified on the module line $! $ i = 0  $next_lprefix:& $     cur_prefix = f$element(i,"+",p1) $     if cur_prefix .nes. "+"  $     then   $         i = i + 1 % $         num_prefix = num_prefix + 1 $ $	  lprefix'num_prefix' = cur_prefix $         goto next_lprefix  $     endif  $!. $! The last prefix is actually the source file $!# $ last_source = lprefix'num_prefix'  $ lprefix'num_prefix' = "" $ num_prefix = num_prefix - 1  $!L $! Now that the source file name has been isolated, if we are using a facASMJ $! file and the module line does not specify the same module name that wasJ $! specified to this command procedure, then consider the next line in the $! facASM file.  $!  $ if f$trnlnm("facasm") .nes. "" $ thenC $   if src_module .nes. f$parse(last_source,,,"name","syntax_only")  $   then $     goto next_asm 	 $   endif  $   src_default = src_name $ else $   src_default = "" $ endif  $! $! $! Find the main source file. P $! If the language type was found in the facASM file, then use that to determineO $! the default file type.  Otherwise attempt to find a file using the supported  $! file types. $! $ if lang .nes. "" $ then $! $   lang_type = lang + "_type"# $   if f$type('lang_type') .eqs. ""  $   thenK $     write sys$output "%COMPILE-F-UNSUPPORTED, unsupported language ",lang G $     exit_status = %x00000E4A	! SS$_UNSUPPORTED  'f$verify(saved_vfy)	  $     goto quit 	 $   endif  $! $   lang_type = 'lang_type' F $   source = f$parse(last_source,lang_type,src_default,,"syntax_only")< $   file_type = f$parse(source,,,"type","syntax_only") - "." $!9 $   if f$parse(src_name,,,"type","syntax_only") .nes. "."  $   thenE $     if f$parse(src_name,,,"type","syntax_only")-"." .nes. file_type 
 $     thenM $       write sys$output "Skipping module ",last_source," for language ",lang  $       goto next_asm  $     endif 	 $   endif  $! $   source = f$search(source)  $   if source .eqs. "" $   thenJ $       write sys$output "%COMPILE-F-FILENOTFOUND, unable to find file ",-R                          f$parse(last_source,lang_type,src_default,,"syntax_only")A $       exit_status = %x00018292	! RMS$_FNF  'f$verify(saved_vfy)  $       goto quit 	 $   endif  $! $ else $!M $   source = f$search(f$parse(last_source,".MAR",src_default,,"syntax_only")) e $   if source .eqs. "" then source = f$search(f$parse(last_source,".M64",src_default,,"syntax_only")) e $   if source .eqs. "" then source = f$search(f$parse(last_source,".BLI",src_default,,"syntax_only")) e $   if source .eqs. "" then source = f$search(f$parse(last_source,".B32",src_default,,"syntax_only")) e $   if source .eqs. "" then source = f$search(f$parse(last_source,".B64",src_default,,"syntax_only")) c $   if source .eqs. "" then source = f$search(f$parse(last_source,".C",src_default,,"syntax_only"))  $! $   if source .eqs. "" $   thenT $       write sys$output "%COMPILE-F-FILENOTFOUND, unable to find file ",last_sourceA $       exit_status = %x00018292	! RMS$_FNF  'f$verify(saved_vfy)  $       goto quit 	 $   endif  $!< $   file_type = f$parse(source,,,"type","syntax_only") - "." $!Q $   if f$locate(".''file_type'." ,supported_types) .ge. f$length(supported_types)  $   thenS $       write sys$output "%COMPILE-F-UNSUPPORTED, unsupported file type ",file_type I $       exit_status = %x00000E4A	! SS$_UNSUPPORTED  'f$verify(saved_vfy)	  $       goto quit 	 $   endif  $! $ endif  $!  $ if f$trnlnm("facasm") .nes. "" $ then $   found_in_facasm = "Y"  $ endif  $!1 $ module = f$parse(source,,,"name","syntax_only") ! $ if p2 .nes. "" then module = p2  $! $! $! Find all the prefix files $!+ $ orig_src = f$trnlnm("src$","lnm$process") 7 $ define/nolog src$ dskd$:['fac'.src],resd$:['fac'.src]  $! $ i = 0  $find_next_prefix: $     i = i + 1  $     if i .le. num_prefix
 $     then- $         lprefix_file = f$search(lprefix'i') e $	  if lprefix_file .eqs. "" then lprefix_file = f$search(f$parse(lprefix'i',,source,,"syntax_only")) m $	  if lprefix_file .eqs. "" then lprefix_file = f$search(f$parse(lprefix'i',"resd$:",source,,"syntax_only")) " $         if lprefix_file .eqs. "" $         then $           deassign src$ B $           if orig_src .nes. "" then define/nolog src$ 'orig_src' $!^ $           write sys$output "%COMPILE-F-FILENOTFOUND, unable to find prefix file ",lprefix'i'E $           exit_status = %x00018292	! RMS$_FNF  'f$verify(saved_vfy)  $           goto quit  $         endif + $         lprefix'i' = lprefix_file + " + "  $         goto find_next_prefix  $     endif  $! $ deassign src$ 8 $ if orig_src .nes. "" then define/nolog src$ 'orig_src' $! $! $ mlibs = "" $!  $ if f$trnlnm("facasm") .eqs. "" $ then $   if "''ml1'" .eqs. "" $   then $     ml1 = "execml$" 3 $     if file_type .eqs. "C" then ml1 = "execlibh$" 	 $   endif  $ endif  $! $! $ i = 0 - $ orig_lib = f$trnlnm("lib$","lnm$process",i)  $next_lib_trans:
 $   i = i + 1 0 $   if f$trnlnm("lib$","lnm$process",i) .nes. "" $   thenB $     orig_lib = orig_lib + "," + f$trnlnm("lib$","lnm$process",i) $     goto next_lib_trans 	 $   endif  $!7 $ define/nolog lib$ dskd$:['fac'.obj],resd$:['fac'.obj]  $! $! $ i = 0  $next_mlib: 
 $   i = i + 1  $   if f$type(ml'i') .nes. ""  $   then $     if ml'i' .nes. "" 
 $     then $       ml = ml'i'M $       if f$parse(ml,,,"type","syntax_only") .eqs. "." then ml = ml + ".mlb"  $       ml = f$search(ml) & $       if ml .eqs. "" then ml = ml'i') $       mlibs = mlibs + "+" + ml + "/lib"  $     endif 	 $   endif # $   if i .le. 4 then goto next_mlib  $! $ deassign lib$ 8 $ if orig_lib .nes. "" then define/nolog lib$ 'orig_lib' $! $!L $! Determine default setting of LIBRARY/GLOBALS switch:  If using facASM.DAT, $! then default is /GLOBALS else /NOGLOBALS. $!% $ if "''olb'" .eqs. "" then olb = fac  $! $ if "''gbl'" .eqs. ""   $ then" $   if f$trnlnm("facasm") .eqs. "" $   then $     gbl = "noglobals"  $   else $     gbl = "globals" 	 $   endif  $ endif  $! $!O $! Based upon the source module file type, go to use the corresponding compiler  $! $ if lang .nes. "" $ then $     goto compile_'lang'  $ else $     goto compile_'file_type' $ endif  $! $! $COMPILE_MACRO:		!source lang   $COMPILE_MAR:		!source file type $! $! Alpha MACRO-32 compiler.  $!
 $ set noon $ define/user sys$output nl: $ define/user sys$error  nl:G $ search evms$sysbldcom:bldlognam.com/out='tmp1_file_name' "macro/migr"  $ search_status = $severity  $ if search_status .ne. 1  $ then $     set noon  $     define/user sys$output nl:  $     define/user sys$error  nl:@ $     search evms$sysbldcom:bldlognam.com/out='tmp1_file_name' - 		"macro/alpha"  $     search_status = $severity  $ endif  $! $ if search_status .eq. 1  $ then $     set symbol/scope=nolocal $     @'tmp1_file_name'  $     delete 'tmp1_file_name';* / $     macro_compile = f$edit(macro,"lowercase")  $     set symbol/scope=local  $     delete/symbol/global macro $ else9 $     macro_compile := "macro/alpha/notie/machine/symbol" $ $ endif                              $! $ macro := "macro" $!5 $ starlet_mlb = f$search("alpha$library:starlet.mlb")o $!
 $ set noon $ saved_vfy = f$verify("yes")E# $ define/user starlet	'starlet_mlb'  $ 'macro_compile' 'opt' -  	/lis=['fac'.lis]'module' -g% 	/obj=['fac'.obj]'module' 'switches'-  	resd$:[syslib]arch_defs + -
 	'lprefix1' -e
 	'lprefix2' -u
 	'lprefix3' -m
 	'lprefix4' -o 	'source' -u 	'mlibs'K $ libr/alpha/replace/'gbl'/log ['fac'.obj]'olb'.olb ['fac'.obj]'module'.obja $! 'f$verify(saved_vfy)t $!4 $!? if $status then delete ['fac'.obj]'module'.obj;* $!  $ if f$trnlnm("facasm") .eqs. "" $ then $   define/user sys$output nl: $   define/user sys$error  nl:5 $   search/match=and/out=nl: 'source' .if,hlldd$step1o) $   if $severity .ne. 1 then goto ok_done: $! $   saved_vfy = f$verify("yes")e# $ define/user starlet	'starlet_mlb't $ 'macro_compile' 'opt' -i 	/lis=['fac'.lis]'module' -d& 	/obj=['fac'.obj]'module' 'switches'	- 	sys$input: +				- 	resd$:[syslib]arch_defs +		- 
 	'lprefix1' -o
 	'lprefix2' -$
 	'lprefix3' -!
 	'lprefix4' -m 	'source' -y 	'mlibs' $DECKyG 	HLLDD$STEP1 = 1 ;Enable support for step 1 drivers (as well as Step 2)e $EODK $ libr/alpha/replace/'gbl'/log ['fac'.obj]'olb'.olb ['fac'.obj]'module'.obj! $! 'f$verify(saved_vfy)$ $!4 $!? if $status then delete ['fac'.obj]'module'.obj;* $! $ endifL $!D $ delete/symbol macro		! Need to delete local symbol if looping back $!3 $ if f$trnlnm("facasm") .nes. "" then goto next_asmt $ goto ok_done $! $! $!) $COMPILE_EVAX_ASSEMBLER:	!source languager! $COMPILE_M64:			!source file typer $! $! Alpha MACRO-64 assemblern $!
 $ set noon $ define/user sys$output nl: $ define/user sys$error  nl:< $ search evms$sysbldcom:bldlognam.com/out='tmp1_file_name' - 		"evax_assembler" $ search_status = $severity  $ if search_status .eq. 1  $ then $     set symbol/scope=nolocal $     @'tmp1_file_name'E $     delete 'tmp1_file_name';* 9 $     evax_assembler = f$edit(evax_assembler,"lowercase")w $     set symbol/scope=local) $     delete/symbol/global evax_assemblere $ else* $     evax_assembler := "tasm/show=binary"$ $ endif                              $! $ macro := "macro" $ tasm  := "tasm"a $ assemble := "assemble" $! $!
 $ set noon $ saved_vfy = f$verify("yes"). $ 'evax_assembler' 'opt' - 	/lis=['fac'.lis]'module'-% 	/obj=['fac'.obj]'module' 'switches'-   	resd$:[syslib]arch_defs.mar + -" 	alpha$library:starlet.include + - 	alpha$library:lib.include + -
 	'lprefix1' -T
 	'lprefix2' - 
 	'lprefix3' -s
 	'lprefix4' -h	 	'source'tK $ libr/alpha/replace/'gbl'/log ['fac'.obj]'olb'.olb ['fac'.obj]'module'.objL $! 'f$verify(saved_vfy)c $!4 $!? if $status then delete ['fac'.obj]'module'.obj;* $!D $ delete/symbol macro		! Need to delete local symbol if looping backE $ delete/symbol tasm  		! Need to delete local symbol if looping backoF $ delete/symbol assemble	! Need to delete local symbol if looping back $!3 $ if f$trnlnm("facasm") .nes. "" then goto next_asme $ goto ok_done $! $! $!! $COMPILE_BLISS:		!source languagea  $COMPILE_BLI:		!source file type  $COMPILE_B32:		!source file type $! $! Alpha Bliss-32 compiler $!
 $ set noon $ define/user sys$output nl: $ define/user sys$error  nl:F $ search evms$sysbldcom:bldlognam.com/out='tmp1_file_name' "bliss/a32" $ search_status = $severity  $ if search_status .eq. 1  $ then $     set symbol/scope=nolocal $     @'tmp1_file_name'  $     delete 'tmp1_file_name';*B/ $     bliss_compile = f$edit(bliss,"lowercase")o $     set symbol/scope=local  $     delete/symbol/global bliss $ elseP $     bliss_compile = "bliss/a32/notrace/env=nofp/check=(noalign,address_taken)"$ $ endif                              $! $ bliss := bliss $!< $ define/user/nolog lib$ dskd$:['fac'.obj],resd$:['fac'.obj]< $ define/user/nolog src$ dskd$:['fac'.src],resd$:['fac'.src] $!
 $ set noon $ saved_vfy = f$verify("yes")i $ 'bliss_compile' 'opt' -x 	  /lis=['fac'.lis]'module'-' 	  /obj=['fac'.obj]'module' 'switches'- 
 	'lprefix1' -d
 	'lprefix2' - 
 	'lprefix3' -u
 	'lprefix4' -e	 	'source' K $ libr/alpha/replace/'gbl'/log ['fac'.obj]'olb'.olb ['fac'.obj]'module'.obj. $! 'f$verify(saved_vfy)  $!4 $!? if $status then delete ['fac'.obj]'module'.obj;* $!D $ delete/symbol bliss		! Need to delete local symbol if looping back $!3 $ if f$trnlnm("facasm") .nes. "" then goto next_asm  $ goto ok_done $! $! $!" $COMPILE_BLISS64:	!source language  $COMPILE_B64:		!source file type $! $! Alpha Bliss-64 compiler $!
 $ set noon $ define/user sys$output nl: $ define/user sys$error  nl:F $ search evms$sysbldcom:bldlognam.com/out='tmp1_file_name' "bliss/a64" $ search_status = $severity  $ if search_status .eq. 1  $ then $     set symbol/scope=nolocal $     @'tmp1_file_name'  $     delete 'tmp1_file_name';*w1 $     bliss_compile = f$edit(bliss64,"lowercase")  $     set symbol/scope=local" $     delete/symbol/global bliss64 $ elseP $     bliss_compile = "bliss/a64/notrace/env=nofp/check=(noalign,address_taken)"$ $ endif                              $! $ bliss := bliss $! $!< $ define/user/nolog lib$ dskd$:['fac'.obj],resd$:['fac'.obj]< $ define/user/nolog src$ dskd$:['fac'.src],resd$:['fac'.src] $!
 $ set noon $ saved_vfy = f$verify("yes")i $ 'bliss_compile' 'opt' -s 	  /lis=['fac'.lis]'module'-' 	  /obj=['fac'.obj]'module' 'switches'-e
 	'lprefix1' -a
 	'lprefix2' - 
 	'lprefix3' - 
 	'lprefix4' -c	 	'source'eK $ libr/alpha/replace/'gbl'/log ['fac'.obj]'olb'.olb ['fac'.obj]'module'.obje $! 'f$verify(saved_vfy)m $!4 $!? if $status then delete ['fac'.obj]'module'.obj;* $!D $ delete/symbol bliss		! Need to delete local symbol if looping back $!3 $ if f$trnlnm("facasm") .nes. "" then goto next_asm  $ goto ok_done $! $! $!" $COMPILE_ANSI_CC:	!source language $COMPILE_C:		!source file type $! $! Alpha DEC C compiler2 $! $! $ ansi_cc_verb = "gemcc/"s) $ if axp_native then ansi_cc_verb = "cc/"1 $ define/user sys$output nl: $ define/user sys$error  nl:F $ search evms$sysbldcom:bldlognam.com/out='tmp1_file_name'/match=and - 		"ansi_cc","''ansi_cc_verb'"e $ search_status = $severity  $ if search_status .eq. 1  $ then $     set symbol/scope=nolocal $     @'tmp1_file_name'e $     delete 'tmp1_file_name';*e+ $     ansi_cc = f$edit(ansi_cc,"lowercase"): $     set symbol/scope=local" $     delete/symbol/global ansi_cc $ elseF $     ansi_cc := "gemcc/opt/machine/instruction=nofloat/extern=strict"$ $ endif                              $!& $ if f$type(BUILD$DECC_64BIT) .NES. "" $ then $     if build$decc_64bit 
 $     then9 $         write sys$output "Using 64-bit DEC C compiler."v $	  write sys$output ""i $     endif  $ endif$ $!
 $ set noon $ saved_vfy = f$verify("yes")  $ 'ansi_cc' 'opt' -  	  /lis=['fac'.lis]'module'-' 	  /obj=['fac'.obj]'module' 'switches'-e
 	'lprefix1' -s
 	'lprefix2' -T
 	'lprefix3' -t
 	'lprefix4' -a 	'source' -  	'mlibs'K $ libr/alpha/replace/'gbl'/log ['fac'.obj]'olb'.olb ['fac'.obj]'module'.obju $! 'f$verify(saved_vfy)e $! $!3 $ if f$trnlnm("facasm") .nes. "" then goto next_asmf $ goto ok_done $! $! $!& $COMPILE_CC:		!source language (VAX C) $!% $! Alpha DEC C compiler in VAX C modeo $! $ cc_verb = "gemcc" # $ if axp_native then cc_verb = "cc"e $!
 $ set noon $ saved_vfy = f$verify("yes")M? $ 'cc_verb'/standard=vaxc/list/machine_code/l_double=64 'opt' -m 	  /lis=['fac'.lis]'module'-' 	  /obj=['fac'.obj]'module' 'switches'-a
 	'lprefix1' - 
 	'lprefix2' -o
 	'lprefix3' -h
 	'lprefix4' -w 	'source' -  	'mlibs'K $ libr/alpha/replace/'gbl'/log ['fac'.obj]'olb'.olb ['fac'.obj]'module'.obj  $! 'f$verify(saved_vfy)c $! $!3 $ if f$trnlnm("facasm") .nes. "" then goto next_asm" $ goto ok_done $! $!% $! Reached end-of-file in facASM.DAT.'I $! If we have not found the source module listed then say so, restore thecK $! original values of the DCL symbols used as implicit inputs (scanning therM $! facASM.DAT has almost certainly changed them), and go back and process thecC $! original parameters as if we could not find the facASM.DAT file.!J $! If we have found and processed the source module at least once, then we $! are finished. $! $eof_facasm: $ if .not. found_in_facasm $ thenM $   write sys$output "Source module ",src_module," not found in ",facasm_name_4 $   if f$trnlnm("facasm") .nes. "" then close facasm $!+ $   p1 = src_name		!restore original valuesd $   p2 = "" A $   ml1 = o_ml1			!restore original values, changed by facASM.DAT  $   ml2 = o_ml21 $   ml3 = o_ml3" $   ml4 = o_ml4_ $   ml5 = o_ml5= $   opt = o_opt" $   gbl = o_gbll $   olb = o_olba
 $   lang = ""$6 $   prefix1 = ""		! Initialize global prefixes to null $   prefix2 = "" $   prefix3 = "" $   prefix4 = "" $   prefix5 = "" $   goto no_facasm $ endife $! $ goto ok_done $! $!	 $ok_done:i $ exit_status = 1z $! $quit: ! 'f$verify(saved_vfy) 
 $ set noon2 $ if f$trnlnm("facasm") .nes. "" then close facasm $ if orig_def .nes. "" $ then $   set default 'orig_def' $   write sys$output ""nN $   write sys$output "Your default directory is now ",f$environment("default") $ endif  $ exit 'exit_status' $! $abort: ! 'f$verify(saved_vfy) $ exit_status = %x2a $ goto quit 