 #pragma module MMOV$ICBM "V1"    /*;  *    MMOV$ICBM -- MultiMedia Configuration Building Module   *J  *    Copyright  Digital Equipment Corporation, 1994 All Rights Reserved.P  *    Unpublished rights reserved under the copyright laws of the United States.  *  M  *    The software contained on this media is proprietary to and embodies the M  *    confidential technology of Digital Equipment Corporation.  Possession,  E  *    use, duplication or dissemination of the software and media is  F  *    authorized only pursuant to a valid written license from Digital  *    Equipment Corporation.  *  L  *    RESTRICTED RIGHTS LEGEND   Use, duplication, or disclosure by the U.S.H  *    Government is subject to restrictions as set forth in SubparagraphK  *    (c)(1)(ii) of DFARS 252.227-7013, or in FAR 52.227-19, as applicable.   *  M  *    -----------------------------------------------------------------------   *  * ABSTRACT:  *O  *  This is the IOGEN Configuration Building Module for the Multimedia Services K  *  for OpenVMS.  The primary function of this module is to load the video  M  *  driver for the AV301/321 FullSupreme Video PCI module, and the J300 Sound H  *  and Motion TurboChannel module; and to load the sound driver for the.  *  Microsoft Windows Sound System ISA module.  *H  *  This module is a shareable image invoked by IOGEN as part of system N  *  autoconfiguration.  It initializes an Autoconfiguration Bus Mapping table,M  *  passes it back to IOGEN, and contains routines that load the video driver N  *  for the TurboChannel or the PCI, and the audio driver for the ISA and EISA
  *  buses.  *  * ENVIRONMENT:   *J  *      Merged as a shareable image by IOGEN Autoconfiguration.  Called inJ  *      EXEC mode at IPL 0.  This image must be installed as a known imageH  *      ($ INSTALL ADD SYS$SHARE:MMOV$ICBM_07.EXE, for example) in orderL  *      for AUTOCONFIGURE to activate it.  If it's being activated by a test9  *      image (as in debugging) it need not be installed.   *F  *      The image name must include the system type and optionally theD  *      CPU type.  These are obtained using the DCL lexical functionF  *      F$GETSYI, parameters "SYSTYPE" and "CPUTYPE".  The systype andG  *      CPU type are appended to the end of the image name following an L  *      underscore.  These values must be two hex digits each.  For example,H  *      on a DEC3000 Model 300, systype is 07 and CPU type is 02, so theF  *      ICBM image name on this system is MMOV$ICBM_0702.EXE.  The CPUG  *      type is optional; the ICBM name could be MMOV$ICBM_07.EXE.  The H  *      systype and CPU type are used by AUTOCONFIGURE to form the imageG  *      name.  The same image can be used on many different systems, as )  *      long as it is name appropriately.   *
  * AUTHOR:  *  *      The Multimedia Group  *  */    /*  *  Include files   */ B #include <adpdef.h>             /* Adapter control block        */B #include <busarraydef.h>        /* Bus array                    */B #include <crbdef.h>             /* Channel request block        */B #include <ctype.h>              /* Character type macros        */B #include <dcdef.h>              /* Adapter type codes           */B #include <descrip.h>            /* String descriptor definitions*/B #include <hwrpbdef.h>           /* HWRPB field definitions      */B #include <ioc_routines.h>       /* for ioc$node_data            */B #include <iocdef.h>             /* for IOC$K_EISA_IRQ           */B #include <iogendef.h>           /* IOGEN symbols and item codes */B #include <ssdef.h>              /* system error codes           */B #include <starlet.h>            /* system service prototypes    */B #include <string.h>             /* C string definitions         */B #include <stsdef.h>             /* status decoding macros       */B #include <vecdef.h>             /* interrupt vector symbols     */   /*  *  External routines in IOGEN  */  int     iogen$ac_select (); # int     iogen$assign_controller ();  int     iogen$log ();  int     sys$load_driver ();    /*)  *  External references to system globals   *E  *  Define a pointer to the hardware RPB.  This is used to locate the H  *  EISA configuration pointer table, which in turn is used to determine<  *  if a device supported by this ICBM exists on the system.  *H  *  Use exe$gpl_hwrpb_l, the 32-bit pointer, instead of exe$gpq_hwrpb, a  *  64-bit pointer.   */  extern HWRPB *exe$gpl_hwrpb_l;   /*  *  Other external definitions  *H  *  These are IOGEN status codes.  They are exported as the addresses of.  *  data cells from the IOGEN shareable image.  */ I extern int IOGEN$_ICBM_OK;        /* Exported by IOGEN shareable image */ I extern int IOGEN$_EXCLUDE;        /* Exported by IOGEN shareable image */    /*  *  Routine prototypes  */ , int             iogen$icbm_init (ABM **abm);: static int      mmov$configure_bus (int handle, ADP *adp);? static int      mmov$configure_bus_eisa (int handle, ADP *adp); I static void     connect_the_driver (int handle, ADP *adp, int mct_index,  7                                     BUSARRAYENTRY *ba); B static int      write_crb_reconnect (CRB *crb, BUSARRAYENTRY *ba);   /*,  *  Data structures used within this module.  */  /*0  * The form of a SYS$LOAD_DRIVER itemlist entry.  */  typedef struct itemlist      {      short int   buffer_size;     short int   item_code;      void        *buffer_address;     short       *return_length;      } ITEMLIST;    /*B  *  Autoconfigure bus mapping table.  This table includes an entry?  *  for each bus this ICBM knows how to configure.  Each entry  >  *  in the table consists of an adapter type and an associated@  *  routine in the ICBM that configures devices on this adapter.A  *  Autoconfigure refers to this table as it scans the system ADP 7  *  list, to determine if this ICBM needs to be called.   */  *  The ABM structure is defined in IOGENDEF.H.   */  static ABM mmov_abm[] =      { !     AT$_PCI,  mmov$configure_bus, !     AT$_TC,   mmov$configure_bus, !     AT$_ISA,  mmov$configure_bus, &     AT$_EISA, mmov$configure_bus_eisa,G     0,        0                         /* Zero signals end of table */      };   /*C  *  Multimedia device configuration table.  This table includes the B  *  8-byte device ID string the ICBM uses to determine if a deviceB  *  exists on the system, the device name and the driver name thatC  *  corresponds to the device, and the adapter type for the bus the   *  the device is on.   *F  *  The device ID is assumed to be no larger than 8 bytes, and if it'sD  *  smaller than 8 bytes, the significant data is in the lower bytesH  *  and the upper bytes are zero.  This is done to simplify comparisons;F  *  the device ID is treated as a 64-bit integer and one comparison is	  *  done.   *E  *  The form of the device ID differs for different buses.  Sometimes #  *  it differs for the same device.   *D  *  For the AV301/AV321, the device ID is the contents of the 32-bitC  *  PCI configuration space PCI ID register.  The upper 32 bits are 	  *  zero.   *?  *  For the AV300-AA, the device ID is the first 8 bytes of the B  *  Turbochannel option ROM.  This is the ASCII string "AV300-AA".  *@  *  For the Microsoft Sound Board, the device ID varies.  On ISAC  *  machines, the console command "add_sound" sets the device ID to D  *  the string "PCXBJ"; VMS copies only the first four bytes of thisA  *  string to the bus array device ID field, resulting in "PCXB".   *C  *  On EISA machines, the default ECU configuration file identifies E  *  the Microsoft Sound Board as "ISA2000".  The ICBM checks for this   *  complete string.  *E  *  "MSB" as a device ID for the Microsoft Sound Board is included in B  *  the configuration table because it was useful in debugging ISA  *  configurations.   *;  *  The complete list of devices supported by this ICBM is:   *9  *      AV301 -- FullVideo Supreme video capture PCI card C  *      AV321 -- FullVideo Supreme JPEG video capture PCI card with ?  *                      on-board JPEG compression/decompression F  *      AV300 -- Sound and Motion J300 video capture Turbochannel cardD  *                      with on-board JPEG compression/decompressionH  *                      (Note that this board also has sound capability,0  *                      which is not supported!))  *      Microsoft Sound System Sound Card *  *      Oak Technologies Mozart Sound CardB  *      Sound card in Digital PCI workstations that are compatible8  *                      with the Microsoft Sound System.  *  *J  *  The configuration table definition is below.  The union for the deviceL  *  ID is necessary because the version of the DEC C compiler in use doesn'tI  *  provide a way to statically initialize a 64-bit field.  Note that the >  *  low-order longword is first, then the high-order longword.  */ 
 static struct      { 	     union 	         {          struct
             {              unsigned int id_l;             unsigned int id_h;             } id_fields;         unsigned __int64 id;         } u_id;      char *device_name;     char *driver_name;     unsigned int adp_type;     } config_table[] =       {     /* ;     *  8-byte device ID    device     driver        adapter ,     *   low       high      name       name      *      *   AV301 device ID      */<     0x00131011, 0x00000000, "VI", "MMOV$VIDRIVER",  AT$_PCI,       /*  AV321 device ID  */ <     0x000E1011, 0x00000000, "VI", "MMOV$VIDRIVER",  AT$_PCI,       /* "AV300-AA" in ASCII  */;     0x30335641, 0x41412D30, "VI", "MMOV$VIDRIVER",  AT$_TC,        /*  "MSB" in ASCII */ <     0x0042534D, 0x00000000, "AU", "MMOV$MSBDRIVER", AT$_ISA,       /*  "PCXB" in ASCII */<     0x42584350, 0x00000000, "AU", "MMOV$MSBDRIVER", AT$_ISA,       /*  "ISA2000" in ASCII */ <     0x32415349, 0x00303030, "AU", "MMOV$MSBDRIVER", AT$_EISA     };  N static int config_table_size = sizeof(config_table) / sizeof(config_table[0]);   /*A  *  iogen$icbm_init -- IOGEN initialization routine for this ICBM   *@  *  This routine is called by IOGEN when the ICBM is loaded.  ItI  *  returns the address of the Autoconfiguration Bus Mapping Table (ABM).   *  *  Inputs:   *@  *      abm -- address of a longword cell to receive the address  *              of the ABM.   *  *  Outputs:  *D  *      The address of the MMOV ABM is written to the input address.  *  *  Status Returns:   *  *      IOGEN$_ICBM_OK  *D  *      Note:  the "&" operator is used below because this symbol isA  *      exported from the IOGEN shareable image as if it were the   *      address of a data cell.   */  int iogen$icbm_init(ABM **abm)     {      *abm = mmov_abm;!     return (int) &IOGEN$_ICBM_OK;      }    /*F  *  mmov$configure_bus -- look for our devices in the ADP's bus array.  *D  *  This routine scans the bus array pointed to by the input ADP forH  *  devices supported by this ICBM.  If a supported device is found, theH  *  associated driver is loaded and the unit connected.  If no device is  *  found, exit.  *  *  Inputs:   *G  *      handle -- magic number interpreted by the autoconfigure support   *            routinesF  *      adp -- pointer to the ADP to be checked for supported devices.  *  *  Implicit Inputs:  *2  *      The multimedia device configuration table.  *  *  Outputs:  *  *      none  *  *  Implicit Outputs:   *A  *      A device driver may be loaded, and a device unit created.   *  *  Status Returns:   *  *      SS$_NORMAL  *B  *      The only errors that could be propagated up are those fromI  *      the connect_the_driver routine, which does not return any errors.   *  */ 4 static int mmov$configure_bus (int handle, ADP *adp)     {      int i, j, k;  	     union        {        char    tempid1[8];        __int64 tempid2;       } u_tempid;               char *id_ptr;        BUSARRAY_HEADER *bah;      BUSARRAYENTRY  *ba;   4     bah = (BUSARRAY_HEADER *) adp->adp$ps_bus_array;7     ba = (BUSARRAYENTRY *) &bah->busarray$q_entry_list;        /*E      *  Scan through the bus array entry list looking for anything in I      *  the configuration table.  For each one found, load the driver and J      *  connect the unit.  All the bus differences, et al., are handled in'      *  the connect_the_driver routine.       */ 6     for (i = 0; i < bah->busarray$l_bus_node_cnt; i++)	         { 
         /*I          *  The busarray$q_hw_id field is a 64-bit quantity.  Do a simple A          *  64-bit comparison to look for a match.  If this is an I          *  ISA ID, this was entered by the user at the console using the K          *  isacfg console command.  The user entered an up to 8-byte ASCII G          *  string.  Convert this string to upper case before doing the 5          *  comparison, as a convenience to the user.           */ *         if (adp->adp$l_adptype == AT$_ISA)
             { 6             id_ptr = (char *) &ba[i].busarray$q_hw_id;#             for (k = 0; k < 8; k++)                  { 9                 u_tempid.tempid1[k] = toupper(id_ptr[k]);                  } 
             }          else
             { 6             u_tempid.tempid2 = ba[i].busarray$q_hw_id;
             }   
         /*I          *  Compare the hardware ID in the bus array slot with each entry K          *  in the configuration table.  Load the driver on the first match H          *  in the configuration table.  As one last consistency check, I          *  make sure the adapter type in the configuration table matches           *  that in the ADP.          */ /         for (j = 0; j < config_table_size; j++) 
             { >             if ( u_tempid.tempid2 == config_table[j].u_id.id )                 { C                 if (config_table[j].adp_type == adp->adp$l_adptype)                      { 6                     connect_the_driver(handle, adp, j,A                                        (BUSARRAYENTRY *) &ba[i]);                      break;                     }                  } =             }   /* for (j = 0; j < config_table_size; j++) */   C         }  /* for (i = 0; i < bah->busarray$l_bus_node_cnt; i++) */        return (SS$_NORMAL);     }    /*B  *  mmov$configure_bus_eisa -- look for our devices in the console*  *                              data block  *B  *      This routine locates our devices in the EISA ConfigurationD  *      Pointer Table.  This table is pointed to by the HWRPB offset?  *      HWRPB$IL_CDB_OFFSET_L.  This value is added to the base D  *      address of the HWRPB to get the address of the configuration@  *      pointer table.  The configuration pointer table consists@  *      of a collection of 3-longword items.  Each item contains?  *      a 7-byte ASCII identification string, followed by a 32- ?  *      bit offset.  The offset is from the base of the Pointer >  *      Table, and points to the compressed configuration dataA  *      block for that device.  The configuration data block, and @  *      the information in the pointer table, all come from data@  *      entered by the user using the ECU at the console prompt.  *D  *      This is the only way to determine if an ISA device supported1  *      by this ICBM is configured on the system.   *=  *      This routine is different from the mmov$configure_bus ?  *      routine, because the location of the data we're looking ?  *      for is very different.  The only thing in the bus array A  *      that's valid for an ISA device on an EISA bus is the CSR, A  *      and only the connect_the_driver routine cares about that.   *  *  Inputs:   *G  *      handle -- magic number interpreted by the autoconfigure support   *                 routines !  *      adp -- pointer to the ADP   *  *  Implicit Inputs:  *2  *      The multimedia device configuration table.5  *      The HWRPB, and the EISA configuration pointer   *      table.  *  *  Outputs:  *  *      none  *  *  Implicit Outputs:   *A  *      A device driver may be loaded, and a device unit created.   *  *  Status Returns:   *(  *      SS$_NORMAL -- everything worked.  *B  *      The only errors that could be propagated up are those fromI  *      the connect_the_driver routine, which does not return any errors.   *  */ 9 static int mmov$configure_bus_eisa (int handle, ADP *adp)O     {"     int found, i, j, status;       HWRPB *hwrpb;t       BUSARRAY_HEADER *bah;      BUSARRAYENTRY  *ba;i   /*H  *  Define a structure for EISA configuration pointer table items.  NoteE  *  that although the first 8 bytes are ASCII in the table, define iteF  *  as an int64 here to make comparisons with the device configurationD  *  table easier.   Use the member_alignment pragma to make sure theJ  *  compiler aligns the members on longword (4-byte) boundaries; otherwiseF  *  the compiler inserts padding before the offset member that doesn't-  *  match how the data is laid out in memory.D  */T #pragma __member_alignment savei% #pragma __nomember_alignment LONGWORDi   typedef struct _cpt {  s              __int64 device_id;               void   *offset;              } EISA_CPT;  " #pragma __member_alignment restore       EISA_CPT *cpt;       /*A      *  Get the pointer to the bus array header, and a pointer toh)      *  the first entry in the bus array.h      */d4     bah = (BUSARRAY_HEADER *) adp->adp$ps_bus_array;7     ba = (BUSARRAYENTRY *) &bah->busarray$q_entry_list;A       /*I      *  Locate the configuration pointer table.  Note that the HWRPB celleD      *  is called "cdb_offset"; this cell points to the CPT, and theF      *  offset member of the CPT points to the CDB for each EISA slot.      */E     hwrpb = exe$gpl_hwrpb_l;G     cpt = (EISA_CPT *) ( (char *)hwrpb + hwrpb->hwrpb$il_cdb_offset_l);*       /*4      *  Scan through the CPT looking for our device.      */e6     for (i = 0; i < bah->busarray$l_bus_node_cnt; i++)	         {h
         /*K          *  Compare the hardware ID in the EISA configuration pointer table K          *  with each entry in the configuration table.  Load the driver ongD          *  the first match in the configuration table.  As one lastN          *  consistency check, make sure the adapter type in the configuration*          *  table matches that in the ADP.          */ /         for (j = 0; j < config_table_size; j++) 
             {a>             if ( cpt[i].device_id == config_table[j].u_id.id )                 {tC                 if (config_table[j].adp_type == adp->adp$l_adptype)Y                     {T6                     connect_the_driver(handle, adp, j,4                           (BUSARRAYENTRY *) &ba[i]);                     break;                     }m                 }D<             }  /* for (j = 0; j < config_table_size; j++) */  C         }  /* for (i = 0; i < bah->busarray$l_bus_node_cnt; i++) */*       return (SS$_NORMAL);     }m o /*?  * connect_the_driver -- loads the driver and connects the unit   *G  *  This routine loads the device driver specified by the configuration B  *  table entry, based on information in the ADP and the bus array
  *  entry.  *G  *  Note that if the device is on an EISA bus, the IRQ is nowhere to beiJ  *  found in the ADP or bus array entry.  Unfortunately, this is needed toH  *  load the driver.  So, the code has to jump through a couple of extra1  *  hoops to find this value, as described below.o  *  *  Inputs:c  *0  *      handle -- the autoconfigure magic number!  *      adp -- pointer to the ADP B  *      mct_index -- index into the multimedia configuration table;  *      ba -- pointer to the bus array entry for the deviceh  *  *  Outputs:  *  *      none  *  *  Side Effects:o  *G  *      A device driver is loaded, and the required portions of the I/O ?  *      database are created.  The driver's controller and unith-  *      initialization routines are executed.   *  *  Status Returns:   *
  *      none.o  *  */ V static void connect_the_driver(int handle, ADP *adp, int mct_index, BUSARRAYENTRY *ba)     {g     int status, temp_vector;     char *device_name_pointer;     short int iosb[4];=     ITEMLIST itemlist[6];               /* for LOAD_DRIVER */ >     int arglist[4];                     /* for CMKRNL calls */
     CRB *crb;   +     struct dsc$descriptor driver_name_desc;s+     struct dsc$descriptor device_name_desc;      char device_name[4];       /**      *  Set up the driver name descriptor.      */eP     driver_name_desc.dsc$w_length = strlen(config_table[mct_index].driver_name);1     driver_name_desc.dsc$b_dtype = DSC$K_DTYPE_T;r1     driver_name_desc.dsc$b_class = DSC$K_CLASS_S; I     driver_name_desc.dsc$a_pointer = config_table[mct_index].driver_name;        /*H      *  Construct the device name.  The first two letters are the deviceF      *  name from the configuration table, the next is the controller F      *  letter, which come from either the bus array entry or from an 0      *  IOGEN routine, followed by an ASCII "0".      */p      /*I2       *  First fill in the device name descriptor.       */&     device_name_desc.dsc$w_length = 4;1     device_name_desc.dsc$b_dtype = DSC$K_DTYPE_T; 1     device_name_desc.dsc$b_class = DSC$K_CLASS_S;c5     device_name_desc.dsc$a_pointer = &device_name[0];m       /*?      *  Now, construct the device name proper, leaving out the _      *  controller letter.      */_>     device_name_pointer = config_table[mct_index].device_name;,     device_name[0] = device_name_pointer[0];,     device_name[1] = device_name_pointer[1];     device_name[3] = '0';d       /*G      *  If the system has assigned a controller letter already, use it.uL      *  Otherwise, ask IOGEN to assign one.  iogen$assign_controller returns=      *  the assigned controller letter in busarray$b_ctrlltr.g      */ $     if (ba->busarray$b_ctrlltr == 0)	         { C         status = iogen$assign_controller (handle, device_name, ba);s)         if (!$VMS_STATUS_SUCCESS(status))e
             { !             device_name[2] = '?';dL             iogen$log(handle, status, &device_name_desc, &driver_name_desc);             return;s
             }a        },     device_name[2] = ba->busarray$b_ctrlltr;       /*L      *  Check whether the device is being implicitly or explicitly excluded.K      *  AUTOCONFIGURE will return either SS$_NORMAL, to indicate the device G      *  should be configured; or IOGEN$_EXCLUDE, which means the devicemI      *  is implicitly or explicitly excluded.  In the latter case, simplyn      *  return.*      */;8     status = iogen$ac_select(handle, &device_name_desc);1     if (status == (int) &IOGEN$_EXCLUDE)  return;        /*E      *  Check to see this device is already configured.  If so, don't M      *  do it again -- multiple connects aren't allowed.  If the no_reconnecthL      *  bit in the bus array entry flags is set, the device has already been      *  connected.      */t-     if (ba->busarray$v_no_reconnect)  return;a       /*K      *  Now fill in the item list for $load_driver, specifying the adapter,oH      *  the CSR, the interrupt vector, the node number, and a pointer toF      *  receive the address of the created CRB.  Like all standard VMS/      *  item lists, it is terminated by a zero.s      */e       /*  The adapter   */4     itemlist[0].buffer_size = sizeof(adp->adp$l_tr);+     itemlist[0].item_code = IOGEN$_ADAPTER; 0     itemlist[0].buffer_address = &adp->adp$l_tr;"     itemlist[0].return_length = 0;       /*  The CSR address */9     itemlist[1].buffer_size = sizeof(ba->busarray$q_csr);*'     itemlist[1].item_code = IOGEN$_CSR;c5     itemlist[1].buffer_address = &ba->busarray$q_csr; "     itemlist[1].return_length = 0;       /*G      *  The interrupt vector.  This is located in a different place for 9      *  each bus, and is especially complicated for EISA.*      */ D     itemlist[2].buffer_size = sizeof(ba->busarray$l_bus_specific_l);*     itemlist[2].item_code = IOGEN$_VECTOR;"     itemlist[2].return_length = 0;       switch (adp->adp$l_adptype)t	         {t         case AT$_PCI:d             /*E              *  If this is the PCI device, the interrupt vector comestF              *  from the low longword of the bus_specific field of the               *  bus array entry.              */uH             itemlist[2].buffer_address = &ba->busarray$l_bus_specific_l;             break;           case AT$_TC:             /*?              *  If it's Turbochannel, the vector comes from theu               *  autoconfig cell.              */oD             itemlist[2].buffer_address = &ba->busarray$l_autoconfig;             break;           case AT$_ISA:*             /*@              *  If this is ISA, the vector is the bus_specific_l              *  cell times 4.i              */a<             temp_vector = ba->busarray$l_bus_specific_l * 4;6             itemlist[2].buffer_address = &temp_vector;             break;           case AT$_EISA:             /*;              *  If this is EISA, ask the system, via a call H              *  to IOC$NODE_DATA, which has to be called in kernel mode.H              *  This routine requires a CRB, which, unfortunately, isn'tC              *  allocated 'til after the SYS$LOAD_DRIVER call.  So, F              *  allocate a private, local CRB, and fill in the values G              *  needed by IOC$NODE_DATA, namely CRB$L_NODE (which comes;I              *  from BUSARRAY$L_NODE_NUMBER), and the address of the ADP. K              *  Don't worry about the rest of the local CRB contents, since M              *  the code path thru IOC$NODE_DATA doesn't touch anything else.               *E              *  When IOC$NODE_DATA returns, multiply the IRQ times 4.               */0
             {O             CRB local_crb;             VEC *vec;*  >             local_crb.crb$l_node = ba->busarray$l_node_number;0             vec = (VEC *) &local_crb.crb$l_intd;"             vec->vec$ps_adp = adp;               arglist[0] = 3;C*             arglist[1] = (int) &local_crb;(             arglist[2] = IOC$K_EISA_IRQ;,             arglist[3] = (int) &temp_vector;9             status = sys$cmkrnl (ioc$node_data, arglist);*             temp_vector *= 4; 6             itemlist[2].buffer_address = &temp_vector;             break;
             }b           default:             /*B              *  If control gets to here, it's an adapter type thisC              *  routine doesn't know how to handle.  Simply return.               */h             return;c             break;-         }  /*  switch (adp->adp$l_adptype) */        /*  The node number */A     itemlist[3].buffer_size = sizeof(ba->busarray$l_node_number); (     itemlist[3].item_code = IOGEN$_NODE;=     itemlist[3].buffer_address = &ba->busarray$l_node_number;s"     itemlist[3].return_length = 0;  0     /*  A pointer to the CRB to be allocated  */*     itemlist[4].buffer_size = sizeof(crb);'     itemlist[4].item_code = IOGEN$_CRB; &     itemlist[4].buffer_address = &crb;"     itemlist[4].return_length = 0;       /*  Terminate the list */u      itemlist[5].buffer_size = 0;     itemlist[5].item_code = 0;#     itemlist[5].buffer_address = 0; "     itemlist[5].return_length = 0;  ?     status = sys$load_driver(IOGEN$_CONNECT, &device_name_desc,r@                              &driver_name_desc, itemlist, iosb);  <     if ($VMS_STATUS_SUCCESS(status)) status = (int) iosb[0];       /*?      *  Log errors here through IOGEN's logging function.  Thisr@      *  information is output when the /LOG qualifier is used on"      *  the AUTOCONFIGURE command.      */oD     iogen$log(handle, status, &device_name_desc, &driver_name_desc);       /*B      * sys$load_driver can return two errors which can be ignored:D      * SS$_DEVEXISTS and SS$_DEVOFFLINE.  DEVEXISTS can never happenD      * if the no_reconnect bit is used. Logic above uses this bit toE      * prevent attempting to load the driver twice.  DEVOFFLINE meansmC      * that for some reason, the device didn't come on line by the rF      * time sys$load_driver completed its work.  This could be becauseC      * some units take a long time to come on line.  Or it could bedB      * because the driver detected some error during controller orD      * unit initialization -- the multimedia video and audio driversA      * work this way.  Either way, these are not errors as far asU2      * the ICBM is concerned, so they are ignored.      *F      * On any other error, exit here without changing the state of the      * no_reconnect bit.      */aA     if ( (status == SS$_DEVEXISTS) || (status == SS$_DEVOFFLINE))t         status = SS$_NORMAL;-     if (!$VMS_STATUS_SUCCESS(status)) return;u       /*E      * Now that the driver is loaded and the unit connected, save the @      * address of the CRB in the bus array entry.  Also, set theE      * no_reconnect flag to indicate the unit cannot be re-connected.aG      * These operations must be done in kernel mode, because the memory D      * containing the bus array entry is not writeable in exec mode.      *G      * Normally, these two functions would be perfomed by a callback to G      * IOGEN.  However, the IOGEN shareable image does not export thesesD      * functions.  So, there is one little kernel-mode routine to doH      * the work.  Finally, note that the status from the sys$cmkrnl call2      * is ignored.  It's there as a debugging aid.      */      arglist[0] = 2;k     arglist[1] = (int) crb;      arglist[2] = (int) ba;7     status = sys$cmkrnl (write_crb_reconnect, arglist);m       return;s     }_ i /*L  * write_crb_reconnect -- write the CRB address and set the no_reconnect bit  *I  *  This routine duplicates the actions of the kernel mode IOGEN routinesrK  *  IOGEN$WRITE_IOGEN_CRB and IOGEN$SET_NORECONNECT, which are not exportedtN  *  by the IOGEN shareable image.  The address of the specified CRB is written:  *  into busarray$ps_crb, and the no_reconnect bit is set.  *M  *  This routine must be called in kernel mode, because the memory containing(6  *  the bus array entry is not writeable in exec mode.  *  *  Inputs:   *C  *      crb -- address of the CRB to write into the bus array entry -  *      ba  -- pointer to the bus array entryr  *  *  Outputs:  *  *      none  *  *  Side Effects:   *  *      none  *  *  Completion Codes:   *  *      SS$_NORMAL  *  */ < static int write_crb_reconnect (CRB *crb, BUSARRAYENTRY *ba)     {_     ba->busarray$ps_crb = crb;$     ba->busarray$v_no_reconnect = 1;     return SS$_NORMAL;     }(