. /* "NDFP" V1..V4(mu) client interface routines  *  * w.j.m. dec 1996 ff.C  * wjm 06-jan-1997: `nfrag' always zero-based, escape from NAK loop <  * wjm 24-jan-1997: add NOM_DIR & NOM_DRV; add exit handler;$  *			always set all output arguments=  * wjm 19-feb-1997: change interface to NDETH: initial delay. ,  * wjm 02-mar-1997: multi-process extensions,  *			(still supporting only a single server)C  * wjm 09-mar-1997: poor man's recovery: remember open() parameters E  * wjm 16-mar-1997: make sure that reopen() doesn't re-create a file; 8  *			use NDFP_SERVER "environment variable" for LANADDR;%  *			remove reference to NOM_CREATERW A  * wjm 16-mar-1997: support V4 with new close2() routine; convert 4  *			deprecated NOM_* options to NCM_* for V4 serverB  * wjm 23-mar-1997: add latent support for V5 (31+9 bit offsets) -(  *			no corresponding user interface yetP  * wjm 24-mar-1997: add new entries to support ND_ATTRIB ("NAB") structure (V5),:  *			*replacing* former close2() routine (only used by the'  *			very first version of ND_RENAME.C) A  * wjm 26-mar-1997: minor edits; re-name constants & header files 4  * wjm 28-mar-1997: fix reopen() to save new shandleI  * wjm 20-apr-1997: add nd_time() for (experimental) time synchronization I  * wjm 22-jun-1997: clear byte count returned by nd_read() and nd_write()   *			only after a _fatal_ error   */    #include <stdio.h> #include <stdlib.h>  #include <string.h>  #include <assert.h>    #include <ssdef.h>   #include "ndfp_proto.h"  #include "ndfp_ethuser.h"   E #define extern		/* use "extern" prototypes as forward declarations */  #include "nd_user.h"
 #undef extern      typedef struct { 	struct ndeth_user_sctx ectx;  	uint32 s_data_max;  	uint32 s_maxcount;  	uint16 s_version; 	uint16 s_window;  } SCTX;   3 static uint16 clno;			/* "client number", 1..255 */   ; static int/*logical*/ active;		/* enforce non-reentrancy */    /*prelim (single server)*/G LANADDR nd_lan_address;		/* may be set externally prior to nd_init() */ , static int/*logical*/ initialized;	/* = 0 */! static SCTX sctxa[1];			/* = 0 */   7 #define NDFP_HDRSIZE (sizeof(NDFP_PKT) - NDFP_DATA_MAX)   * #define MAX(A,B) (((A) > (B)) ? (A) : (B))* #define MIN(A,B) (((A) < (B)) ? (A) : (B))  , #define clear_rq(P) memset(P,0,NDFP_HDRSIZE)     /*****/   6 static NDFP_PKT rqa[NDFP_MAX_FRAG],rpa[NDFP_MAX_FRAG];     /* V2 style */, static unsigned int send_rq2(		/* = rpcnt */
 	SCTX *sx, 	uint16 sh,  	uint16 ch,  	unsigned int rqcnt  ) { 8 	NDFP_PKTDSC rqdsc[NDFP_MAX_FRAG],rqdsc2[NDFP_MAX_FRAG]; 	NDFP_PKT nakp;  	int i;  	uint16 rqop,rqmask,rplen; 	   # 	if(rqcnt > NDFP_MAX_FRAG) abort();    	ndeth_begin(&(sx->ectx));  E 	/* "rqa[]." fields filled in by caller: op,ndata,argw,argl[,data] */    	rqop = rqa[0].op;   	for(i = 0; i < rqcnt; i++) {   		rqa[i].cseq = sx->ectx.s_cseq;< 		rqa[i].ifrag = i;	/* (ifrag == nfrag) marks last packet */ 		rqa[i].nfrag = rqcnt - 1;  		rqa[i].chandle = ch; 		rqa[i].shandle = sh;  B 		rqdsc[i].len = MAX(NDFP_HDRSIZE + rqa[i].ndata,NDFP_PKT_MINLEN); 		rqdsc[i].pp = &rqa[i]; 	}1 	rqmask = (1 << rqcnt) - 1;	/* packets present */    #define rp rpa[0]   < 	/* send all of the packets just once, wait for any reply */) 	ndeth_request(0,rqcnt,rqdsc,&rplen,&rp);  reply0: & 	while(!(rp.cseq == sx->ectx.s_cseq && 		rp.chandle == ch &&  		rp.nfrag < NDFP_MAX_FRAG && 9 		(rp.op & ~NDFP_OP_M_NAK) == (rqop | NDFP_OP_M_REPLY) && ' 		(rp.ndata + NDFP_HDRSIZE) <= rplen &&  		((rp.op & NDFP_OP_M_NAK) ? 			/* tests for NAKs */  		 (rp.nfrag == (rqcnt - 1) && 		  rp.ifrag != 0 &&& 		  (rp.ifrag & rqmask) == rp.ifrag) : 			/* test for non-NAK */  		 (rp.ifrag <= rp.nfrag)))) {8 			/* until a _valid_ reply, re-send last packet only */  			rqdsc2[0] = rqdsc[rqcnt - 1];( 			ndeth_request(1,1,rqdsc2,&rplen,&rp); 		}  		 	if(rp.op & NDFP_OP_M_NAK) { 		unsigned int cnt,mask;  ' 		mask = rp.ifrag | (1 << (rqcnt - 1)); * 		/* always re-send last request packet */0 		for(cnt = i = 0; i < rqcnt; i++, mask >>= 1) { 			if(mask & 1) {  				rqdsc2[cnt++] = rqdsc[i];  			} 		} ) 		ndeth_request(0,cnt,rqdsc2,&rplen,&rp);  		goto reply0; 	}  C 	/* received a non-NAK reply - no longer need to send request(s) */   3 	if(rp.nfrag == 0) {	/* rpa[0] is the only reply */  		ndeth_end(); 		return 1;  	}  ! 	/* build NAK packet prototype */   	memcpy(&nakp,&rp,NDFP_HDRSIZE); 	nakp.ndata = 0; 	nakp.op &= ~NDFP_OP_M_REPLY;  	nakp.op |= NDFP_OP_M_NAK; 	rqdsc2[0].pp = &nakp;3 	rqdsc2[0].len = MAX(NDFP_PKT_MINLEN,NDFP_HDRSIZE);   	 #undef rp  #define rpmask nakp.ifrag % #define rpcnt1 nakp.nfrag	/* # - 1 */   8 	rpmask = (1 << (rpcnt1 + 1)) - 1;	/* replies we need */& 	i = 0;					/* rpa[i] just received */   #define rp rpa[i]    	do {  		int j;  , 		j = rp.ifrag;			/* destination in rpa[] */  1 		/* "escape" has ifrag == nfrag == ndata == 0 */  		if(rp.nfrag == 0) { ' 			/* forget about prior replies ... */  			if(i != 0) rpa[0] = rpa[i];   			ndeth_end(); + 			return 1;		/* (error) reply in rpa[0] */  		}    		/* store unconditionally */ ) 		if(i != j) rpa[j] = rpa[i];		/* move */ * 		rpmask &= ~(1 << j);			/* update mask */   		if(rpmask == 0)	{  			ndeth_end();  			return (rpcnt1 + 1);  		}    		/* find empty rpa[] slot */ - 		for(i = 0; (rpmask & (1 << i)) == 0; i++) ;   9 		/* if no more packets in the receive queue, send NAK */  		do {( 			ndeth_request(1,1,rqdsc2,&rplen,&rp);# 		} while(!(rp.cseq == nakp.cseq &&  			  rp.chandle == ch && 			  (rp.nfrag == rpcnt1 ||  			   /* "escape" from NAK */ * 			   (rp.nfrag == 0 && rp.ndata == 0)) &&) 			  rp.op == (rqop | NDFP_OP_M_REPLY) && * 			  (rp.ndata + NDFP_HDRSIZE) <= rplen && 			  rp.ifrag <= rp.nfrag)); 	} while(1);			 #undef rp 
 #undef rpcnt1 
 #undef rpmask  }   / /* V1 style, implicitly uses rqa[0] & rpa[0] */  static void send_rq(SCTX *sx,  		    uint16 sh, 		    uint16 ch) { 	uint16 rplen; 	NDFP_PKTDSC rqdsc;  #define rq rqa[0]  #define rp rpa[0]    	ndeth_begin(&(sx->ectx));  B 	/* "rq." fields filled in by caller: op,ndata,argw,argl[,data] */   	rq.cseq = sx->ectx.s_cseq;  	rq.ifrag = rq.nfrag = 0;  	rq.chandle = ch;  	rq.shandle = sh;   : 	rqdsc.len = MAX(NDFP_HDRSIZE + rq.ndata,NDFP_PKT_MINLEN); 	rqdsc.pp = &rq;   	do { ' 		ndeth_request(0,1,&rqdsc,&rplen,&rp); ( 	} while(!(rp.cseq == sx->ectx.s_cseq && 		  rp.nfrag == 0 && 		  rp.ifrag == 0 && 		  rp.chandle == ch && ) 		  rp.op == (rq.op | NDFP_OP_M_REPLY) && ' 		  rp.ndata + NDFP_HDRSIZE <= rplen));   
 	ndeth_end(); 	 #undef rq 	 #undef rp  }    /*****/     typedef struct open_parameters { 	uint16 omode; 	uint16 cmode; 	uint32 ftime; 	uint16 fattr; 	uint16 lp; 4 	char path[2];		/* variable length, actually [lp] */ } OPAR; < #define OPAR_LEN1 (sizeof(OPAR) - 2)	/* length w/o path[] */   typedef struct client_context {  	int inuse; 9 	uint16 handle;		/* fixed: index returned to client(s) */ : 	uint16 chandle;		/* fixed during init, {client#|index} */ 	uint16 shandle; 	uint16 offset_byt;  	uint32 offset_blk; 
 	SCTX *sx;
 	OPAR *oparp;  } CCTX;   & #define CCTX_NUMBER 4		/* max = 255 */ static CCTX cctxa[CCTX_NUMBER];     ! static void init_cctx(int hich) {  	int i;   # 	for(i = 0; i < CCTX_NUMBER; i++) {  		cctxa[i].inuse = 0;  		cctxa[i].handle = i + 1;) 		cctxa[i].chandle = i + 1 + (hich << 8); ( 		cctxa[i].sx = NULL;		/* safety only */ 		cctxa[i].oparp = NULL; 	} }   ? static CCTX *find_cctx(uint16 h) {		/* supposedly re-entrant */   	if(h > 0 && h <= CCTX_NUMBER && 	   cctxa[h - 1].inuse) {  		return &cctxa[h - 1];  	}
 	return NULL;  }   & static CCTX *alloc_cctx(SCTX *sctxp) { 	int i;   # 	for(i = 0; i < CCTX_NUMBER; i++) {  		if(!cctxa[i].inuse) {  			cctxa[i].inuse = 1; 			cctxa[i].sx = sctxp;  			cctxa[i].shandle = 0; 			cctxa[i].offset_byt = 0;  			cctxa[i].offset_blk = 0;  			cctxa[i].oparp = NULL;    			return &cctxa[i]; 		}  	}
 	return NULL;  }     static void free_cctx(CCTX *x) { 	if(x->oparp) {  		free(x->oparp);  		x->oparp = NULL; 	}" 	x->sx = NULL;		/* safety only? */ 	x->inuse = 0; }      /*****/   " static void nd_int_reset(SCTX *sx, 			 uint16 chandle) {  	int i;    #define rq rqa[0]  #define rp rpa[0]    	clear_rq(&rq);  	rq.op = NDFP_OP_RESET;  	rq.ndata = 0;  , 	if(!sx) {			/* exit: close known handles */$ 		for(i = 0; i < CCTX_NUMBER; i++) { 			if(cctxa[i].inuse) { , 				send_rq(cctxa[i].sx,0,cctxa[i].chandle); 				free_cctx(&cctxa[i]);  			} 		} 	 		return;   ? 	} else if(chandle != 0) {	/* specific reset (after closing) */  		send_rq(sx,0,chandle);	 		return;  	}   	/* init (with server *sx): - 	 *	- reset all handles we possibly could use  	 *	- get version  	 */  # 	for(i = 0; i < CCTX_NUMBER; i++) { ! 		send_rq(sx,0,cctxa[i].chandle);  	}  " 	sx->s_version = rp.rp_reset_vers;  % 	if(sx->s_version >= NDFP_VERSION5) { / 		sx->s_window = sx->s_version - NDFP_VERSION5; " 		sx->s_data_max = NDFP_DATA_MAX5;, 	} else if(sx->s_version >= NDFP_VERSION4) {/ 		sx->s_window = sx->s_version - NDFP_VERSION4; " 		sx->s_data_max = NDFP_DATA_MAX4;, 	} else if(sx->s_version >= NDFP_VERSION3) {/ 		sx->s_window = sx->s_version - NDFP_VERSION3; " 		sx->s_data_max = NDFP_DATA_MAX3;, 	} else if(sx->s_version >= NDFP_VERSION2) {/ 		sx->s_window = sx->s_version - NDFP_VERSION2; " 		sx->s_data_max = NDFP_DATA_MAX2;	 	} else {  		sx->s_window = 0; " 		sx->s_data_max = NDFP_DATA_MAX1; 	}  8 	if(sx->s_window > NDFP_MAX_FRAG) {	/* must not occur */ 		sx->s_window = 0;  	}  B 	/* this must be a multiple of 512, due to DISK I/O limitations */G 	sx->s_maxcount = ((MAX(1,sx->s_window) * sx->s_data_max) / 512) * 512; 	 #undef rq 	 #undef rp  }     7 static void nd_int_reset_0(void) {	/* "exit handler" */  	nd_int_reset(NULL,0); }    /*****/   = /* try to re-open connection using saved open() parameters */ H /* NOTE: rpa[0].rp_sts preserved, rest of rqa[0] and rpa[0] destroyed */. static int/*logical*/ nd_int_reopen(CCTX *x) {* 	uint16 reopsts, savests = rpa[0].rp_sts;	   	if(x->oparp == NULL) return 0;    #define rq rqa[0]  #define rp rpa[0]    	/* transaction */ 	clear_rq(&rq);  	rq.op = NDFP_OP_OPEN; 	rq.ndata = x->oparp->lp; B 	if(x->oparp->lp > 0) memcpy(rq.data,x->oparp->path,x->oparp->lp);  $ 	rq.rq_open_mode = x->oparp->omode;	/ 	/* setting these fields won't hurt with V4+ */ $ 	rq.rq_open_fattr = x->oparp->fattr;$ 	rq.rq_open_ftime = x->oparp->ftime;  & 	/* careful - don't ever re-create! */A 	if((rq.rq_open_mode & (NDOM_READ | NDOM_WRITE)) == NDOM_WRITE) { - 		/* convert open/write to open/read/write */  		rq.rq_open_mode |= NDOM_READ; = 		/* NOTE: write-only _devices_ may need special treatment */  	}   	send_rq(x->sx,0,x->chandle);  	reopsts = rp.rp_sts;    	if(reopsts & 1) { 		x->shandle = rp.shandle; 	}	 #undef rq 	 #undef rp    	rpa[0].rp_sts = savests;  	if(reopsts & 1) return 1;   	fprintf(stderr,> 		"?nd_int_reopen(\"%.*s\",%%x%04X) failed, status %%x%04X\n",7 		x->oparp->lp,x->oparp->path,x->oparp->omode,reopsts); 
 	return 0; }   " #define reopen(X) nd_int_reopen(X)     /***** 	public entry points */   int nd_init(void) {   3 	if(active) return SS$_TOOMUCHCTX; else active = 1;    	if(!initialized) {  		int i,b0,b1,b2,b3,b4,b5;
 		char *p; 		int/*logical*/ la_set;= 		/* if nothing else, default LANADDR to home PC's address */ 3 		LANADDR def_la = {0x00,0x20,0x18,0x70,0x73,0x94};      		/* LANADDR set by caller? */
 		la_set = 0; ( 		for(i = 0; i < sizeof(LANADDR); i++) {! 			if(nd_lan_address.b[i] != 0) {  				la_set = 1; 
 				break; 			} 		} ) 		if(la_set) goto la_ok;		/* br if yes */   # 		/* NDFP_SERVER logname/symbol? */ + 		if((p = getenv("NDFP_SERVER")) != NULL && " 		   sscanf(p,"%x-%x-%x-%x-%x-%x",' 			    &b0,&b1,&b2,&b3,&b4,&b5) == 6 && 4 		   (b0 & 1) == 0 &&		/* not a broadcast address */ 		   b0 >= 0 && b0 <= 255 && 		   b1 >= 0 && b1 <= 255 && 		   b2 >= 0 && b2 <= 255 && 		   b3 >= 0 && b3 <= 255 && 		   b4 >= 0 && b4 <= 255 && 		   b5 >= 0 && b5 <= 255) { 			nd_lan_address.b[0] = b0; 			nd_lan_address.b[1] = b1; 			nd_lan_address.b[2] = b2; 			nd_lan_address.b[3] = b3; 			nd_lan_address.b[4] = b4; 			nd_lan_address.b[5] = b5; 			goto la_ok; 		}   3 		/* default LANADDR (for historical reasons :-) */  		nd_lan_address = def_la; la_ok:   		ndeth_init_client(&clno);  		init_cctx(clno);   		/*prelim*/+ 		sctxa[0].ectx.s_lanaddr = nd_lan_address; $ 		ndeth_init_server(&sctxa[0].ectx);  3 		/* establish exit handler, controlled by ndeth */  		ndeth_atexit(nd_int_reset_0);    		initialized = 1; 	}   	/* "wildcard" RESET */  	nd_int_reset(&sctxa[0],0);    	active = 0; return NDSS_OK; }     , /* initializer for an ND_ATTRIB structure */* const ND_ATTRIB *ndfp_cc_nd_attrib(void) {6 	static const ND_ATTRIB proto = { ND_ATTRIB_VERSION };* 			/* all zero except for version field */   	return &proto;  }      /* traditional nd_open() */ & int nd_open1(		/* = fake SS$ status */ 	const char *path,	/* asciz */% 	uint16 mode,		/* bitmask (NDOM_*) */ @ 	uint16 fattr,		/* only with NDOM_FATTR: DOS bitmask (NDAM_*) */? 	uint32 ftime,		/* only with NDOM_FTIME: DOS packed datetime */ ; 	uint16 *p_handle,	/* to be used for subsequent accesses */ $ 	uint16 *p_fattr,	/* (maybe NULL) */$ 	uint32 *p_ftime,	/* (maybe NULL) */$ 	uint32 *p_fsize		/* (maybe NULL) */ ) { 	 	CCTX *x;  	unsigned int lp;  	int/*logical*/ pre_v4, pre_v5;  #define rq rqa[0]  #define rp rpa[0]    	if(!initialized) abort();   	/* assume failure */  	*p_handle = 0;    	/* check input parameters */ A 	lp = strlen(path); if(lp > NDFP_DATA_MAX) return NDSS_IVDATALEN;   ? 	if(mode & ~(NDOM_READ | NDOM_WRITE | NDOM_FATTR | NDOM_FTIME | ( 		    NDOM_DISK | NDOM_DRV | NDOM_DIR))  		return NDSS_IVMODE;    	if((mode & NDOM_FATTR) &&H 	   (fattr & ~(NDAM_RONLY | NDAM_HIDDEN | NDAM_SYSFILE | NDAM_ARCHIVE))) 		return NDSS_IVPARAM;  3 	if(active) return SS$_TOOMUCHCTX; else active = 1;    	/* create cctx */* 	if((x = alloc_cctx(&sctxa[0])) == NULL) {! 		active = 0; return NDSS_NOROOM;  	}  - 	pre_v4 = (x->sx->s_version < NDFP_VERSION4); - 	pre_v5 = (x->sx->s_version < NDFP_VERSION5);    	/* transaction */ 	clear_rq(&rq);  	rq.op = NDFP_OP_OPEN; 	rq.ndata = lp; $ 	if(lp > 0) memcpy(rq.data,path,lp);
 	if(pre_v4) {  		rq.rq_open_mode = mode;		 	} else { 7 		rq.rq_open_mode = mode & ~(NDOM_FATTR | NDOM_FTIME);	  	}. 	/* setting these fields won't hurt with V4 */ 	rq.rq_open_fattr = fattr; 	rq.rq_open_ftime = ftime;   	send_rq(x->sx,0,x->chandle);    	if(!(rp.rp_sts & 1)) {  		free_cctx(x); 	 	} else {  		x->shandle = rp.shandle;  " 		/* preserve open() parameters */$ 		x->oparp = malloc(OPAR_LEN1 + lp); 		if(x->oparp == NULL) { 			perror("malloc(opar)"); 			abort();  		}  		x->oparp->cmode = 0;	  		if(pre_v4) { 			x->oparp->omode = mode;	 
 		} else {8 			x->oparp->omode = mode & ~(NDOM_FATTR | NDOM_FTIME);	7 			if(mode & NDOM_FATTR) x->oparp->cmode |= NDCM_FATTR; 7 			if(mode & NDOM_FTIME) x->oparp->cmode |= NDCM_FTIME;  		}  		x->oparp->fattr = fattr; 		x->oparp->ftime = ftime; 		x->oparp->lp = lp;, 		if(lp > 0) memcpy(x->oparp->path,path,lp);   		*p_handle = x->handle; 	}  ) 	if(p_fattr) *p_fattr = rp.rp_open_fattr; ) 	if(p_ftime) *p_ftime = rp.rp_open_ftime; 8 		/* with NDOM_DISK, this actually is rp_opendsk_geom */ 	if(p_fsize) { 		if(pre_v5) { 			*p_fsize = rp.rp_open_fsize; 
 		} else {) 			*p_fsize = rp.rp_open_fsizeblk * 512 +  				   rp.rp_open_fsizebyt;  		}  	} 	active = 0; return rp.rp_sts;	 #undef rq 	 #undef rp  }      /* improved nd_open() */' int nd_open2(			/* = fake SS$ status */  	const char *path,	/* asciz */% 	uint16 mode,		/* bitmask (NDOM_*) */ ; 	uint16 *p_handle,	/* to be used for subsequent accesses */ = 	ND_ATTRIB *p_nab	/* optional: attributes & truename [out] */  ) { 	 	CCTX *x;  	unsigned int lp;  	int/*logical*/ pre_v5;  #define rq rqa[0]  #define rp rpa[0]    	if(!initialized) abort();   	/* assume failure */  	*p_handle = 0;    	/* check input parameters */ A 	lp = strlen(path); if(lp > NDFP_DATA_MAX) return NDSS_IVDATALEN;   H 	if(mode & ~(NDOM_READ | NDOM_WRITE | NDOM_DISK | NDOM_DRV | NDOM_DIR))  		return NDSS_IVMODE;   < 	if(p_nab) {	/* ignore NAB if version isn't set correctly */7 		if(p_nab->version != ND_ATTRIB_VERSION) p_nab = NULL;  	}  3 	if(active) return SS$_TOOMUCHCTX; else active = 1;*   	/* create cctx */* 	if((x = alloc_cctx(&sctxa[0])) == NULL) {! 		active = 0; return NDSS_NOROOM;  	}  - 	pre_v5 = (x->sx->s_version < NDFP_VERSION5);a   	/* transaction */ 	clear_rq(&rq);  	rq.op = NDFP_OP_OPEN; 	rq.ndata = lp;m$ 	if(lp > 0) memcpy(rq.data,path,lp);B 	rq.rq_open_mode = mode;		/* pre-V4 fattr & ftime not supported */   	send_rq(x->sx,0,x->chandle);o   	if(!(rp.rp_sts & 1)) {m 		free_cctx(x);r	 	} else {v 		x->shandle = rp.shandle;  " 		/* preserve open() parameters */$ 		x->oparp = malloc(OPAR_LEN1 + lp); 		if(x->oparp == NULL) { 			perror("malloc(opar)"); 			abort();m 		}e 		x->oparp->omode = mode;	& 		x->oparp->cmode = 0;		/* obsolete */& 		x->oparp->fattr = 0;		/* obsolete */& 		x->oparp->ftime = 0;		/* obsolete */ 		x->oparp->lp = lp;, 		if(lp > 0) memcpy(x->oparp->path,path,lp);   		*p_handle = x->handle; 	}   	if(p_nab) {" 		p_nab->fattr = rp.rp_open_fattr;% 		p_nab->packed.l = rp.rp_open_ftime; ! 					/* a.k.a. rp_opendsk_geom */u 		if(pre_v5) {- 			p_nab->fsize_low = rp.rp_open_fsize % 512; , 			p_nab->size_blk = rp.rp_open_fsize / 512;
 		} else {* 			p_nab->fsize_low = rp.rp_open_fsizebyt;) 			p_nab->size_blk = rp.rp_open_fsizeblk;d 		}t3 		if(rp.ndata >= sizeof(p_nab->path)) {		/* bug? */m 			p_nab->path[0] = '\0';u
 		} else {9 			if(rp.ndata > 0) memcpy(p_nab->path,rp.data,rp.ndata);o  			p_nab->path[rp.ndata] = '\0'; 		}e 	}   	active = 0; return rp.rp_sts;	 #undef rqe	 #undef rpi }u    % int nd_read(		/* = fake SS$ status */i 	uint16 handle,s! 	uint32 count,		/* buffer size */x 	uchar *buf,		/* data buffer */r* 	uint16 *p_count		/* #bytes transferred */ ) { 	 	CCTX *x; 
 	uint16 boff;c" 	unsigned int i,rpcnt, reopct = 0; 	int/*logical*/ pre_v5;c     	if(!initialized) abort();   	*p_count = 0;3 	if(!(x = find_cctx(handle))) return NDSS_IVHANDLE;.  3 	if(active) return SS$_TOOMUCHCTX; else active = 1;o  - 	pre_v5 = (x->sx->s_version < NDFP_VERSION5);A  	 reopened:a  " 	if(x->sx->s_window == 0) goto v1;  	 	/* V2 */)   #define rq rqa[0]i9 #define rp rpa[0]	/* first response must have all info */0  3 	count = MIN(x->sx->s_maxcount,count);		/* limit */A   	clear_rq(&rq);  	rq.op = NDFP_OP_READ; 	rq.rq_read_count = count;	(
 	if(pre_v5) {A: 		rq.rq_read_offset = x->offset_blk * 512 + x->offset_byt;	 	} else { ' 		rq.rq_read_offsetblk = x->offset_blk;N' 		rq.rq_read_offsetbyt = x->offset_byt;c 	}  1 	rpcnt = send_rq2(x->sx,x->shandle,x->chandle,1);1B 	if(rpcnt == 1) goto v1_reply;	/* single buffer is in V1 format */  & 	if(rp.rp_read_count == 0) goto v2bug;) 	if(rp.rp_read_count > count) goto v2bug;s  
 	boff = 0; 	for(i = 0; i < rpcnt; i++) {o$ 		if(!(rpa[i].rp_sts == rp.rp_sts &&2 		     rpa[i].rp_read_count == rp.rp_read_count &&% 		     rpa[i].rp_read_boff == boff &&o- 		     rpa[i].ndata == MIN(x->sx->s_data_max,c, 					 rp.rp_read_count - boff))) goto v2bug; 		assert(rpa[i].ndata > 0);p@ 		if(rp.rp_sts & 1) memcpy(buf + boff,rpa[i].data,rpa[i].ndata); 		boff += rpa[i].ndata;	 	}) 	if(boff != rp.rp_read_count) goto v2bug;N  C 	if((rp.rp_sts & 1) || !(rp.rp_sts & 4)) {	/* unless fatal error */-$ 		x->offset_byt += rp.rp_read_count;' 		x->offset_blk += x->offset_byt / 512;  		x->offset_byt %= 512;e   		*p_count = rp.rp_read_count; 	} 	active = 0; return rp.rp_sts;  	 #undef rqx	 #undef rpe   v2bug:? 	fprintf(stderr,"nd_read(): V2 response error, retrying V1\n");D v1:_   #define rq rqa[0]P #define rp rpa[0]	  0 	count = MIN(NDFP_DATA_MAX1,count);		/* limit */   	clear_rq(&rq);	 	rq.op = NDFP_OP_READ; 	rq.ndata = 0; 	rq.rq_read_count = count;	!
 	if(pre_v5) {.: 		rq.rq_read_offset = x->offset_blk * 512 + x->offset_byt;	 	} else {g' 		rq.rq_read_offsetblk = x->offset_blk; ' 		rq.rq_read_offsetbyt = x->offset_byt;d 	}  & 	send_rq(x->sx,x->shandle,x->chandle);	 v1_reply:rH 	if(rp.rp_sts == NDSS_IVHANDLE && !reopct++ && reopen(x)) goto reopened;  C 	if((rp.rp_sts & 1) || !(rp.rp_sts & 4)) {	/* unless fatal error */t 		if(rp.ndata > count) {# 			active = 0; return NDSS_IVPROTO;  		}  		if(rp.ndata > 0) {  			memcpy(buf,rp.data,rp.ndata);   			x->offset_byt += rp.ndata;s( 			x->offset_blk += x->offset_byt / 512; 			x->offset_byt %= 512; 		}  		*p_count = rp.ndata; 	} 	active = 0; return rp.rp_sts;	 #undef rq 	 #undef rpp }*    & int nd_write(		/* = fake SS$ status */ 	uint16 handle,p* 	uint32 count,		/* #bytes to be written */$ 	const uchar *buf,	/* data buffer */* 	uint16 *p_count		/* #bytes transferred */ ) {c	 	CCTX *x;n
 	uint16 boff;] 	unsigned int rpcnt,npk; 	int i, reopct = 0;u 	int/*logical*/ pre_v5;n     	if(!initialized) abort();   	*p_count = 0;3 	if(!(x = find_cctx(handle))) return NDSS_IVHANDLE;n  3 	if(active) return SS$_TOOMUCHCTX; else active = 1;n  - 	pre_v5 = (x->sx->s_version < NDFP_VERSION5);g  	 reopened:a  " 	if(x->sx->s_window == 0) goto v1;  	 	/* V2 */g   #define rp rpa[0]	  2 	count = MIN(x->sx->s_maxcount,count);	/* limit */   	/* store in reverse order */r 	npk = (count == 0) ?)= 		1 : ((count + x->sx->s_data_max - 1) / x->sx->s_data_max); s  
 	boff = 0;  	for(i = npk - 1; i >= 0; i--) { 		clear_rq(&rqa[i]); 		rqa[i].op = NDFP_OP_WRITE;  		rqa[i].rq_write_count = count; 		if(pre_v5) {1 			rqa[i].rq_write_offset = x->offset_blk * 512 +m 						 x->offset_byt + boff;	;
 		} else {- 			rqa[i].rq_write_offsetblk = x->offset_blk;t4 			rqa[i].rq_write_offsetbyt = x->offset_byt + boff; 		}e 		rqa[i].rq_write_boff = boff;	h5 		rqa[i].ndata = MIN(x->sx->s_data_max,count - boff);&5 		if(rqa[i].ndata > 0) memcpy(rqa[i].data,buf + boff,N 					    rqa[i].ndata);= 		boff += rqa[i].ndata;  	} 	assert(boff == count);_  3 	rpcnt = send_rq2(x->sx,x->shandle,x->chandle,npk);& 	if(rpcnt > 1) goto v2bug;* 	if(rp.rp_write_count > count) goto v2bug;  H 	if(rp.rp_sts == NDSS_IVHANDLE && !reopct++ && reopen(x)) goto reopened;  C 	if((rp.rp_sts & 1) || !(rp.rp_sts & 4)) {	/* unless fatal error */u% 		x->offset_byt += rp.rp_write_count;f' 		x->offset_blk += x->offset_byt / 512;e 		x->offset_byt %= 512;    		*p_count = rp.rp_write_count;r 	} 	active = 0; return rp.rp_sts;  	 #undef rpe   v2bug:@ 	fprintf(stderr,"nd_write(): V2 response error, retrying V1\n"); v1:    #define rq rqa[0]F #define rp rpa[0]a  / 	count = MIN(NDFP_DATA_MAX1,count);	/* limit */d   	clear_rq(&rq);d 	rq.op = NDFP_OP_WRITE;e& 	rq.rq_write_count = rq.ndata = count; 	rq.rq_write_boff = 0;
 	if(pre_v5) {	< 		rq.rq_write_offset = x->offset_blk * 512 + x->offset_byt;		 	} else {p( 		rq.rq_write_offsetblk = x->offset_blk;( 		rq.rq_write_offsetbyt = x->offset_byt; 	}) 	if(count > 0) memcpy(rq.data,buf,count);u  & 	send_rq(x->sx,x->shandle,x->chandle);  H 	if(rp.rp_sts == NDSS_IVHANDLE && !reopct++ && reopen(x)) goto reopened;  C 	if((rp.rp_sts & 1) || !(rp.rp_sts & 4)) {	/* unless fatal error */o! 		if(rp.rp_write_count > count) {_# 			active = 0; return NDSS_IVPROTO;d 		}/  % 		x->offset_byt += rp.rp_write_count; ' 		x->offset_blk += x->offset_byt / 512;c 		x->offset_byt %= 512;    		*p_count = rp.rp_write_count;n 	} 	active = 0; return rp.rp_sts;	 #undef rq 	 #undef rpd }n     /* traditional 31-bit format */t8 int nd_seek(			/* = fake SS$ status; no I/O done here */ 	uint16 handle,i, 	uint32 offset		/* value not checked here */ ) {[	 	CCTX *x;0   	if(!initialized) abort();  3 	if(!(x = find_cctx(handle))) return NDSS_IVHANDLE;]  3 	if(active) return SS$_TOOMUCHCTX; else active = 1;;   	x->offset_blk = offset / 512; 	x->offset_byt = offset % 512;   	active = 0; return NDSS_OK; }N   /* 40-bit format */ 8 int nd_seek2(		/* = fake SS$ status; no I/O done here */ 	uint16 handle,T/ 	uint32 offset_block,	/* "block" (512 bytes) */=< 	uint16 offset_bytes	/* byte offset within block (0..511) */ ) {.	 	CCTX *x;    	if(!initialized) abort();  3 	if(!(x = find_cctx(handle))) return NDSS_IVHANDLE;c   	/* check input parameters */a- 	if(offset_bytes >= 512) return NDSS_IVPARAM;   3 	if(active) return SS$_TOOMUCHCTX; else active = 1;*   	x->offset_blk = offset_block; 	x->offset_byt = offset_bytes;   	active = 0; return NDSS_OK; }/    ' int nd_trunc(			/* = fake SS$ status */v 	uint16 handle ) { 	 	CCTX *x;i 	int reopct = 0; 	int/*logical*/ pre_v5;a   	if(!initialized) abort();3 	if(!(x = find_cctx(handle))) return NDSS_IVHANDLE; 3 	if(active) return SS$_TOOMUCHCTX; else active = 1;	  - 	pre_v5 = (x->sx->s_version < NDFP_VERSION5);]  	 reopened:	 #define rq rqa[0]s #define rp rpa[0]e   	clear_rq(&rq);c 	rq.op = NDFP_OP_TRUNC;	 	rq.ndata = 0;
 	if(pre_v5) {!; 		rq.rq_trunc_offset = x->offset_blk * 512 + x->offset_byt;c	 	} else {	( 		rq.rq_trunc_offsetblk = x->offset_blk;( 		rq.rq_trunc_offsetbyt = x->offset_byt; 	}  & 	send_rq(x->sx,x->shandle,x->chandle);  H 	if(rp.rp_sts == NDSS_IVHANDLE && !reopct++ && reopen(x)) goto reopened;   	active = 0; return rp.rp_sts;	 #undef rqe	 #undef rpF }E     /* V5 extended functionality */r( int nd_close2(			/* = fake SS$ status */ 	uint16 handle, & 	uint16 mode,		/* bit mask (NDCM_*) */B 	ND_ATTRIB *p_nab	/* optional: path[in/out],fattr[in],ftime[in] */ ) {=	 	CCTX *x;M 	int result, reopct = 0; 	unsigned int lp;N   	if(!initialized) abort();  3 	if(!(x = find_cctx(handle))) return NDSS_IVHANDLE;M  < 	if(p_nab) {	/* ignore NAB if version isn't set correctly */7 		if(p_nab->version != ND_ATTRIB_VERSION) p_nab = NULL;N 	}   	/* check input parameters */iC 	if(mode & ~(NDCM_DELETE | NDCM_RENAME | NDCM_FATTR | NDCM_FTIME)) w 		return NDSS_IVMODE;m  ? 	if((mode & (NDCM_RENAME | NDCM_FATTR | NDCM_FTIME)) && !p_nab)l 		return NDSS_IVPARAM;   	if((mode & NDCM_FATTR) && 	   (p_nab->fattr &>@ 	    ~(NDAM_RONLY | NDAM_HIDDEN | NDAM_SYSFILE | NDAM_ARCHIVE))) 		return NDSS_IVPARAM;   	if(mode & NDCM_RENAME) {  		lp = strlen(p_nab->path);U/ 		if(lp > NDFP_DATA_MAX) return NDSS_IVDATALEN;c	 	} else {s	 		lp = 0;  	}  3 	if(active) return SS$_TOOMUCHCTX; else active = 1;q  	 reopened:0 #define rq rqa[0]t #define rp rpa[0]d   	clear_rq(&rq);) 	rq.op = NDFP_OP_CLOSE;s 	rq.ndata = lp;s+ 	if(lp > 0) memcpy(rq.data,p_nab->path,lp);f  , 	rq.rq_close_mode = x->oparp->cmode | mode;	  @ 	/* close() parameters supersede [obsolete] open() parameters */ 	if(mode & NDCM_FATTR) {# 		rq.rq_close_fattr = p_nab->fattr;,* 	} else if(x->oparp->cmode & NDCM_FATTR) {& 		rq.rq_close_fattr = x->oparp->fattr; 	} 	if(mode & NDCM_FTIME) {& 		rq.rq_close_ftime = p_nab->packed.l;* 	} else if(x->oparp->cmode & NDCM_FTIME) {& 		rq.rq_close_ftime = x->oparp->ftime; 	}  & 	send_rq(x->sx,x->shandle,x->chandle);  H 	if(rp.rp_sts == NDSS_IVHANDLE && !reopct++ && reopen(x)) goto reopened; 	result = rp.rp_sts;  ; 	if(mode & NDCM_RENAME) {	/* implies that NAB is present */s4 		/* replace nab.path only if "truename" is valid */6 		if(rp.ndata > 0 && rp.ndata < sizeof(p_nab->path)) {( 			memcpy(p_nab->path,rp.data,rp.ndata);  			p_nab->path[rp.ndata] = '\0'; 		}  	}  	 #undef rq 	 #undef rpr   	/* always RESET */   	nd_int_reset(x->sx,x->chandle);   	free_cctx(x);   	active = 0; return result;  }r    > /* traditional nd_close() entry, emulated for compatibility */( int nd_close1(			/* = fake SS$ status */ 	uint16 handle,e% 	uint16 mode		/* bit mask (NDCM_*) */  ) {(. 	if(mode & ~(NDCM_DELETE)) return NDSS_IVMODE;  ; 	return nd_close2(handle,mode,NULL);	/* NAB not required */l }A     /* time synchronization */& int nd_time(			/* = fake SS$ status */& 	uint16 mode,		/* bit mask (NDTM_*) */> 	uint32 q_in[2],		/* 64 bit input (required with mode != 0) */< 	uint32 q_out[2]		/* 64 bit output (10^-7 sec since 1980) */ ) {; 	if(!initialized) abort();   	/* check input parameters */	6 	if(mode & ~(NDTM_ADD | NDTM_SET)) return NDSS_IVMODE;  A 	if((mode & (NDTM_ADD | NDTM_SET)) && !q_in) return NDSS_IVPARAM;&  3 	if(active) return SS$_TOOMUCHCTX; else active = 1;	   #define rq rqa[0]d #define rp rpa[0]=   	clear_rq(&rq);  	rq.op = NDFP_OP_TIME; 	rq.rq_time_mode = mode;' 	rq.ndata = 0;		/* could be variable */	   	if(q_in) {4 		rq.rq_time_q_lo = q_in[0]; 		rq.rq_time_q_hi = q_in[1]; 	}   	/* NO context required */ 	send_rq(&sctxa[0],0,0);   	if(q_out) { 		q_out[0] = rp.rp_time_q_lo;_ 		q_out[1] = rp.rp_time_q_hi;a 	}   	active = 0; return rp.rp_sts;	 #undef rq*	 #undef rpN }R