#if 0

/**************************/
/* Function FlushOutput() */
/**************************/

int FlushOutput()
{
    /*
     * flush contents of output buffer; return PK-type error code
     */
#if (!defined(DOS_NT_OS2)) || defined(MSWIN)
    static int saved_ctrlZ = FALSE;
#endif
    int len;


    if (disk_full) {
        outcnt = 0;
        outptr = outbuf;
        return 50;          /* ignore rest of this file */
    }

    if (newfile) {
#if (!defined(DOS_NT_OS2)) || defined(MSWIN)
        saved_ctrlZ = FALSE;
#endif
        newfile = FALSE;
    }

    if (outcnt) {
#if (!defined(DOS_NT_OS2)) || defined(MSWIN)
        if (saved_ctrlZ) {
            UpdateCRC(outbuf+1, outcnt-1);   /* don't calc ^Z CRC twice */
            saved_ctrlZ = FALSE;
        } else
#endif
        UpdateCRC(outbuf, outcnt);

        if (!tflag) {
#if (!defined(DOS_NT_OS2)) || defined(MSWIN)
            if (aflag) {
                if (outbuf[outcnt-1] == CTRLZ) {
                    --outcnt;
                    saved_ctrlZ = TRUE;
                }
                len = dos2unix(outbuf, outcnt);
            } else
#endif /* !DOS_NT_OS2 || MSWIN */
                len = outcnt;
#ifdef MACOS
            if ((giCursor+1) >> 2 != (giCursor>>2))
                SetCursor( *rghCursor[((giCursor+1)>>2)&0x03] );
            giCursor = (giCursor+1) & 15;
#endif /* MACOS */
#ifdef MSWIN
            /* if writing to console vs. actual file, write to Msg Window */
            if (cflag)
                WriteBufferToMsgWin(outout, len, FALSE);
            else if (_lwrite(outfd, outout, len) != (UINT)len)
#else /* !MSWIN */
            if (write(outfd, (char *)outout, len) != len)
#endif /* ?MSWIN */
#ifdef DOS_NT_OS2
                if (!cflag)           /* ^Z treated as EOF, removed with -c */
#else /* !DOS_NT_OS2 */
#ifdef MINIX
                if (errno == EFBIG)
                    if (write(outfd, outout, len/2) != len/2  ||
                        write(outfd, outout+len/2, len/2) != len/2)
#endif /* MINIX */
#endif /* ?DOS_NT_OS2 */
                {
                    /* GRR: add test for force_flag when has its own switch */
                    fprintf(stderr,
                      "\n%s:  write error (disk full?).  Continue? (y/n/^C) ",
                      filename);
                    FFLUSH(stderr);
#ifndef MSWIN
                    fgets(answerbuf, 9, stdin);
                    if (*answerbuf == 'y')   /* stop writing to this file */
                        disk_full = 1;       /*  (outfd bad?), but new OK */
                    else
#endif /* ?MSWIN */
                        disk_full = 2;       /* no:  exit program */
                    return 50;    /* 50:  disk full */
                }
        } /* end if (!tflag) */
        outcnt = 0;
        outptr = outbuf;
#if (!defined(DOS_NT_OS2)) || defined(MSWIN)
        if (saved_ctrlZ) {
            ++outcnt;
            *outptr++ = CTRLZ;
        }
#endif /* !DOS_NT_OS2 || MSWIN */
    }
    return 0;                   /* 0:  no error */
}

#endif /* 0 */





#if 0
#if (!defined(DOS_NT_OS2) || defined(MSWIN))

/***********************/
/* Function dos2unix() */
/***********************/

static int dos2unix(buf, len)   /* GRR:  rewrite for generic text conversions */
    unsigned char *buf;
    int len;
{
    int new_len;
    int i;
#ifdef MSWIN
    unsigned char __far *walker;
#else /* !MSWIN */
    unsigned char *walker;
#endif /* ?MSWIN */

    new_len = len;
    walker = outout;
#ifdef MACOS
    /*
     * Mac wants to strip LFs instead CRs from CRLF pairs
     */
    if (CR_flag && *buf == LF) {
        buf++;
        new_len--;
        len--;
        CR_flag = buf[len] == CR;
    }
    else
        CR_flag = buf[len - 1] == CR;
    for (i = 0; i < len; i += 1) {
        *walker++ = ascii_to_native(*buf);
        if (*buf == LF) walker[-1] = CR;
        if (*buf++ == CR && *buf == LF) {
            new_len--;
            buf++;
            i++;
        }
    }
#else /* !MACOS */
    if (CR_flag && *buf != LF)
        *walker++ = ascii_to_native(CR), new_len++;  /* fixed 93.02.23 */
    CR_flag = buf[len - 1] == CR;
    for (i = 0; i < len; i += 1) {
        *walker++ = ascii_to_native(*buf);
        if (*buf++ == CR && *buf == LF) {
            new_len--;
            walker[-1] = ascii_to_native(*buf++);
            i++;
        }
    }
    /*
     * If the last character is a CR, then "ignore it" for now...
     */
    if (walker[-1] == ascii_to_native(CR))
        new_len--;
#endif /* ?MACOS */
    return new_len;
}

#endif /* !DOS_NT_OS2 || MSWIN */
#endif /* 0 */




#if 0

/*********************************/
/* Function create_output_file() */
/*********************************/

int create_output_file()         /* return non-0 if creat failed */
{
#ifdef TOPS20
    char *tfilnam;
#endif

/*---------------------------------------------------------------------------
    Create the output file with appropriate permissions.  If we've gotten to
    this point and the file still exists, we have permission to blow it away.
  ---------------------------------------------------------------------------*/

#if (!defined(DOS_NT_OS2) || defined(MSWIN))
    CR_flag = 0;   /* hack to get CR at end of buffer working */
#endif

#ifdef UNIX
    {
        int mask;

        if (!stat(filename, &statbuf) && (unlink(filename) < 0)) {
            fprintf(stderr, "\n%s:  cannot delete old copy\n", filename);
            return 1;
        }
        mask = umask(0);                    /* now know that we own it */
#ifdef SYMLINKS
        if (symlnk)
            outfd = creat(filename, 0600);  /* make sure we can read it later */
        else
#endif /* SYMLINKS */
        outfd = creat(filename, 0xffff & pInfo->file_attr);          /* Unix */
        umask(mask);
    }
#else /* !UNIX */  /* file permissions set after file closed */
#ifdef TOPS20
    if ((tfilnam = (char *)malloc(2*strlen(filename)+1)) == NULL)
        return 1;
    strcpy(tfilnam, filename);
    upper(tfilnam);
    enquote(tfilnam);
    outfd = creat(tfilnam, S_IWRITE | S_IREAD);                   /* TOPS-20 */
#else /* !TOPS20 */
#ifndef MACOS
    outfd = creat(filename, S_IWRITE | S_IREAD);      /* MS-DOS, OS/2, Amiga */
#else /* MACOS */
    {
        short fDataFork=TRUE;
        MACINFO mi;
        OSErr err;

        fMacZipped = FALSE;
        CtoPstr(filename);
        if (extra_field &&
            (lrec.extra_field_length > sizeof(MACINFOMIN)) &&
            (lrec.extra_field_length <= sizeof(MACINFO))) {
            BlockMove(extra_field, &mi, lrec.extra_field_length);
            if ((makeword((uch *)&mi.header) == 1992) &&
                (makeword((uch *)&mi.data) ==
                  lrec.extra_field_length-sizeof(ZIP_EXTRA_HEADER)) &&
                (mi.signature == 'JLEE')) {
                gostCreator = mi.finfo.fdCreator;
                gostType = mi.finfo.fdType;
                fDataFork = (mi.flags & 1) ? TRUE : FALSE;
                fMacZipped = true;
                /* If it was Zipped w/Mac version, the filename has either */
                /* a 'd' or 'r' appended.  Remove the d/r when unzipping */
                filename[0]-=1;
            }
        }
        if (!fMacZipped) {
            if (!aflag)
                gostType = gostCreator = '\?\?\?\?';
            else {
                gostCreator = CREATOR;
                gostType = 'TEXT';
            }
        }
        PtoCstr(filename);

        outfd = creat(filename, 0);
        if (fMacZipped) {
            CtoPstr(filename);
            if (hfsflag) {
                HParamBlockRec   hpbr;
    
                hpbr.fileParam.ioNamePtr = (StringPtr)filename;
                hpbr.fileParam.ioVRefNum = gnVRefNum;
                hpbr.fileParam.ioDirID = glDirID;
                hpbr.fileParam.ioFlFndrInfo = mi.finfo;
                hpbr.fileParam.ioFlCrDat = mi.lCrDat;
                hpbr.fileParam.ioFlMdDat = mi.lMdDat;
                err = PBHSetFInfo(&hpbr, 0);
            } else {
                err = SetFInfo((StringPtr)filename , 0, &mi.finfo);
            }
            PtoCstr(filename);
        }
        if (outfd != -1)
            outfd = open(filename, (fDataFork)? 1 : 2);
    }
#endif /* ?MACOS */
#endif /* ?TOPS20 */
#endif /* ?UNIX */

    if (outfd < 1) {
        fprintf(stderr, "\n%s:  cannot create\n", filename);
#ifdef TOPS20
        free(tfilnam);
#endif
        return 1;
    }

/*---------------------------------------------------------------------------
    If newly created file is in text mode and should be binary (to disable
    automatic CR/LF translations), either close it and reopen as binary or
    else change the mode to binary (DOS, OS/2).
  ---------------------------------------------------------------------------*/

#if (!defined(UNIX) && !defined(MACOS) && !defined(ATARI_ST))
    if (!aflag) {
#ifdef DOS_NT_OS2
        if (setmode(outfd, O_BINARY) == -1) {
#else /* !DOS_NT_OS2 */
        close(outfd);
#ifndef TOPS20
        if ((outfd = open(filename, O_RDWR | O_BINARY)) < 1) {
#else /* TOPS20 */
        if ((outfd = open(tfilnam, O_RDWR | O_BSIZE_8)) < 1) {
            free(tfilnam);
#endif /* ?TOPS20 */
#endif /* ?DOS_NT_OS2 */
            fprintf(stderr, "Can't make output file binary:  %s\n", filename);
            return 1;
        }
    }
#endif /* !UNIX && !MACOS && !ATARI_ST */

#ifdef TOPS20
    free(tfilnam);
#endif
    return 0;
}

#endif /* 0 */





/***********************/
/* Function ReadByte() */
/***********************/

int ReadByte(x)
    ush *x;
{
    /*
     * read a byte; return 8 if byte available, 0 if not
     */

    if (mem_mode)
        return ReadMemoryByte(x);

    if (csize-- <= 0)
        return 0;

    if (incnt == 0) {
        if ((incnt = read(zipfd, (char *)inbuf, INBUFSIZ)) <= 0)
            return 0;
        /* buffer ALWAYS starts on a block boundary:  */
        cur_zipfile_bufstart += INBUFSIZ;
        inptr = inbuf;
#ifdef CRYPT
        if (pInfo->encrypted) {
            uch *p;
            int n;

            for (n = (long)incnt > csize + 1 ? (int)csize + 1 : incnt,
                 p = inptr; n--; p++)
                zdecode(*p);
        }
#endif /* CRYPT */
    }
    *x = *inptr++;
    --incnt;
    return 8;
}






/****************************/
/* Function FillBitBuffer() */
/****************************/

int FillBitBuffer()
{
    /*
     * Fill bitbuf, which is 8*sizeof(ulg) bits.  This function is only used
     * by the READBITS macro, which is used by unreduce.c and unshrink.c.
     */
    int temp;

    zipeof = 1;
    while (bits_left <= 8*(sizeof(bitbuf)-1) && (temp = NEXTBYTE) != EOF) {
        bitbuf |= (ulg)temp << bits_left;
        bits_left += 8;
        zipeof = 0;
    }
    return 0;
}





/************************/
/* Function UpdateCRC() */
/************************/

 /*--------------------------------------------------------------------

   First, the polynomial itself and its table of feedback terms.  The
   polynomial is
   X^32+X^26+X^23+X^22+X^16+X^12+X^11+X^10+X^8+X^7+X^5+X^4+X^2+X^1+X^0

   Note that we take it "backwards" and put the highest-order term in
   the lowest-order bit.  The X^32 term is "implied"; the LSB is the
   X^31 term, etc.  The X^0 term (usually shown as "+1") results in
   the MSB being 1.

   Note that the usual hardware shift register implementation, which
   is what we're using (we're merely optimizing it by doing eight-bit
   chunks at a time) shifts bits into the lowest-order term.  In our
   implementation, that means shifting towards the right.  Why do we
   do it this way?  Because the calculated CRC must be transmitted in
   order from highest-order term to lowest-order term.  UARTs transmit
   characters in order from LSB to MSB.  By storing the CRC this way,
   we hand it to the UART in the order low-byte to high-byte; the UART
   sends each low-bit to hight-bit; and the result is transmission bit
   by bit from highest- to lowest-order term without requiring any bit
   shuffling on our part.  Reception works similarly.

   The feedback terms table consists of 256, 32-bit entries.  Notes:

       The table can be generated at runtime if desired; code to do so
       is shown later.  It might not be obvious, but the feedback
       terms simply represent the results of eight shift/xor opera-
       tions for all combinations of data and CRC register values.

       The values must be right-shifted by eight bits by the "updcrc"
       logic; the shift must be unsigned (bring in zeroes).  On some
       hardware you could probably optimize the shift in assembler by
       using byte-swap instructions.
       polynomial $edb88320

   COPYRIGHT (C) 1986 Gary S. Brown.  You may use this program, or code
   or tables extracted from it, as desired without restriction.

   --------------------------------------------------------------------*/


void UpdateCRC(s, len)
    register uch *s;
    register int len;
{
    register ulg crcval = crc32val;

    /* update running CRC calculation with contents of a buffer */
    while (len--)
        crcval = crc_32_tab[((uch)crcval ^ (*s++)) & 0xff] ^ (crcval >> 8);
    crc32val = crcval;
}
