/*---------------------------------------------------------------------------
    MS-DOS specific configuration section:
  ---------------------------------------------------------------------------*/

#ifndef __doscfg_h
#define __doscfg_h

#include <dos.h>           /* for REGS macro (TC) or _dos_setftime (MSC) */

#ifdef __TURBOC__          /* includes Power C */
#  include <sys/timeb.h>   /* for structure ftime */
#  ifndef __BORLANDC__     /* there appears to be a bug (?) in Borland's */
#    include <mem.h>       /*  MEM.H related to __STDC__ and far poin-   */
#  endif                   /*  ters. (dpk)  [mem.h included for memcpy]  */
#endif

#ifdef WINDLL
#  if (defined(MSC) || defined(__WATCOMC__))
#    include <sys/utime.h>
#  else /* !(MSC || __WATCOMC__) ==> may be BORLANDC, or GNU environment */
#    include <utime.h>
#  endif /* ?(MSC || __WATCOMC__) */
#endif

#ifdef __WATCOMC__
#  undef SSTAT
#  define SSTAT stat_bandaid
   int stat_bandaid(const char *path, struct stat *buf);

#  ifdef __386__
#    ifndef WATCOMC_386
#      define WATCOMC_386
#    endif
#    define __32BIT__
#    undef far
#    define far
#    undef near
#    define near

/* Get asm routines to link properly without using "__cdecl": */
#    ifndef USE_ZLIB
#      pragma aux crc32         "_*" parm caller [] value [eax] modify [eax]
#      pragma aux get_crc_table "_*" parm caller [] value [eax] \
                                      modify [eax ecx edx]
#    endif /* !USE_ZLIB */
#  else /* !__386__ */
#    ifndef USE_ZLIB
#      pragma aux crc32         "_*" parm caller [] value [ax dx] \
                                      modify [ax cx dx bx]
#      pragma aux get_crc_table "_*" parm caller [] value [ax] \
                                      modify [ax cx dx bx]
#    endif /* !USE_ZLIB */
#  endif /* ?__386__ */

#  ifndef EPIPE
#    define EPIPE -1
#  endif
#  define PIPE_ERROR (errno == EPIPE)
#endif /* __WATCOMC__ */

#ifdef __EMX__
#  ifndef __32BIT__
#    define __32BIT__
#  endif
#  define far
#endif

#if defined(__GO32__) || defined(__DJGPP__)    /* MS-DOS compiler, not OS/2 */
#  ifndef __32BIT__
#    define __32BIT__
#  endif
#  ifndef __GO32__
#    define __GO32__
#  endif
#  include <sys/timeb.h>           /* for structure ftime */
#  if (defined(__DJGPP__) && (__DJGPP__ > 1))
#    include <unistd.h>            /* for prototypes for read/write etc. */
#    include <dir.h>               /* for FA_LABEL */
#    if ((__DJGPP__ == 2) && (__DJGPP_MINOR__ == 0))
#      include <libc/dosio.h>      /* for _USE_LFN, djgpp 2.0 only */
#    endif
#    define USE_LFN _USE_LFN       /* runtime test:  support long filenames? */
#  else
     int setmode(int, int);        /* not in older djgpp's include files */
#  endif
#endif

#ifndef __32BIT__
#  define __16BIT__
#endif

#if (defined(M_I86CM) || defined(M_I86LM)) || defined(WINDLL)
#  define MED_MEM
#endif
#if (defined(__COMPACT__) || defined(__LARGE__) || defined(__HUGE__))
#  define MED_MEM
#endif
#ifdef __16BIT__
#  ifndef MED_MEM
#    define SMALL_MEM
#  endif
#endif

#define EXE_EXTENSION ".exe"  /* OS/2 has GetLoadPath() function instead */

#ifdef __16BIT__
#  if defined(MSC) || defined(__WATCOMC__)
#    include <malloc.h>
#    define nearmalloc _nmalloc
#    define nearfree _nfree
#  endif
#  if defined(__TURBOC__) && defined(DYNALLOC_CRCTAB)
#    if defined(__COMPACT__) || defined(__LARGE__) || defined(__HUGE__)
#      undef DYNALLOC_CRCTAB
#    endif
#  endif
#  ifndef nearmalloc
#    define nearmalloc malloc
#    define nearfree free
#  endif
#  if defined(USE_ZLIB) && !defined(USE_OWN_CRCTAB)
#    define USE_OWN_CRCTAB
#  endif
#endif


/* another stat()/fopen() bug with some 16-bit compilers on Novell drives;
 * very dangerous (silently overwrites executables in other directories)
 */
#define NOVELL_BUG_WORKAROUND

/* enables additional test and message code that directs UnZip to fail safely
 * in case the "workaround" enabled above does not work as intended
 */
#define NOVELL_BUG_FAILSAFE


/* The optional "long filename" support available with some MSDOS compiler
 * environment running under VFAT systems (Win95) is controlled with the
 * help of the two preprocessor symbols USE_VFAT and USE_LFN:
 *  - USE_VFAT is a compile time switch that selects the long filename
 *             semantics in mapname()
 *  - USE_LFN  is a macro equating to a boolean expression indicating
 *             whether long filenames are supported. If available, this
 *             macro should make use of a runtime function checking the
 *             LFN support.
 *
 * The code in msdos.c distinguishes three cases:
 * 1.) USE_VFAT is not defined:
 *     No support of LFN is included; filenames are mapped to 8+3 plain FAT
 *     syntax unconditionally.
 *     This is achieved by ``#define MAYBE_PLAIN_FAT'' to include the plain
 *     FAT name mapping code and by ``#undef USE_LFN'' to disable bypassing
 *     of the FAT mapping at runtime.
 * 2.) USE_VFAT is defined:
 *     Support for LFN is enabled.
 *  a) USE_LFN is undefined:
 *     There is no (runtime) check available to distinguish between OS
 *     environments that support VFAT extensions and those that do not.
 *     In this case, filenames are mapped to the more liberal VFAT LFN
 *     syntax unconditionally. The internal switch MAYBE_PLAIN_FAT remains
 *     undefined to exclude to "map to plain FAT" code parts.
 *  b) USE_LFN is defined (hopefully to a boolean runtime LFN check function):
 *     "#define MAYBE_PLAIN_FAT" is applied to include the plain FAT mapping
 *     code; the programs checks at runtime whether the OS supports LFN and
 *     uses the appropiate mapping syntax.
 */
/* Some environments, like DJGPP v2, can support long filenames on VFAT
 * systems and DOS 8.3 filenames on FAT systems in the same executable.  If
 * such support is available, USE_LFN should be defined to an expression
 * that will return non-zero when long filenames API should be used, zero
 * otherwise.
 */
#ifndef USE_VFAT
#  ifdef USE_LFN
#    undef USE_LFN
#  endif
#  ifndef MAYBE_PLAIN_FAT
#    define MAYBE_PLAIN_FAT
#  endif
#endif
#ifdef USE_LFN
#  define MAYBE_PLAIN_FAT
#endif

#endif /* !__doscfg_h */
