#ifndef _ZIP_STRUCTS_H
#define _ZIP_STRUCTS_H

#ifndef Far
#  define Far far
#endif

/* Porting definations between Win 3.1x and Win32 */
#ifdef WIN32
#  define far
#  define _far
#  define __far
#  define near
#  define _near
#  define __near
#endif

#ifndef PATH_MAX
# define PATH_MAX 128
#endif

#ifndef DEFINED_ONCE
#define DEFINED_ONCE
typedef int (WINAPI DLLPRNT) (char far *, unsigned long);
typedef int (WINAPI DLLPASSWORD) (char *, int, const char *, const char *);
#endif
typedef char far * (WINAPI DLLCOMMENT)(LPSTR);

/* Structures */

typedef struct {
/* Zip flag section */
BOOL fSuffix;
BOOL fEncrypt;
BOOL fSystem;           /* include system and hidden files */
BOOL fVolume;           /* Include volume label */
BOOL fExtra;            /* Include extra attributes */
BOOL fNoDirEntries;     /* Do not add directory entries */
BOOL fDate;             /* Exclude files earlier than specified date */
BOOL fVerbose;          /* Mention oddities in zip file structure */
BOOL fQuiet;            /* Quiet operation */
char fLevel;            /* Compression level (0 - 9) */
BOOL fCRLF_LF;          /* Translate CR/LF to LF */
BOOL fLF_CRLF;          /* Translate LF to CR/LF */
BOOL fJunkDir;          /* Junk directory names */
BOOL fRecurse;          /* Recurse into subdirectories */
BOOL fGrow;             /* Allow appending to a zip file */
BOOL fForce;            /* Make entries using DOS names (k for Katz) */
BOOL fMove;             /* Delete files added or updated in zip file */
BOOL fDeleteEntries;    /* Delete files from zip file */
BOOL fUpdate;           /* Update zip file--overwrite only if newer */
BOOL fFreshen;          /* Freshen zip file--overwrite only */
BOOL fJunkSFX;          /* Junk SFX prefix */
BOOL fLatestTime;       /* Set zip file time to time of latest file in it */
BOOL fComment;          /* Put comment in zip file */
BOOL fOffsets;          /* Update archive offsets for SFX files */
BOOL fPrivilege;        /* Use privileges (WIN32 only) */
int  fRepair;           /* Repair archive. 1 => -F, 2 => -FF */
/* End Zip Flag section */
char Date[7];           /* Date to include after */
char szRootDir[PATH_MAX];    /* Directory to use as base for zipping */
int  argc;              /* Count of files to zip */
LPSTR lpszZipFN;
char **FNV;
} ZCL, _far *LPZCL;

typedef struct {
DLLPRNT *print;
DLLCOMMENT *comment;
DLLPASSWORD *password;
HWND hWndMain;
} ZIPUSERFUNCTIONS, far * LPZIPUSERFUNCTIONS;

#endif /* _ZIP_STRUCTS_H */
