/*
 Copyright (C) 1996 Mike White
 Permission is granted to any individual or institution to use, copy, or
 redistribute this software so long as all of the original files are included,
 that it is not sold for profit, and that this copyright notice is retained.

*/

/*
 *  windll.c by Mike White loosly based on Mark Adler's zip.c
 */
#include <windows.h>
#include <process.h>
#include <signal.h>
#include <stdarg.h>
#ifdef __BORLANDC__
#include <dir.h>
#endif
#include <direct.h>
#include <ctype.h>
#include "zip.h"
#include "crypt.h"
#include "windll.h"

/*
This structure is passed to the DLL when it is called.

typedef struct {
DLLPRNT print           = pointer to application's print routine
DLLSND sound            = pointer to application's sound routine
DLLPASSWORD             = pointer to application's password routine
DLLCOMMENT              = pointer to application's comment entry routine
HWND hWndMain;          = application's main window
* Zip flag section *
BOOL fSuffix            = include suffixes (not implemented)
BOOL fEncrypt           = encrypt files
BOOL fSystem;           = include system and hidden files
BOOL fVolume;           = Include volume label
BOOL fExtra;            = Exclude extra attributes
BOOL fNoDirEntries;     = Do not add directory entries
BOOL fDate;             = Exclude files earlier than specified date
BOOL fVerbose;          = Mention oddities in zip file structure
BOOL fQuiet;            = Quiet operation
char fLevel;            = Compression level (0 - 9)
BOOL fCRLF_LF           = convert CR/LF to LF
BOOL fLF_CRLF;          = convert LF to CRLF
BOOL fJunkDir;          = don't include directory names
BOOL fRecurse;          = Recurse into subdirectories
BOOL fGrow;             = Allow appending to a zip file
BOOL fForce;            = Make entries using DOS names (k for Katz)
BOOL fMove;             = Delete files added or updated in zip file
BOOL fDeleteEntries;    = Delete files from zip file
BOOL fUpdate;           = Update zip file--overwrite only if newer
BOOL fFreshen;          = Freshen zip file--overwrite only
BOOL fJunkSFX;          = Junk SFX prefix
BOOL fLatestTime;       = Set zip file time to time of latest file in it
BOOL fComment           = Add archive comment
BOOL fOffsets           = Update archive offsets for SFX files
BOOL fPrivilege         = Use privileges (WIN32 only)
int  fRepair            = fix archive. 1 => -F, 2 => -FF
* End Zip Flag section *
char Date[7];           = Date to include files after
char szRootDir[256];    = Base reference directory for zipping
int  argc;              = Count of files to zip
LPSTR lpszZipFN         = zip file name to be used
char **FNV              = basically argv for zipmain
} ZCL, _far *LPZCL;
*/

#ifndef PATH_MAX
#define PATH_MAX 256
#endif

DLLPRNT *lpPrint;
DLLPASSWORD *lpPassword;
DLLCOMMENT *lpComment;

int ZipRet;

/*  DLL Entry Point */
#ifdef __BORLANDC__
#pragma warn -par
#endif
#if defined WIN32
BOOL WINAPI DllEntryPoint( HINSTANCE hInstance,
                           DWORD fdwRreason,
                           LPVOID plvReserved)
#else
int WINAPI LibMain( HINSTANCE hInstance,
                        WORD wDataSegment,
                        WORD wHeapSize,
                        LPSTR lpszCmdLine )
#endif
{
#ifndef WIN32
/* The startup code for the DLL initializes the local heap(if there is one)
 with a call to LocalInit which locks the data segment. */

if ( wHeapSize != 0 )
   {
   UnlockData( 0 );
   }
#endif
hInst = hInstance;
return 1;   /* Indicate that the DLL was initialized successfully. */
}

int FAR PASCAL WEP ( int bSystemExit )
{
return 1;
}
#ifdef __BORLANDC__
#pragma warn .par
#endif


/* Local functions */

extern int  zipmain OF((int, char **));
int AllocMemory(int, char *, char *);

HWND hWndMain;
HANDLE hInst;
char **argVee;
int argCee;

int AllocMemory(int i, char *cmd, char *str)
{
int j;
if ((argVee[i] = (char *) malloc( sizeof(char) * strlen(cmd)+1 )) == NULL)
   {
   for (j = 0; j < i; j++)
       {
       free (argVee[j]);
       argVee[j] = NULL;
       }
   free(argVee);
   fprintf(stdout, "Unable to allocate memory in zip dll at %s\n", str);
   return ZE_MEM;
   }
strcpy( argVee[i], cmd );
return ZE_OK;
}

int WINAPI ZpInit(ZIPUSERFUNCTIONS far * lpZipUserFunc)
{
lpPassword = lpZipUserFunc->password;
lpPrint = lpZipUserFunc->print;
lpComment = lpZipUserFunc->comment;
hWndMain = lpZipUserFunc->hWndMain;

if (!lpPrint ||
    !lpComment)
    return FALSE;

return TRUE;
}

BOOL WINAPI ZpEncryption(void)
{
#ifdef CRYPT
return TRUE;
#else
return FALSE;
#endif
}

int WINAPI DllZipUpFiles(ZCL far *C)
/* Add, update, freshen, or delete zip entries in a zip file.  See the
   command help in help() zip.c */
{
int i, k, j, m;
char szOrigDir[PATH_MAX];

argCee = 0;
/* malloc additional 26 to allow for additional command line arguments */
if ((argVee = (char **)malloc((C->argc+26)*sizeof(char *))) == NULL)
   {
   fprintf(stdout, "Unable to allocate memory in zip dll\n");
   return ZE_MEM;
   }
if ((argVee[argCee] = (char *) malloc( sizeof(char) * strlen("wiz.exe")+1 )) == NULL)
   {
   free(argVee);
   fprintf(stdout, "Unable to allocate memory in zip dll\n");
   return ZE_MEM;
   }
strcpy( argVee[argCee], "wiz.exe" );
argCee++;

/* Set compression level efficacy -0...-9 */
if (AllocMemory(argCee, "-0", "Compression") != ZE_OK)
   return ZE_MEM;
argVee[argCee][1] = C->fLevel;
argCee++;

if (C->fOffsets)    /* Update offsets for SFX prefix */
   {
   if (AllocMemory(argCee, "-A", "Offsets") != ZE_OK)
      return ZE_MEM;
   argCee++;
   }
if (C->fDeleteEntries)    /* Delete files from zip file -d */
   {
   if (AllocMemory(argCee, "-d", "Delete") != ZE_OK)
      return ZE_MEM;
   argCee++;
   }
if (C->fNoDirEntries) /* Do not add directory entries -D */
   {
   if (AllocMemory(argCee, "-D", "No Dir Entries") != ZE_OK)
      return ZE_MEM;
   argCee++;
   }
if (C->fFreshen) /* Freshen zip file--overwrite only -f */
   {
   if (AllocMemory(argCee, "-f", "Freshen") != ZE_OK)
      return ZE_MEM;
   argCee++;
   }
if (C->fRepair)  /* Fix archive -F or -FF */
   {
   if (C->fRepair == 1)
      {
      if (AllocMemory(argCee, "-F", "Repair") != ZE_OK)
         return ZE_MEM;
      }
   else
      {
      if (AllocMemory(argCee, "-FF", "Repair") != ZE_OK)
         return ZE_MEM;
      }
   argCee++;
   }
if (C->fGrow) /* Allow appending to a zip file -g */
   {
   if (AllocMemory(argCee, "-g", "Appending") != ZE_OK)
      return ZE_MEM;
   argCee++;
   }
if (C->fJunkDir) /* Junk directory names -j */
   {
   if (AllocMemory(argCee, "-j", "Junk Dir Names") != ZE_OK)
      return ZE_MEM;
   argCee++;
   }
if (C->fEncrypt) /* encrypt -e */
   {
   if (AllocMemory(argCee, "-e", "Encrypt") != ZE_OK)
      return ZE_MEM;
   argCee++;
   }
if (C->fJunkSFX) /* Junk sfx prefix */
   {
   if (AllocMemory(argCee, "-J", "Junk SFX") != ZE_OK)
      return ZE_MEM;
   argCee++;
   }

if (C->fForce) /* Make entries using DOS names (k for Katz) -k */
   {
   if (AllocMemory(argCee, "-k", "Force DOS") != ZE_OK)
      return ZE_MEM;
   argCee++;
   }

if (C->fLF_CRLF) /* Translate LF_CRLF -l */
   {
   if (AllocMemory(argCee, "-l", "LF-CRLF") != ZE_OK)
      return ZE_MEM;
   argCee++;
   }
if (C->fCRLF_LF) /* Translate CR/LF to LF -ll */
   {
   if (AllocMemory(argCee, "-ll", "CRLF-LF") != ZE_OK)
      return ZE_MEM;
   argCee++;
   }
if (C->fMove) /* Delete files added or updated in zip file -m */
   {
   if (AllocMemory(argCee, "-m", "Move") != ZE_OK)
      return ZE_MEM;
   argCee++;
   }

if (C->fLatestTime) /* Set zip file time to time of latest file in it -o */
   {
   if (AllocMemory(argCee, "-o", "Time") != ZE_OK)
      return ZE_MEM;
   argCee++;
   }

if (C->fComment) /* Add archive comment "-z" */
   {
   if (AllocMemory(argCee, "-z", "Comment") != ZE_OK)
      return ZE_MEM;
   argCee++;
   }

if (C->fQuiet) /* quiet operation -q */
   {
   if (AllocMemory(argCee, "-q", "Quiet") != ZE_OK)
      return ZE_MEM;
   argCee++;
   }
if (C->fRecurse) /* recurse into subdirectories -R */
   {
   if (AllocMemory(argCee, "-R", "Recurse") != ZE_OK)
      return ZE_MEM;
   argCee++;
   }
if (C->fSystem)  /* include system and hidden files -S */
   {
   if (AllocMemory(argCee, "-S", "System") != ZE_OK)
      return ZE_MEM;
   argCee++;
   }
if (C->fDate)    /* Exclude files earlier than specified date -t */
   {
   if (C->Date[0] != '\0')
      {
      if (AllocMemory(argCee, "-t", "Date") != ZE_OK)
         return ZE_MEM;
      argCee++;
      if (AllocMemory(argCee, C->Date, "Date") != ZE_OK)
         return ZE_MEM;
      argCee++;
      }
   }

if (C->fUpdate) /* Update zip file--overwrite only if newer -u */
   {
   if (AllocMemory(argCee, "-u", "Update") != ZE_OK)
      return ZE_MEM;
   argCee++;
   }
if (C->fVerbose)  /* Mention oddities in zip file structure -v */
   {
   if (AllocMemory(argCee, "-v", "Verbose") != ZE_OK)
      return ZE_MEM;
   argCee++;
   }
if (C->fVolume)  /* Include volume label -$ */
   {
   if (AllocMemory(argCee, "-$", "Volume") != ZE_OK)
      return ZE_MEM;
   argCee++;
   }
#ifdef WIN32
if (C->fPrivilege)  /* Use privileges -! */
   {
   if (AllocMemory(argCee, "-!", "Privileges") != ZE_OK)
      return ZE_MEM;
   argCee++;
   }
#endif
if (C->fExtra)  /* Exclude extra attributes -X */
   {
   if (AllocMemory(argCee, "-X", "Extra") != ZE_OK)
      return ZE_MEM;
   argCee++;
   }

if (AllocMemory(argCee, C->lpszZipFN, "Zip file name") != ZE_OK)
   return ZE_MEM;
argCee++;

getcwd(szOrigDir, PATH_MAX); /* Save current drive and directory */

if (C->szRootDir[0] != '\0')
   {
   chdir(C->szRootDir);
#ifdef __BORLANDC__
   setdisk(toupper(C->szRootDir[0]) - 'A');
#endif
   lstrcat(C->szRootDir, "\\"); /* append trailing \\ */
 	if (C->FNV != NULL)
      {
      for (k = 0; k < C->argc; k++)
         {
         if (AllocMemory(argCee, C->FNV[k], "Making argv") != ZE_OK)
            return ZE_MEM;
         if ((strncmp(C->szRootDir, C->FNV[k], lstrlen(C->szRootDir))) == 0)
            {
            m = 0;
            for (j = lstrlen(C->szRootDir); j < lstrlen(C->FNV[k]); j++)
               argVee[argCee][m++] = C->FNV[k][j];
            argVee[argCee][m] = '\0';
            }
         argCee++;
         }
      }
   }
else
	if (C->FNV != NULL)
	   for (k = 0; k < C->argc; k++)
   	   {
         if (AllocMemory(argCee, C->FNV[k], "Making argv") != ZE_OK)
            return ZE_MEM;
         argCee++;
	      }

argVee[argCee] = NULL;

ZipRet = zipmain(argCee, argVee);

chdir(szOrigDir);
#ifdef __BORLANDC__
setdisk(toupper(szOrigDir[0]) - 'A');
#endif

/* Free the arguments in the array */
for (i = 0; i < argCee; i++)
   {
      free (argVee[i]);
      argVee[i] = NULL;
   }
/* Then free the array itself */
free(argVee);

return ZipRet;
}

#define STDIO_BUF_SIZE 16384

int __far __cdecl printf(const char *format, ...)
{
va_list argptr;
HANDLE hMemory;
LPSTR pszBuffer;
int len;

va_start(argptr, format);
hMemory = GlobalAlloc(GMEM_MOVEABLE, STDIO_BUF_SIZE);
WinAssert(hMemory);
if (!hMemory)
   {
   return 0;
   }
pszBuffer = (LPSTR)GlobalLock(hMemory);
WinAssert(pszBuffer);
len = wvsprintf(pszBuffer, format, argptr);
va_end(argptr);
WinAssert(strlen(pszBuffer) < STDIO_BUF_SIZE);
len = lpPrint(pszBuffer, len);
GlobalUnlock(hMemory);
GlobalFree(hMemory);
return len;
}

/* fprintf clone for code in zip.c, etc. */
int __far __cdecl fprintf(FILE *file, const char *format, ...)
{
va_list argptr;
HANDLE hMemory;
LPSTR pszBuffer;
int len;

va_start(argptr, format);
hMemory = GlobalAlloc(GMEM_MOVEABLE, STDIO_BUF_SIZE);
WinAssert(hMemory);
if (!hMemory)
   {
   return 0;
   }
pszBuffer = GlobalLock(hMemory);
WinAssert(pszBuffer);
len = wvsprintf(pszBuffer, format, argptr);
va_end(argptr);
WinAssert(strlen(pszBuffer) < STDIO_BUF_SIZE);
if ((file == stderr) || (file == stdout))
	{
	len = lpPrint(pszBuffer, len);
   }
else
   len = write(fileno(file),(char far *)(pszBuffer), len);
GlobalUnlock(hMemory);
GlobalFree(hMemory);
return len;
}

void __far __cdecl perror(const char *parm1)
{
printf(parm1);
}

#ifdef CRYPT
int encr_passwd(int modeflag, char *pwbuf, int size, const char *zfn)
{
return (*lpPassword)(pwbuf, size, ((modeflag == ZP_PW_VERIFY) ?
                  "Verify password: " : "Enter password: "),
                  (char *)zfn);
}
#endif /* CRYPT */

LPSTR szCommentBuf;
HANDLE hStr;

void comment(unsigned int comlen)
{
unsigned int i;
if (comlen > 65534L)
   comlen = (unsigned int) 65534L;
hStr = GlobalAlloc( GPTR, (DWORD)65535L);
if ( !hStr )
   {
   hStr = GlobalAlloc( GPTR, (DWORD) 2);
   szCommentBuf = GlobalLock(hStr);
   szCommentBuf[0] = '\0';
   return;
   }

szCommentBuf = GlobalLock(hStr);
if (comlen)
   {
   for (i = 0; i < comlen; i++)
       szCommentBuf[i] = zcomment[i];
   szCommentBuf[comlen] = '\0';
   }
else
   szCommentBuf[0] = '\0';
free(zcomment);
zcomment = malloc(1);
*zcomment = 0;
szCommentBuf = lpComment(szCommentBuf);
return;
}

